﻿using System;
using System.Collections.Generic;
using System.Text.Json.Serialization;

namespace Forge.OpenAI.Models.ChatCompletions
{

    /// <summary>A chat completion delta generated by streamed model responses.</summary>
    public class Delta
    {

        /// <summary>
        /// Chat message content
        /// </summary>
        [JsonPropertyName("content")]
        public string Content { get; set; }

        /// <summary>The role of the author of this message.</summary>
        /// <value>The role.</value>
        [JsonPropertyName("role")]
        public string Role { get; set; }

        /// <summary>The name and arguments of a function that should be called, as generated by the model.</summary>
        /// <value>
        ///   <para>
        /// The function call.
        /// </para>
        ///   <para>
        ///     <a href="https://platform.openai.com/docs/api-reference/chat/streaming">https://platform.openai.com/docs/api-reference/chat/streaming</a>
        ///   </para>
        /// </value>
        [Obsolete("Deprecated and replaced by tool_calls")]
        [JsonPropertyName("function_call")]
        public ChatFunctionCall FunctionCall { get; set; }

        [JsonPropertyName("tool_calls")]
        public IReadOnlyList<ChatToolCall> ToolCalls { get; set; }

    }

}
