﻿using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Forge.OpenAI.Models.ChatCompletions
{

    public class ChatFunctionCall
    {

        /// <summary>The name of the function to call.</summary>
        /// <value>The name.</value>
        [JsonPropertyName("name")]
        public string Name { get; set; }

        /// <summary>The contents of the function message.</summary>
        /// <value>The content.</value>
        [JsonPropertyName("content")]
        public string Content { get; set; }

        /// <summary>
        /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
        /// </summary>
        /// <value>The arguments.</value>
        [JsonPropertyName("arguments")]
        public string Arguments { get; set; }

        public Dictionary<string, object> ParseArguments()
        {
            return string.IsNullOrWhiteSpace(Arguments) 
                ? 
                new Dictionary<string, object>() 
                : 
                JsonSerializer.Deserialize<Dictionary<string, object>>(Arguments);
        }

    }

}
