# React Design Patterns

[![license MIT][1]][2] [![code stile: standard][3]][4] [![build status][9]][10]
[![codacy code quality][5]][6] [![codefactor code quality][7]][8]

This repository is dedicated to the study of JavaScript and front-end
development, through the analysis and implementation of React design
patterns.

From Wikipedia:

> In software engineering, a software design pattern is a general, reusable
> solution to a commonly occurring problem within a given context in software
> design. It is not a finished design that can be transformed directly into
> source or machine code. Rather, it is a description or template for how to
> solve a problem that can be used in many different situations. Design
> patterns are formalized best practices that the programmer can use to solve
> common problems when designing an application or system.

## Contributing

[![contributors][25]][26] [![commit activity][27]][28] [![issues][29]][30]
[![issues closed][31]][32] [![issues pr][33]][34] [![issues pr closed][35]][36]

Code reviews and pull requests are always welcome!

## Resources

- [Software Design Pattern at Wikipedia][111]

## Getting Started with Create React App

This project was bootstrapped with [Create React App][101].

### Available Scripts

In the project directory, you can run:

#### `npm start`

Runs the app in the development mode.\
Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

#### `npm test`

Launches the test runner in the interactive watch mode.\
See the section about [running tests][102] for more information.

#### `npm run build`

Builds the app for production to the `build` folder.\
It correctly bundles React in production mode and optimizes the build for the
best performance.

The build is minified and the filenames include the hashes.\
Your app is ready to be deployed!

See the section about [deployment][103] for more information.

#### `npm run eject`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

If you aren't satisfied with the build tool and configuration choices, you can
`eject` at any time. This command will remove the single build dependency from
your project.

Instead, it will copy all the configuration files and the transitive
dependencies (webpack, Babel, ESLint, etc) right into your project so you have
full control over them. All of the commands except `eject` will still work,
but they will point to the copied scripts so you can tweak them. At this point
you're on your own.

You don't have to ever use `eject`. The curated feature set is suitable for
small and middle deployments, and you shouldn't feel obligated to use this
feature. However we understand that this tool wouldn't be useful if you
couldn't customize it when you are ready for it.

### Learn More

You can learn more in the [Create React App documentation][104].

To learn React, check out the [React documentation](https://reactjs.org/).

#### Code Splitting

This section has moved here: [code-splitting][105]

#### Analyzing the Bundle Size

This section has moved here: [analyzing-the-bundle-size][106]

#### Making a Progressive Web App

This section has moved here: [making-a-progressive-web-app][107]

#### Advanced Configuration

This section has moved here: [advanced-configuration][108]

#### Deployment

This section has moved here: [deployment][109]

#### `npm run build` fails to minify

This section has moved here: [npm-run-build-fails-to-minify][110]

---

[![total lines][51]][52] [![code size][53]][54] [![repo size][55]][56]

[1]: https://img.shields.io/github/license/jcpedroza/design-patterns-react
[2]: https://en.wikipedia.org/wiki/MIT_License
[3]: https://img.shields.io/badge/code_style-standard-brightgreen.svg
[4]: https://standardjs.com
[5]: https://app.codacy.com/project/badge/Grade/80e2495e7d7741fa9d2e6881698b930a
[6]: https://www.codacy.com/gh/JCPedroza/design-patterns-react/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=JCPedroza/design-patterns-react&amp;utm_campaign=Badge_Grade
[7]: https://www.codefactor.io/repository/github/jcpedroza/design-patterns-react/badge
[8]: https://www.codefactor.io/repository/github/jcpedroza/design-patterns-react
[9]: https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fjcpedroza%2Fdesign-patterns-react%2Fbadge%3Fref%3Dmain&style=flat
[10]: https://actions-badge.atrox.dev/jcpedroza/design-patterns-react/goto?ref=main

[25]: https://img.shields.io/github/contributors/JCPedroza/design-patterns-react
[26]: https://img.shields.io/github/contributors/JCPedroza/design-patterns-react
[27]: https://img.shields.io/github/commit-activity/m/JCPedroza/design-patterns-react
[28]: https://img.shields.io/github/commit-activity/m/JCPedroza/design-patterns-react
[29]: https://img.shields.io/github/issues-raw/JCPedroza/design-patterns-react
[30]: https://img.shields.io/github/issues-raw/JCPedroza/design-patterns-react
[31]: https://img.shields.io/github/issues-closed-raw/JCPedroza/design-patterns-react
[32]: https://img.shields.io/github/issues-closed-raw/JCPedroza/design-patterns-react
[33]: https://img.shields.io/github/issues-pr-raw/JCPedroza/design-patterns-react
[34]: https://img.shields.io/github/issues-pr-raw/JCPedroza/design-patterns-react
[35]: https://img.shields.io/github/issues-pr-closed-raw/JCPedroza/design-patterns-react
[36]: https://img.shields.io/github/issues-pr-closed-raw/JCPedroza/design-patterns-react

[51]: https://img.shields.io/tokei/lines/github/jcpedroza/design-patterns-react
[52]: https://img.shields.io/tokei/lines/github/jcpedroza/design-patterns-react
[53]: https://img.shields.io/github/languages/code-size/jcpedroza/design-patterns-react
[54]: https://img.shields.io/github/languages/code-size/jcpedroza/design-patterns-react
[55]: https://img.shields.io/github/repo-size/jcpedroza/design-patterns-react
[56]: https://img.shields.io/github/repo-size/jcpedroza/design-patterns-react

[101]: https://github.com/facebook/create-react-app
[102]: https://facebook.github.io/create-react-app/docs/running-tests
[103]: https://facebook.github.io/create-react-app/docs/deployment
[104]: https://facebook.github.io/create-react-app/docs/getting-started
[105]: https://facebook.github.io/create-react-app/docs/code-splitting
[106]: https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size
[107]: https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app
[108]: https://facebook.github.io/create-react-app/docs/advanced-configuration
[109]: https://facebook.github.io/create-react-app/docs/deployment
[110]: https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify
[111]: https://en.wikipedia.org/wiki/Software_design_pattern
