# TypeScript Algorithms and Data Structures

[![linux][0]][1]
[![windows][2]][3]
[![macintosh][14]][15]
[![linting][4]][5]

[![typescript][16]][17]
[![node][18]][19]
[![npm][20]][21]
[![ts-jest][10]][11]

[![license MIT][6]][7]
[![ts-standard][8]][9]


Algorithms and data structures implemented in TypeScript. Here you'll find:

- Implementations of algorithms and data structures
- Solutions for problems, prompts, challenges, and popular interview questions

## Installation

First clone or download the repository. Then use `npm install` to install all the
dependencies.

```bash
git clone https://github.com/JCPedroza/algorithms-and-data-structures-ts.git
cd algorithms-and-data-structures-ts
npm install
```

## Usage

### Unit Testing

```bash
npm test              # Run unit tests that have changes
npm run test-unit     # Run all unit tests
npm run test-coverage # Run all unit tests and generate coverage report
```

### Other Scripts

```bash
npm run fix-style     # Run linter and format style errors
npm run build         # Transpile to JavaScript
npm run               # Show all available scripts
```

## Contributing

[![contributors][50]][51] [![commit activity][52]][53] [![issues][54]][55]
[![issues closed][56]][57] [![issues pr][58]][59] [![issues pr closed][60]][61]

Bug reports, pull requests, and code reviews are always welcome at the [GitHub repository][32].

This project is intended to be a safe, welcoming space for collaboration. Everyone
interacting in this project's codebases, issue trackers, chat rooms and mailing lists
is expected to follow the [code of conduct][30].

You can see the full contribution guidelines, workflows, and examples in the
`CONTRIBUTING.md` document of this repository, or [here online][31].

## License

This repository is available as open source under the terms of the
[MIT License][7], that you can see in the LICENSE.md document of
this repository.

## Similar Resources

- [SML][103]
- [Python][101]
- [Racket][104]
- [Other languages][100]

---

[![repo size][94]][95]

[0]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/linux.yml/badge.svg
[1]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/linux.yml
[2]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/windows.yml/badge.svg
[3]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/windows.yml
[4]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/lint.yml/badge.svg
[5]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/lint.yml
[6]: https://badgen.net/github/license/JCPedroza/algorithms-and-data-structures-ts
[7]: https://opensource.org/licenses/MIT
[8]: https://badgen.net/badge/style/ts-standard/blue?icon=typescript
[9]: https://github.com/standard/ts-standard
[10]: https://img.shields.io/badge/-jest-%23C21325?style=for-the-badge&logo=jest&logoColor=white
[10]: https://img.shields.io/badge/test-ts--jest-blue
[11]: https://github.com/kulshekhar/ts-jest
[12]: https://img.shields.io/badge/dependabot-025E8C?style=for-the-badge&logo=dependabot&logoColor=white
[13]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/blob/main/.github/dependabot.yml
[14]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/macintosh.yml/badge.svg
[15]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/actions/workflows/macintosh.yml
[16]: https://img.shields.io/badge/typescript-%23007ACC.svg?style=for-the-badge&logo=typescript&logoColor=white
[17]: https://github.com/microsoft/TypeScript
[18]: https://img.shields.io/badge/node.js-6DA55F?style=for-the-badge&logo=node.js&logoColor=white
[19]: https://github.com/nodejs/node
[20]: https://img.shields.io/badge/NPM-%23000000.svg?style=for-the-badge&logo=npm&logoColor=white
[21]: https://github.com/npm/cli

[30]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/blob/main/CODE_OF_CONDUCT.md
[31]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/blob/main/CONTRIBUTING.md
[32]: https://github.com/JCPedroza/algorithms-and-data-structures-ts

[50]: https://img.shields.io/github/contributors/JCPedroza/algorithms-and-data-structures-ts
[51]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/graphs/contributors
[52]: https://img.shields.io/github/commit-activity/m/JCPedroza/algorithms-and-data-structures-ts
[53]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/graphs/commit-activity
[54]: https://img.shields.io/github/issues-raw/JCPedroza/algorithms-and-data-structures-ts
[55]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/issues
[56]: https://img.shields.io/github/issues-closed-raw/JCPedroza/algorithms-and-data-structures-ts
[57]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/issues
[58]: https://img.shields.io/github/issues-pr-raw/JCPedroza/algorithms-and-data-structures-ts
[59]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/pulls
[60]: https://img.shields.io/github/issues-pr-closed-raw/JCPedroza/algorithms-and-data-structures-ts
[61]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/pulls

[94]: https://img.shields.io/github/repo-size/jcpedroza/algorithms-and-data-structures-ts
[95]: https://img.shields.io/github/repo-size/jcpedroza/algorithms-and-data-structures-ts

[100]: https://github.com/JCPedroza/algorithms-and-data-structures
[101]: https://github.com/JCPedroza/algorithms-and-data-structures-py
[103]: https://github.com/JCPedroza/algorithms-and-data-structures-sml
[104]: https://github.com/JCPedroza/algorithms-and-data-structures-rkt
