# Contributing

[![contributors][50]][51] [![commit activity][52]][53] [![issues][54]][55]
[![issues closed][56]][57] [![issues pr][58]][59] [![issues pr closed][60]][61]

## Documentation

### Readme

Implementations must include a README.md file with explanations, examples, and
resources.

#### Examples

Include at least one example in one or multiple of these forms:
  - Natural language
  - Expression that evaluates to true
  - Jest expect notation

Use whatever is more concise and easily understood.

Two to ten examples should be ok, depending on the case. Examples should complement
the explanations. Use the examples to illustrate edge cases, and basic expected inputs
and outputs.

##### Natural Language

```
double(-1) is 1
double(0) is 0
double(1) is 1
double(2) is 4
```

##### TypeScript Expressions that Evaluate to True

```typescript
double(-1) === 1
double(0) === 0
double(1) === 1
double(2) === 4
```

##### Jest Expect Notation

```typescript
expect(fun(-1)).tobe(1)
expect(fun(0)).tobe(0)
expect(fun(1)).tobe(1)
expect(fun(2)).tobe(2)
```

[50]: https://img.shields.io/github/contributors/JCPedroza/algorithms-and-data-structures-ts
[51]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/graphs/contributors
[52]: https://img.shields.io/github/commit-activity/m/JCPedroza/algorithms-and-data-structures-ts
[53]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/graphs/commit-activity
[54]: https://img.shields.io/github/issues-raw/JCPedroza/algorithms-and-data-structures-ts
[55]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/issues
[56]: https://img.shields.io/github/issues-closed-raw/JCPedroza/algorithms-and-data-structures-ts
[57]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/issues
[58]: https://img.shields.io/github/issues-pr-raw/JCPedroza/algorithms-and-data-structures-ts
[59]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/pulls
[60]: https://img.shields.io/github/issues-pr-closed-raw/JCPedroza/algorithms-and-data-structures-ts
[61]: https://github.com/JCPedroza/algorithms-and-data-structures-ts/pulls
