def heapify(arr, n, i):
    largest = i
    left_child = 2 * i + 1
    right_child = 2 * i + 2

    if left_child < n and arr[i] < arr[left_child]:
        largest = left_child

    if right_child < n and arr[largest] < arr[right_child]:
        largest = right_child

    if largest != i:
        arr[i], arr[largest] = arr[largest], arr[i]
        heapify(arr, n, largest)

def heap_sort(arr):
    n = len(arr)

    # Build a max heap
    for i in range(n // 2 - 1, -1, -1):
        heapify(arr, n, i)

    # Extract elements one by one
    for i in range(n - 1, 0, -1):
        arr[0], arr[i] = arr[i], arr[0]  # Swap
        heapify(arr, i, 0)

if __name__ == "__main__":
    try:
        input_string = input("Enter space-separated integers to sort: ")
        unsorted_list = [int(x) for x in input_string.split()]

        heap_sort(unsorted_list)

        print("Sorted array:")
        for num in unsorted_list:
            print(num, end=" ")

    except ValueError:
        print("Please enter valid integers separated by spaces.")
