# Lakehurst Gothic

![Specimen of Lakehurst Gothic](documentation/LakehurstGothicSMImage.png)

**This typeface is a work-in-progress and is provided here as-is, with no expectations or promises of completeness or quality.**

_Lakehurst Gothic_ is a typeface based on the lettering used by the United States Navy's LTA (lighter-than-air) program. The names emblazoned along the sides of the envelopes of the great Navy airships ([U.S.S. Shenandoah](https://en.wikipedia.org/wiki/USS_Shenandoah_(ZR-1)), [U.S.S. Los Angeles](https://en.wikipedia.org/wiki/USS_Los_Angeles_(ZR-3)), [U.S.S. Akron](https://en.wikipedia.org/wiki/USS_Akron_(ZRS-4)), [U.S.S. Macon](https://en.wikipedia.org/wiki/USS_Macon_(ZRS-5))) bear a resemblance to _Bank Gothic_ (a contemporary) and _Microgramma_, but with several key differences that give them a character all their own.

As there are few orthographic depictions of the face, and because it was likely hand-painted on the vessels' hulls, the design has been copied primarily by eye, with characters missing from available samples created from scratch, using the contemporaneous _Bank Gothic_ as inspiration. A measure of artistic license has also been employed to make the face appear more consistent and aesthetically pleasing when not used solely for typesetting the names of Navy airships.

_Lakehurst Gothic_ is named after the former [Naval Air Station Lakehurst](https://en.wikipedia.org/wiki/Lakehurst_Maxfield_Field), in Lakehurst, New Jersey — the location from which much of the U.S. Navy's airship program was operated, the location where the U.S.S. Shenandoah was constructed, and also the site of the 1937 _Hindenburg_ disaster.

![Specimen of Lakehurst Gothic](documentation/LakehurstGothic_specimen.png)

## Improvements

- I'm hoping to include additional characters, such as those with diacritical marks, in future updates.
- I may adjust or improve characters if research reveals new samples.

## Tools

- [Glyphs.app](https://glyphsapp.com/)

- [Adobe Illustrator](http://adobe.com/products/illustrator/) (mostly for measuring source samples and creating a specimen image)

## License

[SIL Open Font License](https://scripts.sil.org/OFL). See `LICENSE.md` for details.
