package com.yunze.iotapi.controller.openApi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.api.R;
import com.yunze.apiCommon.mapper.mysql.YzCardRouteMapper;
import com.yunze.apiCommon.upstreamAPI.PublicApiService;
import com.yunze.apiCommon.utils.*;
import com.yunze.common.mapper.mysql.*;
import com.yunze.common.mapper.mysql.card.YzApplicationforRenewalMapper;
import com.yunze.common.mapper.mysql.card.YzApplicationforRenewalPrimaryMapper;
import com.yunze.common.mapper.mysql.polling.YzSynCardInfoMapper;
import com.yunze.common.utils.SecurityUtils;
import com.yunze.iotapi.service.impl.OpenApiServiceImpl;
import com.yunze.iotapi.utils.*;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.dnd.DropTarget;
import java.util.*;

/**
 * 物联网卡 通道管理
 */
@Controller
@RequestMapping("/open")
public class PublicOpenAapiController {

    @Resource
    private PublicApiService publicApiService;
    @Resource
    private YzCardRouteMapper yzCardRouteMapper;
    @Resource
    private ApiUtil_NoStatic apiUtil_NoStatic;

    @Resource
    private OpenApiServiceImpl openApiServiceImpl;
    @Resource
    private YzUserMapper yzUserMapper;
    @Resource
    private YzCardMapper yzCardMapper;
    @Resource
    private YzCardPacketMapper yzCardPacketMapper;
    @Resource
    private YzApplicationforRenewalPrimaryMapper renewalPrimaryMapper;
    @Resource
    private YzAgentPackageMapper agentPackageMapper;

    /**
     * 卡信息查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardInfo")
    @ResponseBody
    @LogAnnotation(action = "卡信息查询")
    public JSONObject cardInfo(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> data = publicApiService.cardInfo(Param);
            return new ResponseJson().successOpen(data);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }
    @RequestMapping(value = "/queryCardImei")
    @ResponseBody
    @LogAnnotation(action = "卡信息查询")
    public JSONObject queryCardImei(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> data = publicApiService.queryCardImei(Param);
            return new ResponseJson().successOpen(data);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }
    /**
     * 单卡或批量查询日用量
     */
    @RequestMapping(value = "/queryDateUsage")
    @ResponseBody
    public JSONObject queryDateUsage(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> data = publicApiService.queryDateUsage(Param);
            Map<String, Object> map1 = apiUtil_NoStatic.queryDateUsage(data);
            return new ResponseJson().successOpen(map1);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    @RequestMapping(value = "/RenewalPacket")
    @ResponseBody
    @LogAnnotation(action = "卡信息查询")
    public JSONObject RenewalPacket(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            System.out.println(Param);
            return new ResponseJson().successOpen("****");
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 卡套餐详情
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardPacketInfo")
    @ResponseBody
    @LogAnnotation(action = "卡套餐详情")
    public JSONObject cardPacketInfo(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Object all = Param.get("all") != null ? Param.get("all") : "0";
            Param.put("all", all);
            Map<String, Object> data = publicApiService.cardPackageInfo(Param);
            return new ResponseJson().successOpen(data);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 流量查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simDataUsage")
    @ResponseBody
    @LogAnnotation(action = "流量查询")
    public JSONObject simDataUsage(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> Rdata = openApiServiceImpl.simDataUsage(Param);
            boolean bool = (boolean) Rdata.get("bool");
            String code = Rdata.get("code").toString();
            if (bool) {
                return new ResponseJson().successOpen(Rdata.get("Data"));
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 历史流量查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simDataUsageMonthly")
    @ResponseBody
    @LogAnnotation(action = "历史流量查询")
    public JSONObject simDataUsageMonthly(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> Rdata = apiUtil_NoStatic.queryFlowHis(Param);
            String code = Rdata.get("code").toString();
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (code.equals("200")) {
                returnMap.put("useAmount", Rdata.get("Use"));
                returnMap.put("useUnit", "MB");
                return new ResponseJson().successOpen(returnMap);
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 单卡生命周期
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simStatus")
    @ResponseBody
    @LogAnnotation(action = "单卡生命周期查询")
    public JSONObject simStatus(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");

            Map<String, Object> Rdata = openApiServiceImpl.simStatus(Param);
            boolean bool = (boolean) Rdata.get("bool");
            String code = Rdata.get("code").toString();
            if (bool) {
                return new ResponseJson().successOpen(Rdata.get("Data"));
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 修改生命周期(停复机)
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/changeSimStatus")
    @ResponseBody
    @LogAnnotation(action = "单卡停复机")
    public JSONObject changeSimStatus(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Object Status = Param.get("Status");
            if (Status != null && !Status.equals("") && Status.toString().length() > 0) {
                String Str_Status = Status.toString();
                if (Str_Status.equals("1") || Str_Status.equals("0")) {
                    String Is_Stop = Str_Status.equals("1") ? "off" : Str_Status.equals("0") ? "on" : null;
                    if (Is_Stop != null) {
                        Param.put("Is_Stop", Is_Stop);
                        Param.remove("Status");
                        Map<String, Object> Rdata = openApiServiceImpl.changeSimStatus(Param, Is_Stop);
                        boolean bool = (boolean) Rdata.get("bool");
                        String code = Rdata.get("code").toString();
                        if (bool) {
                            return new ResponseJson().successOpen(Rdata.get("Data"));
                        } else {
                            return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
                        }
                    } else {
                        return new ResponseJson().errorOpen("400", "参数错误！请按文档说明传入 Status !！");
                    }
                } else {
                    return new ResponseJson().errorOpen("400", "参数错误！请按文档说明传入 Status ！");
                }
            } else {
                return new ResponseJson().errorOpen("400", "缺少参数！请按文档说明传入 ！");
            }


        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 查询是否实名
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simRealNameQuery")
    @ResponseBody
    @LogAnnotation(action = "查询是否实名")
    public JSONObject simRealNameQuery(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        //System.out.println(map);
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");

            Map<String, Object> Rdata = apiUtil_NoStatic.queryRealNameStatus(Param);
            String code = Rdata.get("code").toString();
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (code.equals("200")) {
                returnMap.put("statusCode", Rdata.get("Is_status"));
                returnMap.put("statusMessage", Rdata.get("Is_statusName"));
                return new ResponseJson().successOpen(returnMap);
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 单独断网
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simApnFunction")
    @ResponseBody
    @LogAnnotation(action = "单卡单独断网")
    public JSONObject simApnFunction(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Object StatusBreak = Param.get("StatusBreak");
            if (StatusBreak != null && !StatusBreak.equals("") && StatusBreak.toString().length() > 0) {
                String Str_StatusBreak = StatusBreak.toString();
                if (Str_StatusBreak.equals("1") || Str_StatusBreak.equals("0")) {
                    Param.put("Is_Break", Str_StatusBreak);
                    Param.remove("StatusBreak");
                    Map<String, Object> Rdata = openApiServiceImpl.simApnFunction(Param, Str_StatusBreak);
                    boolean bool = (boolean) Rdata.get("bool");
                    String code = Rdata.get("code").toString();
                    if (bool) {
                        return new ResponseJson().successOpen(Rdata.get("Data"));
                    } else {
                        return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
                    }
                } else {
                    return new ResponseJson().errorOpen("400", "参数错误！请按文档说明传入 StatusBreak ！");
                }
            } else {
                return new ResponseJson().errorOpen("400", "缺少参数！请按文档说明传入 ！");
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /*
     * 机卡重绑
     * @param request
     * @param response
     * @return*/
    @RequestMapping(value = "/MachineCardBinding")
    @ResponseBody
    public JSONObject MachineCardBinding(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        System.out.println(map);
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Object contactName = Param.get("contactName");
            Object contactPhone = Param.get("contactPhone");
            if (contactName != null && !contactName.equals("") && contactName.toString().length() > 0 && contactPhone != null && !contactPhone.equals("") && contactPhone.toString().length() > 0) {
                Param.put("bind_type", null);
                Param.put("imei", null);
                Map<String, Object> Rdata = apiUtil_NoStatic.unbundling(Param);
                String code = Rdata.get("code").toString();
                String Message = Rdata.get("Message") != null ? Rdata.get("Message").toString() : "";
                if (code.equals("200")) {
                    return new ResponseJson().successOpen(Message);
                } else {
                    return new ResponseJson().errorOpen(code, Message);
                }
            } else {
                return new ResponseJson().errorOpen("400", "缺少参数！请按文档说明传入 ！");
            }
        } catch (Exception e) {
            System.out.println(e);
            return new ResponseJson().error("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 查询卡是否在网状态
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/simSession")
    @ResponseBody
    @LogAnnotation(action = "查询在网状态")
    public JSONObject simSession(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");

            Map<String, Object> Rdata = apiUtil_NoStatic.queryOnlineStatus(Param);
            String code = Rdata.get("code").toString();
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (code.equals("200")) {
                returnMap.put("type", Rdata.get("type"));
                returnMap.put("typeName", Rdata.get("typeName"));
                returnMap.put("imei", Rdata.get("imei"));
                returnMap.put("statusCode", Rdata.get("statusCode"));
                returnMap.put("statusMessage", Rdata.get("statusMessage"));
                returnMap.put("cd_code", Rdata.get("cd_code"));
                returnMap.put("Data", Rdata.get("Data"));
                return new ResponseJson().successOpen(returnMap);
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 获取共享token
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/sharedToken")
    @ResponseBody
    @LogAnnotation(action = "共享token")
    public JSONObject sharedToken(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> data = publicApiService.getToken(Param);
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (data != null) {
                String token = data.get("token").toString();
                if (token != null) {
                    returnMap.put("Data", data);
                    return new ResponseJson().successOpen(returnMap);
                } else {
                    return new ResponseJson().errorOpen("500", "内部获取token失败");
                }
            } else {
                return new ResponseJson().errorOpen("500", "未找到对应token获取");
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 资费计划 可用查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/tariffplan")
    @ResponseBody
    @LogAnnotation(action = "资费计划 可用查询")
    public JSONObject tariffplan(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");

        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            Map<String, Object> agentAccount = (Map<String, Object>) request.getAttribute("agentAccount");
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            String companyId = Param.get("companyId").toString();
            String agentID = agentAccount.get("agent_id").toString();
            //判断 传入的 企业编号 是否与操企业编号一致
            if (agentID.equals(companyId)) {
                return new ResponseJson().successOpen(yzCardRouteMapper.findTariffplan(Param));
            } else {
                return new ResponseJson().errorOpen("400", "操作企业编号不是您所在的企业请核对后重试！");
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 企业 预存余额查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/balance")
    @ResponseBody
    @LogAnnotation(action = "企业 预存余额查询")
    public JSONObject balance(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            Map<String, Object> agentAccount = (Map<String, Object>) request.getAttribute("agentAccount");
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            String companyId = Param.get("companyId").toString();
            String agentID = agentAccount.get("agent_id").toString();
            //判断 传入的 企业编号 是否与操企业编号一致
            if (agentID.equals(companyId)) {
                Map<String, Object> YcParamMap = new HashMap<String, Object>();
                YcParamMap.put("companyName", agentAccount.get("agent_name").toString());

                Map<String, Object> FindDeptAmountMap = new HashMap<>();
                FindDeptAmountMap.put("dept_id", agentID);
                Map<String, Object> dMap = yzUserMapper.findDeptAmount(FindDeptAmountMap);
                Double companyBalance = 0.0;
                Double companyCredit = 0.0;
                if (dMap != null) {
                    companyBalance = dMap.get("deposit_amount") != null ? Double.parseDouble(dMap.get("deposit_amount").toString()) : companyBalance;
                    companyCredit = dMap.get("be_usable_line_of_credit") != null ? Double.parseDouble(dMap.get("be_usable_line_of_credit").toString()) : companyCredit;
                }
                YcParamMap.put("companyBalance", companyBalance);
                YcParamMap.put("companyCredit", companyCredit);
                return new ResponseJson().successOpen(YcParamMap);
            } else {
                return new ResponseJson().errorOpen("400", "操作企业编号不是您所在的企业请核对后重试！");
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    /**
     * 资费计划订购
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/subscribe")
    @ResponseBody
    @LogAnnotation(action = "资费计划订购")
    public JSONObject subscribe(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            Map<String, Object> agentAccount = (Map<String, Object>) request.getAttribute("agentAccount");
            ParamMap.putAll(JSON.parseObject(map));
            Map<String, Object> Rdata = openApiServiceImpl.subscribe(ParamMap, agentAccount);
            boolean bool = (boolean) Rdata.get("bool");
            String code = Rdata.get("code").toString();
            if (bool) {
                return new ResponseJson().successOpen(Rdata.get("Message"));
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }

    @RequestMapping(value = "/smsSend")
    @ResponseBody
    @LogAnnotation(action = "短信下发")
    public JSONObject smsSend(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            Map<String, Object> agentAccount = (Map<String, Object>) request.getAttribute("agentAccount");
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            String agentID = agentAccount.get("agent_id").toString();

            //增加 id 范围
            if (!agentID.equals("100")) {
                Map<String, Object> findqueryChildrenAreaInfoMap = new HashMap<>();
                findqueryChildrenAreaInfoMap.put("agent_id", agentID);
                String agent_idArrStr = yzCardMapper.queryChildrenAreaInfo(findqueryChildrenAreaInfoMap);
                if (agent_idArrStr != null) {
                    String agent_idArr[] = agent_idArrStr.split(",");
                    if (agent_idArr != null) {
                        List<String> find_agent_id = new ArrayList<>();
                        for (int i = 0; i < agent_idArr.length; i++) {
                            String f_agent_id = agent_idArr[i] != null && agent_idArr[i].length() > 0 ? agent_idArr[i] : null;
                            if (f_agent_id != null) {
                                find_agent_id.add(f_agent_id);
                            }
                        }
                        if (find_agent_id.size() > 0) {
                            Param.put("agentIdList", find_agent_id);
                        }
                    }
                }
            }


            Map<String, Object> findMap = new HashMap<>();
            findMap.put("dept_id", agentID);
            Map<String, Object> dMap = yzUserMapper.getDept(findMap);
            Map<String, Object> User = yzUserMapper.getUser(findMap);
            User.put("dept", dMap);
            Param.put("agent_id", agentID);
            Param.put("User", User);

            Map<String, Object> Rdata = openApiServiceImpl.SmsCCTextField(Param);
            boolean bool = (boolean) Rdata.get("bool");
            String code = Rdata.get("code").toString();
            if (bool) {
                return new ResponseJson().successOpen(Rdata.get("Message"));
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    @RequestMapping(value = "/iotlink/callback")
    @ResponseBody
    @LogAnnotation(action = "资费订购回调")
    public JSONObject callback(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            if (ParamMap != null) {
                return new ResponseJson().successOpen("已成功接收消息");
            } else {
                return new ResponseJson().errorOpen("500", "返回消息保存异常！");
            }
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }


    //续费申请
    @RequestMapping(value = "/renewal")
    @ResponseBody
    @LogAnnotation(action = "续费申请")
    public JSONObject renewalApplication(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        List<Map<String, Object>> list = new ArrayList<>();
        JSONObject object = JSONObject.parseObject(map);
        String Param = object.get("Param").toString();
        String verify = object.get("verify").toString();
        ParamMap.putAll(JSON.parseObject(Param));
        ParamMap.putAll(JSON.parseObject(verify));
        String iccid = ParamMap.get("iccid").toString();
        if (iccid.contains(",")) {
            String iccids[] = ParamMap.get("iccid").toString().split(",");
            try {
                //查询当前API登录用户agent_id
                String agentId = agentPackageMapper.findAgentId(ParamMap.get("appId"));
                for (String ic : iccids) {
                    Map<String, Object> oneCard = yzCardMapper.findOneCard(ic, agentId);
                    if (oneCard != null) {
                        Map<String, Object> cardPacket = yzCardPacketMapper.findCardPacket(ic);
                        if (cardPacket != null) {
                            HashMap<Object, Object> hashMap = new HashMap<>();
                            hashMap.put("dept_id", agentId);
                            hashMap.put("user_id", "1");
                            hashMap.put("create_time", VeDate.getStringDate());
                            hashMap.put("status", 0);
                            hashMap.put("info", " ");
                            hashMap.put("is_send", 1);
                            hashMap.put("card_sumCount", list.size());
                            hashMap.put("amount", cardPacket.get("packet_price"));
                            renewalPrimaryMapper.save(hashMap);
                        }
                    } else {
                        return new ResponseJson().errorOpen("500", "用户无该卡信息！");
                    }
                }
            } catch (Exception e) {
                return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
            }
        } else {
            //查询当前API登录用户agent_id
            String agentId = agentPackageMapper.findAgentId(ParamMap.get("appId"));
            Map<String, Object> oneCard = yzCardMapper.findOneCard(iccid, agentId);
            if (oneCard != null) {
                Map<String, Object> cardPacket = yzCardPacketMapper.findCardPacket(iccid);
                HashMap<String, Object> hashMap = new HashMap<>();
                hashMap.put("dept_id", agentId);
                hashMap.put("user_id", "1");
                hashMap.put("create_time", VeDate.getStringDate());
                hashMap.put("status", 0);
                hashMap.put("info", " ");
                hashMap.put("is_send", 1);
                hashMap.put("card_sumCount", "1");
                hashMap.put("amount", cardPacket.get("packet_price"));
                renewalPrimaryMapper.save(hashMap);
                return new ResponseJson().successOpen("已成功接收消息");
            } else {
                return new ResponseJson().errorOpen("500", "用户无该卡信息！");
            }
        }
        return new ResponseJson().successOpen("已成功接收消息");
    }

    //    batch query
    @RequestMapping(value = "/queryCardInfo")
    @ResponseBody
    @LogAnnotation(action = "批量查询卡信息")
    public JSONObject batchQuery(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();

        ParamMap.putAll(JSON.parseObject((String) map));
        Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
        String iccids[] = Param.get("iccid").toString().split(",");
        List<Object> objects = new ArrayList<>();
        try {
            for (String iccid : iccids) {
                boolean is_Internal = true;
                Map<String, Object> maps = yzCardMapper.selCardList(iccid, is_Internal);
                String operator = maps.get("cd_operator_type").toString();
//                1移动2联通3电信4其他
                if (operator.equals("1")) {
                    maps.put("operatorName","中国移动");
                } else if (operator.equals("2")) {
                    maps.put("operatorName","中国联通");
                } else if (operator.equals("3")) {
                    maps.put("operatorName","中国电信");
                } else {
                    maps.put("operatorName","其他");
                }
                objects.add(maps);
            }
            System.err.println(objects);
            return new ResponseJson().successOpen(objects);
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "批量查询失败，请检查参数是否正确！");
        }
    }

    // 服务器请求地址     http://api.5iot.com/route/open/cardInfo
    protected static String server_Ip = "http://api.5iot.cn/route/open";
    // appId
    public static String appId = null;
    //秘钥密码
    public static String password = null;


    /**
     * Sign 加密类
     *
     * @param map
     * @param key
     * @return
     */
    public static String getSign(Map<String, Object> map, String key) {
        List<String> list = new ArrayList<>(map.keySet());
        Collections.sort(list);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); i++) {
            String k = list.get(i);
            String v = (String) map.get(k);
            sb.append(k).append("=").append(v).append("&");
        }
        String signstr = sb.append("key=").append(key).toString();
        String sign = MD5Util.MD5Encode(signstr).toUpperCase();
        return sign;
    }

//    public static void main(String[] args) {
//        Map<String, Object> map = new HashMap<String, Object>();
//        Map<String, Object> Parmap = new HashMap<String, Object>();
//        Map<String, Object> verify = new HashMap<String, Object>();
//
//        String appId = "SDHZWL";
//        String password = "HZ.2024!";
//        String access_key = "SDHZWL@20240112";
//        String timeStamp = "" + System.currentTimeMillis();
//
//        verify.put("password", password);
//        verify.put("appId", appId);
//        verify.put("timeStamp", timeStamp);
//        verify.put("sign", getSign(verify, access_key));
//
////        Parmap.put("type", "iccid");
//        Parmap.put("iccid", "89860480192040457791,89860480192040456801");
////        Parmap.put("cardno", "89860480192040457791");
////        Parmap.put("cardno", "89860480192040456801");
//
//
//        map.put("verify", verify);
//        map.put("Param", Parmap);
//
//        server_Ip += "/cardInfo";
//        String result = null;
//        String a = "http://127.0.0.1:9080/route/open/queryCardInfo";
//        String data = JSON.toJSONString(map);
//        System.err.println(data);
//        result = HttpUtil.post(a, data);// 返回结果字符串
//        System.out.println(result);
//
//    }
    public static void main(String[] args) {

        Map<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> Parmap = new HashMap<String, Object>();
        Map<String, Object> verify = new HashMap<String, Object>();

        String appId = "cuipeihao";
        String password = "cuipeihao123";
        String access_key = "cuipeihao@0066";
        String timeStamp = "" + System.currentTimeMillis();

        verify.put("password", password);
        verify.put("appId", appId);
        verify.put("timeStamp", timeStamp);
        verify.put("sign", getSign(verify, access_key));
        Parmap.put("type", "iccid");
        Parmap.put("cardno", "898604862921D0011300");


        map.put("verify", verify);
        map.put("Param", Parmap);
        System.err.println(map);
//        server_Ip += "/cardInfo";
        String result = null;
        String a = "http://127.0.0.1:9080/route/iot/cardSel";
        String data = JSON.toJSONString(map);
        result = HttpUtil.post(a, data);// 返回结果字符串
        System.out.println(result);
    }
}

