package com.yunze.iotapi.controller.openApi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yunze.apiCommon.mapper.mysql.YzCardRouteMapper;
import com.yunze.apiCommon.mapper.mysql.YzCardxintongMapper;
import com.yunze.apiCommon.upstreamAPI.PublicApiService;
import com.yunze.apiCommon.utils.ApiUtil_NoStatic;
import com.yunze.iotapi.utils.LogAnnotation;
import com.yunze.iotapi.utils.ResponseJson;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("/iot")
public class IotBossApiController {
    @Resource
    private PublicApiService publicApiService;
    @Resource
    private ApiUtil_NoStatic apiUtil_NoStatic;
    @Resource
    private YzCardRouteMapper yzCardRouteMapper;

    /**
     * 卡信息查询
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardSel")
    @ResponseBody
    @LogAnnotation(action = "卡信息查询")
    public JSONObject cardInfo(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> data = publicApiService.cardInfo(Param);
            return new ResponseJson().successOpen(data);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }

    /**
     * 同步卡用量
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardUsed")
    @ResponseBody
    @LogAnnotation(action = "卡用量查询")
    public JSONObject cardUsed(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            Map<String, Object> Rdata = apiUtil_NoStatic.queryFlow(Param);
            return new ResponseJson().successOpen(Rdata);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }

    /**
     * 同步卡状态
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardStatus")
    @ResponseBody
    @LogAnnotation(action = "卡状态查询")
    public JSONObject cardStatus(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");

            Map<String, Object> Rdata = apiUtil_NoStatic.queryCardStatus(Param);
            String code = Rdata.get("code").toString();
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (code.equals("200")) {
                returnMap.put("type", Rdata.get("type"));
                returnMap.put("typeName", Rdata.get("typeName"));
                returnMap.put("imei", Rdata.get("imei"));
                returnMap.put("statusCode", Rdata.get("statusCode"));
                returnMap.put("statusMessage", Rdata.get("statusMessage"));
                returnMap.put("cd_code", Rdata.get("cd_code"));
                returnMap.put("Data", Rdata.get("Data"));
                return new ResponseJson().successOpen(returnMap);
            } else {
                return new ResponseJson().errorOpen(code, Rdata.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }

    /**
     * 同步卡激活时间
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/cardActiveTime")
    @ResponseBody
    @LogAnnotation(action = "卡激活时间查询")
    public JSONObject cardActiveTime(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));

            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            System.err.println(publicApiService.queryCardActiveTime(Param));
            Map<String, Object> map1 = apiUtil_NoStatic.queryCardActiveTime(Param);
            String code = map1.get("code").toString();
            Map<String, Object> returnMap = new HashMap<String, Object>();
            if (code.equals("200")) {
                returnMap.put("data", map1);
//                returnMap.put("code",map1.get("code"));
//                returnMap.put("activateDate",map1.get("activateDate"));
//                returnMap.put("message",map1.get("Message"));
//                returnMap.put("openDate",map1.get("openDate"));
//                returnMap.put("'statusMessage",map1.get("statusMessage"·));
                return new ResponseJson().successOpen(returnMap);
            } else {
                return new ResponseJson().errorOpen(code, map1.get("Message").toString());
            }
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }

    /**
     * iotx查询卡通道信息
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/findRouterAndApi")
    @ResponseBody
    @LogAnnotation(action = "iotx查询卡通道信息")
    public JSONObject findRouterAndApi(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try {
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            //根据IccID查询通道信息
            Map<String, Object> rMap = yzCardRouteMapper.selCardRouteIotX(Param);
            if (rMap!= null){
                return new ResponseJson().successOpen(rMap);
            }
            return new ResponseJson().errorOpen("500", "无卡信息~");
        } catch (Exception e) {
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }
    @Resource
    YzCardxintongMapper yzCardxintongMapper;

    @RequestMapping(value = "/xintong")
    @ResponseBody
    @LogAnnotation(action = "芯通专属接口")
    public JSONObject xintong(HttpServletRequest request, HttpServletResponse response) {
        String map = (String) request.getAttribute("map");
        Map<String, Object> ParamMap = new HashMap<String, Object>();
        try { //dept 1077
            ParamMap.putAll(JSON.parseObject((String) map));
            Map<String, Object> Param = (Map<String, Object>) ParamMap.get("Param");
            String iccid = Param.get("iccid").toString();
            Map<String, Object> selMap = new HashMap<>();
            selMap.put("iccid",iccid);
            selMap.put("agent_id","1077");
            Map<String, Object> sel = yzCardxintongMapper.sel(selMap);
            return new ResponseJson().successOpen(sel);
        } catch (Exception e) {
            //System.out.println(e);
            return new ResponseJson().errorOpen("500", "操作失败请稍后重试！");
        }
    }
}
