/*
 Navicat Premium Data Transfer

 Source Server         : IoTLink-数据库
 Source Server Type    : MySQL
 Source Server Version : 80032
 Source Host           : localhost:3306
 Source Schema         : iotdb

 Target Server Type    : MySQL
 Target Server Version : 80032
 File Encoding         : 65001

 Date: 12/06/2023 14:56:14
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '代码生成业务表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of gen_table
-- ----------------------------

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `sort` int NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `blob_data` blob NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_blob_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `calendar` blob NOT NULL,
  PRIMARY KEY (`sched_name`, `calendar_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_calendars
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `cron_expression` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `time_zone_id` varchar(80) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', '0 0/10 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', '0 0/20 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', '0 0/1 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', '50 0 0 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', '0 0 0 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', '0 0/45 * * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', '0 1 0 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME17', 'Automation', '0 0/10 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', '0 0 0/8 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', '0 0 0,2,4,6 1 * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME20', 'POLLING', '0 0/3 * * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', '0/20 * * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', '0 0 0/1 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', '0 0 0/1 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', '0 0 0/3 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', '0 0 0/1 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', '0 0 0/1 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', '0 0 0/1 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME28', 'Automation', '0 0 9,15 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME29', 'Automation', '0 0/3 10 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME30', 'SYSTEM', '0 5 0 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME31', 'POLLING', '0 0/8 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME32', 'POLLING', '0 0 5,17 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME33', 'POLLING', '3 0 0 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME34', 'POLLING', '4 0 0 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME35', 'POLLING', '0 0 10,21 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME36', 'POLLING', '0 0 8,19 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME37', 'POLLING', '5 0 0 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME38', 'POLLING', '0 0 0/12 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME39', 'POLLING', '0 0 2/8 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', '0 0 0/1 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME40', 'DEFAULT', '0 0 3/8 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME41', 'POLLING', '0 0 5/8 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME42', 'POLLING', '0 0 6/8 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME43', 'DEFAULT', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME44', 'Automation', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME45', 'DEFAULT', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME46', 'DEFAULT', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME47', 'SYSTEM', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME48', 'POLLING', '0 0 3 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME49', 'POLLING', '0 0 0/4 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', '0 0 0 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME50', 'SYSTEM', '0 0 0 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME51', 'SYSTEM', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME52', 'POLLING', '20 0 19 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME54', 'POLLING', '0 0 20 1/3 * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME55', 'SYSTEM', '0 0 0/3 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME56', 'Automation', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME57', 'DEFAULT', '0 0 0/2 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME58', 'DEFAULT', '0 0 0/2 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME59', 'DEFAULT', '0 0/1 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', '0 0/20 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME61', 'DEFAULT', '0 0 3/8 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME62', 'Automation', '45 0 3 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME63', 'POLLING', '0 0 3 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME64', 'POLLING', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME65', 'POLLING', '0 0 10 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME66', 'POLLING', '0 0/1 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME67', 'POLLING', '0 0/1 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME68', 'SYSTEM', '0 10 0 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME69', 'POLLING', '0 0 20 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', '0 0 11,22 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME70', 'POLLING', '0 0 22 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME71', 'SYSTEM', '0 0 0/1 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME72', 'POLLING', '0 0/50 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME73', 'Automation', '0 0/10 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME74', 'SYSTEM', '0 0/10 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME75', 'SYSTEM', '10 0 1 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME76', 'SYSTEM', '15 0 1 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME77', 'SYSTEM', '10 0 0 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME78', 'SYSTEM', '45 0 0 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME79', 'SYSTEM', '0 0/1 * * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', '0 0 6,18 * * ? ', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME80', 'POLLING', '45 0 1 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME81', 'POLLING', '30 0 0/4 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME82', 'POLLING', '20 0 0/4 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME83', 'DEFAULT', '0 0 9 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME84', 'POLLING', '10 0 2 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME85', 'POLLING', '45 0 1 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME86', 'POLLING', '30 0 0/4 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME87', 'POLLING', '20 0 0/4 * * ?', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME88', 'DEFAULT', '0 0 9 ? * MON-FRI', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME89', 'POLLING', '10 0 2 * * ? *', 'GMT+08:00');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', '0 0/55 * * * ?', 'GMT+08:00');

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `entry_id` varchar(95) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `fired_time` bigint NOT NULL,
  `sched_time` bigint NOT NULL,
  `priority` int NOT NULL,
  `state` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `entry_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_fired_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `job_class_name` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `is_durable` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `is_update_data` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_data` blob NULL,
  PRIMARY KEY (`sched_name`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013174000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 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
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B3E53849078707400007070707400013174000E3020302F3230202A202A202A203F7400506F726465724164645061636B61676550726F64756374696F6E5461736B2E61637469766174696F6E4164645061636B61676550726F64756374696F6E416E644163746976617465446174652831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000B740051E7949FE69588E7B1BBE59E8BE4B8BA205BE6BF80E6B4BBE7949FE695885D20E4B89420E5B7B2E69C89E7949FE69588E697B6E997B420E5A29EE58AA0E588B0E7949FE4BAA7E4BBBBE58AA1E4B8ADE58EBB74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B5D27321878707400007070707400013174000D3020302F31202A202A202A203F74001E63617264466C6F775461736B2E537461727443617264466C6F7728363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000C740018E6898BE58AA8E5BC80E590AFE794A8E9878FE79B91E590AC74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B5DD8174078707400007070707400013174000E353020302030202A202A203F202A7400157379734C6F67735461736B2E6261636B75707328297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000D740018E588A0E999A4E5AFB9E5A496E68EA5E58FA3E697A5E5BF9774000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B9AA31FF878707400007070707400013174000D3020302030202A202A203F202A740013696E69744D512E696E69744D51436F6E66696774000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000E74000B4D51E5889DE5A78BE58C9674000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BE2EBE6A078707400007070707400013174000F3020302F3435202A202A202A203F2074003163617264446973636F6E6E65637465645461736B2E706F6C6C696E6743617264446973636F6E6E65637465642831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000F74000FE69CAAE8AEA2E8B4ADE5819CE69CBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BEE1815A878707400007070707400013174000D3020312030202A202A203F202A7400176261636B7570546573742E67656E7461626C65283330297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001074000FE5A487E4BBBDE68980E69C89E8A1A874000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME17', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C5E215FD078707400007070707400013174000E3020302F3130202A202A202A203F74001F656D61696C434353686F7070696E672E434353686F7070696E67283530302974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001174001BE8B4ADE789A9E982AEE4BBB6E887AAE58AA8E58C96E68A84E9808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017CC634131078707400007070707400013174000E30203020302F38202A202A203F20740037636172644163746976617465446174655461736B2E706F6C6C696E674163746976617465446174652827536572696F7573272C20363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001274001CE8BDAEE8AFA22DE6BF80E6B4BBE697B6E997B4E69C89E794A8E9878F74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017CFD4332A078707400007070707400013174001330203020302C322C342C362031202A203F202A7400136D6F6E74682E67656E7461626C652831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001374001BE69C88E5889DE6B581E9878FE58DA1E8BF9BE8A18CE5A48DE69CBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013174000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME20', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D03EA950878707400007070707400013174000F3020302F33202A202A202A203F202A74001763656E6476616C75652E63656E64616C75652831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001474002243E7ABAFE58585E580BCE58F98E69BB4E5A4B1E8B4A5E5868DE6ACA1E5A48DE69CBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D238B375078707400007070707400013174000E302F3230202A202A202A202A203F740065726F6C6C6261636B436172646167656E742E726F6C6C6261636B4572726F7228272F6D6E742F79756E7A652F646F776E6C6F61642F6373762F313233313233313233645F43617264446973747269627574654261636B75702E637376272C3132302C3536297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000015740013E59B9EE6BB9A20E58892E58DA1E5A487E4BBBD74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D457A7CB878707400007070707400013174000D30203020302F31202A202A203F74002863617264466C6F775461736B2E706F6C6C696E6743617264466C6F774F6E652836302C2734392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001674001BE5889BE5BBBAE58D95E9809AE98193E794A8E9878FE79B91E590AC74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D4589558078707400007070707400013174000D30203020302F31202A202A203F74002C63617264466C6F775461736B2E43617264466C6F774372656174654C697374656E65722836302C2734392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000017740022E68C87E5AE9AE58D95E4B8AAE9809AE98193E5889BE5BBBA20E6B688E8B4B9E8808574000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D4C28864078707400007070707400013174000D30203020302F33202A202A203F7400217265626F6F745461736B2E5265626F6F74466C6F77506F6C6C696E672831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000018740024E8BDAEE8AFA2E9878DE590AFE697A0E8AEB0E5BD95E6B688E8B4B9E88085E5889BE5BBBA74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5FEF11F878707400007070707400013174000D30203020302F31202A202A203F74001E7265626F6F745461736B2E5265626F6F744361726453746F702831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000019740012E5819CE69CBAE99888E580BCE9878DE590AF74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5FEFA28078707400007070707400013174000D30203020302F31202A202A203F7400267265626F6F745461736B2E5265626F6F7443617264446973636F6E6E65637465642831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001A740015E69CAAE8AEA2E8B4ADE5819CE69CBAE9878DE590AF74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5A0D8BE878707400007070707400013174000F30203020302F31202A202A203F202A7400166D7163617264666C6F772E67657474696D6528333029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001B740018E5908CE6ADA5E4B8BBE8A1A8E588B0E69C9FE697A5E69C9F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME28', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017E5244BA9878707400007070707400013174000F30203020392C3135202A202A203F2074002E656D61696C43434361726441626E6F726D616C5374617475732E43434361726441626E6F726D616C53746174757374000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001C74002AE5B7B2E8AEA2E8B4ADE794A8E9878FE78AB6E68081E5B7B2E5819CE69CBAE982AEE4BBB6E68A84E9808174000132740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME29', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017E52C4C7D878707400007070707400013174000E3020302F33203130202A202A203F740026656D61696C43434361726441626E6F726D616C5374617475732E52657472794343283130302974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001D740036E982AEE4BBB6E68A84E98081205BE69C89E794A8E9878FE5819CE69CBAE78AB6E680815DE5A4B1E8B4A5E5868DE6ACA1E68A84E9808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013074000E302F3230202A202A202A202A203F74003872795461736B2E72794D756C7469706C65506172616D7328277279272C20747275652C20323030304C2C203331362E3530442C203130302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000003740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E5A49AE58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME30', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017E8F4D3D9878707400007070707400013174000B3020352030202A202A203F74002C696E6465787061676547656E65726174655461736B2E47656E65726174655461736B2836302C27313030272974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001E740012E9A696E9A1B5E695B0E68DAEE7949FE6889074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME31', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F24C310F078707400007070707400013174000D3020302F38202A202A202A203F74002970617373616765776179506F6C6C696E675461736B2E636C65616E52656469734368616E6E656C2829740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001F740021E6B885E999A4E5BD93E5A4A9E5B7B2E5AE8CE68890E8BDAEE8AFA2E8BF9BE5BAA674000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME32', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6CE2A4B878707400007070707400013174000E30203020352C3137202A202A203F74003763617264466C6F7741695461736B2E706F6C6C696E6743617264466C6F77283132302C276E6F744E756C6C272C2736272C27272C272729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002074000FE794A8E9878F2DE699BAE883BD2D3174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME33', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6CE6754878707400007070707400013174000C3320302030202A202A203F2074003B63617264466C6F7741695461736B2E706F6C6C696E6743617264466C6F77283132302C274E756C6C272C2737272C276E6F744E756C6C272C272729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002174000FE794A8E9878F2DE699BAE883BD2D3274000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME34', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6CE7C15078707400007070707400013174000C3420302030202A202A203F2074003B63617264466C6F7741695461736B2E706F6C6C696E6743617264466C6F77283132302C274E756C6C272C2739272C27272C276E6F744E756C6C2729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002274000FE794A8E9878F2DE699BAE883BD2D3374000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME35', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DB2F0F078707400007070707400013174000F3020302031302C3231202A202A203F74003C6361726453746174757341695461736B2E706F6C6C696E6743617264537461747573283132302C276E6F744E756C6C272C273130272C27272C272729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000023740013E58DA1E78AB6E680812DE699BAE883BD2D312074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME36', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DC8E9F078707400007070707400013174000E30203020382C3139202A202A203F7400406361726453746174757341695461736B2E706F6C6C696E6743617264537461747573283132302C274E756C6C272C273131272C276E6F744E756C6C272C272729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000024740012E58DA1E78AB6E680812DE699BAE883BD2D3274000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME37', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DCBF34878707400007070707400013174000B3520302030202A202A203F7400406361726453746174757341695461736B2E706F6C6C696E6743617264537461747573283132302C274E756C6C272C273133272C27272C276E6F744E756C6C2729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000025740012E58DA1E78AB6E680812DE699BAE883BD2D3374000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME38', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DD4349078707400007070707400013174000F30203020302F3132202A202A203F2074003063617264466C6F7741695461736B2E706F6C6C696E6743617264466C6F7753696C656E6365506572696F642831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002674000FE794A8E9878F2DE699BAE883BD2D3474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME39', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DD85EF878707400007070707400013174000F30203020322F38202A202A203F202A7400276361726453746174757341695461736B2E706F6C6C696E67436172645374617475732831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000027740012E58DA1E78AB6E680812DE699BAE883BD2D3474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017A707EF3B078707400007070707400013174000E30203020302F31202A202A203F207400506F726465724164645061636B61676550726F64756374696F6E5461736B2E61637469766174696F6E4164645061636B61676550726F64756374696F6E416E64416374697661746544617465283138302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000004740024E6A0B9E68DAEE8AEA2E58D95E8BDAEE5BA8FE69BB4E696B0E6BF80E6B4BBE697B6E997B474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME40', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DDF67C078707400007070707400013174000F30203020332F38202A202A203F202A74004C6361726441637469766174654461746541695461736B2E706F6C6C696E67416374697661746544617465496E74656C6C6967656E74283132302C273134272C276E6F744E756C6C272C27272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000028740015E6BF80E6B4BBE697B6E997B42DE699BAE883BD2D3174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME41', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DE5B8F078707400007070707400013174000F30203020352F38202A202A203F202A74004C6361726441637469766174654461746541695461736B2E706F6C6C696E67416374697661746544617465496E74656C6C6967656E74283132302C273135272C27272C276E6F744E756C6C2729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000029740015E6BF80E6B4BBE697B6E997B42DE699BAE883BD2D3274000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME42', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DE84D1878707400007070707400013174000F30203020362F38202A202A203F202A74003A6361726441637469766174654461746541695461736B2E706F6C6C696E67416374697661746544617465496E74656C6C6967656E742831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002A740015E6BF80E6B4BBE697B6E997B42DE699BAE883BD2D3374000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME43', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F672E54E0787074000070707074000131740012302030203130203F202A204D4F4E2D465249740016656D61696C50617947726F75702E50617947726F757074000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002B74002BE887AAE58AA8E58C9620E982AEE4BBB6E68A84E98081205BE69CAAE58892E58886E8B584E8B4B9E7BB845D74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME44', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018018182830787074000070707074000131740012302030203130203F202A204D4F4E2D46524974001675736167654D61696C2E52656D696E6465722838302974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002C74002FE887AAE58AA8E58C96E4BBBBE58AA1E982AEE4BBB6E68A84E98081E8B685E799BEE58886E6AF94EFBC883830EFBC8974000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME45', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F68918E60787074000070707074000131740012302030203130203F202A204D4F4E2D46524974001A656D61696C506173736167657761792E5061737361676577617974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002D740028E887AAE58AA8E58C9620E982AEE4BBB6E68A84E98081205BE69CAAE58892E58886E9809AE981935D74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME46', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6C6F8410787074000070707074000131740012302030203130203F202A204D4F4E2D46524974001B656D61696C506173736167657761792E526574727943432835302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002E74002FE887AAE58AA8E58C9620E982AEE4BBB6E68A84E9808120E9878DE8AF95205BE69CAAE58892E58886E9809AE981935D74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME47', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F720A77B8787074000070707074000131740012302030203130203F202A204D4F4E2D465249740019656D61696C50617947726F75702E526574727943432835302974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000002F740032E887AAE58AA8E58C9620E982AEE4BBB6E68A84E9808120E9878DE8AF95205BE69CAAE58892E58886E8B584E8B4B9E7BB845D74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME48', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F736B53C078707400007070707400013174000B3020302033202A202A203F74002A6361726453746174757341695461736B2E706F6C6C696E67436172645374617475734E756C6C28333029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003074001BE58DA1E78AB6E68081E69CAAE79FA5E88EB7E58F96E78AB6E6808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME49', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F736C97F878707400007070707400013174000D30203020302F34202A202A203F74002B63617264466C6F7741695461736B2E706F6C6C696E6743617264466C6F774E6F745265636F726428343529740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000031740021E794A8E9878FE8AEB0E5BD95E697A0E8AEB0E5BD95E88EB7E58F96E794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017A7FE1F28078707400007070707400013174000C3020302030202A202A203F20740037636172644163746976617465446174655461736B2E706F6C6C696E674163746976617465446174652827536C69676874272C2031323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000005740013E8BDAEE8AFA22DE6BF80E6B4BBE697B6E997B474000132740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME50', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017FB587819878707400007070707400013174000B3020302030202A202A203F740021636C65616E557043617264466C69774869732E436C65616E55702827313030272974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003274001CE6B885E999A4E5A4A7E4BA8E58E5A4A9E794A8E9878FE8AEB0E5BD9574000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME51', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017FBF1D1E98787074000070707074000131740012302030203130203F202A204D4F4E2D465249740026656D61696C43617264436F6E73756D7074696F6E2E43617264436F6E73756D7074696F6E282974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003374001CE5BD92E5B19EE4B8BAE680BBE5B9B3E58FB02DE69C89E794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME52', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018006F97B5878707400007070707400013174000D32302030203139202A202A203F7400386361726441637469766174654461746541695461736B2E706F6C6C696E67416374697661746544617465436F6D70656E7361746528363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000034740013E6BF80E6B4BBE697B6E997B42DE8A1A5E581BF74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME54', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001802CA8E98878707400007070707400013174000E30203020323020312F33202A203F74002B6361726453796E4F66666572696E67696E666F6C6973745461736B2E53796E4F66666572696E67696E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000036740018E58DA1E58FB7E5908CE6ADA5E4B88AE6B8B8E5A597E9A49074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME55', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001803A8F7DA078707400007070707400013174000D30203020302F33202A202A203F7400276361726453796E4F66666572696E67696E666F5461736B2E53796E4F66666572696E67696E666F74000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003774001BE5908CE6ADA5E4B88AE6B8B8E5A597E9A490E7B1BBE59E8BE8A1A874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME56', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018018182830787074000070707074000131740012302030203130203F202A204D4F4E2D46524974001572656D696E6465722E52656D696E6465722838302974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003874002FE887AAE58AA8E58C96E4BBBBE58AA1E982AEE4BBB6E68A84E98081E8B685E799BEE58886E6AF94EFBC883830EFBC8974000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME57', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180205ADB7878707400007070707400013174000D30203020302F32202A202A203F74001963617264436F756E742E73796E6368726F6E697A6174696F6E74000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000039740026E58DA1E9809AE98193E8A1A85BE5908CE6ADA5E69BB4E694B9E5AD97E6AEB5E695B0E68DAE5D74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME58', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180216CC0A878707400007070707400013174000D30203020302F32202A202A203F74002063617264506F7374616765436F756E742E73796E6368726F6E697A6174696F6E74000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003A74001EE8B584E8B4B9E7BB84E38090E5908CE6ADA5E58DA1E680BBE695B0E3809174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME59', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001803BA4357878707400007070707400013174000D3020302F31202A202A202A203F74001472656D696E6465722E526574727943432835302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003B74001FE982AEE4BBB6E68A84E98081E8B685E799BEE58886E6AF942DE9878DE8AF9574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AA96B7E0078707400007070707400013074000E3020302F3230202A202A202A203F74002270617373616765776179506F6C6C696E675461736B2E53796E4368616E6E656C2829740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000006740019E8BDAEE8AFA22DE5908CE6ADA5E9809AE98193E695B0E68DAE74000132740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME61', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017F6DDF67C078707400007070707400013174000F30203020332F38202A202A203F202A74004C6361726441637469766174654461746541695461736B2E706F6C6C696E67416374697661746544617465496E74656C6C6967656E74283132302C273134272C276E6F744E756C6C272C27272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003D740027E6BF80E6B4BBE697B6E997B42DE699BAE883BD2DE69CAAE6BF80E6B4BB2DE69C89E794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME62', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001804A8D169078707400007070707400013174000E343520302033202A202A203F202A74003863617264466C6F774C6573735468616E5A65726F5461736B2E706F6C6C696E6743617264466C6F774C6573735468616E5A65726F2836302974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003E740027E8AEB0E5BD95E4B8BAE8B49FE695B0E58DA1E58FB7E5868DE6ACA1E5908CE6ADA5E794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME63', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180BBDEDA9078707400007070707400013174000B3020302033202A202A203F74002873796E506F6C6C696E674572726F7247726F75705461736B2E53796E4F66666572696E67696E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000003F740032E5908CE6ADA52DE58DA1E794A8E9878FE68EA5E58FA3E69FA5E8AFA2E697B6E99499E8AFAFE8AEB0E5BD952DE58886E7B1BB74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME64', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180BCCEC0A0787074000070707074000131740012302030203130203F202A204D4F4E2D465249740019656D616941706953796E4572726F722E53656E642827392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000040740028415049E5908CE6ADA5E695B0E68DAEE99499E8AFAFE68A84E980812DE8BF90E890A5E7B1BBE59E8B74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME65', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180CBE38BE8787074000070707074000131740012302030203130203F202A204D4F4E2D46524974001A656D616941706953796E4572726F722E53656E64282731302729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004174002B415049E5908CE6ADA5E695B0E68DAEE99499E8AFAFE68A84E980812DE99D9EE8BF90E890A5E7B1BBE59E8B74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME66', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180CBF07C6878707400007070707400013174000D3020302F31202A202A202A203F74001F656D616941706953796E4572726F722E526574727943432835302C27392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000042740025E5908CE6ADA5E5A4B1E8B4A52DE8BF90E890A5E7B1BBE59E8BE38090E9878DE8AF95E3809174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME67', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180CBF0F58078707400007070707400013174000D3020302F31202A202A202A203F740020656D616941706953796E4572726F722E526574727943432835302C2731302729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000043740028E5908CE6ADA5E5A4B1E8B4A52DE99D9EE8BF90E890A5E7B1BBE59E8BE38090E9878DE8AF95E3809174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME68', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001811E3F225878707400007070707400013174000C302031302030202A202A203F74002E636C65616E5570457865637574696F6E5461736B466C69655461736B2E457865637574696F6E5461736B466C696574000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000044740012E6B885E79086E689A7E8A18CE4BBBBE58AA174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME69', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001813738A88878707400007070707400013174000C302030203230202A202A203F740029636172644F746865725374617475735461736B2E706F6C6C696E674361726453746174757328363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000045740021E68C87E5AE9AE58DA1E78AB6E68081E5908CE6ADA5E7949FE591BDE591A8E69C9F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AC2153E507870740000707070740001317400103020302031312C3232202A202A203F20740025636172645374617475735461736B2E706F6C6C696E67436172645374617475732831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000007740010E8BDAEE8AFA22DE58DA1E78AB6E6808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME70', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001815BFFC22878707400007070707400013174000C302030203232202A202A203F740035636172644F746865724163746976617465446174655461736B2E706F6C6C696E674361726441637469766174654461746528363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004674001EE68C87E5AE9AE78AB6E68081E88EB7E58F96E6BF80E6B4BBE697B6E997B474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME71', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000181654A5FF078707400007070707400013174000D30203020302F31202A202A203F7400177379734F726465722E5570644F7264657253746174757374000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000047740021E69CAAE689BEE588B0E58AA0E58C85E9878DE7BDAEE58AA0E58C85E78AB6E6808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME72', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000180B6F55C9878707400007070707400013174000E3020302F3530202A202A202A203F74003163617264427265616B4E6574776F726B5461736B2E706F6C6C696E6743617264427265616B4E6574776F726B2831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004874000FE69CAAE8AEA2E8B4ADE696ADE7BD9174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME73', 'Automation', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018195515F7878707400007070707400013174000E3020302F3130202A202A202A203F74001D656D61696C434352656E6577616C2E4343457865637574696F6E28312974000A4175746F6D6174696F6E7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000049740012E7BBADE8B4B9E982AEE4BBB6E9809AE79FA574000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME74', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001819640E7C878707400007070707400013174000E3020302F3130202A202A202A203F7400306F7264657252656E6577616C47656E65726174696F6E2E52656E6577616C546F47656E65726174654F7264657228332974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004A74001EE7BBADE8B4B9E5AEA1E6A0B8E9809AE8BF87E7949FE68890E8AEA2E58D9574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME75', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000181D10D942878707400007070707400013174000E313020302031202A202A203F202A74001663617264496E666F4368616E67652E436C656172557074000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004B74001BE588A0E999A4E58DA1E78AB6E68081E58F98E69BB4E4BFA1E681AF74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME76', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018201232DF878707400007070707400013174000E313520302031202A202A203F202A74001C7379734C6F67436C6561725461736B2E47656E65726174652833302974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004C74000CE697A5E5BF97E6B885E7908674000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME77', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001820127547878707400007070707400013174000E313020302030202A202A203F202A740034696E6465787061676547656E65726174655461736B2E47656E6572617465417373657444657461696C732836302C27313030272974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004D740018E5B9B3E58FB0E8B584E4BAA7E6988EE7BB86E7949FE6889074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME78', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000182197F37C078707400007070707400013174000E343520302030202A202A203F202A740022636172645061636B6574436F756E745461736B2E53796E5061636B6574436F756E7474000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004E74001CE8B584E8B4B9E8AEA1E588922DE58DA1E695B0E9878FE5908CE6ADA574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME79', 'SYSTEM', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000182B00B266878707400007070707400013174000D3020302F31202A202A202A203F74001F63617264536D735461736B2E53796E5061636B6574436F756E74282731272974000653595354454D7372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000004F740012E79FADE4BFA1E4B88BE58F91E689A7E8A18C74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AC78DE4B878707400007070707400013174000F30203020362C3138202A202A203F2074002163617264466C6F775461736B2E706F6C6C696E6743617264466C6F772831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000874000DE8BDAEE8AFA22DE794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME80', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001833B58198878707400007070707400013174000E343520302031202A202A203F202A74002273796E4368616E6E656C43617264496E666F5461736B2E53796E43617264496E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000050740015E9809AE98193E7BB84E5908CE6ADA5E68890E5919874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME81', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000183404DC89878707400007070707400013174000E3330203020302F34202A202A203F74001B73796E43617264496E666F5461736B2E53796E43617264496E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005174001DE68EA5E585A5E58FB7E5908CE6ADA56963636964E695B0E68DAEE7AD8974000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME82', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001835DA1563078707400007070707400013174000E3230203020302F34202A202A203F74002873796E4361726444617461436F6D70617269736F6E5461736B2E44617461436F6D70617269736F6E740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005274001EE5AFB9E6AF94E4B8BBE8A1A8E695B0E68DAEE8BF9BE8A18CE6A087E8AEB074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME83', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001836831CDF07870740000707070740001317400113020302039203F202A204D4F4E2D4652497400196361726453796E496E666F5461736B2E61646444657465637474000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005374001EE4B88AE6B8B8E6A087E8AEB0E695B0E68DAEE689A7E8A18CE696B0E5A29E74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME84', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001833AC3057878707400007070707400013174000E313020302032202A202A203F202A74002573796E557073747265616D4D656D6265725461736B2E53796E4F66666572696E67696E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000054740015E5908CE6ADA5E9809AE98193E68890E59198E7BB8474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME85', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001833B58198878707400007070707400013174000E343520302031202A202A203F202A74002273796E4368616E6E656C43617264496E666F5461736B2E53796E43617264496E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000055740015E9809AE98193E7BB84E5908CE6ADA5E68890E5919874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME86', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000183404DC89878707400007070707400013174000E3330203020302F34202A202A203F74001B73796E43617264496E666F5461736B2E53796E43617264496E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005674001DE68EA5E585A5E58FB7E5908CE6ADA56963636964E695B0E68DAEE7AD8974000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME87', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001835DA1563078707400007070707400013174000E3230203020302F34202A202A203F74002873796E4361726444617461436F6D70617269736F6E5461736B2E44617461436F6D70617269736F6E740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005774001EE5AFB9E6AF94E4B8BBE8A1A8E695B0E68DAEE8BF9BE8A18CE6A087E8AEB074000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME88', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001836831CDF07870740000707070740001317400113020302039203F202A204D4F4E2D4652497400196361726453796E496E666F5461736B2E61646444657465637474000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000005874001EE4B88AE6B8B8E6A087E8AEB0E695B0E68DAEE689A7E8A18CE696B0E5A29E74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME89', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001833AC3057878707400007070707400013174000E313020302032202A202A203F202A74002573796E557073747265616D4D656D6265725461736B2E53796E4F66666572696E67696E666F740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000059740015E5908CE6ADA5E9809AE98193E68890E59198E7BB8474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AD2D5B9E078707400007070707400013174000E3020302F3535202A202A202A203F7400206361726453746F705461736B2E706F6C6C696E674361726453746F7028363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000974000CE8BEBEE9878FE5819CE69CBA74000131740001307800);

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `lock_name` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `lock_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_paused_trigger_grps
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `last_checkin_time` bigint NOT NULL,
  `checkin_interval` bigint NOT NULL,
  PRIMARY KEY (`sched_name`, `instance_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('RuoyiScheduler', 'userzf1686552090740', 1686552231094, 15000);

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `repeat_count` bigint NOT NULL,
  `repeat_interval` bigint NOT NULL,
  `times_triggered` bigint NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_simple_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `str_prop_1` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `str_prop_2` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `str_prop_3` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `int_prop_1` int NULL DEFAULT NULL,
  `int_prop_2` int NULL DEFAULT NULL,
  `long_prop_1` bigint NULL DEFAULT NULL,
  `long_prop_2` bigint NULL DEFAULT NULL,
  `dec_prop_1` decimal(13, 4) NULL DEFAULT NULL,
  `dec_prop_2` decimal(13, 4) NULL DEFAULT NULL,
  `bool_prop_1` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `bool_prop_2` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_simprop_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `next_fire_time` bigint NULL DEFAULT NULL,
  `prev_fire_time` bigint NULL DEFAULT NULL,
  `priority` int NULL DEFAULT NULL,
  `trigger_state` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `trigger_type` varchar(8) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `start_time` bigint NOT NULL,
  `end_time` bigint NULL DEFAULT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `misfire_instr` smallint NULL DEFAULT NULL,
  `job_data` blob NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  INDEX `sched_name`(`sched_name`, `job_name`, `job_group`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 1686552090000, -1, 5, 'PAUSED', 'CRON', 1686552090000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', 'TASK_CLASS_NAME10', 'POLLING', NULL, 1686552600000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', 'TASK_CLASS_NAME11', 'POLLING', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', 'TASK_CLASS_NAME12', 'POLLING', NULL, 1686552120000, -1, 5, 'PAUSED', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', 'TASK_CLASS_NAME13', 'BACKUP', NULL, 1686585650000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', 'TASK_CLASS_NAME14', 'DEFAULT', NULL, 1686585600000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', 'TASK_CLASS_NAME15', 'POLLING', NULL, 1686552300000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', 'TASK_CLASS_NAME16', 'BACKUP', NULL, 1686585660000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME17', 'Automation', 'TASK_CLASS_NAME17', 'Automation', NULL, 1686552600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', 'TASK_CLASS_NAME18', 'POLLING', NULL, 1686556800000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', 'TASK_CLASS_NAME19', 'POLLING', NULL, 1688140800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 1686552090000, -1, 5, 'PAUSED', 'CRON', 1686552090000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME20', 'POLLING', 'TASK_CLASS_NAME20', 'POLLING', NULL, 1686552300000, 1686552120000, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', 'TASK_CLASS_NAME21', 'BACKUP', NULL, 1686552100000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', 'TASK_CLASS_NAME22', 'POLLING', NULL, 1686553200000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', 'TASK_CLASS_NAME23', 'POLLING', NULL, 1686553200000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', 'TASK_CLASS_NAME24', 'POLLING', NULL, 1686553200000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', 'TASK_CLASS_NAME25', 'POLLING', NULL, 1686553200000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', 'TASK_CLASS_NAME26', 'POLLING', NULL, 1686553200000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', 'TASK_CLASS_NAME27', 'POLLING', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME28', 'Automation', 'TASK_CLASS_NAME28', 'Automation', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, 1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME29', 'Automation', 'TASK_CLASS_NAME29', 'Automation', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1686552100000, -1, 5, 'PAUSED', 'CRON', 1686552090000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME30', 'SYSTEM', 'TASK_CLASS_NAME30', 'SYSTEM', NULL, 1686585900000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME31', 'POLLING', 'TASK_CLASS_NAME31', 'POLLING', NULL, 1686552480000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME32', 'POLLING', 'TASK_CLASS_NAME32', 'POLLING', NULL, 1686560400000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME33', 'POLLING', 'TASK_CLASS_NAME33', 'POLLING', NULL, 1686585603000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME34', 'POLLING', 'TASK_CLASS_NAME34', 'POLLING', NULL, 1686585604000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME35', 'POLLING', 'TASK_CLASS_NAME35', 'POLLING', NULL, 1686574800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME36', 'POLLING', 'TASK_CLASS_NAME36', 'POLLING', NULL, 1686567600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME37', 'POLLING', 'TASK_CLASS_NAME37', 'POLLING', NULL, 1686585605000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME38', 'POLLING', 'TASK_CLASS_NAME38', 'POLLING', NULL, 1686585600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME39', 'POLLING', 'TASK_CLASS_NAME39', 'POLLING', NULL, 1686564000000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME40', 'DEFAULT', 'TASK_CLASS_NAME40', 'DEFAULT', NULL, 1686567600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME41', 'POLLING', 'TASK_CLASS_NAME41', 'POLLING', NULL, 1686574800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME42', 'POLLING', 'TASK_CLASS_NAME42', 'POLLING', NULL, 1686578400000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME43', 'DEFAULT', 'TASK_CLASS_NAME43', 'DEFAULT', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME44', 'Automation', 'TASK_CLASS_NAME44', 'Automation', NULL, 1686621600000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME45', 'DEFAULT', 'TASK_CLASS_NAME45', 'DEFAULT', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME46', 'DEFAULT', 'TASK_CLASS_NAME46', 'DEFAULT', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME47', 'SYSTEM', 'TASK_CLASS_NAME47', 'SYSTEM', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME48', 'POLLING', 'TASK_CLASS_NAME48', 'POLLING', NULL, 1686596400000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME49', 'POLLING', 'TASK_CLASS_NAME49', 'POLLING', NULL, 1686556800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', 'TASK_CLASS_NAME5', 'POLLING', NULL, 1686585600000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, 1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME50', 'SYSTEM', 'TASK_CLASS_NAME50', 'SYSTEM', NULL, 1686585600000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME51', 'SYSTEM', 'TASK_CLASS_NAME51', 'SYSTEM', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME52', 'POLLING', 'TASK_CLASS_NAME52', 'POLLING', NULL, 1686567620000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME54', 'POLLING', 'TASK_CLASS_NAME54', 'POLLING', NULL, 1686657600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME55', 'SYSTEM', 'TASK_CLASS_NAME55', 'SYSTEM', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME56', 'Automation', 'TASK_CLASS_NAME56', 'Automation', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME57', 'DEFAULT', 'TASK_CLASS_NAME57', 'DEFAULT', NULL, 1686556800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME58', 'DEFAULT', 'TASK_CLASS_NAME58', 'DEFAULT', NULL, 1686556800000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME59', 'DEFAULT', 'TASK_CLASS_NAME59', 'DEFAULT', NULL, 1686552240000, 1686552180000, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', 'TASK_CLASS_NAME6', 'POLLING', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, 1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME61', 'DEFAULT', 'TASK_CLASS_NAME61', 'DEFAULT', NULL, 1686567600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME62', 'Automation', 'TASK_CLASS_NAME62', 'Automation', NULL, 1686596445000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME63', 'POLLING', 'TASK_CLASS_NAME63', 'POLLING', NULL, 1686596400000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME64', 'POLLING', 'TASK_CLASS_NAME64', 'POLLING', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME65', 'POLLING', 'TASK_CLASS_NAME65', 'POLLING', NULL, 1686621600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME66', 'POLLING', 'TASK_CLASS_NAME66', 'POLLING', NULL, 1686552240000, 1686552180000, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME67', 'POLLING', 'TASK_CLASS_NAME67', 'POLLING', NULL, 1686552240000, 1686552180000, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME68', 'SYSTEM', 'TASK_CLASS_NAME68', 'SYSTEM', NULL, 1686586200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME69', 'POLLING', 'TASK_CLASS_NAME69', 'POLLING', NULL, 1686571200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', 'TASK_CLASS_NAME7', 'POLLING', NULL, 1686578400000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME70', 'POLLING', 'TASK_CLASS_NAME70', 'POLLING', NULL, 1686578400000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME71', 'SYSTEM', 'TASK_CLASS_NAME71', 'SYSTEM', NULL, 1686553200000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME72', 'POLLING', 'TASK_CLASS_NAME72', 'POLLING', NULL, 1686552600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME73', 'Automation', 'TASK_CLASS_NAME73', 'Automation', NULL, 1686552600000, -1, 5, 'PAUSED', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME74', 'SYSTEM', 'TASK_CLASS_NAME74', 'SYSTEM', NULL, 1686552600000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME75', 'SYSTEM', 'TASK_CLASS_NAME75', 'SYSTEM', NULL, 1686589210000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME76', 'SYSTEM', 'TASK_CLASS_NAME76', 'SYSTEM', NULL, 1686589215000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME77', 'SYSTEM', 'TASK_CLASS_NAME77', 'SYSTEM', NULL, 1686585610000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME78', 'SYSTEM', 'TASK_CLASS_NAME78', 'SYSTEM', NULL, 1686585645000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME79', 'SYSTEM', 'TASK_CLASS_NAME79', 'SYSTEM', NULL, 1686552240000, 1686552180000, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', 'TASK_CLASS_NAME8', 'POLLING', NULL, 1686564000000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME80', 'POLLING', 'TASK_CLASS_NAME80', 'POLLING', NULL, 1686589245000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME81', 'POLLING', 'TASK_CLASS_NAME81', 'POLLING', NULL, 1686556830000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME82', 'POLLING', 'TASK_CLASS_NAME82', 'POLLING', NULL, 1686556820000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME83', 'DEFAULT', 'TASK_CLASS_NAME83', 'DEFAULT', NULL, 1686618000000, -1, 5, 'WAITING', 'CRON', 1686552091000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME84', 'POLLING', 'TASK_CLASS_NAME84', 'POLLING', NULL, 1686592810000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME85', 'POLLING', 'TASK_CLASS_NAME85', 'POLLING', NULL, 1686589245000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME86', 'POLLING', 'TASK_CLASS_NAME86', 'POLLING', NULL, 1686556830000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME87', 'POLLING', 'TASK_CLASS_NAME87', 'POLLING', NULL, 1686556820000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME88', 'DEFAULT', 'TASK_CLASS_NAME88', 'DEFAULT', NULL, 1686618000000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME89', 'POLLING', 'TASK_CLASS_NAME89', 'POLLING', NULL, 1686592810000, -1, 5, 'WAITING', 'CRON', 1686552092000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', 'TASK_CLASS_NAME9', 'POLLING', NULL, 1686552900000, -1, 5, 'WAITING', 'CRON', 1686552090000, 0, NULL, -1, '');

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config`  (
  `config_id` int NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '参数配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'admin', '2021-06-05 09:12:10', '5iot', '2022-01-20 10:31:41', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2021-06-05 09:12:10', '', NULL, '初始化密码 123456');
INSERT INTO `sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2021-06-05 09:12:10', '', NULL, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` VALUES (4, '连接管理解绑默认联系人', 'yunze.card.contactName', 'CeShi', 'Y', 'admin', '2021-07-31 09:17:58', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (5, '连接管理解绑联系人电话', 'yunze.card.contactPhone', '188888888', 'Y', 'admin', '2021-07-31 09:19:30', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (6, '购卡运费', 'yunze.web.byCardFare', '0.01', 'Y', 'admin', '2021-09-22 17:42:07', 'admin', '2021-09-24 13:45:46', '微信web端购卡运费');
INSERT INTO `sys_config` VALUES (7, '系统邮件抄送邮箱', 'yunze.ccConfig.Email', 'youxiang@5iot.cn', 'Y', 'admin', '2021-09-26 12:01:02', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (8, '系统邮件抄送邮箱密码', 'yunze.ccConfig.EmailPwd', 'fffff', 'Y', 'admin', '2021-09-26 12:01:58', '', NULL, '密码或者授权码');
INSERT INTO `sys_config` VALUES (9, '复机重试最大次数', 'MaixCount', '50', 'N', 'admin', '2021-11-15 14:58:40', 'admin', '2021-11-23 16:57:01', NULL);
INSERT INTO `sys_config` VALUES (10, '重启消费者轮序队列数量', 'polling.rebootStandard', '1000', 'N', 'admin', '2021-11-23 16:56:42', 'admin', '2021-11-27 13:40:22', NULL);
INSERT INTO `sys_config` VALUES (11, '重启停机阈值待销费标准', 'polling.rebootCardStop', '1', 'N', 'admin', '2021-11-27 13:40:08', 'admin', '2021-11-27 14:09:29', NULL);
INSERT INTO `sys_config` VALUES (12, '重启未订购停机待销费标准', 'polling.rebootCardDisconnected', '1', 'Y', 'admin', '2021-11-27 13:41:57', 'admin', '2021-11-27 14:09:34', NULL);
INSERT INTO `sys_config` VALUES (13, 'C端充值失败再次充值执行次数', 'yunze.card.IsStop', '10', 'Y', 'admin', '2021-12-27 10:26:40', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (14, '快到期', 'card.expiringSoonCount', '45', 'Y', 'admin', '2022-01-24 13:55:41', '', NULL, '45天到期卡号，用于首页判断相差多少天到期');
INSERT INTO `sys_config` VALUES (15, '首页数据缓存时间', 'IndexpageCacheTime', '15', 'Y', 'admin', '2022-01-25 16:59:01', '', NULL, '15 = 15分钟');

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept`  (
  `dept_id` bigint NOT NULL AUTO_INCREMENT,
  `parent_id` bigint NULL DEFAULT 0,
  `ancestors` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `dept_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `order_num` int NULL DEFAULT 0,
  `leader` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `phone` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0',
  `del_flag` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `create_time` datetime NULL DEFAULT NULL,
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `update_time` datetime NULL DEFAULT NULL,
  `dname` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `deposit_amount` double(10, 2) NULL DEFAULT NULL COMMENT '预存金额',
  `line_of_credit` double(10, 2) NULL DEFAULT NULL COMMENT '已授信额度',
  `profit_amount` double(10, 2) NULL DEFAULT NULL COMMENT '利润金额',
  `used_line_of_credit` double(10, 2) NULL DEFAULT NULL COMMENT '已使用授信额度',
  `be_usable_line_of_credit` double(10, 2) NULL DEFAULT NULL COMMENT '可使用授信额度',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 298 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES (100, 0, '0', '总集团', 0, '；；', '', NULL, '0', '0', 'admin', '2021-06-05 09:12:09', '5iot', '2022-08-31 10:06:28', '总集团', 91.00, NULL, NULL, NULL, NULL);
INSERT INTO `sys_dept` VALUES (266, 100, '0,100', '客户企业', 2, NULL, NULL, NULL, '0', '0', 'admin', '2022-04-30 09:47:44', 'admin', '2022-08-31 09:57:58', '客户企业', 100.00, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data`  (
  `dict_code` bigint NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int NULL DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 923 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
INSERT INTO `sys_dict_data` VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别男');
INSERT INTO `sys_dict_data` VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别女');
INSERT INTO `sys_dict_data` VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别未知');
INSERT INTO `sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '显示菜单');
INSERT INTO `sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '隐藏菜单');
INSERT INTO `sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '默认分组');
INSERT INTO `sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统分组');
INSERT INTO `sys_dict_data` VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统默认是');
INSERT INTO `sys_dict_data` VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统默认否');
INSERT INTO `sys_dict_data` VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知');
INSERT INTO `sys_dict_data` VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '公告');
INSERT INTO `sys_dict_data` VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '关闭状态');
INSERT INTO `sys_dict_data` VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '新增操作');
INSERT INTO `sys_dict_data` VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '修改操作');
INSERT INTO `sys_dict_data` VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '删除操作');
INSERT INTO `sys_dict_data` VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '授权操作');
INSERT INTO `sys_dict_data` VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '导出操作');
INSERT INTO `sys_dict_data` VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '导入操作');
INSERT INTO `sys_dict_data` VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '强退操作');
INSERT INTO `sys_dict_data` VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '生成操作');
INSERT INTO `sys_dict_data` VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '清空操作');
INSERT INTO `sys_dict_data` VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (100, 0, '中国移动', '1', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:49:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (101, 1, '中国联通', '2', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (102, 2, '中国电信', '3', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:18', 'admin', '2021-06-05 10:51:06', NULL);
INSERT INTO `sys_dict_data` VALUES (103, 3, '其他', '4', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:42', 'admin', '2021-06-05 10:51:10', NULL);
INSERT INTO `sys_dict_data` VALUES (104, 0, '卡号', '1', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 09:21:09', 'admin', '2021-06-07 09:22:33', '卡号查询 vid/msisdn/iccid/imsi');
INSERT INTO `sys_dict_data` VALUES (105, 0, '备注', '2', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 09:22:29', '', NULL, '卡板备注');
INSERT INTO `sys_dict_data` VALUES (106, 1, '开卡日期', '1', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:05', 'admin', '2022-01-24 09:52:03', NULL);
INSERT INTO `sys_dict_data` VALUES (107, 2, '激活日期', '2', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:35', 'admin', '2022-01-24 09:52:19', NULL);
INSERT INTO `sys_dict_data` VALUES (108, 3, '入库日期', '3', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:50', 'admin', '2022-01-24 09:52:23', NULL);
INSERT INTO `sys_dict_data` VALUES (109, 0, '正常', '0', 'yunze_card_deltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:26:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (110, 0, '已删除', '1', 'yunze_card_deltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:26:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (111, 1, '移动', '1', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:06', 'admin', '2021-06-07 16:15:24', NULL);
INSERT INTO `sys_dict_data` VALUES (112, 2, '联通', '2', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:15', 'admin', '2021-06-07 16:15:27', NULL);
INSERT INTO `sys_dict_data` VALUES (113, 3, '电信', '3', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (114, 4, '全网通', '4', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:16:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (115, 3, '单项停机', '3', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:20', 'admin', '2021-06-09 10:16:03', NULL);
INSERT INTO `sys_dict_data` VALUES (116, 1, '正常', '1', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (117, 2, '停机', '2', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (118, 4, '预销号', '4', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (119, 5, '过户', '5', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (120, 6, '休眠', '6', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (121, 7, '待激活', '7', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (122, 8, '未知', '8', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (123, 9, '测试期正常', '9', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (124, 10, '测试期停机', '10', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (125, 11, '停机保号', '11', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (126, 12, '机卡分离停机', '12', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (127, 13, '空套餐', '13', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:32:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (128, 1, '当月生效', '1', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:55:50', 'admin', '2021-06-22 11:14:16', NULL);
INSERT INTO `sys_dict_data` VALUES (129, 2, '次月生效', '2', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:56:18', 'admin', '2021-06-22 11:14:20', NULL);
INSERT INTO `sys_dict_data` VALUES (130, 3, '周期延顺', '3', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:58:17', 'admin', '2021-06-22 11:14:23', NULL);
INSERT INTO `sys_dict_data` VALUES (131, 0, '已失效', '0', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:01:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (132, 0, '生效中', '1', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:01:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (133, 1, '微信支付', 'wx', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:02:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (134, 2, '余额支付', 'be', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:03:39', 'admin', '2021-06-09 09:03:45', NULL);
INSERT INTO `sys_dict_data` VALUES (135, 4, '人工操作', 'al', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:04:28', 'admin', '2021-08-06 10:55:23', NULL);
INSERT INTO `sys_dict_data` VALUES (136, 0, '否', '0', 'yunze_customize_whether', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:07:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (137, 1, '是', '1', 'yunze_customize_whether', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:07:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (138, 1, '普通贴片MS0 5mm*6mm', '1', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:52:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (139, 2, '普通SIM卡MS0 5mm*6mm', '2', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:52:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (140, 1, 'NB', '1', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:53:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (141, 2, '4G SIM', '2', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:53:52', 'admin', '2021-06-10 08:54:09', NULL);
INSERT INTO `sys_dict_data` VALUES (142, 3, '5G SIM', '3', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:54:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (143, 1, '离线', '00', 'yunze_card_online_status', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:01:14', 'admin', '2021-06-10 14:01:22', 'EC');
INSERT INTO `sys_dict_data` VALUES (144, 2, '在线', '01', 'yunze_card_online_status', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:01:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (145, 1, '3G', '1', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:02:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (146, 2, '2G', '2', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:02:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (147, 6, '4G', '6', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:03:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (148, 8, 'NB', '8', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:03:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (149, 1, '虚拟编号', '1', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (150, 2, 'MSISDN', '2', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:45', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (151, 3, 'ICCID', '3', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (152, 4, 'IMSI', '4', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:18:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (153, 1, '通道名称', '2', 'yunze_channel_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-19 12:22:37', 'admin', '2021-06-21 08:40:22', NULL);
INSERT INTO `sys_dict_data` VALUES (154, 1, '升序', '1', 'ORDER_BY_rule', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:32:30', '', NULL, 'ASC');
INSERT INTO `sys_dict_data` VALUES (155, 2, '倒叙', '2', 'ORDER_BY_rule', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:32:41', '', NULL, 'DESC');
INSERT INTO `sys_dict_data` VALUES (156, 1, '创建时间', '1', 'channel_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:34:42', '', NULL, 'createTime');
INSERT INTO `sys_dict_data` VALUES (157, 2, '通道编号', '2', 'channel_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:34:58', '', NULL, 'cd_code');
INSERT INTO `sys_dict_data` VALUES (158, 1, '启用', '1', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:41:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (159, 2, '停用', '2', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:42:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (160, 3, '已删除', '3', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:42:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (161, 1, '中国移动', 'YiDong_EC', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:46:59', '', NULL, '移动EC新平台');
INSERT INTO `sys_dict_data` VALUES (162, 2, '中国电信', 'DianXin_CMP', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:47:40', 'admin', '2021-06-19 14:48:41', '电信CMP');
INSERT INTO `sys_dict_data` VALUES (163, 4, '中国联通', 'LianTong_CMP', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:48:27', '', NULL, '中国联通 CMP');
INSERT INTO `sys_dict_data` VALUES (164, 3, '全球电信', 'DianXin_DCP', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:49:19', '', NULL, 'DianXin_DCP');
INSERT INTO `sys_dict_data` VALUES (165, 0, '通道别名', '3', 'yunze_channel_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 08:40:15', 'admin', '2021-06-21 08:40:27', NULL);
INSERT INTO `sys_dict_data` VALUES (166, 1, '任务名', '1', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:30:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (167, 2, '创建人', '2', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:30:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (168, 3, '下载地址', '3', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:31:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (169, 1, '创建时间', '1', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:40:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (170, 2, '任务名', '2', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:40:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (171, 3, '修改时间', '3', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:41:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (172, 1, '连接管理导入', '_CardImport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:17:45', 'admin', '2021-07-28 12:19:58', NULL);
INSERT INTO `sys_dict_data` VALUES (173, 2, '连接管理导出', '_CardOut', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:17:54', 'admin', '2021-07-28 12:20:05', NULL);
INSERT INTO `sys_dict_data` VALUES (174, 3, '上游通道导出', '_ChannelOut', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (175, 1, '月', '1', 'yunze_packet_valid_name', NULL, NULL, 'N', '0', 'admin', '2021-06-22 16:20:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (176, 2, '年', '2', 'yunze_packet_valid_name', NULL, NULL, 'N', '0', 'admin', '2021-06-22 16:20:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (177, 1, '资费组名称', '1', 'yunze_tariffGroup_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:15:27', 'admin', '2021-06-22 17:35:27', NULL);
INSERT INTO `sys_dict_data` VALUES (178, 2, '平台资费组名称', '2', 'yunze_tariffGroup_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:15:41', 'admin', '2021-06-22 17:40:30', NULL);
INSERT INTO `sys_dict_data` VALUES (179, 1, '资费计划名称', '1', 'yunze_tariffPlan_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (180, 2, '平台计划名称', '2', 'yunze_tariffPlan_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:18:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (181, 1, '金额充值', '1', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:50:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (182, 2, '用量充值', '2', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:51:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (183, 0, '未支付', '0', 'yunze_order_status', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:52:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (184, 1, '支付成功', '1', 'yunze_order_status', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:52:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (185, 4, '激活生效', '4', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 11:35:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (186, 2, '未生效', '2', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 11:36:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (188, 14, '运营商管理状态', '14', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-06 15:44:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (189, 3, '轮询任务', 'POLLING', 'sys_job_group', NULL, NULL, 'N', '0', 'admin', '2021-07-07 15:23:51', 'admin', '2021-11-12 09:32:39', NULL);
INSERT INTO `sys_dict_data` VALUES (190, 1, '激活时间-高频', '1', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:20:36', 'admin', '2022-03-09 14:36:14', '无激活时间才获取激活时间');
INSERT INTO `sys_dict_data` VALUES (191, 2, '卡状态-高频', '2', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:25:02', 'admin', '2022-03-09 13:35:27', NULL);
INSERT INTO `sys_dict_data` VALUES (192, 3, '用量轮序-高频', '3', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:26:05', 'admin', '2022-03-09 08:53:08', NULL);
INSERT INTO `sys_dict_data` VALUES (193, 3, '工业贴片MS1 5mm*6mm', '3', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-07-09 09:12:57', 'admin', '2021-08-05 08:26:02', 'NB贴片');
INSERT INTO `sys_dict_data` VALUES (194, 15, '测试去激活', '15', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 09:06:00', 'admin', '2021-07-16 09:06:16', '电信CMP');
INSERT INTO `sys_dict_data` VALUES (195, 16, '拆机', '16', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 09:08:06', '', NULL, '电信CMP');
INSERT INTO `sys_dict_data` VALUES (196, 17, '可测试', '17', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 14:16:08', 'admin', '2021-07-16 14:16:14', NULL);
INSERT INTO `sys_dict_data` VALUES (199, 18, '销号', '18', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-21 15:41:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (200, 19, '库存', '19', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-21 15:43:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (202, 4, '达量停机', '4', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-23 17:35:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (203, 1, '连接管理导出', '1', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:36:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (204, 2, '连接管理划卡', '2', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:36:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (205, 3, '连接管理导入', '3', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:44:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (206, 4, '上游通道导出', '4', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:45:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (207, 4, '连接管理划卡', '_CardDistribute', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-07-28 12:20:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (208, 5, '连接管理划卡备份', '_CardDistributeBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-07-28 13:04:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (210, 20, '违章停机', '20', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-31 14:37:07', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (211, 21, '断网', '21', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-31 15:16:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (212, 22, '开始', '22', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:17:24', '', NULL, '联通CMP');
INSERT INTO `sys_dict_data` VALUES (213, 23, '已失效', '23', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:25', '', NULL, '联通CMP');
INSERT INTO `sys_dict_data` VALUES (214, 24, '已清除', '24', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:45', 'admin', '2021-08-02 09:22:09', '联通CMP');
INSERT INTO `sys_dict_data` VALUES (215, 25, '已更换', '25', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:53', 'admin', '2021-08-02 09:22:06', '联通CMP');
INSERT INTO `sys_dict_data` VALUES (216, 4, '工业插拔', '4', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-08-05 08:25:50', 'admin', '2021-08-05 08:26:35', 'NB插拔');
INSERT INTO `sys_dict_data` VALUES (218, 2, '订单号', '2', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:48:36', 'admin', '2021-08-09 09:46:32', NULL);
INSERT INTO `sys_dict_data` VALUES (219, 3, '交易名称', '3', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:48:51', 'admin', '2021-08-09 09:46:47', NULL);
INSERT INTO `sys_dict_data` VALUES (220, 4, '微信订单号', '4', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:49:08', 'admin', '2021-08-09 09:46:52', NULL);
INSERT INTO `sys_dict_data` VALUES (221, 1, 'ICCID', '1', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:49:22', 'admin', '2021-08-09 09:46:37', NULL);
INSERT INTO `sys_dict_data` VALUES (222, 0, '平台记录', 's', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:55:00', 'admin', '2021-08-06 10:55:16', NULL);
INSERT INTO `sys_dict_data` VALUES (223, 1, '系统', 'sys', 'yunze_order_creType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:58:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (224, 2, '人工', 'ai', 'yunze_order_creType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (225, 1, '否', '0', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:02:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (226, 3, '比例', '1', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:03:11', 'admin', '2021-08-06 11:03:51', NULL);
INSERT INTO `sys_dict_data` VALUES (227, 2, '差价', '2', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:03:22', 'admin', '2021-08-06 11:03:41', NULL);
INSERT INTO `sys_dict_data` VALUES (228, 5, '备注', '5', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:07:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (229, 1, '创建时间', '1', 'yunze_order_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:44:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (230, 2, '加包时间', '2', 'yunze_order_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:44:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (231, 1, 'ICCID', '1', 'yunze_order_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-08-06 17:41:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (233, 5, '平台批量充值', '5', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-12 16:13:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (234, 6, '平台资费订购', '_importRecharge', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-13 13:48:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (235, 6, '连接管理设置', '6', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-18 11:57:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (236, 7, '连接设置详情', '_CardImportSet', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-18 11:59:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (237, 8, '连接管理设置备份', '_CardImportSetBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-18 12:00:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (238, 4, '备份任务', 'BACKUP', 'sys_job_group', NULL, NULL, 'N', '0', 'admin', '2021-08-18 17:25:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (239, 9, 'imei查询', '_CardImportSelImei', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-20 16:36:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (240, 7, '特殊操作 查询imie', '7', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-20 16:37:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (241, 0, '基础资费', '0', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-01 16:05:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (242, 1, '叠加资费', '1', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-01 16:05:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (243, 0, '仅一次', '0', 'yunze_base_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-03 15:31:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (244, 1, '可叠加', '1', 'yunze_base_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-03 15:31:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (245, 3, '请求参数', '4', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:49:25', '', NULL, '请求参数');
INSERT INTO `sys_dict_data` VALUES (246, 4, '响应参数', '5', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:49:52', '', NULL, '响应参数');
INSERT INTO `sys_dict_data` VALUES (247, 5, '操作名称', '6', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:50:20', '', NULL, '操作名称');
INSERT INTO `sys_dict_data` VALUES (248, 1, 'iotapi', 'iotapi', 'yz_sys_logs_project', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:51:45', 'admin', '2021-08-24 12:02:16', NULL);
INSERT INTO `sys_dict_data` VALUES (249, 0, '对应串号', '1', 'dosage_details_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:14:59', '', NULL, '对应串号');
INSERT INTO `sys_dict_data` VALUES (250, 0, '创建时间', '1', 'yunze_yz_card_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:44:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (251, 1, '修改时间', '2', 'yunze_yz_card_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:44:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (252, 1, '创建时间', '0', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 11:39:48', '', NULL, '通道进度创建时间');
INSERT INTO `sys_dict_data` VALUES (253, 2, '修改时间', '1', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 11:40:25', '', NULL, '通道进度修改时间');
INSERT INTO `sys_dict_data` VALUES (254, 1, '轮序批次编码', '0', 'yz_passageway_polling', NULL, NULL, 'N', '0', 'admin', '2021-08-31 14:05:46', 'admin', '2021-09-01 10:11:19', NULL);
INSERT INTO `sys_dict_data` VALUES (255, 3, '同步时间', '2', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 14:13:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (257, 1, 'iccid', '0', 'yunze_sorting_rules', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:34:33', '', NULL, '排序规则iccid');
INSERT INTO `sys_dict_data` VALUES (258, 1, '创建时间', '0', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:54:40', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (259, 2, '生效时间', '1', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:05', '', NULL, '生效时间');
INSERT INTO `sys_dict_data` VALUES (260, 3, '到期时间', '2', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:23', '', NULL, '到期时间');
INSERT INTO `sys_dict_data` VALUES (261, 4, '更新累计包时间', '3', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:48', '', NULL, '更新累计包时间');
INSERT INTO `sys_dict_data` VALUES (262, 1, '升序', '0', 'Lifting_sequence', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:01:04', '', NULL, '升序');
INSERT INTO `sys_dict_data` VALUES (263, 2, '降序', '1', 'Lifting_sequence', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:01:19', '', NULL, '降序');
INSERT INTO `sys_dict_data` VALUES (264, 1, '订单号', '0', 'yz_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:23:41', '', NULL, '订购资费订单号');
INSERT INTO `sys_dict_data` VALUES (265, 2, '对应串号', '1', 'yz_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:25:29', '', NULL, '订购资费对应串号');
INSERT INTO `sys_dict_data` VALUES (266, 1, '创建时间', '0', 'yunze_syslogs_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-24 08:55:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (267, 0, '请求url', '1', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:46:33', '', NULL, '请求url');
INSERT INTO `sys_dict_data` VALUES (268, 1, '执行的类方法', '2', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:47:19', 'admin', '2021-08-24 10:47:54', NULL);
INSERT INTO `sys_dict_data` VALUES (269, 2, 'ip', '3', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:48:30', 'admin', '2021-08-24 10:48:45', NULL);
INSERT INTO `sys_dict_data` VALUES (270, 1, '生命周期', '1', 'yz_cardChange_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:39:11', 'admin', '2021-09-14 09:39:25', NULL);
INSERT INTO `sys_dict_data` VALUES (271, 2, '断开网状态', '2', 'yz_cardChange_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:39:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (272, 1, '达量停机', '1', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:41:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (273, 2, '未订购轮询停机', '2', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:41:48', 'admin', '2021-09-14 14:53:39', NULL);
INSERT INTO `sys_dict_data` VALUES (274, 3, '手动变更', '3', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (275, 4, 'C端充值', '4', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (276, 5, '批量操作', '5', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (277, 5, '未订购资费断网', '5', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 10:16:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (278, 1, '正常', '1', 'yz_cardConnection_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 11:41:44', 'admin', '2021-09-14 11:42:04', NULL);
INSERT INTO `sys_dict_data` VALUES (279, 2, '断网', '2', 'yz_cardConnection_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 11:41:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (280, 1, '成功', '1', 'yz_cardChange_ExecutionStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-15 08:38:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (281, 2, '失败', '2', 'yz_cardChange_ExecutionStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-15 08:38:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (282, 1, '虚拟编号', '0', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:00', '', NULL, '卡号类别虚拟编号');
INSERT INTO `sys_dict_data` VALUES (283, 2, 'MSISDN', '1', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (284, 3, 'ICCID', '2', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (285, 4, 'IMSI', '3', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (287, 26, '用户注销', '26', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:51:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (288, 27, '停断网', '27', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:52:19', 'admin', '2021-10-11 15:58:07', '欠停');
INSERT INTO `sys_dict_data` VALUES (289, 28, '挂失', '28', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:53:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (290, 29, '故障卡', '29', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:54:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (291, 30, '未实名停机', '30', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:54:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (292, 31, '超量停机', '31', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:58:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (293, 32, '停机保号', '32', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:59:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (294, 33, '已锁定', '33', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 16:00:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (295, 3, '商品购买', '3', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-09-23 12:46:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (296, 99, '购买下单邮件推送', '99', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 14:53:03', 'admin', '2021-09-24 15:15:31', NULL);
INSERT INTO `sys_dict_data` VALUES (297, 1, '卡状态变更', '1', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 14:53:14', 'admin', '2021-09-24 15:16:06', NULL);
INSERT INTO `sys_dict_data` VALUES (298, 2, '单卡有效期', '2', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:16:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (299, 3, '单卡用量', '3', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:16:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (300, 1, '邮件推送', '1', 'yz_cc_execution_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:21:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (301, 2, 'API推送', '2', 'yz_cc_execution_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:31:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (302, 1, '正常', '1', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (303, 2, '已停用', '2', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (304, 3, '已删除', '3', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (305, 1, '默认', '1', 'yz_cc_template', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:34:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (306, 0, '待发货', '0', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:10:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (307, 1, '备货中', '1', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:10:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (308, 2, '已发货', '2', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:10:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (309, 3, '运输中', '3', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:11:13', 'admin', '2021-09-26 12:11:27', NULL);
INSERT INTO `sys_dict_data` VALUES (310, 4, '代签收', '4', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:11:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (311, 5, '已签收', '5', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:11:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (312, 6, '拒收', '6', 'yz_orderShopping_Ship', NULL, NULL, 'N', '0', 'admin', '2021-09-26 12:12:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (313, 0, '待处理', '0', 'yz_cc_HisStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:03:54', 'admin', '2021-09-26 17:04:01', NULL);
INSERT INTO `sys_dict_data` VALUES (314, 1, '已处理', '1', 'yz_cc_HisStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:04:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (315, 0, '失败', '0', 'yz_cc_result', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:06:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (316, 1, '成功', '1', 'yz_cc_result', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:06:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (317, 0, '已废弃', '0', 'yz_enabled_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 14:52:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (318, 1, '正常', '1', 'yz_enabled_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 14:52:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (319, 0, '下架', '0', 'yz_commodity_sell', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:04:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (320, 1, '售卖中', '1', 'yz_commodity_sell', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:04:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (321, 0, '未审核', '0', 'yz_check_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:06:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (322, 1, '已审核', '1', 'yz_check_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:06:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (323, 1, '不操作', '1', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (324, 2, '停机', '2', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (325, 3, '复机', '3', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (326, 1, '不操作', '1', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (327, 2, '断网', '2', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (328, 3, '开网', '3', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (329, 1, 'ICCID', '1', 'yz_card_info_change', NULL, NULL, 'N', '0', 'admin', '2021-09-29 19:54:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (330, 1, '正常', '1', 'yz_customer_state', NULL, NULL, 'N', '0', 'admin', '2021-10-11 15:55:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (331, 2, '已停用', '2', 'yz_customer_state', NULL, NULL, 'N', '0', 'admin', '2021-10-11 15:56:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (332, 1, '自有2021年前含老客户', '1', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:05:53', 'admin', '2021-10-11 16:06:20', NULL);
INSERT INTO `sys_dict_data` VALUES (333, 2, '自有2022年起新客户', '2', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:06:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (334, 99, '其他', '99', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:06:36', 'admin', '2021-10-11 16:06:47', NULL);
INSERT INTO `sys_dict_data` VALUES (335, 1, 'A', '1', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:07', '', NULL, 'VIP');
INSERT INTO `sys_dict_data` VALUES (336, 2, 'B', '2', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (337, 3, 'C', '3', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (338, 4, 'D', '4', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (339, 99, '其他', '99', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (340, 10, '卡分组备注更新', '_CardSetCardInfo', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (341, 14, '卡分组备注更新备份', '_CardSetCardInfoBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:20', 'admin', '2021-12-24 15:47:40', NULL);
INSERT INTO `sys_dict_data` VALUES (342, 8, '特殊操作 变更卡分组、备注', '8', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (347, 1, '终端', '1', 'yz_customer_grade_one', NULL, NULL, 'N', '0', 'admin', '2021-10-29 16:09:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (348, 1, '直客', '1', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (349, 2, '生产厂家', '2', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (350, 11, '分销商', '11', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (351, 12, '贸易商', '12', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (352, 2, '代理', '2', 'yz_customer_grade_one', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:18:29', 'admin', '2021-10-30 14:18:35', NULL);
INSERT INTO `sys_dict_data` VALUES (353, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:25:31', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (354, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:28:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (355, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:30:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (356, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:30:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (357, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:38:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (358, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (359, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (360, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (361, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (362, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:40:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (363, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:41:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (364, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:42:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (365, 1, '学生', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:44:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (366, 1, '123', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:00:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (367, 1, '创建时间', '1', 'Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:40:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (368, 1, '无', '1', 'yz_cc_condition', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:59:29', 'admin', '2021-10-25 15:59:34', NULL);
INSERT INTO `sys_dict_data` VALUES (369, 1, '判断条件', '1', 'cc_query_criteria', NULL, NULL, 'N', '0', 'admin', '2021-10-26 10:01:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (370, 1, '最后修改时间', '1', 'prdCategory_timet', NULL, NULL, 'N', '0', 'admin', '2021-10-29 15:33:27', 'admin', '2021-10-29 15:33:48', NULL);
INSERT INTO `sys_dict_data` VALUES (371, 1, '创建时间', '1', 'yunze_task_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-10-29 16:11:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (372, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:30:24', '', NULL, '自动化 创建时间 类型');
INSERT INTO `sys_dict_data` VALUES (373, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:31:46', '', NULL, '自动化创建类型');
INSERT INTO `sys_dict_data` VALUES (374, 1, '创建时间', '0', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:32:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (375, 0, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:34:03', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (376, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-19 16:33:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (377, 0, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-19 16:35:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (378, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 09:52:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (379, 1, '创建时间', '0', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 09:55:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (380, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 13:38:57', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (381, 1, '客户名称', '1', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:26:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (382, 2, '税号', '2', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:26:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (383, 3, '地址详情', '3', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:27:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (384, 0, '创建时间', '0', 'yz_customer_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:28:55', 'admin', '2021-11-04 16:29:49', NULL);
INSERT INTO `sys_dict_data` VALUES (385, 1, '最后修改时间', '1', 'yz_customer_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:29:26', 'admin', '2021-11-04 16:29:53', NULL);
INSERT INTO `sys_dict_data` VALUES (386, 1, '是否回收', '1', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (387, 2, '合伙人费率', '2', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (388, 3, '销售费率', '3', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (389, 4, '售后费率', '4', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (390, 5, '所属合伙人', '5', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:05:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (391, 6, '所属销售', '6', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:06:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (392, 1, '企业', '1', 'yz_CustomerSort_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 15:56:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (393, 2, '个人', '2', 'yz_CustomerSort_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 15:56:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (394, 2, '平台仅一次', '2', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-11-09 16:51:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (395, 9, '月初复机操作', '9', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-09 10:30:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (396, 6, '月初已订购复机', '6', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-11-09 14:46:47', '', NULL, '月初有流量的卡进行复机');
INSERT INTO `sys_dict_data` VALUES (397, 10, 'C端充值变更失败再次复机', '10', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-10 13:46:58', '', NULL, 'C端充值 轮询 卡状态变更失败的 进行再次 复机；（前提是没用完用量）');
INSERT INTO `sys_dict_data` VALUES (398, 7, 'C端充值变更失败再次复机', '7', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-11-11 11:32:03', '', NULL, 'C端充值 轮询 卡状态变更失败的 进行再次 复机；（前提是没用完用量）');
INSERT INTO `sys_dict_data` VALUES (399, 13, '腾宇', 'TenngYu', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-11-22 13:32:21', '', NULL, '腾宇接口');
INSERT INTO `sys_dict_data` VALUES (400, 15, '中国移动ECV2', 'YiDong_ECv2', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-11-29 12:06:53', 'admin', '2021-11-29 12:07:11', 'pboss');
INSERT INTO `sys_dict_data` VALUES (401, 1, '是', '1', 'buttonyesno', NULL, NULL, 'N', '0', 'admin', '2021-11-11 21:26:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (402, 2, '否', '2', 'buttonyesno', NULL, NULL, 'N', '0', 'admin', '2021-11-11 21:26:53', 'admin', '2021-11-12 16:07:02', NULL);
INSERT INTO `sys_dict_data` VALUES (407, 11, '全部订单导出', '11', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-23 15:26:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (408, 10, '订单管理导出', '_Exportallorders', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-11-24 13:32:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (409, 12, '购物订单导出', '12', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-25 10:03:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (410, 13, '购物订单导出', '_Shoppingexport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-11-25 10:10:07', 'admin', '2021-12-24 15:47:36', NULL);
INSERT INTO `sys_dict_data` VALUES (411, 4, '发货日期', '4', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-11-25 16:04:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (412, 1, '中移物联', '1', 'yz_Commodity_supplier', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:14:31', 'admin', '2022-04-03 09:30:43', NULL);
INSERT INTO `sys_dict_data` VALUES (413, 2, '中国移动', '2', 'yz_Commodity_supplier', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:14:59', 'admin', '2022-04-03 09:30:31', NULL);
INSERT INTO `sys_dict_data` VALUES (414, 1, '中国移动', '1', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (415, 2, '中国联通', '2', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (416, 3, '中国电信', '3', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (417, 1, '商品名称', '1', 'yz_Bcommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:29:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (418, 1, '分类名称', '1', 'yz_BcommoditySort_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:32:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (419, 1, '名称', '1', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:26', 'admin', '2021-12-06 16:44:48', NULL);
INSERT INTO `sys_dict_data` VALUES (420, 2, '型号', '2', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (421, 3, '备注', '3', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (422, 0, '已删除', '0', 'yz_Universal_delete', NULL, NULL, 'N', '0', 'admin', '2021-12-07 09:51:55', 'admin', '2021-12-07 09:52:06', NULL);
INSERT INTO `sys_dict_data` VALUES (423, 1, '正常', '1', 'yz_Universal_delete', NULL, NULL, 'N', '0', 'admin', '2021-12-07 09:52:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (424, 0, '不分润', '0', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 14:38:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (425, 1, '正常分润', '1', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:11:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (426, 2, '合伙人分润', '2', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:12:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (427, 3, '销售分润', '3', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:12:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (428, 4, '售后分润', '4', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:20:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (429, 5, '合伙人+销售分润', '5', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:21:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (430, 6, '合伙人+售后分润', '6', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:21:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (431, 7, '销售+售后分润', '7', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:22:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (432, 0, '不开票', '0', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:38:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (433, 1, '增值票', '1', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:39:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (434, 2, '普通票', '2', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:39:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (435, 1, '已申请', '1', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (436, 2, '待发货', '2', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (437, 3, '待出库', '3', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (438, 4, '已完成', '4', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:50:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (439, 99, '作废', '99', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:51:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (440, 0, '未打款', '0', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:08:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (441, 1, '部分到款', '1', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:08:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (442, 3, '已收款', '3', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:09:12', 'admin', '2021-12-10 18:09:21', NULL);
INSERT INTO `sys_dict_data` VALUES (443, 1, '客户名称', '1', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:43:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (444, 2, '甲方代表', '2', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:43:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (445, 3, '合同金额', '3', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:44:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (446, 4, '备注', '4', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:49:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (447, 1, '创建时间', '1', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:51:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (448, 2, '修改时间', '2', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:52:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (449, 0, '合同日期', '0', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:52:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (450, 1, '现金', '1', 'cwgl_Deposit_type', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:05:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (451, 1, '未到款', '1', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (452, 2, '有尾款', '2', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (453, 3, '已到款', '3', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (454, 1, '未发', '1', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:44:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (455, 2, '未发全', '2', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:44:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (456, 3, '已发', '3', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:53:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (457, 1, '销售合同', '1', 'DepositSource_type', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:57:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (458, 1, '合同开票', '1', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (459, 2, '预付开票', '2', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (460, 3, '代开票', '3', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (461, 1, '销售订单', '1', 'contract_nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 09:02:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (462, 2, '临时订单', '2', 'contract_nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 09:02:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (464, 1, '客户名称', '1', 'yunze_OrderDelivery_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-14 12:28:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (465, 1, '预计发货时间', '1', 'yunze_OrderDelivery_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-14 13:28:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (466, 2, '合同创建时间', '2', 'yunze_OrderDelivery_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-14 13:52:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (467, 1, '临时订单', '1', 'Delivery_selection_type', NULL, NULL, 'N', '1', 'admin', '2021-12-14 15:58:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (468, 2, '合同发货', '2', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (469, 3, '普通发货', '3', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (470, 4, '发票发货', '4', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (471, 5, '其他发货', '5', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (472, 1, '快递', '1', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (473, 2, '物流', '2', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (474, 3, '送货', '3', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (475, 4, '自取', '4', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (476, 5, '其他', '5', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (477, 1, '合同发货', '1', 'Delivery_type', NULL, NULL, 'N', '0', 'admin', '2021-12-15 09:23:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (478, 2, '其他发货', '2', 'Delivery_type', NULL, NULL, 'N', '0', 'admin', '2021-12-15 09:23:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (479, 1, '寄付', '1', 'Shipping_method', NULL, NULL, 'N', '0', 'admin', '2021-12-15 10:27:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (480, 2, '到付', '2', 'Shipping_method', NULL, NULL, 'N', '0', 'admin', '2021-12-15 10:27:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (481, 1, '客户名称', '1', 'yunze_ShippingApplication_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:16:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (482, 2, '发货人姓名', '2', 'yunze_ShippingApplication_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:17:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (483, 1, '申请发货日期', '1', 'yunze_ShippingApplication_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:18:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (484, 2, '数据修改时间', '2', 'yunze_ShippingApplication_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:18:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (485, 1, '单位', '1', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (486, 2, '收件人', '2', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (487, 3, '快递编号', '3', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:52', 'admin', '2021-12-23 16:28:22', NULL);
INSERT INTO `sys_dict_data` VALUES (488, 1, '发货日期', '1', 'yunze_ExpressInquiry_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:09:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (489, 2, '收件日期', '2', 'yunze_ExpressInquiry_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:09:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (490, 1, '未收', '1', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (491, 2, '已收', '2', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (492, 3, '退回', '3', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (493, 1, '未评价', '1', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (494, 2, '正常', '2', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (495, 3, '慢', '3', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (496, 4, '损坏', '4', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (497, 5, '丢件', '5', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:17:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (498, 4, '快递单号', '4', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 16:28:30', 'admin', '2021-12-23 16:29:38', NULL);
INSERT INTO `sys_dict_data` VALUES (499, 1, '库存', '1', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (500, 2, '可测试', '2', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:42', 'admin', '2021-12-24 10:51:47', NULL);
INSERT INTO `sys_dict_data` VALUES (501, 3, '待激活', '3', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (502, 4, '已激活', '4', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (503, 5, '已停机', '5', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (504, 6, '预销户', '6', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (505, 7, '已销户', '7', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (506, 8, '未知', '8', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (507, 11, '批量同步用量', '_Consumption', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:47:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (508, 15, '批量-同步状态', '_PublicMethod', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:48:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (509, 16, '批量-同步状态和用量', '_ConsumptionAndState', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:48:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (510, 17, '批量-停机', '_Stopped', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:49:01', 'admin', '2021-12-24 16:06:45', NULL);
INSERT INTO `sys_dict_data` VALUES (511, 18, '批量-复机', '_Machine', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:49:20', 'admin', '2021-12-24 16:06:50', NULL);
INSERT INTO `sys_dict_data` VALUES (512, 19, '批量-断网', '_DisconnectNetwork', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:50:56', 'admin', '2021-12-24 16:06:54', NULL);
INSERT INTO `sys_dict_data` VALUES (513, 20, '批量-开网', '_OpenNetwork', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:52:00', 'admin', '2021-12-24 16:06:59', NULL);
INSERT INTO `sys_dict_data` VALUES (514, 21, '批量变更', '_CardChangeInfo', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 16:07:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (515, 1, '箱号', '1', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (516, 2, '盘号', '2', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (517, 3, '产品编码', '3', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (518, 4, '序列号', '4', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (519, 5, '批号', '5', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (520, 6, '卷盘号', '6', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (521, 7, 'MAC', '7', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (522, 8, '设备码', '8', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (523, 9, '串号', '9', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (524, 10, 'SN', '10', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (525, 11, '原SN', '11', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (526, 12, 'ICCID', '12', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (527, 13, 'IMSI', '13', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (528, 14, 'IMEI', '14', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (529, 15, 'CMEI', '15', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (530, 16, '所属入库编号', '16', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:01:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (531, 1, '创建日期', '1', 'yunze_inventorydetails_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:04:05', 'admin', '2021-12-28 11:04:29', NULL);
INSERT INTO `sys_dict_data` VALUES (532, 2, '入库日期', '2', 'yunze_inventorydetails_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:04:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (533, 1, '箱号', '1', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (534, 2, '盘号', '2', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (535, 3, '产品编码', '3', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (536, 4, '序列号', '4', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (537, 5, '批号', '5', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (538, 6, '卷盘号', '6', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (539, 7, 'MAC', '7', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (540, 8, '设备码', '8', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (541, 9, '串号', '9', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (542, 10, 'SN', '10', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (543, 11, '原SN', '11', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (544, 12, 'ICCID', '12', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (545, 13, 'IMSI', '13', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (546, 14, 'IMEI', '14', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (547, 15, 'CMEI', '15', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (548, 1, '商品名称', '1', 'yunze_CustomerInquiries_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 15:32:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (549, 2, '型号/编号', '2', 'yunze_CustomerInquiries_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 15:32:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (550, 3, 'IMEI', '3', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-12-29 16:22:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (551, 5, 'IMEI', '5', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-29 16:23:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (552, 22, '客户导入', '_CustomerImport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-01-02 10:52:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (553, 13, '客户导入', '13', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2022-01-02 10:53:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (554, 3, '老客户', '3', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2022-01-03 11:01:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (555, 13, '同行', '13', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2022-01-03 12:25:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (556, 0, '无需出库', '0', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (557, 1, '未出库', '1', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (558, 2, '已出库', '2', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (559, 4, '有用量非正常状态', '4', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-01-12 17:37:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (560, 14, '已订购用量状态已停机', '14', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2022-01-13 13:52:55', 'admin', '2022-01-13 14:59:46', NULL);
INSERT INTO `sys_dict_data` VALUES (561, 23, '已订购用量状态已停机', '_AbnormalStatus', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-01-13 13:53:41', 'admin', '2022-03-15 15:43:44', NULL);
INSERT INTO `sys_dict_data` VALUES (562, 4, '任务ID', '4', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2022-01-13 16:40:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (564, 1, '>=', '1', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:16:18', 'admin', '2022-01-24 09:34:59', NULL);
INSERT INTO `sys_dict_data` VALUES (565, 2, '>', '2', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:16:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (566, 3, '=', '3', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:16:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (567, 4, '<', '4', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:16:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (568, 5, '<=', '5', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:17:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (569, 6, '!=', '6', 'yunze_card_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:17:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (570, 1, '账期用量', '1', 'yunze_card_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:18:59', 'admin', '2022-01-24 09:19:23', NULL);
INSERT INTO `sys_dict_data` VALUES (571, 2, '剩余用量', '2', 'yunze_card_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:19:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (572, 5, '到期日期', '5', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2022-01-24 09:51:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (573, 6, '创建时间', '6', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2022-01-24 14:27:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (578, 8, 'Api变更', '8', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2022-02-09 15:17:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (587, 1, '增加', '1', 'sys_Credit_type', NULL, NULL, 'N', '0', 'admin', '2022-02-25 15:24:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (588, 2, '减少', '2', 'sys_Credit_type', NULL, NULL, 'N', '0', 'admin', '2022-02-25 15:25:12', 'admin', '2022-02-25 15:25:20', NULL);
INSERT INTO `sys_dict_data` VALUES (589, 5, '授信支付', 'ct', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2022-02-28 09:54:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (590, 4, '企业预存', '4', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2022-02-28 09:55:13', 'admin', '2022-02-28 09:55:28', NULL);
INSERT INTO `sys_dict_data` VALUES (591, 5, '企业提现', '5', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2022-02-28 09:55:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (592, 6, '预存抵扣', '6', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2022-02-28 10:10:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (593, 1, '手动变更', '1', 'yz_sys_money_changeType', NULL, NULL, 'N', '0', 'admin', '2022-02-28 12:30:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (594, 2, '业务变更', '2', 'yz_sys_money_changeType', NULL, NULL, 'N', '0', 'admin', '2022-02-28 12:30:11', 'admin', '2022-02-28 12:30:25', NULL);
INSERT INTO `sys_dict_data` VALUES (595, 1, '成功', '1', 'yz_money_change_result', NULL, NULL, 'N', '0', 'admin', '2022-02-28 14:00:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (596, 2, '失败', '2', 'yz_money_change_result', NULL, NULL, 'N', '0', 'admin', '2022-02-28 14:00:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (597, 6, '预存支付', 'pe', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2022-03-02 09:26:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (598, 1, '北京', '01', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:30:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (599, 2, '天津', '02', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:30:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (600, 3, '河北', '03', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:30:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (601, 4, '山西', '04', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:30:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (602, 5, '内蒙古', '05', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:30:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (603, 6, '辽宁', '06', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (604, 7, '吉林', '07', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:07', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (605, 8, '黑龙江', '08', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (606, 9, '上海', '09', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (607, 10, '江苏', '10', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (608, 11, ' 浙江', '11', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (609, 12, '安徽', '12', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:31:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (610, 13, '福建', '132', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (611, 14, '江西', '14', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (612, 15, '山东', '15', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (613, 16, '河南', '16', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (614, 17, ' 湖北', '17', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (615, 18, '湖南', '18', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (616, 19, '广东', '19', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:32:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (617, 20, '广西', '20', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (618, 21, '海南', '21', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (619, 22, '四川', '22', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (620, 23, '贵州', '23', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (621, 24, '云南', '24', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (622, 25, '西藏', '25', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (623, 26, '陕西', '26', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:33:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (624, 27, '甘肃', '27', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:34:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (625, 28, '青海', '28', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:34:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (626, 29, '宁夏', '29', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:34:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (627, 30, '新疆', '30', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:34:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (628, 31, '重庆', '31', 'yz_YDcard_attribution', NULL, NULL, 'N', '0', 'admin', '2022-03-02 14:34:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (646, 3, 'LTE', '3', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2022-03-07 13:16:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (647, 3, '测试期资费', '3', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2022-03-07 15:23:48', 'admin', '2022-03-07 15:24:01', NULL);
INSERT INTO `sys_dict_data` VALUES (648, 1, '高频轮询', '1', 'yz_route_algorithm', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:10:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (649, 2, '智能轮询', '2', 'yz_route_algorithm', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:11:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (650, 0, '联通CMP', 'LianTong_CMP', 'yz_route_noActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:17:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (651, 2, '山东省移动', 'SDIOT', 'yz_route_noActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:17:48', 'admin', '2022-03-08 14:20:00', NULL);
INSERT INTO `sys_dict_data` VALUES (652, 1, '电信DCP', 'DianXin_DCP', 'yz_route_noActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:18:30', 'admin', '2022-03-08 14:19:12', NULL);
INSERT INTO `sys_dict_data` VALUES (653, 3, '硕朗', 'ShuoLang', 'yz_route_noActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:20:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (654, 6, '用量轮序-智能-已激活', '6', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 08:53:44', 'admin', '2022-03-09 10:01:27', '用量轮序-智能-有激活时间');
INSERT INTO `sys_dict_data` VALUES (655, 7, '用量轮序-智能-未激活-有用量', '7', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 09:25:55', 'admin', '2022-03-09 10:01:13', '用量轮序-智能-无激活时间-有用量');
INSERT INTO `sys_dict_data` VALUES (656, 10, '用量轮序-智能-未激活-未发货-已到沉默期', '8', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 09:27:24', 'admin', '2022-03-09 13:35:45', '用量轮序-智能-无激活时间-无发货日期-已到沉默期');
INSERT INTO `sys_dict_data` VALUES (657, 9, '用量轮序-智能-未激活-已发货', '9', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 09:40:17', 'admin', '2022-03-09 10:01:59', '用量轮序-智能-无激活时间-有发货日期');
INSERT INTO `sys_dict_data` VALUES (658, 21, '卡状态-智能-已激活', '10', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 13:31:24', 'admin', '2022-03-09 13:33:53', NULL);
INSERT INTO `sys_dict_data` VALUES (659, 22, '卡状态-智能-未激活-有用量', '11', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 13:32:21', 'admin', '2022-03-09 13:34:02', NULL);
INSERT INTO `sys_dict_data` VALUES (660, 24, '卡状态-智能-未激活-未发货-已到沉默期', '12', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 13:32:52', 'admin', '2022-03-09 13:34:17', NULL);
INSERT INTO `sys_dict_data` VALUES (661, 23, '卡状态-智能-未激活-已发货', '13', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 13:33:05', 'admin', '2022-03-09 13:34:10', NULL);
INSERT INTO `sys_dict_data` VALUES (662, 30, '激活时间-智能-有用量', '14', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 14:34:30', 'admin', '2022-03-09 14:34:39', '无激活时间才获取激活时间');
INSERT INTO `sys_dict_data` VALUES (663, 31, '激活时间-智能-已发货', '15', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 14:35:15', 'admin', '2022-03-09 14:35:27', '无激活时间才获取激活时间');
INSERT INTO `sys_dict_data` VALUES (664, 32, '激活时间-智能-未发货-已到沉默期', '16', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 14:36:03', 'admin', '2022-03-09 14:36:09', '无激活时间才获取激活时间');
INSERT INTO `sys_dict_data` VALUES (665, 0, '已激活转已停机', '0', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (666, 1, '已停机转已激活', '1', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (667, 2, '库存转已激活', '2', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (668, 3, '可测试转库存', '3', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (669, 4, '可测试转待激活', '4', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (670, 5, '可测试转已激活', '5', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:04:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (671, 6, '待激活转已激活', '6', 'yz_cardFlexible_change_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 10:05:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (683, 5, '未划分资费组', '5', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-03-08 11:18:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (684, 6, '未划分通道', '6', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-03-08 17:35:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (687, 7, '归属总平台已有用量', '7', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-03-09 17:26:41', 'admin', '2022-03-10 11:11:24', NULL);
INSERT INTO `sys_dict_data` VALUES (688, 11, '状态未知获取', '17', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 18:23:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (689, 12, '已激活无记录用量', '18', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2022-03-10 18:36:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (690, 15, '批量变更卡信息', '15', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2022-03-15 11:08:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (691, 24, '批量变更卡信息主表', '_CardInfoReplace', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-03-15 15:44:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (692, 25, '批量变更卡信息拓展表', '_CardInfoExpandReplace', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-03-15 15:44:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (693, 26, '批量变更主表备份', '__CardInfoReplaceBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-03-15 15:45:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (694, 27, '批量变更拓展表备份', '__CardInfoReplaceExpandBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-03-15 15:45:50', '', NULL, 'card');
INSERT INTO `sys_dict_data` VALUES (695, 1, '3G', '1', 'DianXin_CMP_netModel', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:21:45', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (696, 2, '4G', '2', 'DianXin_CMP_netModel', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:21:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (697, 8, 'NB', '8', 'DianXin_CMP_RAT', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:27:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (698, 6, 'LTE', '6', 'DianXin_CMP_RAT', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:28:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (699, 102, 'eHRPD', '102', 'DianXin_CMP_RAT', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:28:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (700, 0, '在线', '0', 'DianXin_CMP_online', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:29:45', 'admin', '2022-03-23 18:29:56', NULL);
INSERT INTO `sys_dict_data` VALUES (701, 1, '离线', '-1', 'DianXin_CMP_online', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:30:07', 'admin', '2022-12-05 16:30:26', NULL);
INSERT INTO `sys_dict_data` VALUES (702, 2, '未查询到会话信息', '-2', 'DianXin_CMP_online', NULL, NULL, 'N', '0', 'admin', '2022-03-23 18:30:28', 'admin', '2022-12-05 16:30:30', NULL);
INSERT INTO `sys_dict_data` VALUES (703, 2, '用户昵称', '1', 'yz_sysUser_selType', NULL, NULL, 'N', '0', 'admin', '2022-03-29 08:57:25', 'admin', '2022-05-31 09:55:59', NULL);
INSERT INTO `sys_dict_data` VALUES (704, 3, '登录账号', '2', 'yz_sysUser_selType', NULL, NULL, 'N', '0', 'admin', '2022-03-29 08:57:38', 'admin', '2022-05-31 09:56:04', NULL);
INSERT INTO `sys_dict_data` VALUES (705, 4, '手机号', '3', 'yz_sysUser_selType', NULL, NULL, 'N', '0', 'admin', '2022-03-29 09:59:11', 'admin', '2022-05-31 09:56:08', NULL);
INSERT INTO `sys_dict_data` VALUES (707, 0, 'IoTLink', 'IoTLink', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2022-04-02 10:01:41', '', NULL, 'IoTLink 平台对接');
INSERT INTO `sys_dict_data` VALUES (725, 0, '已激活转已停机', '0', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:25:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (726, 1, '已停机转已激活', '1', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:25:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (727, 2, '库存转已激活', '2', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:26:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (728, 3, '可测试转库存', '3', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:26:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (729, 4, '可测试转待激活', '4', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:26:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (730, 5, '可测试转已激活', '5', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:26:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (731, 6, '待激活转已激活', '6', 'yunze_status_Flexible', NULL, NULL, 'N', '0', 'admin', '2022-03-25 12:26:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (736, 0, 'iccid', '0', 'yunze_Upstream_card', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:26:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (737, 2, '资费激活名称', '2', 'yunze_Upstream_card', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:26:34', 'admin', '2022-04-11 16:51:15', NULL);
INSERT INTO `sys_dict_data` VALUES (738, 0, '创建时间', '0', 'yunze_Upstream_time', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:29:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (739, 1, '总量', '1', 'yunze_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:43:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (740, 2, '使用量', '2', 'yunze_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:43:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (741, 3, '剩余量', '3', 'yunze_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:43:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (742, 4, '已用百分比', '4', 'yunze_dimensionField', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:44:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (743, 1, '>=', '1', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:46:10', 'admin', '2022-04-11 14:46:36', NULL);
INSERT INTO `sys_dict_data` VALUES (744, 2, '>', '2', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:46:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (745, 3, '=', '3', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:52:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (746, 4, '<', '4', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:52:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (747, 5, '<=', '5', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:52:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (748, 6, '!=', '6', 'yunze_dimensionType', NULL, NULL, 'N', '0', 'admin', '2022-04-11 14:52:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (749, 1, '最近修改时间', '1', 'yunze_Upstream_time', NULL, NULL, 'N', '0', 'admin', '2022-04-11 16:50:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (750, 1, '资费id', '1', 'yunze_Upstream_card', NULL, NULL, 'N', '0', 'admin', '2022-04-11 16:51:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (751, 3, 'APN 名称', '3', 'yunze_Upstream_card', NULL, NULL, 'N', '0', 'admin', '2022-04-11 16:51:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (753, 1, '未分类', '1', 'card_api_offeringinfo_type', NULL, NULL, 'N', '0', 'admin', '2022-04-15 13:56:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (754, 2, '功能产品', '2', 'card_api_offeringinfo_type', NULL, NULL, 'N', '0', 'admin', '2022-04-15 13:57:07', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (755, 3, '资费产品', '3', 'card_api_offeringinfo_type', NULL, NULL, 'N', '0', 'admin', '2022-04-15 13:57:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (756, 1, 'YiDong_EC', 'YiDong_EC', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (757, 2, 'YiDong_EC_TOKE_ShuoLang', 'YiDong_EC_TOKE_ShuoLang', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (758, 3, 'YiDong_EC_TengYu', 'YiDong_EC_TengYu', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (759, 4, 'YiDong_EC_Combo', 'YiDong_EC_Combo', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (760, 5, 'YiDong_ECv2', 'YiDong_ECv2', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:45', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (761, 6, 'YiDong_ECv2_Combo', 'YiDong_ECv2_Combo', 'yz_card_api_synOfferinginfo', NULL, NULL, 'N', '0', 'admin', '2022-04-15 17:49:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (762, 8, '上游套餐超过百分比抄送', '8', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-04-18 14:18:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (764, 1, '批量复机', '1', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-04-19 16:06:45', 'admin', '2022-05-18 10:44:17', NULL);
INSERT INTO `sys_dict_data` VALUES (765, 2, '批量停机', '2', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-04-19 16:06:56', 'admin', '2022-05-18 10:44:23', NULL);
INSERT INTO `sys_dict_data` VALUES (766, 0, '账户名', '0', 'yunze_apiUser_seltype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:26:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (767, 1, 'appId', '1', 'yunze_apiUser_seltype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:27:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (768, 2, '密码', '2', 'yunze_apiUser_seltype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:27:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (769, 3, 'key', '3', 'yunze_apiUser_seltype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:27:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (770, 0, '创建时间', '0', 'yunze_apiUser_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:31:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (771, 1, '更新时间', '1', 'yunze_apiUser_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-21 18:32:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (772, 0, '流量查询', 'simDataUsage', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:34:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (773, 1, '历史流量查询', 'simDataUsageMonthly', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:34:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (774, 2, '单卡生命周期查询', 'simStatus', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:34:49', 'admin', '2022-04-24 17:10:58', NULL);
INSERT INTO `sys_dict_data` VALUES (775, 3, '修改生命周期(停复机)', 'changeSimStatus', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:35:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (776, 4, '查询是否实名', 'simRealNameQuery', 'yz_openApi_url', NULL, NULL, 'N', '1', 'admin', '2022-04-22 16:35:24', 'admin', '2022-04-22 16:37:49', NULL);
INSERT INTO `sys_dict_data` VALUES (777, 5, '单卡单独断网', 'simApnFunction', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:35:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (778, 6, '查询在网状态', 'simSession', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:36:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (779, 7, '获取共享token', 'sharedToken', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:36:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (780, 8, '可用资费计划查询', 'tariffplan', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:36:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (781, 9, '企业预存余额查询', 'balance', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:37:07', 'admin', '2022-10-08 14:55:19', NULL);
INSERT INTO `sys_dict_data` VALUES (782, 10, '资费计划订购', 'subscribe', 'yz_openApi_url', NULL, NULL, 'N', '0', 'admin', '2022-04-22 16:37:24', 'admin', '2022-10-08 14:55:14', NULL);
INSERT INTO `sys_dict_data` VALUES (783, 0, '否', '0', 'yz_cm_whether', NULL, NULL, 'N', '0', 'admin', '2022-04-25 10:25:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (784, 1, '是', '1', 'yz_cm_whether', NULL, NULL, 'N', '0', 'admin', '2022-04-25 10:25:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (785, 3, '不选择', '99', 'yz_cm_whether', NULL, NULL, 'N', '0', 'admin', '2022-04-25 10:27:01', 'admin', '2022-04-25 11:26:41', NULL);
INSERT INTO `sys_dict_data` VALUES (786, 0, '否', '0', 'yz_cd_state', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:01:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (787, 1, '是', '1', 'yz_cd_state', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:03:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (788, 1, '接口信息不全', '1', 'yz_cd_Interface', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:05:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (789, 2, '接口申请中', '2', 'yz_cd_Interface', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:05:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (790, 3, '不需要对接', '3', 'yz_cd_Interface', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:05:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (791, 4, '已对接', '4', 'yz_cd_Interface', NULL, NULL, 'N', '0', 'admin', '2022-04-19 09:05:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (792, 0, '创建时间', '0', 'yunze_offeringinfolist_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:29:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (793, 1, '生效时间', '1', 'yunze_offeringinfolist_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:30:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (794, 2, '失效时间', '2', 'yunze_offeringinfolist_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:30:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (795, 3, '修改时间', '3', 'yunze_offeringinfolist_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:31:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (796, 0, 'iccid', '0', 'yunze_offeringinfolist_type', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:40:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (797, 1, '资费名称', '1', 'yunze_offeringinfolist_type', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:40:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (798, 2, '资费 ID', '2', 'yunze_offeringinfolist_type', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:41:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (799, 3, 'APN 名称', '3', 'yunze_offeringinfolist_type', NULL, NULL, 'N', '0', 'admin', '2022-04-25 13:41:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (800, 0, '创建时间', '0', 'yunze_offeringinfo_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 14:30:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (801, 1, '最近一次修改时间', '1', 'yunze_offeringinfo_timetype', NULL, NULL, 'N', '0', 'admin', '2022-04-25 14:31:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (808, 5, '未申请', '5', 'yz_cd_Interface', NULL, NULL, 'N', '0', 'admin', '2022-04-27 16:56:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (810, 0, 'YiDong_EC', '11011', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:45:34', 'admin', '2022-05-13 09:49:43', '码号信息错误，请检查MSISDN、ICCID、IMSI是否正确');
INSERT INTO `sys_dict_data` VALUES (811, 1, 'YiDong_EC', '12035', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:46:15', '', NULL, '卡号不属于本企业');
INSERT INTO `sys_dict_data` VALUES (812, 3, 'YiDong_EC', '14008', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:46:34', 'admin', '2022-05-13 09:49:47', '查询不到信息');
INSERT INTO `sys_dict_data` VALUES (813, 6, 'YiDong_ECv2', '25', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:47:07', 'admin', '2022-05-13 09:50:29', 'ICCID号不是所查询的集团下的用户');
INSERT INTO `sys_dict_data` VALUES (814, 4, 'YiDong_EC', '12007', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:47:31', 'admin', '2022-05-13 09:50:19', 'MSISDN号不是所查询的集团下的用户');
INSERT INTO `sys_dict_data` VALUES (815, 5, 'DianXin_CMP', '-1', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-13 09:49:35', 'admin', '2022-05-13 09:50:23', '无权限（请检查做业务的卡/流量池是否属于本账号，或是否有权限调用此接口）');
INSERT INTO `sys_dict_data` VALUES (816, 9, 'API同步错误-运营类型', '9', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-05-13 13:57:02', 'admin', '2022-05-13 14:10:51', NULL);
INSERT INTO `sys_dict_data` VALUES (817, 10, 'API同步错误-非运营类型', '10', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-05-13 14:11:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (819, 7, 'YYWL', '1', 'api_businessError_code', NULL, NULL, 'N', '0', 'admin', '2022-05-16 10:36:21', '', NULL, '企业下无此卡');
INSERT INTO `sys_dict_data` VALUES (823, 3, '批量断网', '3', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:44:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (824, 4, '批量开网', '4', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:44:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (825, 5, '批量订购', '5', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:56:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (826, 6, '批量设置', '6', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:57:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (827, 7, '批量修改', '7', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:57:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (828, 8, '取消实名', '8', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:57:32', 'admin', '2022-05-18 10:58:01', NULL);
INSERT INTO `sys_dict_data` VALUES (829, 9, '查询IMEI', '9', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:58:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (830, 10, '灵活变更状态', '10', 'yz_bulk_business_type', NULL, NULL, 'N', '0', 'admin', '2022-05-18 10:59:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (831, 0, '全部', 'null', 'yz_bulk_business_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:04:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (832, 1, '完成', '1', 'yz_bulk_business_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:05:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (833, 2, '受理中', '2', 'yz_bulk_business_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:05:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (834, 3, '执行中', '3', 'yz_bulk_business_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:05:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (835, 4, '已超时', '4', 'yz_bulk_business_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:06:43', 'admin', '2022-05-18 11:06:49', NULL);
INSERT INTO `sys_dict_data` VALUES (836, 0, '待处理', '0', 'yz_bulk_businessDtails_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:32:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (837, 1, '成功', '1', 'yz_bulk_businessDtails_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:32:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (838, 2, '失败', '2', 'yz_bulk_businessDtails_state_id', NULL, NULL, 'N', '0', 'admin', '2022-05-18 11:32:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (840, 20, 'ECV5梦网共享推送', 'ECV5_token_MW', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2022-05-26 09:02:53', 'admin', '2023-02-13 14:20:48', '移动ECv5梦网共享推送接口');
INSERT INTO `sys_dict_data` VALUES (841, 1, 'iccid', '1', 'yunze_typeOptionsError', NULL, NULL, 'N', '0', 'admin', '2022-05-16 14:14:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (842, 2, '错误代码', '2', 'yunze_typeOptionsError', NULL, NULL, 'N', '0', 'admin', '2022-05-16 15:40:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (843, 3, '错误信息', '3', 'yunze_typeOptionsError', NULL, NULL, 'N', '0', 'admin', '2022-05-16 15:40:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (844, 1, '错误代码', '1', 'yunze_typeOptionsGroup', NULL, NULL, 'N', '0', 'admin', '2022-05-16 15:40:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (845, 2, '错误信息', '2', 'yunze_typeOptionsGroup', NULL, NULL, 'N', '0', 'admin', '2022-05-16 15:41:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (846, 1, '任务名', '1', 'yunze_batchBusiness_type', NULL, NULL, 'N', '0', 'admin', '2022-05-26 10:14:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (847, 2, '编号', '2', 'yunze_batchBusiness_type', NULL, NULL, 'N', '0', 'admin', '2022-05-26 10:14:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (848, 3, '创建人', '3', 'yunze_batchBusiness_type', NULL, NULL, 'N', '0', 'admin', '2022-05-26 10:14:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (849, 1, '号码', '1', 'yunze_businessDetails_type', NULL, NULL, 'N', '0', 'admin', '2022-05-26 10:26:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (850, 2, '描述', '2', 'yunze_businessDetails_type', NULL, NULL, 'N', '0', 'admin', '2022-05-26 10:26:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (859, 21, '中国电信5G', 'DianXin_CMP_5G', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2022-05-31 15:35:00', '', NULL, '中国电信5G平台');
INSERT INTO `sys_dict_data` VALUES (860, 5, '已停机', '5', 'pollingOther_cardCardStatus', NULL, NULL, 'N', '0', 'admin', '2022-06-06 10:14:46', 'admin', '2022-06-07 10:43:31', NULL);
INSERT INTO `sys_dict_data` VALUES (863, 3, '待激活', '3', 'pollingOther_cardCardStatus', NULL, NULL, 'N', '0', 'admin', '2022-06-07 10:43:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (864, 4, '已激活', '4', 'pollingOther_cardCardActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-06-13 12:11:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (875, 1, '订单号', '1', 'cardNumberAge', NULL, NULL, 'N', '0', 'admin', '2022-05-30 13:25:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (876, 2, 'ICCID', '2', 'cardNumberAge', NULL, NULL, 'N', '0', 'admin', '2022-05-30 13:25:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (877, 3, '微信订单号', '3', 'cardNumberAge', NULL, NULL, 'N', '0', 'admin', '2022-05-30 13:26:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (890, 0, '订单号', '0', 'yunze_renewal_seltype', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:44:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (891, 0, '创建时间', '0', 'yunze_renewal_timeType', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:45:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (892, 1, '审核时间', '1', 'yunze_renewal_timeType', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:45:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (893, 2, '修改时间', '2', 'yunze_renewal_timeType', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:45:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (894, 0, '审核中', '0', 'yunze_renewal_state', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:47:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (895, 1, '已审核', '1', 'yunze_renewal_state', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:47:29', 'admin', '2022-06-24 09:47:57', NULL);
INSERT INTO `sys_dict_data` VALUES (896, 2, '未通过', '2', 'yunze_renewal_state', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:47:38', 'admin', '2022-06-24 09:48:14', NULL);
INSERT INTO `sys_dict_data` VALUES (897, 1, '备注', '1', 'yunze_renewal_seltype', NULL, NULL, 'N', '0', 'admin', '2022-06-24 09:57:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (898, 11, '续费通知', '11', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-06-24 17:01:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (899, 2, 'ID', '2', 'yunze_renewal_seltype', NULL, NULL, 'N', '0', 'admin', '2022-06-24 18:39:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (901, 22, '梦网-蜂助手', 'MwFengZuShou', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2022-06-30 14:27:28', '', NULL, '梦网第三方-蜂助手系统');
INSERT INTO `sys_dict_data` VALUES (907, 12, '用量快到期', '12', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2022-08-15 09:05:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (908, 13, '翼控', 'YKWL', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-10-25 17:17:54', '', NULL, '安徽翼控科技');
INSERT INTO `sys_dict_data` VALUES (909, 12, '中创', 'ZCWL', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-09-18 13:48:34', 'admin', '2023-02-13 14:20:24', '中创接口');
INSERT INTO `sys_dict_data` VALUES (910, 7, '旭宇物联', 'XuYuWuLian', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-07-21 15:11:48', 'admin', '2023-02-13 14:20:09', '旭宇物联接口');
INSERT INTO `sys_dict_data` VALUES (911, 0, '联通CMP', 'LianTong_CMP', 'yz_route_noActivateDate', NULL, NULL, 'N', '0', 'admin', '2022-03-08 14:17:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (912, 9, '硕朗系统', 'ShuoLang', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-07-31 11:44:48', 'admin', '2021-07-31 11:45:02', '硕朗接口');
INSERT INTO `sys_dict_data` VALUES (913, 5, '移远物联', 'YYWL', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-07-06 11:43:57', '', NULL, '移远物联');
INSERT INTO `sys_dict_data` VALUES (914, 1, '到期时间', '1', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (915, 2, '用量', '2', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (916, 3, 'MSISDN', '3', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (917, 4, 'ICCID', '4', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (918, 5, 'IMSI', '5', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (919, 6, '虚拟编号', '6', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (920, 7, '同步时间', '7', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (921, 0, '升序', '0', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (922, 1, '降序', '1', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (934, 0, '群组id', '0', 'upStream_query', NULL, NULL, 'N', '0', 'admin', '2022-10-11 15:43:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (935, 1, '群组主资费id', '1', 'upStream_query', NULL, NULL, 'N', '0', 'admin', '2022-10-11 15:44:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (936, 2, '群组主资费名称', '2', 'upStream_query', NULL, NULL, 'N', '0', 'admin', '2022-10-11 15:44:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (937, 3, '群组名称', '3', 'upStream_query', NULL, NULL, 'N', '0', 'admin', '2022-10-11 15:45:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (939, 0, 'MSISDN', '0', 'MGQuery', NULL, NULL, 'N', '0', 'admin', '2022-10-12 15:34:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (940, 0, 'ICCID', '1', 'MGQuery', NULL, NULL, 'N', '0', 'admin', '2022-10-12 15:34:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (941, 0, 'IMSI', '2', 'MGQuery', NULL, NULL, 'N', '0', 'admin', '2022-10-12 15:35:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (942, 0, 'GROUPID', '3', 'MGQuery', NULL, NULL, 'N', '0', 'admin', '2022-10-12 15:52:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (948, 0, '创建时间', '2', 'MGDateType', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:37:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (949, 0, '最近一次修改时间', '3', 'MGDateType', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:38:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (950, 0, '同步时间', '4', 'MGDateType', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:38:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (951, 0, '否', '0', 'MGInsert', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:41:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (952, 0, '是', '1', 'MGInsert', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:41:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (953, 0, '否', '0', 'MGUpdate', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:44:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (954, 0, '是', '1', 'MGUpdate', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:44:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (955, 0, '创建时间', '0', 'upStreamTime_type', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:23:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (956, 0, '最近一次修改时间', '1', 'upStreamTime_type', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:23:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (957, 0, '激活时间', '0', 'MGDateType', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:37:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (958, 0, '开卡时间', '1', 'MGDateType', NULL, NULL, 'N', '0', 'admin', '2022-10-18 14:37:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (978, 0, 'ICCID', '0', 'card_sel_batch_type', NULL, NULL, 'N', '0', 'chenzhichao', '2023-02-22 15:32:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (979, 1, 'VID', '1', 'card_sel_batch_type', NULL, NULL, 'N', '0', 'chenzhichao', '2023-02-22 15:32:24', 'chenzhichao', '2023-02-22 15:33:25', NULL);
INSERT INTO `sys_dict_data` VALUES (980, 2, 'MSIDN', '3', 'card_sel_batch_type', NULL, NULL, 'N', '0', 'chenzhichao', '2023-02-22 15:32:33', 'chenzhichao', '2023-02-22 15:33:31', NULL);
INSERT INTO `sys_dict_data` VALUES (981, 3, 'IMSI', '4', 'card_sel_batch_type', NULL, NULL, 'N', '0', 'chenzhichao', '2023-02-22 15:32:41', 'chenzhichao', '2023-02-22 15:33:35', NULL);
INSERT INTO `sys_dict_data` VALUES (982, 4, 'IMEI', '5', 'card_sel_batch_type', NULL, NULL, 'N', '0', 'chenzhichao', '2023-02-22 15:32:50', 'chenzhichao', '2023-02-22 15:33:39', NULL);
INSERT INTO `sys_dict_data` VALUES (983, 1, '到期时间', '1', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (984, 2, '用量', '2', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (985, 3, 'MSISDN', '3', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (986, 4, 'ICCID', '4', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (987, 5, 'IMSI', '5', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (988, 6, '虚拟编号', '6', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (989, 7, '同步时间', '7', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (990, 1, '到期时间', '1', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (991, 2, '用量', '2', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (992, 3, 'MSISDN', '3', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (993, 4, 'ICCID', '4', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (994, 5, 'IMSI', '5', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (995, 6, '虚拟编号', '6', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (996, 7, '同步时间', '7', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (997, 0, '升序', '0', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (998, 1, '降序', '1', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (999, 1, '到期时间', '1', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1000, 2, '用量', '2', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 11:12:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1001, 3, 'MSISDN', '3', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1002, 4, 'ICCID', '4', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1003, 5, 'IMSI', '5', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:04:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1004, 6, '虚拟编号', '6', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1005, 7, '同步时间', '7', 'yz_card_sortValue', NULL, NULL, 'N', '0', 'admin', '2022-10-24 16:05:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1006, 0, '升序', '0', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (1007, 1, '降序', '1', 'yz_card_sort', NULL, NULL, 'N', '0', 'admin', '2022-10-24 10:10:35', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type`  (
  `dict_id` bigint NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE INDEX `dict_type`(`dict_type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 290 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
INSERT INTO `sys_dict_type` VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '用户性别列表');
INSERT INTO `sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '菜单状态列表');
INSERT INTO `sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统开关列表');
INSERT INTO `sys_dict_type` VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '任务状态列表');
INSERT INTO `sys_dict_type` VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '任务分组列表');
INSERT INTO `sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统是否列表');
INSERT INTO `sys_dict_type` VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知类型列表');
INSERT INTO `sys_dict_type` VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知状态列表');
INSERT INTO `sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '操作类型列表');
INSERT INTO `sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '登录状态列表');
INSERT INTO `sys_dict_type` VALUES (100, '运营商类型', 'card_type', '0', 'admin', '2021-06-05 10:49:08', 'admin', '2022-03-15 09:05:53', '运营商类型\n');
INSERT INTO `sys_dict_type` VALUES (101, '卡列表查询条件', 'yunze_card_seltype', '0', 'admin', '2021-06-07 09:19:56', '', NULL, '卡列表查询条件');
INSERT INTO `sys_dict_type` VALUES (102, '卡板列表时间查询类型', 'yunze_card_sel_timetype', '0', 'admin', '2021-06-07 12:22:33', '', NULL, '卡板列表时间查询类型');
INSERT INTO `sys_dict_type` VALUES (103, '卡板删除标记', 'yunze_card_deltype', '0', 'admin', '2021-06-07 12:25:44', '', NULL, 'del_flag');
INSERT INTO `sys_dict_type` VALUES (104, '运营商类型', 'yunze_card_operators_type', '0', 'admin', '2021-06-07 16:14:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (105, '卡状态描述', 'yunze_card_status_type', '0', 'admin', '2021-06-07 16:28:35', 'admin', '2022-01-24 15:25:05', NULL);
INSERT INTO `sys_dict_type` VALUES (106, '资费计划生效类别', 'yunze_card_takeEffect_type', '0', 'admin', '2021-06-09 08:54:58', 'admin', '2021-06-22 12:12:32', NULL);
INSERT INTO `sys_dict_type` VALUES (107, '资费计划生效中类型', 'yunze_card_valid_type', '0', 'admin', '2021-06-09 08:59:53', 'admin', '2021-06-22 12:12:19', NULL);
INSERT INTO `sys_dict_type` VALUES (108, '支付方式', 'yunze_card_pay_type', '0', 'admin', '2021-06-09 09:02:21', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (109, '自定义是否', 'yunze_customize_whether', '0', 'admin', '2021-06-09 09:07:06', '', NULL, '0 否,1 是');
INSERT INTO `sys_dict_type` VALUES (110, '卡类型', 'yunze_card_card_type', '0', 'admin', '2021-06-10 08:51:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (111, '卡板网络类型', 'yunze_card_network_type', '0', 'admin', '2021-06-10 08:53:30', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (112, '卡板在线状态', 'yunze_card_online_status', '0', 'admin', '2021-06-10 14:00:59', '', NULL, '卡板列表在线信息');
INSERT INTO `sys_dict_type` VALUES (113, '卡板接入方式', 'yunze_card_access_type', '0', 'admin', '2021-06-10 14:02:21', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (114, '卡板列表起止条件查询', 'yunze_card_StartAndEnd_type', '0', 'admin', '2021-06-11 15:17:02', '', NULL, '号码类型');
INSERT INTO `sys_dict_type` VALUES (115, '通道管理查询类型', 'yunze_channel_selType', '0', 'admin', '2021-06-19 12:20:10', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (116, '查询排序类型', 'ORDER_BY_rule', '0', 'admin', '2021-06-19 13:31:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (117, '通道排序类型', 'channel_ORDER_BY_type', '0', 'admin', '2021-06-19 13:34:08', '', NULL, '通道管理排序类型');
INSERT INTO `sys_dict_type` VALUES (118, '通道状态', 'channel_status', '0', 'admin', '2021-06-19 13:41:06', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (119, '通道编码', 'channel_code', '0', 'admin', '2021-06-19 14:45:39', '', NULL, 'API调用 通道编码');
INSERT INTO `sys_dict_type` VALUES (120, '执行任务表查询类型', 'executionTask_selType', '0', 'admin', '2021-06-21 11:29:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (121, '执行任务管理排序类型', 'executionTask_ORDER_BY_type', '0', 'admin', '2021-06-21 11:39:21', '', NULL, '流量卡》执行任务管理');
INSERT INTO `sys_dict_type` VALUES (122, '执行任务导出类别', 'yunze_ExecutionTask_OutType', '0', 'admin', '2021-06-21 14:17:16', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (123, '资费计划周期', 'yunze_packet_valid_name', '0', 'admin', '2021-06-22 16:19:38', 'admin', '2021-06-22 16:24:03', '月 年');
INSERT INTO `sys_dict_type` VALUES (124, '资费组查询条件', 'yunze_tariffGroup_selType', '0', 'admin', '2021-06-22 17:14:54', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (125, '资费计划条件', 'yunze_tariffPlan_selType', '0', 'admin', '2021-06-22 17:16:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (126, '订单交易类型', 'yunze_order_type', '0', 'admin', '2021-07-03 10:50:16', 'admin', '2021-08-06 11:21:53', NULL);
INSERT INTO `sys_dict_type` VALUES (127, '订单状态', 'yunze_order_status', '0', 'admin', '2021-07-03 10:52:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (129, '通道轮询类型', 'yunze_polling_type', '0', 'admin', '2021-07-08 14:19:59', 'admin', '2021-07-08 14:20:15', '通道轮序详情表用');
INSERT INTO `sys_dict_type` VALUES (130, '执行任务类别', 'yunze_task_type', '0', 'admin', '2021-07-28 08:35:29', '', NULL, '执行任务表，主要用于记录');
INSERT INTO `sys_dict_type` VALUES (131, '订单查询条件', 'yunze_order_seltype', '0', 'admin', '2021-08-06 10:48:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (132, '订单生成方式', 'yunze_order_creType', '0', 'admin', '2021-08-06 10:57:52', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (133, '分润类型', 'yunze_order_profitType', '0', 'admin', '2021-08-06 11:02:08', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (135, '订单管理时间查询类型', 'yunze_order_sel_timetype', '0', 'admin', '2021-08-06 11:43:56', 'admin', '2021-08-06 17:31:11', NULL);
INSERT INTO `sys_dict_type` VALUES (136, '订单管理起止条件', 'yunze_order_StartAndEnd_type', '0', 'admin', '2021-08-06 17:41:37', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (137, '资费计划类别', 'yunze_packet_type', '0', 'admin', '2021-09-01 16:04:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (138, '资费类型规则', 'yunze_base_packet_type', '0', 'admin', '2021-09-03 15:29:17', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (139, '对外接口日志时间类型', 'yunze_syslogs_sel_timetype', '0', 'admin', '2021-08-24 08:52:32', 'admin', '2021-08-24 12:04:02', '日志创建时间');
INSERT INTO `sys_dict_type` VALUES (141, '用量详情', 'dosage_details_flow_his', '0', 'admin', '2021-08-26 09:13:18', 'admin', '2021-08-26 09:13:58', '用量详情');
INSERT INTO `sys_dict_type` VALUES (142, '用量详情时间类型', 'yunze_yz_card_flow_his', '0', 'admin', '2021-08-26 09:43:21', '', NULL, '用量详情时间类型');
INSERT INTO `sys_dict_type` VALUES (143, '通道进度时间类型', 'yunze_yz_passageway', '0', 'admin', '2021-08-31 11:37:08', '', NULL, '通道进度时间类型');
INSERT INTO `sys_dict_type` VALUES (144, '通道编号', 'yz_passageway_polling', '0', 'admin', '2021-08-31 14:03:30', '', NULL, '通道进度编号');
INSERT INTO `sys_dict_type` VALUES (146, '排序规则', 'yunze_sorting_rules', '0', 'admin', '2021-09-06 13:32:43', '', NULL, '排序规则');
INSERT INTO `sys_dict_type` VALUES (147, '时间类型', 'yunze_card_flow', '0', 'admin', '2021-09-06 13:53:34', '', NULL, '订购资费查询');
INSERT INTO `sys_dict_type` VALUES (148, '排序类型', 'Lifting_sequence', '0', 'admin', '2021-09-06 14:00:42', '', NULL, '排序类型');
INSERT INTO `sys_dict_type` VALUES (149, '条件查询', 'yz_card_flow', '0', 'admin', '2021-09-06 14:19:22', '', NULL, '订购资费条件查询');
INSERT INTO `sys_dict_type` VALUES (150, '条件选择', 'system_yz_sys_logs_sysLog', '0', 'admin', '2021-08-24 08:33:58', '', NULL, '日志执行');
INSERT INTO `sys_dict_type` VALUES (151, '模块类别', 'yz_sys_logs_project', '0', 'admin', '2021-08-24 08:47:40', '', NULL, '执行模块类别\n');
INSERT INTO `sys_dict_type` VALUES (152, '卡变更类型', 'yz_cardChange_type', '0', 'admin', '2021-09-14 09:37:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (153, '卡变更类型来源', 'yz_cardChange_sourceType', '0', 'admin', '2021-09-14 09:38:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (154, '断开网状态', 'yz_cardConnection_type', '0', 'admin', '2021-09-14 11:41:26', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (155, '卡信息变更执行状态', 'yz_cardChange_ExecutionStatus', '0', 'admin', '2021-09-15 08:37:48', 'admin', '2021-09-15 08:38:16', '');
INSERT INTO `sys_dict_type` VALUES (156, '卡号类别', 'cardNumber', '0', 'admin', '2021-09-09 17:13:07', '', NULL, '卡号类别');
INSERT INTO `sys_dict_type` VALUES (157, '自动化触发类型', 'yz_cc_trigger_type', '0', 'admin', '2021-09-24 14:52:22', 'admin', '2021-09-24 15:18:37', NULL);
INSERT INTO `sys_dict_type` VALUES (158, '推送执行动作类型', 'yz_cc_execution_type', '0', 'admin', '2021-09-24 15:18:30', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (159, '自动化状态', 'yz_cc_status', '0', 'admin', '2021-09-24 15:19:52', 'admin', '2021-09-24 15:20:21', NULL);
INSERT INTO `sys_dict_type` VALUES (160, '自动化推送模板', 'yz_cc_template', '0', 'admin', '2021-09-24 15:34:04', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (161, '购买订单发货状态', 'yz_orderShopping_Ship', '0', 'admin', '2021-09-26 12:10:12', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (162, '自动化抄送状态', 'yz_cc_HisStatus', '0', 'admin', '2021-09-26 17:03:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (163, '自动化抄送结果', 'yz_cc_result', '0', 'admin', '2021-09-26 17:06:03', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (164, '通用启用状态', 'yz_enabled_state', '0', 'admin', '2021-09-27 14:51:46', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (165, '商品出售状态', 'yz_commodity_sell', '0', 'admin', '2021-09-27 18:04:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (166, '商品审核状态', 'yz_check_state', '0', 'admin', '2021-09-27 18:06:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (167, '停复机', 'Stop_and_resume', '0', 'admin', '2021-09-28 09:31:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (168, '断开网', 'Disconnect_the_network', '0', 'admin', '2021-09-28 09:39:45', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (169, '卡信息变更查询条件', 'yz_card_info_change', '0', 'admin', '2021-09-29 19:54:02', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (170, '客户状态', 'yz_customer_state', '0', 'admin', '2021-10-11 15:54:03', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (171, '客户来源', 'yz_customer_source', '0', 'admin', '2021-10-11 16:04:56', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (172, '客户等级', 'yz_customer_grade', '0', 'admin', '2021-10-12 10:45:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (174, '客户一级分类', 'yz_customer_grade_one', '0', 'admin', '2021-10-29 16:08:24', '', NULL, '客户一级分类');
INSERT INTO `sys_dict_type` VALUES (175, '客户二级分类', 'yz_customer_grade_tow', '0', 'admin', '2021-10-29 16:08:55', '', NULL, '客户二级分类');
INSERT INTO `sys_dict_type` VALUES (176, '客户查询类型', 'yz_customer_selType', '0', 'admin', '2021-11-02 16:25:20', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (177, '客户时间查询类型', 'yz_customer_selTimeType', '0', 'admin', '2021-11-02 16:28:34', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (178, '客户敏感信息变更类型', 'yz_CustomerChange_type', '0', 'admin', '2021-11-05 13:59:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (179, '客户类型', 'yz_CustomerSort_type', '0', 'admin', '2021-11-05 15:55:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (180, '自动化时间类型', 'Automation_time', '0', 'admin', '2021-10-19 14:29:36', '', NULL, '自动化时间 类型');
INSERT INTO `sys_dict_type` VALUES (181, '自动化配置时间类型', 'Automated_configuration', '0', 'admin', '2021-10-19 16:33:02', '', NULL, '自动化配置时间类型');
INSERT INTO `sys_dict_type` VALUES (186, '自动化条件类型', 'yz_cc_condition', '0', 'admin', '2021-10-25 15:57:52', 'admin', '2021-10-25 16:00:03', '自动化');
INSERT INTO `sys_dict_type` VALUES (187, '自动化条件选择', 'cc_query_criteria', '0', 'admin', '2021-10-26 10:00:40', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (188, '商品分类时间类型', 'prdCategory_timet', '0', 'admin', '2021-10-29 15:32:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (189, '自动化配置时间类型 ', 'yunze_task_sel_timetype', '0', 'admin', '2021-10-29 16:11:23', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (190, '是否更新未填写属性', 'buttonyesno', '0', 'admin', '2021-11-11 21:25:52', '', NULL, '物联网卡管理 新增 勾选式 编辑 分组 备注 可选择型更新字段；');
INSERT INTO `sys_dict_type` VALUES (191, '入库源', 'Warehousing_source', '0', 'admin', '2021-11-17 09:53:14', '', NULL, '入库出库信息');
INSERT INTO `sys_dict_type` VALUES (192, '商品供应商', 'yz_Commodity_supplier', '0', 'admin', '2021-12-06 10:12:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (193, '商品运营商', 'yz_Commodity_Operator', '0', 'admin', '2021-12-06 10:13:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (194, 'B端商品查询条件', 'yz_Bcommodity_selType', '0', 'admin', '2021-12-06 16:28:29', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (195, 'C端商品查询条件', 'yz_Ccommodity_selType', '0', 'admin', '2021-12-06 16:29:15', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (196, 'B端商品分类查询条件', 'yz_BcommoditySort_selType', '0', 'admin', '2021-12-06 16:31:52', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (197, '通用删除', 'yz_Universal_delete', '0', 'admin', '2021-12-07 09:51:39', '', NULL, '用与状态删除标记');
INSERT INTO `sys_dict_type` VALUES (198, '销售合同分润模式', 'yz_profit_sharingType', '0', 'admin', '2021-12-07 14:38:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (199, '销售合同开票类型', 'yz_Invoicing_Type', '0', 'admin', '2021-12-07 15:38:43', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (200, '销售合同状态', 'yz_Contract_status', '0', 'admin', '2021-12-10 17:46:46', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (201, '合同收款状态', 'yz_ReceivePayment_type', '0', 'admin', '2021-12-10 18:07:57', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (202, '销售合同查询条件', 'yz_SalesContract_selType', '0', 'admin', '2021-12-11 16:42:53', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (203, '销售合同查询时间类型', 'yz_SalesContract_selTimeType', '0', 'admin', '2021-12-11 16:51:19', 'admin', '2021-12-11 16:53:03', NULL);
INSERT INTO `sys_dict_type` VALUES (204, '入款类型', 'cwgl_Deposit_type', '0', 'admin', '2021-12-13 16:04:10', '', NULL, '入款信息');
INSERT INTO `sys_dict_type` VALUES (205, '入款状态', 'cwgl_Deposit_state', '0', 'admin', '2021-12-13 16:04:42', '', NULL, '入款信息\n');
INSERT INTO `sys_dict_type` VALUES (206, '发货状态', 'Ship_state', '0', 'admin', '2021-12-13 16:44:28', '', NULL, '订单合同');
INSERT INTO `sys_dict_type` VALUES (207, '入款信息来源类别', 'DepositSource_type', '0', 'admin', '2021-12-13 16:57:04', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (208, '发票性质', 'invoice_Nature', '0', 'admin', '2021-12-14 08:37:15', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (209, '合同性质', 'contract_nature', '0', 'admin', '2021-12-14 09:02:24', '', NULL, '订单合同发货信息');
INSERT INTO `sys_dict_type` VALUES (210, '合同发货查询条件', 'yunze_OrderDelivery_selType', '0', 'admin', '2021-12-14 12:27:20', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (211, '合同发货查询时间类型', 'yunze_OrderDelivery_timetype', '0', 'admin', '2021-12-14 13:28:39', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (212, '发货选择类型', 'Delivery_selection_type', '0', 'admin', '2021-12-14 15:58:20', 'admin', '2021-12-15 09:23:20', '');
INSERT INTO `sys_dict_type` VALUES (213, '发货方式', 'Delivery_method', '0', 'admin', '2021-12-14 16:39:07', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (214, '发货类型', 'Delivery_type', '0', 'admin', '2021-12-15 09:23:35', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (215, '运费方式', 'Shipping_method', '0', 'admin', '2021-12-15 10:27:38', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (216, '发货申请查询条件', 'yunze_ShippingApplication_selType', '0', 'admin', '2021-12-21 16:16:07', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (217, '发货申请时间查询类型', 'yunze_ShippingApplication_timetype', '0', 'admin', '2021-12-21 16:18:18', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (218, '快递查询-查询条件', 'yunze_ExpressInquiry_selType', '0', 'admin', '2021-12-23 10:06:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (219, '快递查询-时间查询类型', 'yunze_ExpressInquiry_timetype', '0', 'admin', '2021-12-23 10:07:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (220, '快递签收状态', 'yunze_ExpressInquiry_SignFor', '0', 'admin', '2021-12-23 10:12:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (221, '快递评价', 'yunze_ExpressInquiry_Evaluation', '0', 'admin', '2021-12-23 10:13:00', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (222, '卡状态', 'yunze_card_status_ShowId', '0', 'admin', '2021-12-24 10:50:08', '', NULL, '对外展示');
INSERT INTO `sys_dict_type` VALUES (223, '库存明细查询条件', 'yunze_InventoryDetails_selType', '0', 'admin', '2021-12-28 10:55:55', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (224, '入库明细-时间查询类型', 'yunze_inventorydetails_timetype', '0', 'admin', '2021-12-28 11:03:50', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (225, '入库明细-起止条件查询类型', 'yunze_inventorydetails_StartAndEnd_type', '0', 'admin', '2021-12-28 11:05:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (226, '库存数量-查询条件类型', 'yunze_CustomerInquiries_selType', '0', 'admin', '2021-12-28 15:29:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (227, '出库状态', 'yunze_ShippingApplication_OutboundStatus ', '0', 'admin', '2022-01-05 10:24:50', '', NULL, '发货申请出库状态');
INSERT INTO `sys_dict_type` VALUES (228, '维度条件', 'yunze_card_dimensionType', '0', 'admin', '2022-01-24 09:08:42', 'admin', '2022-01-24 09:22:32', NULL);
INSERT INTO `sys_dict_type` VALUES (229, '维度字段', 'yunze_card_dimensionField', '0', 'admin', '2022-01-24 09:09:12', 'admin', '2022-01-24 09:14:14', NULL);
INSERT INTO `sys_dict_type` VALUES (235, '授信类型', 'sys_Credit_type', '0', 'admin', '2022-02-25 15:24:04', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (236, '金额变更类型', 'yz_sys_money_changeType', '0', 'admin', '2022-02-28 12:29:47', '', NULL, '金额变更记录表');
INSERT INTO `sys_dict_type` VALUES (237, '金额变更执行结果', 'yz_money_change_result', '0', 'admin', '2022-02-28 13:59:55', '', NULL, '金额变更执行结果');
INSERT INTO `sys_dict_type` VALUES (238, '移动卡号省份归属地', 'yz_YDcard_attribution', '0', 'admin', '2022-03-02 14:29:55', '', NULL, '移动卡号省份归属地');
INSERT INTO `sys_dict_type` VALUES (243, '通道轮询算法', 'yz_route_algorithm', '0', 'admin', '2022-03-08 14:10:17', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (244, '无法激活时间返回', 'yz_route_noActivateDate', '0', 'admin', '2022-03-08 14:14:55', '', NULL, '无法激活时间返回上游通道类型id');
INSERT INTO `sys_dict_type` VALUES (246, '卡状态灵活变更', 'yz_cardFlexible_change_type', '0', 'admin', '2022-03-10 10:04:06', '', NULL, '卡状态灵活变更类型');
INSERT INTO `sys_dict_type` VALUES (249, '电信CMP无线接入模式', 'DianXin_CMP_netModel', '0', 'admin', '2022-03-23 18:21:23', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (250, '电信CMP接入类型', 'DianXin_CMP_RAT', '0', 'admin', '2022-03-23 18:27:23', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (251, '电信CMP在线状态', 'DianXin_CMP_online', '0', 'admin', '2022-03-23 18:29:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (252, '用户查询条件', 'yz_sysUser_selType', '0', 'admin', '2022-03-29 08:56:33', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (253, '主表灵活变更状态', 'yunze_status_Flexible', '0', 'admin', '2022-03-25 12:18:16', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (254, '上游套餐条件', 'yunze_Upstream_card', '0', 'admin', '2022-04-11 14:25:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (255, '上游套餐时间选择', 'yunze_Upstream_time', '0', 'admin', '2022-04-11 14:27:58', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (256, '上游套餐多维度参数', 'yunze_dimensionField', '0', 'admin', '2022-04-11 14:39:24', 'admin', '2022-04-11 14:39:54', NULL);
INSERT INTO `sys_dict_type` VALUES (257, '上游套餐查询值', 'yunze_dimensionType', '0', 'admin', '2022-04-11 14:45:52', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (258, '上游API返回资费计划类型', 'card_api_offeringinfo_type', '0', 'admin', '2022-04-15 13:56:15', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (259, '已对接套餐上游套餐获取接口', 'yz_card_api_synOfferinginfo', '0', 'admin', '2022-04-15 17:47:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (260, '批量业务订单类型', 'yz_bulk_business_type', '0', 'admin', '2022-04-19 15:48:21', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (261, '批量业务订单状态', 'yz_bulk_business_state_id', '0', 'admin', '2022-04-19 15:49:01', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (263, 'api账户查询条件', 'yunze_apiUser_seltype', '0', 'admin', '2022-04-21 18:25:58', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (264, 'api账户时间查询条件', 'yunze_apiUser_sel_timetype', '0', 'admin', '2022-04-21 18:31:41', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (265, '对外开放接口', 'yz_openApi_url', '0', 'admin', '2022-04-22 16:32:08', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (266, '通用是否带空选项', 'yz_cm_whether', '0', 'admin', '2022-04-25 10:25:20', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (267, '通道表是否正常', 'yz_cd_state', '0', 'admin', '2022-04-19 09:00:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (268, '通道表对接信息', 'yz_cd_Interface', '0', 'admin', '2022-04-19 09:04:54', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (269, '上游已订购套餐时间类型', 'yunze_offeringinfolist_timetype', '0', 'admin', '2022-04-25 13:28:50', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (270, '上游已订购套餐条件查询', 'yunze_offeringinfolist_type', '0', 'admin', '2022-04-25 13:38:37', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (271, '上游资费组管理时间', 'yunze_offeringinfo_timetype', '0', 'admin', '2022-04-25 14:28:11', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (273, '上游业务错误编码', 'api_businessError_code', '0', 'admin', '2022-05-13 09:44:30', '', NULL, '业务错误编码抄送给运营');
INSERT INTO `sys_dict_type` VALUES (274, '批量业务详情状态', 'yz_bulk_businessDtails_state_id', '0', 'admin', '2022-05-18 11:31:40', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (275, '轮询错误详情条件查询', 'yunze_typeOptionsError', '0', 'admin', '2022-05-16 14:13:55', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (276, '轮询错误概要条件查询', 'yunze_typeOptionsGroup', '0', 'admin', '2022-05-16 14:37:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (277, '批量业务订单条件查询', 'yunze_batchBusiness_type', '0', 'admin', '2022-05-26 10:13:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (278, '批量业务详情条件查询', 'yunze_businessDetails_type', '0', 'admin', '2022-05-26 10:25:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (279, '指定卡状态同步生命周期', 'pollingOther_cardCardStatus', '0', 'admin', '2022-06-06 10:14:04', 'admin', '2022-06-13 11:26:20', NULL);
INSERT INTO `sys_dict_type` VALUES (280, '指定卡状态同步激活时间', 'pollingOther_cardCardActivateDate', '0', 'admin', '2022-06-13 11:27:05', 'admin', '2022-06-13 16:45:29', '且系统没有激活时间记录的');
INSERT INTO `sys_dict_type` VALUES (281, '资费订单卡号类型', 'cardNumberAge', '0', 'admin', '2022-05-30 13:25:23', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (285, '续费申请查询条件', 'yunze_renewal_seltype', '0', 'admin', '2022-06-24 09:44:00', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (286, '续费申请时间筛选条件', 'yunze_renewal_timeType', '0', 'admin', '2022-06-24 09:45:28', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (287, '续费申请状态', 'yunze_renewal_state', '0', 'admin', '2022-06-24 09:46:50', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (288, '物联卡排序值', 'yz_card_sortValue', '0', 'admin', '2022-10-24 11:11:30', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (289, '物联卡查询排序', 'yz_card_sort', '0', 'admin', '2022-10-24 10:10:10', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (296, '上游成员组查询条件', 'upStream_query', '0', 'admin', '2022-10-11 15:40:33', '', NULL, '上游成员组查询条件');
INSERT INTO `sys_dict_type` VALUES (297, '成员组查询条件', 'MGQuery', '0', 'admin', '2022-10-12 15:32:55', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (299, '成员组查询时间类型', 'MGDateType', '0', 'admin', '2022-10-18 14:35:57', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (300, '成员组查询是否新增', 'MGInsert', '0', 'admin', '2022-10-18 14:40:08', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (301, '成员组查询是否修改', 'MGUpdate', '0', 'admin', '2022-10-18 14:44:28', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job`  (
  `job_id` bigint NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 85 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '定时任务调度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job
-- ----------------------------
INSERT INTO `sys_job` VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2021-06-05 09:12:10', '', NULL, '');
INSERT INTO `sys_job` VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2021-06-05 09:12:10', '', NULL, '');
INSERT INTO `sys_job` VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '0', '1', 'admin', '2021-06-05 09:12:10', 'admin', '2021-07-04 08:47:54', '');
INSERT INTO `sys_job` VALUES (4, '根据订单轮序更新激活时间', 'DEFAULT', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '0 0 0/1 * * ? ', '1', '1', '0', 'admin', '2021-07-04 15:50:06', 'admin', '2021-11-15 13:31:37', '');
INSERT INTO `sys_job` VALUES (5, '轮询-激活时间', 'POLLING', 'cardActivateDateTask.pollingActivateDate(\'Slight\', 120)', '0 0 0 * * ? ', '2', '1', '0', 'admin', '2021-07-07 15:32:32', 'admin', '2021-11-25 14:18:42', '');
INSERT INTO `sys_job` VALUES (6, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '0 0/20 * * * ?', '2', '0', '0', 'admin', '2021-07-15 17:07:12', 'admin', '2022-03-29 09:17:48', '');
INSERT INTO `sys_job` VALUES (7, '轮询-卡状态', 'POLLING', 'cardStatusTask.pollingCardStatus(120)', '0 0 11,22 * * ? ', '1', '1', '0', 'admin', '2021-07-20 12:03:30', 'admin', '2021-11-25 14:18:56', '');
INSERT INTO `sys_job` VALUES (8, '轮询-用量', 'POLLING', 'cardFlowTask.pollingCardFlow(120)', '0 0 6,18 * * ? ', '1', '1', '0', 'admin', '2021-07-21 13:33:23', 'admin', '2021-11-25 14:19:06', '');
INSERT INTO `sys_job` VALUES (9, '达量停机', 'POLLING', 'cardStopTask.pollingCardStop(60)', '0 0/55 * * * ?', '1', '1', '0', 'admin', '2021-07-23 18:07:40', 'admin', '2022-03-29 09:17:26', '');
INSERT INTO `sys_job` VALUES (10, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '0 0/10 * * * ?', '1', '1', '0', 'admin', '2021-08-04 16:52:55', 'admin', '2022-05-27 14:05:28', '');
INSERT INTO `sys_job` VALUES (11, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '0 0/20 * * * ?', '1', '1', '0', 'admin', '2021-08-13 15:04:26', 'admin', '2022-05-27 14:05:36', '');
INSERT INTO `sys_job` VALUES (12, '手动开启用量监听', 'POLLING', 'cardFlowTask.StartCardFlow(60)', '0 0/1 * * * ?', '1', '1', '1', 'admin', '2021-08-19 14:44:15', '', NULL, '');
INSERT INTO `sys_job` VALUES (13, '删除对外接口日志', 'BACKUP', 'sysLogsTask.backups()', '50 0 0 * * ? *', '1', '1', '0', 'admin', '2021-08-19 17:57:28', 'admin', '2022-06-21 13:25:31', '');
INSERT INTO `sys_job` VALUES (14, 'MQ初始化', 'DEFAULT', 'initMQ.initMQConfig', '0 0 0 * * ? *', '1', '1', '1', 'admin', '2021-08-31 13:16:27', '', NULL, '');
INSERT INTO `sys_job` VALUES (15, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '0 0/45 * * * ? ', '1', '1', '0', 'admin', '2021-09-14 14:08:36', 'admin', '2022-08-15 15:24:49', '');
INSERT INTO `sys_job` VALUES (16, '备份所有表', 'BACKUP', 'backupTest.gentable(30)', '0 1 0 * * ? *', '1', '1', '1', 'admin', '2021-09-16 18:12:41', 'admin', '2022-06-21 13:25:51', '');
INSERT INTO `sys_job` VALUES (17, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '0 0/10 * * * ?', '1', '1', '0', 'admin', '2021-10-08 12:20:18', 'admin', '2022-04-18 15:40:44', '');
INSERT INTO `sys_job` VALUES (18, '轮询-激活时间有用量', 'POLLING', 'cardActivateDateTask.pollingActivateDate(\'Serious\', 60)', '0 0 0/8 * * ? ', '1', '1', '1', 'admin', '2021-10-28 17:21:14', 'admin', '2021-11-12 11:31:34', '');
INSERT INTO `sys_job` VALUES (19, '月初流量卡进行复机', 'POLLING', 'month.gentable(120)', '0 0 0,2,4,6 1 * ? *', '1', '1', '0', 'admin', '2021-11-08 09:56:52', 'admin', '2021-11-25 14:17:52', '');
INSERT INTO `sys_job` VALUES (20, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', '0 0/3 * * * ? *', '1', '1', '0', 'admin', '2021-11-09 16:57:25', 'admin', '2022-08-15 15:24:22', '');
INSERT INTO `sys_job` VALUES (21, '回滚 划卡备份', 'BACKUP', 'rollbackCardagent.rollbackError(\'/mnt/yunze/download/csv/123123123d_CardDistributeBackup.csv\',120,56)', '0/20 * * * * ?', '1', '1', '1', 'admin', '2021-11-15 20:21:06', 'admin', '2022-08-18 15:47:22', '');
INSERT INTO `sys_job` VALUES (22, '创建单通道用量监听', 'POLLING', 'cardFlowTask.pollingCardFlowOne(60,\'49\')', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-22 10:29:55', 'admin', '2021-12-06 18:20:51', '');
INSERT INTO `sys_job` VALUES (23, '指定单个通道创建 消费者', 'POLLING', 'cardFlowTask.CardFlowCreateListener(60,\'49\')', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-22 10:46:08', 'admin', '2021-12-06 18:21:01', '');
INSERT INTO `sys_job` VALUES (24, '轮询重启无记录消费者创建', 'POLLING', 'rebootTask.RebootFlowPolling(180)', '0 0 0/3 * * ?', '1', '1', '1', 'admin', '2021-11-23 17:37:44', 'admin', '2022-02-22 10:26:22', '');
INSERT INTO `sys_job` VALUES (25, '停机阈值重启', 'POLLING', 'rebootTask.RebootCardStop(180)', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-27 13:47:23', '', '2022-03-09 11:48:21', '');
INSERT INTO `sys_job` VALUES (26, '未订购停机重启', 'POLLING', 'rebootTask.RebootCardDisconnected(180)', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-27 13:48:00', '', '2022-03-09 11:48:24', '');
INSERT INTO `sys_job` VALUES (27, '同步主表到期日期', 'POLLING', 'mqcardflow.gettime(30)', '0 0 0/1 * * ? *', '1', '1', '0', 'admin', '2021-11-26 10:22:57', 'admin', '2022-01-24 14:19:30', '');
INSERT INTO `sys_job` VALUES (28, '已订购用量状态已停机邮件抄送', 'Automation', 'emailCCCardAbnormalStatus.CCCardAbnormalStatus', '0 0 9,15 * * ? ', '2', '1', '0', 'admin', '2022-01-13 15:09:03', 'admin', '2022-04-18 15:48:04', '');
INSERT INTO `sys_job` VALUES (29, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '0 0/3 10 * * ?', '1', '1', '0', 'admin', '2022-01-13 17:28:55', 'admin', '2022-08-15 15:25:44', '');
INSERT INTO `sys_job` VALUES (30, '首页数据生成', 'SYSTEM', 'indexpageGenerateTask.GenerateTask(60,\'100\')', '0 5 0 * * ?', '1', '1', '0', 'admin', '2022-01-25 11:35:11', 'admin', '2022-07-25 11:46:27', '');
INSERT INTO `sys_job` VALUES (31, '清除当天已完成轮询进度', 'POLLING', 'passagewayPollingTask.cleanRedisChannel()', '0 0/8 * * * ?', '1', '1', '1', 'admin', '2022-02-23 12:07:18', '', '2022-03-29 12:05:10', '');
INSERT INTO `sys_job` VALUES (32, '用量-智能-1', 'POLLING', 'cardFlowAiTask.pollingCardFlow(120,\'notNull\',\'6\',\'\',\'\')', '0 0 5,17 * * ?', '1', '1', '0', 'admin', '2022-03-09 12:14:27', '', '2022-03-09 18:05:18', '');
INSERT INTO `sys_job` VALUES (33, '用量-智能-2', 'POLLING', 'cardFlowAiTask.pollingCardFlow(120,\'Null\',\'7\',\'notNull\',\'\')', '3 0 0 * * ? ', '1', '1', '0', 'admin', '2022-03-09 12:18:37', 'admin', '2022-03-09 18:05:21', '');
INSERT INTO `sys_job` VALUES (34, '用量-智能-3', 'POLLING', 'cardFlowAiTask.pollingCardFlow(120,\'Null\',\'9\',\'\',\'notNull\')', '4 0 0 * * ? ', '1', '1', '0', 'admin', '2022-03-09 12:20:02', 'admin', '2022-03-09 18:05:23', '');
INSERT INTO `sys_job` VALUES (35, '卡状态-智能-1 ', 'POLLING', 'cardStatusAiTask.pollingCardStatus(120,\'notNull\',\'10\',\'\',\'\')', '0 0 10,21 * * ?', '1', '1', '0', 'admin', '2022-03-09 16:01:58', '', '2022-03-09 18:05:25', '');
INSERT INTO `sys_job` VALUES (36, '卡状态-智能-2', 'POLLING', 'cardStatusAiTask.pollingCardStatus(120,\'Null\',\'11\',\'notNull\',\'\')', '0 0 8,19 * * ?', '1', '1', '0', 'admin', '2022-03-09 16:25:58', 'admin', '2022-03-09 18:05:27', '');
INSERT INTO `sys_job` VALUES (37, '卡状态-智能-3', 'POLLING', 'cardStatusAiTask.pollingCardStatus(120,\'Null\',\'13\',\'\',\'notNull\')', '5 0 0 * * ?', '1', '1', '0', 'admin', '2022-03-09 16:29:17', 'admin', '2022-03-09 18:05:29', '');
INSERT INTO `sys_job` VALUES (38, '用量-智能-4', 'POLLING', 'cardFlowAiTask.pollingCardFlowSilencePeriod(120)', '0 0 0/12 * * ? ', '1', '1', '0', 'admin', '2022-03-09 16:38:18', '', '2022-03-09 18:05:30', '');
INSERT INTO `sys_job` VALUES (39, '卡状态-智能-4', 'POLLING', 'cardStatusAiTask.pollingCardStatus(120)', '0 0 2/8 * * ? *', '1', '1', '0', 'admin', '2022-03-09 16:42:51', '', '2022-03-09 18:05:32', '');
INSERT INTO `sys_job` VALUES (40, '激活时间-智能-1', 'DEFAULT', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120,\'14\',\'notNull\',\'\')', '0 0 3/8 * * ? *', '1', '1', '0', 'admin', '2022-03-09 16:50:32', '', '2022-03-09 18:05:37', '');
INSERT INTO `sys_job` VALUES (41, '激活时间-智能-2', 'POLLING', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120,\'15\',\'\',\'notNull\')', '0 0 5/8 * * ? *', '1', '1', '0', 'admin', '2022-03-09 16:57:26', '', '2022-03-09 18:05:41', '');
INSERT INTO `sys_job` VALUES (42, '激活时间-智能-3', 'POLLING', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120)', '0 0 6/8 * * ? *', '1', '1', '0', 'admin', '2022-03-09 17:00:15', '', '2022-03-09 18:05:43', '');
INSERT INTO `sys_job` VALUES (43, '自动化 邮件抄送 [未划分资费组]', 'DEFAULT', 'emailPayGroup.PayGroup', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-03-08 09:39:24', 'admin', '2022-03-10 19:15:19', '');
INSERT INTO `sys_job` VALUES (44, '自动化任务邮件抄送超百分比（80）', 'Automation', 'usageMail.Reminder(80)', '0 0 10 ? * MON-FRI', '1', '1', '1', 'admin', '2022-04-11 18:07:58', 'admin', '2022-04-18 15:59:47', '');
INSERT INTO `sys_job` VALUES (45, '自动化 邮件抄送 [未划分通道]', 'DEFAULT', 'emailPassageway.Passageway', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-03-08 16:07:24', 'admin', '2022-03-10 19:15:20', '');
INSERT INTO `sys_job` VALUES (46, '自动化 邮件抄送 重试 [未划分通道]', 'DEFAULT', 'emailPassageway.RetryCC(50)', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-03-09 10:08:42', 'admin', '2022-03-10 19:15:22', '');
INSERT INTO `sys_job` VALUES (47, '自动化 邮件抄送 重试 [未划分资费组]', 'SYSTEM', 'emailPayGroup.RetryCC(50)', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-03-10 12:16:03', 'admin', '2022-03-10 19:15:23', '');
INSERT INTO `sys_job` VALUES (48, '卡状态未知获取状态', 'POLLING', 'cardStatusAiTask.pollingCardStatusNull(30)', '0 0 3 * * ?', '1', '1', '0', 'admin', '2022-03-10 18:41:28', 'admin', '2022-07-25 11:38:31', '');
INSERT INTO `sys_job` VALUES (49, '用量记录无记录获取用量', 'POLLING', 'cardFlowAiTask.pollingCardFlowNotRecord(45)', '0 0 0/4 * * ?', '1', '1', '0', 'admin', '2022-03-10 18:42:51', 'admin', '2022-03-19 12:04:41', '');
INSERT INTO `sys_job` VALUES (50, '清除大于X天用量记录', 'SYSTEM', 'cleanUpCardFliwHis.CleanUp(\'100\')', '0 0 0 * * ?', '1', '1', '1', 'admin', '2022-03-23 14:47:11', 'admin', '2022-08-01 10:02:38', '');
INSERT INTO `sys_job` VALUES (51, '归属为总平台-有用量', 'SYSTEM', 'emailCardConsumption.CardConsumption()', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-03-25 11:27:11', '', '2022-03-25 17:54:51', '');
INSERT INTO `sys_job` VALUES (52, '激活时间-补偿', 'POLLING', 'cardActivateDateAiTask.pollingActivateDateCompensate(60)', '20 0 19 * * ?', '1', '1', '0', 'admin', '2022-04-08 10:20:55', 'admin', '2022-06-23 11:11:31', '');
INSERT INTO `sys_job` VALUES (54, '卡号同步上游套餐', 'POLLING', 'cardSynOfferinginfolistTask.SynOfferinginfo', '0 0 20 1/3 * ?', '1', '1', '0', 'admin', '2022-04-15 17:58:29', 'admin', '2022-04-19 08:46:33', '');
INSERT INTO `sys_job` VALUES (55, '同步上游套餐类型表', 'SYSTEM', 'cardSynOfferinginfoTask.SynOfferinginfo', '0 0 0/3 * * ?', '1', '1', '0', 'admin', '2022-04-18 10:45:24', 'admin', '2022-04-18 13:42:51', '');
INSERT INTO `sys_job` VALUES (56, '自动化任务邮件抄送超百分比（80）', 'Automation', 'reminder.Reminder(80)', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-04-11 18:07:58', 'admin', '2022-04-18 15:51:44', '');
INSERT INTO `sys_job` VALUES (57, '卡通道表[同步更改字段数据]', 'DEFAULT', 'cardCount.synchronization', '0 0 0/2 * * ?', '1', '1', '0', 'admin', '2022-04-13 08:37:47', 'admin', '2022-04-18 13:43:04', '');
INSERT INTO `sys_job` VALUES (58, '资费组【同步卡总数】', 'DEFAULT', 'cardPostageCount.synchronization', '0 0 0/2 * * ?', '1', '1', '0', 'admin', '2022-04-13 13:36:57', 'admin', '2022-04-18 13:43:06', '');
INSERT INTO `sys_job` VALUES (59, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '0 0/1 * * * ?', '1', '1', '0', 'admin', '2022-04-18 15:47:39', '', '2022-04-18 16:10:51', '');
INSERT INTO `sys_job` VALUES (61, '激活时间-智能-未激活-有用量', 'DEFAULT', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120,\'14\',\'notNull\',\'\')', '0 0 3/8 * * ? *', '1', '1', '0', 'admin', '2022-03-09 16:50:32', '', '2022-03-09 18:05:37', '');
INSERT INTO `sys_job` VALUES (62, '记录为负数卡号再次同步用量', 'Automation', 'cardFlowLessThanZeroTask.pollingCardFlowLessThanZero(60)', '45 0 3 * * ? *', '1', '1', '0', 'admin', '2022-04-21 13:16:42', 'admin', '2022-07-25 11:52:51', '');
INSERT INTO `sys_job` VALUES (63, '同步-卡用量接口查询时错误记录-分类', 'POLLING', 'synPollingErrorGroupTask.SynOfferinginfo', '0 0 3 * * ?', '1', '1', '0', 'admin', '2022-05-13 13:23:06', 'admin', '2022-07-25 11:52:24', '');
INSERT INTO `sys_job` VALUES (64, 'API同步数据错误抄送-运营类型', 'POLLING', 'emaiApiSynError.Send(\'9\')', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-05-13 17:45:08', '', '2022-05-16 17:38:28', '');
INSERT INTO `sys_job` VALUES (65, 'API同步数据错误抄送-非运营类型', 'POLLING', 'emaiApiSynError.Send(\'10\')', '0 0 10 ? * MON-FRI', '1', '1', '0', 'admin', '2022-05-16 16:02:09', '', '2022-05-16 17:38:57', '');
INSERT INTO `sys_job` VALUES (66, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '0 0/1 * * * ?', '1', '1', '0', 'admin', '2022-05-16 16:16:17', '', '2022-05-16 17:38:59', '');
INSERT INTO `sys_job` VALUES (67, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '0 0/1 * * * ?', '1', '1', '0', 'admin', '2022-05-16 16:16:48', '', '2022-05-16 17:39:00', '');
INSERT INTO `sys_job` VALUES (68, '清理执行任务', 'SYSTEM', 'cleanUpExecutionTaskFlieTask.ExecutionTaskFlie', '0 10 0 * * ?', '1', '1', '0', 'admin', '2022-06-01 15:51:03', 'admin', '2022-07-25 11:52:02', '');
INSERT INTO `sys_job` VALUES (69, '指定卡状态同步生命周期', 'POLLING', 'cardOtherStatusTask.pollingCardStatus(60)', '0 0 20 * * ?', '1', '1', '0', 'admin', '2022-06-06 12:14:29', 'admin', '2022-07-25 11:51:53', '');
INSERT INTO `sys_job` VALUES (70, '指定状态获取激活时间', 'POLLING', 'cardOtherActivateDateTask.pollingCardActivateDate(60)', '0 0 22 * * ?', '1', '1', '0', 'admin', '2022-06-13 15:38:17', 'admin', '2022-07-25 11:51:38', '');
INSERT INTO `sys_job` VALUES (71, '未找到加包重置加包状态', 'SYSTEM', 'sysOrder.UpdOrderStatus', '0 0 0/1 * * ?', '1', '1', '0', 'admin', '2022-06-15 10:56:22', '', '2022-06-15 11:46:00', '');
INSERT INTO `sys_job` VALUES (72, '未订购断网', 'POLLING', 'cardBreakNetworkTask.pollingCardBreakNetwork(120)', '0 0/50 * * * ?', '1', '1', '0', 'admin', '2022-05-12 14:29:35', 'admin', '2022-06-27 16:00:04', '');
INSERT INTO `sys_job` VALUES (73, '续费邮件通知', 'Automation', 'emailCCRenewal.CCExecution(1)', '0 0/10 * * * ?', '1', '1', '1', 'admin', '2022-06-24 18:45:47', '', '2023-01-12 09:28:04', '');
INSERT INTO `sys_job` VALUES (74, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '0 0/10 * * * ?', '1', '1', '0', 'admin', '2022-06-24 23:07:25', 'admin', '2022-06-27 15:35:53', '');
INSERT INTO `sys_job` VALUES (75, '删除卡状态变更信息', 'SYSTEM', 'cardInfoChange.ClearUp', '10 0 1 * * ? *', '1', '1', '0', 'admin', '2022-07-06 09:08:57', 'admin', '2022-07-07 09:08:13', '');
INSERT INTO `sys_job` VALUES (76, '日志清理', 'SYSTEM', 'sysLogClearTask.Generate(30)', '15 0 1 * * ? *', '1', '1', '0', 'admin', '2022-07-15 17:14:19', '', '2022-07-20 17:44:38', '');
INSERT INTO `sys_job` VALUES (77, '平台资产明细生成', 'SYSTEM', 'indexpageGenerateTask.GenerateAssetDetails(60,\'100\')', '10 0 0 * * ? *', '1', '1', '0', 'admin', '2022-07-15 17:18:51', '', '2022-07-20 17:44:44', '');
INSERT INTO `sys_job` VALUES (78, '资费计划-卡数量同步', 'SYSTEM', 'cardPacketCountTask.SynPacketCount', '45 0 0 * * ? *', '1', '1', '0', 'admin', '2022-07-20 10:45:44', '', '2022-07-20 17:49:28', '');
INSERT INTO `sys_job` VALUES (79, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '0 0/1 * * * ?', '1', '1', '0', 'admin', '2022-08-18 16:21:37', 'admin', '2022-08-24 17:13:42', '');
INSERT INTO `sys_job` VALUES (80, '通道组同步成员', 'POLLING', 'synChannelCardInfoTask.SynCardInfo', '45 0 1 * * ? *', '1', '1', '0', 'admin', '2022-09-14 17:32:53', 'admin', '2022-09-27 10:55:43', '');
INSERT INTO `sys_job` VALUES (81, '接入号同步iccid数据等', 'POLLING', 'synCardInfoTask.SynCardInfo', '30 0 0/4 * * ?', '1', '1', '0', 'admin', '2022-09-15 16:39:43', 'admin', '2022-09-21 15:08:22', '');
INSERT INTO `sys_job` VALUES (82, '对比主表数据进行标记', 'POLLING', 'synCardDataComparisonTask.DataComparison', '20 0 0/4 * * ?', '1', '1', '0', 'admin', '2022-09-21 09:19:58', 'admin', '2022-09-27 11:26:24', '');
INSERT INTO `sys_job` VALUES (83, '上游标记数据执行新增', 'DEFAULT', 'cardSynInfoTask.addDetect', '0 0 9 ? * MON-FRI', '1', '1', '0', 'admin', '2022-09-23 10:33:58', 'admin', '2022-09-26 09:03:03', '');
INSERT INTO `sys_job` VALUES (84, '同步通道成员组', 'POLLING', 'synUpstreamMemberTask.SynOfferinginfo', '10 0 2 * * ? *', '1', '1', '0', 'admin', '2022-09-14 14:50:03', 'admin', '2022-09-21 10:37:13', '');
INSERT INTO `sys_job` VALUES (85, '通道组同步成员', 'POLLING', 'synChannelCardInfoTask.SynCardInfo', '45 0 1 * * ? *', '1', '1', '0', 'admin', '2022-09-14 17:32:53', 'admin', '2022-09-27 10:55:43', '');
INSERT INTO `sys_job` VALUES (86, '接入号同步iccid数据等', 'POLLING', 'synCardInfoTask.SynCardInfo', '30 0 0/4 * * ?', '1', '1', '0', 'admin', '2022-09-15 16:39:43', 'admin', '2022-09-21 15:08:22', '');
INSERT INTO `sys_job` VALUES (87, '对比主表数据进行标记', 'POLLING', 'synCardDataComparisonTask.DataComparison', '20 0 0/4 * * ?', '1', '1', '0', 'admin', '2022-09-21 09:19:58', 'admin', '2022-09-27 11:26:24', '');
INSERT INTO `sys_job` VALUES (88, '上游标记数据执行新增', 'DEFAULT', 'cardSynInfoTask.addDetect', '0 0 9 ? * MON-FRI', '1', '1', '0', 'admin', '2022-09-23 10:33:58', 'admin', '2022-09-26 09:03:03', '');
INSERT INTO `sys_job` VALUES (89, '同步通道成员组', 'POLLING', 'synUpstreamMemberTask.SynOfferinginfo', '10 0 2 * * ? *', '1', '1', '0', 'admin', '2022-09-14 14:50:03', 'admin', '2022-09-21 10:37:13', '');

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log`  (
  `job_log_id` bigint NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '日志信息',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '异常信息',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 262646 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '定时任务调度日志表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------
INSERT INTO `sys_job_log` VALUES (262646, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：50毫秒', '0', '', '2023-06-12 10:31:00');
INSERT INTO `sys_job_log` VALUES (262647, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：106毫秒', '0', '', '2023-06-12 10:31:00');
INSERT INTO `sys_job_log` VALUES (262648, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：118毫秒', '0', '', '2023-06-12 10:31:00');
INSERT INTO `sys_job_log` VALUES (262649, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：76毫秒', '0', '', '2023-06-12 10:31:00');
INSERT INTO `sys_job_log` VALUES (262650, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：16毫秒', '0', '', '2023-06-12 10:32:00');
INSERT INTO `sys_job_log` VALUES (262651, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:32:00');
INSERT INTO `sys_job_log` VALUES (262652, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:32:00');
INSERT INTO `sys_job_log` VALUES (262653, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：3毫秒', '0', '', '2023-06-12 10:32:00');
INSERT INTO `sys_job_log` VALUES (262654, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：19毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262655, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：6毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262656, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：5毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262657, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：16毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262658, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：4毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262659, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 10:33:00');
INSERT INTO `sys_job_log` VALUES (262660, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：10毫秒', '0', '', '2023-06-12 10:34:00');
INSERT INTO `sys_job_log` VALUES (262661, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:34:00');
INSERT INTO `sys_job_log` VALUES (262662, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：3毫秒', '0', '', '2023-06-12 10:34:00');
INSERT INTO `sys_job_log` VALUES (262663, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 10:34:00');
INSERT INTO `sys_job_log` VALUES (262664, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:35:00');
INSERT INTO `sys_job_log` VALUES (262665, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：8毫秒', '0', '', '2023-06-12 10:35:00');
INSERT INTO `sys_job_log` VALUES (262666, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:35:00');
INSERT INTO `sys_job_log` VALUES (262667, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：4毫秒', '0', '', '2023-06-12 10:35:00');
INSERT INTO `sys_job_log` VALUES (262668, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：7毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262669, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：16毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262670, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262671, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262672, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262673, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 10:36:00');
INSERT INTO `sys_job_log` VALUES (262674, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：12毫秒', '0', '', '2023-06-12 10:37:00');
INSERT INTO `sys_job_log` VALUES (262675, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:37:00');
INSERT INTO `sys_job_log` VALUES (262676, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 10:37:00');
INSERT INTO `sys_job_log` VALUES (262677, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 10:37:00');
INSERT INTO `sys_job_log` VALUES (262678, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：8毫秒', '0', '', '2023-06-12 10:38:00');
INSERT INTO `sys_job_log` VALUES (262679, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：7毫秒', '0', '', '2023-06-12 10:38:00');
INSERT INTO `sys_job_log` VALUES (262680, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：28毫秒', '0', '', '2023-06-12 10:38:00');
INSERT INTO `sys_job_log` VALUES (262681, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：4毫秒', '0', '', '2023-06-12 10:38:00');
INSERT INTO `sys_job_log` VALUES (262682, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262683, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：0毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262684, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262685, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262686, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262687, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:39:00');
INSERT INTO `sys_job_log` VALUES (262688, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：10毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262689, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262690, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：1毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262691, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262692, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：1毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262693, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262694, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262695, '续费邮件通知', 'Automation', 'emailCCRenewal.CCExecution(1)', '续费邮件通知 总共耗时：0毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262696, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262697, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:40:00');
INSERT INTO `sys_job_log` VALUES (262698, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:41:00');
INSERT INTO `sys_job_log` VALUES (262699, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:41:00');
INSERT INTO `sys_job_log` VALUES (262700, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:41:00');
INSERT INTO `sys_job_log` VALUES (262701, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:41:00');
INSERT INTO `sys_job_log` VALUES (262702, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：3毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262703, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：1毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262704, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262705, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262706, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262707, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:42:00');
INSERT INTO `sys_job_log` VALUES (262708, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:43:00');
INSERT INTO `sys_job_log` VALUES (262709, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:43:00');
INSERT INTO `sys_job_log` VALUES (262710, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:43:00');
INSERT INTO `sys_job_log` VALUES (262711, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 10:43:00');
INSERT INTO `sys_job_log` VALUES (262712, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:44:00');
INSERT INTO `sys_job_log` VALUES (262713, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:44:00');
INSERT INTO `sys_job_log` VALUES (262714, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:44:00');
INSERT INTO `sys_job_log` VALUES (262715, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:44:00');
INSERT INTO `sys_job_log` VALUES (262716, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '未订购停机 总共耗时：20毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262717, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262718, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：1毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262719, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262720, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262721, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262722, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:45:00');
INSERT INTO `sys_job_log` VALUES (262723, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：42毫秒', '0', '', '2023-06-12 10:46:00');
INSERT INTO `sys_job_log` VALUES (262724, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：81毫秒', '0', '', '2023-06-12 10:46:00');
INSERT INTO `sys_job_log` VALUES (262725, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：112毫秒', '0', '', '2023-06-12 10:46:00');
INSERT INTO `sys_job_log` VALUES (262726, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：127毫秒', '0', '', '2023-06-12 10:46:00');
INSERT INTO `sys_job_log` VALUES (262727, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:47:00');
INSERT INTO `sys_job_log` VALUES (262728, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:47:00');
INSERT INTO `sys_job_log` VALUES (262729, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:47:00');
INSERT INTO `sys_job_log` VALUES (262730, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 10:47:00');
INSERT INTO `sys_job_log` VALUES (262731, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262732, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：1毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262733, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262734, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262735, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262736, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:48:00');
INSERT INTO `sys_job_log` VALUES (262737, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:49:00');
INSERT INTO `sys_job_log` VALUES (262738, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:49:00');
INSERT INTO `sys_job_log` VALUES (262739, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:49:00');
INSERT INTO `sys_job_log` VALUES (262740, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:49:00');
INSERT INTO `sys_job_log` VALUES (262741, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：2毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262742, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262743, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262744, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262745, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262746, '未订购断网', 'POLLING', 'cardBreakNetworkTask.pollingCardBreakNetwork(120)', '未订购断网 总共耗时：1毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262747, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262748, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:50:00');
INSERT INTO `sys_job_log` VALUES (262749, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262750, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：0毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262751, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262752, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262753, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262754, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 10:51:00');
INSERT INTO `sys_job_log` VALUES (262755, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:52:00');
INSERT INTO `sys_job_log` VALUES (262756, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:52:00');
INSERT INTO `sys_job_log` VALUES (262757, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:52:00');
INSERT INTO `sys_job_log` VALUES (262758, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:52:00');
INSERT INTO `sys_job_log` VALUES (262759, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:53:00');
INSERT INTO `sys_job_log` VALUES (262760, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:53:00');
INSERT INTO `sys_job_log` VALUES (262761, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：9毫秒', '0', '', '2023-06-12 10:53:00');
INSERT INTO `sys_job_log` VALUES (262762, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 10:53:00');
INSERT INTO `sys_job_log` VALUES (262763, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262764, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：1毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262765, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262766, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262767, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262768, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:54:00');
INSERT INTO `sys_job_log` VALUES (262769, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:55:00');
INSERT INTO `sys_job_log` VALUES (262770, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:55:00');
INSERT INTO `sys_job_log` VALUES (262771, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:55:00');
INSERT INTO `sys_job_log` VALUES (262772, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 10:55:00');
INSERT INTO `sys_job_log` VALUES (262773, '达量停机', 'POLLING', 'cardStopTask.pollingCardStop(60)', '达量停机 总共耗时：1毫秒', '0', '', '2023-06-12 10:55:00');
INSERT INTO `sys_job_log` VALUES (262774, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:56:00');
INSERT INTO `sys_job_log` VALUES (262775, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:56:00');
INSERT INTO `sys_job_log` VALUES (262776, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:56:00');
INSERT INTO `sys_job_log` VALUES (262777, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:56:00');
INSERT INTO `sys_job_log` VALUES (262778, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262779, '邮件抄送 [有用量停机状态]失败再次抄送', 'Automation', 'emailCCCardAbnormalStatus.RetryCC(100)', '邮件抄送 [有用量停机状态]失败再次抄送 总共耗时：0毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262780, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262781, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262782, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262783, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:57:00');
INSERT INTO `sys_job_log` VALUES (262784, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:58:00');
INSERT INTO `sys_job_log` VALUES (262785, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:58:00');
INSERT INTO `sys_job_log` VALUES (262786, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:58:00');
INSERT INTO `sys_job_log` VALUES (262787, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 10:58:00');
INSERT INTO `sys_job_log` VALUES (262788, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 10:59:00');
INSERT INTO `sys_job_log` VALUES (262789, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 10:59:00');
INSERT INTO `sys_job_log` VALUES (262790, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 10:59:00');
INSERT INTO `sys_job_log` VALUES (262791, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 10:59:00');
INSERT INTO `sys_job_log` VALUES (262792, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：3毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262793, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：18毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262794, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '未订购停机 总共耗时：1毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262795, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262796, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262797, '同步主表到期日期', 'POLLING', 'mqcardflow.gettime(30)', '同步主表到期日期 总共耗时：1毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262798, '根据订单轮序更新激活时间', 'DEFAULT', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '根据订单轮序更新激活时间 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262799, '激活时间-智能-1', 'DEFAULT', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120,\'14\',\'notNull\',\'\')', '激活时间-智能-1 总共耗时：2毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262800, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262801, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：1毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262802, '激活时间-智能-未激活-有用量', 'DEFAULT', 'cardActivateDateAiTask.pollingActivateDateIntelligent(120,\'14\',\'notNull\',\'\')', '激活时间-智能-未激活-有用量 总共耗时：1毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262803, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262804, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262805, '轮询-卡状态', 'POLLING', 'cardStatusTask.pollingCardStatus(120)', '轮询-卡状态 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262806, '未找到加包重置加包状态', 'SYSTEM', 'sysOrder.UpdOrderStatus', '未找到加包重置加包状态 总共耗时：5毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262807, '未订购断网', 'POLLING', 'cardBreakNetworkTask.pollingCardBreakNetwork(120)', '未订购断网 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262808, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262809, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262810, '达量停机', 'POLLING', 'cardStopTask.pollingCardStop(60)', '达量停机 总共耗时：1毫秒', '0', '', '2023-06-12 11:00:00');
INSERT INTO `sys_job_log` VALUES (262811, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:01:00');
INSERT INTO `sys_job_log` VALUES (262812, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:01:00');
INSERT INTO `sys_job_log` VALUES (262813, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:01:00');
INSERT INTO `sys_job_log` VALUES (262814, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:01:00');
INSERT INTO `sys_job_log` VALUES (262815, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:02:00');
INSERT INTO `sys_job_log` VALUES (262816, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:02:00');
INSERT INTO `sys_job_log` VALUES (262817, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:02:00');
INSERT INTO `sys_job_log` VALUES (262818, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:02:00');
INSERT INTO `sys_job_log` VALUES (262819, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 11:03:00');
INSERT INTO `sys_job_log` VALUES (262820, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:03:00');
INSERT INTO `sys_job_log` VALUES (262821, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:03:00');
INSERT INTO `sys_job_log` VALUES (262822, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:03:00');
INSERT INTO `sys_job_log` VALUES (262823, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:03:00');
INSERT INTO `sys_job_log` VALUES (262824, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:04:00');
INSERT INTO `sys_job_log` VALUES (262825, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:04:00');
INSERT INTO `sys_job_log` VALUES (262826, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:04:00');
INSERT INTO `sys_job_log` VALUES (262827, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:04:00');
INSERT INTO `sys_job_log` VALUES (262828, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:05:00');
INSERT INTO `sys_job_log` VALUES (262829, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:05:00');
INSERT INTO `sys_job_log` VALUES (262830, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:05:00');
INSERT INTO `sys_job_log` VALUES (262831, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:05:00');
INSERT INTO `sys_job_log` VALUES (262832, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:06:00');
INSERT INTO `sys_job_log` VALUES (262833, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:06:00');
INSERT INTO `sys_job_log` VALUES (262834, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:06:00');
INSERT INTO `sys_job_log` VALUES (262835, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:06:00');
INSERT INTO `sys_job_log` VALUES (262836, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:06:00');
INSERT INTO `sys_job_log` VALUES (262837, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:07:00');
INSERT INTO `sys_job_log` VALUES (262838, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:07:00');
INSERT INTO `sys_job_log` VALUES (262839, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:07:00');
INSERT INTO `sys_job_log` VALUES (262840, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:07:00');
INSERT INTO `sys_job_log` VALUES (262841, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:08:00');
INSERT INTO `sys_job_log` VALUES (262842, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:08:00');
INSERT INTO `sys_job_log` VALUES (262843, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:08:00');
INSERT INTO `sys_job_log` VALUES (262844, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:08:00');
INSERT INTO `sys_job_log` VALUES (262845, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:09:00');
INSERT INTO `sys_job_log` VALUES (262846, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:09:00');
INSERT INTO `sys_job_log` VALUES (262847, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:09:00');
INSERT INTO `sys_job_log` VALUES (262848, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:09:00');
INSERT INTO `sys_job_log` VALUES (262849, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:09:00');
INSERT INTO `sys_job_log` VALUES (262850, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262851, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262852, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262853, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262854, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262855, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262856, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:10:00');
INSERT INTO `sys_job_log` VALUES (262857, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:11:00');
INSERT INTO `sys_job_log` VALUES (262858, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:11:00');
INSERT INTO `sys_job_log` VALUES (262859, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:11:00');
INSERT INTO `sys_job_log` VALUES (262860, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:11:00');
INSERT INTO `sys_job_log` VALUES (262861, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:12:00');
INSERT INTO `sys_job_log` VALUES (262862, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:12:00');
INSERT INTO `sys_job_log` VALUES (262863, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:12:00');
INSERT INTO `sys_job_log` VALUES (262864, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:12:00');
INSERT INTO `sys_job_log` VALUES (262865, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:12:00');
INSERT INTO `sys_job_log` VALUES (262866, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:13:00');
INSERT INTO `sys_job_log` VALUES (262867, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:13:00');
INSERT INTO `sys_job_log` VALUES (262868, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:13:00');
INSERT INTO `sys_job_log` VALUES (262869, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:13:00');
INSERT INTO `sys_job_log` VALUES (262870, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:14:00');
INSERT INTO `sys_job_log` VALUES (262871, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:14:00');
INSERT INTO `sys_job_log` VALUES (262872, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:14:00');
INSERT INTO `sys_job_log` VALUES (262873, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:14:00');
INSERT INTO `sys_job_log` VALUES (262874, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:15:00');
INSERT INTO `sys_job_log` VALUES (262875, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:15:00');
INSERT INTO `sys_job_log` VALUES (262876, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:15:00');
INSERT INTO `sys_job_log` VALUES (262877, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:15:00');
INSERT INTO `sys_job_log` VALUES (262878, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:15:00');
INSERT INTO `sys_job_log` VALUES (262879, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:16:00');
INSERT INTO `sys_job_log` VALUES (262880, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:16:00');
INSERT INTO `sys_job_log` VALUES (262881, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:16:00');
INSERT INTO `sys_job_log` VALUES (262882, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:16:00');
INSERT INTO `sys_job_log` VALUES (262883, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:17:00');
INSERT INTO `sys_job_log` VALUES (262884, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:17:00');
INSERT INTO `sys_job_log` VALUES (262885, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:17:00');
INSERT INTO `sys_job_log` VALUES (262886, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:17:00');
INSERT INTO `sys_job_log` VALUES (262887, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 11:18:00');
INSERT INTO `sys_job_log` VALUES (262888, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:18:00');
INSERT INTO `sys_job_log` VALUES (262889, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:18:00');
INSERT INTO `sys_job_log` VALUES (262890, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:18:00');
INSERT INTO `sys_job_log` VALUES (262891, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:18:00');
INSERT INTO `sys_job_log` VALUES (262892, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:19:00');
INSERT INTO `sys_job_log` VALUES (262893, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:19:00');
INSERT INTO `sys_job_log` VALUES (262894, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:19:00');
INSERT INTO `sys_job_log` VALUES (262895, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:19:00');
INSERT INTO `sys_job_log` VALUES (262896, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262897, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262898, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262899, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262900, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262901, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262902, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262903, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262904, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (262905, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 11:21:00');
INSERT INTO `sys_job_log` VALUES (262906, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:21:00');
INSERT INTO `sys_job_log` VALUES (262907, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:21:00');
INSERT INTO `sys_job_log` VALUES (262908, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:21:00');
INSERT INTO `sys_job_log` VALUES (262909, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:21:00');
INSERT INTO `sys_job_log` VALUES (262910, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:22:00');
INSERT INTO `sys_job_log` VALUES (262911, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:22:00');
INSERT INTO `sys_job_log` VALUES (262912, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:22:00');
INSERT INTO `sys_job_log` VALUES (262913, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:22:00');
INSERT INTO `sys_job_log` VALUES (262914, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:23:00');
INSERT INTO `sys_job_log` VALUES (262915, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:23:00');
INSERT INTO `sys_job_log` VALUES (262916, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:23:00');
INSERT INTO `sys_job_log` VALUES (262917, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:23:00');
INSERT INTO `sys_job_log` VALUES (262918, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 11:24:00');
INSERT INTO `sys_job_log` VALUES (262919, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:24:00');
INSERT INTO `sys_job_log` VALUES (262920, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:24:00');
INSERT INTO `sys_job_log` VALUES (262921, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:24:00');
INSERT INTO `sys_job_log` VALUES (262922, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:24:00');
INSERT INTO `sys_job_log` VALUES (262923, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:25:00');
INSERT INTO `sys_job_log` VALUES (262924, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:25:00');
INSERT INTO `sys_job_log` VALUES (262925, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:25:00');
INSERT INTO `sys_job_log` VALUES (262926, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:25:00');
INSERT INTO `sys_job_log` VALUES (262927, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:26:00');
INSERT INTO `sys_job_log` VALUES (262928, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:26:00');
INSERT INTO `sys_job_log` VALUES (262929, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:26:00');
INSERT INTO `sys_job_log` VALUES (262930, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:26:00');
INSERT INTO `sys_job_log` VALUES (262931, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:27:00');
INSERT INTO `sys_job_log` VALUES (262932, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:27:00');
INSERT INTO `sys_job_log` VALUES (262933, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 11:27:00');
INSERT INTO `sys_job_log` VALUES (262934, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:27:00');
INSERT INTO `sys_job_log` VALUES (262935, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:27:00');
INSERT INTO `sys_job_log` VALUES (262936, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:28:00');
INSERT INTO `sys_job_log` VALUES (262937, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:28:00');
INSERT INTO `sys_job_log` VALUES (262938, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:28:00');
INSERT INTO `sys_job_log` VALUES (262939, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:28:00');
INSERT INTO `sys_job_log` VALUES (262940, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:29:00');
INSERT INTO `sys_job_log` VALUES (262941, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:29:00');
INSERT INTO `sys_job_log` VALUES (262942, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:29:00');
INSERT INTO `sys_job_log` VALUES (262943, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:29:00');
INSERT INTO `sys_job_log` VALUES (262944, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262945, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262946, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262947, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262948, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262949, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262950, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262951, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:30:00');
INSERT INTO `sys_job_log` VALUES (262952, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：84毫秒', '0', '', '2023-06-12 11:31:00');
INSERT INTO `sys_job_log` VALUES (262953, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：28毫秒', '0', '', '2023-06-12 11:31:00');
INSERT INTO `sys_job_log` VALUES (262954, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：108毫秒', '0', '', '2023-06-12 11:31:00');
INSERT INTO `sys_job_log` VALUES (262955, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：52毫秒', '0', '', '2023-06-12 11:31:00');
INSERT INTO `sys_job_log` VALUES (262956, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：19毫秒', '0', '', '2023-06-12 11:33:00');
INSERT INTO `sys_job_log` VALUES (262957, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：48毫秒', '0', '', '2023-06-12 11:33:00');
INSERT INTO `sys_job_log` VALUES (262958, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：34毫秒', '0', '', '2023-06-12 11:33:00');
INSERT INTO `sys_job_log` VALUES (262959, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：98毫秒', '0', '', '2023-06-12 11:33:00');
INSERT INTO `sys_job_log` VALUES (262960, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：88毫秒', '0', '', '2023-06-12 11:33:00');
INSERT INTO `sys_job_log` VALUES (262961, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 11:34:31');
INSERT INTO `sys_job_log` VALUES (262962, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:34:31');
INSERT INTO `sys_job_log` VALUES (262963, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:34:31');
INSERT INTO `sys_job_log` VALUES (262964, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 11:34:31');
INSERT INTO `sys_job_log` VALUES (262965, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：53毫秒', '0', '', '2023-06-12 11:35:00');
INSERT INTO `sys_job_log` VALUES (262966, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：102毫秒', '0', '', '2023-06-12 11:35:00');
INSERT INTO `sys_job_log` VALUES (262967, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：91毫秒', '0', '', '2023-06-12 11:35:00');
INSERT INTO `sys_job_log` VALUES (262968, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：68毫秒', '0', '', '2023-06-12 11:35:00');
INSERT INTO `sys_job_log` VALUES (262969, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：14毫秒', '0', '', '2023-06-12 11:36:00');
INSERT INTO `sys_job_log` VALUES (262970, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 11:36:00');
INSERT INTO `sys_job_log` VALUES (262971, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:36:00');
INSERT INTO `sys_job_log` VALUES (262972, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 11:36:00');
INSERT INTO `sys_job_log` VALUES (262973, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 11:36:00');
INSERT INTO `sys_job_log` VALUES (262974, 'MQ初始化', 'DEFAULT', 'initMQ.initMQConfig', 'MQ初始化 总共耗时：4959毫秒', '0', '', '2023-06-12 11:36:05');
INSERT INTO `sys_job_log` VALUES (262975, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：88毫秒', '0', '', '2023-06-12 13:26:00');
INSERT INTO `sys_job_log` VALUES (262976, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：51毫秒', '0', '', '2023-06-12 13:26:00');
INSERT INTO `sys_job_log` VALUES (262977, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：34毫秒', '0', '', '2023-06-12 13:26:00');
INSERT INTO `sys_job_log` VALUES (262978, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：17毫秒', '0', '', '2023-06-12 13:26:00');
INSERT INTO `sys_job_log` VALUES (262979, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：3毫秒', '0', '', '2023-06-12 13:27:00');
INSERT INTO `sys_job_log` VALUES (262980, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:27:00');
INSERT INTO `sys_job_log` VALUES (262981, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:27:00');
INSERT INTO `sys_job_log` VALUES (262982, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:27:00');
INSERT INTO `sys_job_log` VALUES (262983, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 13:27:00');
INSERT INTO `sys_job_log` VALUES (262984, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:28:00');
INSERT INTO `sys_job_log` VALUES (262985, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:28:00');
INSERT INTO `sys_job_log` VALUES (262986, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:28:00');
INSERT INTO `sys_job_log` VALUES (262987, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:28:00');
INSERT INTO `sys_job_log` VALUES (262988, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:29:00');
INSERT INTO `sys_job_log` VALUES (262989, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:29:00');
INSERT INTO `sys_job_log` VALUES (262990, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:29:00');
INSERT INTO `sys_job_log` VALUES (262991, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 13:29:00');
INSERT INTO `sys_job_log` VALUES (262992, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：16毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262993, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262994, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262995, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262996, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262997, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262998, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (262999, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:30:00');
INSERT INTO `sys_job_log` VALUES (263000, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:31:00');
INSERT INTO `sys_job_log` VALUES (263001, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:31:00');
INSERT INTO `sys_job_log` VALUES (263002, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:31:00');
INSERT INTO `sys_job_log` VALUES (263003, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:31:00');
INSERT INTO `sys_job_log` VALUES (263004, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:32:00');
INSERT INTO `sys_job_log` VALUES (263005, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:32:00');
INSERT INTO `sys_job_log` VALUES (263006, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:32:00');
INSERT INTO `sys_job_log` VALUES (263007, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 13:32:00');
INSERT INTO `sys_job_log` VALUES (263008, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 13:33:00');
INSERT INTO `sys_job_log` VALUES (263009, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:33:00');
INSERT INTO `sys_job_log` VALUES (263010, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:33:00');
INSERT INTO `sys_job_log` VALUES (263011, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：13毫秒', '0', '', '2023-06-12 13:33:00');
INSERT INTO `sys_job_log` VALUES (263012, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:33:00');
INSERT INTO `sys_job_log` VALUES (263013, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:34:00');
INSERT INTO `sys_job_log` VALUES (263014, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:34:00');
INSERT INTO `sys_job_log` VALUES (263015, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:34:00');
INSERT INTO `sys_job_log` VALUES (263016, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:34:00');
INSERT INTO `sys_job_log` VALUES (263017, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:35:00');
INSERT INTO `sys_job_log` VALUES (263018, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:35:00');
INSERT INTO `sys_job_log` VALUES (263019, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:35:00');
INSERT INTO `sys_job_log` VALUES (263020, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:35:00');
INSERT INTO `sys_job_log` VALUES (263021, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:36:03');
INSERT INTO `sys_job_log` VALUES (263022, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:36:03');
INSERT INTO `sys_job_log` VALUES (263023, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:36:03');
INSERT INTO `sys_job_log` VALUES (263024, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:36:03');
INSERT INTO `sys_job_log` VALUES (263025, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:36:03');
INSERT INTO `sys_job_log` VALUES (263026, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:37:00');
INSERT INTO `sys_job_log` VALUES (263027, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:37:00');
INSERT INTO `sys_job_log` VALUES (263028, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:37:00');
INSERT INTO `sys_job_log` VALUES (263029, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:37:00');
INSERT INTO `sys_job_log` VALUES (263030, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:38:00');
INSERT INTO `sys_job_log` VALUES (263031, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:38:00');
INSERT INTO `sys_job_log` VALUES (263032, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:38:00');
INSERT INTO `sys_job_log` VALUES (263033, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:38:00');
INSERT INTO `sys_job_log` VALUES (263034, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:39:00');
INSERT INTO `sys_job_log` VALUES (263035, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:39:00');
INSERT INTO `sys_job_log` VALUES (263036, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:39:00');
INSERT INTO `sys_job_log` VALUES (263037, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:39:00');
INSERT INTO `sys_job_log` VALUES (263038, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:39:00');
INSERT INTO `sys_job_log` VALUES (263039, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263040, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：9毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263041, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：1毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263042, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263043, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：1毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263044, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263045, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263046, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263047, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:40:00');
INSERT INTO `sys_job_log` VALUES (263048, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：16毫秒', '0', '', '2023-06-12 13:41:00');
INSERT INTO `sys_job_log` VALUES (263049, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:41:00');
INSERT INTO `sys_job_log` VALUES (263050, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：3毫秒', '0', '', '2023-06-12 13:41:00');
INSERT INTO `sys_job_log` VALUES (263051, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 13:41:00');
INSERT INTO `sys_job_log` VALUES (263052, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:42:00');
INSERT INTO `sys_job_log` VALUES (263053, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:42:00');
INSERT INTO `sys_job_log` VALUES (263054, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:42:00');
INSERT INTO `sys_job_log` VALUES (263055, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:42:00');
INSERT INTO `sys_job_log` VALUES (263056, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 13:42:00');
INSERT INTO `sys_job_log` VALUES (263057, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:43:00');
INSERT INTO `sys_job_log` VALUES (263058, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 13:43:00');
INSERT INTO `sys_job_log` VALUES (263059, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:43:00');
INSERT INTO `sys_job_log` VALUES (263060, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:43:00');
INSERT INTO `sys_job_log` VALUES (263061, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:44:00');
INSERT INTO `sys_job_log` VALUES (263062, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:44:00');
INSERT INTO `sys_job_log` VALUES (263063, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:44:00');
INSERT INTO `sys_job_log` VALUES (263064, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:44:00');
INSERT INTO `sys_job_log` VALUES (263065, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '未订购停机 总共耗时：9毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263066, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263067, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263068, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263069, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263070, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:45:00');
INSERT INTO `sys_job_log` VALUES (263071, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 13:46:00');
INSERT INTO `sys_job_log` VALUES (263072, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:46:00');
INSERT INTO `sys_job_log` VALUES (263073, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:46:00');
INSERT INTO `sys_job_log` VALUES (263074, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:46:00');
INSERT INTO `sys_job_log` VALUES (263075, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:47:00');
INSERT INTO `sys_job_log` VALUES (263076, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:47:00');
INSERT INTO `sys_job_log` VALUES (263077, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:47:00');
INSERT INTO `sys_job_log` VALUES (263078, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:47:00');
INSERT INTO `sys_job_log` VALUES (263079, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:48:00');
INSERT INTO `sys_job_log` VALUES (263080, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:48:00');
INSERT INTO `sys_job_log` VALUES (263081, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:48:00');
INSERT INTO `sys_job_log` VALUES (263082, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:48:00');
INSERT INTO `sys_job_log` VALUES (263083, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:48:00');
INSERT INTO `sys_job_log` VALUES (263084, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:49:00');
INSERT INTO `sys_job_log` VALUES (263085, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:49:00');
INSERT INTO `sys_job_log` VALUES (263086, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:49:00');
INSERT INTO `sys_job_log` VALUES (263087, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:49:00');
INSERT INTO `sys_job_log` VALUES (263088, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263089, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：0毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263090, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263091, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263092, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263093, '未订购断网', 'POLLING', 'cardBreakNetworkTask.pollingCardBreakNetwork(120)', '未订购断网 总共耗时：11毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263094, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263095, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:50:00');
INSERT INTO `sys_job_log` VALUES (263096, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 13:51:00');
INSERT INTO `sys_job_log` VALUES (263097, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 13:51:00');
INSERT INTO `sys_job_log` VALUES (263098, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:51:00');
INSERT INTO `sys_job_log` VALUES (263099, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 13:51:00');
INSERT INTO `sys_job_log` VALUES (263100, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 13:51:00');
INSERT INTO `sys_job_log` VALUES (263101, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：29毫秒', '0', '', '2023-06-12 14:15:00');
INSERT INTO `sys_job_log` VALUES (263102, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：13毫秒', '0', '', '2023-06-12 14:15:00');
INSERT INTO `sys_job_log` VALUES (263103, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：62毫秒', '0', '', '2023-06-12 14:15:00');
INSERT INTO `sys_job_log` VALUES (263104, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：49毫秒', '0', '', '2023-06-12 14:15:00');
INSERT INTO `sys_job_log` VALUES (263105, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：73毫秒', '0', '', '2023-06-12 14:15:00');
INSERT INTO `sys_job_log` VALUES (263106, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：20毫秒', '0', '', '2023-06-12 14:16:00');
INSERT INTO `sys_job_log` VALUES (263107, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：3毫秒', '0', '', '2023-06-12 14:16:00');
INSERT INTO `sys_job_log` VALUES (263108, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：6毫秒', '0', '', '2023-06-12 14:16:00');
INSERT INTO `sys_job_log` VALUES (263109, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：4毫秒', '0', '', '2023-06-12 14:16:00');
INSERT INTO `sys_job_log` VALUES (263110, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：6毫秒', '0', '', '2023-06-12 14:17:00');
INSERT INTO `sys_job_log` VALUES (263111, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 14:17:00');
INSERT INTO `sys_job_log` VALUES (263112, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 14:17:00');
INSERT INTO `sys_job_log` VALUES (263113, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 14:17:00');
INSERT INTO `sys_job_log` VALUES (263114, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：2毫秒', '0', '', '2023-06-12 14:18:00');
INSERT INTO `sys_job_log` VALUES (263115, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：2毫秒', '0', '', '2023-06-12 14:18:00');
INSERT INTO `sys_job_log` VALUES (263116, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：3毫秒', '0', '', '2023-06-12 14:18:00');
INSERT INTO `sys_job_log` VALUES (263117, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:18:00');
INSERT INTO `sys_job_log` VALUES (263118, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：2毫秒', '0', '', '2023-06-12 14:18:00');
INSERT INTO `sys_job_log` VALUES (263119, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：4毫秒', '0', '', '2023-06-12 14:19:00');
INSERT INTO `sys_job_log` VALUES (263120, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：3毫秒', '0', '', '2023-06-12 14:19:00');
INSERT INTO `sys_job_log` VALUES (263121, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 14:19:00');
INSERT INTO `sys_job_log` VALUES (263122, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：3毫秒', '0', '', '2023-06-12 14:19:00');
INSERT INTO `sys_job_log` VALUES (263123, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263124, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263125, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：2毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263126, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263127, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：0毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263128, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263129, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263130, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263131, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:20:00');
INSERT INTO `sys_job_log` VALUES (263132, 'MQ初始化', 'DEFAULT', 'initMQ.initMQConfig', 'MQ初始化 总共耗时：1988毫秒', '0', '', '2023-06-12 14:20:29');
INSERT INTO `sys_job_log` VALUES (263133, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 14:21:00');
INSERT INTO `sys_job_log` VALUES (263134, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:21:00');
INSERT INTO `sys_job_log` VALUES (263135, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:21:00');
INSERT INTO `sys_job_log` VALUES (263136, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:21:00');
INSERT INTO `sys_job_log` VALUES (263137, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:21:00');
INSERT INTO `sys_job_log` VALUES (263138, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 14:22:00');
INSERT INTO `sys_job_log` VALUES (263139, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:22:00');
INSERT INTO `sys_job_log` VALUES (263140, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：20毫秒', '0', '', '2023-06-12 14:22:00');
INSERT INTO `sys_job_log` VALUES (263141, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:22:00');
INSERT INTO `sys_job_log` VALUES (263142, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 14:23:00');
INSERT INTO `sys_job_log` VALUES (263143, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:23:00');
INSERT INTO `sys_job_log` VALUES (263144, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:23:00');
INSERT INTO `sys_job_log` VALUES (263145, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:23:00');
INSERT INTO `sys_job_log` VALUES (263146, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：1毫秒', '0', '', '2023-06-12 14:24:00');
INSERT INTO `sys_job_log` VALUES (263147, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:24:00');
INSERT INTO `sys_job_log` VALUES (263148, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:24:00');
INSERT INTO `sys_job_log` VALUES (263149, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:24:00');
INSERT INTO `sys_job_log` VALUES (263150, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:24:00');
INSERT INTO `sys_job_log` VALUES (263151, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:25:00');
INSERT INTO `sys_job_log` VALUES (263152, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:25:00');
INSERT INTO `sys_job_log` VALUES (263153, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:25:00');
INSERT INTO `sys_job_log` VALUES (263154, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:25:00');
INSERT INTO `sys_job_log` VALUES (263155, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:26:00');
INSERT INTO `sys_job_log` VALUES (263156, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:26:00');
INSERT INTO `sys_job_log` VALUES (263157, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:26:00');
INSERT INTO `sys_job_log` VALUES (263158, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:26:00');
INSERT INTO `sys_job_log` VALUES (263159, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 14:27:00');
INSERT INTO `sys_job_log` VALUES (263160, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:27:00');
INSERT INTO `sys_job_log` VALUES (263161, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:27:00');
INSERT INTO `sys_job_log` VALUES (263162, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:27:00');
INSERT INTO `sys_job_log` VALUES (263163, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:27:00');
INSERT INTO `sys_job_log` VALUES (263164, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:28:00');
INSERT INTO `sys_job_log` VALUES (263165, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:28:00');
INSERT INTO `sys_job_log` VALUES (263166, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:28:00');
INSERT INTO `sys_job_log` VALUES (263167, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:28:00');
INSERT INTO `sys_job_log` VALUES (263168, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:29:00');
INSERT INTO `sys_job_log` VALUES (263169, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:29:00');
INSERT INTO `sys_job_log` VALUES (263170, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:29:00');
INSERT INTO `sys_job_log` VALUES (263171, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:29:00');
INSERT INTO `sys_job_log` VALUES (263172, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：0毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263173, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：1毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263174, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263175, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：10毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263176, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263177, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263178, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：0毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263179, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:30:00');
INSERT INTO `sys_job_log` VALUES (263180, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:31:00');
INSERT INTO `sys_job_log` VALUES (263181, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:31:00');
INSERT INTO `sys_job_log` VALUES (263182, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:31:00');
INSERT INTO `sys_job_log` VALUES (263183, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:31:00');
INSERT INTO `sys_job_log` VALUES (263184, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:32:00');
INSERT INTO `sys_job_log` VALUES (263185, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:32:00');
INSERT INTO `sys_job_log` VALUES (263186, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:32:00');
INSERT INTO `sys_job_log` VALUES (263187, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:32:00');
INSERT INTO `sys_job_log` VALUES (263188, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 14:33:00');
INSERT INTO `sys_job_log` VALUES (263189, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:33:00');
INSERT INTO `sys_job_log` VALUES (263190, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:33:00');
INSERT INTO `sys_job_log` VALUES (263191, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:33:00');
INSERT INTO `sys_job_log` VALUES (263192, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:33:00');
INSERT INTO `sys_job_log` VALUES (263193, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:34:00');
INSERT INTO `sys_job_log` VALUES (263194, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:34:00');
INSERT INTO `sys_job_log` VALUES (263195, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：2毫秒', '0', '', '2023-06-12 14:34:00');
INSERT INTO `sys_job_log` VALUES (263196, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:34:00');
INSERT INTO `sys_job_log` VALUES (263197, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:35:00');
INSERT INTO `sys_job_log` VALUES (263198, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:35:00');
INSERT INTO `sys_job_log` VALUES (263199, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:35:00');
INSERT INTO `sys_job_log` VALUES (263200, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:35:00');
INSERT INTO `sys_job_log` VALUES (263201, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：0毫秒', '0', '', '2023-06-12 14:36:00');
INSERT INTO `sys_job_log` VALUES (263202, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:36:00');
INSERT INTO `sys_job_log` VALUES (263203, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:36:00');
INSERT INTO `sys_job_log` VALUES (263204, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:36:00');
INSERT INTO `sys_job_log` VALUES (263205, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:36:00');
INSERT INTO `sys_job_log` VALUES (263206, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：1毫秒', '0', '', '2023-06-12 14:37:00');
INSERT INTO `sys_job_log` VALUES (263207, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:37:00');
INSERT INTO `sys_job_log` VALUES (263208, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:37:00');
INSERT INTO `sys_job_log` VALUES (263209, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:37:00');
INSERT INTO `sys_job_log` VALUES (263210, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:38:00');
INSERT INTO `sys_job_log` VALUES (263211, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:38:00');
INSERT INTO `sys_job_log` VALUES (263212, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:38:00');
INSERT INTO `sys_job_log` VALUES (263213, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：0毫秒', '0', '', '2023-06-12 14:38:00');
INSERT INTO `sys_job_log` VALUES (263214, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：80毫秒', '0', '', '2023-06-12 14:39:00');
INSERT INTO `sys_job_log` VALUES (263215, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：47毫秒', '0', '', '2023-06-12 14:39:00');
INSERT INTO `sys_job_log` VALUES (263216, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：30毫秒', '0', '', '2023-06-12 14:39:00');
INSERT INTO `sys_job_log` VALUES (263217, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：68毫秒', '0', '', '2023-06-12 14:39:00');
INSERT INTO `sys_job_log` VALUES (263218, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：13毫秒', '0', '', '2023-06-12 14:39:00');
INSERT INTO `sys_job_log` VALUES (263219, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：1毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263220, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：14毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263221, '购物邮件自动化抄送', 'Automation', 'emailCCShopping.CCShopping(500)', '购物邮件自动化抄送 总共耗时：1毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263222, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263223, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：0毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263224, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263225, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263226, '续费审核通过生成订单', 'SYSTEM', 'orderRenewalGeneration.RenewalToGenerateOrder(3)', '续费审核通过生成订单 总共耗时：1毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263227, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:40:00');
INSERT INTO `sys_job_log` VALUES (263228, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:41:00');
INSERT INTO `sys_job_log` VALUES (263229, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:41:00');
INSERT INTO `sys_job_log` VALUES (263230, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:41:00');
INSERT INTO `sys_job_log` VALUES (263231, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:41:00');
INSERT INTO `sys_job_log` VALUES (263232, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：83毫秒', '0', '', '2023-06-12 14:42:00');
INSERT INTO `sys_job_log` VALUES (263233, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：56毫秒', '0', '', '2023-06-12 14:42:00');
INSERT INTO `sys_job_log` VALUES (263234, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：15毫秒', '0', '', '2023-06-12 14:42:00');
INSERT INTO `sys_job_log` VALUES (263235, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：35毫秒', '0', '', '2023-06-12 14:42:00');
INSERT INTO `sys_job_log` VALUES (263236, 'C端充值变更失败再次复机', 'POLLING', 'cendvalue.cendalue(120)', 'C端充值变更失败再次复机 总共耗时：98毫秒', '0', '', '2023-06-12 14:42:00');
INSERT INTO `sys_job_log` VALUES (263237, '邮件抄送超百分比-重试', 'DEFAULT', 'reminder.RetryCC(50)', '邮件抄送超百分比-重试 总共耗时：0毫秒', '0', '', '2023-06-12 14:43:00');
INSERT INTO `sys_job_log` VALUES (263238, '同步失败-运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'9\')', '同步失败-运营类型【重试】 总共耗时：1毫秒', '0', '', '2023-06-12 14:43:00');
INSERT INTO `sys_job_log` VALUES (263239, '同步失败-非运营类型【重试】', 'POLLING', 'emaiApiSynError.RetryCC(50,\'10\')', '同步失败-非运营类型【重试】 总共耗时：0毫秒', '0', '', '2023-06-12 14:43:00');
INSERT INTO `sys_job_log` VALUES (263240, '短信下发执行', 'SYSTEM', 'cardSmsTask.SynPacketCount(\'1\')', '短信下发执行 总共耗时：1毫秒', '0', '', '2023-06-12 14:43:00');

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor`  (
  `info_id` bigint NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '操作系统',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '提示消息',
  `login_time` datetime NULL DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 17842 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '系统访问记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------
INSERT INTO `sys_logininfor` VALUES (17842, 'admin', '127.0.0.1', '内网IP', 'Chrome 11', 'Windows 10', '0', '登录成功', '2023-06-12 10:38:43');
INSERT INTO `sys_logininfor` VALUES (17843, 'admin', '127.0.0.1', '内网IP', 'Chrome 11', 'Windows 10', '1', '用户不存在/密码错误', '2023-06-12 14:19:35');
INSERT INTO `sys_logininfor` VALUES (17844, 'admin', '127.0.0.1', '内网IP', 'Chrome 11', 'Windows 10', '0', '登录成功', '2023-06-12 14:19:50');

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu`  (
  `menu_id` bigint NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '菜单名称',
  `parent_id` bigint NULL DEFAULT 0 COMMENT '父菜单ID',
  `order_num` int NULL DEFAULT 0 COMMENT '显示顺序',
  `path` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '组件路径',
  `is_frame` int NULL DEFAULT 1 COMMENT '是否为外链（0是 1否）',
  `is_cache` int NULL DEFAULT 0 COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2327 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '菜单权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES (1, '系统管理', 0, 51, 'system', NULL, 1, 0, 'M', '0', '0', '', 'system', 'admin', '2021-06-05 09:12:09', 'admin', '2021-08-06 12:29:06', '系统管理目录');
INSERT INTO `sys_menu` VALUES (2, '系统监控', 1, 52, 'monitor', NULL, 1, 0, 'M', '0', '0', '', 'monitor', 'admin', '2021-06-05 09:12:09', 'admin', '2022-01-15 15:13:01', '系统监控目录');
INSERT INTO `sys_menu` VALUES (3, '研发工具', 1, 53, 'tool', NULL, 1, 0, 'M', '0', '0', '', 'tool', 'admin', '2021-06-05 09:12:09', 'admin', '2022-01-15 15:13:08', '系统工具目录');
INSERT INTO `sys_menu` VALUES (8, '关于IoTLink', 0, 2, 'iotlinkindex', 'Iotlinkindex', 1, 0, 'C', '0', '0', 'Iotlinkindex', 'button', 'admin', '2022-02-14 13:50:56', '', NULL, '');
INSERT INTO `sys_menu` VALUES (100, '内部管理', 2027, 99, 'user', 'system/user/index', 1, 0, 'C', '1', '1', 'system:user:list', 'star', 'admin', '2021-06-05 09:12:09', 'admin', '2022-03-30 15:45:12', '用户管理菜单');
INSERT INTO `sys_menu` VALUES (101, '角色管理', 2027, 6, 'role', 'system/role/index', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2021-06-05 09:12:09', 'admin', '2021-10-12 09:41:23', '角色管理菜单');
INSERT INTO `sys_menu` VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', 1, 0, 'C', '0', '0', 'system:menu:list', 'cascader', 'admin', '2021-06-05 09:12:09', 'admin', '2022-04-21 16:38:29', '菜单管理菜单');
INSERT INTO `sys_menu` VALUES (103, '企业管理', 2027, 1, 'dept', 'system/dept/index', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2021-06-05 09:12:09', 'admin', '2022-04-21 16:42:57', '部门管理菜单');
INSERT INTO `sys_menu` VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', 1, 0, 'C', '1', '0', 'system:post:list', 'post', 'admin', '2021-06-05 09:12:09', 'admin', '2022-04-11 15:32:16', '岗位管理菜单');
INSERT INTO `sys_menu` VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2021-06-05 09:12:09', '', NULL, '字典管理菜单');
INSERT INTO `sys_menu` VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2021-06-05 09:12:09', '', NULL, '参数设置菜单');
INSERT INTO `sys_menu` VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2021-06-05 09:12:09', '', NULL, '通知公告菜单');
INSERT INTO `sys_menu` VALUES (108, '日志管理', 1, 9, 'log', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2021-06-05 09:12:09', '', NULL, '日志管理菜单');
INSERT INTO `sys_menu` VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2021-06-05 09:12:09', '', NULL, '在线用户菜单');
INSERT INTO `sys_menu` VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2021-06-05 09:12:09', '', NULL, '定时任务菜单');
INSERT INTO `sys_menu` VALUES (111, '数据监控', 2, 3, 'druid', 'monitor/druid/index', 1, 0, 'C', '0', '0', 'monitor:druid:list', 'druid', 'admin', '2021-06-05 09:12:09', '', NULL, '数据监控菜单');
INSERT INTO `sys_menu` VALUES (112, '服务监控', 2, 4, 'server', 'monitor/server/index', 1, 0, 'C', '0', '0', 'monitor:server:list', 'server', 'admin', '2021-06-05 09:12:09', '', NULL, '服务监控菜单');
INSERT INTO `sys_menu` VALUES (113, '缓存监控', 2, 5, 'cache', 'monitor/cache/index', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis', 'admin', '2021-06-05 09:12:09', '', NULL, '缓存监控菜单');
INSERT INTO `sys_menu` VALUES (114, '表单构建', 3, 1, 'build', 'tool/build/index', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2021-06-05 09:12:09', '', NULL, '表单构建菜单');
INSERT INTO `sys_menu` VALUES (115, '代码生成', 3, 2, 'gen', 'tool/gen/index', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2021-06-05 09:12:09', '', NULL, '代码生成菜单');
INSERT INTO `sys_menu` VALUES (116, '系统接口', 3, 3, 'swagger', 'tool/swagger/index', 1, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2021-06-05 09:12:09', '', NULL, '系统接口菜单');
INSERT INTO `sys_menu` VALUES (500, '操作日志', 108, 1, 'operlog', 'monitor/operlog/index', 1, 0, 'C', '0', '0', 'monitor:operlog:list', 'form', 'admin', '2021-06-05 09:12:09', '', NULL, '操作日志菜单');
INSERT INTO `sys_menu` VALUES (501, '登录日志', 108, 2, 'logininfor', 'monitor/logininfor/index', 1, 0, 'C', '0', '0', 'monitor:logininfor:list', 'logininfor', 'admin', '2021-06-05 09:12:09', '', NULL, '登录日志菜单');
INSERT INTO `sys_menu` VALUES (1001, '用户查询', 100, 1, '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1002, '用户新增', 100, 2, '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1003, '用户修改', 100, 3, '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1004, '用户删除', 100, 4, '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1005, '用户导出', 100, 5, '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1006, '用户导入', 100, 6, '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1007, '重置密码', 100, 7, '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1008, '角色查询', 101, 1, '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1009, '角色新增', 101, 2, '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1010, '角色修改', 101, 3, '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1011, '角色删除', 101, 4, '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1012, '角色导出', 101, 5, '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1013, '菜单查询', 102, 1, '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1014, '菜单新增', 102, 2, '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1015, '菜单修改', 102, 3, '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1016, '菜单删除', 102, 4, '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1017, '部门查询', 103, 1, '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1018, '部门新增', 103, 2, '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1019, '部门修改', 103, 3, '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1020, '部门删除', 103, 4, '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1021, '岗位查询', 104, 1, '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1022, '岗位新增', 104, 2, '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1023, '岗位修改', 104, 3, '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1024, '岗位删除', 104, 4, '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1025, '岗位导出', 104, 5, '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1026, '字典查询', 105, 1, '#', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1027, '字典新增', 105, 2, '#', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1028, '字典修改', 105, 3, '#', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1029, '字典删除', 105, 4, '#', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1030, '字典导出', 105, 5, '#', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1031, '参数查询', 106, 1, '#', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1032, '参数新增', 106, 2, '#', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1033, '参数修改', 106, 3, '#', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1034, '参数删除', 106, 4, '#', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1035, '参数导出', 106, 5, '#', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1036, '公告查询', 107, 1, '#', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1037, '公告新增', 107, 2, '#', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1038, '公告修改', 107, 3, '#', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1039, '公告删除', 107, 4, '#', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1040, '操作查询', 500, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1041, '操作删除', 500, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1042, '日志导出', 500, 4, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1043, '登录查询', 501, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1044, '登录删除', 501, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1045, '日志导出', 501, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1046, '在线查询', 109, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1047, '批量强退', 109, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1048, '单条强退', 109, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1049, '任务查询', 110, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1050, '任务新增', 110, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1051, '任务修改', 110, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1052, '任务删除', 110, 4, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1053, '状态修改', 110, 5, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1054, '任务导出', 110, 7, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1055, '生成查询', 115, 1, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1056, '生成修改', 115, 2, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1057, '生成删除', 115, 3, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1058, '导入代码', 115, 2, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1059, '预览代码', 115, 4, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1060, '生成代码', 115, 5, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2000, '通信管理', 0, 19, 'card', NULL, 1, 0, 'M', '0', '0', '', 'excel', 'admin', '2021-06-05 10:59:36', 'admin', '2022-06-21 12:25:32', '');
INSERT INTO `sys_menu` VALUES (2001, '物联卡管理', 2000, 0, 'card', 'yunze/flowcard/card/index', 1, 0, 'C', '0', '0', 'yunze:card:list', 'date', 'admin', '2021-06-05 11:00:26', 'admin', '2021-10-30 10:55:32', '');
INSERT INTO `sys_menu` VALUES (2003, '详情查询', 2001, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:find', '#', 'admin', '2021-06-09 13:48:19', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2004, '查询套餐信息', 2001, 99, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryflow', '#', 'admin', '2021-06-09 13:51:13', 'admin', '2021-06-11 14:20:22', '');
INSERT INTO `sys_menu` VALUES (2005, '在线信息查询', 2003, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryOnlineStatus', '#', 'admin', '2021-06-11 09:21:29', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2006, '套餐简要信息查询', 2003, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:queryflowSimple', '#', 'admin', '2021-06-11 09:23:33', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2008, '查询简要套餐名称', 2001, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:queryPackageSimple', '#', 'admin', '2021-06-11 14:20:13', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2009, '导出', 2001, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:exportData', '#', 'admin', '2021-06-15 12:34:30', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2010, '查询API通道名称', 2001, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:findSp', '#', 'admin', '2021-06-15 17:10:14', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2011, '查询参数API通道', 2001, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryParamsChannelId', '#', 'admin', '2021-06-16 09:13:34', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2012, '物联卡通道', 2000, 22, 'channel', NULL, 1, 0, 'M', '0', '0', '', 'tree', 'admin', '2021-06-19 11:22:42', 'admin', '2022-01-15 15:27:33', '');
INSERT INTO `sys_menu` VALUES (2013, '通道管理', 2012, 0, 'cardRoute', 'yunze/API/cardRoute/index', 1, 0, 'C', '0', '0', 'yunze:cardRoute:list', 'cascader', 'admin', '2021-06-19 12:27:16', 'admin', '2022-01-15 15:29:48', '');
INSERT INTO `sys_menu` VALUES (2014, '通道详情', 2013, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:find', '#', 'admin', '2021-06-21 09:04:27', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2015, '通道编辑', 2013, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:edit', '#', 'admin', '2021-06-21 09:04:43', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2016, '通道删除', 2013, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:remove', '#', 'admin', '2021-06-21 09:04:59', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2017, '查询公司所属', 0, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:listAgent', '#', 'admin', '2021-06-21 11:18:33', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2018, '执行日志', 108, 0, 'ExecutionTask', 'yunze/flowcard/executionTask', 1, 0, 'C', '0', '0', 'yunze:ExecutionTask:list', 'server', 'admin', '2021-06-21 13:39:44', 'admin', '2022-01-15 15:32:06', '');
INSERT INTO `sys_menu` VALUES (2019, '执行任务下载', 2018, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:executionTask:download', '#', 'admin', '2021-06-21 14:32:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2020, '平台资费', 2109, 1, 'tariffGroup', 'yunze/flowcard/tariffGroup/index', 1, 0, 'C', '0', '0', 'yunze:tariffGroup:list', 'validCode', 'admin', '2021-06-22 10:44:50', 'admin', '2021-10-30 10:58:51', '');
INSERT INTO `sys_menu` VALUES (2021, '客户资费', 2109, 2, 'agentTariffGroup', 'yunze/flowcard/tariffGroup/agent', 1, 0, 'C', '0', '0', 'yunze:agentTariffGroup:list', 'validCode', 'admin', '2021-06-22 11:58:20', 'admin', '2022-03-03 15:38:56', '');
INSERT INTO `sys_menu` VALUES (2022, '平台资费组新增', 2020, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:add', '#', 'admin', '2021-06-23 16:00:39', 'admin', '2021-06-23 16:17:58', '');
INSERT INTO `sys_menu` VALUES (2023, '平台资费组编辑', 2020, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:edit', '#', 'admin', '2021-06-23 16:14:55', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2024, '平台资费计划新增', 2020, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:add', '#', 'admin', '2021-06-23 16:16:22', 'admin', '2022-04-28 14:08:03', '');
INSERT INTO `sys_menu` VALUES (2025, '平台资费计划详情', 2020, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:find', '#', 'admin', '2021-06-23 16:17:05', 'admin', '2022-04-28 14:08:10', '');
INSERT INTO `sys_menu` VALUES (2026, '平台资费计划编辑', 2020, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:edit', '#', 'admin', '2021-06-23 16:17:43', 'admin', '2022-04-28 14:08:15', '');
INSERT INTO `sys_menu` VALUES (2027, '账号管理', 2125, 0, 'agent', NULL, 1, 0, 'M', '0', '0', '', 'peoples', 'admin', '2021-06-25 09:29:24', 'admin', '2022-01-15 15:09:04', '');
INSERT INTO `sys_menu` VALUES (2028, '企业列表', 2027, 98, 'agent', 'yunze/user/agent/index', 1, 0, 'C', '1', '1', 'yunze:agent:list', 'excel', 'admin', '2021-06-25 09:32:10', 'admin', '2022-03-30 15:45:01', '');
INSERT INTO `sys_menu` VALUES (2029, '用户查询', 2028, 1, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2030, '用户新增', 2028, 2, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2031, '用户修改', 2028, 3, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2032, '用户删除', 2028, 4, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2033, '用户导出', 2028, 5, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2034, '用户导入', 2028, 6, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2035, '重置密码', 2028, 7, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2037, '划分资费查看', 2028, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:agent:DividePlan', '#', 'admin', '2021-06-28 14:03:36', 'admin', '2021-06-28 14:14:43', '');
INSERT INTO `sys_menu` VALUES (2038, '划分保存', 2037, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:tariffDivision', '#', 'admin', '2021-06-28 14:15:33', 'admin', '2021-06-28 14:39:09', '');
INSERT INTO `sys_menu` VALUES (2039, '资费组查询', 2037, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:findPackage', '#', 'admin', '2021-06-28 14:17:37', 'admin', '2021-06-28 14:18:03', '');
INSERT INTO `sys_menu` VALUES (2040, '资费计划查询', 2037, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:findPacket', '#', 'admin', '2021-06-28 14:39:01', 'admin', '2021-06-28 14:40:33', '');
INSERT INTO `sys_menu` VALUES (2041, '用户信息', 2027, 2, 'agentUser', 'yunze/user/agentUser/index', 1, 0, 'C', '0', '0', 'yunze:agent:list', 'user', 'admin', '2021-06-25 09:32:10', 'admin', '2022-04-21 16:43:03', '');
INSERT INTO `sys_menu` VALUES (2042, '用户查询', 2041, 1, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2043, '用户新增', 2041, 2, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2044, '用户修改', 2041, 3, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2045, '用户删除', 2041, 4, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2048, '重置密码', 2041, 7, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2050, '划分资费查看', 2041, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:agent:DividePlan', '#', 'admin', '2021-06-28 14:03:36', 'admin', '2021-06-28 14:14:43', '');
INSERT INTO `sys_menu` VALUES (2051, '划分保存', 2050, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:agentTariffDivision', '#', 'admin', '2021-06-28 14:15:33', 'admin', '2021-06-29 13:33:58', '');
INSERT INTO `sys_menu` VALUES (2052, '资费组查询', 2050, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:findPackage', '#', 'admin', '2021-06-28 14:17:37', 'admin', '2021-06-28 14:18:03', '');
INSERT INTO `sys_menu` VALUES (2053, '资费计划查询', 2050, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:findPacket', '#', 'admin', '2021-06-28 14:39:01', 'admin', '2021-06-28 14:40:33', '');
INSERT INTO `sys_menu` VALUES (2058, '卡板划分', 2001, 7, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:divide', '#', 'admin', '2021-07-02 10:00:00', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2059, '部门所属人员查询', 2058, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:findDeptUser', '#', 'admin', '2021-07-02 10:01:49', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2060, '同步用量', 2001, 8, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:SynFlow', '#', 'admin', '2021-07-21 18:04:29', 'admin', '2021-07-21 18:05:02', '');
INSERT INTO `sys_menu` VALUES (2061, '同步状态', 2001, 9, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:SynStatus', '#', 'admin', '2021-07-21 18:04:46', 'admin', '2021-07-21 18:05:08', '');
INSERT INTO `sys_menu` VALUES (2062, '机卡解绑', 2001, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:CardBinding', '#', 'admin', '2021-07-26 13:09:59', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2063, '订单管理', 2125, 23, 'order', NULL, 1, 0, 'M', '0', '0', '', 'chart', 'admin', '2021-08-06 12:28:49', 'admin', '2022-08-03 11:17:48', '');
INSERT INTO `sys_menu` VALUES (2064, '系统订单', 2063, 10, 'OrderAll', 'yunze/order/ordeAll', 1, 0, 'C', '0', '0', 'yunze:order:list', 'chart', 'admin', '2021-08-06 12:32:11', 'admin', '2022-04-11 15:32:49', '');
INSERT INTO `sys_menu` VALUES (2065, '订单列表查询', 2063, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:list', '#', 'admin', '2021-08-06 12:32:56', 'admin', '2021-08-06 12:33:03', '');
INSERT INTO `sys_menu` VALUES (2066, '可查询删除订单', 2063, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:dellist', '#', 'admin', '2021-08-09 11:04:05', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2067, '手动执行加包', 2063, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:manualaddPackage', '#', 'admin', '2021-08-09 11:13:19', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2068, '金额订单', 2063, 11, 'OrderMoney', 'yunze/order/orderMoney', 1, 0, 'C', '0', '0', 'yunze:order:list', 'money', 'admin', '2021-08-09 11:51:56', 'admin', '2021-08-09 11:52:37', '');
INSERT INTO `sys_menu` VALUES (2069, '资费订单', 2063, 12, 'OrderTariff', 'yunze/order/orderTariff', 1, 0, 'C', '0', '0', 'yunze:order:list', 'size', 'admin', '2021-08-09 12:03:34', 'admin', '2021-09-27 10:17:37', '');
INSERT INTO `sys_menu` VALUES (2070, '订单详情', 2063, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:findOrder', '#', 'admin', '2021-08-10 17:08:32', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2071, '资费订购', 2109, 3, 'rechargeTariff', 'yunze/flowcard/rechargeTariff/index', 1, 0, 'C', '0', '0', 'yunze:order:addPackage', 'money', 'admin', '2021-08-11 11:47:00', 'admin', '2022-03-03 15:38:35', '');
INSERT INTO `sys_menu` VALUES (2072, '查询单条 资费计划  简要', 2071, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:FindPacket', '#', 'admin', '2021-08-12 11:04:20', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2073, '物联卡设置', 2000, 1, 'cardSetting', 'yunze/flowcard/cardSetting/index', 1, 0, 'C', '0', '0', 'yunze:card:Setting', 'system', 'admin', '2021-08-17 08:23:21', 'admin', '2021-10-30 11:06:55', '');
INSERT INTO `sys_menu` VALUES (2074, '划分通道获取通道名称', 2073, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:findCr', '#', 'admin', '2021-08-17 12:16:00', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2075, '平台导入充值', 2071, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:importRecharge', '#', 'admin', '2021-08-18 11:33:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2076, '连接管理导入设置', 2073, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:importSet', '#', 'admin', '2021-08-18 11:35:15', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2079, '特殊操作', 3, 4, 'specialOperation', 'yunze/specialOperation/index', 1, 0, 'C', '0', '0', 'yunze:card:importSelImei', 'system', 'admin', '2021-08-20 15:09:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2080, '导入', 2001, 11, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:import', '#', 'admin', '2021-08-23 15:47:34', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2081, '是否内部人员', 0, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:sys:internal', '#', 'admin', '2021-09-03 14:24:54', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2082, '用量详情', 2109, 7, 'flowhis', 'yunze/flowcard/card/cardFlowHis', 1, 0, 'C', '1', '0', 'yunze:flowhis:list', 'monitor', 'admin', '2021-08-25 10:55:35', 'admin', '2022-04-22 13:28:11', '');
INSERT INTO `sys_menu` VALUES (2084, '通道轮询', 2012, 2, 'polling', 'yunze/API/polling/index', 1, 0, 'C', '0', '0', 'yunze:polling:list', 'online', 'admin', '2021-08-26 11:19:57', 'admin', '2022-01-15 15:29:41', '');
INSERT INTO `sys_menu` VALUES (2085, '订购历史', 2109, 6, 'flow', 'yunze/flowcard/card/cardFlow', 1, 0, 'C', '0', '0', 'yunze:flow:list', 'cardActivation', 'admin', '2021-09-02 08:48:44', 'admin', '2022-04-21 16:39:05', '');
INSERT INTO `sys_menu` VALUES (2086, '系统日志', 108, 3, 'sysLog', 'yunze/system/sysLog/index', 1, 0, 'C', '0', '0', 'yunze:sysLog:list', 'skill', 'admin', '2021-08-23 14:53:03', 'admin', '2022-01-15 15:31:59', '');
INSERT INTO `sys_menu` VALUES (2087, '订购资费查询', 2001, 12, '', NULL, 1, 0, 'F', '0', '0', 'yunze:flow:list', '#', 'admin', '2021-09-18 09:31:28', 'admin', '2021-09-30 14:47:33', '');
INSERT INTO `sys_menu` VALUES (2088, '导入查询', 2001, 13, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ImportQuery', '#', 'admin', '2021-09-23 09:22:31', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2089, '购物订单', 2063, 13, 'OrderShopping', 'yunze/order/OrderShopping', 1, 0, 'C', '0', '0', 'yunze:order:list', 'shopping', 'admin', '2021-09-27 10:16:46', 'admin', '2021-09-27 10:17:13', '');
INSERT INTO `sys_menu` VALUES (2090, '产品管理', 2116, 0, 'commodity', NULL, 1, 0, 'M', '0', '0', '', 'shopping', 'admin', '2021-09-27 12:25:41', 'admin', '2022-08-03 11:41:36', '');
INSERT INTO `sys_menu` VALUES (2091, '产品分类', 2090, 0, 'productCategory', 'yunze/commodity/prdCategory/index', 1, 0, 'C', '0', '0', 'yunze:shop:prdCategory', 'cascader', 'admin', '2021-09-27 13:20:05', 'admin', '2022-08-03 11:42:51', '');
INSERT INTO `sys_menu` VALUES (2092, '产品列表', 2090, 2, 'product', 'yunze/commodity/product/index', 1, 0, 'C', '0', '0', 'yunze:product:list', 'zip', 'admin', '2021-09-27 16:50:01', 'admin', '2022-08-03 11:47:12', '');
INSERT INTO `sys_menu` VALUES (2093, '卡信息变更查询', 2001, 14, '', NULL, 1, 0, 'F', '0', '0', 'yunze:change:list', '#', 'admin', '2021-09-27 13:31:00', 'admin', '2021-09-30 15:00:20', '');
INSERT INTO `sys_menu` VALUES (2094, '商品代理设置', 2092, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:productAgent:edit', '#', 'admin', '2021-09-30 08:39:59', 'admin', '2021-09-30 11:21:23', '');
INSERT INTO `sys_menu` VALUES (2096, '新增商品', 2092, 23, '', NULL, 1, 0, 'F', '0', '0', 'yunze:product:add', '#', 'admin', '2021-09-30 11:22:00', 'admin', '2021-09-30 11:22:08', '');
INSERT INTO `sys_menu` VALUES (2097, '编辑商品', 2092, 24, '', NULL, 1, 0, 'F', '0', '0', 'yunze:product:edit', '#', 'admin', '2021-09-30 11:22:39', 'admin', '2021-09-30 11:26:14', '');
INSERT INTO `sys_menu` VALUES (2098, '商品图片编辑', 2092, 25, '', NULL, 1, 0, 'F', '0', '0', 'yunze:productPic:Prdedit', '#', 'admin', '2021-09-30 11:23:22', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2099, '商品图片查看', 2092, 26, '', NULL, 1, 0, 'F', '0', '0', 'yunze:productPic:findList', '#', 'admin', '2021-09-30 11:23:48', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2100, '新增分类', 2091, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:prdCategory:save', '#', 'admin', '2021-09-30 11:26:48', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2101, '商品分类编辑', 2091, 22, '', NULL, 1, 0, 'F', '0', '0', 'yunze:prdCategory:upd', '#', 'admin', '2021-09-30 11:27:12', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2102, '查询发货订单', 2089, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:findShip', '#', 'admin', '2021-09-30 11:28:54', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2104, '用量详情', 2001, 16, '', NULL, 1, 0, 'F', '0', '0', 'yunze:flowhis:list', '#', 'admin', '2021-09-30 15:00:11', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2106, '变更卡分组、备注', 2001, 17, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:importSetCardInfo', 'system', 'admin', '2021-10-14 09:45:45', 'admin', '2021-10-14 17:30:18', '');
INSERT INTO `sys_menu` VALUES (2108, '设备管理', 2000, 8, 'card', 'yunze/flowcard/card/index', 1, 0, 'C', '0', '1', 'yunze:card:list', '#', 'admin', '2021-10-30 10:50:56', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2109, '物联卡资费', 2000, 21, 'TariffGroup', NULL, 1, 0, 'M', '0', '0', '', 'button', 'admin', '2021-10-30 10:58:35', 'admin', '2022-02-18 10:03:45', '');
INSERT INTO `sys_menu` VALUES (2110, '批量停复机、断开网', 2001, 18, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ApiUpdBatch', '#', 'admin', '2021-11-02 13:15:53', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2111, '规则管理', 2114, 1, 'cc', 'yunze/automation/cc/index', 1, 0, 'C', '0', '0', 'yunze:cc:list', 'email', 'admin', '2021-10-13 13:46:33', 'admin', '2022-01-15 15:37:15', '');
INSERT INTO `sys_menu` VALUES (2112, '推送记录', 2114, 3, 'cchis', 'yunze/automation/cchis/index', 1, 0, 'C', '0', '0', 'yunze:cchis:list', 'form', 'admin', '2021-10-19 15:27:32', 'admin', '2022-01-15 15:34:05', '');
INSERT INTO `sys_menu` VALUES (2113, '推送配置', 2114, 2, 'ccurl', 'yunze/automation/ccurl/index', 1, 0, 'C', '0', '0', 'yunze:ccurl:list', 'upload', 'admin', '2021-10-19 16:59:20', 'admin', '2022-01-15 15:33:57', '');
INSERT INTO `sys_menu` VALUES (2114, '自动化规则', 0, 26, 'loglog', NULL, 1, 0, 'M', '0', '0', '', 'guide', 'admin', '2021-10-13 13:39:34', 'admin', '2022-01-15 15:11:17', '');
INSERT INTO `sys_menu` VALUES (2115, '同步激活时间', 2001, 19, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:SynActivateDate', '#', 'admin', '2021-11-16 10:02:52', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2116, '仓库管理', 0, 25, 'warehouse', NULL, 1, 0, 'M', '0', '0', '', 'tab', 'admin', '2021-11-17 08:32:14', 'admin', '2021-11-17 08:33:11', '');
INSERT INTO `sys_menu` VALUES (2122, 'B端商品', 2090, 3, 'BCommodity', NULL, 1, 0, 'M', '1', '0', '', 'phone', 'admin', '2021-12-03 14:26:05', 'admin', '2022-08-03 11:46:06', '');
INSERT INTO `sys_menu` VALUES (2125, '客户管理', 0, 20, 'market', NULL, 1, 0, 'M', '0', '0', '', 'server', 'admin', '2021-12-07 12:14:02', 'admin', '2022-01-15 15:08:20', '');
INSERT INTO `sys_menu` VALUES (2137, '导出订单', 2063, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:outOrder', '#', 'admin', '2021-12-08 16:39:06', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2153, '勾选式停机', 2001, 20, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:Stopped', '#', 'admin', '2021-12-28 09:04:24', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2154, '勾选式复机', 2001, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:MachineArr', '#', 'admin', '2021-12-28 09:04:52', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2155, '勾选式断网', 2001, 22, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:DisconnectNetworkArr', '#', 'admin', '2021-12-28 09:05:18', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2156, '勾选式开网', 2001, 23, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:OpenNetworkArr', '#', 'admin', '2021-12-28 09:05:38', 'admin', '2021-12-28 09:06:00', '');
INSERT INTO `sys_menu` VALUES (2158, '获取自定义字典', 1, 30, '', NULL, 1, 0, 'F', '0', '0', 'yunze:Administration:type', '#', 'admin', '2021-12-30 11:30:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2167, '勾选式批量同步用量', 2001, 24, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ConsumptionArr', '#', 'admin', '2022-01-10 10:24:57', 'admin', '2022-01-10 10:26:46', '');
INSERT INTO `sys_menu` VALUES (2168, '勾选式同步状态', 2001, 25, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:PublicMethodArr', '#', 'admin', '2022-01-10 10:25:15', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2169, '勾选式同步状态和用量', 2001, 26, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ConsumptionAndStateArr', '#', 'admin', '2022-01-10 10:25:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2170, '获取自动化管理抄送名字', 2114, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cc:nameadd', '#', 'admin', '2022-01-12 10:41:45', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2172, '首页加载', 0, 27, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:findToDay', '#', 'admin', '2022-01-26 10:15:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2173, '已停机数量', 2172, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:downCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2175, '超用量数量', 2172, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:overdoseCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2176, '快到期数量', 2172, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:expiringSoonCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2177, '已达阈值数量', 2172, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:thresholdReachedCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2178, 'Sim卡总数', 2172, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:simCardCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2179, 'Sim卡本月新增数量', 2172, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:simCardNewCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2180, '本月数据用量GB', 2172, 7, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:currentMonth', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2181, 'SIm卡活跃度', 2172, 8, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:simActivity', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2182, '生命周期分布', 2172, 9, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:lifeCycleDistribution', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2183, '业务使用情况-数据', 2172, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:businessVolumeFlow', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2184, '业务使用情况-语音', 2172, 11, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:businessVolumeVoice', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2185, '业务使用情况-短信', 2172, 12, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:businessVolumeMessage', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2186, '客户总数', 2172, 13, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:customerCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2190, '微信订单收款', 2172, 17, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:weChatOrderCollection', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2191, '本月订单总金额', 2172, 18, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:orderAmount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2192, '系统企业总数', 2172, 19, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:systemCliqueCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2193, '系统用户总数', 2172, 20, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:systemUserCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2194, '本月激活卡数', 2172, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:activationCardCount', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2195, '本月发货卡数', 2172, 22, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:shipCard', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2196, '本月登录ip总数', 2172, 23, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:logInIp', '#', 'admin', '2022-01-26 10:16:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2197, '在线用户', 2172, 24, '', NULL, 1, 0, 'F', '0', '0', 'yunze:index:onlineCount', '#', 'admin', '2022-01-26 16:37:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2202, '物联卡诊断', 2000, 19, 'diagnosis', 'yunze/flowcard/diagnosis/index', 1, 0, 'C', '0', '0', 'yunze:card:diagnosis', 'druid', 'admin', '2022-02-15 10:20:29', 'admin', '2022-02-18 10:04:40', '');
INSERT INTO `sys_menu` VALUES (2203, '物联卡匹对', 2202, 6, 'cardMatch', 'yunze/flowcard/cardMatch/index', 1, 0, 'F', '0', '0', 'yunze:card:cardMatch', 'search', 'admin', '2022-02-18 10:01:46', 'admin', '2022-03-24 15:35:54', '');
INSERT INTO `sys_menu` VALUES (2204, '授信', 103, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:dept:credit', '#', 'admin', '2022-02-25 15:15:12', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2205, '企业预存', 103, 6, 'deptPrestore', 'yunze/system/deptPrestore/index', 1, 0, 'F', '0', '0', 'system:dept:prestore', 'money', 'admin', '2022-03-01 11:37:00', 'admin', '2022-03-01 16:07:10', '');
INSERT INTO `sys_menu` VALUES (2206, '企业预存-微信支付', 103, 7, '', NULL, 1, 0, 'F', '0', '0', 'yunze:dept:initiatePreSave', '#', 'admin', '2022-03-01 16:07:03', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2208, 'API使用', 2209, 5, 'apifile', 'tool/apifile/index', 1, 0, 'C', '0', '0', 'tool:apifile:list', 'slider', 'admin', '2022-02-17 13:31:29', 'admin', '2022-03-02 17:59:51', '');
INSERT INTO `sys_menu` VALUES (2209, 'API集成', 1, 54, 'AapIntegrated', NULL, 1, 0, 'M', '0', '0', NULL, 'Ip', 'admin', '2022-03-02 17:35:48', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2214, '批量取消实名', 2001, 27, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:cancelrealname', '#', 'admin', '2022-03-03 09:48:48', 'admin', '2022-03-03 09:48:58', '');
INSERT INTO `sys_menu` VALUES (2219, '用量详情导出', 2082, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:flowhis:exportflowhis', '#', 'admin', '2022-03-03 10:01:41', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2238, '单卡停机原因查询', 2202, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:simStopReason', '#', 'admin', '2022-03-04 09:09:11', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2239, '单卡开关机状态实时查询', 2202, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:onOffStatus', '#', 'admin', '2022-03-04 09:09:29', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2240, '单卡已开通APN信息查询', 2202, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:apnInfo', '#', 'admin', '2022-03-04 09:09:43', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2241, '物联卡机卡分离状态查询', 2202, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:cardBindStatus', '#', 'admin', '2022-03-04 09:10:00', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2242, '单卡状态变更历史查询', 2202, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:simChangeHistory', '#', 'admin', '2022-03-04 09:10:14', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2252, '卡信息更新', 2001, 28, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:replace', '#', 'admin', '2022-03-14 14:52:58', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2253, '划分资费系统内部使用', 2041, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:sys:DividePlan', '#', 'admin', '2022-03-29 14:22:06', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2254, '灵活变更状态', 2001, 29, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:fbestate', '#', 'admin', '2022-03-25 13:33:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2256, '上游套餐', 2109, 8, 'cardSetmeal', 'yunze/flowcard/cardSetmeal/index', 1, 0, 'C', '0', '0', 'yunze:cardSetmeal:list', 'used', 'admin', '2022-04-11 13:16:38', 'admin', '2022-04-11 13:18:17', '');
INSERT INTO `sys_menu` VALUES (2257, 'API账号', 2027, 4, 'apiAccount', 'yunze/user/apiUser/index', 1, 0, 'C', '0', '0', 'yunze:apiAccount:list', 'api', 'admin', '2022-04-21 16:42:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2258, '新增', 2257, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:apiAccount:save', '#', 'admin', '2022-04-21 16:49:24', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2259, '修改', 2257, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:apiAccount:upd', '#', 'admin', '2022-04-21 16:49:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2260, '删除', 2257, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:apiAccount:del', '#', 'admin', '2022-04-22 16:30:27', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2261, '获取agent_id下appId', 2257, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:apiAccount:find', '#', 'admin', '2022-04-22 16:30:48', 'admin', '2022-04-22 16:31:23', '');
INSERT INTO `sys_menu` VALUES (2262, '可访问接口设置', 2257, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:apiAccount:updPermission', '#', 'admin', '2022-04-24 17:38:17', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2263, '上游已订购套餐', 2109, 9, 'offeringinfolist', 'yunze/flowcard/offeringinfolist/index', 1, 0, 'C', '0', '0', 'yunze:offeringinfolist:list', 'post', 'admin', '2022-04-25 11:21:17', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2264, '上游资费组管理', 2109, 10, 'offeringinfo', 'yunze/flowcard/offeringinfo/index', 1, 0, 'C', '0', '0', 'yunze_offeringinfo_list', 'button', 'admin', '2022-04-25 13:47:20', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2265, '删除按钮', 2264, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:offeringinfo:delete', '#', 'admin', '2022-04-26 14:08:20', 'admin', '2022-04-28 15:25:51', '');
INSERT INTO `sys_menu` VALUES (2266, '修改按钮', 2264, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:offeringinfo:update', '#', 'admin', '2022-04-26 14:08:46', 'admin', '2022-04-28 15:26:03', '');
INSERT INTO `sys_menu` VALUES (2267, '上游单卡订购套餐列表', 2001, 30, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:selUsage', '#', 'admin', '2022-04-28 11:46:17', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2268, '上游套餐记录列表', 2001, 34, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:reminder', '#', 'admin', '2022-04-28 11:46:43', 'admin', '2022-08-16 10:26:44', '');
INSERT INTO `sys_menu` VALUES (2269, '通道查询资费组', 2013, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:packageRoute', '#', 'admin', '2022-04-28 13:52:01', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2270, '平台资费组详情', 2020, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:find', '#', 'admin', '2022-04-28 14:07:53', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2271, '上游订购套餐查询', 2001, 32, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryOffering', '#', 'admin', '2022-05-07 10:18:13', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2272, '同步用量和状态', 2001, 35, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:InfoFlow', '#', 'admin', '2022-05-07 16:02:54', 'admin', '2022-08-16 10:27:00', '');
INSERT INTO `sys_menu` VALUES (2273, '变更分组及备注', 2001, 31, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:singleUpd', '#', 'admin', '2022-05-07 16:03:37', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2274, '单卡灵活变更状态', 2001, 33, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:singleState', '#', 'admin', '2022-05-07 16:04:19', 'admin', '2022-08-16 10:25:12', '');
INSERT INTO `sys_menu` VALUES (2275, '轮询错误详情', 2, 6, 'error', 'monitor/error/index', 1, 0, 'C', '0', '0', 'monitor:error:list', 'bug', 'admin', '2022-05-16 10:03:03', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2276, '轮询错误概要', 2, 7, 'group', 'monitor/group/index', 1, 0, 'C', '0', '0', 'monitor:group:list', '404', 'admin', '2022-05-16 10:04:49', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2277, '修改', 2264, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:error:upd', '#', 'admin', '2022-05-17 16:11:02', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2278, '删除', 2264, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:error:del', '#', 'admin', '2022-05-17 16:11:22', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2279, '批量修改', 2264, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:error:updArr', '#', 'admin', '2022-05-17 16:11:43', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2280, '批量删除', 2264, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:error:delArr', '#', 'admin', '2022-05-17 16:12:04', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2281, '修改', 2265, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:group:upd', '#', 'admin', '2022-05-17 16:12:28', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2282, '删除', 2265, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:group:del', '#', 'admin', '2022-05-17 16:12:44', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2283, '批量修改', 2265, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:group:updArr', '#', 'admin', '2022-05-17 16:13:12', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2284, '批量删除', 2265, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:group:delArr', '#', 'admin', '2022-05-17 16:13:34', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2285, '导出', 2274, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:businessDtails:export', '#', 'admin', '2022-05-27 14:45:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2286, '批量业务受理', 108, 4, 'batchBusiness', 'yunze/flowcard/batchBusiness/index', 1, 0, 'C', '0', '0', 'yunze:batchBusiness:list', 'druid', 'admin', '2022-05-25 16:15:38', 'admin', '2022-05-31 09:12:53', '');
INSERT INTO `sys_menu` VALUES (2288, '查询批量业务详情', 2286, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:businessDtails:success', '#', 'admin', '2022-05-31 15:09:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2289, '批量业务导出', 2286, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:businessDtails:export', '#', 'admin', '2022-05-31 15:09:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2290, '通道新增', 2013, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:add', '#', 'admin', '2022-06-02 16:18:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2291, '通道导出', 2013, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:exportData', '#', 'admin', '2022-06-02 16:18:30', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2292, '退订', 2069, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:nobscribe', '#', 'admin', '2022-06-15 16:06:17', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2293, '执行加包', 2069, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:package', '#', 'admin', '2022-06-15 16:15:36', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2294, '续费查询', 2001, 34, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:Renewal', '#', 'admin', '2022-06-21 15:40:11', 'admin', '2022-08-16 10:25:20', '');
INSERT INTO `sys_menu` VALUES (2295, '续费进度', 2109, 0, 'applicationforRenewal', 'yunze/flowcard/applicationforRenewal/index', 1, 0, 'C', '0', '0', 'yunze:renewal:list', 'cardMaturity', 'admin', '2022-06-22 14:38:03', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2296, '续费申请新增', 2295, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:renewal:add', '#', 'admin', '2022-06-22 14:38:49', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2297, '续费详情修改', 2295, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:renewal:upd', '#', 'admin', '2022-06-22 14:39:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2298, '详情查看', 2295, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:renewal:find', '#', 'admin', '2022-06-24 11:23:13', 'admin', '2022-06-24 11:23:25', '');
INSERT INTO `sys_menu` VALUES (2299, '授信修改', 103, 8, '', NULL, 1, 0, 'F', '0', '0', 'yunze:dept:updCredit', '#', 'admin', '2022-06-25 00:28:29', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2300, '导出', 2020, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:export', '#', 'admin', '2022-05-30 10:33:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2301, '导出', 2021, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:agentTariffGroup:export', '#', 'admin', '2022-05-30 10:34:40', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2309, '导入查询', 2063, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:cardNumberAge', '#', 'admin', '2022-06-27 16:20:13', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2310, '选择运营商时加载出对应的通道', 2001, 15, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:operator', '#', 'admin', '2022-07-18 15:44:44', 'admin', '2022-08-16 10:27:30', '');
INSERT INTO `sys_menu` VALUES (2311, '企业预存-平台操作', 103, 9, '', NULL, 1, 0, 'F', '0', '0', 'yunze:dept:sysPreSaved', '#', 'admin', '2022-08-01 10:24:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2312, '预存抵扣-平台操作', 103, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:dept:sysDeduct', '#', 'admin', '2022-08-01 14:20:58', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2313, '平台文本域充值', 2071, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:TextRecharge', '#', 'admin', '2022-08-03 11:05:38', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2314, '企业文本域充值', 2071, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:DeptTextRecharge', '#', 'admin', '2022-08-04 10:47:53', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2321, '群组成员信息', 2012, 4, 'memberGroup', 'yunze/API/memberGroup/index', 1, 0, 'C', '0', '0', 'yunze:memberGroup:list', 'Ip', 'admin', '2022-09-23 10:07:12', 'admin', '2022-09-29 08:51:42', '');
INSERT INTO `sys_menu` VALUES (2322, '上游集团群组', 2012, 3, 'upSteam', 'yunze/API/upStream/index', 1, 0, 'C', '0', '0', 'yunze:upsteam:list', 'peoples', 'admin', '2022-09-28 13:40:05', 'admin', '2022-09-28 13:46:03', '');
INSERT INTO `sys_menu` VALUES (2325, '短信日志', 108, 6, 'smslog', 'yunze/flowcard/smslog/index', 1, 0, 'C', '0', '0', 'yunze:sysLog:list', 'button', 'admin', '2022-09-01 14:38:51', 'admin', '2022-09-01 14:55:21', '');
INSERT INTO `sys_menu` VALUES (2326, '短信业务受理', 108, 5, 'smsbatchBusiness', 'yunze/flowcard/smsbatchBusiness/index', 1, 0, 'C', '0', '0', 'yunze:smsbatchBusiness:list', 'message', 'admin', '2022-08-16 12:21:05', '', NULL, '');

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice`  (
  `notice_id` int NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '公告标题',
  `notice_type` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob NULL COMMENT '公告内容',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '通知公告表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_notice
-- ----------------------------

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log`  (
  `oper_id` bigint NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '模块标题',
  `business_type` int NULL DEFAULT 0 COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '请求方式',
  `operator_type` int NULL DEFAULT 0 COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '返回参数',
  `status` int NULL DEFAULT 0 COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`oper_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6409 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '操作日志记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post`  (
  `post_id` bigint NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '岗位名称',
  `post_sort` int NOT NULL COMMENT '显示顺序',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '岗位信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_post
-- ----------------------------
INSERT INTO `sys_post` VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `role_id` bigint NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '角色权限字符串',
  `role_sort` int NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '部门树选择项是否关联显示',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 29 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '角色信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2021-06-05 09:12:09', '', NULL, '超级管理员');
INSERT INTO `sys_role` VALUES (2, '集团客户', 'common', 2, '4', 1, 0, '0', '0', 'admin', '2021-06-05 09:12:09', '5iot', '2022-01-12 10:47:05', '普通角色');
INSERT INTO `sys_role` VALUES (3, '开发', 'development', 99, '1', 1, 1, '0', '0', 'admin', '2021-06-22 11:49:48', 'admin', '2021-11-19 10:46:15', NULL);
INSERT INTO `sys_role` VALUES (4, '用户', 'user', 3, '4', 1, 1, '0', '0', 'admin', '2021-06-25 09:11:37', 'admin', '2021-10-15 10:36:40', '3级');
INSERT INTO `sys_role` VALUES (5, '内部人员', 'adminUser', 5, '1', 0, 0, '0', '0', 'admin', '2021-07-06 10:17:03', 'admin', '2022-04-30 11:33:59', NULL);
INSERT INTO `sys_role` VALUES (6, '销售部经理', 'salesManager', 6, '1', 0, 0, '0', '0', 'admin', '2021-12-30 11:11:47', '5iot', '2022-01-12 10:49:40', NULL);
INSERT INTO `sys_role` VALUES (7, '销售业务员', 'Sales', 7, '1', 1, 1, '0', '0', 'admin', '2022-01-04 08:53:22', 'admin', '2022-01-05 17:25:45', NULL);
INSERT INTO `sys_role` VALUES (8, '仓库管理员', 'WarehouseManager', 8, '1', 1, 1, '0', '0', 'admin', '2022-01-04 14:02:35', 'admin', '2022-01-04 14:05:17', NULL);
INSERT INTO `sys_role` VALUES (9, '演示账号', 'testdome', 9, '1', 1, 1, '0', '0', 'admin', '2022-01-12 10:31:59', 'admin', '2022-09-05 11:02:54', NULL);
INSERT INTO `sys_role` VALUES (10, '财务', 'finance', 0, '1', 1, 1, '0', '0', 'admin', '2022-08-03 13:51:25', '', NULL, NULL);
INSERT INTO `sys_role` VALUES (19, '测试', 'ceshi', 1, '1', 0, 0, '1', '0', '5iot', '2022-10-10 11:38:07', 'admin', '2023-04-13 22:27:25', NULL);
INSERT INTO `sys_role` VALUES (20, '测试角色', '10', 0, '1', 1, 1, '0', '0', '5iot', '2022-12-23 10:12:18', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept`  (
  `role_id` bigint NOT NULL COMMENT '角色ID',
  `dept_id` bigint NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`, `dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '角色和部门关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_dept
-- ----------------------------

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu`  (
  `role_id` bigint NOT NULL COMMENT '角色ID',
  `menu_id` bigint NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '角色和菜单关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES (2, 1);
INSERT INTO `sys_role_menu` VALUES (2, 103);
INSERT INTO `sys_role_menu` VALUES (2, 108);
INSERT INTO `sys_role_menu` VALUES (2, 1017);
INSERT INTO `sys_role_menu` VALUES (2, 1018);
INSERT INTO `sys_role_menu` VALUES (2, 1019);
INSERT INTO `sys_role_menu` VALUES (2, 2000);
INSERT INTO `sys_role_menu` VALUES (2, 2001);
INSERT INTO `sys_role_menu` VALUES (2, 2003);
INSERT INTO `sys_role_menu` VALUES (2, 2004);
INSERT INTO `sys_role_menu` VALUES (2, 2005);
INSERT INTO `sys_role_menu` VALUES (2, 2006);
INSERT INTO `sys_role_menu` VALUES (2, 2008);
INSERT INTO `sys_role_menu` VALUES (2, 2009);
INSERT INTO `sys_role_menu` VALUES (2, 2018);
INSERT INTO `sys_role_menu` VALUES (2, 2019);
INSERT INTO `sys_role_menu` VALUES (2, 2027);
INSERT INTO `sys_role_menu` VALUES (2, 2041);
INSERT INTO `sys_role_menu` VALUES (2, 2042);
INSERT INTO `sys_role_menu` VALUES (2, 2043);
INSERT INTO `sys_role_menu` VALUES (2, 2044);
INSERT INTO `sys_role_menu` VALUES (2, 2048);
INSERT INTO `sys_role_menu` VALUES (2, 2050);
INSERT INTO `sys_role_menu` VALUES (2, 2051);
INSERT INTO `sys_role_menu` VALUES (2, 2052);
INSERT INTO `sys_role_menu` VALUES (2, 2053);
INSERT INTO `sys_role_menu` VALUES (2, 2058);
INSERT INTO `sys_role_menu` VALUES (2, 2059);
INSERT INTO `sys_role_menu` VALUES (2, 2060);
INSERT INTO `sys_role_menu` VALUES (2, 2061);
INSERT INTO `sys_role_menu` VALUES (2, 2071);
INSERT INTO `sys_role_menu` VALUES (2, 2072);
INSERT INTO `sys_role_menu` VALUES (2, 2088);
INSERT INTO `sys_role_menu` VALUES (2, 2106);
INSERT INTO `sys_role_menu` VALUES (2, 2109);
INSERT INTO `sys_role_menu` VALUES (2, 2125);
INSERT INTO `sys_role_menu` VALUES (2, 2167);
INSERT INTO `sys_role_menu` VALUES (2, 2168);
INSERT INTO `sys_role_menu` VALUES (2, 2169);
INSERT INTO `sys_role_menu` VALUES (2, 2206);
INSERT INTO `sys_role_menu` VALUES (2, 2208);
INSERT INTO `sys_role_menu` VALUES (2, 2209);
INSERT INTO `sys_role_menu` VALUES (2, 2257);
INSERT INTO `sys_role_menu` VALUES (2, 2259);
INSERT INTO `sys_role_menu` VALUES (2, 2261);
INSERT INTO `sys_role_menu` VALUES (2, 2286);
INSERT INTO `sys_role_menu` VALUES (2, 2288);
INSERT INTO `sys_role_menu` VALUES (2, 2295);
INSERT INTO `sys_role_menu` VALUES (2, 2296);
INSERT INTO `sys_role_menu` VALUES (2, 2298);
INSERT INTO `sys_role_menu` VALUES (2, 2314);
INSERT INTO `sys_role_menu` VALUES (3, 1);
INSERT INTO `sys_role_menu` VALUES (3, 2);
INSERT INTO `sys_role_menu` VALUES (3, 3);
INSERT INTO `sys_role_menu` VALUES (3, 100);
INSERT INTO `sys_role_menu` VALUES (3, 101);
INSERT INTO `sys_role_menu` VALUES (3, 102);
INSERT INTO `sys_role_menu` VALUES (3, 103);
INSERT INTO `sys_role_menu` VALUES (3, 104);
INSERT INTO `sys_role_menu` VALUES (3, 105);
INSERT INTO `sys_role_menu` VALUES (3, 106);
INSERT INTO `sys_role_menu` VALUES (3, 107);
INSERT INTO `sys_role_menu` VALUES (3, 108);
INSERT INTO `sys_role_menu` VALUES (3, 109);
INSERT INTO `sys_role_menu` VALUES (3, 110);
INSERT INTO `sys_role_menu` VALUES (3, 111);
INSERT INTO `sys_role_menu` VALUES (3, 112);
INSERT INTO `sys_role_menu` VALUES (3, 113);
INSERT INTO `sys_role_menu` VALUES (3, 114);
INSERT INTO `sys_role_menu` VALUES (3, 115);
INSERT INTO `sys_role_menu` VALUES (3, 116);
INSERT INTO `sys_role_menu` VALUES (3, 500);
INSERT INTO `sys_role_menu` VALUES (3, 501);
INSERT INTO `sys_role_menu` VALUES (3, 1001);
INSERT INTO `sys_role_menu` VALUES (3, 1002);
INSERT INTO `sys_role_menu` VALUES (3, 1003);
INSERT INTO `sys_role_menu` VALUES (3, 1004);
INSERT INTO `sys_role_menu` VALUES (3, 1005);
INSERT INTO `sys_role_menu` VALUES (3, 1006);
INSERT INTO `sys_role_menu` VALUES (3, 1007);
INSERT INTO `sys_role_menu` VALUES (3, 1008);
INSERT INTO `sys_role_menu` VALUES (3, 1009);
INSERT INTO `sys_role_menu` VALUES (3, 1010);
INSERT INTO `sys_role_menu` VALUES (3, 1011);
INSERT INTO `sys_role_menu` VALUES (3, 1012);
INSERT INTO `sys_role_menu` VALUES (3, 1013);
INSERT INTO `sys_role_menu` VALUES (3, 1014);
INSERT INTO `sys_role_menu` VALUES (3, 1015);
INSERT INTO `sys_role_menu` VALUES (3, 1016);
INSERT INTO `sys_role_menu` VALUES (3, 1017);
INSERT INTO `sys_role_menu` VALUES (3, 1018);
INSERT INTO `sys_role_menu` VALUES (3, 1019);
INSERT INTO `sys_role_menu` VALUES (3, 1020);
INSERT INTO `sys_role_menu` VALUES (3, 1021);
INSERT INTO `sys_role_menu` VALUES (3, 1022);
INSERT INTO `sys_role_menu` VALUES (3, 1023);
INSERT INTO `sys_role_menu` VALUES (3, 1024);
INSERT INTO `sys_role_menu` VALUES (3, 1025);
INSERT INTO `sys_role_menu` VALUES (3, 1026);
INSERT INTO `sys_role_menu` VALUES (3, 1027);
INSERT INTO `sys_role_menu` VALUES (3, 1028);
INSERT INTO `sys_role_menu` VALUES (3, 1029);
INSERT INTO `sys_role_menu` VALUES (3, 1030);
INSERT INTO `sys_role_menu` VALUES (3, 1031);
INSERT INTO `sys_role_menu` VALUES (3, 1032);
INSERT INTO `sys_role_menu` VALUES (3, 1033);
INSERT INTO `sys_role_menu` VALUES (3, 1034);
INSERT INTO `sys_role_menu` VALUES (3, 1035);
INSERT INTO `sys_role_menu` VALUES (3, 1036);
INSERT INTO `sys_role_menu` VALUES (3, 1037);
INSERT INTO `sys_role_menu` VALUES (3, 1038);
INSERT INTO `sys_role_menu` VALUES (3, 1039);
INSERT INTO `sys_role_menu` VALUES (3, 1040);
INSERT INTO `sys_role_menu` VALUES (3, 1041);
INSERT INTO `sys_role_menu` VALUES (3, 1042);
INSERT INTO `sys_role_menu` VALUES (3, 1043);
INSERT INTO `sys_role_menu` VALUES (3, 1044);
INSERT INTO `sys_role_menu` VALUES (3, 1045);
INSERT INTO `sys_role_menu` VALUES (3, 1046);
INSERT INTO `sys_role_menu` VALUES (3, 1047);
INSERT INTO `sys_role_menu` VALUES (3, 1048);
INSERT INTO `sys_role_menu` VALUES (3, 1049);
INSERT INTO `sys_role_menu` VALUES (3, 1050);
INSERT INTO `sys_role_menu` VALUES (3, 1051);
INSERT INTO `sys_role_menu` VALUES (3, 1053);
INSERT INTO `sys_role_menu` VALUES (3, 1054);
INSERT INTO `sys_role_menu` VALUES (3, 1055);
INSERT INTO `sys_role_menu` VALUES (3, 1056);
INSERT INTO `sys_role_menu` VALUES (3, 1057);
INSERT INTO `sys_role_menu` VALUES (3, 1058);
INSERT INTO `sys_role_menu` VALUES (3, 1059);
INSERT INTO `sys_role_menu` VALUES (3, 1060);
INSERT INTO `sys_role_menu` VALUES (3, 2000);
INSERT INTO `sys_role_menu` VALUES (3, 2001);
INSERT INTO `sys_role_menu` VALUES (3, 2003);
INSERT INTO `sys_role_menu` VALUES (3, 2004);
INSERT INTO `sys_role_menu` VALUES (3, 2005);
INSERT INTO `sys_role_menu` VALUES (3, 2006);
INSERT INTO `sys_role_menu` VALUES (3, 2008);
INSERT INTO `sys_role_menu` VALUES (3, 2009);
INSERT INTO `sys_role_menu` VALUES (3, 2010);
INSERT INTO `sys_role_menu` VALUES (3, 2011);
INSERT INTO `sys_role_menu` VALUES (3, 2012);
INSERT INTO `sys_role_menu` VALUES (3, 2013);
INSERT INTO `sys_role_menu` VALUES (3, 2014);
INSERT INTO `sys_role_menu` VALUES (3, 2015);
INSERT INTO `sys_role_menu` VALUES (3, 2016);
INSERT INTO `sys_role_menu` VALUES (3, 2017);
INSERT INTO `sys_role_menu` VALUES (3, 2018);
INSERT INTO `sys_role_menu` VALUES (3, 2019);
INSERT INTO `sys_role_menu` VALUES (3, 2020);
INSERT INTO `sys_role_menu` VALUES (3, 2021);
INSERT INTO `sys_role_menu` VALUES (3, 2022);
INSERT INTO `sys_role_menu` VALUES (3, 2023);
INSERT INTO `sys_role_menu` VALUES (3, 2024);
INSERT INTO `sys_role_menu` VALUES (3, 2025);
INSERT INTO `sys_role_menu` VALUES (3, 2026);
INSERT INTO `sys_role_menu` VALUES (3, 2027);
INSERT INTO `sys_role_menu` VALUES (3, 2028);
INSERT INTO `sys_role_menu` VALUES (3, 2029);
INSERT INTO `sys_role_menu` VALUES (3, 2030);
INSERT INTO `sys_role_menu` VALUES (3, 2031);
INSERT INTO `sys_role_menu` VALUES (3, 2032);
INSERT INTO `sys_role_menu` VALUES (3, 2033);
INSERT INTO `sys_role_menu` VALUES (3, 2034);
INSERT INTO `sys_role_menu` VALUES (3, 2035);
INSERT INTO `sys_role_menu` VALUES (3, 2037);
INSERT INTO `sys_role_menu` VALUES (3, 2038);
INSERT INTO `sys_role_menu` VALUES (3, 2039);
INSERT INTO `sys_role_menu` VALUES (3, 2040);
INSERT INTO `sys_role_menu` VALUES (3, 2041);
INSERT INTO `sys_role_menu` VALUES (3, 2042);
INSERT INTO `sys_role_menu` VALUES (3, 2043);
INSERT INTO `sys_role_menu` VALUES (3, 2044);
INSERT INTO `sys_role_menu` VALUES (3, 2045);
INSERT INTO `sys_role_menu` VALUES (3, 2048);
INSERT INTO `sys_role_menu` VALUES (3, 2050);
INSERT INTO `sys_role_menu` VALUES (3, 2051);
INSERT INTO `sys_role_menu` VALUES (3, 2052);
INSERT INTO `sys_role_menu` VALUES (3, 2053);
INSERT INTO `sys_role_menu` VALUES (3, 2058);
INSERT INTO `sys_role_menu` VALUES (3, 2059);
INSERT INTO `sys_role_menu` VALUES (3, 2060);
INSERT INTO `sys_role_menu` VALUES (3, 2061);
INSERT INTO `sys_role_menu` VALUES (3, 2062);
INSERT INTO `sys_role_menu` VALUES (3, 2063);
INSERT INTO `sys_role_menu` VALUES (3, 2064);
INSERT INTO `sys_role_menu` VALUES (3, 2065);
INSERT INTO `sys_role_menu` VALUES (3, 2066);
INSERT INTO `sys_role_menu` VALUES (3, 2067);
INSERT INTO `sys_role_menu` VALUES (3, 2068);
INSERT INTO `sys_role_menu` VALUES (3, 2069);
INSERT INTO `sys_role_menu` VALUES (3, 2070);
INSERT INTO `sys_role_menu` VALUES (3, 2071);
INSERT INTO `sys_role_menu` VALUES (3, 2072);
INSERT INTO `sys_role_menu` VALUES (3, 2073);
INSERT INTO `sys_role_menu` VALUES (3, 2074);
INSERT INTO `sys_role_menu` VALUES (3, 2075);
INSERT INTO `sys_role_menu` VALUES (3, 2076);
INSERT INTO `sys_role_menu` VALUES (3, 2079);
INSERT INTO `sys_role_menu` VALUES (3, 2080);
INSERT INTO `sys_role_menu` VALUES (3, 2081);
INSERT INTO `sys_role_menu` VALUES (3, 2082);
INSERT INTO `sys_role_menu` VALUES (3, 2084);
INSERT INTO `sys_role_menu` VALUES (3, 2085);
INSERT INTO `sys_role_menu` VALUES (3, 2087);
INSERT INTO `sys_role_menu` VALUES (3, 2088);
INSERT INTO `sys_role_menu` VALUES (3, 2089);
INSERT INTO `sys_role_menu` VALUES (3, 2090);
INSERT INTO `sys_role_menu` VALUES (3, 2091);
INSERT INTO `sys_role_menu` VALUES (3, 2092);
INSERT INTO `sys_role_menu` VALUES (3, 2093);
INSERT INTO `sys_role_menu` VALUES (3, 2094);
INSERT INTO `sys_role_menu` VALUES (3, 2096);
INSERT INTO `sys_role_menu` VALUES (3, 2097);
INSERT INTO `sys_role_menu` VALUES (3, 2098);
INSERT INTO `sys_role_menu` VALUES (3, 2099);
INSERT INTO `sys_role_menu` VALUES (3, 2100);
INSERT INTO `sys_role_menu` VALUES (3, 2101);
INSERT INTO `sys_role_menu` VALUES (3, 2102);
INSERT INTO `sys_role_menu` VALUES (3, 2104);
INSERT INTO `sys_role_menu` VALUES (3, 2105);
INSERT INTO `sys_role_menu` VALUES (3, 2106);
INSERT INTO `sys_role_menu` VALUES (3, 2107);
INSERT INTO `sys_role_menu` VALUES (3, 2108);
INSERT INTO `sys_role_menu` VALUES (3, 2109);
INSERT INTO `sys_role_menu` VALUES (3, 2110);
INSERT INTO `sys_role_menu` VALUES (3, 2115);
INSERT INTO `sys_role_menu` VALUES (3, 2116);
INSERT INTO `sys_role_menu` VALUES (3, 2117);
INSERT INTO `sys_role_menu` VALUES (3, 2118);
INSERT INTO `sys_role_menu` VALUES (3, 2119);
INSERT INTO `sys_role_menu` VALUES (3, 2120);
INSERT INTO `sys_role_menu` VALUES (3, 2121);
INSERT INTO `sys_role_menu` VALUES (3, 2122);
INSERT INTO `sys_role_menu` VALUES (3, 2123);
INSERT INTO `sys_role_menu` VALUES (3, 2124);
INSERT INTO `sys_role_menu` VALUES (3, 2125);
INSERT INTO `sys_role_menu` VALUES (3, 2126);
INSERT INTO `sys_role_menu` VALUES (3, 2127);
INSERT INTO `sys_role_menu` VALUES (3, 2128);
INSERT INTO `sys_role_menu` VALUES (3, 2129);
INSERT INTO `sys_role_menu` VALUES (3, 2130);
INSERT INTO `sys_role_menu` VALUES (3, 2131);
INSERT INTO `sys_role_menu` VALUES (3, 2132);
INSERT INTO `sys_role_menu` VALUES (3, 2133);
INSERT INTO `sys_role_menu` VALUES (3, 2134);
INSERT INTO `sys_role_menu` VALUES (3, 2135);
INSERT INTO `sys_role_menu` VALUES (3, 2136);
INSERT INTO `sys_role_menu` VALUES (3, 2137);
INSERT INTO `sys_role_menu` VALUES (3, 2138);
INSERT INTO `sys_role_menu` VALUES (3, 2139);
INSERT INTO `sys_role_menu` VALUES (3, 2140);
INSERT INTO `sys_role_menu` VALUES (3, 2141);
INSERT INTO `sys_role_menu` VALUES (3, 2142);
INSERT INTO `sys_role_menu` VALUES (3, 2143);
INSERT INTO `sys_role_menu` VALUES (3, 2144);
INSERT INTO `sys_role_menu` VALUES (3, 2145);
INSERT INTO `sys_role_menu` VALUES (3, 2146);
INSERT INTO `sys_role_menu` VALUES (3, 2147);
INSERT INTO `sys_role_menu` VALUES (3, 2148);
INSERT INTO `sys_role_menu` VALUES (3, 2149);
INSERT INTO `sys_role_menu` VALUES (3, 2150);
INSERT INTO `sys_role_menu` VALUES (3, 2151);
INSERT INTO `sys_role_menu` VALUES (3, 2152);
INSERT INTO `sys_role_menu` VALUES (3, 2153);
INSERT INTO `sys_role_menu` VALUES (3, 2154);
INSERT INTO `sys_role_menu` VALUES (3, 2155);
INSERT INTO `sys_role_menu` VALUES (3, 2156);
INSERT INTO `sys_role_menu` VALUES (3, 2157);
INSERT INTO `sys_role_menu` VALUES (3, 2159);
INSERT INTO `sys_role_menu` VALUES (3, 2160);
INSERT INTO `sys_role_menu` VALUES (3, 2161);
INSERT INTO `sys_role_menu` VALUES (3, 2162);
INSERT INTO `sys_role_menu` VALUES (3, 2163);
INSERT INTO `sys_role_menu` VALUES (3, 2164);
INSERT INTO `sys_role_menu` VALUES (3, 2166);
INSERT INTO `sys_role_menu` VALUES (3, 2167);
INSERT INTO `sys_role_menu` VALUES (3, 2168);
INSERT INTO `sys_role_menu` VALUES (3, 2169);
INSERT INTO `sys_role_menu` VALUES (3, 2171);
INSERT INTO `sys_role_menu` VALUES (3, 2172);
INSERT INTO `sys_role_menu` VALUES (3, 2173);
INSERT INTO `sys_role_menu` VALUES (3, 2175);
INSERT INTO `sys_role_menu` VALUES (3, 2176);
INSERT INTO `sys_role_menu` VALUES (3, 2177);
INSERT INTO `sys_role_menu` VALUES (3, 2178);
INSERT INTO `sys_role_menu` VALUES (3, 2179);
INSERT INTO `sys_role_menu` VALUES (3, 2180);
INSERT INTO `sys_role_menu` VALUES (3, 2181);
INSERT INTO `sys_role_menu` VALUES (3, 2182);
INSERT INTO `sys_role_menu` VALUES (3, 2183);
INSERT INTO `sys_role_menu` VALUES (3, 2184);
INSERT INTO `sys_role_menu` VALUES (3, 2185);
INSERT INTO `sys_role_menu` VALUES (3, 2186);
INSERT INTO `sys_role_menu` VALUES (3, 2187);
INSERT INTO `sys_role_menu` VALUES (3, 2188);
INSERT INTO `sys_role_menu` VALUES (3, 2189);
INSERT INTO `sys_role_menu` VALUES (3, 2190);
INSERT INTO `sys_role_menu` VALUES (3, 2191);
INSERT INTO `sys_role_menu` VALUES (3, 2192);
INSERT INTO `sys_role_menu` VALUES (3, 2193);
INSERT INTO `sys_role_menu` VALUES (3, 2194);
INSERT INTO `sys_role_menu` VALUES (3, 2195);
INSERT INTO `sys_role_menu` VALUES (3, 2196);
INSERT INTO `sys_role_menu` VALUES (3, 2197);
INSERT INTO `sys_role_menu` VALUES (3, 2202);
INSERT INTO `sys_role_menu` VALUES (3, 2203);
INSERT INTO `sys_role_menu` VALUES (3, 2214);
INSERT INTO `sys_role_menu` VALUES (3, 2238);
INSERT INTO `sys_role_menu` VALUES (3, 2239);
INSERT INTO `sys_role_menu` VALUES (3, 2240);
INSERT INTO `sys_role_menu` VALUES (3, 2241);
INSERT INTO `sys_role_menu` VALUES (3, 2242);
INSERT INTO `sys_role_menu` VALUES (4, 1);
INSERT INTO `sys_role_menu` VALUES (4, 108);
INSERT INTO `sys_role_menu` VALUES (4, 2000);
INSERT INTO `sys_role_menu` VALUES (4, 2001);
INSERT INTO `sys_role_menu` VALUES (4, 2003);
INSERT INTO `sys_role_menu` VALUES (4, 2004);
INSERT INTO `sys_role_menu` VALUES (4, 2005);
INSERT INTO `sys_role_menu` VALUES (4, 2006);
INSERT INTO `sys_role_menu` VALUES (4, 2008);
INSERT INTO `sys_role_menu` VALUES (4, 2009);
INSERT INTO `sys_role_menu` VALUES (4, 2010);
INSERT INTO `sys_role_menu` VALUES (4, 2017);
INSERT INTO `sys_role_menu` VALUES (4, 2018);
INSERT INTO `sys_role_menu` VALUES (4, 2019);
INSERT INTO `sys_role_menu` VALUES (4, 2021);
INSERT INTO `sys_role_menu` VALUES (4, 2027);
INSERT INTO `sys_role_menu` VALUES (4, 2041);
INSERT INTO `sys_role_menu` VALUES (4, 2042);
INSERT INTO `sys_role_menu` VALUES (4, 2050);
INSERT INTO `sys_role_menu` VALUES (4, 2052);
INSERT INTO `sys_role_menu` VALUES (4, 2053);
INSERT INTO `sys_role_menu` VALUES (4, 2060);
INSERT INTO `sys_role_menu` VALUES (4, 2061);
INSERT INTO `sys_role_menu` VALUES (4, 2063);
INSERT INTO `sys_role_menu` VALUES (4, 2064);
INSERT INTO `sys_role_menu` VALUES (4, 2065);
INSERT INTO `sys_role_menu` VALUES (4, 2068);
INSERT INTO `sys_role_menu` VALUES (4, 2069);
INSERT INTO `sys_role_menu` VALUES (4, 2082);
INSERT INTO `sys_role_menu` VALUES (4, 2087);
INSERT INTO `sys_role_menu` VALUES (4, 2093);
INSERT INTO `sys_role_menu` VALUES (4, 2109);
INSERT INTO `sys_role_menu` VALUES (4, 2125);
INSERT INTO `sys_role_menu` VALUES (4, 2172);
INSERT INTO `sys_role_menu` VALUES (4, 2173);
INSERT INTO `sys_role_menu` VALUES (4, 2175);
INSERT INTO `sys_role_menu` VALUES (4, 2176);
INSERT INTO `sys_role_menu` VALUES (4, 2177);
INSERT INTO `sys_role_menu` VALUES (4, 2178);
INSERT INTO `sys_role_menu` VALUES (4, 2179);
INSERT INTO `sys_role_menu` VALUES (4, 2180);
INSERT INTO `sys_role_menu` VALUES (4, 2181);
INSERT INTO `sys_role_menu` VALUES (4, 2182);
INSERT INTO `sys_role_menu` VALUES (4, 2183);
INSERT INTO `sys_role_menu` VALUES (4, 2190);
INSERT INTO `sys_role_menu` VALUES (4, 2191);
INSERT INTO `sys_role_menu` VALUES (4, 2192);
INSERT INTO `sys_role_menu` VALUES (4, 2193);
INSERT INTO `sys_role_menu` VALUES (4, 2194);
INSERT INTO `sys_role_menu` VALUES (4, 2195);
INSERT INTO `sys_role_menu` VALUES (5, 1);
INSERT INTO `sys_role_menu` VALUES (5, 2);
INSERT INTO `sys_role_menu` VALUES (5, 3);
INSERT INTO `sys_role_menu` VALUES (5, 8);
INSERT INTO `sys_role_menu` VALUES (5, 100);
INSERT INTO `sys_role_menu` VALUES (5, 101);
INSERT INTO `sys_role_menu` VALUES (5, 103);
INSERT INTO `sys_role_menu` VALUES (5, 108);
INSERT INTO `sys_role_menu` VALUES (5, 109);
INSERT INTO `sys_role_menu` VALUES (5, 1001);
INSERT INTO `sys_role_menu` VALUES (5, 1002);
INSERT INTO `sys_role_menu` VALUES (5, 1003);
INSERT INTO `sys_role_menu` VALUES (5, 1004);
INSERT INTO `sys_role_menu` VALUES (5, 1005);
INSERT INTO `sys_role_menu` VALUES (5, 1006);
INSERT INTO `sys_role_menu` VALUES (5, 1007);
INSERT INTO `sys_role_menu` VALUES (5, 1008);
INSERT INTO `sys_role_menu` VALUES (5, 1017);
INSERT INTO `sys_role_menu` VALUES (5, 1018);
INSERT INTO `sys_role_menu` VALUES (5, 1019);
INSERT INTO `sys_role_menu` VALUES (5, 1046);
INSERT INTO `sys_role_menu` VALUES (5, 2000);
INSERT INTO `sys_role_menu` VALUES (5, 2001);
INSERT INTO `sys_role_menu` VALUES (5, 2003);
INSERT INTO `sys_role_menu` VALUES (5, 2004);
INSERT INTO `sys_role_menu` VALUES (5, 2005);
INSERT INTO `sys_role_menu` VALUES (5, 2006);
INSERT INTO `sys_role_menu` VALUES (5, 2008);
INSERT INTO `sys_role_menu` VALUES (5, 2009);
INSERT INTO `sys_role_menu` VALUES (5, 2010);
INSERT INTO `sys_role_menu` VALUES (5, 2011);
INSERT INTO `sys_role_menu` VALUES (5, 2012);
INSERT INTO `sys_role_menu` VALUES (5, 2013);
INSERT INTO `sys_role_menu` VALUES (5, 2014);
INSERT INTO `sys_role_menu` VALUES (5, 2015);
INSERT INTO `sys_role_menu` VALUES (5, 2016);
INSERT INTO `sys_role_menu` VALUES (5, 2017);
INSERT INTO `sys_role_menu` VALUES (5, 2018);
INSERT INTO `sys_role_menu` VALUES (5, 2019);
INSERT INTO `sys_role_menu` VALUES (5, 2020);
INSERT INTO `sys_role_menu` VALUES (5, 2021);
INSERT INTO `sys_role_menu` VALUES (5, 2022);
INSERT INTO `sys_role_menu` VALUES (5, 2023);
INSERT INTO `sys_role_menu` VALUES (5, 2024);
INSERT INTO `sys_role_menu` VALUES (5, 2025);
INSERT INTO `sys_role_menu` VALUES (5, 2026);
INSERT INTO `sys_role_menu` VALUES (5, 2027);
INSERT INTO `sys_role_menu` VALUES (5, 2028);
INSERT INTO `sys_role_menu` VALUES (5, 2029);
INSERT INTO `sys_role_menu` VALUES (5, 2030);
INSERT INTO `sys_role_menu` VALUES (5, 2031);
INSERT INTO `sys_role_menu` VALUES (5, 2032);
INSERT INTO `sys_role_menu` VALUES (5, 2033);
INSERT INTO `sys_role_menu` VALUES (5, 2034);
INSERT INTO `sys_role_menu` VALUES (5, 2035);
INSERT INTO `sys_role_menu` VALUES (5, 2037);
INSERT INTO `sys_role_menu` VALUES (5, 2038);
INSERT INTO `sys_role_menu` VALUES (5, 2039);
INSERT INTO `sys_role_menu` VALUES (5, 2040);
INSERT INTO `sys_role_menu` VALUES (5, 2041);
INSERT INTO `sys_role_menu` VALUES (5, 2042);
INSERT INTO `sys_role_menu` VALUES (5, 2043);
INSERT INTO `sys_role_menu` VALUES (5, 2044);
INSERT INTO `sys_role_menu` VALUES (5, 2045);
INSERT INTO `sys_role_menu` VALUES (5, 2048);
INSERT INTO `sys_role_menu` VALUES (5, 2050);
INSERT INTO `sys_role_menu` VALUES (5, 2051);
INSERT INTO `sys_role_menu` VALUES (5, 2052);
INSERT INTO `sys_role_menu` VALUES (5, 2053);
INSERT INTO `sys_role_menu` VALUES (5, 2058);
INSERT INTO `sys_role_menu` VALUES (5, 2059);
INSERT INTO `sys_role_menu` VALUES (5, 2060);
INSERT INTO `sys_role_menu` VALUES (5, 2061);
INSERT INTO `sys_role_menu` VALUES (5, 2062);
INSERT INTO `sys_role_menu` VALUES (5, 2063);
INSERT INTO `sys_role_menu` VALUES (5, 2064);
INSERT INTO `sys_role_menu` VALUES (5, 2065);
INSERT INTO `sys_role_menu` VALUES (5, 2066);
INSERT INTO `sys_role_menu` VALUES (5, 2067);
INSERT INTO `sys_role_menu` VALUES (5, 2068);
INSERT INTO `sys_role_menu` VALUES (5, 2069);
INSERT INTO `sys_role_menu` VALUES (5, 2070);
INSERT INTO `sys_role_menu` VALUES (5, 2071);
INSERT INTO `sys_role_menu` VALUES (5, 2072);
INSERT INTO `sys_role_menu` VALUES (5, 2073);
INSERT INTO `sys_role_menu` VALUES (5, 2074);
INSERT INTO `sys_role_menu` VALUES (5, 2075);
INSERT INTO `sys_role_menu` VALUES (5, 2076);
INSERT INTO `sys_role_menu` VALUES (5, 2079);
INSERT INTO `sys_role_menu` VALUES (5, 2080);
INSERT INTO `sys_role_menu` VALUES (5, 2081);
INSERT INTO `sys_role_menu` VALUES (5, 2082);
INSERT INTO `sys_role_menu` VALUES (5, 2084);
INSERT INTO `sys_role_menu` VALUES (5, 2085);
INSERT INTO `sys_role_menu` VALUES (5, 2087);
INSERT INTO `sys_role_menu` VALUES (5, 2088);
INSERT INTO `sys_role_menu` VALUES (5, 2089);
INSERT INTO `sys_role_menu` VALUES (5, 2090);
INSERT INTO `sys_role_menu` VALUES (5, 2093);
INSERT INTO `sys_role_menu` VALUES (5, 2102);
INSERT INTO `sys_role_menu` VALUES (5, 2104);
INSERT INTO `sys_role_menu` VALUES (5, 2105);
INSERT INTO `sys_role_menu` VALUES (5, 2106);
INSERT INTO `sys_role_menu` VALUES (5, 2107);
INSERT INTO `sys_role_menu` VALUES (5, 2109);
INSERT INTO `sys_role_menu` VALUES (5, 2110);
INSERT INTO `sys_role_menu` VALUES (5, 2115);
INSERT INTO `sys_role_menu` VALUES (5, 2116);
INSERT INTO `sys_role_menu` VALUES (5, 2120);
INSERT INTO `sys_role_menu` VALUES (5, 2123);
INSERT INTO `sys_role_menu` VALUES (5, 2124);
INSERT INTO `sys_role_menu` VALUES (5, 2125);
INSERT INTO `sys_role_menu` VALUES (5, 2129);
INSERT INTO `sys_role_menu` VALUES (5, 2130);
INSERT INTO `sys_role_menu` VALUES (5, 2131);
INSERT INTO `sys_role_menu` VALUES (5, 2132);
INSERT INTO `sys_role_menu` VALUES (5, 2134);
INSERT INTO `sys_role_menu` VALUES (5, 2135);
INSERT INTO `sys_role_menu` VALUES (5, 2136);
INSERT INTO `sys_role_menu` VALUES (5, 2137);
INSERT INTO `sys_role_menu` VALUES (5, 2138);
INSERT INTO `sys_role_menu` VALUES (5, 2139);
INSERT INTO `sys_role_menu` VALUES (5, 2140);
INSERT INTO `sys_role_menu` VALUES (5, 2141);
INSERT INTO `sys_role_menu` VALUES (5, 2142);
INSERT INTO `sys_role_menu` VALUES (5, 2143);
INSERT INTO `sys_role_menu` VALUES (5, 2144);
INSERT INTO `sys_role_menu` VALUES (5, 2145);
INSERT INTO `sys_role_menu` VALUES (5, 2148);
INSERT INTO `sys_role_menu` VALUES (5, 2149);
INSERT INTO `sys_role_menu` VALUES (5, 2150);
INSERT INTO `sys_role_menu` VALUES (5, 2152);
INSERT INTO `sys_role_menu` VALUES (5, 2153);
INSERT INTO `sys_role_menu` VALUES (5, 2154);
INSERT INTO `sys_role_menu` VALUES (5, 2155);
INSERT INTO `sys_role_menu` VALUES (5, 2156);
INSERT INTO `sys_role_menu` VALUES (5, 2157);
INSERT INTO `sys_role_menu` VALUES (5, 2158);
INSERT INTO `sys_role_menu` VALUES (5, 2159);
INSERT INTO `sys_role_menu` VALUES (5, 2161);
INSERT INTO `sys_role_menu` VALUES (5, 2162);
INSERT INTO `sys_role_menu` VALUES (5, 2163);
INSERT INTO `sys_role_menu` VALUES (5, 2164);
INSERT INTO `sys_role_menu` VALUES (5, 2167);
INSERT INTO `sys_role_menu` VALUES (5, 2168);
INSERT INTO `sys_role_menu` VALUES (5, 2169);
INSERT INTO `sys_role_menu` VALUES (5, 2171);
INSERT INTO `sys_role_menu` VALUES (5, 2172);
INSERT INTO `sys_role_menu` VALUES (5, 2173);
INSERT INTO `sys_role_menu` VALUES (5, 2175);
INSERT INTO `sys_role_menu` VALUES (5, 2176);
INSERT INTO `sys_role_menu` VALUES (5, 2177);
INSERT INTO `sys_role_menu` VALUES (5, 2178);
INSERT INTO `sys_role_menu` VALUES (5, 2179);
INSERT INTO `sys_role_menu` VALUES (5, 2180);
INSERT INTO `sys_role_menu` VALUES (5, 2181);
INSERT INTO `sys_role_menu` VALUES (5, 2182);
INSERT INTO `sys_role_menu` VALUES (5, 2183);
INSERT INTO `sys_role_menu` VALUES (5, 2184);
INSERT INTO `sys_role_menu` VALUES (5, 2185);
INSERT INTO `sys_role_menu` VALUES (5, 2190);
INSERT INTO `sys_role_menu` VALUES (5, 2191);
INSERT INTO `sys_role_menu` VALUES (5, 2192);
INSERT INTO `sys_role_menu` VALUES (5, 2193);
INSERT INTO `sys_role_menu` VALUES (5, 2194);
INSERT INTO `sys_role_menu` VALUES (5, 2195);
INSERT INTO `sys_role_menu` VALUES (5, 2196);
INSERT INTO `sys_role_menu` VALUES (5, 2197);
INSERT INTO `sys_role_menu` VALUES (5, 2202);
INSERT INTO `sys_role_menu` VALUES (5, 2203);
INSERT INTO `sys_role_menu` VALUES (5, 2208);
INSERT INTO `sys_role_menu` VALUES (5, 2209);
INSERT INTO `sys_role_menu` VALUES (5, 2210);
INSERT INTO `sys_role_menu` VALUES (5, 2211);
INSERT INTO `sys_role_menu` VALUES (5, 2212);
INSERT INTO `sys_role_menu` VALUES (5, 2213);
INSERT INTO `sys_role_menu` VALUES (5, 2214);
INSERT INTO `sys_role_menu` VALUES (5, 2237);
INSERT INTO `sys_role_menu` VALUES (5, 2238);
INSERT INTO `sys_role_menu` VALUES (5, 2239);
INSERT INTO `sys_role_menu` VALUES (5, 2240);
INSERT INTO `sys_role_menu` VALUES (5, 2241);
INSERT INTO `sys_role_menu` VALUES (5, 2242);
INSERT INTO `sys_role_menu` VALUES (5, 2252);
INSERT INTO `sys_role_menu` VALUES (5, 2253);
INSERT INTO `sys_role_menu` VALUES (5, 2254);
INSERT INTO `sys_role_menu` VALUES (5, 2256);
INSERT INTO `sys_role_menu` VALUES (5, 2257);
INSERT INTO `sys_role_menu` VALUES (5, 2258);
INSERT INTO `sys_role_menu` VALUES (5, 2259);
INSERT INTO `sys_role_menu` VALUES (5, 2261);
INSERT INTO `sys_role_menu` VALUES (5, 2262);
INSERT INTO `sys_role_menu` VALUES (5, 2263);
INSERT INTO `sys_role_menu` VALUES (5, 2264);
INSERT INTO `sys_role_menu` VALUES (5, 2266);
INSERT INTO `sys_role_menu` VALUES (5, 2267);
INSERT INTO `sys_role_menu` VALUES (5, 2268);
INSERT INTO `sys_role_menu` VALUES (5, 2269);
INSERT INTO `sys_role_menu` VALUES (5, 2270);
INSERT INTO `sys_role_menu` VALUES (5, 2271);
INSERT INTO `sys_role_menu` VALUES (5, 2272);
INSERT INTO `sys_role_menu` VALUES (5, 2273);
INSERT INTO `sys_role_menu` VALUES (5, 2274);
INSERT INTO `sys_role_menu` VALUES (5, 2286);
INSERT INTO `sys_role_menu` VALUES (5, 2288);
INSERT INTO `sys_role_menu` VALUES (5, 2289);
INSERT INTO `sys_role_menu` VALUES (5, 2290);
INSERT INTO `sys_role_menu` VALUES (5, 2292);
INSERT INTO `sys_role_menu` VALUES (5, 2293);
INSERT INTO `sys_role_menu` VALUES (5, 2294);
INSERT INTO `sys_role_menu` VALUES (5, 2309);
INSERT INTO `sys_role_menu` VALUES (5, 2310);
INSERT INTO `sys_role_menu` VALUES (5, 2313);
INSERT INTO `sys_role_menu` VALUES (6, 2105);
INSERT INTO `sys_role_menu` VALUES (6, 2118);
INSERT INTO `sys_role_menu` VALUES (6, 2119);
INSERT INTO `sys_role_menu` VALUES (6, 2121);
INSERT INTO `sys_role_menu` VALUES (6, 2125);
INSERT INTO `sys_role_menu` VALUES (6, 2166);
INSERT INTO `sys_role_menu` VALUES (6, 2172);
INSERT INTO `sys_role_menu` VALUES (7, 2105);
INSERT INTO `sys_role_menu` VALUES (7, 2119);
INSERT INTO `sys_role_menu` VALUES (7, 2125);
INSERT INTO `sys_role_menu` VALUES (7, 2165);
INSERT INTO `sys_role_menu` VALUES (7, 2172);
INSERT INTO `sys_role_menu` VALUES (8, 2090);
INSERT INTO `sys_role_menu` VALUES (8, 2105);
INSERT INTO `sys_role_menu` VALUES (8, 2116);
INSERT INTO `sys_role_menu` VALUES (8, 2117);
INSERT INTO `sys_role_menu` VALUES (8, 2123);
INSERT INTO `sys_role_menu` VALUES (8, 2124);
INSERT INTO `sys_role_menu` VALUES (8, 2125);
INSERT INTO `sys_role_menu` VALUES (8, 2126);
INSERT INTO `sys_role_menu` VALUES (8, 2127);
INSERT INTO `sys_role_menu` VALUES (8, 2128);
INSERT INTO `sys_role_menu` VALUES (8, 2129);
INSERT INTO `sys_role_menu` VALUES (8, 2140);
INSERT INTO `sys_role_menu` VALUES (8, 2141);
INSERT INTO `sys_role_menu` VALUES (8, 2142);
INSERT INTO `sys_role_menu` VALUES (8, 2143);
INSERT INTO `sys_role_menu` VALUES (8, 2144);
INSERT INTO `sys_role_menu` VALUES (8, 2145);
INSERT INTO `sys_role_menu` VALUES (8, 2146);
INSERT INTO `sys_role_menu` VALUES (8, 2147);
INSERT INTO `sys_role_menu` VALUES (8, 2148);
INSERT INTO `sys_role_menu` VALUES (8, 2149);
INSERT INTO `sys_role_menu` VALUES (8, 2150);
INSERT INTO `sys_role_menu` VALUES (8, 2151);
INSERT INTO `sys_role_menu` VALUES (8, 2152);
INSERT INTO `sys_role_menu` VALUES (8, 2157);
INSERT INTO `sys_role_menu` VALUES (8, 2159);
INSERT INTO `sys_role_menu` VALUES (8, 2160);
INSERT INTO `sys_role_menu` VALUES (8, 2162);
INSERT INTO `sys_role_menu` VALUES (8, 2163);
INSERT INTO `sys_role_menu` VALUES (8, 2164);
INSERT INTO `sys_role_menu` VALUES (9, 1);
INSERT INTO `sys_role_menu` VALUES (9, 2);
INSERT INTO `sys_role_menu` VALUES (9, 3);
INSERT INTO `sys_role_menu` VALUES (9, 8);
INSERT INTO `sys_role_menu` VALUES (9, 100);
INSERT INTO `sys_role_menu` VALUES (9, 101);
INSERT INTO `sys_role_menu` VALUES (9, 102);
INSERT INTO `sys_role_menu` VALUES (9, 103);
INSERT INTO `sys_role_menu` VALUES (9, 104);
INSERT INTO `sys_role_menu` VALUES (9, 105);
INSERT INTO `sys_role_menu` VALUES (9, 106);
INSERT INTO `sys_role_menu` VALUES (9, 108);
INSERT INTO `sys_role_menu` VALUES (9, 110);
INSERT INTO `sys_role_menu` VALUES (9, 114);
INSERT INTO `sys_role_menu` VALUES (9, 115);
INSERT INTO `sys_role_menu` VALUES (9, 1001);
INSERT INTO `sys_role_menu` VALUES (9, 1002);
INSERT INTO `sys_role_menu` VALUES (9, 1006);
INSERT INTO `sys_role_menu` VALUES (9, 1008);
INSERT INTO `sys_role_menu` VALUES (9, 1009);
INSERT INTO `sys_role_menu` VALUES (9, 1013);
INSERT INTO `sys_role_menu` VALUES (9, 1017);
INSERT INTO `sys_role_menu` VALUES (9, 1021);
INSERT INTO `sys_role_menu` VALUES (9, 1026);
INSERT INTO `sys_role_menu` VALUES (9, 1031);
INSERT INTO `sys_role_menu` VALUES (9, 1049);
INSERT INTO `sys_role_menu` VALUES (9, 1055);
INSERT INTO `sys_role_menu` VALUES (9, 2000);
INSERT INTO `sys_role_menu` VALUES (9, 2001);
INSERT INTO `sys_role_menu` VALUES (9, 2003);
INSERT INTO `sys_role_menu` VALUES (9, 2004);
INSERT INTO `sys_role_menu` VALUES (9, 2005);
INSERT INTO `sys_role_menu` VALUES (9, 2006);
INSERT INTO `sys_role_menu` VALUES (9, 2008);
INSERT INTO `sys_role_menu` VALUES (9, 2009);
INSERT INTO `sys_role_menu` VALUES (9, 2010);
INSERT INTO `sys_role_menu` VALUES (9, 2011);
INSERT INTO `sys_role_menu` VALUES (9, 2012);
INSERT INTO `sys_role_menu` VALUES (9, 2013);
INSERT INTO `sys_role_menu` VALUES (9, 2014);
INSERT INTO `sys_role_menu` VALUES (9, 2015);
INSERT INTO `sys_role_menu` VALUES (9, 2017);
INSERT INTO `sys_role_menu` VALUES (9, 2018);
INSERT INTO `sys_role_menu` VALUES (9, 2019);
INSERT INTO `sys_role_menu` VALUES (9, 2020);
INSERT INTO `sys_role_menu` VALUES (9, 2021);
INSERT INTO `sys_role_menu` VALUES (9, 2022);
INSERT INTO `sys_role_menu` VALUES (9, 2023);
INSERT INTO `sys_role_menu` VALUES (9, 2024);
INSERT INTO `sys_role_menu` VALUES (9, 2025);
INSERT INTO `sys_role_menu` VALUES (9, 2026);
INSERT INTO `sys_role_menu` VALUES (9, 2027);
INSERT INTO `sys_role_menu` VALUES (9, 2028);
INSERT INTO `sys_role_menu` VALUES (9, 2029);
INSERT INTO `sys_role_menu` VALUES (9, 2030);
INSERT INTO `sys_role_menu` VALUES (9, 2034);
INSERT INTO `sys_role_menu` VALUES (9, 2037);
INSERT INTO `sys_role_menu` VALUES (9, 2038);
INSERT INTO `sys_role_menu` VALUES (9, 2039);
INSERT INTO `sys_role_menu` VALUES (9, 2040);
INSERT INTO `sys_role_menu` VALUES (9, 2041);
INSERT INTO `sys_role_menu` VALUES (9, 2042);
INSERT INTO `sys_role_menu` VALUES (9, 2043);
INSERT INTO `sys_role_menu` VALUES (9, 2050);
INSERT INTO `sys_role_menu` VALUES (9, 2051);
INSERT INTO `sys_role_menu` VALUES (9, 2052);
INSERT INTO `sys_role_menu` VALUES (9, 2053);
INSERT INTO `sys_role_menu` VALUES (9, 2058);
INSERT INTO `sys_role_menu` VALUES (9, 2059);
INSERT INTO `sys_role_menu` VALUES (9, 2060);
INSERT INTO `sys_role_menu` VALUES (9, 2061);
INSERT INTO `sys_role_menu` VALUES (9, 2062);
INSERT INTO `sys_role_menu` VALUES (9, 2063);
INSERT INTO `sys_role_menu` VALUES (9, 2064);
INSERT INTO `sys_role_menu` VALUES (9, 2065);
INSERT INTO `sys_role_menu` VALUES (9, 2066);
INSERT INTO `sys_role_menu` VALUES (9, 2067);
INSERT INTO `sys_role_menu` VALUES (9, 2068);
INSERT INTO `sys_role_menu` VALUES (9, 2069);
INSERT INTO `sys_role_menu` VALUES (9, 2070);
INSERT INTO `sys_role_menu` VALUES (9, 2071);
INSERT INTO `sys_role_menu` VALUES (9, 2072);
INSERT INTO `sys_role_menu` VALUES (9, 2073);
INSERT INTO `sys_role_menu` VALUES (9, 2074);
INSERT INTO `sys_role_menu` VALUES (9, 2075);
INSERT INTO `sys_role_menu` VALUES (9, 2076);
INSERT INTO `sys_role_menu` VALUES (9, 2079);
INSERT INTO `sys_role_menu` VALUES (9, 2080);
INSERT INTO `sys_role_menu` VALUES (9, 2081);
INSERT INTO `sys_role_menu` VALUES (9, 2082);
INSERT INTO `sys_role_menu` VALUES (9, 2084);
INSERT INTO `sys_role_menu` VALUES (9, 2085);
INSERT INTO `sys_role_menu` VALUES (9, 2086);
INSERT INTO `sys_role_menu` VALUES (9, 2087);
INSERT INTO `sys_role_menu` VALUES (9, 2088);
INSERT INTO `sys_role_menu` VALUES (9, 2089);
INSERT INTO `sys_role_menu` VALUES (9, 2093);
INSERT INTO `sys_role_menu` VALUES (9, 2102);
INSERT INTO `sys_role_menu` VALUES (9, 2104);
INSERT INTO `sys_role_menu` VALUES (9, 2106);
INSERT INTO `sys_role_menu` VALUES (9, 2108);
INSERT INTO `sys_role_menu` VALUES (9, 2109);
INSERT INTO `sys_role_menu` VALUES (9, 2110);
INSERT INTO `sys_role_menu` VALUES (9, 2114);
INSERT INTO `sys_role_menu` VALUES (9, 2125);
INSERT INTO `sys_role_menu` VALUES (9, 2137);
INSERT INTO `sys_role_menu` VALUES (9, 2153);
INSERT INTO `sys_role_menu` VALUES (9, 2154);
INSERT INTO `sys_role_menu` VALUES (9, 2155);
INSERT INTO `sys_role_menu` VALUES (9, 2156);
INSERT INTO `sys_role_menu` VALUES (9, 2167);
INSERT INTO `sys_role_menu` VALUES (9, 2168);
INSERT INTO `sys_role_menu` VALUES (9, 2169);
INSERT INTO `sys_role_menu` VALUES (9, 2170);
INSERT INTO `sys_role_menu` VALUES (9, 2172);
INSERT INTO `sys_role_menu` VALUES (9, 2173);
INSERT INTO `sys_role_menu` VALUES (9, 2175);
INSERT INTO `sys_role_menu` VALUES (9, 2176);
INSERT INTO `sys_role_menu` VALUES (9, 2177);
INSERT INTO `sys_role_menu` VALUES (9, 2178);
INSERT INTO `sys_role_menu` VALUES (9, 2179);
INSERT INTO `sys_role_menu` VALUES (9, 2180);
INSERT INTO `sys_role_menu` VALUES (9, 2181);
INSERT INTO `sys_role_menu` VALUES (9, 2182);
INSERT INTO `sys_role_menu` VALUES (9, 2183);
INSERT INTO `sys_role_menu` VALUES (9, 2184);
INSERT INTO `sys_role_menu` VALUES (9, 2185);
INSERT INTO `sys_role_menu` VALUES (9, 2190);
INSERT INTO `sys_role_menu` VALUES (9, 2191);
INSERT INTO `sys_role_menu` VALUES (9, 2192);
INSERT INTO `sys_role_menu` VALUES (9, 2193);
INSERT INTO `sys_role_menu` VALUES (9, 2194);
INSERT INTO `sys_role_menu` VALUES (9, 2195);
INSERT INTO `sys_role_menu` VALUES (9, 2202);
INSERT INTO `sys_role_menu` VALUES (9, 2203);
INSERT INTO `sys_role_menu` VALUES (9, 2214);
INSERT INTO `sys_role_menu` VALUES (9, 2238);
INSERT INTO `sys_role_menu` VALUES (9, 2239);
INSERT INTO `sys_role_menu` VALUES (9, 2240);
INSERT INTO `sys_role_menu` VALUES (9, 2241);
INSERT INTO `sys_role_menu` VALUES (9, 2242);
INSERT INTO `sys_role_menu` VALUES (9, 2256);
INSERT INTO `sys_role_menu` VALUES (9, 2263);
INSERT INTO `sys_role_menu` VALUES (9, 2269);
INSERT INTO `sys_role_menu` VALUES (9, 2270);
INSERT INTO `sys_role_menu` VALUES (9, 2295);
INSERT INTO `sys_role_menu` VALUES (9, 2298);
INSERT INTO `sys_role_menu` VALUES (9, 2309);
INSERT INTO `sys_role_menu` VALUES (13, 2063);
INSERT INTO `sys_role_menu` VALUES (13, 2064);
INSERT INTO `sys_role_menu` VALUES (13, 2065);
INSERT INTO `sys_role_menu` VALUES (13, 2066);
INSERT INTO `sys_role_menu` VALUES (13, 2067);
INSERT INTO `sys_role_menu` VALUES (13, 2068);
INSERT INTO `sys_role_menu` VALUES (13, 2069);
INSERT INTO `sys_role_menu` VALUES (13, 2070);
INSERT INTO `sys_role_menu` VALUES (13, 2089);
INSERT INTO `sys_role_menu` VALUES (13, 2102);
INSERT INTO `sys_role_menu` VALUES (13, 2137);
INSERT INTO `sys_role_menu` VALUES (17, 1);
INSERT INTO `sys_role_menu` VALUES (17, 2);
INSERT INTO `sys_role_menu` VALUES (17, 3);
INSERT INTO `sys_role_menu` VALUES (17, 100);
INSERT INTO `sys_role_menu` VALUES (17, 101);
INSERT INTO `sys_role_menu` VALUES (17, 102);
INSERT INTO `sys_role_menu` VALUES (17, 103);
INSERT INTO `sys_role_menu` VALUES (17, 104);
INSERT INTO `sys_role_menu` VALUES (17, 105);
INSERT INTO `sys_role_menu` VALUES (17, 106);
INSERT INTO `sys_role_menu` VALUES (17, 108);
INSERT INTO `sys_role_menu` VALUES (17, 110);
INSERT INTO `sys_role_menu` VALUES (17, 114);
INSERT INTO `sys_role_menu` VALUES (17, 115);
INSERT INTO `sys_role_menu` VALUES (17, 1001);
INSERT INTO `sys_role_menu` VALUES (17, 1002);
INSERT INTO `sys_role_menu` VALUES (17, 1006);
INSERT INTO `sys_role_menu` VALUES (17, 1008);
INSERT INTO `sys_role_menu` VALUES (17, 1009);
INSERT INTO `sys_role_menu` VALUES (17, 1013);
INSERT INTO `sys_role_menu` VALUES (17, 1017);
INSERT INTO `sys_role_menu` VALUES (17, 1021);
INSERT INTO `sys_role_menu` VALUES (17, 1026);
INSERT INTO `sys_role_menu` VALUES (17, 1031);
INSERT INTO `sys_role_menu` VALUES (17, 1049);
INSERT INTO `sys_role_menu` VALUES (17, 1055);
INSERT INTO `sys_role_menu` VALUES (17, 2000);
INSERT INTO `sys_role_menu` VALUES (17, 2001);
INSERT INTO `sys_role_menu` VALUES (17, 2003);
INSERT INTO `sys_role_menu` VALUES (17, 2004);
INSERT INTO `sys_role_menu` VALUES (17, 2005);
INSERT INTO `sys_role_menu` VALUES (17, 2006);
INSERT INTO `sys_role_menu` VALUES (17, 2008);
INSERT INTO `sys_role_menu` VALUES (17, 2009);
INSERT INTO `sys_role_menu` VALUES (17, 2010);
INSERT INTO `sys_role_menu` VALUES (17, 2011);
INSERT INTO `sys_role_menu` VALUES (17, 2012);
INSERT INTO `sys_role_menu` VALUES (17, 2013);
INSERT INTO `sys_role_menu` VALUES (17, 2014);
INSERT INTO `sys_role_menu` VALUES (17, 2015);
INSERT INTO `sys_role_menu` VALUES (17, 2017);
INSERT INTO `sys_role_menu` VALUES (17, 2018);
INSERT INTO `sys_role_menu` VALUES (17, 2019);
INSERT INTO `sys_role_menu` VALUES (17, 2020);
INSERT INTO `sys_role_menu` VALUES (17, 2021);
INSERT INTO `sys_role_menu` VALUES (17, 2022);
INSERT INTO `sys_role_menu` VALUES (17, 2023);
INSERT INTO `sys_role_menu` VALUES (17, 2024);
INSERT INTO `sys_role_menu` VALUES (17, 2025);
INSERT INTO `sys_role_menu` VALUES (17, 2026);
INSERT INTO `sys_role_menu` VALUES (17, 2027);
INSERT INTO `sys_role_menu` VALUES (17, 2028);
INSERT INTO `sys_role_menu` VALUES (17, 2029);
INSERT INTO `sys_role_menu` VALUES (17, 2030);
INSERT INTO `sys_role_menu` VALUES (17, 2034);
INSERT INTO `sys_role_menu` VALUES (17, 2037);
INSERT INTO `sys_role_menu` VALUES (17, 2038);
INSERT INTO `sys_role_menu` VALUES (17, 2039);
INSERT INTO `sys_role_menu` VALUES (17, 2040);
INSERT INTO `sys_role_menu` VALUES (17, 2041);
INSERT INTO `sys_role_menu` VALUES (17, 2042);
INSERT INTO `sys_role_menu` VALUES (17, 2043);
INSERT INTO `sys_role_menu` VALUES (17, 2050);
INSERT INTO `sys_role_menu` VALUES (17, 2051);
INSERT INTO `sys_role_menu` VALUES (17, 2052);
INSERT INTO `sys_role_menu` VALUES (17, 2053);
INSERT INTO `sys_role_menu` VALUES (17, 2058);
INSERT INTO `sys_role_menu` VALUES (17, 2059);
INSERT INTO `sys_role_menu` VALUES (17, 2060);
INSERT INTO `sys_role_menu` VALUES (17, 2061);
INSERT INTO `sys_role_menu` VALUES (17, 2062);
INSERT INTO `sys_role_menu` VALUES (17, 2063);
INSERT INTO `sys_role_menu` VALUES (17, 2064);
INSERT INTO `sys_role_menu` VALUES (17, 2065);
INSERT INTO `sys_role_menu` VALUES (17, 2066);
INSERT INTO `sys_role_menu` VALUES (17, 2067);
INSERT INTO `sys_role_menu` VALUES (17, 2068);
INSERT INTO `sys_role_menu` VALUES (17, 2069);
INSERT INTO `sys_role_menu` VALUES (17, 2070);
INSERT INTO `sys_role_menu` VALUES (17, 2071);
INSERT INTO `sys_role_menu` VALUES (17, 2072);
INSERT INTO `sys_role_menu` VALUES (17, 2073);
INSERT INTO `sys_role_menu` VALUES (17, 2074);
INSERT INTO `sys_role_menu` VALUES (17, 2075);
INSERT INTO `sys_role_menu` VALUES (17, 2076);
INSERT INTO `sys_role_menu` VALUES (17, 2079);
INSERT INTO `sys_role_menu` VALUES (17, 2080);
INSERT INTO `sys_role_menu` VALUES (17, 2081);
INSERT INTO `sys_role_menu` VALUES (17, 2082);
INSERT INTO `sys_role_menu` VALUES (17, 2084);
INSERT INTO `sys_role_menu` VALUES (17, 2085);
INSERT INTO `sys_role_menu` VALUES (17, 2086);
INSERT INTO `sys_role_menu` VALUES (17, 2087);
INSERT INTO `sys_role_menu` VALUES (17, 2088);
INSERT INTO `sys_role_menu` VALUES (17, 2089);
INSERT INTO `sys_role_menu` VALUES (17, 2093);
INSERT INTO `sys_role_menu` VALUES (17, 2102);
INSERT INTO `sys_role_menu` VALUES (17, 2104);
INSERT INTO `sys_role_menu` VALUES (17, 2106);
INSERT INTO `sys_role_menu` VALUES (17, 2108);
INSERT INTO `sys_role_menu` VALUES (17, 2109);
INSERT INTO `sys_role_menu` VALUES (17, 2110);
INSERT INTO `sys_role_menu` VALUES (17, 2114);
INSERT INTO `sys_role_menu` VALUES (17, 2125);
INSERT INTO `sys_role_menu` VALUES (17, 2137);
INSERT INTO `sys_role_menu` VALUES (17, 2153);
INSERT INTO `sys_role_menu` VALUES (17, 2154);
INSERT INTO `sys_role_menu` VALUES (17, 2155);
INSERT INTO `sys_role_menu` VALUES (17, 2156);
INSERT INTO `sys_role_menu` VALUES (17, 2167);
INSERT INTO `sys_role_menu` VALUES (17, 2168);
INSERT INTO `sys_role_menu` VALUES (17, 2169);
INSERT INTO `sys_role_menu` VALUES (17, 2170);
INSERT INTO `sys_role_menu` VALUES (17, 2172);
INSERT INTO `sys_role_menu` VALUES (17, 2173);
INSERT INTO `sys_role_menu` VALUES (17, 2175);
INSERT INTO `sys_role_menu` VALUES (17, 2176);
INSERT INTO `sys_role_menu` VALUES (17, 2177);
INSERT INTO `sys_role_menu` VALUES (17, 2178);
INSERT INTO `sys_role_menu` VALUES (17, 2179);
INSERT INTO `sys_role_menu` VALUES (17, 2180);
INSERT INTO `sys_role_menu` VALUES (17, 2181);
INSERT INTO `sys_role_menu` VALUES (17, 2182);
INSERT INTO `sys_role_menu` VALUES (17, 2183);
INSERT INTO `sys_role_menu` VALUES (17, 2184);
INSERT INTO `sys_role_menu` VALUES (17, 2185);
INSERT INTO `sys_role_menu` VALUES (17, 2190);
INSERT INTO `sys_role_menu` VALUES (17, 2191);
INSERT INTO `sys_role_menu` VALUES (17, 2192);
INSERT INTO `sys_role_menu` VALUES (17, 2193);
INSERT INTO `sys_role_menu` VALUES (17, 2194);
INSERT INTO `sys_role_menu` VALUES (17, 2195);
INSERT INTO `sys_role_menu` VALUES (17, 2202);
INSERT INTO `sys_role_menu` VALUES (17, 2203);
INSERT INTO `sys_role_menu` VALUES (17, 2214);
INSERT INTO `sys_role_menu` VALUES (17, 2238);
INSERT INTO `sys_role_menu` VALUES (17, 2239);
INSERT INTO `sys_role_menu` VALUES (17, 2240);
INSERT INTO `sys_role_menu` VALUES (17, 2241);
INSERT INTO `sys_role_menu` VALUES (17, 2242);
INSERT INTO `sys_role_menu` VALUES (17, 2269);
INSERT INTO `sys_role_menu` VALUES (17, 2270);
INSERT INTO `sys_role_menu` VALUES (18, 1);
INSERT INTO `sys_role_menu` VALUES (18, 2);
INSERT INTO `sys_role_menu` VALUES (18, 3);
INSERT INTO `sys_role_menu` VALUES (18, 8);
INSERT INTO `sys_role_menu` VALUES (18, 100);
INSERT INTO `sys_role_menu` VALUES (18, 101);
INSERT INTO `sys_role_menu` VALUES (18, 102);
INSERT INTO `sys_role_menu` VALUES (18, 103);
INSERT INTO `sys_role_menu` VALUES (18, 104);
INSERT INTO `sys_role_menu` VALUES (18, 105);
INSERT INTO `sys_role_menu` VALUES (18, 106);
INSERT INTO `sys_role_menu` VALUES (18, 108);
INSERT INTO `sys_role_menu` VALUES (18, 110);
INSERT INTO `sys_role_menu` VALUES (18, 114);
INSERT INTO `sys_role_menu` VALUES (18, 115);
INSERT INTO `sys_role_menu` VALUES (18, 1001);
INSERT INTO `sys_role_menu` VALUES (18, 1002);
INSERT INTO `sys_role_menu` VALUES (18, 1006);
INSERT INTO `sys_role_menu` VALUES (18, 1008);
INSERT INTO `sys_role_menu` VALUES (18, 1009);
INSERT INTO `sys_role_menu` VALUES (18, 1013);
INSERT INTO `sys_role_menu` VALUES (18, 1017);
INSERT INTO `sys_role_menu` VALUES (18, 1021);
INSERT INTO `sys_role_menu` VALUES (18, 1026);
INSERT INTO `sys_role_menu` VALUES (18, 1031);
INSERT INTO `sys_role_menu` VALUES (18, 1049);
INSERT INTO `sys_role_menu` VALUES (18, 1055);
INSERT INTO `sys_role_menu` VALUES (18, 2000);
INSERT INTO `sys_role_menu` VALUES (18, 2001);
INSERT INTO `sys_role_menu` VALUES (18, 2003);
INSERT INTO `sys_role_menu` VALUES (18, 2004);
INSERT INTO `sys_role_menu` VALUES (18, 2005);
INSERT INTO `sys_role_menu` VALUES (18, 2006);
INSERT INTO `sys_role_menu` VALUES (18, 2008);
INSERT INTO `sys_role_menu` VALUES (18, 2009);
INSERT INTO `sys_role_menu` VALUES (18, 2010);
INSERT INTO `sys_role_menu` VALUES (18, 2011);
INSERT INTO `sys_role_menu` VALUES (18, 2012);
INSERT INTO `sys_role_menu` VALUES (18, 2013);
INSERT INTO `sys_role_menu` VALUES (18, 2014);
INSERT INTO `sys_role_menu` VALUES (18, 2015);
INSERT INTO `sys_role_menu` VALUES (18, 2017);
INSERT INTO `sys_role_menu` VALUES (18, 2018);
INSERT INTO `sys_role_menu` VALUES (18, 2019);
INSERT INTO `sys_role_menu` VALUES (18, 2020);
INSERT INTO `sys_role_menu` VALUES (18, 2021);
INSERT INTO `sys_role_menu` VALUES (18, 2022);
INSERT INTO `sys_role_menu` VALUES (18, 2023);
INSERT INTO `sys_role_menu` VALUES (18, 2024);
INSERT INTO `sys_role_menu` VALUES (18, 2025);
INSERT INTO `sys_role_menu` VALUES (18, 2026);
INSERT INTO `sys_role_menu` VALUES (18, 2027);
INSERT INTO `sys_role_menu` VALUES (18, 2028);
INSERT INTO `sys_role_menu` VALUES (18, 2029);
INSERT INTO `sys_role_menu` VALUES (18, 2030);
INSERT INTO `sys_role_menu` VALUES (18, 2034);
INSERT INTO `sys_role_menu` VALUES (18, 2037);
INSERT INTO `sys_role_menu` VALUES (18, 2038);
INSERT INTO `sys_role_menu` VALUES (18, 2039);
INSERT INTO `sys_role_menu` VALUES (18, 2040);
INSERT INTO `sys_role_menu` VALUES (18, 2041);
INSERT INTO `sys_role_menu` VALUES (18, 2042);
INSERT INTO `sys_role_menu` VALUES (18, 2043);
INSERT INTO `sys_role_menu` VALUES (18, 2050);
INSERT INTO `sys_role_menu` VALUES (18, 2051);
INSERT INTO `sys_role_menu` VALUES (18, 2052);
INSERT INTO `sys_role_menu` VALUES (18, 2053);
INSERT INTO `sys_role_menu` VALUES (18, 2058);
INSERT INTO `sys_role_menu` VALUES (18, 2059);
INSERT INTO `sys_role_menu` VALUES (18, 2060);
INSERT INTO `sys_role_menu` VALUES (18, 2061);
INSERT INTO `sys_role_menu` VALUES (18, 2062);
INSERT INTO `sys_role_menu` VALUES (18, 2063);
INSERT INTO `sys_role_menu` VALUES (18, 2064);
INSERT INTO `sys_role_menu` VALUES (18, 2065);
INSERT INTO `sys_role_menu` VALUES (18, 2066);
INSERT INTO `sys_role_menu` VALUES (18, 2067);
INSERT INTO `sys_role_menu` VALUES (18, 2068);
INSERT INTO `sys_role_menu` VALUES (18, 2069);
INSERT INTO `sys_role_menu` VALUES (18, 2070);
INSERT INTO `sys_role_menu` VALUES (18, 2071);
INSERT INTO `sys_role_menu` VALUES (18, 2072);
INSERT INTO `sys_role_menu` VALUES (18, 2073);
INSERT INTO `sys_role_menu` VALUES (18, 2074);
INSERT INTO `sys_role_menu` VALUES (18, 2075);
INSERT INTO `sys_role_menu` VALUES (18, 2076);
INSERT INTO `sys_role_menu` VALUES (18, 2079);
INSERT INTO `sys_role_menu` VALUES (18, 2080);
INSERT INTO `sys_role_menu` VALUES (18, 2081);
INSERT INTO `sys_role_menu` VALUES (18, 2082);
INSERT INTO `sys_role_menu` VALUES (18, 2084);
INSERT INTO `sys_role_menu` VALUES (18, 2085);
INSERT INTO `sys_role_menu` VALUES (18, 2086);
INSERT INTO `sys_role_menu` VALUES (18, 2087);
INSERT INTO `sys_role_menu` VALUES (18, 2088);
INSERT INTO `sys_role_menu` VALUES (18, 2089);
INSERT INTO `sys_role_menu` VALUES (18, 2093);
INSERT INTO `sys_role_menu` VALUES (18, 2102);
INSERT INTO `sys_role_menu` VALUES (18, 2104);
INSERT INTO `sys_role_menu` VALUES (18, 2106);
INSERT INTO `sys_role_menu` VALUES (18, 2108);
INSERT INTO `sys_role_menu` VALUES (18, 2109);
INSERT INTO `sys_role_menu` VALUES (18, 2110);
INSERT INTO `sys_role_menu` VALUES (18, 2114);
INSERT INTO `sys_role_menu` VALUES (18, 2125);
INSERT INTO `sys_role_menu` VALUES (18, 2137);
INSERT INTO `sys_role_menu` VALUES (18, 2153);
INSERT INTO `sys_role_menu` VALUES (18, 2154);
INSERT INTO `sys_role_menu` VALUES (18, 2155);
INSERT INTO `sys_role_menu` VALUES (18, 2156);
INSERT INTO `sys_role_menu` VALUES (18, 2167);
INSERT INTO `sys_role_menu` VALUES (18, 2168);
INSERT INTO `sys_role_menu` VALUES (18, 2169);
INSERT INTO `sys_role_menu` VALUES (18, 2170);
INSERT INTO `sys_role_menu` VALUES (18, 2172);
INSERT INTO `sys_role_menu` VALUES (18, 2173);
INSERT INTO `sys_role_menu` VALUES (18, 2175);
INSERT INTO `sys_role_menu` VALUES (18, 2176);
INSERT INTO `sys_role_menu` VALUES (18, 2177);
INSERT INTO `sys_role_menu` VALUES (18, 2178);
INSERT INTO `sys_role_menu` VALUES (18, 2179);
INSERT INTO `sys_role_menu` VALUES (18, 2180);
INSERT INTO `sys_role_menu` VALUES (18, 2181);
INSERT INTO `sys_role_menu` VALUES (18, 2182);
INSERT INTO `sys_role_menu` VALUES (18, 2183);
INSERT INTO `sys_role_menu` VALUES (18, 2184);
INSERT INTO `sys_role_menu` VALUES (18, 2185);
INSERT INTO `sys_role_menu` VALUES (18, 2190);
INSERT INTO `sys_role_menu` VALUES (18, 2191);
INSERT INTO `sys_role_menu` VALUES (18, 2192);
INSERT INTO `sys_role_menu` VALUES (18, 2193);
INSERT INTO `sys_role_menu` VALUES (18, 2194);
INSERT INTO `sys_role_menu` VALUES (18, 2195);
INSERT INTO `sys_role_menu` VALUES (18, 2202);
INSERT INTO `sys_role_menu` VALUES (18, 2203);
INSERT INTO `sys_role_menu` VALUES (18, 2214);
INSERT INTO `sys_role_menu` VALUES (18, 2238);
INSERT INTO `sys_role_menu` VALUES (18, 2239);
INSERT INTO `sys_role_menu` VALUES (18, 2240);
INSERT INTO `sys_role_menu` VALUES (18, 2241);
INSERT INTO `sys_role_menu` VALUES (18, 2242);
INSERT INTO `sys_role_menu` VALUES (18, 2269);
INSERT INTO `sys_role_menu` VALUES (18, 2270);
INSERT INTO `sys_role_menu` VALUES (20, 100);
INSERT INTO `sys_role_menu` VALUES (20, 101);
INSERT INTO `sys_role_menu` VALUES (20, 103);
INSERT INTO `sys_role_menu` VALUES (20, 1001);
INSERT INTO `sys_role_menu` VALUES (20, 1002);
INSERT INTO `sys_role_menu` VALUES (20, 1006);
INSERT INTO `sys_role_menu` VALUES (20, 1008);
INSERT INTO `sys_role_menu` VALUES (20, 1009);
INSERT INTO `sys_role_menu` VALUES (20, 1017);
INSERT INTO `sys_role_menu` VALUES (20, 2027);
INSERT INTO `sys_role_menu` VALUES (20, 2028);
INSERT INTO `sys_role_menu` VALUES (20, 2029);
INSERT INTO `sys_role_menu` VALUES (20, 2030);
INSERT INTO `sys_role_menu` VALUES (20, 2034);
INSERT INTO `sys_role_menu` VALUES (20, 2037);
INSERT INTO `sys_role_menu` VALUES (20, 2038);
INSERT INTO `sys_role_menu` VALUES (20, 2039);
INSERT INTO `sys_role_menu` VALUES (20, 2040);
INSERT INTO `sys_role_menu` VALUES (20, 2041);
INSERT INTO `sys_role_menu` VALUES (20, 2042);
INSERT INTO `sys_role_menu` VALUES (20, 2043);
INSERT INTO `sys_role_menu` VALUES (20, 2050);
INSERT INTO `sys_role_menu` VALUES (20, 2051);
INSERT INTO `sys_role_menu` VALUES (20, 2052);
INSERT INTO `sys_role_menu` VALUES (20, 2053);
INSERT INTO `sys_role_menu` VALUES (20, 2063);
INSERT INTO `sys_role_menu` VALUES (20, 2064);
INSERT INTO `sys_role_menu` VALUES (20, 2065);
INSERT INTO `sys_role_menu` VALUES (20, 2066);
INSERT INTO `sys_role_menu` VALUES (20, 2067);
INSERT INTO `sys_role_menu` VALUES (20, 2068);
INSERT INTO `sys_role_menu` VALUES (20, 2069);
INSERT INTO `sys_role_menu` VALUES (20, 2070);
INSERT INTO `sys_role_menu` VALUES (20, 2089);
INSERT INTO `sys_role_menu` VALUES (20, 2102);
INSERT INTO `sys_role_menu` VALUES (20, 2125);
INSERT INTO `sys_role_menu` VALUES (20, 2137);
INSERT INTO `sys_role_menu` VALUES (20, 2309);
INSERT INTO `sys_role_menu` VALUES (21, 8);
INSERT INTO `sys_role_menu` VALUES (21, 100);
INSERT INTO `sys_role_menu` VALUES (21, 101);
INSERT INTO `sys_role_menu` VALUES (21, 103);
INSERT INTO `sys_role_menu` VALUES (21, 1001);
INSERT INTO `sys_role_menu` VALUES (21, 1002);
INSERT INTO `sys_role_menu` VALUES (21, 1006);
INSERT INTO `sys_role_menu` VALUES (21, 1008);
INSERT INTO `sys_role_menu` VALUES (21, 1009);
INSERT INTO `sys_role_menu` VALUES (21, 1017);
INSERT INTO `sys_role_menu` VALUES (21, 2000);
INSERT INTO `sys_role_menu` VALUES (21, 2001);
INSERT INTO `sys_role_menu` VALUES (21, 2003);
INSERT INTO `sys_role_menu` VALUES (21, 2004);
INSERT INTO `sys_role_menu` VALUES (21, 2005);
INSERT INTO `sys_role_menu` VALUES (21, 2006);
INSERT INTO `sys_role_menu` VALUES (21, 2008);
INSERT INTO `sys_role_menu` VALUES (21, 2009);
INSERT INTO `sys_role_menu` VALUES (21, 2010);
INSERT INTO `sys_role_menu` VALUES (21, 2011);
INSERT INTO `sys_role_menu` VALUES (21, 2012);
INSERT INTO `sys_role_menu` VALUES (21, 2013);
INSERT INTO `sys_role_menu` VALUES (21, 2014);
INSERT INTO `sys_role_menu` VALUES (21, 2015);
INSERT INTO `sys_role_menu` VALUES (21, 2017);
INSERT INTO `sys_role_menu` VALUES (21, 2020);
INSERT INTO `sys_role_menu` VALUES (21, 2021);
INSERT INTO `sys_role_menu` VALUES (21, 2022);
INSERT INTO `sys_role_menu` VALUES (21, 2023);
INSERT INTO `sys_role_menu` VALUES (21, 2024);
INSERT INTO `sys_role_menu` VALUES (21, 2025);
INSERT INTO `sys_role_menu` VALUES (21, 2026);
INSERT INTO `sys_role_menu` VALUES (21, 2027);
INSERT INTO `sys_role_menu` VALUES (21, 2028);
INSERT INTO `sys_role_menu` VALUES (21, 2029);
INSERT INTO `sys_role_menu` VALUES (21, 2030);
INSERT INTO `sys_role_menu` VALUES (21, 2034);
INSERT INTO `sys_role_menu` VALUES (21, 2037);
INSERT INTO `sys_role_menu` VALUES (21, 2038);
INSERT INTO `sys_role_menu` VALUES (21, 2039);
INSERT INTO `sys_role_menu` VALUES (21, 2040);
INSERT INTO `sys_role_menu` VALUES (21, 2041);
INSERT INTO `sys_role_menu` VALUES (21, 2042);
INSERT INTO `sys_role_menu` VALUES (21, 2043);
INSERT INTO `sys_role_menu` VALUES (21, 2050);
INSERT INTO `sys_role_menu` VALUES (21, 2051);
INSERT INTO `sys_role_menu` VALUES (21, 2052);
INSERT INTO `sys_role_menu` VALUES (21, 2053);
INSERT INTO `sys_role_menu` VALUES (21, 2058);
INSERT INTO `sys_role_menu` VALUES (21, 2059);
INSERT INTO `sys_role_menu` VALUES (21, 2060);
INSERT INTO `sys_role_menu` VALUES (21, 2061);
INSERT INTO `sys_role_menu` VALUES (21, 2062);
INSERT INTO `sys_role_menu` VALUES (21, 2063);
INSERT INTO `sys_role_menu` VALUES (21, 2064);
INSERT INTO `sys_role_menu` VALUES (21, 2065);
INSERT INTO `sys_role_menu` VALUES (21, 2066);
INSERT INTO `sys_role_menu` VALUES (21, 2067);
INSERT INTO `sys_role_menu` VALUES (21, 2068);
INSERT INTO `sys_role_menu` VALUES (21, 2069);
INSERT INTO `sys_role_menu` VALUES (21, 2070);
INSERT INTO `sys_role_menu` VALUES (21, 2071);
INSERT INTO `sys_role_menu` VALUES (21, 2072);
INSERT INTO `sys_role_menu` VALUES (21, 2073);
INSERT INTO `sys_role_menu` VALUES (21, 2074);
INSERT INTO `sys_role_menu` VALUES (21, 2075);
INSERT INTO `sys_role_menu` VALUES (21, 2076);
INSERT INTO `sys_role_menu` VALUES (21, 2080);
INSERT INTO `sys_role_menu` VALUES (21, 2081);
INSERT INTO `sys_role_menu` VALUES (21, 2082);
INSERT INTO `sys_role_menu` VALUES (21, 2084);
INSERT INTO `sys_role_menu` VALUES (21, 2085);
INSERT INTO `sys_role_menu` VALUES (21, 2087);
INSERT INTO `sys_role_menu` VALUES (21, 2088);
INSERT INTO `sys_role_menu` VALUES (21, 2089);
INSERT INTO `sys_role_menu` VALUES (21, 2093);
INSERT INTO `sys_role_menu` VALUES (21, 2102);
INSERT INTO `sys_role_menu` VALUES (21, 2104);
INSERT INTO `sys_role_menu` VALUES (21, 2106);
INSERT INTO `sys_role_menu` VALUES (21, 2108);
INSERT INTO `sys_role_menu` VALUES (21, 2109);
INSERT INTO `sys_role_menu` VALUES (21, 2110);
INSERT INTO `sys_role_menu` VALUES (21, 2125);
INSERT INTO `sys_role_menu` VALUES (21, 2137);
INSERT INTO `sys_role_menu` VALUES (21, 2153);
INSERT INTO `sys_role_menu` VALUES (21, 2154);
INSERT INTO `sys_role_menu` VALUES (21, 2155);
INSERT INTO `sys_role_menu` VALUES (21, 2156);
INSERT INTO `sys_role_menu` VALUES (21, 2167);
INSERT INTO `sys_role_menu` VALUES (21, 2168);
INSERT INTO `sys_role_menu` VALUES (21, 2169);
INSERT INTO `sys_role_menu` VALUES (21, 2202);
INSERT INTO `sys_role_menu` VALUES (21, 2203);
INSERT INTO `sys_role_menu` VALUES (21, 2214);
INSERT INTO `sys_role_menu` VALUES (21, 2238);
INSERT INTO `sys_role_menu` VALUES (21, 2239);
INSERT INTO `sys_role_menu` VALUES (21, 2240);
INSERT INTO `sys_role_menu` VALUES (21, 2241);
INSERT INTO `sys_role_menu` VALUES (21, 2242);
INSERT INTO `sys_role_menu` VALUES (21, 2256);
INSERT INTO `sys_role_menu` VALUES (21, 2263);
INSERT INTO `sys_role_menu` VALUES (21, 2269);
INSERT INTO `sys_role_menu` VALUES (21, 2270);
INSERT INTO `sys_role_menu` VALUES (21, 2295);
INSERT INTO `sys_role_menu` VALUES (21, 2298);
INSERT INTO `sys_role_menu` VALUES (21, 2309);
INSERT INTO `sys_role_menu` VALUES (22, 100);
INSERT INTO `sys_role_menu` VALUES (22, 101);
INSERT INTO `sys_role_menu` VALUES (22, 103);
INSERT INTO `sys_role_menu` VALUES (22, 1001);
INSERT INTO `sys_role_menu` VALUES (22, 1002);
INSERT INTO `sys_role_menu` VALUES (22, 1006);
INSERT INTO `sys_role_menu` VALUES (22, 1008);
INSERT INTO `sys_role_menu` VALUES (22, 1009);
INSERT INTO `sys_role_menu` VALUES (22, 1017);
INSERT INTO `sys_role_menu` VALUES (22, 2027);
INSERT INTO `sys_role_menu` VALUES (22, 2028);
INSERT INTO `sys_role_menu` VALUES (22, 2029);
INSERT INTO `sys_role_menu` VALUES (22, 2030);
INSERT INTO `sys_role_menu` VALUES (22, 2034);
INSERT INTO `sys_role_menu` VALUES (22, 2037);
INSERT INTO `sys_role_menu` VALUES (22, 2038);
INSERT INTO `sys_role_menu` VALUES (22, 2039);
INSERT INTO `sys_role_menu` VALUES (22, 2040);
INSERT INTO `sys_role_menu` VALUES (22, 2041);
INSERT INTO `sys_role_menu` VALUES (22, 2042);
INSERT INTO `sys_role_menu` VALUES (22, 2043);
INSERT INTO `sys_role_menu` VALUES (22, 2050);
INSERT INTO `sys_role_menu` VALUES (22, 2051);
INSERT INTO `sys_role_menu` VALUES (22, 2052);
INSERT INTO `sys_role_menu` VALUES (22, 2053);
INSERT INTO `sys_role_menu` VALUES (22, 2063);
INSERT INTO `sys_role_menu` VALUES (22, 2064);
INSERT INTO `sys_role_menu` VALUES (22, 2065);
INSERT INTO `sys_role_menu` VALUES (22, 2066);
INSERT INTO `sys_role_menu` VALUES (22, 2067);
INSERT INTO `sys_role_menu` VALUES (22, 2068);
INSERT INTO `sys_role_menu` VALUES (22, 2069);
INSERT INTO `sys_role_menu` VALUES (22, 2070);
INSERT INTO `sys_role_menu` VALUES (22, 2089);
INSERT INTO `sys_role_menu` VALUES (22, 2102);
INSERT INTO `sys_role_menu` VALUES (22, 2125);
INSERT INTO `sys_role_menu` VALUES (22, 2137);
INSERT INTO `sys_role_menu` VALUES (22, 2309);
INSERT INTO `sys_role_menu` VALUES (23, 1);
INSERT INTO `sys_role_menu` VALUES (23, 2);
INSERT INTO `sys_role_menu` VALUES (23, 3);
INSERT INTO `sys_role_menu` VALUES (23, 8);
INSERT INTO `sys_role_menu` VALUES (23, 100);
INSERT INTO `sys_role_menu` VALUES (23, 101);
INSERT INTO `sys_role_menu` VALUES (23, 102);
INSERT INTO `sys_role_menu` VALUES (23, 103);
INSERT INTO `sys_role_menu` VALUES (23, 104);
INSERT INTO `sys_role_menu` VALUES (23, 105);
INSERT INTO `sys_role_menu` VALUES (23, 106);
INSERT INTO `sys_role_menu` VALUES (23, 108);
INSERT INTO `sys_role_menu` VALUES (23, 110);
INSERT INTO `sys_role_menu` VALUES (23, 114);
INSERT INTO `sys_role_menu` VALUES (23, 115);
INSERT INTO `sys_role_menu` VALUES (23, 1001);
INSERT INTO `sys_role_menu` VALUES (23, 1002);
INSERT INTO `sys_role_menu` VALUES (23, 1006);
INSERT INTO `sys_role_menu` VALUES (23, 1008);
INSERT INTO `sys_role_menu` VALUES (23, 1009);
INSERT INTO `sys_role_menu` VALUES (23, 1013);
INSERT INTO `sys_role_menu` VALUES (23, 1017);
INSERT INTO `sys_role_menu` VALUES (23, 1021);
INSERT INTO `sys_role_menu` VALUES (23, 1026);
INSERT INTO `sys_role_menu` VALUES (23, 1031);
INSERT INTO `sys_role_menu` VALUES (23, 1049);
INSERT INTO `sys_role_menu` VALUES (23, 1055);
INSERT INTO `sys_role_menu` VALUES (23, 2000);
INSERT INTO `sys_role_menu` VALUES (23, 2001);
INSERT INTO `sys_role_menu` VALUES (23, 2003);
INSERT INTO `sys_role_menu` VALUES (23, 2004);
INSERT INTO `sys_role_menu` VALUES (23, 2005);
INSERT INTO `sys_role_menu` VALUES (23, 2006);
INSERT INTO `sys_role_menu` VALUES (23, 2008);
INSERT INTO `sys_role_menu` VALUES (23, 2009);
INSERT INTO `sys_role_menu` VALUES (23, 2010);
INSERT INTO `sys_role_menu` VALUES (23, 2011);
INSERT INTO `sys_role_menu` VALUES (23, 2012);
INSERT INTO `sys_role_menu` VALUES (23, 2013);
INSERT INTO `sys_role_menu` VALUES (23, 2014);
INSERT INTO `sys_role_menu` VALUES (23, 2015);
INSERT INTO `sys_role_menu` VALUES (23, 2017);
INSERT INTO `sys_role_menu` VALUES (23, 2018);
INSERT INTO `sys_role_menu` VALUES (23, 2019);
INSERT INTO `sys_role_menu` VALUES (23, 2020);
INSERT INTO `sys_role_menu` VALUES (23, 2021);
INSERT INTO `sys_role_menu` VALUES (23, 2022);
INSERT INTO `sys_role_menu` VALUES (23, 2023);
INSERT INTO `sys_role_menu` VALUES (23, 2024);
INSERT INTO `sys_role_menu` VALUES (23, 2025);
INSERT INTO `sys_role_menu` VALUES (23, 2026);
INSERT INTO `sys_role_menu` VALUES (23, 2027);
INSERT INTO `sys_role_menu` VALUES (23, 2028);
INSERT INTO `sys_role_menu` VALUES (23, 2029);
INSERT INTO `sys_role_menu` VALUES (23, 2030);
INSERT INTO `sys_role_menu` VALUES (23, 2034);
INSERT INTO `sys_role_menu` VALUES (23, 2037);
INSERT INTO `sys_role_menu` VALUES (23, 2038);
INSERT INTO `sys_role_menu` VALUES (23, 2039);
INSERT INTO `sys_role_menu` VALUES (23, 2040);
INSERT INTO `sys_role_menu` VALUES (23, 2041);
INSERT INTO `sys_role_menu` VALUES (23, 2042);
INSERT INTO `sys_role_menu` VALUES (23, 2043);
INSERT INTO `sys_role_menu` VALUES (23, 2050);
INSERT INTO `sys_role_menu` VALUES (23, 2051);
INSERT INTO `sys_role_menu` VALUES (23, 2052);
INSERT INTO `sys_role_menu` VALUES (23, 2053);
INSERT INTO `sys_role_menu` VALUES (23, 2058);
INSERT INTO `sys_role_menu` VALUES (23, 2059);
INSERT INTO `sys_role_menu` VALUES (23, 2060);
INSERT INTO `sys_role_menu` VALUES (23, 2061);
INSERT INTO `sys_role_menu` VALUES (23, 2062);
INSERT INTO `sys_role_menu` VALUES (23, 2063);
INSERT INTO `sys_role_menu` VALUES (23, 2064);
INSERT INTO `sys_role_menu` VALUES (23, 2065);
INSERT INTO `sys_role_menu` VALUES (23, 2066);
INSERT INTO `sys_role_menu` VALUES (23, 2067);
INSERT INTO `sys_role_menu` VALUES (23, 2068);
INSERT INTO `sys_role_menu` VALUES (23, 2069);
INSERT INTO `sys_role_menu` VALUES (23, 2070);
INSERT INTO `sys_role_menu` VALUES (23, 2071);
INSERT INTO `sys_role_menu` VALUES (23, 2072);
INSERT INTO `sys_role_menu` VALUES (23, 2073);
INSERT INTO `sys_role_menu` VALUES (23, 2074);
INSERT INTO `sys_role_menu` VALUES (23, 2075);
INSERT INTO `sys_role_menu` VALUES (23, 2076);
INSERT INTO `sys_role_menu` VALUES (23, 2079);
INSERT INTO `sys_role_menu` VALUES (23, 2080);
INSERT INTO `sys_role_menu` VALUES (23, 2081);
INSERT INTO `sys_role_menu` VALUES (23, 2082);
INSERT INTO `sys_role_menu` VALUES (23, 2084);
INSERT INTO `sys_role_menu` VALUES (23, 2085);
INSERT INTO `sys_role_menu` VALUES (23, 2086);
INSERT INTO `sys_role_menu` VALUES (23, 2087);
INSERT INTO `sys_role_menu` VALUES (23, 2088);
INSERT INTO `sys_role_menu` VALUES (23, 2089);
INSERT INTO `sys_role_menu` VALUES (23, 2093);
INSERT INTO `sys_role_menu` VALUES (23, 2102);
INSERT INTO `sys_role_menu` VALUES (23, 2104);
INSERT INTO `sys_role_menu` VALUES (23, 2106);
INSERT INTO `sys_role_menu` VALUES (23, 2108);
INSERT INTO `sys_role_menu` VALUES (23, 2109);
INSERT INTO `sys_role_menu` VALUES (23, 2110);
INSERT INTO `sys_role_menu` VALUES (23, 2114);
INSERT INTO `sys_role_menu` VALUES (23, 2125);
INSERT INTO `sys_role_menu` VALUES (23, 2137);
INSERT INTO `sys_role_menu` VALUES (23, 2153);
INSERT INTO `sys_role_menu` VALUES (23, 2154);
INSERT INTO `sys_role_menu` VALUES (23, 2155);
INSERT INTO `sys_role_menu` VALUES (23, 2156);
INSERT INTO `sys_role_menu` VALUES (23, 2167);
INSERT INTO `sys_role_menu` VALUES (23, 2168);
INSERT INTO `sys_role_menu` VALUES (23, 2169);
INSERT INTO `sys_role_menu` VALUES (23, 2170);
INSERT INTO `sys_role_menu` VALUES (23, 2172);
INSERT INTO `sys_role_menu` VALUES (23, 2173);
INSERT INTO `sys_role_menu` VALUES (23, 2175);
INSERT INTO `sys_role_menu` VALUES (23, 2176);
INSERT INTO `sys_role_menu` VALUES (23, 2177);
INSERT INTO `sys_role_menu` VALUES (23, 2178);
INSERT INTO `sys_role_menu` VALUES (23, 2179);
INSERT INTO `sys_role_menu` VALUES (23, 2180);
INSERT INTO `sys_role_menu` VALUES (23, 2181);
INSERT INTO `sys_role_menu` VALUES (23, 2182);
INSERT INTO `sys_role_menu` VALUES (23, 2183);
INSERT INTO `sys_role_menu` VALUES (23, 2184);
INSERT INTO `sys_role_menu` VALUES (23, 2185);
INSERT INTO `sys_role_menu` VALUES (23, 2190);
INSERT INTO `sys_role_menu` VALUES (23, 2191);
INSERT INTO `sys_role_menu` VALUES (23, 2192);
INSERT INTO `sys_role_menu` VALUES (23, 2193);
INSERT INTO `sys_role_menu` VALUES (23, 2194);
INSERT INTO `sys_role_menu` VALUES (23, 2195);
INSERT INTO `sys_role_menu` VALUES (23, 2202);
INSERT INTO `sys_role_menu` VALUES (23, 2203);
INSERT INTO `sys_role_menu` VALUES (23, 2214);
INSERT INTO `sys_role_menu` VALUES (23, 2238);
INSERT INTO `sys_role_menu` VALUES (23, 2239);
INSERT INTO `sys_role_menu` VALUES (23, 2240);
INSERT INTO `sys_role_menu` VALUES (23, 2241);
INSERT INTO `sys_role_menu` VALUES (23, 2242);
INSERT INTO `sys_role_menu` VALUES (23, 2256);
INSERT INTO `sys_role_menu` VALUES (23, 2263);
INSERT INTO `sys_role_menu` VALUES (23, 2269);
INSERT INTO `sys_role_menu` VALUES (23, 2270);
INSERT INTO `sys_role_menu` VALUES (23, 2295);
INSERT INTO `sys_role_menu` VALUES (23, 2298);
INSERT INTO `sys_role_menu` VALUES (23, 2309);
INSERT INTO `sys_role_menu` VALUES (24, 1);
INSERT INTO `sys_role_menu` VALUES (24, 2);
INSERT INTO `sys_role_menu` VALUES (24, 3);
INSERT INTO `sys_role_menu` VALUES (24, 8);
INSERT INTO `sys_role_menu` VALUES (24, 100);
INSERT INTO `sys_role_menu` VALUES (24, 101);
INSERT INTO `sys_role_menu` VALUES (24, 102);
INSERT INTO `sys_role_menu` VALUES (24, 103);
INSERT INTO `sys_role_menu` VALUES (24, 104);
INSERT INTO `sys_role_menu` VALUES (24, 105);
INSERT INTO `sys_role_menu` VALUES (24, 106);
INSERT INTO `sys_role_menu` VALUES (24, 108);
INSERT INTO `sys_role_menu` VALUES (24, 110);
INSERT INTO `sys_role_menu` VALUES (24, 114);
INSERT INTO `sys_role_menu` VALUES (24, 115);
INSERT INTO `sys_role_menu` VALUES (24, 1001);
INSERT INTO `sys_role_menu` VALUES (24, 1002);
INSERT INTO `sys_role_menu` VALUES (24, 1006);
INSERT INTO `sys_role_menu` VALUES (24, 1008);
INSERT INTO `sys_role_menu` VALUES (24, 1009);
INSERT INTO `sys_role_menu` VALUES (24, 1013);
INSERT INTO `sys_role_menu` VALUES (24, 1017);
INSERT INTO `sys_role_menu` VALUES (24, 1021);
INSERT INTO `sys_role_menu` VALUES (24, 1026);
INSERT INTO `sys_role_menu` VALUES (24, 1031);
INSERT INTO `sys_role_menu` VALUES (24, 1049);
INSERT INTO `sys_role_menu` VALUES (24, 1055);
INSERT INTO `sys_role_menu` VALUES (24, 2000);
INSERT INTO `sys_role_menu` VALUES (24, 2001);
INSERT INTO `sys_role_menu` VALUES (24, 2003);
INSERT INTO `sys_role_menu` VALUES (24, 2004);
INSERT INTO `sys_role_menu` VALUES (24, 2005);
INSERT INTO `sys_role_menu` VALUES (24, 2006);
INSERT INTO `sys_role_menu` VALUES (24, 2008);
INSERT INTO `sys_role_menu` VALUES (24, 2009);
INSERT INTO `sys_role_menu` VALUES (24, 2010);
INSERT INTO `sys_role_menu` VALUES (24, 2011);
INSERT INTO `sys_role_menu` VALUES (24, 2012);
INSERT INTO `sys_role_menu` VALUES (24, 2013);
INSERT INTO `sys_role_menu` VALUES (24, 2014);
INSERT INTO `sys_role_menu` VALUES (24, 2015);
INSERT INTO `sys_role_menu` VALUES (24, 2017);
INSERT INTO `sys_role_menu` VALUES (24, 2018);
INSERT INTO `sys_role_menu` VALUES (24, 2019);
INSERT INTO `sys_role_menu` VALUES (24, 2020);
INSERT INTO `sys_role_menu` VALUES (24, 2021);
INSERT INTO `sys_role_menu` VALUES (24, 2022);
INSERT INTO `sys_role_menu` VALUES (24, 2023);
INSERT INTO `sys_role_menu` VALUES (24, 2024);
INSERT INTO `sys_role_menu` VALUES (24, 2025);
INSERT INTO `sys_role_menu` VALUES (24, 2026);
INSERT INTO `sys_role_menu` VALUES (24, 2027);
INSERT INTO `sys_role_menu` VALUES (24, 2028);
INSERT INTO `sys_role_menu` VALUES (24, 2029);
INSERT INTO `sys_role_menu` VALUES (24, 2030);
INSERT INTO `sys_role_menu` VALUES (24, 2034);
INSERT INTO `sys_role_menu` VALUES (24, 2037);
INSERT INTO `sys_role_menu` VALUES (24, 2038);
INSERT INTO `sys_role_menu` VALUES (24, 2039);
INSERT INTO `sys_role_menu` VALUES (24, 2040);
INSERT INTO `sys_role_menu` VALUES (24, 2041);
INSERT INTO `sys_role_menu` VALUES (24, 2042);
INSERT INTO `sys_role_menu` VALUES (24, 2043);
INSERT INTO `sys_role_menu` VALUES (24, 2050);
INSERT INTO `sys_role_menu` VALUES (24, 2051);
INSERT INTO `sys_role_menu` VALUES (24, 2052);
INSERT INTO `sys_role_menu` VALUES (24, 2053);
INSERT INTO `sys_role_menu` VALUES (24, 2058);
INSERT INTO `sys_role_menu` VALUES (24, 2059);
INSERT INTO `sys_role_menu` VALUES (24, 2060);
INSERT INTO `sys_role_menu` VALUES (24, 2061);
INSERT INTO `sys_role_menu` VALUES (24, 2062);
INSERT INTO `sys_role_menu` VALUES (24, 2063);
INSERT INTO `sys_role_menu` VALUES (24, 2064);
INSERT INTO `sys_role_menu` VALUES (24, 2065);
INSERT INTO `sys_role_menu` VALUES (24, 2066);
INSERT INTO `sys_role_menu` VALUES (24, 2067);
INSERT INTO `sys_role_menu` VALUES (24, 2068);
INSERT INTO `sys_role_menu` VALUES (24, 2069);
INSERT INTO `sys_role_menu` VALUES (24, 2070);
INSERT INTO `sys_role_menu` VALUES (24, 2071);
INSERT INTO `sys_role_menu` VALUES (24, 2072);
INSERT INTO `sys_role_menu` VALUES (24, 2073);
INSERT INTO `sys_role_menu` VALUES (24, 2074);
INSERT INTO `sys_role_menu` VALUES (24, 2075);
INSERT INTO `sys_role_menu` VALUES (24, 2076);
INSERT INTO `sys_role_menu` VALUES (24, 2079);
INSERT INTO `sys_role_menu` VALUES (24, 2080);
INSERT INTO `sys_role_menu` VALUES (24, 2081);
INSERT INTO `sys_role_menu` VALUES (24, 2082);
INSERT INTO `sys_role_menu` VALUES (24, 2084);
INSERT INTO `sys_role_menu` VALUES (24, 2085);
INSERT INTO `sys_role_menu` VALUES (24, 2086);
INSERT INTO `sys_role_menu` VALUES (24, 2087);
INSERT INTO `sys_role_menu` VALUES (24, 2088);
INSERT INTO `sys_role_menu` VALUES (24, 2089);
INSERT INTO `sys_role_menu` VALUES (24, 2093);
INSERT INTO `sys_role_menu` VALUES (24, 2102);
INSERT INTO `sys_role_menu` VALUES (24, 2104);
INSERT INTO `sys_role_menu` VALUES (24, 2106);
INSERT INTO `sys_role_menu` VALUES (24, 2108);
INSERT INTO `sys_role_menu` VALUES (24, 2109);
INSERT INTO `sys_role_menu` VALUES (24, 2110);
INSERT INTO `sys_role_menu` VALUES (24, 2114);
INSERT INTO `sys_role_menu` VALUES (24, 2125);
INSERT INTO `sys_role_menu` VALUES (24, 2137);
INSERT INTO `sys_role_menu` VALUES (24, 2153);
INSERT INTO `sys_role_menu` VALUES (24, 2154);
INSERT INTO `sys_role_menu` VALUES (24, 2155);
INSERT INTO `sys_role_menu` VALUES (24, 2156);
INSERT INTO `sys_role_menu` VALUES (24, 2167);
INSERT INTO `sys_role_menu` VALUES (24, 2168);
INSERT INTO `sys_role_menu` VALUES (24, 2169);
INSERT INTO `sys_role_menu` VALUES (24, 2170);
INSERT INTO `sys_role_menu` VALUES (24, 2172);
INSERT INTO `sys_role_menu` VALUES (24, 2173);
INSERT INTO `sys_role_menu` VALUES (24, 2175);
INSERT INTO `sys_role_menu` VALUES (24, 2176);
INSERT INTO `sys_role_menu` VALUES (24, 2177);
INSERT INTO `sys_role_menu` VALUES (24, 2178);
INSERT INTO `sys_role_menu` VALUES (24, 2179);
INSERT INTO `sys_role_menu` VALUES (24, 2180);
INSERT INTO `sys_role_menu` VALUES (24, 2181);
INSERT INTO `sys_role_menu` VALUES (24, 2182);
INSERT INTO `sys_role_menu` VALUES (24, 2183);
INSERT INTO `sys_role_menu` VALUES (24, 2184);
INSERT INTO `sys_role_menu` VALUES (24, 2185);
INSERT INTO `sys_role_menu` VALUES (24, 2190);
INSERT INTO `sys_role_menu` VALUES (24, 2191);
INSERT INTO `sys_role_menu` VALUES (24, 2192);
INSERT INTO `sys_role_menu` VALUES (24, 2193);
INSERT INTO `sys_role_menu` VALUES (24, 2194);
INSERT INTO `sys_role_menu` VALUES (24, 2195);
INSERT INTO `sys_role_menu` VALUES (24, 2202);
INSERT INTO `sys_role_menu` VALUES (24, 2203);
INSERT INTO `sys_role_menu` VALUES (24, 2214);
INSERT INTO `sys_role_menu` VALUES (24, 2238);
INSERT INTO `sys_role_menu` VALUES (24, 2239);
INSERT INTO `sys_role_menu` VALUES (24, 2240);
INSERT INTO `sys_role_menu` VALUES (24, 2241);
INSERT INTO `sys_role_menu` VALUES (24, 2242);
INSERT INTO `sys_role_menu` VALUES (24, 2256);
INSERT INTO `sys_role_menu` VALUES (24, 2263);
INSERT INTO `sys_role_menu` VALUES (24, 2269);
INSERT INTO `sys_role_menu` VALUES (24, 2270);
INSERT INTO `sys_role_menu` VALUES (24, 2295);
INSERT INTO `sys_role_menu` VALUES (24, 2298);
INSERT INTO `sys_role_menu` VALUES (24, 2309);
INSERT INTO `sys_role_menu` VALUES (25, 1);
INSERT INTO `sys_role_menu` VALUES (25, 2);
INSERT INTO `sys_role_menu` VALUES (25, 3);
INSERT INTO `sys_role_menu` VALUES (25, 8);
INSERT INTO `sys_role_menu` VALUES (25, 100);
INSERT INTO `sys_role_menu` VALUES (25, 101);
INSERT INTO `sys_role_menu` VALUES (25, 102);
INSERT INTO `sys_role_menu` VALUES (25, 103);
INSERT INTO `sys_role_menu` VALUES (25, 104);
INSERT INTO `sys_role_menu` VALUES (25, 105);
INSERT INTO `sys_role_menu` VALUES (25, 106);
INSERT INTO `sys_role_menu` VALUES (25, 108);
INSERT INTO `sys_role_menu` VALUES (25, 110);
INSERT INTO `sys_role_menu` VALUES (25, 114);
INSERT INTO `sys_role_menu` VALUES (25, 115);
INSERT INTO `sys_role_menu` VALUES (25, 1001);
INSERT INTO `sys_role_menu` VALUES (25, 1002);
INSERT INTO `sys_role_menu` VALUES (25, 1006);
INSERT INTO `sys_role_menu` VALUES (25, 1008);
INSERT INTO `sys_role_menu` VALUES (25, 1009);
INSERT INTO `sys_role_menu` VALUES (25, 1013);
INSERT INTO `sys_role_menu` VALUES (25, 1017);
INSERT INTO `sys_role_menu` VALUES (25, 1021);
INSERT INTO `sys_role_menu` VALUES (25, 1026);
INSERT INTO `sys_role_menu` VALUES (25, 1031);
INSERT INTO `sys_role_menu` VALUES (25, 1049);
INSERT INTO `sys_role_menu` VALUES (25, 1055);
INSERT INTO `sys_role_menu` VALUES (25, 2000);
INSERT INTO `sys_role_menu` VALUES (25, 2001);
INSERT INTO `sys_role_menu` VALUES (25, 2003);
INSERT INTO `sys_role_menu` VALUES (25, 2004);
INSERT INTO `sys_role_menu` VALUES (25, 2005);
INSERT INTO `sys_role_menu` VALUES (25, 2006);
INSERT INTO `sys_role_menu` VALUES (25, 2008);
INSERT INTO `sys_role_menu` VALUES (25, 2009);
INSERT INTO `sys_role_menu` VALUES (25, 2010);
INSERT INTO `sys_role_menu` VALUES (25, 2011);
INSERT INTO `sys_role_menu` VALUES (25, 2012);
INSERT INTO `sys_role_menu` VALUES (25, 2013);
INSERT INTO `sys_role_menu` VALUES (25, 2014);
INSERT INTO `sys_role_menu` VALUES (25, 2015);
INSERT INTO `sys_role_menu` VALUES (25, 2017);
INSERT INTO `sys_role_menu` VALUES (25, 2018);
INSERT INTO `sys_role_menu` VALUES (25, 2019);
INSERT INTO `sys_role_menu` VALUES (25, 2020);
INSERT INTO `sys_role_menu` VALUES (25, 2021);
INSERT INTO `sys_role_menu` VALUES (25, 2022);
INSERT INTO `sys_role_menu` VALUES (25, 2023);
INSERT INTO `sys_role_menu` VALUES (25, 2024);
INSERT INTO `sys_role_menu` VALUES (25, 2025);
INSERT INTO `sys_role_menu` VALUES (25, 2026);
INSERT INTO `sys_role_menu` VALUES (25, 2027);
INSERT INTO `sys_role_menu` VALUES (25, 2028);
INSERT INTO `sys_role_menu` VALUES (25, 2029);
INSERT INTO `sys_role_menu` VALUES (25, 2030);
INSERT INTO `sys_role_menu` VALUES (25, 2034);
INSERT INTO `sys_role_menu` VALUES (25, 2037);
INSERT INTO `sys_role_menu` VALUES (25, 2038);
INSERT INTO `sys_role_menu` VALUES (25, 2039);
INSERT INTO `sys_role_menu` VALUES (25, 2040);
INSERT INTO `sys_role_menu` VALUES (25, 2041);
INSERT INTO `sys_role_menu` VALUES (25, 2042);
INSERT INTO `sys_role_menu` VALUES (25, 2043);
INSERT INTO `sys_role_menu` VALUES (25, 2050);
INSERT INTO `sys_role_menu` VALUES (25, 2051);
INSERT INTO `sys_role_menu` VALUES (25, 2052);
INSERT INTO `sys_role_menu` VALUES (25, 2053);
INSERT INTO `sys_role_menu` VALUES (25, 2058);
INSERT INTO `sys_role_menu` VALUES (25, 2059);
INSERT INTO `sys_role_menu` VALUES (25, 2060);
INSERT INTO `sys_role_menu` VALUES (25, 2061);
INSERT INTO `sys_role_menu` VALUES (25, 2062);
INSERT INTO `sys_role_menu` VALUES (25, 2063);
INSERT INTO `sys_role_menu` VALUES (25, 2064);
INSERT INTO `sys_role_menu` VALUES (25, 2065);
INSERT INTO `sys_role_menu` VALUES (25, 2066);
INSERT INTO `sys_role_menu` VALUES (25, 2067);
INSERT INTO `sys_role_menu` VALUES (25, 2068);
INSERT INTO `sys_role_menu` VALUES (25, 2069);
INSERT INTO `sys_role_menu` VALUES (25, 2070);
INSERT INTO `sys_role_menu` VALUES (25, 2071);
INSERT INTO `sys_role_menu` VALUES (25, 2072);
INSERT INTO `sys_role_menu` VALUES (25, 2073);
INSERT INTO `sys_role_menu` VALUES (25, 2074);
INSERT INTO `sys_role_menu` VALUES (25, 2075);
INSERT INTO `sys_role_menu` VALUES (25, 2076);
INSERT INTO `sys_role_menu` VALUES (25, 2079);
INSERT INTO `sys_role_menu` VALUES (25, 2080);
INSERT INTO `sys_role_menu` VALUES (25, 2081);
INSERT INTO `sys_role_menu` VALUES (25, 2082);
INSERT INTO `sys_role_menu` VALUES (25, 2084);
INSERT INTO `sys_role_menu` VALUES (25, 2085);
INSERT INTO `sys_role_menu` VALUES (25, 2086);
INSERT INTO `sys_role_menu` VALUES (25, 2087);
INSERT INTO `sys_role_menu` VALUES (25, 2088);
INSERT INTO `sys_role_menu` VALUES (25, 2089);
INSERT INTO `sys_role_menu` VALUES (25, 2093);
INSERT INTO `sys_role_menu` VALUES (25, 2102);
INSERT INTO `sys_role_menu` VALUES (25, 2104);
INSERT INTO `sys_role_menu` VALUES (25, 2106);
INSERT INTO `sys_role_menu` VALUES (25, 2108);
INSERT INTO `sys_role_menu` VALUES (25, 2109);
INSERT INTO `sys_role_menu` VALUES (25, 2110);
INSERT INTO `sys_role_menu` VALUES (25, 2114);
INSERT INTO `sys_role_menu` VALUES (25, 2125);
INSERT INTO `sys_role_menu` VALUES (25, 2137);
INSERT INTO `sys_role_menu` VALUES (25, 2153);
INSERT INTO `sys_role_menu` VALUES (25, 2154);
INSERT INTO `sys_role_menu` VALUES (25, 2155);
INSERT INTO `sys_role_menu` VALUES (25, 2156);
INSERT INTO `sys_role_menu` VALUES (25, 2167);
INSERT INTO `sys_role_menu` VALUES (25, 2168);
INSERT INTO `sys_role_menu` VALUES (25, 2169);
INSERT INTO `sys_role_menu` VALUES (25, 2170);
INSERT INTO `sys_role_menu` VALUES (25, 2172);
INSERT INTO `sys_role_menu` VALUES (25, 2173);
INSERT INTO `sys_role_menu` VALUES (25, 2175);
INSERT INTO `sys_role_menu` VALUES (25, 2176);
INSERT INTO `sys_role_menu` VALUES (25, 2177);
INSERT INTO `sys_role_menu` VALUES (25, 2178);
INSERT INTO `sys_role_menu` VALUES (25, 2179);
INSERT INTO `sys_role_menu` VALUES (25, 2180);
INSERT INTO `sys_role_menu` VALUES (25, 2181);
INSERT INTO `sys_role_menu` VALUES (25, 2182);
INSERT INTO `sys_role_menu` VALUES (25, 2183);
INSERT INTO `sys_role_menu` VALUES (25, 2184);
INSERT INTO `sys_role_menu` VALUES (25, 2185);
INSERT INTO `sys_role_menu` VALUES (25, 2190);
INSERT INTO `sys_role_menu` VALUES (25, 2191);
INSERT INTO `sys_role_menu` VALUES (25, 2192);
INSERT INTO `sys_role_menu` VALUES (25, 2193);
INSERT INTO `sys_role_menu` VALUES (25, 2194);
INSERT INTO `sys_role_menu` VALUES (25, 2195);
INSERT INTO `sys_role_menu` VALUES (25, 2202);
INSERT INTO `sys_role_menu` VALUES (25, 2203);
INSERT INTO `sys_role_menu` VALUES (25, 2214);
INSERT INTO `sys_role_menu` VALUES (25, 2238);
INSERT INTO `sys_role_menu` VALUES (25, 2239);
INSERT INTO `sys_role_menu` VALUES (25, 2240);
INSERT INTO `sys_role_menu` VALUES (25, 2241);
INSERT INTO `sys_role_menu` VALUES (25, 2242);
INSERT INTO `sys_role_menu` VALUES (25, 2256);
INSERT INTO `sys_role_menu` VALUES (25, 2263);
INSERT INTO `sys_role_menu` VALUES (25, 2269);
INSERT INTO `sys_role_menu` VALUES (25, 2270);
INSERT INTO `sys_role_menu` VALUES (25, 2295);
INSERT INTO `sys_role_menu` VALUES (25, 2298);
INSERT INTO `sys_role_menu` VALUES (25, 2309);
INSERT INTO `sys_role_menu` VALUES (26, 1);
INSERT INTO `sys_role_menu` VALUES (26, 2);
INSERT INTO `sys_role_menu` VALUES (26, 3);
INSERT INTO `sys_role_menu` VALUES (26, 102);
INSERT INTO `sys_role_menu` VALUES (26, 104);
INSERT INTO `sys_role_menu` VALUES (26, 105);
INSERT INTO `sys_role_menu` VALUES (26, 106);
INSERT INTO `sys_role_menu` VALUES (26, 108);
INSERT INTO `sys_role_menu` VALUES (26, 110);
INSERT INTO `sys_role_menu` VALUES (26, 114);
INSERT INTO `sys_role_menu` VALUES (26, 115);
INSERT INTO `sys_role_menu` VALUES (26, 1013);
INSERT INTO `sys_role_menu` VALUES (26, 1021);
INSERT INTO `sys_role_menu` VALUES (26, 1026);
INSERT INTO `sys_role_menu` VALUES (26, 1031);
INSERT INTO `sys_role_menu` VALUES (26, 1049);
INSERT INTO `sys_role_menu` VALUES (26, 1055);
INSERT INTO `sys_role_menu` VALUES (26, 2017);
INSERT INTO `sys_role_menu` VALUES (26, 2018);
INSERT INTO `sys_role_menu` VALUES (26, 2019);
INSERT INTO `sys_role_menu` VALUES (26, 2079);
INSERT INTO `sys_role_menu` VALUES (26, 2086);
INSERT INTO `sys_role_menu` VALUES (26, 2172);
INSERT INTO `sys_role_menu` VALUES (26, 2173);
INSERT INTO `sys_role_menu` VALUES (26, 2175);
INSERT INTO `sys_role_menu` VALUES (26, 2176);
INSERT INTO `sys_role_menu` VALUES (26, 2177);
INSERT INTO `sys_role_menu` VALUES (26, 2178);
INSERT INTO `sys_role_menu` VALUES (26, 2179);
INSERT INTO `sys_role_menu` VALUES (26, 2180);
INSERT INTO `sys_role_menu` VALUES (26, 2181);
INSERT INTO `sys_role_menu` VALUES (26, 2182);
INSERT INTO `sys_role_menu` VALUES (26, 2183);
INSERT INTO `sys_role_menu` VALUES (26, 2184);
INSERT INTO `sys_role_menu` VALUES (26, 2185);
INSERT INTO `sys_role_menu` VALUES (26, 2190);
INSERT INTO `sys_role_menu` VALUES (26, 2191);
INSERT INTO `sys_role_menu` VALUES (26, 2192);
INSERT INTO `sys_role_menu` VALUES (26, 2193);
INSERT INTO `sys_role_menu` VALUES (26, 2194);
INSERT INTO `sys_role_menu` VALUES (26, 2195);
INSERT INTO `sys_role_menu` VALUES (28, 1);
INSERT INTO `sys_role_menu` VALUES (28, 2);
INSERT INTO `sys_role_menu` VALUES (28, 3);
INSERT INTO `sys_role_menu` VALUES (28, 8);
INSERT INTO `sys_role_menu` VALUES (28, 100);
INSERT INTO `sys_role_menu` VALUES (28, 101);
INSERT INTO `sys_role_menu` VALUES (28, 102);
INSERT INTO `sys_role_menu` VALUES (28, 103);
INSERT INTO `sys_role_menu` VALUES (28, 104);
INSERT INTO `sys_role_menu` VALUES (28, 105);
INSERT INTO `sys_role_menu` VALUES (28, 106);
INSERT INTO `sys_role_menu` VALUES (28, 108);
INSERT INTO `sys_role_menu` VALUES (28, 110);
INSERT INTO `sys_role_menu` VALUES (28, 114);
INSERT INTO `sys_role_menu` VALUES (28, 115);
INSERT INTO `sys_role_menu` VALUES (28, 1001);
INSERT INTO `sys_role_menu` VALUES (28, 1002);
INSERT INTO `sys_role_menu` VALUES (28, 1006);
INSERT INTO `sys_role_menu` VALUES (28, 1008);
INSERT INTO `sys_role_menu` VALUES (28, 1009);
INSERT INTO `sys_role_menu` VALUES (28, 1013);
INSERT INTO `sys_role_menu` VALUES (28, 1017);
INSERT INTO `sys_role_menu` VALUES (28, 1021);
INSERT INTO `sys_role_menu` VALUES (28, 1026);
INSERT INTO `sys_role_menu` VALUES (28, 1031);
INSERT INTO `sys_role_menu` VALUES (28, 1049);
INSERT INTO `sys_role_menu` VALUES (28, 1055);
INSERT INTO `sys_role_menu` VALUES (28, 2000);
INSERT INTO `sys_role_menu` VALUES (28, 2001);
INSERT INTO `sys_role_menu` VALUES (28, 2003);
INSERT INTO `sys_role_menu` VALUES (28, 2004);
INSERT INTO `sys_role_menu` VALUES (28, 2005);
INSERT INTO `sys_role_menu` VALUES (28, 2006);
INSERT INTO `sys_role_menu` VALUES (28, 2008);
INSERT INTO `sys_role_menu` VALUES (28, 2009);
INSERT INTO `sys_role_menu` VALUES (28, 2010);
INSERT INTO `sys_role_menu` VALUES (28, 2011);
INSERT INTO `sys_role_menu` VALUES (28, 2012);
INSERT INTO `sys_role_menu` VALUES (28, 2013);
INSERT INTO `sys_role_menu` VALUES (28, 2014);
INSERT INTO `sys_role_menu` VALUES (28, 2015);
INSERT INTO `sys_role_menu` VALUES (28, 2017);
INSERT INTO `sys_role_menu` VALUES (28, 2018);
INSERT INTO `sys_role_menu` VALUES (28, 2019);
INSERT INTO `sys_role_menu` VALUES (28, 2020);
INSERT INTO `sys_role_menu` VALUES (28, 2021);
INSERT INTO `sys_role_menu` VALUES (28, 2022);
INSERT INTO `sys_role_menu` VALUES (28, 2023);
INSERT INTO `sys_role_menu` VALUES (28, 2024);
INSERT INTO `sys_role_menu` VALUES (28, 2025);
INSERT INTO `sys_role_menu` VALUES (28, 2026);
INSERT INTO `sys_role_menu` VALUES (28, 2027);
INSERT INTO `sys_role_menu` VALUES (28, 2028);
INSERT INTO `sys_role_menu` VALUES (28, 2029);
INSERT INTO `sys_role_menu` VALUES (28, 2030);
INSERT INTO `sys_role_menu` VALUES (28, 2034);
INSERT INTO `sys_role_menu` VALUES (28, 2037);
INSERT INTO `sys_role_menu` VALUES (28, 2038);
INSERT INTO `sys_role_menu` VALUES (28, 2039);
INSERT INTO `sys_role_menu` VALUES (28, 2040);
INSERT INTO `sys_role_menu` VALUES (28, 2041);
INSERT INTO `sys_role_menu` VALUES (28, 2042);
INSERT INTO `sys_role_menu` VALUES (28, 2043);
INSERT INTO `sys_role_menu` VALUES (28, 2050);
INSERT INTO `sys_role_menu` VALUES (28, 2051);
INSERT INTO `sys_role_menu` VALUES (28, 2052);
INSERT INTO `sys_role_menu` VALUES (28, 2053);
INSERT INTO `sys_role_menu` VALUES (28, 2058);
INSERT INTO `sys_role_menu` VALUES (28, 2059);
INSERT INTO `sys_role_menu` VALUES (28, 2060);
INSERT INTO `sys_role_menu` VALUES (28, 2061);
INSERT INTO `sys_role_menu` VALUES (28, 2062);
INSERT INTO `sys_role_menu` VALUES (28, 2063);
INSERT INTO `sys_role_menu` VALUES (28, 2064);
INSERT INTO `sys_role_menu` VALUES (28, 2065);
INSERT INTO `sys_role_menu` VALUES (28, 2066);
INSERT INTO `sys_role_menu` VALUES (28, 2067);
INSERT INTO `sys_role_menu` VALUES (28, 2068);
INSERT INTO `sys_role_menu` VALUES (28, 2069);
INSERT INTO `sys_role_menu` VALUES (28, 2070);
INSERT INTO `sys_role_menu` VALUES (28, 2071);
INSERT INTO `sys_role_menu` VALUES (28, 2072);
INSERT INTO `sys_role_menu` VALUES (28, 2073);
INSERT INTO `sys_role_menu` VALUES (28, 2074);
INSERT INTO `sys_role_menu` VALUES (28, 2075);
INSERT INTO `sys_role_menu` VALUES (28, 2076);
INSERT INTO `sys_role_menu` VALUES (28, 2079);
INSERT INTO `sys_role_menu` VALUES (28, 2080);
INSERT INTO `sys_role_menu` VALUES (28, 2081);
INSERT INTO `sys_role_menu` VALUES (28, 2082);
INSERT INTO `sys_role_menu` VALUES (28, 2084);
INSERT INTO `sys_role_menu` VALUES (28, 2085);
INSERT INTO `sys_role_menu` VALUES (28, 2086);
INSERT INTO `sys_role_menu` VALUES (28, 2087);
INSERT INTO `sys_role_menu` VALUES (28, 2088);
INSERT INTO `sys_role_menu` VALUES (28, 2089);
INSERT INTO `sys_role_menu` VALUES (28, 2093);
INSERT INTO `sys_role_menu` VALUES (28, 2102);
INSERT INTO `sys_role_menu` VALUES (28, 2104);
INSERT INTO `sys_role_menu` VALUES (28, 2106);
INSERT INTO `sys_role_menu` VALUES (28, 2108);
INSERT INTO `sys_role_menu` VALUES (28, 2109);
INSERT INTO `sys_role_menu` VALUES (28, 2110);
INSERT INTO `sys_role_menu` VALUES (28, 2114);
INSERT INTO `sys_role_menu` VALUES (28, 2125);
INSERT INTO `sys_role_menu` VALUES (28, 2137);
INSERT INTO `sys_role_menu` VALUES (28, 2153);
INSERT INTO `sys_role_menu` VALUES (28, 2154);
INSERT INTO `sys_role_menu` VALUES (28, 2155);
INSERT INTO `sys_role_menu` VALUES (28, 2156);
INSERT INTO `sys_role_menu` VALUES (28, 2167);
INSERT INTO `sys_role_menu` VALUES (28, 2168);
INSERT INTO `sys_role_menu` VALUES (28, 2169);
INSERT INTO `sys_role_menu` VALUES (28, 2170);
INSERT INTO `sys_role_menu` VALUES (28, 2172);
INSERT INTO `sys_role_menu` VALUES (28, 2173);
INSERT INTO `sys_role_menu` VALUES (28, 2175);
INSERT INTO `sys_role_menu` VALUES (28, 2176);
INSERT INTO `sys_role_menu` VALUES (28, 2177);
INSERT INTO `sys_role_menu` VALUES (28, 2178);
INSERT INTO `sys_role_menu` VALUES (28, 2179);
INSERT INTO `sys_role_menu` VALUES (28, 2180);
INSERT INTO `sys_role_menu` VALUES (28, 2181);
INSERT INTO `sys_role_menu` VALUES (28, 2182);
INSERT INTO `sys_role_menu` VALUES (28, 2183);
INSERT INTO `sys_role_menu` VALUES (28, 2184);
INSERT INTO `sys_role_menu` VALUES (28, 2185);
INSERT INTO `sys_role_menu` VALUES (28, 2190);
INSERT INTO `sys_role_menu` VALUES (28, 2191);
INSERT INTO `sys_role_menu` VALUES (28, 2192);
INSERT INTO `sys_role_menu` VALUES (28, 2193);
INSERT INTO `sys_role_menu` VALUES (28, 2194);
INSERT INTO `sys_role_menu` VALUES (28, 2195);
INSERT INTO `sys_role_menu` VALUES (28, 2202);
INSERT INTO `sys_role_menu` VALUES (28, 2203);
INSERT INTO `sys_role_menu` VALUES (28, 2214);
INSERT INTO `sys_role_menu` VALUES (28, 2238);
INSERT INTO `sys_role_menu` VALUES (28, 2239);
INSERT INTO `sys_role_menu` VALUES (28, 2240);
INSERT INTO `sys_role_menu` VALUES (28, 2241);
INSERT INTO `sys_role_menu` VALUES (28, 2242);
INSERT INTO `sys_role_menu` VALUES (28, 2256);
INSERT INTO `sys_role_menu` VALUES (28, 2263);
INSERT INTO `sys_role_menu` VALUES (28, 2269);
INSERT INTO `sys_role_menu` VALUES (28, 2270);
INSERT INTO `sys_role_menu` VALUES (28, 2295);
INSERT INTO `sys_role_menu` VALUES (28, 2298);
INSERT INTO `sys_role_menu` VALUES (28, 2309);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `user_id` bigint NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint NULL DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '手机号码',
  `sex` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '密码',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime NULL DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `isSales` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '0' COMMENT '是否销售',
  `isPartner` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '0' COMMENT '是否合伙人',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 423540 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '用户信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 100, 'admin', '管理员', '00', '', '', '0', '/profile/avatar/2022/01/12/86bb5301-5e36-4e6a-bc9c-d83d345ff6e5.jpeg', '$2a$10$6rlILudDyVDrQZ5emMCNj.GWPlMNeXA2eK9qUkfuAZabOF/YzYaJS', '0', '0', '127.0.0.1', '2023-06-12 14:19:50', 'admin', '2021-06-05 09:12:09', '', '2023-06-12 14:19:50', '管理员', '1', '1');
INSERT INTO `sys_user` VALUES (100, 100, '5iot', '演示账号', '00', 'iotlink@5iot.cn', '17853123033', '1', '/profile/avatar/2022/01/12/86bb5301-5e36-4e6a-bc9c-d83d345ff6e5.jpeg', '$2a$10$Z03ZGxYMD.p3qk3bKQTQcOCr42DcuDhDVnAa9vgxidpB823psbmSS', '0', '0', '183.238.220.146', '2022-09-05 15:02:55', 'admin', '2021-06-11 09:11:25', 'admin', '2022-09-05 15:02:55', '演示账号', '0', '0');

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post`  (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `post_id` bigint NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`, `post_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '用户与岗位关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
INSERT INTO `sys_user_post` VALUES (1, 1);
INSERT INTO `sys_user_post` VALUES (2, 2);
INSERT INTO `sys_user_post` VALUES (102, 4);
INSERT INTO `sys_user_post` VALUES (166, 4);
INSERT INTO `sys_user_post` VALUES (241, 1);
INSERT INTO `sys_user_post` VALUES (243, 1);
INSERT INTO `sys_user_post` VALUES (335, 4);
INSERT INTO `sys_user_post` VALUES (339, 2);
INSERT INTO `sys_user_post` VALUES (423533, 1);
INSERT INTO `sys_user_post` VALUES (423535, 2);
INSERT INTO `sys_user_post` VALUES (423541, 4);
INSERT INTO `sys_user_post` VALUES (423546, 1);
INSERT INTO `sys_user_post` VALUES (423554, 2);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `role_id` bigint NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '用户和角色关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES (1, 1);
INSERT INTO `sys_user_role` VALUES (2, 2);
INSERT INTO `sys_user_role` VALUES (100, 9);
INSERT INTO `sys_user_role` VALUES (102, 3);
INSERT INTO `sys_user_role` VALUES (104, 2);
INSERT INTO `sys_user_role` VALUES (104, 4);
INSERT INTO `sys_user_role` VALUES (107, 4);
INSERT INTO `sys_user_role` VALUES (108, 4);
INSERT INTO `sys_user_role` VALUES (109, 5);
INSERT INTO `sys_user_role` VALUES (109, 6);
INSERT INTO `sys_user_role` VALUES (110, 5);
INSERT INTO `sys_user_role` VALUES (110, 7);
INSERT INTO `sys_user_role` VALUES (111, 2);
INSERT INTO `sys_user_role` VALUES (111, 4);
INSERT INTO `sys_user_role` VALUES (112, 2);
INSERT INTO `sys_user_role` VALUES (112, 4);
INSERT INTO `sys_user_role` VALUES (113, 5);
INSERT INTO `sys_user_role` VALUES (113, 8);
INSERT INTO `sys_user_role` VALUES (114, 2);
INSERT INTO `sys_user_role` VALUES (114, 4);
INSERT INTO `sys_user_role` VALUES (115, 4);
INSERT INTO `sys_user_role` VALUES (117, 2);
INSERT INTO `sys_user_role` VALUES (117, 4);
INSERT INTO `sys_user_role` VALUES (118, 2);
INSERT INTO `sys_user_role` VALUES (118, 4);
INSERT INTO `sys_user_role` VALUES (119, 2);
INSERT INTO `sys_user_role` VALUES (119, 4);
INSERT INTO `sys_user_role` VALUES (120, 2);
INSERT INTO `sys_user_role` VALUES (120, 4);
INSERT INTO `sys_user_role` VALUES (121, 2);
INSERT INTO `sys_user_role` VALUES (121, 4);
INSERT INTO `sys_user_role` VALUES (122, 2);
INSERT INTO `sys_user_role` VALUES (122, 4);
INSERT INTO `sys_user_role` VALUES (123, 2);
INSERT INTO `sys_user_role` VALUES (123, 4);
INSERT INTO `sys_user_role` VALUES (124, 2);
INSERT INTO `sys_user_role` VALUES (125, 2);
INSERT INTO `sys_user_role` VALUES (125, 4);
INSERT INTO `sys_user_role` VALUES (126, 4);
INSERT INTO `sys_user_role` VALUES (128, 2);
INSERT INTO `sys_user_role` VALUES (128, 4);
INSERT INTO `sys_user_role` VALUES (129, 2);
INSERT INTO `sys_user_role` VALUES (129, 4);
INSERT INTO `sys_user_role` VALUES (130, 2);
INSERT INTO `sys_user_role` VALUES (130, 4);
INSERT INTO `sys_user_role` VALUES (131, 2);
INSERT INTO `sys_user_role` VALUES (131, 4);
INSERT INTO `sys_user_role` VALUES (132, 2);
INSERT INTO `sys_user_role` VALUES (132, 4);
INSERT INTO `sys_user_role` VALUES (133, 2);
INSERT INTO `sys_user_role` VALUES (133, 4);
INSERT INTO `sys_user_role` VALUES (134, 2);
INSERT INTO `sys_user_role` VALUES (134, 4);
INSERT INTO `sys_user_role` VALUES (135, 2);
INSERT INTO `sys_user_role` VALUES (135, 4);
INSERT INTO `sys_user_role` VALUES (136, 2);
INSERT INTO `sys_user_role` VALUES (136, 4);
INSERT INTO `sys_user_role` VALUES (137, 2);
INSERT INTO `sys_user_role` VALUES (137, 4);
INSERT INTO `sys_user_role` VALUES (138, 2);
INSERT INTO `sys_user_role` VALUES (138, 4);
INSERT INTO `sys_user_role` VALUES (139, 2);
INSERT INTO `sys_user_role` VALUES (139, 4);
INSERT INTO `sys_user_role` VALUES (140, 2);
INSERT INTO `sys_user_role` VALUES (140, 4);
INSERT INTO `sys_user_role` VALUES (141, 2);
INSERT INTO `sys_user_role` VALUES (141, 4);
INSERT INTO `sys_user_role` VALUES (142, 2);
INSERT INTO `sys_user_role` VALUES (142, 4);
INSERT INTO `sys_user_role` VALUES (143, 2);
INSERT INTO `sys_user_role` VALUES (143, 4);
INSERT INTO `sys_user_role` VALUES (144, 2);
INSERT INTO `sys_user_role` VALUES (144, 4);
INSERT INTO `sys_user_role` VALUES (145, 2);
INSERT INTO `sys_user_role` VALUES (145, 4);
INSERT INTO `sys_user_role` VALUES (146, 2);
INSERT INTO `sys_user_role` VALUES (146, 4);
INSERT INTO `sys_user_role` VALUES (148, 2);
INSERT INTO `sys_user_role` VALUES (148, 4);
INSERT INTO `sys_user_role` VALUES (150, 2);
INSERT INTO `sys_user_role` VALUES (150, 4);
INSERT INTO `sys_user_role` VALUES (151, 2);
INSERT INTO `sys_user_role` VALUES (151, 4);
INSERT INTO `sys_user_role` VALUES (152, 2);
INSERT INTO `sys_user_role` VALUES (152, 4);
INSERT INTO `sys_user_role` VALUES (154, 2);
INSERT INTO `sys_user_role` VALUES (154, 4);
INSERT INTO `sys_user_role` VALUES (155, 2);
INSERT INTO `sys_user_role` VALUES (155, 4);
INSERT INTO `sys_user_role` VALUES (156, 2);
INSERT INTO `sys_user_role` VALUES (156, 4);
INSERT INTO `sys_user_role` VALUES (157, 2);
INSERT INTO `sys_user_role` VALUES (157, 4);
INSERT INTO `sys_user_role` VALUES (158, 2);
INSERT INTO `sys_user_role` VALUES (158, 4);
INSERT INTO `sys_user_role` VALUES (159, 2);
INSERT INTO `sys_user_role` VALUES (159, 4);
INSERT INTO `sys_user_role` VALUES (160, 2);
INSERT INTO `sys_user_role` VALUES (160, 4);
INSERT INTO `sys_user_role` VALUES (161, 2);
INSERT INTO `sys_user_role` VALUES (161, 4);
INSERT INTO `sys_user_role` VALUES (163, 2);
INSERT INTO `sys_user_role` VALUES (163, 4);
INSERT INTO `sys_user_role` VALUES (164, 2);
INSERT INTO `sys_user_role` VALUES (164, 4);
INSERT INTO `sys_user_role` VALUES (165, 2);
INSERT INTO `sys_user_role` VALUES (165, 4);
INSERT INTO `sys_user_role` VALUES (166, 3);
INSERT INTO `sys_user_role` VALUES (167, 2);
INSERT INTO `sys_user_role` VALUES (167, 4);
INSERT INTO `sys_user_role` VALUES (168, 4);
INSERT INTO `sys_user_role` VALUES (170, 4);
INSERT INTO `sys_user_role` VALUES (171, 4);
INSERT INTO `sys_user_role` VALUES (172, 2);
INSERT INTO `sys_user_role` VALUES (172, 4);
INSERT INTO `sys_user_role` VALUES (173, 2);
INSERT INTO `sys_user_role` VALUES (173, 4);
INSERT INTO `sys_user_role` VALUES (174, 2);
INSERT INTO `sys_user_role` VALUES (174, 4);
INSERT INTO `sys_user_role` VALUES (175, 2);
INSERT INTO `sys_user_role` VALUES (175, 4);
INSERT INTO `sys_user_role` VALUES (176, 2);
INSERT INTO `sys_user_role` VALUES (176, 4);
INSERT INTO `sys_user_role` VALUES (177, 5);
INSERT INTO `sys_user_role` VALUES (178, 4);
INSERT INTO `sys_user_role` VALUES (179, 3);
INSERT INTO `sys_user_role` VALUES (181, 2);
INSERT INTO `sys_user_role` VALUES (181, 4);
INSERT INTO `sys_user_role` VALUES (183, 2);
INSERT INTO `sys_user_role` VALUES (183, 4);
INSERT INTO `sys_user_role` VALUES (184, 2);
INSERT INTO `sys_user_role` VALUES (184, 4);
INSERT INTO `sys_user_role` VALUES (185, 4);
INSERT INTO `sys_user_role` VALUES (186, 2);
INSERT INTO `sys_user_role` VALUES (186, 4);
INSERT INTO `sys_user_role` VALUES (187, 2);
INSERT INTO `sys_user_role` VALUES (187, 4);
INSERT INTO `sys_user_role` VALUES (188, 2);
INSERT INTO `sys_user_role` VALUES (188, 4);
INSERT INTO `sys_user_role` VALUES (189, 2);
INSERT INTO `sys_user_role` VALUES (189, 4);
INSERT INTO `sys_user_role` VALUES (190, 2);
INSERT INTO `sys_user_role` VALUES (190, 4);
INSERT INTO `sys_user_role` VALUES (191, 2);
INSERT INTO `sys_user_role` VALUES (191, 4);
INSERT INTO `sys_user_role` VALUES (192, 2);
INSERT INTO `sys_user_role` VALUES (192, 4);
INSERT INTO `sys_user_role` VALUES (194, 2);
INSERT INTO `sys_user_role` VALUES (194, 4);
INSERT INTO `sys_user_role` VALUES (195, 2);
INSERT INTO `sys_user_role` VALUES (195, 4);
INSERT INTO `sys_user_role` VALUES (196, 2);
INSERT INTO `sys_user_role` VALUES (196, 4);
INSERT INTO `sys_user_role` VALUES (197, 2);
INSERT INTO `sys_user_role` VALUES (197, 4);
INSERT INTO `sys_user_role` VALUES (198, 2);
INSERT INTO `sys_user_role` VALUES (198, 4);
INSERT INTO `sys_user_role` VALUES (199, 2);
INSERT INTO `sys_user_role` VALUES (199, 4);
INSERT INTO `sys_user_role` VALUES (200, 2);
INSERT INTO `sys_user_role` VALUES (200, 4);
INSERT INTO `sys_user_role` VALUES (201, 2);
INSERT INTO `sys_user_role` VALUES (201, 4);
INSERT INTO `sys_user_role` VALUES (202, 2);
INSERT INTO `sys_user_role` VALUES (202, 4);
INSERT INTO `sys_user_role` VALUES (203, 5);
INSERT INTO `sys_user_role` VALUES (203, 7);
INSERT INTO `sys_user_role` VALUES (204, 5);
INSERT INTO `sys_user_role` VALUES (204, 7);
INSERT INTO `sys_user_role` VALUES (205, 5);
INSERT INTO `sys_user_role` VALUES (205, 7);
INSERT INTO `sys_user_role` VALUES (206, 2);
INSERT INTO `sys_user_role` VALUES (206, 4);
INSERT INTO `sys_user_role` VALUES (207, 2);
INSERT INTO `sys_user_role` VALUES (207, 4);
INSERT INTO `sys_user_role` VALUES (208, 2);
INSERT INTO `sys_user_role` VALUES (208, 4);
INSERT INTO `sys_user_role` VALUES (209, 2);
INSERT INTO `sys_user_role` VALUES (209, 4);
INSERT INTO `sys_user_role` VALUES (210, 2);
INSERT INTO `sys_user_role` VALUES (210, 4);
INSERT INTO `sys_user_role` VALUES (211, 2);
INSERT INTO `sys_user_role` VALUES (211, 4);
INSERT INTO `sys_user_role` VALUES (212, 2);
INSERT INTO `sys_user_role` VALUES (212, 4);
INSERT INTO `sys_user_role` VALUES (213, 2);
INSERT INTO `sys_user_role` VALUES (213, 4);
INSERT INTO `sys_user_role` VALUES (214, 2);
INSERT INTO `sys_user_role` VALUES (214, 4);
INSERT INTO `sys_user_role` VALUES (215, 2);
INSERT INTO `sys_user_role` VALUES (215, 4);
INSERT INTO `sys_user_role` VALUES (216, 2);
INSERT INTO `sys_user_role` VALUES (216, 4);
INSERT INTO `sys_user_role` VALUES (217, 2);
INSERT INTO `sys_user_role` VALUES (217, 4);
INSERT INTO `sys_user_role` VALUES (218, 2);
INSERT INTO `sys_user_role` VALUES (218, 4);
INSERT INTO `sys_user_role` VALUES (219, 2);
INSERT INTO `sys_user_role` VALUES (219, 4);
INSERT INTO `sys_user_role` VALUES (220, 2);
INSERT INTO `sys_user_role` VALUES (220, 4);
INSERT INTO `sys_user_role` VALUES (222, 2);
INSERT INTO `sys_user_role` VALUES (222, 4);
INSERT INTO `sys_user_role` VALUES (223, 2);
INSERT INTO `sys_user_role` VALUES (223, 4);
INSERT INTO `sys_user_role` VALUES (224, 2);
INSERT INTO `sys_user_role` VALUES (224, 4);
INSERT INTO `sys_user_role` VALUES (225, 2);
INSERT INTO `sys_user_role` VALUES (225, 4);
INSERT INTO `sys_user_role` VALUES (226, 2);
INSERT INTO `sys_user_role` VALUES (226, 4);
INSERT INTO `sys_user_role` VALUES (228, 4);
INSERT INTO `sys_user_role` VALUES (229, 4);
INSERT INTO `sys_user_role` VALUES (230, 2);
INSERT INTO `sys_user_role` VALUES (230, 4);
INSERT INTO `sys_user_role` VALUES (231, 2);
INSERT INTO `sys_user_role` VALUES (231, 4);
INSERT INTO `sys_user_role` VALUES (232, 2);
INSERT INTO `sys_user_role` VALUES (232, 4);
INSERT INTO `sys_user_role` VALUES (233, 2);
INSERT INTO `sys_user_role` VALUES (233, 4);
INSERT INTO `sys_user_role` VALUES (234, 2);
INSERT INTO `sys_user_role` VALUES (234, 4);
INSERT INTO `sys_user_role` VALUES (235, 2);
INSERT INTO `sys_user_role` VALUES (235, 4);
INSERT INTO `sys_user_role` VALUES (236, 2);
INSERT INTO `sys_user_role` VALUES (236, 4);
INSERT INTO `sys_user_role` VALUES (237, 2);
INSERT INTO `sys_user_role` VALUES (237, 4);
INSERT INTO `sys_user_role` VALUES (238, 2);
INSERT INTO `sys_user_role` VALUES (238, 4);
INSERT INTO `sys_user_role` VALUES (239, 2);
INSERT INTO `sys_user_role` VALUES (239, 4);
INSERT INTO `sys_user_role` VALUES (240, 2);
INSERT INTO `sys_user_role` VALUES (240, 4);
INSERT INTO `sys_user_role` VALUES (241, 4);
INSERT INTO `sys_user_role` VALUES (242, 2);
INSERT INTO `sys_user_role` VALUES (242, 4);
INSERT INTO `sys_user_role` VALUES (243, 2);
INSERT INTO `sys_user_role` VALUES (243, 4);
INSERT INTO `sys_user_role` VALUES (244, 2);
INSERT INTO `sys_user_role` VALUES (244, 4);
INSERT INTO `sys_user_role` VALUES (245, 2);
INSERT INTO `sys_user_role` VALUES (245, 4);
INSERT INTO `sys_user_role` VALUES (246, 4);
INSERT INTO `sys_user_role` VALUES (247, 2);
INSERT INTO `sys_user_role` VALUES (247, 4);
INSERT INTO `sys_user_role` VALUES (248, 2);
INSERT INTO `sys_user_role` VALUES (248, 4);
INSERT INTO `sys_user_role` VALUES (249, 2);
INSERT INTO `sys_user_role` VALUES (249, 4);
INSERT INTO `sys_user_role` VALUES (250, 2);
INSERT INTO `sys_user_role` VALUES (250, 4);
INSERT INTO `sys_user_role` VALUES (251, 2);
INSERT INTO `sys_user_role` VALUES (251, 4);
INSERT INTO `sys_user_role` VALUES (252, 2);
INSERT INTO `sys_user_role` VALUES (252, 4);
INSERT INTO `sys_user_role` VALUES (253, 2);
INSERT INTO `sys_user_role` VALUES (253, 4);
INSERT INTO `sys_user_role` VALUES (254, 2);
INSERT INTO `sys_user_role` VALUES (254, 4);
INSERT INTO `sys_user_role` VALUES (255, 2);
INSERT INTO `sys_user_role` VALUES (255, 4);
INSERT INTO `sys_user_role` VALUES (256, 2);
INSERT INTO `sys_user_role` VALUES (256, 4);
INSERT INTO `sys_user_role` VALUES (257, 2);
INSERT INTO `sys_user_role` VALUES (257, 4);
INSERT INTO `sys_user_role` VALUES (258, 2);
INSERT INTO `sys_user_role` VALUES (258, 4);
INSERT INTO `sys_user_role` VALUES (259, 2);
INSERT INTO `sys_user_role` VALUES (259, 4);
INSERT INTO `sys_user_role` VALUES (260, 2);
INSERT INTO `sys_user_role` VALUES (260, 4);
INSERT INTO `sys_user_role` VALUES (261, 2);
INSERT INTO `sys_user_role` VALUES (261, 4);
INSERT INTO `sys_user_role` VALUES (262, 2);
INSERT INTO `sys_user_role` VALUES (262, 4);
INSERT INTO `sys_user_role` VALUES (263, 2);
INSERT INTO `sys_user_role` VALUES (263, 4);
INSERT INTO `sys_user_role` VALUES (264, 2);
INSERT INTO `sys_user_role` VALUES (264, 4);
INSERT INTO `sys_user_role` VALUES (265, 2);
INSERT INTO `sys_user_role` VALUES (265, 4);
INSERT INTO `sys_user_role` VALUES (266, 2);
INSERT INTO `sys_user_role` VALUES (266, 4);
INSERT INTO `sys_user_role` VALUES (267, 2);
INSERT INTO `sys_user_role` VALUES (267, 4);
INSERT INTO `sys_user_role` VALUES (268, 2);
INSERT INTO `sys_user_role` VALUES (268, 4);
INSERT INTO `sys_user_role` VALUES (269, 2);
INSERT INTO `sys_user_role` VALUES (269, 4);
INSERT INTO `sys_user_role` VALUES (270, 2);
INSERT INTO `sys_user_role` VALUES (270, 4);
INSERT INTO `sys_user_role` VALUES (271, 2);
INSERT INTO `sys_user_role` VALUES (271, 4);
INSERT INTO `sys_user_role` VALUES (272, 2);
INSERT INTO `sys_user_role` VALUES (272, 4);
INSERT INTO `sys_user_role` VALUES (273, 2);
INSERT INTO `sys_user_role` VALUES (273, 4);
INSERT INTO `sys_user_role` VALUES (274, 2);
INSERT INTO `sys_user_role` VALUES (274, 4);
INSERT INTO `sys_user_role` VALUES (275, 2);
INSERT INTO `sys_user_role` VALUES (275, 4);
INSERT INTO `sys_user_role` VALUES (276, 2);
INSERT INTO `sys_user_role` VALUES (276, 4);
INSERT INTO `sys_user_role` VALUES (277, 2);
INSERT INTO `sys_user_role` VALUES (277, 4);
INSERT INTO `sys_user_role` VALUES (278, 2);
INSERT INTO `sys_user_role` VALUES (278, 4);
INSERT INTO `sys_user_role` VALUES (279, 2);
INSERT INTO `sys_user_role` VALUES (279, 4);
INSERT INTO `sys_user_role` VALUES (280, 2);
INSERT INTO `sys_user_role` VALUES (280, 4);
INSERT INTO `sys_user_role` VALUES (281, 2);
INSERT INTO `sys_user_role` VALUES (281, 4);
INSERT INTO `sys_user_role` VALUES (282, 2);
INSERT INTO `sys_user_role` VALUES (282, 4);
INSERT INTO `sys_user_role` VALUES (285, 2);
INSERT INTO `sys_user_role` VALUES (285, 4);
INSERT INTO `sys_user_role` VALUES (286, 2);
INSERT INTO `sys_user_role` VALUES (286, 4);
INSERT INTO `sys_user_role` VALUES (287, 2);
INSERT INTO `sys_user_role` VALUES (287, 4);
INSERT INTO `sys_user_role` VALUES (288, 2);
INSERT INTO `sys_user_role` VALUES (288, 4);
INSERT INTO `sys_user_role` VALUES (289, 2);
INSERT INTO `sys_user_role` VALUES (289, 4);
INSERT INTO `sys_user_role` VALUES (290, 4);
INSERT INTO `sys_user_role` VALUES (291, 2);
INSERT INTO `sys_user_role` VALUES (291, 4);
INSERT INTO `sys_user_role` VALUES (292, 2);
INSERT INTO `sys_user_role` VALUES (292, 4);
INSERT INTO `sys_user_role` VALUES (293, 2);
INSERT INTO `sys_user_role` VALUES (293, 4);
INSERT INTO `sys_user_role` VALUES (294, 2);
INSERT INTO `sys_user_role` VALUES (294, 4);
INSERT INTO `sys_user_role` VALUES (295, 2);
INSERT INTO `sys_user_role` VALUES (295, 4);
INSERT INTO `sys_user_role` VALUES (296, 2);
INSERT INTO `sys_user_role` VALUES (296, 4);
INSERT INTO `sys_user_role` VALUES (297, 2);
INSERT INTO `sys_user_role` VALUES (297, 4);
INSERT INTO `sys_user_role` VALUES (298, 2);
INSERT INTO `sys_user_role` VALUES (298, 4);
INSERT INTO `sys_user_role` VALUES (299, 2);
INSERT INTO `sys_user_role` VALUES (299, 4);
INSERT INTO `sys_user_role` VALUES (300, 2);
INSERT INTO `sys_user_role` VALUES (300, 4);
INSERT INTO `sys_user_role` VALUES (301, 2);
INSERT INTO `sys_user_role` VALUES (301, 4);
INSERT INTO `sys_user_role` VALUES (302, 2);
INSERT INTO `sys_user_role` VALUES (302, 4);
INSERT INTO `sys_user_role` VALUES (303, 2);
INSERT INTO `sys_user_role` VALUES (303, 4);
INSERT INTO `sys_user_role` VALUES (304, 2);
INSERT INTO `sys_user_role` VALUES (304, 4);
INSERT INTO `sys_user_role` VALUES (305, 2);
INSERT INTO `sys_user_role` VALUES (305, 4);
INSERT INTO `sys_user_role` VALUES (306, 2);
INSERT INTO `sys_user_role` VALUES (306, 4);
INSERT INTO `sys_user_role` VALUES (307, 2);
INSERT INTO `sys_user_role` VALUES (307, 4);
INSERT INTO `sys_user_role` VALUES (308, 2);
INSERT INTO `sys_user_role` VALUES (308, 4);
INSERT INTO `sys_user_role` VALUES (309, 2);
INSERT INTO `sys_user_role` VALUES (309, 4);
INSERT INTO `sys_user_role` VALUES (310, 2);
INSERT INTO `sys_user_role` VALUES (310, 4);
INSERT INTO `sys_user_role` VALUES (311, 2);
INSERT INTO `sys_user_role` VALUES (311, 4);
INSERT INTO `sys_user_role` VALUES (312, 2);
INSERT INTO `sys_user_role` VALUES (312, 4);
INSERT INTO `sys_user_role` VALUES (313, 2);
INSERT INTO `sys_user_role` VALUES (313, 4);
INSERT INTO `sys_user_role` VALUES (314, 2);
INSERT INTO `sys_user_role` VALUES (314, 4);
INSERT INTO `sys_user_role` VALUES (315, 2);
INSERT INTO `sys_user_role` VALUES (315, 4);
INSERT INTO `sys_user_role` VALUES (316, 2);
INSERT INTO `sys_user_role` VALUES (316, 4);
INSERT INTO `sys_user_role` VALUES (317, 2);
INSERT INTO `sys_user_role` VALUES (317, 4);
INSERT INTO `sys_user_role` VALUES (318, 2);
INSERT INTO `sys_user_role` VALUES (318, 4);
INSERT INTO `sys_user_role` VALUES (319, 2);
INSERT INTO `sys_user_role` VALUES (319, 4);
INSERT INTO `sys_user_role` VALUES (320, 2);
INSERT INTO `sys_user_role` VALUES (320, 4);
INSERT INTO `sys_user_role` VALUES (321, 2);
INSERT INTO `sys_user_role` VALUES (321, 4);
INSERT INTO `sys_user_role` VALUES (322, 2);
INSERT INTO `sys_user_role` VALUES (322, 4);
INSERT INTO `sys_user_role` VALUES (323, 4);
INSERT INTO `sys_user_role` VALUES (324, 2);
INSERT INTO `sys_user_role` VALUES (324, 4);
INSERT INTO `sys_user_role` VALUES (325, 2);
INSERT INTO `sys_user_role` VALUES (325, 4);
INSERT INTO `sys_user_role` VALUES (326, 2);
INSERT INTO `sys_user_role` VALUES (326, 4);
INSERT INTO `sys_user_role` VALUES (327, 2);
INSERT INTO `sys_user_role` VALUES (327, 4);
INSERT INTO `sys_user_role` VALUES (328, 2);
INSERT INTO `sys_user_role` VALUES (328, 4);
INSERT INTO `sys_user_role` VALUES (329, 2);
INSERT INTO `sys_user_role` VALUES (329, 4);
INSERT INTO `sys_user_role` VALUES (330, 2);
INSERT INTO `sys_user_role` VALUES (330, 4);
INSERT INTO `sys_user_role` VALUES (331, 2);
INSERT INTO `sys_user_role` VALUES (331, 4);
INSERT INTO `sys_user_role` VALUES (332, 2);
INSERT INTO `sys_user_role` VALUES (332, 4);
INSERT INTO `sys_user_role` VALUES (333, 2);
INSERT INTO `sys_user_role` VALUES (333, 4);
INSERT INTO `sys_user_role` VALUES (334, 2);
INSERT INTO `sys_user_role` VALUES (334, 4);
INSERT INTO `sys_user_role` VALUES (335, 2);
INSERT INTO `sys_user_role` VALUES (339, 5);
INSERT INTO `sys_user_role` VALUES (423533, 2);
INSERT INTO `sys_user_role` VALUES (423534, 6);
INSERT INTO `sys_user_role` VALUES (423535, 5);
INSERT INTO `sys_user_role` VALUES (423536, 2);
INSERT INTO `sys_user_role` VALUES (423536, 4);
INSERT INTO `sys_user_role` VALUES (423537, 2);
INSERT INTO `sys_user_role` VALUES (423538, 4);
INSERT INTO `sys_user_role` VALUES (423539, 2);
INSERT INTO `sys_user_role` VALUES (423539, 4);
INSERT INTO `sys_user_role` VALUES (423540, 4);
INSERT INTO `sys_user_role` VALUES (423541, 20);
INSERT INTO `sys_user_role` VALUES (423542, 21);
INSERT INTO `sys_user_role` VALUES (423543, 21);
INSERT INTO `sys_user_role` VALUES (423544, 22);
INSERT INTO `sys_user_role` VALUES (423545, 20);
INSERT INTO `sys_user_role` VALUES (423546, 10);
INSERT INTO `sys_user_role` VALUES (423547, 25);
INSERT INTO `sys_user_role` VALUES (423548, 2);
INSERT INTO `sys_user_role` VALUES (423548, 3);
INSERT INTO `sys_user_role` VALUES (423548, 4);
INSERT INTO `sys_user_role` VALUES (423548, 5);
INSERT INTO `sys_user_role` VALUES (423548, 6);
INSERT INTO `sys_user_role` VALUES (423548, 7);
INSERT INTO `sys_user_role` VALUES (423548, 8);
INSERT INTO `sys_user_role` VALUES (423548, 9);
INSERT INTO `sys_user_role` VALUES (423548, 10);
INSERT INTO `sys_user_role` VALUES (423548, 19);
INSERT INTO `sys_user_role` VALUES (423548, 20);
INSERT INTO `sys_user_role` VALUES (423548, 21);
INSERT INTO `sys_user_role` VALUES (423548, 22);
INSERT INTO `sys_user_role` VALUES (423548, 23);
INSERT INTO `sys_user_role` VALUES (423548, 24);
INSERT INTO `sys_user_role` VALUES (423548, 25);
INSERT INTO `sys_user_role` VALUES (423549, 2);
INSERT INTO `sys_user_role` VALUES (423550, 20);
INSERT INTO `sys_user_role` VALUES (423551, 7);
INSERT INTO `sys_user_role` VALUES (423552, 26);
INSERT INTO `sys_user_role` VALUES (423553, 2);
INSERT INTO `sys_user_role` VALUES (423554, 28);

-- ----------------------------
-- Table structure for yz_agent_account
-- ----------------------------
DROP TABLE IF EXISTS `yz_agent_account`;
CREATE TABLE `yz_agent_account`  (
  `id` char(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'id',
  `app_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '唯一识别',
  `access_key` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '密钥',
  `password` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '密码',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `agent_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `agent_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '关联企业 agent_id',
  `times` int NULL DEFAULT NULL COMMENT '调用频率',
  `openurl` varchar(20000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '放行接口',
  `typesys` int NOT NULL DEFAULT 0 COMMENT '是否为系统内部账户',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `id`(`id`) USING BTREE,
  UNIQUE INDEX `app_id`(`app_id`) USING BTREE,
  INDEX `agent_id`(`agent_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '企业调用api账户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_agent_account
-- ----------------------------
INSERT INTO `yz_agent_account` VALUES ('202306120242131107', '1', '3', '2', '2023-06-12 14:42:13', '2023-06-12 14:42:22', '客户企业', '266', 60, 'simDataUsage,simStatus,simApnFunction,simSession,tariffplan,balance,subscribe', 0);

-- ----------------------------
-- Table structure for yz_agent_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_agent_package`;
CREATE TABLE `yz_agent_package`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐唯一识别号',
  `package_agentname` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '代理商查看名称',
  `package_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐名',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `error_so` double(10, 2) NULL DEFAULT 1.00 COMMENT '套餐SO',
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证 (所属公司)',
  `user_id` int NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证（所属人）',
  `agent_count` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡总数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 64 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '资费组' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_agent_package
-- ----------------------------
INSERT INTO `yz_agent_package` VALUES (62, 'YZ202201140123296552', '大王卡', '移动大王卡', '2022-05-05 17:33:21', 1.00, 266, 423536, '1');
INSERT INTO `yz_agent_package` VALUES (63, 'YZ202201140123296552', '大王卡', '移动大王卡', '2022-07-25 17:06:41', 1.00, 273, 423538, '1');

-- ----------------------------
-- Table structure for yz_agent_packet
-- ----------------------------
DROP TABLE IF EXISTS `yz_agent_packet`;
CREATE TABLE `yz_agent_packet`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐ID',
  `packet_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐包ID',
  `packet_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '套餐包名',
  `packet_wx_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '微信端显示名称',
  `packet_price` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包金额',
  `packet_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包流量',
  `base_packet_type` int NULL DEFAULT 0 COMMENT '资费计划 类型 0:仅一次，1可叠加',
  `packet_type` int NULL DEFAULT 0 COMMENT '加油包类型：0基础加油包-1叠加油包',
  `is_profit` int NULL DEFAULT 0 COMMENT '是否分润：0否 1是',
  `show_profit` int NULL DEFAULT 0 COMMENT '是否显示分润：0否-1是',
  `wechat_pay` int NULL DEFAULT 1 COMMENT '是否可微信支付：0否1是',
  `balance_pay` int NULL DEFAULT 0 COMMENT '是否可余额支付：0否-1是',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐流量',
  `error_so` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包SO倍数',
  `packet_valid_time` int NULL DEFAULT NULL COMMENT '资费计划规格\r\n\r\n，根据packet_valid_name定义，表示为月或年',
  `packet_cost` double(10, 2) NULL DEFAULT NULL COMMENT '成本价',
  `is_month` int NULL DEFAULT NULL COMMENT '是否分月到账：0否 1是',
  `date_limit` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '限制不可充值日期',
  `deduction` int NULL DEFAULT NULL COMMENT '是否支持 自动扣代理预存授信延续',
  `in_stock` int NULL DEFAULT NULL COMMENT '是否在售 0 否 1 是',
  `packet_valid_type` int NULL DEFAULT NULL COMMENT '资费计划生效类型 当月生效 yunze_card_takeEffect_type',
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `packet_valid_name` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '月' COMMENT '资费计划规则 月 年 ',
  `card_count` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡总数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 107 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '资费计划' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_agent_packet
-- ----------------------------
INSERT INTO `yz_agent_packet` VALUES (103, 'YZ202201140123296552', 'YZ6552202201140124584558', '大王卡30MB一月', '30MB一月', 5.00, 30.00, 0, 0, 0, 0, 1, 1, '2022-05-05 17:33:21', 30.00, 1.00, 12, 5.00, 1, '29,30,31', 0, 1, 1, 266, 423536, '年', NULL);
INSERT INTO `yz_agent_packet` VALUES (104, 'YZ202201140123296552', 'YZ6552202205270149522871', '11111', '111', 100.00, 100.00, 0, 0, 0, 0, 1, 1, '2022-06-01 11:56:27', 100.00, 1.00, 3, 100.00, 0, '', 0, 1, 1, 266, 423536, '月', NULL);
INSERT INTO `yz_agent_packet` VALUES (105, 'YZ202201140123296552', 'YZ6552202205250221230042', '0', '0', 8.00, 88.00, 1, 1, 0, 0, 1, 1, '2022-07-11 17:15:06', 29.33, 3.00, 8, 8.00, 1, '8', 0, 1, 1, 266, 423536, '月', NULL);
INSERT INTO `yz_agent_packet` VALUES (106, 'YZ202201140123296552', 'YZ6552202201140124584558', '大王卡30MB一月', '30MB一月', 5.00, 30.00, 0, 0, 0, 0, 1, 1, '2022-07-25 17:06:41', 30.00, 1.00, 12, 5.00, 1, '29,30,31', 0, 1, 1, 273, 423538, '年', NULL);

-- ----------------------------
-- Table structure for yz_applicationfor_renewal
-- ----------------------------
DROP TABLE IF EXISTS `yz_applicationfor_renewal`;
CREATE TABLE `yz_applicationfor_renewal`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `p_id` int NOT NULL COMMENT '主表id',
  `dept_id` int NOT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `packet_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '资费计划数据信息',
  `packet_info` varchar(1000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '资费计划数据信息',
  `card_count` int NOT NULL COMMENT '续费卡总数',
  `packet_wx_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '微信端显示名称',
  `packet_price` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '套餐包金额',
  `packet_flow` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '套餐包流量',
  `packet_cost` double(10, 2) NOT NULL COMMENT '成本价-谁申请的就是谁的',
  `packet_valid_time` int NOT NULL COMMENT '资费计划规格\r\n\r\n，根据packet_valid_name定义，表示为月或年',
  `packet_valid_name` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '月' COMMENT '资费计划规则 月 年 ',
  `generate_tariff_orders` smallint NOT NULL COMMENT '是否已生成批量加包订单',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `order_key`(`p_id`) USING BTREE,
  INDEX `dept_key`(`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '续费申请表-资费计划列表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_applicationfor_renewal
-- ----------------------------
INSERT INTO `yz_applicationfor_renewal` VALUES (4, 2, 100, '2022-08-31 10:06:29', '2022-09-02 15:42:27', 'YZ6552202201140124584558', '{\"packet_cost\":4.5,\"error_so\":1.0,\"packet_valid_type\":1,\"base_packet_type\":0,\"package_id\":\"YZ202201140123296552\",\"in_stock\":1,\"packet_name\":\"大王卡30MB一月\",\"packet_wx_name\":\"30MB一月\",\"date_limit\":\"29,30,31\",\"packet_price\":5.0,\"packet_id\":\"YZ6552202201140124584558\",\"wechat_pay\":1,\"id\":99,\"create_time\":1642137898000,\"packet_flow\":30.0,\"balance_pay\":1,\"is_month\":1,\"deduction\":0,\"show_profit\":0,\"user_id\":1,\"is_profit\":0,\"error_flow\":30.0,\"packet_valid_time\":12,\"dept_id\":100,\"packet_type\":0,\"packet_valid_name\":\"月\"}', 1, '30MB一月', 5.00, 30.00, 4.50, 12, '月', 1);

-- ----------------------------
-- Table structure for yz_applicationfor_renewal_iccid
-- ----------------------------
DROP TABLE IF EXISTS `yz_applicationfor_renewal_iccid`;
CREATE TABLE `yz_applicationfor_renewal_iccid`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'SIM 卡号',
  `b_id` int NOT NULL COMMENT '主表id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid_key`(`b_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '续费申请详情卡号' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_applicationfor_renewal_iccid
-- ----------------------------
INSERT INTO `yz_applicationfor_renewal_iccid` VALUES (1, '89860799999999999999', 4);

-- ----------------------------
-- Table structure for yz_applicationfor_renewal_ordno
-- ----------------------------
DROP TABLE IF EXISTS `yz_applicationfor_renewal_ordno`;
CREATE TABLE `yz_applicationfor_renewal_ordno`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `ord_no` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '订单号',
  `p_id` int NOT NULL COMMENT '主表id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ord_no`(`ord_no`) USING BTREE,
  INDEX `pid_key`(`p_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '续费申请详情卡号' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_applicationfor_renewal_ordno
-- ----------------------------
INSERT INTO `yz_applicationfor_renewal_ordno` VALUES (1, '2022083110062702046432', 2);

-- ----------------------------
-- Table structure for yz_applicationfor_renewal_primary
-- ----------------------------
DROP TABLE IF EXISTS `yz_applicationfor_renewal_primary`;
CREATE TABLE `yz_applicationfor_renewal_primary`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `dept_id` int NOT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `status` smallint NOT NULL DEFAULT 0 COMMENT '状态：0申请中-1审核通过-2审核不通过',
  `info` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注信息-企业提交',
  `annotation` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '内部可看-批注',
  `feedback` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '反馈信息-企业可看',
  `user_id` int NOT NULL COMMENT '申请人',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `is_send` smallint NOT NULL COMMENT '是否抄送通知 0 否 1 是',
  `review_time` datetime NULL DEFAULT NULL COMMENT '审核处理时间',
  `card_sumCount` int NOT NULL COMMENT '续费卡总数',
  `amount` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '总计金额',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `dept_key`(`dept_id`, `user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '续费申请表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_applicationfor_renewal_primary
-- ----------------------------
INSERT INTO `yz_applicationfor_renewal_primary` VALUES (1, 100, '2022-08-31 10:02:22', 0, '', NULL, NULL, 1, '2022-08-31 10:02:22', 1, NULL, 1, 4.50);
INSERT INTO `yz_applicationfor_renewal_primary` VALUES (2, 100, '2022-08-31 10:06:29', 1, '', '已审核OK', '已审核', 1, '2022-08-31 10:16:18', 1, '2022-08-31 10:16:18', 1, 4.50);

-- ----------------------------
-- Table structure for yz_automation_cc
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc`;
CREATE TABLE `yz_automation_cc`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `trigger_type` int NOT NULL COMMENT '触发类型',
  `channel_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '通道id',
  `operation_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '运营商类型',
  `triggering_conditions` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '判断条件',
  `conditions_type` int NULL DEFAULT NULL COMMENT '条件类型',
  `execution_type` int NOT NULL COMMENT '执行动作类型',
  `status` int NOT NULL COMMENT '状态',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `execution_template` int NOT NULL COMMENT '执行模板',
  `dep_id` int NOT NULL COMMENT '所属集团',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `cc_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '抄送名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 34 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '自动化抄送' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_automation_cc
-- ----------------------------

-- ----------------------------
-- Table structure for yz_automation_cc_his
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc_his`;
CREATE TABLE `yz_automation_cc_his`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `cc_id` int NOT NULL COMMENT '抄送任务id',
  `cc_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送API',
  `cc_email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送邮件',
  `cc_state` int NOT NULL COMMENT '抄送状态',
  `cc_result` int NOT NULL COMMENT '抄送结果',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `cc_parameter` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '抄送参数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `cc_count` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '抄送次数',
  `cc_time` datetime NULL DEFAULT NULL COMMENT '最近一次抄送时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '推送记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_automation_cc_his
-- ----------------------------

-- ----------------------------
-- Table structure for yz_automation_cc_url
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc_url`;
CREATE TABLE `yz_automation_cc_url`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `cc_id` int NOT NULL COMMENT '对应自动化规则表',
  `url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送API',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送邮件',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '触发任务推送地址邮箱配置' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_automation_cc_url
-- ----------------------------

-- ----------------------------
-- Table structure for yz_bulk_business
-- ----------------------------
DROP TABLE IF EXISTS `yz_bulk_business`;
CREATE TABLE `yz_bulk_business`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '编号',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  `start_time` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `task_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务名',
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '任务下载地址 1,2,3',
  `auth` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务创建人',
  `agent_id` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '代理编号',
  `type` int NULL DEFAULT NULL COMMENT '类型',
  `state_id` smallint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 79 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '批量任务主表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_bulk_business
-- ----------------------------

-- ----------------------------
-- Table structure for yz_bulk_business_dtails
-- ----------------------------
DROP TABLE IF EXISTS `yz_bulk_business_dtails`;
CREATE TABLE `yz_bulk_business_dtails`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `b_id` int NOT NULL COMMENT '主表id',
  `card_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '号码',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `mydescribe` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '描述',
  `state_id` smallint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 28967 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_bulk_business_dtails
-- ----------------------------

-- ----------------------------
-- Table structure for yz_busi_card_sms
-- ----------------------------
DROP TABLE IF EXISTS `yz_busi_card_sms`;
CREATE TABLE `yz_busi_card_sms`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `msgid` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '短息id',
  `msisdn` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '短信服务号',
  `content` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '下发内容',
  `state_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '状态',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '操作方式',
  `create_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `del_flag` smallint NOT NULL COMMENT '是否删除 0 否 1 是',
  `sms_src_TerminalId` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '短信服务号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '短信收发记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_busi_card_sms
-- ----------------------------

-- ----------------------------
-- Table structure for yz_by_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_by_package`;
CREATE TABLE `yz_by_package`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐唯一识别号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '购卡资费组关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_by_package
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_api_offeringinfo
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_api_offeringinfo`;
CREATE TABLE `yz_card_api_offeringinfo`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `cd_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '通道类型',
  `offeringId` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费 ID',
  `offeringName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费名称',
  `apnName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT 'APN 名称',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  `type` smallint NOT NULL DEFAULT 1 COMMENT '资费类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '上游接口返回已订购资费信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_api_offeringinfo
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_api_offeringinfolist
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_api_offeringinfolist`;
CREATE TABLE `yz_card_api_offeringinfolist`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `offeringId` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费 ID',
  `offeringName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费名称',
  `effectiveDate` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生效时间',
  `expiriedDate` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '失效时间',
  `apnName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT 'APN 名称',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  `cd_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '通道类型',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `iccid`(`iccid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '上游接口返回已订购资费信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_api_offeringinfolist
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_flow
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_flow`;
CREATE TABLE `yz_card_flow`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '充值套餐',
  `packet_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '充值流量包',
  `ord_no` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '订单号',
  `true_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '真实流量，显示在前端的',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '虚后流量，后台以此作控制',
  `start_time` datetime NULL DEFAULT NULL COMMENT '生效时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '到期时间',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `ord_type` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '资费计划 月包 年包 包规格类型',
  `status` int NULL DEFAULT 0 COMMENT '状态：0已失效-2未生效-1生效',
  `packet_type` int NOT NULL COMMENT '叠加包 基础包',
  `use_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '使用流量（针对累计卡保存）',
  `iccid` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '对应串号',
  `error_time` double(30, 2) NOT NULL COMMENT '防超系数',
  `validate_type` int NULL DEFAULT NULL COMMENT '资费生效类别：当月生效，次月生效，周期延顺',
  `validate_time` datetime NULL DEFAULT NULL COMMENT '更新累计包时间',
  `use_true_flow` double(10, 2) NULL DEFAULT NULL COMMENT '天包真实已用流量',
  `use_so_flow` double(10, 2) NULL DEFAULT NULL COMMENT '天包记录已用流量so',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `IDU_Busi_iccid_ord_no`(`iccid`, `ord_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1256705 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '流量包记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_flow
-- ----------------------------
INSERT INTO `yz_card_flow` VALUES (1256704, 'YZ202201140123296552', 'YZ6552202201140124584558', '2022011401340608224300', 30.00, 30.00, '2022-01-14 13:34:07', '2022-01-31 23:59:59', '2022-01-14 13:35:00', '1', 1, 0, NULL, '89860799999999999999', 1.00, 1, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for yz_card_flow_his
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_flow_his`;
CREATE TABLE `yz_card_flow_his`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `total_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '当月使用总量 接口',
  `total_flow_now` double(10, 2) NULL DEFAULT 0.00 COMMENT '当天使用总量 接口',
  `month` int NOT NULL COMMENT '月份',
  `year` int NOT NULL COMMENT '年份',
  `day` int NOT NULL COMMENT '日',
  `iccid` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '对应串号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `total_show_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '当月使用总量 展示用',
  `total_show_flow_now` double(10, 2) NULL DEFAULT 0.00 COMMENT '当天使用总量 展示用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `sel_id`(`id`) USING BTREE,
  INDEX `find_iccid`(`iccid`, `year`, `month`, `day`) USING BTREE,
  INDEX `IDU_Busi_iccid_create_time_update_time`(`create_time`, `update_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 26142703 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '历史流量使用记录表' ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of yz_card_flow_his
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_info`;
CREATE TABLE `yz_card_info`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '编号',
  `vid` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '虚拟编号',
  `msisdn` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'SIM 号码',
  `iccid` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'SIM 卡号',
  `imsi` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'SIM 识别码',
  `open_date` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '开卡日期',
  `activate_date` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '激活日期',
  `agent_id` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '代理编号',
  `channel_id` int NULL DEFAULT NULL COMMENT '通道编号',
  `is_pool` varchar(4) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '是否流量池',
  `pool_id` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '流量池编号',
  `remind_ratio` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒阈值',
  `virtual_ratio` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '虚量阈值',
  `batch_date` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `syn_Time` datetime NULL DEFAULT NULL COMMENT '同步时间',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `create_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '更新者',
  `update_date` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `del_flag` tinyint(1) NULL DEFAULT 0 COMMENT '删除标记',
  `status_id` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡状态描述',
  `package_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '资费组',
  `used` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期用量',
  `remaining` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '剩余用量',
  `deliver_date` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '发货日期',
  `imei` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'IMEI',
  `type` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡类型 对应字典表',
  `network_type` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '网络类型 对应字典表',
  `is_sms` int NULL DEFAULT NULL COMMENT '是否支持短信发送',
  `sms_number` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信服务号码',
  `gprs` int NULL DEFAULT NULL COMMENT 'GPRS是否开启',
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `out_of_stock` date NULL DEFAULT NULL COMMENT '出库日期',
  `is_Disconnected` int NULL DEFAULT NULL COMMENT '未订购资费 是否 轮询断网',
  `connection_status` int NULL DEFAULT NULL COMMENT '断开网状态',
  `customize_grouping` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '自定义分组',
  `remarks` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `due_expire_time` datetime NULL DEFAULT NULL COMMENT '到期时间',
  `status_ShowId` int NULL DEFAULT NULL COMMENT '卡状状态',
  `is_polling` smallint NOT NULL DEFAULT 1 COMMENT '是否轮询 0 否 1 是',
  `is_NetworkBreak` smallint NULL DEFAULT NULL COMMENT '未订购资费 是否 轮询断网',
  `flowTime` datetime NULL DEFAULT NULL COMMENT '最近一次同步用量时间',
  `stateTime` datetime NULL DEFAULT NULL COMMENT '最近一次同步状态时间',
  `firstUseTime` datetime NULL DEFAULT NULL COMMENT '首次用量产生记录时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `IDU_Busi_Card_id`(`id`) USING BTREE,
  UNIQUE INDEX `iccid_sel`(`iccid`) USING BTREE,
  INDEX `IDU_Busi_Card_vid`(`vid`) USING BTREE,
  INDEX `IDU_Busi_Card_imsi`(`imsi`) USING BTREE,
  INDEX `IDU_Busi_Card_msisdn`(`msisdn`) USING BTREE,
  INDEX `IDU_Busi_Card_status_id`(`status_id`) USING BTREE,
  INDEX `IDU_Busi_Card_iccid_used_remaining`(`used`, `customize_grouping`) USING BTREE,
  INDEX `IDU_Busi_Card_agent_id_user_id_iccid`(`agent_id`, `user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1130530 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '模块-智能卡信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_info
-- ----------------------------
INSERT INTO `yz_card_info` VALUES (1129785, '16800000001', '1069999999999', '89860799999999999999', NULL, NULL, '2021-02-01', '266', 1, '0', NULL, NULL, NULL, NULL, '2022-01-11 09:45:30', ' [ 总集团 ] -  [ admin ] ', '2022-01-10 17:14:00', NULL, NULL, 0, '1', 'YZ202201140123296552', 0.00, 30.00, '2023-03-16', NULL, NULL, NULL, 0, NULL, 0, 266, 423539, NULL, NULL, NULL, '23', '23123', '2022-01-31 23:59:59', 4, 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for yz_card_info_change
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_info_change`;
CREATE TABLE `yz_card_info_change`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ctype` int NOT NULL COMMENT '变更类型',
  `cbefore` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更前',
  `cafterward` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更后',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `source_type` int NOT NULL COMMENT '来源类型',
  `execution_status` int NOT NULL COMMENT '执行状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1502644 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '卡状态变更记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_info_change
-- ----------------------------
INSERT INTO `yz_card_info_change` VALUES (1502631, '89860799999999999999', 2, '未知', '已开网', '2022-01-30 14:47:35', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502632, '89860799999999999999', 1, '已激活', '已停机', '2022-04-06 16:39:49', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502633, '89860799999999999999', 1, '已激活', '已停机', '2022-04-11 06:59:10', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502634, '89860799999999999999', 1, '已激活', '已停机', '2022-04-11 20:46:23', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502635, '89860799999999999999', 1, '已激活', '已复机', '2022-05-07 15:05:54', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502636, '89860799999999999999', 1, '已激活', '已复机', '2022-05-11 20:45:15', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502637, '89860799999999999999', 2, '未知', '已断网', '2022-05-11 20:45:28', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502638, '89860799999999999999', 1, '已激活', '已停机', '2022-05-21 23:47:23', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502639, '89860799999999999999', 1, '已激活', '已停机', '2022-05-21 23:47:35', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502640, '89860799999999999999', 2, '未知', '已断网', '2022-07-20 13:55:51', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502641, '89860799999999999999', 2, '未知', '已开网', '2022-08-23 17:37:28', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502642, '89860799999999999999', 1, '已激活', '已停机', '2022-08-28 20:43:30', '执行失败！', 5, 2);
INSERT INTO `yz_card_info_change` VALUES (1502643, '89860799999999999999', 1, '已激活', '已停机', '2022-08-28 20:43:42', '执行失败！', 5, 2);

-- ----------------------------
-- Table structure for yz_card_info_expand
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_info_expand`;
CREATE TABLE `yz_card_info_expand`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `test_period_last_time` date NULL DEFAULT NULL COMMENT '测试期最后时间',
  `silent_period_last_time` date NULL DEFAULT NULL COMMENT '沉默期最后时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '卡列表拓展表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_info_expand
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_isstop
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_isstop`;
CREATE TABLE `yz_card_isstop`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '串号',
  `order_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '唯一订单号',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '状态',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '月初复机有用量 记录\r\n' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_isstop
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_operating
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_operating`;
CREATE TABLE `yz_card_operating`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `create_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '更新者',
  `update_date` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `operating` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作说明',
  `operating_type` int NULL DEFAULT NULL COMMENT '操作类型 对应字典',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '卡信息操作表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_operating
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_package`;
CREATE TABLE `yz_card_package`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐唯一识别号',
  `package_agentname` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '代理商查看名称',
  `package_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐名',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `error_so` double(10, 2) NULL DEFAULT 1.00 COMMENT '套餐SO',
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证 (所属公司)',
  `user_id` int NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证（所属人）',
  `card_count` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡总数',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `package_id`(`package_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '资费组' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_package
-- ----------------------------
INSERT INTO `yz_card_package` VALUES (13, 'YZ202201140123296552', '大王卡', '移动大王卡', '2022-01-14 13:23:29', 1.00, 100, 1, '1');
INSERT INTO `yz_card_package` VALUES (14, 'YZ202203300505155366', '地王卡', '联通地王卡', '2022-03-30 17:05:15', 1.00, 100, 1, NULL);
INSERT INTO `yz_card_package` VALUES (15, 'YZ202204050218434577', '移动NB', '移动NB卡', '2022-04-05 14:18:43', 1.00, 100, 1, NULL);

-- ----------------------------
-- Table structure for yz_card_packet
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_packet`;
CREATE TABLE `yz_card_packet`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐ID',
  `packet_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '套餐包ID',
  `packet_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '套餐包名',
  `packet_wx_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '微信端显示名称',
  `packet_price` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包金额',
  `packet_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包流量',
  `base_packet_type` int NULL DEFAULT 0 COMMENT '资费计划 类型 0:仅一次，1可叠加',
  `packet_type` int NULL DEFAULT 0 COMMENT '加油包类型：0基础加油包-1叠加油包',
  `is_profit` int NULL DEFAULT 0 COMMENT '是否分润：0否 1是',
  `show_profit` int NULL DEFAULT 0 COMMENT '是否显示分润：0否-1是',
  `wechat_pay` int NULL DEFAULT 1 COMMENT '是否可微信支付：0否1是',
  `balance_pay` int NULL DEFAULT 0 COMMENT '是否可余额支付：0否-1是',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐流量',
  `error_so` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包SO倍数',
  `packet_valid_time` int NULL DEFAULT NULL COMMENT '资费计划规格\r\n\r\n，根据packet_valid_name定义，表示为月或年',
  `packet_cost` double(10, 2) NULL DEFAULT NULL COMMENT '成本价',
  `is_month` int NULL DEFAULT NULL COMMENT '是否分月到账：0否 1是',
  `date_limit` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '限制不可充值日期',
  `deduction` int NULL DEFAULT NULL COMMENT '是否支持 自动扣代理预存授信延续',
  `in_stock` int NULL DEFAULT NULL COMMENT '是否在售 0 否 1 是',
  `packet_valid_type` int NULL DEFAULT NULL COMMENT '资费计划生效类型 当月生效 yunze_card_takeEffect_type',
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `packet_valid_name` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '月' COMMENT '资费计划规则 月 年 ',
  `card_count` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡总数',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `packet_id`(`packet_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 102 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '资费计划' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_packet
-- ----------------------------
INSERT INTO `yz_card_packet` VALUES (99, 'YZ202201140123296552', 'YZ6552202201140124584558', '大王卡30MB一月', '30MB一月', 5.00, 30.00, 0, 0, 0, 0, 1, 1, '2022-01-14 13:24:58', 30.00, 1.00, 12, 4.50, 1, '29,30,31', 0, 1, 1, 100, 1, '月', NULL);

-- ----------------------------
-- Table structure for yz_card_polling_error
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_polling_error`;
CREATE TABLE `yz_card_polling_error`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `codeOn` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '错误代码',
  `message` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '错误信息',
  `cd_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '通道编码',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  `is_notice` smallint NOT NULL COMMENT '是否需要通知默认是',
  `rt_map` longblob NOT NULL COMMENT '返回数据',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cd_code_ss`(`cd_code`) USING BTREE,
  INDEX `cd_code`(`cd_code`, `iccid`, `codeOn`) USING BTREE,
  INDEX `is_notice`(`is_notice`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '主要用于记录卡用量接口查询时错误记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_polling_error
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_polling_error_group
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_polling_error_group`;
CREATE TABLE `yz_card_polling_error_group`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `codeOn` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '错误代码',
  `message` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '错误信息',
  `cd_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '通道编码',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  `is_notice` smallint NOT NULL COMMENT '是否需要通知默认是',
  `ct_sum` int NOT NULL COMMENT '卡总数',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `upd_date`(`upd_date`, `is_notice`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '卡用量接口查询时错误记录-分类' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_polling_error_group
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_route
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_route`;
CREATE TABLE `yz_card_route`  (
  `cd_id` int NOT NULL AUTO_INCREMENT,
  `cd_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道编号',
  `cd_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `cd_username` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道注册用户名',
  `cd_pwd` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道用户登录密码',
  `cd_key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道key码',
  `cd_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道url',
  `cd_operator_type` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '运营商类型1移动2联通3电信4其他',
  `cd_concurrency` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '线程数',
  `cd_lunxun` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否轮询:0否1是',
  `cd_control_type` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'API请求 控制类型 0 无 1 内部请求',
  `cd_max_use` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '达量断网阈值',
  `createTime` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `cd_delete` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `cd_agent_id` char(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '代理商id',
  `cd_status` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道状态 1 启用 2 停用 3 已删除',
  `cd_alias` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '通道别名 ',
  `cd_algorithm` smallint NOT NULL DEFAULT 1 COMMENT '通道算法',
  `cd_count` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '卡总数',
  `cd_useraccount` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '登录账号',
  `cd_password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '登录密码',
  `cd_addressurl` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '登录地址',
  `cd_state` char(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '是否正常:0否,1是',
  `success_rate` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '前一天同步成功率',
  `cd_total` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '前一天同步总数',
  `success_total` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '前一天同步成功总数',
  `fail_total` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '前一天同步失败总数',
  `cd_Interface` char(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '对接是否已完成/1.接口信息不全 2. 接口申请中3. 不需要对接4. 已对接',
  `sms_host` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-请求地址',
  `sms_port` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-端口号',
  `sms_source_addr` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-企业代码',
  `sms_shared_secret` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-密码',
  `sms_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-执行模板',
  `sms_src_TerminalId` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '短信-服务号码',
  `sync_upstream` smallint NULL DEFAULT NULL COMMENT '是否同步上游卡号数据',
  `sync_change_notification` smallint NULL DEFAULT NULL COMMENT '上游成员变更是是否通知',
  `sync_data_type` smallint NULL DEFAULT NULL COMMENT '上游返回的数据-同步类型',
  `upstream_card_count` int NULL DEFAULT NULL COMMENT '上游成员卡总数',
  `sync_field` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '自动同步的字段 如 activate_date,open_date',
  PRIMARY KEY (`cd_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 58 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '通道表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_route
-- ----------------------------
INSERT INTO `yz_card_route` VALUES (1, 'ShuoLang', '移动', '000102', '0012', '01874', NULL, '1', NULL, '1', NULL, NULL, '2022-01-10 16:55:13', '2023-06-12 11:34:52', NULL, '100', '1', '中国移动01', 1, '1', '011012', '20101', 'http://39.102.99.213:32003', '1', NULL, NULL, NULL, NULL, '4', '11', '11', '11', '11', 'YD_CMPP', '11', NULL, NULL, NULL, NULL, '');

-- ----------------------------
-- Table structure for yz_card_usage_reminder
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_usage_reminder`;
CREATE TABLE `yz_card_usage_reminder`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `iccid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'iccid',
  `offeringId` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费id',
  `offeringName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '资费激活名称',
  `apnName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT 'APN 名称',
  `totalAmount` double(10, 2) NOT NULL COMMENT '总量，单位：MB',
  `useAmount` double(10, 2) NOT NULL COMMENT '使用量，单位：MB',
  `remainAmount` double(10, 2) NOT NULL COMMENT '剩余量，单位：MB',
  `percentage` double(6, 2) NOT NULL COMMENT '已用百分比',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `id`(`id`) USING BTREE,
  INDEX `iccid`(`iccid`, `offeringId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '上游返回套餐记录信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_card_usage_reminder
-- ----------------------------

-- ----------------------------
-- Table structure for yz_execution_task
-- ----------------------------
DROP TABLE IF EXISTS `yz_execution_task`;
CREATE TABLE `yz_execution_task`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `task_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务名',
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务下载地址 1,2,3',
  `auth` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务创建人',
  `agent_id` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '代理编号',
  `type` int NULL DEFAULT NULL COMMENT '任务类别',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2299 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '执行任务表 系统下载 上传任务\r\n' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_execution_task
-- ----------------------------

-- ----------------------------
-- Table structure for yz_indexpage
-- ----------------------------
DROP TABLE IF EXISTS `yz_indexpage`;
CREATE TABLE `yz_indexpage`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `downCount` int NOT NULL DEFAULT 0 COMMENT '已停机数量',
  `overdoseCount` int NOT NULL DEFAULT 0 COMMENT '超用量数量',
  `expiringSoonCount` int NOT NULL DEFAULT 0 COMMENT '快到期数量',
  `thresholdReachedCount` int NOT NULL DEFAULT 0 COMMENT '已达阈值数量',
  `simCardCount` int NOT NULL DEFAULT 0 COMMENT 'Sim卡总数',
  `simCardNewCount` int NOT NULL DEFAULT 0 COMMENT 'Sim卡本月新增数量',
  `currentMonth` double(13, 2) NOT NULL DEFAULT 0.00 COMMENT '本月数据用量GB',
  `simActivity` double(6, 2) NOT NULL DEFAULT 0.00 COMMENT 'SIm卡活跃度',
  `lifeCycleDistribution` longblob NOT NULL COMMENT '生命周期分布',
  `businessVolumeFlow` longblob NOT NULL COMMENT '业务使用情况-数据',
  `businessVolumeVoice` longblob NULL COMMENT '业务使用情况-语音',
  `businessVolumeMessage` longblob NULL COMMENT '业务使用情况-短信',
  `customerCount` int NOT NULL DEFAULT 0 COMMENT '客户总数',
  `customerNewCount` int NOT NULL DEFAULT 0 COMMENT '本月新增客户',
  `salesContractCount` int NOT NULL DEFAULT 0 COMMENT '本月销售合同总数',
  `salesContractDepositCount` double(13, 2) NOT NULL DEFAULT 0.00 COMMENT '本月销售合同入款金额',
  `weChatOrderCollection` double(13, 2) NOT NULL DEFAULT 0.00 COMMENT '微信订单收款',
  `orderAmount` double(13, 2) NOT NULL DEFAULT 0.00 COMMENT '本月订单总金额',
  `systemCliqueCount` int NOT NULL DEFAULT 0 COMMENT '系统企业总数',
  `systemUserCount` int NOT NULL DEFAULT 0 COMMENT '系统用户总数',
  `activationCardCount` int NOT NULL DEFAULT 0 COMMENT '本月激活卡数',
  `shipCard` int NOT NULL DEFAULT 0 COMMENT '本月发货卡数',
  `logInIp` int NOT NULL DEFAULT 0 COMMENT '本月登录ip总数',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `record_date` date NOT NULL COMMENT '记录日期',
  `dept_id` int NOT NULL COMMENT '所属用户id',
  `requestMap` longblob NOT NULL COMMENT '请求参数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 299 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '首页数据表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_indexpage
-- ----------------------------


-- ----------------------------
-- Table structure for yz_money_change_record
-- ----------------------------
DROP TABLE IF EXISTS `yz_money_change_record`;
CREATE TABLE `yz_money_change_record`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `field_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更字段',
  `field_val` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更字段介绍',
  `mytable_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更表名',
  `mytype` smallint NOT NULL COMMENT '变更类型（手动，业务变更）',
  `mybefore` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更前',
  `change_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更值',
  `myfunction_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '函数名',
  `remarks` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '备注',
  `par_val` longblob NOT NULL COMMENT '请求参数',
  `result` smallint NOT NULL COMMENT '执行结果',
  `sel_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '关联查询 字段',
  `sel_val` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '关联查询 字段值',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_date` datetime NOT NULL COMMENT '最近修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '金额变更记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_money_change_record
-- ----------------------------

-- ----------------------------
-- Table structure for yz_order
-- ----------------------------
DROP TABLE IF EXISTS `yz_order`;
CREATE TABLE `yz_order`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ord_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '唯一订单号',
  `ord_type` int NULL DEFAULT 0 COMMENT '订单类型:1金额充值\r\n-2用量充值',
  `ord_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '交易名称：账户充值-流量加油包',
  `iccid` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '串号',
  `wx_ord_no` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '微信订单号',
  `status` int NULL DEFAULT 0 COMMENT '支付状态：0未支付-1支付成功-2加包成功-3退订',
  `price` double(10, 2) NULL DEFAULT 0.00 COMMENT '交易金额',
  `account` double(10, 2) NULL DEFAULT 0.00 COMMENT '交易后金额',
  `packet_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '交易流量包，充值填0',
  `pay_type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '支付方式：w微信支付-b余额支付-s平台记录',
  `cre_type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '生成方式：sys系统-man人工',
  `is_profit` int NULL DEFAULT 0 COMMENT '是否需要分润：0否-1是',
  `add_package` int NULL DEFAULT 0 COMMENT '是否已经执行过加包 0否 1 是',
  `show_status` int NULL DEFAULT 0 COMMENT '是否显示交易记录:0否-1显示',
  `open_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'openid',
  `agent_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '代理商id',
  `profit_type` int NULL DEFAULT 0 COMMENT '分润类型：0否-1分润比-2差价',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `validate_type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '生效类型：yunze_card_takeEffect_type',
  `info` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `add_parameter` varchar(1000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `add_package_time` datetime NULL DEFAULT NULL COMMENT '加包执行时间',
  `del_flag` tinyint(1) NULL DEFAULT 0 COMMENT '删除标记',
  `is_profit_sharing` tinyint(1) NULL DEFAULT NULL COMMENT '是否已分润 0否 1 是',
  `profit_sharing_time` datetime NULL DEFAULT NULL COMMENT '分润执行时间',
  `is_audit` smallint(5) NOT NULL DEFAULT '1' COMMENT '是否已审核通过 0否 1 是',
  `callback_address` varchar(500) DEFAULT NULL COMMENT '回调地址',
  `callback_status` smallint(5) NOT NULL DEFAULT '0' COMMENT '回调是否成功',
  `callback_time` datetime DEFAULT NULL COMMENT '最近一次回调执行时间',
  `callback_info` varchar(1000) DEFAULT NULL COMMENT '回调返回消息',
  `is_dd_status` smallint(5) DEFAULT NULL COMMENT '是否订购达量断网',
  `is_dd_exCount` int(3) NOT NULL DEFAULT '0' COMMENT '达量断网-执行次数',
  `is_dd_quota` varchar(20) DEFAULT NULL COMMENT '达量断网执行时阈值',
  `is_dd_exTime` datetime DEFAULT NULL COMMENT '订购达量断网 执行时间',
  `is_dd_exStatus` smallint(5) DEFAULT NULL COMMENT '订购达量断网 执行结果',
  `is_boot_status` smallint(5) DEFAULT NULL COMMENT '是否 开机',
  `is_boot_exTime` datetime DEFAULT NULL COMMENT '开机 执行时间',
  `is_boot_exStatus` smallint(5) DEFAULT NULL COMMENT '开机 执行结果',
  `is_boot_exCount` int(3) NOT NULL DEFAULT '0' COMMENT '开机-执行次数',
  `is_openNet_status` smallint(5) DEFAULT NULL COMMENT '是否 开网',
  `is_openNet_exTime` datetime DEFAULT NULL COMMENT '开网 执行时间',
  `is_openNet_exStatus` smallint(5) DEFAULT NULL COMMENT '开网 执行结果',
  `is_openNet_exCount` int(3) NOT NULL DEFAULT '0' COMMENT '开网-执行次数',
  `is_audi` smallint(5) NOT NULL DEFAULT '1' COMMENT '是否已审核通过 0否 1 是',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ord_no`(`ord_no`) USING BTREE,
  KEY `iccid_key` (`iccid`),
  KEY `packet_id_key` (`packet_id`) USING BTREE
  INDEX `agent_id_idx`(`agent_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 452023 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '订单表' ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of yz_order
-- ----------------------------
INSERT INTO `yz_order` VALUES (452017, '2022011401340608224300', 2, '平台批量充值', '89860799999999999999', NULL, 1, 5.00, 0.00, 'YZ6552202201140124584558', 's', 'sys', 0, 1, 0, NULL, '100', 0, '2022-01-14 13:34:07', '1', '加包成功  iccid : 89860799999999999999 SuccessCount 1', '{\"packet_cost\":4.5,\"error_so\":1.0,\"ord_type\":\"2\",\"base_packet_type\":0,\"package_id\":\"YZ202201140123296552\",\"packet_flow\":30.0,\"packet_wx_name\":\"30MB一月\",\"packet_name\":\"大王卡30MB一月\",\"balance_pay\":1,\"date_limit\":\"29,30,31\",\"is_month\":1,\"packet_price\":5.0,\"packet_id\":\"YZ6552202201140124584558\",\"wxValidType\":1,\"validate_type\":\"1\",\"wechat_pay\":1,\"error_flow\":30.0,\"packet_valid_time\":1,\"packet_type\":0,\"packet_valid_name\":\"月\"}', '2022-01-14 13:35:00', 0, 0, NULL);
INSERT INTO `yz_order` VALUES (452018, '2022083109530474440271', 4, '企业预存-人工操作', '', NULL, 1, 100.00, 0.00, NULL, 'al', 'ai', 0, 0, 1, NULL, '266', NULL, '2022-08-31 09:53:06', NULL, '测试', NULL, NULL, 0, 0, NULL);
INSERT INTO `yz_order` VALUES (452019, '2022083109583321118608', 4, '企业预存-人工操作', '', NULL, 1, 100.00, 0.00, NULL, 'al', 'ai', 0, 0, 1, NULL, '100', NULL, '2022-08-31 09:58:34', NULL, '存储', NULL, NULL, 0, 0, NULL);
INSERT INTO `yz_order` VALUES (452020, '2022083110022050243531', 7, '企业续费', '', NULL, 1, 4.50, 95.50, NULL, 'pe', 'sys', 0, 0, 1, NULL, '100', NULL, '2022-08-31 10:02:22', NULL, '', NULL, NULL, 0, 0, NULL);
INSERT INTO `yz_order` VALUES (452021, '2022083110062702046432', 7, '企业续费', '', NULL, 1, 4.50, 91.00, NULL, 'pe', 'sys', 0, 0, 1, NULL, '100', NULL, '2022-08-31 10:06:28', NULL, '', NULL, NULL, 0, 0, NULL);
INSERT INTO `yz_order` VALUES (452022, '2022090203422724823277', 2, '企业续费-用量充值', '89860799999999999999', NULL, 1, 5.00, 0.00, 'YZ6552202201140124584558', 's', 'sys', 0, 0, 0, NULL, '100', 0, '2022-09-02 15:42:27', '3', NULL, '{\"packet_cost\":4.5,\"error_so\":1.0,\"packet_valid_type\":1,\"base_packet_type\":0,\"package_id\":\"YZ202201140123296552\",\"in_stock\":1,\"packet_name\":\"大王卡30MB一月\",\"packet_wx_name\":\"30MB一月\",\"date_limit\":\"29,30,31\",\"packet_price\":5.0,\"packet_id\":\"YZ6552202201140124584558\",\"wechat_pay\":1,\"id\":99,\"create_time\":1642137898000,\"ord_type\":\"2\",\"packet_flow\":30.0,\"balance_pay\":1,\"is_month\":1,\"deduction\":0,\"show_profit\":0,\"user_id\":1,\"is_profit\":0,\"validate_type\":\"3\",\"error_flow\":30.0,\"packet_valid_time\":12,\"dept_id\":100,\"packet_type\":0,\"packet_valid_name\":\"月\"}', NULL, 0, 0, NULL);

-- ----------------------------
-- Table structure for yz_passageway_polling
-- ----------------------------
DROP TABLE IF EXISTS `yz_passageway_polling`;
CREATE TABLE `yz_passageway_polling`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cd_id` int NOT NULL COMMENT '通道编号',
  `create_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `cd_count` int NOT NULL COMMENT '轮序总数',
  `cd_current` int NULL DEFAULT NULL COMMENT '当前轮序数量',
  `polling_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '轮序批次编码',
  `syn_date` datetime NULL DEFAULT NULL COMMENT '最近一次同步时间',
  `polling_type` int NULL DEFAULT NULL COMMENT '轮询类型 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 75746 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '通道轮序详情表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_passageway_polling
-- ----------------------------

-- ----------------------------
-- Table structure for yz_ruepke
-- ----------------------------
DROP TABLE IF EXISTS `yz_ruepke`;
CREATE TABLE `yz_ruepke`  (
  `cd_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '通道ID',
  `package_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '资费组ID'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '通道与资费组关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_ruepke
-- ----------------------------
INSERT INTO `yz_ruepke` VALUES ('1', 'YZ202201140123296552');

-- ----------------------------
-- Table structure for yz_syn_card_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_syn_card_info`;
CREATE TABLE `yz_syn_card_info`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `msisdn` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '接入号',
  `iccid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `imsi` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `activate_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '激活时间',
  `open_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '开卡时间',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_date` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `syn_Time` datetime NULL DEFAULT NULL COMMENT '同步时间',
  `channel_id` int NOT NULL COMMENT '通道编号',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `inconsistent_iccid` smallint NOT NULL DEFAULT 0 COMMENT '是否 与 card_info 表 iccid不一致',
  `is_new` smallint NOT NULL DEFAULT 0 COMMENT '是否 需要新增到 card_info 表',
  `groupId` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '上游成员组id',
  `custId` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '客户id-[DX_CMP]',
  `status_id` smallint NULL DEFAULT NULL COMMENT '卡状态描述 -【DX-CMP】',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `msisdn`(`msisdn`) USING BTREE,
  INDEX `channel_id`(`channel_id`) USING BTREE,
  INDEX `inconsistent_iccid`(`inconsistent_iccid`, `is_new`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 235456 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '上游返回-群组所属成员信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_syn_card_info
-- ----------------------------

-- ----------------------------
-- Table structure for yz_sys_logs
-- ----------------------------
DROP TABLE IF EXISTS `yz_sys_logs`;
CREATE TABLE `yz_sys_logs`  (
  `id` char(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'id',
  `res_url` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '请求url',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `class_method` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '执行的类方法',
  `ip` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'ip',
  `request_args` longblob NOT NULL COMMENT '请求参数',
  `response_args` longblob NOT NULL COMMENT '响应参数',
  `user_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '操作人',
  `project` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '模块',
  `action_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作名称'
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '系统级日志' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_sys_logs
-- ----------------------------

-- ----------------------------
-- Table structure for yz_upstream_group
-- ----------------------------
DROP TABLE IF EXISTS `yz_upstream_group`;
CREATE TABLE `yz_upstream_group`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '群组ID',
  `groupName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '群组名称',
  `offeringId` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '群组主资费id',
  `offeringName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '群组主资费名称',
  `channel_id` int NOT NULL COMMENT '通道编号',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `upd_date` datetime NOT NULL COMMENT '最近一次修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '上游集团群组' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_upstream_group
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wechat_user
-- ----------------------------
DROP TABLE IF EXISTS `yz_wechat_user`;
CREATE TABLE `yz_wechat_user`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `openid` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `head_image` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `iccid` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `sex` int NULL DEFAULT 33,
  `create_time` datetime NULL DEFAULT NULL,
  `city` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `province` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `country` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `app_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `status` int NULL DEFAULT NULL,
  `bind_status` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wechat_user
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_autoreply
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_autoreply`;
CREATE TABLE `yz_wx_autoreply`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `auto_id` int NOT NULL COMMENT '回复ID，区分关注(100)，关键词(200)，默认（1）',
  `keywords` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '关键字',
  `content` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '内容',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `app_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '微信自动回复' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_autoreply
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_brand_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_brand_info`;
CREATE TABLE `yz_wx_by_brand_info`  (
  `brand_id` smallint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '品牌ID',
  `brand_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '品牌名称',
  `telephone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '联系电话',
  `brand_web` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '品牌网络',
  `brand_logo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '品牌logo URL',
  `brand_desc` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '品牌描述',
  `brand_status` tinyint NOT NULL DEFAULT 0 COMMENT '品牌状态,0禁用,1启用',
  `brand_order` tinyint NOT NULL DEFAULT 0 COMMENT '排序',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`brand_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '品牌信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_brand_info
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_product_agent
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_product_agent`;
CREATE TABLE `yz_wx_by_product_agent`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `dept_id` int NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 103 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '商品购买代理关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_product_agent
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_product_category
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_product_category`;
CREATE TABLE `yz_wx_by_product_category`  (
  `category_id` smallint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `category_name` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '分类名称',
  `category_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '分类编码',
  `parent_id` smallint UNSIGNED NOT NULL DEFAULT 0 COMMENT '父分类ID',
  `category_level` tinyint NOT NULL DEFAULT 1 COMMENT '分类层级',
  `category_status` tinyint NOT NULL DEFAULT 1 COMMENT '分类状态',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`category_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '商品分类表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_product_category
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_product_comment
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_product_comment`;
CREATE TABLE `yz_wx_by_product_comment`  (
  `comment_id` int UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `product_id` int UNSIGNED NOT NULL COMMENT '商品ID',
  `order_id` bigint UNSIGNED NOT NULL COMMENT '订单ID',
  `customer_id` int UNSIGNED NOT NULL COMMENT '用户ID',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '评论标题',
  `content` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '评论内容',
  `audit_status` tinyint NOT NULL COMMENT '审核状态：0未审核，1已审核',
  `audit_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '评论时间',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`comment_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '商品评论表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_product_comment
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_product_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_product_info`;
CREATE TABLE `yz_wx_by_product_info`  (
  `product_id` int UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品ID',
  `product_core` char(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '商品编码',
  `product_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '商品名称',
  `bar_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '国条码',
  `brand_id` int UNSIGNED NULL DEFAULT NULL COMMENT '品牌表的ID',
  `one_category_id` smallint UNSIGNED NOT NULL COMMENT '一级分类ID',
  `two_category_id` smallint UNSIGNED NULL DEFAULT NULL COMMENT '二级分类ID',
  `three_category_id` smallint UNSIGNED NULL DEFAULT NULL COMMENT '三级分类ID',
  `supplier_id` int UNSIGNED NULL DEFAULT NULL COMMENT '商品的供应商ID',
  `price` decimal(8, 2) NOT NULL COMMENT '商品销售价格',
  `average_cost` decimal(18, 2) NULL DEFAULT NULL COMMENT '商品加权平均成本',
  `publish_status` tinyint NOT NULL DEFAULT 0 COMMENT '上下架状态：0下架1上架',
  `audit_status` tinyint NOT NULL DEFAULT 0 COMMENT '审核状态：0未审核，1已审核',
  `weight` float NULL DEFAULT NULL COMMENT '商品重量',
  `length` float NULL DEFAULT NULL COMMENT '商品长度',
  `height` float NULL DEFAULT NULL COMMENT '商品高度',
  `width` float NULL DEFAULT NULL COMMENT '商品宽度',
  `color_type` enum('红','黄','蓝','黑') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `production_date` datetime NULL DEFAULT NULL COMMENT '生产日期',
  `shelf_life` int NULL DEFAULT NULL COMMENT '商品有效期',
  `descript` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL COMMENT '商品描述',
  `indate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '商品录入时间',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`product_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '商品信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_product_info
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_product_pic_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_product_pic_info`;
CREATE TABLE `yz_wx_by_product_pic_info`  (
  `product_pic_id` int UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品图片ID',
  `product_id` int UNSIGNED NOT NULL COMMENT '商品ID',
  `pic_desc` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '图片描述',
  `pic_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '图片URL',
  `is_master` tinyint NOT NULL DEFAULT 0 COMMENT '是否主图：0.非主图1.主图',
  `pic_order` tinyint NOT NULL DEFAULT 0 COMMENT '图片排序',
  `pic_status` tinyint NOT NULL DEFAULT 1 COMMENT '图片是否有效：0无效 1有效',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`product_pic_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '商品图片信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_product_pic_info
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_by_supplier_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_by_supplier_info`;
CREATE TABLE `yz_wx_by_supplier_info`  (
  `supplier_id` int UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '供应商ID',
  `supplier_code` char(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '供应商编码',
  `supplier_name` char(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '供应商名称',
  `supplier_type` tinyint NOT NULL COMMENT '供应商类型：1.自营，2.平台',
  `link_man` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '供应商联系人',
  `phone_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '联系电话',
  `bank_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '供应商开户银行名称',
  `bank_account` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '银行账号',
  `address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '供应商地址',
  `supplier_status` tinyint NOT NULL DEFAULT 0 COMMENT '状态：0禁止，1启用',
  `modified_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`supplier_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '供应商信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_by_supplier_info
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_config
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_config`;
CREATE TABLE `yz_wx_config`  (
  `id` char(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '\r\nid',
  `app_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '公众号id',
  `app_secret` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '公众号密钥',
  `app_token` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '接入token',
  `origin_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '原始id',
  `mch_id` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '商户号',
  `paterner_key` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '商户密钥',
  `index_url` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接入路径',
  `back_url` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '回调路径',
  `status` int NULL DEFAULT 0 COMMENT '开启状态：0未开启-1开启',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `create_user` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '更新人',
  `company_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '区分公众号',
  `agent_id` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '所属企业id',
  `native_url` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '扫码回调',
  `auth_txt` varchar(80) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '授权文件名',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `app_id`(`app_id`) USING BTREE,
  UNIQUE INDEX `app_secret`(`app_secret`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '微信公众号配置' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_config
-- ----------------------------

-- ----------------------------
-- Table structure for yz_wx_menu
-- ----------------------------
DROP TABLE IF EXISTS `yz_wx_menu`;
CREATE TABLE `yz_wx_menu`  (
  `id` char(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'id',
  `menu_id` int NOT NULL COMMENT '菜单id',
  `menu_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '菜单名',
  `menu_pid` int NULL DEFAULT 0 COMMENT '父级ID，一级菜单默认0',
  `menu_url` varchar(300) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '菜单：一级菜单默认0',
  `menu_status` int NULL DEFAULT 0 COMMENT '状态：0未开启-1开启',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `create_user` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `app_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '所属微信公众号',
  `menu_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `media_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '微信菜单表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of yz_wx_menu
-- ----------------------------

-- ----------------------------
-- Function structure for queryChildrenAreaInfo
-- ----------------------------
DROP FUNCTION IF EXISTS `queryChildrenAreaInfo`;
delimiter ;;
CREATE FUNCTION `queryChildrenAreaInfo`(`username_set` char(50) charset utf8mb4 collate utf8mb4_0900_ai_ci)
 RETURNS varchar(16383) CHARSET utf8mb3
  SQL SECURITY INVOKER
BEGIN

DECLARE sTemp VARCHAR(16383);
DECLARE sTempChd VARCHAR(16383);

SET sTemp="";
SET sTempChd = CAST(username_set AS CHAR);

WHILE sTempChd IS NOT NULL DO
SET sTemp= CONCAT(sTemp,",",sTempChd);
SELECT GROUP_CONCAT(dept_id) INTO sTempChd FROM sys_dept WHERE FIND_IN_SET(parent_id,sTempChd)>0;
END WHILE;
RETURN sTemp;
END
;;
delimiter ;

SET FOREIGN_KEY_CHECKS = 1;
