/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SM3 {
    private static Log logger = LogFactory.getLog(SM3.class);
    private static char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ivHexStr = "7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e";
    private static final BigInteger IV = new BigInteger("7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e".replaceAll(" ", ""), 16);
    private static final Integer Tj15 = Integer.valueOf("79cc4519", 16);
    private static final Integer Tj63 = Integer.valueOf("7a879d8a", 16);
    private static final byte[] FirstPadding = new byte[]{-128};
    private static final byte[] ZeroPadding = new byte[1];
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private static int T(int j) {
        if (j >= 0 && j <= 15) {
            return Tj15;
        }
        if (j >= 16 && j <= 63) {
            return Tj63;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer FF(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer GG(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer P0(Integer x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static Integer P1(Integer x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    private static byte[] padding(byte[] source) throws IOException {
        if ((long)source.length >= 0x2000000000000000L) {
            throw new RuntimeException("src data invalid.");
        }
        long l = source.length * 8;
        long k = 448L - (l + 1L) % 512L;
        if (k < 0L) {
            k += 512L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("k = " + k);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(source);
        baos.write(FirstPadding);
        long i = k - 7L;
        while (i > 0L) {
            baos.write(ZeroPadding);
            i -= 8L;
        }
        baos.write(SM3.long2bytes(l));
        if (logger.isDebugEnabled()) {
            logger.debug("paded size = " + baos.size());
        }
        return baos.toByteArray();
    }

    private static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
            ++i;
        }
        return bytes;
    }

    public static byte[] hash(byte[] source) throws IOException {
        byte[] m1 = SM3.padding(source);
        int n = m1.length / 64;
        if (logger.isDebugEnabled()) {
            logger.debug("n = " + n);
        }
        byte[] vi = IV.toByteArray();
        byte[] vi1 = null;
        int i = 0;
        while (i < n) {
            byte[] b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM3.CF(vi, b);
            vi = vi1;
            ++i;
        }
        return vi1;
    }

    private static byte[] CF(byte[] vi, byte[] bi) throws IOException {
        int a = SM3.toInteger(vi, 0);
        int b = SM3.toInteger(vi, 1);
        int c = SM3.toInteger(vi, 2);
        int d = SM3.toInteger(vi, 3);
        int e = SM3.toInteger(vi, 4);
        int f = SM3.toInteger(vi, 5);
        int g = SM3.toInteger(vi, 6);
        int h = SM3.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        int i = 0;
        while (i < 16) {
            w[i] = SM3.toInteger(bi, i);
            ++i;
        }
        int j = 16;
        while (j < 68) {
            w[j] = SM3.P1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
            ++j;
        }
        j = 0;
        while (j < 64) {
            w1[j] = w[j] ^ w[j + 4];
            ++j;
        }
        int j2 = 0;
        while (j2 < 64) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM3.T(j2), j2), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM3.FF(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM3.GG(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM3.P0(tt2);
            ++j2;
        }
        byte[] v = SM3.toByteArray(a, b, c, d, e, f, g, h);
        int i2 = 0;
        while (i2 < v.length) {
            v[i2] = (byte)(v[i2] ^ vi[i2]);
            ++i2;
        }
        return v;
    }

    private static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder("");
        int i = 0;
        while (i < 4) {
            valueStr.append(chars[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(chars[(byte)(source[index * 4 + i] & 0xF)]);
            ++i;
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    private static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
        baos.write(SM3.toByteArray(a));
        baos.write(SM3.toByteArray(b));
        baos.write(SM3.toByteArray(c));
        baos.write(SM3.toByteArray(d));
        baos.write(SM3.toByteArray(e));
        baos.write(SM3.toByteArray(f));
        baos.write(SM3.toByteArray(g));
        baos.write(SM3.toByteArray(h));
        return baos.toByteArray();
    }

    private static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    private static void printIntArray(int[] intArray, int lineSize) {
        int i = 0;
        while (i < intArray.length) {
            byte[] byteArray = SM3.toByteArray(intArray[i]);
            int j = 0;
            while (j < byteArray.length) {
                System.out.print(chars[(byteArray[j] & 0xFF) >> 4]);
                System.out.print(chars[byteArray[j] & 0xF]);
                ++j;
            }
            System.out.print(" ");
            if (i % lineSize == lineSize - 1) {
                System.out.println(" ");
            }
            ++i;
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            resultSb.append(SM3.byteToHexString(b[i]));
            ++i;
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return String.valueOf(hexDigits[d1]) + hexDigits[d2];
    }

    public static String SM3Encode(String source, String charsetname) throws IOException {
        String resultString = null;
        resultString = charsetname == null || "".equals(charsetname) ? SM3.byteArrayToHexString(SM3.hash(source.getBytes())) : SM3.byteArrayToHexString(SM3.hash(source.getBytes(charsetname)));
        return resultString;
    }

    public static Map<String, Object> makeToken(String appId, String appSecrect) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String token = "";
        String timestamp = "2017-09-14 13:54:45 687";
        String transId = "20170914135445687536273";
        timestamp = SM3.getFormatedDateString(8.0f);
        transId = timestamp.replace("-", "").replace(" ", "").replace(":", "");
        transId = String.valueOf(transId) + new Random().nextInt(999999);
        StringBuilder sb = new StringBuilder();
        sb.append("app_id");
        sb.append(appId);
        sb.append("timestamp");
        sb.append(timestamp);
        sb.append("trans_id");
        sb.append(transId);
        sb.append(appSecrect);
        token = SM3.SM3Encode(sb.toString(), "UTF-8");
        result.put("token", token);
        result.put("timestamp", timestamp);
        result.put("trans_id", transId);
        return result;
    }

    public static String getFormatedDateString(float timeZoneOffset) {
        int newTime;
        String[] ids;
        if (timeZoneOffset > 13.0f || timeZoneOffset < -12.0f) {
            timeZoneOffset = 0.0f;
        }
        TimeZone timeZone = (ids = TimeZone.getAvailableIDs(newTime = (int)(timeZoneOffset * 60.0f * 60.0f * 1000.0f))).length == 0 ? TimeZone.getDefault() : new SimpleTimeZone(newTime, ids[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        sdf.setTimeZone(timeZone);
        return sdf.format(new Date());
    }

    public static void main(String[] args) throws IOException {
        byte[] source = new byte[]{97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100, 97, 98, 99, 100};
        byte[] sm3HashValue = SM3.hash(source);
        System.out.println(SM3.SM3Encode(sm3HashValue.toString(), "utf-8"));
        String token = SM3.SM3Encode("app_id5E6339211Ftimestamp2017-09-14 13:54:45 687trans_id20170914135445687536273PG65cP4C4977I0z3durISe1c24547409", "utf-8");
        System.out.println(token);
        System.out.println("d1e36c3e8e1abdd704c74591ee3da7a124f072e11ee041968f3940cdc1499438".equals(token));
        System.out.println("20170914135445687536273".length());
        System.out.println("20170914155804273365621".length());
    }
}

