/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import com.cu.api.internal.utils.Base64;
import com.cu.api.internal.utils.ByteUtils;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import sun.misc.BASE64Decoder;

public class RsaUtils {
    private static final String ALGORITHM = "RSA";
    private static final String RSA_ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    private static ThreadLocal<Cipher> rsaCipher = new ThreadLocal(){

        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaUtils.RSA_ECB_PKCS1_PADDING);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
        }
    };

    public static String encrypt(String paramValue, String prikey) throws Exception {
        byte[] plainText = paramValue.getBytes();
        rsaCipher.get().init(1, RsaUtils.getPrivateKey(prikey));
        byte[] enBytes = rsaCipher.get().doFinal(plainText);
        return Base64.encodeToString(enBytes, false);
    }

    public static String encrypts(String paramValue, String pubkey) throws Exception {
        byte[] plainText = paramValue.getBytes();
        rsaCipher.get().init(1, RsaUtils.getPublicKey(pubkey));
        byte[] enBytes = rsaCipher.get().doFinal(plainText);
        return Base64.encodeToString(enBytes, false);
    }

    public static String decrypt(String paramValue, String pubkey) throws Exception {
        byte[] enBytes = Base64.decode(paramValue);
        rsaCipher.get().init(2, RsaUtils.getPublicKey(pubkey));
        byte[] deBytes = rsaCipher.get().doFinal(enBytes);
        return ByteUtils.toString(deBytes);
    }

    public static String decrypts(String paramValue, String prikey) throws Exception {
        byte[] enBytes = Base64.decode(paramValue);
        rsaCipher.get().init(2, RsaUtils.getPrivateKey(prikey));
        byte[] deBytes = rsaCipher.get().doFinal(enBytes);
        return ByteUtils.toString(deBytes);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static void main(String[] args) throws Exception {
        String pri = "MIIBVgIBADANBgkqhkiG9w0BAQEFAASCAUAwggE8AgEAAkEAjSww8T8YtScn8zgjufcpPOFP5A2v8pnbKfVTGv225P2C1AIgtjYVbU+2RWr5IjfSZxm7lTkx6nDirj1Pg59uEwIDAQABAkEAi/1yWwhSm/DEMO9Oni51+iUDcAYSn+Pp7OWVD4LgRpmUEBt+2Pldo0bJzIsDF+86TUymXycFV1GDA8ZGUBo2YQIhAMe+AnEKxjDX+29Q0H1O0Gzujaj/4l3ebj6NkH6Kk+h/AiEAtO8k9H5LCxcdrP+1cec3fK2y5gYm7QMcvaoNmhEikG0CIQDB/0YXzMMZhWxrfS5Bxl6grkFgNscBLJwenRgOD0IAuQIga7Ig3ArEXkCPIGdAOCE5bNPzNWmaB9+fXuF2oSrr2O0CIQCnIZTaJ/4EUTv5DXdRyeuWZkvLgtsZOl8dc9foQhvPuw==";
        String pub = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAI0sMPE/GLUnJ/M4I7n3KTzhT+QNr/KZ2yn1Uxr9tuT9gtQCILY2FW1PtkVq+SI30mcZu5U5Mepw4q49T4OfbhMCAwEAAQ==";
        String mingwen = "dEJNeC7ONz7DAY5mkIwbxg==";
        String dd = RsaUtils.encrypt(mingwen, pri);
    }
}

