/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import java.io.UnsupportedEncodingException;

public class ByteUtils {
    public static final int SIZEOF_LONG = 8;

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        int i = 7;
        while (i > 0) {
            b[i] = (byte)val;
            val >>>= 8;
            --i;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        if (8 > bytes.length) {
            return 0L;
        }
        long l = 0L;
        int i = 0;
        while (i < 8) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return l;
    }

    public static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String toString(byte[] b) {
        return ByteUtils.toString(b, 0);
    }

    public static String toString(byte[] b, int off) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, off, b.length - off, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

