/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import com.cu.api.ApiException;
import com.cu.api.IoTGatewayResponse;
import com.cu.api.internal.parser.json.ObjectJsonParser;
import com.cu.api.internal.utils.XmlWriter;
import com.cu.api.internal.utils.json.JSONReader;
import com.cu.api.internal.utils.json.JSONValidatingReader;
import com.cu.api.internal.utils.json.JSONWriter;
import java.net.InetAddress;

public abstract class ApaasUtils {
    private static String intranetIp;

    private ApaasUtils() {
    }

    public static Object jsonToObject(String json) {
        JSONValidatingReader jr = new JSONValidatingReader();
        return ((JSONReader)jr).read(json);
    }

    public static String objectToJson(Object object) {
        JSONWriter writer = new JSONWriter(false, true);
        return writer.write(object);
    }

    public static String objectToXml(Object object) {
        XmlWriter writer = new XmlWriter();
        return writer.write(object);
    }

    public static <T extends IoTGatewayResponse> T parseResponse(String json, Class<T> clazz) throws ApiException {
        ObjectJsonParser<T> parser = new ObjectJsonParser<T>(clazz);
        Object rsp = parser.parse(json);
        ((IoTGatewayResponse)rsp).setBody(json);
        return (T)rsp;
    }

    public static String getIntranetIp() {
        if (intranetIp == null) {
            try {
                intranetIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                intranetIp = "127.0.0.1";
            }
        }
        return intranetIp;
    }
}

