/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import com.cu.api.internal.utils.Base64;
import com.cu.api.internal.utils.ByteUtils;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class AesUtils {
    private static final String AES_ALGRITHOM = "AES";
    private static ThreadLocal<Cipher> aesCipher = new ThreadLocal(){

        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(AesUtils.AES_ALGRITHOM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
        }
    };

    public static String decrypt(String paramValue, String key) throws Exception {
        return AesUtils.decrypt(paramValue, Base64.decode(key));
    }

    public static String decrypt(String paramValue, byte[] key) throws Exception {
        byte[] value = Base64.decode(ByteUtils.toBytes(paramValue));
        byte[] decrypt = AesUtils.decrypt(value, key);
        return ByteUtils.toString(decrypt);
    }

    public static String encrypt(String message, String key) throws Exception {
        return AesUtils.encrypt(message, Base64.decode(key));
    }

    public static String encrypt(String message, byte[] key) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, AES_ALGRITHOM);
        aesCipher.get().init(1, skeySpec);
        byte[] encrypted = aesCipher.get().doFinal(ByteUtils.toBytes(message));
        return Base64.encodeToString(encrypted, false);
    }

    public static byte[] decrypt(byte[] value, byte[] key) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, AES_ALGRITHOM);
        aesCipher.get().init(2, skeySpec);
        byte[] decrypted = aesCipher.get().doFinal(value);
        return decrypted;
    }
}

