/*
 Navicat Premium Data Transfer

 Source Server Type    : MySQL
 Source Server Version : 80024
 Source Schema         : iotdb
 Target Server Type    : MySQL
 Target Server Version : 80024
 File Encoding         : 65001

 Date: 12/01/2022 11:20:15
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table
-- ----------------------------

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `sort` int(0) NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `blob_data` blob NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_blob_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `calendar` blob NOT NULL,
  PRIMARY KEY (`sched_name`, `calendar_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_calendars
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `cron_expression` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `time_zone_id` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', '0 0/5 * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', '0 0/1 * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', '0 0 0 * * ? *', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', '0 0 0 * * ? *', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', '0 0/20 * * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', '0 0 0 * * ? *', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', '0 0 0/8 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', '0 0 0,2,4,6 1 * ? *', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', '0/20 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', '0 0 0/1 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', '0 0 0/1 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', '0 0 0/3 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', '0 0 0/1 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', '0 0 0/1 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', '0 0 0/2 * * ? *', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', '0 0 0/1 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', '0 0 0 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', '0 0 11,22 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', '0 0 6,18 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', '0 0/15 * * * ?', 'Asia/Shanghai');

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `entry_id` varchar(95) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `fired_time` bigint(0) NOT NULL,
  `sched_time` bigint(0) NOT NULL,
  `priority` int(0) NOT NULL,
  `state` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `entry_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_fired_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `job_class_name` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_durable` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_update_data` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_data` blob NULL,
  PRIMARY KEY (`sched_name`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013174000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 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
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 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
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B5D27321878707400007070707400013174000D3020302F31202A202A202A203F74001E63617264466C6F775461736B2E537461727443617264466C6F7728363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000C740018E6898BE58AA8E5BC80E590AFE794A8E9878FE79B91E590AC74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B5DD8174078707400007070707400013174000D3020302030202A202A203F202A7400157379734C6F67735461736B2E6261636B75707328297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000D740018E588A0E999A4E5AFB9E5A496E68EA5E58FA3E697A5E5BF9774000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017B9AA31FF878707400007070707400013174000D3020302030202A202A203F202A740013696E69744D512E696E69744D51436F6E66696774000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000E74000B4D51E5889DE5A78BE58C9674000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BE2EBE6A078707400007070707400013174000F3020302F3230202A202A202A203F2074003163617264446973636F6E6E65637465645461736B2E706F6C6C696E6743617264446973636F6E6E65637465642831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000F74000FE69CAAE8AEA2E8B4ADE5819CE69CBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BEE1815A878707400007070707400013174000D3020302030202A202A203F202A7400176261636B7570546573742E67656E7461626C65283330297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001074000FE5A487E4BBBDE68980E69C89E8A1A874000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017CC634131078707400007070707400013174000E30203020302F38202A202A203F20740037636172644163746976617465446174655461736B2E706F6C6C696E674163746976617465446174652827536572696F7573272C20363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001274001CE8BDAEE8AFA22DE6BF80E6B4BBE697B6E997B4E69C89E794A8E9878F74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017CFD4332A078707400007070707400013174001330203020302C322C342C362031202A203F202A7400136D6F6E74682E67656E7461626C652831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001374001BE69C88E5889DE6B581E9878FE58DA1E8BF9BE8A18CE5A48DE69CBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013174000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D238B375078707400007070707400013174000E302F3230202A202A202A202A203F740076726F6C6C6261636B436172646167656E742E726F6C6C6261636B4572726F722827313633363936333636313639375F6373765F39626435656531346136383134653862613265653763373037313163653463645F43617264446973747269627574654261636B75702E637376272C3233362C323436297400064241434B55507372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000015740013E59B9EE6BB9A20E58892E58DA1E5A487E4BBBD74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D457A7CB878707400007070707400013174000D30203020302F31202A202A203F74002863617264466C6F775461736B2E706F6C6C696E6743617264466C6F774F6E652836302C2734392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001674001BE5889BE5BBBAE58D95E9809AE98193E794A8E9878FE79B91E590AC74000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D4589558078707400007070707400013174000D30203020302F31202A202A203F74002C63617264466C6F775461736B2E43617264466C6F774372656174654C697374656E65722836302C2734392729740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000017740022E68C87E5AE9AE58D95E4B8AAE9809AE98193E5889BE5BBBA20E6B688E8B4B9E8808574000131740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D4C28864078707400007070707400013174000D30203020302F33202A202A203F7400217265626F6F745461736B2E5265626F6F74466C6F77506F6C6C696E672831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000018740024E8BDAEE8AFA2E9878DE590AFE697A0E8AEB0E5BD95E6B688E8B4B9E88085E5889BE5BBBA74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5FEF11F878707400007070707400013174000D30203020302F31202A202A203F74001E7265626F6F745461736B2E5265626F6F744361726453746F702831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000019740012E5819CE69CBAE99888E580BCE9878DE590AF74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5FEFA28078707400007070707400013174000D30203020302F31202A202A203F7400267265626F6F745461736B2E5265626F6F7443617264446973636F6E6E65637465642831383029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001A740015E69CAAE8AEA2E8B4ADE5819CE69CBAE9878DE590AF74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017D5A0D8BE878707400007070707400013174000F30203020302F32202A202A203F202A7400166D7163617264666C6F772E67657474696D6528333029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000001B740018E5908CE6ADA5E4B8BBE8A1A8E588B0E69C9FE697A5E69C9F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000179D9BA361078707400007070707400013074000E302F3230202A202A202A202A203F74003872795461736B2E72794D756C7469706C65506172616D7328277279272C20747275652C20323030304C2C203331362E3530442C203130302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000003740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E5A49AE58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017A707EF3B078707400007070707400013174000E30203020302F31202A202A203F207400506F726465724164645061636B61676550726F64756374696F6E5461736B2E61637469766174696F6E4164645061636B61676550726F64756374696F6E416E64416374697661746544617465283138302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000004740024E6A0B9E68DAEE8AEA2E58D95E8BDAEE5BA8FE69BB4E696B0E6BF80E6B4BBE697B6E997B474000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017A7FE1F28078707400007070707400013174000C3020302030202A202A203F20740037636172644163746976617465446174655461736B2E706F6C6C696E674163746976617465446174652827536C69676874272C2031323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000005740013E8BDAEE8AFA22DE6BF80E6B4BBE697B6E997B474000132740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AA96B7E0078707400007070707400013074000E3020302F3130202A202A202A203F74002270617373616765776179506F6C6C696E675461736B2E53796E4368616E6E656C2829740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000006740019E8BDAEE8AFA22DE5908CE6ADA5E9809AE98193E695B0E68DAE74000132740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AC2153E507870740000707070740001317400103020302031312C3232202A202A203F20740025636172645374617475735461736B2E706F6C6C696E67436172645374617475732831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000007740010E8BDAEE8AFA22DE58DA1E78AB6E6808174000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AC78DE4B878707400007070707400013174000F30203020362C3138202A202A203F2074002163617264466C6F775461736B2E706F6C6C696E6743617264466C6F772831323029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000874000DE8BDAEE8AFA22DE794A8E9878F74000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', NULL, 'com.yunze.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E79756E7A652E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E79756E7A652E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017AD2D5B9E078707400007070707400013174000E3020302F3135202A202A202A203F7400206361726453746F705461736B2E706F6C6C696E674361726453746F7028363029740007504F4C4C494E477372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000974000CE8BEBEE9878FE5819CE69CBA74000131740001307800);

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `lock_name` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `lock_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_paused_trigger_grps
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `last_checkin_time` bigint(0) NOT NULL,
  `checkin_interval` bigint(0) NOT NULL,
  PRIMARY KEY (`sched_name`, `instance_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('RuoyiScheduler', 'hecs-x-xlarge-2-linux-202006152200231641953379431', 1641957613462, 15000);

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `repeat_count` bigint(0) NOT NULL,
  `repeat_interval` bigint(0) NOT NULL,
  `times_triggered` bigint(0) NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_simple_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `str_prop_1` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `str_prop_2` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `str_prop_3` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `int_prop_1` int(0) NULL DEFAULT NULL,
  `int_prop_2` int(0) NULL DEFAULT NULL,
  `long_prop_1` bigint(0) NULL DEFAULT NULL,
  `long_prop_2` bigint(0) NULL DEFAULT NULL,
  `dec_prop_1` decimal(13, 4) NULL DEFAULT NULL,
  `dec_prop_2` decimal(13, 4) NULL DEFAULT NULL,
  `bool_prop_1` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `bool_prop_2` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_simprop_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `next_fire_time` bigint(0) NULL DEFAULT NULL,
  `prev_fire_time` bigint(0) NULL DEFAULT NULL,
  `priority` int(0) NULL DEFAULT NULL,
  `trigger_state` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_type` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `start_time` bigint(0) NOT NULL,
  `end_time` bigint(0) NULL DEFAULT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `misfire_instr` smallint(0) NULL DEFAULT NULL,
  `job_data` blob NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  INDEX `sched_name`(`sched_name`, `job_name`, `job_group`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 1641953380000, -1, 5, 'PAUSED', 'CRON', 1641953379000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME10', 'POLLING', 'TASK_CLASS_NAME10', 'POLLING', NULL, 1641957900000, 1641957600000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME11', 'POLLING', 'TASK_CLASS_NAME11', 'POLLING', NULL, 1641958200000, 1641957600000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME12', 'POLLING', 'TASK_CLASS_NAME12', 'POLLING', NULL, 1641953400000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME13', 'BACKUP', 'TASK_CLASS_NAME13', 'BACKUP', NULL, 1642003200000, -1, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME14', 'DEFAULT', 'TASK_CLASS_NAME14', 'DEFAULT', NULL, 1642003200000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME15', 'POLLING', 'TASK_CLASS_NAME15', 'POLLING', NULL, 1641958800000, 1641957600000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME16', 'BACKUP', 'TASK_CLASS_NAME16', 'BACKUP', NULL, 1642003200000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME18', 'POLLING', 'TASK_CLASS_NAME18', 'POLLING', NULL, 1641974400000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME19', 'POLLING', 'TASK_CLASS_NAME19', 'POLLING', NULL, 1643644800000, -1, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 1641953385000, -1, 5, 'PAUSED', 'CRON', 1641953379000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME21', 'BACKUP', 'TASK_CLASS_NAME21', 'BACKUP', NULL, 1641953380000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME22', 'POLLING', 'TASK_CLASS_NAME22', 'POLLING', NULL, 1641956400000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME23', 'POLLING', 'TASK_CLASS_NAME23', 'POLLING', NULL, 1641956400000, -1, 5, 'PAUSED', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME24', 'POLLING', 'TASK_CLASS_NAME24', 'POLLING', NULL, 1641960000000, -1, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME25', 'POLLING', 'TASK_CLASS_NAME25', 'POLLING', NULL, 1641960000000, 1641956400000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME26', 'POLLING', 'TASK_CLASS_NAME26', 'POLLING', NULL, 1641960000000, 1641956400000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME27', 'POLLING', 'TASK_CLASS_NAME27', 'POLLING', NULL, 1641960000000, -1, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1641953380000, -1, 5, 'PAUSED', 'CRON', 1641953379000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 1641960000000, 1641956400000, 5, 'WAITING', 'CRON', 1641953379000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'POLLING', 'TASK_CLASS_NAME5', 'POLLING', NULL, 1642003200000, -1, 5, 'WAITING', 'CRON', 1641953379000, 0, NULL, 1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME6', 'POLLING', 'TASK_CLASS_NAME6', 'POLLING', NULL, 1641958200000, 1641957600000, 5, 'WAITING', 'CRON', 1641953379000, 0, NULL, 1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME7', 'POLLING', 'TASK_CLASS_NAME7', 'POLLING', NULL, 1641996000000, 1641956400000, 5, 'WAITING', 'CRON', 1641953379000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME8', 'POLLING', 'TASK_CLASS_NAME8', 'POLLING', NULL, 1641981600000, -1, 5, 'WAITING', 'CRON', 1641953379000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME9', 'POLLING', 'TASK_CLASS_NAME9', 'POLLING', NULL, 1641958200000, 1641957300000, 5, 'WAITING', 'CRON', 1641953380000, 0, NULL, -1, '');

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config`  (
  `config_id` int(0) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '参数配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'admin', '2021-06-05 09:12:10', '', NULL, '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2021-06-05 09:12:10', '', NULL, '初始化密码 123456');
INSERT INTO `sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2021-06-05 09:12:10', '', NULL, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` VALUES (4, '连接管理解绑默认联系人', 'yunze.card.contactName', 'CeShi', 'Y', 'admin', '2021-07-31 09:17:58', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (5, '连接管理解绑联系人电话', 'yunze.card.contactPhone', '188888888', 'Y', 'admin', '2021-07-31 09:19:30', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (6, '购卡运费', 'yunze.web.byCardFare', '0.01', 'Y', 'admin', '2021-09-22 17:42:07', 'admin', '2021-09-24 13:45:46', '微信web端购卡运费');
INSERT INTO `sys_config` VALUES (7, '系统邮件抄送邮箱', 'yunze.ccConfig.Email', 'youxiang@5iot.cn', 'Y', 'admin', '2021-09-26 12:01:02', '', NULL, NULL);
INSERT INTO `sys_config` VALUES (8, '系统邮件抄送邮箱密码', 'yunze.ccConfig.EmailPwd', 'fffff', 'Y', 'admin', '2021-09-26 12:01:58', '', NULL, '密码或者授权码');
INSERT INTO `sys_config` VALUES (9, '复机重试最大次数', 'MaixCount', '50', 'N', 'admin', '2021-11-15 14:58:40', 'admin', '2021-11-23 16:57:01', NULL);
INSERT INTO `sys_config` VALUES (10, '重启消费者轮序队列数量', 'polling.rebootStandard', '1000', 'N', 'admin', '2021-11-23 16:56:42', 'admin', '2021-11-27 13:40:22', NULL);
INSERT INTO `sys_config` VALUES (11, '重启停机阈值待销费标准', 'polling.rebootCardStop', '1', 'N', 'admin', '2021-11-27 13:40:08', 'admin', '2021-11-27 14:09:29', NULL);
INSERT INTO `sys_config` VALUES (12, '重启未订购停机待销费标准', 'polling.rebootCardDisconnected', '1', 'Y', 'admin', '2021-11-27 13:41:57', 'admin', '2021-11-27 14:09:34', NULL);
INSERT INTO `sys_config` VALUES (13, 'C端充值失败再次充值执行次数', 'yunze.card.IsStop', '10', 'Y', 'admin', '2021-12-27 10:26:40', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept`  (
  `dept_id` bigint(0) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(0) NULL DEFAULT 0,
  `ancestors` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `dept_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `order_num` int(0) NULL DEFAULT 0,
  `leader` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `phone` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `create_time` datetime(0) NULL DEFAULT NULL,
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `update_time` datetime(0) NULL DEFAULT NULL,
  `dname` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 252 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES (100, 0, '0', '总企业', 0, NULL, NULL, NULL, '0', '0', 'admin', '2021-06-05 09:12:09', 'admin', '2021-06-07 09:04:38', '总企业');

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data`  (
  `dict_code` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(0) NULL DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 559 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
INSERT INTO `sys_dict_data` VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别男');
INSERT INTO `sys_dict_data` VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别女');
INSERT INTO `sys_dict_data` VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '性别未知');
INSERT INTO `sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '显示菜单');
INSERT INTO `sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '隐藏菜单');
INSERT INTO `sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '默认分组');
INSERT INTO `sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统分组');
INSERT INTO `sys_dict_data` VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统默认是');
INSERT INTO `sys_dict_data` VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统默认否');
INSERT INTO `sys_dict_data` VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知');
INSERT INTO `sys_dict_data` VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '公告');
INSERT INTO `sys_dict_data` VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '关闭状态');
INSERT INTO `sys_dict_data` VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '新增操作');
INSERT INTO `sys_dict_data` VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '修改操作');
INSERT INTO `sys_dict_data` VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '删除操作');
INSERT INTO `sys_dict_data` VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '授权操作');
INSERT INTO `sys_dict_data` VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '导出操作');
INSERT INTO `sys_dict_data` VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '导入操作');
INSERT INTO `sys_dict_data` VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '强退操作');
INSERT INTO `sys_dict_data` VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '生成操作');
INSERT INTO `sys_dict_data` VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '清空操作');
INSERT INTO `sys_dict_data` VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (100, 0, '中国移动', '1', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:49:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (101, 1, '中国联通', '2', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (102, 2, '中国电信', '3', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:18', 'admin', '2021-06-05 10:51:06', NULL);
INSERT INTO `sys_dict_data` VALUES (103, 3, '其他', '4', 'card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-05 10:50:42', 'admin', '2021-06-05 10:51:10', NULL);
INSERT INTO `sys_dict_data` VALUES (104, 0, '卡号', '1', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 09:21:09', 'admin', '2021-06-07 09:22:33', '卡号查询 vid/msisdn/iccid/imsi');
INSERT INTO `sys_dict_data` VALUES (105, 0, '备注', '2', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 09:22:29', '', NULL, '卡板备注');
INSERT INTO `sys_dict_data` VALUES (106, 0, '开卡日期', '1', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (107, 0, '激活日期', '2', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (108, 0, '入库日期', '3', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:23:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (109, 0, '正常', '0', 'yunze_card_deltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:26:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (110, 0, '已删除', '1', 'yunze_card_deltype', NULL, NULL, 'N', '0', 'admin', '2021-06-07 12:26:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (111, 1, '移动', '1', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:06', 'admin', '2021-06-07 16:15:24', NULL);
INSERT INTO `sys_dict_data` VALUES (112, 2, '联通', '2', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:15', 'admin', '2021-06-07 16:15:27', NULL);
INSERT INTO `sys_dict_data` VALUES (113, 3, '电信', '3', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:15:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (114, 4, '全网通', '4', 'yunze_card_operators_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:16:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (115, 3, '单项停机', '3', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:20', 'admin', '2021-06-09 10:16:03', NULL);
INSERT INTO `sys_dict_data` VALUES (116, 1, '正常', '1', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (117, 2, '停机', '2', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:29:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (118, 4, '预销号', '4', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (119, 5, '过户', '5', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (120, 6, '休眠', '6', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (121, 7, '待激活', '7', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:30:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (122, 8, '未知', '8', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (123, 9, '测试期正常', '9', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (124, 10, '测试期停机', '10', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (125, 11, '停机保号', '11', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (126, 12, '机卡分离停机', '12', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:31:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (127, 13, '空套餐', '13', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-06-07 16:32:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (128, 1, '当月生效', '1', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:55:50', 'admin', '2021-06-22 11:14:16', NULL);
INSERT INTO `sys_dict_data` VALUES (129, 2, '次月生效', '2', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:56:18', 'admin', '2021-06-22 11:14:20', NULL);
INSERT INTO `sys_dict_data` VALUES (130, 3, '周期延顺', '3', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 08:58:17', 'admin', '2021-06-22 11:14:23', NULL);
INSERT INTO `sys_dict_data` VALUES (131, 0, '已失效', '0', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:01:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (132, 0, '生效中', '1', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:01:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (133, 1, '微信支付', 'wx', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:02:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (134, 2, '余额支付', 'be', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:03:39', 'admin', '2021-06-09 09:03:45', NULL);
INSERT INTO `sys_dict_data` VALUES (135, 4, '人工操作', 'al', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:04:28', 'admin', '2021-08-06 10:55:23', NULL);
INSERT INTO `sys_dict_data` VALUES (136, 0, '否', '0', 'yunze_customize_whether', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:07:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (137, 1, '是', '1', 'yunze_customize_whether', NULL, NULL, 'N', '0', 'admin', '2021-06-09 09:07:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (138, 1, '普通贴片MS0 5mm*6mm', '1', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:52:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (139, 2, '普通SIM卡MS0 5mm*6mm', '2', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:52:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (140, 1, 'NB', '1', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:53:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (141, 2, '4G SIM', '2', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:53:52', 'admin', '2021-06-10 08:54:09', NULL);
INSERT INTO `sys_dict_data` VALUES (142, 3, '5G SIM', '3', 'yunze_card_network_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 08:54:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (143, 1, '离线', '00', 'yunze_card_online_status', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:01:14', 'admin', '2021-06-10 14:01:22', 'EC');
INSERT INTO `sys_dict_data` VALUES (144, 2, '在线', '01', 'yunze_card_online_status', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:01:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (145, 1, '3G', '1', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:02:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (146, 2, '2G', '2', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:02:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (147, 6, '4G', '6', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:03:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (148, 8, 'NB', '8', 'yunze_card_access_type', NULL, NULL, 'N', '0', 'admin', '2021-06-10 14:03:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (149, 1, '虚拟编号', '1', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (150, 2, 'MSISDN', '2', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:45', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (151, 3, 'ICCID', '3', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:17:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (152, 4, 'IMSI', '4', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-06-11 15:18:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (153, 1, '通道名称', '2', 'yunze_channel_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-19 12:22:37', 'admin', '2021-06-21 08:40:22', NULL);
INSERT INTO `sys_dict_data` VALUES (154, 1, '升序', '1', 'ORDER_BY_rule', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:32:30', '', NULL, 'ASC');
INSERT INTO `sys_dict_data` VALUES (155, 2, '倒叙', '2', 'ORDER_BY_rule', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:32:41', '', NULL, 'DESC');
INSERT INTO `sys_dict_data` VALUES (156, 1, '创建时间', '1', 'channel_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:34:42', '', NULL, 'createTime');
INSERT INTO `sys_dict_data` VALUES (157, 2, '通道编号', '2', 'channel_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:34:58', '', NULL, 'cd_code');
INSERT INTO `sys_dict_data` VALUES (158, 1, '启用', '1', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:41:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (159, 2, '停用', '2', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:42:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (160, 3, '已删除', '3', 'channel_status', NULL, NULL, 'N', '0', 'admin', '2021-06-19 13:42:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (161, 1, '中国移动', 'YiDong_EC', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:46:59', '', NULL, '移动EC新平台');
INSERT INTO `sys_dict_data` VALUES (162, 2, '中国电信', 'DianXin_CMP', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:47:40', 'admin', '2021-06-19 14:48:41', '电信CMP');
INSERT INTO `sys_dict_data` VALUES (164, 3, '全球电信', 'DianXin_DCP', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-06-19 14:49:19', '', NULL, 'DianXin_DCP');
INSERT INTO `sys_dict_data` VALUES (165, 0, '通道别名', '3', 'yunze_channel_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 08:40:15', 'admin', '2021-06-21 08:40:27', NULL);
INSERT INTO `sys_dict_data` VALUES (166, 1, '任务名', '1', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:30:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (167, 2, '创建人', '2', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:30:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (168, 3, '下载地址', '3', 'executionTask_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:31:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (169, 1, '创建时间', '1', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:40:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (170, 2, '任务名', '2', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:40:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (171, 3, '修改时间', '3', 'executionTask_ORDER_BY_type', NULL, NULL, 'N', '0', 'admin', '2021-06-21 11:41:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (172, 1, '连接管理导入', '_CardImport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:17:45', 'admin', '2021-07-28 12:19:58', NULL);
INSERT INTO `sys_dict_data` VALUES (173, 2, '连接管理导出', '_CardOut', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:17:54', 'admin', '2021-07-28 12:20:05', NULL);
INSERT INTO `sys_dict_data` VALUES (174, 3, '上游通道导出', '_ChannelOut', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-06-21 14:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (175, 1, '月', '1', 'yunze_packet_valid_name', NULL, NULL, 'N', '0', 'admin', '2021-06-22 16:20:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (176, 2, '年', '2', 'yunze_packet_valid_name', NULL, NULL, 'N', '0', 'admin', '2021-06-22 16:20:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (177, 1, '资费组名称', '1', 'yunze_tariffGroup_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:15:27', 'admin', '2021-06-22 17:35:27', NULL);
INSERT INTO `sys_dict_data` VALUES (178, 2, '平台资费组名称', '2', 'yunze_tariffGroup_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:15:41', 'admin', '2021-06-22 17:40:30', NULL);
INSERT INTO `sys_dict_data` VALUES (179, 1, '资费计划名称', '1', 'yunze_tariffPlan_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (180, 2, '平台计划名称', '2', 'yunze_tariffPlan_selType', NULL, NULL, 'N', '0', 'admin', '2021-06-22 17:18:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (181, 1, '金额充值', '1', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:50:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (182, 2, '用量充值', '2', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:51:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (183, 0, '未支付', '0', 'yunze_order_status', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:52:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (184, 1, '支付成功', '1', 'yunze_order_status', NULL, NULL, 'N', '0', 'admin', '2021-07-03 10:52:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (185, 4, '激活生效', '4', 'yunze_card_takeEffect_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 11:35:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (186, 2, '未生效', '2', 'yunze_card_valid_type', NULL, NULL, 'N', '0', 'admin', '2021-07-03 11:36:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (188, 14, '运营商管理状态', '14', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-06 15:44:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (189, 3, '轮询任务', 'POLLING', 'sys_job_group', NULL, NULL, 'N', '0', 'admin', '2021-07-07 15:23:51', 'admin', '2021-11-12 09:32:39', NULL);
INSERT INTO `sys_dict_data` VALUES (190, 1, '激活状态', '1', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:20:36', 'admin', '2021-07-08 14:21:20', 'polling.cardActivateDate.exchange\npolling.cardActivateDate.queue');
INSERT INTO `sys_dict_data` VALUES (191, 2, '卡装态', '2', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:25:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (192, 3, '用量轮序', '3', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-08 14:26:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (193, 3, '工业贴片MS1 5mm*6mm', '3', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-07-09 09:12:57', 'admin', '2021-08-05 08:26:02', 'NB贴片');
INSERT INTO `sys_dict_data` VALUES (194, 15, '测试去激活', '15', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 09:06:00', 'admin', '2021-07-16 09:06:16', '电信CMP');
INSERT INTO `sys_dict_data` VALUES (195, 16, '拆机', '16', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 09:08:06', '', NULL, '电信CMP');
INSERT INTO `sys_dict_data` VALUES (196, 17, '可测试', '17', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-16 14:16:08', 'admin', '2021-07-16 14:16:14', NULL);
INSERT INTO `sys_dict_data` VALUES (199, 18, '销号', '18', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-21 15:41:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (200, 19, '库存', '19', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-21 15:43:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (202, 4, '达量停机', '4', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-07-23 17:35:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (203, 1, '连接管理导出', '1', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:36:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (204, 2, '连接管理划卡', '2', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:36:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (205, 3, '连接管理导入', '3', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:44:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (206, 4, '上游通道导出', '4', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-07-28 08:45:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (207, 4, '连接管理划卡', '_CardDistribute', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-07-28 12:20:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (208, 5, '连接管理划卡备份', '_CardDistributeBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-07-28 13:04:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (210, 20, '违章停机', '20', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-31 14:37:07', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (211, 21, '断网', '21', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-07-31 15:16:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (212, 22, '开始', '22', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:17:24', '', NULL, '联通CMP');
INSERT INTO `sys_dict_data` VALUES (213, 23, '已失效', '23', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:25', '', NULL, '联通CMP');
INSERT INTO `sys_dict_data` VALUES (214, 24, '已清除', '24', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:45', 'admin', '2021-08-02 09:22:09', '联通CMP');
INSERT INTO `sys_dict_data` VALUES (215, 25, '已更换', '25', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-08-02 09:21:53', 'admin', '2021-08-02 09:22:06', '联通CMP');
INSERT INTO `sys_dict_data` VALUES (216, 4, '工业插拔', '4', 'yunze_card_card_type', NULL, NULL, 'N', '0', 'admin', '2021-08-05 08:25:50', 'admin', '2021-08-05 08:26:35', 'NB插拔');
INSERT INTO `sys_dict_data` VALUES (218, 2, '订单号', '2', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:48:36', 'admin', '2021-08-09 09:46:32', NULL);
INSERT INTO `sys_dict_data` VALUES (219, 3, '交易名称', '3', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:48:51', 'admin', '2021-08-09 09:46:47', NULL);
INSERT INTO `sys_dict_data` VALUES (220, 4, '微信订单号', '4', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:49:08', 'admin', '2021-08-09 09:46:52', NULL);
INSERT INTO `sys_dict_data` VALUES (221, 1, 'ICCID', '1', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:49:22', 'admin', '2021-08-09 09:46:37', NULL);
INSERT INTO `sys_dict_data` VALUES (222, 0, '平台记录', 's', 'yunze_card_pay_type', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:55:00', 'admin', '2021-08-06 10:55:16', NULL);
INSERT INTO `sys_dict_data` VALUES (223, 1, '系统', 'sys', 'yunze_order_creType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:58:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (224, 2, '人工', 'ai', 'yunze_order_creType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (225, 1, '否', '0', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:02:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (226, 3, '比例', '1', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:03:11', 'admin', '2021-08-06 11:03:51', NULL);
INSERT INTO `sys_dict_data` VALUES (227, 2, '差价', '2', 'yunze_order_profitType', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:03:22', 'admin', '2021-08-06 11:03:41', NULL);
INSERT INTO `sys_dict_data` VALUES (228, 5, '备注', '5', 'yunze_order_seltype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:07:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (229, 1, '创建时间', '1', 'yunze_order_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:44:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (230, 2, '加包时间', '2', 'yunze_order_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-06 11:44:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (231, 1, 'ICCID', '1', 'yunze_order_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-08-06 17:41:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (233, 5, '平台批量充值', '5', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-12 16:13:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (234, 6, '平台资费订购', '_importRecharge', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-13 13:48:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (235, 6, '连接管理设置', '6', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-18 11:57:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (236, 7, '连接设置详情', '_CardImportSet', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-18 11:59:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (237, 8, '连接管理设置备份', '_CardImportSetBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-18 12:00:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (238, 4, '备份任务', 'BACKUP', 'sys_job_group', NULL, NULL, 'N', '0', 'admin', '2021-08-18 17:25:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (239, 9, 'imei查询', '_CardImportSelImei', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-08-20 16:36:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (240, 7, '特殊操作 查询imie', '7', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-08-20 16:37:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (241, 0, '基础资费', '0', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-01 16:05:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (242, 1, '叠加资费', '1', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-01 16:05:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (243, 0, '仅一次', '0', 'yunze_base_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-03 15:31:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (244, 1, '可叠加', '1', 'yunze_base_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-09-03 15:31:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (245, 3, '请求参数', '4', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:49:25', '', NULL, '请求参数');
INSERT INTO `sys_dict_data` VALUES (246, 4, '响应参数', '5', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:49:52', '', NULL, '响应参数');
INSERT INTO `sys_dict_data` VALUES (247, 5, '操作名称', '6', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:50:20', '', NULL, '操作名称');
INSERT INTO `sys_dict_data` VALUES (248, 1, 'iotapi', 'iotapi', 'yz_sys_logs_project', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:51:45', 'admin', '2021-08-24 12:02:16', NULL);
INSERT INTO `sys_dict_data` VALUES (249, 0, '对应串号', '1', 'dosage_details_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:14:59', '', NULL, '对应串号');
INSERT INTO `sys_dict_data` VALUES (250, 0, '创建时间', '1', 'yunze_yz_card_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:44:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (251, 1, '修改时间', '2', 'yunze_yz_card_flow_his', NULL, NULL, 'N', '0', 'admin', '2021-08-26 09:44:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (252, 1, '创建时间', '0', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 11:39:48', '', NULL, '通道进度创建时间');
INSERT INTO `sys_dict_data` VALUES (253, 2, '修改时间', '1', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 11:40:25', '', NULL, '通道进度修改时间');
INSERT INTO `sys_dict_data` VALUES (254, 1, '轮序批次编码', '0', 'yz_passageway_polling', NULL, NULL, 'N', '0', 'admin', '2021-08-31 14:05:46', 'admin', '2021-09-01 10:11:19', NULL);
INSERT INTO `sys_dict_data` VALUES (255, 3, '同步时间', '2', 'yunze_yz_passageway', NULL, NULL, 'N', '0', 'admin', '2021-08-31 14:13:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (257, 1, 'iccid', '0', 'yunze_sorting_rules', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:34:33', '', NULL, '排序规则iccid');
INSERT INTO `sys_dict_data` VALUES (258, 1, '创建时间', '0', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:54:40', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (259, 2, '生效时间', '1', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:05', '', NULL, '生效时间');
INSERT INTO `sys_dict_data` VALUES (260, 3, '到期时间', '2', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:23', '', NULL, '到期时间');
INSERT INTO `sys_dict_data` VALUES (261, 4, '更新累计包时间', '3', 'yunze_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 13:55:48', '', NULL, '更新累计包时间');
INSERT INTO `sys_dict_data` VALUES (262, 1, '升序', '0', 'Lifting_sequence', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:01:04', '', NULL, '升序');
INSERT INTO `sys_dict_data` VALUES (263, 2, '降序', '1', 'Lifting_sequence', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:01:19', '', NULL, '降序');
INSERT INTO `sys_dict_data` VALUES (264, 1, '订单号', '0', 'yz_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:23:41', '', NULL, '订购资费订单号');
INSERT INTO `sys_dict_data` VALUES (265, 2, '对应串号', '1', 'yz_card_flow', NULL, NULL, 'N', '0', 'admin', '2021-09-06 14:25:29', '', NULL, '订购资费对应串号');
INSERT INTO `sys_dict_data` VALUES (266, 1, '创建时间', '0', 'yunze_syslogs_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-08-24 08:55:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (267, 0, '请求url', '1', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:46:33', '', NULL, '请求url');
INSERT INTO `sys_dict_data` VALUES (268, 1, '执行的类方法', '2', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:47:19', 'admin', '2021-08-24 10:47:54', NULL);
INSERT INTO `sys_dict_data` VALUES (269, 2, 'ip', '3', 'system_yz_sys_logs_sysLog', NULL, NULL, 'N', '0', 'admin', '2021-08-24 10:48:30', 'admin', '2021-08-24 10:48:45', NULL);
INSERT INTO `sys_dict_data` VALUES (270, 1, '生命周期', '1', 'yz_cardChange_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:39:11', 'admin', '2021-09-14 09:39:25', NULL);
INSERT INTO `sys_dict_data` VALUES (271, 2, '断开网状态', '2', 'yz_cardChange_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:39:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (272, 1, '达量停机', '1', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:41:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (273, 2, '未订购轮询停机', '2', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:41:48', 'admin', '2021-09-14 14:53:39', NULL);
INSERT INTO `sys_dict_data` VALUES (274, 3, '手动变更', '3', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (275, 4, 'C端充值', '4', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (276, 5, '批量操作', '5', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-09-14 09:42:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (277, 5, '未订购资费断网', '5', 'yunze_polling_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 10:16:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (278, 1, '正常', '1', 'yz_cardConnection_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 11:41:44', 'admin', '2021-09-14 11:42:04', NULL);
INSERT INTO `sys_dict_data` VALUES (279, 2, '断网', '2', 'yz_cardConnection_type', NULL, NULL, 'N', '0', 'admin', '2021-09-14 11:41:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (280, 1, '成功', '1', 'yz_cardChange_ExecutionStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-15 08:38:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (281, 2, '失败', '2', 'yz_cardChange_ExecutionStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-15 08:38:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (282, 1, '虚拟编号', '0', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:00', '', NULL, '卡号类别虚拟编号');
INSERT INTO `sys_dict_data` VALUES (283, 2, 'MSISDN', '1', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (284, 3, 'ICCID', '2', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (285, 4, 'IMSI', '3', 'cardNumber', NULL, NULL, 'N', '0', 'admin', '2021-09-09 17:15:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (287, 26, '用户注销', '26', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:51:11', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (288, 27, '停断网', '27', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:52:19', 'admin', '2021-10-11 15:58:07', '欠停');
INSERT INTO `sys_dict_data` VALUES (289, 28, '挂失', '28', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:53:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (290, 29, '故障卡', '29', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:54:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (291, 30, '未实名停机', '30', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:54:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (292, 31, '超量停机', '31', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:58:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (293, 32, '停机保号', '32', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 15:59:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (294, 33, '已锁定', '33', 'yunze_card_status_type', NULL, NULL, 'N', '0', 'admin', '2021-09-18 16:00:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (295, 3, '商品购买', '3', 'yunze_order_type', NULL, NULL, 'N', '0', 'admin', '2021-09-23 12:46:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (296, 99, '购买下单邮件推送', '99', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 14:53:03', 'admin', '2021-09-24 15:15:31', NULL);
INSERT INTO `sys_dict_data` VALUES (297, 1, '卡状态变更', '1', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 14:53:14', 'admin', '2021-09-24 15:16:06', NULL);
INSERT INTO `sys_dict_data` VALUES (298, 2, '单卡有效期', '2', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:16:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (299, 3, '单卡用量', '3', 'yz_cc_trigger_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:16:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (300, 1, '邮件推送', '1', 'yz_cc_execution_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:21:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (301, 2, 'API推送', '2', 'yz_cc_execution_type', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:31:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (302, 1, '正常', '1', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (303, 2, '已停用', '2', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (304, 3, '已删除', '3', 'yz_cc_status', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:32:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (305, 1, '默认', '1', 'yz_cc_template', NULL, NULL, 'N', '0', 'admin', '2021-09-24 15:34:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (313, 0, '待处理', '0', 'yz_cc_HisStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:03:54', 'admin', '2021-09-26 17:04:01', NULL);
INSERT INTO `sys_dict_data` VALUES (314, 1, '已处理', '1', 'yz_cc_HisStatus', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:04:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (315, 0, '失败', '0', 'yz_cc_result', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:06:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (316, 1, '成功', '1', 'yz_cc_result', NULL, NULL, 'N', '0', 'admin', '2021-09-26 17:06:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (317, 0, '已废弃', '0', 'yz_enabled_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 14:52:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (318, 1, '正常', '1', 'yz_enabled_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 14:52:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (319, 0, '下架', '0', 'yz_commodity_sell', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:04:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (320, 1, '售卖中', '1', 'yz_commodity_sell', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:04:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (321, 0, '未审核', '0', 'yz_check_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:06:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (322, 1, '已审核', '1', 'yz_check_state', NULL, NULL, 'N', '0', 'admin', '2021-09-27 18:06:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (323, 1, '不操作', '1', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (324, 2, '停机', '2', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (325, 3, '复机', '3', 'Stop_and_resume', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:32:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (326, 1, '不操作', '1', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (327, 2, '断网', '2', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (328, 3, '开网', '3', 'Disconnect_the_network', NULL, NULL, 'N', '0', 'admin', '2021-09-28 09:40:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (329, 1, 'ICCID', '1', 'yz_card_info_change', NULL, NULL, 'N', '0', 'admin', '2021-09-29 19:54:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (330, 1, '正常', '1', 'yz_customer_state', NULL, NULL, 'N', '0', 'admin', '2021-10-11 15:55:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (331, 2, '已停用', '2', 'yz_customer_state', NULL, NULL, 'N', '0', 'admin', '2021-10-11 15:56:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (332, 1, '自有2021年前含老客户', '1', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:05:53', 'admin', '2021-10-11 16:06:20', NULL);
INSERT INTO `sys_dict_data` VALUES (333, 2, '自有2022年起新客户', '2', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:06:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (334, 99, '其他', '99', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2021-10-11 16:06:36', 'admin', '2021-10-11 16:06:47', NULL);
INSERT INTO `sys_dict_data` VALUES (335, 1, 'A', '1', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:07', '', NULL, 'VIP');
INSERT INTO `sys_dict_data` VALUES (336, 2, 'B', '2', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (337, 3, 'C', '3', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (338, 4, 'D', '4', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (339, 99, '其他', '99', 'yz_customer_grade', NULL, NULL, 'N', '0', 'admin', '2021-10-12 10:47:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (340, 10, '卡分组备注更新', '_CardSetCardInfo', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (341, 14, '卡分组备注更新备份', '_CardSetCardInfoBackup', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:20', 'admin', '2021-12-24 15:47:40', NULL);
INSERT INTO `sys_dict_data` VALUES (342, 8, '特殊操作 变更卡分组、备注', '8', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-10-14 08:53:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (347, 1, '终端', '1', 'yz_customer_grade_one', NULL, NULL, 'N', '0', 'admin', '2021-10-29 16:09:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (348, 1, '直客', '1', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (349, 2, '生产厂家', '2', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (350, 11, '分销商', '11', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:17:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (351, 12, '贸易商', '12', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:18:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (352, 2, '代理', '2', 'yz_customer_grade_one', NULL, NULL, 'N', '0', 'admin', '2021-10-30 14:18:29', 'admin', '2021-10-30 14:18:35', NULL);
INSERT INTO `sys_dict_data` VALUES (353, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:25:31', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (354, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:28:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (355, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:30:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (356, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:30:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (357, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:38:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (358, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (359, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (360, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (361, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:39:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (362, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:40:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (363, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:41:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (364, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:42:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (365, 1, '学生', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 14:44:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (366, 1, '123', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:00:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (367, 1, '创建时间', '1', 'Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:40:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (368, 1, '无', '1', 'yz_cc_condition', NULL, NULL, 'N', '0', 'admin', '2021-10-25 15:59:29', 'admin', '2021-10-25 15:59:34', NULL);
INSERT INTO `sys_dict_data` VALUES (369, 1, '判断条件', '1', 'cc_query_criteria', NULL, NULL, 'N', '0', 'admin', '2021-10-26 10:01:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (370, 1, '最后修改时间', '1', 'prdCategory_timet', NULL, NULL, 'N', '0', 'admin', '2021-10-29 15:33:27', 'admin', '2021-10-29 15:33:48', NULL);
INSERT INTO `sys_dict_data` VALUES (371, 1, '创建时间', '1', 'yunze_task_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-10-29 16:11:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (372, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:30:24', '', NULL, '自动化 创建时间 类型');
INSERT INTO `sys_dict_data` VALUES (373, 1, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:31:46', '', NULL, '自动化创建类型');
INSERT INTO `sys_dict_data` VALUES (374, 1, '创建时间', '0', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:32:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (375, 0, '创建时间', '1', ' Automation_time', NULL, NULL, 'N', '0', 'admin', '2021-10-19 14:34:03', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (376, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-19 16:33:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (377, 0, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-19 16:35:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (378, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 09:52:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (379, 1, '创建时间', '0', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 09:55:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (380, 1, '创建时间', '1', ' Automated_configuration', NULL, NULL, 'N', '0', 'admin', '2021-10-25 13:38:57', '', NULL, '创建时间');
INSERT INTO `sys_dict_data` VALUES (381, 1, '客户名称', '1', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:26:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (382, 2, '税号', '2', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:26:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (383, 3, '地址详情', '3', 'yz_customer_selType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:27:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (384, 0, '创建时间', '0', 'yz_customer_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:28:55', 'admin', '2021-11-04 16:29:49', NULL);
INSERT INTO `sys_dict_data` VALUES (385, 1, '最后修改时间', '1', 'yz_customer_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-11-02 16:29:26', 'admin', '2021-11-04 16:29:53', NULL);
INSERT INTO `sys_dict_data` VALUES (386, 1, '是否回收', '1', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (387, 2, '合伙人费率', '2', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (388, 3, '销售费率', '3', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (389, 4, '售后费率', '4', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:04:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (390, 5, '所属合伙人', '5', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:05:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (391, 6, '所属销售', '6', 'yz_CustomerChange_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 14:06:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (392, 1, '企业', '1', 'yz_CustomerSort_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 15:56:02', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (393, 2, '个人', '2', 'yz_CustomerSort_type', NULL, NULL, 'N', '0', 'admin', '2021-11-05 15:56:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (394, 2, '平台仅一次', '2', 'yunze_packet_type', NULL, NULL, 'N', '0', 'admin', '2021-11-09 16:51:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (395, 9, '月初复机操作', '9', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-09 10:30:35', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (396, 6, '月初已订购复机', '6', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-11-09 14:46:47', '', NULL, '月初有流量的卡进行复机');
INSERT INTO `sys_dict_data` VALUES (397, 10, 'C端充值变更失败再次复机', '10', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-10 13:46:58', '', NULL, 'C端充值 轮询 卡状态变更失败的 进行再次 复机；（前提是没用完用量）');
INSERT INTO `sys_dict_data` VALUES (398, 7, 'C端充值变更失败再次复机', '7', 'yz_cardChange_sourceType', NULL, NULL, 'N', '0', 'admin', '2021-11-11 11:32:03', '', NULL, 'C端充值 轮询 卡状态变更失败的 进行再次 复机；（前提是没用完用量）');
INSERT INTO `sys_dict_data` VALUES (400, 15, '中国移动ECV2', 'YiDong_ECv2', 'channel_code', NULL, NULL, 'N', '0', 'admin', '2021-11-29 12:06:53', 'admin', '2021-11-29 12:07:11', 'pboss');
INSERT INTO `sys_dict_data` VALUES (401, 1, '是', '1', 'buttonyesno', NULL, NULL, 'N', '0', 'admin', '2021-11-11 21:26:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (402, 2, '否', '2', 'buttonyesno', NULL, NULL, 'N', '0', 'admin', '2021-11-11 21:26:53', 'admin', '2021-11-12 16:07:02', NULL);
INSERT INTO `sys_dict_data` VALUES (407, 11, '全部订单导出', '11', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-23 15:26:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (408, 10, '订单管理导出', '_Exportallorders', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-11-24 13:32:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (409, 12, '购物订单导出', '12', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2021-11-25 10:03:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (410, 13, '购物订单导出', '_Shoppingexport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-11-25 10:10:07', 'admin', '2021-12-24 15:47:36', NULL);
INSERT INTO `sys_dict_data` VALUES (411, 4, '发货日期', '4', 'yunze_card_sel_timetype', NULL, NULL, 'N', '0', 'admin', '2021-11-25 16:04:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (412, 1, '中移企业', '1', 'yz_Commodity_supplier', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:14:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (413, 2, '电信物联网', '2', 'yz_Commodity_supplier', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:14:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (414, 1, '中国移动', '1', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (415, 2, '中国联通', '2', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:30', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (416, 3, '中国电信', '3', 'yz_Commodity_Operator', NULL, NULL, 'N', '0', 'admin', '2021-12-06 10:15:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (417, 1, '商品名称', '1', 'yz_Bcommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:29:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (418, 1, '分类名称', '1', 'yz_BcommoditySort_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:32:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (419, 1, '名称', '1', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:26', 'admin', '2021-12-06 16:44:48', NULL);
INSERT INTO `sys_dict_data` VALUES (420, 2, '型号', '2', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (421, 3, '备注', '3', 'yz_Ccommodity_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-06 16:44:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (422, 0, '已删除', '0', 'yz_Universal_delete', NULL, NULL, 'N', '0', 'admin', '2021-12-07 09:51:55', 'admin', '2021-12-07 09:52:06', NULL);
INSERT INTO `sys_dict_data` VALUES (423, 1, '正常', '1', 'yz_Universal_delete', NULL, NULL, 'N', '0', 'admin', '2021-12-07 09:52:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (424, 0, '不分润', '0', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 14:38:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (425, 1, '正常分润', '1', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:11:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (426, 2, '合伙人分润', '2', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:12:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (427, 3, '销售分润', '3', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:12:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (428, 4, '售后分润', '4', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:20:48', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (429, 5, '合伙人+销售分润', '5', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:21:13', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (430, 6, '合伙人+售后分润', '6', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:21:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (431, 7, '销售+售后分润', '7', 'yz_profit_sharingType', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:22:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (432, 0, '不开票', '0', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:38:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (433, 1, '增值票', '1', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:39:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (434, 2, '普通票', '2', 'yz_Invoicing_Type', NULL, NULL, 'N', '0', 'admin', '2021-12-07 15:39:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (435, 1, '已申请', '1', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (436, 2, '待发货', '2', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (437, 3, '待出库', '3', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:49:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (438, 4, '已完成', '4', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:50:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (439, 99, '作废', '99', 'yz_Contract_status', NULL, NULL, 'N', '0', 'admin', '2021-12-10 17:51:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (440, 0, '未打款', '0', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:08:38', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (441, 1, '部分到款', '1', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:08:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (442, 3, '已收款', '3', 'yz_ReceivePayment_type', NULL, NULL, 'N', '0', 'admin', '2021-12-10 18:09:12', 'admin', '2021-12-10 18:09:21', NULL);
INSERT INTO `sys_dict_data` VALUES (443, 1, '客户名称', '1', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:43:14', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (444, 2, '甲方代表', '2', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:43:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (445, 3, '合同金额', '3', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:44:00', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (446, 4, '备注', '4', 'yz_SalesContract_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:49:54', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (447, 1, '创建时间', '1', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:51:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (448, 2, '修改时间', '2', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:52:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (449, 0, '合同日期', '0', 'yz_SalesContract_selTimeType', NULL, NULL, 'N', '0', 'admin', '2021-12-11 16:52:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (450, 1, '现金', '1', 'cwgl_Deposit_type', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:05:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (451, 1, '未到款', '1', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (452, 2, '有尾款', '2', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (453, 3, '已到款', '3', 'cwgl_Deposit_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:27:53', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (454, 1, '未发', '1', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:44:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (455, 2, '未发全', '2', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:44:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (456, 3, '已发', '3', 'Ship_state', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:53:05', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (457, 1, '销售合同', '1', 'DepositSource_type', NULL, NULL, 'N', '0', 'admin', '2021-12-13 16:57:28', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (458, 1, '合同开票', '1', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (459, 2, '预付开票', '2', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (460, 3, '代开票', '3', 'invoice_Nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 08:37:59', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (461, 1, '销售订单', '1', 'contract_nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 09:02:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (462, 2, '临时订单', '2', 'contract_nature', NULL, NULL, 'N', '0', 'admin', '2021-12-14 09:02:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (464, 1, '客户名称', '1', 'yunze_OrderDelivery_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-14 12:28:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (465, 1, '预计发货时间', '1', 'yunze_OrderDelivery_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-14 13:28:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (466, 2, '合同创建时间', '2', 'yunze_OrderDelivery_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-14 13:52:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (467, 1, '临时订单', '1', 'Delivery_selection_type', NULL, NULL, 'N', '1', 'admin', '2021-12-14 15:58:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (468, 2, '合同发货', '2', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (469, 3, '普通发货', '3', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (470, 4, '发票发货', '4', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:23', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (471, 5, '其他发货', '5', 'Delivery_selection_type', NULL, NULL, 'N', '0', 'admin', '2021-12-14 15:59:33', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (472, 1, '快递', '1', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:21', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (473, 2, '物流', '2', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (474, 3, '送货', '3', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:43', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (475, 4, '自取', '4', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (476, 5, '其他', '5', 'Delivery_method', NULL, NULL, 'N', '0', 'admin', '2021-12-14 16:39:58', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (477, 1, '合同发货', '1', 'Delivery_type', NULL, NULL, 'N', '0', 'admin', '2021-12-15 09:23:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (478, 2, '其他发货', '2', 'Delivery_type', NULL, NULL, 'N', '0', 'admin', '2021-12-15 09:23:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (479, 1, '寄付', '1', 'Shipping_method', NULL, NULL, 'N', '0', 'admin', '2021-12-15 10:27:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (480, 2, '到付', '2', 'Shipping_method', NULL, NULL, 'N', '0', 'admin', '2021-12-15 10:27:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (481, 1, '客户名称', '1', 'yunze_ShippingApplication_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:16:56', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (482, 2, '发货人姓名', '2', 'yunze_ShippingApplication_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:17:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (483, 1, '申请发货日期', '1', 'yunze_ShippingApplication_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:18:29', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (484, 2, '数据修改时间', '2', 'yunze_ShippingApplication_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-21 16:18:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (485, 1, '单位', '1', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:31', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (486, 2, '收件人', '2', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:44', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (487, 3, '快递编号', '3', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:07:52', 'admin', '2021-12-23 16:28:22', NULL);
INSERT INTO `sys_dict_data` VALUES (488, 1, '发货日期', '1', 'yunze_ExpressInquiry_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:09:37', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (489, 2, '收件日期', '2', 'yunze_ExpressInquiry_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:09:49', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (490, 1, '未收', '1', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (491, 2, '已收', '2', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:46', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (492, 3, '退回', '3', 'yunze_ExpressInquiry_SignFor', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:15:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (493, 1, '未评价', '1', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:17', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (494, 2, '正常', '2', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (495, 3, '慢', '3', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:40', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (496, 4, '损坏', '4', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:16:52', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (497, 5, '丢件', '5', 'yunze_ExpressInquiry_Evaluation', NULL, NULL, 'N', '0', 'admin', '2021-12-23 10:17:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (498, 4, '快递单号', '4', 'yunze_ExpressInquiry_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-23 16:28:30', 'admin', '2021-12-23 16:29:38', NULL);
INSERT INTO `sys_dict_data` VALUES (499, 1, '库存', '1', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (500, 2, '可测试', '2', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:42', 'admin', '2021-12-24 10:51:47', NULL);
INSERT INTO `sys_dict_data` VALUES (501, 3, '待激活', '3', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:51:55', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (502, 4, '已激活', '4', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:03', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (503, 5, '已停机', '5', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (504, 6, '预销户', '6', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:25', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (505, 7, '已销户', '7', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:41', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (506, 8, '未知', '8', 'yunze_card_status_ShowId', NULL, NULL, 'N', '0', 'admin', '2021-12-24 10:52:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (507, 11, '批量同步用量', '_Consumption', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:47:18', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (508, 15, '批量-同步状态', '_PublicMethod', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:48:01', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (509, 16, '批量-同步状态和用量', '_ConsumptionAndState', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:48:16', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (510, 17, '批量-停机', '_Stopped', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:49:01', 'admin', '2021-12-24 16:06:45', NULL);
INSERT INTO `sys_dict_data` VALUES (511, 18, '批量-复机', '_Machine', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:49:20', 'admin', '2021-12-24 16:06:50', NULL);
INSERT INTO `sys_dict_data` VALUES (512, 19, '批量-断网', '_DisconnectNetwork', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:50:56', 'admin', '2021-12-24 16:06:54', NULL);
INSERT INTO `sys_dict_data` VALUES (513, 20, '批量-开网', '_OpenNetwork', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 15:52:00', 'admin', '2021-12-24 16:06:59', NULL);
INSERT INTO `sys_dict_data` VALUES (514, 21, '批量变更', '_CardChangeInfo', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2021-12-24 16:07:22', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (515, 1, '箱号', '1', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (516, 2, '盘号', '2', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (517, 3, '产品编码', '3', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (518, 4, '序列号', '4', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (519, 5, '批号', '5', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (520, 6, '卷盘号', '6', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (521, 7, 'MAC', '7', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (522, 8, '设备码', '8', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (523, 9, '串号', '9', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (524, 10, 'SN', '10', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (525, 11, '原SN', '11', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (526, 12, 'ICCID', '12', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (527, 13, 'IMSI', '13', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (528, 14, 'IMEI', '14', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (529, 15, 'CMEI', '15', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (530, 16, '所属入库编号', '16', 'yunze_InventoryDetails_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:01:24', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (531, 1, '创建日期', '1', 'yunze_inventorydetails_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:04:05', 'admin', '2021-12-28 11:04:29', NULL);
INSERT INTO `sys_dict_data` VALUES (532, 2, '入库日期', '2', 'yunze_inventorydetails_timetype', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:04:15', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (533, 1, '箱号', '1', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (534, 2, '盘号', '2', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:56:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (535, 3, '产品编码', '3', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:06', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (536, 4, '序列号', '4', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (537, 5, '批号', '5', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (538, 6, '卷盘号', '6', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:57:50', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (539, 7, 'MAC', '7', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (540, 8, '设备码', '8', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (541, 9, '串号', '9', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:58:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (542, 10, 'SN', '10', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:10', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (543, 11, '原SN', '11', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:27', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (544, 12, 'ICCID', '12', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 10:59:51', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (545, 13, 'IMSI', '13', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (546, 14, 'IMEI', '14', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:34', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (547, 15, 'CMEI', '15', 'yunze_inventorydetails_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-28 11:00:57', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (548, 1, '商品名称', '1', 'yunze_CustomerInquiries_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 15:32:20', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (549, 2, '型号/编号', '2', 'yunze_CustomerInquiries_selType', NULL, NULL, 'N', '0', 'admin', '2021-12-28 15:32:32', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (550, 3, 'IMEI', '3', 'yunze_card_seltype', NULL, NULL, 'N', '0', 'admin', '2021-12-29 16:22:39', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (551, 5, 'IMEI', '5', 'yunze_card_StartAndEnd_type', NULL, NULL, 'N', '0', 'admin', '2021-12-29 16:23:09', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (552, 22, '客户导入', '_CustomerImport', 'yunze_ExecutionTask_OutType', NULL, NULL, 'N', '0', 'admin', '2022-01-02 10:52:36', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (553, 13, '客户导入', '13', 'yunze_task_type', NULL, NULL, 'N', '0', 'admin', '2022-01-02 10:53:19', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (554, 3, '老客户', '3', 'yz_customer_source', NULL, NULL, 'N', '0', 'admin', '2022-01-03 11:01:08', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (555, 13, '同行', '13', 'yz_customer_grade_tow', NULL, NULL, 'N', '0', 'admin', '2022-01-03 12:25:26', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (556, 0, '无需出库', '0', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:04', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (557, 1, '未出库', '1', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (558, 2, '已出库', '2', 'yunze_ShippingApplication_OutboundStatus ', NULL, NULL, 'N', '0', 'admin', '2022-01-05 10:25:20', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type`  (
  `dict_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE INDEX `dict_type`(`dict_type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 228 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
INSERT INTO `sys_dict_type` VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '用户性别列表');
INSERT INTO `sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '菜单状态列表');
INSERT INTO `sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统开关列表');
INSERT INTO `sys_dict_type` VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '任务状态列表');
INSERT INTO `sys_dict_type` VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '任务分组列表');
INSERT INTO `sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '系统是否列表');
INSERT INTO `sys_dict_type` VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知类型列表');
INSERT INTO `sys_dict_type` VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '通知状态列表');
INSERT INTO `sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '操作类型列表');
INSERT INTO `sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2021-06-05 09:12:10', '', NULL, '登录状态列表');
INSERT INTO `sys_dict_type` VALUES (100, '卡类型', 'card_type', '0', 'admin', '2021-06-05 10:49:08', 'admin', '2021-08-05 08:24:13', '运营商类型\n');
INSERT INTO `sys_dict_type` VALUES (101, '卡列表查询条件', 'yunze_card_seltype', '0', 'admin', '2021-06-07 09:19:56', '', NULL, '卡列表查询条件');
INSERT INTO `sys_dict_type` VALUES (102, '卡板列表时间查询类型', 'yunze_card_sel_timetype', '0', 'admin', '2021-06-07 12:22:33', '', NULL, '卡板列表时间查询类型');
INSERT INTO `sys_dict_type` VALUES (103, '卡板删除标记', 'yunze_card_deltype', '0', 'admin', '2021-06-07 12:25:44', '', NULL, 'del_flag');
INSERT INTO `sys_dict_type` VALUES (104, '运营商类型', 'yunze_card_operators_type', '0', 'admin', '2021-06-07 16:14:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (105, '卡状态', 'yunze_card_status_type', '0', 'admin', '2021-06-07 16:28:35', 'admin', '2021-06-07 17:14:33', NULL);
INSERT INTO `sys_dict_type` VALUES (106, '资费计划生效类别', 'yunze_card_takeEffect_type', '0', 'admin', '2021-06-09 08:54:58', 'admin', '2021-06-22 12:12:32', NULL);
INSERT INTO `sys_dict_type` VALUES (107, '资费计划生效中类型', 'yunze_card_valid_type', '0', 'admin', '2021-06-09 08:59:53', 'admin', '2021-06-22 12:12:19', NULL);
INSERT INTO `sys_dict_type` VALUES (108, '支付方式', 'yunze_card_pay_type', '0', 'admin', '2021-06-09 09:02:21', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (109, '自定义是否', 'yunze_customize_whether', '0', 'admin', '2021-06-09 09:07:06', '', NULL, '0 否,1 是');
INSERT INTO `sys_dict_type` VALUES (110, '卡类型', 'yunze_card_card_type', '0', 'admin', '2021-06-10 08:51:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (111, '卡板网络类型', 'yunze_card_network_type', '0', 'admin', '2021-06-10 08:53:30', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (112, '卡板在线状态', 'yunze_card_online_status', '0', 'admin', '2021-06-10 14:00:59', '', NULL, '卡板列表在线信息');
INSERT INTO `sys_dict_type` VALUES (113, '卡板接入方式', 'yunze_card_access_type', '0', 'admin', '2021-06-10 14:02:21', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (114, '卡板列表起止条件查询', 'yunze_card_StartAndEnd_type', '0', 'admin', '2021-06-11 15:17:02', '', NULL, '号码类型');
INSERT INTO `sys_dict_type` VALUES (115, '通道管理查询类型', 'yunze_channel_selType', '0', 'admin', '2021-06-19 12:20:10', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (116, '查询排序类型', 'ORDER_BY_rule', '0', 'admin', '2021-06-19 13:31:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (117, '通道排序类型', 'channel_ORDER_BY_type', '0', 'admin', '2021-06-19 13:34:08', '', NULL, '通道管理排序类型');
INSERT INTO `sys_dict_type` VALUES (118, '通道状态', 'channel_status', '0', 'admin', '2021-06-19 13:41:06', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (119, '通道编码', 'channel_code', '0', 'admin', '2021-06-19 14:45:39', '', NULL, 'API调用 通道编码');
INSERT INTO `sys_dict_type` VALUES (120, '执行任务表查询类型', 'executionTask_selType', '0', 'admin', '2021-06-21 11:29:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (121, '执行任务管理排序类型', 'executionTask_ORDER_BY_type', '0', 'admin', '2021-06-21 11:39:21', '', NULL, '流量卡》执行任务管理');
INSERT INTO `sys_dict_type` VALUES (122, '执行任务导出类别', 'yunze_ExecutionTask_OutType', '0', 'admin', '2021-06-21 14:17:16', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (123, '资费计划周期', 'yunze_packet_valid_name', '0', 'admin', '2021-06-22 16:19:38', 'admin', '2021-06-22 16:24:03', '月 年');
INSERT INTO `sys_dict_type` VALUES (124, '资费组查询条件', 'yunze_tariffGroup_selType', '0', 'admin', '2021-06-22 17:14:54', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (125, '资费计划条件', 'yunze_tariffPlan_selType', '0', 'admin', '2021-06-22 17:16:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (126, '订单交易类型', 'yunze_order_type', '0', 'admin', '2021-07-03 10:50:16', 'admin', '2021-08-06 11:21:53', NULL);
INSERT INTO `sys_dict_type` VALUES (127, '订单状态', 'yunze_order_status', '0', 'admin', '2021-07-03 10:52:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (129, '通道轮询类型', 'yunze_polling_type', '0', 'admin', '2021-07-08 14:19:59', 'admin', '2021-07-08 14:20:15', '通道轮序详情表用');
INSERT INTO `sys_dict_type` VALUES (130, '执行任务类别', 'yunze_task_type', '0', 'admin', '2021-07-28 08:35:29', '', NULL, '执行任务表，主要用于记录');
INSERT INTO `sys_dict_type` VALUES (131, '订单查询条件', 'yunze_order_seltype', '0', 'admin', '2021-08-06 10:48:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (132, '订单生成方式', 'yunze_order_creType', '0', 'admin', '2021-08-06 10:57:52', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (133, '分润类型', 'yunze_order_profitType', '0', 'admin', '2021-08-06 11:02:08', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (135, '订单管理时间查询类型', 'yunze_order_sel_timetype', '0', 'admin', '2021-08-06 11:43:56', 'admin', '2021-08-06 17:31:11', NULL);
INSERT INTO `sys_dict_type` VALUES (136, '订单管理起止条件', 'yunze_order_StartAndEnd_type', '0', 'admin', '2021-08-06 17:41:37', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (137, '资费计划类别', 'yunze_packet_type', '0', 'admin', '2021-09-01 16:04:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (138, '资费类型规则', 'yunze_base_packet_type', '0', 'admin', '2021-09-03 15:29:17', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (139, '对外接口日志时间类型', 'yunze_syslogs_sel_timetype', '0', 'admin', '2021-08-24 08:52:32', 'admin', '2021-08-24 12:04:02', '日志创建时间');
INSERT INTO `sys_dict_type` VALUES (141, '用量详情', 'dosage_details_flow_his', '0', 'admin', '2021-08-26 09:13:18', 'admin', '2021-08-26 09:13:58', '用量详情');
INSERT INTO `sys_dict_type` VALUES (142, '用量详情时间类型', 'yunze_yz_card_flow_his', '0', 'admin', '2021-08-26 09:43:21', '', NULL, '用量详情时间类型');
INSERT INTO `sys_dict_type` VALUES (143, '通道进度时间类型', 'yunze_yz_passageway', '0', 'admin', '2021-08-31 11:37:08', '', NULL, '通道进度时间类型');
INSERT INTO `sys_dict_type` VALUES (144, '通道编号', 'yz_passageway_polling', '0', 'admin', '2021-08-31 14:03:30', '', NULL, '通道进度编号');
INSERT INTO `sys_dict_type` VALUES (146, '排序规则', 'yunze_sorting_rules', '0', 'admin', '2021-09-06 13:32:43', '', NULL, '排序规则');
INSERT INTO `sys_dict_type` VALUES (147, '时间类型', 'yunze_card_flow', '0', 'admin', '2021-09-06 13:53:34', '', NULL, '订购资费查询');
INSERT INTO `sys_dict_type` VALUES (148, '排序类型', 'Lifting_sequence', '0', 'admin', '2021-09-06 14:00:42', '', NULL, '排序类型');
INSERT INTO `sys_dict_type` VALUES (149, '条件查询', 'yz_card_flow', '0', 'admin', '2021-09-06 14:19:22', '', NULL, '订购资费条件查询');
INSERT INTO `sys_dict_type` VALUES (150, '条件选择', 'system_yz_sys_logs_sysLog', '0', 'admin', '2021-08-24 08:33:58', '', NULL, '日志执行');
INSERT INTO `sys_dict_type` VALUES (151, '模块类别', 'yz_sys_logs_project', '0', 'admin', '2021-08-24 08:47:40', '', NULL, '执行模块类别\n');
INSERT INTO `sys_dict_type` VALUES (152, '卡变更类型', 'yz_cardChange_type', '0', 'admin', '2021-09-14 09:37:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (153, '卡变更类型来源', 'yz_cardChange_sourceType', '0', 'admin', '2021-09-14 09:38:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (154, '断开网状态', 'yz_cardConnection_type', '0', 'admin', '2021-09-14 11:41:26', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (155, '卡信息变更执行状态', 'yz_cardChange_ExecutionStatus', '0', 'admin', '2021-09-15 08:37:48', 'admin', '2021-09-15 08:38:16', '');
INSERT INTO `sys_dict_type` VALUES (156, '卡号类别', 'cardNumber', '0', 'admin', '2021-09-09 17:13:07', '', NULL, '卡号类别');
INSERT INTO `sys_dict_type` VALUES (157, '自动化触发类型', 'yz_cc_trigger_type', '0', 'admin', '2021-09-24 14:52:22', 'admin', '2021-09-24 15:18:37', NULL);
INSERT INTO `sys_dict_type` VALUES (158, '推送执行动作类型', 'yz_cc_execution_type', '0', 'admin', '2021-09-24 15:18:30', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (159, '自动化状态', 'yz_cc_status', '0', 'admin', '2021-09-24 15:19:52', 'admin', '2021-09-24 15:20:21', NULL);
INSERT INTO `sys_dict_type` VALUES (160, '自动化推送模板', 'yz_cc_template', '0', 'admin', '2021-09-24 15:34:04', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (162, '自动化抄送状态', 'yz_cc_HisStatus', '0', 'admin', '2021-09-26 17:03:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (163, '自动化抄送结果', 'yz_cc_result', '0', 'admin', '2021-09-26 17:06:03', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (164, '通用启用状态', 'yz_enabled_state', '0', 'admin', '2021-09-27 14:51:46', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (165, '商品出售状态', 'yz_commodity_sell', '0', 'admin', '2021-09-27 18:04:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (166, '商品审核状态', 'yz_check_state', '0', 'admin', '2021-09-27 18:06:19', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (167, '停复机', 'Stop_and_resume', '0', 'admin', '2021-09-28 09:31:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (168, '断开网', 'Disconnect_the_network', '0', 'admin', '2021-09-28 09:39:45', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (169, '卡信息变更查询条件', 'yz_card_info_change', '0', 'admin', '2021-09-29 19:54:02', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (170, '客户状态', 'yz_customer_state', '0', 'admin', '2021-10-11 15:54:03', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (171, '客户来源', 'yz_customer_source', '0', 'admin', '2021-10-11 16:04:56', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (172, '客户等级', 'yz_customer_grade', '0', 'admin', '2021-10-12 10:45:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (174, '客户一级分类', 'yz_customer_grade_one', '0', 'admin', '2021-10-29 16:08:24', '', NULL, '客户一级分类');
INSERT INTO `sys_dict_type` VALUES (175, '客户二级分类', 'yz_customer_grade_tow', '0', 'admin', '2021-10-29 16:08:55', '', NULL, '客户二级分类');
INSERT INTO `sys_dict_type` VALUES (176, '客户查询类型', 'yz_customer_selType', '0', 'admin', '2021-11-02 16:25:20', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (177, '客户时间查询类型', 'yz_customer_selTimeType', '0', 'admin', '2021-11-02 16:28:34', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (178, '客户敏感信息变更类型', 'yz_CustomerChange_type', '0', 'admin', '2021-11-05 13:59:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (179, '客户类型', 'yz_CustomerSort_type', '0', 'admin', '2021-11-05 15:55:44', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (180, '自动化时间类型', 'Automation_time', '0', 'admin', '2021-10-19 14:29:36', '', NULL, '自动化时间 类型');
INSERT INTO `sys_dict_type` VALUES (181, '自动化配置时间类型', 'Automated_configuration', '0', 'admin', '2021-10-19 16:33:02', '', NULL, '自动化配置时间类型');
INSERT INTO `sys_dict_type` VALUES (186, '自动化条件类型', 'yz_cc_condition', '0', 'admin', '2021-10-25 15:57:52', 'admin', '2021-10-25 16:00:03', '自动化');
INSERT INTO `sys_dict_type` VALUES (187, '自动化条件选择', 'cc_query_criteria', '0', 'admin', '2021-10-26 10:00:40', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (188, '商品分类时间类型', 'prdCategory_timet', '0', 'admin', '2021-10-29 15:32:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (189, '自动化配置时间类型 ', 'yunze_task_sel_timetype', '0', 'admin', '2021-10-29 16:11:23', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (190, '是否更新未填写属性', 'buttonyesno', '0', 'admin', '2021-11-11 21:25:52', '', NULL, '物联网卡管理 新增 勾选式 编辑 分组 备注 可选择型更新字段；');
INSERT INTO `sys_dict_type` VALUES (191, '入库源', 'Warehousing_source', '0', 'admin', '2021-11-17 09:53:14', '', NULL, '入库出库信息');
INSERT INTO `sys_dict_type` VALUES (192, '商品供应商', 'yz_Commodity_supplier', '0', 'admin', '2021-12-06 10:12:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (193, '商品运营商', 'yz_Commodity_Operator', '0', 'admin', '2021-12-06 10:13:36', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (194, 'B端商品查询条件', 'yz_Bcommodity_selType', '0', 'admin', '2021-12-06 16:28:29', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (195, 'C端商品查询条件', 'yz_Ccommodity_selType', '0', 'admin', '2021-12-06 16:29:15', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (196, 'B端商品分类查询条件', 'yz_BcommoditySort_selType', '0', 'admin', '2021-12-06 16:31:52', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (197, '通用删除', 'yz_Universal_delete', '0', 'admin', '2021-12-07 09:51:39', '', NULL, '用与状态删除标记');
INSERT INTO `sys_dict_type` VALUES (198, '销售合同分润模式', 'yz_profit_sharingType', '0', 'admin', '2021-12-07 14:38:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (199, '销售合同开票类型', 'yz_Invoicing_Type', '0', 'admin', '2021-12-07 15:38:43', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (200, '销售合同状态', 'yz_Contract_status', '0', 'admin', '2021-12-10 17:46:46', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (201, '合同收款状态', 'yz_ReceivePayment_type', '0', 'admin', '2021-12-10 18:07:57', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (202, '销售合同查询条件', 'yz_SalesContract_selType', '0', 'admin', '2021-12-11 16:42:53', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (203, '销售合同查询时间类型', 'yz_SalesContract_selTimeType', '0', 'admin', '2021-12-11 16:51:19', 'admin', '2021-12-11 16:53:03', NULL);
INSERT INTO `sys_dict_type` VALUES (204, '入款类型', 'cwgl_Deposit_type', '0', 'admin', '2021-12-13 16:04:10', '', NULL, '入款信息');
INSERT INTO `sys_dict_type` VALUES (205, '入款状态', 'cwgl_Deposit_state', '0', 'admin', '2021-12-13 16:04:42', '', NULL, '入款信息\n');
INSERT INTO `sys_dict_type` VALUES (206, '发货状态', 'Ship_state', '0', 'admin', '2021-12-13 16:44:28', '', NULL, '订单合同');
INSERT INTO `sys_dict_type` VALUES (207, '入款信息来源类别', 'DepositSource_type', '0', 'admin', '2021-12-13 16:57:04', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (208, '发票性质', 'invoice_Nature', '0', 'admin', '2021-12-14 08:37:15', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (209, '合同性质', 'contract_nature', '0', 'admin', '2021-12-14 09:02:24', '', NULL, '订单合同发货信息');
INSERT INTO `sys_dict_type` VALUES (210, '合同发货查询条件', 'yunze_OrderDelivery_selType', '0', 'admin', '2021-12-14 12:27:20', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (211, '合同发货查询时间类型', 'yunze_OrderDelivery_timetype', '0', 'admin', '2021-12-14 13:28:39', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (212, '发货选择类型', 'Delivery_selection_type', '0', 'admin', '2021-12-14 15:58:20', 'admin', '2021-12-15 09:23:20', '');
INSERT INTO `sys_dict_type` VALUES (213, '发货方式', 'Delivery_method', '0', 'admin', '2021-12-14 16:39:07', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (214, '发货类型', 'Delivery_type', '0', 'admin', '2021-12-15 09:23:35', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (215, '运费方式', 'Shipping_method', '0', 'admin', '2021-12-15 10:27:38', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (216, '发货申请查询条件', 'yunze_ShippingApplication_selType', '0', 'admin', '2021-12-21 16:16:07', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (217, '发货申请时间查询类型', 'yunze_ShippingApplication_timetype', '0', 'admin', '2021-12-21 16:18:18', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (218, '快递查询-查询条件', 'yunze_ExpressInquiry_selType', '0', 'admin', '2021-12-23 10:06:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (219, '快递查询-时间查询类型', 'yunze_ExpressInquiry_timetype', '0', 'admin', '2021-12-23 10:07:05', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (220, '快递签收状态', 'yunze_ExpressInquiry_SignFor', '0', 'admin', '2021-12-23 10:12:24', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (221, '快递评价', 'yunze_ExpressInquiry_Evaluation', '0', 'admin', '2021-12-23 10:13:00', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (222, '卡状态', 'yunze_card_status_ShowId', '0', 'admin', '2021-12-24 10:50:08', '', NULL, '对外展示');
INSERT INTO `sys_dict_type` VALUES (223, '库存明细查询条件', 'yunze_InventoryDetails_selType', '0', 'admin', '2021-12-28 10:55:55', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (224, '入库明细-时间查询类型', 'yunze_inventorydetails_timetype', '0', 'admin', '2021-12-28 11:03:50', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (225, '入库明细-起止条件查询类型', 'yunze_inventorydetails_StartAndEnd_type', '0', 'admin', '2021-12-28 11:05:47', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (226, '库存数量-查询条件类型', 'yunze_CustomerInquiries_selType', '0', 'admin', '2021-12-28 15:29:48', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (227, '出库状态', 'yunze_ShippingApplication_OutboundStatus ', '0', 'admin', '2022-01-05 10:24:50', '', NULL, '发货申请出库状态');

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job`  (
  `job_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 28 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '定时任务调度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job
-- ----------------------------
INSERT INTO `sys_job` VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2021-06-05 09:12:10', '', NULL, '');
INSERT INTO `sys_job` VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2021-06-05 09:12:10', '', NULL, '');
INSERT INTO `sys_job` VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '0', '1', 'admin', '2021-06-05 09:12:10', 'admin', '2021-07-04 08:47:54', '');
INSERT INTO `sys_job` VALUES (4, '根据订单轮序更新激活时间', 'DEFAULT', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '0 0 0/1 * * ? ', '1', '1', '0', 'admin', '2021-07-04 15:50:06', 'admin', '2021-11-15 13:31:37', '');
INSERT INTO `sys_job` VALUES (5, '轮询-激活时间', 'POLLING', 'cardActivateDateTask.pollingActivateDate(\'Slight\', 120)', '0 0 0 * * ? ', '2', '1', '0', 'admin', '2021-07-07 15:32:32', 'admin', '2021-11-25 14:18:42', '');
INSERT INTO `sys_job` VALUES (6, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '0 0/10 * * * ?', '2', '0', '0', 'admin', '2021-07-15 17:07:12', 'admin', '2021-11-12 09:31:33', '');
INSERT INTO `sys_job` VALUES (7, '轮询-卡状态', 'POLLING', 'cardStatusTask.pollingCardStatus(120)', '0 0 11,22 * * ? ', '1', '1', '0', 'admin', '2021-07-20 12:03:30', 'admin', '2021-11-25 14:18:56', '');
INSERT INTO `sys_job` VALUES (8, '轮询-用量', 'POLLING', 'cardFlowTask.pollingCardFlow(120)', '0 0 6,18 * * ? ', '1', '1', '0', 'admin', '2021-07-21 13:33:23', 'admin', '2021-11-25 14:19:06', '');
INSERT INTO `sys_job` VALUES (9, '达量停机', 'POLLING', 'cardStopTask.pollingCardStop(60)', '0 0/15 * * * ?', '1', '1', '0', 'admin', '2021-07-23 18:07:40', 'admin', '2021-09-14 15:54:19', '');
INSERT INTO `sys_job` VALUES (10, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '0 0/5 * * * ?', '1', '1', '0', 'admin', '2021-08-04 16:52:55', 'admin', '2021-08-24 10:07:11', '');
INSERT INTO `sys_job` VALUES (11, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '0 0/10 * * * ?', '1', '1', '0', 'admin', '2021-08-13 15:04:26', 'admin', '2021-08-24 10:03:52', '');
INSERT INTO `sys_job` VALUES (12, '手动开启用量监听', 'POLLING', 'cardFlowTask.StartCardFlow(60)', '0 0/1 * * * ?', '1', '1', '1', 'admin', '2021-08-19 14:44:15', '', NULL, '');
INSERT INTO `sys_job` VALUES (13, '删除对外接口日志', 'BACKUP', 'sysLogsTask.backups()', '0 0 0 * * ? *', '1', '1', '0', 'admin', '2021-08-19 17:57:28', 'admin', '2021-11-19 15:15:17', '');
INSERT INTO `sys_job` VALUES (14, 'MQ初始化', 'DEFAULT', 'initMQ.initMQConfig', '0 0 0 * * ? *', '1', '1', '1', 'admin', '2021-08-31 13:16:27', '', NULL, '');
INSERT INTO `sys_job` VALUES (15, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '0 0/20 * * * ? ', '1', '1', '0', 'admin', '2021-09-14 14:08:36', 'admin', '2021-12-01 17:28:35', '');
INSERT INTO `sys_job` VALUES (16, '备份所有表', 'BACKUP', 'backupTest.gentable(30)', '0 0 0 * * ? *', '1', '1', '1', 'admin', '2021-09-16 18:12:41', 'admin', '2021-09-17 11:08:53', '');
INSERT INTO `sys_job` VALUES (18, '轮询-激活时间有用量', 'POLLING', 'cardActivateDateTask.pollingActivateDate(\'Serious\', 60)', '0 0 0/8 * * ? ', '1', '1', '1', 'admin', '2021-10-28 17:21:14', 'admin', '2021-11-12 11:31:34', '');
INSERT INTO `sys_job` VALUES (19, '月初流量卡进行复机', 'POLLING', 'month.gentable(120)', '0 0 0,2,4,6 1 * ? *', '1', '1', '0', 'admin', '2021-11-08 09:56:52', 'admin', '2021-11-25 14:17:52', '');
INSERT INTO `sys_job` VALUES (21, '回滚 划卡备份', 'BACKUP', 'rollbackCardagent.rollbackError(\'1636963661697_csv_9bd5ee14a6814e8ba2ee7c70711ce4cd_CardDistributeBackup.csv\',236,246)', '0/20 * * * * ?', '1', '1', '1', 'admin', '2021-11-15 20:21:06', 'admin', '2021-11-24 13:14:35', '');
INSERT INTO `sys_job` VALUES (22, '创建单通道用量监听', 'POLLING', 'cardFlowTask.pollingCardFlowOne(60,\'49\')', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-22 10:29:55', 'admin', '2021-12-06 18:20:51', '');
INSERT INTO `sys_job` VALUES (23, '指定单个通道创建 消费者', 'POLLING', 'cardFlowTask.CardFlowCreateListener(60,\'49\')', '0 0 0/1 * * ?', '1', '1', '1', 'admin', '2021-11-22 10:46:08', 'admin', '2021-12-06 18:21:01', '');
INSERT INTO `sys_job` VALUES (24, '轮询重启无记录消费者创建', 'POLLING', 'rebootTask.RebootFlowPolling(180)', '0 0 0/3 * * ?', '1', '1', '0', 'admin', '2021-11-23 17:37:44', 'admin', '2021-12-23 08:55:02', '');
INSERT INTO `sys_job` VALUES (25, '停机阈值重启', 'POLLING', 'rebootTask.RebootCardStop(180)', '0 0 0/1 * * ?', '1', '1', '0', 'admin', '2021-11-27 13:47:23', '', '2021-11-27 14:26:57', '');
INSERT INTO `sys_job` VALUES (26, '未订购停机重启', 'POLLING', 'rebootTask.RebootCardDisconnected(180)', '0 0 0/1 * * ?', '1', '1', '0', 'admin', '2021-11-27 13:48:00', '', '2021-11-27 14:26:59', '');
INSERT INTO `sys_job` VALUES (27, '同步主表到期日期', 'POLLING', 'mqcardflow.gettime(30)', '0 0 0/2 * * ? *', '1', '1', '0', 'admin', '2021-11-26 10:22:57', 'admin', '2021-12-01 17:29:04', '');

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log`  (
  `job_log_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '日志信息',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '异常信息',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 290761 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '定时任务调度日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------
INSERT INTO `sys_job_log` VALUES (83, '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.addPackageProduction(180)', '除 生效类型为 [激活生效] 外 所有加包 增加到生产任务中去 总共耗时：12毫秒', '0', '', '2022-01-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (84, '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去', 'POLLING', 'orderAddPackageProductionTask.activationAddPackageProductionAndActivateDate(180)', '生效类型为 [激活生效] 且 已有生效时间 增加到生产任务中去 总共耗时：10毫秒', '0', '', '2022-01-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (85, '未订购停机', 'POLLING', 'cardDisconnectedTask.pollingCardDisconnected(120)', '未订购停机 总共耗时：1毫秒', '0', '', '2022-01-12 11:20:00');
INSERT INTO `sys_job_log` VALUES (86, '轮询-同步通道数据', 'POLLING', 'passagewayPollingTask.SynChannel()', '轮询-同步通道数据 总共耗时：1毫秒', '0', '', '2022-01-12 11:20:00');

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor`  (
  `info_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '操作系统',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '提示消息',
  `login_time` datetime(0) NULL DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6967 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统访问记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu`  (
  `menu_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(0) NULL DEFAULT 0 COMMENT '父菜单ID',
  `order_num` int(0) NULL DEFAULT 0 COMMENT '显示顺序',
  `path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件路径',
  `is_frame` int(0) NULL DEFAULT 1 COMMENT '是否为外链（0是 1否）',
  `is_cache` int(0) NULL DEFAULT 0 COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2170 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '菜单权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES (1, '系统管理', 0, 51, 'system', NULL, 1, 0, 'M', '0', '0', '', 'system', 'admin', '2021-06-05 09:12:09', 'admin', '2021-08-06 12:29:06', '系统管理目录');
INSERT INTO `sys_menu` VALUES (2, '系统监控', 0, 52, 'monitor', NULL, 1, 0, 'M', '0', '0', '', 'monitor', 'admin', '2021-06-05 09:12:09', 'admin', '2021-08-06 12:29:12', '系统监控目录');
INSERT INTO `sys_menu` VALUES (3, '系统工具', 0, 53, 'tool', NULL, 1, 0, 'M', '0', '0', '', 'tool', 'admin', '2021-06-05 09:12:09', 'admin', '2021-08-06 12:29:17', '系统工具目录');
INSERT INTO `sys_menu` VALUES (100, '内部管理', 2027, 1, 'user', 'system/user/index', 1, 0, 'C', '0', '0', 'system:user:list', 'star', 'admin', '2021-06-05 09:12:09', 'admin', '2021-07-19 16:24:45', '用户管理菜单');
INSERT INTO `sys_menu` VALUES (101, '角色管理', 2027, 6, 'role', 'system/role/index', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2021-06-05 09:12:09', 'admin', '2021-10-12 09:41:23', '角色管理菜单');
INSERT INTO `sys_menu` VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'admin', '2021-06-05 09:12:09', '', NULL, '菜单管理菜单');
INSERT INTO `sys_menu` VALUES (103, '企业管理', 2027, 4, 'dept', 'system/dept/index', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2021-06-05 09:12:09', 'admin', '2021-07-19 16:18:54', '部门管理菜单');
INSERT INTO `sys_menu` VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'admin', '2021-06-05 09:12:09', '', NULL, '岗位管理菜单');
INSERT INTO `sys_menu` VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2021-06-05 09:12:09', '', NULL, '字典管理菜单');
INSERT INTO `sys_menu` VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2021-06-05 09:12:09', '', NULL, '参数设置菜单');
INSERT INTO `sys_menu` VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2021-06-05 09:12:09', '', NULL, '通知公告菜单');
INSERT INTO `sys_menu` VALUES (108, '日志管理', 1, 9, 'log', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2021-06-05 09:12:09', '', NULL, '日志管理菜单');
INSERT INTO `sys_menu` VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2021-06-05 09:12:09', '', NULL, '在线用户菜单');
INSERT INTO `sys_menu` VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2021-06-05 09:12:09', '', NULL, '定时任务菜单');
INSERT INTO `sys_menu` VALUES (111, '数据监控', 2, 3, 'druid', 'monitor/druid/index', 1, 0, 'C', '0', '0', 'monitor:druid:list', 'druid', 'admin', '2021-06-05 09:12:09', '', NULL, '数据监控菜单');
INSERT INTO `sys_menu` VALUES (112, '服务监控', 2, 4, 'server', 'monitor/server/index', 1, 0, 'C', '0', '0', 'monitor:server:list', 'server', 'admin', '2021-06-05 09:12:09', '', NULL, '服务监控菜单');
INSERT INTO `sys_menu` VALUES (113, '缓存监控', 2, 5, 'cache', 'monitor/cache/index', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis', 'admin', '2021-06-05 09:12:09', '', NULL, '缓存监控菜单');
INSERT INTO `sys_menu` VALUES (114, '表单构建', 3, 1, 'build', 'tool/build/index', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2021-06-05 09:12:09', '', NULL, '表单构建菜单');
INSERT INTO `sys_menu` VALUES (115, '代码生成', 3, 2, 'gen', 'tool/gen/index', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2021-06-05 09:12:09', '', NULL, '代码生成菜单');
INSERT INTO `sys_menu` VALUES (116, '系统接口', 3, 3, 'swagger', 'tool/swagger/index', 1, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2021-06-05 09:12:09', '', NULL, '系统接口菜单');
INSERT INTO `sys_menu` VALUES (500, '操作日志', 108, 1, 'operlog', 'monitor/operlog/index', 1, 0, 'C', '0', '0', 'monitor:operlog:list', 'form', 'admin', '2021-06-05 09:12:09', '', NULL, '操作日志菜单');
INSERT INTO `sys_menu` VALUES (501, '登录日志', 108, 2, 'logininfor', 'monitor/logininfor/index', 1, 0, 'C', '0', '0', 'monitor:logininfor:list', 'logininfor', 'admin', '2021-06-05 09:12:09', '', NULL, '登录日志菜单');
INSERT INTO `sys_menu` VALUES (1001, '用户查询', 100, 1, '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1002, '用户新增', 100, 2, '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1003, '用户修改', 100, 3, '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1004, '用户删除', 100, 4, '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1005, '用户导出', 100, 5, '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1006, '用户导入', 100, 6, '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1007, '重置密码', 100, 7, '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1008, '角色查询', 101, 1, '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1009, '角色新增', 101, 2, '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1010, '角色修改', 101, 3, '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1011, '角色删除', 101, 4, '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1012, '角色导出', 101, 5, '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1013, '菜单查询', 102, 1, '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1014, '菜单新增', 102, 2, '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1015, '菜单修改', 102, 3, '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1016, '菜单删除', 102, 4, '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1017, '部门查询', 103, 1, '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1018, '部门新增', 103, 2, '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1019, '部门修改', 103, 3, '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1020, '部门删除', 103, 4, '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1021, '岗位查询', 104, 1, '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1022, '岗位新增', 104, 2, '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1023, '岗位修改', 104, 3, '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1024, '岗位删除', 104, 4, '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1025, '岗位导出', 104, 5, '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1026, '字典查询', 105, 1, '#', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1027, '字典新增', 105, 2, '#', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1028, '字典修改', 105, 3, '#', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1029, '字典删除', 105, 4, '#', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1030, '字典导出', 105, 5, '#', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1031, '参数查询', 106, 1, '#', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1032, '参数新增', 106, 2, '#', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1033, '参数修改', 106, 3, '#', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1034, '参数删除', 106, 4, '#', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1035, '参数导出', 106, 5, '#', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1036, '公告查询', 107, 1, '#', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1037, '公告新增', 107, 2, '#', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1038, '公告修改', 107, 3, '#', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1039, '公告删除', 107, 4, '#', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1040, '操作查询', 500, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1041, '操作删除', 500, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1042, '日志导出', 500, 4, '#', '', 1, 0, 'F', '0', '0', 'monitor:operlog:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1043, '登录查询', 501, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1044, '登录删除', 501, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1045, '日志导出', 501, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1046, '在线查询', 109, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1047, '批量强退', 109, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1048, '单条强退', 109, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1049, '任务查询', 110, 1, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1050, '任务新增', 110, 2, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1051, '任务修改', 110, 3, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1052, '任务删除', 110, 4, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1053, '状态修改', 110, 5, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1054, '任务导出', 110, 7, '#', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1055, '生成查询', 115, 1, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1056, '生成修改', 115, 2, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1057, '生成删除', 115, 3, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1058, '导入代码', 115, 2, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1059, '预览代码', 115, 4, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1060, '生成代码', 115, 5, '#', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2000, '通信管理', 0, 21, 'card', NULL, 1, 0, 'M', '0', '0', '', 'excel', 'admin', '2021-06-05 10:59:36', 'admin', '2021-10-30 10:51:37', '');
INSERT INTO `sys_menu` VALUES (2001, '物联卡管理', 2000, 0, 'card', 'yunze/flowcard/card/index', 1, 0, 'C', '0', '0', 'yunze:card:list', 'date', 'admin', '2021-06-05 11:00:26', 'admin', '2021-10-30 10:55:32', '');
INSERT INTO `sys_menu` VALUES (2003, '详情查询', 2001, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:find', '#', 'admin', '2021-06-09 13:48:19', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2004, '查询套餐信息', 2001, 99, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryflow', '#', 'admin', '2021-06-09 13:51:13', 'admin', '2021-06-11 14:20:22', '');
INSERT INTO `sys_menu` VALUES (2005, '在线信息查询', 2003, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryOnlineStatus', '#', 'admin', '2021-06-11 09:21:29', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2006, '套餐简要信息查询', 2003, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:queryflowSimple', '#', 'admin', '2021-06-11 09:23:33', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2008, '查询简要套餐名称', 2001, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:queryPackageSimple', '#', 'admin', '2021-06-11 14:20:13', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2009, '导出', 2001, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:exportData', '#', 'admin', '2021-06-15 12:34:30', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2010, '查询API通道名称', 2001, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:findSp', '#', 'admin', '2021-06-15 17:10:14', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2011, '查询参数API通道', 2001, 6, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:queryParamsChannelId', '#', 'admin', '2021-06-16 09:13:34', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2012, '通道管理', 2000, 22, 'channel', NULL, 1, 0, 'M', '0', '0', '', 'tree', 'admin', '2021-06-19 11:22:42', 'admin', '2021-10-30 10:52:05', '');
INSERT INTO `sys_menu` VALUES (2013, '上游通道', 2012, 0, 'cardRoute', 'yunze/API/cardRoute/index', 1, 0, 'C', '0', '0', 'yunze:cardRoute:list', 'cascader', 'admin', '2021-06-19 12:27:16', 'admin', '2021-06-19 13:57:55', '');
INSERT INTO `sys_menu` VALUES (2014, '通道详情', 2013, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:find', '#', 'admin', '2021-06-21 09:04:27', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2015, '通道编辑', 2013, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:edit', '#', 'admin', '2021-06-21 09:04:43', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2016, '通道删除', 2013, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:remove', '#', 'admin', '2021-06-21 09:04:59', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2017, '查询公司所属', 0, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:listAgent', '#', 'admin', '2021-06-21 11:18:33', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2018, '执行任务管理', 2000, 99, 'ExecutionTask', 'yunze/flowcard/executionTask', 1, 0, 'C', '0', '0', 'yunze:ExecutionTask:list', 'server', 'admin', '2021-06-21 13:39:44', 'admin', '2021-10-30 11:07:03', '');
INSERT INTO `sys_menu` VALUES (2019, '执行任务下载', 2018, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:executionTask:download', '#', 'admin', '2021-06-21 14:32:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2020, '平台资费', 2109, 1, 'tariffGroup', 'yunze/flowcard/tariffGroup/index', 1, 0, 'C', '0', '0', 'yunze:tariffGroup:list', 'validCode', 'admin', '2021-06-22 10:44:50', 'admin', '2021-10-30 10:58:51', '');
INSERT INTO `sys_menu` VALUES (2021, '客户资费', 2109, 2, 'agentTariffGroup', 'yunze/flowcard/tariffGroup/agent', 1, 0, 'C', '0', '0', 'yunze:agentTariffGroup:list', 'validCode', 'admin', '2021-06-22 11:58:20', 'admin', '2021-10-30 10:59:00', '');
INSERT INTO `sys_menu` VALUES (2022, '平台资费组新增', 2020, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:add', '#', 'admin', '2021-06-23 16:00:39', 'admin', '2021-06-23 16:17:58', '');
INSERT INTO `sys_menu` VALUES (2023, '平台资费组编辑', 2020, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:edit', '#', 'admin', '2021-06-23 16:14:55', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2024, '平台资费计划新增', 2020, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:add', '#', 'admin', '2021-06-23 16:16:22', 'admin', '2021-06-23 16:17:51', '');
INSERT INTO `sys_menu` VALUES (2025, '平台资费计划详情', 2020, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:find', '#', 'admin', '2021-06-23 16:17:05', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2026, '平台资费计划编辑', 2020, 5, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:edit', '#', 'admin', '2021-06-23 16:17:43', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2027, '用户管理', 0, 22, 'agent', NULL, 1, 0, 'M', '0', '0', NULL, 'peoples', 'admin', '2021-06-25 09:29:24', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2028, '企业列表', 2027, 2, 'agent', 'yunze/user/agent/index', 1, 0, 'C', '0', '0', 'yunze:agent:list', 'excel', 'admin', '2021-06-25 09:32:10', 'admin', '2021-07-19 16:24:54', '');
INSERT INTO `sys_menu` VALUES (2029, '用户查询', 2028, 1, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2030, '用户新增', 2028, 2, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2031, '用户修改', 2028, 3, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2032, '用户删除', 2028, 4, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2033, '用户导出', 2028, 5, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:export', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2034, '用户导入', 2028, 6, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:import', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2035, '重置密码', 2028, 7, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2037, '划分资费查看', 2028, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:agent:DividePlan', '#', 'admin', '2021-06-28 14:03:36', 'admin', '2021-06-28 14:14:43', '');
INSERT INTO `sys_menu` VALUES (2038, '划分保存', 2037, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:tariffDivision', '#', 'admin', '2021-06-28 14:15:33', 'admin', '2021-06-28 14:39:09', '');
INSERT INTO `sys_menu` VALUES (2039, '资费组查询', 2037, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:findPackage', '#', 'admin', '2021-06-28 14:17:37', 'admin', '2021-06-28 14:18:03', '');
INSERT INTO `sys_menu` VALUES (2040, '资费计划查询', 2037, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:findPacket', '#', 'admin', '2021-06-28 14:39:01', 'admin', '2021-06-28 14:40:33', '');
INSERT INTO `sys_menu` VALUES (2041, '用户列表', 2027, 3, 'agentUser', 'yunze/user/agentUser/index', 1, 0, 'C', '0', '0', 'yunze:agent:list', 'user', 'admin', '2021-06-25 09:32:10', 'admin', '2021-07-19 16:22:20', '');
INSERT INTO `sys_menu` VALUES (2042, '用户查询', 2041, 1, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:query', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2043, '用户新增', 2041, 2, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:add', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2044, '用户修改', 2041, 3, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:edit', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2045, '用户删除', 2041, 4, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:remove', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2048, '重置密码', 2041, 7, '', '', 1, 0, 'F', '0', '0', 'yunze:agent:resetPwd', '#', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2050, '划分资费查看', 2041, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:agent:DividePlan', '#', 'admin', '2021-06-28 14:03:36', 'admin', '2021-06-28 14:14:43', '');
INSERT INTO `sys_menu` VALUES (2051, '划分保存', 2050, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:agentTariffDivision', '#', 'admin', '2021-06-28 14:15:33', 'admin', '2021-06-29 13:33:58', '');
INSERT INTO `sys_menu` VALUES (2052, '资费组查询', 2050, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffGroup:findPackage', '#', 'admin', '2021-06-28 14:17:37', 'admin', '2021-06-28 14:18:03', '');
INSERT INTO `sys_menu` VALUES (2053, '资费计划查询', 2050, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:tariffPlan:findPacket', '#', 'admin', '2021-06-28 14:39:01', 'admin', '2021-06-28 14:40:33', '');
INSERT INTO `sys_menu` VALUES (2058, '卡板划分', 2001, 7, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:divide', '#', 'admin', '2021-07-02 10:00:00', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2059, '部门所属人员查询', 2058, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:findDeptUser', '#', 'admin', '2021-07-02 10:01:49', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2060, '同步用量', 2001, 8, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:SynFlow', '#', 'admin', '2021-07-21 18:04:29', 'admin', '2021-07-21 18:05:02', '');
INSERT INTO `sys_menu` VALUES (2061, '同步状态', 2001, 9, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:SynStatus', '#', 'admin', '2021-07-21 18:04:46', 'admin', '2021-07-21 18:05:08', '');
INSERT INTO `sys_menu` VALUES (2062, '机卡解绑', 2001, 10, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:CardBinding', '#', 'admin', '2021-07-26 13:09:59', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2063, '订单管理', 0, 23, 'order', NULL, 1, 0, 'M', '0', '0', '', 'chart', 'admin', '2021-08-06 12:28:49', 'admin', '2021-09-27 11:17:56', '');
INSERT INTO `sys_menu` VALUES (2064, '全部订单', 2063, 10, 'OrderAll', 'yunze/order/ordeAll', 1, 0, 'C', '0', '0', 'yunze:order:list', 'chart', 'admin', '2021-08-06 12:32:11', 'admin', '2021-08-06 13:26:36', '');
INSERT INTO `sys_menu` VALUES (2065, '订单列表查询', 2063, 0, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:list', '#', 'admin', '2021-08-06 12:32:56', 'admin', '2021-08-06 12:33:03', '');
INSERT INTO `sys_menu` VALUES (2066, '可查询删除订单', 2063, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:dellist', '#', 'admin', '2021-08-09 11:04:05', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2067, '手动执行加包', 2063, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:manualaddPackage', '#', 'admin', '2021-08-09 11:13:19', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2068, '金额订单', 2063, 11, 'OrderMoney', 'yunze/order/orderMoney', 1, 0, 'C', '0', '0', 'yunze:order:list', 'money', 'admin', '2021-08-09 11:51:56', 'admin', '2021-08-09 11:52:37', '');
INSERT INTO `sys_menu` VALUES (2069, '资费订单', 2063, 12, 'OrderTariff', 'yunze/order/orderTariff', 1, 0, 'C', '0', '0', 'yunze:order:list', 'size', 'admin', '2021-08-09 12:03:34', 'admin', '2021-09-27 10:17:37', '');
INSERT INTO `sys_menu` VALUES (2070, '订单详情', 2063, 3, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:findOrder', '#', 'admin', '2021-08-10 17:08:32', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2071, '资费订购', 2109, 3, 'RechargeTariff', 'yunze/flowcard/rechargeTariff', 1, 0, 'C', '0', '0', 'yunze:order:addPackage', 'money', 'admin', '2021-08-11 11:47:00', 'admin', '2021-10-30 11:02:12', '');
INSERT INTO `sys_menu` VALUES (2072, '查询单条 资费计划  简要', 2071, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardFlow:FindPacket', '#', 'admin', '2021-08-12 11:04:20', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2073, '物联卡设置', 2000, 1, 'cardSetting', 'yunze/flowcard/cardSetting/index', 1, 0, 'C', '0', '0', 'yunze:card:Setting', 'system', 'admin', '2021-08-17 08:23:21', 'admin', '2021-10-30 11:06:55', '');
INSERT INTO `sys_menu` VALUES (2074, '划分通道获取通道名称', 2073, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cardRoute:findCr', '#', 'admin', '2021-08-17 12:16:00', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2075, '平台导入充值', 2071, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:importRecharge', '#', 'admin', '2021-08-18 11:33:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2076, '连接管理导入设置', 2073, 2, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:importSet', '#', 'admin', '2021-08-18 11:35:15', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2079, '特殊操作', 3, 4, 'specialOperation', 'yunze/specialOperation/index', 1, 0, 'C', '0', '0', 'yunze:card:importSelImei', 'system', 'admin', '2021-08-20 15:09:10', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2080, '导入', 2001, 11, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:import', '#', 'admin', '2021-08-23 15:47:34', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2081, '是否内部人员', 0, 1, '', NULL, 1, 0, 'F', '0', '0', 'yunze:sys:internal', '#', 'admin', '2021-09-03 14:24:54', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2082, '用量详情', 2109, 7, 'flowhis', 'yunze/flowcard/card/cardFlowHis', 1, 0, 'C', '0', '0', 'yunze:flowhis:list', 'star', 'admin', '2021-08-25 10:55:35', 'admin', '2021-10-30 11:05:33', '');
INSERT INTO `sys_menu` VALUES (2084, '通道进度', 2012, 2, 'polling', 'yunze/API/polling/index', 1, 0, 'C', '0', '0', 'yunze:polling:list', 'online', 'admin', '2021-08-26 11:19:57', 'admin', '2021-10-12 09:44:49', '');
INSERT INTO `sys_menu` VALUES (2085, '订购历史', 2109, 6, 'flow', 'yunze/flowcard/card/cardFlow', 1, 0, 'C', '0', '0', 'yunze:flow:list', 'money', 'admin', '2021-09-02 08:48:44', 'admin', '2021-10-30 11:05:27', '');
INSERT INTO `sys_menu` VALUES (2086, '日志执行', 108, 3, 'sysLog', 'yunze/system/sysLog/index', 1, 0, 'C', '0', '0', 'yunze:sysLog:list', 'skill', 'admin', '2021-08-23 14:53:03', 'admin', '2021-08-23 15:24:28', '');
INSERT INTO `sys_menu` VALUES (2087, '订购资费查询', 2001, 12, '', NULL, 1, 0, 'F', '0', '0', 'yunze:flow:list', '#', 'admin', '2021-09-18 09:31:28', 'admin', '2021-09-30 14:47:33', '');
INSERT INTO `sys_menu` VALUES (2088, '导入查询', 2001, 13, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ImportQuery', '#', 'admin', '2021-09-23 09:22:31', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2089, '购物订单', 2063, 13, 'OrderShopping', 'yunze/order/OrderShopping', 1, 0, 'C', '0', '0', 'yunze:order:list', 'shopping', 'admin', '2021-09-27 10:16:46', 'admin', '2021-09-27 10:17:13', '');
INSERT INTO `sys_menu` VALUES (2093, '卡信息变更查询', 2001, 14, '', NULL, 1, 0, 'F', '0', '0', 'yunze:change:list', '#', 'admin', '2021-09-27 13:31:00', 'admin', '2021-09-30 15:00:20', '');
INSERT INTO `sys_menu` VALUES (2102, '查询发货订单', 2089, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:findShip', '#', 'admin', '2021-09-30 11:28:54', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2104, '用量详情', 2001, 16, '', NULL, 1, 0, 'F', '0', '0', 'yunze:flowhis:list', '#', 'admin', '2021-09-30 15:00:11', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2106, '变更卡分组、备注', 2001, 17, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:importSetCardInfo', 'system', 'admin', '2021-10-14 09:45:45', 'admin', '2021-10-14 17:30:18', '');
INSERT INTO `sys_menu` VALUES (2108, '设备管理', 2000, 8, 'card', 'yunze/flowcard/card/index', 1, 0, 'C', '0', '1', 'yunze:card:list', '#', 'admin', '2021-10-30 10:50:56', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2109, '资费管理', 2000, 3, 'TariffGroup', NULL, 1, 0, 'M', '0', '0', '', 'button', 'admin', '2021-10-30 10:58:35', 'admin', '2021-10-30 11:06:50', '');
INSERT INTO `sys_menu` VALUES (2110, '批量停复机、断开网', 2001, 18, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ApiUpdBatch', '#', 'admin', '2021-11-02 13:15:53', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2111, '自动化', 2114, 1, 'cc', 'yunze/automation/cc/index', 1, 0, 'C', '0', '0', 'yunze:cc:list', 'email', 'admin', '2021-10-13 13:46:33', 'admin', '2021-10-19 11:27:57', '');
INSERT INTO `sys_menu` VALUES (2112, '推送记录', 2114, 2, 'cchis', 'yunze/automation/cchis/index', 1, 0, 'C', '0', '0', 'yunze:cchis:list', 'form', 'admin', '2021-10-19 15:27:32', 'admin', '2021-10-22 09:04:25', '');
INSERT INTO `sys_menu` VALUES (2113, '配置', 2114, 3, 'ccurl', 'yunze/automation/ccurl/index', 1, 0, 'C', '0', '0', 'yunze:ccurl:list', 'upload', 'admin', '2021-10-19 16:59:20', 'admin', '2021-10-22 09:04:40', '');
INSERT INTO `sys_menu` VALUES (2114, '自动化管理', 1, 10, 'loglog', NULL, 1, 0, 'M', '0', '0', '', 'guide', 'admin', '2021-10-13 13:39:34', 'admin', '2021-10-19 11:34:16', '');
INSERT INTO `sys_menu` VALUES (2137, '导出订单', 2063, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:order:outOrder', '#', 'admin', '2021-12-08 16:39:06', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2153, '勾选式停机', 2001, 20, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:Stopped', '#', 'admin', '2021-12-28 09:04:24', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2154, '勾选式复机', 2001, 21, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:MachineArr', '#', 'admin', '2021-12-28 09:04:52', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2155, '勾选式断网', 2001, 22, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:DisconnectNetworkArr', '#', 'admin', '2021-12-28 09:05:18', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2156, '勾选式开网', 2001, 23, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:OpenNetworkArr', '#', 'admin', '2021-12-28 09:05:38', 'admin', '2021-12-28 09:06:00', '');
INSERT INTO `sys_menu` VALUES (2167, '勾选式批量同步用量', 2001, 24, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ConsumptionArr', '#', 'admin', '2022-01-10 10:24:57', 'admin', '2022-01-10 10:26:46', '');
INSERT INTO `sys_menu` VALUES (2168, '勾选式同步状态', 2001, 25, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:PublicMethodArr', '#', 'admin', '2022-01-10 10:25:15', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2169, '勾选式同步状态和用量', 2001, 26, '', NULL, 1, 0, 'F', '0', '0', 'yunze:card:ConsumptionAndStateArr', '#', 'admin', '2022-01-10 10:25:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2170, '获取自动化管理抄送名字', 2114, 4, '', NULL, 1, 0, 'F', '0', '0', 'yunze:cc:nameadd', '#', 'admin', '2022-01-12 10:41:45', '', NULL, '');

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice`  (
  `notice_id` int(0) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '公告标题',
  `notice_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob NULL COMMENT '公告内容',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '通知公告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_notice
-- ----------------------------

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log`  (
  `oper_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '模块标题',
  `business_type` int(0) NULL DEFAULT 0 COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '请求方式',
  `operator_type` int(0) NULL DEFAULT 0 COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '返回参数',
  `status` int(0) NULL DEFAULT 0 COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime(0) NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`oper_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5785 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '操作日志记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post`  (
  `post_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '岗位名称',
  `post_sort` int(0) NOT NULL COMMENT '显示顺序',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '岗位信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_post
-- ----------------------------
INSERT INTO `sys_post` VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');
INSERT INTO `sys_post` VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2021-06-05 09:12:09', '', NULL, '');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `role_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(0) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '部门树选择项是否关联显示',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2021-06-05 09:12:09', '', NULL, '超级管理员');
INSERT INTO `sys_role` VALUES (2, '企业客户', 'common', 2, '4', 1, 0, '0', '0', 'admin', '2021-06-05 09:12:09', '5iot', '2022-01-12 10:47:05', '普通角色');
INSERT INTO `sys_role` VALUES (3, '开发', 'development', 99, '1', 1, 1, '0', '0', 'admin', '2021-06-22 11:49:48', 'admin', '2021-11-19 10:46:15', NULL);
INSERT INTO `sys_role` VALUES (4, '用户', 'user', 3, '4', 1, 1, '0', '0', 'admin', '2021-06-25 09:11:37', 'admin', '2021-10-15 10:36:40', '3级');
INSERT INTO `sys_role` VALUES (5, '内部人员', 'adminUser', 5, '1', 0, 0, '0', '0', 'admin', '2021-07-06 10:17:03', '5iot', '2022-01-12 10:48:59', NULL);
INSERT INTO `sys_role` VALUES (6, '销售部经理', 'salesManager', 6, '1', 0, 0, '0', '0', 'admin', '2021-12-30 11:11:47', '5iot', '2022-01-12 10:49:40', NULL);
INSERT INTO `sys_role` VALUES (7, '销售业务员', 'Sales', 7, '1', 1, 1, '0', '0', 'admin', '2022-01-04 08:53:22', 'admin', '2022-01-05 17:25:45', NULL);
INSERT INTO `sys_role` VALUES (8, '仓库管理员', 'WarehouseManager', 8, '1', 1, 1, '0', '0', 'admin', '2022-01-04 14:02:35', 'admin', '2022-01-04 14:05:17', NULL);
INSERT INTO `sys_role` VALUES (9, '演示账号', 'testdome', 9, '1', 1, 1, '0', '0', 'admin', '2022-01-12 10:31:59', 'admin', '2022-01-12 11:18:24', NULL);

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept`  (
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(0) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`, `dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色和部门关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_dept
-- ----------------------------

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu`  (
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(0) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色和菜单关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES (2, 103);
INSERT INTO `sys_role_menu` VALUES (2, 1017);
INSERT INTO `sys_role_menu` VALUES (2, 1018);
INSERT INTO `sys_role_menu` VALUES (2, 1019);
INSERT INTO `sys_role_menu` VALUES (2, 2000);
INSERT INTO `sys_role_menu` VALUES (2, 2001);
INSERT INTO `sys_role_menu` VALUES (2, 2003);
INSERT INTO `sys_role_menu` VALUES (2, 2004);
INSERT INTO `sys_role_menu` VALUES (2, 2005);
INSERT INTO `sys_role_menu` VALUES (2, 2006);
INSERT INTO `sys_role_menu` VALUES (2, 2008);
INSERT INTO `sys_role_menu` VALUES (2, 2009);
INSERT INTO `sys_role_menu` VALUES (2, 2018);
INSERT INTO `sys_role_menu` VALUES (2, 2019);
INSERT INTO `sys_role_menu` VALUES (2, 2027);
INSERT INTO `sys_role_menu` VALUES (2, 2041);
INSERT INTO `sys_role_menu` VALUES (2, 2042);
INSERT INTO `sys_role_menu` VALUES (2, 2043);
INSERT INTO `sys_role_menu` VALUES (2, 2044);
INSERT INTO `sys_role_menu` VALUES (2, 2050);
INSERT INTO `sys_role_menu` VALUES (2, 2051);
INSERT INTO `sys_role_menu` VALUES (2, 2052);
INSERT INTO `sys_role_menu` VALUES (2, 2053);
INSERT INTO `sys_role_menu` VALUES (2, 2058);
INSERT INTO `sys_role_menu` VALUES (2, 2059);
INSERT INTO `sys_role_menu` VALUES (2, 2060);
INSERT INTO `sys_role_menu` VALUES (2, 2061);
INSERT INTO `sys_role_menu` VALUES (2, 2088);
INSERT INTO `sys_role_menu` VALUES (3, 1);
INSERT INTO `sys_role_menu` VALUES (3, 2);
INSERT INTO `sys_role_menu` VALUES (3, 3);
INSERT INTO `sys_role_menu` VALUES (3, 100);
INSERT INTO `sys_role_menu` VALUES (3, 101);
INSERT INTO `sys_role_menu` VALUES (3, 102);
INSERT INTO `sys_role_menu` VALUES (3, 103);
INSERT INTO `sys_role_menu` VALUES (3, 104);
INSERT INTO `sys_role_menu` VALUES (3, 105);
INSERT INTO `sys_role_menu` VALUES (3, 106);
INSERT INTO `sys_role_menu` VALUES (3, 107);
INSERT INTO `sys_role_menu` VALUES (3, 108);
INSERT INTO `sys_role_menu` VALUES (3, 109);
INSERT INTO `sys_role_menu` VALUES (3, 110);
INSERT INTO `sys_role_menu` VALUES (3, 111);
INSERT INTO `sys_role_menu` VALUES (3, 112);
INSERT INTO `sys_role_menu` VALUES (3, 113);
INSERT INTO `sys_role_menu` VALUES (3, 114);
INSERT INTO `sys_role_menu` VALUES (3, 115);
INSERT INTO `sys_role_menu` VALUES (3, 116);
INSERT INTO `sys_role_menu` VALUES (3, 500);
INSERT INTO `sys_role_menu` VALUES (3, 501);
INSERT INTO `sys_role_menu` VALUES (3, 1001);
INSERT INTO `sys_role_menu` VALUES (3, 1002);
INSERT INTO `sys_role_menu` VALUES (3, 1003);
INSERT INTO `sys_role_menu` VALUES (3, 1004);
INSERT INTO `sys_role_menu` VALUES (3, 1005);
INSERT INTO `sys_role_menu` VALUES (3, 1006);
INSERT INTO `sys_role_menu` VALUES (3, 1007);
INSERT INTO `sys_role_menu` VALUES (3, 1008);
INSERT INTO `sys_role_menu` VALUES (3, 1009);
INSERT INTO `sys_role_menu` VALUES (3, 1010);
INSERT INTO `sys_role_menu` VALUES (3, 1011);
INSERT INTO `sys_role_menu` VALUES (3, 1012);
INSERT INTO `sys_role_menu` VALUES (3, 1013);
INSERT INTO `sys_role_menu` VALUES (3, 1014);
INSERT INTO `sys_role_menu` VALUES (3, 1015);
INSERT INTO `sys_role_menu` VALUES (3, 1016);
INSERT INTO `sys_role_menu` VALUES (3, 1017);
INSERT INTO `sys_role_menu` VALUES (3, 1018);
INSERT INTO `sys_role_menu` VALUES (3, 1019);
INSERT INTO `sys_role_menu` VALUES (3, 1020);
INSERT INTO `sys_role_menu` VALUES (3, 1021);
INSERT INTO `sys_role_menu` VALUES (3, 1022);
INSERT INTO `sys_role_menu` VALUES (3, 1023);
INSERT INTO `sys_role_menu` VALUES (3, 1024);
INSERT INTO `sys_role_menu` VALUES (3, 1025);
INSERT INTO `sys_role_menu` VALUES (3, 1026);
INSERT INTO `sys_role_menu` VALUES (3, 1027);
INSERT INTO `sys_role_menu` VALUES (3, 1028);
INSERT INTO `sys_role_menu` VALUES (3, 1029);
INSERT INTO `sys_role_menu` VALUES (3, 1030);
INSERT INTO `sys_role_menu` VALUES (3, 1031);
INSERT INTO `sys_role_menu` VALUES (3, 1032);
INSERT INTO `sys_role_menu` VALUES (3, 1033);
INSERT INTO `sys_role_menu` VALUES (3, 1034);
INSERT INTO `sys_role_menu` VALUES (3, 1035);
INSERT INTO `sys_role_menu` VALUES (3, 1036);
INSERT INTO `sys_role_menu` VALUES (3, 1037);
INSERT INTO `sys_role_menu` VALUES (3, 1038);
INSERT INTO `sys_role_menu` VALUES (3, 1039);
INSERT INTO `sys_role_menu` VALUES (3, 1040);
INSERT INTO `sys_role_menu` VALUES (3, 1041);
INSERT INTO `sys_role_menu` VALUES (3, 1042);
INSERT INTO `sys_role_menu` VALUES (3, 1043);
INSERT INTO `sys_role_menu` VALUES (3, 1044);
INSERT INTO `sys_role_menu` VALUES (3, 1045);
INSERT INTO `sys_role_menu` VALUES (3, 1046);
INSERT INTO `sys_role_menu` VALUES (3, 1047);
INSERT INTO `sys_role_menu` VALUES (3, 1048);
INSERT INTO `sys_role_menu` VALUES (3, 1049);
INSERT INTO `sys_role_menu` VALUES (3, 1050);
INSERT INTO `sys_role_menu` VALUES (3, 1051);
INSERT INTO `sys_role_menu` VALUES (3, 1053);
INSERT INTO `sys_role_menu` VALUES (3, 1054);
INSERT INTO `sys_role_menu` VALUES (3, 1055);
INSERT INTO `sys_role_menu` VALUES (3, 1056);
INSERT INTO `sys_role_menu` VALUES (3, 1057);
INSERT INTO `sys_role_menu` VALUES (3, 1058);
INSERT INTO `sys_role_menu` VALUES (3, 1059);
INSERT INTO `sys_role_menu` VALUES (3, 1060);
INSERT INTO `sys_role_menu` VALUES (3, 2000);
INSERT INTO `sys_role_menu` VALUES (3, 2001);
INSERT INTO `sys_role_menu` VALUES (3, 2003);
INSERT INTO `sys_role_menu` VALUES (3, 2004);
INSERT INTO `sys_role_menu` VALUES (3, 2005);
INSERT INTO `sys_role_menu` VALUES (3, 2006);
INSERT INTO `sys_role_menu` VALUES (3, 2008);
INSERT INTO `sys_role_menu` VALUES (3, 2009);
INSERT INTO `sys_role_menu` VALUES (3, 2010);
INSERT INTO `sys_role_menu` VALUES (3, 2011);
INSERT INTO `sys_role_menu` VALUES (3, 2012);
INSERT INTO `sys_role_menu` VALUES (3, 2013);
INSERT INTO `sys_role_menu` VALUES (3, 2014);
INSERT INTO `sys_role_menu` VALUES (3, 2015);
INSERT INTO `sys_role_menu` VALUES (3, 2016);
INSERT INTO `sys_role_menu` VALUES (3, 2017);
INSERT INTO `sys_role_menu` VALUES (3, 2018);
INSERT INTO `sys_role_menu` VALUES (3, 2019);
INSERT INTO `sys_role_menu` VALUES (3, 2020);
INSERT INTO `sys_role_menu` VALUES (3, 2021);
INSERT INTO `sys_role_menu` VALUES (3, 2022);
INSERT INTO `sys_role_menu` VALUES (3, 2023);
INSERT INTO `sys_role_menu` VALUES (3, 2024);
INSERT INTO `sys_role_menu` VALUES (3, 2025);
INSERT INTO `sys_role_menu` VALUES (3, 2026);
INSERT INTO `sys_role_menu` VALUES (3, 2027);
INSERT INTO `sys_role_menu` VALUES (3, 2028);
INSERT INTO `sys_role_menu` VALUES (3, 2029);
INSERT INTO `sys_role_menu` VALUES (3, 2030);
INSERT INTO `sys_role_menu` VALUES (3, 2031);
INSERT INTO `sys_role_menu` VALUES (3, 2032);
INSERT INTO `sys_role_menu` VALUES (3, 2033);
INSERT INTO `sys_role_menu` VALUES (3, 2034);
INSERT INTO `sys_role_menu` VALUES (3, 2035);
INSERT INTO `sys_role_menu` VALUES (3, 2037);
INSERT INTO `sys_role_menu` VALUES (3, 2038);
INSERT INTO `sys_role_menu` VALUES (3, 2039);
INSERT INTO `sys_role_menu` VALUES (3, 2040);
INSERT INTO `sys_role_menu` VALUES (3, 2041);
INSERT INTO `sys_role_menu` VALUES (3, 2042);
INSERT INTO `sys_role_menu` VALUES (3, 2043);
INSERT INTO `sys_role_menu` VALUES (3, 2044);
INSERT INTO `sys_role_menu` VALUES (3, 2045);
INSERT INTO `sys_role_menu` VALUES (3, 2048);
INSERT INTO `sys_role_menu` VALUES (3, 2050);
INSERT INTO `sys_role_menu` VALUES (3, 2051);
INSERT INTO `sys_role_menu` VALUES (3, 2052);
INSERT INTO `sys_role_menu` VALUES (3, 2053);
INSERT INTO `sys_role_menu` VALUES (3, 2058);
INSERT INTO `sys_role_menu` VALUES (3, 2059);
INSERT INTO `sys_role_menu` VALUES (3, 2060);
INSERT INTO `sys_role_menu` VALUES (3, 2061);
INSERT INTO `sys_role_menu` VALUES (3, 2062);
INSERT INTO `sys_role_menu` VALUES (3, 2063);
INSERT INTO `sys_role_menu` VALUES (3, 2064);
INSERT INTO `sys_role_menu` VALUES (3, 2065);
INSERT INTO `sys_role_menu` VALUES (3, 2066);
INSERT INTO `sys_role_menu` VALUES (3, 2067);
INSERT INTO `sys_role_menu` VALUES (3, 2068);
INSERT INTO `sys_role_menu` VALUES (3, 2069);
INSERT INTO `sys_role_menu` VALUES (3, 2070);
INSERT INTO `sys_role_menu` VALUES (3, 2071);
INSERT INTO `sys_role_menu` VALUES (3, 2072);
INSERT INTO `sys_role_menu` VALUES (3, 2073);
INSERT INTO `sys_role_menu` VALUES (3, 2074);
INSERT INTO `sys_role_menu` VALUES (3, 2075);
INSERT INTO `sys_role_menu` VALUES (3, 2076);
INSERT INTO `sys_role_menu` VALUES (3, 2079);
INSERT INTO `sys_role_menu` VALUES (3, 2080);
INSERT INTO `sys_role_menu` VALUES (3, 2081);
INSERT INTO `sys_role_menu` VALUES (3, 2082);
INSERT INTO `sys_role_menu` VALUES (3, 2084);
INSERT INTO `sys_role_menu` VALUES (3, 2085);
INSERT INTO `sys_role_menu` VALUES (3, 2087);
INSERT INTO `sys_role_menu` VALUES (3, 2088);
INSERT INTO `sys_role_menu` VALUES (3, 2093);
INSERT INTO `sys_role_menu` VALUES (3, 2104);
INSERT INTO `sys_role_menu` VALUES (3, 2105);
INSERT INTO `sys_role_menu` VALUES (3, 2106);
INSERT INTO `sys_role_menu` VALUES (3, 2107);
INSERT INTO `sys_role_menu` VALUES (3, 2108);
INSERT INTO `sys_role_menu` VALUES (3, 2109);
INSERT INTO `sys_role_menu` VALUES (3, 2110);
INSERT INTO `sys_role_menu` VALUES (3, 2115);
INSERT INTO `sys_role_menu` VALUES (4, 2000);
INSERT INTO `sys_role_menu` VALUES (4, 2001);
INSERT INTO `sys_role_menu` VALUES (4, 2003);
INSERT INTO `sys_role_menu` VALUES (4, 2004);
INSERT INTO `sys_role_menu` VALUES (4, 2005);
INSERT INTO `sys_role_menu` VALUES (4, 2006);
INSERT INTO `sys_role_menu` VALUES (4, 2008);
INSERT INTO `sys_role_menu` VALUES (4, 2009);
INSERT INTO `sys_role_menu` VALUES (4, 2010);
INSERT INTO `sys_role_menu` VALUES (4, 2017);
INSERT INTO `sys_role_menu` VALUES (4, 2018);
INSERT INTO `sys_role_menu` VALUES (4, 2019);
INSERT INTO `sys_role_menu` VALUES (4, 2021);
INSERT INTO `sys_role_menu` VALUES (4, 2027);
INSERT INTO `sys_role_menu` VALUES (4, 2041);
INSERT INTO `sys_role_menu` VALUES (4, 2042);
INSERT INTO `sys_role_menu` VALUES (4, 2050);
INSERT INTO `sys_role_menu` VALUES (4, 2052);
INSERT INTO `sys_role_menu` VALUES (4, 2053);
INSERT INTO `sys_role_menu` VALUES (4, 2060);
INSERT INTO `sys_role_menu` VALUES (4, 2061);
INSERT INTO `sys_role_menu` VALUES (4, 2063);
INSERT INTO `sys_role_menu` VALUES (4, 2064);
INSERT INTO `sys_role_menu` VALUES (4, 2065);
INSERT INTO `sys_role_menu` VALUES (4, 2068);
INSERT INTO `sys_role_menu` VALUES (4, 2069);
INSERT INTO `sys_role_menu` VALUES (4, 2087);
INSERT INTO `sys_role_menu` VALUES (4, 2093);
INSERT INTO `sys_role_menu` VALUES (5, 1);
INSERT INTO `sys_role_menu` VALUES (5, 2);
INSERT INTO `sys_role_menu` VALUES (5, 3);
INSERT INTO `sys_role_menu` VALUES (5, 100);
INSERT INTO `sys_role_menu` VALUES (5, 101);
INSERT INTO `sys_role_menu` VALUES (5, 103);
INSERT INTO `sys_role_menu` VALUES (5, 109);
INSERT INTO `sys_role_menu` VALUES (5, 1001);
INSERT INTO `sys_role_menu` VALUES (5, 1002);
INSERT INTO `sys_role_menu` VALUES (5, 1003);
INSERT INTO `sys_role_menu` VALUES (5, 1004);
INSERT INTO `sys_role_menu` VALUES (5, 1005);
INSERT INTO `sys_role_menu` VALUES (5, 1006);
INSERT INTO `sys_role_menu` VALUES (5, 1007);
INSERT INTO `sys_role_menu` VALUES (5, 1008);
INSERT INTO `sys_role_menu` VALUES (5, 1017);
INSERT INTO `sys_role_menu` VALUES (5, 1018);
INSERT INTO `sys_role_menu` VALUES (5, 1019);
INSERT INTO `sys_role_menu` VALUES (5, 1046);
INSERT INTO `sys_role_menu` VALUES (5, 2000);
INSERT INTO `sys_role_menu` VALUES (5, 2001);
INSERT INTO `sys_role_menu` VALUES (5, 2003);
INSERT INTO `sys_role_menu` VALUES (5, 2004);
INSERT INTO `sys_role_menu` VALUES (5, 2005);
INSERT INTO `sys_role_menu` VALUES (5, 2006);
INSERT INTO `sys_role_menu` VALUES (5, 2008);
INSERT INTO `sys_role_menu` VALUES (5, 2009);
INSERT INTO `sys_role_menu` VALUES (5, 2010);
INSERT INTO `sys_role_menu` VALUES (5, 2011);
INSERT INTO `sys_role_menu` VALUES (5, 2012);
INSERT INTO `sys_role_menu` VALUES (5, 2013);
INSERT INTO `sys_role_menu` VALUES (5, 2014);
INSERT INTO `sys_role_menu` VALUES (5, 2015);
INSERT INTO `sys_role_menu` VALUES (5, 2016);
INSERT INTO `sys_role_menu` VALUES (5, 2017);
INSERT INTO `sys_role_menu` VALUES (5, 2018);
INSERT INTO `sys_role_menu` VALUES (5, 2019);
INSERT INTO `sys_role_menu` VALUES (5, 2020);
INSERT INTO `sys_role_menu` VALUES (5, 2021);
INSERT INTO `sys_role_menu` VALUES (5, 2022);
INSERT INTO `sys_role_menu` VALUES (5, 2023);
INSERT INTO `sys_role_menu` VALUES (5, 2024);
INSERT INTO `sys_role_menu` VALUES (5, 2025);
INSERT INTO `sys_role_menu` VALUES (5, 2026);
INSERT INTO `sys_role_menu` VALUES (5, 2027);
INSERT INTO `sys_role_menu` VALUES (5, 2028);
INSERT INTO `sys_role_menu` VALUES (5, 2029);
INSERT INTO `sys_role_menu` VALUES (5, 2030);
INSERT INTO `sys_role_menu` VALUES (5, 2031);
INSERT INTO `sys_role_menu` VALUES (5, 2032);
INSERT INTO `sys_role_menu` VALUES (5, 2033);
INSERT INTO `sys_role_menu` VALUES (5, 2034);
INSERT INTO `sys_role_menu` VALUES (5, 2035);
INSERT INTO `sys_role_menu` VALUES (5, 2037);
INSERT INTO `sys_role_menu` VALUES (5, 2038);
INSERT INTO `sys_role_menu` VALUES (5, 2039);
INSERT INTO `sys_role_menu` VALUES (5, 2040);
INSERT INTO `sys_role_menu` VALUES (5, 2041);
INSERT INTO `sys_role_menu` VALUES (5, 2042);
INSERT INTO `sys_role_menu` VALUES (5, 2043);
INSERT INTO `sys_role_menu` VALUES (5, 2044);
INSERT INTO `sys_role_menu` VALUES (5, 2045);
INSERT INTO `sys_role_menu` VALUES (5, 2048);
INSERT INTO `sys_role_menu` VALUES (5, 2050);
INSERT INTO `sys_role_menu` VALUES (5, 2051);
INSERT INTO `sys_role_menu` VALUES (5, 2052);
INSERT INTO `sys_role_menu` VALUES (5, 2053);
INSERT INTO `sys_role_menu` VALUES (5, 2058);
INSERT INTO `sys_role_menu` VALUES (5, 2059);
INSERT INTO `sys_role_menu` VALUES (5, 2060);
INSERT INTO `sys_role_menu` VALUES (5, 2061);
INSERT INTO `sys_role_menu` VALUES (5, 2062);
INSERT INTO `sys_role_menu` VALUES (5, 2063);
INSERT INTO `sys_role_menu` VALUES (5, 2064);
INSERT INTO `sys_role_menu` VALUES (5, 2065);
INSERT INTO `sys_role_menu` VALUES (5, 2066);
INSERT INTO `sys_role_menu` VALUES (5, 2067);
INSERT INTO `sys_role_menu` VALUES (5, 2068);
INSERT INTO `sys_role_menu` VALUES (5, 2069);
INSERT INTO `sys_role_menu` VALUES (5, 2070);
INSERT INTO `sys_role_menu` VALUES (5, 2071);
INSERT INTO `sys_role_menu` VALUES (5, 2072);
INSERT INTO `sys_role_menu` VALUES (5, 2073);
INSERT INTO `sys_role_menu` VALUES (5, 2074);
INSERT INTO `sys_role_menu` VALUES (5, 2075);
INSERT INTO `sys_role_menu` VALUES (5, 2076);
INSERT INTO `sys_role_menu` VALUES (5, 2079);
INSERT INTO `sys_role_menu` VALUES (5, 2080);
INSERT INTO `sys_role_menu` VALUES (5, 2081);
INSERT INTO `sys_role_menu` VALUES (5, 2082);
INSERT INTO `sys_role_menu` VALUES (5, 2084);
INSERT INTO `sys_role_menu` VALUES (5, 2085);
INSERT INTO `sys_role_menu` VALUES (5, 2087);
INSERT INTO `sys_role_menu` VALUES (5, 2088);
INSERT INTO `sys_role_menu` VALUES (5, 2089);
INSERT INTO `sys_role_menu` VALUES (5, 2090);
INSERT INTO `sys_role_menu` VALUES (5, 2093);
INSERT INTO `sys_role_menu` VALUES (5, 2102);
INSERT INTO `sys_role_menu` VALUES (5, 2104);
INSERT INTO `sys_role_menu` VALUES (5, 2105);
INSERT INTO `sys_role_menu` VALUES (5, 2106);
INSERT INTO `sys_role_menu` VALUES (5, 2107);
INSERT INTO `sys_role_menu` VALUES (5, 2109);
INSERT INTO `sys_role_menu` VALUES (5, 2110);
INSERT INTO `sys_role_menu` VALUES (5, 2115);
INSERT INTO `sys_role_menu` VALUES (5, 2116);
INSERT INTO `sys_role_menu` VALUES (5, 2120);
INSERT INTO `sys_role_menu` VALUES (5, 2123);
INSERT INTO `sys_role_menu` VALUES (5, 2124);
INSERT INTO `sys_role_menu` VALUES (5, 2125);
INSERT INTO `sys_role_menu` VALUES (5, 2129);
INSERT INTO `sys_role_menu` VALUES (5, 2130);
INSERT INTO `sys_role_menu` VALUES (5, 2131);
INSERT INTO `sys_role_menu` VALUES (5, 2132);
INSERT INTO `sys_role_menu` VALUES (5, 2134);
INSERT INTO `sys_role_menu` VALUES (5, 2135);
INSERT INTO `sys_role_menu` VALUES (5, 2136);
INSERT INTO `sys_role_menu` VALUES (5, 2137);
INSERT INTO `sys_role_menu` VALUES (5, 2138);
INSERT INTO `sys_role_menu` VALUES (5, 2139);
INSERT INTO `sys_role_menu` VALUES (5, 2140);
INSERT INTO `sys_role_menu` VALUES (5, 2141);
INSERT INTO `sys_role_menu` VALUES (5, 2142);
INSERT INTO `sys_role_menu` VALUES (5, 2143);
INSERT INTO `sys_role_menu` VALUES (5, 2144);
INSERT INTO `sys_role_menu` VALUES (5, 2145);
INSERT INTO `sys_role_menu` VALUES (5, 2148);
INSERT INTO `sys_role_menu` VALUES (5, 2149);
INSERT INTO `sys_role_menu` VALUES (5, 2150);
INSERT INTO `sys_role_menu` VALUES (5, 2152);
INSERT INTO `sys_role_menu` VALUES (5, 2153);
INSERT INTO `sys_role_menu` VALUES (5, 2154);
INSERT INTO `sys_role_menu` VALUES (5, 2155);
INSERT INTO `sys_role_menu` VALUES (5, 2156);
INSERT INTO `sys_role_menu` VALUES (5, 2157);
INSERT INTO `sys_role_menu` VALUES (5, 2158);
INSERT INTO `sys_role_menu` VALUES (5, 2159);
INSERT INTO `sys_role_menu` VALUES (5, 2161);
INSERT INTO `sys_role_menu` VALUES (5, 2162);
INSERT INTO `sys_role_menu` VALUES (5, 2163);
INSERT INTO `sys_role_menu` VALUES (5, 2164);
INSERT INTO `sys_role_menu` VALUES (5, 2167);
INSERT INTO `sys_role_menu` VALUES (5, 2168);
INSERT INTO `sys_role_menu` VALUES (5, 2169);
INSERT INTO `sys_role_menu` VALUES (6, 2105);
INSERT INTO `sys_role_menu` VALUES (6, 2118);
INSERT INTO `sys_role_menu` VALUES (6, 2119);
INSERT INTO `sys_role_menu` VALUES (6, 2121);
INSERT INTO `sys_role_menu` VALUES (6, 2125);
INSERT INTO `sys_role_menu` VALUES (6, 2166);
INSERT INTO `sys_role_menu` VALUES (7, 2105);
INSERT INTO `sys_role_menu` VALUES (7, 2119);
INSERT INTO `sys_role_menu` VALUES (7, 2125);
INSERT INTO `sys_role_menu` VALUES (7, 2165);
INSERT INTO `sys_role_menu` VALUES (8, 2090);
INSERT INTO `sys_role_menu` VALUES (8, 2105);
INSERT INTO `sys_role_menu` VALUES (8, 2116);
INSERT INTO `sys_role_menu` VALUES (8, 2117);
INSERT INTO `sys_role_menu` VALUES (8, 2123);
INSERT INTO `sys_role_menu` VALUES (8, 2124);
INSERT INTO `sys_role_menu` VALUES (8, 2125);
INSERT INTO `sys_role_menu` VALUES (8, 2126);
INSERT INTO `sys_role_menu` VALUES (8, 2127);
INSERT INTO `sys_role_menu` VALUES (8, 2128);
INSERT INTO `sys_role_menu` VALUES (8, 2129);
INSERT INTO `sys_role_menu` VALUES (8, 2140);
INSERT INTO `sys_role_menu` VALUES (8, 2141);
INSERT INTO `sys_role_menu` VALUES (8, 2142);
INSERT INTO `sys_role_menu` VALUES (8, 2143);
INSERT INTO `sys_role_menu` VALUES (8, 2144);
INSERT INTO `sys_role_menu` VALUES (8, 2145);
INSERT INTO `sys_role_menu` VALUES (8, 2146);
INSERT INTO `sys_role_menu` VALUES (8, 2147);
INSERT INTO `sys_role_menu` VALUES (8, 2148);
INSERT INTO `sys_role_menu` VALUES (8, 2149);
INSERT INTO `sys_role_menu` VALUES (8, 2150);
INSERT INTO `sys_role_menu` VALUES (8, 2151);
INSERT INTO `sys_role_menu` VALUES (8, 2152);
INSERT INTO `sys_role_menu` VALUES (8, 2157);
INSERT INTO `sys_role_menu` VALUES (8, 2159);
INSERT INTO `sys_role_menu` VALUES (8, 2160);
INSERT INTO `sys_role_menu` VALUES (8, 2162);
INSERT INTO `sys_role_menu` VALUES (8, 2163);
INSERT INTO `sys_role_menu` VALUES (8, 2164);
INSERT INTO `sys_role_menu` VALUES (9, 1);
INSERT INTO `sys_role_menu` VALUES (9, 2);
INSERT INTO `sys_role_menu` VALUES (9, 3);
INSERT INTO `sys_role_menu` VALUES (9, 100);
INSERT INTO `sys_role_menu` VALUES (9, 101);
INSERT INTO `sys_role_menu` VALUES (9, 102);
INSERT INTO `sys_role_menu` VALUES (9, 103);
INSERT INTO `sys_role_menu` VALUES (9, 104);
INSERT INTO `sys_role_menu` VALUES (9, 105);
INSERT INTO `sys_role_menu` VALUES (9, 106);
INSERT INTO `sys_role_menu` VALUES (9, 108);
INSERT INTO `sys_role_menu` VALUES (9, 110);
INSERT INTO `sys_role_menu` VALUES (9, 114);
INSERT INTO `sys_role_menu` VALUES (9, 115);
INSERT INTO `sys_role_menu` VALUES (9, 116);
INSERT INTO `sys_role_menu` VALUES (9, 1001);
INSERT INTO `sys_role_menu` VALUES (9, 1002);
INSERT INTO `sys_role_menu` VALUES (9, 1006);
INSERT INTO `sys_role_menu` VALUES (9, 1008);
INSERT INTO `sys_role_menu` VALUES (9, 1009);
INSERT INTO `sys_role_menu` VALUES (9, 1013);
INSERT INTO `sys_role_menu` VALUES (9, 1014);
INSERT INTO `sys_role_menu` VALUES (9, 1015);
INSERT INTO `sys_role_menu` VALUES (9, 1017);
INSERT INTO `sys_role_menu` VALUES (9, 1018);
INSERT INTO `sys_role_menu` VALUES (9, 1019);
INSERT INTO `sys_role_menu` VALUES (9, 1021);
INSERT INTO `sys_role_menu` VALUES (9, 1022);
INSERT INTO `sys_role_menu` VALUES (9, 1023);
INSERT INTO `sys_role_menu` VALUES (9, 1026);
INSERT INTO `sys_role_menu` VALUES (9, 1027);
INSERT INTO `sys_role_menu` VALUES (9, 1028);
INSERT INTO `sys_role_menu` VALUES (9, 1031);
INSERT INTO `sys_role_menu` VALUES (9, 1032);
INSERT INTO `sys_role_menu` VALUES (9, 1033);
INSERT INTO `sys_role_menu` VALUES (9, 1049);
INSERT INTO `sys_role_menu` VALUES (9, 1055);
INSERT INTO `sys_role_menu` VALUES (9, 2000);
INSERT INTO `sys_role_menu` VALUES (9, 2001);
INSERT INTO `sys_role_menu` VALUES (9, 2003);
INSERT INTO `sys_role_menu` VALUES (9, 2004);
INSERT INTO `sys_role_menu` VALUES (9, 2005);
INSERT INTO `sys_role_menu` VALUES (9, 2006);
INSERT INTO `sys_role_menu` VALUES (9, 2008);
INSERT INTO `sys_role_menu` VALUES (9, 2009);
INSERT INTO `sys_role_menu` VALUES (9, 2010);
INSERT INTO `sys_role_menu` VALUES (9, 2011);
INSERT INTO `sys_role_menu` VALUES (9, 2012);
INSERT INTO `sys_role_menu` VALUES (9, 2013);
INSERT INTO `sys_role_menu` VALUES (9, 2014);
INSERT INTO `sys_role_menu` VALUES (9, 2015);
INSERT INTO `sys_role_menu` VALUES (9, 2017);
INSERT INTO `sys_role_menu` VALUES (9, 2018);
INSERT INTO `sys_role_menu` VALUES (9, 2019);
INSERT INTO `sys_role_menu` VALUES (9, 2020);
INSERT INTO `sys_role_menu` VALUES (9, 2021);
INSERT INTO `sys_role_menu` VALUES (9, 2022);
INSERT INTO `sys_role_menu` VALUES (9, 2023);
INSERT INTO `sys_role_menu` VALUES (9, 2024);
INSERT INTO `sys_role_menu` VALUES (9, 2025);
INSERT INTO `sys_role_menu` VALUES (9, 2026);
INSERT INTO `sys_role_menu` VALUES (9, 2027);
INSERT INTO `sys_role_menu` VALUES (9, 2028);
INSERT INTO `sys_role_menu` VALUES (9, 2029);
INSERT INTO `sys_role_menu` VALUES (9, 2030);
INSERT INTO `sys_role_menu` VALUES (9, 2034);
INSERT INTO `sys_role_menu` VALUES (9, 2037);
INSERT INTO `sys_role_menu` VALUES (9, 2038);
INSERT INTO `sys_role_menu` VALUES (9, 2039);
INSERT INTO `sys_role_menu` VALUES (9, 2040);
INSERT INTO `sys_role_menu` VALUES (9, 2041);
INSERT INTO `sys_role_menu` VALUES (9, 2042);
INSERT INTO `sys_role_menu` VALUES (9, 2043);
INSERT INTO `sys_role_menu` VALUES (9, 2050);
INSERT INTO `sys_role_menu` VALUES (9, 2051);
INSERT INTO `sys_role_menu` VALUES (9, 2052);
INSERT INTO `sys_role_menu` VALUES (9, 2053);
INSERT INTO `sys_role_menu` VALUES (9, 2058);
INSERT INTO `sys_role_menu` VALUES (9, 2059);
INSERT INTO `sys_role_menu` VALUES (9, 2060);
INSERT INTO `sys_role_menu` VALUES (9, 2061);
INSERT INTO `sys_role_menu` VALUES (9, 2062);
INSERT INTO `sys_role_menu` VALUES (9, 2063);
INSERT INTO `sys_role_menu` VALUES (9, 2064);
INSERT INTO `sys_role_menu` VALUES (9, 2065);
INSERT INTO `sys_role_menu` VALUES (9, 2066);
INSERT INTO `sys_role_menu` VALUES (9, 2067);
INSERT INTO `sys_role_menu` VALUES (9, 2068);
INSERT INTO `sys_role_menu` VALUES (9, 2069);
INSERT INTO `sys_role_menu` VALUES (9, 2070);
INSERT INTO `sys_role_menu` VALUES (9, 2071);
INSERT INTO `sys_role_menu` VALUES (9, 2072);
INSERT INTO `sys_role_menu` VALUES (9, 2073);
INSERT INTO `sys_role_menu` VALUES (9, 2074);
INSERT INTO `sys_role_menu` VALUES (9, 2075);
INSERT INTO `sys_role_menu` VALUES (9, 2076);
INSERT INTO `sys_role_menu` VALUES (9, 2079);
INSERT INTO `sys_role_menu` VALUES (9, 2080);
INSERT INTO `sys_role_menu` VALUES (9, 2081);
INSERT INTO `sys_role_menu` VALUES (9, 2082);
INSERT INTO `sys_role_menu` VALUES (9, 2084);
INSERT INTO `sys_role_menu` VALUES (9, 2085);
INSERT INTO `sys_role_menu` VALUES (9, 2086);
INSERT INTO `sys_role_menu` VALUES (9, 2087);
INSERT INTO `sys_role_menu` VALUES (9, 2088);
INSERT INTO `sys_role_menu` VALUES (9, 2089);
INSERT INTO `sys_role_menu` VALUES (9, 2093);
INSERT INTO `sys_role_menu` VALUES (9, 2102);
INSERT INTO `sys_role_menu` VALUES (9, 2104);
INSERT INTO `sys_role_menu` VALUES (9, 2106);
INSERT INTO `sys_role_menu` VALUES (9, 2108);
INSERT INTO `sys_role_menu` VALUES (9, 2109);
INSERT INTO `sys_role_menu` VALUES (9, 2110);
INSERT INTO `sys_role_menu` VALUES (9, 2111);
INSERT INTO `sys_role_menu` VALUES (9, 2112);
INSERT INTO `sys_role_menu` VALUES (9, 2113);
INSERT INTO `sys_role_menu` VALUES (9, 2114);
INSERT INTO `sys_role_menu` VALUES (9, 2137);
INSERT INTO `sys_role_menu` VALUES (9, 2153);
INSERT INTO `sys_role_menu` VALUES (9, 2154);
INSERT INTO `sys_role_menu` VALUES (9, 2155);
INSERT INTO `sys_role_menu` VALUES (9, 2156);
INSERT INTO `sys_role_menu` VALUES (9, 2167);
INSERT INTO `sys_role_menu` VALUES (9, 2168);
INSERT INTO `sys_role_menu` VALUES (9, 2169);
INSERT INTO `sys_role_menu` VALUES (9, 2170);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `user_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(0) NULL DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '手机号码',
  `sex` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '密码',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime(0) NULL DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `isSales` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '是否销售',
  `isPartner` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '是否合伙人',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 335 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 100, 'admin', '管理员', '00', '', '15888888899', '0', '/profile/avatar/2022/01/12/86bb5301-5e36-4e6a-bc9c-d83d345ff6e5.jpeg', '$2a$10$6rlILudDyVDrQZ5emMCNj.GWPlMNeXA2eK9qUkfuAZabOF/YzYaJS', '0', '0', '120.224.39.28', '2022-01-12 10:44:02', 'admin', '2021-06-05 09:12:09', '', '2022-01-12 10:44:02', '管理员', '1', '1');
INSERT INTO `sys_user` VALUES (100, 100, '5iot', '演示账号', '00', 'yunye@5iot.cn', '', '0', '', '$2a$10$Z03ZGxYMD.p3qk3bKQTQcOCr42DcuDhDVnAa9vgxidpB823psbmSS', '0', '0', '120.224.39.28', '2022-01-12 10:53:33', 'admin', '2021-06-11 09:11:25', '5iot', '2022-01-12 10:53:32', '演示账号', '0', '0');

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post`  (
  `user_id` bigint(0) NOT NULL COMMENT '用户ID',
  `post_id` bigint(0) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`, `post_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户与岗位关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
INSERT INTO `sys_user_post` VALUES (1, 1);
INSERT INTO `sys_user_post` VALUES (2, 2);
INSERT INTO `sys_user_post` VALUES (102, 4);
INSERT INTO `sys_user_post` VALUES (166, 4);
INSERT INTO `sys_user_post` VALUES (241, 1);
INSERT INTO `sys_user_post` VALUES (243, 1);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `user_id` bigint(0) NOT NULL COMMENT '用户ID',
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户和角色关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES (1, 1);
INSERT INTO `sys_user_role` VALUES (2, 2);
INSERT INTO `sys_user_role` VALUES (100, 9);
INSERT INTO `sys_user_role` VALUES (102, 3);
INSERT INTO `sys_user_role` VALUES (104, 2);
INSERT INTO `sys_user_role` VALUES (104, 4);
INSERT INTO `sys_user_role` VALUES (107, 4);
INSERT INTO `sys_user_role` VALUES (108, 4);
INSERT INTO `sys_user_role` VALUES (109, 5);
INSERT INTO `sys_user_role` VALUES (109, 6);
INSERT INTO `sys_user_role` VALUES (110, 5);
INSERT INTO `sys_user_role` VALUES (110, 7);
INSERT INTO `sys_user_role` VALUES (111, 2);
INSERT INTO `sys_user_role` VALUES (111, 4);
INSERT INTO `sys_user_role` VALUES (112, 2);
INSERT INTO `sys_user_role` VALUES (112, 4);
INSERT INTO `sys_user_role` VALUES (113, 5);
INSERT INTO `sys_user_role` VALUES (113, 8);
INSERT INTO `sys_user_role` VALUES (114, 2);
INSERT INTO `sys_user_role` VALUES (114, 4);
INSERT INTO `sys_user_role` VALUES (115, 4);
INSERT INTO `sys_user_role` VALUES (117, 2);
INSERT INTO `sys_user_role` VALUES (117, 4);
INSERT INTO `sys_user_role` VALUES (118, 2);
INSERT INTO `sys_user_role` VALUES (118, 4);
INSERT INTO `sys_user_role` VALUES (119, 2);
INSERT INTO `sys_user_role` VALUES (119, 4);
INSERT INTO `sys_user_role` VALUES (120, 2);
INSERT INTO `sys_user_role` VALUES (120, 4);
INSERT INTO `sys_user_role` VALUES (121, 2);
INSERT INTO `sys_user_role` VALUES (121, 4);
INSERT INTO `sys_user_role` VALUES (122, 2);
INSERT INTO `sys_user_role` VALUES (122, 4);
INSERT INTO `sys_user_role` VALUES (123, 2);
INSERT INTO `sys_user_role` VALUES (123, 4);
INSERT INTO `sys_user_role` VALUES (124, 2);
INSERT INTO `sys_user_role` VALUES (125, 2);
INSERT INTO `sys_user_role` VALUES (125, 4);
INSERT INTO `sys_user_role` VALUES (126, 4);
INSERT INTO `sys_user_role` VALUES (128, 2);
INSERT INTO `sys_user_role` VALUES (128, 4);
INSERT INTO `sys_user_role` VALUES (129, 2);
INSERT INTO `sys_user_role` VALUES (129, 4);
INSERT INTO `sys_user_role` VALUES (130, 2);
INSERT INTO `sys_user_role` VALUES (130, 4);
INSERT INTO `sys_user_role` VALUES (131, 2);
INSERT INTO `sys_user_role` VALUES (131, 4);
INSERT INTO `sys_user_role` VALUES (132, 2);
INSERT INTO `sys_user_role` VALUES (132, 4);
INSERT INTO `sys_user_role` VALUES (133, 2);
INSERT INTO `sys_user_role` VALUES (133, 4);
INSERT INTO `sys_user_role` VALUES (134, 2);
INSERT INTO `sys_user_role` VALUES (134, 4);
INSERT INTO `sys_user_role` VALUES (135, 2);
INSERT INTO `sys_user_role` VALUES (135, 4);
INSERT INTO `sys_user_role` VALUES (136, 2);
INSERT INTO `sys_user_role` VALUES (136, 4);
INSERT INTO `sys_user_role` VALUES (137, 2);
INSERT INTO `sys_user_role` VALUES (137, 4);
INSERT INTO `sys_user_role` VALUES (138, 2);
INSERT INTO `sys_user_role` VALUES (138, 4);
INSERT INTO `sys_user_role` VALUES (139, 2);
INSERT INTO `sys_user_role` VALUES (139, 4);
INSERT INTO `sys_user_role` VALUES (140, 2);
INSERT INTO `sys_user_role` VALUES (140, 4);
INSERT INTO `sys_user_role` VALUES (141, 2);
INSERT INTO `sys_user_role` VALUES (141, 4);
INSERT INTO `sys_user_role` VALUES (142, 2);
INSERT INTO `sys_user_role` VALUES (142, 4);
INSERT INTO `sys_user_role` VALUES (143, 2);
INSERT INTO `sys_user_role` VALUES (143, 4);
INSERT INTO `sys_user_role` VALUES (144, 2);
INSERT INTO `sys_user_role` VALUES (144, 4);
INSERT INTO `sys_user_role` VALUES (145, 2);
INSERT INTO `sys_user_role` VALUES (145, 4);
INSERT INTO `sys_user_role` VALUES (146, 2);
INSERT INTO `sys_user_role` VALUES (146, 4);
INSERT INTO `sys_user_role` VALUES (148, 2);
INSERT INTO `sys_user_role` VALUES (148, 4);
INSERT INTO `sys_user_role` VALUES (150, 2);
INSERT INTO `sys_user_role` VALUES (150, 4);
INSERT INTO `sys_user_role` VALUES (151, 2);
INSERT INTO `sys_user_role` VALUES (151, 4);
INSERT INTO `sys_user_role` VALUES (152, 2);
INSERT INTO `sys_user_role` VALUES (152, 4);
INSERT INTO `sys_user_role` VALUES (154, 2);
INSERT INTO `sys_user_role` VALUES (154, 4);
INSERT INTO `sys_user_role` VALUES (155, 2);
INSERT INTO `sys_user_role` VALUES (155, 4);
INSERT INTO `sys_user_role` VALUES (156, 2);
INSERT INTO `sys_user_role` VALUES (156, 4);
INSERT INTO `sys_user_role` VALUES (157, 2);
INSERT INTO `sys_user_role` VALUES (157, 4);
INSERT INTO `sys_user_role` VALUES (158, 2);
INSERT INTO `sys_user_role` VALUES (158, 4);
INSERT INTO `sys_user_role` VALUES (159, 2);
INSERT INTO `sys_user_role` VALUES (159, 4);
INSERT INTO `sys_user_role` VALUES (160, 2);
INSERT INTO `sys_user_role` VALUES (160, 4);
INSERT INTO `sys_user_role` VALUES (161, 2);
INSERT INTO `sys_user_role` VALUES (161, 4);
INSERT INTO `sys_user_role` VALUES (163, 2);
INSERT INTO `sys_user_role` VALUES (163, 4);
INSERT INTO `sys_user_role` VALUES (164, 2);
INSERT INTO `sys_user_role` VALUES (164, 4);
INSERT INTO `sys_user_role` VALUES (165, 2);
INSERT INTO `sys_user_role` VALUES (165, 4);
INSERT INTO `sys_user_role` VALUES (166, 3);
INSERT INTO `sys_user_role` VALUES (167, 2);
INSERT INTO `sys_user_role` VALUES (167, 4);
INSERT INTO `sys_user_role` VALUES (168, 4);
INSERT INTO `sys_user_role` VALUES (170, 4);
INSERT INTO `sys_user_role` VALUES (171, 4);
INSERT INTO `sys_user_role` VALUES (172, 2);
INSERT INTO `sys_user_role` VALUES (172, 4);
INSERT INTO `sys_user_role` VALUES (173, 2);
INSERT INTO `sys_user_role` VALUES (173, 4);
INSERT INTO `sys_user_role` VALUES (174, 2);
INSERT INTO `sys_user_role` VALUES (174, 4);
INSERT INTO `sys_user_role` VALUES (175, 2);
INSERT INTO `sys_user_role` VALUES (175, 4);
INSERT INTO `sys_user_role` VALUES (176, 2);
INSERT INTO `sys_user_role` VALUES (176, 4);
INSERT INTO `sys_user_role` VALUES (177, 5);
INSERT INTO `sys_user_role` VALUES (178, 4);
INSERT INTO `sys_user_role` VALUES (179, 3);
INSERT INTO `sys_user_role` VALUES (181, 2);
INSERT INTO `sys_user_role` VALUES (181, 4);
INSERT INTO `sys_user_role` VALUES (183, 2);
INSERT INTO `sys_user_role` VALUES (183, 4);
INSERT INTO `sys_user_role` VALUES (184, 2);
INSERT INTO `sys_user_role` VALUES (184, 4);
INSERT INTO `sys_user_role` VALUES (185, 4);
INSERT INTO `sys_user_role` VALUES (186, 2);
INSERT INTO `sys_user_role` VALUES (186, 4);
INSERT INTO `sys_user_role` VALUES (187, 2);
INSERT INTO `sys_user_role` VALUES (187, 4);
INSERT INTO `sys_user_role` VALUES (188, 2);
INSERT INTO `sys_user_role` VALUES (188, 4);
INSERT INTO `sys_user_role` VALUES (189, 2);
INSERT INTO `sys_user_role` VALUES (189, 4);
INSERT INTO `sys_user_role` VALUES (190, 2);
INSERT INTO `sys_user_role` VALUES (190, 4);
INSERT INTO `sys_user_role` VALUES (191, 2);
INSERT INTO `sys_user_role` VALUES (191, 4);
INSERT INTO `sys_user_role` VALUES (192, 2);
INSERT INTO `sys_user_role` VALUES (192, 4);
INSERT INTO `sys_user_role` VALUES (194, 2);
INSERT INTO `sys_user_role` VALUES (194, 4);
INSERT INTO `sys_user_role` VALUES (195, 2);
INSERT INTO `sys_user_role` VALUES (195, 4);
INSERT INTO `sys_user_role` VALUES (196, 2);
INSERT INTO `sys_user_role` VALUES (196, 4);
INSERT INTO `sys_user_role` VALUES (197, 2);
INSERT INTO `sys_user_role` VALUES (197, 4);
INSERT INTO `sys_user_role` VALUES (198, 2);
INSERT INTO `sys_user_role` VALUES (198, 4);
INSERT INTO `sys_user_role` VALUES (199, 2);
INSERT INTO `sys_user_role` VALUES (199, 4);
INSERT INTO `sys_user_role` VALUES (200, 2);
INSERT INTO `sys_user_role` VALUES (200, 4);
INSERT INTO `sys_user_role` VALUES (201, 2);
INSERT INTO `sys_user_role` VALUES (201, 4);
INSERT INTO `sys_user_role` VALUES (202, 2);
INSERT INTO `sys_user_role` VALUES (202, 4);
INSERT INTO `sys_user_role` VALUES (203, 5);
INSERT INTO `sys_user_role` VALUES (203, 7);
INSERT INTO `sys_user_role` VALUES (204, 5);
INSERT INTO `sys_user_role` VALUES (204, 7);
INSERT INTO `sys_user_role` VALUES (205, 5);
INSERT INTO `sys_user_role` VALUES (205, 7);
INSERT INTO `sys_user_role` VALUES (206, 2);
INSERT INTO `sys_user_role` VALUES (206, 4);
INSERT INTO `sys_user_role` VALUES (207, 2);
INSERT INTO `sys_user_role` VALUES (207, 4);
INSERT INTO `sys_user_role` VALUES (208, 2);
INSERT INTO `sys_user_role` VALUES (208, 4);
INSERT INTO `sys_user_role` VALUES (209, 2);
INSERT INTO `sys_user_role` VALUES (209, 4);
INSERT INTO `sys_user_role` VALUES (210, 2);
INSERT INTO `sys_user_role` VALUES (210, 4);
INSERT INTO `sys_user_role` VALUES (211, 2);
INSERT INTO `sys_user_role` VALUES (211, 4);
INSERT INTO `sys_user_role` VALUES (212, 2);
INSERT INTO `sys_user_role` VALUES (212, 4);
INSERT INTO `sys_user_role` VALUES (213, 2);
INSERT INTO `sys_user_role` VALUES (213, 4);
INSERT INTO `sys_user_role` VALUES (214, 2);
INSERT INTO `sys_user_role` VALUES (214, 4);
INSERT INTO `sys_user_role` VALUES (215, 2);
INSERT INTO `sys_user_role` VALUES (215, 4);
INSERT INTO `sys_user_role` VALUES (216, 2);
INSERT INTO `sys_user_role` VALUES (216, 4);
INSERT INTO `sys_user_role` VALUES (217, 2);
INSERT INTO `sys_user_role` VALUES (217, 4);
INSERT INTO `sys_user_role` VALUES (218, 2);
INSERT INTO `sys_user_role` VALUES (218, 4);
INSERT INTO `sys_user_role` VALUES (219, 2);
INSERT INTO `sys_user_role` VALUES (219, 4);
INSERT INTO `sys_user_role` VALUES (220, 2);
INSERT INTO `sys_user_role` VALUES (220, 4);
INSERT INTO `sys_user_role` VALUES (222, 2);
INSERT INTO `sys_user_role` VALUES (222, 4);
INSERT INTO `sys_user_role` VALUES (223, 2);
INSERT INTO `sys_user_role` VALUES (223, 4);
INSERT INTO `sys_user_role` VALUES (224, 2);
INSERT INTO `sys_user_role` VALUES (224, 4);
INSERT INTO `sys_user_role` VALUES (225, 2);
INSERT INTO `sys_user_role` VALUES (225, 4);
INSERT INTO `sys_user_role` VALUES (226, 2);
INSERT INTO `sys_user_role` VALUES (226, 4);
INSERT INTO `sys_user_role` VALUES (228, 4);
INSERT INTO `sys_user_role` VALUES (229, 4);
INSERT INTO `sys_user_role` VALUES (230, 2);
INSERT INTO `sys_user_role` VALUES (230, 4);
INSERT INTO `sys_user_role` VALUES (231, 2);
INSERT INTO `sys_user_role` VALUES (231, 4);
INSERT INTO `sys_user_role` VALUES (232, 2);
INSERT INTO `sys_user_role` VALUES (232, 4);
INSERT INTO `sys_user_role` VALUES (233, 2);
INSERT INTO `sys_user_role` VALUES (233, 4);
INSERT INTO `sys_user_role` VALUES (234, 2);
INSERT INTO `sys_user_role` VALUES (234, 4);
INSERT INTO `sys_user_role` VALUES (235, 2);
INSERT INTO `sys_user_role` VALUES (235, 4);
INSERT INTO `sys_user_role` VALUES (236, 2);
INSERT INTO `sys_user_role` VALUES (236, 4);
INSERT INTO `sys_user_role` VALUES (237, 2);
INSERT INTO `sys_user_role` VALUES (237, 4);
INSERT INTO `sys_user_role` VALUES (238, 2);
INSERT INTO `sys_user_role` VALUES (238, 4);
INSERT INTO `sys_user_role` VALUES (239, 2);
INSERT INTO `sys_user_role` VALUES (239, 4);
INSERT INTO `sys_user_role` VALUES (240, 2);
INSERT INTO `sys_user_role` VALUES (240, 4);
INSERT INTO `sys_user_role` VALUES (241, 4);
INSERT INTO `sys_user_role` VALUES (242, 2);
INSERT INTO `sys_user_role` VALUES (242, 4);
INSERT INTO `sys_user_role` VALUES (243, 2);
INSERT INTO `sys_user_role` VALUES (243, 4);
INSERT INTO `sys_user_role` VALUES (244, 2);
INSERT INTO `sys_user_role` VALUES (244, 4);
INSERT INTO `sys_user_role` VALUES (245, 2);
INSERT INTO `sys_user_role` VALUES (245, 4);
INSERT INTO `sys_user_role` VALUES (246, 4);
INSERT INTO `sys_user_role` VALUES (247, 2);
INSERT INTO `sys_user_role` VALUES (247, 4);
INSERT INTO `sys_user_role` VALUES (248, 2);
INSERT INTO `sys_user_role` VALUES (248, 4);
INSERT INTO `sys_user_role` VALUES (249, 2);
INSERT INTO `sys_user_role` VALUES (249, 4);
INSERT INTO `sys_user_role` VALUES (250, 2);
INSERT INTO `sys_user_role` VALUES (250, 4);
INSERT INTO `sys_user_role` VALUES (251, 2);
INSERT INTO `sys_user_role` VALUES (251, 4);
INSERT INTO `sys_user_role` VALUES (252, 2);
INSERT INTO `sys_user_role` VALUES (252, 4);
INSERT INTO `sys_user_role` VALUES (253, 2);
INSERT INTO `sys_user_role` VALUES (253, 4);
INSERT INTO `sys_user_role` VALUES (254, 2);
INSERT INTO `sys_user_role` VALUES (254, 4);
INSERT INTO `sys_user_role` VALUES (255, 2);
INSERT INTO `sys_user_role` VALUES (255, 4);
INSERT INTO `sys_user_role` VALUES (256, 2);
INSERT INTO `sys_user_role` VALUES (256, 4);
INSERT INTO `sys_user_role` VALUES (257, 2);
INSERT INTO `sys_user_role` VALUES (257, 4);
INSERT INTO `sys_user_role` VALUES (258, 2);
INSERT INTO `sys_user_role` VALUES (258, 4);
INSERT INTO `sys_user_role` VALUES (259, 2);
INSERT INTO `sys_user_role` VALUES (259, 4);
INSERT INTO `sys_user_role` VALUES (260, 2);
INSERT INTO `sys_user_role` VALUES (260, 4);
INSERT INTO `sys_user_role` VALUES (261, 2);
INSERT INTO `sys_user_role` VALUES (261, 4);
INSERT INTO `sys_user_role` VALUES (262, 2);
INSERT INTO `sys_user_role` VALUES (262, 4);
INSERT INTO `sys_user_role` VALUES (263, 2);
INSERT INTO `sys_user_role` VALUES (263, 4);
INSERT INTO `sys_user_role` VALUES (264, 2);
INSERT INTO `sys_user_role` VALUES (264, 4);
INSERT INTO `sys_user_role` VALUES (265, 2);
INSERT INTO `sys_user_role` VALUES (265, 4);
INSERT INTO `sys_user_role` VALUES (266, 2);
INSERT INTO `sys_user_role` VALUES (266, 4);
INSERT INTO `sys_user_role` VALUES (267, 2);
INSERT INTO `sys_user_role` VALUES (267, 4);
INSERT INTO `sys_user_role` VALUES (268, 2);
INSERT INTO `sys_user_role` VALUES (268, 4);
INSERT INTO `sys_user_role` VALUES (269, 2);
INSERT INTO `sys_user_role` VALUES (269, 4);
INSERT INTO `sys_user_role` VALUES (270, 2);
INSERT INTO `sys_user_role` VALUES (270, 4);
INSERT INTO `sys_user_role` VALUES (271, 2);
INSERT INTO `sys_user_role` VALUES (271, 4);
INSERT INTO `sys_user_role` VALUES (272, 2);
INSERT INTO `sys_user_role` VALUES (272, 4);
INSERT INTO `sys_user_role` VALUES (273, 2);
INSERT INTO `sys_user_role` VALUES (273, 4);
INSERT INTO `sys_user_role` VALUES (274, 2);
INSERT INTO `sys_user_role` VALUES (274, 4);
INSERT INTO `sys_user_role` VALUES (275, 2);
INSERT INTO `sys_user_role` VALUES (275, 4);
INSERT INTO `sys_user_role` VALUES (276, 2);
INSERT INTO `sys_user_role` VALUES (276, 4);
INSERT INTO `sys_user_role` VALUES (277, 2);
INSERT INTO `sys_user_role` VALUES (277, 4);
INSERT INTO `sys_user_role` VALUES (278, 2);
INSERT INTO `sys_user_role` VALUES (278, 4);
INSERT INTO `sys_user_role` VALUES (279, 2);
INSERT INTO `sys_user_role` VALUES (279, 4);
INSERT INTO `sys_user_role` VALUES (280, 2);
INSERT INTO `sys_user_role` VALUES (280, 4);
INSERT INTO `sys_user_role` VALUES (281, 2);
INSERT INTO `sys_user_role` VALUES (281, 4);
INSERT INTO `sys_user_role` VALUES (282, 2);
INSERT INTO `sys_user_role` VALUES (282, 4);
INSERT INTO `sys_user_role` VALUES (285, 2);
INSERT INTO `sys_user_role` VALUES (285, 4);
INSERT INTO `sys_user_role` VALUES (286, 2);
INSERT INTO `sys_user_role` VALUES (286, 4);
INSERT INTO `sys_user_role` VALUES (287, 2);
INSERT INTO `sys_user_role` VALUES (287, 4);
INSERT INTO `sys_user_role` VALUES (288, 2);
INSERT INTO `sys_user_role` VALUES (288, 4);
INSERT INTO `sys_user_role` VALUES (289, 2);
INSERT INTO `sys_user_role` VALUES (289, 4);
INSERT INTO `sys_user_role` VALUES (290, 4);
INSERT INTO `sys_user_role` VALUES (291, 2);
INSERT INTO `sys_user_role` VALUES (291, 4);
INSERT INTO `sys_user_role` VALUES (292, 2);
INSERT INTO `sys_user_role` VALUES (292, 4);
INSERT INTO `sys_user_role` VALUES (293, 2);
INSERT INTO `sys_user_role` VALUES (293, 4);
INSERT INTO `sys_user_role` VALUES (294, 2);
INSERT INTO `sys_user_role` VALUES (294, 4);
INSERT INTO `sys_user_role` VALUES (295, 2);
INSERT INTO `sys_user_role` VALUES (295, 4);
INSERT INTO `sys_user_role` VALUES (296, 2);
INSERT INTO `sys_user_role` VALUES (296, 4);
INSERT INTO `sys_user_role` VALUES (297, 2);
INSERT INTO `sys_user_role` VALUES (297, 4);
INSERT INTO `sys_user_role` VALUES (298, 2);
INSERT INTO `sys_user_role` VALUES (298, 4);
INSERT INTO `sys_user_role` VALUES (299, 2);
INSERT INTO `sys_user_role` VALUES (299, 4);
INSERT INTO `sys_user_role` VALUES (300, 2);
INSERT INTO `sys_user_role` VALUES (300, 4);
INSERT INTO `sys_user_role` VALUES (301, 2);
INSERT INTO `sys_user_role` VALUES (301, 4);
INSERT INTO `sys_user_role` VALUES (302, 2);
INSERT INTO `sys_user_role` VALUES (302, 4);
INSERT INTO `sys_user_role` VALUES (303, 2);
INSERT INTO `sys_user_role` VALUES (303, 4);
INSERT INTO `sys_user_role` VALUES (304, 2);
INSERT INTO `sys_user_role` VALUES (304, 4);
INSERT INTO `sys_user_role` VALUES (305, 2);
INSERT INTO `sys_user_role` VALUES (305, 4);
INSERT INTO `sys_user_role` VALUES (306, 2);
INSERT INTO `sys_user_role` VALUES (306, 4);
INSERT INTO `sys_user_role` VALUES (307, 2);
INSERT INTO `sys_user_role` VALUES (307, 4);
INSERT INTO `sys_user_role` VALUES (308, 2);
INSERT INTO `sys_user_role` VALUES (308, 4);
INSERT INTO `sys_user_role` VALUES (309, 2);
INSERT INTO `sys_user_role` VALUES (309, 4);
INSERT INTO `sys_user_role` VALUES (310, 2);
INSERT INTO `sys_user_role` VALUES (310, 4);
INSERT INTO `sys_user_role` VALUES (311, 2);
INSERT INTO `sys_user_role` VALUES (311, 4);
INSERT INTO `sys_user_role` VALUES (312, 2);
INSERT INTO `sys_user_role` VALUES (312, 4);
INSERT INTO `sys_user_role` VALUES (313, 2);
INSERT INTO `sys_user_role` VALUES (313, 4);
INSERT INTO `sys_user_role` VALUES (314, 2);
INSERT INTO `sys_user_role` VALUES (314, 4);
INSERT INTO `sys_user_role` VALUES (315, 2);
INSERT INTO `sys_user_role` VALUES (315, 4);
INSERT INTO `sys_user_role` VALUES (316, 2);
INSERT INTO `sys_user_role` VALUES (316, 4);
INSERT INTO `sys_user_role` VALUES (317, 2);
INSERT INTO `sys_user_role` VALUES (317, 4);
INSERT INTO `sys_user_role` VALUES (318, 2);
INSERT INTO `sys_user_role` VALUES (318, 4);
INSERT INTO `sys_user_role` VALUES (319, 2);
INSERT INTO `sys_user_role` VALUES (319, 4);
INSERT INTO `sys_user_role` VALUES (320, 2);
INSERT INTO `sys_user_role` VALUES (320, 4);
INSERT INTO `sys_user_role` VALUES (321, 2);
INSERT INTO `sys_user_role` VALUES (321, 4);
INSERT INTO `sys_user_role` VALUES (322, 2);
INSERT INTO `sys_user_role` VALUES (322, 4);
INSERT INTO `sys_user_role` VALUES (323, 4);
INSERT INTO `sys_user_role` VALUES (324, 2);
INSERT INTO `sys_user_role` VALUES (324, 4);
INSERT INTO `sys_user_role` VALUES (325, 2);
INSERT INTO `sys_user_role` VALUES (325, 4);
INSERT INTO `sys_user_role` VALUES (326, 2);
INSERT INTO `sys_user_role` VALUES (326, 4);
INSERT INTO `sys_user_role` VALUES (327, 2);
INSERT INTO `sys_user_role` VALUES (327, 4);
INSERT INTO `sys_user_role` VALUES (328, 2);
INSERT INTO `sys_user_role` VALUES (328, 4);
INSERT INTO `sys_user_role` VALUES (329, 2);
INSERT INTO `sys_user_role` VALUES (329, 4);
INSERT INTO `sys_user_role` VALUES (330, 2);
INSERT INTO `sys_user_role` VALUES (330, 4);
INSERT INTO `sys_user_role` VALUES (331, 2);
INSERT INTO `sys_user_role` VALUES (331, 4);
INSERT INTO `sys_user_role` VALUES (332, 2);
INSERT INTO `sys_user_role` VALUES (332, 4);
INSERT INTO `sys_user_role` VALUES (333, 2);
INSERT INTO `sys_user_role` VALUES (333, 4);
INSERT INTO `sys_user_role` VALUES (334, 2);
INSERT INTO `sys_user_role` VALUES (334, 4);

-- ----------------------------
-- Table structure for yz_agent_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_agent_package`;
CREATE TABLE `yz_agent_package`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐唯一识别号',
  `package_agentname` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理商查看名称',
  `package_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐名',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `error_so` double(10, 2) NULL DEFAULT 1.00 COMMENT '套餐SO',
  `dept_id` int(0) NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证 (所属公司)',
  `user_id` int(0) NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证（所属人）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 62 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '资费组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_agent_package
-- ----------------------------

-- ----------------------------
-- Table structure for yz_agent_packet
-- ----------------------------
DROP TABLE IF EXISTS `yz_agent_packet`;
CREATE TABLE `yz_agent_packet`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐ID',
  `packet_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐包ID',
  `packet_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '套餐包名',
  `packet_wx_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信端显示名称',
  `packet_price` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包金额',
  `packet_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包流量',
  `base_packet_type` int(0) NULL DEFAULT 0 COMMENT '资费计划 类型 0:仅一次，1可叠加',
  `packet_type` int(0) NULL DEFAULT 0 COMMENT '加油包类型：0基础加油包-1叠加油包',
  `is_profit` int(0) NULL DEFAULT 0 COMMENT '是否分润：0否 1是',
  `show_profit` int(0) NULL DEFAULT 0 COMMENT '是否显示分润：0否-1是',
  `wechat_pay` int(0) NULL DEFAULT 1 COMMENT '是否可微信支付：0否1是',
  `balance_pay` int(0) NULL DEFAULT 0 COMMENT '是否可余额支付：0否-1是',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐流量',
  `error_so` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包SO倍数',
  `packet_valid_time` int(0) NULL DEFAULT NULL COMMENT '资费计划规格\r\n\r\n，根据packet_valid_name定义，表示为月或年',
  `packet_cost` double(10, 2) NULL DEFAULT NULL COMMENT '成本价',
  `is_month` int(0) NULL DEFAULT NULL COMMENT '是否分月到账：0否 1是',
  `date_limit` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '限制不可充值日期',
  `deduction` int(0) NULL DEFAULT NULL COMMENT '是否支持 自动扣代理预存授信延续',
  `in_stock` int(0) NULL DEFAULT NULL COMMENT '是否在售 0 否 1 是',
  `packet_valid_type` int(0) NULL DEFAULT NULL COMMENT '资费计划生效类型 当月生效 yunze_card_takeEffect_type',
  `dept_id` int(0) NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int(0) NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `packet_valid_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '月' COMMENT '资费计划规则 月 年 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 103 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '资费计划' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_agent_packet
-- ----------------------------

-- ----------------------------
-- Table structure for yz_automation_cc
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc`;
CREATE TABLE `yz_automation_cc`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `trigger_type` int(0) NOT NULL COMMENT '触发类型',
  `channel_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '通道id',
  `operation_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '运营商类型',
  `triggering_conditions` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '判断条件',
  `conditions_type` int(0) NULL DEFAULT NULL COMMENT '条件类型',
  `execution_type` int(0) NOT NULL COMMENT '执行动作类型',
  `status` int(0) NOT NULL COMMENT '状态',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `execution_template` int(0) NOT NULL COMMENT '执行模板',
  `dep_id` int(0) NOT NULL COMMENT '所属企业',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `cc_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '抄送名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '自动化抄送' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_automation_cc
-- ----------------------------
INSERT INTO `yz_automation_cc` VALUES (1, 99, NULL, NULL, NULL, NULL, 1, 1, NULL, 1, 100, '2021-09-24 15:58:36', '');

-- ----------------------------
-- Table structure for yz_automation_cc_his
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc_his`;
CREATE TABLE `yz_automation_cc_his`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `cc_id` int(0) NOT NULL COMMENT '抄送任务id',
  `cc_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送API',
  `cc_email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送邮件',
  `cc_state` int(0) NOT NULL COMMENT '抄送状态',
  `cc_result` int(0) NOT NULL COMMENT '抄送结果',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `cc_parameter` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '抄送参数',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `cc_count` int(0) UNSIGNED NOT NULL DEFAULT 0 COMMENT '抄送次数',
  `cc_time` datetime(0) NULL DEFAULT NULL COMMENT '最近一次抄送时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '推送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_automation_cc_his
-- ----------------------------

-- ----------------------------
-- Table structure for yz_automation_cc_url
-- ----------------------------
DROP TABLE IF EXISTS `yz_automation_cc_url`;
CREATE TABLE `yz_automation_cc_url`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `cc_id` int(0) NOT NULL COMMENT '对应自动化规则表',
  `url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送API',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '推送邮件',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '触发任务推送地址邮箱配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_automation_cc_url
-- ----------------------------
INSERT INTO `yz_automation_cc_url` VALUES (1, 1, '', 'yunye@5iot.cn', '2021-09-24 15:59:00');

-- ----------------------------
-- Table structure for yz_by_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_by_package`;
CREATE TABLE `yz_by_package`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐唯一识别号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '购卡资费组关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_by_package
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_flow
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_flow`;
CREATE TABLE `yz_card_flow`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '充值套餐',
  `packet_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '充值流量包',
  `ord_no` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单号',
  `true_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '真实流量，显示在前端的',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '虚后流量，后台以此作控制',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '生效时间',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '到期时间',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `ord_type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '资费计划 月包 年包 包规格类型',
  `status` int(0) NULL DEFAULT 0 COMMENT '状态：0已失效-2未生效-1生效',
  `packet_type` int(0) NOT NULL COMMENT '叠加包 基础包',
  `use_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '使用流量（针对累计卡保存）',
  `iccid` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '对应串号',
  `error_time` double(30, 2) NOT NULL COMMENT '防超系数',
  `validate_type` int(0) NULL DEFAULT NULL COMMENT '资费生效类别：当月生效，次月生效，周期延顺',
  `validate_time` datetime(0) NULL DEFAULT NULL COMMENT '更新累计包时间',
  `use_true_flow` double(10, 2) NULL DEFAULT NULL COMMENT '天包真实已用流量',
  `use_so_flow` double(10, 2) NULL DEFAULT NULL COMMENT '天包记录已用流量so',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `IDU_Busi_iccid_ord_no`(`iccid`, `ord_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1256704 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '流量包记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_flow
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_flow_his
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_flow_his`;
CREATE TABLE `yz_card_flow_his`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `total_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '当月使用总量 接口',
  `total_flow_now` double(10, 2) NULL DEFAULT 0.00 COMMENT '当天使用总量 接口',
  `month` int(0) NOT NULL COMMENT '月份',
  `year` int(0) NOT NULL COMMENT '年份',
  `day` int(0) NOT NULL COMMENT '日',
  `iccid` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '对应串号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `total_show_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '当月使用总量 展示用',
  `total_show_flow_now` double(10, 2) NULL DEFAULT 0.00 COMMENT '当天使用总量 展示用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `sel_id`(`id`) USING BTREE,
  INDEX `find_iccid`(`iccid`, `year`, `month`, `day`) USING BTREE,
  INDEX `IDU_Busi_iccid_create_time_update_time`(`create_time`, `update_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 26142703 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '历史流量使用记录表' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of yz_card_flow_his
-- ----------------------------
INSERT INTO `yz_card_flow_his` VALUES (26142701, 0.00, 0.00, 1, 2022, 10, '89860799999999999999', '2022-01-10 17:14:08', '2022-01-10 18:00:12', 0.00, 0.00);
INSERT INTO `yz_card_flow_his` VALUES (26142702, 0.00, 0.00, 1, 2022, 11, '89860799999999999999', '2022-01-11 09:45:30', NULL, 0.00, 0.00);

-- ----------------------------
-- Table structure for yz_card_info
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_info`;
CREATE TABLE `yz_card_info`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `vid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '虚拟编号',
  `msisdn` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SIM 号码',
  `iccid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'SIM 卡号',
  `imsi` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SIM 识别码',
  `open_date` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '开卡日期',
  `activate_date` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '激活日期',
  `agent_id` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理编号',
  `channel_id` int(0) NULL DEFAULT NULL COMMENT '通道编号',
  `is_pool` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '是否流量池',
  `pool_id` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流量池编号',
  `remind_ratio` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提醒阈值',
  `virtual_ratio` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '虚量阈值',
  `batch_date` varchar(0) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '入库日期',
  `syn_Time` datetime(0) NULL DEFAULT NULL COMMENT '同步时间',
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `create_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新者',
  `update_date` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `del_flag` tinyint(1) NULL DEFAULT 0 COMMENT '删除标记',
  `status_id` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '卡状态描述',
  `package_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资费组',
  `used` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '账期用量',
  `remaining` double(10, 2) NOT NULL DEFAULT 0.00 COMMENT '剩余用量',
  `deliver_date` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发货日期',
  `imei` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'IMEI',
  `type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '卡类型 对应字典表',
  `network_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '网络类型 对应字典表',
  `is_sms` int(0) NULL DEFAULT NULL COMMENT '是否支持短信发送',
  `sms_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '短信服务号码',
  `gprs` int(0) NULL DEFAULT NULL COMMENT 'GPRS是否开启',
  `dept_id` int(0) NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int(0) NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `out_of_stock` date NULL DEFAULT NULL COMMENT '出库日期',
  `is_Disconnected` int(0) NULL DEFAULT NULL COMMENT '未订购资费 是否 轮询断网',
  `connection_status` int(0) NULL DEFAULT NULL COMMENT '断开网状态',
  `customize_grouping` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '自定义分组',
  `remarks` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `due_expire_time` datetime(0) NULL DEFAULT NULL COMMENT '到期时间',
  `status_ShowId` int(0) NULL DEFAULT NULL COMMENT '卡状状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `IDU_Busi_Card_id`(`id`) USING BTREE,
  UNIQUE INDEX `iccid_sel`(`iccid`) USING BTREE,
  INDEX `IDU_Busi_Card_vid`(`vid`) USING BTREE,
  INDEX `IDU_Busi_Card_imsi`(`imsi`) USING BTREE,
  INDEX `IDU_Busi_Card_msisdn`(`msisdn`) USING BTREE,
  INDEX `IDU_Busi_Card_status_id`(`status_id`) USING BTREE,
  INDEX `IDU_Busi_Card_iccid_used_remaining`(`used`, `customize_grouping`) USING BTREE,
  INDEX `IDU_Busi_Card_agent_id_user_id_iccid`(`agent_id`, `user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1129786 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '模块-智能卡信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_info
-- ----------------------------
INSERT INTO `yz_card_info` VALUES (1129785, '16800000001', '1069999999999', '89860799999999999999', NULL, NULL, '2021-02-01', '100', 1, '0', NULL, NULL, NULL, NULL, '2022-01-11 09:45:30', ' [ 总企业 ] -  [ admin ] ', '2022-01-10 17:14:00', NULL, NULL, 0, '1', NULL, 0.00, 0.00, NULL, NULL, NULL, NULL, 0, NULL, 0, 100, 1, NULL, NULL, NULL, NULL, NULL, NULL, 4);

-- ----------------------------
-- Table structure for yz_card_info_change
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_info_change`;
CREATE TABLE `yz_card_info_change`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `iccid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ctype` int(0) NOT NULL COMMENT '变更类型',
  `cbefore` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更前',
  `cafterward` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '变更后',
  `createTime` datetime(0) NOT NULL COMMENT '创建时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `source_type` int(0) NOT NULL COMMENT '来源类型',
  `execution_status` int(0) NOT NULL COMMENT '执行状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1502631 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '卡状态变更记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_info_change
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_isstop
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_isstop`;
CREATE TABLE `yz_card_isstop`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `iccid` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '串号',
  `order_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '唯一订单号',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '状态',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '月初复机有用量 记录\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_isstop
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_operating
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_operating`;
CREATE TABLE `yz_card_operating`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `create_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `create_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新者',
  `update_date` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `operating` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作说明',
  `operating_type` int(0) NULL DEFAULT NULL COMMENT '操作类型 对应字典',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '卡信息操作表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_operating
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_package
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_package`;
CREATE TABLE `yz_card_package`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐唯一识别号',
  `package_agentname` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理商查看名称',
  `package_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐名',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `error_so` double(10, 2) NULL DEFAULT 1.00 COMMENT '套餐SO',
  `dept_id` int(0) NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证 (所属公司)',
  `user_id` int(0) NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证（所属人）',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `package_id`(`package_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '资费组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_package
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_packet
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_packet`;
CREATE TABLE `yz_card_packet`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `package_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐ID',
  `packet_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '套餐包ID',
  `packet_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '套餐包名',
  `packet_wx_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信端显示名称',
  `packet_price` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包金额',
  `packet_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包流量',
  `base_packet_type` int(0) NULL DEFAULT 0 COMMENT '资费计划 类型 0:仅一次，1可叠加',
  `packet_type` int(0) NULL DEFAULT 0 COMMENT '加油包类型：0基础加油包-1叠加油包',
  `is_profit` int(0) NULL DEFAULT 0 COMMENT '是否分润：0否 1是',
  `show_profit` int(0) NULL DEFAULT 0 COMMENT '是否显示分润：0否-1是',
  `wechat_pay` int(0) NULL DEFAULT 1 COMMENT '是否可微信支付：0否1是',
  `balance_pay` int(0) NULL DEFAULT 0 COMMENT '是否可余额支付：0否-1是',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `error_flow` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐流量',
  `error_so` double(10, 2) NULL DEFAULT 0.00 COMMENT '套餐包SO倍数',
  `packet_valid_time` int(0) NULL DEFAULT NULL COMMENT '资费计划规格\r\n\r\n，根据packet_valid_name定义，表示为月或年',
  `packet_cost` double(10, 2) NULL DEFAULT NULL COMMENT '成本价',
  `is_month` int(0) NULL DEFAULT NULL COMMENT '是否分月到账：0否 1是',
  `date_limit` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '限制不可充值日期',
  `deduction` int(0) NULL DEFAULT NULL COMMENT '是否支持 自动扣代理预存授信延续',
  `in_stock` int(0) NULL DEFAULT NULL COMMENT '是否在售 0 否 1 是',
  `packet_valid_type` int(0) NULL DEFAULT NULL COMMENT '资费计划生效类型 当月生效 yunze_card_takeEffect_type',
  `dept_id` int(0) NULL DEFAULT NULL COMMENT '代理编号 与 agent_id 一致 但需要用于系统结构 数据验证',
  `user_id` int(0) NULL DEFAULT NULL COMMENT '系统登录账户id 用于系统结构数据验证',
  `packet_valid_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '月' COMMENT '资费计划规则 月 年 ',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `packet_id`(`packet_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 99 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '资费计划' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_packet
-- ----------------------------

-- ----------------------------
-- Table structure for yz_card_route
-- ----------------------------
DROP TABLE IF EXISTS `yz_card_route`;
CREATE TABLE `yz_card_route`  (
  `cd_id` int(0) NOT NULL AUTO_INCREMENT,
  `cd_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道编号',
  `cd_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `cd_username` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道注册用户名',
  `cd_pwd` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道用户登录密码',
  `cd_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道key码',
  `cd_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道url',
  `cd_operator_type` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '运营商类型1移动2联通3电信4其他',
  `cd_concurrency` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '线程数',
  `cd_lunxun` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否轮训:0否1是',
  `cd_control_type` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'API请求 控制类型 0 无 1 内部请求',
  `cd_max_use` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '达量断网阈值',
  `createTime` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `cd_delete` datetime(0) NULL DEFAULT NULL COMMENT '删除时间',
  `cd_agent_id` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理商id',
  `cd_status` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道状态 1 启用 2 停用 3 已删除',
  `cd_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通道别名 ',
  PRIMARY KEY (`cd_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 55 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '通道表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_card_route
-- ----------------------------
INSERT INTO `yz_card_route` VALUES (1, 'YiDong_EC', '济南移动', '200222222221111', 'Fjkio@33fffG', '1', NULL, '1', NULL, '0', NULL, NULL, '2022-01-10 16:55:13', '2022-01-11 10:23:33', NULL, '100', '2', '中国移动01');

-- ----------------------------
-- Table structure for yz_execution_task
-- ----------------------------
DROP TABLE IF EXISTS `yz_execution_task`;
CREATE TABLE `yz_execution_task`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NOT NULL,
  `update_time` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `start_time` datetime(0) NOT NULL COMMENT '开始时间',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间',
  `task_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务名',
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务下载地址 1,2,3',
  `auth` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务创建人',
  `agent_id` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '代理编号',
  `type` int(0) NULL DEFAULT NULL COMMENT '任务类别',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2060 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '执行任务表 系统下载 上传任务\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_execution_task
-- ----------------------------

-- ----------------------------
-- Table structure for yz_order
-- ----------------------------
DROP TABLE IF EXISTS `yz_order`;
CREATE TABLE `yz_order`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ord_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '唯一订单号',
  `ord_type` int(0) NULL DEFAULT 0 COMMENT '订单类型:1金额充值\r\n-2用量充值',
  `ord_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '交易名称：账户充值-流量加油包',
  `iccid` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '串号',
  `wx_ord_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信订单号',
  `status` int(0) NULL DEFAULT 0 COMMENT '支付状态：0未支付-1支付成功-2加包成功-3退订',
  `price` double(10, 2) NULL DEFAULT 0.00 COMMENT '交易金额',
  `account` double(10, 2) NULL DEFAULT 0.00 COMMENT '交易后金额',
  `packet_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '交易流量包，充值填0',
  `pay_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '支付方式：w微信支付-b余额支付-s平台记录',
  `cre_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '生成方式：sys系统-man人工',
  `is_profit` int(0) NULL DEFAULT 0 COMMENT '是否需要分润：0否-1是',
  `add_package` int(0) NULL DEFAULT 0 COMMENT '是否已经执行过加包 0否 1 是',
  `show_status` int(0) NULL DEFAULT 0 COMMENT '是否显示交易记录:0否-1显示',
  `open_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'openid',
  `agent_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '代理商id',
  `profit_type` int(0) NULL DEFAULT 0 COMMENT '分润类型：0否-1分润比-2差价',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `validate_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生效类型：yunze_card_takeEffect_type',
  `info` varchar(3000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `add_parameter` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '加包参数 需要加包时获取',
  `add_package_time` datetime(0) NULL DEFAULT NULL COMMENT '加包执行时间',
  `del_flag` tinyint(1) NULL DEFAULT 0 COMMENT '删除标记',
  `is_profit_sharing` tinyint(1) NULL DEFAULT NULL COMMENT '是否已分润 0否 1 是',
  `profit_sharing_time` datetime(0) NULL DEFAULT NULL COMMENT '分润执行时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ord_no`(`ord_no`) USING BTREE,
  INDEX `agent_id_idx`(`agent_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 452017 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单表' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of yz_order
-- ----------------------------

-- ----------------------------
-- Table structure for yz_passageway_polling
-- ----------------------------
DROP TABLE IF EXISTS `yz_passageway_polling`;
CREATE TABLE `yz_passageway_polling`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cd_id` int(0) NOT NULL COMMENT '通道编号',
  `create_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `upd_date` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `cd_count` int(0) NOT NULL COMMENT '轮序总数',
  `cd_current` int(0) NULL DEFAULT NULL COMMENT '当前轮序数量',
  `polling_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '轮序批次编码',
  `syn_date` datetime(0) NULL DEFAULT NULL COMMENT '最近一次同步时间',
  `polling_type` int(0) NULL DEFAULT NULL COMMENT '轮询类型 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 70714 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '通道轮序详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_passageway_polling
-- ----------------------------
INSERT INTO `yz_passageway_polling` VALUES (70711, 1, '2022-01-10 17:22:33', '2022-01-10 17:30:05', 1, 1, '202201100522305358', '2022-01-10 17:30:05', 3);
INSERT INTO `yz_passageway_polling` VALUES (70712, 1, '2022-01-10 17:26:14', '2022-01-10 17:30:05', 1, 1, '202201100526106680', '2022-01-10 17:30:05', 2);
INSERT INTO `yz_passageway_polling` VALUES (70713, 1, '2022-01-10 18:00:10', '2022-01-10 18:10:05', 1, 1, '202201100600077073', '2022-01-10 18:10:05', 3);

-- ----------------------------
-- Table structure for yz_sys_logs
-- ----------------------------
DROP TABLE IF EXISTS `yz_sys_logs`;
CREATE TABLE `yz_sys_logs`  (
  `id` char(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `res_url` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '请求url',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `class_method` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '执行的类方法',
  `ip` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ip',
  `request_args` longblob NOT NULL COMMENT '请求参数',
  `response_args` longblob NOT NULL COMMENT '响应参数',
  `user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '操作人',
  `project` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块',
  `action_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作名称'
) ENGINE = InnoDB AUTO_INCREMENT = 8517830 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统级日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of yz_sys_logs
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
