/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils.json;

import com.cu.api.internal.utils.StringUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class JSONWriter {
    private StringBuffer buf = new StringBuffer();
    private Stack<Object> calls = new Stack();
    private boolean emitClassName = true;
    private boolean useApiStyle = false;
    static char[] hex = "0123456789ABCDEF".toCharArray();

    public JSONWriter(boolean emitClassName) {
        this.emitClassName = emitClassName;
    }

    public JSONWriter(boolean emitClassName, boolean useApiStyle) {
        this(emitClassName);
        this.useApiStyle = useApiStyle;
    }

    public JSONWriter() {
        this(false);
    }

    public String write(Object object) {
        this.buf.setLength(0);
        this.value(object);
        return this.buf.toString();
    }

    public String write(long n) {
        return String.valueOf(n);
    }

    public String write(double d) {
        return String.valueOf(d);
    }

    public String write(char c) {
        return "\"" + c + "\"";
    }

    public String write(boolean b) {
        return String.valueOf(b);
    }

    private void value(Object object) {
        if (object == null || this.cyclic(object)) {
            this.add(null);
        } else {
            this.calls.push(object);
            if (object instanceof Class) {
                this.string(object);
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(object);
            } else if (object instanceof Iterator) {
                this.array((Iterator)object);
            } else if (object instanceof Collection) {
                this.array(((Collection)object).iterator());
            } else if (object instanceof Date) {
                this.date((Date)object);
            } else {
                this.bean(object);
            }
            this.calls.pop();
        }
    }

    private boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private void bean(Object object) {
        this.add("{");
        boolean addedSomething = false;
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            int i = 0;
            while (i < props.length) {
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                Method accessor = prop.getReadMethod();
                if ((this.emitClassName || !"class".equals(name)) && accessor != null) {
                    Object value;
                    if (!accessor.isAccessible()) {
                        accessor.setAccessible(true);
                    }
                    if ((value = accessor.invoke(object, null)) != null) {
                        if (addedSomething) {
                            this.add(',');
                        }
                        if (this.useApiStyle) {
                            name = StringUtils.toUnderlineStyle(name);
                        }
                        this.add(name, value);
                        addedSomething = true;
                    }
                }
                ++i;
            }
            Field[] ff = object.getClass().getFields();
            int i2 = 0;
            while (i2 < ff.length) {
                Field field = ff[i2];
                Object value = field.get(object);
                if (value != null) {
                    if (addedSomething) {
                        this.add(',');
                    }
                    this.add(field.getName(), value);
                    addedSomething = true;
                }
                ++i2;
            }
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.getCause().printStackTrace();
            ite.printStackTrace();
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        this.add("}");
    }

    private void add(String name, Object value) {
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value);
    }

    private void map(Map<?, ?> map) {
        this.add("{");
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> e = it.next();
            this.value(e.getKey());
            this.add(":");
            this.value(e.getValue());
            if (!it.hasNext()) continue;
            this.add(',');
        }
        this.add("}");
    }

    private void array(Iterator<?> it) {
        this.add("[");
        while (it.hasNext()) {
            this.value(it.next());
            if (!it.hasNext()) continue;
            this.add(",");
        }
        this.add("]");
    }

    private void array(Object object) {
        this.add("[");
        int length = Array.getLength(object);
        int i = 0;
        while (i < length) {
            this.value(Array.get(object, i));
            if (i < length - 1) {
                this.add(',');
            }
            ++i;
        }
        this.add("]");
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void date(Date date) {
        this.add("\"");
        this.add(StringUtils.formatDateTime(date));
        this.add("\"");
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void add(char c) {
        this.buf.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        int i = 0;
        while (i < 4) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
            ++i;
        }
    }
}

