/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;

public abstract class StringUtils {
    private static final TimeZone TZ_GMT8 = TimeZone.getTimeZone("GMT+8");
    private static final String QUOT = "&quot;";
    private static final String AMP = "&amp;";
    private static final String APOS = "&apos;";
    private static final String GT = "&gt;";
    private static final String LT = "&lt;";

    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                result &= !StringUtils.isEmpty(value);
                ++n2;
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            int i = 0;
            while (i < unicode.length()) {
                out.append(unicode.charAt(i));
                ++i;
            }
        }
        return out.toString();
    }

    public static String toUnderlineStyle(String name) {
        StringBuilder newName = new StringBuilder();
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    newName.append("_");
                }
                newName.append(Character.toLowerCase(c));
            } else {
                newName.append(c);
            }
            ++i;
        }
        return newName.toString();
    }

    public static String toCamelStyle(String name) {
        StringBuilder newName = new StringBuilder();
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (i == 0) {
                newName.append(Character.toLowerCase(c));
            } else {
                newName.append(c);
            }
            ++i;
        }
        return newName.toString();
    }

    public static Date parseDateTime(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TZ_GMT8);
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TZ_GMT8);
        return format.format(date);
    }

    public static String formatDateTime(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TZ_GMT8);
        return format.format(date);
    }

    public static String escapeXml(String value) {
        StringBuilder writer = new StringBuilder();
        char[] chars = value.trim().toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    writer.append(LT);
                    break;
                }
                case '>': {
                    writer.append(GT);
                    break;
                }
                case '\'': {
                    writer.append(APOS);
                    break;
                }
                case '&': {
                    writer.append(AMP);
                    break;
                }
                case '\"': {
                    writer.append(QUOT);
                    break;
                }
                default: {
                    if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) break;
                    writer.append(c);
                }
            }
            ++i;
        }
        return writer.toString();
    }

    public static Set<String> getClassProperties(Class<?> clazz, boolean isGet) {
        HashSet<String> propNames = new HashSet<String>();
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = props = info.getPropertyDescriptors();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor prop = propertyDescriptorArray[n2];
                String name = prop.getName();
                Method method = isGet ? prop.getReadMethod() : prop.getWriteMethod();
                if (!"class".equals(name) && method != null) {
                    propNames.add(name);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return propNames;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(StringUtils.charToByte(hexChars[pos]) << 4 | StringUtils.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte numToByte(int num) {
        return (byte)num;
    }

    public static byte[] compleBytes(byte[] srcBytes, int baseDigt, byte compleBits) {
        byte[] bytes = null;
        if (srcBytes.length % baseDigt != 0) {
            bytes = new byte[(srcBytes.length / baseDigt + 1) * baseDigt];
            System.arraycopy(srcBytes, 0, bytes, 0, srcBytes.length);
            int i = 0;
            while (i + srcBytes.length < bytes.length) {
                bytes[srcBytes.length + i] = compleBits;
                ++i;
            }
        } else {
            bytes = srcBytes;
        }
        return bytes;
    }

    public static byte[] removeCompleBytes(byte[] bytes, byte compleBits) {
        int pos = bytes.length;
        while (bytes[--pos] == compleBits) {
        }
        byte[] newBytes = new byte[++pos];
        System.arraycopy(bytes, 0, newBytes, 0, pos);
        return newBytes;
    }
}

