/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.utils;

import com.cu.api.internal.utils.ApaasUtils;
import com.cu.api.internal.utils.StringUtils;
import com.cu.api.internal.utils.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApaasLogger {
    private static final Log log = LogFactory.getLog("apaas-sdk");
    private static final String LOG_SPLIT = "\t";
    private static String osName = System.getProperties().getProperty("os.name");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        ApaasLogger.needEnableLogger = needEnableLogger;
    }

    public static void logApiError(String appId, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ApaasLogger.formatDateTime(new Date()));
        sb.append(LOG_SPLIT);
        sb.append(appId);
        sb.append(LOG_SPLIT);
        sb.append(apiName);
        sb.append(LOG_SPLIT);
        sb.append(ApaasUtils.getIntranetIp());
        sb.append(LOG_SPLIT);
        sb.append(osName);
        sb.append(LOG_SPLIT);
        sb.append(latency);
        sb.append(LOG_SPLIT);
        sb.append(url);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.buildQuery(params, "utf-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(LOG_SPLIT);
        sb.append(errorMessage);
        log.error(sb.toString());
    }

    private static String formatDateTime(Date date) {
        return StringUtils.formatDateTime(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }
}

