/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.parser.json;

import com.cu.api.ApiException;
import com.cu.api.internal.mapping.Converter;
import com.cu.api.internal.mapping.Converters;
import com.cu.api.internal.mapping.Reader;
import com.cu.api.internal.utils.json.ExceptionErrorListener;
import com.cu.api.internal.utils.json.JSONReader;
import com.cu.api.internal.utils.json.JSONValidatingReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonConverter
implements Converter {
    @Override
    public <T> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            Collection values = rootJson.values();
            for (Object rspObj : values) {
                if (!(rspObj instanceof Map)) continue;
                Map rspJson = (Map)rspObj;
                return this.fromJson(rspJson, clazz);
            }
        }
        return null;
    }

    public <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws ApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return JsonConverter.this.fromJson(map, type);
                }
                return tmp;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<Object> listObjs = null;
                Object listTmp = json.get(listName);
                if (listTmp instanceof Map) {
                    Map jsonMap = (Map)listTmp;
                    Object itemTmp = jsonMap.get(itemName);
                    if (itemTmp == null && listName != null) {
                        String listNameStr = listName.toString();
                        itemTmp = jsonMap.get(listNameStr.substring(0, listNameStr.length() - 1));
                    }
                    if (itemTmp instanceof List) {
                        listObjs = new ArrayList<Object>();
                        List tmpList = (List)itemTmp;
                        for (Object subTmp : tmpList) {
                            if (subTmp instanceof Map) {
                                Map subMap = (Map)subTmp;
                                Object subObj = JsonConverter.this.fromJson(subMap, subType);
                                if (subObj == null) continue;
                                listObjs.add(subObj);
                                continue;
                            }
                            if (subTmp instanceof List) continue;
                            listObjs.add(subTmp);
                        }
                    }
                }
                return listObjs;
            }
        });
    }
}

