/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api.internal.mapping;

import com.cu.api.ApiException;
import com.cu.api.IoTGatewayResponse;
import com.cu.api.internal.mapping.ApiField;
import com.cu.api.internal.mapping.ApiListField;
import com.cu.api.internal.mapping.Reader;
import com.cu.api.internal.utils.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Map<String, Set<String>> baseProps = new HashMap<String, Set<String>>();
    private static final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    static {
        baseProps.put(IoTGatewayResponse.class.getName(), StringUtils.getClassProperties(IoTGatewayResponse.class, false));
    }

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws ApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = pds = beanInfo.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Method method = pd.getWriteMethod();
                if (method != null) {
                    String itemName = pd.getName();
                    String listName = null;
                    Field field = null;
                    Set<String> stopProps = baseProps.get(clazz.getSuperclass().getName());
                    field = stopProps != null && stopProps.contains(itemName) ? Converters.getField(clazz.getSuperclass(), pd) : Converters.getField(clazz, pd);
                    if (field != null) {
                        ApiListField jsonListField;
                        ApiField jsonField = field.getAnnotation(ApiField.class);
                        if (jsonField != null) {
                            itemName = jsonField.value();
                        }
                        if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                            listName = jsonListField.value();
                        }
                        if (reader.hasReturnField(itemName) || listName != null && reader.hasReturnField(listName)) {
                            Object value;
                            Class<?> typeClass = field.getType();
                            if (String.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof String) {
                                    method.invoke(rsp, value.toString());
                                } else {
                                    if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a String");
                                    }
                                    if (value != null) {
                                        method.invoke(rsp, value.toString());
                                    } else {
                                        method.invoke(rsp, "");
                                    }
                                }
                            } else if (Long.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof Long) {
                                    method.invoke(rsp, (Long)value);
                                } else {
                                    if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a Number(Long)");
                                    }
                                    if (StringUtils.isNumeric(value)) {
                                        method.invoke(rsp, Long.valueOf(value.toString()));
                                    }
                                }
                            } else if (Boolean.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof Boolean) {
                                    method.invoke(rsp, (Boolean)value);
                                } else {
                                    if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a Boolean");
                                    }
                                    if (value != null) {
                                        method.invoke(rsp, Boolean.valueOf(value.toString()));
                                    }
                                }
                            } else if (Date.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof String) {
                                    method.invoke(rsp, StringUtils.parseDateTime(value.toString()));
                                }
                            } else if (List.class.isAssignableFrom(typeClass)) {
                                Class subType;
                                List<?> listObjs;
                                ParameterizedType paramType;
                                Type[] genericTypes;
                                Type fieldType = field.getGenericType();
                                if (fieldType instanceof ParameterizedType && (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) != null && genericTypes.length > 0 && genericTypes[0] instanceof Class && (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) != null) {
                                    method.invoke(rsp, listObjs);
                                }
                            } else if (Integer.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof Integer) {
                                    method.invoke(rsp, (Integer)value);
                                } else {
                                    if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a Number(Integer)");
                                    }
                                    if (StringUtils.isNumeric(value)) {
                                        method.invoke(rsp, Integer.valueOf(value.toString()));
                                    }
                                }
                            } else if (Double.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof Double) {
                                    method.invoke(rsp, (Double)value);
                                } else if (isCheckJsonType && value != null) {
                                    throw new ApiException(String.valueOf(itemName) + " is not a Double");
                                }
                            } else if (Number.class.isAssignableFrom(typeClass)) {
                                value = reader.getPrimitiveObject(itemName);
                                if (value instanceof Number) {
                                    method.invoke(rsp, (Number)value);
                                } else if (isCheckJsonType && value != null) {
                                    throw new ApiException(String.valueOf(itemName) + " is not a Number");
                                }
                            } else {
                                Object obj = reader.getObject(itemName, typeClass);
                                if (obj != null) {
                                    method.invoke(rsp, obj);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    private static Field getField(Class<?> clazz, PropertyDescriptor pd) throws Exception {
        String key = clazz.getName() + "_" + pd.getName();
        Field field = fieldCache.get(key);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(pd.getName());
                fieldCache.put(key, field);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        return field;
    }
}

