/*
 * Decompiled with CFR 0.152.
 */
package com.cu.api;

import com.cu.api.ApiException;
import com.cu.api.IIoTGatewayClient;
import com.cu.api.IoTGatewayParser;
import com.cu.api.IoTGatewayRequest;
import com.cu.api.IoTGatewayResponse;
import com.cu.api.internal.parser.json.ObjectJsonParser;
import com.cu.api.internal.parser.xml.ObjectXmlParser;
import com.cu.api.internal.utils.ApaasSignUtil;
import com.cu.api.internal.utils.WebUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IoTGatewayClient
implements IIoTGatewayClient {
    private final String serverUrl;
    private final String appId;
    private final String appSecret;
    private int connectTimeout = 5000;
    private int readTimeout = 30000;
    private int retryCount = 0;

    public IoTGatewayClient(String serverUrl, String appId, String appSecret) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    @Override
    public <T extends IoTGatewayResponse> T execute(IoTGatewayRequest<T> request) throws ApiException {
        String rspMsg = this.doPost(request);
        if (rspMsg == null) {
            return null;
        }
        String contentType = request.getContentType();
        Class<T> respClass = request.getResponseClass();
        IoTGatewayParser<T> parser = contentType != null && contentType.contains("text/xml") ? new ObjectXmlParser<T>(respClass) : new ObjectJsonParser<T>(respClass, true);
        IoTGatewayResponse tRsp = null;
        try {
            tRsp = (IoTGatewayResponse)parser.parse(rspMsg);
        }
        catch (Exception e) {
            tRsp.setSuccess(false);
        }
        return (T)tRsp;
    }

    private <T extends IoTGatewayResponse> String doPost(IoTGatewayRequest<T> request) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("app_id", this.appId);
        map.put("app_secrect", this.appSecret);
        try {
            ApaasSignUtil.buildAppParams(map);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        Map<String, Object> params = request.getParams();
        map.put("data", params);
        request.execProcessBeforeReqSend(new Object[]{map});
        try {
            return WebUtils.doPost(this.serverUrl, request.getApiName(), request.getApiVer(), request.getReqText(), this.connectTimeout, this.readTimeout, this.retryCount);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

