import React from "react"
const navigation = {
    main: [
        // { name: 'About', href: '#' },
        // { name: 'Blog', href: '#' },
        // { name: 'Jobs', href: '#' },
        // { name: 'Press', href: '#' },
        // { name: 'Accessibility', href: '#' },
        // { name: 'Partners', href: '#' },
    ],
    social: [
        {
            name: 'Reddit',
            href: 'https://www.reddit.com/user/InternetFreedomIn/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path
                        fillRule="evenodd"
                        d="M19.522,7.196c-1.062-1.064-2.775-1.077-3.896-0.069c-1.305-0.627-2.815-1.026-4.437-1.121 c0.6-1.862,1.834-4.465,3.077-4.715c0.418-0.083,0.874,0.137,1.353,0.657c-0.035,0.138-0.061,0.28-0.061,0.427 c0,0.921,0.748,1.669,1.669,1.669c0.921,0,1.669-0.746,1.669-1.669c0-0.921-0.748-1.667-1.669-1.667 c-0.3,0-0.581,0.086-0.825,0.226c-0.758-0.753-1.558-1.055-2.386-0.89c-2.417,0.487-3.88,5.023-4.157,5.955 C8.152,6.076,6.563,6.485,5.202,7.146c-1.119-1.031-2.849-1.022-3.92,0.049C0.227,8.25,0.207,9.942,1.189,11.064 c-0.319,0.731-0.498,1.512-0.498,2.324c0,4.089,4.371,7.417,9.744,7.417s9.746-3.327,9.746-7.417c0-0.831-0.189-1.628-0.522-2.375 C20.597,9.893,20.561,8.235,19.522,7.196z M1.731,7.645C2.506,6.869,3.73,6.818,4.598,7.467c-1.344,0.769-2.422,1.79-3.101,2.977 C0.904,9.58,0.977,8.398,1.731,7.645z M10.435,19.531c-4.673,0-8.473-2.755-8.473-6.143c0-3.385,3.8-6.142,8.473-6.142 c4.674,0,8.474,2.757,8.474,6.142C18.909,16.778,15.109,19.531,10.435,19.531z M16.234,7.446c0.868-0.627,2.071-0.567,2.838,0.2 c0.742,0.74,0.825,1.891,0.27,2.749C18.656,9.217,17.578,8.205,16.234,7.446z M6.886,13.284c-0.877,0-1.589-0.711-1.589-1.589 c0-0.877,0.711-1.589,1.589-1.589c0.878,0,1.589,0.711,1.589,1.589S7.763,13.284,6.886,13.284z M15.56,11.694 c0,0.877-0.711,1.589-1.589,1.589c-0.877,0-1.589-0.711-1.589-1.589c0-0.878,0.711-1.589,1.589-1.589 C14.848,10.105,15.56,10.816,15.56,11.694z M14.222,15.912c0.217,0.275,0.167,0.676-0.112,0.893 c-1.326,1.028-2.614,1.375-3.742,1.375c-2.255,0-3.874-1.378-3.898-1.4c-0.264-0.228-0.291-0.632-0.061-0.896 c0.231-0.264,0.63-0.291,0.894-0.063c0.118,0.101,2.884,2.42,6.027-0.02C13.606,15.584,14.005,15.637,14.222,15.912z"
                        clipRule="evenodd"
                    />
                </svg>
            ),
        },
        {
            name: 'Instagram',
            href: 'https://www.instagram.com/internetfreedom.in/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path
                        fillRule="evenodd"
                        d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 015.45 2.525c.636-.247 1.363-.416 2.427-.465C8.901 2.013 9.256 2 11.685 2h.63zm-.081 1.802h-.468c-2.456 0-2.784.011-3.807.058-.975.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.882-.344 1.857-.047 1.023-.058 1.351-.058 3.807v.468c0 2.456.011 2.784.058 3.807.045.975.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.882.3 1.857.344 1.054.048 1.37.058 4.041.058h.08c2.597 0 2.917-.01 3.96-.058.976-.045 1.505-.207 1.858-.344.466-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.882.344-1.857.048-1.055.058-1.37.058-4.041v-.08c0-2.597-.01-2.917-.058-3.96-.045-.976-.207-1.505-.344-1.858a3.097 3.097 0 00-.748-1.15 3.098 3.098 0 00-1.15-.748c-.353-.137-.882-.3-1.857-.344-1.023-.047-1.351-.058-3.807-.058zM12 6.865a5.135 5.135 0 110 10.27 5.135 5.135 0 010-10.27zm0 1.802a3.333 3.333 0 100 6.666 3.333 3.333 0 000-6.666zm5.338-3.205a1.2 1.2 0 110 2.4 1.2 1.2 0 010-2.4z"
                        clipRule="evenodd"
                    />
                </svg>
            ),
        },
        {
            name: 'Twitter',
            href: 'https://twitter.com/internetfreedom/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84" />
                </svg>
            ),
        },
        {
            name: 'Linkedin',
            href: 'https://www.linkedin.com/company/internet-freedom-foundation/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path
                        fillRule="evenodd"
                        d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"
                        clipRule="evenodd"
                    />
                </svg>
            ),
        },
        {
            name: 'Mastodon',
            href: 'https://mas.to/@internetfreedom/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path
                        fillRule="evenodd"
                        d="M21.258 13.99c-.274 1.41-2.456 2.955-4.962 3.254-1.306.156-2.593.3-3.965.236-2.243-.103-4.014-.535-4.014-.535 0 .218.014.426.04.62.292 2.215 2.196 2.347 4 2.41 1.82.062 3.44-.45 3.44-.45l.076 1.646s-1.274.684-3.542.81c-1.25.068-2.803-.032-4.612-.51-3.923-1.039-4.598-5.22-4.701-9.464-.031-1.26-.012-2.447-.012-3.44 0-4.34 2.843-5.611 2.843-5.611 1.433-.658 3.892-.935 6.45-.956h.062c2.557.02 5.018.298 6.451.956 0 0 2.843 1.272 2.843 5.61 0 0 .036 3.201-.397 5.424zm-2.956-5.087c0-1.074-.273-1.927-.822-2.558-.567-.631-1.308-.955-2.229-.955-1.065 0-1.871.41-2.405 1.228l-.518.87-.519-.87C11.276 5.8 10.47 5.39 9.405 5.39c-.921 0-1.663.324-2.229.955-.549.631-.822 1.484-.822 2.558v5.253h2.081V9.057c0-1.075.452-1.62 1.357-1.62 1 0 1.501.647 1.501 1.927v2.79h2.07v-2.79c0-1.28.5-1.927 1.5-1.927.905 0 1.358.545 1.358 1.62v5.1h2.08V8.902z"
                        clipRule="evenodd"
                    />
                </svg>
            ),
        },
        {
            name: 'Youtube',
            href: 'https://www.youtube.com/channel/UCahIqRDjhvhuocX3BJdxfQQ/',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path
                        fillRule="evenodd"
                        d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"
                        clipRule="evenodd"
                    />
                </svg>
            ),
        },
        {
            name: 'RSS',
            href: 'https://www.internetfreedom.in/rss',
            icon: (props) => (
                <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
                    <path d="M19.199 24C19.199 13.467 10.533 4.8 0 4.8V0c13.165 0 24 10.835 24 24h-4.801zM3.291 17.415c1.814 0 3.293 1.479 3.293 3.295 0 1.813-1.485 3.29-3.301 3.29C1.47 24 0 22.526 0 20.71s1.475-3.294 3.291-3.295zM15.909 24h-4.665c0-6.169-5.075-11.245-11.244-11.245V8.09c8.727 0 15.909 7.184 15.909 15.91z" /></svg>
            ),
        },

    ],
}

const Footer = () => {
    return (
        <footer className="bg-white">
            <div className="w-full" />
            <div className="max-w-7xl mx-auto py-12 px-4 overflow-hidden sm:px-6 lg:px-8">
                <nav className="-mx-5 -my-2 flex flex-wrap justify-center" aria-label="Footer">
                    {navigation.main.map((item) => (
                        <div key={item.name} className="px-5 py-2">
                            <a href={item.href} className="text-base text-gray-500 hover:text-gray-900">
                                {item.name}
                            </a>
                        </div>
                    ))}
                </nav>
                <div className="mt-8 flex justify-center space-x-6">
                    {navigation.social.map((item) => (
                        <a key={item.name} href={item.href} className="text-stone-500 hover:text-gray-500">
                            <span className="sr-only">{item.name}</span>
                            <item.icon className="h-6 w-6" aria-hidden="true" />
                        </a>
                    ))}
                </div>
                <p className="mt-8 text-center text-base text-stone-700">&copy; Internet Freedom Foundation</p>
                <p className="text-center text-base text-zinc-500">All contents licensed under CC-BY unless stated otherwise.</p>
            </div>
        </footer>
    );
};

export default Footer;
