# Contributing to Transliteration – WordPress Transliteration Plugin

## Welcome to Our Contributor Community!

Hello developers and linguists! Thank you for your interest in contributing to the Transliteration – WordPress Transliteration Plugin. This plugin aims to provide comprehensive transliteration functionality, offering maximum flexibility to users. Your contributions can play a significant role in enhancing this tool and supporting a wider range of users.

## How to Contribute

### Reporting Bugs and Suggesting Enhancements

- If you spot a bug or want to suggest an enhancement, please use the [Issues section](https://github.com/InfinitumForm/serbian-transliteration/issues) on our GitHub repository.
- Before creating a new issue, check if it already exists or has been resolved.
- Use clear, concise titles and provide as much information as possible in the description.

### Code Contributions

1. **Fork and Clone**: Start by forking the repository and cloning your fork to your local machine.
2. **Set Up Your Environment**: Ensure your development environment meets all the necessary requirements.
3. **Pick an Issue**: Choose an existing issue to work on, or create a new one and comment that you're tackling it.
4. **Create a Branch**: Make a new branch for your work.
5. **Code**: Write your code following WordPress coding standards and best practices.
6. **Write Tests**: If possible, write tests for your code.
7. **Document Your Changes**: Update the README.md if needed and add comments in your code for clarity.
8. **Submit a Pull Request (PR)**: Push your changes to your fork and open a PR to the main repository.
9. **Code Review**: Wait for a review. Your code might be merged if it meets the project standards and passes the review process.

### Linguistic Contributions

- If you are a linguist and want to contribute to the language and transliteration aspects of the plugin, your insights and suggestions are invaluable.
- Please reach out with your suggestions or language-specific issues.

### Join the Community

- Join our [Slack channel](https://wptransliterator.slack.com) to discuss development, share ideas, and collaborate.
- For any collaboration or detailed discussions, please contact us at infinitumform@gmail.com.

## Code of Conduct

We are committed to providing a welcoming and inspiring community for all. Please review our [Code of Conduct](CODE_OF_CONDUCT.md) which guides our interactions.

## Acknowledgements

Your contributions are sincerely appreciated, and we ensure that all contributors are acknowledged. We believe in recognizing the effort and skill you bring to this project.

Thank you for being part of this journey, and we look forward to your creative and valuable contributions!