// JPEGsnoop - JPEG Image Decoder & Analysis Utility
// Copyright (C) 2017 - Calvin Hass
// http://www.impulseadventure.com/photo/jpeg-snoop.html
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "stdafx.h"
#include "DbSigs.h"

// Signature List
const CompSigConst CDbSigs::m_sSigList[] = {

{ ENUM_EDITOR_CAM,_T("10.0M 3X digital camera"),_T("DigitalCam"),_T(""),_T("01ABDC51F42E1B9894AD6BA6180AEC08"),_T("01D0F3FAE71E7CE4E25ED195F2599491"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("???"),_T("Treo 680"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Apple"),_T("iPhone"),_T(""),_T("01114839EC1207E51E21B08385DF6974"),_T("01234D2E8848CB268F789EBB63EE1B8D"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 330"),_T(""),_T("0152B022B4F4AC1741AF3BA5F0B4C3C6"),_T("01AF9C2CD0D6D3B4EA273D052679C144"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 330"),_T(""),_T("01012CAE6B2A83F4ECFDC9516C93825E"),_T("01E53DA9892B36ADAAEAC58897E28B7B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 330"),_T(""),_T("015CEBBBDF89445196B16C9736466726"),_T("01EC96C762F7941278E3F5584E9B100C"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 330"),_T(""),_T("013489D0392A3692A8D7389782C0A6EB"),_T("0166B131CC98588533F1D93ACE79AA1A"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 330"),_T(""),_T("0123D54F3D383A3E64A10DE0D5A97816"),_T("016EE147C94FA14FFEB80BC6FA4614C8"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Asahi Optical Co.,Ltd"),_T("PENTAX Optio 430"),_T(""),_T("0152B022B4F4AC1741AF3BA5F0B4C3C6"),_T("01AF9C2CD0D6D3B4EA273D052679C144"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 300"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 330"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 330"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 40"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 40"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 400"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 400"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 50"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 50"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 55"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 70"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 700"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 700"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 750"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 800 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 850 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 850 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 860 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 900Ti"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS 900Ti"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon DIGITAL IXUS II"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 10D"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 10D"),_T("norm"),_T("017C9D4907C58FFF90C29510E8DD23EB"),_T("01C8A7D568C582C8D42E10882ECA7701"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 20D"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 300D DIGITAL"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 30D"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 350D DIGITAL"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 400D DIGITAL"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 40D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 40D"),_T("norm"),_T("017C9D4907C58FFF90C29510E8DD23EB"),_T("01C8A7D568C582C8D42E10882ECA7701"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 450D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 500D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 500D"),_T("norm"),_T("017C9D4907C58FFF90C29510E8DD23EB"),_T("01C8A7D568C582C8D42E10882ECA7701"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 50D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 550D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 5D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 5D Mark II"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 5D Mark III"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 600D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 60D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS 7D"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS D30"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS D60"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL XS"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL XSi"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL XT"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL XTi"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS DIGITAL REBEL XTi"),_T("fine"),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS REBEL T1i"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS REBEL T2i"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS REBEL T3i"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1D"),_T("fine"),_T("017211BC8C6161BCE36DB4E91A7A575F"),_T("018C775AA14027570ED51F477477AA84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1D Mark II"),_T("fine"),_T("01693B4A9D484C7DF321A6051F241493"),_T("01F308C26BBCCE3A8D1E869927236116"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1D Mark II"),_T("fine"),_T("014E3B2CA236245A8E6AC25D4C0547B5"),_T("016FF2A5B4DCC046A3499C4E12912CBE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1D Mark III"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1DS"),_T("fine"),_T("017211BC8C6161BCE36DB4E91A7A575F"),_T("018C775AA14027570ED51F477477AA84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1Ds Mark II"),_T("fine"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon EOS-1Ds Mark III"),_T("fine"),_T("018F98F7BF412181D34F86F1A3BCD26F"),_T("01A5A96C366F3E76B00DA5ED55BB3238"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A20"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A20"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A40"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A430"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A460"),_T("superfine"),_T("0197DCCA5A22C4279E039DC052C60443"),_T("01F240E7FA65AB2E40EFA1C2CCEE3726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A510"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A520"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A520"),_T("norm"),_T("01536581ECEFBFB9C18C278E79905118"),_T("01D91E583DD0037108266E42ED3A262C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A520"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A60"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A620"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A620"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A630"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A640"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A640"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A650 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A70"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A700"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A710 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A710 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A720 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A75"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A95"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot A95"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G1"),_T("fine"),_T("0166C6447A130A0EB12268E3E74C2545"),_T("01FEF02BAC5C13D1C39BCA4E342A8434"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G1"),_T("superfine"),_T("01D98D90B542316CF007C19CB4C99545"),_T("01D98D90B542316CF007C19CB4C99545"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G10"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G11"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G12"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G2"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G2"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G3"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G5"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G6"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G6"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G7"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G7"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G7"),_T("superfine"),_T("0197DCCA5A22C4279E039DC052C60443"),_T("01F240E7FA65AB2E40EFA1C2CCEE3726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot G9"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot Pro1"),_T("fine"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot Pro1"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S1 IS"),_T("fine"),_T("018567C5DEAAD7EF4120A002519DC287"),_T("01BD35C96FB5A5B7BBD37BEAE0E8938C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S1 IS"),_T("superfine"),_T("012292153D6B64A48C045C10DA4FC0F9"),_T("01C11E397A687C7513E1034BC24F4710"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S2 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S2 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S20"),_T("fine"),_T("0166C6447A130A0EB12268E3E74C2545"),_T("01FEF02BAC5C13D1C39BCA4E342A8434"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S20"),_T("superfine"),_T("01254D92D792D2CB6523C82CF3641DB5"),_T("01AF89B1822B526790CC093D6D374A09"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S200"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S3 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S3 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S30"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S40"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S45"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S45"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S5 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S50"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S60"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S70"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S80"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot S80"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD1000"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD20"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD300"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD40"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD400"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD600"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD800 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD800 IS"),_T("norm"),_T("01A9490A915CC37ECB6E1256F8E6644B"),_T("01B61A33CB5EFDF80F505C0224D3B563"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD800 IS"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot SD950 IS"),_T("fine"),_T("01A84EC0DDFAE937A0336DB825C85028"),_T("01A9B171AA8560DD8EA55A93D29361E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Canon"),_T("Canon PowerShot TX1"),_T("superfine"),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0114ACEDA8F9481F39E84EFF05320A75"),_T("012FCA6D6632CA1A4A7BDD6231B32535"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("010901E28B712B0A893D88C64200A77C"),_T("01A458CA927F61177265F104EFC3B6DB"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0154891CBD5437A548A3C052C118AA0B"),_T("01B36319ECD00B49D67C9A766B774E2C"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0106EE66B9A3CCA78E456DBD4F70C75A"),_T("0109875B03DEB01C981AD4D394F5366C"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0101D11D279551CC7C4CA86A8F39A41A"),_T("0161415C082A4312146D7F5C39BA5ED1"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0186E4B502CA67A194BF25F837844D8D"),_T("01A32782FC02530A42591F1F4F464F3F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01284370CBB386736D9945F4CC9B67D2"),_T("01CCC7E166F2A263B79D58383140B8A1"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01072BA17E81B063A400664BBDF89044"),_T("01C4A90CB8D7B176C23A657F10AF4F62"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01642B5F591CE08B51B5D0D2493A956D"),_T("01A431C10DF789D73EDA19939C228D84"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01C839B17EE76D0157A2AAE990D683B4"),_T("01FE40687C4282564075351F339BDCAD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0186895D7C5F2BBA6028D98DBA7CEA73"),_T("01CD2D081D75FDCD853C8C66B5A9E79B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01878DA912905F4FB26A085F27638E14"),_T("01B6670DB7E3D9B5378D0B4D54F84632"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("014D370BE2BDBDBCB33569C338FECF5C"),_T("01FEDC6036672378F31AAE0AE2E28E0E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("016BB57ACC9696E011186EC286CFC185"),_T("01ADDA416DCF3BBC8649DC7495FF09F8"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("0191369E9D5A81193E62D58452CC5DDB"),_T("01AE39A80FB5251F44103926ED2EC3E2"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01D8752CBB2AE66D6F4CFB775D59A7A5"),_T("01F6B4F4795B85ADB326FD80B4993D68"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("012DE9EF5B39566F08E4864A0E6734F1"),_T("01508825BF8EACB426BE13B9F647B278"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("01646DA44D608C8154DCF8F04E540FC1"),_T("01D5F912A2CAC1141FEDFAD87B2A66D1"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("013C143987565282044C2DAC1A068436"),_T("01879A52F82348EFAC4D95E0C53D88D7"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-3000EX"),_T(""),_T("011A671A74533E934228664BC17AB47F"),_T("01B002679AE502C39E114EF2B5FC0306"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("011B35D8688C01551FDE78BFFB8F1C57"),_T("014E650C236D4FC2D83EF2A6226A8A9B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("01081B465B20737AFAD71D785AC239B0"),_T("016A90369C5FDF1067FE96D982AD2119"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("01BAAEE4D1A66BBB7F4F0E88411017E5"),_T("01CC1C78C52A9250EC2589572EEE1985"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("012C5B50BF9AE8AAB4A56B596E435A92"),_T("017ACD82E5B0B9829E9213B645C356D6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("01CC03D9AD8BD65C811C26485454F57F"),_T("01CF95ACB5EC9CE5A1DECCE25E5353D8"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("015A33449827A6024F4F2088B40487FF"),_T("01FC69409FCF1FF801C9ECE870FF52F2"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("0104176A29E2524FBA25A9905E4F23B8"),_T("01F2D9EBEA054E050687EF4CD4A3BC43"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("01AD43A6537A8BFA5B99A6DD691C86CA"),_T("01AF1667B04F8576816B0BDCD7C2DE43"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("0158C4F5686476668DB83B0E530AD342"),_T("01F04E7D6E8E71B08B3426073D69212E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("0188DCDAB979EC7D09A12202F2B774AF"),_T("01CC33C98E3EA1AF8D6BA30C49E3F2DD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO"),_T("QV-4000"),_T(""),_T("011AE1522C59D1CDBABB1F8AE9C18859"),_T("0129A2541B4DC116666C667A9E7798C3"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-P700"),_T(""),_T("01158B0D515E752B1B0716889F2B3371"),_T("017BBA44ECD57A9B2E59D0D6967F1623"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-P700"),_T(""),_T("018A97EF0C8856D9155F90A770C73067"),_T("01F68622EE6EF782C32ACC2CCF6A9907"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-P700"),_T(""),_T("0102294DDB25E3C1C60F5C5DC104F7B5"),_T("016B3CB8CC79372F62EC1BF4D84C018E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01307DB502FD0796E12F5BBEB51B4AB2"),_T("01663330C80C57C3B23D93665BCA78AD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("013E4F4032D7BBB022EA8A4DD2A79AA1"),_T("015DD46C027E5E984C8305753B29931D"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01D0473D74948D7D40D56AE4618F18FA"),_T("01E2C847E07C54190944A74B136E452B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("016457926DC23B96DCB1158EC97FA41F"),_T("01CF9466A7F18116407263F3C571385B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("013EB813C8BBDFFF0B4E8A901F467A53"),_T("016E3BEA7C7F7A2699A831BD7D810755"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01541589583CE2044639D04AFA5D92EC"),_T("01C87F3D55EDD94FF768CD3D6C4C5EB9"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01538B160141A7D4D5EC996041B13927"),_T("01CD00B4F906A2D48B87B432BD90C47F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01E4024724CFD9D59967431BE3D4B5F7"),_T("01FC172DB6898BD03C724F65B292E2DB"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("0189899374B6A91C23CE16E82E10860A"),_T("01A03ED33AF152520F69668A6384F1CD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("01762465923F7F2BDED202DCC9EC1C61"),_T("019BA0F4F58AB3E2D5503B48FBE64BCD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("0125B10AC281E131BEEF59122D2A50D9"),_T("018613B9EDD3B80CD5532CEDB56E179A"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("012004B942B765F1D36C13D9037D6FBC"),_T("01DB30EDD5E692FCF2A005916617DEAD"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("0105A3A5351DF1752ED496F68DAA2FBB"),_T("01732657CD1F44D5B7321E556A8612DA"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("012345305944D817D0C161C7B54BAF5C"),_T("017DDCB884AFEF1F6DD72AEA5D125933"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z3"),_T(""),_T("012EE70617EAFF0FC7A699EDF281D96C"),_T("0140748F1853345BF32A08347F94C9A4"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0114F4E9F4E455967FE80C4ED10EBDAD"),_T("01680D1FE97C0D264CA8043A194C8133"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01158B0D515E752B1B0716889F2B3371"),_T("017BBA44ECD57A9B2E59D0D6967F1623"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0151361D87566A29C7953F5D17496970"),_T("01C9FD0688443EC6A4EA219C6875EF80"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("013B1FC692BCCE8DBBAEA5BD4DC13F87"),_T("01DB220936AEBE1D36FDF3382FD48D2E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("018A97EF0C8856D9155F90A770C73067"),_T("01F68622EE6EF782C32ACC2CCF6A9907"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0102E487A27A09D7582FA1E0001EDDA8"),_T("011B1F3139A11C00C8AF37C1E3BC177F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01282B7C952CA521A46610097AF44D85"),_T("01D66E67E2B232758F87834EF50590B5"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01133005CDA1908ED26E50DDB781DF3D"),_T("0160796D6F8855EA95ECF106A9654836"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01898FC95FA9A32B051449450C4D2A12"),_T("01C2E8DD6BF896D8E02C99FF30979C44"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0153055EA4D756EC9F6475B3C09E7C01"),_T("01FD90D92E90DBA384669EADB3F577C6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01353F8208A74D70DE394C36EF9E1930"),_T("0187F5E28A0687D5CCFCFC88CAE032D6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01E58965F8067668C66AFED5D75C697A"),_T("01E9F3EA3C7492A27953F6010EEC4018"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("012EB4552CC504B451C1DB9919AF87B4"),_T("01E45CAEA1F7F87027D080E583B4E4B2"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0181E59CD24EF8789C041D42B8AD1D5A"),_T("01E463C57C904FE7ACC294AD6019A96D"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("0141C8BCEE79DCFDA074E3C07736416A"),_T("01DE5CEEED245872C6FCA585F661116B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01140A9EB6A29B75A94DAA83062EDF86"),_T("015EF8EB6F5D14FB23AB7ABDC958138A"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01573FFE0766609566191C1833D6F679"),_T("0183874EA1080211719853DD0F1BCF07"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD"),_T("EX-Z750"),_T(""),_T("01A06F04F4B4D355BA155DEF93666C41"),_T("01B46D5D99ED73CD4F3240EC47C43EFA"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-S1"),_T(""),_T("0101A7F739C69F00359D8B85CC34F0FB"),_T("01367C97B8AC950F6F131433253F02B6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-V7"),_T(""),_T("010A617846E6CF420B022872292301CF"),_T("01DB0DF2EAE120F08CE3C4D7878A4E22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0114F4E9F4E455967FE80C4ED10EBDAD"),_T("01680D1FE97C0D264CA8043A194C8133"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("015810C34129CDE961B762FC29DAD759"),_T("01A966EEF909399816B26D62AA2361A1"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("01158B0D515E752B1B0716889F2B3371"),_T("017BBA44ECD57A9B2E59D0D6967F1623"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0151361D87566A29C7953F5D17496970"),_T("01C9FD0688443EC6A4EA219C6875EF80"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0174AE9734728759DD35CDC2E31AA7A1"),_T("018F56C5185CA8141F9A004ABF9D73D8"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("012FF3521C45C6DAEEA460C7BDD6DCCC"),_T("0187425514C2B6F84D4F22EF7A9D9C40"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0142650EF71E4211C4C81828541A77F8"),_T("0194F0978127E72F4314C73250B9E6B4"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("017968F1F9AEE81D13441ECE60DA6BEA"),_T("01A370D713D9ABF8C828A06FCBB25860"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("011BFA3463AE7DAC4A6D3902FB1C0108"),_T("01739F243032DF6F0262F85D7A36CFE5"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("011A3E23EC6F242909B20639EB7205D8"),_T("01823F6AF5D968093CE92BB16C4A4988"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0129FE5A01A618B61ABCC5F50F960D20"),_T("01F091FFC7E5B8779C78222894121BDF"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("01898FC95FA9A32B051449450C4D2A12"),_T("01C2E8DD6BF896D8E02C99FF30979C44"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("011D3D09F48DCC50F94890D1C9A69C5B"),_T("01E26E34B5F5E005BA9F75037796E619"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0133226BF13534FDE68EFC2D88AE82CE"),_T("01B9E5BE874A359DE08D0316A0177506"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("014AAC72448AB92C4302572620B7F4AC"),_T("014DCA2B0866A92BD9B6839AFC50A1D6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0185FECE30CB0A7EB5E37B6A11BD6836"),_T("01B3720783EA3E69C14BBFBF06757E64"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("0142BB80C46874F3726D3A8EEED24A3F"),_T("014789A946A1654649745D9ABDEAAE79"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("013041C49E6936277A0AB6A1E36A2E56"),_T("01C7A2FB7E82A978A31032E710B85EEE"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("015A69E9850D5D1EEAC2BA4108D0314C"),_T("01FAA2C9873B4E3B098860660F4C910D"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z1000"),_T(""),_T("01AE4DFAA5863EF3F54DA3BB2BF35E66"),_T("01B67A85A646A481EF7378F757E236D1"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("EX-Z60"),_T(""),_T("0149FA5635438A0954FA8059E2793FB3"),_T("01F127B5443FBD96B3025F295D69BE9F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("CASIO COMPUTER CO.,LTD."),_T("QV-R3"),_T(""),_T("0123352933C37236F67F03EB6B0E3A91"),_T("0153CE6A2850A881FA5219B4669EE67C"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK C875 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Eastman Kodak Company"),_T("KODAK DC265 ZOOM DIGITAL CAMERA (V01.00)"),_T(""),_T("0108DD2F610E7A2995F0205A2B110768"),_T("0108DD2F610E7A2995F0205A2B110768"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Eastman Kodak Company"),_T("KODAK DC265 ZOOM DIGITAL CAMERA (V01.00)"),_T(""),_T("01641718AE2C9861D8B6FA297AFF7345"),_T("01641718AE2C9861D8B6FA297AFF7345"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DC280 ZOOM DIGITAL CAMERA"),_T(""),_T("0108DD2F610E7A2995F0205A2B110768"),_T("0108DD2F610E7A2995F0205A2B110768"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DC280 ZOOM DIGITAL CAMERA"),_T(""),_T("01641718AE2C9861D8B6FA297AFF7345"),_T("01641718AE2C9861D8B6FA297AFF7345"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Eastman Kodak Company"),_T("KODAK DC290 Zoom Digital Camera (V01.00)"),_T(""),_T("0108DD2F610E7A2995F0205A2B110768"),_T("0108DD2F610E7A2995F0205A2B110768"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DC4800 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DX4900 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DX7590 ZOOM DIGITAL CAMERA"),_T(""),_T("01761CEA379B4F7A4F77D06279E8050F"),_T("01761CEA379B4F7A4F77D06279E8050F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK DX7590 ZOOM DIGITAL CAMERA"),_T(""),_T("01761CEA379B4F7A4F77D06279E8050F"),_T("01761CEA379B4F7A4F77D06279E8050F"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK LS753 ZOOM DIGITAL CAMERA"),_T("Best"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P712 ZOOM DIGITAL CAMERA"),_T("Basic"),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P712 ZOOM DIGITAL CAMERA"),_T("Fine"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P712 ZOOM DIGITAL CAMERA"),_T("Standard"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P850 ZOOM DIGITAL CAMERA"),_T(""),_T("0184C9EBAD799D9C4AFE7B97932F42C5"),_T("01F0A787A4F48EE0145B0243DD91F234"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK P880 ZOOM DIGITAL CAMERA"),_T(""),_T("0178BAF59FA3A93E45912D1A3AB3DFA4"),_T("0183C6D8ADA5B5856CB6C4CEAFA87628"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK V610 DUAL LENS DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK V705 DUAL LENS DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK Z612 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK Z650 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("EASTMAN KODAK COMPANY"),_T("KODAK Z740 ZOOM DIGITAL CAMERA"),_T(""),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("01BBFCF1173FB5AFEACBC1D065B6DC5B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix A330"),_T("high"),_T("016177AB8D6680CE1D5BD42F16970EBB"),_T("01CF7260141AA84FBDC5E47A35118EBF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix A700"),_T(""),_T("01144982047160D8F5F6F1353EF1713C"),_T("01EE606D916D8DBD24D301A85169CE58"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0107970B1B893B56DEC2A2B1B0B797B1"),_T("0115AB45CC9CD386DAC1E6E7DAB33CD6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0143A9114D57AEC803D47AB9AA1DAC8E"),_T("01E0F7F87C972B220E1203E00D78FF1E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0136AAFA05459AEFAABBB57620F4604F"),_T("01B995B722D53ADDC6AA4D06115AFE4F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0167ADE27CBB81EED41B08E8DD91919C"),_T("017FA6A0E82890CD1734E1435D5EED33"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01144982047160D8F5F6F1353EF1713C"),_T("01EE606D916D8DBD24D301A85169CE58"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("016FA4721E4BDCA33AB0243056ED052F"),_T("01B0ACBB0E5167B3D432056CDFF87C98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0194A30D59C5D4F233C204CCCD9383E0"),_T("01D69C67E78A7244D23671EB2DEDF6C1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("018DDDBEBFE9897574F2601B234742B0"),_T("01EDD07571B6983644D2B38B88D520A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("010D98BF96F187A0C2C69857A2532D3A"),_T("01A30B61A5E49BF4ED08B00CFE7916BE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01300CF6E26C44CA6E1F7E002E90E29B"),_T("01C97D0146AF14BC73CBB75FBC2DEA7D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01209694C019817E5160C77ECB0E6E73"),_T("01A6E0CFCF95398C049C8A6A8CB5662F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01322A55C3F539232F9F48AC5DCA0072"),_T("01448D46E463836F6191E0916423365A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0145F26B95FF8AF15D1A7DC64355F872"),_T("016D15F943FA53E2F9E93A89A926B850"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("011F72189F16FB63160539354A378C18"),_T("01B57B0DB97AF420331DCB82522A4FC0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0105CCB4C4B348AE594D640D47A029B7"),_T("014CE1370398E06CCA7E7635DA264D67"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0114487FCFC83B9264E0E8E7CEB018C1"),_T("01775E6DC2982017FD3CADA42C020735"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0175096CD9CB339136584317671A190F"),_T("01FFAD541AE2A57B779D1092D1D36CC6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("010B56EF40829B8C4322CA40EC09F38E"),_T("01EDC31567D017E237CD52453C45DD19"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0143F7DAE2EA08DE30DA14FE894C3D07"),_T("017C6D26409ACAF1615DE04A6B9C9C7C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("01A88E1F6EE058E7ED3461A41319E940"),_T("01F2199FD2DDA564B7B2C2B509C9B867"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("012C11691B3D750330F68718791E6D82"),_T("016F2A0902423BB51F4C00CB28EC2AC2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T(""),_T("0158A6F94ACA7479ADC3CE97BCCF6067"),_T("01966CF476E457732318E23BED0FACFB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T("fine"),_T("0115FB8DBBBF91B4B9D9F034824CB8DE"),_T("013855ED9741DF50B314E3AC7E2F6A3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E550"),_T("normal"),_T("01131D987286C9F06E27B89F8CB39055"),_T("01E3FB9A93F491AF8D8D25B6C85C60AF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix E900"),_T(""),_T("016FA4721E4BDCA33AB0243056ED052F"),_T("01B0ACBB0E5167B3D432056CDFF87C98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("018E2B0BAB1091B759DA4A36C1498434"),_T("01B3E93337A2DC7DB01EFC7F0B9260BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01511F2752713A5E416E7F52CAACC00F"),_T("01652DC355F8FE9317D1ACD1B61F3BFD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0142BD6537DD267D5315D93E3199D296"),_T("019F6B8CF9E4A7B141FF8C23430ABB79"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0126DF310012A2906C931B68FFE4A4FF"),_T("01EDEA44DA225D6BAAA693F15D5D9FA4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01CF6837934F5586370A3208A5964B35"),_T("01CFFF16E1C60E2DBE37A43C7DC375A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01F66DD3883F0537836AF63904F782EA"),_T("01F683F377BF9221D4B797F47699DB46"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("015263B1DEF7F49143B25A7399503908"),_T("01D9E2046C67FBA14257D043ABD80227"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0143172307C00E1BF25477E64B4D871E"),_T("0149D17CAB38C9B9FEBDBA1E18354E75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0103D886A565CB92A2C07B1E83283938"),_T("01B0DFFF3B86F30AB053C9E4D90E2857"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01775803404B1F6E51DA270D875AE21C"),_T("018DE101321099CA44B3BBB7A971FC1D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0135B9D3FA43F42B228C8D68559183A1"),_T("01E9A7153A4282CFAFCB55AE330A529D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0136AAFA05459AEFAABBB57620F4604F"),_T("01B995B722D53ADDC6AA4D06115AFE4F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0167ADE27CBB81EED41B08E8DD91919C"),_T("017FA6A0E82890CD1734E1435D5EED33"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01E63EEB1C76EA886EB86D05A4BF6453"),_T("01EE5B1290C0B04E02A7A5909D728E53"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01AB6FC5F47A256B85A06A20DF7A2E73"),_T("01D33FAE924EC067B2FA25060B9DBDDE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01322A55C3F539232F9F48AC5DCA0072"),_T("01448D46E463836F6191E0916423365A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("014D07412D807AFD47466BC3B2DCFD20"),_T("018571F62223F9611C5C82E33361D715"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("01269559519B7DD8BEF85FD3A3D36098"),_T("01699EC66C077829BFC5A565F2406A2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0106D2E82ED326912ACBE67C2156F424"),_T("01389549659E667495B6C42EE144CB04"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("016177AB8D6680CE1D5BD42F16970EBB"),_T("01CF7260141AA84FBDC5E47A35118EBF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F10"),_T(""),_T("0187E258D1C4458BF14E95702CCA2CF9"),_T("01E68E3620535112F02B2D1133033A90"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("013659FB683254FC54DDE61474AF809C"),_T("0174AB5078929D8E287FECAA4B30532E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0177F18C71320F7FF7F3B037DD101223"),_T("01D9F611647071948F3807C5C4C97964"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01159F4F09FFCFDABE48FC7C23DCF0CA"),_T("018E6E27D7203B16A8C808E94F67089F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("018C380E60DF1314784C827EFEC4087F"),_T("01C4776D91252150EA3E030855ED4E70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0107970B1B893B56DEC2A2B1B0B797B1"),_T("0115AB45CC9CD386DAC1E6E7DAB33CD6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0142BD6537DD267D5315D93E3199D296"),_T("019F6B8CF9E4A7B141FF8C23430ABB79"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0125360719B8F561A961A8205CA300A6"),_T("01A12CBCB3929F4F50A2361636A2C17F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0133353D7ACF8F6FFD9C833C91C2DE82"),_T("01DCD75B2D981DCBA8F67F138F5A4689"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01CF6837934F5586370A3208A5964B35"),_T("01CFFF16E1C60E2DBE37A43C7DC375A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("015263B1DEF7F49143B25A7399503908"),_T("01D9E2046C67FBA14257D043ABD80227"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0103D886A565CB92A2C07B1E83283938"),_T("01B0DFFF3B86F30AB053C9E4D90E2857"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0143A9114D57AEC803D47AB9AA1DAC8E"),_T("01E0F7F87C972B220E1203E00D78FF1E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0113F8BF2685232C081221544B886BE3"),_T("014A4D2D56D0003594C4ECB8139B08D4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0135B9D3FA43F42B228C8D68559183A1"),_T("01E9A7153A4282CFAFCB55AE330A529D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01340755C56A1C1E8A7E59A1B3BA24D8"),_T("0159C96D7604CE74484E5E1BFDECC62E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("01E63EEB1C76EA886EB86D05A4BF6453"),_T("01EE5B1290C0B04E02A7A5909D728E53"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("019CAE8BAA4E0901A8132DB0460252E6"),_T("01D6C978E3AABF216D5CAACF54F63412"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0132B6121FABF922EC108ED2299A4DF8"),_T("01B1D99243F7145290F94B0DDB143DF1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("013848370A40F0D07134E5F819A35BAA"),_T("01AA5DCFB1E3186C06CED70E710F15C0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F30"),_T(""),_T("0173377CDE7592A2713170C463771BCF"),_T("01D784735642AA8E091C60FEE5FD1DBD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0109D9B765ADC9B8A749C830F9A87C0C"),_T("01F47FF18B844BA5E3163DC1BB954612"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0103E19EF10910FD9D0710852668A178"),_T("01D5BC8CE7BC209B25A8C8648FB61439"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("013AB20A7D024D1D24EE5CA8A01B8A2E"),_T("015620909103A039B8D64818100C3538"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("012FCE7A1A81837C7F3783AA9F2CB0CF"),_T("01BDD87262EF899D2EA565BAEBFF8285"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("012BFCCAF570BA39D7758A93212F4FE6"),_T("01383B54C4063EEBA23F13AB1415BB64"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("01EF23B16E6DF6EFE5F4E183E476188A"),_T("01F57F9E26A77E824BF4EA1D93EBFEB6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0137DD0B0E26F694CBB317E21B4AE230"),_T("01DEB47B3440B79A7568ADAAC0B5D4E1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0124A6EC131285715A0E4C5C37AACFE8"),_T("01381ECEF3CA87CC5B27C32FC8FCADD0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("01229C5AA062D88A9449065018371866"),_T("015A18E7902796EB4DBDE8A5AC7CDC91"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("018EDB93CFE7F86ECE0E37F92C374F62"),_T("0191E43084B599DC909907C4BA82070A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("01537B41C7887A54ABAAB2B14836B7F6"),_T("01CA67189FF26224721E329BB73A2CF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0127BA5075AD35F0F85D15DE0568818E"),_T("012A90C987751ECEF261E62CC88755B5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("013CD57992DEE9AF4FF18916A1BAF695"),_T("018849D06D074410D0C51A22F8DECE87"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("014B5F0D2E14DA1836880E0B71113A23"),_T("0178844318AA60BEBB0F3D39BFA7C282"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("014F28993E97414C40DFD0B6C3F53AEA"),_T("01581A04F9ABEEDFFCF3917BB2C925A7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F700"),_T(""),_T("0105B30BB6043B3CC5A9518A60947F04"),_T("011D5E41D0A9E07F8DC8ECBC923E1A50"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0102FD60B1BEE5C1D4E09C430F3BAF8E"),_T("016A742831A8B18944908F8FE6667FF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("01CF6837934F5586370A3208A5964B35"),_T("01CFFF16E1C60E2DBE37A43C7DC375A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0136909CD8B831B7F2A1A40DDFE711FA"),_T("013DD960D0C3B58269535DF656FA87AE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("016FA4721E4BDCA33AB0243056ED052F"),_T("01B0ACBB0E5167B3D432056CDFF87C98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("01E63EEB1C76EA886EB86D05A4BF6453"),_T("01EE5B1290C0B04E02A7A5909D728E53"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("010591CD94BABC13B571DEDB9A76B196"),_T("01F0E53A1233A692F0D17371293F5342"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("013848370A40F0D07134E5F819A35BAA"),_T("01AA5DCFB1E3186C06CED70E710F15C0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("011F13E54D8728C8486C2D0547B93C00"),_T("01E981EDB38DC8239E54BA4805C26B74"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("012840C2B1FCCDE2221D57CD894F5898"),_T("015F4AA8F8D3132E1FAF5DB940997359"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("014953E487E86BCA6BB01842D37A3979"),_T("01CBF30DCDFF5964440C0DD7A1DC9DDD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0125B5D4DAD31F73197E943B1FA80710"),_T("012B5C9C9DE2B306557D7F6F0ABBC33F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0195EEA7C7FFC31874CB47F55A731440"),_T("01EA701641AE57738E101037BBDFBAC4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0177F851C3B1746C6F3ED95C768B72AF"),_T("01A2D84750639B253394A2BC702BBA64"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("011C906212D8A2C45BA66ED96B57DD16"),_T("018F1C3E1FDB4A1785F9BF63ACC5DD1B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("012F2EE5B50FBD87AF3DD370C98D4E3A"),_T("01CF07DB139C22B4C3B7B59640D0EE06"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("010E3334FC94179364A056207AE42ACB"),_T("01BBD1C9C6E595E3D97E4CC4D24E0066"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("015D43A40A0602CAFB865C7620995223"),_T("018D283C92404C7F768254885EFD5DA2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("015BDA2DD1B591063B1D47998A5BF147"),_T("018E9408F19306B79381D994B812C431"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0124A6EC131285715A0E4C5C37AACFE8"),_T("01381ECEF3CA87CC5B27C32FC8FCADD0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("01450C56AA66881CD17F96A041FC17F7"),_T("01BD74F16BA271F7A0438D79AFC746C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("01A88E1F6EE058E7ED3461A41319E940"),_T("01F2199FD2DDA564B7B2C2B509C9B867"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix F810"),_T(""),_T("0155A48050753EA001FBAF229F98C84B"),_T("01E7CEA6D4523C9769B9D7E3C0D1CA78"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S20Pro"),_T(""),_T("01AC5C1171760A3C309B7156A91E7E65"),_T("01CA4C33113E1681E0196932FB6D9D81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01089D27A104A81CE3A986763DEF98B8"),_T("016783137CC0098188020126C5327C0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("018E2B0BAB1091B759DA4A36C1498434"),_T("01B3E93337A2DC7DB01EFC7F0B9260BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01511F2752713A5E416E7F52CAACC00F"),_T("01652DC355F8FE9317D1ACD1B61F3BFD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0107970B1B893B56DEC2A2B1B0B797B1"),_T("0115AB45CC9CD386DAC1E6E7DAB33CD6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0126DF310012A2906C931B68FFE4A4FF"),_T("01EDEA44DA225D6BAAA693F15D5D9FA4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0133353D7ACF8F6FFD9C833C91C2DE82"),_T("01DCD75B2D981DCBA8F67F138F5A4689"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01338863A9E9D87C756424FEB020BD98"),_T("01D90BFC434FAD5B68EA3351CF827D30"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0143172307C00E1BF25477E64B4D871E"),_T("0149D17CAB38C9B9FEBDBA1E18354E75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0103D886A565CB92A2C07B1E83283938"),_T("01B0DFFF3B86F30AB053C9E4D90E2857"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01775803404B1F6E51DA270D875AE21C"),_T("018DE101321099CA44B3BBB7A971FC1D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0143A9114D57AEC803D47AB9AA1DAC8E"),_T("01E0F7F87C972B220E1203E00D78FF1E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0126DAA916EC369FF8B1797B107C375F"),_T("01BAC7FF877B99FA2EFE0B0BC9A51F70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01A1E20150A519300E142C5DFF57F49D"),_T("01A9F212229355222B1DF6D1C6BA36CE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0135B9D3FA43F42B228C8D68559183A1"),_T("01E9A7153A4282CFAFCB55AE330A529D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("0147C9CEBD36DF9A8FC10C197C655B9A"),_T("01CBF7CACE5354346E834F315D68854C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("01340755C56A1C1E8A7E59A1B3BA24D8"),_T("0159C96D7604CE74484E5E1BFDECC62E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("016FA4721E4BDCA33AB0243056ED052F"),_T("01B0ACBB0E5167B3D432056CDFF87C98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("014D07412D807AFD47466BC3B2DCFD20"),_T("018571F62223F9611C5C82E33361D715"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("017548B546BB0963B26B44611755A70D"),_T("01C985AE33A5F28E8BAB1D3ED75ED2A1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S3Pro"),_T(""),_T("014899659B5DFB996E7E35C3DA1F6211"),_T("017230BF5CE1D091A27340E31A89BF61"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("0154B9751596FC0D25ADC6F9D2B6B274"),_T("01D07180C64D9BDF825A5304B71E751F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("019F5DB74FAF31A9F4895A9A007E0A01"),_T("01ADB3065BA5B24F87745074E70B7C54"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("011C1CA26C33CE3E87B733EC41F1E233"),_T("019938269F4D594DE389F9C1DE231D9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("010E3334FC94179364A056207AE42ACB"),_T("01BBD1C9C6E595E3D97E4CC4D24E0066"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("01991A5434F416A7CCBDACDB066BDFA5"),_T("01E1BB8350885874B0A7C8C9750985BB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("016C0C68D03E7317DDED0A07B2492CA2"),_T("019C0C77CBCDFB463BAA8F0543FA3BC4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("0124A6EC131285715A0E4C5C37AACFE8"),_T("01381ECEF3CA87CC5B27C32FC8FCADD0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("01A88E1F6EE058E7ED3461A41319E940"),_T("01F2199FD2DDA564B7B2C2B509C9B867"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("01062F81528A1594FFBFF7BEED6584DA"),_T("01DE2EFED0143FDF402CD486CF4B67F4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("01A30316FC14ABE0576A6D39338B489F"),_T("01AE9F3C5615392B7144D385A82925AD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("0155A48050753EA001FBAF229F98C84B"),_T("01E7CEA6D4523C9769B9D7E3C0D1CA78"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("014F28993E97414C40DFD0B6C3F53AEA"),_T("01581A04F9ABEEDFFCF3917BB2C925A7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("01172B3480B05799AA98FAB9BBACA31C"),_T("017E24A44A691C3AAC93AA741E7BA8BE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("013C282F2F9C1270D6FC8DD4E334CBE9"),_T("017D5A53E3ABF75F2FBAA66DE6804CA6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("0120638613ED08DC3B923EC45E3F2BDB"),_T("01F85A256DFDBBC84214D566AB8AACFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5000"),_T(""),_T("0123530416265D640E4E07C606357E5A"),_T("012978B985997C7A0597D7CAC69525DA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01089D27A104A81CE3A986763DEF98B8"),_T("016783137CC0098188020126C5327C0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("018E2B0BAB1091B759DA4A36C1498434"),_T("01B3E93337A2DC7DB01EFC7F0B9260BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("0126DF310012A2906C931B68FFE4A4FF"),_T("01EDEA44DA225D6BAAA693F15D5D9FA4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01F66DD3883F0537836AF63904F782EA"),_T("01F683F377BF9221D4B797F47699DB46"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("015263B1DEF7F49143B25A7399503908"),_T("01D9E2046C67FBA14257D043ABD80227"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01338863A9E9D87C756424FEB020BD98"),_T("01D90BFC434FAD5B68EA3351CF827D30"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("014D9616BBF7E071E910B93ABFB21C27"),_T("018734006FEA2D30B1C0A8F47A50FF74"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("0136AAFA05459AEFAABBB57620F4604F"),_T("01B995B722D53ADDC6AA4D06115AFE4F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("0147C9CEBD36DF9A8FC10C197C655B9A"),_T("01CBF7CACE5354346E834F315D68854C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("013FA8B0D97468662280A7C33A960DD7"),_T("014B6B976D0DF6E350AD535F4BEA101F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("0115FB8DBBBF91B4B9D9F034824CB8DE"),_T("013855ED9741DF50B314E3AC7E2F6A3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01BD62DE4967E5CD3906D337D28B5905"),_T("01C9C71A684334A614FC1F7BE6A00D15"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01AB6FC5F47A256B85A06A20DF7A2E73"),_T("01D33FAE924EC067B2FA25060B9DBDDE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("011A4E131AE6141F56175D11C0FF08F3"),_T("019C6D82AB51688BCFEF61E51C4C4B89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01209694C019817E5160C77ECB0E6E73"),_T("01A6E0CFCF95398C049C8A6A8CB5662F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("016ADD09C60862FD6F0B9452EC614AD8"),_T("017B24E070670F38FE2761B505BF97C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("01322A55C3F539232F9F48AC5DCA0072"),_T("01448D46E463836F6191E0916423365A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("014F18BED4590DE7A0360B979D6C1EC0"),_T("016FC2A0F1990575069647DB51BF5D98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("011F72189F16FB63160539354A378C18"),_T("01B57B0DB97AF420331DCB82522A4FC0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("011A0B6A5E2CD8D701387C1B92673C51"),_T("01424F959EF392EE7D3A4B878C98E2B2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5500"),_T(""),_T("011A80B1C9B879845EFE6653EA3D3C98"),_T("01423B8723E1E7758F00E44D42A3A2CB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0129F7BBA55E2EAEB8C9E3BDDBA7B64A"),_T("014363233109D50BE8328B6044FE1D58"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("019EF19678BB82F6281BF75BEE17635A"),_T("01B721616C882F82F632C9C9A02029A3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("013659FB683254FC54DDE61474AF809C"),_T("0174AB5078929D8E287FECAA4B30532E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0177F18C71320F7FF7F3B037DD101223"),_T("01D9F611647071948F3807C5C4C97964"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("01089D27A104A81CE3A986763DEF98B8"),_T("016783137CC0098188020126C5327C0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("018C380E60DF1314784C827EFEC4087F"),_T("01C4776D91252150EA3E030855ED4E70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("01511F2752713A5E416E7F52CAACC00F"),_T("01652DC355F8FE9317D1ACD1B61F3BFD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0107970B1B893B56DEC2A2B1B0B797B1"),_T("0115AB45CC9CD386DAC1E6E7DAB33CD6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0126DF310012A2906C931B68FFE4A4FF"),_T("01EDEA44DA225D6BAAA693F15D5D9FA4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0133353D7ACF8F6FFD9C833C91C2DE82"),_T("01DCD75B2D981DCBA8F67F138F5A4689"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("01CF6837934F5586370A3208A5964B35"),_T("01CFFF16E1C60E2DBE37A43C7DC375A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("013FA8B0D97468662280A7C33A960DD7"),_T("014B6B976D0DF6E350AD535F4BEA101F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S5Pro"),_T(""),_T("0115FB8DBBBF91B4B9D9F034824CB8DE"),_T("013855ED9741DF50B314E3AC7E2F6A3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6000fd"),_T("normal"),_T("0121D8EB73BAC21E4308A56F22BCB342"),_T("01AA1D853FAC38D9FC8DC1E65CED1574"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6000fd"),_T("normal"),_T("01BEB83A517518E7E38D6457D7B098DE"),_T("01EF98C649CA056505C41E28C21A354E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S602 ZOOM"),_T(""),_T("01C6EB2D5C761F5B0F41195E09A7C5E1"),_T("01EDB7106ED8CE9E8F7BD7F14EC44611"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S602 ZOOM"),_T(""),_T("012840C2B1FCCDE2221D57CD894F5898"),_T("015F4AA8F8D3132E1FAF5DB940997359"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S602 ZOOM"),_T(""),_T("0153F536ECB43EAF05B3724640284BC1"),_T("01E70A0FD3DB0A5288CF9E983B6F9531"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S602 ZOOM"),_T(""),_T("01315E29DF55971D2E1D34104AC3E495"),_T("01928C9C997CDBA38DA512091CF1A7F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0129F7BBA55E2EAEB8C9E3BDDBA7B64A"),_T("014363233109D50BE8328B6044FE1D58"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("019EF19678BB82F6281BF75BEE17635A"),_T("01B721616C882F82F632C9C9A02029A3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("018C380E60DF1314784C827EFEC4087F"),_T("01C4776D91252150EA3E030855ED4E70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("018E2B0BAB1091B759DA4A36C1498434"),_T("01B3E93337A2DC7DB01EFC7F0B9260BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01511F2752713A5E416E7F52CAACC00F"),_T("01652DC355F8FE9317D1ACD1B61F3BFD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0125360719B8F561A961A8205CA300A6"),_T("01A12CBCB3929F4F50A2361636A2C17F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0102FD60B1BEE5C1D4E09C430F3BAF8E"),_T("016A742831A8B18944908F8FE6667FF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0133353D7ACF8F6FFD9C833C91C2DE82"),_T("01DCD75B2D981DCBA8F67F138F5A4689"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0103AF85E3D5BCF4E131B579BE784A54"),_T("011FB35319800515F3B1AF9C01B98F5C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01338863A9E9D87C756424FEB020BD98"),_T("01D90BFC434FAD5B68EA3351CF827D30"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0143172307C00E1BF25477E64B4D871E"),_T("0149D17CAB38C9B9FEBDBA1E18354E75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0103D886A565CB92A2C07B1E83283938"),_T("01B0DFFF3B86F30AB053C9E4D90E2857"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01775803404B1F6E51DA270D875AE21C"),_T("018DE101321099CA44B3BBB7A971FC1D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01A1E20150A519300E142C5DFF57F49D"),_T("01A9F212229355222B1DF6D1C6BA36CE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0135B9D3FA43F42B228C8D68559183A1"),_T("01E9A7153A4282CFAFCB55AE330A529D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("015533F5B111AD9E51590E42BF1CF318"),_T("018AE8620E8E1B95D1C8FD0338613321"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01986403D0DB39CED56956CC83185747"),_T("01D8F9653754860125F8983DB814867D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01BD62DE4967E5CD3906D337D28B5905"),_T("01C9C71A684334A614FC1F7BE6A00D15"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01AB6FC5F47A256B85A06A20DF7A2E73"),_T("01D33FAE924EC067B2FA25060B9DBDDE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("01300CF6E26C44CA6E1F7E002E90E29B"),_T("01C97D0146AF14BC73CBB75FBC2DEA7D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("016ADD09C60862FD6F0B9452EC614AD8"),_T("017B24E070670F38FE2761B505BF97C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S6500fd"),_T(""),_T("0173E1FDEFE1767FC62734B7FD5B4FE6"),_T("017EFC8A48D105AD27C16C3EC1B7A211"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01986403D0DB39CED56956CC83185747"),_T("01D8F9653754860125F8983DB814867D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("0139C3609C7439A2677D0591BAA17CA0"),_T("017CE35D279F1A8B21080E0AE6C53CAD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01870F12535AD117686AA38D87F4F230"),_T("01F1932E46B612094A22F38BD5FF970E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("011A0B6A5E2CD8D701387C1B92673C51"),_T("01424F959EF392EE7D3A4B878C98E2B2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("0153F536ECB43EAF05B3724640284BC1"),_T("01E70A0FD3DB0A5288CF9E983B6F9531"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01B87A9323B8323DBBF8D268C8DA5CCB"),_T("01FA3743550ECF2375FD313472BC7415"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01269559519B7DD8BEF85FD3A3D36098"),_T("01699EC66C077829BFC5A565F2406A2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("0195EEA7C7FFC31874CB47F55A731440"),_T("01EA701641AE57738E101037BBDFBAC4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("012ACF619E4947C6342F0DFA82B454F4"),_T("017696925674863D4E93611CF53FE982"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("0158F705D871236CACBC097D8FF7E553"),_T("01C46C517D157C7456DAB45044446CB2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01D44FF54148D7672B0F9F149588C216"),_T("01FCF038CB0AFCB826D6834D3B9BB7FF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01B6370B0E1246DC33A50DE4AFAE3064"),_T("01C32DF8021355EF8B5777806A810BFE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01932B6BF7C7C4EA0676C13FE773E9F0"),_T("01B0A192C8D2D9B359A6A71DBFC65DE7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("01C1350830CDC224402C69FBBA4B4D32"),_T("01C40C78BB04798DE6386B16D6CA2F48"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("0160C13457E7492844700B1E2765A7C2"),_T("017374AB9A06F5B7D9C547A5D586B0BE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("011593FAC397BE3E35F132DA00BB55C1"),_T("014D9687F924E7724F494F7538C9C7EF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S7000"),_T(""),_T("014412B6367A91A2120C56FE9DEDCF7A"),_T("0199DFAF205A8F5ED6131F8C9D4E7C4C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("012DA6A8179D685C316E3561ECFDFBBD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0129F7BBA55E2EAEB8C9E3BDDBA7B64A"),_T("014363233109D50BE8328B6044FE1D58"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("013659FB683254FC54DDE61474AF809C"),_T("0174AB5078929D8E287FECAA4B30532E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0177F18C71320F7FF7F3B037DD101223"),_T("01D9F611647071948F3807C5C4C97964"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01089D27A104A81CE3A986763DEF98B8"),_T("016783137CC0098188020126C5327C0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01159F4F09FFCFDABE48FC7C23DCF0CA"),_T("018E6E27D7203B16A8C808E94F67089F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("018E2B0BAB1091B759DA4A36C1498434"),_T("01B3E93337A2DC7DB01EFC7F0B9260BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0142BD6537DD267D5315D93E3199D296"),_T("019F6B8CF9E4A7B141FF8C23430ABB79"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0168B62B2672A1EA16B5EEFCE01A5D3D"),_T("01DA3B84475F74FFA005D8B903F9305C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01004744D797C2E65F6E10A01801F988"),_T("0126C34F057B641EA35917CAE5BABD04"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0125360719B8F561A961A8205CA300A6"),_T("01A12CBCB3929F4F50A2361636A2C17F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01CF6837934F5586370A3208A5964B35"),_T("01CFFF16E1C60E2DBE37A43C7DC375A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01DE1EEA3B2C88A57A1D3894C9F4CA25"),_T("01EEFBA4B1584A8B8B670D9EAB8D0C9D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01338863A9E9D87C756424FEB020BD98"),_T("01D90BFC434FAD5B68EA3351CF827D30"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01775803404B1F6E51DA270D875AE21C"),_T("018DE101321099CA44B3BBB7A971FC1D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0126DAA916EC369FF8B1797B107C375F"),_T("01BAC7FF877B99FA2EFE0B0BC9A51F70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0147C9CEBD36DF9A8FC10C197C655B9A"),_T("01CBF7CACE5354346E834F315D68854C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("0115FB8DBBBF91B4B9D9F034824CB8DE"),_T("013855ED9741DF50B314E3AC7E2F6A3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01DF82190E252AC7A11162C378E74D8F"),_T("01F6A274D8F0CBC5C82B7B67941C1C8E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("014899659B5DFB996E7E35C3DA1F6211"),_T("017230BF5CE1D091A27340E31A89BF61"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("015BFED124534D3E92BBF2906045F273"),_T("0190E3CE4CB1DEB9C26685C28EE19669"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix S9500"),_T(""),_T("01B6890F97E3942CF6210514EAD0B4DF"),_T("01F14DAD8C7B9AAAC1F8DB9C88E21E3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix V10"),_T("fine"),_T("01DC8EA12E8F9DE73C730CE2710B6CB1"),_T("01FCD32DF9F3AF71786DD78DC0800136"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix2650"),_T(""),_T("0173E1FDEFE1767FC62734B7FD5B4FE6"),_T("017EFC8A48D105AD27C16C3EC1B7A211"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix2650"),_T(""),_T("0103BCA9D0FF326CE25144CF5AE1D884"),_T("019F7525A3CBF83459E6870C7D506833"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0139C3609C7439A2677D0591BAA17CA0"),_T("017CE35D279F1A8B21080E0AE6C53CAD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("019CAE8BAA4E0901A8132DB0460252E6"),_T("01D6C978E3AABF216D5CAACF54F63412"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("01300CF6E26C44CA6E1F7E002E90E29B"),_T("01C97D0146AF14BC73CBB75FBC2DEA7D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0131856988BD7B6B71E3C17784F3B1DF"),_T("0164A6B8BA79A38657D4129B88C1E935"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("012EFDA0756DC8F02E1314E0A85E38DA"),_T("0150B33D240B71C570632E01FEB03F89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0117AFF0AC55A9FA9B557341ED28AA4F"),_T("019FC66891E7C2CB433015662520C0B7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0102C9551E830545C18B70A571480094"),_T("01F15F441249A8D22F60EE46C1A5E212"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0178484D9EC1A5ECCEAE50569236B015"),_T("01A26D8FAC66BE2064402779D63E7401"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("014B61CBCC7D97DD7DB61C0EFD0AB9D3"),_T("0171C28AC02233CEF51F1715DD281396"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("019A4D45AE6936BB8BEC4EDE730117CD"),_T("01A11FE6F7D27DC64C8B2B33D2897452"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("017058A60BB7E5ABA088618FFB832B0A"),_T("01EE2DF6C151E5ACD0A3486FBF4E13BE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0120638613ED08DC3B923EC45E3F2BDB"),_T("01F85A256DFDBBC84214D566AB8AACFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("01162961AA289CC2513853FB31F0ACDB"),_T("0120F0B88A52100F82FEABC058B05CBF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("015474DAE40565467683F60E7D6B6F73"),_T("01B3F14AE750544D9C9AD20F6B823CEC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("015CE917BCF8AC73508BA0C75E562B75"),_T("01F42AADEAF7C0257B27DCBE24A2EAC0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("01957F28DB8A7D2E18F08AEA246A4DE3"),_T("01E323A0DF8F66AE1E221AE79A931716"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("01406565599DBF14F8047FC359DD66A6"),_T("017D5401D16B226E8EC07EDDA05439CD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("0189E78B2B76067BD8FD61F468E67EB1"),_T("01F59D383C499039CF4F238405E5F9C3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix40i"),_T(""),_T("013F606C45AD191612B28EEF1CF6D7F9"),_T("0170C371C8D24158A7740555A3D0254E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix4700 ZOOM"),_T(""),_T("01B9EBFD77569CE29D8C032DA51DAD85"),_T("01BAD4B2C44FC0802AD488E3B5325405"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix4700 ZOOM"),_T(""),_T("01BF1089DB13798CF30FA0B6E186875D"),_T("01F21F74C1D6A089ACB1C6E39E624E84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01400713A3B10D105792E66D14AE5117"),_T("019624AE422BF7F88A92118F611DD996"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("016ADD09C60862FD6F0B9452EC614AD8"),_T("017B24E070670F38FE2761B505BF97C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01322A55C3F539232F9F48AC5DCA0072"),_T("01448D46E463836F6191E0916423365A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("014D07412D807AFD47466BC3B2DCFD20"),_T("018571F62223F9611C5C82E33361D715"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("011F72189F16FB63160539354A378C18"),_T("01B57B0DB97AF420331DCB82522A4FC0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("018A502DE0262FC6DC8403269363DDAA"),_T("01931CC3681EB77CAE72911CE36B4E45"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("012840C2B1FCCDE2221D57CD894F5898"),_T("015F4AA8F8D3132E1FAF5DB940997359"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("017AAFD0B2845F41BAEC5521AF7E60BE"),_T("017CFBCEBE300D30A2D3DEAD73C002D0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("011BC0CF1B8F6C86A969EDB72AF27E24"),_T("01C994AFEBE3496186FC47707252ED30"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("0107F7F326C0D058D0FC463309D21C61"),_T("01FADF48C0D5EFBD05CA31667FBD79DE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01314A8C33DC01682816CD4AFE0E7B96"),_T("01FF7EAC06B780BA2C3FC2E5C66BFF3C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("0108B1AD56CEBAD5367B758EE1A63F18"),_T("017AC2BA97E4EDA4876AD2D0189C8F06"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01927DE8CDA4A34FD981CA1E4BA453B3"),_T("01DC11991BE26BEBDC12355CA2257CB1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("013FB5BDF7687EB994ECEB079C294E87"),_T("01D99CAE0607C1F221C77094F1740AFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01F555C022AB19D485F62E5008BC0722"),_T("01FD0F0A93A98D049E8365862CBC20EB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("01957F28DB8A7D2E18F08AEA246A4DE3"),_T("01E323A0DF8F66AE1E221AE79A931716"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6800 ZOOM"),_T(""),_T("016DFAF277299189E9A1092D09A50FFE"),_T("01E0D78873374FD205A32162BC32DC8E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0126DAA916EC369FF8B1797B107C375F"),_T("01BAC7FF877B99FA2EFE0B0BC9A51F70"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("015533F5B111AD9E51590E42BF1CF318"),_T("018AE8620E8E1B95D1C8FD0338613321"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0139C3609C7439A2677D0591BAA17CA0"),_T("017CE35D279F1A8B21080E0AE6C53CAD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0161149FCDDF874DEC4C938ED855AACC"),_T("01D3BAD36E511A7EAC1E7792840C74B5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("019CAE8BAA4E0901A8132DB0460252E6"),_T("01D6C978E3AABF216D5CAACF54F63412"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("011A4E131AE6141F56175D11C0FF08F3"),_T("019C6D82AB51688BCFEF61E51C4C4B89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("016ADD09C60862FD6F0B9452EC614AD8"),_T("017B24E070670F38FE2761B505BF97C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0132B6121FABF922EC108ED2299A4DF8"),_T("01B1D99243F7145290F94B0DDB143DF1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("010591CD94BABC13B571DEDB9A76B196"),_T("01F0E53A1233A692F0D17371293F5342"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("013220D5B0D1F5FE11D1EF6E38C75F28"),_T("01FF04703C85EEC5589CB5AFC641A3B8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0145F26B95FF8AF15D1A7DC64355F872"),_T("016D15F943FA53E2F9E93A89A926B850"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("014F18BED4590DE7A0360B979D6C1EC0"),_T("016FC2A0F1990575069647DB51BF5D98"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("011A0B6A5E2CD8D701387C1B92673C51"),_T("01424F959EF392EE7D3A4B878C98E2B2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("01C6EB2D5C761F5B0F41195E09A7C5E1"),_T("01EDB7106ED8CE9E8F7BD7F14EC44611"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("013848370A40F0D07134E5F819A35BAA"),_T("01AA5DCFB1E3186C06CED70E710F15C0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("018A502DE0262FC6DC8403269363DDAA"),_T("01931CC3681EB77CAE72911CE36B4E45"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("01B9EBFD77569CE29D8C032DA51DAD85"),_T("01BAD4B2C44FC0802AD488E3B5325405"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("018892FB2CB156925F1964F3023E30B0"),_T("01C678B5E26E2424556FF4830079520C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("017548B546BB0963B26B44611755A70D"),_T("01C985AE33A5F28E8BAB1D3ED75ED2A1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("01DF82190E252AC7A11162C378E74D8F"),_T("01F6A274D8F0CBC5C82B7B67941C1C8E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0105CCB4C4B348AE594D640D47A029B7"),_T("014CE1370398E06CCA7E7635DA264D67"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0125B5D4DAD31F73197E943B1FA80710"),_T("012B5C9C9DE2B306557D7F6F0ABBC33F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("0195EEA7C7FFC31874CB47F55A731440"),_T("01EA701641AE57738E101037BBDFBAC4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("015BFED124534D3E92BBF2906045F273"),_T("0190E3CE4CB1DEB9C26685C28EE19669"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePix6900ZOOM"),_T(""),_T("01DB93351D55A5C6665EB31A9849CC52"),_T("01DE4A1BA4CE22FA6FB6A0A223F62D8F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePixS1Pro"),_T(""),_T("013FA8B0D97468662280A7C33A960DD7"),_T("014B6B976D0DF6E350AD535F4BEA101F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("FUJIFILM"),_T("FinePixS2Pro"),_T(""),_T("014D9616BBF7E071E910B93ABFB21C27"),_T("018734006FEA2D30B1C0A8F47A50FF74"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart C935 (V03.46)"),_T(""),_T("013A863D37AA0BE299071B31D3548CC5"),_T("01704C1F618115BDBB14771D54A2F822"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)"),_T(""),_T("01205DF2136851A02AF30ADF84ABA11E"),_T("01205DF2136851A02AF30ADF84ABA11E"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)"),_T(""),_T("0116133E48F8ECEDAB742EBF6BAC284F"),_T("01631DCA5E69DD1AD024465A7AA266E0"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)"),_T(""),_T("0116133E48F8ECEDAB742EBF6BAC284F"),_T("01631DCA5E69DD1AD024465A7AA266E0"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)d"),_T(""),_T("01205DF2136851A02AF30ADF84ABA11E"),_T("01205DF2136851A02AF30ADF84ABA11E"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)d"),_T(""),_T("0116133E48F8ECEDAB742EBF6BAC284F"),_T("01631DCA5E69DD1AD024465A7AA266E0"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard"),_T("HP PhotoSmart R707 (V01.00)d"),_T(""),_T("0116133E48F8ECEDAB742EBF6BAC284F"),_T("01631DCA5E69DD1AD024465A7AA266E0"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Hewlett-Packard Company"),_T("HP PhotoSmart 315"),_T(""),_T("019199CA85730911299600A6D6C93A8B"),_T("01A383DA6BF7479D28B19AA0074FCF71"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE A200"),_T(""),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE X1"),_T(""),_T("01605B36C27A91863BAE84A614E5A6E4"),_T("01F92B192C6A8A1E122F5E86BF586B21"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("DiMAGE Z5"),_T(""),_T("01574BED6DDCCAA822CC146FBC040AD3"),_T("01B58D1B77454977FCFDA55DD2461963"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("MAXXUM 5D"),_T(""),_T("01DC669AEC37FB0775F2E831266AF705"),_T("01DC669AEC37FB0775F2E831266AF705"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("MAXXUM 7D"),_T(""),_T("01DC669AEC37FB0775F2E831266AF705"),_T("01DC669AEC37FB0775F2E831266AF705"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KONICA MINOLTA"),_T("MAXXUM 7D"),_T(""),_T("010C6FB9C20DA535F1E85B7129DDA2C8"),_T("013F4575982733FD3AC4FC46459ECCBB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE A2"),_T(""),_T("0151D6730547B1732F1428518F41C9F6"),_T("0180267FA9A456EDEBBCEE6011CB1AA3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE A2"),_T(""),_T("011158B7475856AC9E477562F1AE68DE"),_T("01BEF7217A1C2BD460A84D645491083C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Konica Minolta Camera, Inc."),_T("DiMAGE Z2"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("KYOCERA"),_T("FC-S3"),_T(""),_T("01CAE3D12075ADF4431488E73D758A9F"),_T("01CCD42AB84A46D8AC1AA4A68125A0DD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("01A80023CDC86D90CD9F92AF55575482"),_T("01B2EADEE5D2C6887670513AD186ACB5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("0131425FDE6F5E75E059E0550C40F980"),_T("015893E2971294882CF4EBDD82414044"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("01550C3F4489ABC67200B2CED3B02537"),_T("019D8ABB0272467D0F475E3CAB7B0978"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("0143E2834A286CF542FA2972C0478CC5"),_T("01D122D556870F2E0FBA1EB2B32EB550"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("016F84D0243E6A5B2CC1572E5CA4948E"),_T("01E13E8834276D783C8B088EA2E071B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("01146210F8F782499562164D98588DF7"),_T("01416268426EA8AA822C30E62CB99184"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("0120BC9F7FBDE71C9F7AF75F1271DE8E"),_T("0168E10B1946222765F3952D9095AA5E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("LEICA"),_T("DIGILUX 2"),_T(""),_T("01B02D6252495A2B9D08BBBBFEA0369C"),_T("01C44B75CC82D3AE8CA47C53C0367FA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Leica Camera AG"),_T("M8 Digital Camera"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Leica Camera AG"),_T("M8 Digital Camera"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Leica Camera AG"),_T("M8 Digital Camera"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE 7Hi"),_T(""),_T("0151D6730547B1732F1428518F41C9F6"),_T("0180267FA9A456EDEBBCEE6011CB1AA3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE 7Hi"),_T(""),_T("011158B7475856AC9E477562F1AE68DE"),_T("01BEF7217A1C2BD460A84D645491083C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("Dimage EX"),_T(""),_T("014CBA7CF41D9FFFD11933E748C4AC6E"),_T("014CBA7CF41D9FFFD11933E748C4AC6E"),_T("1x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("Dimage EX"),_T(""),_T("014CBA7CF41D9FFFD11933E748C4AC6E"),_T("014CBA7CF41D9FFFD11933E748C4AC6E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE F100"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE S304"),_T(""),_T("0184192EB1977CC6268343E6D3134191"),_T("01F0AFDCFFFAA57D4AD7C0227EE1B579"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Minolta Co., Ltd."),_T("DiMAGE S304"),_T(""),_T("011158B7475856AC9E477562F1AE68DE"),_T("01BEF7217A1C2BD460A84D645491083C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX L12"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P2"),_T("FINE"),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("0135744CED39E5E2D1D49B97A23E3ED4"),_T("01F8F364323CCDD63F0F238CA9CDCEB1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("013CB9B72088B06DE7931FD5B1C1A049"),_T("01AC143B735AABE226CF68DF7824E697"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("01574BED6DDCCAA822CC146FBC040AD3"),_T("01B58D1B77454977FCFDA55DD2461963"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("0144E26FB9BA003C2AF6A895D6E9CEAF"),_T("01B8E50677C21B70F8FC7A5FB398B8E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("013C26239BC3004EC0E1984F79A2E053"),_T("0159C4239254A897A6B1DA7E87648344"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("01533B110E20F3AC48999897834373DB"),_T("017CEDD8688FEFC6B8CAE0968021824A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("01B9E92D5CE414394429CCED76B89949"),_T("01C1C1593753CDBB62B9FD282846CFC7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("0163462BFBD4A64917560469CB201547"),_T("01AC950CF614B011A45DBA57653F8034"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("01764A58772BF2B2118E21F2035E3536"),_T("01A192EB488B778995905709D072210A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("01B58550F0786C24AD24DD26F9915727"),_T("01BC5FB692DA4A34C6A7D5438989B2F7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("015916E2168735FB572926A049B025DB"),_T("01F9ED4812F46CA42CB85C9371E94710"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("012706B411DF0C5629682D10083CB68A"),_T("0195F4BD0E07A4CDEF7400EC94BB5E75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P3"),_T("FINE"),_T("0159C3DD4607B9ACB9BB3F5D7191891A"),_T("01901016622EBC2E42EE162000A13DE3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("0123BAAA6DABBA3007987C5DD352F23A"),_T("0162F90EF60A9DB921AA87532AE23D68"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX P5000"),_T("FINE"),_T("012402B6D67E6105719FB11153F3C804"),_T("017E816CD8B40EB76B66F94A63ED38FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S10"),_T("FINE"),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("COOLPIX S5"),_T("NORMAL"),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E2500"),_T("FINE"),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("NORMAL"),_T("013ACAC180247B71700A6278939D82A8"),_T("01C67F4B42859DDFF107237CE8D4B047"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("NORMAL"),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("NORMAL"),_T("0120996088E68CF9F70A20A414D14AE6"),_T("013E3A5D329BBCB6AAF62F2E18FF8127"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E3100"),_T("NORMAL"),_T("017659A2F9A530359CB8725D32B5BE6C"),_T("01F863D3F47BE8F243BFF177EAC1EDB4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4500"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4600"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("FINE"),_T("0100E9AA36415D0482E7AD68EAF372C3"),_T("012840F1B30DA4789A3345257EEB59C9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("NORMAL"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("NORMAL"),_T("010176D29AD13D3FFAC14F0D3932B95E"),_T("01A05E3557B786BCF9267EAB607AEE7C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E4800"),_T("NORMAL"),_T("016C4383FFABE35F063D8FCB331942C0"),_T("019DC7724B5425C464D28F2CF78F707E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5000"),_T("FINE"),_T("012402B6D67E6105719FB11153F3C804"),_T("017E816CD8B40EB76B66F94A63ED38FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("01BC50262FBBFF6362759E0D0536794E"),_T("01F4661730D2DB6A83CF98B0179EB03E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("013CB9B72088B06DE7931FD5B1C1A049"),_T("01AC143B735AABE226CF68DF7824E697"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("0144E26FB9BA003C2AF6A895D6E9CEAF"),_T("01B8E50677C21B70F8FC7A5FB398B8E4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("013C26239BC3004EC0E1984F79A2E053"),_T("0159C4239254A897A6B1DA7E87648344"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("01533B110E20F3AC48999897834373DB"),_T("017CEDD8688FEFC6B8CAE0968021824A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("01B9E92D5CE414394429CCED76B89949"),_T("01C1C1593753CDBB62B9FD282846CFC7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("0163462BFBD4A64917560469CB201547"),_T("01AC950CF614B011A45DBA57653F8034"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("0173F1E44DAC63C1C6803AEB21D68121"),_T("01A7CCF0C258A5AA0A372238704D3964"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5200"),_T("FINE"),_T("011ED6AAC481E84EB7DF7D6C55C35FDB"),_T("01F41F75DA85DCEE81F79C9BFD835249"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5400"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("FINE"),_T("012402B6D67E6105719FB11153F3C804"),_T("017E816CD8B40EB76B66F94A63ED38FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E5700"),_T("RAW"),_T("012933907CE4B9D3C27E3E9D4D50BFD6"),_T("012933907CE4B9D3C27E3E9D4D50BFD6"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E775"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("FINE"),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("NORMAL"),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E7900"),_T("NORMAL"),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8400"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8400"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8400"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8400"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8700"),_T("FINE"),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8800"),_T("EXTRA"),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8800"),_T("FINE"),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8800"),_T("FINE"),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E8800"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E885"),_T("FINE"),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E995"),_T("FINE"),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("E995"),_T("FINE"),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D1"),_T("FINE"),_T("012A783CCEA06D57AFD2961BDCAB0D55"),_T("01C09FE954D02261612AB2F26E6C71AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D100"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D1H"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D1X"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("0119C6E2A0C136712CC82D09D3AD6D47"),_T("0165098BC665654C03482EBA8880EB6D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("0120A81C1C6B471497B2C39DD796FE4D"),_T("015E09F77A7C92CAAEEEB1C80AE632CD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("01292260CD87AAB3D2B0BC3DD8B4776C"),_T("016D5EE47029175386D08F8ED963988D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D200"),_T("FINE"),_T("012A783CCEA06D57AFD2961BDCAB0D55"),_T("01C09FE954D02261612AB2F26E6C71AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2H"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2H"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2H"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2H"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2X"),_T("FINE"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D2X"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D3"),_T("FINE"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D300"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("0114ED88173433C4BF99F0569EA94D90"),_T("019E0FC5DA517712EF95A6C1789E61D0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("01D13AFD01FF0B6EC46EA4081D25BB4D"),_T("01FF5BA518B453CC8F224A4C85505196"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40"),_T("FINE"),_T("010406665318412F7AE7B4533F75EB76"),_T("019363EF9F2ECA136B352D0C47E63CF1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("FINE"),_T("014277D1DDB84253758F0F33BA54C7A2"),_T("0149438163B8EE0EE5F349FB365DC931"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("FINE"),_T("0120A81C1C6B471497B2C39DD796FE4D"),_T("015E09F77A7C92CAAEEEB1C80AE632CD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("FINE"),_T("017211BC8C6161BCE36DB4E91A7A575F"),_T("018C775AA14027570ED51F477477AA84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D40X"),_T("NORMAL"),_T("016316C80954E937BBAC5CCDC94A2ABF"),_T("01CA96F6D54E052A082B32260A1C363F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D50"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D50"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D50"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D50"),_T("FINE"),_T("01337EA310F3CF72C36B8AA6F7B5B042"),_T("014D068B9432D4C85F0F18F767DD368B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D50"),_T("FINE"),_T("010CC33FB192BF2F6D9CB720360C5711"),_T("010F766EEF9BFC2D9829794E01D705EE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D70"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D70"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D70"),_T("FINE"),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D70s"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("0103A1C445586D96DAFDC06542FD9968"),_T("016F5C933A7B31BA8437BDB3DE186E60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("012F557E656D34C0A277B8470E9C4514"),_T("01E600E35F0A8CD0D9FE2D31B998D709"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("014277D1DDB84253758F0F33BA54C7A2"),_T("0149438163B8EE0EE5F349FB365DC931"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("0119C6E2A0C136712CC82D09D3AD6D47"),_T("0165098BC665654C03482EBA8880EB6D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("NIKON"),_T("NIKON D80"),_T("FINE"),_T("0100CFEEBE21B71A129B9F5EE8B64138"),_T("013D4003F1AB977990BD3347854082B2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Nokia"),_T("N73"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C770UZ"),_T(""),_T("0123BAAA6DABBA3007987C5DD352F23A"),_T("0162F90EF60A9DB921AA87532AE23D68"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("C8080WZ"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("0187D263643F75F6F2CEC032888A2A45"),_T("019DD36729BF82BD2C25365F97212ABB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("011441CDDA3078A5D1C163B3B0FFE1C5"),_T("01282C395BF9B7D99C09B71B657DA58C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("01D3C9C5AEB96A3600596D1BA8DCC518"),_T("01EFDDEBC09FEA0E4DEB1D6C1FFD424F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("01039FEC4F02406097182040B3440305"),_T("01C964F0D2B4E38AF575BA1091609062"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("014C4539278C70EB2F211DC2F3761A69"),_T("01E71E41ABAAD4BA2E4ABF26D2C1B49F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("0113CB6928D4C44D92A529E750A1FAFD"),_T("011E8E0FD2B78118E39762BC0450B648"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("012C6E06AB117D45972ED8E94A710463"),_T("01AFE9065B19F00A9A8B58AFEAC4B1C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("013BC890BA91666EE60A15E994089ADA"),_T("0187516AAE96E1CD50E9790E171BDD62"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("E-1"),_T(""),_T("0113C1943346397ACF92F02CD561001E"),_T("015782DCFB7A5EA4709477A956907A78"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("u30D,S410D,u410D"),_T(""),_T("014C1A2E427DED32AEA6FC03D0CA9B9C"),_T("01F48E8F658B3553CB6924724D135FE5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("u30D,S410D,u410D"),_T(""),_T("015B3D5A0AE6A4FF8E8DA3F6968F2C7B"),_T("01ADD0B7D7B22B46B4143A083E870995"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("u30D,S410D,u410D"),_T(""),_T("011B3C84FF1F9B0A5C68B6781CB9BC0A"),_T("01500507100E23146C1873FF72BAEEE0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("u30D,S410D,u410D"),_T(""),_T("0118DA9BA52EBDA65A929FBC36A5F758"),_T("01B2F246631E655B3A537725164E404B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS CORPORATION"),_T("u30D,S410D,u410D"),_T(""),_T("011E80B74A9DC355244D05164A4E66DF"),_T("0189751B3EF2F5EE04B8401B1E7D9CAA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("C70Z,C7000Z"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("C70Z,C7000Z"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("013CCB589498C2FA69ACF4F31643BCDF"),_T("016EA42E1A814C8939C7329EE6CD1252"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("0112276B312502E900C3ED93B9354F72"),_T("0172D8A74BE9D7F5922EE1FB37F03545"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("015B3D5A0AE6A4FF8E8DA3F6968F2C7B"),_T("01ADD0B7D7B22B46B4143A083E870995"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("011B3C84FF1F9B0A5C68B6781CB9BC0A"),_T("01500507100E23146C1873FF72BAEEE0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("014E2DD4DD4202955FAC8AC87B8BFE84"),_T("0170631E9C7CC7A0A4FF1BDCF40CE12F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("0118DA9BA52EBDA65A929FBC36A5F758"),_T("01B2F246631E655B3A537725164E404B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("011E80B74A9DC355244D05164A4E66DF"),_T("0189751B3EF2F5EE04B8401B1E7D9CAA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("01285979F5130214FEF7EA318B17BE50"),_T("01828B0DFD8C4EB651271D2476EA41E1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("013DED50ECAF324351680E680845F9E6"),_T("018E7EFB95EB0916122B1D3FF6C89439"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("0134A7CE8E7585FE1F943D0026551384"),_T("01C3C7E7FDAAC42F2237CCEE8D1B92C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-300"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("018A97EF0C8856D9155F90A770C73067"),_T("01F68622EE6EF782C32ACC2CCF6A9907"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("012F3FD7C72F5D59DD9BA311EC3435A8"),_T("017969AD15F95DA89D67B4C0D349E522"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("0137BCC4D1028471DB9567121B8F5ACD"),_T("014181969D6481A1AFA279ACD0D4A59A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("013CCB589498C2FA69ACF4F31643BCDF"),_T("016EA42E1A814C8939C7329EE6CD1252"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("014C1A2E427DED32AEA6FC03D0CA9B9C"),_T("01F48E8F658B3553CB6924724D135FE5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("015B3D5A0AE6A4FF8E8DA3F6968F2C7B"),_T("01ADD0B7D7B22B46B4143A083E870995"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("011B3C84FF1F9B0A5C68B6781CB9BC0A"),_T("01500507100E23146C1873FF72BAEEE0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("0183D94237D2A1462CF8884A2C58566B"),_T("01D2027538B7350A8CE3D2F9769B1071"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("0125417F733714AD6039B7B11F310C6B"),_T("016B64AD420E45930EB2675A84E11185"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("01285979F5130214FEF7EA318B17BE50"),_T("01828B0DFD8C4EB651271D2476EA41E1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("0108E559ED0A4C154B52686E91A352F1"),_T("014BD89E61593032748E58BD71B5571C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("0134FDC769F9513D03884B184C3B8474"),_T("01913604EDD203CB3CB8EF8D9405CC78"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("015867A80D31E8FBB5FA03FA5F803379"),_T("01CA611F74EAD0841DB3817C6FD50452"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("01C5E85A4DBCD5E098F88522E4ACDEB3"),_T("01FF0DBEC5FE494C16A5BFBB0692551C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-330"),_T(""),_T("018C33F34E14965F901D87E2F5059D76"),_T("01A2863D209D69C318C2D791ED4A198B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("012F3FD7C72F5D59DD9BA311EC3435A8"),_T("017969AD15F95DA89D67B4C0D349E522"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("013CCB589498C2FA69ACF4F31643BCDF"),_T("016EA42E1A814C8939C7329EE6CD1252"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01357CD849370F4A172BD943451FE6B4"),_T("01E09C16F2846C46555213A7AB078A89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("0101668016F68201E1DE902B7B3BD405"),_T("017C85A24795A05A2D425BE9067F3A00"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("0101668016F68201E1DE902B7B3BD405"),_T("017C85A24795A05A2D425BE9067F3A00"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("017C1051F7D1293ED3C00F4184A341C2"),_T("01CA25316D7681E90F1842212F04B5D7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("012A1EE3560CFC313F7C5D69E076BF72"),_T("013F7C8964CD3311BDA99091421C2891"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01D77879D457F2AC7CE9764A5EABF214"),_T("01FFE2AA1D8016FBFC7567FAD3422E88"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01206338DD44330548732C39C9898CB9"),_T("017ED526927F046AB92EEBAC17992610"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01770BAFC79685F009A0606BD51581B1"),_T("01A02E2722752A1B6A5D21B38C8BE458"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("010D83AB9B456604FD5FC580CE3C2AD6"),_T("0188C66E91A12D1245AAD86FB4CA0591"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01C5E85A4DBCD5E098F88522E4ACDEB3"),_T("01FF0DBEC5FE494C16A5BFBB0692551C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("01090555AE667AAFCC8690487D7ECFE7"),_T("0162B11FBE64420AD051A9204EC87256"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("013EEEE54844728CBFE64276B0896C4D"),_T("0163ADA62CF0747605CA7A66D8CE3BFF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("015B622B91A46CAED9398308D57CE89D"),_T("0160F37925702D99E90C7D82F42F2A22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("016282E23CADE6A86B7D47670FF06CB6"),_T("016476CE7011709FF925C9C788A84894"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-400"),_T(""),_T("010F11D5FAE835C77D3DD8BB379FA484"),_T("01397D113392AA4E41EC9521C95A62B6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("011706BAD6FC19A0F82C2DB0A76B9159"),_T("0166661BCE268A3178BFA5236FEF46F4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("011706BAD6FC19A0F82C2DB0A76B9159"),_T("0166661BCE268A3178BFA5236FEF46F4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("010590710A3F937EB8251BCE9037F8AB"),_T("012C9982B9ACBEA744752FD914C747E9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("013DED50ECAF324351680E680845F9E6"),_T("018E7EFB95EB0916122B1D3FF6C89439"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("017975CE66AC80239C28B5632F819EBA"),_T("01F1467C227A678A990547B58196DF5A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("0101668016F68201E1DE902B7B3BD405"),_T("017C85A24795A05A2D425BE9067F3A00"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("0143053BDE5FE1EF59EACEEDC1024A96"),_T("01DDE10D1E165421147E3B9137B15516"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("017C1051F7D1293ED3C00F4184A341C2"),_T("01CA25316D7681E90F1842212F04B5D7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("01B4A7A245551276F6519788823E2D60"),_T("01C5790C084B60EA44FCB4AC30219DE2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("012A1EE3560CFC313F7C5D69E076BF72"),_T("013F7C8964CD3311BDA99091421C2891"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("0119884C6EF97B8C8F7C2D47001CB7B1"),_T("01BE372491F24996F0B2105E372D0E2A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("016A22859FB33004511CB5B91680D0DE"),_T("019E3A4A333DBA72C95F0949E49AD767"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("010B19115B7E61CE2DB4BDA480120DEA"),_T("01BF61EACB8030C7AACFDB5A3A2CA383"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-410"),_T(""),_T("010D0A1D6CEE42FC5EA16089A0E5146F"),_T("011CE222910EB9DE43A04A865A42EB52"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-500"),_T(""),_T("0118DA9BA52EBDA65A929FBC36A5F758"),_T("01B2F246631E655B3A537725164E404B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("E-510"),_T(""),_T("01D77879D457F2AC7CE9764A5EABF214"),_T("01FFE2AA1D8016FBFC7567FAD3422E88"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("FE240/X795"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("011B20DC56FAA4C14E9139389EC259DE"),_T("016C1F26F78CB9D45A1D5F244123CAA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("01372CAD9800E68C2F9E94BC751B63C5"),_T("01B6EA567DCF6C0BED12D64BC86AA700"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("012402B6D67E6105719FB11153F3C804"),_T("017E816CD8B40EB76B66F94A63ED38FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0178BAF59FA3A93E45912D1A3AB3DFA4"),_T("0183C6D8ADA5B5856CB6C4CEAFA87628"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("010176D29AD13D3FFAC14F0D3932B95E"),_T("01A05E3557B786BCF9267EAB607AEE7C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP310"),_T(""),_T("0100E9AA36415D0482E7AD68EAF372C3"),_T("012840F1B30DA4789A3345257EEB59C9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP320"),_T(""),_T("010176D29AD13D3FFAC14F0D3932B95E"),_T("01A05E3557B786BCF9267EAB607AEE7C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP500UZ"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP500UZ"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP500UZ"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP500UZ"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP500UZ"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("SP550UZ"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("012F3FD7C72F5D59DD9BA311EC3435A8"),_T("017969AD15F95DA89D67B4C0D349E522"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0137BCC4D1028471DB9567121B8F5ACD"),_T("014181969D6481A1AFA279ACD0D4A59A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0112276B312502E900C3ED93B9354F72"),_T("0172D8A74BE9D7F5922EE1FB37F03545"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("015B3D5A0AE6A4FF8E8DA3F6968F2C7B"),_T("01ADD0B7D7B22B46B4143A083E870995"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("011B3C84FF1F9B0A5C68B6781CB9BC0A"),_T("01500507100E23146C1873FF72BAEEE0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("014E2DD4DD4202955FAC8AC87B8BFE84"),_T("0170631E9C7CC7A0A4FF1BDCF40CE12F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0107FCA83F17FA8F5DE5DE87C97ACB66"),_T("01161EE3B094F778304EE8AEB19C0F7B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("018E60C998DDC4CFE972FB9D6819E93E"),_T("018EBE4A99EFD4F4C02B09C7AA308353"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01C274A79362E9D34711FC55D55E432A"),_T("01C2DDB7BB8068B253FE087C9B6DA9F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("013E5D266F98E0E4BA51DEEB63949B4C"),_T("01935D9820EE9DF4858BDDEC7A36F27A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01592ABB5E932D863CF0B8D4344F4A8D"),_T("01CFAE5113F841AE9D212DBED3A37CE2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("017C1051F7D1293ED3C00F4184A341C2"),_T("01CA25316D7681E90F1842212F04B5D7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0101092454C6BA70F329E8323BA37A62"),_T("01D3F187A0B029D75287067CC329CBEB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0171FDB6AA66F1C1C71E52F49A6501AA"),_T("019B93D2807091FEA62161B7F3B2E1D0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0185B6CAB5D7A16084F11BAA56C09541"),_T("01FF11A44402FB7E615760C82130FE07"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01770BAFC79685F009A0606BD51581B1"),_T("01A02E2722752A1B6A5D21B38C8BE458"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0124A376C93414B16308422029BE7EB2"),_T("016711181F86C56184198107A8B1B2CD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01379C8FD2662AEAAD76CB1511BB084E"),_T("019EEAD0E94E444AE0CFCFD8FF684314"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("01784AF43BDB59E131697740D9F749C9"),_T("01C5A7E5F1316C4FC792054221B3AC36"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("0111F4F3A18657DCC662CD8EB1FE4027"),_T("013D6612D6D58DA0317FE1F808207124"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("018C33F34E14965F901D87E2F5059D76"),_T("01A2863D209D69C318C2D791ED4A198B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniD,Stylus V"),_T(""),_T("015B7616FEF5459D7774B52FF73427C9"),_T("016EC1CD6EC54DC6BA7A7F51B9DCDFEC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u-miniS,StylusVS"),_T("shq"),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("u1000/S1000"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("013EB82FF071762D5AD4098D6AAF6D46"),_T("01AC121D8B78786E79DB87C9244D6F9A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0118DA9BA52EBDA65A929FBC36A5F758"),_T("01B2F246631E655B3A537725164E404B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("011E80B74A9DC355244D05164A4E66DF"),_T("0189751B3EF2F5EE04B8401B1E7D9CAA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0145CCFB3CFD657AA47D68857C73808B"),_T("0187CDB41EB378C587B76E9CD566D8C0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0140475FCF05578FC1534AE1012A3E6C"),_T("0146DF88F666D7A82A0C6993869E5D19"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0108E559ED0A4C154B52686E91A352F1"),_T("014BD89E61593032748E58BD71B5571C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01357CD849370F4A172BD943451FE6B4"),_T("01E09C16F2846C46555213A7AB078A89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01B4A7A245551276F6519788823E2D60"),_T("01C5790C084B60EA44FCB4AC30219DE2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("012A1EE3560CFC313F7C5D69E076BF72"),_T("013F7C8964CD3311BDA99091421C2891"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01206338DD44330548732C39C9898CB9"),_T("017ED526927F046AB92EEBAC17992610"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01078E5F33C358C11D6FC20E07947670"),_T("01EF9D257F85D6DF20DCEEB140CEED51"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0171FDB6AA66F1C1C71E52F49A6501AA"),_T("019B93D2807091FEA62161B7F3B2E1D0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0116B512F11CB253BE375B6F9D1A4DF1"),_T("01BEC1DC1E365603C9A1F34A5203AB1A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0106565AA8AF8C8B175E2099D8554A55"),_T("01E0BA388CD18FF5EE51C8A0B4B9BC8B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0148E4615DD64A838FAFB981A86B933F"),_T("01B8633F273963FCAA0BB07A1E3D0806"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01770BAFC79685F009A0606BD51581B1"),_T("01A02E2722752A1B6A5D21B38C8BE458"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("013B9A18346B48620A5B169E05D2145A"),_T("01E39C266F548F608B50BE9F45058DEC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("010D7E6A57E24111A336CFCFAE264013"),_T("018DCEB3BF68D1005ED718D23FCADF0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("0150771598CCA9FA1386C8CF7CAAE2C8"),_T("01EDAFDF283C0E3E5329BECC28481DEA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01934C08AE04B95306C45924D92EDB7A"),_T("01F06F8AC2AF95397733F5D7FC833D60"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("01784AF43BDB59E131697740D9F749C9"),_T("01C5A7E5F1316C4FC792054221B3AC36"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("012F5BEAA2D4FFCFF102170F7B20EB0C"),_T("01FFD76F9A7419BFA21F6F377E1B9AF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("013AFFABCB152E7A0BD9109F12B9615E"),_T("015D476129065AC43A136F8E534FC24A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS IMAGING CORP."),_T("uD800,S800"),_T(""),_T("017CC9274A8BBAFF7C6C947CA346C10D"),_T("01FEA10B14C47C75407F3A4D09A7D902"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0123BAAA6DABBA3007987C5DD352F23A"),_T("0162F90EF60A9DB921AA87532AE23D68"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("012402B6D67E6105719FB11153F3C804"),_T("017E816CD8B40EB76B66F94A63ED38FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01AC139E31B941CA0F2C5B5A0BFCDFC0"),_T("01F3D5B0FBE08EC4AAE9E1E4238BF215"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("018F43694F4E9A49C24613CE0DB777A1"),_T("01BFD6DFF74A169EDA4F585691B1C832"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("010300D2A3C0CEB8216F7C59B96AFB16"),_T("014F706DC17A4AF11117D50B414F348C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("010176D29AD13D3FFAC14F0D3932B95E"),_T("01A05E3557B786BCF9267EAB607AEE7C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C2000Z"),_T(""),_T("01851AAA60C021C5E9C1235B2509BD09"),_T("01D126D2AA41BC051273FED404386FCF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("0124AC8790656DF23F8070E2A880B501"),_T("016CC716D191DBD0BB21F1090184405D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("018AD79CC6A9406F7CEA6B76F46AED2D"),_T("018B0C44364D83741C0A27927E2FAC1F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01AC139E31B941CA0F2C5B5A0BFCDFC0"),_T("01F3D5B0FBE08EC4AAE9E1E4238BF215"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("010300D2A3C0CEB8216F7C59B96AFB16"),_T("014F706DC17A4AF11117D50B414F348C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("01625155BE84D00125E6E169DF4A2F65"),_T("01C54F8112BAF719522090C85C5E23F1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C3040Z"),_T(""),_T("0138A8D4ECE59F41D2EB9AF5168B6675"),_T("01CA9A809F737BA668C16DDE52E74092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("0123BAAA6DABBA3007987C5DD352F23A"),_T("0162F90EF60A9DB921AA87532AE23D68"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("010300D2A3C0CEB8216F7C59B96AFB16"),_T("014F706DC17A4AF11117D50B414F348C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C40Z,D40Z"),_T(""),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("01AC139E31B941CA0F2C5B5A0BFCDFC0"),_T("01F3D5B0FBE08EC4AAE9E1E4238BF215"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0178BAF59FA3A93E45912D1A3AB3DFA4"),_T("0183C6D8ADA5B5856CB6C4CEAFA87628"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("018F43694F4E9A49C24613CE0DB777A1"),_T("01BFD6DFF74A169EDA4F585691B1C832"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0138A8D4ECE59F41D2EB9AF5168B6675"),_T("01CA9A809F737BA668C16DDE52E74092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("0120996088E68CF9F70A20A414D14AE6"),_T("013E3A5D329BBCB6AAF62F2E18FF8127"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("01786593B7990A17B0D81B6DF749470E"),_T("01DF37EBC825495EA04E9B311B77D309"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("01403088D08B8A2712CA648846151E07"),_T("01BABD681F45ABBA1BDCF41992781236"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("017659A2F9A530359CB8725D32B5BE6C"),_T("01F863D3F47BE8F243BFF177EAC1EDB4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C700UZ"),_T(""),_T("016A9F39EDF7E9DCAF8BE822C2266077"),_T("01F0A31D3842CFD4B7E09178F141E14B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("C740UZ"),_T(""),_T("01851AAA60C021C5E9C1235B2509BD09"),_T("01D126D2AA41BC051273FED404386FCF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0128413C51CDA1AB1E7E157A61FD358B"),_T("01689B8D30387E1072A93C36BFF81DEC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0117BDDBF4C4D5F2BD473867C268B992"),_T("01D67415634AF487A644D544967B5229"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01D72E86D9A71586407B16573061BE82"),_T("01FEE178671C154C42FD7275DA10C8B2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01CC5054634686211425F9313789330E"),_T("01D7C1596EF390EC64D371F4BBEED4CA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0190F389112850389D210F01DAC49ECC"),_T("01973B91796499966833E12D9F47D6F8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("011950D41F42D21E97D50473114BE0D7"),_T("01B93C2C9074C39E346E44112D11515B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01ABAB9098FBA1D73C384C3A89D54D36"),_T("01D88924E59DBFEDA69DB6878301F4AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("015D76974F1AAEE7318546F8817042CF"),_T("0192A37A39ECDB4EE3204E56E17613AF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01ED3E764331690417CFB0B6760E3CF9"),_T("01FECF64497ADED556DB6690691B2F04"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01379268F9FBE19C81CC00CD70598366"),_T("01F07D7BAE71080B3DD911AD4E97F511"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0182FC9E34E7EF518A5E521A73CB9150"),_T("01963E3DBE697A70C122A3973E90CB59"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01B0F9A7C7E350A1B701261420EC769E"),_T("01CDE58F50CD625612AE7FD49FB98473"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0181E0FA93A7C8FFBFAED0AB0A682EDF"),_T("01F73ED16F0BD0F7C73BD44D4839ED4D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("015B0307770D08EE38047293E49F7B95"),_T("018B755668E420798B44C06DEEF7A0B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("016EA0E7A46C136F2ABA8A0E865CBC21"),_T("01A15B41B7F74EB6449B8F8319248967"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("017DF1BD8B33D55134DD3E46656ED053"),_T("01A093ACDCA80186F422983344D97150"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0139D8C8782FE5A30C4C88D9FCAE8181"),_T("01CC38B6FCB0DEA0A013C4D914641E40"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("0164182DB61A14805CAA4F70E0415E53"),_T("0173FB6497370EE93BAE2DCDEE79E8AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("017858AF71B9A633FD70AEAB659B3300"),_T("01DACE21BB46E12DD3BC4727CD8D8210"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01069AD821B0103E56E421C38B5B2CD6"),_T("011497B7CD73D9D25DC361F5A34BDEB9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01794DB02469022B32443CA60688C148"),_T("01F86D4ECED7E890C68BE9D10E56274F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("017C0F23D27AAEAD889A664DC26AD545"),_T("01E97DB27309D1AB029F5BFF06FB3B75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("016398A5D03E9FA5A5974B9EABF113B7"),_T("01ADC2FDBC49253897195A5B8165F49C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("019444DDF02185A1932271ABB5EA43C2"),_T("01F912E034059159BF429BDBA8B7F988"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-10"),_T(""),_T("01C61A250680030358EF5227D70D1087"),_T("01E9E47BD2E94A56F17ADC1CD1D859D8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0108C44AD56089B4CD27462EF0E9E40B"),_T("01AD4F667053A6FBA82E3D2B0BC4A566"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0128413C51CDA1AB1E7E157A61FD358B"),_T("01689B8D30387E1072A93C36BFF81DEC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0117BDDBF4C4D5F2BD473867C268B992"),_T("01D67415634AF487A644D544967B5229"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("01CC5054634686211425F9313789330E"),_T("01D7C1596EF390EC64D371F4BBEED4CA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0190F389112850389D210F01DAC49ECC"),_T("01973B91796499966833E12D9F47D6F8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("011950D41F42D21E97D50473114BE0D7"),_T("01B93C2C9074C39E346E44112D11515B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("015D76974F1AAEE7318546F8817042CF"),_T("0192A37A39ECDB4EE3204E56E17613AF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("01ED3E764331690417CFB0B6760E3CF9"),_T("01FECF64497ADED556DB6690691B2F04"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("01379268F9FBE19C81CC00CD70598366"),_T("01F07D7BAE71080B3DD911AD4E97F511"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0182FC9E34E7EF518A5E521A73CB9150"),_T("01963E3DBE697A70C122A3973E90CB59"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("0145C214D721F708E0D4B76BCF1D4AAD"),_T("01EDD76E1D040E754652CDF54F4C9BA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("01590C75F0867760D72D155295E96425"),_T("01E27BBE5161A0E68048D0A194534D74"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("016EE1A32255BAAB84FC58ED3890502C"),_T("01A5D351507261639CE450B127B1475A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("E-20,E-20N,E-20P"),_T(""),_T("01A83536481A79EC40C50C791F1E4220"),_T("01FABFD178D6926A37E77FEA3B1A0C37"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("014A1C89C73A29E281A843479E0D8270"),_T("01FF143D8822FDACA79A68AA47A453B1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("0113C1943346397ACF92F02CD561001E"),_T("015782DCFB7A5EA4709477A956907A78"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("01065AFF4925691D6682020FE0351289"),_T("012B7A93E0F5D34E6922626FE3FDD0B5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("013C7B66311D04188EBDC1B1F80C5CD1"),_T("01607C40C6F84F1EC927665858404823"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("01992C72E3F2F6CE2A20CD738B766D9A"),_T("019DB237D8FE714224C756060548A8F9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("012221FB6D96695F14C7B12D99EA4E73"),_T("01D1729230BA2DF3602BE06F32BA0D5A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("0153A4E107A161D4EE844C4AC1E91AC0"),_T("01C2B103DC657341EB06FDADCFCFC1FC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("01732E8C7483DF76164E47EA5F45C18C"),_T("01EB3595DF117750F757BF015FBCC9D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("015EA26684DB82F5A340C79D9B28B646"),_T("01EE83B10EFF28C203E3B706416A5799"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("018C1CCB93439920B33C7AD4CA75C7BE"),_T("018D1DB0D777A5B623FA247CC2E649F2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("010A73C6212633C5BC7D1A24AD3F64C6"),_T("011227482A91BAC69AE87BA6F0494F96"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("OLYMPUS OPTICAL CO.,LTD"),_T("X-2,C-50Z"),_T(""),_T("01336A7453832F56E158AFBA35CCCE6A"),_T("0194012593362B6F226D47AEC452FA45"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0107DF00A3B3CC0618E1780640E7C637"),_T("01F909EF7883AFD92617F844C239E03F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("013C5D9A83F33B70EDD0EF4B175E4734"),_T("017B0CF969CF5E15D58B94F64DB0EDC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0138462F3B064F5A2D2735BCBD535472"),_T("01390D38EF6A011B05DD7B36A364A3BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("013DC48B707181D2512BD55D72EEBCF0"),_T("01DEFE52F8A7964EC92CAA476C1081C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("018E071D7C6333CCA941AF3F86C4B040"),_T("01F1BC59628C27605A47B1DD4DAFBD2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("01C91F94EE93568591EB96DA028179AF"),_T("01E1BD28E783DDA36EE9EF9124CB40AE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0122D115001A0F43E9F12CAF15140921"),_T("019590EE31CB1F94A5E95BB6D8A4D15B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("01CFFACD05293AA908AF4316230788E9"),_T("01DD5B33181B223F8AB26AEBDC6E8E84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("01198346965EB20066F6D7B6831E9C95"),_T("013E95521791B5B70228DE9E899234B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("013161476484359DD4D9CF9409A8D7CD"),_T("014BF262F2540BDB3D5AF1ADF46B1BDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("014D667B6CED05284B47E4C66FF4C609"),_T("015FC89EA6DB6E3DD7F8D77D7FA4480F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0104627D31E6BCB51040B2A47F908518"),_T("01C451DC68A972D099D1DAD1E315CF22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX01"),_T(""),_T("0177E3A26E664A95E6BAE877F3FA8E8B"),_T("01D3F65CE838517AA4ED750EDB8521D1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("0192E3B46CA4AA3BB9DEF414E8A36D12"),_T("01AD7C7F5EA54145C6376424C02FDCC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("011FA861380627C4E0D18BB1BE206178"),_T("0146D98747195222CB35EE2DA5F9BC3E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("0116E95EEDDF8CF3518E815BA203C615"),_T("017C4ABD754ABA2830C2F2ED1FE33B8C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("01693AAEEDEEA2DAF003F0981E32DB6D"),_T("01F2AD7A47E5E5458D3391E48F0862BC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("011F65BAC64F587C94E637D842323019"),_T("01310F546088EDA9A94120D7EC70423B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX7"),_T(""),_T("018141C2FC543690C76BA6C90CD1E379"),_T("01A5531E48945A567D9DDED506CAD64D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("013DC48B707181D2512BD55D72EEBCF0"),_T("01DEFE52F8A7964EC92CAA476C1081C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("018E071D7C6333CCA941AF3F86C4B040"),_T("01F1BC59628C27605A47B1DD4DAFBD2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("0186B5A9C29AD0C22B08617BAAF8B2F3"),_T("01AADE46228BCCA9AAC3BE09EF986623"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("0122D115001A0F43E9F12CAF15140921"),_T("019590EE31CB1F94A5E95BB6D8A4D15B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("01CFFACD05293AA908AF4316230788E9"),_T("01DD5B33181B223F8AB26AEBDC6E8E84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("014145865FE9A3D75612AD65CD0BF9C3"),_T("01680307DDD5C5366799674555B5BD2D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("013EF0E302E6BBE0C2AA0D9D85AF7990"),_T("014B2BC31CF89A8DC2B2C962A8CF82A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("01198346965EB20066F6D7B6831E9C95"),_T("013E95521791B5B70228DE9E899234B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("013161476484359DD4D9CF9409A8D7CD"),_T("014BF262F2540BDB3D5AF1ADF46B1BDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("014D667B6CED05284B47E4C66FF4C609"),_T("015FC89EA6DB6E3DD7F8D77D7FA4480F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("011D37296ED90033C19351777AAB0B38"),_T("01B2922FE979931BFD2586AB0267B31B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("011377E8CCEBED5DFA86FC8ACF2295C2"),_T("01ADCA18F8F8F4DF33ACD56F393A645A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FX9"),_T(""),_T("01E4CF70D3F4FC5894F625131F820CF3"),_T("01F9F607F691635857AE5C87E726A252"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0192E3B46CA4AA3BB9DEF414E8A36D12"),_T("01AD7C7F5EA54145C6376424C02FDCC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("011FA861380627C4E0D18BB1BE206178"),_T("0146D98747195222CB35EE2DA5F9BC3E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("011030DDD6A189F70FE3BA4CEDA10C0E"),_T("018FEC9B7763A5FBF41B927640234A6F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("01A78DD347695335597BFB27B18CEEE2"),_T("01F449D1310A4BCC04588AA07DC6F457"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("012E2FD711E336593E1E6661771EFF20"),_T("01BE5250860C140A34674091C55CCD0E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0116E95EEDDF8CF3518E815BA203C615"),_T("017C4ABD754ABA2830C2F2ED1FE33B8C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("011F65BAC64F587C94E637D842323019"),_T("01310F546088EDA9A94120D7EC70423B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0123684778F7F6D955AC459FBD1120CA"),_T("01BFD2C50315AD2DAE445AC96459B822"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("017E4C77A22222A6F09A53D932091662"),_T("01B7487CFD91880BA0489F67866571DF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0114007765A43A934A4DDC8A61E1562A"),_T("014BE2D26B383E99C16FF976EA5DFFB0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("0139D09DC9BF32F37522D4ECF507D39D"),_T("01D444AE0369695BF6F8AE7357012B48"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ20"),_T(""),_T("011CACC20EDB7B88165442D9C282E155"),_T("01D53767A9769BEFDD0487B8CED92BD6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("01146210F8F782499562164D98588DF7"),_T("01416268426EA8AA822C30E62CB99184"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("01B02D6252495A2B9D08BBBBFEA0369C"),_T("01C44B75CC82D3AE8CA47C53C0367FA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("014B3173926CDBA56C1E13038A53D12A"),_T("01CBA0981E28CD632712D268FB362E38"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("01A025B984771F2A9EAE24823D6AB63B"),_T("01DA5E9CB2E45878BD8FC0BE2F4DB4E2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("0153A205814CDE04D1706E59E8013027"),_T("01B0C46A0378B6F005FB98832273680E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("011B7750DE6D43BDE2BC3D14BBAD7414"),_T("013FA3066503A7D23032FC9D0987D322"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("011FA861380627C4E0D18BB1BE206178"),_T("0146D98747195222CB35EE2DA5F9BC3E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("01A78DD347695335597BFB27B18CEEE2"),_T("01F449D1310A4BCC04588AA07DC6F457"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("019653C54EB7D48750695B068423FF76"),_T("01B0180D7EED5FE5736800864F71B097"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("012E2FD711E336593E1E6661771EFF20"),_T("01BE5250860C140A34674091C55CCD0E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("0116E95EEDDF8CF3518E815BA203C615"),_T("017C4ABD754ABA2830C2F2ED1FE33B8C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("012A2AD50650A8B9646E8D9ABD3BFA88"),_T("018F2017595154F0F6593A89BC701E3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("0123684778F7F6D955AC459FBD1120CA"),_T("01BFD2C50315AD2DAE445AC96459B822"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ3"),_T(""),_T("018141C2FC543690C76BA6C90CD1E379"),_T("01A5531E48945A567D9DDED506CAD64D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("01B02D6252495A2B9D08BBBBFEA0369C"),_T("01C44B75CC82D3AE8CA47C53C0367FA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("011B7750DE6D43BDE2BC3D14BBAD7414"),_T("013FA3066503A7D23032FC9D0987D322"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("011030DDD6A189F70FE3BA4CEDA10C0E"),_T("018FEC9B7763A5FBF41B927640234A6F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("014BF769355E127A5014D2B5C2238F0B"),_T("01BCA265FDE2DDF5E1AF22F54434D125"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("014BA11590681A399B60019E89D95551"),_T("0196E966C2B3709B7836B021787B3EAA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("012E2FD711E336593E1E6661771EFF20"),_T("01BE5250860C140A34674091C55CCD0E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("0116E95EEDDF8CF3518E815BA203C615"),_T("017C4ABD754ABA2830C2F2ED1FE33B8C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ30"),_T(""),_T("011F65BAC64F587C94E637D842323019"),_T("01310F546088EDA9A94120D7EC70423B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("011FA861380627C4E0D18BB1BE206178"),_T("0146D98747195222CB35EE2DA5F9BC3E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("01A78DD347695335597BFB27B18CEEE2"),_T("01F449D1310A4BCC04588AA07DC6F457"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("019653C54EB7D48750695B068423FF76"),_T("01B0180D7EED5FE5736800864F71B097"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("012E2FD711E336593E1E6661771EFF20"),_T("01BE5250860C140A34674091C55CCD0E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("01AF869E9C11B22A86704F305C873B54"),_T("01C9C269CF6A8DC6FB6E7690FBD22450"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ5"),_T(""),_T("0139D09DC9BF32F37522D4ECF507D39D"),_T("01D444AE0369695BF6F8AE7357012B48"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ50"),_T("high"),_T("0138462F3B064F5A2D2735BCBD535472"),_T("01390D38EF6A011B05DD7B36A364A3BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("01146210F8F782499562164D98588DF7"),_T("01416268426EA8AA822C30E62CB99184"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("011B7750DE6D43BDE2BC3D14BBAD7414"),_T("013FA3066503A7D23032FC9D0987D322"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("0192E3B46CA4AA3BB9DEF414E8A36D12"),_T("01AD7C7F5EA54145C6376424C02FDCC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("01A78DD347695335597BFB27B18CEEE2"),_T("01F449D1310A4BCC04588AA07DC6F457"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("014BF769355E127A5014D2B5C2238F0B"),_T("01BCA265FDE2DDF5E1AF22F54434D125"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("0116E95EEDDF8CF3518E815BA203C615"),_T("017C4ABD754ABA2830C2F2ED1FE33B8C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("012A2AD50650A8B9646E8D9ABD3BFA88"),_T("018F2017595154F0F6593A89BC701E3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ7"),_T(""),_T("0101829004C47D7E3F6B71F56536BA02"),_T("018AAE1A612B247686EFDA55966E7683"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01146210F8F782499562164D98588DF7"),_T("01416268426EA8AA822C30E62CB99184"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0120BC9F7FBDE71C9F7AF75F1271DE8E"),_T("0168E10B1946222765F3952D9095AA5E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01AE77654BD30AB3892163E998A7CA6F"),_T("01CC4AC83792BB0CEEE11B2F773B71B5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0191A7EB3030A81F80E2059E5295F271"),_T("01D17DB6368FB3C5EB068CBD52B219AA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01B02D6252495A2B9D08BBBBFEA0369C"),_T("01C44B75CC82D3AE8CA47C53C0367FA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0168D26319E840447DE0FEB6916D097B"),_T("0198F32FC612493C4B8E63A36538B44E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("014B3173926CDBA56C1E13038A53D12A"),_T("01CBA0981E28CD632712D268FB362E38"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("014A1828D4C5D5228632ED107E5E372E"),_T("01F277EEA6356BA671EA2224C96CE68D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01A025B984771F2A9EAE24823D6AB63B"),_T("01DA5E9CB2E45878BD8FC0BE2F4DB4E2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0153A205814CDE04D1706E59E8013027"),_T("01B0C46A0378B6F005FB98832273680E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("011B7750DE6D43BDE2BC3D14BBAD7414"),_T("013FA3066503A7D23032FC9D0987D322"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0123BC6810721B28DDD0F4F3DCAA6277"),_T("019D8B7008873790DEF7D64A73B50A81"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0192E3B46CA4AA3BB9DEF414E8A36D12"),_T("01AD7C7F5EA54145C6376424C02FDCC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01A78DD347695335597BFB27B18CEEE2"),_T("01F449D1310A4BCC04588AA07DC6F457"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("014BF769355E127A5014D2B5C2238F0B"),_T("01BCA265FDE2DDF5E1AF22F54434D125"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("014BA11590681A399B60019E89D95551"),_T("0196E966C2B3709B7836B021787B3EAA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("01D9CAAD4A2D7DC83A6BADAFD0C00425"),_T("01F0CD875838DE7997852185F2378B4F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-FZ8"),_T(""),_T("0101829004C47D7E3F6B71F56536BA02"),_T("018AAE1A612B247686EFDA55966E7683"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-L1"),_T(""),_T("0169FCFCCC4D6CE6959541DC098BE408"),_T("01F9C0838D8AFDB904555F93BFAF238C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("01B02D6252495A2B9D08BBBBFEA0369C"),_T("01C44B75CC82D3AE8CA47C53C0367FA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("011B7750DE6D43BDE2BC3D14BBAD7414"),_T("013FA3066503A7D23032FC9D0987D322"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("0192E3B46CA4AA3BB9DEF414E8A36D12"),_T("01AD7C7F5EA54145C6376424C02FDCC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("011FA861380627C4E0D18BB1BE206178"),_T("0146D98747195222CB35EE2DA5F9BC3E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("011030DDD6A189F70FE3BA4CEDA10C0E"),_T("018FEC9B7763A5FBF41B927640234A6F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("014BF769355E127A5014D2B5C2238F0B"),_T("01BCA265FDE2DDF5E1AF22F54434D125"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("010F3953A08A959619F07E0BB01C8BF5"),_T("018C5063107B6A1357AC6031F8B67D42"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("012A2AD50650A8B9646E8D9ABD3BFA88"),_T("018F2017595154F0F6593A89BC701E3F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("018141C2FC543690C76BA6C90CD1E379"),_T("01A5531E48945A567D9DDED506CAD64D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("0114007765A43A934A4DDC8A61E1562A"),_T("014BE2D26B383E99C16FF976EA5DFFB0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("01A03C8460297BF48BC8FEB4FC637382"),_T("01A63CAA9BF37144D54CD5FEAB904CA3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX1"),_T(""),_T("013A0E62CC533A8F06C9241B1663A995"),_T("018C97A3CA4FA22079CC8A732C2EDFCB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("0107DF00A3B3CC0618E1780640E7C637"),_T("01F909EF7883AFD92617F844C239E03F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("013C5D9A83F33B70EDD0EF4B175E4734"),_T("017B0CF969CF5E15D58B94F64DB0EDC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("0138462F3B064F5A2D2735BCBD535472"),_T("01390D38EF6A011B05DD7B36A364A3BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("013DC48B707181D2512BD55D72EEBCF0"),_T("01DEFE52F8A7964EC92CAA476C1081C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("018E071D7C6333CCA941AF3F86C4B040"),_T("01F1BC59628C27605A47B1DD4DAFBD2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("0186B5A9C29AD0C22B08617BAAF8B2F3"),_T("01AADE46228BCCA9AAC3BE09EF986623"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("016D44ECEDC69CC32EFDBDB3FA52FF2F"),_T("017FD44400AB16F1FE452C02524238A1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("014145865FE9A3D75612AD65CD0BF9C3"),_T("01680307DDD5C5366799674555B5BD2D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("013161476484359DD4D9CF9409A8D7CD"),_T("014BF262F2540BDB3D5AF1ADF46B1BDB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("014293DC259CA2AD60B54C5E1DBD5BE4"),_T("017F0898D918195BE28D075579313D0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("01768F9D9AD459A2F0E12FF8FE7E58E7"),_T("01C8DAFC2B195EF06BE17FB14795E4FF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("01958DB41B5F276E1BFD5C17CC07BC50"),_T("01CD2F6EDA89988406EECE9D8C492B93"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("011DD5F353F534B7B9CBEE2412A65D5E"),_T("01E9E0E0460B869897F4107EBEFDC638"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("01E4CF70D3F4FC5894F625131F820CF3"),_T("01F9F607F691635857AE5C87E726A252"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("0134C04B9EA21B43C4EF2F5E9398FAED"),_T("0142C40B3C1A8BE418B8A6BAE99BF4B7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("01BB46E7CAF6065E33DD28A6E7EC9C03"),_T("01D4047F04C7C32C6FDDBBF5D71F4CFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LX2"),_T(""),_T("011C71CDD4C0F8F2CE09A808B280931A"),_T("01629B48C0D9C3358A36F1ADC61E01FA"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("018132019BC5CC9867CC79E9250560C5"),_T("01CF7D282F68C01148D58EE95918704B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("01198346965EB20066F6D7B6831E9C95"),_T("013E95521791B5B70228DE9E899234B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("014293DC259CA2AD60B54C5E1DBD5BE4"),_T("017F0898D918195BE28D075579313D0D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("014D667B6CED05284B47E4C66FF4C609"),_T("015FC89EA6DB6E3DD7F8D77D7FA4480F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("011D37296ED90033C19351777AAB0B38"),_T("01B2922FE979931BFD2586AB0267B31B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("012D088BCB11234F4DD3B0306BE621EF"),_T("01E45AC07E04EF2C5E8A37C82A60666F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("01BC09B19EB1EA65D20FEB9309259336"),_T("01E8286E6F2FE6CDD265F8441DC7B59C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ2"),_T(""),_T("017AF37B1EB466ADBB6C646D90A56E15"),_T("01E8D1E4A12056DADDE7152A0B9115B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ3"),_T(""),_T("018132019BC5CC9867CC79E9250560C5"),_T("01CF7D282F68C01148D58EE95918704B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-LZ7"),_T("fine"),_T("01146210F8F782499562164D98588DF7"),_T("01416268426EA8AA822C30E62CB99184"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("0182C24E1E5290C73AD84A7813FCC7AE"),_T("01C7160A775B4F76BC0438656E0FF092"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("013C5D9A83F33B70EDD0EF4B175E4734"),_T("017B0CF969CF5E15D58B94F64DB0EDC1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("0138462F3B064F5A2D2735BCBD535472"),_T("01390D38EF6A011B05DD7B36A364A3BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("013DC48B707181D2512BD55D72EEBCF0"),_T("01DEFE52F8A7964EC92CAA476C1081C5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("018E071D7C6333CCA941AF3F86C4B040"),_T("01F1BC59628C27605A47B1DD4DAFBD2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("01C91F94EE93568591EB96DA028179AF"),_T("01E1BD28E783DDA36EE9EF9124CB40AE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("0122D115001A0F43E9F12CAF15140921"),_T("019590EE31CB1F94A5E95BB6D8A4D15B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("01CFFACD05293AA908AF4316230788E9"),_T("01DD5B33181B223F8AB26AEBDC6E8E84"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("013EF0E302E6BBE0C2AA0D9D85AF7990"),_T("014B2BC31CF89A8DC2B2C962A8CF82A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("018132019BC5CC9867CC79E9250560C5"),_T("01CF7D282F68C01148D58EE95918704B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("01198346965EB20066F6D7B6831E9C95"),_T("013E95521791B5B70228DE9E899234B3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Panasonic"),_T("DMC-TZ1"),_T(""),_T("011377E8CCEBED5DFA86FC8ACF2295C2"),_T("01ADCA18F8F8F4DF33ACD56F393A645A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX *ist D"),_T(""),_T("012ECC6A2CB8921C19D4E9ADDE045BE0"),_T("0198B0E9CEFCFC54ED3BBAA91F3947F9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX *ist DS"),_T(""),_T("012ECC6A2CB8921C19D4E9ADDE045BE0"),_T("0198B0E9CEFCFC54ED3BBAA91F3947F9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX *ist DS"),_T(""),_T("012ECC6A2CB8921C19D4E9ADDE045BE0"),_T("0198B0E9CEFCFC54ED3BBAA91F3947F9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX K100D"),_T(""),_T("012ECC6A2CB8921C19D4E9ADDE045BE0"),_T("0198B0E9CEFCFC54ED3BBAA91F3947F9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX K10D"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX K10D"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0162BC9F7A5892E2F2DB22C82006610B"),_T("01EA5346C5145C7930905DCF6B31F083"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0150263B9EFAF0D3F1436478F497AF5A"),_T("018370CF802E9CF8FE79E29232CCD3AC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0134F2041810CE97DAAB408D5E71163C"),_T("01D831EF97768EF36E607FD5D85426FB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0123BAAA6DABBA3007987C5DD352F23A"),_T("0162F90EF60A9DB921AA87532AE23D68"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("012876087A56CFCA7CFEC7D254AD88D7"),_T("01C6BBED27FF2B3D0E26E4009B66E38B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("018F43694F4E9A49C24613CE0DB777A1"),_T("01BFD6DFF74A169EDA4F585691B1C832"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 550"),_T(""),_T("0182230692721ADF5DCBFB56F747490C"),_T("01DD92C0CD7077A88C49139F2F15908D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 750Z"),_T(""),_T("0130E17CF819C676B0C4E1D92B29E3D0"),_T("0148099C19C2AEEB10F7C98672C9FEF5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio 750Z"),_T(""),_T("015B3AC73951F0F8C2B83654AF587152"),_T("01BE05B882F033CCDFE7838FB2FE84F0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio A10"),_T(""),_T("010D5F6137BC7E0D9264FCE27CEE56F2"),_T("010D5F6137BC7E0D9264FCE27CEE56F2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio A20"),_T(""),_T("0196A4A230303DA672148A7723BA0A45"),_T("0196A4A230303DA672148A7723BA0A45"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio A20"),_T(""),_T("0110E4095D5E65A4ED3A79082BD1651D"),_T("0110E4095D5E65A4ED3A79082BD1651D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio A30"),_T(""),_T("0196A4A230303DA672148A7723BA0A45"),_T("0196A4A230303DA672148A7723BA0A45"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio M40"),_T(""),_T("010F0CB84C835BB4FCCCF6EE02335430"),_T("016C2B10163D7D4D412E22C026BBFE2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("01173DFDB15AEF0B8F8F7DBA935075C0"),_T("016B6E94C94F71C50644EB0FB3B797CA"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("011B5DB93D1920C4F22FE30C9D74B019"),_T("01817C5AAF8167836BE4F1FE59FC19CA"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("014021C1D4CC4D086AE9ECB4D74059E1"),_T("01B02C50605DC2BF1D4287C381033DEA"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("01B22FB5EA6896651D50C9AF6449C755"),_T("01B5D1CEC9EA1F3901B90F24ABD896AE"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("01069E2E226122744E5D3FCC5BD907DA"),_T("01135841705661AB895ACB4A742D5334"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("0137D4B64EF02801FFFCBB0CC37E6D14"),_T("018DE75B8C39571DE5D80B55ED6E40DB"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("01536F16BCEC1264BC0511A540801E5B"),_T("01968C8117F844F9A6419C4F192FA3A9"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("018C348769A146C48CDAD42B7E612974"),_T("01B90E7E70A6F27BB4153922849C5700"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("0121CCFD7E28555BAA5181244B39E4D4"),_T("016B0E8A7220EB2CAF7F1319967FC91A"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("012E4AFBCA09CE8FD90460247DF139AF"),_T("01900BBA2DFF8FFEE4C1C9ABDA1C2745"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("012C67677590471A0359CE86EE1D78FA"),_T("01AC53FE16B3241E100A052B316C5739"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("015D00310664D41A4A6D2E0E2F340385"),_T("01ABF0D27535C31F6BE2559024D247CB"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("012345305944D817D0C161C7B54BAF5C"),_T("017DDCB884AFEF1F6DD72AEA5D125933"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("014BA1BDD0180359CC4190D6229FFDDF"),_T("01C6957B3588A513847B8FA541A6F154"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("0110ED34D89C23D3FE25D19D8F11C7B7"),_T("0162043D57592A98CC22BBCC1C7E1EFC"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("0176898E9E79FCA6F38E219E765888DD"),_T("017BB107FA4D61F8B85BCD845DDD93B4"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("013F8DB7C0AE9774B157A59660DCEF10"),_T("01F196CA415D9FF6662FA9A3AF99F1AC"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S"),_T(""),_T("017D4C33EF2B651D308D32F6DF71963D"),_T("01AF9D48ABD1FE131FBB9D5CCB3EC659"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01A0FB219D74904EAF637293A0F31493"),_T("01E3F3BE628274E6C1D4856D8DC20D0E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01158B0D515E752B1B0716889F2B3371"),_T("017BBA44ECD57A9B2E59D0D6967F1623"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("013B1FC692BCCE8DBBAEA5BD4DC13F87"),_T("01DB220936AEBE1D36FDF3382FD48D2E"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("018A97EF0C8856D9155F90A770C73067"),_T("01F68622EE6EF782C32ACC2CCF6A9907"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("011ED04C97FD28B94C49DA6F353F6EC7"),_T("015CDC228C3E4F86A815998B228353E7"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01534F696E6036C0F788B7E655AC8296"),_T("01DFBB572EC62EA7B91E6179FDE95E64"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01133005CDA1908ED26E50DDB781DF3D"),_T("0160796D6F8855EA95ECF106A9654836"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("PENTAX"),_T("PENTAX Optio S5i"),_T(""),_T("01C02F25034BDF89C44B5D4FF79274B0"),_T("01ECDD6995EAB2286B85FC2B730162B6"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Research In Motion"),_T("BlackBerry 8100"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Research In Motion"),_T("BlackBerry 8220"),_T(""),_T("015058863386110B7045FC40D0B47450"),_T("017B270E20A299F9D227B485DD5A9BC0"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Research In Motion"),_T("BlackBerry 9530"),_T("Superfine"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01407EB22CA143AC5D93A6849A7FEAA7"),_T("0157FE31F260013F0ADA57D0F1717DB4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0120A81C1C6B471497B2C39DD796FE4D"),_T("015E09F77A7C92CAAEEEB1C80AE632CD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("012E8AB1306B60B6F8E1D673C857EE3A"),_T("01930E8CA4514118CCC2A71CD51FB6A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("016F77F4F618340DFA8D4DB85506B0D7"),_T("01726AA8F1753F6CFA3AEC3EC6A8F818"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("012D53B2BC8DEEC423C726A99B23EFFB"),_T("01342830C284AABC77AEBE2A43D20C2F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0140C3DDA9D3F807E4D5FD42CB7F7401"),_T("019407145AD5FCC16FEC932CCBC8A9AD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0166D7C4514A1B5BF17A8A31C90EF2D3"),_T("01E4481CC143080346658FEE1819556F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01A940AF62216A26DC513D6BDA9F0701"),_T("01CE6F38DBA971F907620725AC62EDF6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01D5393400D7C7676C33FFE7B0058C2B"),_T("01ECDF62417BAFECAB21ED7394C3302E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("011E63634FA82881580FDA27C4236F17"),_T("017BB1C8854A1FE91C2AAC2B0C5DCED7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("014E56BC9BC75A3853C76762DBA89741"),_T("018A49571355BE8367CF9B25F2D7BDA4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("015DF0EF77AA51618EF0438E14C99A7C"),_T("01C5A27A11860EEEC6677C345637D3A6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01916A2F71719701991D51B431766405"),_T("0194DE526E131B12BA9CA01B3623B401"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("014263F0A2FDCD405EEB3E857088CF2B"),_T("0198BD9B01BE7BDFC5734F86B17A4B4E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("010CC33FB192BF2F6D9CB720360C5711"),_T("010F766EEF9BFC2D9829794E01D705EE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("010B3F0B475B9082D702F9C46AC041F7"),_T("014E7F78F0BB99F85D5A30D64641C1AD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0172A66D9B79583F96160F0977E50ABB"),_T("01E6372FFE99AA515645F757C6A7829A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01E231E0B0AD1CA2327570EF255B58A5"),_T("01EEDC9369B1AE507AD0EAC4A9FAFADE"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0138D93AD569F4A6DDA706D4C29ECF62"),_T("01832CCB523483953FAA4D9EF090AD7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("017C6B0B992BF83D07547D6D3DD9E327"),_T("01A1B2B680A7A1010AFC443A26B4AB93"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0118E8265FC7C96FE9E57D127154C1EF"),_T("0190FEEF53AEA16907E09255D2D7431A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0109795E5DB4D422FE6B1949FF142172"),_T("016A02998856C8628E975A95B2293848"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01A465994803BB73ECB03A30E32A9599"),_T("01B3BD820D3A06A710CA6BA6D6B4B639"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("012C1E92CE901A9022CB5FD8282E00DB"),_T("019102DFD4F30C9EAA8B16AF21908898"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("01773241DB0BF4F8D415F19CEBB787C3"),_T("0191FDD3348E5D33208A12821DA15F11"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("RICOH"),_T("GR Digital"),_T(""),_T("0141CE8E21211A09448DCACE8DC51CD4"),_T("01BEE51B29F37D8A5A7BC31C63A652BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01C6769F955C867455C153847C74E6EF"),_T("01EC1CBF6C8662E52114F39EE148CEF7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("0113A2B410CA72B083DF5810A3E3B864"),_T("0156501AF03F0CAA64E7A7956E73BA36"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01855CE0D173027D32B5235EA39D7A1A"),_T("0196BB1FB30F48B5813991708301ECF7"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01B654B54E59A5BD891D0D46B0AE5700"),_T("01CE3648755C5E28D788D4D41892D74F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("019811E20AFD55A42B1C23F704AA9455"),_T("01CD08024A418DA37AF5E3C310299FAC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("0138DF7EECCBD6DFA2AA97A7ED98F9C9"),_T("01822C655B2A1BBFD1095FA6CF8CDC4F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01E3AF5C11ECBA1BDED80818B86A11D7"),_T("01F3BC7FCF52B7F7062B9460473B9128"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("010B2D80F047E0F70631DE68432DAF6B"),_T("01A258C809C4EAC518FAB39067B15EFF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("013E22A3FCAE62D2BD90C219E36F1146"),_T("0149B05374B1345932869E6372ED0485"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("013F402F00B9A0C3102B989150765365"),_T("015BC8A6314A5E90EFD59DF85EE4AC83"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("0184DCF92E592A5982ACC908BA00A472"),_T("01A0D60381102F12B8B8B7AFE0AFEEA1"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("019D7E45EEE96AB2F2F117390DBB5CE6"),_T("01CA95CC822CEF61DE2D1A73DC0253D2"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01683B19EFCF77DD132F0FA65417C2B8"),_T("0196C06916DEAB56AAE98FA378D1533E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("0142C33C0C4072C4FE6CF0D692AEA8DF"),_T("019E26D1A1D23881A7FFAFB39D0863B5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01584549461851E6B504905DBA2404AE"),_T("016738090663999BED71FF0ABE2C3247"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01A5020E4F4CC608563561E25F924693"),_T("01F4A5628F4904EB870522FF06D62F82"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01A464CBA79019D90DB72915151295A4"),_T("01D38A3553CEE799B0E0D1645CB4B9F5"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01903CBB5777CC392122384B2778F808"),_T("019BF9AB7533677149C6F2022D1A6398"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("01D8241004A2F31D77D8AE109E2C1965"),_T("01F7B1DA8FFC33821446BCC0360B89FD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10 / Digimax V10 >"),_T(""),_T("012B47549F5F32EE33A1FFBDB56E2899"),_T("014F1DA0331B7D42C7B19A7841722055"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("015F52865AF840E866CE4FC92CBA216E"),_T("018CD4FE97236D5ACA212D9945920F07"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("01098170130C8E4660FCADF13D54D691"),_T("017C96A497120FCD8FBF9C3A08AD9FFC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("01349952A8F476A506636F184C339776"),_T("01EA0154C99CDE8FB89FB42F9D5FDAB9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("010B2D80F047E0F70631DE68432DAF6B"),_T("01A258C809C4EAC518FAB39067B15EFF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("0101795CE0D98BABE2BD57034849C925"),_T("01A7FF8625C86B3E99E55BF02B8C438E"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("013E22A3FCAE62D2BD90C219E36F1146"),_T("0149B05374B1345932869E6372ED0485"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<Digimax V700 / Kenox V10>"),_T(""),_T("0141808604FB9D4DA90E3B5B6F8C9434"),_T("01E4FE15DD3789354DA16A873745D01F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("<KENOX S1050  / Samsung S1050>"),_T(""),_T("01094BA340F15215478EA7244B41C831"),_T("016774C49D2D9056742699631887A1F3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("Samsung Techwin"),_T("Digimax V50/a5"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("Pro 815"),_T(""),_T("010300D2A3C0CEB8216F7C59B96AFB16"),_T("014F706DC17A4AF11117D50B414F348C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV 7, NV 7"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SAMSUNG TECHWIN"),_T("VLUU NV10, NV10"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01687A34DFCE112C64A9A8B662405FB5"),_T("01A711E09E62AE95248FF0B5F8FED76A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01D85DF4F5A6AEEE0EB14899034DC2CC"),_T("01DE4C91AB91D804F823DDBBEFED0C80"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01942B85D5DFEDD8B2BA6B1113B78EE2"),_T("0195A50084E3EAFB04010E04AC831A0A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("0118F69D273A291E8C84DC722CA95DF5"),_T("01192BB7696A82DAA10BCBDB0538FBF9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01BD24596581D7A1535AFC805B0D60A2"),_T("01D47AD28A985151B705F90864369E2C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("01AC139E31B941CA0F2C5B5A0BFCDFC0"),_T("01F3D5B0FBE08EC4AAE9E1E4238BF215"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SEIKO EPSON CORP."),_T("PhotoPC 3000Z"),_T(""),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SIGMA"),_T("SIGMA SD10"),_T("Qual:12"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SIGMA"),_T("SIGMA SD10"),_T("Qual:12"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SIGMA"),_T("SIGMA SD14"),_T("Qual:12"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SIGMA"),_T("SIGMA SD14"),_T("Qual:12"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("1x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SIGMA"),_T("SIGMA SD9"),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("01B4A094E3299D54C686AAC3A9E68DA3"),_T("01E79C7A6F55D80F5CBA8BE9834FCFBC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("017D916C205AEFFD4A087EBF94C7506E"),_T("01B41E10A3065957FB93F928542E3BE8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("0123A1A8835A75EE1DE4DDDB26B19F17"),_T("01D587857C3B50B1C030DD163E85021B"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("015109957D8D4AFEF6E13F4663725048"),_T("01DF5042708CA669A4CD1454906667C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("019CE3957D32D1795897B849160802E5"),_T("01AE0DBDE466823C5A17DED45D11DB22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT"),_T(""),_T("011DEA5F26F562AB40D55A90630F7653"),_T("01A6F8AC827B402FC7F102B182B2CFC9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("CYBERSHOT U"),_T(""),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T("2x2"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F828"),_T(""),_T("013E4F4032D7BBB022EA8A4DD2A79AA1"),_T("015DD46C027E5E984C8305753B29931D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F828"),_T(""),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F828"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F828"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F828"),_T(""),_T("011DEA5F26F562AB40D55A90630F7653"),_T("01A6F8AC827B402FC7F102B182B2CFC9"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F88"),_T(""),_T("013E4F4032D7BBB022EA8A4DD2A79AA1"),_T("015DD46C027E5E984C8305753B29931D"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F88"),_T(""),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F88"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-F88"),_T(""),_T("011599F2B12AC57E3846AB3F9B84F65C"),_T("01B95B9EB7508DC0C23E40DFC6BE2512"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H1"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H1"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H1"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H1"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H1"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H2"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H5"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H7"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("014D29278FD055B04D8FCEF52F63568B"),_T("01EECF7F5B388E02EEE84ABDCF4CECCB"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-H9"),_T(""),_T("01786593B7990A17B0D81B6DF749470E"),_T("01DF37EBC825495EA04E9B311B77D309"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-L1"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-N1"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-N2"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P150"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P150"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P150"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P150"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P200"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P200"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P200"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P200"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-P200"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-R1"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-S90"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-T100"),_T(""),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("01B4A094E3299D54C686AAC3A9E68DA3"),_T("01E79C7A6F55D80F5CBA8BE9834FCFBC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("017D916C205AEFFD4A087EBF94C7506E"),_T("01B41E10A3065957FB93F928542E3BE8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("015109957D8D4AFEF6E13F4663725048"),_T("01DF5042708CA669A4CD1454906667C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V1"),_T(""),_T("019CE3957D32D1795897B849160802E5"),_T("01AE0DBDE466823C5A17DED45D11DB22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V3"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V3"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V3"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-V3"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W1"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W35"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W55"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W7"),_T(""),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W70"),_T(""),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSC-W80"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSLR-A100"),_T(""),_T("0138E0E373A395C2E98FF667B21870CC"),_T("0138E0E373A395C2E98FF667B21870CC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("DSLR-A700"),_T(""),_T("0138E0E373A395C2E98FF667B21870CC"),_T("0138E0E373A395C2E98FF667B21870CC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("011B33BAEED0A54091895B8D5389FA91"),_T("01E5F053039A59A823FEDC91959822BF"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("01B4A094E3299D54C686AAC3A9E68DA3"),_T("01E79C7A6F55D80F5CBA8BE9834FCFBC"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("017D916C205AEFFD4A087EBF94C7506E"),_T("01B41E10A3065957FB93F928542E3BE8"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("015109957D8D4AFEF6E13F4663725048"),_T("01DF5042708CA669A4CD1454906667C4"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("019CE3957D32D1795897B849160802E5"),_T("01AE0DBDE466823C5A17DED45D11DB22"),_T("2x1"),_T(""),_T("")},
{ ENUM_EDITOR_CAM,_T("SONY"),_T("SONY"),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T("2x1"),_T(""),_T("")},




{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T(""),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("000-001"),_T("0138D27C7EEF02B3AB3313CD713E8134"),_T("01D70ED96E34F308DB1A0848A943DDC4"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("002"),_T("011386C6B52F40BADA59DA38760E742F"),_T("0139107E395BC07B318B5EC0E9F6A283"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("003"),_T("0159463DC4E43388BCC153A437842F15"),_T("017A8FCB62FED5062A6DB85334F299DF"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("004"),_T("01130984F055CB0734DFE9120AE608A9"),_T("01A5CE7EC04CE304D74A544A905A8125"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("005-600"),_T("012CCAA4D0460DAD73BE0DECDBA04E21"),_T("0136AB2C178AF7EC6F22CE56DCF2F0AB"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("007"),_T("019833C578EB378FFBFACA37C5E3F219"),_T("01F95C855A1F379C3CC789A80D610101"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("008"),_T("01303D41327C5F81D755996EA1C8F1DC"),_T("0158FB8C5B854AE80A56BD090B82AAAA"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("009"),_T("017AAEFBFFFEC743BE469EC9596717F1"),_T("01A488D7614F4AC0E683C477AD5DCB0D"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("010-011"),_T("0150F2E76158ACE070DADA0C1B2EF396"),_T("01FABEDD10226CF93CB1E7390586140C"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("012"),_T("0105694D3A60EF8B068790263E3C1F64"),_T("011A74C0287957F725CC611660CDFF39"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("013"),_T("01703B12AB08246102043E762591206E"),_T("01DFA2CCC4055F0DB26870FEAABC5C09"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("014"),_T("011B207D670A565F68E79A7BE837635D"),_T("0138F3064037793EA8824A88441C3379"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("015-016"),_T("0147438D96A1D4C93DAE41F36DF4B9C4"),_T("01C19077E605B2CAE33BCEFFAC7AC110"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("017"),_T("016C045902D3F378009ECC6AA271124A"),_T("01D4890A48F5290F27CFDB5BED360D78"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("018"),_T("014BFFD73E371DE01C8CC4B30F2FF7B5"),_T("019D01D87616A4737618729D6DFC552E"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("019"),_T("0189543DDE1BE069368F49B421EFB312"),_T("01B628D80BF1F36B67F3643C0B43B4E1"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("020-021"),_T("017589061A7DA6B30DF34A514AF87692"),_T("01BFFB5FB1318ECC4541CCE316813CFD"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("022"),_T("013E7D04521AC131191558F1EBFC1422"),_T("0157A84F104FDBAB29766F29B675609D"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("023"),_T("01443D23B61DFE645C516FA7D26ED0E0"),_T("01F78F60C79374F89F8BC8EB5AF95047"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("024"),_T("01CADEEA6D4C87A401681BE2BF6189FE"),_T("01F59FC240430708D00AE746922891E0"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("025-026"),_T("017539FD56DF939BCE98C6579237C990"),_T("019A22644832C0A7E445677EBCAC1281"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("027"),_T("01204B752AAEBE51E57D06CB3FDCB48B"),_T("0181DC7BD18DD9FDE59E76F26E5541F2"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("028"),_T("01788CB9C83CF50B847C8A7760659544"),_T("017E9DCD06418EBF8D8CE2FEA4D19C32"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("029"),_T("013C5B4643DD6ADF550B23C67A4DFB25"),_T("018288F50215A7693617F920D19AF81F"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("030-031"),_T("011214AF9B0A7890D8DC588CC88A5FEB"),_T("01BF7D3BEAAC4CD8821795FADAA05AB9"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("032"),_T("010455DF473F62044D313A95F6B8C203"),_T("0117B6A72284D6C5F2F5D52D583C9A9C"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("033"),_T("0107E24545E03C45A2C8806D4D11E64E"),_T("01CEC660B66A2A9A8F27CE73E2F7FD7F"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("034"),_T("015239267819AD908CBF72984A9EE8AD"),_T("015819A335BC138743DB48271ED66D38"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("035-036"),_T("010C69E37CDA707F8DB41957E1BE8721"),_T("013EE695988AE5866D3BC80C01EDF1AD"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("037"),_T("010F99140A5A95CC42052808231CAF3D"),_T("01DD988FBC2A1D333FEBF0BB3B46C680"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("038"),_T("010D2888FB173C6821C5958697347F8F"),_T("01E3534FF692FAE47CB617751CEDEAFE"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("039"),_T("01929371778243D865240876945323C9"),_T("01F4AE9E56FD1F2D7895EF779F7521A1"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("040-041"),_T("0190F119A0B474CB73448F1895BFBE31"),_T("01F25CBB83BCD0E1E894F20647D07476"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("042"),_T("01973F7E8EFBBF63B293A4A7D0951902"),_T("01AFAECC1EC469727C0D3A0F618718A7"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("043"),_T("014EDA494C563A45977F05858B440735"),_T("01ADAD0EA6FAC8EC39E6BB9F80A2B5FC"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("044"),_T("01212BB4A3C5DB6702F929C338CC483A"),_T("01DA92F4AB571727EE61689446AB8ECE"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("045-046"),_T("010CC15B4643F88FC4A52E0A85D791F7"),_T("0187A1A2912E4742B24CC3B3AD0A1465"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("047"),_T("01A5EE2681EE6E4FEFA887661A193308"),_T("01E27A642E2D09EFF8B133F03B603282"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("048"),_T("01010BA0CB90E6E8B55F0ACAA8CB1D21"),_T("01FD78538EF8960FF993257E5050AE48"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("049"),_T("0114717D20FD02CF5321B7A85D8440CC"),_T("0145BF8B1C7367D83231FC6721828A9B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("050-051"),_T("0134368B6244F8CE214E1D6FB34735A3"),_T("01F6CBD459813DD2CA23C36B6ACB720D"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("052"),_T("012CB626F43DA8BF2607C70F9B7D0977"),_T("01EA643AE20A86AA7DD4DF1DDCD76718"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("053"),_T("013A5F729164EFFCF0EB088CD45D926D"),_T("01E3B128CDFFB87298D438EE74DDA17B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("054"),_T("013E58AF3BB40DD88C5E49C7F9CAB7B0"),_T("01FF0D5D047A4AD1FDE3A2AEBDB7C15B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("055-056"),_T("013BE45647CC6624E7EF97898D19F980"),_T("0196B6D81E1EC891B78A6FC41E501EE6"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("057"),_T("01D0E43E7DEF23651B8F486C4563E9BE"),_T("01E0FEAB3A81C6D7345A32C58AB7D51B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("058"),_T("0188F1BEBBC334B3B3A5081174406414"),_T("01F4B2D39E4017CF1952BDF84A27956F"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("059"),_T("01BA98C687122EA41579AF0D55D7D9F1"),_T("01DBB3556C945DDEA930FEE96C922B32"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("060-061"),_T("010493046013812E6A60F1C947BCF98E"),_T("014FDEE94CD6BB3894EB72C2FD3435EC"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("062"),_T("0182A8273EA432A275A98785F1155CF9"),_T("018B736BBB7A6A9B377113556592970E"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("063"),_T("019322C0F935CB3E8BF358BE02009F10"),_T("01D7C033447017E64166566306B613BD"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("064"),_T("0168A35C180D94AFCF3908195B2EF41E"),_T("01B53A0C930F891E5584A9837F4D20C7"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("065-066"),_T("019523E1FC78374CA437AC1B93E6C27D"),_T("01EC82A09F1E8B8BDA6C9AC3412D4DD4"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("067"),_T("0157B8F21222421A6F55931F84FBB4C1"),_T("01E0433F7723F6AF60219478207469FA"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("068"),_T("0106A1E243ED8C5EECD9FFA83BD9D909"),_T("0135E338E512D2981F53A6F796BBE716"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("069"),_T("015DFAB1D0C62A768D000FF66F670AA7"),_T("0173A34A3257A4FDDF4CCCF7FCB09B6D"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("070-071"),_T("0124237EA3BAF7E687617C56C9FEF44F"),_T("01BE27B1A4F277018ECF621F9EE4357B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("072"),_T("01381A44131973EA2D012A7F90BF1B65"),_T("01AF00436DA7962818EF111E9602E267"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("073"),_T("0180B24C0D600C69D5EE50E5E7D9FF05"),_T("01BE134082E3654CBC17B64F4CA74D81"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("074"),_T("0113C0115C6CB65A9D176FF7F12DB8F4"),_T("01D879A5B03C9C261E0B13051091F939"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("075-076"),_T("0119470A4796C6D8835FEF17B32D6ACD"),_T("01549824A2982D54A86FBF6FCB58EBF3"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("077"),_T("018417A6CAFD7B99E68D62AE1ED533FB"),_T("01A75327FAD0DAD29E63A3A036C9C747"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("078"),_T("015D89F31A0A1F179BB64CED49905491"),_T("01FAC3701288FA83A4C1789873781568"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("079"),_T("0103354594ADA873431D96F400633A46"),_T("01373828E35FA443AB1D6D36D9FF0BD8"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("080-081"),_T("01E97EB12F8E60E014045751764986DB"),_T("01EEB2D93138615B3BA17C3FBF4F1ED8"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("082"),_T("011C34BE0A49E7129E2106129B25F06C"),_T("01A7C687C179664D7E5162D5675C9A89"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("083"),_T("012FC28E2C2D7D8176873702AEFB212D"),_T("01DDDE2C5DF0F5AC0F1161042D26656D"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("084"),_T("0166C9CC3967807247B93C0D2A168BE9"),_T("01A71FC79AF7E6117788FDAD38A9AD08"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("085-086"),_T("0154DFF319B59E71D47D1ED5C4FBF4E6"),_T("01AAB0140714ACCCCA606490053A1605"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("087"),_T("014822F5A31DCCE335A3DAE44D884780"),_T("01AA752557C5F34B1E2A3CF2E95AF769"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("088"),_T("018FCD649AAEFF642CBF273A36A60F6F"),_T("01EE90F9E15CEC725BC6E0A4B37F0207"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("089"),_T("0133A0EF20C997C87B68A9DFAB282361"),_T("015A336EE0553841153E22FBAB2CD372"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("090-091"),_T("0125AF4DAC2A62E600F6D03E05B7CF91"),_T("01F33F7F8758DADA8F99200CA44FD75B"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("092"),_T("0188801020BE0484F499413EA7ABB724"),_T("01C5315718D1D19AD0CA15A2F68DF5EC"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("093"),_T("01CA6A328C0296B896419261BAD2C8F2"),_T("01EB561F2389361E8994280294CD5423"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("094"),_T("01EA97D21A38A7C290E6C7117A14A83B"),_T("01F8845FE0E2B565A12A92AD8D0F29CC"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("095-096"),_T("0112FFC96229344A2CA6DA90B2E81A6C"),_T("019667373D982CBA9786618B7B663240"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("097"),_T("0129A0C3AD12541D54E6703AD419C527"),_T("0134C26D9B1EDEC747FA07E745F6B46E"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("098"),_T("017A81B04AA9ED5DBFA356169028C91F"),_T("01FD06EF44E5CB187E7A4A87CC2D9D66"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("099"),_T("0100B8C4E482C33F2A505D7261E2CC99"),_T("011C7429AB80690F18978FD375BD831A"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("ACDSee"),_T(""),_T("100"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T("ACD Systems"),_T("ACDSee")},
{ ENUM_EDITOR_SW, _T("Adobe DNG Converter"),_T(""),_T(""),_T("01C2DDA29A1B5DCCD5E217CF9C558A62"),_T("01C2DDA29A1B5DCCD5E217CF9C558A62"),_T(""),_T("Adobe DNG"),_T("Adobe DNG Converter")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 00"),_T("012325931C8FA8522A0DC6856C8FB483"),_T("012325931C8FA8522A0DC6856C8FB483"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 01"),_T("010C5D6B4748A678290EC5AE783A8A68"),_T("010C5D6B4748A678290EC5AE783A8A68"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 02"),_T("01FF0B6A3E240ECF49A8B06AA2743D25"),_T("01FF0B6A3E240ECF49A8B06AA2743D25"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 03"),_T("0107D8E0D4EE2910BEB0A984F3D17E30"),_T("0107D8E0D4EE2910BEB0A984F3D17E30"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 04"),_T("01FA347CB7C707FD008CDAD7367966C6"),_T("01FA347CB7C707FD008CDAD7367966C6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 05"),_T("01B7D42A6678B6F1F20EB05FFC2A8EB9"),_T("01B7D42A6678B6F1F20EB05FFC2A8EB9"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 05"),_T("01C2DDA29A1B5DCCD5E217CF9C558A62"),_T("01C2DDA29A1B5DCCD5E217CF9C558A62"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 06"),_T("01C695AC8819C200F1D13C16468312F5"),_T("01C695AC8819C200F1D13C16468312F5"),_T(""),_T(""),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 06"),_T("01A90005BBDC3F23A80123EF0B4E4A28"),_T("01A90005BBDC3F23A80123EF0B4E4A28"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 07"),_T("014219E79BBC5C20BABF374762AAA745"),_T("014219E79BBC5C20BABF374762AAA745"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 08"),_T("01180AF3DE63318828A86409EF4013DD"),_T("01180AF3DE63318828A86409EF4013DD"),_T(""),_T(""),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 08"),_T("01A20F69263117021CD16AEF44D6E650"),_T("01A20F69263117021CD16AEF44D6E650"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 09"),_T("0108A9C11C74DD59416AC689A4C00A55"),_T("0108A9C11C74DD59416AC689A4C00A55"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 09"),_T("0108A0C92E083893457EBEE6BC99F12C"),_T("0108A0C92E083893457EBEE6BC99F12C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 10"),_T("0166B0BC0B82C8233430BF67FA31C829"),_T("0166B0BC0B82C8233430BF67FA31C829"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 10 grayscale"),_T("01398BCF6C3CD3F191AC7651DE1572A1"),_T("01398BCF6C3CD3F191AC7651DE1572A1"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 11"),_T("014C6C24A9EE0C6BDCC1598CEECCE808"),_T("014C6C24A9EE0C6BDCC1598CEECCE808"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 12"),_T("01C1158E443D1C90F302FF6BE49DDD87"),_T("01C1158E443D1C90F302FF6BE49DDD87"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save As 12"),_T("01DADDC4908E9BA57CC067EEAD54E67D"),_T("01DADDC4908E9BA57CC067EEAD54E67D"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 000"),_T("0130B2A516BC06C5D54B8D26507991E2"),_T("0130B2A516BC06C5D54B8D26507991E2"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 001"),_T("0119A7B4F14DEB5431CBFC2EA7D3EDDD"),_T("0119A7B4F14DEB5431CBFC2EA7D3EDDD"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 002"),_T("0103D2DC208BB2DA8027302DF5B27C1A"),_T("0103D2DC208BB2DA8027302DF5B27C1A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 003"),_T("01BBFF6CB5ABCB09C381E6EB26F8C249"),_T("01BBFF6CB5ABCB09C381E6EB26F8C249"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 004"),_T("018DC509622FE322961BBE39FD51C38B"),_T("018DC509622FE322961BBE39FD51C38B"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 005"),_T("016FF5235A28B97875366ECA87B244CE"),_T("016FF5235A28B97875366ECA87B244CE"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 006"),_T("01F898E2D1E6AE15A446A9032C87121F"),_T("01F898E2D1E6AE15A446A9032C87121F"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 007"),_T("01EC4E95D6F4850EE65667888E006EE4"),_T("01EC4E95D6F4850EE65667888E006EE4"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 008"),_T("01A8073AA8F327DC2EE84DF61F069132"),_T("01A8073AA8F327DC2EE84DF61F069132"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 009"),_T("01E371BB7D76C099C71CB29CFDD825CA"),_T("01E371BB7D76C099C71CB29CFDD825CA"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 010"),_T("01E36CB9967B0DC1C592A39666BF877E"),_T("01E36CB9967B0DC1C592A39666BF877E"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 011"),_T("012629A5C57929287862ADA25BE00E70"),_T("012629A5C57929287862ADA25BE00E70"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 012"),_T("01A600EAD4B56FC377169141936A9012"),_T("01A600EAD4B56FC377169141936A9012"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 013"),_T("017C5C5E45660BA6CBCB3227428E6F59"),_T("017C5C5E45660BA6CBCB3227428E6F59"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 014"),_T("016CFC2E78B9BEF288E515994861ED2A"),_T("016CFC2E78B9BEF288E515994861ED2A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 015"),_T("01BB9DB9D84C1FF90F10393E786EFA37"),_T("01BB9DB9D84C1FF90F10393E786EFA37"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 016"),_T("01FC38C12A3488DA75DB0206D349C35A"),_T("01FC38C12A3488DA75DB0206D349C35A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 017"),_T("01DD25CDB86D38D4032D6EE9E877B827"),_T("01DD25CDB86D38D4032D6EE9E877B827"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 018"),_T("01A8ACB503430091613C58F4448510BD"),_T("01A8ACB503430091613C58F4448510BD"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 019"),_T("01621F1AC8A1B3152136EE2348440AEE"),_T("01621F1AC8A1B3152136EE2348440AEE"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 020"),_T("01753BA0EF85AD1B1C66F2724B9879EA"),_T("01753BA0EF85AD1B1C66F2724B9879EA"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 020"),_T("016191A38B30FA96ED932E8F03ABD75C"),_T("016191A38B30FA96ED932E8F03ABD75C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 022"),_T("01BAEFC08D867839BB67FAA24A7004D0"),_T("01BAEFC08D867839BB67FAA24A7004D0"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 023"),_T("0109594B7BD71FF6EB4CBA341F4528EB"),_T("0109594B7BD71FF6EB4CBA341F4528EB"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 024"),_T("01C95456509D376179DBC2536A11AB80"),_T("01C95456509D376179DBC2536A11AB80"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 026"),_T("0124BB387BF72FB204C341839BD9CCB5"),_T("0124BB387BF72FB204C341839BD9CCB5"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 027"),_T("012044A3BA7CE9E4F17D98D49684AFEA"),_T("012044A3BA7CE9E4F17D98D49684AFEA"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 028"),_T("01107F5F085067D02D0ABE0F1F84012E"),_T("01107F5F085067D02D0ABE0F1F84012E"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 030"),_T("01F73A1839315AEFC5DB2DF9EE8D0977"),_T("01F73A1839315AEFC5DB2DF9EE8D0977"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 031"),_T("0184411BB50011A44DCFE3D51D1A17AF"),_T("0184411BB50011A44DCFE3D51D1A17AF"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 033"),_T("015E5E79CEE9B0FE744F68E5F6F8BFDA"),_T("015E5E79CEE9B0FE744F68E5F6F8BFDA"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 035"),_T("010C825A320E0BD3B93090391B319625"),_T("010C825A320E0BD3B93090391B319625"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 036"),_T("01382BDFE1AED73EE5F30BF0D2044852"),_T("01382BDFE1AED73EE5F30BF0D2044852"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 038"),_T("015582D4CEA4ECEC52CE6EE9A1222C95"),_T("015582D4CEA4ECEC52CE6EE9A1222C95"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 040"),_T("012BD5B2A563F55EAAE0128203CC68F6"),_T("012BD5B2A563F55EAAE0128203CC68F6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 041"),_T("019849132013D5323EF4E2B2702C9737"),_T("019849132013D5323EF4E2B2702C9737"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 043"),_T("01DDC09F3332E25EA20962B3FEF3BF23"),_T("01DDC09F3332E25EA20962B3FEF3BF23"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 044"),_T("01651D50C387514D0E61092260CB0258"),_T("01651D50C387514D0E61092260CB0258"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 046"),_T("0101E499902CA45920E16A202657C0E2"),_T("0101E499902CA45920E16A202657C0E2"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 048"),_T("01024F682A8AFB5D96B1B7A6339B7D45"),_T("01024F682A8AFB5D96B1B7A6339B7D45"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 049"),_T("014861235F177CE4A79C1A0C43816AF5"),_T("014861235F177CE4A79C1A0C43816AF5"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 050"),_T("011E122B2E1C9BB19DCC0C0BC8E74E25"),_T("011E122B2E1C9BB19DCC0C0BC8E74E25"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 052"),_T("01B561565D8F26E36922E8AA5FC12D45"),_T("01B561565D8F26E36922E8AA5FC12D45"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 053"),_T("01431604AA6CF86A5300CE0553C058B8"),_T("01431604AA6CF86A5300CE0553C058B8"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 054"),_T("011B9E3A3334C136B755003D2CAF305C"),_T("011B9E3A3334C136B755003D2CAF305C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 056"),_T("011226BD3AB7415091D91106E6512A0A"),_T("011226BD3AB7415091D91106E6512A0A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 057"),_T("01301727419256BBE49DEA4A0532ABF4"),_T("01301727419256BBE49DEA4A0532ABF4"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 059"),_T("01296F65B9EFEB0E469475600B17D622"),_T("01296F65B9EFEB0E469475600B17D622"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 060"),_T("01C26040DB5181BA3B5CD7A813FAD209"),_T("01C26040DB5181BA3B5CD7A813FAD209"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 061"),_T("019CD397A6F3412E605D89ACE6D5E1E7"),_T("019CD397A6F3412E605D89ACE6D5E1E7"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 062"),_T("01203021460C376D8D31D57C3F4BDD55"),_T("01203021460C376D8D31D57C3F4BDD55"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 063"),_T("01438E0E3B5EE9CC5380F611E5168979"),_T("01438E0E3B5EE9CC5380F611E5168979"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 064"),_T("0142F9A14A2DB18F9A8E42521497910D"),_T("0142F9A14A2DB18F9A8E42521497910D"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 065"),_T("01803D95BA4C7F1CDA486B171BB30DBA"),_T("01803D95BA4C7F1CDA486B171BB30DBA"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 065"),_T("01EDA06D0F21C77828F6D5BF5BB25EB8"),_T("01EDA06D0F21C77828F6D5BF5BB25EB8"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 066"),_T("0139B00110F2F44D5E6F220C1CEACC39"),_T("0139B00110F2F44D5E6F220C1CEACC39"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 067"),_T("0182FE1F69533D6A2C675D7985752298"),_T("0182FE1F69533D6A2C675D7985752298"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 068"),_T("014A714C9F3FCF306F101BB7109B7FC7"),_T("014A714C9F3FCF306F101BB7109B7FC7"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 069"),_T("01C553050D6EBAC845BEC1A2B2ED35A8"),_T("01C553050D6EBAC845BEC1A2B2ED35A8"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 070"),_T("019CAD91870AF68B20FEF745FB5B191C"),_T("019CAD91870AF68B20FEF745FB5B191C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 071"),_T("0170812268185A8C590F16B3DBAB22BC"),_T("0170812268185A8C590F16B3DBAB22BC"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 072"),_T("016743557ABCB147A79BFA185DA3EA15"),_T("016743557ABCB147A79BFA185DA3EA15"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 074"),_T("017DCB1A1B1D8B591A3B04771041A382"),_T("017DCB1A1B1D8B591A3B04771041A382"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 075"),_T("013E5A347BEB5C2FD641B1432B342192"),_T("013E5A347BEB5C2FD641B1432B342192"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 076"),_T("01DA170CA3AA855A5CB8D95C5A4B8E38"),_T("01DA170CA3AA855A5CB8D95C5A4B8E38"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 077"),_T("010DCEC5469DFE9A25FD53D3D268A638"),_T("010DCEC5469DFE9A25FD53D3D268A638"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 078"),_T("01025266C31FCCE9E081B1E73F65C152"),_T("01025266C31FCCE9E081B1E73F65C152"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 079"),_T("012BCCCA56539844F0D270A0A6CCAF85"),_T("012BCCCA56539844F0D270A0A6CCAF85"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 080"),_T("014FC9D32AB50D2E78A55796DA2CBEC6"),_T("014FC9D32AB50D2E78A55796DA2CBEC6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 081"),_T("012B9DCBF402DF17158CBF6E64206F32"),_T("012B9DCBF402DF17158CBF6E64206F32"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 082"),_T("0130B6BD32634AEFB97B70F20976FC86"),_T("0130B6BD32634AEFB97B70F20976FC86"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 083"),_T("0189D2AED788E6E598C992F4260F351A"),_T("0189D2AED788E6E598C992F4260F351A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 084"),_T("01BBEA4DA57CB2723835E42CC4E0BCAC"),_T("01BBEA4DA57CB2723835E42CC4E0BCAC"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 086"),_T("01A001542F2B6107CEA432CE45AF8100"),_T("01A001542F2B6107CEA432CE45AF8100"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 087"),_T("0128FDDB85CB7E37EEC547C9FBD4E8CF"),_T("0128FDDB85CB7E37EEC547C9FBD4E8CF"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 088"),_T("01943E417C105E1AD39161CA8C5EE06E"),_T("01943E417C105E1AD39161CA8C5EE06E"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 089"),_T("017981A780D2FB52E811A9DFB5E211DB"),_T("017981A780D2FB52E811A9DFB5E211DB"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 090"),_T("01D3C14A2EE08C94A55B15E2ADB46AE4"),_T("01D3C14A2EE08C94A55B15E2ADB46AE4"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 091"),_T("0132C1F3B949A09A0C059E9CF70DBADF"),_T("0132C1F3B949A09A0C059E9CF70DBADF"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 092"),_T("01495A5CA34A31036C80CE720821A2AE"),_T("01495A5CA34A31036C80CE720821A2AE"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 094"),_T("011366606521191E3BF568FFE4F0ED0C"),_T("011366606521191E3BF568FFE4F0ED0C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 095"),_T("010BCBF1E31BE554B4429AF04CA58C0E"),_T("010BCBF1E31BE554B4429AF04CA58C0E"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 096"),_T("0192B42FED2A30C8D0E60CDC1200ADF4"),_T("0192B42FED2A30C8D0E60CDC1200ADF4"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 097"),_T("014007E37B551E53208F1585B40B99E0"),_T("014007E37B551E53208F1585B40B99E0"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 098"),_T("0126C30B910B29E7FF76843991A77790"),_T("0126C30B910B29E7FF76843991A77790"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 099"),_T("0144B08D172AE0B1285A07DECA206F71"),_T("0144B08D172AE0B1285A07DECA206F71"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop"),_T(""),_T("Save For Web 100"),_T("01E76B1145D4662F80BA198358A896A4"),_T("01E76B1145D4662F80BA198358A896A4"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 021"),_T("01A9B3D4EF8B5D8C732F94BD7AF4ECA6"),_T("01A9B3D4EF8B5D8C732F94BD7AF4ECA6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 025"),_T("019389FA50B73A7B9D6D0094FED486CC"),_T("019389FA50B73A7B9D6D0094FED486CC"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 029"),_T("012D9007B37C05C003535E8D4B15EDD9"),_T("012D9007B37C05C003535E8D4B15EDD9"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 032"),_T("01A8466B2DB77E8F85B7364B729FADF0"),_T("01A8466B2DB77E8F85B7364B729FADF0"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 034"),_T("01FC7D123C99FF761F2865AF43F03A4B"),_T("01FC7D123C99FF761F2865AF43F03A4B"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 037"),_T("014B8AB1944327D4DD81AD3F69001F86"),_T("014B8AB1944327D4DD81AD3F69001F86"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 039"),_T("0175F8DAB418C9B17A5FB722EB309BA6"),_T("0175F8DAB418C9B17A5FB722EB309BA6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 042"),_T("01791EA97528DA2BD02082933CEDD4F2"),_T("01791EA97528DA2BD02082933CEDD4F2"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 045"),_T("0153DE55B52852BBB966CE1FF54FAF81"),_T("0153DE55B52852BBB966CE1FF54FAF81"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 047"),_T("01A13C373289893FD824792E79CD8115"),_T("01A13C373289893FD824792E79CD8115"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 055"),_T("010CCF22A3D98B7E94C08FB611403AE1"),_T("010CCF22A3D98B7E94C08FB611403AE1"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 058"),_T("019F3067B720B4F8428DEFC96661167C"),_T("019F3067B720B4F8428DEFC96661167C"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 073"),_T("01347EEB18BCBCBA043C274F38C6554B"),_T("01347EEB18BCBCBA043C274F38C6554B"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 085"),_T("01F43B7B625F02D2AAD575F9A61842FC"),_T("01F43B7B625F02D2AAD575F9A61842FC"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Mac"),_T(""),_T("Save For Web 093"),_T("01A8A4A60156C103EC5C645224C142EF"),_T("01A8A4A60156C103EC5C645224C142EF"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Mac")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 021"),_T("0175AFC5ABBC32B32E4D2F4CDAC93F69"),_T("0175AFC5ABBC32B32E4D2F4CDAC93F69"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 025"),_T("019CC391D4B06A06E29474EA82801C4A"),_T("019CC391D4B06A06E29474EA82801C4A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 029"),_T("01177339640EEDC5DC811AF1B7744459"),_T("01177339640EEDC5DC811AF1B7744459"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 032"),_T("01F659D3E69B6A840FA8DAC5FC8275C0"),_T("01F659D3E69B6A840FA8DAC5FC8275C0"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 034"),_T("013DD4ED1AA14061D16D1DDDAF48E6C2"),_T("013DD4ED1AA14061D16D1DDDAF48E6C2"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 037"),_T("017C2DB1BAB171B59D51799C4FCF0E8F"),_T("017C2DB1BAB171B59D51799C4FCF0E8F"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 039"),_T("011AAAD2F0102BC6AC01D65C7BBC0334"),_T("011AAAD2F0102BC6AC01D65C7BBC0334"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 042"),_T("0103D86E0E6E0CC85740ACD6CA691A6A"),_T("0103D86E0E6E0CC85740ACD6CA691A6A"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 045"),_T("01653BBDF05CD614839A275CE9B6912E"),_T("01653BBDF05CD614839A275CE9B6912E"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 047"),_T("010EF9F94D9E759DA75E1C3A969BEC70"),_T("010EF9F94D9E759DA75E1C3A969BEC70"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 051"),_T("01D2AB7D4DF7A989D35E7A065E3779BB"),_T("01D2AB7D4DF7A989D35E7A065E3779BB"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 055"),_T("0112676ABC8BB7D03ED0B1A9E2ED214D"),_T("0112676ABC8BB7D03ED0B1A9E2ED214D"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 058"),_T("01A06D860B61A8C65172CB737CFE81D6"),_T("01A06D860B61A8C65172CB737CFE81D6"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 073"),_T("012A76A99AE7EFAF680F8A583E4A2B3B"),_T("012A76A99AE7EFAF680F8A583E4A2B3B"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 085"),_T("0125E813312F55DE92C0A2C020B90589"),_T("0125E813312F55DE92C0A2C020B90589"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop -Win"),_T(""),_T("Save For Web 093"),_T("01CAD52BFD97C6E39A4FEDA5CC104BCC"),_T("01CAD52BFD97C6E39A4FEDA5CC104BCC"),_T(""),_T("Adobe Photoshop"),_T("Adobe Photoshop -Win")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop 7.0"),_T(""),_T("Save As 07"),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T("0165B3F1B409A4D8D5F2ADFFA970D3A5"),_T(""),_T(""),_T("Adobe Photoshop 7.0")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop 7.0"),_T(""),_T("Save As 07"),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("Adobe Photoshop 7.0")},
{ ENUM_EDITOR_SW, _T("Adobe Photoshop Elements 2.0"),_T(""),_T("Save As 10"),_T("012933907CE4B9D3C27E3E9D4D50BFD6"),_T("012933907CE4B9D3C27E3E9D4D50BFD6"),_T(""),_T(""),_T("Adobe Photoshop Elements 2.0")},
{ ENUM_EDITOR_SW, _T("Adobe Photosop"),_T(""),_T("Save For Web 050"),_T("011E122B2E1C9BB19DCC0C0BC8E74E25"),_T("011E122B2E1C9BB19DCC0C0BC8E74E25"),_T(""),_T("Adobe Photosop"),_T("Adobe Photosop")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("000-004"),_T("01E1BDDF6C45DBEC46FC48B60BBF6018"),_T("01EA5E13EF082CE6D445C4AC8ED703A8"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("005"),_T("0126FBCAC54E5F8913BF1675612B5D23"),_T("0198D256A3203CC67CF1559EEB39D216"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("006"),_T("011C793F9E71B996834C395C0A4B987F"),_T("0168CEC66029B4B5237F887CCAA2E604"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("007"),_T("01645CC0CC50F54D1173CA3E454AF54A"),_T("019D7FA63C16339F44D67D45FD8603E6"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("008"),_T("01677A30C503901718398BF6931FC51E"),_T("019BB42ADFFE3152B70CF024B826D7CC"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("009"),_T("014939B82901487C3A444099F486237D"),_T("01CBF5EB43E3104104B28258D417ACC1"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("010"),_T("012B2C7ABA69A72048A5B864F1AC4070"),_T("01574C5E6F3D7293E84BE75D886A3917"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("011"),_T("0188AC3A8F2B0B70FA22245542E991CC"),_T("01935D7534EFAB6901A7DA9159BA60BF"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("012"),_T("0126FB4D1191A9B77D790FA3A446B071"),_T("0198C08C7D5E51753E7EC3FC7FD294C9"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("013"),_T("01539AF5226D7FD8CA9423F5C1A7E61D"),_T("0170D73C45D867BD2AD75B49D7254C24"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("014"),_T("0172C9440F7071B4EE7CA7BEF484B84E"),_T("01DFEEAB4A038C174D2F19BF66A13231"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("015"),_T("01466F83C333E94A420A1D981B0B18C1"),_T("01B2C325E900FF46A26E2EE89FDDB2A2"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("016"),_T("01C0446E7A2D20CBEBA8F2DB3E3FF514"),_T("01E90614933C79BC205EE1EF74699CB1"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("017"),_T("010047DB57AB7D7DD5FB3D0F5000D53D"),_T("019A9BEE3E8EFAD46391AD433C755815"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("018"),_T("016E007C33B426D996676779A6526DF1"),_T("01A3914684E4EE020AF3A5D193681E58"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("019"),_T("01934D7DA423E24105014F3C048391F7"),_T("01B24B2CB41352E7BC79EF13D24F8E33"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("020"),_T("016592D04ACA0DD271C5C2BC90E1333F"),_T("01807A26F1DD1849F1D287C4D0788B23"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("021"),_T("016480046FB50102942EDEF00B61C36F"),_T("018E070FB96C25B959564A5AA94C35E6"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("022"),_T("016B59B05B49931DC6084E11616D64EC"),_T("016FD94ED31FF30D8E1C25587E0D85F7"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("023"),_T("01878E1F2B458AA806240872FB43DDAA"),_T("018BB3F9D4DA424384A51D624CD3D9FE"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("024"),_T("015CFC6C2D58274E98FBBA4F6321D1AF"),_T("01EB319F71755E65CE61657E4E9A99B0"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("025 (Low)"),_T("0106CC8A4D86406631698CAD623295E7"),_T("01D7939BF6193E9BA33B39FB00E1692D"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("026"),_T("01225CBD60ED2AD10620D8DF77E71FB0"),_T("013B9648B48BFF6B7B099F3FD651F248"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("027"),_T("012131D6E147D0DDA17559B6D8F0E7A1"),_T("016254A60390F098D16CF2F9F8D46D41"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("028"),_T("012B4382271961958103C7343BE6ABD5"),_T("015F8C12B50F26B6E80F167F0FF47455"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("029"),_T("01CB490B7BED73A82A4DC3F14D8BB4A8"),_T("01FBCB539A90B10CEADEB86252E28589"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("030"),_T("012DCC7188B68F08CA475B836A696D35"),_T("01D3C50126F751A336DB7979BD55A2B0"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("031"),_T("0129DD41201CBABC51D0DA67D61D1D0A"),_T("0139B0F3163DF554094E7C3C575C8283"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("032"),_T("0125CEF1CADB3F9B61DB1C76882632EE"),_T("0130DBC822B41A84DB23DED722875DEB"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("033"),_T("01295A789D11EFBEB1271894A616C2B6"),_T("01EE25BE492A83676EBD2DD27DAB6EF4"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("034"),_T("014A5317C1D0D7E249AFE179EDC78D44"),_T("01F141F71B11831A417055F56CDBDBAF"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("035"),_T("019F943F9911D5A92F7FD316D5257911"),_T("01F5EACFE329B4A0B3D933BAA129D992"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("036"),_T("01157C3DC3F654CAE8DC773C6875C501"),_T("01E10E17D6553EDAA3980DD8442849E8"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("037"),_T("0102FD53DA7E2BF17C286459EB6D9527"),_T("0157C76A130F5344634EA4EEDA0A1D5B"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("038"),_T("0188BF9F540DFEEFA3A9C802EEC8CD13"),_T("01A778499CDDA9D909D5227FD9B90D18"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("039"),_T("018D62D7C4DE7E96267B7DB39A83794A"),_T("01BA683B8D4A9C52CE491558E648008E"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("040"),_T("01204FC209870A3BBFC7845EAF5759CC"),_T("0124B5353984D3B55CE4761AD15F513A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("041"),_T("0106F49F3A8C3ED55BE59D17CFBF3021"),_T("01314FAD6CA3B2292CCD7BA1FE3BA6AA"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("042"),_T("0107889833E58EAD62F3C831ADA56423"),_T("01C6E60E4501F3D32F128664DCE3D284"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("043"),_T("01137E2463CDDFCD699A73035661A466"),_T("01A747D368B7ED07DD3B26292D80ECFB"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("044"),_T("0133919E64E56D9E74D9EF2745A71459"),_T("01589D2B6C93E184413F1FC5AC3B9BE9"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("045"),_T("018E870D2F9AFC8B03C5DC4492682F64"),_T("01E325F50092F947E74B2CC234700C31"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("046"),_T("01872032961FF2B3646C019B7E9B108F"),_T("01A6301376639A3410E4F662FD058A2F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("047"),_T("0158976B662BDACF2273BB1C473A164D"),_T("017BCE5EF37920D90E7111FE8BD58598"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("048"),_T("012C8DE2056525DE9FE92443C605A78A"),_T("0194CECD16D9F462DCDCAAEF81F3ADBA"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("049"),_T("0182230692721ADF5DCBFB56F747490C"),_T("01DD92C0CD7077A88C49139F2F15908D"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("050 (Normal)"),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("051"),_T("019A47660E47871B3671ED47AC3CC5A0"),_T("01A1C753C3B952DEB5279ECB0BF65C2C"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("052"),_T("01120B3AD85F4C8E3EAFB2795C0B48F2"),_T("011CE1667822D0847E888CB66C5C580A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("053"),_T("0141CE8E21211A09448DCACE8DC51CD4"),_T("01BEE51B29F37D8A5A7BC31C63A652BF"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("054"),_T("010024C0F1734B148CECCD76EE92D9A1"),_T("01E80B819244DB40BC79151703625E2F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("055"),_T("01260E87C3F8E7D82C26F75E6E6AF47C"),_T("012FD11B66B6BDC21718EC7B400264A1"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("056"),_T("0161BBFB99218AA2D308B872914C25D3"),_T("0193EF2EDE9B800A47B1668DAC55A133"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("057"),_T("012444027658BD665BB7AD2C119EA883"),_T("012551DDF21B7F7A80EA5E9DD6B0896C"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("058"),_T("0142CC6174741D661E2C9E071B69422E"),_T("01C350C443A4740D913952AFB00253F2"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("059"),_T("01056C44719BDAC0034D5A55E16F47A4"),_T("01E9E33A72E2F73E8FB9307D47BA5286"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("060"),_T("011968874FC0524E5485DA781700EDAF"),_T("0164D08E1D3B43F9DF9C6925DF9791AD"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("061"),_T("0134C01EB38234AE0E6AC6DAF079B326"),_T("01A15B86B56D87ACB7B5E9BBC2569B2C"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("062"),_T("012E13089848657B9B5CDB998090F7F5"),_T("01E932F45D4F1478D2D273CD62DBDECB"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("063"),_T("0119EDAD5E9B000BDDBA8753B120A229"),_T("01DE4177A47A2F2676F6B2B3A0080023"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("064"),_T("012C1E92CE901A9022CB5FD8282E00DB"),_T("019102DFD4F30C9EAA8B16AF21908898"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("065"),_T("010C5E83B4718AA6A399FF23B50A7F96"),_T("01597ACBE29F0E07FA071884AB89D3CF"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("066"),_T("01B1DDF4CB8DA7D900F69CED5A0A04D0"),_T("01F8D63A18117D01CD1294E5AB131C8C"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("067"),_T("01758A3E0C28B68036CD45CFC3EB1216"),_T("0197E99A8AE184E3D3E3C6C3C5FEF99F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("068"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("069"),_T("0162FE55E33782E1688BFB4B0EAE65B4"),_T("0190321C4F531E73CBEFEB2A68A93EA0"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("070"),_T("01784541057E8D5DE839E26D360E7B9B"),_T("0190F856F3F2E4FBD1A8EA7EECE2AC97"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("071"),_T("01612B6026E2956027E1F1A429384D0B"),_T("0187EF25A41FE4767D1716CD0D3241B6"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("072"),_T("0160DE46E1DD853827062BD015E0007C"),_T("01C180F0D55998C9159D07F2FABBCB1A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("073"),_T("01887E4A16BFD89384CCF99F476255AC"),_T("01BD26E97FB262E36DC19C7C3890813F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("074"),_T("017FC4A11DAF71E5DA854E663AAC411D"),_T("01906ECAFA199DFFA6789731CEF5E958"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("075 (High)"),_T("0147A204E29CA6BB54C62A51E403109C"),_T("01A1625280C51FF5D66CD5588DB795E2"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("076"),_T("01220C476CFC53783AC6AB5EB1A97F0D"),_T("01C250F6680836A53A23AB81808F9A0A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("077"),_T("01598BE63D08B2CEDA32C2C52352CE48"),_T("016BE18CF2724156D4B72F612AD90E97"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("078"),_T("0170120584A0850B1F6E0B9D80D90B31"),_T("01C351E4E8F43FB78EB16F77F64E894D"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("079"),_T("01B84306903A0AF41E7FF28543937201"),_T("01ECBCB4C4CAEFADF8CE7D835B93CD59"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("080"),_T("01191863A92FA362537A80411114BBC3"),_T("01D7D42C1C869993B7E598D7C109534B"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("081"),_T("0158CE52C54D397B53221DD19E8ACDED"),_T("01AA907DA83C09A2A65361F78978711F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("082"),_T("011C4430355A5A7DC629AF44FF04226B"),_T("01A815DCC9C4C2F64AE295D37ACA0F7E"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("083"),_T("01512628D15A91E8E2F10B54339B8F97"),_T("01CDEE40A34EE162A13F228C5578D9CF"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("084"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("085"),_T("015E76BF0DE87FB5F316AA09C0140F63"),_T("01EF24522F0FAAF04D2AAE329E929E9A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("086"),_T("0124BB115473A2FDF8761E456E0479E5"),_T("016A0C5AF55E177945D9CA4325B15B66"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("087"),_T("0160BB5124EC40826352E9552F12F291"),_T("01E5D37BA619FF16E45EE495903E19D4"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("088"),_T("016517142B3160A02B540042E07047B7"),_T("01A2E59FC2CABC23E9813AE1501F4592"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("089"),_T("0177216E93088FE251EADA34A3527681"),_T("01F836392A26F87859B328DE1EB0E05A"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("090"),_T("0114ED88173433C4BF99F0569EA94D90"),_T("019E0FC5DA517712EF95A6C1789E61D0"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("091"),_T("014992BEE7D2FAA63304B0F1263B685C"),_T("01DC1DDDE2A9FBFA4FAA4C6E202E2CFE"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("092"),_T("013970FDDE9C9CA2CC8F0082375FFCB8"),_T("01A098C96CAA97E3171F4A90451B4CB1"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("093"),_T("01195C98AC99FFB4127537310F066964"),_T("01ADB5F03BA5F38B0F507E3D71E627FC"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("094"),_T("012AE29B4321410985D1B1B400901D6A"),_T("0155B057A3CF7EB81659AEB7BEB76C7E"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("095"),_T("0117778062C5DEB6B73DF9E5B4148858"),_T("01387F274E7398893466910CFCDB77F7"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("096"),_T("0166D7C4514A1B5BF17A8A31C90EF2D3"),_T("01E4481CC143080346658FEE1819556F"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("097"),_T("01456AE94047979A32863FE4D17BE1B0"),_T("018EE88E37BAC6C8133370617AD31752"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("098"),_T("0111DB73E1FEA8BD01B0960F519AA102"),_T("01BF46EDE189625817DDCD2078B14615"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("099"),_T("010391CFAC472ACA504A2866EE657963"),_T("0143211291F265B8A813CF926B8C057D"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple ImageIO.framework"),_T(""),_T("100 (Best)"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T(""),_T("Apple ImageIO.framework")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0000-0063 (Least)"),_T("011C88CCAB514CC4A787F898B6E6EE24"),_T("01C63F17235F997C6F997B87B01184EA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0064-0080"),_T("010C95C1C2130A78D3FC22D9FC14E720"),_T("01D35577208E868CB177450A5F916D44"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0081-0092"),_T("0165D7D8186AAC0B25CCBBAD42B1C8E7"),_T("01A5449AF732DA14FCD0C06726602345"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0093-0101"),_T("01A0B3390F3E3FBA8E0934D3A0D43DA7"),_T("01D50AACEC5C12098C7E95D7002EE7E9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0102-0109"),_T("01800B30CFE9217CBB8ED38308657045"),_T("019BC80D7BA9D1A6DA22935FD2076D0E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0110-0116"),_T("0163DE1D571705F29A4E0F9EDD415669"),_T("01A0B785F91E0A94A4CDE7AC8D98ED25"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0117-0122"),_T("010F76D7444606E67A155424D3E374DA"),_T("01BF0F617041503990DE36C6989878CD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0123-0127"),_T("01999239E7FC36CD7392D754FAAA519A"),_T("01B738F6EB8AB273740302236E6D3DFF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0128-0133"),_T("01BACF6DEA7CFE4408147A6FDBE6F370"),_T("01BAF402B2F4B9DB94C239DA866A32AE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0134-0137"),_T("01AC9A9855E4AC5C155158207E3661E9"),_T("01F26BA2ED5D94674D5367C9DF97913F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0138-0142"),_T("0158368371EF557D54B5C5885E827AB7"),_T("01FD1430AC02ED9CACAD174917D3962B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0143-0146"),_T("011EA21ED48A1140575230458A58CD21"),_T("01702B3CFF2B096D8556B5235D21212A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0147-0150"),_T("0128E20D2CDA4930602AF70D82D522FB"),_T("01A5EC263C62A85FE940A82FB9A0BBD5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0151-0154"),_T("012E67FC156AFCDF75878E4D58407D5D"),_T("0159A5F2A6B04D5AC38ECE33D1566E0F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0155-0157"),_T("0131B676C793FF00970E4A7522C59A35"),_T("01E81ECCBB93900A2CC55954CB731F4C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0158-0161"),_T("0179A7B1E2CCB0B4FBA690EE835B0E41"),_T("018FC7296FA535ED107586AE591C28DD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0162-0164"),_T("0174FC3355E9634E5D67D66637548DD9"),_T("01803B4A2775C2AE8447860D31EE740F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0165-0167"),_T("017231B2B696C41FD41146CB8F260F82"),_T("01C018FF15BA3C3ECA9F6FC169409E4F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0168-0170"),_T("01187EBC3CCC817414146831110B5714"),_T("01FE56C7FB69FC18FE3A98FC6FBB9831"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0171-0173"),_T("0102F290BB55CE87D3A705BF37818931"),_T("012D6428363A50CB868C7FEEB1BB7A40"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0174-0176"),_T("017B200FB5E3EA74BF9569227EA666AA"),_T("01EBE28348FAAEC3D1ECA43A1A5BCD10"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0177-0179"),_T("017F7AD7B07FA891B9B7EEB3CC921E88"),_T("01CF270B256B8BBD3007EE9C2EF4CD58"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0180-0182"),_T("011FAC9E26D30E962A6C4F180E2F0B69"),_T("0198CD00F64E119A82C25BB4DA8D8F3D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0183-0184"),_T("01307A78223F839F3BA2CDAD683CCB9A"),_T("017E03CD31C931DA2E862647E433FF21"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0185-0187"),_T("01C531722B2F47394AA9062F21C78BF9"),_T("01F47B4EAFE308D7B688AA053D3E2107"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0188-0189"),_T("015E1131DB3861BDA89E4D376820098E"),_T("016BF49E27301A47B42DB44FD5E13BD7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0190-0191"),_T("010299130D04450933C15078BFF5207F"),_T("013EAC782791858F72B8519395E3CA80"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0192-0194"),_T("015DEBB2E2AE030CEA8A9058EA35D9A3"),_T("01ED2508642E02D9EF8FC3D62AEFD374"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0195-0196"),_T("01931F59C7630A1B2F93F317B961F956"),_T("01CBA97D70360CA0BDFA5DE6BDA81E72"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0197-0198"),_T("013BF16740D3351AF9695E6407C98CCD"),_T("01FF0D33D2B66880A08992BFC079D67E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0199-0201"),_T("01BE7402223A77113BA5B256C9C6F0A0"),_T("01E387C75185B38F03F72755FED78E23"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0202-0203"),_T("0101D798797EEDCB716D01E9249F9323"),_T("011BDF304280BC0CEF755487C1768AE1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0204-0205"),_T("0140E6C2E321FC84E4CC0E8E3E673605"),_T("01FF35BDA8A4920D7005942922170945"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0206-0207"),_T("01CDB2D0D2E48C9A334625947D5A03F3"),_T("01EB372FC55553561BBBC6A0F611811B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0208-0209"),_T("011282E3D3EA6EBB3E82A40E23457C4F"),_T("01FEF40DD58BB15342E27EEA563FAB91"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0210-0211"),_T("014BC1B7DF73E3859FB55B83662212F8"),_T("01D3D577995401BD13AD3DE5486F5410"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0212-0213"),_T("0170CE9375BB242C57042017076B26B7"),_T("01A090554DB6AC19AD0F115CF5C50C74"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0214-0215"),_T("016077995DA06695B9A79FC106DF90EB"),_T("019666EA7B2AAB54FF488C4FB1433D61"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0216-0217"),_T("01AFA5864E7B1831A46CE24922753EC1"),_T("01CB502FE905AFF42FE7974CCFA79E46"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0218"),_T("0154257DC075384E68903518B2E50833"),_T("01EC276018BCAB863F37703644F7E482"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0219-0220"),_T("016B40F14F627EF116C2BF5AEEF0911B"),_T("01CFCC57C80681053827D570ABB8C4F7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0221-0222"),_T("0184F5D819677C7C5F3DC67449EF1AF8"),_T("01BA88DE9F5ED718592D424347B544CA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0223-0224"),_T("011D0A500F8B772AA87957260AE2418A"),_T("016CB90C820ABF22026718C383C64852"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0225"),_T("018A0C0FBDE2385861078D1E0E66796F"),_T("01F5D68FBA719FF3C8F685FD57815658"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0226-0227"),_T("0175767D251F6D9462228543A21FC1FC"),_T("01A0DAF5AD35F93E1AC7A3C1688020DB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0228-0229"),_T("0155688A51658EF2A4D620E851251F2D"),_T("01ECDC70524EDBF9578ED76CB371ADD2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0230"),_T("0133F8440ED95E1CF6A22C633094E486"),_T("013665FB4674E8A03B1F5BB1FF4FE50A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0231-0232"),_T("011806C4A142F558FA34B7DA152A88D1"),_T("01B458CAD46CB1AD102CD19867C1F31D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0233-0234"),_T("015F4B1408D5D32314E622C007EC0E36"),_T("018918B22E5A0BD03DDD40A9EFF7ADA0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0235"),_T("011649A2C018937D2D6A6866EB9EA878"),_T("01F685EDE4697F7A54BEC8AD02747C0B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0236-0237"),_T("012EFFFBAC08525942D3B5A87FE5E8BF"),_T("019890C73537B5F3DE4525C640D0E5D5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0238"),_T("0142FE3E6227A5F805714FA78EE78FE0"),_T("0167D8ED180A72D688875A06F4C97A71"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0239-0240"),_T("0152CF7CC5A3E51C147B2F73B41061A8"),_T("019C5BE56272F419FDBDFFF2EE6C7BE5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0241"),_T("014B5051F8A15FDA93313FFB0CA80305"),_T("01D4220BC754A34CC3433BAC02C9DB44"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0242-0243"),_T("013CBB074AD3516731972B97FA633214"),_T("01FF2959188C37BB821EF4E005EF5A2C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0244"),_T("0120C506E3D67A32E14D4C311F08E049"),_T("0172226C0CDE175D59148C13FB22493D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0245-0246"),_T("012D01E9C979A65B61567B0CF43B1D2A"),_T("01A2B82DBF8317BD7DE51A6C2AEFC8C0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0247"),_T("013B712701EF86BECB39ADB93CC6AC92"),_T("017C22C408DFE161695256C8817821E2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0248-0249"),_T("017A0B79755B97F8E1B7239217EF8F1A"),_T("01E51FC640553BD5F7FDFE9F788B963E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0250"),_T("012BC876798D084DDDC8B15C0A888F0A"),_T("018128A750BE8ECAC95B90355C90F731"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0251"),_T("016590247EF75642C69D0E6549AB3F2D"),_T("01AE46F4AD34864476F6D3705E8E09EE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0252-0253"),_T("017E30CC8BF30E23C3D3D90E5AD81CB2"),_T("01F56B299ABF062A81CEFEC4E0EC858E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0254"),_T("015C2B61451212F09BA3C35FD11B8ABA"),_T("01784446567C08E4C0A3758BD3FE916F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0255"),_T("017D1C0CAB3D8BD6F9059B970B088BDC"),_T("01DFD59D9409C9AF49BB3D0F2A5E6C6A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0256-0257 (Low)"),_T("014196C461DEFB74E00440F3D2991D05"),_T("015F02EEE7A4CB7824E4F4D7558D75CA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0258"),_T("0167F8273061B6E3F9C4E45CE7DC3A6D"),_T("01DE720A4E7464E54FC0341D1020F40B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0259"),_T("010ED5474FA470D1FC43BB3433EC9D05"),_T("01B5CB99F543185E58AE0DB5CDF3A4D2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0260-0261"),_T("01B1D257C3F23179C939AA7DD1161F63"),_T("01BE43D3203CC0B00E48300C5DEB59A5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0262"),_T("015DAD73756A5193368D6517AF1D8493"),_T("01E017C96864CC2FD2AAA0046F70DB94"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0263"),_T("013DB11464FBC46A7C47478AA9A9D7AE"),_T("01B720AAC9BBE757EAAB0FAA1203B361"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0264-0265"),_T("0132ED26C8B816CE8850B895F4DCE3E8"),_T("01FFAA9B7400390FE7470715071D796E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0266"),_T("0169AED3A0F67E2C8488D72A6011961C"),_T("016B2C899283273B1E568196B9F0EC8F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0267"),_T("01E614AD096C0BBC6D3930B1C21D6F4A"),_T("01E761C004EF5A8603F3EB8198E2BF9F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0268"),_T("01499A7445CF67E1F91FD160221DFDB3"),_T("01A5F149E6942061F725B5F7BB29EE75"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0269"),_T("01379F5D785888DE67F8869769133BFE"),_T("01F1F074159797A96356BF36921E9221"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0270-0271"),_T("0144B7952F8D9D40A7DD27993540A022"),_T("01FDE9CA3F612ADD0BC23A4F7D883666"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0272"),_T("012E96FA94C824F9A8640AEA33DAE4C2"),_T("01FDCDF2BE27B0A172840806A70E21A6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0273"),_T("017C6B6BC4D2D426AC637CB266713EA3"),_T("01DE1EF2CAAFF234AB731F79D04A8A60"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0274"),_T("010E204824CFF3EFEB296E548D2831F6"),_T("01916B4116500E60BE5D144985FA237D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0275"),_T("0138088D42874B0741D3FC58F5573AF1"),_T("017E3E77F3505D19F7327DD7D2724FED"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0276"),_T("01098D59ED7C8AC69F2C1E20CF4E0CAC"),_T("01C6BB26799012DB2BCC96DA02220221"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0277-0278"),_T("01CA592B0A278C10375A6E4148FE6419"),_T("01E286256520B9A7B43B0222D0E69999"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0279"),_T("016A44AAF01EF90192F4573EAFEFAEDC"),_T("01A657B1A018AFFA2179C715508B0F25"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0280"),_T("01503F4EEBA4820DF555885B90A5C917"),_T("0188F1B513AEC3F28F4F34D7E2A79BFA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0281"),_T("0124752B6F53B757FF5AB259745EDDD3"),_T("01525932818E982A26993F09F4F92CB8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0282"),_T("015AC49AF7DB5476531A72E670AB4655"),_T("01B2B99A8CBD11198C31AFAAD8640EF3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0283"),_T("014C59B66345954B61A51EAAAFBE6889"),_T("01542847E3D874AF2170840C401F0434"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0284"),_T("014991356E69A0C83FCE1B5326252396"),_T("01C75BC71D33F654F794FF5CFE6728CE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0285"),_T("016A5848CD54767A21084D3EBA1C8595"),_T("01942F78687AD71C00190D68849FE0C1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0286"),_T("0133BB7F25BB79CCA360CEBBE3C8CBD6"),_T("0198DFCF876DA1E81E92B7E9949D8155"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0287"),_T("01398276696E8F035EAEEB7B9AECD452"),_T("0155FF2B6BAE4AE1D1635FE67CCE8D0F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0288"),_T("01132101C4CEA4A437B39210AD463702"),_T("01637425BDE8E6F7E84F802802E9D126"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0289"),_T("0178B0F881697D3A35A0FF5EADEBBAB2"),_T("01DE18A63B1C8834DA9226AFED6724CF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0290"),_T("0153E02513D840FC99FE0B60EC6E5DC7"),_T("01C3F4EE67393C17F132E1C81761B80E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0291-0292"),_T("019D857D65A18858930E1E7D5D6B289B"),_T("01B1EB1585D954B41CDF72C01898778D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0293"),_T("01DE0FBFCDC2F65D93BA930372F59D41"),_T("01F94CFD5C2E1015E6EA3C240FCF11A1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0294"),_T("0192CBEA07A900E2422BCDA4741A3A00"),_T("01F9FABD244E1E79A0DC4CD9ADC55D48"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0295"),_T("01A25C1DDB83C5A4F020FF827B4E72B6"),_T("01D08774A3271E73C3E78532FDDE88EB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0296"),_T("018034E260B462D6E0F8ABFC8A3BB907"),_T("01F01BD0FBF6771B2850F5934646E944"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0297"),_T("016FF758B448E2511C296CBB45D3B033"),_T("0199D82603D51297B1F867AA942AE20A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0298"),_T("01AD570D9BB42F2D764F482FC66D3A97"),_T("01C47B48A2D9AA094611619C24AC2CB5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0299"),_T("012FBAE8007C11A27D87235DD8A08605"),_T("013CBF9607270A1954C81E459DD4F336"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0300"),_T("01C5200A6DBF9165C917066FA4860C0C"),_T("01FF6D37252274C859416FA6F98AC090"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0301"),_T("0116153BACF3F792E59FF7836DDAE7D8"),_T("0121A96A82547450CF8F58BF84284C15"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0302"),_T("0109E20C03C96B7AEF53CA5EAA5AD1DF"),_T("0114B45FD68923F2128B84DF8A6F3CCB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0303"),_T("01D50D828028DF78913C1B8DABECCEEC"),_T("01E004DBF278C6DFFD3189B29FE6093E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0304"),_T("015F75D0539DB0AA33DE9086D3D634AB"),_T("01D561C82C0BF4F7C83321A6DBED8824"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0305"),_T("0126229976467EACBF032D4C5A2D127F"),_T("016BB7A9E6546985118526AA7631651C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0306"),_T("010B8E92977DA6223CBE535BBF4A4367"),_T("0190F4E50734B3691B95FF3AB0F2D858"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0307"),_T("012E91AA6F00BAAD85F8F2B6BAD82926"),_T("01DB44FD317523A4D3C0A5C56340D7AC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0308"),_T("01772ED0AD3C1C1BFFC38E66898E3A35"),_T("01B0F92606B6AE035255B817ACAC850C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0309"),_T("01E1865EA4F6ECE601AC4422624C6121"),_T("01F7FFE8BE356C30D30EAEF9D85EC512"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0310"),_T("01A33A9D8610B69649BD2CA4291CC025"),_T("01B1997E3D406AB0A132C98A655550C9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0311"),_T("016EDA1C4521F0E5445B34F1345661EF"),_T("01F413B54D77AACC10C5EBAF527DE7DD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0312"),_T("017269EE6347D641396E6CE4EEC55545"),_T("0176C0087432177BDECB6B0564EDDD75"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0313"),_T("016BC2EE578196DA4ABC2BF857D60F14"),_T("018A160913B05A8E2A50F81D6F69EA46"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0314"),_T("01556C09EA00DD3C189F2BDA34787961"),_T("016371B1B482BFD9A55E101227864AA9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0315"),_T("01A22C90AA6B01914EF92C2EDD4399AE"),_T("01ABB8850DBCB396508E3A42659A9EE3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0316"),_T("016CB97F1CFD2C57C286C575F7F99531"),_T("01804E265A2A88E90D54A114FC8DDDE7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0317"),_T("019407B1682B8D28EC04607FA2B19EC3"),_T("01FFBFD4B46EAC504CD923FFB9E49131"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0318"),_T("015F455CD02BC42D60842BEFCD24E35E"),_T("01BE7EA9208B1F968C165587E7957E82"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0319"),_T("011D57FF8285857AA73865075C50B528"),_T("01EE6332FE27FACA6561FB159CD2C165"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0320"),_T("01B103E031429E917A31E86C3DA634DA"),_T("01F502A2624B1A16EB133755300467CD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0321"),_T("01325ED8501E998C8603C6B115102D5E"),_T("0139FD353945B81AA25529086E0CC5A3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0322-0324"),_T("012514374A61C0E0205A43EC2CC2DA8B"),_T("01298A5758D10D013E0130A6B560A15B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0325"),_T("0133FC69E52E74319F110B4486B8B0D8"),_T("017FEB124293E03634B25E85B537A2E9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0326"),_T("016D7EDE7606414D991E6952E80EE1F7"),_T("01D115190D8DC08B0088CEBD49ABDF3D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0327"),_T("012BFA25EC8A81E6A52D3EDD9EFFBB7A"),_T("01F64137199157B9971E5368174CC3E6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0328"),_T("01CA390C3C7A086D1F674E0F8DE3E487"),_T("01EA3E9E6C1AF5D15ED5E617A2D3D89F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0329"),_T("018AA265EEE919D20B4D74CB4CBCD9FF"),_T("01B0F2C7ECCAF189E47337AE0B2BE871"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0330"),_T("0138B43587335B7136A83646BB8C8444"),_T("016FC91B845047794BC8718125DC1D22"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0331"),_T("010706DCEC9384FCD911CE7EF6F9AA10"),_T("01DF585825BD040888218151BB180485"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0332"),_T("017A73E137683F2CF27F35A8EA277B2D"),_T("01ABB6CF48A47B6B69ACD617CA381C96"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0333"),_T("0172CBBAFDC69B2DB22550D9FFFDD5DA"),_T("018A1D72EF163CB05CC015BDAB62E943"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0334"),_T("0115214D14B7DBBE80708BF92F07C0E5"),_T("017AA2772964687B2C60899FC0DDF260"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0335"),_T("01BA0E6EAF685E372997C5158873A934"),_T("01E720041665A7B0028E31EB34495D45"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0336"),_T("010C82C21FFB556423D2E1AEA09D6AC3"),_T("01ADCE0CBE4B4BD36E8990DCA71F41FD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0337"),_T("017A6A4E8D40701EDD2BE40F880699A7"),_T("01F2C7A73B2E5BFBCE9E680FCF33B732"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0338"),_T("0113FADEC57583A1B8DF0EA04A8984FA"),_T("014A17E0D9EAE8D5CCFEADB7A409172E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0339"),_T("01B54851F7FAFFE3F3FFB0C98045C20F"),_T("01CD762DB17AE5F82C0534B07A265DFD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0340"),_T("0106D7625E411877CAA338676E05E5AB"),_T("01E04BE11B708F7730D5A91B89AAA914"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0341"),_T("01DEEF0C26CDB5F18CB5C30AC67D10DF"),_T("01E6FBB5A4BF581F87F339D62578258A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0342"),_T("0196CC9924E6BD959AE089F5862BA560"),_T("01D8CB2710CC698C40143FF0E146E3BF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0343"),_T("0197C4CC8A2121EB59A6E3400A8295EF"),_T("01F136537F044C37185E4D19C744AD9E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0344"),_T("011EC85456FAD165DBF5C6A5007C3E07"),_T("01805F382A0E1E5D4D49D5612C5B1FA2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0345"),_T("0161F9E8EE00BA1E250B7D55F186F72C"),_T("01CBEA20A3945A17C97EDB92D1A3F8C1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0346"),_T("01488B03814992ED43EF64D8659F28BA"),_T("01D730E0F6C17C9617BCDC128B90C379"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0347"),_T("015CC783479C3D9A25A18AE2C2FCF0EA"),_T("016D96CCCD278808EF958DD1C5315158"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0348"),_T("01A4190E753515CDBA00BEA808B04D1A"),_T("01FC1898602DF6895977522E10374788"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0349"),_T("0111982B37FDFA77D6C9C7356D9548D0"),_T("017E046DBD0AD3AFA3BD1443BB27D017"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0350"),_T("01273B05269AB49659658826842AC1AA"),_T("01851D05C185ADA1F03BA1DD7EB693BD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0351"),_T("014B69771DC99F42CF7E75A92453A27F"),_T("0163F1FB5A0DCBA8FE6D85138E1F9338"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0352"),_T("0132FFC1D7FEBB3B053AC02AD51A16A0"),_T("0158A45982834ED63790DC6DF9C6A626"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0353"),_T("0107A54863D862C397614B7A892B7C6E"),_T("010ACB017888870B12D192AACBD700FF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0354"),_T("0103CB9729158D46CF1DB0689CA14F7D"),_T("0132626CADD62AF02D5FD0DF263B71D3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0355"),_T("01C9AB1473B3FB383D976870F68AE1EE"),_T("01D58ADDAA7168BB2208616E8E37FAA4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0356"),_T("019140D94D7A9941798F2A71CA5437D6"),_T("01B52C9B356883331ADB76B001F7F391"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0357"),_T("01AD256679DDC2EDD0DBE80F157D88AE"),_T("01E1C17643BC7FFAFB439F32EA785BD1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0358"),_T("017CAA0B0B61BCE22B54D21D2890EE91"),_T("01A817DB5F8B63ED712C4E5726334B7B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0359"),_T("01B72416616B03EC44EE529F97A61DCB"),_T("01DF2FC19A3231A7DB9F482D79B38A62"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0360"),_T("0159B37AE98E23EBE3CC1A4F3B5D1EFC"),_T("01D2D675F82D7B1AF96E84C473447C62"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0361"),_T("014CDC93234C1379FE22988D7402782C"),_T("01A8A9D00F826AEAD001518F2CD437B5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0362"),_T("01B993B11363C5FA17FE7D38FCF8C2F4"),_T("01D377C41EC4C2584EE46CB3A4436280"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0363"),_T("01EB34994D5E62FC5E52F8DDEFE3D2F4"),_T("01F598EBE426AEE87D8F456C07B7EFF6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0364"),_T("0119CF37863A6A7F7EF49EAD67AF66E0"),_T("016723371317F92E47C1364768EA973A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0365"),_T("01787808AA17389825519FF453F8BFB6"),_T("01EBD34BDA688D36A8AD061F1095AE64"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0366"),_T("01E24A057CCF3F9D4E36888CD54AFDDA"),_T("01E9C7A6AA13FF21D1EB0B0C0096A915"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0367"),_T("014820A0E94228F9300AC1C09F07AEA6"),_T("01559974BDEC2A6063D9929B872E2A61"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0368"),_T("010558C701B4128C1C5E4E6C90F78286"),_T("0116171C8A2FC260EC329F719E262E0E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0369"),_T("0147126750ACC655ADDE82C1EFF1C0D3"),_T("01AAF51AFB5BA9B5505C1A9081C8DF57"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0370"),_T("0152506665FCB02684140B07D207A770"),_T("01BB0D0BE601F1B02E43FA4AC95605C5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0371"),_T("01DB04A9499D69E56B91AC0DC16F22EB"),_T("01E24EF7397BC708EF485D8CDFB19973"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0372"),_T("014FF9AFBE7E78E178C583D0F2125008"),_T("01D39DF0A6282B2C2398C38DEFBFF1B1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0373"),_T("01D782AF987ED53E7E4082935788895F"),_T("01DBF5EDF65B6D3F953F7D78CB8646B5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0374"),_T("0127E66E3B0B4204DAB9A632C5EC0767"),_T("014ABD9E2286076902B40329C4E8E6A5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0375"),_T("0141DBB33F21E5ED0522800C8BF949B1"),_T("016E46DAFFB0299EAE565529E35572AC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0376"),_T("011DF0955ED033F1136A7590B06E90B5"),_T("01B747309643CBC602FB70CA27DE7F55"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0377"),_T("01C3F32F5E678D3A7423DE27C938F01A"),_T("01D84EA5162D47C996A6777BC27504BB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0378"),_T("010DFF2B2F6AA668ED2612ADE8C9B3C2"),_T("01EDA6A155F9852329767462E5CD76C2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0379"),_T("01D3C34273ECB6591C4E721E283A640C"),_T("01F62E7C97C688FDF31B6E2F81454F94"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0380"),_T("0171F9A47B9B30D078F234F4418ACE45"),_T("01B5F0DDCCE9EBE5969E992D01129CF5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0381"),_T("01974F95F7C16468E32AD38170E510EA"),_T("019C1DAFA502776E7BAAC4747AB3332F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0382"),_T("019782C31B0C831845D73F5543BC98BE"),_T("01E15F4211BDD6C4F5E0F77E9326D1CE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0383"),_T("0177AC904C4E007252A91C25DCBB14EB"),_T("01DF68AB84D32B71FAD42C11B73B6BB8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0384"),_T("011400D468605B952AE88B8B10A18171"),_T("01DA14E2A02A7AD3469068CD7F038457"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0385"),_T("0155EF820020ADFABE1533A4F67C0B80"),_T("01C481734231F722C7445B0C55C84239"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0386"),_T("010E6513BE81BED0D4B36BD462D666E8"),_T("0134F1B277A728D903AFD77DB4619C00"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0387"),_T("01989BEAC872A1B99539690065A39C54"),_T("01A02FDF2E7F6DBB0A71AFCF077AED79"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0388"),_T("01540532C51FA06508D087686FD0DCFF"),_T("01D0DFB151D286F2298B6B28FAC28546"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0389"),_T("01950F306D0ACDBACB1E943077B6C502"),_T("01A1D2743EA64B7003A8866879ACD83C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0390"),_T("010520B3289F6C115E6C7FB5FF94AD23"),_T("011393F781C1F5604BBBE037EA344772"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0391"),_T("014291231A0D750BD42E7379AB2EC9A7"),_T("0155BC2CEB317B56429D72E3832C276B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0392"),_T("0119045ACB656B2AA89B8B7E7AA9A11C"),_T("0181F7838B94CC005C4D9415A9FC4AC5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0393"),_T("0108315A37ECD25AB2C3C7D34D8FAEE6"),_T("018EBB3CEB30AC32525A83E9674F4AD2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0394"),_T("0146224B58B822FA02B2550303B29173"),_T("01C941D2C9C9D882C499CF6C3B606ABF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0395"),_T("01B0AE5A64CD5462E66AE5E3E03A619C"),_T("01CD547BDD05B363D522676F3D639052"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0396"),_T("01812B79812DA11637F57EF135221694"),_T("01EBDB2DE50293CD4DF8563A62CC6BD7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0397"),_T("01135549E44963F5BED69C19E01A626A"),_T("01D082E1F33592E8ED3C0D04C34ADDF2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0398"),_T("013643035BD0BBCF2848799DDF50EC2A"),_T("013851E6565FCD218A8178D6C6A177A1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0399"),_T("01003B03E43F3C08EF305568D1EAA2C4"),_T("01040E165069A205217F6A88EC5AEEED"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0400"),_T("01764B33356D627246D9BDE18256C8F3"),_T("01DA8ADB8F6C79F85E968B77B23B1636"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0401"),_T("014DCDA30453F991F9C987E71F33A01D"),_T("0192427F2575D9764AEBFE1887CA89C2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0402"),_T("01B03481E5EE1AF8A0D9CF4B6D0C9B7E"),_T("01D28F1C9D3EDA1FADD49B775A70994C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0403"),_T("011A1AD05F4E69637D54F7644F73A677"),_T("01F0A14448D6798A5AEEE50E8C24544E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0404"),_T("0146220BE1E3384C10CE628D5C8FFF66"),_T("014B01295466371C1D24CA6CD2CA6C9A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0405"),_T("014DF9897E85EA56455369FCDD6F6E70"),_T("01877A475F66FE110F7B8A3A816A9133"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0406"),_T("013D8437D836E4297D1772BAC1E5F43E"),_T("015E43C944E17354042EBC370845C575"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0407"),_T("0148FC19E8FBB1851F30AE5F45112705"),_T("0161A26E905FA28126885B6AF72A8D1D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0408"),_T("01C637C2623EE02B60F7F0A6B3FDD32A"),_T("01FD447287C5C847EC6545B2B8CB387C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0409"),_T("013DB44FDC160E2254E0FC7175AF4A4B"),_T("0194A4989DAE98C41ED27CC38AE1E04C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0410"),_T("01369181F64CC932F704247634847989"),_T("01F40C8B0BE2B857818AB7D54AD1700B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0411"),_T("0139A96A7EF90701633DF35E361484C9"),_T("01634F996ABAFB8624801B6BC71E0EB8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0412"),_T("013BE218116F5C424D76F2889433ABC9"),_T("01F21D487E1140F08F6ED715C608283A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0413"),_T("01386F898D3FF042622254961860D2C1"),_T("0175C60DE795C1DBEC7FA2569E7C4BCE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0414"),_T("011344654042CFE5285074B9F759FE54"),_T("0156573AD1A42BB73D971215B649BFAA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0415"),_T("0140F1E3574A5277EDB2B7D62DB91A73"),_T("01A3CFDE5BB74875D0CD9845A0CD0579"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0416"),_T("01254CDD816D22F1274A2408AF25D54A"),_T("01A60E05A006B83663C13F79E518EF68"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0417"),_T("014C1996E3D5846DC928502735000E1E"),_T("0170BDFC71B6904408B13C98438A3F73"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0418"),_T("01268E71573851865FFC033A73EDA838"),_T("01B8E57A1D406AFDEEC40992332407EB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0419"),_T("011C34244A1783F3081F338394B63FDF"),_T("016406DD22AE88220391FDC65315C5AD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0420"),_T("010A6E0576302CA936E447F4618A8431"),_T("0114DA572C12C1D8AE051ACF5A968E96"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0421"),_T("015BF7F9F6764C265708C62043034F68"),_T("01C29B72AD423BCDA0B3413A8628AA87"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0422"),_T("0130BC5C262DE544C733420AC8384EAE"),_T("0199B34FC298156BAE8E81C9D04ACE15"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0423"),_T("013382A238A823BE795E8D8D5BCD2A2F"),_T("01986EC7F03B04BF24F244C32880FAA0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0424"),_T("0198EAD8D50C4408C1D37D44C3443C3B"),_T("01CD3B8FBA42269AEEBA7D8F9656C68E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0425"),_T("0131E2F41BA4D1CCC0F9DD6178DFCF4D"),_T("01509FC32735787D681CFD1BD18758BA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0426"),_T("011E7A4569DBA0E121E81D91462DE65F"),_T("016C961BE702BA452A489DF42A99FAFA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0427"),_T("01324B15EEECCFDE0D7A907E54A4C8BA"),_T("01B29068D17071B95DEF63969BF07253"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0428"),_T("01C7A2581BDE73567E3F07F99A904A72"),_T("01D7AEBAD9445D81EF0C99DBB30AF533"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0429"),_T("012891FD6E0DCC297BB5AD1D057353C2"),_T("0159A1AA837820FF99E28074A49CD849"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0430"),_T("0147411E31D4761D3303D58AC31C2B52"),_T("01F78B8C83226968EABF8E6FEEFA0CDD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0431"),_T("019A48C7F1949EE3F71EFDDEA395C4BE"),_T("01C53231B84B5784FF30F8C59BD01B14"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0432"),_T("010BDC7D1187FF0CB1CC6783A6199A36"),_T("01778D57EE62B36E06D41C8DC1A6E325"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0433"),_T("0175371036D9DE51EDAA0144E0A199CC"),_T("01AAF3BEB2C40054C86617289EF54FCF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0434"),_T("01331210DC5BB6795AA27B45B7AF373C"),_T("01FD55DE693D807A56CD1312F90489FA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0435"),_T("013E49E627D57319B424AD1FC37D9ED1"),_T("014DC069EF03293A2F0F42BD66D827B4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0436"),_T("019A93C48B520B1C40B9E7F3F6C6E473"),_T("01CFF2CFDBA3E60F9DFB4898F9E09816"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0437"),_T("01B0CE0F01EFBF706846A02896471923"),_T("01B9A8DD143D350ACB16069CBE1AD772"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0438"),_T("0185F3A0CE832BCCCE4DC841C5080CA7"),_T("01BFCDD7D711F3A95C288EE3035688D0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0439"),_T("016A5E7F4B01C1E50C9F29A36772EEE2"),_T("0189C05B83E027D45FE58BB3DC2579EE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0440"),_T("01B0A8D9978F8EF27815C03F48AB841D"),_T("01F34A28FABF97747395BB712AC37AE9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0441"),_T("0180E29802FE7454A524F36FE0B6B43A"),_T("01B6E6284CA2C0A3046839BFAEF215EA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0442"),_T("01A2B2EEE6F4EDCC72F54984E6409CDC"),_T("01B7C182BEBB12D0D557CB87715350A0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0443"),_T("0120474BD1393DEE893F4D918F8A3BED"),_T("01FAC7D572FE578DBE58A68BFD29F75B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0444"),_T("013C95A781126474E7935C84880C1363"),_T("016D3F0FE62365F68006C20886E6652B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0445"),_T("01140702441D18A8B38FF0AB59FDDE87"),_T("016793590F30219FAE2FC6A30C6CE624"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0446"),_T("01227400E7A08A512FFB19410CB9220F"),_T("0187B8FCF67A7E3DCB9B86374A48E31B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0447"),_T("011D931D35DD43E4D64643598BC6D2B1"),_T("01FC51D4686A6A12459792FEA57DFD41"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0448"),_T("018C55FB6FD97073BC8637B8203940B7"),_T("01CDFC8965E4A7BF7B44B86BE150A2C2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0449"),_T("01A2EEB0662AE55C1294513B6DC109BF"),_T("01D3EBC5FFC2A0A96533DD881E068D6B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0450"),_T("0191EB02D6A1677CB75B2C8505E352F4"),_T("01F866C46749929C0598EABA0DDEC439"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0451"),_T("013AC1A7E3E9D9CC676CCD7A543DB582"),_T("01D75C158973ED2DAEC8B07F552CF938"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0452"),_T("0157532D8B0C1B683254879AADA840C2"),_T("01DE075217BE9633DC710384A4D6EDD9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0453"),_T("0174C6747387A33B3A96B6323A15B8B6"),_T("01A95551F1C9CD937B95D861456ECC97"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0454"),_T("012C392B5613E551A6821FA0E54F8CFD"),_T("019B5FF7C37E4BF52F9FE041251C7BB9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0455"),_T("0105F9C080293209E3AEBE1CECCC7D4A"),_T("01412D3CE77A43A575221DFF8CBC28D4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0456"),_T("01199A62B009B1F466CB0E0E6404EE08"),_T("01A2D9C8FEF5C4E019E77966B259016B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0457"),_T("018E848CD3DF1DBDB5D82CE001CDB448"),_T("01ACEB6CEDF0722C80924FDB80FB7D70"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0458"),_T("015BA90DD391A7F10D2C01DB2166FCB6"),_T("01C6212E754EC57178CBCB82946709CA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0459"),_T("012803DC9428F1BD30D74DED1B197AC8"),_T("01D96024DEAB04F4882E3DC5609C28FF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0460"),_T("014B284F6780E8431B6782F7C3FB2443"),_T("0190740B961CD87EBF3396052B5C8A61"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0461"),_T("010B19115B7E61CE2DB4BDA480120DEA"),_T("01BF61EACB8030C7AACFDB5A3A2CA383"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0462"),_T("0148F74AFF4C0FEFD9AA0038F0D06096"),_T("01E9206DCEB55FD53A45A1FC49D0B0D6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0463"),_T("0133F236363BB55A3DC0C6487232F70D"),_T("01FC63F6C6038C347FC3CB3F4600EB52"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0464-0465"),_T("017F4D6A4D88E1F797C7244C6D159DC1"),_T("01C49F65720FB8B657FF0BEA2FD7C3C7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0466-0467"),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0468"),_T("013AC1608F7A083FA54F0ABC612E36C8"),_T("017EED788940B9E835B3EAE7CC4EB840"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0469"),_T("016B4A8253BFBD3B16FDE14E5A2C2E78"),_T("01E65D760D8EABCACFDA5F7D80EE41B1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0470"),_T("015641547A6E6FA36EAF79B1E50EE7DD"),_T("01C4A96E0D533D4CE4AF07371FC45AEE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0471"),_T("010722A0620056E9A2FF35D172ED6BA3"),_T("01789360A074D94FBF180890C02F8CF1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0472"),_T("01A0A7C8FAD86CD51719B4D11B809A75"),_T("01E5FCE7A9DD101E94A9E32B66E8C4EE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0473"),_T("019D13E47EAD93B95DFE2D80B9FB81E6"),_T("01C55AAD2822F315C3E2D3F0CD4000A7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0474"),_T("01353632E1E04A7081884271A93A13B1"),_T("0159E5C814BC1605AEE28A0EE89E4F0A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0475"),_T("01977A5680033292F498E7CF4EB62437"),_T("0199439B7E7464FEA9A6FC0FC1285B9E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0476"),_T("011CAE68B99D05085FC30546A1DB3452"),_T("018463C3E6CABB68E655411E87FBFCB4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0477"),_T("014FAF505C1A45011F1E99F280135A18"),_T("01CF2E949F6F3973B17077A6DCD078CC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0478"),_T("01C02512D0005A0849AB22F0BDDC0E2B"),_T("01DF7500501CAE9F89E0CC7660CDDF72"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0479"),_T("010F353D6181F73F425C37F9A1282695"),_T("0159E6F0AF54E1502B58942F96A0A2B0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0480"),_T("0140B3EDC42BED8D7893372A2EE399A5"),_T("0188BCF4D70EED40EAB0A6AE12C8856E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0481"),_T("01390D43C65FD5DF5DA1CF416607E83C"),_T("01D95D92A1702017D722D918EB17D7E9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0482"),_T("013319E9ACFC1592EA3707443D41379B"),_T("01C641A80FA9F17A2F80671405FA645D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0483"),_T("0193978466E8C45B530015DAD9771756"),_T("01B431F54E253079EFBC6E35AA851485"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0484"),_T("010AF02A7E11380A8E7048EC838C9146"),_T("0174C6950A3ECB17C3EDAE3943CA0E74"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0485"),_T("01A37EC6A34E45D9E324A41C3C1F8D0A"),_T("01E56E1F28A07DA431A8E941A4ED3D6F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0486"),_T("019BFA737D93AE4E810BCEC1BF622FE1"),_T("01F604112EDD2CD75252A3F4E7914186"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0487"),_T("011E8FC3005D787803DC61391250E11C"),_T("01260816124E68FB34B3C5A968652188"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0488"),_T("0180ED9DF7C292F9E6EE10AA0EC33D93"),_T("01DBCB52A9F4D5EF652ADE91D3DBC20F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0489"),_T("013CE5A98CA06564271913E97E17091C"),_T("01CA8DB74626EB5ADDDE924CBB808177"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0490"),_T("018C33F34E14965F901D87E2F5059D76"),_T("01A2863D209D69C318C2D791ED4A198B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0491"),_T("01CC427EE894AC6DA5233F1BB70DA151"),_T("01D392E7B3F2274DA633A257D3335513"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0492"),_T("016AE6407F27503483641CB265E3666F"),_T("01ED61C6EB014A13D153CCB63075CADE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0493"),_T("016A8B9D3E06915B6057C1A4E9925FAF"),_T("01EADF79B040CBDA0A3329190FFF5E60"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0494"),_T("011C975826DF4E650B123D6CBD745FEF"),_T("01A9583C33385BE8C5D9AA8DF5C4A2A9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0495"),_T("0186DDA3C99987029C896738E83A6423"),_T("01A083083E3BF1EB8EA792091F3FDEAB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0496"),_T("01013C1CD527C24F7C5DB1A915507C76"),_T("01EA1DEEE251FDD2C98F1A1E7CF06DB0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0497"),_T("0115991B24A2457586CC3A252FAEDF93"),_T("012B0F71ACD29195BD62C24AAD206F86"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0498"),_T("0174EE93AABA2457FB0A41BCAE94A025"),_T("01B6C9DDB75BE6F5A0AFC904F69999BE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0499"),_T("01AC981B3281A80EEA9A1EE13766901D"),_T("01EFF430D5EA2DED89B39B35669A4889"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0500"),_T("010A9056CAEBB877BB3ADA1540D60D26"),_T("016FE42D5D9723FEE0EEE84FF3D859A0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0501"),_T("012B575006786ECBF308796237665A0D"),_T("0187FE84BF2728468C1F8DAD7BAC74D6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0502"),_T("0114F3762062837D521FC2EE9DA92199"),_T("01826894D6D5FCEF1DE9F84C2E926253"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0503"),_T("012D23D883E0AD3058D4CAF7CFEA8160"),_T("01ABE7D58F64F0BACB5F3745A1571F8C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0504"),_T("01412DDD7EF447F4BE51597651384825"),_T("018B9740A2EF139B8A4CABE1EA9082BF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0505"),_T("0104D700393677934A3376EE0EF59B10"),_T("014E439B42B0BC98DE98769652F16506"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0506"),_T("010ECBD9D88CECC0BFC1D6EDCDA59A5A"),_T("01210F00D2B4E698BFE43D6500739FCD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0507"),_T("0116F7ED80AA7FB5288AB995FA31E7C8"),_T("015B8CB1DC0E7027278339C4A2548446"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0508"),_T("013B3824930D0195BED318AAE153C0AA"),_T("0159AF9A6C1A473B1BA1D3B1A1ADEA62"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0509"),_T("0135589828B5D78F89F92CFF0BAD7B1F"),_T("013D977C1BBFC9367671545500BAF3A8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0510"),_T("010A47B0AAC2F9AF94E42FCB5F9784DE"),_T("01D59C3006B20C6C80E322B72E56BC61"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0511"),_T("01EBA0DB74E96523A5EFFC5591CA7710"),_T("01FA385AAC22610419A213399C6090ED"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0512 (Medium)"),_T("0119EF3DDFC8AFAE643E7D5C02A7BD06"),_T("01D050F7B28604722499747F698AE37B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0513"),_T("013BA6E39F3A8198BC9CC8BBE88CC7E8"),_T("0148D2AD5FB27F03DD7EF6494E374DF3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0514"),_T("013829C572356A4F2C6F81A1B4909309"),_T("013E47531452F2C6FE57201ADF6EE8ED"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0515"),_T("017874969F6A9CC97F2867FA0A05E7B4"),_T("01DAFBE1190C8C50FD91602E042E2FF5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0516"),_T("018A74BE1C5A6707E2DA4057C7A4FE5C"),_T("01F92C3E6FEEF1D9EB564CC49B8CB41C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0517"),_T("013E2307EAA7A15304CF3B76CBF7C16A"),_T("01EE0AD6E211AACA392B5E03530E9C09"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0518"),_T("01C30FD636D41E1204C54F7D4607BE82"),_T("01D00D35AA2C30286149F79BAEACBA7C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0519"),_T("01173D1EBB33A4F2E070B5867F132C6E"),_T("01A266B175D7197CB016173224B78D9D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0520"),_T("01B3DA8CF02BDE7FA68D34243C140F69"),_T("01E9D25593908740A63E07F070225F1E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0521"),_T("0193C847546BD23021C382452F392451"),_T("01ABF300C7DB5E8A406DCC4F27517827"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0522"),_T("01483D27FEBDB0A0700DDC8B13447A29"),_T("0150AA0F3370CCD475ABA3F176C7246B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0523"),_T("018EB546459E180ED0A78376F0B86DD1"),_T("01C4C5A323B32B46E52F5A44DF16AE86"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0524"),_T("0149EDD8F40A4F402E9C85140D5F5E64"),_T("016592157E2278248194FD0CB1628859"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0525"),_T("012B9F12897CC495658FA7C8E71F6129"),_T("01A7688231540AA058762F89F7532D3D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0526"),_T("018AECA8CEB44F688DB3E833244D4F17"),_T("018CCCA6C1F54BC6DD537E90FC9BA14B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0527"),_T("018E05B59673206626E97C3D7EB3E533"),_T("01D99B8F7C5E1793F94EB6F0F1F5C413"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0528"),_T("019BB8FFFCBA7222C2603E5B4359CA95"),_T("01ACB248F872EC6A233D9828B10C2711"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0529"),_T("01725A3AA5DD3A8950439B2A12422310"),_T("01C63D32D890102FE2AE651723FC4658"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0530"),_T("0109874E43EEA38503A27E21619D3419"),_T("014510AF5A2662C30D8E86668401002F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0531"),_T("015B62A53E2AAE1F9C45F8E53D8615F8"),_T("016AD3B63321BDE3E3AFC869984AF05C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0532-0533"),_T("01315330924E21101CEA22D844F5DA75"),_T("01FF5B0059671E82BC316B53A3EA430B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0534"),_T("010F281AAFB3DAA7AB9579A81A32F83A"),_T("0179878902493D17D868B06656C11D49"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0535"),_T("01361651FFB7E4064EDD1CB4AC1F79E8"),_T("01F6F4526A88E2F8FD82962A49B970E7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0536"),_T("01CDF4161B9EAD0944C4C637713F890D"),_T("01F64488A68083AA011C86EDD9B6DB5F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0537"),_T("01041AFF93E2B634CF24E47D12B10123"),_T("01495220A029A18FE0BBFF73BBBE2A76"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0538"),_T("011CEDE2297091B8203EFA1EA2099CE9"),_T("01DF29B9885FF8B13FE401DD941DD6DC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0539"),_T("01BDA2739C2D2EED4F87164EF88E8424"),_T("01E5201E2D8E6D430410D083445CB274"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0540"),_T("011AFCF5E21D51C4C46E47E4836536DF"),_T("01572CAF26F97C3991673130F5B79406"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0541"),_T("0177A848BE829FB1D0CA048C07803325"),_T("017B428D20074AD5EA7D1B5A1F1E9B54"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0542"),_T("017A6B4FE4405C5D571F6EF30CC6754C"),_T("01EA537E8D3B4E668D1762C74DAF2916"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0543"),_T("011E948E332DDBFBAD817997E6496D08"),_T("013EC1BED397021141FBBAE1E85A10E7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0544"),_T("01079651EEF6AEAF5559E1ABF169AA9A"),_T("01646999D0D1059FBADEC52358A8E186"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0545"),_T("01199F4840E879CF90C93F2A3C032765"),_T("01824E11B5A82C46E2979AC1EB972FD6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0546"),_T("01D467159EF7FC037D4BC15975425DB0"),_T("01E07FF8FDA5AFD0F161A6916A487FF6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0547"),_T("01337CCAB01F142FFB043309C1BE89ED"),_T("01D9E65ABF15551CA1E4E850CAC18341"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0548"),_T("014D94DD0540F158FB57C393AABE6446"),_T("019AFB1E0C3E302F1A4FD4A872A06043"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0549"),_T("0158258EA1FD2608AB5B950D7F4ACEB8"),_T("018F0A6CDEB1D850B343B4AA3C6BAF47"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0550"),_T("0172F4A74DC5EAE3E3211EEB52E8E2D6"),_T("0175533E6936247A24A4E723429BE097"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0551-0552"),_T("01215F8B546A79060EE355A2E97B66F0"),_T("0148A415D0B4F9D30AE5AFCE60FD785B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0553"),_T("0130A8F30CE48AEDB0BA769B98F622E0"),_T("01C2B78C71BC9D738A4A98016B6166AB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0554"),_T("012B879B089D4682F35808BB55E714CC"),_T("012C7B5581572F1B7E656E2506297A25"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0555"),_T("016DA97EE5CBA9DB6AFE79095C8B67A8"),_T("01EEDA8D76433F3826EF1D55DBAFB6DF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0556"),_T("019217C84EEB33F8F15541663490144F"),_T("01DE7129878875B91093EEFB15F4ADAE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0557"),_T("010CA54F01885376F1BC40C9443F09C9"),_T("01DCCC15C2CFFBD8726C36AF07432733"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0558"),_T("01529AC7132D369E6C8153BF022A572F"),_T("019D0AEA75EFC29E8E40EC2CF0D2F52A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0559"),_T("017ABA62F8D535F93EC1748A6CC8930C"),_T("018F557B9267C9728DF25AFC88375EA9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0560"),_T("01D0CCC1F1497C77980638AB280C571D"),_T("01E0A9A04CB177D7C1B9DC126FFC24BB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0561"),_T("011AEC06FC3F1F97B6B511D8291BDEA3"),_T("016497F7069C0C1B3DEEC411B70492EF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0562"),_T("011020A8CE017867DBAEFE0AD14F6766"),_T("013C6F7BC009FB2C14B5CD427986C52B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0563"),_T("016D89BCB9CFA1EBDD85664CFC4F28BF"),_T("01E28F5CCACCC03267E34838C87F40A5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0564"),_T("011A24D4D1F20D578607BC06AB1C570E"),_T("0169E3418F2F19EE06D7E139133BC098"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0565"),_T("013DD6F8235429E6C462178C6BB4607B"),_T("01539D2AEFB11A47144BE2DF97712599"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0566"),_T("0142ABD5F13DC0E83CBD65CACA5B5B89"),_T("016739FA7498D8D0EFDC177C323DC489"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0567"),_T("0186A524B452BD06FE2B3514423D66CD"),_T("01E27A9C1791474E596B64F9FBFF6F3A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0568"),_T("013FDD18059D23A2022F75AD850AE91B"),_T("01D43AA02F96D9715FCC389EC237D9D5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0569"),_T("0196F647E3787E7D1D8D435C25682A43"),_T("01A2A6C89226F66B40054A4E11C68A09"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0570"),_T("0160F53AA8AE22485E9FE1A3B5626243"),_T("01717E8FB416A5B5B6AB7A21773907B6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0571"),_T("013D8ACC259EA3DEFA871BDA970004EF"),_T("017964C23B09E531380036E45A0034F2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0572"),_T("011BDB09582A077704EF571A2DAECC0D"),_T("013A79D63066295F6721AF900B86D7D6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0573"),_T("01405E2A203BD650AF23FFB5BABCA259"),_T("0196E4626FF74CA6CD5324A9EA119AC5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0574"),_T("01196A438AEA19420E2EBFA693B24A3F"),_T("01CBD656AFC34BFE37ED9AAF5A6C9660"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0575"),_T("01A4BD144F232B5FD61732389CA2C61A"),_T("01F3FD2303A977F8AE85BFCFF1A4B2C7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0576"),_T("011A501544AD16AE1BF926EDB16D7E60"),_T("01E2E90275E1D6117E1FC4EFBCB2E758"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0577"),_T("014F5E4309F2016B7C520C8C4D6124BE"),_T("017239CF21D05D985CE2E362A59DA3C8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0578"),_T("01784AF43BDB59E131697740D9F749C9"),_T("01C5A7E5F1316C4FC792054221B3AC36"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0579"),_T("01BBCC62EDC5EFD02521156E8DFD4E59"),_T("01F65EB9B59FC85FD2F5A9BDB5C6439F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0580"),_T("01B370B0CF9B39814C9FB285A1DE7BAA"),_T("01F691898CCAF8B18EC7B7584B589F3A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0581"),_T("0141BB96199D04625C3ECCD6C377A54A"),_T("01438D96391F5059A791DD54559C497C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0582"),_T("0118B4C9F3738AD70982BCF1A3233800"),_T("012ECCB297F3B309984AF91FC7E42410"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0583"),_T("0163D2A5B396C6CE9F37619A295DD844"),_T("016B9E564AEEB38875F3CD83336826E0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0584"),_T("012FE2E13FB0F51F392900520178EFB3"),_T("012FF7557920FBA525E636A6B2EE6C63"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0585"),_T("01D31D3A897C16C7B6BB261C790A8AB8"),_T("01FD51C58147F6698BBF8E432570EFFA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0586"),_T("013DFE922200A5859E4FEA6FE22D2E08"),_T("01FB2A709E8B47A7A6108285951BF8EE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0587"),_T("01934C08AE04B95306C45924D92EDB7A"),_T("01F06F8AC2AF95397733F5D7FC833D60"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0588"),_T("010E8C8B4657B99C292ACFAB5E054D0F"),_T("01594781802807E4A112EAD772B47FE3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0589"),_T("010C3512EF011615AE08B5A0F5A18AE2"),_T("01A1D847941C44FEBC8CAD6AEE81CD6D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0590"),_T("017D7FCED13E3FD6F5EBEE434968FFA3"),_T("01D7F59588D2F21D4AF073A86EED0E97"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0591"),_T("0131E43B8F3B7E1F7CA44D4FD2845948"),_T("019532E04894BE1217FD71D5AA70076B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0592"),_T("019ADD607FAC29CCFB1F7000B6F0B1CC"),_T("01C7EFE68D0ACEDC6FFEB38920F24073"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0593"),_T("01625B46D4345A960398554960E1F0EF"),_T("017AF6F64CFF7AD017DB776E9FDCF93B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0594"),_T("01063D3B7A459A1960B574873CD009AF"),_T("015395E9D289D85143E3FF829DC467AF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0595"),_T("01A19DE721362B0F81BEC7026A251C41"),_T("01F06464DF9D98E3BE5F8A4432E741F7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0596"),_T("011F4079C2BE836A4397BF10DFB77189"),_T("019E8705241279BA567FF049A067A535"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0597"),_T("0181C78303E484735F45F80B309F77B3"),_T("01C65CE052D427878D7BA214B0FEF229"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0598"),_T("012BBC4A2210601C2CBC1BEB2AB380B3"),_T("01A23773A58813A23C918B720C8493A7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0599"),_T("011F86E82D6FB033A3728AB3D9A20821"),_T("01E281EE027BD7CDA97FBFF07490AF6F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0600"),_T("0150771598CCA9FA1386C8CF7CAAE2C8"),_T("01EDAFDF283C0E3E5329BECC28481DEA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0601"),_T("0119390DA0FFE0A164F2B3760794E0FB"),_T("014B962B7070DA78C91C4582405DFAF7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0602"),_T("010DCE4BECEE1A505B5E19BB0129831C"),_T("019F2B93445875DE45079688AF263FFB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0603"),_T("014695B0F2B5DBFCBC7A03C6ED5DE395"),_T("019FDF3B64184478EDC7A78DF1D326E3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0604"),_T("0111FB1DA18149736B19222FB0C4A0A1"),_T("01E3EDEB2B9B5ED080E3F91434B8E5FF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0605"),_T("01207A7BCD539CE50B1544D3CB8583B3"),_T("0175C3EDD1F83ECD543667A4A5A15EDF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0606"),_T("010B878577817EEBF329605E67824DC3"),_T("01F057E232007EE31E5CC9EBC15500F6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0607"),_T("0183BA956E2DF949FB2E214319A9A040"),_T("01FDC2A61BE20A287FA3C5FBC5F4C07D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0608"),_T("015FF2926021E3547CA1F5315A4DA91E"),_T("01E1789C081C5773459525805DD3F1B5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0609"),_T("0116E36C7C1FF430775A8F1B094B702C"),_T("01423DD4B032F187954986F03046B94E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0610"),_T("018AD14B2718E06FCC8FD3AE04D0E5B9"),_T("01EC01F52AA6AADD763BC047C59A9539"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0611"),_T("016B60B93469A1C699D34DAB3F52815D"),_T("01CA5228F2A7274064DF65F76BA1BD18"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0612"),_T("01CAC8F32305645BB022CDB9F1F5FEB4"),_T("01FE086949D3703F241B43EEAF4BE3F9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0613"),_T("015C31B9B2364EBADD1D4536165B821F"),_T("019FB982D1E089899459D0E691A72943"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0614"),_T("01504404B1E5B7AEF9AC9E53255288FD"),_T("0170192E66D245932BAD94179C879C1A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0615"),_T("013A71FACCB23F78B9336C910825E01F"),_T("01B17BDA706ABA44257C8EB44CEA537C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0616-0617"),_T("0196628E172FF577C928908747304A38"),_T("01C39B962D89A8056C280F5C53AA4E33"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0618-0619"),_T("0124A376C93414B16308422029BE7EB2"),_T("016711181F86C56184198107A8B1B2CD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0620"),_T("014E931AD85225E17346BEA135A657D1"),_T("0176AF1071F4DA4385E3EC0AAF79E0A5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0621"),_T("01C5E85A4DBCD5E098F88522E4ACDEB3"),_T("01FF0DBEC5FE494C16A5BFBB0692551C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0622"),_T("019432D6DFF23214B94AC29AC87B52B2"),_T("01A532FD0DE2B08102AB44F9787AB6A9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0623"),_T("011741406FC79BACD3B1C13EB30B853E"),_T("01993F9BFB22858B5BC8AF0AC8515D05"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0624"),_T("015B2ADDFD60C24DE90610C30F427C4D"),_T("01FB749C238A45ACEEE9444DC04BE7D3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0625"),_T("01B311F09CBF18BF46103A6B6D7B9953"),_T("01B31D6ADDEEDEA05C958DBC1BBFAB16"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0626"),_T("010CDD5C0042D54FA7BA6C6EA26266C5"),_T("010DE710D720BE30A4AB6817DECF3E5B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0627"),_T("0195D5A9021B6E9EFFAF0AC55974F935"),_T("01DE59024EC091DEBE4ECFA08A5810E0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0628"),_T("014F58F2AC03A1B61EC73CE42476E1F8"),_T("01EC1D716C02DCA253E31D3A5D20C36D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0629"),_T("01487F70349A520AECFBFDA44FC4C26E"),_T("01AF0FBD376861C070FF41A61EEE92A9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0630"),_T("0100BCD7BCF205B784EC2FD26A19A465"),_T("01AF190F303F9923D63B01083EA3C49E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0631"),_T("01A0609D0ADDD544B7B07FCE1A238E27"),_T("01FF054416CCC06B35E291724A8E625D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0632"),_T("013487E10453F3F6D820C2C9A96FF542"),_T("01E35CF64B08F3DD08E1C3A202F95D94"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0633"),_T("0105B163264E4581A4DE2E599939277F"),_T("01E58F0DE89BEC1891B16F53685F230B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0634"),_T("01266999C06F1F36BE31A19ABCC56A8B"),_T("01B85C9AF7657E7CB676E4A3935E1498"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0635"),_T("014D979D3B9289B763D5328F6846BCB5"),_T("016892C835463DF5EFB7A4F91353C529"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0636"),_T("013B179FBF51592750480D2C9919927B"),_T("01F7471FC574BDADBD57D16CA9C90CC7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0637"),_T("018F406B4CC441E964548BEBBC60D623"),_T("01E87175DD7C18E5C5FA6BA8159C94FB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0638"),_T("010FF686CE1C605FDEBA93787A633D61"),_T("017A49933AFBA16618C0096EA41750E9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0639"),_T("014D7FD735E513C363BDB6201C0820FF"),_T("01F4308CC79989831DCBFA85A1C12703"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0640-0641"),_T("0149635D84D269B43578215A80FF5B06"),_T("014CB31B469512AE67304AE64C2A8574"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0642"),_T("0185B6CAB5D7A16084F11BAA56C09541"),_T("01FF11A44402FB7E615760C82130FE07"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0643"),_T("011CBEAD1346460F0F8A4E20B0074383"),_T("0147F3187321624D43B73C65D464CC5C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0644"),_T("01421C0E478349B038A86473E0A74EE1"),_T("01AC2A9B988883C81A8B40D71D20F9D4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0645"),_T("0109DB86288598A2D3AF4CD477AE59DE"),_T("017806A15D182315F03686D7BD9573AE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0646"),_T("01E0B7CCEAF32A708F20880A05359EF2"),_T("01EBAA5744E1C88BC4C63DFD7A4DAA78"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0647"),_T("018019FFDA1E0C06D29271B2AFC990C3"),_T("01B473BFE6AABAED9113D75360449B5D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0648-0649"),_T("0120539057468B71AE1A38509164BB83"),_T("018F551209CB3D9F50F65921B0AE905A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0650"),_T("01451F027933100BE142E67765B629F9"),_T("01BC131EAA3BF14CE0AAD581C8A59A93"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0651"),_T("01341AAB8FA2577137E21496D2E4444A"),_T("016ADE70C44F0656895FC835AF292C95"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0652"),_T("01BE3EAAEF8FD7220B84AF159E8FDA8D"),_T("01D6E132612A02FD07D5D91C2167636C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0653"),_T("0135F0E85BD17FFAD0FC0AB864383039"),_T("01933455E651433AFE5B3304BCF6972C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0654"),_T("01595EF5515383D023051550499B7C4B"),_T("01F3EA2A5B38FCA29B828E2A19F5CA85"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0655"),_T("01F05366224EA4A7C8041B85AC412B51"),_T("01FFD79267B38B946762B575DA8060DC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0656"),_T("01D3634F4F993FC19742733E6172A1D2"),_T("01F8156E2700659AD1B9E005FBE11E2E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0657"),_T("01BB4E3F9D40B7FE627B32F0A14F0ECF"),_T("01FEEA836C2FA04443C4258414FBE09E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0658"),_T("015A2EECB6F997E58B971DDD5E4F3599"),_T("017EB8D13251EBFAFEB0D2CDEEBF64E5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0659"),_T("0107B1BDF3D8DD5E2E667AD0D90AC1F7"),_T("01B1E0F7A0134D6ED55DB4E7E0FAD481"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0660-0661"),_T("0160EDE6DA1EE97DAB0FADF77C10CDE2"),_T("01DF9A73AA539A6A4441AC16A3815F5D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0662"),_T("0105D86A361A46843E24A65FCFDB3F5B"),_T("01DEBDE71AA7E6AC6670B89A240391C9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0663"),_T("014AF66861DA40F04E840F02196310BD"),_T("0160E51964C3F8814CEECE4A8564EA4E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0664"),_T("0108CB6C68D2169DC93F75F24BCC20E0"),_T("01EAD5F0FAFAA20FC6FDD7C086E30695"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0665"),_T("0161A0473A80FA6AE22E47A4D5D4BDD9"),_T("01AE72B0E17F3DFC763EDB0933A2008E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0666"),_T("01366A59F1EC5DAE2EBA473E9FE39E90"),_T("01CBF8333B24EBE49FD91A3168DD15CF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0667"),_T("014E78244F8874EAB07FA03C9477830E"),_T("01A3B985AA3238882AE1D45645C3EFB7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0668"),_T("010F4C2826D9C7DC2BFA69FDA415ADC1"),_T("017FE93CC0DFCC3CEB6242E8E806277A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0669-0671"),_T("0126A2FA3C22164DF0A9EB95998349AD"),_T("013ABC0489729523BAA273DDD79E35AA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0672-0673"),_T("0106565AA8AF8C8B175E2099D8554A55"),_T("01E0BA388CD18FF5EE51C8A0B4B9BC8B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0674"),_T("019E8548175BAB4AC73A6B0EE259B1EE"),_T("01C7EBECA6AA280425623EE8A755D84F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0675"),_T("011760944E0002C67B50606C1EDDB005"),_T("01ED37EDF7A8B09E7D7ECC52CC1777C0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0676"),_T("0110CA7CB1A26824094B92768B72F626"),_T("01A97EC414E6B9D3F0C20A92332451C2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0677"),_T("011D1D8F80824BA994ECF22E00794B4D"),_T("01D253009A4156E5D55CF596A190D6DA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0678"),_T("01EEC69368D94F689DB28B50BE9FF1F6"),_T("01F2B0B2D717144B98A57ECAC8E2B038"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0679"),_T("0126C4DC25352BCB8FC2CDCE18D302FB"),_T("01CE70B3DB930A0E07D8C9A234DE9223"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0680"),_T("017EDC69FB4953E49F1D392B50700474"),_T("01EEDACA91CABEEB1E30461B5AC8796B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0681"),_T("011ABCCE7FF704A1134987C9381FE453"),_T("0199CF079A275C3D6502744E1F9FA38B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0682"),_T("0116B512F11CB253BE375B6F9D1A4DF1"),_T("01BEC1DC1E365603C9A1F34A5203AB1A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0683"),_T("016041089623F059C1430DFD4415742C"),_T("01639DC99BFA73C1BD89B69E5D75B6CE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0684"),_T("01990B0BF37BE0DD67515AAE6027E7C0"),_T("01C3542AAEAC14324AE9F432ECDEC50A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0685"),_T("01A06E83B4C8414944D4EAFB97B4CECF"),_T("01A21489B17889130F5B25ED2D63F389"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0686"),_T("01A1633366696868B8E8B4B66E2D91D9"),_T("01BFE49AD49262F4BFE51C4976876EDE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0687"),_T("018BE6F95DB41D49A6334B754B62A954"),_T("01E1E7982C7D30F713503B6337A79754"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0688-0689"),_T("01BEBBD5B162549AF3F1A738360943F6"),_T("01C4D090385B1E48E69F9367A8DCCBFC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0690"),_T("019DBA0836EDED58AB112FA7A6CD90EA"),_T("01EF7849D3DFA50329C62AAEFC27AB72"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0691"),_T("0192D8EEC8BE959ABCBB1050E0AF26F5"),_T("01C4D7E9E7EEDB2C8C811FF57C4205FC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0692"),_T("014E74B3253E7AC260C60C2E726CE1C7"),_T("016AE7499A4B36DE74967AAE39181B65"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0693"),_T("011012D7160D574CB213546EEC0AA2B6"),_T("014E086B045D6A4CF049FC03A1B0648F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0694-0695"),_T("0121AE462CA220728E6487173DD04DD7"),_T("01EC69DF19534B2AFB4E7666135F531D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0696"),_T("0115E10B04E689E43D807BCB48C8E684"),_T("0161B5930D64896B3698E8170E80F0E1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0697"),_T("012E18617B47370407C6F580545F063F"),_T("018A2BA552B11CC325831C5829E1532C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0698"),_T("01138552102BE957D7D106EA02237416"),_T("0122DEA62DA2B0EFC7A50EA650D55824"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0699"),_T("0197F05D7485FA7A5BE930FD519BA672"),_T("01E86D710032E0FB8A4E92234B04C87D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0700"),_T("01995D63218D76C0A444960AB08ADCB5"),_T("01D724E5E046090F8847360B3956A5EF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0701"),_T("0143AAD72758786BAF42C240C82BF85F"),_T("014BE257E635D3B51336CDB730220372"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0702"),_T("013A0BCD88068C2474C6209C7842BBA9"),_T("01C705210854348EAFC54248BA482EE4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0703-0704"),_T("0171FDB6AA66F1C1C71E52F49A6501AA"),_T("019B93D2807091FEA62161B7F3B2E1D0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0705"),_T("011A11D1467C51885297BEA1677EF0E1"),_T("013C878262ED898982788866AFDBA53B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0706"),_T("011EF334A1F5878DAC969B2D975C5C9E"),_T("0151F34783E62115D851AEDEA5BBFB27"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0707"),_T("010970729EA8DA34D6D0ADD6C4FCC0A0"),_T("01ACDF4A1A6A1B9BACAF9AEB517F15B8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0708"),_T("01160C0A461223FCA14B803999C77063"),_T("01B9872378DF042302B5C61A0CEFEAFA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0709"),_T("0107F990EA052C704D000EA613E98071"),_T("011E23C05DF15EA242AAFE0CC9643CF3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0710"),_T("014883EC107C372F451881A92BE75B6E"),_T("01B357CE02A83DE3A4D3E0C44DE16D0C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0711-0712"),_T("01F2C7208522D584AC48F29E773739DD"),_T("01F9349EFF2EB352576B06239703115B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0713"),_T("0163DDFECE4F9B9D9BBDD1C3218DC4F9"),_T("01946EF487B9339E9F437A8C69CAFB7D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0714"),_T("01521970584A867B2C85489A407ED5EF"),_T("01D6D0CE4DE7EB6FF07F75BF91AEF714"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0715"),_T("01281F3839F9C167EBC0E90C500A1E8F"),_T("01E68A9ABE6EFBCA99D8717B314A7741"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0716-0717"),_T("0134A7CE8E7585FE1F943D0026551384"),_T("01C3C7E7FDAAC42F2237CCEE8D1B92C4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0718-0719"),_T("01739900893E6A9FB4F49DFCCD467491"),_T("01E24F33D9CE2357188A51C84D73F420"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0720"),_T("019AD443DD29FACE2373D25E8878B52C"),_T("01BBFF1EDFB76F360E8AC44C50664558"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0721"),_T("015867A80D31E8FBB5FA03FA5F803379"),_T("01CA611F74EAD0841DB3817C6FD50452"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0722"),_T("019D394C31BAEF3FE5BAE653A1D94E6A"),_T("019F86D96446A0EE774B229DB9E9C70A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0723"),_T("01314DFD630E4D8D003E2E246A8FB607"),_T("01458C161B002F44A3AE037676107702"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0724"),_T("0124838C508E0A6EF0691B431E4DE939"),_T("0161609B0BD3A95476488D33433FB88A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0725"),_T("011439EC069399C29235DBE644C41565"),_T("01A31CB55665B8A1742F7B24CD82043D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0726"),_T("015E67C21DDA3E3E85D76DF6E615C687"),_T("019604DBEDDFFDC04EE4E5BC07C7B923"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0727"),_T("01982BF3FE2D349DC94C81AA03E16A3B"),_T("01E5810D6E525A705831B7F249F6F31F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0728"),_T("0134FDC769F9513D03884B184C3B8474"),_T("01913604EDD203CB3CB8EF8D9405CC78"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0729"),_T("0162D8F4C6DD019A9AFF0FC19670B4F0"),_T("01BD06018FE3B154414A43FC5CA06F29"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0730"),_T("017787AB0E4AD17C47D14721F54D5971"),_T("01A1F107D32BCAD79BB1214426FA22D8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0731"),_T("010D35A572945A6446414647ACDE17DF"),_T("013C8FC492A94D57518D5A6F4334BA05"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0732-0733"),_T("0131752C78490CCEF74111CFCC6DB4C7"),_T("015EB9DC9CBA819105338EE47BB9EFD6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0734"),_T("016008E06C048D93C910F8BEF91EF52B"),_T("0189A268B377E7AAA01A50D60463C6EE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0735"),_T("01206338DD44330548732C39C9898CB9"),_T("017ED526927F046AB92EEBAC17992610"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0736"),_T("01818E92F0073502F31D955D37E59D8E"),_T("0196F98AD9CB86564728563FC852D224"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0737-0738"),_T("0141106A1E34C06A8380D76407F372D1"),_T("01A8170DE4B3744E99F652BAF9619BD4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0739-0740"),_T("01740D301664CC994E2774767C6CC8BA"),_T("01C5C3949889B3CC407EEF13097624E0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0741"),_T("01D77879D457F2AC7CE9764A5EABF214"),_T("01FFE2AA1D8016FBFC7567FAD3422E88"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0742"),_T("0154631648919D9452C7DDD081D65951"),_T("01FAD332C48948D9D5F2F60EA3F72346"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0743-0744"),_T("016E4A931CE4379D90486BB66C817C15"),_T("01B2EF3F66BA798CF28E7118704285D8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0745"),_T("0165C1C102FBCA737CD716E4C74F5F67"),_T("01F7DF156ED778A5B7B9DF1D76B260B3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0746"),_T("010505557AB62F0F334BAD93FB293C67"),_T("01D7D2943230E0A362F28BB7D5043970"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0747"),_T("0134A989953EE55331EEA4B4C88C1561"),_T("016FA522EFE695EC8D2B20F5406A42AE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0748"),_T("012C70106E9761CB2E4312F05D4F2327"),_T("013421859AF35CB606A5893F8CF5CB79"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0749"),_T("01B17B4F3DE2FE7251021BCD49927983"),_T("01C75766F98D2588DE309F55B5AD027F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0750"),_T("0151BC4E6B5B7EA9383ABF9771D0E92F"),_T("0173793CB90A12F80B5A9B80F1225E82"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0751"),_T("01B162F68E01A9A6EC7EC41718BC0334"),_T("01C3291FC9ECA84F53EC6DC60CFA120F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0752-0753"),_T("01412E8689908AC0E032CB0DC91B6F98"),_T("01F2EA617A2830FD0DF622A0E5B4E8B5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0754"),_T("01E13ADF486BC5299E981CBB75DF9574"),_T("01F6DDAD42951DD69C8226FDEFCC86AB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0755"),_T("012A1EE3560CFC313F7C5D69E076BF72"),_T("013F7C8964CD3311BDA99091421C2891"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0756-0758"),_T("010CC33C83738B5BE1816E06A1B0FB79"),_T("01728A7E3A3E47F0D19A2E84D52B40CB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0759-0760"),_T("0181345A53E4630DBECDDCDEBF8A92EB"),_T("01C6F728BA0618067E7CB7B9085076B9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0761"),_T("011E0EEB08CE87632FB21DBB368AF7C5"),_T("0155E29B6B1B65DF62F287769B080931"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0762"),_T("0116A748C26B59FA71A99BFD2FAA79EF"),_T("01172C6CE09A4259ED382FFD81A4A11E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0763"),_T("01B4A7A245551276F6519788823E2D60"),_T("01C5790C084B60EA44FCB4AC30219DE2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0764"),_T("015E6B9E0BC59FFCE339C28E2832299D"),_T("017A3E8BF45A6D4CD135CA7A8938819F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0765-0766"),_T("010F9B8A1133847B8CEB1A79257CEF9D"),_T("0162DDF780B1C003D8880718FA48DB65"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0767-0768 (High)"),_T("0114CE573067A530B2672439300A277B"),_T("01262585BD65203A8835AF165D372114"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0769"),_T("0129E09178207BE8FE53C58F9D6F7E56"),_T("01E01CC2DCDFFC31C0EF530FD447EEF4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0770"),_T("01D2E279C32DD15835EC16E2F3D3B0FB"),_T("01D80B17931E38658364310BD16F8BFA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0771"),_T("0143053BDE5FE1EF59EACEEDC1024A96"),_T("01DDE10D1E165421147E3B9137B15516"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0772"),_T("01188EAC9079CE45BA48409E5D0DC617"),_T("01D3D9F44C41E759AEA2E43BEB180FB8"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0773"),_T("0140F64413ED8154715044EFFA4C6DBC"),_T("01CE1750DECF954F386D907BEEE8A084"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0774"),_T("0147F5708EB9017D13A442BB46F75E77"),_T("015DD487C40FAC0BBBE57DC1C32602BA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0775-0776"),_T("01556C85BAD1C7ECAF21965C9EF39CD1"),_T("01AA8404ECEA9EBB446977EE9E308261"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0777"),_T("014940406434BA7B331A890F17E5A4E4"),_T("0190EDE593AAE35F2BB4DB0B502B3A29"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0778"),_T("015D8C258F267F4FFB925A1BA05140D3"),_T("0166C31FE604DCCAF3D8516BBC6D6BF0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0779"),_T("010494BCA62C248ED17298891C5B8FB3"),_T("0111AD6C0B52D5EA87C854C6B95A0E78"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0780-0781"),_T("01236434B32DE2735236C07E2129C50A"),_T("01A1F1281B2849D0BEFA12FEDD813F2D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0782"),_T("01EA5C943C3AB6EA9E1DC2AF7C352A8B"),_T("01F8AE977EE16043673AFEDA1F040DD7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0783"),_T("016A712A246EA22F747C859C41EC9FF8"),_T("01AC5276059C21D3C8444FC965885DA9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0784"),_T("01175ECFD976F119F93651FB69518BF9"),_T("016DF4BADEC1F1987780BC7A97F9F9F5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0785-0786"),_T("01108E81657F5FDDFE07806F26D8C9C8"),_T("01AE1C3A9DF92782A37F536B8FAEAA73"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0787"),_T("0101668016F68201E1DE902B7B3BD405"),_T("017C85A24795A05A2D425BE9067F3A00"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0788"),_T("011EE79632F3450F748B960C5C0FD35E"),_T("01D5E807FD481CD4F36602BDD73E2324"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0789"),_T("017FDC063B80AD6B76AF635FB23C4AEB"),_T("01F4591ACCE7C655F7EBB222BB35CC69"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0790"),_T("019F0C3919379CA2A9964B9DC0335110"),_T("01FFF828D20AC20FBC46EDDBF6936EBF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0791-0792"),_T("01303A83ACA1D50A22EEF083FDDC1273"),_T("019FCD20A1B623236C7917F3C322A000"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0793-0795"),_T("015DD2631DD75A3AFAD94A72003DCFA7"),_T("01CED8758CB2471DB965A29A872A3E16"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0796-0798"),_T("017975CE66AC80239C28B5632F819EBA"),_T("01F1467C227A678A990547B58196DF5A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0799"),_T("01A35F7D4A3B8775ECC4D1F486596DD4"),_T("01D095BEA29226BF600C6A51E99E010B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0800"),_T("017B0C62BD790E165D6EB9F56DB10744"),_T("01D4860F7B7EFBB4A11C50883E5CCDC3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0801"),_T("01B06F3B1E8A89F18F67ACFFB5E5E35A"),_T("01C490A27EED0BB557CD91A099D5C3CF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0802-0804"),_T("01494FE7130F7036E5D8B269B054E7D5"),_T("0197A3DA88F11D33F5088D40266DE48E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0805"),_T("013DED50ECAF324351680E680845F9E6"),_T("018E7EFB95EB0916122B1D3FF6C89439"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0806-0807"),_T("01A2DB43DDC2ED6652939254D7509F87"),_T("01B3284A595854CC24387CB570612183"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0808"),_T("01A6AE04333E98EC67A2B90FCC0F9A63"),_T("01BC4197B84B745BB832C82C583529F4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0809"),_T("01D2AE72BAA1964FC202C90413A3174C"),_T("01E93D154CD964675A0291F4F06802E7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0810"),_T("013D6DBD55EC9139611AA94FB22DEB87"),_T("01C4E7DE76032D0739E6EB92BFACAF6B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0811-0813"),_T("01A6ED22E09B0C61E0E894677782A239"),_T("01C83B9A79A2D4AA5DF605154502229B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0814"),_T("010590710A3F937EB8251BCE9037F8AB"),_T("012C9982B9ACBEA744752FD914C747E9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0815"),_T("01A75EC893B771D1BF06D639521C6E75"),_T("01F08859E484A8F53DABB093CF402F13"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0816"),_T("0102089A411F9831A81443CF562AE24F"),_T("010A52696752917FD55A62CCA9F2058B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0817"),_T("01282D9DB4C3B247FF24A74235006856"),_T("013B7EBD5151E2B6DCCEEF706A75BD08"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0818"),_T("011EAFD32BC3364849CC84F731276A52"),_T("017DD830BB02481BFF8637E8A819369C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0819"),_T("01A7D8F5C012A126E71976DFA6A69E6E"),_T("01FF8CF4DA3465E35A0CC6A5D7BA32D4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0820"),_T("01244F193E8F5F3AB7F387838D34BFAF"),_T("0148301FE7106E0F911CDD856ED99AA9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0821"),_T("0124D625856B9A359557F200C36C20F0"),_T("01A272D8217E7D598E465A181BE43734"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0822-0824"),_T("011706BAD6FC19A0F82C2DB0A76B9159"),_T("0166661BCE268A3178BFA5236FEF46F4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0825"),_T("01357CD849370F4A172BD943451FE6B4"),_T("01E09C16F2846C46555213A7AB078A89"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0826"),_T("011A9829DD6E60F8BE182A4882EAF93E"),_T("01D64FD999BF5167B5CB3A096CAF4FC3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0827-0829"),_T("0162041423D36713D42A487912D6A225"),_T("0193365A1BC7AD1982C4F78F826FB382"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0830-0832"),_T("01296B6B24C38AFE7DCDDF9A12522B26"),_T("0158B7297BFC62B638C3224453BCD0E2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0833-0834"),_T("01269870C93BA30F725724603796F8FE"),_T("017666F1CB6BA0A85EEA665BC022D0AE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0835"),_T("014E86D6BD4286FEE473EC57587367F2"),_T("01D6A399C2605C19C14CB55BE64408D0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0836"),_T("0140196F2394032EFE2FBA1AED7D0FC9"),_T("017816277EABE53FCD6A910E6518F7F5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0837"),_T("01882E8022338D9D7EAF94E75B19EA8C"),_T("01B75181D1C02E9F3612094C00A0332B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0838-0839"),_T("01764C27E26D66AE8655F92AA4315343"),_T("01A904FD8D4B558341C396714729CBAA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0840"),_T("01067F36BCC213919EF14EE4512A9168"),_T("01F2F7DE16E0EEEC8BC9E52790994976"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0841"),_T("016FCE873589B972B238EAC7220189AB"),_T("018F8BEC8170A0C9B0AE7E1CA506E8CA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0842"),_T("01708D99409B901485052582D9D25FB1"),_T("01DF1EB7BFDEAA245BC4703876AE4AA5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0843"),_T("017B83D10654AC54A91EC88CCDBB1F3A"),_T("01E4697D5F927E28531335C748BDBC56"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0844"),_T("01362ECE09C2145375024C3401B038E5"),_T("01445193C5622F1538DCE90617F4A281"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0845"),_T("01D18103D4A56B2FF588FF7622CACBB4"),_T("01F75814A4F7BDD1DFF9AAC1B8B08995"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0846-0849"),_T("010A1DBA635B790F53C6FC0BB82D22B8"),_T("01F812F4416ACC7CA376817D3D214573"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0850"),_T("0104B096E5766291BB33A43D3D84818B"),_T("018074541C8331661660C2B91C3B0485"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0851-0852"),_T("013D1B431D2B129506124324FC27843F"),_T("01D31512C2C1FB60074B7D9471B7B5DD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0853"),_T("015815FBF233497A852248AECC2AD894"),_T("01798BE292A44D1B825CBC07A1A92998"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0854"),_T("0162688EDC2692044347B4C2D042D932"),_T("0177FADE315CE89A775CD1AB71F48D1F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0855-0856"),_T("013E5D266F98E0E4BA51DEEB63949B4C"),_T("01935D9820EE9DF4858BDDEC7A36F27A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0857"),_T("01002542B0D746E9574F530CB7A01879"),_T("015240A57D2EA2D411CFA2609493FF7F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0858"),_T("019F9FF19A8808B484AAEC973EC632F5"),_T("01DE9CBE6384981AB6F497009BA343FD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0859-0860"),_T("0160843783D38DA64A32A35C10E95F8E"),_T("019A4883A109C97A8A91C53564D294CE"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0861-0863"),_T("01BECD23BB2BA6B32AAF7D02FD3AD9D6"),_T("01DAD10C5CACA29498C2A3496900F0D2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0864"),_T("011FAE984D4239F67E3197A56E6E8B1F"),_T("015BEA542F03A7DEBD40C6C83B835CD0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0865"),_T("010EC5DF81A47D7B35E364DB0286B38D"),_T("014C231A3F4D8ED66189A008D6BE59AC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0866"),_T("0181644723CC0B619C843E94F9DF3FB1"),_T("0186CF4D27D784DCBC9149FA45EA51EF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0867"),_T("0103C35DB787348230A5FA7F97887BA6"),_T("0131AEA501B09E8749B0F68991EF4538"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0868"),_T("018B7FBC04AA06CE3B87746A5B55064F"),_T("01E25A56685F14707F600B7AFCC408A3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0869"),_T("010FC500A34E29F8D4F20F849D24167D"),_T("01C94752FA9E07B9CACF5C1BDB701CD3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0870"),_T("014F4D5995A52BAD57003BC299E453F7"),_T("01FD443C54431C10C23F2479127E9609"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0871-0872"),_T("01318BE3C32ABEC748B143223E421F71"),_T("015683460D89CF3616DFE135A3AECC92"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0873-0875"),_T("019E0432CAFC6F51A86A80B85868846E"),_T("01C88F78E035E50AC5454EFD84354580"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0876-0877"),_T("0140AA346D76225BAC4320B2E4A6883D"),_T("01E29D9F775424374223E006EA7B73BF"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0878-0880"),_T("0145300F9C6A04E10EE27C6B45A9746F"),_T("01CED08B797A882E66ED900C302C3F22"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0881-0886"),_T("01C9D74F9D2AC23742FFB0DDF28DD890"),_T("01F5760662EABE073CDBD655E81D5CF5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0887"),_T("01592F6CF2E6D2CEB5B023ED7B3DB768"),_T("01E6AE16DF74E071B44CB5E6135A3875"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0888-0890"),_T("016FA758A5FD41BA9757D26600661FDD"),_T("01FFFBD71EEEC84292194F59C1AE8C35"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0891-0893"),_T("0182506132D5C42D898911DE2FC8E20E"),_T("01F7AA219DF03B306462A9742C13E7CA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0894"),_T("0153E38C981DE75EF937FF0A5E4D3E35"),_T("01FC66A3E0467C4A8EC59BF968D2F133"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0895"),_T("0137BE74FDA5DF7CC4268BD46A70FC4E"),_T("01DD84F796ED019DEED72FAA460B62B4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0896"),_T("0196C918EE5DAA4CB4CEDE3FC36EA29F"),_T("019829A61BF6891AF3496006CB7A9227"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0897-0898"),_T("014241152DABD4B60ABC5816CEE1417E"),_T("019E9B714DC34B87388054423FEC8167"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0899"),_T("0171ABA63ABCB22DD39052088B9B0E14"),_T("01D85FCEFFBA040249D0FD61210C252C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0900-0901"),_T("012FD7E7C0496E485D16796E87322A12"),_T("019FDD88B2761291AE473B23072748E7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0902"),_T("0138872865D1A708920CE687813953F2"),_T("0139D006CBBA38F7F9CE8AEA103C095D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0903"),_T("01DF111C519CC6ABF27C30574B3405BD"),_T("01E055E3FFD73824E68FF94AFD9470AB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0904-0905"),_T("017FD330B167DFB68140C5FB5C9568AD"),_T("019007F0F583B54FB0E344BD7CB23E6C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0906"),_T("01A202BC3BDA93D933E3094438696126"),_T("01FAA64089CD85A14E3D9F65CB7D950D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0907-0908"),_T("01C274A79362E9D34711FC55D55E432A"),_T("01C2DDB7BB8068B253FE087C9B6DA9F1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0909-0910"),_T("019C6EA04C3648025A7C6421D38391AD"),_T("01A093402E7C86841FF0976DE9747406"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0911-0914"),_T("01055F01B835B9E22A70C00F4506CC1E"),_T("01F04D7E62919092320B205F5FC1CDEA"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0915-0917"),_T("01519C01EF10AB5923C7DEF7CF451AD1"),_T("0178A29EDD3726918889CB57C86BEC60"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0918-0920"),_T("01903AE5E5B23C9A5AA94CEF21515929"),_T("01D745557D2D8E39A360BA6991107154"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0921-0922"),_T("0140475FCF05578FC1534AE1012A3E6C"),_T("0146DF88F666D7A82A0C6993869E5D19"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0923-0924"),_T("015816A392487668D55F25DDBDA7C372"),_T("017999550C7E510079EA2F7385D40A68"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0925-0926"),_T("019B6B0E53931422A906687B7022A0CE"),_T("019C316BC6926ADA711EB8BC46071961"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0927"),_T("01698ECEA56E44E858B5001C65223773"),_T("016EFCBDBE78119FBABB3400F579BBEB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0928"),_T("01581755543FD36EBDB20BBC01BC6631"),_T("01E7D74B14934BC43D3B8DD34618B277"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0929"),_T("010C0CD447B7CBF6965F9170562F20F6"),_T("01F71E70719574F7F55CDCCFAB64B0F9"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0930"),_T("013B6D40EE1AB3DA18D6E6610C858DAD"),_T("01D89B879D7407DCCD764666375A9BC4"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0931"),_T("011C5DE8171A9695B0520737183C0764"),_T("014836903D604574382F05B733ECC80D"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0932-0933"),_T("013AFDEC9FCE9811633541BB297D6A31"),_T("01A6507F4D6EA152B6D6D15DEA8438E7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0934-0936"),_T("01C78FEF1A1B50D8078AA7ECE43CA83F"),_T("01CE1A263791F67AFA794CD7C9CC2D7B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0937-0938"),_T("01183D63F171792FE6CE4CDADA65B869"),_T("01AFCBFFDAB1A380DE71C6A0BED9F5D2"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0939"),_T("01285979F5130214FEF7EA318B17BE50"),_T("01828B0DFD8C4EB651271D2476EA41E1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0940"),_T("0164A85D3DD37F489487BB34EA3C971F"),_T("0175EE5CAA89C22F49971415D2628DFC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0941-0943"),_T("011C6E8D2A68E4026F432C1FDBD5AD86"),_T("01418786671986A64A643046489E8A14"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0944-0946"),_T("017CBE1D96DC15F458694A6CC1DAB180"),_T("01B7AA5E0A74E22F6A5C58A339B211D1"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0947-0948"),_T("0161AC18EADB56CABBC756804A4A9941"),_T("0187694299147CD57FEBF35D7FFE260F"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0949-0951"),_T("0141327E255C3A13433042918367AA9C"),_T("01EA8B13B98E14EC4215FEDE05C44727"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0952-0954"),_T("01D3986A649C4593CF9A19B4D8E3EA4A"),_T("01F356138F798D2FA9AC84B3DFD26C92"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0955"),_T("0145CCFB3CFD657AA47D68857C73808B"),_T("0187CDB41EB378C587B76E9CD566D8C0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0956-0957"),_T("012F07144A72589BEF23F77C2919D01C"),_T("014F11F503B94F47BCC76381C94217A6"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0958"),_T("01858F2371E6FD5D2B022A862C9403CD"),_T("01C7E4C843A994F4D1E403D1DC069301"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0959-0961"),_T("012154F06AD8C10650176D38CA037FF0"),_T("01EA79B38EDD5146D5F476914A8E71BD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0962"),_T("01155074C742DE05033EE1BA458A9425"),_T("015B548A7412D0EE0ADAB5E2DCE23EFD"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0963-0967"),_T("011CFBFE38980EECFF0A34C6388CE105"),_T("0163ADF771C4E12D63D3C9788E2FDBE3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0968-0970"),_T("0105906605B0B1F3486C3C8CF3D57D6B"),_T("01D6B0B146317ED757EC77F7DB2BFF28"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0971"),_T("013691ABD953028C3F53D6804CC70AE9"),_T("0150B09A0E3882C6F8A5E1AAF5E03B0B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0972-0973"),_T("0125417F733714AD6039B7B11F310C6B"),_T("016B64AD420E45930EB2675A84E11185"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0974"),_T("0146A06271D0F045EBB5F9FBDB2CA380"),_T("0199BD0C5E50BEB3391B3BA83E20460C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0975-0977"),_T("011530FE3D2596A1DBF9B21DC0C768BB"),_T("01F398CC38FFA11AE6A27DA61479D2DB"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0978-0979"),_T("01030E4D425BF53637B25750A7D2EC3F"),_T("013753A38766C7184F81BE47535374A7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0980-0984"),_T("011434D104CFA9756DDB849B1C7CA6CA"),_T("01F237DB76339A845B8D23936B8161B3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0985-0987"),_T("0176EA31FD79529A42C9E966CBD37ECA"),_T("01B8CD4E7BA416EA9FABE965D9F0D53A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0988-0991"),_T("013A02A0143E2E6C70448EEBEE4AE013"),_T("0172EB3632373F14D4872D664B0356D0"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0992-0993"),_T("01409A21C0503864B6F3013D3F92DC02"),_T("01580E49C26E88C02076AD62914EC02A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0994-0996"),_T("0104A8440AFAEE765A1F31C7367B5D82"),_T("01A787B438945DA50535AC583C384183"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0997-0998"),_T("01828FAD99129D943E92AA8D2B2C72C1"),_T("01F1ABA1A836A48B95926B8850C6CDA7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("0999-1000"),_T("0188E600659A5FC4DA9DE8ED6300E542"),_T("01DDCF7F20D3F3D8FBFC7DC191980795"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1001-1002"),_T("017DA7EED6877ECE524C1B3C4986B048"),_T("01CF347986890DBA777C4C82C82910A3"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1003"),_T("0149FCF072B1E749E71ED0979D875CD8"),_T("014F7DCA1C9B2157092412A48B32A1A5"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1004"),_T("0113ABE207B0829CBBD35025982A7F66"),_T("0171F3D4D3B81286D4FD1B096E06998C"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1005-1006"),_T("01581FD78C224E87707122C4FEADBC07"),_T("01D6264DA2D1D946944131F4692C2874"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1007-1009"),_T("0109FB92C942C66AFC32B3687428C6D0"),_T("019BC9FACE95D1842B0CFCF9649D84DC"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1010-1013"),_T("012E357594FCD55C23DE9B211BC27C8B"),_T("0170F23CF35057B264F6163C0CC7743B"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1014-1016"),_T("0183D94237D2A1462CF8884A2C58566B"),_T("01D2027538B7350A8CE3D2F9769B1071"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1017"),_T("011763A76D06504E23FC3843EB35ED62"),_T("01FB54D501D5628BB7E7BDB128FD8A99"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1018-1020"),_T("0161F31183C82FA6B3675AEFCC73D858"),_T("01E90C213C988C624D42B2EFBFEA3CD7"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1021-1023"),_T("019D0859B90DD978F84DF3C7F8A725FC"),_T("01A5C5922845AA40ADB38740B5BB205A"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Apple Quicktime"),_T(""),_T("1024 (Best)"),_T("0137276AE93D501787EB606694966C4E"),_T("0137276AE93D501787EB606694966C4E"),_T(""),_T(""),_T("Apple Quicktime")},
{ ENUM_EDITOR_SW, _T("Corel Photopaint v8.0"),_T(""),_T("high (comp 12%)"),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T(""),_T(""),_T("Corel Photopaint v8.0")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("01"),_T("01371CDFD05D688A5EF29310462CEBFD"),_T("01F098E22EBE7D3E0D31DD1FE0B14FD6"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("02"),_T("01264E8FC69DB0D4E823310AC4A62F5B"),_T("01FAB2BA2D9A80FB421DC6981F422A94"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("03"),_T("01472DFFD69C61F0236252CEC3D93A59"),_T("01AA29A71CF32688CAA00C0345252BE3"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("04"),_T("01925341B1402B2B890C20539B2994B4"),_T("01A506A5268ADF6774AD1DD49F250957"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("05"),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("06"),_T("018F43694F4E9A49C24613CE0DB777A1"),_T("01BFD6DFF74A169EDA4F585691B1C832"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("07"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("08"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("09"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("Digital Photo Professional"),_T(""),_T("10"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T("Digital Photo Professional"),_T("Digital Photo Professional")},
{ ENUM_EDITOR_SW, _T("FixFoto"),_T(""),_T("fine"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T(""),_T(""),_T("FixFoto")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("001"),_T("017B7355162223C173A4E4C88F05C9DA"),_T("018EAAFCAA0AB2E88D21C57EB8C43B91"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("001 Baseline"),_T("015E8EF249156A7517F33D04EC88B72D"),_T("015E8EF249156A7517F33D04EC88B72D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("001 Baseline Gray"),_T("01297F26422C08EAC152895BC06C7499"),_T("01297F26422C08EAC152895BC06C7499"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("001 Gray"),_T("0163D6CB88C86210E76F0E31048B0BF6"),_T("01A6E4ED4705E839FA28074138B05070"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("002"),_T("014DD72F134192F5A8218CD57E7E92F7"),_T("01530695A44D097615A909810255552D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("002 Baseline"),_T("015F7A9618EB2A868C7550DA1329990A"),_T("019EAF74910A2D5AC97092B7AF4836DC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("002 Baseline Gray"),_T("01486C07E83005735F04D0A4A27068E8"),_T("01C14F2467E51D7674E2DD062263F7BB"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("002 Gray"),_T("012598FEF5AFB0C3E676833AF10CCCA9"),_T("01C5DF373FF773BDAFEE6185D00369C9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("003"),_T("010D93534ECBE41A03AD908F7C2F65D0"),_T("01225387EEF2A87E35871B03DD67611E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("003 Baseline"),_T("014180871C124E13E1D1ECC15766B3AD"),_T("01B78E9757D16F4C222B8FCDB3E0009B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("003 Baseline Gray"),_T("01A263063939FF920070C72232265CEE"),_T("01D1D80702D2418283DB0B64B688F06C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("003 Gray"),_T("01179B1DF96EE5FE56253A215543EC1E"),_T("01BAF3E5B99E4B484E5BA182B172D98B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("004"),_T("01E8961863E6A06BD0F830F728EA4280"),_T("01F7A160536DC08D336A2F1631F7F3DC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("004 Baseline"),_T("01A97DA12E54D66FBFBCAE0D5E991CA7"),_T("01B75FA66F48AA9134AEB973912F5002"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("004 Baseline Gray"),_T("01351162C4FB4ABBC45E7C31F97176ED"),_T("018BEC3F23835B6B6E1CE317E248E55F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("004 Gray"),_T("011236A3C64BA1BA9F5FFB1C8AD211E7"),_T("01DF43FC1624F3D0509022EE7B4D153D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("005"),_T("0148D4A3A57AA9F4CCC1A1ABE2B3EBD3"),_T("019F85C1F6EA55C6C11B0816CEEE394E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("005 Baseline"),_T("015D763BE94566375ED64FA6BBC90CBC"),_T("01E9BD6C6EA39F1EC280CCAB84E9F838"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("005 Baseline Gray"),_T("0127C219A56CD59294E419F50B3CD5A4"),_T("01B7927F22D541B45898138DCCBCB8BF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("005 Gray"),_T("014403414AAC4820C77EF45FF0983FA1"),_T("01DD93A182BEE09075A38D13E48CEEB5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("006"),_T("01557CBD43FA30C074C5F867B271E4FF"),_T("01C74923F623DA3353728D4F65A65560"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("006 Baseline"),_T("0178C88CE971F4895B97F162B6F4D9EB"),_T("01E5D4A5B704442CFB9AB125C61B8380"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("006 Baseline Gray"),_T("013452C3086DA41E7287EFA1BFA8B2AB"),_T("016D6A0A694A62C56E5743868BB0D41E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("006 Gray"),_T("0114BECC99AF2EFEB4E15210F5371B75"),_T("019844D405FFF1D861D36BEB52217DE2"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("007"),_T("01B8C90AD9A893E6C04A131099DFACA7"),_T("01D85E50FA0EE5AD5E0DC4E56D3B433D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("007 Baseline"),_T("0164AE108050FA4F61234DC514D83948"),_T("017D8F5DD41BE2AF4D193065A10D9C8B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("007 Baseline Gray"),_T("01012B878EF734B659BA1CFFC2B5D2E1"),_T("01501DCF3CBA9EB2E717BEDDE3219788"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("007 Gray"),_T("015A4FEE9D68729E5C58D9026790CD83"),_T("01EC84DC35C178247C3E04B54D808ED9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("008"),_T("01D8CA571F91B40B212432DF0B1293AA"),_T("01FD4538ACD2D3959E31924320F447A3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("008 Baseline"),_T("01B366D312409D49FBD66A7271A7880E"),_T("01ED8C761580D6160951141E756C4373"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("008 Baseline Gray"),_T("010BD1B6B651D091E4611F312F853D55"),_T("01E0F07D87CFF3B690BB7BD4BFD3F0D5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("008 Gray"),_T("010E8D52A10CA78D233C33E2B2CB2511"),_T("01D0F02822F32FFE1F21A1A5CA33CBBC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("009"),_T("0165A32069B4C1CE7B097FE2261689E2"),_T("01CB76360C6CCD24100452C09CEEB761"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("009 Baseline"),_T("010A73E1E045C32AD1C406E7EB3EBF09"),_T("01804FAAD1B26D898E85F75DF30C2F22"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("009 Baseline Gray"),_T("01735AE9B21723B1A0B1086693F921F4"),_T("0193567FAD350593014BE7683825EFFC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("009 Gray"),_T("01376345AA246B6B1E13EAE20EAE4CA5"),_T("016CDF096CA0416A303787481AFA38A1"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("010"),_T("01A1BA2ACAA09A184A268313A90E5EB4"),_T("01D0E8A480D3D5EE22490A21A32F430B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("010 Baseline"),_T("0196F2BCA047EAD712F1E724146172C2"),_T("0199D6A2E65FCBEB7FC729FFBD7733F1"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("010 Baseline Gray"),_T("016431D22F1312535059CE905D3B7D36"),_T("01D9554FEA5607D2524F36810B49C6E3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("010 Gray"),_T("014C3AFFE67BA40C08BE705C298DD947"),_T("016800F71365CD51678A09C7D22020AD"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("011"),_T("0104DD1B8565682F6243C8B6B495538E"),_T("0113AA4194BAED61D2EBFD5D249A7C3B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("011 Baseline"),_T("0136A16196FF2A6919912E549E28DB1F"),_T("01B321156125107374C0494726A4E615"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("011 Baseline Gray"),_T("010D74B305577D4C0EF9A4FA81208E2A"),_T("019ABE12869B59CCBF0D08884F809733"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("011 Gray"),_T("013EDCA35DC95867FAEF6504D946AB88"),_T("0173CA54240C852D2162D2D60C70BD1E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("012"),_T("010141597D7D13E15FAFCBE3655018CA"),_T("01A1ACA48E2530DA49D13E6A1A00D351"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("012 Baseline"),_T("019F0B1DA2B01FF4A8215F8BAAB61652"),_T("01DB6989B11A4E8962133E089391A871"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("012 Baseline Gray"),_T("013BE7534F6F10E0DB3569A5DCAC59D1"),_T("0195CA1CAA708E6D5202211255BBAA7C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("012 Gray"),_T("018F446D264CD997BAF04D04B05A91B9"),_T("018F616CE930D4500CB63FFD1E2F97EF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("013"),_T("0108C12043C674298E68F922A4F9D8E3"),_T("01F32CCDBCF6D70A6F162E68B71B9292"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("013 Baseline"),_T("01FAFD5D6C3FF57FEC50542A8049FFBE"),_T("01FB327F2708133773A7C1C2ADF015C8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("013 Baseline Gray"),_T("01A9A53936E293CAA737CAF361CA4EB1"),_T("01C5522783D57656739934F7FAD62AFF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("013 Gray"),_T("010064FC378FCADA298C6E19AE772386"),_T("01F924075E607C892E5ED487B66C33C5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("014"),_T("01B8FF4C5FB2480CC2FA203338B3FB49"),_T("01F2515A4D47E94F00444E125569ADEC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("014 Baseline"),_T("0111ED3FE874F467004F42442A4D5EC1"),_T("01D0B329A0D3E31ED35C294BDBED9B6F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("014 Baseline Gray"),_T("01DE5FE34EADFA8BDA32D377565E1141"),_T("01EE3682E1D03DFFFB284257ABB9C199"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("014 Gray"),_T("01CA028CF12DA7C6A38D88F9E80D2B75"),_T("01F385384D8FBB00459FF944F49EF187"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("015"),_T("0105A3D95D2D36DE9351313E30D8E945"),_T("013C3A43642D2E8325A76C3818B3C324"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("015 Baseline"),_T("0137B43FA77C7778CA3ADF9EACBE244A"),_T("01DD0F98215EAF68D95CA29504642470"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("015 Baseline Gray"),_T("015F641253537182AB95B7377533CEC9"),_T("01782BAC6D4C5814864EA1E787F1DD17"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("015 Gray"),_T("014FAB780D8D2E126D37C285196C56C3"),_T("01B81286514AF4681D5269E7A69FB780"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("016"),_T("01382B45F768D75423502D2E8B4FA067"),_T("01809D564FFB50A4B041FA568A15C9E6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("016 Baseline"),_T("0120A091F04D17628FED6C97DEEB280A"),_T("0188331717200FC0BB9554D2A03CC9FE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("016 Baseline Gray"),_T("0113DF3F814D89D622254D755BAB04CF"),_T("01C825971AE124C75253EB75D5D58FB9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("016 Gray"),_T("016709ECACA8BFACE513721F290F23EF"),_T("0196AF8D3EAD94D6E97505361B1F1358"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("017"),_T("01DC148567DCB4285F93B78611674D07"),_T("01E94E7F685174FAD107E3ED5E42BE92"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("017 Baseline"),_T("01758F4E39DFACE5EA5D12F9E0B34014"),_T("01FB6608C70A5EE84888DC0BAFC6B5B5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("017 Baseline Gray"),_T("017391E08342C2EC22792EF337EF549D"),_T("0177E5CD64BA1F01B9E7CEB33B14CF35"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("017 Gray"),_T("010153C5A5FF4AF26A0091FA8B9678B0"),_T("01552F1E4906CECE8137F1BB9BA2D8B7"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("018"),_T("01057FAB300BDD64B97BA4568CB14B5D"),_T("015C51EA21C7499D0C90807ACE472F04"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("018 Baseline"),_T("012B46FBA4F602C5E2A9E53273F92CC2"),_T("01B34903143AE2C4148C20975CD59793"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("018 Baseline Gray"),_T("014B75D8C642D3B15BBAF66297C036A9"),_T("0162C12D22B2E3019AFB303E26DA4045"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("018 Gray"),_T("017FE7B01030048A75A0A5A3766C2398"),_T("01EF118D91165F6B8109179E315F2197"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("019"),_T("01F28319610130A4962D2F2471A47B44"),_T("01F9DE9286B554D02751D1F9BC1FABBF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("019 Baseline"),_T("01371CDFD05D688A5EF29310462CEBFD"),_T("01F098E22EBE7D3E0D31DD1FE0B14FD6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("019 Baseline Gray"),_T("011BF44C288ED88757E92D649BF545C6"),_T("01EE49101C014F8EAF5D98C5A39B6A7C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("019 Gray"),_T("0161AF5C8A6D83C8F6BEF3334AFA19FF"),_T("01DF20D95132EFD134BA9742BE28DD2D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("020"),_T("010D756CE419BC1DC5A66488DA103E59"),_T("018772B3B18E10C3B6A30048454AE64F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("020 Baseline"),_T("01992DA20A6C319816DB7D1B2930DE70"),_T("01C26E64C91D1F3AF498FC128F3DB745"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("020 Baseline Gray"),_T("0189AA319F67514100ABE60A7A217A0F"),_T("01DB8A3598F8CF5C597313B21AE58C40"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("020 Gray"),_T("0128762025414333A77880F582836FB9"),_T("019F14524F3D4172188A4F25CFBF7015"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("021"),_T("010B8F48DDFF29779D862905F7915174"),_T("01230BD3DB98C5BF6519D7E6F7814119"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("021 Baseline"),_T("01031013E022B4BDE27ACB2BA5506995"),_T("018C081C9DA097E46EE51742F0DCAE8F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("021 Baseline Gray"),_T("01257B6D36CBD8F417A2DE61BFB93FF8"),_T("01935FA65F1AA4AF2852C9166E38A46E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("021 Gray"),_T("015A99179502B880756AA0BEA60CC4AA"),_T("01B5750AD0FB01E2ED32BD82C1D81DA0"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("022"),_T("01DAFBF5D1DB29911AD6E3C28B177C52"),_T("01F26E0C642B9F63BF509154038FE4B4"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("022 Baseline"),_T("0156DA0F6CB05402768A8D3DD04ECC6C"),_T("0163FB39B3ABD9B660E34373AB7D493C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("022 Baseline Gray"),_T("011FFEB512FB1C5FEC87B20A0393C51B"),_T("0174462842394EBE92A30BF2C0218121"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("022 Gray"),_T("0144B39F0745FE14081460A17C9F0EDD"),_T("01790532CABF49AD76891FFD62356BC1"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("023"),_T("0127817626115968C5209E0DE893658C"),_T("018A1898AFD039F134389BD9C3BD1207"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("023 Baseline"),_T("01E54E7B9935A1823BD7813756967A82"),_T("01FDE410993C16AC3DD3215B90356FBB"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("023 Baseline Gray"),_T("017847DED0D72816ED793C0653399846"),_T("01F861D1354732586D40BC1FD35DD41E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("023 Gray"),_T("014822C68A0E484A993E17FCF585C83C"),_T("01B42FC018510E940575716D9F2CC132"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("024"),_T("01AD1431E7E7E855D5882888C08FEDCE"),_T("01DF495B594519EB683D744308BFCC3C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("024 Baseline Gray"),_T("0199F8E5AA2715706C5D86E6C063AED0"),_T("01AB425B0BB561E5D81F73461FCFD53C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("024 Gray"),_T("0199F8E5AA2715706C5D86E6C063AED0"),_T("01AB425B0BB561E5D81F73461FCFD53C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("025"),_T("01E1BDDF6C45DBEC46FC48B60BBF6018"),_T("01EA5E13EF082CE6D445C4AC8ED703A8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("025 Gray"),_T("010E9D90B70F67A74998A33E2617EFEA"),_T("017EFD436979334F7462F6D419A0409F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("026"),_T("0151A009EDF99BEB2F36F3144CAC3AA8"),_T("017CE6C1F0D1E4AD2C6A76454B0DC6D6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("026 Gray"),_T("01350FAC262F271A402061E7A92657A7"),_T("017C4553F75B9286974C886AEBC452CD"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("027"),_T("011AA95A067A44EFE4ED594A7A10A60D"),_T("01A4D8C74D429DFFA9E7E8CA28A5037D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("027 Gray"),_T("013E02157EB5DB737A047347048D690F"),_T("017A7F16CE910CD41DB40D254B8E3C00"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("028"),_T("019086A16FAAA8C9EB3BFAE9CC6F096C"),_T("01C66E4A63F60FBEE086C72C84BB3BAA"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("028 Gray"),_T("017766E2B681D23724D1C8D83AF21ED9"),_T("01EF36845FE887FDA32AE0CEFE9301E8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("029"),_T("019420068645B04E0AB5B600562E4D34"),_T("01D3E4499654186CEF7A4B146040D88F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("029 Gray"),_T("010EA6645EF02F7CD84388BDB49DD441"),_T("01812B12E4C29E5CE6CD24A08B080E82"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("030"),_T("0167A32FCC8F153A51B2AFF207149263"),_T("01C530B87D23AF05C825E5F17C117894"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("030 Gray"),_T("01B864B56117822F710C17F001F5F51E"),_T("01DA9F3B7A014E2E21DB6BD7F2400787"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("031"),_T("0120240537230FF485E6F7B275736D66"),_T("0168C32A593FFC45927D116D1D8C8D5A"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("031 Gray"),_T("01E7214A25C754357E0BA14BBEF0C3C5"),_T("01FF8A40330C94B23ABA5B8B776533CF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("032"),_T("0179A42A607F414795D1C0AA4F7812B1"),_T("01A7D58273508268F0027B337E9B9B45"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("032 Gray"),_T("0150F18D85D9427B5B10534D4C691403"),_T("01A1EF24C114372F78BEC3686E4DCE06"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("033"),_T("01305AB319A9D55BB8D687C882D81F4B"),_T("01F713F3A15722B9E150D9FDC208057C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("033 Gray"),_T("01790540992153EBB158E27DAECDE058"),_T("01D877F04A272A12FE8F5226CB015902"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("034"),_T("015246209B28B1C08EE92BF82AFD7252"),_T("01816E05E735E241697A1F2B1A8FF6FE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("034 Gray"),_T("019899F0FC9916880F066BC0BE7856D5"),_T("01DA91F2DFA45AA049601EFDD45D53B6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("035"),_T("0183F20270F106C2C089DDDFE2D6C626"),_T("01E3AB977A4827AE486B1D7E3940E953"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("035 Gray"),_T("011264D15B226B6331EA524A178CF762"),_T("0134EFE39D2DABDC6235B0CB9146EF57"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("036"),_T("01264E8FC69DB0D4E823310AC4A62F5B"),_T("01FAB2BA2D9A80FB421DC6981F422A94"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("036 Gray"),_T("012DF7E87095F3A4D07DBC92373D9B4F"),_T("01FC66F233B3BE25F29099CC55B0885E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("037"),_T("0121590D0BEDF72A4143EC952F460381"),_T("01E628E7BB9ABFE61671ADD29C40C494"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("037 Gray"),_T("015A3EBC8CE27C2263ACFE59FDEAA9FD"),_T("015F3D8E92A854F7DD672416B986181D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("038"),_T("0142CD8148CDCF1773B5033BC4F6DB7C"),_T("0175F083CDB8B43AC45869AD5F233302"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("038 Gray"),_T("014EBD5319703B5C799FF67F85369A24"),_T("015C41B94BA775521381E9A3DD1D0E67"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("039"),_T("01225CBD60ED2AD10620D8DF77E71FB0"),_T("013B9648B48BFF6B7B099F3FD651F248"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("039 Gray"),_T("016841AE563FF5A1202CA89697227C79"),_T("01D2BE9EDDEFF1E984B81E79E3FED82F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("040"),_T("012247F7591F152CB8F0A9859A5CAE7B"),_T("01E9C459D99D5A7EB868FD7782AEE67D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("040 Gray"),_T("0120CDD2204490080A40263C61858CB3"),_T("016C2734A1E5D1B70EF40A6C3188BE69"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("041"),_T("0127C46FF50D958B8B384E6F0AD2E8A8"),_T("01B7CECFBDFB72C303882D2CAFC59A74"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("041 Gray"),_T("0113B0EF4E7461BB505737FC88B5D0BD"),_T("012388C889FE36A02B05F47E5AA2A6A5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("042"),_T("0129E22447C9DAF1C399DD56A361ED12"),_T("018F8CD5A5C334B58F55752E4E490831"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("042 Gray"),_T("0157890A2FEAAC8D8C821656B843D3BD"),_T("01DE4AFC5FA19B360DF6CD75CA6F2630"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("043"),_T("010B2A78965C750E17CD6AFC82E4C383"),_T("0121DE7AB63C9FB70AD06BFE55115CC0"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("043 Gray"),_T("0168C82969D81B945688F0F3C440C12A"),_T("01DE38198CCB700A64CD2856AE6F6E95"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("044"),_T("0123A1A8835A75EE1DE4DDDB26B19F17"),_T("01D587857C3B50B1C030DD163E85021B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("044 Gray"),_T("010B836AADC68BAE29CA32563548136E"),_T("0180F16550B7AEEE50ED1E9F3B979BDC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("045"),_T("0186F9C1D60513E78DA10AB8A11EBF2F"),_T("01EAA96641C0139DBE4744ACFB0635C9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("045 Gray"),_T("01E8A97442C3AB91BE7A459F832B1542"),_T("01F1F92020C2A577FED4E54284E9F4D3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("046"),_T("0179F3FF136D4ED422E37B67FD7540C0"),_T("01E59C1A56C91BC1B050D764A2503A6A"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("046 Gray"),_T("014BDF62789FCD30F49D651762C762C3"),_T("01EDF4068076CF390F5E992CF8D7671B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("047"),_T("01C2C5F19300276881675802CA117AFF"),_T("01DE888ABC6D1237F227292F3C2CA6AF"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("047 Gray"),_T("0133957C29272CBD22C122D57BFCFAF4"),_T("0162031166211D6FD11E0E0459196DBE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("048"),_T("01AE707BB10E5B75C6C1C72950710BC2"),_T("01FBCE244CA094EF3E713642A284AE75"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("048 Gray"),_T("01DE8416C14C4A77B0775116285A5FD0"),_T("01F9D08C289E2816F7948FA464F14D6E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("049"),_T("019D38AE2A0593E6CA1796D340F9C8C4"),_T("019D75AD2E9F9F3E32AFC268217DD894"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("049 Gray"),_T("01B3F9CB307D6EA42C70BA3F1A1A3980"),_T("01F1B3CA3A9317E0BF83E26BC15EFE6D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("050"),_T("0133FC69E52E74319F110B4486B8B0D8"),_T("017FEB124293E03634B25E85B537A2E9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("050 Gray"),_T("01D721791D863035D28A72BCB3992FAD"),_T("01F2F9B33C8A515088AB4F8A57BD09F2"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("051"),_T("01472DFFD69C61F0236252CEC3D93A59"),_T("01AA29A71CF32688CAA00C0345252BE3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("051 Gray"),_T("0152A96E81A2E16D04079E533F08CA43"),_T("01EEF4B339A3CE53F9006963F1F88998"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("052"),_T("01BB95128BBB51E2CDB18EE3464EB78A"),_T("01C77ED677A7444C7303760B540151A3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("052 Gray"),_T("01C3D3D11D66BA55032A2889E25E6D3D"),_T("01C9A767730799D049B2C57B960C115E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("053"),_T("011D227275F2AC493D1A6A1492BB77C0"),_T("01ED7F994B85E53AF98F2BC8A1D76759"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("053 Gray"),_T("0157AED65A17EE6DFA6F71DF01F4B464"),_T("01C74D9D2760A28FADB0C8E62D8D6458"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("054"),_T("01621500A3E854663655E2A69AB304A1"),_T("01C937495DA1BD772ACC0DA4E9E2DECC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("054 Gray"),_T("0165074F1C9E973ADE6C604727FAA835"),_T("01DAB04F1D318845D3C7E5B40F90870C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("055"),_T("01B740329A84086970A6293DC09A8FCC"),_T("01C32360C87E4BDE82548DE301DEA159"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("055 Gray"),_T("010615CF2AA5E0D93B8D36C96DB4642F"),_T("01261D04EA4EA8D29F63053627ADAC54"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("056"),_T("0137761655C50D80F4162817A18A3920"),_T("015047A760AA50A563D0ECFAC4386056"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("056 Gray"),_T("01116F0DFF19B83CB7A5F3247636284F"),_T("0126F525F78C06384CF5250CEA75639F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("057"),_T("0116C72F9570BAC3A7EBA653C02444AC"),_T("015CBFF3B2FDEBE2602CB83EFC2688DC"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("057 Gray"),_T("013B67ABCAF2C9F654181EDB1CA63717"),_T("013F9615D6C1C61EE57178F7DC50B0DB"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("058"),_T("016AB252DEC4F6934FE95D58A15F7DB7"),_T("01D1328F2F91E725469044B4063D1C4F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("058 Gray"),_T("019E75CAE868EF1C82E59DE7533922A2"),_T("01F8470BFA03E0E546FA08E72CFFF65C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("059"),_T("01BEBCC9A81E85194989409335851B32"),_T("01C6EA1A6A3BB78C164A83168D921736"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("059 Gray"),_T("014EF48C7F135B7586EBC027F4B06478"),_T("01E6C2A5F8BA5B973206CA732E425EE8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("060"),_T("01195A026C32F022A48BC36FD0D4D64D"),_T("01F08A12F2ADAE77844686384A57586C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("060 Gray"),_T("015A51E4B01EE84E2841914511C8AC32"),_T("01DB43FAA6FA415E716878737358C331"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("061"),_T("0185CD228521305D8A3490CBF8A409B7"),_T("018C8552EF8C257A88F67B3C878F027A"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("061 Gray"),_T("018A4084F15493F2D2D86D4D372B3227"),_T("01BC3F21BE4C67B1793F135A8202D542"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("062"),_T("01C16479F816F0780B7B435C0A260E1B"),_T("01F8B58DB77D7D86532D621723DB8696"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("062 Gray"),_T("010889A479D668E1B0ADEC6718AD824B"),_T("012284AC8BBDFBB3E9DBC94C06947C32"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("063"),_T("0123A1DCFED52D07F5EC102A1DD65CC4"),_T("01E267EAC491A4E9E29D44F8A908273F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("063 Gray"),_T("01794D803B2513E44FC0880D80F5C6ED"),_T("01EC07C26593B71842880ECA0F97A4EA"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("064"),_T("01925341B1402B2B890C20539B2994B4"),_T("01A506A5268ADF6774AD1DD49F250957"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("064 Gray"),_T("0109EB325DDBC8BE92C9FEA5FC094F05"),_T("01A737652BBA7373792E10CDDFC1F37A"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("065"),_T("0139091A8EB09D2E5B08BF57DA89136A"),_T("01FD829AFC9398AA4692176577CC045B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("065 Gray"),_T("0163F622658A1D5A34EE2A0C0CC7E753"),_T("01DFA0762D896CC0D28EBFD72C4636C8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("066"),_T("010973B55CB8F35CEC6BE27E8A6114C3"),_T("011C1D7F8A70B35D705697AD7C3035FE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("066 Gray"),_T("0197BC85139932CD93236BF56D9600D3"),_T("01BB08DD8016C1A52BA05BCC1B70D418"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("067"),_T("0115B960DFCCAED914805028D6BE5B9E"),_T("01E46A79F6348351DC69F39906F79815"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("067 Gray"),_T("01322D28A106B1D69A67397D203DC2AB"),_T("015B7AADF7F79F1022ED982956F1A354"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("068"),_T("012BE1B445368E603FC22008BD93022A"),_T("01A5343F7E0036358F115437CDDF62AD"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("068 Gray"),_T("017FB581F809207921A8B4FC49053BC9"),_T("019D0460FCE1BE7CB21EDECDB459A189"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("069"),_T("019440CF19661C1F7828F27EB76A8DFA"),_T("01F80863A47C93BAE0AA573CA22BC24C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("069 Gray"),_T("010495CE0D8FB4A4C0A3F5C82D8EE71E"),_T("01AAE70F705BFA52EE947CBEBB9D4F3F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("070"),_T("012E11ED043029D57BEF07015C8706F5"),_T("01CB9E06BC0516835D9AD2264F9E2DB8"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("070 Gray"),_T("011D54A91F2767E204B3156EF7D939B9"),_T("01C3CAF8C48F2C9E84AF3750B68EF1FE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("071"),_T("011975EE86201F10E48E4F365C73A839"),_T("01B8FDD60747E53114DC15797CC09B4E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("071 Gray"),_T("017124153ECD2C1080FB1C81DE3E8966"),_T("01B85C5272CC4E0F18B4296963627C55"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("072"),_T("016A9F39EDF7E9DCAF8BE822C2266077"),_T("01F0A31D3842CFD4B7E09178F141E14B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("072 Gray"),_T("01040344A2DB072C102867283CB40094"),_T("01EBED1BEF3A14275D6F99C39E693140"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("073"),_T("017659A2F9A530359CB8725D32B5BE6C"),_T("01F863D3F47BE8F243BFF177EAC1EDB4"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("073 Gray"),_T("012A4FCCFBB2E5EB17ABF53CB8CE19D8"),_T("01C1F982D08F1A78A5165145F51496D2"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("074"),_T("01403088D08B8A2712CA648846151E07"),_T("01BABD681F45ABBA1BDCF41992781236"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("074 Gray"),_T("017B6F3C3060C8FBDC545D51B689926D"),_T("01FAA30172673DECEDD32E154151FEE3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("075"),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("075 Gray"),_T("019C6C4CB99521A5680C96B0EE999485"),_T("01C8ADEC252DAF2DD41A3F13A6B26952"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("076"),_T("01786593B7990A17B0D81B6DF749470E"),_T("01DF37EBC825495EA04E9B311B77D309"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("076 Gray"),_T("01DC3D7DB9ACC994536C4DB9946E9711"),_T("01DCCEE0F68DE87E7373AC29C1CBB49E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("077"),_T("017326197BBD2E1FDD0E11F8566B9AF0"),_T("01E130328507AD3C0BBF764713BAA825"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("077 Gray"),_T("0141F107BB584F14E87768245DB3AF76"),_T("01F1541340407C08EA76A4FCFE8072B2"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("078"),_T("0120996088E68CF9F70A20A414D14AE6"),_T("013E3A5D329BBCB6AAF62F2E18FF8127"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("078 Gray"),_T("0121F5AA8F3FDC544FE971687552237B"),_T("01702C9DDEEF45423E653771CC795E0F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("079"),_T("0182230692721ADF5DCBFB56F747490C"),_T("01DD92C0CD7077A88C49139F2F15908D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("079 Gray"),_T("018FF6814B9CECD349F3C68DB05AE935"),_T("01A3E3C211808C98C590BCA8648EADF0"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("080"),_T("0175BAF3251040E0EFB2930B73328E7F"),_T("01DC499064BA9264D591FDE9071DFD89"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("080 Gray"),_T("015025DF3475A3F29C67076450ACA130"),_T("01E0394825707E498E84188416172B0E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("081"),_T("014D29278FD055B04D8FCEF52F63568B"),_T("01EECF7F5B388E02EEE84ABDCF4CECCB"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("081 Gray"),_T("01AF22414DC63BEA0C335DE6D1375597"),_T("01B475A679A93E2BC96403919A8EC24B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("082"),_T("0138A8D4ECE59F41D2EB9AF5168B6675"),_T("01CA9A809F737BA668C16DDE52E74092"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("082 Gray"),_T("017FF59AA3FE074887A5BFBD5F62022A"),_T("01FEA37B95E38ED4CAD108207F94128D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("083"),_T("010300D2A3C0CEB8216F7C59B96AFB16"),_T("014F706DC17A4AF11117D50B414F348C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("083 Gray"),_T("01051ABAFD203A1D4605907C8543F055"),_T("019B7D8C1A094ECB4CBB5B828420356E"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("084"),_T("018F43694F4E9A49C24613CE0DB777A1"),_T("01BFD6DFF74A169EDA4F585691B1C832"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("084 Gray"),_T("01B5F6A0FFE77B77435B2FCAEE7C6F80"),_T("01F3041C2B3DF3709A124468F429A720"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("085"),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("085 Gray"),_T("0130FCE1BA83C767EA3CB8DB23D92289"),_T("0181EC6986C4F1EABDE468325BA3A394"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("086"),_T("01AC139E31B941CA0F2C5B5A0BFCDFC0"),_T("01F3D5B0FBE08EC4AAE9E1E4238BF215"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("086 Gray"),_T("0114DB57CAB32401E0507B831E2A52E4"),_T("0146686A83711D8227677BFBBA638030"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("087"),_T("01387A14AF75DC6963F040C1239B7DED"),_T("0196457BE1E9E30F00715A3DDE8B160C"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("087 Gray"),_T("012000BE0A51DBE0A2C9892010AA5F52"),_T("01ED8F3F34064DE4F66E3020450CB51D"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("088"),_T("0197DD04E9338FA3B25733603CE7B284"),_T("01EDFA7E57FD291021994E804A3F8B7A"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("088 Gray"),_T("01087F903C023E08A98F0AFFDECEB92E"),_T("01FD306EB29345CD98B6A5745F0E7E75"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("089"),_T("010F50672F14B4A88409AEC86E9DECE9"),_T("01C3B4FE62DF9A99F1CA8A5C17AC7711"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("089 Gray"),_T("0151EDAED564F03C97DECD9354C9E257"),_T("0196AB42568EED23B00AA7EA62C8A2EB"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("090"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("090 Gray"),_T("015C645021E37D3469A6B652789383DB"),_T("01D400C125EB43B05762A66347B271F7"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("091"),_T("019F3987F634C2AABC21F2AF9FF4A0DD"),_T("01B96BF26D34997052B944BCAE85EB75"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("091 Gray"),_T("012D8D2AA086D89492158B78E1409893"),_T("0176BA0E25E41748CB30F6A569C793C5"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("092"),_T("01557A9AE226A38386271DFE13D64298"),_T("0167FCEDBA3A8E8CF822163DB3564762"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("092 Gray"),_T("0142C7713D66971ABCD4705A86C69165"),_T("015BF30464B173AD153EB6FDF2F443F9"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("093"),_T("01B47B996CFDAA5BBAD40B9496314C1B"),_T("01BFF13DEB883EF04BEF63AE789B06D3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("093 Gray"),_T("011D2972762547222591CBAA7C61AF23"),_T("01A6F243D0894ED6B08CD932F2C5F096"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("094"),_T("019A5A3F4E1CAB2BEA76F978702613E2"),_T("01F870A8F8261FC607E1DE4C088B1B47"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("094 Gray"),_T("01945002AD5673EA722BE69C865C25FD"),_T("01985BEA05A4061A6B7350876FD023A6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("095"),_T("01E6610D026E8E6FE4BECEA9B3328A63"),_T("01E764F3ECB6C14A51FF83F1FF6D546B"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("095 Gray"),_T("01154D4A58716A0D3591A6CD38D1A6B1"),_T("018667606B031F3EB98BE15F21933033"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("096"),_T("0124512C758C4EA7689FD76F2327664F"),_T("01943EFC55D71F0B8BD5172B58D4D1E6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("096 Gray"),_T("01A02F112389AEA183D45DF351CCA76E"),_T("01AF02847E47B29390CD232AD89735D3"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("097"),_T("010564D93F295ADB889B91604DC82EE1"),_T("014302FE54745F4DBB58A0D51CDC66BD"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("097 Gray"),_T("01078E051231C5656C68E628BC44D34D"),_T("01635537D06C5A911C84767FCEC61FCE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("098"),_T("01081C0D2E757D5A5E24734E147CE6B9"),_T("019C33083B8FA8E4D2CED45F06F0B201"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("098 Gray"),_T("017165E9E48151933AC85B03ABADF71F"),_T("01C7F75AB9E45A76BAA81B38A8BC3AC6"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("099"),_T("01C7F83908166C226C06A44017421732"),_T("01D3EFDD3855C42AE3E0E6289F1A6726"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("099 Gray"),_T("0169F10B74745DE17CC5BDC51629A6AF"),_T("018177A3B8C276E1BE69C65555927CA7"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("100"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IJG Library"),_T(""),_T("100 Gray"),_T("01BC2BB6764A7F9709F829E766D93AAE"),_T("01BC2BB6764A7F9709F829E766D93AAE"),_T(""),_T(""),_T("IJG Library")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("000"),_T("0165AC93CC56CD962E10217D526A4E41"),_T("0165AC93CC56CD962E10217D526A4E41"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("001"),_T("01320332E53ADAA0073CE0CEC27FE3F1"),_T("01320332E53ADAA0073CE0CEC27FE3F1"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("002"),_T("01E036E949A895A37821CD14EBB4A675"),_T("01E036E949A895A37821CD14EBB4A675"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("003"),_T("0174A31FB9ACE562DE1A8E872E9CCD87"),_T("0174A31FB9ACE562DE1A8E872E9CCD87"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("004"),_T("01A134A20B2372BEE6603196DED7BC1C"),_T("01A134A20B2372BEE6603196DED7BC1C"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("005"),_T("01B1BB61E82C7572D6BACAC16B9416E2"),_T("01B1BB61E82C7572D6BACAC16B9416E2"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("006"),_T("01683DDDC33FB58B75F62B69669762EB"),_T("01683DDDC33FB58B75F62B69669762EB"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("007"),_T("01D83C9B11E571CEB80835C5F27A7325"),_T("01D83C9B11E571CEB80835C5F27A7325"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("008"),_T("01062ACF66978332F99F455BF1BF02CA"),_T("01062ACF66978332F99F455BF1BF02CA"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("009"),_T("0191560E1D00D2548C2B84CBD38E4F90"),_T("0191560E1D00D2548C2B84CBD38E4F90"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("010"),_T("01F70CA7113363A125152495402F4B3A"),_T("01F70CA7113363A125152495402F4B3A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("011"),_T("011AEBA34603BBF13149C2DF6F0D515B"),_T("011AEBA34603BBF13149C2DF6F0D515B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("012"),_T("01A7F1472D707FA981CD95BB2704BD51"),_T("01A7F1472D707FA981CD95BB2704BD51"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("013"),_T("012390AAF66ACC40F1E0BBDAC7F7C121"),_T("012390AAF66ACC40F1E0BBDAC7F7C121"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("014"),_T("01057F114EFF86B7EEAEB29B44D91FFB"),_T("01057F114EFF86B7EEAEB29B44D91FFB"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("015"),_T("0118EC3E8E053C034DF05BE8B0F57955"),_T("0118EC3E8E053C034DF05BE8B0F57955"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("016"),_T("011707F5512F6B6A5DC49A505D01AE6E"),_T("011707F5512F6B6A5DC49A505D01AE6E"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("017"),_T("011AE0EE6EC94BEE7A9A6B044A61140F"),_T("011AE0EE6EC94BEE7A9A6B044A61140F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("018"),_T("01DBFA99FEAD99E45BF3F8E87A6DC496"),_T("01DBFA99FEAD99E45BF3F8E87A6DC496"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("019"),_T("0179A73F972B0B3F50D1E7F08E6BCBAC"),_T("0179A73F972B0B3F50D1E7F08E6BCBAC"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("020"),_T("01256E630ECC0F36AC9A66A059BB8822"),_T("01256E630ECC0F36AC9A66A059BB8822"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("021"),_T("014A56275ACC27F844CADDB17F98F26E"),_T("014A56275ACC27F844CADDB17F98F26E"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("022"),_T("01D42506093CA9EF8A953FD39AC01065"),_T("01D42506093CA9EF8A953FD39AC01065"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("023"),_T("01C9E68E93AA669A128AEF8CA399229B"),_T("01C9E68E93AA669A128AEF8CA399229B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("024"),_T("015E1F710449F305ABFDB69069868E75"),_T("015E1F710449F305ABFDB69069868E75"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("025"),_T("01F610DAE4667E04A680FB5290680918"),_T("01F610DAE4667E04A680FB5290680918"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("026"),_T("019E8BED749941E7119D32CF7596D03C"),_T("019E8BED749941E7119D32CF7596D03C"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("027"),_T("016B1EFCF5EB29A6EC6C9B60543F3310"),_T("016B1EFCF5EB29A6EC6C9B60543F3310"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("028"),_T("012921014AF19689F7F763C9B0C45326"),_T("012921014AF19689F7F763C9B0C45326"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("029"),_T("0101A87A5738D68CBBD00DD5A6E243FE"),_T("0101A87A5738D68CBBD00DD5A6E243FE"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("030"),_T("01A33578C3220069FEAAA7E75291FD7D"),_T("01A33578C3220069FEAAA7E75291FD7D"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("031"),_T("01182426BB9EE261B719D69D33F2B292"),_T("01182426BB9EE261B719D69D33F2B292"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("032"),_T("0105B6A25A9C3CC6C116D3C1423C9911"),_T("0105B6A25A9C3CC6C116D3C1423C9911"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("033"),_T("011B084C50C703C19F8139A65F872BFB"),_T("011B084C50C703C19F8139A65F872BFB"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("034"),_T("01368977779D7F6794C6D8ED97A15DDB"),_T("01368977779D7F6794C6D8ED97A15DDB"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("035"),_T("016D0A6F0008E38FF4871D6FA2FDF670"),_T("016D0A6F0008E38FF4871D6FA2FDF670"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("036"),_T("015DBB98F058A2FCF2E2C4E2F4DEE19A"),_T("015DBB98F058A2FCF2E2C4E2F4DEE19A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("037"),_T("01F3C4686DB5BF716079413E8E797364"),_T("01F3C4686DB5BF716079413E8E797364"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("038"),_T("0125A88E7EE182C7AE60C2D4D7164AA5"),_T("0125A88E7EE182C7AE60C2D4D7164AA5"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("039"),_T("0153AFED056FAF18883C6E96B1030880"),_T("0153AFED056FAF18883C6E96B1030880"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("040"),_T("01B6C23631B1BEEB8BE9B8B02DCFA8B5"),_T("01B6C23631B1BEEB8BE9B8B02DCFA8B5"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("041"),_T("01123CD019B873459AAD3952CEB8D1A3"),_T("01123CD019B873459AAD3952CEB8D1A3"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("042"),_T("01A8E1140B0BF7461026A4809DBEAEB6"),_T("01A8E1140B0BF7461026A4809DBEAEB6"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("043"),_T("01581A0E69C1827A70976EB09BE96F8B"),_T("01581A0E69C1827A70976EB09BE96F8B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("044"),_T("016BEC3E5671BBE6E32F29E7A000314A"),_T("016BEC3E5671BBE6E32F29E7A000314A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("045"),_T("0177C479CC3569F601E2D189FF09093D"),_T("0177C479CC3569F601E2D189FF09093D"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("046"),_T("011D2C9DBC773C3786D8F5402609FBF7"),_T("011D2C9DBC773C3786D8F5402609FBF7"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("047"),_T("0108BF398EF6D0B8ABC608669F239502"),_T("0108BF398EF6D0B8ABC608669F239502"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("048"),_T("01C6EF48FB38D410960A4B5295402D13"),_T("01C6EF48FB38D410960A4B5295402D13"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("049"),_T("01DC96B5A5DA85F89903453952815094"),_T("01DC96B5A5DA85F89903453952815094"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("050"),_T("019F146786D0C38328847A24D182AE7B"),_T("019F146786D0C38328847A24D182AE7B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("051"),_T("01B7F57F8C74ED65BEBE6869D2E21460"),_T("01B7F57F8C74ED65BEBE6869D2E21460"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("052"),_T("013A6B5B0036C84A990351B774AA806F"),_T("013A6B5B0036C84A990351B774AA806F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("053"),_T("01793AD27ACF46FE764114536DED4202"),_T("01793AD27ACF46FE764114536DED4202"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("054"),_T("011032D627D34988AFB0C81BB38AB10F"),_T("011032D627D34988AFB0C81BB38AB10F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("055"),_T("01EADC023F4E5C5AAA1AC39A8DB1FDA2"),_T("01EADC023F4E5C5AAA1AC39A8DB1FDA2"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("056"),_T("01542C4D2A5514D93FE3364CE687C454"),_T("01542C4D2A5514D93FE3364CE687C454"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("057"),_T("01813B424C27FE594BE7BD3343E0A611"),_T("01813B424C27FE594BE7BD3343E0A611"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("058"),_T("017900994312A5DE5F9FAE88C288E214"),_T("017900994312A5DE5F9FAE88C288E214"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("059"),_T("0191BE33AB50852173F373BFB13EDF79"),_T("0191BE33AB50852173F373BFB13EDF79"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("060"),_T("011D3C2904614E246C4B468A20F3A936"),_T("011D3C2904614E246C4B468A20F3A936"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("061"),_T("012A482E2BF56F6F79CC68F954B9E546"),_T("012A482E2BF56F6F79CC68F954B9E546"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("062"),_T("01EFC4FB222400071490FEFB4758227A"),_T("01EFC4FB222400071490FEFB4758227A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("063"),_T("018116332ABC764D7A310A24BE177139"),_T("018116332ABC764D7A310A24BE177139"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("064"),_T("01C9755B12B233887E9324B085D765CF"),_T("01C9755B12B233887E9324B085D765CF"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("065"),_T("010066231D4ED98B946D06673BC5461A"),_T("010066231D4ED98B946D06673BC5461A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("066"),_T("01A22CB689E1CE541A6F9C90B5BAAD45"),_T("01A22CB689E1CE541A6F9C90B5BAAD45"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("067"),_T("016D25B5E4025E5C6CD9669925D466AF"),_T("016D25B5E4025E5C6CD9669925D466AF"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("068"),_T("01081855DC7D86A3C49FFCD1FD0872E3"),_T("01081855DC7D86A3C49FFCD1FD0872E3"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("069"),_T("01B4CBB1E2072AF552406AAE4F6229C8"),_T("01B4CBB1E2072AF552406AAE4F6229C8"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("070"),_T("019F9FFECDE5E7D2C16CC9690B8D1F84"),_T("019F9FFECDE5E7D2C16CC9690B8D1F84"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("071"),_T("01365815032821702D1D930EBAB3A018"),_T("01365815032821702D1D930EBAB3A018"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("072"),_T("01C52D343FE84C9F630B12E74D24FC3C"),_T("01C52D343FE84C9F630B12E74D24FC3C"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("073"),_T("01D9875CC6270A5D1F95C86812F2332B"),_T("01D9875CC6270A5D1F95C86812F2332B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("074"),_T("01DDDA3E938F3F32BDA4C6FB2580C07D"),_T("01DDDA3E938F3F32BDA4C6FB2580C07D"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("075"),_T("01AD10A6B3BC47A7087FA4AA6DD82A84"),_T("01AD10A6B3BC47A7087FA4AA6DD82A84"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("076"),_T("018858FFFFCA04022B685715553469F7"),_T("018858FFFFCA04022B685715553469F7"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("077"),_T("0161B033070AD7DF62ED0D0C5E738D2F"),_T("0161B033070AD7DF62ED0D0C5E738D2F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("078"),_T("01E1FE1B4167D1DB9E61B353A0C222A0"),_T("01E1FE1B4167D1DB9E61B353A0C222A0"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("079"),_T("01B88714C0895C6C53D6BE36937A449A"),_T("01B88714C0895C6C53D6BE36937A449A"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("080"),_T("01E6BB7915E70A0580A079D7A78298B5"),_T("01E6BB7915E70A0580A079D7A78298B5"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("081"),_T("01535ED71A83B97108BCEB895970043B"),_T("01535ED71A83B97108BCEB895970043B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("082"),_T("01DF44F9FB42F388184BE63D97FAAF59"),_T("01DF44F9FB42F388184BE63D97FAAF59"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("083"),_T("010B5C07E62A9FB8E0EC07F424F91BC7"),_T("010B5C07E62A9FB8E0EC07F424F91BC7"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("084"),_T("0186FD4E87FED64154FD29050DCDE911"),_T("0186FD4E87FED64154FD29050DCDE911"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("085"),_T("019CB44E34BBC199CCDE9949BC3C81AA"),_T("019CB44E34BBC199CCDE9949BC3C81AA"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("086"),_T("0102F441777107372DDBA78ECC612F95"),_T("0102F441777107372DDBA78ECC612F95"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("087"),_T("01F77B3D704D81FC9679311833807D2F"),_T("01F77B3D704D81FC9679311833807D2F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("088"),_T("01DA4D763CA09070FE565F16F98AA391"),_T("01DA4D763CA09070FE565F16F98AA391"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("089"),_T("01F1DAF5AEE48C7A85C561856ABA0ABD"),_T("01F1DAF5AEE48C7A85C561856ABA0ABD"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("090"),_T("01AD2B3452A92FE3564BFC87014D17CB"),_T("01AD2B3452A92FE3564BFC87014D17CB"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("091"),_T("01EF6B2FB59A6F333BAD5FF3CA481240"),_T("01EF6B2FB59A6F333BAD5FF3CA481240"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("092"),_T("017B4CC93608A96F242BDD539E9CB8FF"),_T("017B4CC93608A96F242BDD539E9CB8FF"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("093"),_T("0142A062D95E6067C4B0B791526A0C5D"),_T("0142A062D95E6067C4B0B791526A0C5D"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("094"),_T("0121303C9E720270C0931427D9D0FB2F"),_T("0121303C9E720270C0931427D9D0FB2F"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("095"),_T("016C410AD0D0DBF3709961EDBEDD7D0B"),_T("016C410AD0D0DBF3709961EDBEDD7D0B"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("096"),_T("010E60C5B6D1D2C9163A91ADC454B219"),_T("010E60C5B6D1D2C9163A91ADC454B219"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("097"),_T("01550366890863E706A41B5610F6156C"),_T("01550366890863E706A41B5610F6156C"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("098"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("099"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("IMatch"),_T(""),_T("100"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T("01E4DEC5DF580F8461F51E4430A0C612"),_T(""),_T(""),_T("IMatch")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("002"),_T("010D9693F4FC34B402EFA979BED34733"),_T("0193B6220463E5A621ED25A53EC2FE7D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("003"),_T("01AE4339D18A0F80E83AC68ECA3F29D2"),_T("01D73AB11CDEE244F9E6F86AA656DCF4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("004"),_T("0130D16765220C8A13FDA6E7015EBA60"),_T("015829A3515B899B026896D737523095"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("005"),_T("010F16DA7E39F9FA0D360306D844BE1C"),_T("0162806319221CD47AFBE36563122286"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("006"),_T("014B8E3BB9C7F7469A34DE7ACA0E3E14"),_T("01D1781C33BA6C700844CF5F06F64D26"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("007"),_T("011EDDE09B712B924A2BE665A74AE914"),_T("01AC05807AE1A285B2B1F24793ACB8AC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("008"),_T("014682A529B0B422C82557495769AF92"),_T("01A9CF2158FAE4057FC08722ABD92D67"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("009"),_T("016D0D6BB91282D033CCC41AD6BF3CB2"),_T("01FB5E38DB85808DEDE20EAA84BB9812"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("010"),_T("0101092454C6BA70F329E8323BA37A62"),_T("01D3F187A0B029D75287067CC329CBEB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("011"),_T("01241D8A9C72BB77B5EFE13F46E0A694"),_T("01886D873F6F6F190084AA8EACCFA7E4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("012"),_T("015916E2168735FB572926A049B025DB"),_T("01F9ED4812F46CA42CB85C9371E94710"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("013"),_T("011ED6AAC481E84EB7DF7D6C55C35FDB"),_T("01F41F75DA85DCEE81F79C9BFD835249"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("014"),_T("0159C3DD4607B9ACB9BB3F5D7191891A"),_T("01901016622EBC2E42EE162000A13DE3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("015"),_T("018390F607F757E2E42726F5EBB576FB"),_T("01EED88C9C6EB2CA6E048972F144CFB2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("016"),_T("01160566E2F95BA1BF0BD7EE4B0A539A"),_T("01705560C1E678DDFB67349C3C510B2F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("017"),_T("010317C21733B42EA85718360A1ED6D4"),_T("016D83AC7EBE1C58D15569E4FD4EB650"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("018"),_T("012791C800B2CCB875FE41FCA751D076"),_T("01C78E1BE13FDF35BFD3DFC789ADED0B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("019"),_T("0134A4CABB20CE957BF7F286CF8A4F77"),_T("017A10221C34E697EB4F3D9BE678A664"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("020"),_T("01013FFDF2B833139BDC7D30DB3F6F9C"),_T("012A1A7AE01B91CCAC1C5264E444A3C6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("021"),_T("01347AC5D164854F8C771A7799867FDC"),_T("017A11C185DAD8B8246F46BC6BBF60EE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("022"),_T("01166750E43638B43D2714F203408D38"),_T("014D35DD5AA484B2B89A705B009D6BF1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("023"),_T("018FF7549D7AE5B9D1D2A61A0DFD584F"),_T("01EF84DB7BFD56AE1AFA2694BEB10676"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("024"),_T("0196A9589F2F3BA0D42D937C1A94312E"),_T("01E28097831F0F7B6A5C17D31F74E2D4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("025"),_T("01CAA4241F9ACC590059C92CC8203E75"),_T("01F7BF349603DA557C8CD6EE7D9C5AC7"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("026"),_T("01561E29456A1AFB859025E2407C7077"),_T("01ABF64A97B6FEF8218EF1EFB776B9FB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("027"),_T("01821498C3A572DA347E2C024EA303BA"),_T("018BF7FA5F45481749B5AA32797564B6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("028"),_T("01EB64439B48102135509A2A19152640"),_T("01F5C4A96AE81125E1987D0CF03389F6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("029"),_T("0144DB8DCD47372608E2295E4EC309B1"),_T("0155964EA581F823AD5ED60982BD2BF2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("030"),_T("0109523D0200F111FBDFB63DC27DE296"),_T("01AFDE21B58FF9781CD22B60E20F22B1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("031"),_T("01872C7AE0162EF140AE3C5F5EA39753"),_T("01A5762018316067F45B5D0B30E0E4A2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("032"),_T("01626CBD0BAEB519B4FA1DB9C280013E"),_T("01646D280597178A2C5344688EEC6E0E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("033"),_T("0165A4432B13F5117EC466B6DAD5D5A3"),_T("018C4E45F08A156DB04F70F5BB708721"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("034"),_T("0169F22E635E72757DA817F4AF5095EA"),_T("01B18BB69C0824C715BB005F1A4184A9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("035"),_T("0174A6099629A3AC2A4D187945772A2A"),_T("017DF8CA578501893092725F3B7918D9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("036"),_T("0170FC9571E8D70265DCADC8049444DE"),_T("0188936C9FF8F4EF33C8F9AE1E337D27"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("037"),_T("01DFE417CBBC628DDC8BB3A78AAD5B33"),_T("01EC396D7F0CBA8C375512E739C7F90F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("038"),_T("013628F4E46C5B171E4B808B8AE2863A"),_T("015D15A0EDFC7D0175E0949D6A450524"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("039"),_T("015ABF68E584D7D7C8877F6FD98C184D"),_T("01DF9616AF38E538261F7AE8571E31BB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("040"),_T("010605B0608B08F2892492F6CCA254BF"),_T("01166CDDF24FC9B5437579E30667C774"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("041"),_T("011EBBE3EE74E33567F2CEE7BC6C8F38"),_T("01965362F06FCE474BDDFDE09F119CDF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("042"),_T("01E8295EED0260AAF623B72423E17B17"),_T("01F8EC33907B45D062A8398A2DD3045A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("043"),_T("01AA8A959B286BC0E480F7362A790200"),_T("01F34AF7BB0266B24D3F018B77BD1D99"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("044"),_T("0132A165637742AD0D3C9EDAF84DC95C"),_T("017EC1C29F2449DA50B3FF30061C6DC3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("045"),_T("01380D2C3886D54F05AF501141908A08"),_T("01463C19A046A5A6DDC79555E325AFF6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("046"),_T("011FFD5C27656C7C753976FFBA50FEB1"),_T("01E189AB820A6C612129C5D7E0BD72E3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("047"),_T("01548A239BF2C6CC1255CD26F1B840F0"),_T("01F16C6F4375E2055EC31A45A14F3DC2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("048"),_T("01182829CF6E8D0845AB1F3BF52D9F9F"),_T("0158C3EE617A20028F15D0F25A425D98"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("049"),_T("0121C7DF0C348A2A5E4D4B7CF62D94CD"),_T("017FC54345ADFFD6C7946694E7E49122"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("050"),_T("0133FC69E52E74319F110B4486B8B0D8"),_T("017FEB124293E03634B25E85B537A2E9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("051"),_T("010CBC45D3C5260863E839BFC2235A81"),_T("01CFBBD314CF6CEB5248469C5E3C2CA3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("052"),_T("019D1C17E70D8AC5C9B6DEE7A30827C8"),_T("01F0547180BAB8A5C8329D7DB6F3F954"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("053"),_T("013146F1F80E20B7C32B0319B214A919"),_T("01FBA1F3C2CCA3C78748DD5C4CC80562"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("054"),_T("01BC27930C37DABFE67EFD9E4AB54437"),_T("01C01A9A5554405594E81AB4C371B932"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("055"),_T("01B72C7BF56F55753B1265BDFF439069"),_T("01F08AA3ED4A18353A524A66691D73CE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("056"),_T("019A22EAFA396CDD0CDC430C61FFA430"),_T("01D67A64BE0EA692C0EEDDE2EE719535"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("057"),_T("010ECB885D4D576D5C5932FF5A6A5092"),_T("0113B452EDEA1714691CB6333FD0729D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("058"),_T("015E4B9F3BEAB958F015B81710C84810"),_T("01AD6C71352216EF35FE8520F5D1E82F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("059"),_T("0163526F62E82D53C0DAD905D35C4599"),_T("01A9FC9DF742C7FF082F03A6F87EC381"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("060"),_T("0175E68D4D293E2FA784C8CE11DF5516"),_T("0184D878A64B40EF526E5A6EF6BCBCEF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("061"),_T("012300395A15B1B6D203FA8393593157"),_T("0134E076C67CEBD6283F4ACFD9BFF5A3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("062"),_T("01F9E4690F1C0BC76BEC16928BAE9A88"),_T("01FDA2A2C7470CAFD274D9FB41AAF0F1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("063"),_T("0107317B76A298F1175B4BACA2B107F9"),_T("01CB912C521BE4AE1FDB4C842587E7E2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("064"),_T("012440B020AE88BF95B81B31641CF09C"),_T("01D32149DD50948136591D5F368DF581"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("065"),_T("0141CDC5CFC490A7B8C049F9D93AAF73"),_T("015FECEF7EDC0B3AF333347FF17321AA"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("066"),_T("01A6F76F7CF17EFC800AF2483ED2557C"),_T("01FEBD27FF945E96DF972ADFD2FE0F6B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("067"),_T("015DAF6A68DCC4478A45C180F88C9DFA"),_T("0198059D58EFC7D276E91AE2E90D2A4C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("068"),_T("012166ED0C275FFE159418B2A2113CA1"),_T("017B601F4F41E04CD8EECB9337CCBBDE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("069"),_T("01433F7C61DAA7495770AAF88AE7039A"),_T("01C86AB6D8F5303BDA47B88623E417A3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("070"),_T("012A78934E0D22A24AE899907336F46D"),_T("01E52224D11398FC4821FD4E938BE877"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("071"),_T("011F669669DAA96DAB5C7517A5172089"),_T("01B558FAE56F5994211E6B916577F868"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("072"),_T("014170590155C13FE856CBA528EA920B"),_T("01A343DFC0DB4F646D3063066740BAC6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("073"),_T("016FDE4F110A6334F0973B29DBF22C85"),_T("01A325BC80221BD481A6D37355FBF9B4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("074"),_T("011F4D6A97876DA82E951074BC74A097"),_T("01D970DCACCC1D81A2DE8E3E4C3385FF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("075"),_T("012C8E823FB3F009A733E7B91A146A96"),_T("015DDB4F6B6A8D3A5E934B7C70F69CD0"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("076"),_T("0106E6569633D7A5DE7A24F1D08042CB"),_T("01A8904FBE491ADF0B62FFBDDA4A0FE0"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("077"),_T("0110ECE968535091C39AA238A6E17E83"),_T("01F62C6E04151C290FE6E475B5FFA56E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("078"),_T("01607299E0B0D313EB869C0789AC56EF"),_T("01D29EE49F2811E430569C8C43F1046A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("079"),_T("0143DE5B546751703206B2C5335698C0"),_T("01D8674E4E744A68D5BDA4A2543C8B59"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("080"),_T("017608CABE0D8EA50F98359E3B90E58F"),_T("019DA014E50CBF279074EDD8ABA2BFDC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("081"),_T("01BB618731B0CC9F1EFB45293DFD6379"),_T("01CC621547D81C1FDB424C8B013725A3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("082"),_T("01653DEB309B7D3BE24668026E2BFCA6"),_T("01926E63F4B81298BA87F4C5D8D22700"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("083"),_T("01B0DFEB26DC3CEEF172C10114D1D1F8"),_T("01D100852DA3DF0BE3145A12152DA87D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("084"),_T("011DD9AF3EC835F5AAD56D8BAA6CA058"),_T("01925CCD917C507DBE547DBAAA5F00FB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("085"),_T("0145E6BAC626BA2061E26CD9120D3D0D"),_T("017158FF2EC09CAA79A63E1AD371972F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("086"),_T("012D19D8472A61C74A2FECE822664F24"),_T("016E3AB5C1681D786D7EC6AC65EE8C4D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("087"),_T("011D4CBBB874BC0438B7A82B99F61024"),_T("0121AC61D63E0CE991E5EAA2092B944E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("088"),_T("01AB6F0F127632E95789CE3F207AE6A6"),_T("01E6B6C5713F5E884C46C5675ED26B2A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("089"),_T("010F8FE41C7B8EEF01699F91C5E071CD"),_T("0191086A01F0D774B7C509E5D26E51FB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("090"),_T("0133F539C3C8F7349AB3CD95449C0A43"),_T("015C031486FE1D68DBF351CABB2FA562"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("091"),_T("012D7B879B3DD39080026AECF90ACBE1"),_T("0172C829A8BAABAAA7CD03665971F951"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("092"),_T("01AC6BEDFBF8FC68178A60F6A58703F7"),_T("01B930D70CB78DCB1F19B54BB01CE5FE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("093"),_T("018E1BB7E1BBB283FD6CC7B63222D184"),_T("01FE4D541951F248E3CFECF937A8B15A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("094"),_T("01573D26512CB20F26EE9D8BAB4F8F92"),_T("01CCB2F17A97E15E403FEDA856E0AC26"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("095"),_T("011D8D1C132B3AC1E38E908794BC12CD"),_T("019479014B4DADCCAB900417DC5E5E6B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("096"),_T("012182815ACD54C5ED046112CF86B17B"),_T("01A95CE911A6B592AAD4BBB9A3389530"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("097"),_T("012DAB79295978802275F2EB275F3018"),_T("0177CAD866B69CF219E809A260A615D9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("098"),_T("016DEBEAFAB638EB0FFEFFC01DBD5A93"),_T("0180FE9314CF21561495056C7829A1E8"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("099"),_T("01023A9C5ADDAD46F387B97385DDAD8E"),_T("016ACE6BDC9B15A229DA6C3803765017"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("100"),_T("01E1BDDF6C45DBEC46FC48B60BBF6018"),_T("01EA5E13EF082CE6D445C4AC8ED703A8"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("101"),_T("010141ECC5CC1790D53255A8DDDC833B"),_T("0128F95E9DE7849E634EA71562327BE4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("102"),_T("01171F54307EDF50C03ABD8B00DFF08F"),_T("01EBA7D8ECE07830AEA584123271D1A0"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("103"),_T("0101666C809358D2E81FB42FDC63B2DD"),_T("01020222E6F191065FAD2BCC51533280"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("104"),_T("0140D612069F8FAA681E9DBAB8D9422F"),_T("01B6390FABC6D36F61EA3E9C567460B9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("105"),_T("0142F71E2A5FE68B77119E652C497DA1"),_T("018D7B491F46CFDAAD58ADDADA7C69D6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("106"),_T("012CE2C6E38F70422E1A4088817E8D1E"),_T("01513A242FDAC9DF86CB10B1983401E9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("107"),_T("01A73E3CBBB3D58EBF7D305DFE82CDDF"),_T("01B11D8D4DF6FC62A0483F8C5B1B574C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("108"),_T("0139868D2E3D0B299C5B53E1242B73FA"),_T("0157E6A56B0F86CB33286A66C826AB1D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("109"),_T("015F3E7E52A9BB54D2968B9502E56B7D"),_T("01A587DD053AC0EEA85252AE153A306A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("110"),_T("01445B141C321629DE1D172989A5DB00"),_T("01B1FA9AB8E9FFFF4EC9D7E534523430"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("111"),_T("010CCCF0E35063085F6B99EDFBE9FAD2"),_T("01246F5CFD63CC8F8E3B018FD8C5A2E6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("112"),_T("0172FE66433D5A303BEC3A7B3598413F"),_T("017807CE8752D7040EB8911BE11F2ECF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("113"),_T("01CCC60FEDECE33BD4D5B9BF147C328C"),_T("01F69436326FFFE5A7D587753E51D235"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("114"),_T("010A74D30FE24B0CB7F0714BDB698933"),_T("014862165168A1D16D354D47BF688216"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("115"),_T("0127FA6EB0ADEF10211E9FB0E9A4CE57"),_T("01637285D6262ABE6DD31424675DCA08"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("116"),_T("015231DA2358880432B85B5B09B81C38"),_T("0165997FDB5C071D28926403F749AFA9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("117"),_T("0122411D52D4ED1253B058F4DB022E90"),_T("017BD507D2EE0655298312CCDC880665"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("118"),_T("0102ABB0AE862BF7F819435579E6247D"),_T("01C447FB8247749E4E567A704E428D45"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("119"),_T("01126218AC9A43474C6A20E003B0C745"),_T("014453F2D9017D5D4027E745F2BC013B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("120"),_T("01E1475EDCD07BEB173E37EA2B175775"),_T("01FF6858DD9272AFA62AE816476D3F42"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("121"),_T("015A290A921D1A61039ADE4601870B45"),_T("01BAB47CF076E57F011C308687C0201E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("122"),_T("0117761DB6D57310D87DF66FA37FA55C"),_T("018A985588DFC6CF1B7041CF90C6A01F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("123"),_T("0126D303D0E3903B7ED22854AC5FCB5B"),_T("016AC4AFE871A1B87AF7A266958E4B7F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("124"),_T("015166A24C308C040FC15EEFBDADEF43"),_T("01D3EBF7841ED02AD1A7EF5D50DE2781"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("125"),_T("013432620EF3C94ABA4B8B43893CBFDA"),_T("016A83ADE0CD4955D9C5BB5A834D3350"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("126"),_T("01154A4B654FC14A1FB5EDFB6CF9A330"),_T("018153B33F1C1B5ACD8B558368063A47"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("127"),_T("017A3F21468542DFB663AC22203C535D"),_T("01C556D1672AEACA3D59BC16856EC458"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("128"),_T("01CA214289E25D814ACFE0605450D369"),_T("01EC39946C595C89370B197CF1AD9DC4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("129"),_T("01B3BE8967B35123F5470C114ACC4D85"),_T("01F6D1933E1977C3AE2CAB28D26B6CA9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("130"),_T("011603DB4A43142175F911A9B1499D15"),_T("011CAE4214885A1BCBD6DAAB17E21962"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("131"),_T("013C262FCCF1880A24A3363BAA52F0D7"),_T("01804C67D073E9FBE759D0F4F3BB4851"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("132"),_T("015C3D3593910C5D68881301400627D7"),_T("01A884BE8038BE0699E63FE0FEF708C3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("133"),_T("01C3FC4C442C82D1BF964721F2E83566"),_T("01F2A5444C2F00BC66A710CFCEFC63CC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("134"),_T("01BD674544CEF9938C18F992D9593D60"),_T("01F44452EAED42EFDC058888F8655295"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("135"),_T("013231BCD4DB6238F254737F0694AAFB"),_T("0148B37E9F2C9FF9FEE1CFFDBFC5440E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("136"),_T("017BA30AF567FA508880537B53AF1DC9"),_T("018C8428B7F6B8A7B458218052063827"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("137"),_T("01BFC4478AE7B73B41E50ECD28DBFA78"),_T("01EDE8F336941947589F52BA8F913588"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("138"),_T("0197AF7CBDDA618AD03F38469CE36C27"),_T("01C303C78B3C6EDB05B6BAB9D33DC066"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("139"),_T("01423D270D41FF070AB1A59D0D2DACA2"),_T("01A5635F552D35C292C9846F7E70FDDB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("140"),_T("0105B2B68B41A49822BE48D950359C15"),_T("017E9E409FD0EBFA51AE02E48650D4B4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("141"),_T("01694E63CF8AD00C095B3EAC43F48A54"),_T("01D656714D974C633FF925601A2AF00E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("142"),_T("0101B13F55983BAB29E383AD562DFAC7"),_T("016C6AF5FC276A23D80328BDC9BED33F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("143"),_T("011200DAB55F8121374DB751C9E8F5B9"),_T("01F4EE9BA4BF7817C586B0D8DB0F738F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("144"),_T("01871DA90985CBE76C50D726831A91B1"),_T("01A689041103AB59CEA476222A0794D3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("145"),_T("01803640D2420EE067C0F563CBB95DE7"),_T("018353485340A2010A4A235B1BCAFA81"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("146"),_T("0163E75D86848F86284BF139FCA3549C"),_T("018E709178CFC5A916BC344AED26F220"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("147"),_T("014688C0BD278F52D4C50C521655F66E"),_T("01A63DB18F873AA2840962B31DA9C817"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("148"),_T("013CD318BFF36E64B4F278E711DEA604"),_T("0178483C1EE5DE57BF953F86759EAB3C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("149"),_T("0155C0982CB5A63BFF9B5253574EB035"),_T("017771204B2B4085EE4A71FACEB2046F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("150"),_T("0130B52BECDCA022AC4351FE4488C78D"),_T("01F38689DFAE7F18B9D7A757C417F4A0"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("151"),_T("01339152D762290475AFE687085AF946"),_T("01BBFACDC2C7A3247BBA0275D5635997"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("152"),_T("010174B064BCE4CD8904BDE2323DB30B"),_T("01D21DA353D298FB3AD6A2293B6426B1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("153"),_T("016A859C353655704E95D1423022EE6C"),_T("01D50D9CED27295D1F94C394791DD27E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("154"),_T("012EAF2E5A37A39FCB90FE9B8E1B0125"),_T("01F995FE2845306D1F0CD1B2CC247389"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("155"),_T("016420AE56F486BA2525D85AADBB339B"),_T("0192A18C2F74AF061E7CB0662E81DF0C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("156"),_T("0121D7F3B29A19C137ABF1FE953E93BC"),_T("01314DD06C5D624036E01B45E67A72FD"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("157"),_T("0180B0D0F6E0B42EB78DE66CB363B1F3"),_T("01E0F93EC976F33BA219E94567133B38"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("158"),_T("011EDE482D6C91D1A4D0EB1649192E0C"),_T("01A2317C79DFC4F5432A9AA284132E48"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("159"),_T("01201CA64783CE8188860A0ED0EE8730"),_T("019A99D60146E0563333B96672A27086"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("160"),_T("013D415F6D9A2E3632F2352A34460202"),_T("016A76DBFDED5D2370F7C9911987F883"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("161"),_T("0139CF17C9F433E3D69FDB6C5D0310DE"),_T("01A31F28A468D32AECF98CCA09DF5CEC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("162"),_T("011C6E5426A01F87557A250C2AA29217"),_T("01FF5A009E8BC1DFCC3EF5C219A2580F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("163"),_T("0181CEEB6A4808DB5DF406CA356EA961"),_T("01E61B13DDB271A5FA8431CD7C3632D4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("164"),_T("01584D00FFE9D5F4C0B18C1F1057AC2D"),_T("018D851B69B22F754C61D7A7D404804E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("165"),_T("014FCBCD7DCC32E728AB11E41D340CF1"),_T("0197C7717AF680AEADE069E4CF5566F1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("166"),_T("01D9EF9AA868719114E7ED681CE15A80"),_T("01DB08AFB949C6BF5038EACE89C16AF7"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("167"),_T("018E8E0FB96EDD8C810FAC4BCAF5A1E3"),_T("01D71CE75395343B02463C9015B0077A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("168"),_T("01BB9CD692E53154B43C6E55FE0649E3"),_T("01F9292523447EF171ED57B21DF0651F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("169"),_T("01148E465BBA17AC2D3C2767495085EC"),_T("01CC996391449E53060289135E622C37"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("170"),_T("0118A98A7AC7645546854D5B2607BC18"),_T("012CF14DB7C0EA2649CE8BDB7748771D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("171"),_T("0164BF7D624C6777E83DF8D8010ED1F9"),_T("01B3BA7DFA2A96138260DD56B020A299"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("172"),_T("015D5A7A503EF9A79E0B9DCFA4D9AFCC"),_T("01ACF9CB7740C2AED7B849D1DECFDE07"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("173"),_T("016C18E771F0FDF4509C2867B02497DC"),_T("01E395B45299AFD9C7AFCC8962DD186C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("174"),_T("0110C90DC53738A78030D81B591AC85D"),_T("018B7DEACF116730086494CD41B1E76C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("175"),_T("0140AA92AF90106991CEC0EF43EA9457"),_T("017816F27EC5ABF5CD34DA0349DF8A50"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("176"),_T("01542922E77EA9907DA7C63A53EC0C2E"),_T("016A09CF30769985052767C629566149"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("177"),_T("0161A5E2DCDB62920B9288658957C449"),_T("01AC8FD2461869A913BA2E4985388C42"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("178"),_T("017D9D0947EB2CDE8A79CD4C5D869F0A"),_T("01ADF6C704CD3999A14BAB1779AC5C60"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("179"),_T("010EE1BA682A0A601783CEB29267810B"),_T("0163A30EFC0120551D66A798698035A6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("180"),_T("01592BDC96DF403C97961FE9DA3A2873"),_T("018F8F43094A2B3F41538DACAA06D0D3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("181"),_T("01B1C5AB82A4EF3ABC574D4A987DF7B6"),_T("01D5D6195B4B127BF216B37F6AE34346"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("182"),_T("012CB7FA2A05A9C81BFE5BD830CB8A86"),_T("018AE56FA30610ED2C3220D469C4AD5B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("183"),_T("01AA46313DCA7147FB76F9C16DB95E53"),_T("01F925D9FF424F37F9DF4651AD5F49AD"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("184"),_T("014A437C6777FE25CCCE2E0839514344"),_T("0197A285BBA2E336F5400798A1EFDBCF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("185"),_T("0139A1775B95631AED1643F9B9A10BDF"),_T("01A89B8115E4C07B1F2E1DCEA21660E6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("186"),_T("011293704A25B4573D946F959C1D283F"),_T("019DE085FCB086DC1FCB3B64BE663827"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("187"),_T("013C181981A0D19412F53D2569584165"),_T("01D600AB45ECA09E45C6E4A1694C8234"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("188"),_T("0186832C45BEE501811E977BA184521E"),_T("01E0CA9FA53234ED9CB1B7EE41F97683"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("189"),_T("01583D62D92E147E1D3D96D8DA75BAE9"),_T("01CCA0E74AAE418E55199FD145DBDAD6"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("190"),_T("01B2E2402508AC74AD6F6EA806B0F602"),_T("01D69A0BBAB8B513E1DE2A46CA907F9C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("191"),_T("01256DD2320743579D3BD609B41C037F"),_T("01C5BBFE5839CB149B1B081A21F9CBAE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("192"),_T("017A13BED0629B650E766E8D9E902BE8"),_T("0194A980726F85C2B181025329A20120"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("193"),_T("01CE303D379D6D4EEAAC4F32AA5F9C8A"),_T("01E0BA091563681A70A97C05E08CA118"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("194"),_T("01966DA267048952B7F85C0660AEDAB7"),_T("01D83116882941AB191165216E83B03D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("195"),_T("013CE8D7CB46B01AB54AD46A328AF3AA"),_T("01F6A1D4ED560049F4B94EF1FAB50A0F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("196"),_T("01766DFB4AB8AE4CE255F51D1C2312FE"),_T("0187FC645536F1FB632D8796CFE484FE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("197"),_T("01AE734C85730B30D8A65855EADCBE46"),_T("01C34818A36E8B5A64CB40DBBCBD20C4"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("198"),_T("018D6DAF0BE5233A8244A19F82B5F783"),_T("01BC7B2D25E7FAAC23A9321CEA6608F7"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("199"),_T("011C08D93C5BFD6DA098F0E85C9B8C10"),_T("0179ABBF6FF7A03F9CC1A55B9BAFB8C1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("200"),_T("01A23B72BEF75A4E84326F02773A7CD4"),_T("01F992EEBCBFBD7BA60314C1F508D728"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("201"),_T("0164FD8242063595E29DBE312830045C"),_T("016B7D40D8A542B883A5A780D2F57B07"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("202"),_T("016A90CDEBC44629F2D139F33D7A082B"),_T("019A1095D5923CE1794BF6EAD8A0AE86"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("203"),_T("0143659D8A7CAC20D791A6470D18BF27"),_T("0186DECD51204231FF26E916F8BC6F90"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("204"),_T("0183D0F6865F5A0C20413AA23E39E6AE"),_T("01878A9644BB3814E0E1BE55B726F810"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("205"),_T("01067CC09A86C82ED44C5296F627096D"),_T("013574316F410F500CE9DA3ED49B3CAF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("206"),_T("0153F4AD836330A3FC327D63AF81E863"),_T("01967A578FEF8961D357B89CED883312"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("207"),_T("016368A72B2B4BE76F9FCCD24F3A3C4B"),_T("018673DABE870D0E382895336312C4F8"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("208"),_T("018DCFF341F4F16AC152899FFC9930A7"),_T("0194EFE42E510AF76A28FFFFB6A7109B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("209"),_T("011D2D343B318B4B5EFBF3F5C4881374"),_T("0182376C5A57A22ED63A7BCC1DD15911"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("210"),_T("01C57A8AC130A22BD9E70B7280C3AF8B"),_T("01D412F55562351219D4B55EDA8D0183"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("211"),_T("011287B0EB965E0AB995996E463D8C21"),_T("013FC028BB33B3987DA4AFECE7BE836D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("212"),_T("019AF0457038CA90921962EA4FC4B12E"),_T("01A382427977006432BFC0A0D6DA182A"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("213"),_T("0146CDA3DB8EC26BCE23148D2FADA063"),_T("01F30BEDB60E5F3669F59D7198D45EF9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("214"),_T("010126E4E8112C268A97D40B8421A0C9"),_T("0144BF7E909DF76D25EF67B16728CA4C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("215"),_T("01A497218747EFBF5FFCFF4C61845DA9"),_T("01F32A37604FDB29829BF69982A68AE2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("216"),_T("013AE04D42C99D1D5008EE57142DBC9D"),_T("018631FAEAEA70CD642BEC283EE4F3EB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("217"),_T("013A9C3C0ADA3BA6B2B4CB88B152E09E"),_T("016E7F3413FB9588D354D13AEB0A88AD"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("218"),_T("0107C3298B9AB5BA68FC43789937CA16"),_T("01595DD440ACA9FFBAE70759814218FE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("219"),_T("01255F0C43AB1B5464BF2D833BF27787"),_T("01CE214CC2913402217CD79EF7584985"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("220"),_T("015CF4D420F0E3D87331EE66BB41BE9A"),_T("01798F13B32C295E3E39B49BE584AC9B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("221"),_T("01661CB22D78899647C86A9D9F92CAD7"),_T("01F5EDAE84DC99823D86B5496ABC2A79"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("222"),_T("0154F14EB75877AFB568497E7FC7CCBB"),_T("01775B723C027C05DFD6DD71017D515D"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("223"),_T("01A64EA770E38F02927517A018E54FD2"),_T("01E35A7F2F1DF754D0CECA1ABAEADFA8"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("224"),_T("013B1972A84DA747D33289E5ACFBAE77"),_T("01F23FE5D6A15F805E18CF9CC2DDBF71"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("225"),_T("01A42CDA1EB0DB0234D37F0D06214861"),_T("01AAF044D3BC677F6804DCC38090AB74"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("226"),_T("0187F687E7CFC90BD8518C964C538F2D"),_T("01CD907285C824C02EB4FB7311A43889"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("227"),_T("015BA337FFF960BFCC41C15D995361C5"),_T("0182C745E667724C80A4080E3517307E"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("228"),_T("01A588522161B622C80027D364E2CE91"),_T("01C8E41883DC5F8DD639B824267F6991"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("229"),_T("010158703CBDC2502B5F7FFE72014C50"),_T("01FC0EBBCF963C663F27D830FAD042C3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("230"),_T("015E6B81C8409882B2B0D546DA93CB7E"),_T("018BCD69EEBE6987253212436A43A262"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("231"),_T("014685AD0F428DFE382F2DED801DD446"),_T("01B5F5CC8F2DF2C2356B0AB8506BA6FC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("232"),_T("012EE742281152FB69DA4BCDB7E48228"),_T("0143EE9337F64E88CF82F85CEED491AC"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("233"),_T("01C037C9626C78E998AE4A0C077217B4"),_T("01FFFFFE13DC2E4FBA0E232166BA0A2B"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("234"),_T("0173E7F4C05E1BDE13591D1A70547F58"),_T("01B88AEF44B633912FF522A2283D92DF"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("235"),_T("01B61EED62EA03D8DDAA0BC17C02BE15"),_T("01EACC9E71FD3C7BD4B96A5C4BD54B46"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("236"),_T("012D45681EF3306674FCA37F12F89280"),_T("01E59B28E1D5C5FDF1FD1EA9DDFD7B3C"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("237"),_T("01EDD0CA4BA6DC4C0086DA4297C3D865"),_T("01F0EA54DC032CE660E74B8B5240F99F"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("238"),_T("0104D37DA3235B719B234B623476B037"),_T("01AE3AF247D1AD117B64AE6FCAFAD4B8"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("239"),_T("015C70BD35420A1F830D4D991B916AEC"),_T("01DBE0E8ED24D6CE2AC474056129AC53"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("240"),_T("010288A3B93D05F58058450F28B9B6F4"),_T("01AAD89E1E172FC5A7D0ED619A260BCB"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("241"),_T("01C5ADB0AE807AE5A5330F1B229B433D"),_T("01FE51092BF5C41E7BAE4B17CED51713"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("242"),_T("010A17DD2B09E7A3623A8EEF835719E0"),_T("0179D27DDEB67C90D4DA618597354EAE"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("243"),_T("01781D7E083EB7FBE29D1AF750DA5D49"),_T("017F6AA3C29782B775EDE527ABE44CE3"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("244"),_T("016E16E7BEFFAFB5B36269859A28A697"),_T("01F826EEA44BE8B3A36F0D87F2842411"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("245"),_T("0127825DA69B73164498FDFAD3FFA42B"),_T("0170AB98468291247AC14A209FC73661"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("246"),_T("019EB8A2E48C4E5B629E3E1DA7A9DF90"),_T("01E3299F5B80CC928C920D8D5A524D33"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("247"),_T("011A20E9C62F1E0CF16816969601A633"),_T("01C1D36F16C9F16B49417F0E94E74875"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("248"),_T("0179116263EC482BA2A2614BAC024ACA"),_T("018A306477F9B53A684F317173580B77"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("249"),_T("0103612119DE6616AB89AF4AD81AE337"),_T("016E47B08C6C290EE22B52F2B7154041"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("250-251"),_T("0196F2BCA047EAD712F1E724146172C2"),_T("0199D6A2E65FCBEB7FC729FFBD7733F1"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("252"),_T("01BB7F7FDBEFFD8B50C4581EE95632F8"),_T("01F4581774AF48A7CE129726B80159E9"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("253"),_T("016C9B02F44E7FD2F1FE9FBD8ACC158E"),_T("01C6BCF73B3325EAF95402536045B239"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("254"),_T("01010A5F7A0EE7B384B71F416DE97A7D"),_T("01318A9A5A7B2E880424831584BDD5E2"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("LEAD Technologies Inc"),_T(""),_T("255"),_T("01188DD39C08F3C6857DFBB1B7DEE0AA"),_T("019B1D02367E98B7B6C2C8C1878E8C86"),_T(""),_T(""),_T("LEAD Technologies Inc")},
{ ENUM_EDITOR_SW, _T("Matlab"),_T(""),_T("75"),_T("019C6C4CB99521A5680C96B0EE999485"),_T("01C8ADEC252DAF2DD41A3F13A6B26952"),_T(""),_T("Matlab"),_T("Matlab")},
{ ENUM_EDITOR_SW, _T("MS Office Pic Mgr"),_T(""),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T(""),_T("MS Office Pic Mgr")},
{ ENUM_EDITOR_SW, _T("MS Paint"),_T(""),_T(""),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("MS Paint")},
{ ENUM_EDITOR_SW, _T("MS Visio"),_T(""),_T(""),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("MS Visio")},
{ ENUM_EDITOR_SW, _T("MS Windows Photo Gallery"),_T(""),_T(""),_T("01C6138A3E892EC7CD6F55F578FDD086"),_T("01F86317ECF8E38342C13A63423ADFDB"),_T(""),_T("Microsoft Windows Photo Gallery"),_T("MS Windows Photo Gallery")},
{ ENUM_EDITOR_SW, _T("Nikon Scan"),_T(""),_T("Excellent Quality"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T("Nikon Scan"),_T("Nikon Scan")},
{ ENUM_EDITOR_SW, _T("Paint Shop Pro"),_T(""),_T(""),_T("0198C5EAC1FD06F70494FC588808EA60"),_T("01EE638764A3ACF4F505DF2864906AC9"),_T(""),_T("Paint Shop Pro"),_T("Paint Shop Pro")},
{ ENUM_EDITOR_SW, _T("Paint.NET"),_T(""),_T("050"),_T("0133FC69E52E74319F110B4486B8B0D8"),_T("017FEB124293E03634B25E85B537A2E9"),_T(""),_T("Paint.NET"),_T("Paint.NET")},
{ ENUM_EDITOR_SW, _T("Picasa"),_T(""),_T("065 (Minimum)"),_T("0139091A8EB09D2E5B08BF57DA89136A"),_T("01FD829AFC9398AA4692176577CC045B"),_T(""),_T("Picasa"),_T("Picasa")},
{ ENUM_EDITOR_SW, _T("Picasa"),_T(""),_T("085 (Normal)"),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T(""),_T("Picasa"),_T("Picasa")},
{ ENUM_EDITOR_SW, _T("Picasa"),_T(""),_T("100 (Maximum)"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T("Picasa"),_T("Picasa")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("01-02"),_T("014FC9D32AB50D2E78A55796DA2CBEC6"),_T("014FC9D32AB50D2E78A55796DA2CBEC6"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("03"),_T("013B7D3CA9CB31130CA7139D25B7A8A4"),_T("014969EC6B9209AB4F927921A5888DEC"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("04"),_T("0106F0377342CFA5A3143FF45CD28994"),_T("015A029AAD57B7CF8B62685C6013B390"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("05"),_T("013DFD2C7376334D7E79543CDAAC4910"),_T("0168601A9309B12FF6663D1F0136AFED"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("06"),_T("0175BBCB841A26513150597603D62BF6"),_T("01E523DD30A14718A8953D0C5612B3EB"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("07"),_T("01134024651373C4D6D52691F50D6586"),_T("01556DD156C6B8656EDE632E14B091E7"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("08"),_T("01031D5074818334ABA6C355F5560090"),_T("0134BF791F72302FF2B4E1AB17C648D0"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("09"),_T("012B194EE141D44DAB6B42D3CF93CAD1"),_T("01D95481ACA60A50D2B8C5085BC83312"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("10"),_T("01C79DA0631E8F88841CDA26F6094C3D"),_T("01DB3970B526B734EA8EE2C65A70AE0F"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("11"),_T("01CE5B6AC816554311EED0F18B9B7B44"),_T("01EC62868B595D0C25ED770649D1280C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("12"),_T("015EA76216925F6290C9E5D53D3969FA"),_T("01D81968C245475537CA4224A630C63D"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("13"),_T("012E28D014C5944E3724F593D5124973"),_T("01678B2664F0FCA111021154313AAF00"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("14"),_T("01406236F6F26D47D8F8C9E90F56FF27"),_T("018353E30DB3225FAF549B62C74EA23E"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("15"),_T("0196D68851992632D8AFBC72A97C02CE"),_T("01A286D2DBF8E54AC7AF60EA475D8C18"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("16"),_T("014F8A218A85D2867A1915A25F21403C"),_T("018BAC2514EAA8FFA6EDDACF71A53463"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("17"),_T("018199F91BFAFFAE0512D079EE507FC9"),_T("01DA8188C92117746BB7C34FD21088EE"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("18"),_T("01AD8CC7B0BEA52AA46695E00836D283"),_T("01C30D636777D304332C9E7D4DA6774C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("19"),_T("0176C54DD01B825DB07AC652FDB58481"),_T("018A25EDFEBEEC4C1F13F85B0AC1FA91"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("20"),_T("01481C9AD7F23611A304A703A06EE9BC"),_T("01FC2ECF39D66CBC7D8E03447C7084C5"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("21"),_T("010FF14E5BDE6B9935D34EF0059DEB80"),_T("013BBBB068DF184D7E914EC1D0672958"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("22"),_T("016943FBC2A3BDF1386CDF1466A64854"),_T("01D79F265CED6CFD247F77FCCA968B13"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("23"),_T("016AC4AAB8FB52EF9543CF9DF32C0B04"),_T("01AC672449D5493D950D03AE8BA9F139"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("24"),_T("01BE458C95B49B42A6D67B928462CD83"),_T("01EF33F114A7BE4AB5A1746B36EEF7AB"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("25"),_T("013C67C96F075EDC35E17465A7C5CD78"),_T("01FA8C758837FA7911AD460B42B2384C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("26"),_T("014802F109EFC228031D3217A9E114AD"),_T("01C527DE13328C300574C033048946BD"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("27"),_T("0146FBA7A23D57869F711A19F742AFD5"),_T("018AC27D2F6543212645814BA65E3C46"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("28"),_T("016BF7C2A3A5AFF828BBE8F19656DB36"),_T("01757BFFF1D76B9945B8C69814064267"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("29"),_T("0177F0948D0988BDD99B6D282498F7AC"),_T("01A3C305AE69B5EDB57D0A3D10584170"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("30"),_T("015C0F02DB07641172802B72A8A8ADE5"),_T("0166BECC9447792D7865590A4C22013C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("31"),_T("016EBF81B56DFED63B29607AD297F144"),_T("01C1479CA8401A0BC01F0FF8982A5F0E"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("32"),_T("010068DC8ED499DA2B7E7FC64AE69DE6"),_T("016E4E591440BD5EC00EA595295E8C09"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("33"),_T("017476AB316DA91A21832475A2201E6E"),_T("01D20D87FB61F87434F81EAAD953E615"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("34"),_T("01653199EACFE67EC85007845F9C594A"),_T("01EF4DF707B0E636502496C3742DA65F"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("35"),_T("015A74BACF3E03F8CFC7A5A8B6210945"),_T("01A1995ABC25A1DB4A7E0DD89ACA09CA"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("36"),_T("017B2235BAD77C7750DAFB57D6BB8B1E"),_T("01D954326D446FC53B6CA18688ECBC45"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("37"),_T("0128F93C4708384183AFC1455E285628"),_T("0129DE2A443CF44E76BCDDCE66FD45F1"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("38"),_T("01177B26BF1D2E7CEF9DC415E5CFEF2F"),_T("013CBF347EEF13561018AD28B7FD11CF"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("39"),_T("016CCC82267AF456EEEEC62A048E61E9"),_T("018FA3C125BF76156C39EF16D5FA403D"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("40"),_T("017791019EA30BF0AF439F2E01DBF795"),_T("0198AECAF49D80A7704AE1E61B4285E1"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("41"),_T("0128EB73EA061E4143110E0DDB2D5086"),_T("018E1C45D953E59A7F3A2173134A831B"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("42"),_T("0112464E22EA96E1FA24B4108D94490A"),_T("01A657E6F9DD5DC6EC526EACAD4CF981"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("43"),_T("0103E99FFBF410A1F5F80144C1AC8976"),_T("01EDA600FE79E9EE3F1803B85DFC709D"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("44"),_T("0104555079C4CF6202C7D6FEC9FDCCCD"),_T("01BA2F06B3F98DA4CA9FCE843A463ACF"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("45"),_T("0128BC847341313AD2A08BD6666476AE"),_T("015229DAB8A23610BA0A6D2C7C4D8D3A"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("46"),_T("01A78B98E2DE6C68D64137A136C0E9FF"),_T("01DE6B69C756C0EED2FD0BC17F6F73F2"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("47"),_T("01AE68DDDCA0196DCE436DEB1B9F9F55"),_T("01FD082F93AFC83E35DD27E55DC5DEB8"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("48"),_T("018030F65F41018A1EF44D2B74D1BB46"),_T("01B4BFFD8A1ACDE587DC39E5D8D7BA72"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("49"),_T("0101F557FB8C1C6C7123D97611884BC0"),_T("016BD88BC1A3A973FEC2E9130CED025E"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("50"),_T("018F43D8975ECD7B1A5BCAE44908FC68"),_T("01E8F427C47F9BAAF87A0DC3F1417759"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("51"),_T("0163ABC310674EBF8008372F0519C06E"),_T("019F6C9A1AFAECF5B25451304135A7D6"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("52"),_T("016F22947C74E50976B8F269F1729522"),_T("01A7A98CF7792A01D4A9E0F2D7534D97"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("53"),_T("014A9CB34479FB4A6CB53D671AF8F591"),_T("01ECEA3248E5614D47154A5F7811C869"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("54"),_T("018652B3DAD29F910C60328D324DA00E"),_T("01D00CE104DE38D0C2D2E11FA40D1B65"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("55"),_T("01065DAFCEA1DA071991649F1395E4AE"),_T("01744013B24B70E6CD252884F1683D7D"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("56"),_T("0139F277F697F731DD23793026C6AFF7"),_T("01D96E2E7C00D75C074CCD1049CA8E0F"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("57"),_T("012A186EBDF5C89419616B0D2EAAD5F3"),_T("01844D8B71E242CA8C88D6B30EF493C8"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("58"),_T("012E25DEC73667282FE995A2480F3898"),_T("01A2370EF178FFDFCBB099B836A2A9C6"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("59"),_T("01331C3A2F6F1EE69C2680DE11339FFB"),_T("01A1198E53AC4E466134CCE3BB932EA7"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("60"),_T("01C4C8F52D63C2600019D3389DB29248"),_T("01F1AC2B0A274B9BA11F22DEF5FD08F4"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("61"),_T("011136E78D87BB3CBB07B86C5389CC86"),_T("01B23F2BA3D9EEE6AC1E1C14A11AE93F"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("62"),_T("012DC58305C26A0605CE4624F5EC79A7"),_T("01B5C303E87AA0D13CC289B9E9F50779"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("63"),_T("0126FE4F83EC4002AB986D8FF233C3A6"),_T("0170FB005850265D208B40F54248E3A9"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("64"),_T("01672E8C86836203704D51FFDDF8D229"),_T("017509677D6681D926CD6FC7E7CEF27C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("65"),_T("011839BC9F708E7C1780C99F7DA52AA6"),_T("016C1CFC7BB403C79DF0E3C14C348609"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("66"),_T("0152F13FCD2990EF7DC3C457AE14F6CD"),_T("0167EAFD58DB869351761D7AF42D3376"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("67"),_T("0100FC284EC4398EE30E1FA6C893B717"),_T("0154EE10CFE4FEB99F262AD41571CA07"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("68"),_T("0165D09DE19E8DE361ACB1D46D398A34"),_T("01811AC4E5252B14A65E5E221EC9267C"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("69"),_T("016EDFB389F79A837E2EB91DD26CECEB"),_T("01761256820BF8C1F26BD9AFEF56DE4E"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("70"),_T("018A66F4CAB0C46AC4B9AA6DBE4C9208"),_T("01A88A93A3529C7ECAA3176280FEE0D2"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("The JPEG Wizard2"),_T(""),_T("71"),_T("0103AEB2D5B835F3E556862994F777F3"),_T("01F59933CC03EBFE4CCAF43C60980CBE"),_T(""),_T(""),_T("The JPEG Wizard2")},
{ ENUM_EDITOR_SW, _T("ZoomBrowser EX"),_T(""),_T("high"),_T("013BA18D5561625796E986FDBC09F846"),_T("01AC57E12793DFA7C46C704625C5AF0F"),_T(""),_T(""),_T("ZoomBrowser EX")},
{ ENUM_EDITOR_SW, _T("ZoomBrowser EX"),_T(""),_T("highest"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T(""),_T(""),_T("ZoomBrowser EX")},
{ ENUM_EDITOR_SW, _T("ZoomBrowser EX"),_T(""),_T("low"),_T("012D821C6AB210E2A753BE053B8F55D0"),_T("0182408A81A4ABF04D4A34A8A5E98C58"),_T(""),_T(""),_T("ZoomBrowser EX")},
{ ENUM_EDITOR_SW, _T("ZoomBrowser EX"),_T(""),_T("medium"),_T("0155D875C95B74D0F3C5835A62516F48"),_T("01D38A25358EB7649A254E19F1D46600"),_T(""),_T(""),_T("ZoomBrowser EX")},



	{ ENUM_EDITOR_SW, _T(""),_T(""),_T(""),_T("01BBB1709AC9C1F89220D955A31A8F34"),_T("zsig"),_T(""),_T(""),_T("EOS Viewer Utility")},

	// Other software strings to look for (known software), without trying to
	// match particular signature.
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Capture NX"),_T("Nikon Capture NX")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("DiMAGE Master"),_T("DiMAGE Master")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("FUJIFILM RAW FILE CONVERTER"),_T("FUJIFILM RAW FILE CONVERTER")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Image Compressor"),_T("Image Compressor")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Image Data Converter SR"),_T("Sony Image Data Converter")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("KODAK PROFESSIONAL DCS Photo Desk"),_T("KODAK PROFESSIONAL DCS Photo Desk")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Microsoft Windows Live Photo Gallery"),_T("MS Windows Live Photo Gallery")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Nero PhotoSnap"),_T("Nero PhotoSnap")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Nikon Capture Editor"),_T("Nikon Capture Editor")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Nikon Scan"),_T("Nikon Scan")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Nikon Transfer"),_T("Nikon Transfer")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("OLYMPUS Studio"),_T("OLYMPUS Studio")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("PENTAX PHOTO Laboratory"),_T("PENTAX PHOTO Laboratory")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("PENTAX PHOTO Browser"),_T("PENTAX PHOTO Browser")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("PictureProject"),_T("PictureProject")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("QuickTime"),_T("QuickTime")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("Roxio PhotoSuite"),_T("Roxio PhotoSuite")},
	{ ENUM_EDITOR_SW, _T(""),_T(""),_T("zqual"),_T("zsig"),_T("zsig"),_T(""),_T("ViewNX"),_T("ViewNX")},


	// Unknown:
	//  - COACHWare 1.0
	//  - CAM ZE15
	//  - adoWKS15
	//  - Digital Lab System	(Seen in Kodak printing lab)
	//  - DVWare 1.0			(Seen in AIPTEK DV 6800)
	//  - IRSDK

	{ ENUM_EDITOR_UNSET, _T("*"),_T(""),_T(""),_T(""),_T(""),_T(""),_T(""),_T("")}
};


// -------------------------------------------------------------------
// Signature database sample exceptions
// -------------------------------------------------------------------

// Exceptions of make/model digicams/phones that don't
// generally have makernotes present
const CompExcMm CDbSigs::m_sExcMmNoMkrList[] = {
	{_T("Apple"),				_T("iPhone")},				// ? always the case?
	{_T("CoreLogic"),			_T("SAMSUNG")},				// strUmQual=swSamsung SGH-E900
	{_T("HTC"),					_T("Hermes")},				// strUmQual=T-Mobile MDA Vario II (a.k.a HTC Hermes)
	{_T("MOTOROLA"),			_T("")},					// model=RAZRV3x
	{_T("Nokia"),				_T("")},					// model=5200
	{_T("???"),					_T("Treo*")},				// model=Treo 680
	{_T("Research In Motion"),	_T("")},					// model=BlackBerry 9000 (=Blackberry Bold)
	{_T("RIM"),					_T("")},					// model=BlackBerry 8100 (=Blackberry Pearl)
	{_T("Sony Ericsson"),		_T("")},					// model=K750i
	{_T("SONY"),				_T("DIGITALMAVICA")},
	{_T("SONY"),				_T("CYBERSHOT")},
	{_T("SONY"),				_T("CYBERSHOT U")},
	{_T("SONY"),				_T("MAVICA")},
	{_T("SONY ERICSSON"),		_T("")},					// model=SONY ERICSSON P990i
	{_T("Vivitar"),				_T("")},					// model=ViviCam3746
	{_T("*"),					_T("")},
};


// Make/models that are known "edited"
const CompExcMm CDbSigs::m_sExcMmIsEditList[] = {
	{_T("Noritsu"),						_T("")},				// Lab
	{_T("Mercury Peripherals Inc."),	_T("DigitalCam Pro")},	// Scanner driver
	{_T("*"),							_T("")},
};

// TODO:
// - Also consider: Palm Treo 600, 650, 680, 700, Apple iPhone

