// JPEGsnoop - JPEG Image Decoder & Analysis Utility
// Copyright (C) 2017 - Calvin Hass
// http://www.impulseadventure.com/photo/jpeg-snoop.html
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#include "stdafx.h"

#include "DecodeDicom.h"


// ===============================================================================
// CONSTANTS
// ===============================================================================


// File Meta Elements
struct tsDicomTag asDicomTags[] =
{
// Part 10, Section 7.1
{ 0x0002,0x0000,DICOM_T_TYPE1, _T("File Meta Information Group Length") },
{ 0x0002,0x0001,DICOM_T_TYPE1, _T("File Meta Information Version") },
{ 0x0002,0x0002,DICOM_T_TYPE1, _T("Media Storage SOP Class UID") },
{ 0x0002,0x0003,DICOM_T_TYPE1, _T("Media Storage SOP Instance UID") },
{ 0x0002,0x0010,DICOM_T_TYPE1, _T("Transfer Syntax UID") },
{ 0x0002,0x0012,DICOM_T_TYPE1, _T("Implementation Class UID") },
{ 0x0002,0x0013,DICOM_T_TYPE3, _T("Implementation Version Name") },
{ 0x0002,0x0016,DICOM_T_TYPE3, _T("Source Application Entity Title") },
{ 0x0002,0x0100,DICOM_T_TYPE3, _T("Private Information Creator UID") },
{ 0x0002,0x0102,DICOM_T_TYPE1C,_T("Private Information") },
	
	// Part 6, Section 6
{ 0x0008,0x0001,DICOM_T_UNK,   _T("Length to End") },
{ 0x0008,0x0005,DICOM_T_UNK,   _T("Specific Character Set") },
{ 0x0008,0x0006,DICOM_T_UNK,   _T("Language Code Sequence") },
{ 0x0008,0x0008,DICOM_T_UNK,   _T("Image Type") },
{ 0x0008,0x0010,DICOM_T_UNK,   _T("Recognition Code") },
{ 0x0008,0x0012,DICOM_T_UNK,   _T("Instance Creation Date") },
{ 0x0008,0x0013,DICOM_T_UNK,   _T("Instance Creation Time") },
{ 0x0008,0x0014,DICOM_T_UNK,   _T("Instance Creator UID") },
{ 0x0008,0x0015,DICOM_T_UNK,   _T("Instance Coercion DateTime") },
{ 0x0008,0x0016,DICOM_T_UNK,   _T("SOP Class UID") },
{ 0x0008,0x0018,DICOM_T_UNK,   _T("SOP Instance UID") },
{ 0x0008,0x001A,DICOM_T_UNK,   _T("Related General SOP Class UID") },
{ 0x0008,0x001B,DICOM_T_UNK,   _T("Original Specialized SOP Class UID") },
{ 0x0008,0x0020,DICOM_T_UNK,   _T("Study Date") },
{ 0x0008,0x0021,DICOM_T_UNK,   _T("Series Date") },
{ 0x0008,0x0022,DICOM_T_UNK,   _T("Acquisition Date") },
{ 0x0008,0x0023,DICOM_T_UNK,   _T("Content Date") },
{ 0x0008,0x0024,DICOM_T_UNK,   _T("Overlay Date") },
{ 0x0008,0x0025,DICOM_T_UNK,   _T("Curve Date") },
{ 0x0008,0x002A,DICOM_T_UNK,   _T("Acquisition DateTime") },
{ 0x0008,0x0030,DICOM_T_UNK,   _T("Study Time") },
{ 0x0008,0x0031,DICOM_T_UNK,   _T("Series Time") },
{ 0x0008,0x0032,DICOM_T_UNK,   _T("Acquisition Time") },
{ 0x0008,0x0033,DICOM_T_UNK,   _T("Content Time") },
{ 0x0008,0x0034,DICOM_T_UNK,   _T("Overlay Time") },
{ 0x0008,0x0035,DICOM_T_UNK,   _T("Curve Time") },
{ 0x0008,0x0040,DICOM_T_UNK,   _T("Data Set Type") },
{ 0x0008,0x0041,DICOM_T_UNK,   _T("Data Set Subtype") },
{ 0x0008,0x0042,DICOM_T_UNK,   _T("Nuclear Medicine Series Type") },
{ 0x0008,0x0050,DICOM_T_UNK,   _T("Accession Number") },
{ 0x0008,0x0051,DICOM_T_UNK,   _T("Issuer of Accession Number Sequence") },
{ 0x0008,0x0052,DICOM_T_UNK,   _T("Query/Retrieve Level") },
{ 0x0008,0x0053,DICOM_T_UNK,   _T("Query/Retrieve View") },
{ 0x0008,0x0054,DICOM_T_UNK,   _T("Retrieve AE Title") },
{ 0x0008,0x0056,DICOM_T_UNK,   _T("Instance Availability") },
{ 0x0008,0x0058,DICOM_T_UNK,   _T("Failed SOP Instance UID List") },
{ 0x0008,0x0060,DICOM_T_UNK,   _T("Modality") },
{ 0x0008,0x0061,DICOM_T_UNK,   _T("Modalities in Study") },
{ 0x0008,0x0062,DICOM_T_UNK,   _T("SOP Classes in Study") },
{ 0x0008,0x0064,DICOM_T_UNK,   _T("Conversion Type") },
{ 0x0008,0x0068,DICOM_T_UNK,   _T("Presentation Intent Type") },
{ 0x0008,0x0070,DICOM_T_UNK,   _T("Manufacturer") },
{ 0x0008,0x0080,DICOM_T_UNK,   _T("Institution Name") },
{ 0x0008,0x0081,DICOM_T_UNK,   _T("Institution Address") },
{ 0x0008,0x0082,DICOM_T_UNK,   _T("Institution Code Sequence") },
{ 0x0008,0x0090,DICOM_T_UNK,   _T("Referring Physician's Name") },
{ 0x0008,0x0092,DICOM_T_UNK,   _T("Referring Physician's Address") },
{ 0x0008,0x0094,DICOM_T_UNK,   _T("Referring Physician's Telephone Numbers") },
{ 0x0008,0x0096,DICOM_T_UNK,   _T("Referring Physician Identification Sequence") },
{ 0x0008,0x0100,DICOM_T_UNK,   _T("Code Value") },
{ 0x0008,0x0101,DICOM_T_UNK,   _T("Extended Code Value") },
{ 0x0008,0x0102,DICOM_T_UNK,   _T("Coding Scheme Designator") },
{ 0x0008,0x0103,DICOM_T_UNK,   _T("Coding Scheme Version") },
{ 0x0008,0x0104,DICOM_T_UNK,   _T("Code Meaning") },
{ 0x0008,0x0105,DICOM_T_UNK,   _T("Mapping Resource") },
{ 0x0008,0x0106,DICOM_T_UNK,   _T("Context Group Version") },
{ 0x0008,0x0107,DICOM_T_UNK,   _T("Context Group Local Version") },
{ 0x0008,0x0108,DICOM_T_UNK,   _T("Extended Code Meaning") },
{ 0x0008,0x010B,DICOM_T_UNK,   _T("Context Group Extension Flag") },
{ 0x0008,0x010C,DICOM_T_UNK,   _T("Coding Scheme UID") },
{ 0x0008,0x010D,DICOM_T_UNK,   _T("Context Group Extension Creator UID") },
{ 0x0008,0x010F,DICOM_T_UNK,   _T("Context Identifier") },
{ 0x0008,0x0110,DICOM_T_UNK,   _T("Coding Scheme Identification Sequence") },
{ 0x0008,0x0112,DICOM_T_UNK,   _T("Coding Scheme Registry") },
{ 0x0008,0x0114,DICOM_T_UNK,   _T("Coding Scheme External ID") },
{ 0x0008,0x0115,DICOM_T_UNK,   _T("Coding Scheme Name") },
{ 0x0008,0x0116,DICOM_T_UNK,   _T("Coding Scheme Responsible Organization") },
{ 0x0008,0x0117,DICOM_T_UNK,   _T("Context UID") },
{ 0x0008,0x0201,DICOM_T_UNK,   _T("Timezone Offset From UTC") },
{ 0x0008,0x1000,DICOM_T_UNK,   _T("Network ID") },
{ 0x0008,0x1010,DICOM_T_UNK,   _T("Station Name") },
{ 0x0008,0x1030,DICOM_T_UNK,   _T("Study Description") },
{ 0x0008,0x1032,DICOM_T_UNK,   _T("Procedure Code Sequence") },
{ 0x0008,0x103E,DICOM_T_UNK,   _T("Series Description") },
{ 0x0008,0x103F,DICOM_T_UNK,   _T("Series Description Code Sequence") },
{ 0x0008,0x1040,DICOM_T_UNK,   _T("Institutional Department Name") },
{ 0x0008,0x1048,DICOM_T_UNK,   _T("Physician(s) of Record") },
{ 0x0008,0x1049,DICOM_T_UNK,   _T("Physician(s) of Record Identification Sequence") },
{ 0x0008,0x1050,DICOM_T_UNK,   _T("Performing Physician's Name") },
{ 0x0008,0x1052,DICOM_T_UNK,   _T("Performing Physician Identification Sequence") },
{ 0x0008,0x1060,DICOM_T_UNK,   _T("Name of Physician(s) Reading Study") },
{ 0x0008,0x1062,DICOM_T_UNK,   _T("Physician(s) Reading Study Identification Sequence") },
{ 0x0008,0x1070,DICOM_T_UNK,   _T("Operators' Name") },
{ 0x0008,0x1072,DICOM_T_UNK,   _T("Operator Identification Sequence") },
{ 0x0008,0x1080,DICOM_T_UNK,   _T("Admitting Diagnoses Description") },
{ 0x0008,0x1084,DICOM_T_UNK,   _T("Admitting Diagnoses Code Sequence") },
{ 0x0008,0x1090,DICOM_T_UNK,   _T("Manufacturer's Model Name") },
{ 0x0008,0x1100,DICOM_T_UNK,   _T("Referenced Results Sequence") },
{ 0x0008,0x1110,DICOM_T_UNK,   _T("Referenced Study Sequence") },
{ 0x0008,0x1111,DICOM_T_UNK,   _T("Referenced Performed Procedure Step Sequence") },
{ 0x0008,0x1115,DICOM_T_UNK,   _T("Referenced Series Sequence") },
{ 0x0008,0x1120,DICOM_T_UNK,   _T("Referenced Patient Sequence") },
{ 0x0008,0x1125,DICOM_T_UNK,   _T("Referenced Visit Sequence") },
{ 0x0008,0x1130,DICOM_T_UNK,   _T("Referenced Overlay Sequence") },
{ 0x0008,0x1134,DICOM_T_UNK,   _T("Referenced Stereometric Instance Sequence") },
{ 0x0008,0x113A,DICOM_T_UNK,   _T("Referenced Waveform Sequence") },
{ 0x0008,0x1140,DICOM_T_UNK,   _T("Referenced Image Sequence") },
{ 0x0008,0x1145,DICOM_T_UNK,   _T("Referenced Curve Sequence") },
{ 0x0008,0x114A,DICOM_T_UNK,   _T("Referenced Instance Sequence") },
{ 0x0008,0x114B,DICOM_T_UNK,   _T("Referenced Real World Value Mapping Instance Sequence") },
{ 0x0008,0x1150,DICOM_T_UNK,   _T("Referenced SOP Class UID") },
{ 0x0008,0x1155,DICOM_T_UNK,   _T("Referenced SOP Instance UID") },
{ 0x0008,0x115A,DICOM_T_UNK,   _T("SOP Classes Supported") },
{ 0x0008,0x1160,DICOM_T_UNK,   _T("Referenced Frame Number") },
{ 0x0008,0x1161,DICOM_T_UNK,   _T("Simple Frame List") },
{ 0x0008,0x1162,DICOM_T_UNK,   _T("Calculated Frame List") },
{ 0x0008,0x1163,DICOM_T_UNK,   _T("Time Range") },
{ 0x0008,0x1164,DICOM_T_UNK,   _T("Frame Extraction Sequence") },
{ 0x0008,0x1167,DICOM_T_UNK,   _T("Multi-frame Source SOP Instance UID") },
{ 0x0008,0x1190,DICOM_T_UNK,   _T("Retrieve URL") },
{ 0x0008,0x1195,DICOM_T_UNK,   _T("Transaction UID") },
{ 0x0008,0x1196,DICOM_T_UNK,   _T("Warning Reason") },
{ 0x0008,0x1197,DICOM_T_UNK,   _T("Failure Reason") },
{ 0x0008,0x1198,DICOM_T_UNK,   _T("Failed SOP Sequence") },
{ 0x0008,0x1199,DICOM_T_UNK,   _T("Referenced SOP Sequence") },
{ 0x0008,0x1200,DICOM_T_UNK,   _T("Studies Containing Other Referenced Instances Sequence") },
{ 0x0008,0x1250,DICOM_T_UNK,   _T("Related Series Sequence") },
{ 0x0008,0x2110,DICOM_T_UNK,   _T("Lossy Image Compression (Retired)") },
{ 0x0008,0x2111,DICOM_T_UNK,   _T("Derivation Description") },
{ 0x0008,0x2112,DICOM_T_UNK,   _T("Source Image Sequence") },
{ 0x0008,0x2120,DICOM_T_UNK,   _T("Stage Name") },
{ 0x0008,0x2122,DICOM_T_UNK,   _T("Stage Number") },
{ 0x0008,0x2124,DICOM_T_UNK,   _T("Number of Stages") },
{ 0x0008,0x2127,DICOM_T_UNK,   _T("View Name") },
{ 0x0008,0x2128,DICOM_T_UNK,   _T("View Number") },
{ 0x0008,0x2129,DICOM_T_UNK,   _T("Number of Event Timers") },
{ 0x0008,0x212A,DICOM_T_UNK,   _T("Number of Views in Stage") },
{ 0x0008,0x2130,DICOM_T_UNK,   _T("Event Elapsed Time(s)") },
{ 0x0008,0x2132,DICOM_T_UNK,   _T("Event Timer Name(s)") },
{ 0x0008,0x2133,DICOM_T_UNK,   _T("Event Timer Sequence") },
{ 0x0008,0x2134,DICOM_T_UNK,   _T("Event Time Offset") },
{ 0x0008,0x2135,DICOM_T_UNK,   _T("Event Code Sequence") },
{ 0x0008,0x2142,DICOM_T_UNK,   _T("Start Trim") },
{ 0x0008,0x2143,DICOM_T_UNK,   _T("Stop Trim") },
{ 0x0008,0x2144,DICOM_T_UNK,   _T("Recommended Display Frame Rate") },
{ 0x0008,0x2200,DICOM_T_UNK,   _T("Transducer Position") },
{ 0x0008,0x2204,DICOM_T_UNK,   _T("Transducer Orientation") },
{ 0x0008,0x2208,DICOM_T_UNK,   _T("Anatomic Structure") },
{ 0x0008,0x2218,DICOM_T_UNK,   _T("Anatomic Region Sequence") },
{ 0x0008,0x2220,DICOM_T_UNK,   _T("Anatomic Region Modifier Sequence") },
{ 0x0008,0x2228,DICOM_T_UNK,   _T("Primary Anatomic Structure Sequence") },
{ 0x0008,0x2229,DICOM_T_UNK,   _T("Anatomic Structure, Space or Region Sequence") },
{ 0x0008,0x2230,DICOM_T_UNK,   _T("Primary Anatomic Structure Modifier Sequence") },
{ 0x0008,0x2240,DICOM_T_UNK,   _T("Transducer Position Sequence") },
{ 0x0008,0x2242,DICOM_T_UNK,   _T("Transducer Position Modifier Sequence") },
{ 0x0008,0x2244,DICOM_T_UNK,   _T("Transducer Orientation Sequence") },
{ 0x0008,0x2246,DICOM_T_UNK,   _T("Transducer Orientation Modifier Sequence") },
{ 0x0008,0x2251,DICOM_T_UNK,   _T("Anatomic Structure Space Or Region Code Sequence (Trial)") },
{ 0x0008,0x2253,DICOM_T_UNK,   _T("Anatomic Portal Of Entrance Code Sequence (Trial)") },
{ 0x0008,0x2255,DICOM_T_UNK,   _T("Anatomic Approach Direction Code Sequence (Trial)") },
{ 0x0008,0x2256,DICOM_T_UNK,   _T("Anatomic Perspective Description (Trial)") },
{ 0x0008,0x2257,DICOM_T_UNK,   _T("Anatomic Perspective Code Sequence (Trial)") },
{ 0x0008,0x2258,DICOM_T_UNK,   _T("Anatomic Location Of Examining Instrument Description (Trial)") },
{ 0x0008,0x2259,DICOM_T_UNK,   _T("Anatomic Location Of Examining Instrument Code Sequence (Trial)") },
{ 0x0008,0x225A,DICOM_T_UNK,   _T("Anatomic Structure Space Or Region Modifier Code Sequence (Trial)") },
{ 0x0008,0x225C,DICOM_T_UNK,   _T("On Axis Background Anatomic Structure Code Sequence (Trial)") },
{ 0x0008,0x3001,DICOM_T_UNK,   _T("Alternate Representation Sequence") },
{ 0x0008,0x3010,DICOM_T_UNK,   _T("Irradiation Event UID") },
{ 0x0008,0x3011,DICOM_T_UNK,   _T("Source Irradiation Event Sequence") },
{ 0x0008,0x3012,DICOM_T_UNK,   _T("Radiopharmaceutical Administration Event UID") },
{ 0x0008,0x4000,DICOM_T_UNK,   _T("Identifying Comments") },
{ 0x0008,0x9007,DICOM_T_UNK,   _T("Frame Type") },
{ 0x0008,0x9092,DICOM_T_UNK,   _T("Referenced Image Evidence Sequence") },
{ 0x0008,0x9121,DICOM_T_UNK,   _T("Referenced Raw Data Sequence") },
{ 0x0008,0x9123,DICOM_T_UNK,   _T("Creator-Version UID") },
{ 0x0008,0x9124,DICOM_T_UNK,   _T("Derivation Image Sequence") },
{ 0x0008,0x9154,DICOM_T_UNK,   _T("Source Image Evidence Sequence") },
{ 0x0008,0x9205,DICOM_T_UNK,   _T("Pixel Presentation") },
{ 0x0008,0x9206,DICOM_T_UNK,   _T("Volumetric Properties") },
{ 0x0008,0x9207,DICOM_T_UNK,   _T("Volume Based Calculation Technique") },
{ 0x0008,0x9208,DICOM_T_UNK,   _T("Complex Image Component") },
{ 0x0008,0x9209,DICOM_T_UNK,   _T("Acquisition Contrast") },
{ 0x0008,0x9215,DICOM_T_UNK,   _T("Derivation Code Sequence") },
{ 0x0008,0x9237,DICOM_T_UNK,   _T("Referenced Presentation State Sequence") },
{ 0x0008,0x9410,DICOM_T_UNK,   _T("Referenced Other Plane Sequence") },
{ 0x0008,0x9458,DICOM_T_UNK,   _T("Frame Display Sequence") },
{ 0x0008,0x9459,DICOM_T_UNK,   _T("Recommended Display Frame Rate in Float") },
{ 0x0008,0x9460,DICOM_T_UNK,   _T("Skip Frame Range Flag") },
{ 0x0010,0x0010,DICOM_T_UNK,   _T("Patient's Name") },
{ 0x0010,0x0020,DICOM_T_UNK,   _T("Patient ID") },
{ 0x0010,0x0021,DICOM_T_UNK,   _T("Issuer of Patient ID") },
{ 0x0010,0x0022,DICOM_T_UNK,   _T("Type of Patient ID") },
{ 0x0010,0x0024,DICOM_T_UNK,   _T("Issuer of Patient ID Qualifiers Sequence") },
{ 0x0010,0x0030,DICOM_T_UNK,   _T("Patient's Birth Date") },
{ 0x0010,0x0032,DICOM_T_UNK,   _T("Patient's Birth Time") },
{ 0x0010,0x0040,DICOM_T_UNK,   _T("Patient's Sex") },
{ 0x0010,0x0050,DICOM_T_UNK,   _T("Patient's Insurance Plan Code Sequence") },
{ 0x0010,0x0101,DICOM_T_UNK,   _T("Patient's Primary Language Code Sequence") },
{ 0x0010,0x0102,DICOM_T_UNK,   _T("Patient's Primary Language Modifier Code Sequence") },
{ 0x0010,0x0200,DICOM_T_UNK,   _T("Quality Control Subject") },
{ 0x0010,0x0201,DICOM_T_UNK,   _T("Quality Control Subject Type Code Sequence") },
{ 0x0010,0x1000,DICOM_T_UNK,   _T("Other Patient IDs") },
{ 0x0010,0x1001,DICOM_T_UNK,   _T("Other Patient Names") },
{ 0x0010,0x1002,DICOM_T_UNK,   _T("Other Patient IDs Sequence") },
{ 0x0010,0x1005,DICOM_T_UNK,   _T("Patient's Birth Name") },
{ 0x0010,0x1010,DICOM_T_UNK,   _T("Patient's Age") },
{ 0x0010,0x1020,DICOM_T_UNK,   _T("Patient's Size") },
{ 0x0010,0x1021,DICOM_T_UNK,   _T("Patient's Size Code Sequence") },
{ 0x0010,0x1030,DICOM_T_UNK,   _T("Patient's Weight") },
{ 0x0010,0x1040,DICOM_T_UNK,   _T("Patient's Address") },
{ 0x0010,0x1050,DICOM_T_UNK,   _T("Insurance Plan Identification") },
{ 0x0010,0x1060,DICOM_T_UNK,   _T("Patient's Mother's Birth Name") },
{ 0x0010,0x1080,DICOM_T_UNK,   _T("Military Rank") },
{ 0x0010,0x1081,DICOM_T_UNK,   _T("Branch of Service") },
{ 0x0010,0x1090,DICOM_T_UNK,   _T("Medical Record Locator") },
{ 0x0010,0x1100,DICOM_T_UNK,   _T("Referenced Patient Photo Sequence") },
{ 0x0010,0x2000,DICOM_T_UNK,   _T("Medical Alerts") },
{ 0x0010,0x2110,DICOM_T_UNK,   _T("Allergies") },
{ 0x0010,0x2150,DICOM_T_UNK,   _T("Country of Residence") },
{ 0x0010,0x2152,DICOM_T_UNK,   _T("Region of Residence") },
{ 0x0010,0x2154,DICOM_T_UNK,   _T("Patient's Telephone Numbers") },
{ 0x0010,0x2160,DICOM_T_UNK,   _T("Ethnic Group") },
{ 0x0010,0x2180,DICOM_T_UNK,   _T("Occupation") },
{ 0x0010,0x21A0,DICOM_T_UNK,   _T("Smoking Status") },
{ 0x0010,0x21B0,DICOM_T_UNK,   _T("Additional Patient History") },
{ 0x0010,0x21C0,DICOM_T_UNK,   _T("Pregnancy Status") },
{ 0x0010,0x21D0,DICOM_T_UNK,   _T("Last Menstrual Date") },
{ 0x0010,0x21F0,DICOM_T_UNK,   _T("Patient's Religious Preference") },
{ 0x0010,0x2201,DICOM_T_UNK,   _T("Patient Species Description") },
{ 0x0010,0x2202,DICOM_T_UNK,   _T("Patient Species Code Sequence") },
{ 0x0010,0x2203,DICOM_T_UNK,   _T("Patient's Sex Neutered") },
{ 0x0010,0x2210,DICOM_T_UNK,   _T("Anatomical Orientation Type") },
{ 0x0010,0x2292,DICOM_T_UNK,   _T("Patient Breed Description") },
{ 0x0010,0x2293,DICOM_T_UNK,   _T("Patient Breed Code Sequence") },
{ 0x0010,0x2294,DICOM_T_UNK,   _T("Breed Registration Sequence") },
{ 0x0010,0x2295,DICOM_T_UNK,   _T("Breed Registration Number") },
{ 0x0010,0x2296,DICOM_T_UNK,   _T("Breed Registry Code Sequence") },
{ 0x0010,0x2297,DICOM_T_UNK,   _T("Responsible Person") },
{ 0x0010,0x2298,DICOM_T_UNK,   _T("Responsible Person Role") },
{ 0x0010,0x2299,DICOM_T_UNK,   _T("Responsible Organization") },
{ 0x0010,0x4000,DICOM_T_UNK,   _T("Patient Comments") },
{ 0x0010,0x9431,DICOM_T_UNK,   _T("Examined Body Thickness") },
{ 0x0012,0x0010,DICOM_T_UNK,   _T("Clinical Trial Sponsor Name") },
{ 0x0012,0x0020,DICOM_T_UNK,   _T("Clinical Trial Protocol ID") },
{ 0x0012,0x0021,DICOM_T_UNK,   _T("Clinical Trial Protocol Name") },
{ 0x0012,0x0030,DICOM_T_UNK,   _T("Clinical Trial Site ID") },
{ 0x0012,0x0031,DICOM_T_UNK,   _T("Clinical Trial Site Name") },
{ 0x0012,0x0040,DICOM_T_UNK,   _T("Clinical Trial Subject ID") },
{ 0x0012,0x0042,DICOM_T_UNK,   _T("Clinical Trial Subject Reading ID") },
{ 0x0012,0x0050,DICOM_T_UNK,   _T("Clinical Trial Time Point ID") },
{ 0x0012,0x0051,DICOM_T_UNK,   _T("Clinical Trial Time Point Description") },
{ 0x0012,0x0060,DICOM_T_UNK,   _T("Clinical Trial Coordinating Center Name") },
{ 0x0012,0x0062,DICOM_T_UNK,   _T("Patient Identity Removed") },
{ 0x0012,0x0063,DICOM_T_UNK,   _T("De-identification Method") },
{ 0x0012,0x0064,DICOM_T_UNK,   _T("De-identification Method Code Sequence") },
{ 0x0012,0x0071,DICOM_T_UNK,   _T("Clinical Trial Series ID") },
{ 0x0012,0x0072,DICOM_T_UNK,   _T("Clinical Trial Series Description") },
{ 0x0012,0x0081,DICOM_T_UNK,   _T("Clinical Trial Protocol Ethics Committee Name") },
{ 0x0012,0x0082,DICOM_T_UNK,   _T("Clinical Trial Protocol Ethics Committee Approval Number") },
{ 0x0012,0x0083,DICOM_T_UNK,   _T("Consent for Clinical Trial Use Sequence") },
{ 0x0012,0x0084,DICOM_T_UNK,   _T("Distribution Type") },
{ 0x0012,0x0085,DICOM_T_UNK,   _T("Consent for Distribution Flag") },
{ 0x0014,0x0023,DICOM_T_UNK,   _T("CAD File Format") },
{ 0x0014,0x0024,DICOM_T_UNK,   _T("Component Reference System") },
{ 0x0014,0x0025,DICOM_T_UNK,   _T("Component Manufacturing Procedure") },
{ 0x0014,0x0028,DICOM_T_UNK,   _T("Component Manufacturer") },
{ 0x0014,0x0030,DICOM_T_UNK,   _T("Material Thickness") },
{ 0x0014,0x0032,DICOM_T_UNK,   _T("Material Pipe Diameter") },
{ 0x0014,0x0034,DICOM_T_UNK,   _T("Material Isolation Diameter") },
{ 0x0014,0x0042,DICOM_T_UNK,   _T("Material Grade") },
{ 0x0014,0x0044,DICOM_T_UNK,   _T("Material Properties Description") },
{ 0x0014,0x0045,DICOM_T_UNK,   _T("Material Properties File Format (Retired)") },
{ 0x0014,0x0046,DICOM_T_UNK,   _T("Material Notes") },
{ 0x0014,0x0050,DICOM_T_UNK,   _T("Component Shape") },
{ 0x0014,0x0052,DICOM_T_UNK,   _T("Curvature Type") },
{ 0x0014,0x0054,DICOM_T_UNK,   _T("Outer Diameter") },
{ 0x0014,0x0056,DICOM_T_UNK,   _T("Inner Diameter") },
{ 0x0014,0x1010,DICOM_T_UNK,   _T("Actual Environmental Conditions") },
{ 0x0014,0x1020,DICOM_T_UNK,   _T("Expiry Date") },
{ 0x0014,0x1040,DICOM_T_UNK,   _T("Environmental Conditions") },
{ 0x0014,0x2002,DICOM_T_UNK,   _T("Evaluator Sequence") },
{ 0x0014,0x2004,DICOM_T_UNK,   _T("Evaluator Number") },
{ 0x0014,0x2006,DICOM_T_UNK,   _T("Evaluator Name") },
{ 0x0014,0x2008,DICOM_T_UNK,   _T("Evaluation Attempt") },
{ 0x0014,0x2012,DICOM_T_UNK,   _T("Indication Sequence") },
{ 0x0014,0x2014,DICOM_T_UNK,   _T("Indication Number") },
{ 0x0014,0x2016,DICOM_T_UNK,   _T("Indication Label") },
{ 0x0014,0x2018,DICOM_T_UNK,   _T("Indication Description") },
{ 0x0014,0x201A,DICOM_T_UNK,   _T("Indication Type") },
{ 0x0014,0x201C,DICOM_T_UNK,   _T("Indication Disposition") },
{ 0x0014,0x201E,DICOM_T_UNK,   _T("Indication ROI Sequence") },
{ 0x0014,0x2030,DICOM_T_UNK,   _T("Indication Physical Property Sequence") },
{ 0x0014,0x2032,DICOM_T_UNK,   _T("Property Label") },
{ 0x0014,0x2202,DICOM_T_UNK,   _T("Coordinate System Number of Axes") },
{ 0x0014,0x2204,DICOM_T_UNK,   _T("Coordinate System Axes Sequence") },
{ 0x0014,0x2206,DICOM_T_UNK,   _T("Coordinate System Axis Description") },
{ 0x0014,0x2208,DICOM_T_UNK,   _T("Coordinate System Data Set Mapping") },
{ 0x0014,0x220A,DICOM_T_UNK,   _T("Coordinate System Axis Number") },
{ 0x0014,0x220C,DICOM_T_UNK,   _T("Coordinate System Axis Type") },
{ 0x0014,0x220E,DICOM_T_UNK,   _T("Coordinate System Axis Units") },
{ 0x0014,0x2210,DICOM_T_UNK,   _T("Coordinate System Axis Values") },
{ 0x0014,0x2220,DICOM_T_UNK,   _T("Coordinate System Transform Sequence") },
{ 0x0014,0x2222,DICOM_T_UNK,   _T("Transform Description") },
{ 0x0014,0x2224,DICOM_T_UNK,   _T("Transform Number of Axes") },
{ 0x0014,0x2226,DICOM_T_UNK,   _T("Transform Order of Axes") },
{ 0x0014,0x2228,DICOM_T_UNK,   _T("Transformed Axis Units") },
{ 0x0014,0x222A,DICOM_T_UNK,   _T("Coordinate System Transform Rotation and Scale Matrix") },
{ 0x0014,0x222C,DICOM_T_UNK,   _T("Coordinate System Transform Translation Matrix") },
{ 0x0014,0x3011,DICOM_T_UNK,   _T("Internal Detector Frame Time") },
{ 0x0014,0x3012,DICOM_T_UNK,   _T("Number of Frames Integrated") },
{ 0x0014,0x3020,DICOM_T_UNK,   _T("Detector Temperature Sequence") },
{ 0x0014,0x3022,DICOM_T_UNK,   _T("Sensor Name") },
{ 0x0014,0x3024,DICOM_T_UNK,   _T("Horizontal Offset of Sensor") },
{ 0x0014,0x3026,DICOM_T_UNK,   _T("Vertical Offset of Sensor") },
{ 0x0014,0x3028,DICOM_T_UNK,   _T("Sensor Temperature") },
{ 0x0014,0x3040,DICOM_T_UNK,   _T("Dark Current Sequence") },
{ 0x0014,0x3050,DICOM_T_UNK,   _T("Dark Current Counts") },
{ 0x0014,0x3060,DICOM_T_UNK,   _T("Gain Correction Reference Sequence") },
{ 0x0014,0x3070,DICOM_T_UNK,   _T("Air Counts") },
{ 0x0014,0x3071,DICOM_T_UNK,   _T("KV Used in Gain Calibration") },
{ 0x0014,0x3072,DICOM_T_UNK,   _T("MA Used in Gain Calibration") },
{ 0x0014,0x3073,DICOM_T_UNK,   _T("Number of Frames Used for Integration") },
{ 0x0014,0x3074,DICOM_T_UNK,   _T("Filter Material Used in Gain Calibration") },
{ 0x0014,0x3075,DICOM_T_UNK,   _T("Filter Thickness Used in Gain Calibration") },
{ 0x0014,0x3076,DICOM_T_UNK,   _T("Date of Gain Calibration") },
{ 0x0014,0x3077,DICOM_T_UNK,   _T("Time of Gain Calibration") },
{ 0x0014,0x3080,DICOM_T_UNK,   _T("Bad Pixel Image") },
{ 0x0014,0x3099,DICOM_T_UNK,   _T("Calibration Notes") },
{ 0x0014,0x4002,DICOM_T_UNK,   _T("Pulser Equipment Sequence") },
{ 0x0014,0x4004,DICOM_T_UNK,   _T("Pulser Type") },
{ 0x0014,0x4006,DICOM_T_UNK,   _T("Pulser Notes") },
{ 0x0014,0x4008,DICOM_T_UNK,   _T("Receiver Equipment Sequence") },
{ 0x0014,0x400A,DICOM_T_UNK,   _T("Amplifier Type") },
{ 0x0014,0x400C,DICOM_T_UNK,   _T("Receiver Notes") },
{ 0x0014,0x400E,DICOM_T_UNK,   _T("Pre-Amplifier Equipment Sequence") },
{ 0x0014,0x400F,DICOM_T_UNK,   _T("Pre-Amplifier Notes") },
{ 0x0014,0x4010,DICOM_T_UNK,   _T("Transmit Transducer Sequence") },
{ 0x0014,0x4011,DICOM_T_UNK,   _T("Receive Transducer Sequence") },
{ 0x0014,0x4012,DICOM_T_UNK,   _T("Number of Elements") },
{ 0x0014,0x4013,DICOM_T_UNK,   _T("Element Shape") },
{ 0x0014,0x4014,DICOM_T_UNK,   _T("Element Dimension A") },
{ 0x0014,0x4015,DICOM_T_UNK,   _T("Element Dimension B") },
{ 0x0014,0x4016,DICOM_T_UNK,   _T("Element Pitch A") },
{ 0x0014,0x4017,DICOM_T_UNK,   _T("Measured Beam Dimension A") },
{ 0x0014,0x4018,DICOM_T_UNK,   _T("Measured Beam Dimension B") },
{ 0x0014,0x4019,DICOM_T_UNK,   _T("Location of Measured Beam Diameter") },
{ 0x0014,0x401A,DICOM_T_UNK,   _T("Nominal Frequency") },
{ 0x0014,0x401B,DICOM_T_UNK,   _T("Measured Center Frequency") },
{ 0x0014,0x401C,DICOM_T_UNK,   _T("Measured Bandwidth") },
{ 0x0014,0x401D,DICOM_T_UNK,   _T("Element Pitch B") },
{ 0x0014,0x4020,DICOM_T_UNK,   _T("Pulser Settings Sequence") },
{ 0x0014,0x4022,DICOM_T_UNK,   _T("Pulse Width") },
{ 0x0014,0x4024,DICOM_T_UNK,   _T("Excitation Frequency") },
{ 0x0014,0x4026,DICOM_T_UNK,   _T("Modulation Type") },
{ 0x0014,0x4028,DICOM_T_UNK,   _T("Damping") },
{ 0x0014,0x4030,DICOM_T_UNK,   _T("Receiver Settings Sequence") },
{ 0x0014,0x4031,DICOM_T_UNK,   _T("Acquired Soundpath Length") },
{ 0x0014,0x4032,DICOM_T_UNK,   _T("Acquisition Compression Type") },
{ 0x0014,0x4033,DICOM_T_UNK,   _T("Acquisition Sample Size") },
{ 0x0014,0x4034,DICOM_T_UNK,   _T("Rectifier Smoothing") },
{ 0x0014,0x4035,DICOM_T_UNK,   _T("DAC Sequence") },
{ 0x0014,0x4036,DICOM_T_UNK,   _T("DAC Type") },
{ 0x0014,0x4038,DICOM_T_UNK,   _T("DAC Gain Points") },
{ 0x0014,0x403A,DICOM_T_UNK,   _T("DAC Time Points") },
{ 0x0014,0x403C,DICOM_T_UNK,   _T("DAC Amplitude") },
{ 0x0014,0x4040,DICOM_T_UNK,   _T("Pre-Amplifier Settings Sequence") },
{ 0x0014,0x4050,DICOM_T_UNK,   _T("Transmit Transducer Settings Sequence") },
{ 0x0014,0x4051,DICOM_T_UNK,   _T("Receive Transducer Settings Sequence") },
{ 0x0014,0x4052,DICOM_T_UNK,   _T("Incident Angle") },
{ 0x0014,0x4054,DICOM_T_UNK,   _T("Coupling Technique") },
{ 0x0014,0x4056,DICOM_T_UNK,   _T("Coupling Medium") },
{ 0x0014,0x4057,DICOM_T_UNK,   _T("Coupling Velocity") },
{ 0x0014,0x4058,DICOM_T_UNK,   _T("Probe Center Location X") },
{ 0x0014,0x4059,DICOM_T_UNK,   _T("Probe Center Location Z") },
{ 0x0014,0x405A,DICOM_T_UNK,   _T("Sound Path Length") },
{ 0x0014,0x405C,DICOM_T_UNK,   _T("Delay Law Identifier") },
{ 0x0014,0x4060,DICOM_T_UNK,   _T("Gate Settings Sequence") },
{ 0x0014,0x4062,DICOM_T_UNK,   _T("Gate Threshold") },
{ 0x0014,0x4064,DICOM_T_UNK,   _T("Velocity of Sound") },
{ 0x0014,0x4070,DICOM_T_UNK,   _T("Calibration Settings Sequence") },
{ 0x0014,0x4072,DICOM_T_UNK,   _T("Calibration Procedure") },
{ 0x0014,0x4074,DICOM_T_UNK,   _T("Procedure Version") },
{ 0x0014,0x4076,DICOM_T_UNK,   _T("Procedure Creation Date") },
{ 0x0014,0x4078,DICOM_T_UNK,   _T("Procedure Expiration Date") },
{ 0x0014,0x407A,DICOM_T_UNK,   _T("Procedure Last Modified Date") },
{ 0x0014,0x407C,DICOM_T_UNK,   _T("Calibration Time") },
{ 0x0014,0x407E,DICOM_T_UNK,   _T("Calibration Date") },
{ 0x0014,0x4080,DICOM_T_UNK,   _T("Probe Drive Equipment Sequence") },
{ 0x0014,0x4081,DICOM_T_UNK,   _T("Drive Type") },
{ 0x0014,0x4082,DICOM_T_UNK,   _T("Probe Drive Notes") },
{ 0x0014,0x4083,DICOM_T_UNK,   _T("Drive Probe Sequence") },
{ 0x0014,0x4084,DICOM_T_UNK,   _T("Probe Inductance") },
{ 0x0014,0x4085,DICOM_T_UNK,   _T("Probe Resistance") },
{ 0x0014,0x4086,DICOM_T_UNK,   _T("Receive Probe Sequence") },
{ 0x0014,0x4087,DICOM_T_UNK,   _T("Probe Drive Settings Sequence") },
{ 0x0014,0x4088,DICOM_T_UNK,   _T("Bridge Resistors") },
{ 0x0014,0x4089,DICOM_T_UNK,   _T("Probe Orientation Angle") },
{ 0x0014,0x408B,DICOM_T_UNK,   _T("User Selected Gain Y") },
{ 0x0014,0x408C,DICOM_T_UNK,   _T("User Selected Phase") },
{ 0x0014,0x408D,DICOM_T_UNK,   _T("User Selected Offset X") },
{ 0x0014,0x408E,DICOM_T_UNK,   _T("User Selected Offset Y") },
{ 0x0014,0x4091,DICOM_T_UNK,   _T("Channel Settings Sequence") },
{ 0x0014,0x4092,DICOM_T_UNK,   _T("Channel Threshold") },
{ 0x0014,0x409A,DICOM_T_UNK,   _T("Scanner Settings Sequence") },
{ 0x0014,0x409B,DICOM_T_UNK,   _T("Scan Procedure") },
{ 0x0014,0x409C,DICOM_T_UNK,   _T("Translation Rate X") },
{ 0x0014,0x409D,DICOM_T_UNK,   _T("Translation Rate Y") },
{ 0x0014,0x409F,DICOM_T_UNK,   _T("Channel Overlap") },
{ 0x0014,0x40A0,DICOM_T_UNK,   _T("Image Quality Indicator Type") },
{ 0x0014,0x40A1,DICOM_T_UNK,   _T("Image Quality Indicator Material") },
{ 0x0014,0x40A2,DICOM_T_UNK,   _T("Image Quality Indicator Size") },
{ 0x0014,0x5002,DICOM_T_UNK,   _T("LINAC Energy") },
{ 0x0014,0x5004,DICOM_T_UNK,   _T("LINAC Output") },
{ 0x0018,0x0010,DICOM_T_UNK,   _T("Contrast/Bolus Agent") },
{ 0x0018,0x0012,DICOM_T_UNK,   _T("Contrast/Bolus Agent Sequence") },
{ 0x0018,0x0013,DICOM_T_UNK,   _T("Contrast/Bolus T1 Relaxivity") },
{ 0x0018,0x0014,DICOM_T_UNK,   _T("Contrast/Bolus Administration Route Sequence") },
{ 0x0018,0x0015,DICOM_T_UNK,   _T("Body Part Examined") },
{ 0x0018,0x0020,DICOM_T_UNK,   _T("Scanning Sequence") },
{ 0x0018,0x0021,DICOM_T_UNK,   _T("Sequence Variant") },
{ 0x0018,0x0022,DICOM_T_UNK,   _T("Scan Options") },
{ 0x0018,0x0023,DICOM_T_UNK,   _T("MR Acquisition Type") },
{ 0x0018,0x0024,DICOM_T_UNK,   _T("Sequence Name") },
{ 0x0018,0x0025,DICOM_T_UNK,   _T("Angio Flag") },
{ 0x0018,0x0026,DICOM_T_UNK,   _T("Intervention Drug Information Sequence") },
{ 0x0018,0x0027,DICOM_T_UNK,   _T("Intervention Drug Stop Time") },
{ 0x0018,0x0028,DICOM_T_UNK,   _T("Intervention Drug Dose") },
{ 0x0018,0x0029,DICOM_T_UNK,   _T("Intervention Drug Code Sequence") },
{ 0x0018,0x002A,DICOM_T_UNK,   _T("Additional Drug Sequence") },
{ 0x0018,0x0030,DICOM_T_UNK,   _T("Radionuclide") },
{ 0x0018,0x0031,DICOM_T_UNK,   _T("Radiopharmaceutical") },
{ 0x0018,0x0032,DICOM_T_UNK,   _T("Energy Window Centerline") },
{ 0x0018,0x0033,DICOM_T_UNK,   _T("Energy Window Total Width") },
{ 0x0018,0x0034,DICOM_T_UNK,   _T("Intervention Drug Name") },
{ 0x0018,0x0035,DICOM_T_UNK,   _T("Intervention Drug Start Time") },
{ 0x0018,0x0036,DICOM_T_UNK,   _T("Intervention Sequence") },
{ 0x0018,0x0037,DICOM_T_UNK,   _T("Therapy Type") },
{ 0x0018,0x0038,DICOM_T_UNK,   _T("Intervention Status") },
{ 0x0018,0x0039,DICOM_T_UNK,   _T("Therapy Description") },
{ 0x0018,0x003A,DICOM_T_UNK,   _T("Intervention Description") },
{ 0x0018,0x0040,DICOM_T_UNK,   _T("Cine Rate") },
{ 0x0018,0x0042,DICOM_T_UNK,   _T("Initial Cine Run State") },
{ 0x0018,0x0050,DICOM_T_UNK,   _T("Slice Thickness") },
{ 0x0018,0x0060,DICOM_T_UNK,   _T("KVP") },
{ 0x0018,0x0070,DICOM_T_UNK,   _T("Counts Accumulated") },
{ 0x0018,0x0071,DICOM_T_UNK,   _T("Acquisition Termination Condition") },
{ 0x0018,0x0072,DICOM_T_UNK,   _T("Effective Duration") },
{ 0x0018,0x0073,DICOM_T_UNK,   _T("Acquisition Start Condition") },
{ 0x0018,0x0074,DICOM_T_UNK,   _T("Acquisition Start Condition Data") },
{ 0x0018,0x0075,DICOM_T_UNK,   _T("Acquisition Termination Condition Data") },
{ 0x0018,0x0080,DICOM_T_UNK,   _T("Repetition Time") },
{ 0x0018,0x0081,DICOM_T_UNK,   _T("Echo Time") },
{ 0x0018,0x0082,DICOM_T_UNK,   _T("Inversion Time") },
{ 0x0018,0x0083,DICOM_T_UNK,   _T("Number of Averages") },
{ 0x0018,0x0084,DICOM_T_UNK,   _T("Imaging Frequency") },
{ 0x0018,0x0085,DICOM_T_UNK,   _T("Imaged Nucleus") },
{ 0x0018,0x0086,DICOM_T_UNK,   _T("Echo Number(s)") },
{ 0x0018,0x0087,DICOM_T_UNK,   _T("Magnetic Field Strength") },
{ 0x0018,0x0088,DICOM_T_UNK,   _T("Spacing Between Slices") },
{ 0x0018,0x0089,DICOM_T_UNK,   _T("Number of Phase Encoding Steps") },
{ 0x0018,0x0090,DICOM_T_UNK,   _T("Data Collection Diameter") },
{ 0x0018,0x0091,DICOM_T_UNK,   _T("Echo Train Length") },
{ 0x0018,0x0093,DICOM_T_UNK,   _T("Percent Sampling") },
{ 0x0018,0x0094,DICOM_T_UNK,   _T("Percent Phase Field of View") },
{ 0x0018,0x0095,DICOM_T_UNK,   _T("Pixel Bandwidth") },
{ 0x0018,0x1000,DICOM_T_UNK,   _T("Device Serial Number") },
{ 0x0018,0x1002,DICOM_T_UNK,   _T("Device UID") },
{ 0x0018,0x1003,DICOM_T_UNK,   _T("Device ID") },
{ 0x0018,0x1004,DICOM_T_UNK,   _T("Plate ID") },
{ 0x0018,0x1005,DICOM_T_UNK,   _T("Generator ID") },
{ 0x0018,0x1006,DICOM_T_UNK,   _T("Grid ID") },
{ 0x0018,0x1007,DICOM_T_UNK,   _T("Cassette ID") },
{ 0x0018,0x1008,DICOM_T_UNK,   _T("Gantry ID") },
{ 0x0018,0x1010,DICOM_T_UNK,   _T("Secondary Capture Device ID") },
{ 0x0018,0x1011,DICOM_T_UNK,   _T("Hardcopy Creation Device ID") },
{ 0x0018,0x1012,DICOM_T_UNK,   _T("Date of Secondary Capture") },
{ 0x0018,0x1014,DICOM_T_UNK,   _T("Time of Secondary Capture") },
{ 0x0018,0x1016,DICOM_T_UNK,   _T("Secondary Capture Device Manufacturer") },
{ 0x0018,0x1017,DICOM_T_UNK,   _T("Hardcopy Device Manufacturer") },
{ 0x0018,0x1018,DICOM_T_UNK,   _T("Secondary Capture Device Manufacturer's Model Name") },
{ 0x0018,0x1019,DICOM_T_UNK,   _T("Secondary Capture Device Software Versions") },
{ 0x0018,0x101A,DICOM_T_UNK,   _T("Hardcopy Device Software Version") },
{ 0x0018,0x101B,DICOM_T_UNK,   _T("Hardcopy Device Manufacturer's Model Name") },
{ 0x0018,0x1020,DICOM_T_UNK,   _T("Software Version(s)") },
{ 0x0018,0x1022,DICOM_T_UNK,   _T("Video Image Format Acquired") },
{ 0x0018,0x1023,DICOM_T_UNK,   _T("Digital Image Format Acquired") },
{ 0x0018,0x1030,DICOM_T_UNK,   _T("Protocol Name") },
{ 0x0018,0x1040,DICOM_T_UNK,   _T("Contrast/Bolus Route") },
{ 0x0018,0x1041,DICOM_T_UNK,   _T("Contrast/Bolus Volume") },
{ 0x0018,0x1042,DICOM_T_UNK,   _T("Contrast/Bolus Start Time") },
{ 0x0018,0x1043,DICOM_T_UNK,   _T("Contrast/Bolus Stop Time") },
{ 0x0018,0x1044,DICOM_T_UNK,   _T("Contrast/Bolus Total Dose") },
{ 0x0018,0x1045,DICOM_T_UNK,   _T("Syringe Counts") },
{ 0x0018,0x1046,DICOM_T_UNK,   _T("Contrast Flow Rate") },
{ 0x0018,0x1047,DICOM_T_UNK,   _T("Contrast Flow Duration") },
{ 0x0018,0x1048,DICOM_T_UNK,   _T("Contrast/Bolus Ingredient") },
{ 0x0018,0x1049,DICOM_T_UNK,   _T("Contrast/Bolus Ingredient Concentration") },
{ 0x0018,0x1050,DICOM_T_UNK,   _T("Spatial Resolution") },
{ 0x0018,0x1060,DICOM_T_UNK,   _T("Trigger Time") },
{ 0x0018,0x1061,DICOM_T_UNK,   _T("Trigger Source or Type") },
{ 0x0018,0x1062,DICOM_T_UNK,   _T("Nominal Interval") },
{ 0x0018,0x1063,DICOM_T_UNK,   _T("Frame Time") },
{ 0x0018,0x1064,DICOM_T_UNK,   _T("Cardiac Framing Type") },
{ 0x0018,0x1065,DICOM_T_UNK,   _T("Frame Time Vector") },
{ 0x0018,0x1066,DICOM_T_UNK,   _T("Frame Delay") },
{ 0x0018,0x1067,DICOM_T_UNK,   _T("Image Trigger Delay") },
{ 0x0018,0x1068,DICOM_T_UNK,   _T("Multiplex Group Time Offset") },
{ 0x0018,0x1069,DICOM_T_UNK,   _T("Trigger Time Offset") },
{ 0x0018,0x106A,DICOM_T_UNK,   _T("Synchronization Trigger") },
{ 0x0018,0x106C,DICOM_T_UNK,   _T("Synchronization Channel") },
{ 0x0018,0x106E,DICOM_T_UNK,   _T("Trigger Sample Position") },
{ 0x0018,0x1070,DICOM_T_UNK,   _T("Radiopharmaceutical Route") },
{ 0x0018,0x1071,DICOM_T_UNK,   _T("Radiopharmaceutical Volume") },
{ 0x0018,0x1072,DICOM_T_UNK,   _T("Radiopharmaceutical Start Time") },
{ 0x0018,0x1073,DICOM_T_UNK,   _T("Radiopharmaceutical Stop Time") },
{ 0x0018,0x1074,DICOM_T_UNK,   _T("Radionuclide Total Dose") },
{ 0x0018,0x1075,DICOM_T_UNK,   _T("Radionuclide Half Life") },
{ 0x0018,0x1076,DICOM_T_UNK,   _T("Radionuclide Positron Fraction") },
{ 0x0018,0x1077,DICOM_T_UNK,   _T("Radiopharmaceutical Specific Activity") },
{ 0x0018,0x1078,DICOM_T_UNK,   _T("Radiopharmaceutical Start DateTime") },
{ 0x0018,0x1079,DICOM_T_UNK,   _T("Radiopharmaceutical Stop DateTime") },
{ 0x0018,0x1080,DICOM_T_UNK,   _T("Beat Rejection Flag") },
{ 0x0018,0x1081,DICOM_T_UNK,   _T("Low R-R Value") },
{ 0x0018,0x1082,DICOM_T_UNK,   _T("High R-R Value") },
{ 0x0018,0x1083,DICOM_T_UNK,   _T("Intervals Acquired") },
{ 0x0018,0x1084,DICOM_T_UNK,   _T("Intervals Rejected") },
{ 0x0018,0x1085,DICOM_T_UNK,   _T("PVC Rejection") },
{ 0x0018,0x1086,DICOM_T_UNK,   _T("Skip Beats") },
{ 0x0018,0x1088,DICOM_T_UNK,   _T("Heart Rate") },
{ 0x0018,0x1090,DICOM_T_UNK,   _T("Cardiac Number of Images") },
{ 0x0018,0x1094,DICOM_T_UNK,   _T("Trigger Window") },
{ 0x0018,0x1100,DICOM_T_UNK,   _T("Reconstruction Diameter") },
{ 0x0018,0x1110,DICOM_T_UNK,   _T("Distance Source to Detector") },
{ 0x0018,0x1111,DICOM_T_UNK,   _T("Distance Source to Patient") },
{ 0x0018,0x1114,DICOM_T_UNK,   _T("Estimated Radiographic Magnification Factor") },
{ 0x0018,0x1120,DICOM_T_UNK,   _T("Gantry/Detector Tilt") },
{ 0x0018,0x1121,DICOM_T_UNK,   _T("Gantry/Detector Slew") },
{ 0x0018,0x1130,DICOM_T_UNK,   _T("Table Height") },
{ 0x0018,0x1131,DICOM_T_UNK,   _T("Table Traverse") },
{ 0x0018,0x1134,DICOM_T_UNK,   _T("Table Motion") },
{ 0x0018,0x1135,DICOM_T_UNK,   _T("Table Vertical Increment") },
{ 0x0018,0x1136,DICOM_T_UNK,   _T("Table Lateral Increment") },
{ 0x0018,0x1137,DICOM_T_UNK,   _T("Table Longitudinal Increment") },
{ 0x0018,0x1138,DICOM_T_UNK,   _T("Table Angle") },
{ 0x0018,0x113A,DICOM_T_UNK,   _T("Table Type") },
{ 0x0018,0x1140,DICOM_T_UNK,   _T("Rotation Direction") },
{ 0x0018,0x1141,DICOM_T_UNK,   _T("Angular Position") },
{ 0x0018,0x1142,DICOM_T_UNK,   _T("Radial Position") },
{ 0x0018,0x1143,DICOM_T_UNK,   _T("Scan Arc") },
{ 0x0018,0x1144,DICOM_T_UNK,   _T("Angular Step") },
{ 0x0018,0x1145,DICOM_T_UNK,   _T("Center of Rotation Offset") },
{ 0x0018,0x1146,DICOM_T_UNK,   _T("Rotation Offset") },
{ 0x0018,0x1147,DICOM_T_UNK,   _T("Field of View Shape") },
{ 0x0018,0x1149,DICOM_T_UNK,   _T("Field of View Dimension(s)") },
{ 0x0018,0x1150,DICOM_T_UNK,   _T("Exposure Time") },
{ 0x0018,0x1151,DICOM_T_UNK,   _T("X-Ray Tube Current") },
{ 0x0018,0x1152,DICOM_T_UNK,   _T("Exposure") },
{ 0x0018,0x1153,DICOM_T_UNK,   _T("Exposure in µAs") },
{ 0x0018,0x1154,DICOM_T_UNK,   _T("Average Pulse Width") },
{ 0x0018,0x1155,DICOM_T_UNK,   _T("Radiation Setting") },
{ 0x0018,0x1156,DICOM_T_UNK,   _T("Rectification Type") },
{ 0x0018,0x115A,DICOM_T_UNK,   _T("Radiation Mode") },
{ 0x0018,0x115E,DICOM_T_UNK,   _T("Image and Fluoroscopy Area Dose Product") },
{ 0x0018,0x1160,DICOM_T_UNK,   _T("Filter Type") },
{ 0x0018,0x1161,DICOM_T_UNK,   _T("Type of Filters") },
{ 0x0018,0x1162,DICOM_T_UNK,   _T("Intensifier Size") },
{ 0x0018,0x1164,DICOM_T_UNK,   _T("Imager Pixel Spacing") },
{ 0x0018,0x1166,DICOM_T_UNK,   _T("Grid") },
{ 0x0018,0x1170,DICOM_T_UNK,   _T("Generator Power") },
{ 0x0018,0x1180,DICOM_T_UNK,   _T("Collimator/grid Name") },
{ 0x0018,0x1181,DICOM_T_UNK,   _T("Collimator Type") },
{ 0x0018,0x1182,DICOM_T_UNK,   _T("Focal Distance") },
{ 0x0018,0x1183,DICOM_T_UNK,   _T("X Focus Center") },
{ 0x0018,0x1184,DICOM_T_UNK,   _T("Y Focus Center") },
{ 0x0018,0x1190,DICOM_T_UNK,   _T("Focal Spot(s)") },
{ 0x0018,0x1191,DICOM_T_UNK,   _T("Anode Target Material") },
{ 0x0018,0x11A0,DICOM_T_UNK,   _T("Body Part Thickness") },
{ 0x0018,0x11A2,DICOM_T_UNK,   _T("Compression Force") },
{ 0x0018,0x11A4,DICOM_T_UNK,   _T("Paddle Description") },
{ 0x0018,0x1200,DICOM_T_UNK,   _T("Date of Last Calibration") },
{ 0x0018,0x1201,DICOM_T_UNK,   _T("Time of Last Calibration") },
{ 0x0018,0x1202,DICOM_T_UNK,   _T("DateTime of Last Calibration") },
{ 0x0018,0x1210,DICOM_T_UNK,   _T("Convolution Kernel") },
{ 0x0018,0x1240,DICOM_T_UNK,   _T("Upper/Lower Pixel Values") },
{ 0x0018,0x1242,DICOM_T_UNK,   _T("Actual Frame Duration") },
{ 0x0018,0x1243,DICOM_T_UNK,   _T("Count Rate") },
{ 0x0018,0x1244,DICOM_T_UNK,   _T("Preferred Playback Sequencing") },
{ 0x0018,0x1250,DICOM_T_UNK,   _T("Receive Coil Name") },
{ 0x0018,0x1251,DICOM_T_UNK,   _T("Transmit Coil Name") },
{ 0x0018,0x1260,DICOM_T_UNK,   _T("Plate Type") },
{ 0x0018,0x1261,DICOM_T_UNK,   _T("Phosphor Type") },
{ 0x0018,0x1300,DICOM_T_UNK,   _T("Scan Velocity") },
{ 0x0018,0x1301,DICOM_T_UNK,   _T("Whole Body Technique") },
{ 0x0018,0x1302,DICOM_T_UNK,   _T("Scan Length") },
{ 0x0018,0x1310,DICOM_T_UNK,   _T("Acquisition Matrix") },
{ 0x0018,0x1312,DICOM_T_UNK,   _T("In-plane Phase Encoding Direction") },
{ 0x0018,0x1314,DICOM_T_UNK,   _T("Flip Angle") },
{ 0x0018,0x1315,DICOM_T_UNK,   _T("Variable Flip Angle Flag") },
{ 0x0018,0x1316,DICOM_T_UNK,   _T("SAR") },
{ 0x0018,0x1318,DICOM_T_UNK,   _T("dB/dt") },
{ 0x0018,0x1400,DICOM_T_UNK,   _T("Acquisition Device Processing Description") },
{ 0x0018,0x1401,DICOM_T_UNK,   _T("Acquisition Device Processing Code") },
{ 0x0018,0x1402,DICOM_T_UNK,   _T("Cassette Orientation") },
{ 0x0018,0x1403,DICOM_T_UNK,   _T("Cassette Size") },
{ 0x0018,0x1404,DICOM_T_UNK,   _T("Exposures on Plate") },
{ 0x0018,0x1405,DICOM_T_UNK,   _T("Relative X-Ray Exposure") },
{ 0x0018,0x1411,DICOM_T_UNK,   _T("Exposure Index") },
{ 0x0018,0x1412,DICOM_T_UNK,   _T("Target Exposure Index") },
{ 0x0018,0x1413,DICOM_T_UNK,   _T("Deviation Index") },
{ 0x0018,0x1450,DICOM_T_UNK,   _T("Column Angulation") },
{ 0x0018,0x1460,DICOM_T_UNK,   _T("Tomo Layer Height") },
{ 0x0018,0x1470,DICOM_T_UNK,   _T("Tomo Angle") },
{ 0x0018,0x1480,DICOM_T_UNK,   _T("Tomo Time") },
{ 0x0018,0x1490,DICOM_T_UNK,   _T("Tomo Type") },
{ 0x0018,0x1491,DICOM_T_UNK,   _T("Tomo Class") },
{ 0x0018,0x1495,DICOM_T_UNK,   _T("Number of Tomosynthesis Source Images") },
{ 0x0018,0x1500,DICOM_T_UNK,   _T("Positioner Motion") },
{ 0x0018,0x1508,DICOM_T_UNK,   _T("Positioner Type") },
{ 0x0018,0x1510,DICOM_T_UNK,   _T("Positioner Primary Angle") },
{ 0x0018,0x1511,DICOM_T_UNK,   _T("Positioner Secondary Angle") },
{ 0x0018,0x1520,DICOM_T_UNK,   _T("Positioner Primary Angle Increment") },
{ 0x0018,0x1521,DICOM_T_UNK,   _T("Positioner Secondary Angle Increment") },
{ 0x0018,0x1530,DICOM_T_UNK,   _T("Detector Primary Angle") },
{ 0x0018,0x1531,DICOM_T_UNK,   _T("Detector Secondary Angle") },
{ 0x0018,0x1600,DICOM_T_UNK,   _T("Shutter Shape") },
{ 0x0018,0x1602,DICOM_T_UNK,   _T("Shutter Left Vertical Edge") },
{ 0x0018,0x1604,DICOM_T_UNK,   _T("Shutter Right Vertical Edge") },
{ 0x0018,0x1606,DICOM_T_UNK,   _T("Shutter Upper Horizontal Edge") },
{ 0x0018,0x1608,DICOM_T_UNK,   _T("Shutter Lower Horizontal Edge") },
{ 0x0018,0x1610,DICOM_T_UNK,   _T("Center of Circular Shutter") },
{ 0x0018,0x1612,DICOM_T_UNK,   _T("Radius of Circular Shutter") },
{ 0x0018,0x1620,DICOM_T_UNK,   _T("Vertices of the Polygonal Shutter") },
{ 0x0018,0x1622,DICOM_T_UNK,   _T("Shutter Presentation Value") },
{ 0x0018,0x1623,DICOM_T_UNK,   _T("Shutter Overlay Group") },
{ 0x0018,0x1624,DICOM_T_UNK,   _T("Shutter Presentation Color CIELab Value") },
{ 0x0018,0x1700,DICOM_T_UNK,   _T("Collimator Shape") },
{ 0x0018,0x1702,DICOM_T_UNK,   _T("Collimator Left Vertical Edge") },
{ 0x0018,0x1704,DICOM_T_UNK,   _T("Collimator Right Vertical Edge") },
{ 0x0018,0x1706,DICOM_T_UNK,   _T("Collimator Upper Horizontal Edge") },
{ 0x0018,0x1708,DICOM_T_UNK,   _T("Collimator Lower Horizontal Edge") },
{ 0x0018,0x1710,DICOM_T_UNK,   _T("Center of Circular Collimator") },
{ 0x0018,0x1712,DICOM_T_UNK,   _T("Radius of Circular Collimator") },
{ 0x0018,0x1720,DICOM_T_UNK,   _T("Vertices of the Polygonal Collimator") },
{ 0x0018,0x1800,DICOM_T_UNK,   _T("Acquisition Time Synchronized") },
{ 0x0018,0x1801,DICOM_T_UNK,   _T("Time Source") },
{ 0x0018,0x1802,DICOM_T_UNK,   _T("Time Distribution Protocol") },
{ 0x0018,0x1803,DICOM_T_UNK,   _T("NTP Source Address") },
{ 0x0018,0x2001,DICOM_T_UNK,   _T("Page Number Vector") },
{ 0x0018,0x2002,DICOM_T_UNK,   _T("Frame Label Vector") },
{ 0x0018,0x2003,DICOM_T_UNK,   _T("Frame Primary Angle Vector") },
{ 0x0018,0x2004,DICOM_T_UNK,   _T("Frame Secondary Angle Vector") },
{ 0x0018,0x2005,DICOM_T_UNK,   _T("Slice Location Vector") },
{ 0x0018,0x2006,DICOM_T_UNK,   _T("Display Window Label Vector") },
{ 0x0018,0x2010,DICOM_T_UNK,   _T("Nominal Scanned Pixel Spacing") },
{ 0x0018,0x2020,DICOM_T_UNK,   _T("Digitizing Device Transport Direction") },
{ 0x0018,0x2030,DICOM_T_UNK,   _T("Rotation of Scanned Film") },
{ 0x0018,0x2041,DICOM_T_UNK,   _T("Biopsy Target Sequence") },
{ 0x0018,0x2042,DICOM_T_UNK,   _T("Target UID") },
{ 0x0018,0x2043,DICOM_T_UNK,   _T("Localizing Cursor Position") },
{ 0x0018,0x2044,DICOM_T_UNK,   _T("Calculated Target Position") },
{ 0x0018,0x2045,DICOM_T_UNK,   _T("Target Label") },
{ 0x0018,0x2046,DICOM_T_UNK,   _T("Displayed Z Value") },
{ 0x0018,0x3100,DICOM_T_UNK,   _T("IVUS Acquisition") },
{ 0x0018,0x3101,DICOM_T_UNK,   _T("IVUS Pullback Rate") },
{ 0x0018,0x3102,DICOM_T_UNK,   _T("IVUS Gated Rate") },
{ 0x0018,0x3103,DICOM_T_UNK,   _T("IVUS Pullback Start Frame Number") },
{ 0x0018,0x3104,DICOM_T_UNK,   _T("IVUS Pullback Stop Frame Number") },
{ 0x0018,0x3105,DICOM_T_UNK,   _T("Lesion Number") },
{ 0x0018,0x4000,DICOM_T_UNK,   _T("Acquisition Comments") },
{ 0x0018,0x5000,DICOM_T_UNK,   _T("Output Power") },
{ 0x0018,0x5010,DICOM_T_UNK,   _T("Transducer Data") },
{ 0x0018,0x5012,DICOM_T_UNK,   _T("Focus Depth") },
{ 0x0018,0x5020,DICOM_T_UNK,   _T("Processing Function") },
{ 0x0018,0x5021,DICOM_T_UNK,   _T("Postprocessing Function") },
{ 0x0018,0x5022,DICOM_T_UNK,   _T("Mechanical Index") },
{ 0x0018,0x5024,DICOM_T_UNK,   _T("Bone Thermal Index") },
{ 0x0018,0x5026,DICOM_T_UNK,   _T("Cranial Thermal Index") },
{ 0x0018,0x5027,DICOM_T_UNK,   _T("Soft Tissue Thermal Index") },
{ 0x0018,0x5028,DICOM_T_UNK,   _T("Soft Tissue-focus Thermal Index") },
{ 0x0018,0x5029,DICOM_T_UNK,   _T("Soft Tissue-surface Thermal Index") },
{ 0x0018,0x5030,DICOM_T_UNK,   _T("Dynamic Range") },
{ 0x0018,0x5040,DICOM_T_UNK,   _T("Total Gain") },
{ 0x0018,0x5050,DICOM_T_UNK,   _T("Depth of Scan Field") },
{ 0x0018,0x5100,DICOM_T_UNK,   _T("Patient Position") },
{ 0x0018,0x5101,DICOM_T_UNK,   _T("View Position") },
{ 0x0018,0x5104,DICOM_T_UNK,   _T("Projection Eponymous Name Code Sequence") },
{ 0x0018,0x5210,DICOM_T_UNK,   _T("Image Transformation Matrix") },
{ 0x0018,0x5212,DICOM_T_UNK,   _T("Image Translation Vector") },
{ 0x0018,0x6000,DICOM_T_UNK,   _T("Sensitivity") },
{ 0x0018,0x6011,DICOM_T_UNK,   _T("Sequence of Ultrasound Regions") },
{ 0x0018,0x6012,DICOM_T_UNK,   _T("Region Spatial Format") },
{ 0x0018,0x6014,DICOM_T_UNK,   _T("Region Data Type") },
{ 0x0018,0x6016,DICOM_T_UNK,   _T("Region Flags") },
{ 0x0018,0x6018,DICOM_T_UNK,   _T("Region Location Min X0") },
{ 0x0018,0x601A,DICOM_T_UNK,   _T("Region Location Min Y0") },
{ 0x0018,0x601C,DICOM_T_UNK,   _T("Region Location Max X1") },
{ 0x0018,0x601E,DICOM_T_UNK,   _T("Region Location Max Y1") },
{ 0x0018,0x6020,DICOM_T_UNK,   _T("Reference Pixel X0") },
{ 0x0018,0x6022,DICOM_T_UNK,   _T("Reference Pixel Y0") },
{ 0x0018,0x6024,DICOM_T_UNK,   _T("Physical Units X Direction") },
{ 0x0018,0x6026,DICOM_T_UNK,   _T("Physical Units Y Direction") },
{ 0x0018,0x6028,DICOM_T_UNK,   _T("Reference Pixel Physical Value X") },
{ 0x0018,0x602A,DICOM_T_UNK,   _T("Reference Pixel Physical Value Y") },
{ 0x0018,0x602C,DICOM_T_UNK,   _T("Physical Delta X") },
{ 0x0018,0x602E,DICOM_T_UNK,   _T("Physical Delta Y") },
{ 0x0018,0x6030,DICOM_T_UNK,   _T("Transducer Frequency") },
{ 0x0018,0x6031,DICOM_T_UNK,   _T("Transducer Type") },
{ 0x0018,0x6032,DICOM_T_UNK,   _T("Pulse Repetition Frequency") },
{ 0x0018,0x6034,DICOM_T_UNK,   _T("Doppler Correction Angle") },
{ 0x0018,0x6036,DICOM_T_UNK,   _T("Steering Angle") },
{ 0x0018,0x6038,DICOM_T_UNK,   _T("Doppler Sample Volume X Position (Retired)") },
{ 0x0018,0x6039,DICOM_T_UNK,   _T("Doppler Sample Volume X Position") },
{ 0x0018,0x603A,DICOM_T_UNK,   _T("Doppler Sample Volume Y Position (Retired)") },
{ 0x0018,0x603B,DICOM_T_UNK,   _T("Doppler Sample Volume Y Position") },
{ 0x0018,0x603C,DICOM_T_UNK,   _T("TM-Line Position X0 (Retired)") },
{ 0x0018,0x603D,DICOM_T_UNK,   _T("TM-Line Position X0") },
{ 0x0018,0x603E,DICOM_T_UNK,   _T("TM-Line Position Y0 (Retired)") },
{ 0x0018,0x603F,DICOM_T_UNK,   _T("TM-Line Position Y0") },
{ 0x0018,0x6040,DICOM_T_UNK,   _T("TM-Line Position X1 (Retired)") },
{ 0x0018,0x6041,DICOM_T_UNK,   _T("TM-Line Position X1") },
{ 0x0018,0x6042,DICOM_T_UNK,   _T("TM-Line Position Y1 (Retired)") },
{ 0x0018,0x6043,DICOM_T_UNK,   _T("TM-Line Position Y1") },
{ 0x0018,0x6044,DICOM_T_UNK,   _T("Pixel Component Organization") },
{ 0x0018,0x6046,DICOM_T_UNK,   _T("Pixel Component Mask") },
{ 0x0018,0x6048,DICOM_T_UNK,   _T("Pixel Component Range Start") },
{ 0x0018,0x604A,DICOM_T_UNK,   _T("Pixel Component Range Stop") },
{ 0x0018,0x604C,DICOM_T_UNK,   _T("Pixel Component Physical Units") },
{ 0x0018,0x604E,DICOM_T_UNK,   _T("Pixel Component Data Type") },
{ 0x0018,0x6050,DICOM_T_UNK,   _T("Number of Table Break Points") },
{ 0x0018,0x6052,DICOM_T_UNK,   _T("Table of X Break Points") },
{ 0x0018,0x6054,DICOM_T_UNK,   _T("Table of Y Break Points") },
{ 0x0018,0x6056,DICOM_T_UNK,   _T("Number of Table Entries") },
{ 0x0018,0x6058,DICOM_T_UNK,   _T("Table of Pixel Values") },
{ 0x0018,0x605A,DICOM_T_UNK,   _T("Table of Parameter Values") },
{ 0x0018,0x6060,DICOM_T_UNK,   _T("R Wave Time Vector") },
{ 0x0018,0x7000,DICOM_T_UNK,   _T("Detector Conditions Nominal Flag") },
{ 0x0018,0x7001,DICOM_T_UNK,   _T("Detector Temperature") },
{ 0x0018,0x7004,DICOM_T_UNK,   _T("Detector Type") },
{ 0x0018,0x7005,DICOM_T_UNK,   _T("Detector Configuration") },
{ 0x0018,0x7006,DICOM_T_UNK,   _T("Detector Description") },
{ 0x0018,0x7008,DICOM_T_UNK,   _T("Detector Mode") },
{ 0x0018,0x700A,DICOM_T_UNK,   _T("Detector ID") },
{ 0x0018,0x700C,DICOM_T_UNK,   _T("Date of Last Detector Calibration") },
{ 0x0018,0x700E,DICOM_T_UNK,   _T("Time of Last Detector Calibration") },
{ 0x0018,0x7010,DICOM_T_UNK,   _T("Exposures on Detector Since Last Calibration") },
{ 0x0018,0x7011,DICOM_T_UNK,   _T("Exposures on Detector Since Manufactured") },
{ 0x0018,0x7012,DICOM_T_UNK,   _T("Detector Time Since Last Exposure") },
{ 0x0018,0x7014,DICOM_T_UNK,   _T("Detector Active Time") },
{ 0x0018,0x7016,DICOM_T_UNK,   _T("Detector Activation Offset From Exposure") },
{ 0x0018,0x701A,DICOM_T_UNK,   _T("Detector Binning") },
{ 0x0018,0x7020,DICOM_T_UNK,   _T("Detector Element Physical Size") },
{ 0x0018,0x7022,DICOM_T_UNK,   _T("Detector Element Spacing") },
{ 0x0018,0x7024,DICOM_T_UNK,   _T("Detector Active Shape") },
{ 0x0018,0x7026,DICOM_T_UNK,   _T("Detector Active Dimension(s)") },
{ 0x0018,0x7028,DICOM_T_UNK,   _T("Detector Active Origin") },
{ 0x0018,0x702A,DICOM_T_UNK,   _T("Detector Manufacturer Name") },
{ 0x0018,0x702B,DICOM_T_UNK,   _T("Detector Manufacturer's Model Name") },
{ 0x0018,0x7030,DICOM_T_UNK,   _T("Field of View Origin") },
{ 0x0018,0x7032,DICOM_T_UNK,   _T("Field of View Rotation") },
{ 0x0018,0x7034,DICOM_T_UNK,   _T("Field of View Horizontal Flip") },
{ 0x0018,0x7036,DICOM_T_UNK,   _T("Pixel Data Area Origin Relative To FOV") },
{ 0x0018,0x7038,DICOM_T_UNK,   _T("Pixel Data Area Rotation Angle Relative To FOV") },
{ 0x0018,0x7040,DICOM_T_UNK,   _T("Grid Absorbing Material") },
{ 0x0018,0x7041,DICOM_T_UNK,   _T("Grid Spacing Material") },
{ 0x0018,0x7042,DICOM_T_UNK,   _T("Grid Thickness") },
{ 0x0018,0x7044,DICOM_T_UNK,   _T("Grid Pitch") },
{ 0x0018,0x7046,DICOM_T_UNK,   _T("Grid Aspect Ratio") },
{ 0x0018,0x7048,DICOM_T_UNK,   _T("Grid Period") },
{ 0x0018,0x704C,DICOM_T_UNK,   _T("Grid Focal Distance") },
{ 0x0018,0x7050,DICOM_T_UNK,   _T("Filter Material") },
{ 0x0018,0x7052,DICOM_T_UNK,   _T("Filter Thickness Minimum") },
{ 0x0018,0x7054,DICOM_T_UNK,   _T("Filter Thickness Maximum") },
{ 0x0018,0x7056,DICOM_T_UNK,   _T("Filter Beam Path Length Minimum") },
{ 0x0018,0x7058,DICOM_T_UNK,   _T("Filter Beam Path Length Maximum") },
{ 0x0018,0x7060,DICOM_T_UNK,   _T("Exposure Control Mode") },
{ 0x0018,0x7062,DICOM_T_UNK,   _T("Exposure Control Mode Description") },
{ 0x0018,0x7064,DICOM_T_UNK,   _T("Exposure Status") },
{ 0x0018,0x7065,DICOM_T_UNK,   _T("Phototimer Setting") },
{ 0x0018,0x8150,DICOM_T_UNK,   _T("Exposure Time in µS") },
{ 0x0018,0x8151,DICOM_T_UNK,   _T("X-Ray Tube Current in µA") },
{ 0x0018,0x9004,DICOM_T_UNK,   _T("Content Qualification") },
{ 0x0018,0x9005,DICOM_T_UNK,   _T("Pulse Sequence Name") },
{ 0x0018,0x9006,DICOM_T_UNK,   _T("MR Imaging Modifier Sequence") },
{ 0x0018,0x9008,DICOM_T_UNK,   _T("Echo Pulse Sequence") },
{ 0x0018,0x9009,DICOM_T_UNK,   _T("Inversion Recovery") },
{ 0x0018,0x9010,DICOM_T_UNK,   _T("Flow Compensation") },
{ 0x0018,0x9011,DICOM_T_UNK,   _T("Multiple Spin Echo") },
{ 0x0018,0x9012,DICOM_T_UNK,   _T("Multi-planar Excitation") },
{ 0x0018,0x9014,DICOM_T_UNK,   _T("Phase Contrast") },
{ 0x0018,0x9015,DICOM_T_UNK,   _T("Time of Flight Contrast") },
{ 0x0018,0x9016,DICOM_T_UNK,   _T("Spoiling") },
{ 0x0018,0x9017,DICOM_T_UNK,   _T("Steady State Pulse Sequence") },
{ 0x0018,0x9018,DICOM_T_UNK,   _T("Echo Planar Pulse Sequence") },
{ 0x0018,0x9019,DICOM_T_UNK,   _T("Tag Angle First Axis") },
{ 0x0018,0x9020,DICOM_T_UNK,   _T("Magnetization Transfer") },
{ 0x0018,0x9021,DICOM_T_UNK,   _T("T2 Preparation") },
{ 0x0018,0x9022,DICOM_T_UNK,   _T("Blood Signal Nulling") },
{ 0x0018,0x9024,DICOM_T_UNK,   _T("Saturation Recovery") },
{ 0x0018,0x9025,DICOM_T_UNK,   _T("Spectrally Selected Suppression") },
{ 0x0018,0x9026,DICOM_T_UNK,   _T("Spectrally Selected Excitation") },
{ 0x0018,0x9027,DICOM_T_UNK,   _T("Spatial Pre-saturation") },
{ 0x0018,0x9028,DICOM_T_UNK,   _T("Tagging") },
{ 0x0018,0x9029,DICOM_T_UNK,   _T("Oversampling Phase") },
{ 0x0018,0x9030,DICOM_T_UNK,   _T("Tag Spacing First Dimension") },
{ 0x0018,0x9032,DICOM_T_UNK,   _T("Geometry of k-Space Traversal") },
{ 0x0018,0x9033,DICOM_T_UNK,   _T("Segmented k-Space Traversal") },
{ 0x0018,0x9034,DICOM_T_UNK,   _T("Rectilinear Phase Encode Reordering") },
{ 0x0018,0x9035,DICOM_T_UNK,   _T("Tag Thickness") },
{ 0x0018,0x9036,DICOM_T_UNK,   _T("Partial Fourier Direction") },
{ 0x0018,0x9037,DICOM_T_UNK,   _T("Cardiac Synchronization Technique") },
{ 0x0018,0x9041,DICOM_T_UNK,   _T("Receive Coil Manufacturer Name") },
{ 0x0018,0x9042,DICOM_T_UNK,   _T("MR Receive Coil Sequence") },
{ 0x0018,0x9043,DICOM_T_UNK,   _T("Receive Coil Type") },
{ 0x0018,0x9044,DICOM_T_UNK,   _T("Quadrature Receive Coil") },
{ 0x0018,0x9045,DICOM_T_UNK,   _T("Multi-Coil Definition Sequence") },
{ 0x0018,0x9046,DICOM_T_UNK,   _T("Multi-Coil Configuration") },
{ 0x0018,0x9047,DICOM_T_UNK,   _T("Multi-Coil Element Name") },
{ 0x0018,0x9048,DICOM_T_UNK,   _T("Multi-Coil Element Used") },
{ 0x0018,0x9049,DICOM_T_UNK,   _T("MR Transmit Coil Sequence") },
{ 0x0018,0x9050,DICOM_T_UNK,   _T("Transmit Coil Manufacturer Name") },
{ 0x0018,0x9051,DICOM_T_UNK,   _T("Transmit Coil Type") },
{ 0x0018,0x9052,DICOM_T_UNK,   _T("Spectral Width") },
{ 0x0018,0x9053,DICOM_T_UNK,   _T("Chemical Shift Reference") },
{ 0x0018,0x9054,DICOM_T_UNK,   _T("Volume Localization Technique") },
{ 0x0018,0x9058,DICOM_T_UNK,   _T("MR Acquisition Frequency Encoding Steps") },
{ 0x0018,0x9059,DICOM_T_UNK,   _T("De-coupling") },
{ 0x0018,0x9060,DICOM_T_UNK,   _T("De-coupled Nucleus") },
{ 0x0018,0x9061,DICOM_T_UNK,   _T("De-coupling Frequency") },
{ 0x0018,0x9062,DICOM_T_UNK,   _T("De-coupling Method") },
{ 0x0018,0x9063,DICOM_T_UNK,   _T("De-coupling Chemical Shift Reference") },
{ 0x0018,0x9064,DICOM_T_UNK,   _T("k-space Filtering") },
{ 0x0018,0x9065,DICOM_T_UNK,   _T("Time Domain Filtering") },
{ 0x0018,0x9066,DICOM_T_UNK,   _T("Number of Zero Fills") },
{ 0x0018,0x9067,DICOM_T_UNK,   _T("Baseline Correction") },
{ 0x0018,0x9069,DICOM_T_UNK,   _T("Parallel Reduction Factor In-plane") },
{ 0x0018,0x9070,DICOM_T_UNK,   _T("Cardiac R-R Interval Specified") },
{ 0x0018,0x9073,DICOM_T_UNK,   _T("Acquisition Duration") },
{ 0x0018,0x9074,DICOM_T_UNK,   _T("Frame Acquisition DateTime") },
{ 0x0018,0x9075,DICOM_T_UNK,   _T("Diffusion Directionality") },
{ 0x0018,0x9076,DICOM_T_UNK,   _T("Diffusion Gradient Direction Sequence") },
{ 0x0018,0x9077,DICOM_T_UNK,   _T("Parallel Acquisition") },
{ 0x0018,0x9078,DICOM_T_UNK,   _T("Parallel Acquisition Technique") },
{ 0x0018,0x9079,DICOM_T_UNK,   _T("Inversion Times") },
{ 0x0018,0x9080,DICOM_T_UNK,   _T("Metabolite Map Description") },
{ 0x0018,0x9081,DICOM_T_UNK,   _T("Partial Fourier") },
{ 0x0018,0x9082,DICOM_T_UNK,   _T("Effective Echo Time") },
{ 0x0018,0x9083,DICOM_T_UNK,   _T("Metabolite Map Code Sequence") },
{ 0x0018,0x9084,DICOM_T_UNK,   _T("Chemical Shift Sequence") },
{ 0x0018,0x9085,DICOM_T_UNK,   _T("Cardiac Signal Source") },
{ 0x0018,0x9087,DICOM_T_UNK,   _T("Diffusion b-value") },
{ 0x0018,0x9089,DICOM_T_UNK,   _T("Diffusion Gradient Orientation") },
{ 0x0018,0x9090,DICOM_T_UNK,   _T("Velocity Encoding Direction") },
{ 0x0018,0x9091,DICOM_T_UNK,   _T("Velocity Encoding Minimum Value") },
{ 0x0018,0x9092,DICOM_T_UNK,   _T("Velocity Encoding Acquisition Sequence") },
{ 0x0018,0x9093,DICOM_T_UNK,   _T("Number of k-Space Trajectories") },
{ 0x0018,0x9094,DICOM_T_UNK,   _T("Coverage of k-Space") },
{ 0x0018,0x9095,DICOM_T_UNK,   _T("Spectroscopy Acquisition Phase Rows") },
{ 0x0018,0x9096,DICOM_T_UNK,   _T("Parallel Reduction Factor In-plane (Retired)") },
{ 0x0018,0x9098,DICOM_T_UNK,   _T("Transmitter Frequency") },
{ 0x0018,0x9100,DICOM_T_UNK,   _T("Resonant Nucleus") },
{ 0x0018,0x9101,DICOM_T_UNK,   _T("Frequency Correction") },
{ 0x0018,0x9103,DICOM_T_UNK,   _T("MR Spectroscopy FOV/Geometry Sequence") },
{ 0x0018,0x9104,DICOM_T_UNK,   _T("Slab Thickness") },
{ 0x0018,0x9105,DICOM_T_UNK,   _T("Slab Orientation") },
{ 0x0018,0x9106,DICOM_T_UNK,   _T("Mid Slab Position") },
{ 0x0018,0x9107,DICOM_T_UNK,   _T("MR Spatial Saturation Sequence") },
{ 0x0018,0x9112,DICOM_T_UNK,   _T("MR Timing and Related Parameters Sequence") },
{ 0x0018,0x9114,DICOM_T_UNK,   _T("MR Echo Sequence") },
{ 0x0018,0x9115,DICOM_T_UNK,   _T("MR Modifier Sequence") },
{ 0x0018,0x9117,DICOM_T_UNK,   _T("MR Diffusion Sequence") },
{ 0x0018,0x9118,DICOM_T_UNK,   _T("Cardiac Synchronization Sequence") },
{ 0x0018,0x9119,DICOM_T_UNK,   _T("MR Averages Sequence") },
{ 0x0018,0x9125,DICOM_T_UNK,   _T("MR FOV/Geometry Sequence") },
{ 0x0018,0x9126,DICOM_T_UNK,   _T("Volume Localization Sequence") },
{ 0x0018,0x9127,DICOM_T_UNK,   _T("Spectroscopy Acquisition Data Columns") },
{ 0x0018,0x9147,DICOM_T_UNK,   _T("Diffusion Anisotropy Type") },
{ 0x0018,0x9151,DICOM_T_UNK,   _T("Frame Reference DateTime") },
{ 0x0018,0x9152,DICOM_T_UNK,   _T("MR Metabolite Map Sequence") },
{ 0x0018,0x9155,DICOM_T_UNK,   _T("Parallel Reduction Factor out-of-plane") },
{ 0x0018,0x9159,DICOM_T_UNK,   _T("Spectroscopy Acquisition Out-of-plane Phase Steps") },
{ 0x0018,0x9166,DICOM_T_UNK,   _T("Bulk Motion Status") },
{ 0x0018,0x9168,DICOM_T_UNK,   _T("Parallel Reduction Factor Second In-plane") },
{ 0x0018,0x9169,DICOM_T_UNK,   _T("Cardiac Beat Rejection Technique") },
{ 0x0018,0x9170,DICOM_T_UNK,   _T("Respiratory Motion Compensation Technique") },
{ 0x0018,0x9171,DICOM_T_UNK,   _T("Respiratory Signal Source") },
{ 0x0018,0x9172,DICOM_T_UNK,   _T("Bulk Motion Compensation Technique") },
{ 0x0018,0x9173,DICOM_T_UNK,   _T("Bulk Motion Signal Source") },
{ 0x0018,0x9174,DICOM_T_UNK,   _T("Applicable Safety Standard Agency") },
{ 0x0018,0x9175,DICOM_T_UNK,   _T("Applicable Safety Standard Description") },
{ 0x0018,0x9176,DICOM_T_UNK,   _T("Operating Mode Sequence") },
{ 0x0018,0x9177,DICOM_T_UNK,   _T("Operating Mode Type") },
{ 0x0018,0x9178,DICOM_T_UNK,   _T("Operating Mode") },
{ 0x0018,0x9179,DICOM_T_UNK,   _T("Specific Absorption Rate Definition") },
{ 0x0018,0x9180,DICOM_T_UNK,   _T("Gradient Output Type") },
{ 0x0018,0x9181,DICOM_T_UNK,   _T("Specific Absorption Rate Value") },
{ 0x0018,0x9182,DICOM_T_UNK,   _T("Gradient Output") },
{ 0x0018,0x9183,DICOM_T_UNK,   _T("Flow Compensation Direction") },
{ 0x0018,0x9184,DICOM_T_UNK,   _T("Tagging Delay") },
{ 0x0018,0x9185,DICOM_T_UNK,   _T("Respiratory Motion Compensation Technique Description") },
{ 0x0018,0x9186,DICOM_T_UNK,   _T("Respiratory Signal Source ID") },
{ 0x0018,0x9195,DICOM_T_UNK,   _T("Chemical Shift Minimum Integration Limit in Hz") },
{ 0x0018,0x9196,DICOM_T_UNK,   _T("Chemical Shift Maximum Integration Limit in Hz") },
{ 0x0018,0x9197,DICOM_T_UNK,   _T("MR Velocity Encoding Sequence") },
{ 0x0018,0x9198,DICOM_T_UNK,   _T("First Order Phase Correction") },
{ 0x0018,0x9199,DICOM_T_UNK,   _T("Water Referenced Phase Correction") },
{ 0x0018,0x9200,DICOM_T_UNK,   _T("MR Spectroscopy Acquisition Type") },
{ 0x0018,0x9214,DICOM_T_UNK,   _T("Respiratory Cycle Position") },
{ 0x0018,0x9217,DICOM_T_UNK,   _T("Velocity Encoding Maximum Value") },
{ 0x0018,0x9218,DICOM_T_UNK,   _T("Tag Spacing Second Dimension") },
{ 0x0018,0x9219,DICOM_T_UNK,   _T("Tag Angle Second Axis") },
{ 0x0018,0x9220,DICOM_T_UNK,   _T("Frame Acquisition Duration") },
{ 0x0018,0x9226,DICOM_T_UNK,   _T("MR Image Frame Type Sequence") },
{ 0x0018,0x9227,DICOM_T_UNK,   _T("MR Spectroscopy Frame Type Sequence") },
{ 0x0018,0x9231,DICOM_T_UNK,   _T("MR Acquisition Phase Encoding Steps in-plane") },
{ 0x0018,0x9232,DICOM_T_UNK,   _T("MR Acquisition Phase Encoding Steps out-of-plane") },
{ 0x0018,0x9234,DICOM_T_UNK,   _T("Spectroscopy Acquisition Phase Columns") },
{ 0x0018,0x9236,DICOM_T_UNK,   _T("Cardiac Cycle Position") },
{ 0x0018,0x9239,DICOM_T_UNK,   _T("Specific Absorption Rate Sequence") },
{ 0x0018,0x9240,DICOM_T_UNK,   _T("RF Echo Train Length") },
{ 0x0018,0x9241,DICOM_T_UNK,   _T("Gradient Echo Train Length") },
{ 0x0018,0x9250,DICOM_T_UNK,   _T("Arterial Spin Labeling Contrast") },
{ 0x0018,0x9251,DICOM_T_UNK,   _T("MR Arterial Spin Labeling Sequence") },
{ 0x0018,0x9252,DICOM_T_UNK,   _T("ASL Technique Description") },
{ 0x0018,0x9253,DICOM_T_UNK,   _T("ASL Slab Number") },
{ 0x0018,0x9254,DICOM_T_UNK,   _T("ASL Slab Thickness") },
{ 0x0018,0x9255,DICOM_T_UNK,   _T("ASL Slab Orientation") },
{ 0x0018,0x9256,DICOM_T_UNK,   _T("ASL Mid Slab Position") },
{ 0x0018,0x9257,DICOM_T_UNK,   _T("ASL Context") },
{ 0x0018,0x9258,DICOM_T_UNK,   _T("ASL Pulse Train Duration") },
{ 0x0018,0x9259,DICOM_T_UNK,   _T("ASL Crusher Flag") },
{ 0x0018,0x925A,DICOM_T_UNK,   _T("ASL Crusher Flow Limit") },
{ 0x0018,0x925B,DICOM_T_UNK,   _T("ASL Crusher Description") },
{ 0x0018,0x925C,DICOM_T_UNK,   _T("ASL Bolus Cut-off Flag") },
{ 0x0018,0x925D,DICOM_T_UNK,   _T("ASL Bolus Cut-off Timing Sequence") },
{ 0x0018,0x925E,DICOM_T_UNK,   _T("ASL Bolus Cut-off Technique") },
{ 0x0018,0x925F,DICOM_T_UNK,   _T("ASL Bolus Cut-off Delay Time") },
{ 0x0018,0x9260,DICOM_T_UNK,   _T("ASL Slab Sequence") },
{ 0x0018,0x9295,DICOM_T_UNK,   _T("Chemical Shift Minimum Integration Limit in ppm") },
{ 0x0018,0x9296,DICOM_T_UNK,   _T("Chemical Shift Maximum Integration Limit in ppm") },
{ 0x0018,0x9297,DICOM_T_UNK,   _T("Water Reference Acquisition") },
{ 0x0018,0x9298,DICOM_T_UNK,   _T("Echo Peak Position") },
{ 0x0018,0x9301,DICOM_T_UNK,   _T("CT Acquisition Type Sequence") },
{ 0x0018,0x9302,DICOM_T_UNK,   _T("Acquisition Type") },
{ 0x0018,0x9303,DICOM_T_UNK,   _T("Tube Angle") },
{ 0x0018,0x9304,DICOM_T_UNK,   _T("CT Acquisition Details Sequence") },
{ 0x0018,0x9305,DICOM_T_UNK,   _T("Revolution Time") },
{ 0x0018,0x9306,DICOM_T_UNK,   _T("Single Collimation Width") },
{ 0x0018,0x9307,DICOM_T_UNK,   _T("Total Collimation Width") },
{ 0x0018,0x9308,DICOM_T_UNK,   _T("CT Table Dynamics Sequence") },
{ 0x0018,0x9309,DICOM_T_UNK,   _T("Table Speed") },
{ 0x0018,0x9310,DICOM_T_UNK,   _T("Table Feed per Rotation") },
{ 0x0018,0x9311,DICOM_T_UNK,   _T("Spiral Pitch Factor") },
{ 0x0018,0x9312,DICOM_T_UNK,   _T("CT Geometry Sequence") },
{ 0x0018,0x9313,DICOM_T_UNK,   _T("Data Collection Center (Patient)") },
{ 0x0018,0x9314,DICOM_T_UNK,   _T("CT Reconstruction Sequence") },
{ 0x0018,0x9315,DICOM_T_UNK,   _T("Reconstruction Algorithm") },
{ 0x0018,0x9316,DICOM_T_UNK,   _T("Convolution Kernel Group") },
{ 0x0018,0x9317,DICOM_T_UNK,   _T("Reconstruction Field of View") },
{ 0x0018,0x9318,DICOM_T_UNK,   _T("Reconstruction Target Center (Patient)") },
{ 0x0018,0x9319,DICOM_T_UNK,   _T("Reconstruction Angle") },
{ 0x0018,0x9320,DICOM_T_UNK,   _T("Image Filter") },
{ 0x0018,0x9321,DICOM_T_UNK,   _T("CT Exposure Sequence") },
{ 0x0018,0x9322,DICOM_T_UNK,   _T("Reconstruction Pixel Spacing") },
{ 0x0018,0x9323,DICOM_T_UNK,   _T("Exposure Modulation Type") },
{ 0x0018,0x9324,DICOM_T_UNK,   _T("Estimated Dose Saving") },
{ 0x0018,0x9325,DICOM_T_UNK,   _T("CT X-Ray Details Sequence") },
{ 0x0018,0x9326,DICOM_T_UNK,   _T("CT Position Sequence") },
{ 0x0018,0x9327,DICOM_T_UNK,   _T("Table Position") },
{ 0x0018,0x9328,DICOM_T_UNK,   _T("Exposure Time in ms") },
{ 0x0018,0x9329,DICOM_T_UNK,   _T("CT Image Frame Type Sequence") },
{ 0x0018,0x9330,DICOM_T_UNK,   _T("X-Ray Tube Current in mA") },
{ 0x0018,0x9332,DICOM_T_UNK,   _T("Exposure in mAs") },
{ 0x0018,0x9333,DICOM_T_UNK,   _T("Constant Volume Flag") },
{ 0x0018,0x9334,DICOM_T_UNK,   _T("Fluoroscopy Flag") },
{ 0x0018,0x9335,DICOM_T_UNK,   _T("Distance Source to Data Collection Center") },
{ 0x0018,0x9337,DICOM_T_UNK,   _T("Contrast/Bolus Agent Number") },
{ 0x0018,0x9338,DICOM_T_UNK,   _T("Contrast/Bolus Ingredient Code Sequence") },
{ 0x0018,0x9340,DICOM_T_UNK,   _T("Contrast Administration Profile Sequence") },
{ 0x0018,0x9341,DICOM_T_UNK,   _T("Contrast/Bolus Usage Sequence") },
{ 0x0018,0x9342,DICOM_T_UNK,   _T("Contrast/Bolus Agent Administered") },
{ 0x0018,0x9343,DICOM_T_UNK,   _T("Contrast/Bolus Agent Detected") },
{ 0x0018,0x9344,DICOM_T_UNK,   _T("Contrast/Bolus Agent Phase") },
{ 0x0018,0x9345,DICOM_T_UNK,   _T("CTDIvol") },
{ 0x0018,0x9346,DICOM_T_UNK,   _T("CTDI Phantom Type Code Sequence") },
{ 0x0018,0x9351,DICOM_T_UNK,   _T("Calcium Scoring Mass Factor Patient") },
{ 0x0018,0x9352,DICOM_T_UNK,   _T("Calcium Scoring Mass Factor Device") },
{ 0x0018,0x9353,DICOM_T_UNK,   _T("Energy Weighting Factor") },
{ 0x0018,0x9360,DICOM_T_UNK,   _T("CT Additional X-Ray Source Sequence") },
{ 0x0018,0x9401,DICOM_T_UNK,   _T("Projection Pixel Calibration Sequence") },
{ 0x0018,0x9402,DICOM_T_UNK,   _T("Distance Source to Isocenter") },
{ 0x0018,0x9403,DICOM_T_UNK,   _T("Distance Object to Table Top") },
{ 0x0018,0x9404,DICOM_T_UNK,   _T("Object Pixel Spacing in Center of Beam") },
{ 0x0018,0x9405,DICOM_T_UNK,   _T("Positioner Position Sequence") },
{ 0x0018,0x9406,DICOM_T_UNK,   _T("Table Position Sequence") },
{ 0x0018,0x9407,DICOM_T_UNK,   _T("Collimator Shape Sequence") },
{ 0x0018,0x9410,DICOM_T_UNK,   _T("Planes in Acquisition") },
{ 0x0018,0x9412,DICOM_T_UNK,   _T("XA/XRF Frame Characteristics Sequence") },
{ 0x0018,0x9417,DICOM_T_UNK,   _T("Frame Acquisition Sequence") },
{ 0x0018,0x9420,DICOM_T_UNK,   _T("X-Ray Receptor Type") },
{ 0x0018,0x9423,DICOM_T_UNK,   _T("Acquisition Protocol Name") },
{ 0x0018,0x9424,DICOM_T_UNK,   _T("Acquisition Protocol Description") },
{ 0x0018,0x9425,DICOM_T_UNK,   _T("Contrast/Bolus Ingredient Opaque") },
{ 0x0018,0x9426,DICOM_T_UNK,   _T("Distance Receptor Plane to Detector Housing") },
{ 0x0018,0x9427,DICOM_T_UNK,   _T("Intensifier Active Shape") },
{ 0x0018,0x9428,DICOM_T_UNK,   _T("Intensifier Active Dimension(s)") },
{ 0x0018,0x9429,DICOM_T_UNK,   _T("Physical Detector Size") },
{ 0x0018,0x9430,DICOM_T_UNK,   _T("Position of Isocenter Projection") },
{ 0x0018,0x9432,DICOM_T_UNK,   _T("Field of View Sequence") },
{ 0x0018,0x9433,DICOM_T_UNK,   _T("Field of View Description") },
{ 0x0018,0x9434,DICOM_T_UNK,   _T("Exposure Control Sensing Regions Sequence") },
{ 0x0018,0x9435,DICOM_T_UNK,   _T("Exposure Control Sensing Region Shape") },
{ 0x0018,0x9436,DICOM_T_UNK,   _T("Exposure Control Sensing Region Left Vertical Edge") },
{ 0x0018,0x9437,DICOM_T_UNK,   _T("Exposure Control Sensing Region Right Vertical Edge") },
{ 0x0018,0x9438,DICOM_T_UNK,   _T("Exposure Control Sensing Region Upper Horizontal Edge") },
{ 0x0018,0x9439,DICOM_T_UNK,   _T("Exposure Control Sensing Region Lower Horizontal Edge") },
{ 0x0018,0x9440,DICOM_T_UNK,   _T("Center of Circular Exposure Control Sensing Region") },
{ 0x0018,0x9441,DICOM_T_UNK,   _T("Radius of Circular Exposure Control Sensing Region") },
{ 0x0018,0x9442,DICOM_T_UNK,   _T("Vertices of the Polygonal Exposure Control Sensing Region") },
{ 0x0018,0x9445,DICOM_T_UNK,   _T("") },
{ 0x0018,0x9447,DICOM_T_UNK,   _T("Column Angulation (Patient)") },
{ 0x0018,0x9449,DICOM_T_UNK,   _T("Beam Angle") },
{ 0x0018,0x9451,DICOM_T_UNK,   _T("Frame Detector Parameters Sequence") },
{ 0x0018,0x9452,DICOM_T_UNK,   _T("Calculated Anatomy Thickness") },
{ 0x0018,0x9455,DICOM_T_UNK,   _T("Calibration Sequence") },
{ 0x0018,0x9456,DICOM_T_UNK,   _T("Object Thickness Sequence") },
{ 0x0018,0x9457,DICOM_T_UNK,   _T("Plane Identification") },
{ 0x0018,0x9461,DICOM_T_UNK,   _T("Field of View Dimension(s) in Float") },
{ 0x0018,0x9462,DICOM_T_UNK,   _T("Isocenter Reference System Sequence") },
{ 0x0018,0x9463,DICOM_T_UNK,   _T("Positioner Isocenter Primary Angle") },
{ 0x0018,0x9464,DICOM_T_UNK,   _T("Positioner Isocenter Secondary Angle") },
{ 0x0018,0x9465,DICOM_T_UNK,   _T("Positioner Isocenter Detector Rotation Angle") },
{ 0x0018,0x9466,DICOM_T_UNK,   _T("Table X Position to Isocenter") },
{ 0x0018,0x9467,DICOM_T_UNK,   _T("Table Y Position to Isocenter") },
{ 0x0018,0x9468,DICOM_T_UNK,   _T("Table Z Position to Isocenter") },
{ 0x0018,0x9469,DICOM_T_UNK,   _T("Table Horizontal Rotation Angle") },
{ 0x0018,0x9470,DICOM_T_UNK,   _T("Table Head Tilt Angle") },
{ 0x0018,0x9471,DICOM_T_UNK,   _T("Table Cradle Tilt Angle") },
{ 0x0018,0x9472,DICOM_T_UNK,   _T("Frame Display Shutter Sequence") },
{ 0x0018,0x9473,DICOM_T_UNK,   _T("Acquired Image Area Dose Product") },
{ 0x0018,0x9474,DICOM_T_UNK,   _T("C-arm Positioner Tabletop Relationship") },
{ 0x0018,0x9476,DICOM_T_UNK,   _T("X-Ray Geometry Sequence") },
{ 0x0018,0x9477,DICOM_T_UNK,   _T("Irradiation Event Identification Sequence") },
{ 0x0018,0x9504,DICOM_T_UNK,   _T("X-Ray 3D Frame Type Sequence") },
{ 0x0018,0x9506,DICOM_T_UNK,   _T("Contributing Sources Sequence") },
{ 0x0018,0x9507,DICOM_T_UNK,   _T("X-Ray 3D Acquisition Sequence") },
{ 0x0018,0x9508,DICOM_T_UNK,   _T("Primary Positioner Scan Arc") },
{ 0x0018,0x9509,DICOM_T_UNK,   _T("Secondary Positioner Scan Arc") },
{ 0x0018,0x9510,DICOM_T_UNK,   _T("Primary Positioner Scan Start Angle") },
{ 0x0018,0x9511,DICOM_T_UNK,   _T("Secondary Positioner Scan Start Angle") },
{ 0x0018,0x9514,DICOM_T_UNK,   _T("Primary Positioner Increment") },
{ 0x0018,0x9515,DICOM_T_UNK,   _T("Secondary Positioner Increment") },
{ 0x0018,0x9516,DICOM_T_UNK,   _T("Start Acquisition DateTime") },
{ 0x0018,0x9517,DICOM_T_UNK,   _T("End Acquisition DateTime") },
{ 0x0018,0x9518,DICOM_T_UNK,   _T("Primary Positioner Increment Sign") },
{ 0x0018,0x9519,DICOM_T_UNK,   _T("Secondary Positioner Increment Sign") },
{ 0x0018,0x9524,DICOM_T_UNK,   _T("Application Name") },
{ 0x0018,0x9525,DICOM_T_UNK,   _T("Application Version") },
{ 0x0018,0x9526,DICOM_T_UNK,   _T("Application Manufacturer") },
{ 0x0018,0x9527,DICOM_T_UNK,   _T("Algorithm Type") },
{ 0x0018,0x9528,DICOM_T_UNK,   _T("Algorithm Description") },
{ 0x0018,0x9530,DICOM_T_UNK,   _T("X-Ray 3D Reconstruction Sequence") },
{ 0x0018,0x9531,DICOM_T_UNK,   _T("Reconstruction Description") },
{ 0x0018,0x9538,DICOM_T_UNK,   _T("Per Projection Acquisition Sequence") },
{ 0x0018,0x9541,DICOM_T_UNK,   _T("Detector Position Sequence") },
{ 0x0018,0x9542,DICOM_T_UNK,   _T("X-Ray Acquisition Dose Sequence") },
{ 0x0018,0x9543,DICOM_T_UNK,   _T("X-Ray Source Isocenter Primary Angle") },
{ 0x0018,0x9544,DICOM_T_UNK,   _T("X-Ray Source Isocenter Secondary Angle") },
{ 0x0018,0x9545,DICOM_T_UNK,   _T("Breast Support Isocenter Primary Angle") },
{ 0x0018,0x9546,DICOM_T_UNK,   _T("Breast Support Isocenter Secondary Angle") },
{ 0x0018,0x9547,DICOM_T_UNK,   _T("Breast Support X Position to Isocenter") },
{ 0x0018,0x9548,DICOM_T_UNK,   _T("Breast Support Y Position to Isocenter") },
{ 0x0018,0x9549,DICOM_T_UNK,   _T("Breast Support Z Position to Isocenter") },
{ 0x0018,0x9550,DICOM_T_UNK,   _T("Detector Isocenter Primary Angle") },
{ 0x0018,0x9551,DICOM_T_UNK,   _T("Detector Isocenter Secondary Angle") },
{ 0x0018,0x9552,DICOM_T_UNK,   _T("Detector X Position to Isocenter") },
{ 0x0018,0x9553,DICOM_T_UNK,   _T("Detector Y Position to Isocenter") },
{ 0x0018,0x9554,DICOM_T_UNK,   _T("Detector Z Position to Isocenter") },
{ 0x0018,0x9555,DICOM_T_UNK,   _T("X-Ray Grid Sequence") },
{ 0x0018,0x9556,DICOM_T_UNK,   _T("X-Ray Filter Sequence") },
{ 0x0018,0x9557,DICOM_T_UNK,   _T("Detector Active Area TLHC Position") },
{ 0x0018,0x9558,DICOM_T_UNK,   _T("Detector Active Area Orientation") },
{ 0x0018,0x9559,DICOM_T_UNK,   _T("Positioner Primary Angle Direction") },
{ 0x0018,0x9601,DICOM_T_UNK,   _T("Diffusion b-matrix Sequence") },
{ 0x0018,0x9602,DICOM_T_UNK,   _T("Diffusion b-value XX") },
{ 0x0018,0x9603,DICOM_T_UNK,   _T("Diffusion b-value XY") },
{ 0x0018,0x9604,DICOM_T_UNK,   _T("Diffusion b-value XZ") },
{ 0x0018,0x9605,DICOM_T_UNK,   _T("Diffusion b-value YY") },
{ 0x0018,0x9606,DICOM_T_UNK,   _T("Diffusion b-value YZ") },
{ 0x0018,0x9607,DICOM_T_UNK,   _T("Diffusion b-value ZZ") },
{ 0x0018,0x9701,DICOM_T_UNK,   _T("Decay Correction DateTime") },
{ 0x0018,0x9715,DICOM_T_UNK,   _T("Start Density Threshold") },
{ 0x0018,0x9716,DICOM_T_UNK,   _T("Start Relative Density Difference Threshold") },
{ 0x0018,0x9717,DICOM_T_UNK,   _T("Start Cardiac Trigger Count Threshold") },
{ 0x0018,0x9718,DICOM_T_UNK,   _T("Start Respiratory Trigger Count Threshold") },
{ 0x0018,0x9719,DICOM_T_UNK,   _T("Termination Counts Threshold") },
{ 0x0018,0x9720,DICOM_T_UNK,   _T("Termination Density Threshold") },
{ 0x0018,0x9721,DICOM_T_UNK,   _T("Termination Relative Density Threshold") },
{ 0x0018,0x9722,DICOM_T_UNK,   _T("Termination Time Threshold") },
{ 0x0018,0x9723,DICOM_T_UNK,   _T("Termination Cardiac Trigger Count Threshold") },
{ 0x0018,0x9724,DICOM_T_UNK,   _T("Termination Respiratory Trigger Count Threshold") },
{ 0x0018,0x9725,DICOM_T_UNK,   _T("Detector Geometry") },
{ 0x0018,0x9726,DICOM_T_UNK,   _T("Transverse Detector Separation") },
{ 0x0018,0x9727,DICOM_T_UNK,   _T("Axial Detector Dimension") },
{ 0x0018,0x9729,DICOM_T_UNK,   _T("Radiopharmaceutical Agent Number") },
{ 0x0018,0x9732,DICOM_T_UNK,   _T("PET Frame Acquisition Sequence") },
{ 0x0018,0x9733,DICOM_T_UNK,   _T("PET Detector Motion Details Sequence") },
{ 0x0018,0x9734,DICOM_T_UNK,   _T("PET Table Dynamics Sequence") },
{ 0x0018,0x9735,DICOM_T_UNK,   _T("PET Position Sequence") },
{ 0x0018,0x9736,DICOM_T_UNK,   _T("PET Frame Correction Factors Sequence") },
{ 0x0018,0x9737,DICOM_T_UNK,   _T("Radiopharmaceutical Usage Sequence") },
{ 0x0018,0x9738,DICOM_T_UNK,   _T("Attenuation Correction Source") },
{ 0x0018,0x9739,DICOM_T_UNK,   _T("Number of Iterations") },
{ 0x0018,0x9740,DICOM_T_UNK,   _T("Number of Subsets") },
{ 0x0018,0x9749,DICOM_T_UNK,   _T("PET Reconstruction Sequence") },
{ 0x0018,0x9751,DICOM_T_UNK,   _T("PET Frame Type Sequence") },
{ 0x0018,0x9755,DICOM_T_UNK,   _T("Time of Flight Information Used") },
{ 0x0018,0x9756,DICOM_T_UNK,   _T("Reconstruction Type") },
{ 0x0018,0x9758,DICOM_T_UNK,   _T("Decay Corrected") },
{ 0x0018,0x9759,DICOM_T_UNK,   _T("Attenuation Corrected") },
{ 0x0018,0x9760,DICOM_T_UNK,   _T("Scatter Corrected") },
{ 0x0018,0x9761,DICOM_T_UNK,   _T("Dead Time Corrected") },
{ 0x0018,0x9762,DICOM_T_UNK,   _T("Gantry Motion Corrected") },
{ 0x0018,0x9763,DICOM_T_UNK,   _T("Patient Motion Corrected") },
{ 0x0018,0x9764,DICOM_T_UNK,   _T("Count Loss Normalization Corrected") },
{ 0x0018,0x9765,DICOM_T_UNK,   _T("Randoms Corrected") },
{ 0x0018,0x9766,DICOM_T_UNK,   _T("Non-uniform Radial Sampling Corrected") },
{ 0x0018,0x9767,DICOM_T_UNK,   _T("Sensitivity Calibrated") },
{ 0x0018,0x9768,DICOM_T_UNK,   _T("Detector Normalization Correction") },
{ 0x0018,0x9769,DICOM_T_UNK,   _T("Iterative Reconstruction Method") },
{ 0x0018,0x9770,DICOM_T_UNK,   _T("Attenuation Correction Temporal Relationship") },
{ 0x0018,0x9771,DICOM_T_UNK,   _T("Patient Physiological State Sequence") },
{ 0x0018,0x9772,DICOM_T_UNK,   _T("Patient Physiological State Code Sequence") },
{ 0x0018,0x9801,DICOM_T_UNK,   _T("Depth(s) of Focus") },
{ 0x0018,0x9803,DICOM_T_UNK,   _T("Excluded Intervals Sequence") },
{ 0x0018,0x9804,DICOM_T_UNK,   _T("Exclusion Start DateTime") },
{ 0x0018,0x9805,DICOM_T_UNK,   _T("Exclusion Duration") },
{ 0x0018,0x9806,DICOM_T_UNK,   _T("US Image Description Sequence") },
{ 0x0018,0x9807,DICOM_T_UNK,   _T("Image Data Type Sequence") },
{ 0x0018,0x9808,DICOM_T_UNK,   _T("Data Type") },
{ 0x0018,0x9809,DICOM_T_UNK,   _T("Transducer Scan Pattern Code Sequence") },
{ 0x0018,0x980B,DICOM_T_UNK,   _T("Aliased Data Type") },
{ 0x0018,0x980C,DICOM_T_UNK,   _T("Position Measuring Device Used") },
{ 0x0018,0x980D,DICOM_T_UNK,   _T("Transducer Geometry Code Sequence") },
{ 0x0018,0x980E,DICOM_T_UNK,   _T("Transducer Beam Steering Code Sequence") },
{ 0x0018,0x980F,DICOM_T_UNK,   _T("Transducer Application Code Sequence") },
{ 0x0018,0x9810,DICOM_T_UNK,   _T("Zero Velocity Pixel Value") },
{ 0x0018,0xA001,DICOM_T_UNK,   _T("Contributing Equipment Sequence") },
{ 0x0018,0xA002,DICOM_T_UNK,   _T("Contribution DateTime") },
{ 0x0018,0xA003,DICOM_T_UNK,   _T("Contribution Description") },
{ 0x0020,0x000D,DICOM_T_UNK,   _T("Study Instance UID") },
{ 0x0020,0x000E,DICOM_T_UNK,   _T("Series Instance UID") },
{ 0x0020,0x0010,DICOM_T_UNK,   _T("Study ID") },
{ 0x0020,0x0011,DICOM_T_UNK,   _T("Series Number") },
{ 0x0020,0x0012,DICOM_T_UNK,   _T("Acquisition Number") },
{ 0x0020,0x0013,DICOM_T_UNK,   _T("Instance Number") },
{ 0x0020,0x0014,DICOM_T_UNK,   _T("Isotope Number") },
{ 0x0020,0x0015,DICOM_T_UNK,   _T("Phase Number") },
{ 0x0020,0x0016,DICOM_T_UNK,   _T("Interval Number") },
{ 0x0020,0x0017,DICOM_T_UNK,   _T("Time Slot Number") },
{ 0x0020,0x0018,DICOM_T_UNK,   _T("Angle Number") },
{ 0x0020,0x0019,DICOM_T_UNK,   _T("Item Number") },
{ 0x0020,0x0020,DICOM_T_UNK,   _T("Patient Orientation") },
{ 0x0020,0x0022,DICOM_T_UNK,   _T("Overlay Number") },
{ 0x0020,0x0024,DICOM_T_UNK,   _T("Curve Number") },
{ 0x0020,0x0026,DICOM_T_UNK,   _T("LUT Number") },
{ 0x0020,0x0030,DICOM_T_UNK,   _T("Image Position") },
{ 0x0020,0x0032,DICOM_T_UNK,   _T("Image Position (Patient)") },
{ 0x0020,0x0035,DICOM_T_UNK,   _T("Image Orientation") },
{ 0x0020,0x0037,DICOM_T_UNK,   _T("Image Orientation (Patient)") },
{ 0x0020,0x0050,DICOM_T_UNK,   _T("Location") },
{ 0x0020,0x0052,DICOM_T_UNK,   _T("Frame of Reference UID") },
{ 0x0020,0x0060,DICOM_T_UNK,   _T("Laterality") },
{ 0x0020,0x0062,DICOM_T_UNK,   _T("Image Laterality") },
{ 0x0020,0x0070,DICOM_T_UNK,   _T("Image Geometry Type") },
{ 0x0020,0x0080,DICOM_T_UNK,   _T("Masking Image") },
{ 0x0020,0x00AA,DICOM_T_UNK,   _T("Report Number") },
{ 0x0020,0x0100,DICOM_T_UNK,   _T("Temporal Position Identifier") },
{ 0x0020,0x0105,DICOM_T_UNK,   _T("Number of Temporal Positions") },
{ 0x0020,0x0110,DICOM_T_UNK,   _T("Temporal Resolution") },
{ 0x0020,0x0200,DICOM_T_UNK,   _T("Synchronization Frame of Reference UID") },
{ 0x0020,0x0242,DICOM_T_UNK,   _T("SOP Instance UID of Concatenation Source") },
{ 0x0020,0x1000,DICOM_T_UNK,   _T("Series in Study") },
{ 0x0020,0x1001,DICOM_T_UNK,   _T("Acquisitions in Series") },
{ 0x0020,0x1002,DICOM_T_UNK,   _T("Images in Acquisition") },
{ 0x0020,0x1003,DICOM_T_UNK,   _T("Images in Series") },
{ 0x0020,0x1004,DICOM_T_UNK,   _T("Acquisitions in Study") },
{ 0x0020,0x1005,DICOM_T_UNK,   _T("Images in Study") },
{ 0x0020,0x1020,DICOM_T_UNK,   _T("Reference") },
{ 0x0020,0x1040,DICOM_T_UNK,   _T("Position Reference Indicator") },
{ 0x0020,0x1041,DICOM_T_UNK,   _T("Slice Location") },
{ 0x0020,0x1070,DICOM_T_UNK,   _T("Other Study Numbers") },
{ 0x0020,0x1200,DICOM_T_UNK,   _T("Number of Patient Related Studies") },
{ 0x0020,0x1202,DICOM_T_UNK,   _T("Number of Patient Related Series") },
{ 0x0020,0x1204,DICOM_T_UNK,   _T("Number of Patient Related Instances") },
{ 0x0020,0x1206,DICOM_T_UNK,   _T("Number of Study Related Series") },
{ 0x0020,0x1208,DICOM_T_UNK,   _T("Number of Study Related Instances") },
{ 0x0020,0x1209,DICOM_T_UNK,   _T("Number of Series Related Instances") },
/*
{ 0x0020,0x31xx,DICOM_T_UNK,   _T("Source Image IDs") },
*/
{ 0x0020,0x3401,DICOM_T_UNK,   _T("Modifying Device ID") },
{ 0x0020,0x3402,DICOM_T_UNK,   _T("Modified Image ID") },
{ 0x0020,0x3403,DICOM_T_UNK,   _T("Modified Image Date") },
{ 0x0020,0x3404,DICOM_T_UNK,   _T("Modifying Device Manufacturer") },
{ 0x0020,0x3405,DICOM_T_UNK,   _T("Modified Image Time") },
{ 0x0020,0x3406,DICOM_T_UNK,   _T("Modified Image Description") },
{ 0x0020,0x4000,DICOM_T_UNK,   _T("Image Comments") },
{ 0x0020,0x5000,DICOM_T_UNK,   _T("Original Image Identification") },
{ 0x0020,0x5002,DICOM_T_UNK,   _T("Original Image Identification Nomenclature") },
{ 0x0020,0x9056,DICOM_T_UNK,   _T("Stack ID") },
{ 0x0020,0x9057,DICOM_T_UNK,   _T("In-Stack Position Number") },
{ 0x0020,0x9071,DICOM_T_UNK,   _T("Frame Anatomy Sequence") },
{ 0x0020,0x9072,DICOM_T_UNK,   _T("Frame Laterality") },
{ 0x0020,0x9111,DICOM_T_UNK,   _T("Frame Content Sequence") },
{ 0x0020,0x9113,DICOM_T_UNK,   _T("Plane Position Sequence") },
{ 0x0020,0x9116,DICOM_T_UNK,   _T("Plane Orientation Sequence") },
{ 0x0020,0x9128,DICOM_T_UNK,   _T("Temporal Position Index") },
{ 0x0020,0x9153,DICOM_T_UNK,   _T("Nominal Cardiac Trigger Delay Time") },
{ 0x0020,0x9154,DICOM_T_UNK,   _T("Nominal Cardiac Trigger Time Prior To R-Peak") },
{ 0x0020,0x9155,DICOM_T_UNK,   _T("Actual Cardiac Trigger Time Prior To R-Peak") },
{ 0x0020,0x9156,DICOM_T_UNK,   _T("Frame Acquisition Number") },
{ 0x0020,0x9157,DICOM_T_UNK,   _T("Dimension Index Values") },
{ 0x0020,0x9158,DICOM_T_UNK,   _T("Frame Comments") },
{ 0x0020,0x9161,DICOM_T_UNK,   _T("Concatenation UID") },
{ 0x0020,0x9162,DICOM_T_UNK,   _T("In-concatenation Number") },
{ 0x0020,0x9163,DICOM_T_UNK,   _T("In-concatenation Total Number") },
{ 0x0020,0x9164,DICOM_T_UNK,   _T("Dimension Organization UID") },
{ 0x0020,0x9165,DICOM_T_UNK,   _T("Dimension Index Pointer") },
{ 0x0020,0x9167,DICOM_T_UNK,   _T("Functional Group Pointer") },
{ 0x0020,0x9170,DICOM_T_UNK,   _T("Unassigned Shared Converted Attributes Sequence") },
{ 0x0020,0x9171,DICOM_T_UNK,   _T("Unassigned Per-Frame Converted Attributes Sequence") },
{ 0x0020,0x9172,DICOM_T_UNK,   _T("Conversion Source Attributes Sequence") },
{ 0x0020,0x9213,DICOM_T_UNK,   _T("Dimension Index Private Creator") },
{ 0x0020,0x9221,DICOM_T_UNK,   _T("Dimension Organization Sequence") },
{ 0x0020,0x9222,DICOM_T_UNK,   _T("Dimension Index Sequence") },
{ 0x0020,0x9228,DICOM_T_UNK,   _T("Concatenation Frame Offset Number") },
{ 0x0020,0x9238,DICOM_T_UNK,   _T("Functional Group Private Creator") },
{ 0x0020,0x9241,DICOM_T_UNK,   _T("Nominal Percentage of Cardiac Phase") },
{ 0x0020,0x9245,DICOM_T_UNK,   _T("Nominal Percentage of Respiratory Phase") },
{ 0x0020,0x9246,DICOM_T_UNK,   _T("Starting Respiratory Amplitude") },
{ 0x0020,0x9247,DICOM_T_UNK,   _T("Starting Respiratory Phase") },
{ 0x0020,0x9248,DICOM_T_UNK,   _T("Ending Respiratory Amplitude") },
{ 0x0020,0x9249,DICOM_T_UNK,   _T("Ending Respiratory Phase") },
{ 0x0020,0x9250,DICOM_T_UNK,   _T("Respiratory Trigger Type") },
{ 0x0020,0x9251,DICOM_T_UNK,   _T("R-R Interval Time Nominal") },
{ 0x0020,0x9252,DICOM_T_UNK,   _T("Actual Cardiac Trigger Delay Time") },
{ 0x0020,0x9253,DICOM_T_UNK,   _T("Respiratory Synchronization Sequence") },
{ 0x0020,0x9254,DICOM_T_UNK,   _T("Respiratory Interval Time") },
{ 0x0020,0x9255,DICOM_T_UNK,   _T("Nominal Respiratory Trigger Delay Time") },
{ 0x0020,0x9256,DICOM_T_UNK,   _T("Respiratory Trigger Delay Threshold") },
{ 0x0020,0x9257,DICOM_T_UNK,   _T("Actual Respiratory Trigger Delay Time") },
{ 0x0020,0x9301,DICOM_T_UNK,   _T("Image Position (Volume)") },
{ 0x0020,0x9302,DICOM_T_UNK,   _T("Image Orientation (Volume)") },
{ 0x0020,0x9307,DICOM_T_UNK,   _T("Ultrasound Acquisition Geometry") },
{ 0x0020,0x9308,DICOM_T_UNK,   _T("Apex Position") },
{ 0x0020,0x9309,DICOM_T_UNK,   _T("Volume to Transducer Mapping Matrix") },
{ 0x0020,0x930A,DICOM_T_UNK,   _T("Volume to Table Mapping Matrix") },
{ 0x0020,0x930B,DICOM_T_UNK,   _T("Volume to Transducer Relationship") },
{ 0x0020,0x930C,DICOM_T_UNK,   _T("Patient Frame of Reference Source") },
{ 0x0020,0x930D,DICOM_T_UNK,   _T("Temporal Position Time Offset") },
{ 0x0020,0x930E,DICOM_T_UNK,   _T("Plane Position (Volume) Sequence") },
{ 0x0020,0x930F,DICOM_T_UNK,   _T("Plane Orientation (Volume) Sequence") },
{ 0x0020,0x9310,DICOM_T_UNK,   _T("Temporal Position Sequence") },
{ 0x0020,0x9311,DICOM_T_UNK,   _T("Dimension Organization Type") },
{ 0x0020,0x9312,DICOM_T_UNK,   _T("Volume Frame of Reference UID") },
{ 0x0020,0x9313,DICOM_T_UNK,   _T("Table Frame of Reference UID") },
{ 0x0020,0x9421,DICOM_T_UNK,   _T("Dimension Description Label") },
{ 0x0020,0x9450,DICOM_T_UNK,   _T("Patient Orientation in Frame Sequence") },
{ 0x0020,0x9453,DICOM_T_UNK,   _T("Frame Label") },
{ 0x0020,0x9518,DICOM_T_UNK,   _T("Acquisition Index") },
{ 0x0020,0x9529,DICOM_T_UNK,   _T("Contributing SOP Instances Reference Sequence") },
{ 0x0020,0x9536,DICOM_T_UNK,   _T("Reconstruction Index") },
{ 0x0022,0x0001,DICOM_T_UNK,   _T("Light Path Filter Pass-Through Wavelength") },
{ 0x0022,0x0002,DICOM_T_UNK,   _T("Light Path Filter Pass Band") },
{ 0x0022,0x0003,DICOM_T_UNK,   _T("Image Path Filter Pass-Through Wavelength") },
{ 0x0022,0x0004,DICOM_T_UNK,   _T("Image Path Filter Pass Band") },
{ 0x0022,0x0005,DICOM_T_UNK,   _T("Patient Eye Movement Commanded") },
{ 0x0022,0x0006,DICOM_T_UNK,   _T("Patient Eye Movement Command Code Sequence") },
{ 0x0022,0x0007,DICOM_T_UNK,   _T("Spherical Lens Power") },
{ 0x0022,0x0008,DICOM_T_UNK,   _T("Cylinder Lens Power") },
{ 0x0022,0x0009,DICOM_T_UNK,   _T("Cylinder Axis") },
{ 0x0022,0x000A,DICOM_T_UNK,   _T("Emmetropic Magnification") },
{ 0x0022,0x000B,DICOM_T_UNK,   _T("Intra Ocular Pressure") },
{ 0x0022,0x000C,DICOM_T_UNK,   _T("Horizontal Field of View") },
{ 0x0022,0x000D,DICOM_T_UNK,   _T("Pupil Dilated") },
{ 0x0022,0x000E,DICOM_T_UNK,   _T("Degree of Dilation") },
{ 0x0022,0x0010,DICOM_T_UNK,   _T("Stereo Baseline Angle") },
{ 0x0022,0x0011,DICOM_T_UNK,   _T("Stereo Baseline Displacement") },
{ 0x0022,0x0012,DICOM_T_UNK,   _T("Stereo Horizontal Pixel Offset") },
{ 0x0022,0x0013,DICOM_T_UNK,   _T("Stereo Vertical Pixel Offset") },
{ 0x0022,0x0014,DICOM_T_UNK,   _T("Stereo Rotation") },
{ 0x0022,0x0015,DICOM_T_UNK,   _T("Acquisition Device Type Code Sequence") },
{ 0x0022,0x0016,DICOM_T_UNK,   _T("Illumination Type Code Sequence") },
{ 0x0022,0x0017,DICOM_T_UNK,   _T("Light Path Filter Type Stack Code Sequence") },
{ 0x0022,0x0018,DICOM_T_UNK,   _T("Image Path Filter Type Stack Code Sequence") },
{ 0x0022,0x0019,DICOM_T_UNK,   _T("Lenses Code Sequence") },
{ 0x0022,0x001A,DICOM_T_UNK,   _T("Channel Description Code Sequence") },
{ 0x0022,0x001B,DICOM_T_UNK,   _T("Refractive State Sequence") },
{ 0x0022,0x001C,DICOM_T_UNK,   _T("Mydriatic Agent Code Sequence") },
{ 0x0022,0x001D,DICOM_T_UNK,   _T("Relative Image Position Code Sequence") },
{ 0x0022,0x001E,DICOM_T_UNK,   _T("Camera Angle of View") },
{ 0x0022,0x0020,DICOM_T_UNK,   _T("Stereo Pairs Sequence") },
{ 0x0022,0x0021,DICOM_T_UNK,   _T("Left Image Sequence") },
{ 0x0022,0x0022,DICOM_T_UNK,   _T("Right Image Sequence") },
{ 0x0022,0x0030,DICOM_T_UNK,   _T("Axial Length of the Eye") },
{ 0x0022,0x0031,DICOM_T_UNK,   _T("Ophthalmic Frame Location Sequence") },
{ 0x0022,0x0032,DICOM_T_UNK,   _T("Reference Coordinates") },
{ 0x0022,0x0035,DICOM_T_UNK,   _T("Depth Spatial Resolution") },
{ 0x0022,0x0036,DICOM_T_UNK,   _T("Maximum Depth Distortion") },
{ 0x0022,0x0037,DICOM_T_UNK,   _T("Along-scan Spatial Resolution") },
{ 0x0022,0x0038,DICOM_T_UNK,   _T("Maximum Along-scan Distortion") },
{ 0x0022,0x0039,DICOM_T_UNK,   _T("Ophthalmic Image Orientation") },
{ 0x0022,0x0041,DICOM_T_UNK,   _T("Depth of Transverse Image") },
{ 0x0022,0x0042,DICOM_T_UNK,   _T("Mydriatic Agent Concentration Units Sequence") },
{ 0x0022,0x0048,DICOM_T_UNK,   _T("Across-scan Spatial Resolution") },
{ 0x0022,0x0049,DICOM_T_UNK,   _T("Maximum Across-scan Distortion") },
{ 0x0022,0x004E,DICOM_T_UNK,   _T("Mydriatic Agent Concentration") },
{ 0x0022,0x0055,DICOM_T_UNK,   _T("Illumination Wave Length") },
{ 0x0022,0x0056,DICOM_T_UNK,   _T("Illumination Power") },
{ 0x0022,0x0057,DICOM_T_UNK,   _T("Illumination Bandwidth") },
{ 0x0022,0x0058,DICOM_T_UNK,   _T("Mydriatic Agent Sequence") },
{ 0x0022,0x1007,DICOM_T_UNK,   _T("Ophthalmic Axial Measurements Right Eye Sequence") },
{ 0x0022,0x1008,DICOM_T_UNK,   _T("Ophthalmic Axial Measurements Left Eye Sequence") },
{ 0x0022,0x1009,DICOM_T_UNK,   _T("Ophthalmic Axial Measurements Device Type") },
{ 0x0022,0x1010,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Type") },
{ 0x0022,0x1012,DICOM_T_UNK,   _T("Ophthalmic Axial Length Sequence") },
{ 0x0022,0x1019,DICOM_T_UNK,   _T("Ophthalmic Axial Length") },
{ 0x0022,0x1024,DICOM_T_UNK,   _T("Lens Status Code Sequence") },
{ 0x0022,0x1025,DICOM_T_UNK,   _T("Vitreous Status Code Sequence") },
{ 0x0022,0x1028,DICOM_T_UNK,   _T("IOL Formula Code Sequence") },
{ 0x0022,0x1029,DICOM_T_UNK,   _T("IOL Formula Detail") },
{ 0x0022,0x1033,DICOM_T_UNK,   _T("Keratometer Index") },
{ 0x0022,0x1035,DICOM_T_UNK,   _T("Source of Ophthalmic Axial Length Code Sequence") },
{ 0x0022,0x1037,DICOM_T_UNK,   _T("Target Refraction") },
{ 0x0022,0x1039,DICOM_T_UNK,   _T("Refractive Procedure Occurred") },
{ 0x0022,0x1040,DICOM_T_UNK,   _T("Refractive Surgery Type Code Sequence") },
{ 0x0022,0x1044,DICOM_T_UNK,   _T("Ophthalmic Ultrasound Method Code Sequence") },
{ 0x0022,0x1050,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Sequence") },
{ 0x0022,0x1053,DICOM_T_UNK,   _T("IOL Power") },
{ 0x0022,0x1054,DICOM_T_UNK,   _T("Predicted Refractive Error") },
{ 0x0022,0x1059,DICOM_T_UNK,   _T("Ophthalmic Axial Length Velocity") },
{ 0x0022,0x1065,DICOM_T_UNK,   _T("Lens Status Description") },
{ 0x0022,0x1066,DICOM_T_UNK,   _T("Vitreous Status Description") },
{ 0x0022,0x1090,DICOM_T_UNK,   _T("IOL Power Sequence") },
{ 0x0022,0x1092,DICOM_T_UNK,   _T("Lens Constant Sequence") },
{ 0x0022,0x1093,DICOM_T_UNK,   _T("IOL Manufacturer") },
{ 0x0022,0x1094,DICOM_T_UNK,   _T("Lens Constant Description") },
{ 0x0022,0x1095,DICOM_T_UNK,   _T("Implant Name") },
{ 0x0022,0x1096,DICOM_T_UNK,   _T("Keratometry Measurement Type Code Sequence") },
{ 0x0022,0x1097,DICOM_T_UNK,   _T("Implant Part Number") },
{ 0x0022,0x1100,DICOM_T_UNK,   _T("Referenced Ophthalmic Axial Measurements Sequence") },
{ 0x0022,0x1101,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Segment Name Code Sequence") },
{ 0x0022,0x1103,DICOM_T_UNK,   _T("Refractive Error Before Refractive Surgery Code Sequence") },
{ 0x0022,0x1121,DICOM_T_UNK,   _T("IOL Power For Exact Emmetropia") },
{ 0x0022,0x1122,DICOM_T_UNK,   _T("IOL Power For Exact Target Refraction") },
{ 0x0022,0x1125,DICOM_T_UNK,   _T("Anterior Chamber Depth Definition Code Sequence") },
{ 0x0022,0x1127,DICOM_T_UNK,   _T("Lens Thickness Sequence") },
{ 0x0022,0x1128,DICOM_T_UNK,   _T("Anterior Chamber Depth Sequence") },
{ 0x0022,0x1130,DICOM_T_UNK,   _T("Lens Thickness") },
{ 0x0022,0x1131,DICOM_T_UNK,   _T("Anterior Chamber Depth") },
{ 0x0022,0x1132,DICOM_T_UNK,   _T("Source of Lens Thickness Data Code Sequence") },
{ 0x0022,0x1133,DICOM_T_UNK,   _T("Source of Anterior Chamber Depth Data Code Sequence") },
{ 0x0022,0x1134,DICOM_T_UNK,   _T("Source of Refractive Measurements Sequence") },
{ 0x0022,0x1135,DICOM_T_UNK,   _T("Source of Refractive Measurements Code Sequence") },
{ 0x0022,0x1140,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurement Modified") },
{ 0x0022,0x1150,DICOM_T_UNK,   _T("Ophthalmic Axial Length Data Source Code Sequence") },
{ 0x0022,0x1153,DICOM_T_UNK,   _T("Ophthalmic Axial Length Acquisition Method Code Sequence") },
{ 0x0022,0x1155,DICOM_T_UNK,   _T("Signal to Noise Ratio") },
{ 0x0022,0x1159,DICOM_T_UNK,   _T("Ophthalmic Axial Length Data Source Description") },
{ 0x0022,0x1210,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Total Length Sequence") },
{ 0x0022,0x1211,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Segmental Length Sequence") },
{ 0x0022,0x1212,DICOM_T_UNK,   _T("Ophthalmic Axial Length Measurements Length Summation Sequence") },
{ 0x0022,0x1220,DICOM_T_UNK,   _T("Ultrasound Ophthalmic Axial Length Measurements Sequence") },
{ 0x0022,0x1225,DICOM_T_UNK,   _T("Optical Ophthalmic Axial Length Measurements Sequence") },
{ 0x0022,0x1230,DICOM_T_UNK,   _T("Ultrasound Selected Ophthalmic Axial Length Sequence") },
{ 0x0022,0x1250,DICOM_T_UNK,   _T("Ophthalmic Axial Length Selection Method Code Sequence") },
{ 0x0022,0x1255,DICOM_T_UNK,   _T("Optical Selected Ophthalmic Axial Length Sequence") },
{ 0x0022,0x1257,DICOM_T_UNK,   _T("Selected Segmental Ophthalmic Axial Length Sequence") },
{ 0x0022,0x1260,DICOM_T_UNK,   _T("Selected Total Ophthalmic Axial Length Sequence") },
{ 0x0022,0x1262,DICOM_T_UNK,   _T("Ophthalmic Axial Length Quality Metric Sequence") },
{ 0x0022,0x1265,DICOM_T_UNK,   _T("Ophthalmic Axial Length Quality Metric Type Code Sequence") },
{ 0x0022,0x1273,DICOM_T_UNK,   _T("Ophthalmic Axial Length Quality Metric Type Description") },
{ 0x0022,0x1300,DICOM_T_UNK,   _T("Intraocular Lens Calculations Right Eye Sequence") },
{ 0x0022,0x1310,DICOM_T_UNK,   _T("Intraocular Lens Calculations Left Eye Sequence") },
{ 0x0022,0x1330,DICOM_T_UNK,   _T("Referenced Ophthalmic Axial Length Measurement QC Image Sequence") },
{ 0x0022,0x1415,DICOM_T_UNK,   _T("Ophthalmic Mapping Device Type") },
{ 0x0022,0x1420,DICOM_T_UNK,   _T("Acquisition Method Code Sequence") },
{ 0x0022,0x1423,DICOM_T_UNK,   _T("Acquisition Method Algorithm Sequence") },
{ 0x0022,0x1436,DICOM_T_UNK,   _T("Ophthalmic Thickness Map Type Code Sequence") },
{ 0x0022,0x1443,DICOM_T_UNK,   _T("Ophthalmic Thickness Mapping Normals Sequence") },
{ 0x0022,0x1445,DICOM_T_UNK,   _T("Retinal Thickness Definition Code Sequence") },
{ 0x0022,0x1450,DICOM_T_UNK,   _T("Pixel Value Mapping to Coded Concept Sequence") },
{ 0x0022,0x1452,DICOM_T_UNK,   _T("Mapped Pixel Value") },
{ 0x0022,0x1454,DICOM_T_UNK,   _T("Pixel Value Mapping Explanation") },
{ 0x0022,0x1458,DICOM_T_UNK,   _T("Ophthalmic Thickness Map Quality Threshold Sequence") },
{ 0x0022,0x1460,DICOM_T_UNK,   _T("Ophthalmic Thickness Map Threshold Quality Rating") },
{ 0x0022,0x1463,DICOM_T_UNK,   _T("Anatomic Structure Reference Point") },
{ 0x0022,0x1465,DICOM_T_UNK,   _T("Registration to Localizer Sequence") },
{ 0x0022,0x1466,DICOM_T_UNK,   _T("Registered Localizer Units") },
{ 0x0022,0x1467,DICOM_T_UNK,   _T("Registered Localizer Top Left Hand Corner") },
{ 0x0022,0x1468,DICOM_T_UNK,   _T("Registered Localizer Bottom Right Hand Corner") },
{ 0x0022,0x1470,DICOM_T_UNK,   _T("Ophthalmic Thickness Map Quality Rating Sequence") },
{ 0x0022,0x1472,DICOM_T_UNK,   _T("Relevant OPT Attributes Sequence") },
{ 0x0024,0x0010,DICOM_T_UNK,   _T("Visual Field Horizontal Extent") },
{ 0x0024,0x0011,DICOM_T_UNK,   _T("Visual Field Vertical Extent") },
{ 0x0024,0x0012,DICOM_T_UNK,   _T("Visual Field Shape") },
{ 0x0024,0x0016,DICOM_T_UNK,   _T("Screening Test Mode Code Sequence") },
{ 0x0024,0x0018,DICOM_T_UNK,   _T("Maximum Stimulus Luminance") },
{ 0x0024,0x0020,DICOM_T_UNK,   _T("Background Luminance") },
{ 0x0024,0x0021,DICOM_T_UNK,   _T("Stimulus Color Code Sequence") },
{ 0x0024,0x0024,DICOM_T_UNK,   _T("Background Illumination Color Code Sequence") },
{ 0x0024,0x0025,DICOM_T_UNK,   _T("Stimulus Area") },
{ 0x0024,0x0028,DICOM_T_UNK,   _T("Stimulus Presentation Time") },
{ 0x0024,0x0032,DICOM_T_UNK,   _T("Fixation Sequence") },
{ 0x0024,0x0033,DICOM_T_UNK,   _T("Fixation Monitoring Code Sequence") },
{ 0x0024,0x0034,DICOM_T_UNK,   _T("Visual Field Catch Trial Sequence") },
{ 0x0024,0x0035,DICOM_T_UNK,   _T("Fixation Checked Quantity") },
{ 0x0024,0x0036,DICOM_T_UNK,   _T("Patient Not Properly Fixated Quantity") },
{ 0x0024,0x0037,DICOM_T_UNK,   _T("Presented Visual Stimuli Data Flag") },
{ 0x0024,0x0038,DICOM_T_UNK,   _T("Number of Visual Stimuli") },
{ 0x0024,0x0039,DICOM_T_UNK,   _T("Excessive Fixation Losses Data Flag") },
{ 0x0024,0x0040,DICOM_T_UNK,   _T("Excessive Fixation Losses") },
{ 0x0024,0x0042,DICOM_T_UNK,   _T("Stimuli Retesting Quantity") },
{ 0x0024,0x0044,DICOM_T_UNK,   _T("Comments on Patient's Performance of Visual Field") },
{ 0x0024,0x0045,DICOM_T_UNK,   _T("False Negatives Estimate Flag") },
{ 0x0024,0x0046,DICOM_T_UNK,   _T("False Negatives Estimate") },
{ 0x0024,0x0048,DICOM_T_UNK,   _T("Negative Catch Trials Quantity") },
{ 0x0024,0x0050,DICOM_T_UNK,   _T("False Negatives Quantity") },
{ 0x0024,0x0051,DICOM_T_UNK,   _T("Excessive False Negatives Data Flag") },
{ 0x0024,0x0052,DICOM_T_UNK,   _T("Excessive False Negatives") },
{ 0x0024,0x0053,DICOM_T_UNK,   _T("False Positives Estimate Flag") },
{ 0x0024,0x0054,DICOM_T_UNK,   _T("False Positives Estimate") },
{ 0x0024,0x0055,DICOM_T_UNK,   _T("Catch Trials Data Flag") },
{ 0x0024,0x0056,DICOM_T_UNK,   _T("Positive Catch Trials Quantity") },
{ 0x0024,0x0057,DICOM_T_UNK,   _T("Test Point Normals Data Flag") },
{ 0x0024,0x0058,DICOM_T_UNK,   _T("Test Point Normals Sequence") },
{ 0x0024,0x0059,DICOM_T_UNK,   _T("Global Deviation Probability Normals Flag") },
{ 0x0024,0x0060,DICOM_T_UNK,   _T("False Positives Quantity") },
{ 0x0024,0x0061,DICOM_T_UNK,   _T("Excessive False Positives Data Flag") },
{ 0x0024,0x0062,DICOM_T_UNK,   _T("Excessive False Positives") },
{ 0x0024,0x0063,DICOM_T_UNK,   _T("Visual Field Test Normals Flag") },
{ 0x0024,0x0064,DICOM_T_UNK,   _T("Results Normals Sequence") },
{ 0x0024,0x0065,DICOM_T_UNK,   _T("Age Corrected Sensitivity Deviation Algorithm Sequence") },
{ 0x0024,0x0066,DICOM_T_UNK,   _T("Global Deviation From Normal") },
{ 0x0024,0x0067,DICOM_T_UNK,   _T("Generalized Defect Sensitivity Deviation Algorithm Sequence") },
{ 0x0024,0x0068,DICOM_T_UNK,   _T("Localized Deviation From Normal") },
{ 0x0024,0x0069,DICOM_T_UNK,   _T("Patient Reliability Indicator") },
{ 0x0024,0x0070,DICOM_T_UNK,   _T("Visual Field Mean Sensitivity") },
{ 0x0024,0x0071,DICOM_T_UNK,   _T("Global Deviation Probability") },
{ 0x0024,0x0072,DICOM_T_UNK,   _T("Local Deviation Probability Normals Flag") },
{ 0x0024,0x0073,DICOM_T_UNK,   _T("Localized Deviation Probability") },
{ 0x0024,0x0074,DICOM_T_UNK,   _T("Short Term Fluctuation Calculated") },
{ 0x0024,0x0075,DICOM_T_UNK,   _T("Short Term Fluctuation") },
{ 0x0024,0x0076,DICOM_T_UNK,   _T("Short Term Fluctuation Probability Calculated") },
{ 0x0024,0x0077,DICOM_T_UNK,   _T("Short Term Fluctuation Probability") },
{ 0x0024,0x0078,DICOM_T_UNK,   _T("Corrected Localized Deviation From Normal Calculated") },
{ 0x0024,0x0079,DICOM_T_UNK,   _T("Corrected Localized Deviation From Normal") },
{ 0x0024,0x0080,DICOM_T_UNK,   _T("Corrected Localized Deviation From Normal Probability Calculated") },
{ 0x0024,0x0081,DICOM_T_UNK,   _T("Corrected Localized Deviation From Normal Probability") },
{ 0x0024,0x0083,DICOM_T_UNK,   _T("Global Deviation Probability Sequence") },
{ 0x0024,0x0085,DICOM_T_UNK,   _T("Localized Deviation Probability Sequence") },
{ 0x0024,0x0086,DICOM_T_UNK,   _T("Foveal Sensitivity Measured") },
{ 0x0024,0x0087,DICOM_T_UNK,   _T("Foveal Sensitivity") },
{ 0x0024,0x0088,DICOM_T_UNK,   _T("Visual Field Test Duration") },
{ 0x0024,0x0089,DICOM_T_UNK,   _T("Visual Field Test Point Sequence") },
{ 0x0024,0x0090,DICOM_T_UNK,   _T("Visual Field Test Point X-Coordinate") },
{ 0x0024,0x0091,DICOM_T_UNK,   _T("Visual Field Test Point Y-Coordinate") },
{ 0x0024,0x0092,DICOM_T_UNK,   _T("Age Corrected Sensitivity Deviation Value") },
{ 0x0024,0x0093,DICOM_T_UNK,   _T("Stimulus Results") },
{ 0x0024,0x0094,DICOM_T_UNK,   _T("Sensitivity Value") },
{ 0x0024,0x0095,DICOM_T_UNK,   _T("Retest Stimulus Seen") },
{ 0x0024,0x0096,DICOM_T_UNK,   _T("Retest Sensitivity Value") },
{ 0x0024,0x0097,DICOM_T_UNK,   _T("Visual Field Test Point Normals Sequence") },
{ 0x0024,0x0098,DICOM_T_UNK,   _T("Quantified Defect") },
{ 0x0024,0x0100,DICOM_T_UNK,   _T("Age Corrected Sensitivity Deviation Probability Value") },
{ 0x0024,0x0102,DICOM_T_UNK,   _T("Generalized Defect Corrected Sensitivity Deviation Flag") },
{ 0x0024,0x0103,DICOM_T_UNK,   _T("Generalized Defect Corrected Sensitivity Deviation Value") },
{ 0x0024,0x0104,DICOM_T_UNK,   _T("Generalized Defect Corrected Sensitivity Deviation Probability Value") },
{ 0x0024,0x0105,DICOM_T_UNK,   _T("Minimum Sensitivity Value") },
{ 0x0024,0x0106,DICOM_T_UNK,   _T("Blind Spot Localized") },
{ 0x0024,0x0107,DICOM_T_UNK,   _T("Blind Spot X-Coordinate") },
{ 0x0024,0x0108,DICOM_T_UNK,   _T("Blind Spot Y-Coordinate") },
{ 0x0024,0x0110,DICOM_T_UNK,   _T("Visual Acuity Measurement Sequence") },
{ 0x0024,0x0112,DICOM_T_UNK,   _T("Refractive Parameters Used on Patient Sequence") },
{ 0x0024,0x0113,DICOM_T_UNK,   _T("Measurement Laterality") },
{ 0x0024,0x0114,DICOM_T_UNK,   _T("Ophthalmic Patient Clinical Information Left Eye Sequence") },
{ 0x0024,0x0115,DICOM_T_UNK,   _T("Ophthalmic Patient Clinical Information Right Eye Sequence") },
{ 0x0024,0x0117,DICOM_T_UNK,   _T("Foveal Point Normative Data Flag") },
{ 0x0024,0x0118,DICOM_T_UNK,   _T("Foveal Point Probability Value") },
{ 0x0024,0x0120,DICOM_T_UNK,   _T("Screening Baseline Measured") },
{ 0x0024,0x0122,DICOM_T_UNK,   _T("Screening Baseline Measured Sequence") },
{ 0x0024,0x0124,DICOM_T_UNK,   _T("Screening Baseline Type") },
{ 0x0024,0x0126,DICOM_T_UNK,   _T("Screening Baseline Value") },
{ 0x0024,0x0202,DICOM_T_UNK,   _T("Algorithm Source") },
{ 0x0024,0x0306,DICOM_T_UNK,   _T("Data Set Name") },
{ 0x0024,0x0307,DICOM_T_UNK,   _T("Data Set Version") },
{ 0x0024,0x0308,DICOM_T_UNK,   _T("Data Set Source") },
{ 0x0024,0x0309,DICOM_T_UNK,   _T("Data Set Description") },
{ 0x0024,0x0317,DICOM_T_UNK,   _T("Visual Field Test Reliability Global Index Sequence") },
{ 0x0024,0x0320,DICOM_T_UNK,   _T("Visual Field Global Results Index Sequence") },
{ 0x0024,0x0325,DICOM_T_UNK,   _T("Data Observation Sequence") },
{ 0x0024,0x0338,DICOM_T_UNK,   _T("Index Normals Flag") },
{ 0x0024,0x0341,DICOM_T_UNK,   _T("Index Probability") },
{ 0x0024,0x0344,DICOM_T_UNK,   _T("Index Probability Sequence") },
{ 0x0028,0x0002,DICOM_T_UNK,   _T("Samples per Pixel") },
{ 0x0028,0x0003,DICOM_T_UNK,   _T("Samples per Pixel Used") },
{ 0x0028,0x0004,DICOM_T_UNK,   _T("Photometric Interpretation") },
{ 0x0028,0x0005,DICOM_T_UNK,   _T("Image Dimensions") },
{ 0x0028,0x0006,DICOM_T_UNK,   _T("Planar Configuration") },
{ 0x0028,0x0008,DICOM_T_UNK,   _T("Number of Frames") },
{ 0x0028,0x0009,DICOM_T_UNK,   _T("Frame Increment Pointer") },
{ 0x0028,0x000A,DICOM_T_UNK,   _T("Frame Dimension Pointer") },
{ 0x0028,0x0010,DICOM_T_UNK,   _T("Rows") },
{ 0x0028,0x0011,DICOM_T_UNK,   _T("Columns") },
{ 0x0028,0x0012,DICOM_T_UNK,   _T("Planes") },
{ 0x0028,0x0014,DICOM_T_UNK,   _T("Ultrasound Color Data Present") },
{ 0x0028,0x0020,DICOM_T_UNK,   _T("") },
{ 0x0028,0x0030,DICOM_T_UNK,   _T("Pixel Spacing") },
{ 0x0028,0x0031,DICOM_T_UNK,   _T("Zoom Factor") },
{ 0x0028,0x0032,DICOM_T_UNK,   _T("Zoom Center") },
{ 0x0028,0x0034,DICOM_T_UNK,   _T("Pixel Aspect Ratio") },
{ 0x0028,0x0040,DICOM_T_UNK,   _T("Image Format") },
{ 0x0028,0x0050,DICOM_T_UNK,   _T("Manipulated Image") },
{ 0x0028,0x0051,DICOM_T_UNK,   _T("Corrected Image") },
{ 0x0028,0x005F,DICOM_T_UNK,   _T("Compression Recognition Code") },
{ 0x0028,0x0060,DICOM_T_UNK,   _T("Compression Code") },
{ 0x0028,0x0061,DICOM_T_UNK,   _T("Compression Originator") },
{ 0x0028,0x0062,DICOM_T_UNK,   _T("Compression Label") },
{ 0x0028,0x0063,DICOM_T_UNK,   _T("Compression Description") },
{ 0x0028,0x0065,DICOM_T_UNK,   _T("Compression Sequence") },
{ 0x0028,0x0066,DICOM_T_UNK,   _T("Compression Step Pointers") },
{ 0x0028,0x0068,DICOM_T_UNK,   _T("Repeat Interval") },
{ 0x0028,0x0069,DICOM_T_UNK,   _T("Bits Grouped") },
{ 0x0028,0x0070,DICOM_T_UNK,   _T("Perimeter Table") },
{ 0x0028,0x0071,DICOM_T_UNK,   _T("Perimeter Value") },
{ 0x0028,0x0080,DICOM_T_UNK,   _T("Predictor Rows") },
{ 0x0028,0x0081,DICOM_T_UNK,   _T("Predictor Columns") },
{ 0x0028,0x0082,DICOM_T_UNK,   _T("Predictor Constants") },
{ 0x0028,0x0090,DICOM_T_UNK,   _T("Blocked Pixels") },
{ 0x0028,0x0091,DICOM_T_UNK,   _T("Block Rows") },
{ 0x0028,0x0092,DICOM_T_UNK,   _T("Block Columns") },
{ 0x0028,0x0093,DICOM_T_UNK,   _T("Row Overlap") },
{ 0x0028,0x0094,DICOM_T_UNK,   _T("Column Overlap") },
{ 0x0028,0x0100,DICOM_T_UNK,   _T("Bits Allocated") },
{ 0x0028,0x0101,DICOM_T_UNK,   _T("Bits Stored") },
{ 0x0028,0x0102,DICOM_T_UNK,   _T("High Bit") },
{ 0x0028,0x0103,DICOM_T_UNK,   _T("Pixel Representation") },
{ 0x0028,0x0104,DICOM_T_UNK,   _T("Smallest Valid Pixel Value") },
{ 0x0028,0x0105,DICOM_T_UNK,   _T("Largest Valid Pixel Value") },
{ 0x0028,0x0106,DICOM_T_UNK,   _T("Smallest Image Pixel Value") },
{ 0x0028,0x0107,DICOM_T_UNK,   _T("Largest Image Pixel Value") },
{ 0x0028,0x0108,DICOM_T_UNK,   _T("Smallest Pixel Value in Series") },
{ 0x0028,0x0109,DICOM_T_UNK,   _T("Largest Pixel Value in Series") },
{ 0x0028,0x0110,DICOM_T_UNK,   _T("Smallest Image Pixel Value in Plane") },
{ 0x0028,0x0111,DICOM_T_UNK,   _T("Largest Image Pixel Value in Plane") },
{ 0x0028,0x0120,DICOM_T_UNK,   _T("Pixel Padding Value") },
{ 0x0028,0x0121,DICOM_T_UNK,   _T("Pixel Padding Range Limit") },
{ 0x0028,0x0200,DICOM_T_UNK,   _T("Image Location") },
{ 0x0028,0x0300,DICOM_T_UNK,   _T("Quality Control Image") },
{ 0x0028,0x0301,DICOM_T_UNK,   _T("Burned In Annotation") },
{ 0x0028,0x0302,DICOM_T_UNK,   _T("Recognizable Visual Features") },
{ 0x0028,0x0303,DICOM_T_UNK,   _T("Longitudinal Temporal Information Modified") },
{ 0x0028,0x0304,DICOM_T_UNK,   _T("Referenced Color Palette Instance UID") },
{ 0x0028,0x0400,DICOM_T_UNK,   _T("Transform Label") },
{ 0x0028,0x0401,DICOM_T_UNK,   _T("Transform Version Number") },
{ 0x0028,0x0402,DICOM_T_UNK,   _T("Number of Transform Steps") },
{ 0x0028,0x0403,DICOM_T_UNK,   _T("Sequence of Compressed Data") },
{ 0x0028,0x0404,DICOM_T_UNK,   _T("Details of Coefficients") },
/*
{ 0x0028,0x04x0,DICOM_T_UNK,   _T("Rows For Nth Order Coefficients") },
{ 0x0028,0x04x1,DICOM_T_UNK,   _T("Columns For Nth Order Coefficients") },
{ 0x0028,0x04x2,DICOM_T_UNK,   _T("Coefficient Coding") },
{ 0x0028,0x04x3,DICOM_T_UNK,   _T("Coefficient Coding Pointers") },
*/
{ 0x0028,0x0700,DICOM_T_UNK,   _T("DCT Label") },
{ 0x0028,0x0701,DICOM_T_UNK,   _T("Data Block Description") },
{ 0x0028,0x0702,DICOM_T_UNK,   _T("Data Block") },
{ 0x0028,0x0710,DICOM_T_UNK,   _T("Normalization Factor Format") },
{ 0x0028,0x0720,DICOM_T_UNK,   _T("Zonal Map Number Format") },
{ 0x0028,0x0721,DICOM_T_UNK,   _T("Zonal Map Location") },
{ 0x0028,0x0722,DICOM_T_UNK,   _T("Zonal Map Format") },
{ 0x0028,0x0730,DICOM_T_UNK,   _T("Adaptive Map Format") },
{ 0x0028,0x0740,DICOM_T_UNK,   _T("Code Number Format") },
/*
{ 0x0028,0x08x0,DICOM_T_UNK,   _T("Code Label") },
{ 0x0028,0x08x2,DICOM_T_UNK,   _T("Number of Tables") },
{ 0x0028,0x08x3,DICOM_T_UNK,   _T("Code Table Location") },
{ 0x0028,0x08x4,DICOM_T_UNK,   _T("Bits For Code Word") },
{ 0x0028,0x08x8,DICOM_T_UNK,   _T("Image Data Location") },
*/
{ 0x0028,0x0A02,DICOM_T_UNK,   _T("Pixel Spacing Calibration Type") },
{ 0x0028,0x0A04,DICOM_T_UNK,   _T("Pixel Spacing Calibration Description") },
{ 0x0028,0x1040,DICOM_T_UNK,   _T("Pixel Intensity Relationship") },
{ 0x0028,0x1041,DICOM_T_UNK,   _T("Pixel Intensity Relationship Sign") },
{ 0x0028,0x1050,DICOM_T_UNK,   _T("Window Center") },
{ 0x0028,0x1051,DICOM_T_UNK,   _T("Window Width") },
{ 0x0028,0x1052,DICOM_T_UNK,   _T("Rescale Intercept") },
{ 0x0028,0x1053,DICOM_T_UNK,   _T("Rescale Slope") },
{ 0x0028,0x1054,DICOM_T_UNK,   _T("Rescale Type") },
{ 0x0028,0x1055,DICOM_T_UNK,   _T("Window Center & Width Explanation") },
{ 0x0028,0x1056,DICOM_T_UNK,   _T("VOI LUT Function") },
{ 0x0028,0x1080,DICOM_T_UNK,   _T("Gray Scale") },
{ 0x0028,0x1090,DICOM_T_UNK,   _T("Recommended Viewing Mode") },
{ 0x0028,0x1100,DICOM_T_UNK,   _T("Gray Lookup Table Descriptor") },
{ 0x0028,0x1101,DICOM_T_UNK,   _T("Red Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1102,DICOM_T_UNK,   _T("Green Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1103,DICOM_T_UNK,   _T("Blue Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1104,DICOM_T_UNK,   _T("Alpha Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1111,DICOM_T_UNK,   _T("Large Red Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1112,DICOM_T_UNK,   _T("Large Green Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1113,DICOM_T_UNK,   _T("Large Blue Palette Color Lookup Table Descriptor") },
{ 0x0028,0x1199,DICOM_T_UNK,   _T("Palette Color Lookup Table UID") },
{ 0x0028,0x1200,DICOM_T_UNK,   _T("Gray Lookup Table Data") },
{ 0x0028,0x1201,DICOM_T_UNK,   _T("Red Palette Color Lookup Table Data") },
{ 0x0028,0x1202,DICOM_T_UNK,   _T("Green Palette Color Lookup Table Data") },
{ 0x0028,0x1203,DICOM_T_UNK,   _T("Blue Palette Color Lookup Table Data") },
{ 0x0028,0x1204,DICOM_T_UNK,   _T("Alpha Palette Color Lookup Table Data") },
{ 0x0028,0x1211,DICOM_T_UNK,   _T("Large Red Palette Color Lookup Table Data") },
{ 0x0028,0x1212,DICOM_T_UNK,   _T("Large Green Palette Color Lookup Table Data") },
{ 0x0028,0x1213,DICOM_T_UNK,   _T("Large Blue Palette Color Lookup Table Data") },
{ 0x0028,0x1214,DICOM_T_UNK,   _T("Large Palette Color Lookup Table UID") },
{ 0x0028,0x1221,DICOM_T_UNK,   _T("Segmented Red Palette Color Lookup Table Data") },
{ 0x0028,0x1222,DICOM_T_UNK,   _T("Segmented Green Palette Color Lookup Table Data") },
{ 0x0028,0x1223,DICOM_T_UNK,   _T("Segmented Blue Palette Color Lookup Table Data") },
{ 0x0028,0x1300,DICOM_T_UNK,   _T("Breast Implant Present") },
{ 0x0028,0x1350,DICOM_T_UNK,   _T("Partial View") },
{ 0x0028,0x1351,DICOM_T_UNK,   _T("Partial View Description") },
{ 0x0028,0x1352,DICOM_T_UNK,   _T("Partial View Code Sequence") },
{ 0x0028,0x135A,DICOM_T_UNK,   _T("Spatial Locations Preserved") },
{ 0x0028,0x1401,DICOM_T_UNK,   _T("Data Frame Assignment Sequence") },
{ 0x0028,0x1402,DICOM_T_UNK,   _T("Data Path Assignment") },
{ 0x0028,0x1403,DICOM_T_UNK,   _T("Bits Mapped to Color Lookup Table") },
{ 0x0028,0x1404,DICOM_T_UNK,   _T("Blending LUT 1 Sequence") },
{ 0x0028,0x1405,DICOM_T_UNK,   _T("Blending LUT 1 Transfer Function") },
{ 0x0028,0x1406,DICOM_T_UNK,   _T("Blending Weight Constant") },
{ 0x0028,0x1407,DICOM_T_UNK,   _T("Blending Lookup Table Descriptor") },
{ 0x0028,0x1408,DICOM_T_UNK,   _T("Blending Lookup Table Data") },
{ 0x0028,0x140B,DICOM_T_UNK,   _T("Enhanced Palette Color Lookup Table Sequence") },
{ 0x0028,0x140C,DICOM_T_UNK,   _T("Blending LUT 2 Sequence") },
{ 0x0028,0x140D,DICOM_T_UNK,   _T("Blending LUT 2 Transfer Function") },
{ 0x0028,0x140E,DICOM_T_UNK,   _T("Data Path ID") },
{ 0x0028,0x140F,DICOM_T_UNK,   _T("RGB LUT Transfer Function") },
{ 0x0028,0x1410,DICOM_T_UNK,   _T("Alpha LUT Transfer Function") },
{ 0x0028,0x2000,DICOM_T_UNK,   _T("ICC Profile") },
{ 0x0028,0x2110,DICOM_T_UNK,   _T("Lossy Image Compression") },
{ 0x0028,0x2112,DICOM_T_UNK,   _T("Lossy Image Compression Ratio") },
{ 0x0028,0x2114,DICOM_T_UNK,   _T("Lossy Image Compression Method") },
{ 0x0028,0x3000,DICOM_T_UNK,   _T("Modality LUT Sequence") },
{ 0x0028,0x3002,DICOM_T_UNK,   _T("LUT Descriptor") },
{ 0x0028,0x3003,DICOM_T_UNK,   _T("LUT Explanation") },
{ 0x0028,0x3004,DICOM_T_UNK,   _T("Modality LUT Type") },
{ 0x0028,0x3006,DICOM_T_UNK,   _T("LUT Data") },
{ 0x0028,0x3010,DICOM_T_UNK,   _T("VOI LUT Sequence") },
{ 0x0028,0x3110,DICOM_T_UNK,   _T("Softcopy VOI LUT Sequence") },
{ 0x0028,0x4000,DICOM_T_UNK,   _T("Image Presentation Comments") },
{ 0x0028,0x5000,DICOM_T_UNK,   _T("Bi-Plane Acquisition Sequence") },
{ 0x0028,0x6010,DICOM_T_UNK,   _T("Representative Frame Number") },
{ 0x0028,0x6020,DICOM_T_UNK,   _T("Frame Numbers of Interest (FOI)") },
{ 0x0028,0x6022,DICOM_T_UNK,   _T("Frame of Interest Description") },
{ 0x0028,0x6023,DICOM_T_UNK,   _T("Frame of Interest Type") },
{ 0x0028,0x6030,DICOM_T_UNK,   _T("Mask Pointer(s)") },
{ 0x0028,0x6040,DICOM_T_UNK,   _T("R Wave Pointer") },
{ 0x0028,0x6100,DICOM_T_UNK,   _T("Mask Subtraction Sequence") },
{ 0x0028,0x6101,DICOM_T_UNK,   _T("Mask Operation") },
{ 0x0028,0x6102,DICOM_T_UNK,   _T("Applicable Frame Range") },
{ 0x0028,0x6110,DICOM_T_UNK,   _T("Mask Frame Numbers") },
{ 0x0028,0x6112,DICOM_T_UNK,   _T("Contrast Frame Averaging") },
{ 0x0028,0x6114,DICOM_T_UNK,   _T("Mask Sub-pixel Shift") },
{ 0x0028,0x6120,DICOM_T_UNK,   _T("TID Offset") },
{ 0x0028,0x6190,DICOM_T_UNK,   _T("Mask Operation Explanation") },
{ 0x0028,0x7000,DICOM_T_UNK,   _T("Equipment Administrator Sequence") },
{ 0x0028,0x7001,DICOM_T_UNK,   _T("Number of Display Subsystems") },
{ 0x0028,0x7002,DICOM_T_UNK,   _T("Current Configuration ID") },
{ 0x0028,0x7003,DICOM_T_UNK,   _T("Display Subsystem ID") },
{ 0x0028,0x7004,DICOM_T_UNK,   _T("Display Subsystem Name") },
{ 0x0028,0x7005,DICOM_T_UNK,   _T("Display Subsystem Description") },
{ 0x0028,0x7006,DICOM_T_UNK,   _T("System Status") },
{ 0x0028,0x7007,DICOM_T_UNK,   _T("System Status Comment") },
{ 0x0028,0x7008,DICOM_T_UNK,   _T("Target Luminance Characteristics Sequence") },
{ 0x0028,0x7009,DICOM_T_UNK,   _T("Luminance Characteristics ID") },
{ 0x0028,0x700A,DICOM_T_UNK,   _T("Display Subsystem Configuration Sequence") },
{ 0x0028,0x700B,DICOM_T_UNK,   _T("Configuration ID") },
{ 0x0028,0x700C,DICOM_T_UNK,   _T("Configuration Name") },
{ 0x0028,0x700D,DICOM_T_UNK,   _T("Configuration Description") },
{ 0x0028,0x700E,DICOM_T_UNK,   _T("Referenced Target Luminance Characteristics ID") },
{ 0x0028,0x700F,DICOM_T_UNK,   _T("QA Results Sequence") },
{ 0x0028,0x7010,DICOM_T_UNK,   _T("Display Subsystem QA Results Sequence") },
{ 0x0028,0x7011,DICOM_T_UNK,   _T("Configuration QA Results Sequence") },
{ 0x0028,0x7012,DICOM_T_UNK,   _T("Measurement Equipment Sequence") },
{ 0x0028,0x7013,DICOM_T_UNK,   _T("Measurement Functions") },
{ 0x0028,0x7014,DICOM_T_UNK,   _T("Measurement Equipment Type") },
{ 0x0028,0x7015,DICOM_T_UNK,   _T("Visual Evaluation Result Sequence") },
{ 0x0028,0x7016,DICOM_T_UNK,   _T("Display Calibration Result Sequence") },
{ 0x0028,0x7017,DICOM_T_UNK,   _T("DDL Value") },
{ 0x0028,0x7018,DICOM_T_UNK,   _T("CIExy White Point") },
{ 0x0028,0x7019,DICOM_T_UNK,   _T("Display Function Type") },
{ 0x0028,0x701A,DICOM_T_UNK,   _T("Gamma Value") },
{ 0x0028,0x701B,DICOM_T_UNK,   _T("Number of Luminance Points") },
{ 0x0028,0x701C,DICOM_T_UNK,   _T("Luminance Response Sequence") },
{ 0x0028,0x701D,DICOM_T_UNK,   _T("Target Minimum Luminance") },
{ 0x0028,0x701E,DICOM_T_UNK,   _T("Target Maximum Luminance") },
{ 0x0028,0x701F,DICOM_T_UNK,   _T("Luminance Value") },
{ 0x0028,0x7020,DICOM_T_UNK,   _T("Luminance Response Description") },
{ 0x0028,0x7021,DICOM_T_UNK,   _T("White Point Flag") },
{ 0x0028,0x7022,DICOM_T_UNK,   _T("Display Device Type Code Sequence") },
{ 0x0028,0x7023,DICOM_T_UNK,   _T("Display Subsystem Sequence") },
{ 0x0028,0x7024,DICOM_T_UNK,   _T("Luminance Result Sequence") },
{ 0x0028,0x7025,DICOM_T_UNK,   _T("Ambient Light Value Source") },
{ 0x0028,0x7026,DICOM_T_UNK,   _T("Measured Characteristics") },
{ 0x0028,0x7027,DICOM_T_UNK,   _T("Luminance Uniformity Result Sequence") },
{ 0x0028,0x7028,DICOM_T_UNK,   _T("Visual Evaluation Test Sequence") },
{ 0x0028,0x7029,DICOM_T_UNK,   _T("Test Result") },
{ 0x0028,0x702A,DICOM_T_UNK,   _T("Test Result Comment") },
{ 0x0028,0x702B,DICOM_T_UNK,   _T("Test Image Validation") },
{ 0x0028,0x702C,DICOM_T_UNK,   _T("Test Pattern Code Sequence") },
{ 0x0028,0x702D,DICOM_T_UNK,   _T("Measurement Pattern Code Sequence") },
{ 0x0028,0x702E,DICOM_T_UNK,   _T("Visual Evaluation Method Code Sequence") },
{ 0x0028,0x7FE0,DICOM_T_UNK,   _T("Pixel Data Provider URL") },
{ 0x0028,0x9001,DICOM_T_UNK,   _T("Data Point Rows") },
{ 0x0028,0x9002,DICOM_T_UNK,   _T("Data Point Columns") },
{ 0x0028,0x9003,DICOM_T_UNK,   _T("Signal Domain Columns") },
{ 0x0028,0x9099,DICOM_T_UNK,   _T("Largest Monochrome Pixel Value") },
{ 0x0028,0x9108,DICOM_T_UNK,   _T("Data Representation") },
{ 0x0028,0x9110,DICOM_T_UNK,   _T("Pixel Measures Sequence") },
{ 0x0028,0x9132,DICOM_T_UNK,   _T("Frame VOI LUT Sequence") },
{ 0x0028,0x9145,DICOM_T_UNK,   _T("Pixel Value Transformation Sequence") },
{ 0x0028,0x9235,DICOM_T_UNK,   _T("Signal Domain Rows") },
{ 0x0028,0x9411,DICOM_T_UNK,   _T("Display Filter Percentage") },
{ 0x0028,0x9415,DICOM_T_UNK,   _T("Frame Pixel Shift Sequence") },
{ 0x0028,0x9416,DICOM_T_UNK,   _T("Subtraction Item ID") },
{ 0x0028,0x9422,DICOM_T_UNK,   _T("Pixel Intensity Relationship LUT Sequence") },
{ 0x0028,0x9443,DICOM_T_UNK,   _T("Frame Pixel Data Properties Sequence") },
{ 0x0028,0x9444,DICOM_T_UNK,   _T("Geometrical Properties") },
{ 0x0028,0x9445,DICOM_T_UNK,   _T("Geometric Maximum Distortion") },
{ 0x0028,0x9446,DICOM_T_UNK,   _T("Image Processing Applied") },
{ 0x0028,0x9454,DICOM_T_UNK,   _T("Mask Selection Mode") },
{ 0x0028,0x9474,DICOM_T_UNK,   _T("LUT Function") },
{ 0x0028,0x9478,DICOM_T_UNK,   _T("Mask Visibility Percentage") },
{ 0x0028,0x9501,DICOM_T_UNK,   _T("Pixel Shift Sequence") },
{ 0x0028,0x9502,DICOM_T_UNK,   _T("Region Pixel Shift Sequence") },
{ 0x0028,0x9503,DICOM_T_UNK,   _T("Vertices of the Region") },
{ 0x0028,0x9505,DICOM_T_UNK,   _T("Multi-frame Presentation Sequence") },
{ 0x0028,0x9506,DICOM_T_UNK,   _T("Pixel Shift Frame Range") },
{ 0x0028,0x9507,DICOM_T_UNK,   _T("LUT Frame Range") },
{ 0x0028,0x9520,DICOM_T_UNK,   _T("Image to Equipment Mapping Matrix") },
{ 0x0028,0x9537,DICOM_T_UNK,   _T("Equipment Coordinate System Identification") },
{ 0x0032,0x000A,DICOM_T_UNK,   _T("Study Status ID") },
{ 0x0032,0x000C,DICOM_T_UNK,   _T("Study Priority ID") },
{ 0x0032,0x0012,DICOM_T_UNK,   _T("Study ID Issuer") },
{ 0x0032,0x0032,DICOM_T_UNK,   _T("Study Verified Date") },
{ 0x0032,0x0033,DICOM_T_UNK,   _T("Study Verified Time") },
{ 0x0032,0x0034,DICOM_T_UNK,   _T("Study Read Date") },
{ 0x0032,0x0035,DICOM_T_UNK,   _T("Study Read Time") },
{ 0x0032,0x1000,DICOM_T_UNK,   _T("Scheduled Study Start Date") },
{ 0x0032,0x1001,DICOM_T_UNK,   _T("Scheduled Study Start Time") },
{ 0x0032,0x1010,DICOM_T_UNK,   _T("Scheduled Study Stop Date") },
{ 0x0032,0x1011,DICOM_T_UNK,   _T("Scheduled Study Stop Time") },
{ 0x0032,0x1020,DICOM_T_UNK,   _T("Scheduled Study Location") },
{ 0x0032,0x1021,DICOM_T_UNK,   _T("Scheduled Study Location AE Title") },
{ 0x0032,0x1030,DICOM_T_UNK,   _T("Reason for Study") },
{ 0x0032,0x1031,DICOM_T_UNK,   _T("Requesting Physician Identification Sequence") },
{ 0x0032,0x1032,DICOM_T_UNK,   _T("Requesting Physician") },
{ 0x0032,0x1033,DICOM_T_UNK,   _T("Requesting Service") },
{ 0x0032,0x1034,DICOM_T_UNK,   _T("Requesting Service Code Sequence") },
{ 0x0032,0x1040,DICOM_T_UNK,   _T("Study Arrival Date") },
{ 0x0032,0x1041,DICOM_T_UNK,   _T("Study Arrival Time") },
{ 0x0032,0x1050,DICOM_T_UNK,   _T("Study Completion Date") },
{ 0x0032,0x1051,DICOM_T_UNK,   _T("Study Completion Time") },
{ 0x0032,0x1055,DICOM_T_UNK,   _T("Study Component Status ID") },
{ 0x0032,0x1060,DICOM_T_UNK,   _T("Requested Procedure Description") },
{ 0x0032,0x1064,DICOM_T_UNK,   _T("Requested Procedure Code Sequence") },
{ 0x0032,0x1070,DICOM_T_UNK,   _T("Requested Contrast Agent") },
{ 0x0032,0x4000,DICOM_T_UNK,   _T("Study Comments") },
{ 0x0038,0x0004,DICOM_T_UNK,   _T("Referenced Patient Alias Sequence") },
{ 0x0038,0x0008,DICOM_T_UNK,   _T("Visit Status ID") },
{ 0x0038,0x0010,DICOM_T_UNK,   _T("Admission ID") },
{ 0x0038,0x0011,DICOM_T_UNK,   _T("Issuer of Admission ID") },
{ 0x0038,0x0014,DICOM_T_UNK,   _T("Issuer of Admission ID Sequence") },
{ 0x0038,0x0016,DICOM_T_UNK,   _T("Route of Admissions") },
{ 0x0038,0x001A,DICOM_T_UNK,   _T("Scheduled Admission Date") },
{ 0x0038,0x001B,DICOM_T_UNK,   _T("Scheduled Admission Time") },
{ 0x0038,0x001C,DICOM_T_UNK,   _T("Scheduled Discharge Date") },
{ 0x0038,0x001D,DICOM_T_UNK,   _T("Scheduled Discharge Time") },
{ 0x0038,0x001E,DICOM_T_UNK,   _T("Scheduled Patient Institution Residence") },
{ 0x0038,0x0020,DICOM_T_UNK,   _T("Admitting Date") },
{ 0x0038,0x0021,DICOM_T_UNK,   _T("Admitting Time") },
{ 0x0038,0x0030,DICOM_T_UNK,   _T("Discharge Date") },
{ 0x0038,0x0032,DICOM_T_UNK,   _T("Discharge Time") },
{ 0x0038,0x0040,DICOM_T_UNK,   _T("Discharge Diagnosis Description") },
{ 0x0038,0x0044,DICOM_T_UNK,   _T("Discharge Diagnosis Code Sequence") },
{ 0x0038,0x0050,DICOM_T_UNK,   _T("Special Needs") },
{ 0x0038,0x0060,DICOM_T_UNK,   _T("Service Episode ID") },
{ 0x0038,0x0061,DICOM_T_UNK,   _T("Issuer of Service Episode ID") },
{ 0x0038,0x0062,DICOM_T_UNK,   _T("Service Episode Description") },
{ 0x0038,0x0064,DICOM_T_UNK,   _T("Issuer of Service Episode ID Sequence") },
{ 0x0038,0x0100,DICOM_T_UNK,   _T("Pertinent Documents Sequence") },
{ 0x0038,0x0300,DICOM_T_UNK,   _T("Current Patient Location") },
{ 0x0038,0x0400,DICOM_T_UNK,   _T("Patient's Institution Residence") },
{ 0x0038,0x0500,DICOM_T_UNK,   _T("Patient State") },
{ 0x0038,0x0502,DICOM_T_UNK,   _T("Patient Clinical Trial Participation Sequence") },
{ 0x0038,0x4000,DICOM_T_UNK,   _T("Visit Comments") },
{ 0x003A,0x0004,DICOM_T_UNK,   _T("Waveform Originality") },
{ 0x003A,0x0005,DICOM_T_UNK,   _T("Number of Waveform Channels") },
{ 0x003A,0x0010,DICOM_T_UNK,   _T("Number of Waveform Samples") },
{ 0x003A,0x001A,DICOM_T_UNK,   _T("Sampling Frequency") },
{ 0x003A,0x0020,DICOM_T_UNK,   _T("Multiplex Group Label") },
{ 0x003A,0x0200,DICOM_T_UNK,   _T("Channel Definition Sequence") },
{ 0x003A,0x0202,DICOM_T_UNK,   _T("Waveform Channel Number") },
{ 0x003A,0x0203,DICOM_T_UNK,   _T("Channel Label") },
{ 0x003A,0x0205,DICOM_T_UNK,   _T("Channel Status") },
{ 0x003A,0x0208,DICOM_T_UNK,   _T("Channel Source Sequence") },
{ 0x003A,0x0209,DICOM_T_UNK,   _T("Channel Source Modifiers Sequence") },
{ 0x003A,0x020A,DICOM_T_UNK,   _T("Source Waveform Sequence") },
{ 0x003A,0x020C,DICOM_T_UNK,   _T("Channel Derivation Description") },
{ 0x003A,0x0210,DICOM_T_UNK,   _T("Channel Sensitivity") },
{ 0x003A,0x0211,DICOM_T_UNK,   _T("Channel Sensitivity Units Sequence") },
{ 0x003A,0x0212,DICOM_T_UNK,   _T("Channel Sensitivity Correction Factor") },
{ 0x003A,0x0213,DICOM_T_UNK,   _T("Channel Baseline") },
{ 0x003A,0x0214,DICOM_T_UNK,   _T("Channel Time Skew") },
{ 0x003A,0x0215,DICOM_T_UNK,   _T("Channel Sample Skew") },
{ 0x003A,0x0218,DICOM_T_UNK,   _T("Channel Offset") },
{ 0x003A,0x021A,DICOM_T_UNK,   _T("Waveform Bits Stored") },
{ 0x003A,0x0220,DICOM_T_UNK,   _T("Filter Low Frequency") },
{ 0x003A,0x0221,DICOM_T_UNK,   _T("Filter High Frequency") },
{ 0x003A,0x0222,DICOM_T_UNK,   _T("Notch Filter Frequency") },
{ 0x003A,0x0223,DICOM_T_UNK,   _T("Notch Filter Bandwidth") },
{ 0x003A,0x0230,DICOM_T_UNK,   _T("Waveform Data Display Scale") },
{ 0x003A,0x0231,DICOM_T_UNK,   _T("Waveform Display Background CIELab Value") },
{ 0x003A,0x0240,DICOM_T_UNK,   _T("Waveform Presentation Group Sequence") },
{ 0x003A,0x0241,DICOM_T_UNK,   _T("Presentation Group Number") },
{ 0x003A,0x0242,DICOM_T_UNK,   _T("Channel Display Sequence") },
{ 0x003A,0x0244,DICOM_T_UNK,   _T("Channel Recommended Display CIELab Value") },
{ 0x003A,0x0245,DICOM_T_UNK,   _T("Channel Position") },
{ 0x003A,0x0246,DICOM_T_UNK,   _T("Display Shading Flag") },
{ 0x003A,0x0247,DICOM_T_UNK,   _T("Fractional Channel Display Scale") },
{ 0x003A,0x0248,DICOM_T_UNK,   _T("Absolute Channel Display Scale") },
{ 0x003A,0x0300,DICOM_T_UNK,   _T("Multiplexed Audio Channels Description Code Sequence") },
{ 0x003A,0x0301,DICOM_T_UNK,   _T("Channel Identification Code") },
{ 0x003A,0x0302,DICOM_T_UNK,   _T("Channel Mode") },
{ 0x0040,0x0001,DICOM_T_UNK,   _T("Scheduled Station AE Title") },
{ 0x0040,0x0002,DICOM_T_UNK,   _T("Scheduled Procedure Step Start Date") },
{ 0x0040,0x0003,DICOM_T_UNK,   _T("Scheduled Procedure Step Start Time") },
{ 0x0040,0x0004,DICOM_T_UNK,   _T("Scheduled Procedure Step End Date") },
{ 0x0040,0x0005,DICOM_T_UNK,   _T("Scheduled Procedure Step End Time") },
{ 0x0040,0x0006,DICOM_T_UNK,   _T("Scheduled Performing Physician's Name") },
{ 0x0040,0x0007,DICOM_T_UNK,   _T("Scheduled Procedure Step Description") },
{ 0x0040,0x0008,DICOM_T_UNK,   _T("Scheduled Protocol Code Sequence") },
{ 0x0040,0x0009,DICOM_T_UNK,   _T("Scheduled Procedure Step ID") },
{ 0x0040,0x000A,DICOM_T_UNK,   _T("Stage Code Sequence") },
{ 0x0040,0x000B,DICOM_T_UNK,   _T("Scheduled Performing Physician Identification Sequence") },
{ 0x0040,0x0010,DICOM_T_UNK,   _T("Scheduled Station Name") },
{ 0x0040,0x0011,DICOM_T_UNK,   _T("Scheduled Procedure Step Location") },
{ 0x0040,0x0012,DICOM_T_UNK,   _T("Pre-Medication") },
{ 0x0040,0x0020,DICOM_T_UNK,   _T("Scheduled Procedure Step Status") },
{ 0x0040,0x0026,DICOM_T_UNK,   _T("Order Placer Identifier Sequence") },
{ 0x0040,0x0027,DICOM_T_UNK,   _T("Order Filler Identifier Sequence") },
{ 0x0040,0x0031,DICOM_T_UNK,   _T("Local Namespace Entity ID") },
{ 0x0040,0x0032,DICOM_T_UNK,   _T("Universal Entity ID") },
{ 0x0040,0x0033,DICOM_T_UNK,   _T("Universal Entity ID Type") },
{ 0x0040,0x0035,DICOM_T_UNK,   _T("Identifier Type Code") },
{ 0x0040,0x0036,DICOM_T_UNK,   _T("Assigning Facility Sequence") },
{ 0x0040,0x0039,DICOM_T_UNK,   _T("Assigning Jurisdiction Code Sequence") },
{ 0x0040,0x003A,DICOM_T_UNK,   _T("Assigning Agency or Department Code Sequence") },
{ 0x0040,0x0100,DICOM_T_UNK,   _T("Scheduled Procedure Step Sequence") },
{ 0x0040,0x0220,DICOM_T_UNK,   _T("Referenced Non-Image Composite SOP Instance Sequence") },
{ 0x0040,0x0241,DICOM_T_UNK,   _T("Performed Station AE Title") },
{ 0x0040,0x0242,DICOM_T_UNK,   _T("Performed Station Name") },
{ 0x0040,0x0243,DICOM_T_UNK,   _T("Performed Location") },
{ 0x0040,0x0244,DICOM_T_UNK,   _T("Performed Procedure Step Start Date") },
{ 0x0040,0x0245,DICOM_T_UNK,   _T("Performed Procedure Step Start Time") },
{ 0x0040,0x0250,DICOM_T_UNK,   _T("Performed Procedure Step End Date") },
{ 0x0040,0x0251,DICOM_T_UNK,   _T("Performed Procedure Step End Time") },
{ 0x0040,0x0252,DICOM_T_UNK,   _T("Performed Procedure Step Status") },
{ 0x0040,0x0253,DICOM_T_UNK,   _T("Performed Procedure Step ID") },
{ 0x0040,0x0254,DICOM_T_UNK,   _T("Performed Procedure Step Description") },
{ 0x0040,0x0255,DICOM_T_UNK,   _T("Performed Procedure Type Description") },
{ 0x0040,0x0260,DICOM_T_UNK,   _T("Performed Protocol Code Sequence") },
{ 0x0040,0x0261,DICOM_T_UNK,   _T("Performed Protocol Type") },
{ 0x0040,0x0270,DICOM_T_UNK,   _T("Scheduled Step Attributes Sequence") },
{ 0x0040,0x0275,DICOM_T_UNK,   _T("Request Attributes Sequence") },
{ 0x0040,0x0280,DICOM_T_UNK,   _T("Comments on the Performed Procedure Step") },
{ 0x0040,0x0281,DICOM_T_UNK,   _T("Performed Procedure Step Discontinuation Reason Code Sequence") },
{ 0x0040,0x0293,DICOM_T_UNK,   _T("Quantity Sequence") },
{ 0x0040,0x0294,DICOM_T_UNK,   _T("Quantity") },
{ 0x0040,0x0295,DICOM_T_UNK,   _T("Measuring Units Sequence") },
{ 0x0040,0x0296,DICOM_T_UNK,   _T("Billing Item Sequence") },
{ 0x0040,0x0300,DICOM_T_UNK,   _T("Total Time of Fluoroscopy") },
{ 0x0040,0x0301,DICOM_T_UNK,   _T("Total Number of Exposures") },
{ 0x0040,0x0302,DICOM_T_UNK,   _T("Entrance Dose") },
{ 0x0040,0x0303,DICOM_T_UNK,   _T("Exposed Area") },
{ 0x0040,0x0306,DICOM_T_UNK,   _T("Distance Source to Entrance") },
{ 0x0040,0x0307,DICOM_T_UNK,   _T("Distance Source to Support") },
{ 0x0040,0x030E,DICOM_T_UNK,   _T("Exposure Dose Sequence") },
{ 0x0040,0x0310,DICOM_T_UNK,   _T("Comments on Radiation Dose") },
{ 0x0040,0x0312,DICOM_T_UNK,   _T("X-Ray Output") },
{ 0x0040,0x0314,DICOM_T_UNK,   _T("Half Value Layer") },
{ 0x0040,0x0316,DICOM_T_UNK,   _T("Organ Dose") },
{ 0x0040,0x0318,DICOM_T_UNK,   _T("Organ Exposed") },
{ 0x0040,0x0320,DICOM_T_UNK,   _T("Billing Procedure Step Sequence") },
{ 0x0040,0x0321,DICOM_T_UNK,   _T("Film Consumption Sequence") },
{ 0x0040,0x0324,DICOM_T_UNK,   _T("Billing Supplies and Devices Sequence") },
{ 0x0040,0x0330,DICOM_T_UNK,   _T("Referenced Procedure Step Sequence") },
{ 0x0040,0x0340,DICOM_T_UNK,   _T("Performed Series Sequence") },
{ 0x0040,0x0400,DICOM_T_UNK,   _T("Comments on the Scheduled Procedure Step") },
{ 0x0040,0x0440,DICOM_T_UNK,   _T("Protocol Context Sequence") },
{ 0x0040,0x0441,DICOM_T_UNK,   _T("Content Item Modifier Sequence") },
{ 0x0040,0x0500,DICOM_T_UNK,   _T("Scheduled Specimen Sequence") },
{ 0x0040,0x050A,DICOM_T_UNK,   _T("Specimen Accession Number") },
{ 0x0040,0x0512,DICOM_T_UNK,   _T("Container Identifier") },
{ 0x0040,0x0513,DICOM_T_UNK,   _T("Issuer of the Container Identifier Sequence") },
{ 0x0040,0x0515,DICOM_T_UNK,   _T("Alternate Container Identifier Sequence") },
{ 0x0040,0x0518,DICOM_T_UNK,   _T("Container Type Code Sequence") },
{ 0x0040,0x051A,DICOM_T_UNK,   _T("Container Description") },
{ 0x0040,0x0520,DICOM_T_UNK,   _T("Container Component Sequence") },
{ 0x0040,0x0550,DICOM_T_UNK,   _T("Specimen Sequence") },
{ 0x0040,0x0551,DICOM_T_UNK,   _T("Specimen Identifier") },
{ 0x0040,0x0552,DICOM_T_UNK,   _T("Specimen Description Sequence (Trial)") },
{ 0x0040,0x0553,DICOM_T_UNK,   _T("Specimen Description (Trial)") },
{ 0x0040,0x0554,DICOM_T_UNK,   _T("Specimen UID") },
{ 0x0040,0x0555,DICOM_T_UNK,   _T("Acquisition Context Sequence") },
{ 0x0040,0x0556,DICOM_T_UNK,   _T("Acquisition Context Description") },
{ 0x0040,0x059A,DICOM_T_UNK,   _T("Specimen Type Code Sequence") },
{ 0x0040,0x0560,DICOM_T_UNK,   _T("Specimen Description Sequence") },
{ 0x0040,0x0562,DICOM_T_UNK,   _T("Issuer of the Specimen Identifier Sequence") },
{ 0x0040,0x0600,DICOM_T_UNK,   _T("Specimen Short Description") },
{ 0x0040,0x0602,DICOM_T_UNK,   _T("Specimen Detailed Description") },
{ 0x0040,0x0610,DICOM_T_UNK,   _T("Specimen Preparation Sequence") },
{ 0x0040,0x0612,DICOM_T_UNK,   _T("Specimen Preparation Step Content Item Sequence") },
{ 0x0040,0x0620,DICOM_T_UNK,   _T("Specimen Localization Content Item Sequence") },
{ 0x0040,0x06FA,DICOM_T_UNK,   _T("Slide Identifier") },
{ 0x0040,0x071A,DICOM_T_UNK,   _T("Image Center Point Coordinates Sequence") },
{ 0x0040,0x072A,DICOM_T_UNK,   _T("X Offset in Slide Coordinate System") },
{ 0x0040,0x073A,DICOM_T_UNK,   _T("Y Offset in Slide Coordinate System") },
{ 0x0040,0x074A,DICOM_T_UNK,   _T("Z Offset in Slide Coordinate System") },
{ 0x0040,0x08D8,DICOM_T_UNK,   _T("Pixel Spacing Sequence") },
{ 0x0040,0x08DA,DICOM_T_UNK,   _T("Coordinate System Axis Code Sequence") },
{ 0x0040,0x08EA,DICOM_T_UNK,   _T("Measurement Units Code Sequence") },
{ 0x0040,0x09F8,DICOM_T_UNK,   _T("Vital Stain Code Sequence (Trial)") },
{ 0x0040,0x1001,DICOM_T_UNK,   _T("Requested Procedure ID") },
{ 0x0040,0x1002,DICOM_T_UNK,   _T("Reason for the Requested Procedure") },
{ 0x0040,0x1003,DICOM_T_UNK,   _T("Requested Procedure Priority") },
{ 0x0040,0x1004,DICOM_T_UNK,   _T("Patient Transport Arrangements") },
{ 0x0040,0x1005,DICOM_T_UNK,   _T("Requested Procedure Location") },
{ 0x0040,0x1006,DICOM_T_UNK,   _T("Placer Order Number / Procedure") },
{ 0x0040,0x1007,DICOM_T_UNK,   _T("Filler Order Number / Procedure") },
{ 0x0040,0x1008,DICOM_T_UNK,   _T("Confidentiality Code") },
{ 0x0040,0x1009,DICOM_T_UNK,   _T("Reporting Priority") },
{ 0x0040,0x100A,DICOM_T_UNK,   _T("Reason for Requested Procedure Code Sequence") },
{ 0x0040,0x1010,DICOM_T_UNK,   _T("Names of Intended Recipients of Results") },
{ 0x0040,0x1011,DICOM_T_UNK,   _T("Intended Recipients of Results Identification Sequence") },
{ 0x0040,0x1012,DICOM_T_UNK,   _T("Reason For Performed Procedure Code Sequence") },
{ 0x0040,0x1060,DICOM_T_UNK,   _T("Requested Procedure Description (Trial)") },
{ 0x0040,0x1101,DICOM_T_UNK,   _T("Person Identification Code Sequence") },
{ 0x0040,0x1102,DICOM_T_UNK,   _T("Person's Address") },
{ 0x0040,0x1103,DICOM_T_UNK,   _T("Person's Telephone Numbers") },
{ 0x0040,0x1400,DICOM_T_UNK,   _T("Requested Procedure Comments") },
{ 0x0040,0x2001,DICOM_T_UNK,   _T("Reason for the Imaging Service Request") },
{ 0x0040,0x2004,DICOM_T_UNK,   _T("Issue Date of Imaging Service Request") },
{ 0x0040,0x2005,DICOM_T_UNK,   _T("Issue Time of Imaging Service Request") },
{ 0x0040,0x2006,DICOM_T_UNK,   _T("Placer Order Number / Imaging Service Request (Retired)") },
{ 0x0040,0x2007,DICOM_T_UNK,   _T("Filler Order Number / Imaging Service Request (Retired)") },
{ 0x0040,0x2008,DICOM_T_UNK,   _T("Order Entered By") },
{ 0x0040,0x2009,DICOM_T_UNK,   _T("Order Enterer's Location") },
{ 0x0040,0x2010,DICOM_T_UNK,   _T("Order Callback Phone Number") },
{ 0x0040,0x2016,DICOM_T_UNK,   _T("Placer Order Number / Imaging Service Request") },
{ 0x0040,0x2017,DICOM_T_UNK,   _T("Filler Order Number / Imaging Service Request") },
{ 0x0040,0x2400,DICOM_T_UNK,   _T("Imaging Service Request Comments") },
{ 0x0040,0x3001,DICOM_T_UNK,   _T("Confidentiality Constraint on Patient Data Description") },
{ 0x0040,0x4001,DICOM_T_UNK,   _T("General Purpose Scheduled Procedure Step Status") },
{ 0x0040,0x4002,DICOM_T_UNK,   _T("General Purpose Performed Procedure Step Status") },
{ 0x0040,0x4003,DICOM_T_UNK,   _T("General Purpose Scheduled Procedure Step Priority") },
{ 0x0040,0x4004,DICOM_T_UNK,   _T("Scheduled Processing Applications Code Sequence") },
{ 0x0040,0x4005,DICOM_T_UNK,   _T("Scheduled Procedure Step Start DateTime") },
{ 0x0040,0x4006,DICOM_T_UNK,   _T("Multiple Copies Flag") },
{ 0x0040,0x4007,DICOM_T_UNK,   _T("Performed Processing Applications Code Sequence") },
{ 0x0040,0x4009,DICOM_T_UNK,   _T("Human Performer Code Sequence") },
{ 0x0040,0x4010,DICOM_T_UNK,   _T("Scheduled Procedure Step Modification DateTime") },
{ 0x0040,0x4011,DICOM_T_UNK,   _T("Expected Completion DateTime") },
{ 0x0040,0x4015,DICOM_T_UNK,   _T("Resulting General Purpose Performed Procedure Steps Sequence") },
{ 0x0040,0x4016,DICOM_T_UNK,   _T("Referenced General Purpose Scheduled Procedure Step Sequence") },
{ 0x0040,0x4018,DICOM_T_UNK,   _T("Scheduled Workitem Code Sequence") },
{ 0x0040,0x4019,DICOM_T_UNK,   _T("Performed Workitem Code Sequence") },
{ 0x0040,0x4020,DICOM_T_UNK,   _T("Input Availability Flag") },
{ 0x0040,0x4021,DICOM_T_UNK,   _T("Input Information Sequence") },
{ 0x0040,0x4022,DICOM_T_UNK,   _T("Relevant Information Sequence") },
{ 0x0040,0x4023,DICOM_T_UNK,   _T("Referenced General Purpose Scheduled Procedure Step Transaction UID") },
{ 0x0040,0x4025,DICOM_T_UNK,   _T("Scheduled Station Name Code Sequence") },
{ 0x0040,0x4026,DICOM_T_UNK,   _T("Scheduled Station Class Code Sequence") },
{ 0x0040,0x4027,DICOM_T_UNK,   _T("Scheduled Station Geographic Location Code Sequence") },
{ 0x0040,0x4028,DICOM_T_UNK,   _T("Performed Station Name Code Sequence") },
{ 0x0040,0x4029,DICOM_T_UNK,   _T("Performed Station Class Code Sequence") },
{ 0x0040,0x4030,DICOM_T_UNK,   _T("Performed Station Geographic Location Code Sequence") },
{ 0x0040,0x4031,DICOM_T_UNK,   _T("Requested Subsequent Workitem Code Sequence") },
{ 0x0040,0x4032,DICOM_T_UNK,   _T("Non-DICOM Output Code Sequence") },
{ 0x0040,0x4033,DICOM_T_UNK,   _T("Output Information Sequence") },
{ 0x0040,0x4034,DICOM_T_UNK,   _T("Scheduled Human Performers Sequence") },
{ 0x0040,0x4035,DICOM_T_UNK,   _T("Actual Human Performers Sequence") },
{ 0x0040,0x4036,DICOM_T_UNK,   _T("Human Performer's Organization") },
{ 0x0040,0x4037,DICOM_T_UNK,   _T("Human Performer's Name") },
{ 0x0040,0x4040,DICOM_T_UNK,   _T("Raw Data Handling") },
{ 0x0040,0x4041,DICOM_T_UNK,   _T("Input Readiness State") },
{ 0x0040,0x4050,DICOM_T_UNK,   _T("Performed Procedure Step Start DateTime") },
{ 0x0040,0x4051,DICOM_T_UNK,   _T("Performed Procedure Step End DateTime") },
{ 0x0040,0x4052,DICOM_T_UNK,   _T("Procedure Step Cancellation DateTime") },
{ 0x0040,0x8302,DICOM_T_UNK,   _T("Entrance Dose in mGy") },
{ 0x0040,0x9094,DICOM_T_UNK,   _T("Referenced Image Real World Value Mapping Sequence") },
{ 0x0040,0x9096,DICOM_T_UNK,   _T("Real World Value Mapping Sequence") },
{ 0x0040,0x9098,DICOM_T_UNK,   _T("Pixel Value Mapping Code Sequence") },
{ 0x0040,0x9210,DICOM_T_UNK,   _T("LUT Label") },
{ 0x0040,0x9211,DICOM_T_UNK,   _T("Real World Value Last Value Mapped") },
{ 0x0040,0x9212,DICOM_T_UNK,   _T("Real World Value LUT Data") },
{ 0x0040,0x9216,DICOM_T_UNK,   _T("Real World Value First Value Mapped") },
{ 0x0040,0x9224,DICOM_T_UNK,   _T("Real World Value Intercept") },
{ 0x0040,0x9225,DICOM_T_UNK,   _T("Real World Value Slope") },
{ 0x0040,0xA007,DICOM_T_UNK,   _T("Findings Flag (Trial)") },
{ 0x0040,0xA010,DICOM_T_UNK,   _T("Relationship Type") },
{ 0x0040,0xA020,DICOM_T_UNK,   _T("Findings Sequence (Trial)") },
{ 0x0040,0xA021,DICOM_T_UNK,   _T("Findings Group UID (Trial)") },
{ 0x0040,0xA022,DICOM_T_UNK,   _T("Referenced Findings Group UID (Trial)") },
{ 0x0040,0xA023,DICOM_T_UNK,   _T("Findings Group Recording Date (Trial)") },
{ 0x0040,0xA024,DICOM_T_UNK,   _T("Findings Group Recording Time (Trial)") },
{ 0x0040,0xA026,DICOM_T_UNK,   _T("Findings Source Category Code Sequence (Trial)") },
{ 0x0040,0xA027,DICOM_T_UNK,   _T("Verifying Organization") },
{ 0x0040,0xA028,DICOM_T_UNK,   _T("Documenting Organization Identifier Code Sequence (Trial)") },
{ 0x0040,0xA030,DICOM_T_UNK,   _T("Verification DateTime") },
{ 0x0040,0xA032,DICOM_T_UNK,   _T("Observation DateTime") },
{ 0x0040,0xA040,DICOM_T_UNK,   _T("Value Type") },
{ 0x0040,0xA043,DICOM_T_UNK,   _T("Concept Name Code Sequence") },
{ 0x0040,0xA047,DICOM_T_UNK,   _T("Measurement Precision Description (Trial)") },
{ 0x0040,0xA050,DICOM_T_UNK,   _T("Continuity Of Content") },
{ 0x0040,0xA057,DICOM_T_UNK,   _T("Urgency or Priority Alerts (Trial)") },
{ 0x0040,0xA060,DICOM_T_UNK,   _T("Sequencing Indicator (Trial)") },
{ 0x0040,0xA066,DICOM_T_UNK,   _T("Document Identifier Code Sequence (Trial)") },
{ 0x0040,0xA067,DICOM_T_UNK,   _T("Document Author (Trial)") },
{ 0x0040,0xA068,DICOM_T_UNK,   _T("Document Author Identifier Code Sequence (Trial)") },
{ 0x0040,0xA070,DICOM_T_UNK,   _T("Identifier Code Sequence (Trial)") },
{ 0x0040,0xA073,DICOM_T_UNK,   _T("Verifying Observer Sequence") },
{ 0x0040,0xA074,DICOM_T_UNK,   _T("Object Binary Identifier (Trial)") },
{ 0x0040,0xA075,DICOM_T_UNK,   _T("Verifying Observer Name") },
{ 0x0040,0xA076,DICOM_T_UNK,   _T("Documenting Observer Identifier Code Sequence (Trial)") },
{ 0x0040,0xA078,DICOM_T_UNK,   _T("Author Observer Sequence") },
{ 0x0040,0xA07A,DICOM_T_UNK,   _T("Participant Sequence") },
{ 0x0040,0xA07C,DICOM_T_UNK,   _T("Custodial Organization Sequence") },
{ 0x0040,0xA080,DICOM_T_UNK,   _T("Participation Type") },
{ 0x0040,0xA082,DICOM_T_UNK,   _T("Participation DateTime") },
{ 0x0040,0xA084,DICOM_T_UNK,   _T("Observer Type") },
{ 0x0040,0xA085,DICOM_T_UNK,   _T("Procedure Identifier Code Sequence (Trial)") },
{ 0x0040,0xA088,DICOM_T_UNK,   _T("Verifying Observer Identification Code Sequence") },
{ 0x0040,0xA089,DICOM_T_UNK,   _T("Object Directory Binary Identifier (Trial)") },
{ 0x0040,0xA090,DICOM_T_UNK,   _T("Equivalent CDA Document Sequence") },
{ 0x0040,0xA0B0,DICOM_T_UNK,   _T("Referenced Waveform Channels") },
{ 0x0040,0xA110,DICOM_T_UNK,   _T("Date of Document or Verbal Transaction (Trial)") },
{ 0x0040,0xA112,DICOM_T_UNK,   _T("Time of Document Creation or Verbal Transaction (Trial)") },
{ 0x0040,0xA120,DICOM_T_UNK,   _T("DateTime") },
{ 0x0040,0xA121,DICOM_T_UNK,   _T("Date") },
{ 0x0040,0xA122,DICOM_T_UNK,   _T("Time") },
{ 0x0040,0xA123,DICOM_T_UNK,   _T("Person Name") },
{ 0x0040,0xA124,DICOM_T_UNK,   _T("UID") },
{ 0x0040,0xA125,DICOM_T_UNK,   _T("Report Status ID (Trial)") },
{ 0x0040,0xA130,DICOM_T_UNK,   _T("Temporal Range Type") },
{ 0x0040,0xA132,DICOM_T_UNK,   _T("Referenced Sample Positions") },
{ 0x0040,0xA136,DICOM_T_UNK,   _T("Referenced Frame Numbers") },
{ 0x0040,0xA138,DICOM_T_UNK,   _T("Referenced Time Offsets") },
{ 0x0040,0xA13A,DICOM_T_UNK,   _T("Referenced DateTime") },
{ 0x0040,0xA160,DICOM_T_UNK,   _T("Text Value") },
{ 0x0040,0xA161,DICOM_T_UNK,   _T("Floating Point Value") },
{ 0x0040,0xA162,DICOM_T_UNK,   _T("Rational Numerator Value") },
{ 0x0040,0xA163,DICOM_T_UNK,   _T("Rational Denominator Value") },
{ 0x0040,0xA167,DICOM_T_UNK,   _T("Observation Category Code Sequence (Trial)") },
{ 0x0040,0xA168,DICOM_T_UNK,   _T("Concept Code Sequence") },
{ 0x0040,0xA16A,DICOM_T_UNK,   _T("Bibliographic Citation (Trial)") },
{ 0x0040,0xA170,DICOM_T_UNK,   _T("Purpose of Reference Code Sequence") },
{ 0x0040,0xA171,DICOM_T_UNK,   _T("Observation UID") },
{ 0x0040,0xA172,DICOM_T_UNK,   _T("Referenced Observation UID (Trial)") },
{ 0x0040,0xA173,DICOM_T_UNK,   _T("Referenced Observation Class (Trial)") },
{ 0x0040,0xA174,DICOM_T_UNK,   _T("Referenced Object Observation Class (Trial)") },
{ 0x0040,0xA180,DICOM_T_UNK,   _T("Annotation Group Number") },
{ 0x0040,0xA192,DICOM_T_UNK,   _T("Observation Date (Trial)") },
{ 0x0040,0xA193,DICOM_T_UNK,   _T("Observation Time (Trial)") },
{ 0x0040,0xA194,DICOM_T_UNK,   _T("Measurement Automation (Trial)") },
{ 0x0040,0xA195,DICOM_T_UNK,   _T("Modifier Code Sequence") },
{ 0x0040,0xA224,DICOM_T_UNK,   _T("Identification Description (Trial)") },
{ 0x0040,0xA290,DICOM_T_UNK,   _T("Coordinates Set Geometric Type (Trial)") },
{ 0x0040,0xA296,DICOM_T_UNK,   _T("Algorithm Code Sequence (Trial)") },
{ 0x0040,0xA297,DICOM_T_UNK,   _T("Algorithm Description (Trial)") },
{ 0x0040,0xA29A,DICOM_T_UNK,   _T("Pixel Coordinates Set (Trial)") },
{ 0x0040,0xA300,DICOM_T_UNK,   _T("Measured Value Sequence") },
{ 0x0040,0xA301,DICOM_T_UNK,   _T("Numeric Value Qualifier Code Sequence") },
{ 0x0040,0xA307,DICOM_T_UNK,   _T("Current Observer (Trial)") },
{ 0x0040,0xA30A,DICOM_T_UNK,   _T("Numeric Value") },
{ 0x0040,0xA313,DICOM_T_UNK,   _T("Referenced Accession Sequence (Trial)") },
{ 0x0040,0xA33A,DICOM_T_UNK,   _T("Report Status Comment (Trial)") },
{ 0x0040,0xA340,DICOM_T_UNK,   _T("Procedure Context Sequence (Trial)") },
{ 0x0040,0xA352,DICOM_T_UNK,   _T("Verbal Source (Trial)") },
{ 0x0040,0xA353,DICOM_T_UNK,   _T("Address (Trial)") },
{ 0x0040,0xA354,DICOM_T_UNK,   _T("Telephone Number (Trial)") },
{ 0x0040,0xA358,DICOM_T_UNK,   _T("Verbal Source Identifier Code Sequence (Trial)") },
{ 0x0040,0xA360,DICOM_T_UNK,   _T("Predecessor Documents Sequence") },
{ 0x0040,0xA370,DICOM_T_UNK,   _T("Referenced Request Sequence") },
{ 0x0040,0xA372,DICOM_T_UNK,   _T("Performed Procedure Code Sequence") },
{ 0x0040,0xA375,DICOM_T_UNK,   _T("Current Requested Procedure Evidence Sequence") },
{ 0x0040,0xA380,DICOM_T_UNK,   _T("Report Detail Sequence (Trial)") },
{ 0x0040,0xA385,DICOM_T_UNK,   _T("Pertinent Other Evidence Sequence") },
{ 0x0040,0xA390,DICOM_T_UNK,   _T("HL7 Structured Document Reference Sequence") },
{ 0x0040,0xA402,DICOM_T_UNK,   _T("Observation Subject UID (Trial)") },
{ 0x0040,0xA403,DICOM_T_UNK,   _T("Observation Subject Class (Trial)") },
{ 0x0040,0xA404,DICOM_T_UNK,   _T("Observation Subject Type Code Sequence (Trial)") },
{ 0x0040,0xA491,DICOM_T_UNK,   _T("Completion Flag") },
{ 0x0040,0xA492,DICOM_T_UNK,   _T("Completion Flag Description") },
{ 0x0040,0xA493,DICOM_T_UNK,   _T("Verification Flag") },
{ 0x0040,0xA494,DICOM_T_UNK,   _T("Archive Requested") },
{ 0x0040,0xA496,DICOM_T_UNK,   _T("Preliminary Flag") },
{ 0x0040,0xA504,DICOM_T_UNK,   _T("Content Template Sequence") },
{ 0x0040,0xA525,DICOM_T_UNK,   _T("Identical Documents Sequence") },
{ 0x0040,0xA600,DICOM_T_UNK,   _T("Observation Subject Context Flag (Trial)") },
{ 0x0040,0xA601,DICOM_T_UNK,   _T("Observer Context Flag (Trial)") },
{ 0x0040,0xA603,DICOM_T_UNK,   _T("Procedure Context Flag (Trial)") },
{ 0x0040,0xA730,DICOM_T_UNK,   _T("Content Sequence") },
{ 0x0040,0xA731,DICOM_T_UNK,   _T("Relationship Sequence (Trial)") },
{ 0x0040,0xA732,DICOM_T_UNK,   _T("Relationship Type Code Sequence (Trial)") },
{ 0x0040,0xA744,DICOM_T_UNK,   _T("Language Code Sequence (Trial)") },
{ 0x0040,0xA992,DICOM_T_UNK,   _T("Uniform Resource Locator (Trial)") },
{ 0x0040,0xB020,DICOM_T_UNK,   _T("Waveform Annotation Sequence") },
{ 0x0040,0xDB00,DICOM_T_UNK,   _T("Template Identifier") },
{ 0x0040,0xDB06,DICOM_T_UNK,   _T("Template Version") },
{ 0x0040,0xDB07,DICOM_T_UNK,   _T("Template Local Version") },
{ 0x0040,0xDB0B,DICOM_T_UNK,   _T("Template Extension Flag") },
{ 0x0040,0xDB0C,DICOM_T_UNK,   _T("Template Extension Organization UID") },
{ 0x0040,0xDB0D,DICOM_T_UNK,   _T("Template Extension Creator UID") },
{ 0x0040,0xDB73,DICOM_T_UNK,   _T("Referenced Content Item Identifier") },
{ 0x0040,0xE001,DICOM_T_UNK,   _T("HL7 Instance Identifier") },
{ 0x0040,0xE004,DICOM_T_UNK,   _T("HL7 Document Effective Time") },
{ 0x0040,0xE006,DICOM_T_UNK,   _T("HL7 Document Type Code Sequence") },
{ 0x0040,0xE008,DICOM_T_UNK,   _T("Document Class Code Sequence") },
{ 0x0040,0xE010,DICOM_T_UNK,   _T("Retrieve URI") },
{ 0x0040,0xE011,DICOM_T_UNK,   _T("Retrieve Location UID") },
{ 0x0040,0xE020,DICOM_T_UNK,   _T("Type of Instances") },
{ 0x0040,0xE021,DICOM_T_UNK,   _T("DICOM Retrieval Sequence") },
{ 0x0040,0xE022,DICOM_T_UNK,   _T("DICOM Media Retrieval Sequence") },
{ 0x0040,0xE023,DICOM_T_UNK,   _T("WADO Retrieval Sequence") },
{ 0x0040,0xE024,DICOM_T_UNK,   _T("XDS Retrieval Sequence") },
{ 0x0040,0xE030,DICOM_T_UNK,   _T("Repository Unique ID") },
{ 0x0040,0xE031,DICOM_T_UNK,   _T("Home Community ID") },
{ 0x0042,0x0010,DICOM_T_UNK,   _T("Document Title") },
{ 0x0042,0x0011,DICOM_T_UNK,   _T("Encapsulated Document") },
{ 0x0042,0x0012,DICOM_T_UNK,   _T("MIME Type of Encapsulated Document") },
{ 0x0042,0x0013,DICOM_T_UNK,   _T("Source Instance Sequence") },
{ 0x0042,0x0014,DICOM_T_UNK,   _T("List of MIME Types") },
{ 0x0044,0x0001,DICOM_T_UNK,   _T("Product Package Identifier") },
{ 0x0044,0x0002,DICOM_T_UNK,   _T("Substance Administration Approval") },
{ 0x0044,0x0003,DICOM_T_UNK,   _T("Approval Status Further Description") },
{ 0x0044,0x0004,DICOM_T_UNK,   _T("Approval Status DateTime") },
{ 0x0044,0x0007,DICOM_T_UNK,   _T("Product Type Code Sequence") },
{ 0x0044,0x0008,DICOM_T_UNK,   _T("Product Name") },
{ 0x0044,0x0009,DICOM_T_UNK,   _T("Product Description") },
{ 0x0044,0x000A,DICOM_T_UNK,   _T("Product Lot Identifier") },
{ 0x0044,0x000B,DICOM_T_UNK,   _T("Product Expiration DateTime") },
{ 0x0044,0x0010,DICOM_T_UNK,   _T("Substance Administration DateTime") },
{ 0x0044,0x0011,DICOM_T_UNK,   _T("Substance Administration Notes") },
{ 0x0044,0x0012,DICOM_T_UNK,   _T("Substance Administration Device ID") },
{ 0x0044,0x0013,DICOM_T_UNK,   _T("Product Parameter Sequence") },
{ 0x0044,0x0019,DICOM_T_UNK,   _T("Substance Administration Parameter Sequence") },
{ 0x0046,0x0012,DICOM_T_UNK,   _T("Lens Description") },
{ 0x0046,0x0014,DICOM_T_UNK,   _T("Right Lens Sequence") },
{ 0x0046,0x0015,DICOM_T_UNK,   _T("Left Lens Sequence") },
{ 0x0046,0x0016,DICOM_T_UNK,   _T("Unspecified Laterality Lens Sequence") },
{ 0x0046,0x0018,DICOM_T_UNK,   _T("Cylinder Sequence") },
{ 0x0046,0x0028,DICOM_T_UNK,   _T("Prism Sequence") },
{ 0x0046,0x0030,DICOM_T_UNK,   _T("Horizontal Prism Power") },
{ 0x0046,0x0032,DICOM_T_UNK,   _T("Horizontal Prism Base") },
{ 0x0046,0x0034,DICOM_T_UNK,   _T("Vertical Prism Power") },
{ 0x0046,0x0036,DICOM_T_UNK,   _T("Vertical Prism Base") },
{ 0x0046,0x0038,DICOM_T_UNK,   _T("Lens Segment Type") },
{ 0x0046,0x0040,DICOM_T_UNK,   _T("Optical Transmittance") },
{ 0x0046,0x0042,DICOM_T_UNK,   _T("Channel Width") },
{ 0x0046,0x0044,DICOM_T_UNK,   _T("Pupil Size") },
{ 0x0046,0x0046,DICOM_T_UNK,   _T("Corneal Size") },
{ 0x0046,0x0050,DICOM_T_UNK,   _T("Autorefraction Right Eye Sequence") },
{ 0x0046,0x0052,DICOM_T_UNK,   _T("Autorefraction Left Eye Sequence") },
{ 0x0046,0x0060,DICOM_T_UNK,   _T("Distance Pupillary Distance") },
{ 0x0046,0x0062,DICOM_T_UNK,   _T("Near Pupillary Distance") },
{ 0x0046,0x0063,DICOM_T_UNK,   _T("Intermediate Pupillary Distance") },
{ 0x0046,0x0064,DICOM_T_UNK,   _T("Other Pupillary Distance") },
{ 0x0046,0x0070,DICOM_T_UNK,   _T("Keratometry Right Eye Sequence") },
{ 0x0046,0x0071,DICOM_T_UNK,   _T("Keratometry Left Eye Sequence") },
{ 0x0046,0x0074,DICOM_T_UNK,   _T("Steep Keratometric Axis Sequence") },
{ 0x0046,0x0075,DICOM_T_UNK,   _T("Radius of Curvature") },
{ 0x0046,0x0076,DICOM_T_UNK,   _T("Keratometric Power") },
{ 0x0046,0x0077,DICOM_T_UNK,   _T("Keratometric Axis") },
{ 0x0046,0x0080,DICOM_T_UNK,   _T("Flat Keratometric Axis Sequence") },
{ 0x0046,0x0092,DICOM_T_UNK,   _T("Background Color") },
{ 0x0046,0x0094,DICOM_T_UNK,   _T("Optotype") },
{ 0x0046,0x0095,DICOM_T_UNK,   _T("Optotype Presentation") },
{ 0x0046,0x0097,DICOM_T_UNK,   _T("Subjective Refraction Right Eye Sequence") },
{ 0x0046,0x0098,DICOM_T_UNK,   _T("Subjective Refraction Left Eye Sequence") },
{ 0x0046,0x0100,DICOM_T_UNK,   _T("Add Near Sequence") },
{ 0x0046,0x0101,DICOM_T_UNK,   _T("Add Intermediate Sequence") },
{ 0x0046,0x0102,DICOM_T_UNK,   _T("Add Other Sequence") },
{ 0x0046,0x0104,DICOM_T_UNK,   _T("Add Power") },
{ 0x0046,0x0106,DICOM_T_UNK,   _T("Viewing Distance") },
{ 0x0046,0x0121,DICOM_T_UNK,   _T("Visual Acuity Type Code Sequence") },
{ 0x0046,0x0122,DICOM_T_UNK,   _T("Visual Acuity Right Eye Sequence") },
{ 0x0046,0x0123,DICOM_T_UNK,   _T("Visual Acuity Left Eye Sequence") },
{ 0x0046,0x0124,DICOM_T_UNK,   _T("Visual Acuity Both Eyes Open Sequence") },
{ 0x0046,0x0125,DICOM_T_UNK,   _T("Viewing Distance Type") },
{ 0x0046,0x0135,DICOM_T_UNK,   _T("Visual Acuity Modifiers") },
{ 0x0046,0x0137,DICOM_T_UNK,   _T("Decimal Visual Acuity") },
{ 0x0046,0x0139,DICOM_T_UNK,   _T("Optotype Detailed Definition") },
{ 0x0046,0x0145,DICOM_T_UNK,   _T("Referenced Refractive Measurements Sequence") },
{ 0x0046,0x0146,DICOM_T_UNK,   _T("Sphere Power") },
{ 0x0046,0x0147,DICOM_T_UNK,   _T("Cylinder Power") },
{ 0x0046,0x0201,DICOM_T_UNK,   _T("Corneal Topography Surface") },
{ 0x0046,0x0202,DICOM_T_UNK,   _T("Corneal Vertex Location") },
{ 0x0046,0x0203,DICOM_T_UNK,   _T("Pupil Centroid X-Coordinate") },
{ 0x0046,0x0204,DICOM_T_UNK,   _T("Pupil Centroid Y-Coordinate") },
{ 0x0046,0x0205,DICOM_T_UNK,   _T("Equivalent Pupil Radius") },
{ 0x0046,0x0207,DICOM_T_UNK,   _T("Corneal Topography Map Type Code Sequence") },
{ 0x0046,0x0208,DICOM_T_UNK,   _T("Vertices of the Outline of Pupil") },
{ 0x0046,0x0210,DICOM_T_UNK,   _T("Corneal Topography Mapping Normals Sequence") },
{ 0x0046,0x0211,DICOM_T_UNK,   _T("Maximum Corneal Curvature Sequence") },
{ 0x0046,0x0212,DICOM_T_UNK,   _T("Maximum Corneal Curvature") },
{ 0x0046,0x0213,DICOM_T_UNK,   _T("Maximum Corneal Curvature Location") },
{ 0x0046,0x0215,DICOM_T_UNK,   _T("Minimum Keratometric Sequence") },
{ 0x0046,0x0218,DICOM_T_UNK,   _T("Simulated Keratometric Cylinder Sequence") },
{ 0x0046,0x0220,DICOM_T_UNK,   _T("Average Corneal Power") },
{ 0x0046,0x0224,DICOM_T_UNK,   _T("Corneal I-S Value") },
{ 0x0046,0x0227,DICOM_T_UNK,   _T("Analyzed Area") },
{ 0x0046,0x0230,DICOM_T_UNK,   _T("Surface Regularity Index") },
{ 0x0046,0x0232,DICOM_T_UNK,   _T("Surface Asymmetry Index") },
{ 0x0046,0x0234,DICOM_T_UNK,   _T("Corneal Eccentricity Index") },
{ 0x0046,0x0236,DICOM_T_UNK,   _T("Keratoconus Prediction Index") },
{ 0x0046,0x0238,DICOM_T_UNK,   _T("Decimal Potential Visual Acuity") },
{ 0x0046,0x0242,DICOM_T_UNK,   _T("Corneal Topography Map Quality Evaluation") },
{ 0x0046,0x0244,DICOM_T_UNK,   _T("Source Image Corneal Processed Data Sequence") },
{ 0x0046,0x0247,DICOM_T_UNK,   _T("Corneal Point Location") },
{ 0x0046,0x0248,DICOM_T_UNK,   _T("Corneal Point Estimated") },
{ 0x0046,0x0249,DICOM_T_UNK,   _T("Axial Power") },
{ 0x0046,0x0250,DICOM_T_UNK,   _T("Tangential Power") },
{ 0x0046,0x0251,DICOM_T_UNK,   _T("Refractive Power") },
{ 0x0046,0x0252,DICOM_T_UNK,   _T("Relative Elevation") },
{ 0x0046,0x0253,DICOM_T_UNK,   _T("Corneal Wavefront") },
{ 0x0048,0x0001,DICOM_T_UNK,   _T("Imaged Volume Width") },
{ 0x0048,0x0002,DICOM_T_UNK,   _T("Imaged Volume Height") },
{ 0x0048,0x0003,DICOM_T_UNK,   _T("Imaged Volume Depth") },
{ 0x0048,0x0006,DICOM_T_UNK,   _T("Total Pixel Matrix Columns") },
{ 0x0048,0x0007,DICOM_T_UNK,   _T("Total Pixel Matrix Rows") },
{ 0x0048,0x0008,DICOM_T_UNK,   _T("Total Pixel Matrix Origin Sequence") },
{ 0x0048,0x0010,DICOM_T_UNK,   _T("Specimen Label in Image") },
{ 0x0048,0x0011,DICOM_T_UNK,   _T("Focus Method") },
{ 0x0048,0x0012,DICOM_T_UNK,   _T("Extended Depth of Field") },
{ 0x0048,0x0013,DICOM_T_UNK,   _T("Number of Focal Planes") },
{ 0x0048,0x0014,DICOM_T_UNK,   _T("Distance Between Focal Planes") },
{ 0x0048,0x0015,DICOM_T_UNK,   _T("Recommended Absent Pixel CIELab Value") },
{ 0x0048,0x0100,DICOM_T_UNK,   _T("Illuminator Type Code Sequence") },
{ 0x0048,0x0102,DICOM_T_UNK,   _T("Image Orientation (Slide)") },
{ 0x0048,0x0105,DICOM_T_UNK,   _T("Optical Path Sequence") },
{ 0x0048,0x0106,DICOM_T_UNK,   _T("Optical Path Identifier") },
{ 0x0048,0x0107,DICOM_T_UNK,   _T("Optical Path Description") },
{ 0x0048,0x0108,DICOM_T_UNK,   _T("Illumination Color Code Sequence") },
{ 0x0048,0x0110,DICOM_T_UNK,   _T("Specimen Reference Sequence") },
{ 0x0048,0x0111,DICOM_T_UNK,   _T("Condenser Lens Power") },
{ 0x0048,0x0112,DICOM_T_UNK,   _T("Objective Lens Power") },
{ 0x0048,0x0113,DICOM_T_UNK,   _T("Objective Lens Numerical Aperture") },
{ 0x0048,0x0120,DICOM_T_UNK,   _T("Palette Color Lookup Table Sequence") },
{ 0x0048,0x0200,DICOM_T_UNK,   _T("Referenced Image Navigation Sequence") },
{ 0x0048,0x0201,DICOM_T_UNK,   _T("Top Left Hand Corner of Localizer Area") },
{ 0x0048,0x0202,DICOM_T_UNK,   _T("Bottom Right Hand Corner of Localizer Area") },
{ 0x0048,0x0207,DICOM_T_UNK,   _T("Optical Path Identification Sequence") },
{ 0x0048,0x021A,DICOM_T_UNK,   _T("Plane Position (Slide) Sequence") },
{ 0x0048,0x021E,DICOM_T_UNK,   _T("Column Position In Total Image Pixel Matrix") },
{ 0x0048,0x021F,DICOM_T_UNK,   _T("Row Position In Total Image Pixel Matrix") },
{ 0x0048,0x0301,DICOM_T_UNK,   _T("Pixel Origin Interpretation") },
{ 0x0050,0x0004,DICOM_T_UNK,   _T("Calibration Image") },
{ 0x0050,0x0010,DICOM_T_UNK,   _T("Device Sequence") },
{ 0x0050,0x0012,DICOM_T_UNK,   _T("Container Component Type Code Sequence") },
{ 0x0050,0x0013,DICOM_T_UNK,   _T("Container Component Thickness") },
{ 0x0050,0x0014,DICOM_T_UNK,   _T("Device Length") },
{ 0x0050,0x0015,DICOM_T_UNK,   _T("Container Component Width") },
{ 0x0050,0x0016,DICOM_T_UNK,   _T("Device Diameter") },
{ 0x0050,0x0017,DICOM_T_UNK,   _T("Device Diameter Units") },
{ 0x0050,0x0018,DICOM_T_UNK,   _T("Device Volume") },
{ 0x0050,0x0019,DICOM_T_UNK,   _T("Inter-Marker Distance") },
{ 0x0050,0x001A,DICOM_T_UNK,   _T("Container Component Material") },
{ 0x0050,0x001B,DICOM_T_UNK,   _T("Container Component ID") },
{ 0x0050,0x001C,DICOM_T_UNK,   _T("Container Component Length") },
{ 0x0050,0x001D,DICOM_T_UNK,   _T("Container Component Diameter") },
{ 0x0050,0x001E,DICOM_T_UNK,   _T("Container Component Description") },
{ 0x0050,0x0020,DICOM_T_UNK,   _T("Device Description") },
{ 0x0052,0x0001,DICOM_T_UNK,   _T("Contrast/Bolus Ingredient Percent by Volume") },
{ 0x0052,0x0002,DICOM_T_UNK,   _T("OCT Focal Distance") },
{ 0x0052,0x0003,DICOM_T_UNK,   _T("Beam Spot Size") },
{ 0x0052,0x0004,DICOM_T_UNK,   _T("Effective Refractive Index") },
{ 0x0052,0x0006,DICOM_T_UNK,   _T("OCT Acquisition Domain") },
{ 0x0052,0x0007,DICOM_T_UNK,   _T("OCT Optical Center Wavelength") },
{ 0x0052,0x0008,DICOM_T_UNK,   _T("Axial Resolution") },
{ 0x0052,0x0009,DICOM_T_UNK,   _T("Ranging Depth") },
{ 0x0052,0x0011,DICOM_T_UNK,   _T("A-line Rate") },
{ 0x0052,0x0012,DICOM_T_UNK,   _T("A-lines Per Frame") },
{ 0x0052,0x0013,DICOM_T_UNK,   _T("Catheter Rotational Rate") },
{ 0x0052,0x0014,DICOM_T_UNK,   _T("A-line Pixel Spacing") },
{ 0x0052,0x0016,DICOM_T_UNK,   _T("Mode of Percutaneous Access Sequence") },
{ 0x0052,0x0025,DICOM_T_UNK,   _T("Intravascular OCT Frame Type Sequence") },
{ 0x0052,0x0026,DICOM_T_UNK,   _T("OCT Z Offset Applied") },
{ 0x0052,0x0027,DICOM_T_UNK,   _T("Intravascular Frame Content Sequence") },
{ 0x0052,0x0028,DICOM_T_UNK,   _T("Intravascular Longitudinal Distance") },
{ 0x0052,0x0029,DICOM_T_UNK,   _T("Intravascular OCT Frame Content Sequence") },
{ 0x0052,0x0030,DICOM_T_UNK,   _T("OCT Z Offset Correction") },
{ 0x0052,0x0031,DICOM_T_UNK,   _T("Catheter Direction of Rotation") },
{ 0x0052,0x0033,DICOM_T_UNK,   _T("Seam Line Location") },
{ 0x0052,0x0034,DICOM_T_UNK,   _T("First A-line Location") },
{ 0x0052,0x0036,DICOM_T_UNK,   _T("Seam Line Index") },
{ 0x0052,0x0038,DICOM_T_UNK,   _T("Number of Padded A-lines") },
{ 0x0052,0x0039,DICOM_T_UNK,   _T("Interpolation Type") },
{ 0x0052,0x003A,DICOM_T_UNK,   _T("Refractive Index Applied") },
{ 0x0054,0x0010,DICOM_T_UNK,   _T("Energy Window Vector") },
{ 0x0054,0x0011,DICOM_T_UNK,   _T("Number of Energy Windows") },
{ 0x0054,0x0012,DICOM_T_UNK,   _T("Energy Window Information Sequence") },
{ 0x0054,0x0013,DICOM_T_UNK,   _T("Energy Window Range Sequence") },
{ 0x0054,0x0014,DICOM_T_UNK,   _T("Energy Window Lower Limit") },
{ 0x0054,0x0015,DICOM_T_UNK,   _T("Energy Window Upper Limit") },
{ 0x0054,0x0016,DICOM_T_UNK,   _T("Radiopharmaceutical Information Sequence") },
{ 0x0054,0x0017,DICOM_T_UNK,   _T("Residual Syringe Counts") },
{ 0x0054,0x0018,DICOM_T_UNK,   _T("Energy Window Name") },
{ 0x0054,0x0020,DICOM_T_UNK,   _T("Detector Vector") },
{ 0x0054,0x0021,DICOM_T_UNK,   _T("Number of Detectors") },
{ 0x0054,0x0022,DICOM_T_UNK,   _T("Detector Information Sequence") },
{ 0x0054,0x0030,DICOM_T_UNK,   _T("Phase Vector") },
{ 0x0054,0x0031,DICOM_T_UNK,   _T("Number of Phases") },
{ 0x0054,0x0032,DICOM_T_UNK,   _T("Phase Information Sequence") },
{ 0x0054,0x0033,DICOM_T_UNK,   _T("Number of Frames in Phase") },
{ 0x0054,0x0036,DICOM_T_UNK,   _T("Phase Delay") },
{ 0x0054,0x0038,DICOM_T_UNK,   _T("Pause Between Frames") },
{ 0x0054,0x0039,DICOM_T_UNK,   _T("Phase Description") },
{ 0x0054,0x0050,DICOM_T_UNK,   _T("Rotation Vector") },
{ 0x0054,0x0051,DICOM_T_UNK,   _T("Number of Rotations") },
{ 0x0054,0x0052,DICOM_T_UNK,   _T("Rotation Information Sequence") },
{ 0x0054,0x0053,DICOM_T_UNK,   _T("Number of Frames in Rotation") },
{ 0x0054,0x0060,DICOM_T_UNK,   _T("R-R Interval Vector") },
{ 0x0054,0x0061,DICOM_T_UNK,   _T("Number of R-R Intervals") },
{ 0x0054,0x0062,DICOM_T_UNK,   _T("Gated Information Sequence") },
{ 0x0054,0x0063,DICOM_T_UNK,   _T("Data Information Sequence") },
{ 0x0054,0x0070,DICOM_T_UNK,   _T("Time Slot Vector") },
{ 0x0054,0x0071,DICOM_T_UNK,   _T("Number of Time Slots") },
{ 0x0054,0x0072,DICOM_T_UNK,   _T("Time Slot Information Sequence") },
{ 0x0054,0x0073,DICOM_T_UNK,   _T("Time Slot Time") },
{ 0x0054,0x0080,DICOM_T_UNK,   _T("Slice Vector") },
{ 0x0054,0x0081,DICOM_T_UNK,   _T("Number of Slices") },
{ 0x0054,0x0090,DICOM_T_UNK,   _T("Angular View Vector") },
{ 0x0054,0x0100,DICOM_T_UNK,   _T("Time Slice Vector") },
{ 0x0054,0x0101,DICOM_T_UNK,   _T("Number of Time Slices") },
{ 0x0054,0x0200,DICOM_T_UNK,   _T("Start Angle") },
{ 0x0054,0x0202,DICOM_T_UNK,   _T("Type of Detector Motion") },
{ 0x0054,0x0210,DICOM_T_UNK,   _T("Trigger Vector") },
{ 0x0054,0x0211,DICOM_T_UNK,   _T("Number of Triggers in Phase") },
{ 0x0054,0x0220,DICOM_T_UNK,   _T("View Code Sequence") },
{ 0x0054,0x0222,DICOM_T_UNK,   _T("View Modifier Code Sequence") },
{ 0x0054,0x0300,DICOM_T_UNK,   _T("Radionuclide Code Sequence") },
{ 0x0054,0x0302,DICOM_T_UNK,   _T("Administration Route Code Sequence") },
{ 0x0054,0x0304,DICOM_T_UNK,   _T("Radiopharmaceutical Code Sequence") },
{ 0x0054,0x0306,DICOM_T_UNK,   _T("Calibration Data Sequence") },
{ 0x0054,0x0308,DICOM_T_UNK,   _T("Energy Window Number") },
{ 0x0054,0x0400,DICOM_T_UNK,   _T("Image ID") },
{ 0x0054,0x0410,DICOM_T_UNK,   _T("Patient Orientation Code Sequence") },
{ 0x0054,0x0412,DICOM_T_UNK,   _T("Patient Orientation Modifier Code Sequence") },
{ 0x0054,0x0414,DICOM_T_UNK,   _T("Patient Gantry Relationship Code Sequence") },
{ 0x0054,0x0500,DICOM_T_UNK,   _T("Slice Progression Direction") },
{ 0x0054,0x0501,DICOM_T_UNK,   _T("Scan Progression Direction") },
{ 0x0054,0x1000,DICOM_T_UNK,   _T("Series Type") },
{ 0x0054,0x1001,DICOM_T_UNK,   _T("Units") },
{ 0x0054,0x1002,DICOM_T_UNK,   _T("Counts Source") },
{ 0x0054,0x1004,DICOM_T_UNK,   _T("Reprojection Method") },
{ 0x0054,0x1006,DICOM_T_UNK,   _T("SUV Type") },
{ 0x0054,0x1100,DICOM_T_UNK,   _T("Randoms Correction Method") },
{ 0x0054,0x1101,DICOM_T_UNK,   _T("Attenuation Correction Method") },
{ 0x0054,0x1102,DICOM_T_UNK,   _T("Decay Correction") },
{ 0x0054,0x1103,DICOM_T_UNK,   _T("Reconstruction Method") },
{ 0x0054,0x1104,DICOM_T_UNK,   _T("Detector Lines of Response Used") },
{ 0x0054,0x1105,DICOM_T_UNK,   _T("Scatter Correction Method") },
{ 0x0054,0x1200,DICOM_T_UNK,   _T("Axial Acceptance") },
{ 0x0054,0x1201,DICOM_T_UNK,   _T("Axial Mash") },
{ 0x0054,0x1202,DICOM_T_UNK,   _T("Transverse Mash") },
{ 0x0054,0x1203,DICOM_T_UNK,   _T("Detector Element Size") },
{ 0x0054,0x1210,DICOM_T_UNK,   _T("Coincidence Window Width") },
{ 0x0054,0x1220,DICOM_T_UNK,   _T("Secondary Counts Type") },
{ 0x0054,0x1300,DICOM_T_UNK,   _T("Frame Reference Time") },
{ 0x0054,0x1310,DICOM_T_UNK,   _T("Primary (Prompts) Counts Accumulated") },
{ 0x0054,0x1311,DICOM_T_UNK,   _T("Secondary Counts Accumulated") },
{ 0x0054,0x1320,DICOM_T_UNK,   _T("Slice Sensitivity Factor") },
{ 0x0054,0x1321,DICOM_T_UNK,   _T("Decay Factor") },
{ 0x0054,0x1322,DICOM_T_UNK,   _T("Dose Calibration Factor") },
{ 0x0054,0x1323,DICOM_T_UNK,   _T("Scatter Fraction Factor") },
{ 0x0054,0x1324,DICOM_T_UNK,   _T("Dead Time Factor") },
{ 0x0054,0x1330,DICOM_T_UNK,   _T("Image Index") },
{ 0x0054,0x1400,DICOM_T_UNK,   _T("Counts Included") },
{ 0x0054,0x1401,DICOM_T_UNK,   _T("Dead Time Correction Flag") },
{ 0x0060,0x3000,DICOM_T_UNK,   _T("Histogram Sequence") },
{ 0x0060,0x3002,DICOM_T_UNK,   _T("Histogram Number of Bins") },
{ 0x0060,0x3004,DICOM_T_UNK,   _T("Histogram First Bin Value") },
{ 0x0060,0x3006,DICOM_T_UNK,   _T("Histogram Last Bin Value") },
{ 0x0060,0x3008,DICOM_T_UNK,   _T("Histogram Bin Width") },
{ 0x0060,0x3010,DICOM_T_UNK,   _T("Histogram Explanation") },
{ 0x0060,0x3020,DICOM_T_UNK,   _T("Histogram Data") },
{ 0x0062,0x0001,DICOM_T_UNK,   _T("Segmentation Type") },
{ 0x0062,0x0002,DICOM_T_UNK,   _T("Segment Sequence") },
{ 0x0062,0x0003,DICOM_T_UNK,   _T("Segmented Property Category Code Sequence") },
{ 0x0062,0x0004,DICOM_T_UNK,   _T("Segment Number") },
{ 0x0062,0x0005,DICOM_T_UNK,   _T("Segment Label") },
{ 0x0062,0x0006,DICOM_T_UNK,   _T("Segment Description") },
{ 0x0062,0x0008,DICOM_T_UNK,   _T("Segment Algorithm Type") },
{ 0x0062,0x0009,DICOM_T_UNK,   _T("Segment Algorithm Name") },
{ 0x0062,0x000A,DICOM_T_UNK,   _T("Segment Identification Sequence") },
{ 0x0062,0x000B,DICOM_T_UNK,   _T("Referenced Segment Number") },
{ 0x0062,0x000C,DICOM_T_UNK,   _T("Recommended Display Grayscale Value") },
{ 0x0062,0x000D,DICOM_T_UNK,   _T("Recommended Display CIELab Value") },
{ 0x0062,0x000E,DICOM_T_UNK,   _T("Maximum Fractional Value") },
{ 0x0062,0x000F,DICOM_T_UNK,   _T("Segmented Property Type Code Sequence") },
{ 0x0062,0x0010,DICOM_T_UNK,   _T("Segmentation Fractional Type") },
{ 0x0062,0x0011,DICOM_T_UNK,   _T("Segmented Property Type Modifier Code Sequence") },
{ 0x0062,0x0012,DICOM_T_UNK,   _T("Used Segments Sequence") },
{ 0x0064,0x0002,DICOM_T_UNK,   _T("Deformable Registration Sequence") },
{ 0x0064,0x0003,DICOM_T_UNK,   _T("Source Frame of Reference UID") },
{ 0x0064,0x0005,DICOM_T_UNK,   _T("Deformable Registration Grid Sequence") },
{ 0x0064,0x0007,DICOM_T_UNK,   _T("Grid Dimensions") },
{ 0x0064,0x0008,DICOM_T_UNK,   _T("Grid Resolution") },
{ 0x0064,0x0009,DICOM_T_UNK,   _T("Vector Grid Data") },
{ 0x0064,0x000F,DICOM_T_UNK,   _T("Pre Deformation Matrix Registration Sequence") },
{ 0x0064,0x0010,DICOM_T_UNK,   _T("Post Deformation Matrix Registration Sequence") },
{ 0x0066,0x0001,DICOM_T_UNK,   _T("Number of Surfaces") },
{ 0x0066,0x0002,DICOM_T_UNK,   _T("Surface Sequence") },
{ 0x0066,0x0003,DICOM_T_UNK,   _T("Surface Number") },
{ 0x0066,0x0004,DICOM_T_UNK,   _T("Surface Comments") },
{ 0x0066,0x0009,DICOM_T_UNK,   _T("Surface Processing") },
{ 0x0066,0x000A,DICOM_T_UNK,   _T("Surface Processing Ratio") },
{ 0x0066,0x000B,DICOM_T_UNK,   _T("Surface Processing Description") },
{ 0x0066,0x000C,DICOM_T_UNK,   _T("Recommended Presentation Opacity") },
{ 0x0066,0x000D,DICOM_T_UNK,   _T("Recommended Presentation Type") },
{ 0x0066,0x000E,DICOM_T_UNK,   _T("Finite Volume") },
{ 0x0066,0x0010,DICOM_T_UNK,   _T("Manifold") },
{ 0x0066,0x0011,DICOM_T_UNK,   _T("Surface Points Sequence") },
{ 0x0066,0x0012,DICOM_T_UNK,   _T("Surface Points Normals Sequence") },
{ 0x0066,0x0013,DICOM_T_UNK,   _T("Surface Mesh Primitives Sequence") },
{ 0x0066,0x0015,DICOM_T_UNK,   _T("Number of Surface Points") },
{ 0x0066,0x0016,DICOM_T_UNK,   _T("Point Coordinates Data") },
{ 0x0066,0x0017,DICOM_T_UNK,   _T("Point Position Accuracy") },
{ 0x0066,0x0018,DICOM_T_UNK,   _T("Mean Point Distance") },
{ 0x0066,0x0019,DICOM_T_UNK,   _T("Maximum Point Distance") },
{ 0x0066,0x001A,DICOM_T_UNK,   _T("Points Bounding Box Coordinates") },
{ 0x0066,0x001B,DICOM_T_UNK,   _T("Axis of Rotation") },
{ 0x0066,0x001C,DICOM_T_UNK,   _T("Center of Rotation") },
{ 0x0066,0x001E,DICOM_T_UNK,   _T("Number of Vectors") },
{ 0x0066,0x001F,DICOM_T_UNK,   _T("Vector Dimensionality") },
{ 0x0066,0x0020,DICOM_T_UNK,   _T("Vector Accuracy") },
{ 0x0066,0x0021,DICOM_T_UNK,   _T("Vector Coordinate Data") },
{ 0x0066,0x0023,DICOM_T_UNK,   _T("Triangle Point Index List") },
{ 0x0066,0x0024,DICOM_T_UNK,   _T("Edge Point Index List") },
{ 0x0066,0x0025,DICOM_T_UNK,   _T("Vertex Point Index List") },
{ 0x0066,0x0026,DICOM_T_UNK,   _T("Triangle Strip Sequence") },
{ 0x0066,0x0027,DICOM_T_UNK,   _T("Triangle Fan Sequence") },
{ 0x0066,0x0028,DICOM_T_UNK,   _T("Line Sequence") },
{ 0x0066,0x0029,DICOM_T_UNK,   _T("Primitive Point Index List") },
{ 0x0066,0x002A,DICOM_T_UNK,   _T("Surface Count") },
{ 0x0066,0x002B,DICOM_T_UNK,   _T("Referenced Surface Sequence") },
{ 0x0066,0x002C,DICOM_T_UNK,   _T("Referenced Surface Number") },
{ 0x0066,0x002D,DICOM_T_UNK,   _T("Segment Surface Generation Algorithm Identification Sequence") },
{ 0x0066,0x002E,DICOM_T_UNK,   _T("Segment Surface Source Instance Sequence") },
{ 0x0066,0x002F,DICOM_T_UNK,   _T("Algorithm Family Code Sequence") },
{ 0x0066,0x0030,DICOM_T_UNK,   _T("Algorithm Name Code Sequence") },
{ 0x0066,0x0031,DICOM_T_UNK,   _T("Algorithm Version") },
{ 0x0066,0x0032,DICOM_T_UNK,   _T("Algorithm Parameters") },
{ 0x0066,0x0034,DICOM_T_UNK,   _T("Facet Sequence") },
{ 0x0066,0x0035,DICOM_T_UNK,   _T("Surface Processing Algorithm Identification Sequence") },
{ 0x0066,0x0036,DICOM_T_UNK,   _T("Algorithm Name") },
{ 0x0066,0x0037,DICOM_T_UNK,   _T("Recommended Point Radius") },
{ 0x0066,0x0038,DICOM_T_UNK,   _T("Recommended Line Thickness") },
{ 0x0066,0x0040,DICOM_T_UNK,   _T("Long Primitive Point Index List") },
{ 0x0066,0x0041,DICOM_T_UNK,   _T("Long Triangle Point Index List") },
{ 0x0066,0x0042,DICOM_T_UNK,   _T("Long Edge Point Index List") },
{ 0x0066,0x0043,DICOM_T_UNK,   _T("Long Vertex Point Index List") },
{ 0x0068,0x6210,DICOM_T_UNK,   _T("Implant Size") },
{ 0x0068,0x6221,DICOM_T_UNK,   _T("Implant Template Version") },
{ 0x0068,0x6222,DICOM_T_UNK,   _T("Replaced Implant Template Sequence") },
{ 0x0068,0x6223,DICOM_T_UNK,   _T("Implant Type") },
{ 0x0068,0x6224,DICOM_T_UNK,   _T("Derivation Implant Template Sequence") },
{ 0x0068,0x6225,DICOM_T_UNK,   _T("Original Implant Template Sequence") },
{ 0x0068,0x6226,DICOM_T_UNK,   _T("Effective DateTime") },
{ 0x0068,0x6230,DICOM_T_UNK,   _T("Implant Target Anatomy Sequence") },
{ 0x0068,0x6260,DICOM_T_UNK,   _T("Information From Manufacturer Sequence") },
{ 0x0068,0x6265,DICOM_T_UNK,   _T("Notification From Manufacturer Sequence") },
{ 0x0068,0x6270,DICOM_T_UNK,   _T("Information Issue DateTime") },
{ 0x0068,0x6280,DICOM_T_UNK,   _T("Information Summary") },
{ 0x0068,0x62A0,DICOM_T_UNK,   _T("Implant Regulatory Disapproval Code Sequence") },
{ 0x0068,0x62A5,DICOM_T_UNK,   _T("Overall Template Spatial Tolerance") },
{ 0x0068,0x62C0,DICOM_T_UNK,   _T("HPGL Document Sequence") },
{ 0x0068,0x62D0,DICOM_T_UNK,   _T("HPGL Document ID") },
{ 0x0068,0x62D5,DICOM_T_UNK,   _T("HPGL Document Label") },
{ 0x0068,0x62E0,DICOM_T_UNK,   _T("View Orientation Code Sequence") },
{ 0x0068,0x62F0,DICOM_T_UNK,   _T("View Orientation Modifier") },
{ 0x0068,0x62F2,DICOM_T_UNK,   _T("HPGL Document Scaling") },
{ 0x0068,0x6300,DICOM_T_UNK,   _T("HPGL Document") },
{ 0x0068,0x6310,DICOM_T_UNK,   _T("HPGL Contour Pen Number") },
{ 0x0068,0x6320,DICOM_T_UNK,   _T("HPGL Pen Sequence") },
{ 0x0068,0x6330,DICOM_T_UNK,   _T("HPGL Pen Number") },
{ 0x0068,0x6340,DICOM_T_UNK,   _T("HPGL Pen Label") },
{ 0x0068,0x6345,DICOM_T_UNK,   _T("HPGL Pen Description") },
{ 0x0068,0x6346,DICOM_T_UNK,   _T("Recommended Rotation Point") },
{ 0x0068,0x6347,DICOM_T_UNK,   _T("Bounding Rectangle") },
{ 0x0068,0x6350,DICOM_T_UNK,   _T("Implant Template 3D Model Surface Number") },
{ 0x0068,0x6360,DICOM_T_UNK,   _T("Surface Model Description Sequence") },
{ 0x0068,0x6380,DICOM_T_UNK,   _T("Surface Model Label") },
{ 0x0068,0x6390,DICOM_T_UNK,   _T("Surface Model Scaling Factor") },
{ 0x0068,0x63A0,DICOM_T_UNK,   _T("Materials Code Sequence") },
{ 0x0068,0x63A4,DICOM_T_UNK,   _T("Coating Materials Code Sequence") },
{ 0x0068,0x63A8,DICOM_T_UNK,   _T("Implant Type Code Sequence") },
{ 0x0068,0x63AC,DICOM_T_UNK,   _T("Fixation Method Code Sequence") },
{ 0x0068,0x63B0,DICOM_T_UNK,   _T("Mating Feature Sets Sequence") },
{ 0x0068,0x63C0,DICOM_T_UNK,   _T("Mating Feature Set ID") },
{ 0x0068,0x63D0,DICOM_T_UNK,   _T("Mating Feature Set Label") },
{ 0x0068,0x63E0,DICOM_T_UNK,   _T("Mating Feature Sequence") },
{ 0x0068,0x63F0,DICOM_T_UNK,   _T("Mating Feature ID") },
{ 0x0068,0x6400,DICOM_T_UNK,   _T("Mating Feature Degree of Freedom Sequence") },
{ 0x0068,0x6410,DICOM_T_UNK,   _T("Degree of Freedom ID") },
{ 0x0068,0x6420,DICOM_T_UNK,   _T("Degree of Freedom Type") },
{ 0x0068,0x6430,DICOM_T_UNK,   _T("2D Mating Feature Coordinates Sequence") },
{ 0x0068,0x6440,DICOM_T_UNK,   _T("Referenced HPGL Document ID") },
{ 0x0068,0x6450,DICOM_T_UNK,   _T("2D Mating Point") },
{ 0x0068,0x6460,DICOM_T_UNK,   _T("2D Mating Axes") },
{ 0x0068,0x6470,DICOM_T_UNK,   _T("2D Degree of Freedom Sequence") },
{ 0x0068,0x6490,DICOM_T_UNK,   _T("3D Degree of Freedom Axis") },
{ 0x0068,0x64A0,DICOM_T_UNK,   _T("Range of Freedom") },
{ 0x0068,0x64C0,DICOM_T_UNK,   _T("3D Mating Point") },
{ 0x0068,0x64D0,DICOM_T_UNK,   _T("3D Mating Axes") },
{ 0x0068,0x64F0,DICOM_T_UNK,   _T("2D Degree of Freedom Axis") },
{ 0x0068,0x6500,DICOM_T_UNK,   _T("Planning Landmark Point Sequence") },
{ 0x0068,0x6510,DICOM_T_UNK,   _T("Planning Landmark Line Sequence") },
{ 0x0068,0x6520,DICOM_T_UNK,   _T("Planning Landmark Plane Sequence") },
{ 0x0068,0x6530,DICOM_T_UNK,   _T("Planning Landmark ID") },
{ 0x0068,0x6540,DICOM_T_UNK,   _T("Planning Landmark Description") },
{ 0x0068,0x6545,DICOM_T_UNK,   _T("Planning Landmark Identification Code Sequence") },
{ 0x0068,0x6550,DICOM_T_UNK,   _T("2D Point Coordinates Sequence") },
{ 0x0068,0x6560,DICOM_T_UNK,   _T("2D Point Coordinates") },
{ 0x0068,0x6590,DICOM_T_UNK,   _T("3D Point Coordinates") },
{ 0x0068,0x65A0,DICOM_T_UNK,   _T("2D Line Coordinates Sequence") },
{ 0x0068,0x65B0,DICOM_T_UNK,   _T("2D Line Coordinates") },
{ 0x0068,0x65D0,DICOM_T_UNK,   _T("3D Line Coordinates") },
{ 0x0068,0x65E0,DICOM_T_UNK,   _T("2D Plane Coordinates Sequence") },
{ 0x0068,0x65F0,DICOM_T_UNK,   _T("2D Plane Intersection") },
{ 0x0068,0x6610,DICOM_T_UNK,   _T("3D Plane Origin") },
{ 0x0068,0x6620,DICOM_T_UNK,   _T("3D Plane Normal") },
{ 0x0070,0x0001,DICOM_T_UNK,   _T("Graphic Annotation Sequence") },
{ 0x0070,0x0002,DICOM_T_UNK,   _T("Graphic Layer") },
{ 0x0070,0x0003,DICOM_T_UNK,   _T("Bounding Box Annotation Units") },
{ 0x0070,0x0004,DICOM_T_UNK,   _T("Anchor Point Annotation Units") },
{ 0x0070,0x0005,DICOM_T_UNK,   _T("Graphic Annotation Units") },
{ 0x0070,0x0006,DICOM_T_UNK,   _T("Unformatted Text Value") },
{ 0x0070,0x0008,DICOM_T_UNK,   _T("Text Object Sequence") },
{ 0x0070,0x0009,DICOM_T_UNK,   _T("Graphic Object Sequence") },
{ 0x0070,0x0010,DICOM_T_UNK,   _T("Bounding Box Top Left Hand Corner") },
{ 0x0070,0x0011,DICOM_T_UNK,   _T("Bounding Box Bottom Right Hand Corner") },
{ 0x0070,0x0012,DICOM_T_UNK,   _T("Bounding Box Text Horizontal Justification") },
{ 0x0070,0x0014,DICOM_T_UNK,   _T("Anchor Point") },
{ 0x0070,0x0015,DICOM_T_UNK,   _T("Anchor Point Visibility") },
{ 0x0070,0x0020,DICOM_T_UNK,   _T("Graphic Dimensions") },
{ 0x0070,0x0021,DICOM_T_UNK,   _T("Number of Graphic Points") },
{ 0x0070,0x0022,DICOM_T_UNK,   _T("Graphic Data") },
{ 0x0070,0x0023,DICOM_T_UNK,   _T("Graphic Type") },
{ 0x0070,0x0024,DICOM_T_UNK,   _T("Graphic Filled") },
{ 0x0070,0x0040,DICOM_T_UNK,   _T("Image Rotation (Retired)") },
{ 0x0070,0x0041,DICOM_T_UNK,   _T("Image Horizontal Flip") },
{ 0x0070,0x0042,DICOM_T_UNK,   _T("Image Rotation") },
{ 0x0070,0x0050,DICOM_T_UNK,   _T("Displayed Area Top Left Hand Corner (Trial)") },
{ 0x0070,0x0051,DICOM_T_UNK,   _T("Displayed Area Bottom Right Hand Corner (Trial)") },
{ 0x0070,0x0052,DICOM_T_UNK,   _T("Displayed Area Top Left Hand Corner") },
{ 0x0070,0x0053,DICOM_T_UNK,   _T("Displayed Area Bottom Right Hand Corner") },
{ 0x0070,0x005A,DICOM_T_UNK,   _T("Displayed Area Selection Sequence") },
{ 0x0070,0x0060,DICOM_T_UNK,   _T("Graphic Layer Sequence") },
{ 0x0070,0x0062,DICOM_T_UNK,   _T("Graphic Layer Order") },
{ 0x0070,0x0066,DICOM_T_UNK,   _T("Graphic Layer Recommended Display Grayscale Value") },
{ 0x0070,0x0067,DICOM_T_UNK,   _T("Graphic Layer Recommended Display RGB Value") },
{ 0x0070,0x0068,DICOM_T_UNK,   _T("Graphic Layer Description") },
{ 0x0070,0x0080,DICOM_T_UNK,   _T("Content Label") },
{ 0x0070,0x0081,DICOM_T_UNK,   _T("Content Description") },
{ 0x0070,0x0082,DICOM_T_UNK,   _T("Presentation Creation Date") },
{ 0x0070,0x0083,DICOM_T_UNK,   _T("Presentation Creation Time") },
{ 0x0070,0x0084,DICOM_T_UNK,   _T("Content Creator's Name") },
{ 0x0070,0x0086,DICOM_T_UNK,   _T("Content Creator's Identification Code Sequence") },
{ 0x0070,0x0087,DICOM_T_UNK,   _T("Alternate Content Description Sequence") },
{ 0x0070,0x0100,DICOM_T_UNK,   _T("Presentation Size Mode") },
{ 0x0070,0x0101,DICOM_T_UNK,   _T("Presentation Pixel Spacing") },
{ 0x0070,0x0102,DICOM_T_UNK,   _T("Presentation Pixel Aspect Ratio") },
{ 0x0070,0x0103,DICOM_T_UNK,   _T("Presentation Pixel Magnification Ratio") },
{ 0x0070,0x0207,DICOM_T_UNK,   _T("Graphic Group Label") },
{ 0x0070,0x0208,DICOM_T_UNK,   _T("Graphic Group Description") },
{ 0x0070,0x0209,DICOM_T_UNK,   _T("Compound Graphic Sequence") },
{ 0x0070,0x0226,DICOM_T_UNK,   _T("Compound Graphic Instance ID") },
{ 0x0070,0x0227,DICOM_T_UNK,   _T("Font Name") },
{ 0x0070,0x0228,DICOM_T_UNK,   _T("Font Name Type") },
{ 0x0070,0x0229,DICOM_T_UNK,   _T("CSS Font Name") },
{ 0x0070,0x0230,DICOM_T_UNK,   _T("Rotation Angle") },
{ 0x0070,0x0231,DICOM_T_UNK,   _T("Text Style Sequence") },
{ 0x0070,0x0232,DICOM_T_UNK,   _T("Line Style Sequence") },
{ 0x0070,0x0233,DICOM_T_UNK,   _T("Fill Style Sequence") },
{ 0x0070,0x0234,DICOM_T_UNK,   _T("Graphic Group Sequence") },
{ 0x0070,0x0241,DICOM_T_UNK,   _T("Text Color CIELab Value") },
{ 0x0070,0x0242,DICOM_T_UNK,   _T("Horizontal Alignment") },
{ 0x0070,0x0243,DICOM_T_UNK,   _T("Vertical Alignment") },
{ 0x0070,0x0244,DICOM_T_UNK,   _T("Shadow Style") },
{ 0x0070,0x0245,DICOM_T_UNK,   _T("Shadow Offset X") },
{ 0x0070,0x0246,DICOM_T_UNK,   _T("Shadow Offset Y") },
{ 0x0070,0x0247,DICOM_T_UNK,   _T("Shadow Color CIELab Value") },
{ 0x0070,0x0248,DICOM_T_UNK,   _T("Underlined") },
{ 0x0070,0x0249,DICOM_T_UNK,   _T("Bold") },
{ 0x0070,0x0250,DICOM_T_UNK,   _T("Italic") },
{ 0x0070,0x0251,DICOM_T_UNK,   _T("Pattern On Color CIELab Value") },
{ 0x0070,0x0252,DICOM_T_UNK,   _T("Pattern Off Color CIELab Value") },
{ 0x0070,0x0253,DICOM_T_UNK,   _T("Line Thickness") },
{ 0x0070,0x0254,DICOM_T_UNK,   _T("Line Dashing Style") },
{ 0x0070,0x0255,DICOM_T_UNK,   _T("Line Pattern") },
{ 0x0070,0x0256,DICOM_T_UNK,   _T("Fill Pattern") },
{ 0x0070,0x0257,DICOM_T_UNK,   _T("Fill Mode") },
{ 0x0070,0x0258,DICOM_T_UNK,   _T("Shadow Opacity") },
{ 0x0070,0x0261,DICOM_T_UNK,   _T("Gap Length") },
{ 0x0070,0x0262,DICOM_T_UNK,   _T("Diameter of Visibility") },
{ 0x0070,0x0273,DICOM_T_UNK,   _T("Rotation Point") },
{ 0x0070,0x0274,DICOM_T_UNK,   _T("Tick Alignment") },
{ 0x0070,0x0278,DICOM_T_UNK,   _T("Show Tick Label") },
{ 0x0070,0x0279,DICOM_T_UNK,   _T("Tick Label Alignment") },
{ 0x0070,0x0282,DICOM_T_UNK,   _T("Compound Graphic Units") },
{ 0x0070,0x0284,DICOM_T_UNK,   _T("Pattern On Opacity") },
{ 0x0070,0x0285,DICOM_T_UNK,   _T("Pattern Off Opacity") },
{ 0x0070,0x0287,DICOM_T_UNK,   _T("Major Ticks Sequence") },
{ 0x0070,0x0288,DICOM_T_UNK,   _T("Tick Position") },
{ 0x0070,0x0289,DICOM_T_UNK,   _T("Tick Label") },
{ 0x0070,0x0294,DICOM_T_UNK,   _T("Compound Graphic Type") },
{ 0x0070,0x0295,DICOM_T_UNK,   _T("Graphic Group ID") },
{ 0x0070,0x0306,DICOM_T_UNK,   _T("Shape Type") },
{ 0x0070,0x0308,DICOM_T_UNK,   _T("Registration Sequence") },
{ 0x0070,0x0309,DICOM_T_UNK,   _T("Matrix Registration Sequence") },
{ 0x0070,0x030A,DICOM_T_UNK,   _T("Matrix Sequence") },
{ 0x0070,0x030C,DICOM_T_UNK,   _T("Frame of Reference Transformation Matrix Type") },
{ 0x0070,0x030D,DICOM_T_UNK,   _T("Registration Type Code Sequence") },
{ 0x0070,0x030F,DICOM_T_UNK,   _T("Fiducial Description") },
{ 0x0070,0x0310,DICOM_T_UNK,   _T("Fiducial Identifier") },
{ 0x0070,0x0311,DICOM_T_UNK,   _T("Fiducial Identifier Code Sequence") },
{ 0x0070,0x0312,DICOM_T_UNK,   _T("Contour Uncertainty Radius") },
{ 0x0070,0x0314,DICOM_T_UNK,   _T("Used Fiducials Sequence") },
{ 0x0070,0x0318,DICOM_T_UNK,   _T("Graphic Coordinates Data Sequence") },
{ 0x0070,0x031A,DICOM_T_UNK,   _T("Fiducial UID") },
{ 0x0070,0x031C,DICOM_T_UNK,   _T("Fiducial Set Sequence") },
{ 0x0070,0x031E,DICOM_T_UNK,   _T("Fiducial Sequence") },
{ 0x0070,0x0401,DICOM_T_UNK,   _T("Graphic Layer Recommended Display CIELab Value") },
{ 0x0070,0x0402,DICOM_T_UNK,   _T("Blending Sequence") },
{ 0x0070,0x0403,DICOM_T_UNK,   _T("Relative Opacity") },
{ 0x0070,0x0404,DICOM_T_UNK,   _T("Referenced Spatial Registration Sequence") },
{ 0x0070,0x0405,DICOM_T_UNK,   _T("Blending Position") },
{ 0x0072,0x0002,DICOM_T_UNK,   _T("Hanging Protocol Name") },
{ 0x0072,0x0004,DICOM_T_UNK,   _T("Hanging Protocol Description") },
{ 0x0072,0x0006,DICOM_T_UNK,   _T("Hanging Protocol Level") },
{ 0x0072,0x0008,DICOM_T_UNK,   _T("Hanging Protocol Creator") },
{ 0x0072,0x000A,DICOM_T_UNK,   _T("Hanging Protocol Creation DateTime") },
{ 0x0072,0x000C,DICOM_T_UNK,   _T("Hanging Protocol Definition Sequence") },
{ 0x0072,0x000E,DICOM_T_UNK,   _T("Hanging Protocol User Identification Code Sequence") },
{ 0x0072,0x0010,DICOM_T_UNK,   _T("Hanging Protocol User Group Name") },
{ 0x0072,0x0012,DICOM_T_UNK,   _T("Source Hanging Protocol Sequence") },
{ 0x0072,0x0014,DICOM_T_UNK,   _T("Number of Priors Referenced") },
{ 0x0072,0x0020,DICOM_T_UNK,   _T("Image Sets Sequence") },
{ 0x0072,0x0022,DICOM_T_UNK,   _T("Image Set Selector Sequence") },
{ 0x0072,0x0024,DICOM_T_UNK,   _T("Image Set Selector Usage Flag") },
{ 0x0072,0x0026,DICOM_T_UNK,   _T("Selector Attribute") },
{ 0x0072,0x0028,DICOM_T_UNK,   _T("Selector Value Number") },
{ 0x0072,0x0030,DICOM_T_UNK,   _T("Time Based Image Sets Sequence") },
{ 0x0072,0x0032,DICOM_T_UNK,   _T("Image Set Number") },
{ 0x0072,0x0034,DICOM_T_UNK,   _T("Image Set Selector Category") },
{ 0x0072,0x0038,DICOM_T_UNK,   _T("Relative Time") },
{ 0x0072,0x003A,DICOM_T_UNK,   _T("Relative Time Units") },
{ 0x0072,0x003C,DICOM_T_UNK,   _T("Abstract Prior Value") },
{ 0x0072,0x003E,DICOM_T_UNK,   _T("Abstract Prior Code Sequence") },
{ 0x0072,0x0040,DICOM_T_UNK,   _T("Image Set Label") },
{ 0x0072,0x0050,DICOM_T_UNK,   _T("Selector Attribute VR") },
{ 0x0072,0x0052,DICOM_T_UNK,   _T("Selector Sequence Pointer") },
{ 0x0072,0x0054,DICOM_T_UNK,   _T("Selector Sequence Pointer Private Creator") },
{ 0x0072,0x0056,DICOM_T_UNK,   _T("Selector Attribute Private Creator") },
{ 0x0072,0x0060,DICOM_T_UNK,   _T("Selector AT Value") },
{ 0x0072,0x0062,DICOM_T_UNK,   _T("Selector CS Value") },
{ 0x0072,0x0064,DICOM_T_UNK,   _T("Selector IS Value") },
{ 0x0072,0x0066,DICOM_T_UNK,   _T("Selector LO Value") },
{ 0x0072,0x0068,DICOM_T_UNK,   _T("Selector LT Value") },
{ 0x0072,0x006A,DICOM_T_UNK,   _T("Selector PN Value") },
{ 0x0072,0x006C,DICOM_T_UNK,   _T("Selector SH Value") },
{ 0x0072,0x006E,DICOM_T_UNK,   _T("Selector ST Value") },
{ 0x0072,0x0070,DICOM_T_UNK,   _T("Selector UT Value") },
{ 0x0072,0x0072,DICOM_T_UNK,   _T("Selector DS Value") },
{ 0x0072,0x0074,DICOM_T_UNK,   _T("Selector FD Value") },
{ 0x0072,0x0076,DICOM_T_UNK,   _T("Selector FL Value") },
{ 0x0072,0x0078,DICOM_T_UNK,   _T("Selector UL Value") },
{ 0x0072,0x007A,DICOM_T_UNK,   _T("Selector US Value") },
{ 0x0072,0x007C,DICOM_T_UNK,   _T("Selector SL Value") },
{ 0x0072,0x007E,DICOM_T_UNK,   _T("Selector SS Value") },
{ 0x0072,0x0080,DICOM_T_UNK,   _T("Selector Code Sequence Value") },
{ 0x0072,0x0100,DICOM_T_UNK,   _T("Number of Screens") },
{ 0x0072,0x0102,DICOM_T_UNK,   _T("Nominal Screen Definition Sequence") },
{ 0x0072,0x0104,DICOM_T_UNK,   _T("Number of Vertical Pixels") },
{ 0x0072,0x0106,DICOM_T_UNK,   _T("Number of Horizontal Pixels") },
{ 0x0072,0x0108,DICOM_T_UNK,   _T("Display Environment Spatial Position") },
{ 0x0072,0x010A,DICOM_T_UNK,   _T("Screen Minimum Grayscale Bit Depth") },
{ 0x0072,0x010C,DICOM_T_UNK,   _T("Screen Minimum Color Bit Depth") },
{ 0x0072,0x010E,DICOM_T_UNK,   _T("Application Maximum Repaint Time") },
{ 0x0072,0x0200,DICOM_T_UNK,   _T("Display Sets Sequence") },
{ 0x0072,0x0202,DICOM_T_UNK,   _T("Display Set Number") },
{ 0x0072,0x0203,DICOM_T_UNK,   _T("Display Set Label") },
{ 0x0072,0x0204,DICOM_T_UNK,   _T("Display Set Presentation Group") },
{ 0x0072,0x0206,DICOM_T_UNK,   _T("Display Set Presentation Group Description") },
{ 0x0072,0x0208,DICOM_T_UNK,   _T("Partial Data Display Handling") },
{ 0x0072,0x0210,DICOM_T_UNK,   _T("Synchronized Scrolling Sequence") },
{ 0x0072,0x0212,DICOM_T_UNK,   _T("Display Set Scrolling Group") },
{ 0x0072,0x0214,DICOM_T_UNK,   _T("Navigation Indicator Sequence") },
{ 0x0072,0x0216,DICOM_T_UNK,   _T("Navigation Display Set") },
{ 0x0072,0x0218,DICOM_T_UNK,   _T("Reference Display Sets") },
{ 0x0072,0x0300,DICOM_T_UNK,   _T("Image Boxes Sequence") },
{ 0x0072,0x0302,DICOM_T_UNK,   _T("Image Box Number") },
{ 0x0072,0x0304,DICOM_T_UNK,   _T("Image Box Layout Type") },
{ 0x0072,0x0306,DICOM_T_UNK,   _T("Image Box Tile Horizontal Dimension") },
{ 0x0072,0x0308,DICOM_T_UNK,   _T("Image Box Tile Vertical Dimension") },
{ 0x0072,0x0310,DICOM_T_UNK,   _T("Image Box Scroll Direction") },
{ 0x0072,0x0312,DICOM_T_UNK,   _T("Image Box Small Scroll Type") },
{ 0x0072,0x0314,DICOM_T_UNK,   _T("Image Box Small Scroll Amount") },
{ 0x0072,0x0316,DICOM_T_UNK,   _T("Image Box Large Scroll Type") },
{ 0x0072,0x0318,DICOM_T_UNK,   _T("Image Box Large Scroll Amount") },
{ 0x0072,0x0320,DICOM_T_UNK,   _T("Image Box Overlap Priority") },
{ 0x0072,0x0330,DICOM_T_UNK,   _T("Cine Relative to Real-Time") },
{ 0x0072,0x0400,DICOM_T_UNK,   _T("Filter Operations Sequence") },
{ 0x0072,0x0402,DICOM_T_UNK,   _T("Filter-by Category") },
{ 0x0072,0x0404,DICOM_T_UNK,   _T("Filter-by Attribute Presence") },
{ 0x0072,0x0406,DICOM_T_UNK,   _T("Filter-by Operator") },
{ 0x0072,0x0420,DICOM_T_UNK,   _T("Structured Display Background CIELab Value") },
{ 0x0072,0x0421,DICOM_T_UNK,   _T("Empty Image Box CIELab Value") },
{ 0x0072,0x0422,DICOM_T_UNK,   _T("Structured Display Image Box Sequence") },
{ 0x0072,0x0424,DICOM_T_UNK,   _T("Structured Display Text Box Sequence") },
{ 0x0072,0x0427,DICOM_T_UNK,   _T("Referenced First Frame Sequence") },
{ 0x0072,0x0430,DICOM_T_UNK,   _T("Image Box Synchronization Sequence") },
{ 0x0072,0x0432,DICOM_T_UNK,   _T("Synchronized Image Box List") },
{ 0x0072,0x0434,DICOM_T_UNK,   _T("Type of Synchronization") },
{ 0x0072,0x0500,DICOM_T_UNK,   _T("Blending Operation Type") },
{ 0x0072,0x0510,DICOM_T_UNK,   _T("Reformatting Operation Type") },
{ 0x0072,0x0512,DICOM_T_UNK,   _T("Reformatting Thickness") },
{ 0x0072,0x0514,DICOM_T_UNK,   _T("Reformatting Interval") },
{ 0x0072,0x0516,DICOM_T_UNK,   _T("Reformatting Operation Initial View Direction") },
{ 0x0072,0x0520,DICOM_T_UNK,   _T("3D Rendering Type") },
{ 0x0072,0x0600,DICOM_T_UNK,   _T("Sorting Operations Sequence") },
{ 0x0072,0x0602,DICOM_T_UNK,   _T("Sort-by Category") },
{ 0x0072,0x0604,DICOM_T_UNK,   _T("Sorting Direction") },
{ 0x0072,0x0700,DICOM_T_UNK,   _T("Display Set Patient Orientation") },
{ 0x0072,0x0702,DICOM_T_UNK,   _T("VOI Type") },
{ 0x0072,0x0704,DICOM_T_UNK,   _T("Pseudo-Color Type") },
{ 0x0072,0x0705,DICOM_T_UNK,   _T("Pseudo-Color Palette Instance Reference Sequence") },
{ 0x0072,0x0706,DICOM_T_UNK,   _T("Show Grayscale Inverted") },
{ 0x0072,0x0710,DICOM_T_UNK,   _T("Show Image True Size Flag") },
{ 0x0072,0x0712,DICOM_T_UNK,   _T("Show Graphic Annotation Flag") },
{ 0x0072,0x0714,DICOM_T_UNK,   _T("Show Patient Demographics Flag") },
{ 0x0072,0x0716,DICOM_T_UNK,   _T("Show Acquisition Techniques Flag") },
{ 0x0072,0x0717,DICOM_T_UNK,   _T("Display Set Horizontal Justification") },
{ 0x0072,0x0718,DICOM_T_UNK,   _T("Display Set Vertical Justification") },
{ 0x0074,0x0120,DICOM_T_UNK,   _T("Continuation Start Meterset") },
{ 0x0074,0x0121,DICOM_T_UNK,   _T("Continuation End Meterset") },
{ 0x0074,0x1000,DICOM_T_UNK,   _T("Procedure Step State") },
{ 0x0074,0x1002,DICOM_T_UNK,   _T("Procedure Step Progress Information Sequence") },
{ 0x0074,0x1004,DICOM_T_UNK,   _T("Procedure Step Progress") },
{ 0x0074,0x1006,DICOM_T_UNK,   _T("Procedure Step Progress Description") },
{ 0x0074,0x1008,DICOM_T_UNK,   _T("Procedure Step Communications URI Sequence") },
{ 0x0074,0x100A,DICOM_T_UNK,   _T("Contact URI") },
{ 0x0074,0x100C,DICOM_T_UNK,   _T("Contact Display Name") },
{ 0x0074,0x100E,DICOM_T_UNK,   _T("Procedure Step Discontinuation Reason Code Sequence") },
{ 0x0074,0x1020,DICOM_T_UNK,   _T("Beam Task Sequence") },
{ 0x0074,0x1022,DICOM_T_UNK,   _T("Beam Task Type") },
{ 0x0074,0x1024,DICOM_T_UNK,   _T("Beam Order Index (Trial)") },
{ 0x0074,0x1025,DICOM_T_UNK,   _T("Autosequence Flag") },
{ 0x0074,0x1026,DICOM_T_UNK,   _T("Table Top Vertical Adjusted Position") },
{ 0x0074,0x1027,DICOM_T_UNK,   _T("Table Top Longitudinal Adjusted Position") },
{ 0x0074,0x1028,DICOM_T_UNK,   _T("Table Top Lateral Adjusted Position") },
{ 0x0074,0x102A,DICOM_T_UNK,   _T("Patient Support Adjusted Angle") },
{ 0x0074,0x102B,DICOM_T_UNK,   _T("Table Top Eccentric Adjusted Angle") },
{ 0x0074,0x102C,DICOM_T_UNK,   _T("Table Top Pitch Adjusted Angle") },
{ 0x0074,0x102D,DICOM_T_UNK,   _T("Table Top Roll Adjusted Angle") },
{ 0x0074,0x1030,DICOM_T_UNK,   _T("Delivery Verification Image Sequence") },
{ 0x0074,0x1032,DICOM_T_UNK,   _T("Verification Image Timing") },
{ 0x0074,0x1034,DICOM_T_UNK,   _T("Double Exposure Flag") },
{ 0x0074,0x1036,DICOM_T_UNK,   _T("Double Exposure Ordering") },
{ 0x0074,0x1038,DICOM_T_UNK,   _T("Double Exposure Meterset (Trial)") },
{ 0x0074,0x103A,DICOM_T_UNK,   _T("Double Exposure Field Delta (Trial)") },
{ 0x0074,0x1040,DICOM_T_UNK,   _T("Related Reference RT Image Sequence") },
{ 0x0074,0x1042,DICOM_T_UNK,   _T("General Machine Verification Sequence") },
{ 0x0074,0x1044,DICOM_T_UNK,   _T("Conventional Machine Verification Sequence") },
{ 0x0074,0x1046,DICOM_T_UNK,   _T("Ion Machine Verification Sequence") },
{ 0x0074,0x1048,DICOM_T_UNK,   _T("Failed Attributes Sequence") },
{ 0x0074,0x104A,DICOM_T_UNK,   _T("Overridden Attributes Sequence") },
{ 0x0074,0x104C,DICOM_T_UNK,   _T("Conventional Control Point Verification Sequence") },
{ 0x0074,0x104E,DICOM_T_UNK,   _T("Ion Control Point Verification Sequence") },
{ 0x0074,0x1050,DICOM_T_UNK,   _T("Attribute Occurrence Sequence") },
{ 0x0074,0x1052,DICOM_T_UNK,   _T("Attribute Occurrence Pointer") },
{ 0x0074,0x1054,DICOM_T_UNK,   _T("Attribute Item Selector") },
{ 0x0074,0x1056,DICOM_T_UNK,   _T("Attribute Occurrence Private Creator") },
{ 0x0074,0x1057,DICOM_T_UNK,   _T("Selector Sequence Pointer Items") },
{ 0x0074,0x1200,DICOM_T_UNK,   _T("Scheduled Procedure Step Priority") },
{ 0x0074,0x1202,DICOM_T_UNK,   _T("Worklist Label") },
{ 0x0074,0x1204,DICOM_T_UNK,   _T("Procedure Step Label") },
{ 0x0074,0x1210,DICOM_T_UNK,   _T("Scheduled Processing Parameters Sequence") },
{ 0x0074,0x1212,DICOM_T_UNK,   _T("Performed Processing Parameters Sequence") },
{ 0x0074,0x1216,DICOM_T_UNK,   _T("Unified Procedure Step Performed Procedure Sequence") },
{ 0x0074,0x1220,DICOM_T_UNK,   _T("Related Procedure Step Sequence") },
{ 0x0074,0x1222,DICOM_T_UNK,   _T("Procedure Step Relationship Type") },
{ 0x0074,0x1224,DICOM_T_UNK,   _T("Replaced Procedure Step Sequence") },
{ 0x0074,0x1230,DICOM_T_UNK,   _T("Deletion Lock") },
{ 0x0074,0x1234,DICOM_T_UNK,   _T("Receiving AE") },
{ 0x0074,0x1236,DICOM_T_UNK,   _T("Requesting AE") },
{ 0x0074,0x1238,DICOM_T_UNK,   _T("Reason for Cancellation") },
{ 0x0074,0x1242,DICOM_T_UNK,   _T("SCP Status") },
{ 0x0074,0x1244,DICOM_T_UNK,   _T("Subscription List Status") },
{ 0x0074,0x1246,DICOM_T_UNK,   _T("Unified Procedure Step List Status") },
{ 0x0074,0x1324,DICOM_T_UNK,   _T("Beam Order Index") },
{ 0x0074,0x1338,DICOM_T_UNK,   _T("Double Exposure Meterset") },
{ 0x0074,0x133A,DICOM_T_UNK,   _T("Double Exposure Field Delta") },
{ 0x0076,0x0001,DICOM_T_UNK,   _T("Implant Assembly Template Name") },
{ 0x0076,0x0003,DICOM_T_UNK,   _T("Implant Assembly Template Issuer") },
{ 0x0076,0x0006,DICOM_T_UNK,   _T("Implant Assembly Template Version") },
{ 0x0076,0x0008,DICOM_T_UNK,   _T("Replaced Implant Assembly Template Sequence") },
{ 0x0076,0x000A,DICOM_T_UNK,   _T("Implant Assembly Template Type") },
{ 0x0076,0x000C,DICOM_T_UNK,   _T("Original Implant Assembly Template Sequence") },
{ 0x0076,0x000E,DICOM_T_UNK,   _T("Derivation Implant Assembly Template Sequence") },
{ 0x0076,0x0010,DICOM_T_UNK,   _T("Implant Assembly Template Target Anatomy Sequence") },
{ 0x0076,0x0020,DICOM_T_UNK,   _T("Procedure Type Code Sequence") },
{ 0x0076,0x0030,DICOM_T_UNK,   _T("Surgical Technique") },
{ 0x0076,0x0032,DICOM_T_UNK,   _T("Component Types Sequence") },
{ 0x0076,0x0034,DICOM_T_UNK,   _T("Component Type Code Sequence") },
{ 0x0076,0x0036,DICOM_T_UNK,   _T("Exclusive Component Type") },
{ 0x0076,0x0038,DICOM_T_UNK,   _T("Mandatory Component Type") },
{ 0x0076,0x0040,DICOM_T_UNK,   _T("Component Sequence") },
{ 0x0076,0x0055,DICOM_T_UNK,   _T("Component ID") },
{ 0x0076,0x0060,DICOM_T_UNK,   _T("Component Assembly Sequence") },
{ 0x0076,0x0070,DICOM_T_UNK,   _T("Component 1 Referenced ID") },
{ 0x0076,0x0080,DICOM_T_UNK,   _T("Component 1 Referenced Mating Feature Set ID") },
{ 0x0076,0x0090,DICOM_T_UNK,   _T("Component 1 Referenced Mating Feature ID") },
{ 0x0076,0x00A0,DICOM_T_UNK,   _T("Component 2 Referenced ID") },
{ 0x0076,0x00B0,DICOM_T_UNK,   _T("Component 2 Referenced Mating Feature Set ID") },
{ 0x0076,0x00C0,DICOM_T_UNK,   _T("Component 2 Referenced Mating Feature ID") },
{ 0x0078,0x0001,DICOM_T_UNK,   _T("Implant Template Group Name") },
{ 0x0078,0x0010,DICOM_T_UNK,   _T("Implant Template Group Description") },
{ 0x0078,0x0020,DICOM_T_UNK,   _T("Implant Template Group Issuer") },
{ 0x0078,0x0024,DICOM_T_UNK,   _T("Implant Template Group Version") },
{ 0x0078,0x0026,DICOM_T_UNK,   _T("Replaced Implant Template Group Sequence") },
{ 0x0078,0x0028,DICOM_T_UNK,   _T("Implant Template Group Target Anatomy Sequence") },
{ 0x0078,0x002A,DICOM_T_UNK,   _T("Implant Template Group Members Sequence") },
{ 0x0078,0x002E,DICOM_T_UNK,   _T("Implant Template Group Member ID") },
{ 0x0078,0x0050,DICOM_T_UNK,   _T("3D Implant Template Group Member Matching Point") },
{ 0x0078,0x0060,DICOM_T_UNK,   _T("3D Implant Template Group Member Matching Axes") },
{ 0x0078,0x0070,DICOM_T_UNK,   _T("Implant Template Group Member Matching 2D Coordinates Sequence") },
{ 0x0078,0x0090,DICOM_T_UNK,   _T("2D Implant Template Group Member Matching Point") },
{ 0x0078,0x00A0,DICOM_T_UNK,   _T("2D Implant Template Group Member Matching Axes") },
{ 0x0078,0x00B0,DICOM_T_UNK,   _T("Implant Template Group Variation Dimension Sequence") },
{ 0x0078,0x00B2,DICOM_T_UNK,   _T("Implant Template Group Variation Dimension Name") },
{ 0x0078,0x00B4,DICOM_T_UNK,   _T("Implant Template Group Variation Dimension Rank Sequence") },
{ 0x0078,0x00B6,DICOM_T_UNK,   _T("Referenced Implant Template Group Member ID") },
{ 0x0078,0x00B8,DICOM_T_UNK,   _T("Implant Template Group Variation Dimension Rank") },
{ 0x0080,0x0001,DICOM_T_UNK,   _T("Surface Scan Acquisition Type Code Sequence") },
{ 0x0080,0x0002,DICOM_T_UNK,   _T("Surface Scan Mode Code Sequence") },
{ 0x0080,0x0003,DICOM_T_UNK,   _T("Registration Method Code Sequence") },
{ 0x0080,0x0004,DICOM_T_UNK,   _T("Shot Duration Time") },
{ 0x0080,0x0005,DICOM_T_UNK,   _T("Shot Offset Time") },
{ 0x0080,0x0006,DICOM_T_UNK,   _T("Surface Point Presentation Value Data") },
{ 0x0080,0x0007,DICOM_T_UNK,   _T("Surface Point Color CIELab Value Data") },
{ 0x0080,0x0008,DICOM_T_UNK,   _T("UV Mapping Sequence") },
{ 0x0080,0x0009,DICOM_T_UNK,   _T("Texture Label") },
{ 0x0080,0x0010,DICOM_T_UNK,   _T("U Value Data") },
{ 0x0080,0x0011,DICOM_T_UNK,   _T("V Value Data") },
{ 0x0080,0x0012,DICOM_T_UNK,   _T("Referenced Texture Sequence") },
{ 0x0080,0x0013,DICOM_T_UNK,   _T("Referenced Surface Data Sequence") },
{ 0x0088,0x0130,DICOM_T_UNK,   _T("Storage Media File-set ID") },
{ 0x0088,0x0140,DICOM_T_UNK,   _T("Storage Media File-set UID") },
{ 0x0088,0x0200,DICOM_T_UNK,   _T("Icon Image Sequence") },
{ 0x0088,0x0904,DICOM_T_UNK,   _T("Topic Title") },
{ 0x0088,0x0906,DICOM_T_UNK,   _T("Topic Subject") },
{ 0x0088,0x0910,DICOM_T_UNK,   _T("Topic Author") },
{ 0x0088,0x0912,DICOM_T_UNK,   _T("Topic Keywords") },
{ 0x0100,0x0410,DICOM_T_UNK,   _T("SOP Instance Status") },
{ 0x0100,0x0420,DICOM_T_UNK,   _T("SOP Authorization DateTime") },
{ 0x0100,0x0424,DICOM_T_UNK,   _T("SOP Authorization Comment") },
{ 0x0100,0x0426,DICOM_T_UNK,   _T("Authorization Equipment Certification Number") },
{ 0x0400,0x0005,DICOM_T_UNK,   _T("MAC ID Number") },
{ 0x0400,0x0010,DICOM_T_UNK,   _T("MAC Calculation Transfer Syntax UID") },
{ 0x0400,0x0015,DICOM_T_UNK,   _T("MAC Algorithm") },
{ 0x0400,0x0020,DICOM_T_UNK,   _T("Data Elements Signed") },
{ 0x0400,0x0100,DICOM_T_UNK,   _T("Digital Signature UID") },
{ 0x0400,0x0105,DICOM_T_UNK,   _T("Digital Signature DateTime") },
{ 0x0400,0x0110,DICOM_T_UNK,   _T("Certificate Type") },
{ 0x0400,0x0115,DICOM_T_UNK,   _T("Certificate of Signer") },
{ 0x0400,0x0120,DICOM_T_UNK,   _T("Signature") },
{ 0x0400,0x0305,DICOM_T_UNK,   _T("Certified Timestamp Type") },
{ 0x0400,0x0310,DICOM_T_UNK,   _T("Certified Timestamp") },
{ 0x0400,0x0401,DICOM_T_UNK,   _T("Digital Signature Purpose Code Sequence") },
{ 0x0400,0x0402,DICOM_T_UNK,   _T("Referenced Digital Signature Sequence") },
{ 0x0400,0x0403,DICOM_T_UNK,   _T("Referenced SOP Instance MAC Sequence") },
{ 0x0400,0x0404,DICOM_T_UNK,   _T("MAC") },
{ 0x0400,0x0500,DICOM_T_UNK,   _T("Encrypted Attributes Sequence") },
{ 0x0400,0x0510,DICOM_T_UNK,   _T("Encrypted Content Transfer Syntax UID") },
{ 0x0400,0x0520,DICOM_T_UNK,   _T("Encrypted Content") },
{ 0x0400,0x0550,DICOM_T_UNK,   _T("Modified Attributes Sequence") },
{ 0x0400,0x0561,DICOM_T_UNK,   _T("Original Attributes Sequence") },
{ 0x0400,0x0562,DICOM_T_UNK,   _T("Attribute Modification DateTime") },
{ 0x0400,0x0563,DICOM_T_UNK,   _T("Modifying System") },
{ 0x0400,0x0564,DICOM_T_UNK,   _T("Source of Previous Values") },
{ 0x0400,0x0565,DICOM_T_UNK,   _T("Reason for the Attribute Modification") },
/*
{ 0x1000,0xxxx0,DICOM_T_UNK,   _T("Escape Triplet") },
{ 0x1000,0xxxx1,DICOM_T_UNK,   _T("Run Length Triplet") },
{ 0x1000,0xxxx2,DICOM_T_UNK,   _T("Huffman Table Size") },
{ 0x1000,0xxxx3,DICOM_T_UNK,   _T("Huffman Table Triplet") },
{ 0x1000,0xxxx4,DICOM_T_UNK,   _T("Shift Table Size") },
{ 0x1000,0xxxx5,DICOM_T_UNK,   _T("Shift Table Triplet") },
{ 0x1010,0xxxxx,DICOM_T_UNK,   _T("Zonal Map") },
*/
{ 0x2000,0x0010,DICOM_T_UNK,   _T("Number of Copies") },
{ 0x2000,0x001E,DICOM_T_UNK,   _T("Printer Configuration Sequence") },
{ 0x2000,0x0020,DICOM_T_UNK,   _T("Print Priority") },
{ 0x2000,0x0030,DICOM_T_UNK,   _T("Medium Type") },
{ 0x2000,0x0040,DICOM_T_UNK,   _T("Film Destination") },
{ 0x2000,0x0050,DICOM_T_UNK,   _T("Film Session Label") },
{ 0x2000,0x0060,DICOM_T_UNK,   _T("Memory Allocation") },
{ 0x2000,0x0061,DICOM_T_UNK,   _T("Maximum Memory Allocation") },
{ 0x2000,0x0062,DICOM_T_UNK,   _T("Color Image Printing Flag") },
{ 0x2000,0x0063,DICOM_T_UNK,   _T("Collation Flag") },
{ 0x2000,0x0065,DICOM_T_UNK,   _T("Annotation Flag") },
{ 0x2000,0x0067,DICOM_T_UNK,   _T("Image Overlay Flag") },
{ 0x2000,0x0069,DICOM_T_UNK,   _T("Presentation LUT Flag") },
{ 0x2000,0x006A,DICOM_T_UNK,   _T("Image Box Presentation LUT Flag") },
{ 0x2000,0x00A0,DICOM_T_UNK,   _T("Memory Bit Depth") },
{ 0x2000,0x00A1,DICOM_T_UNK,   _T("Printing Bit Depth") },
{ 0x2000,0x00A2,DICOM_T_UNK,   _T("Media Installed Sequence") },
{ 0x2000,0x00A4,DICOM_T_UNK,   _T("Other Media Available Sequence") },
{ 0x2000,0x00A8,DICOM_T_UNK,   _T("Supported Image Display Formats Sequence") },
{ 0x2000,0x0500,DICOM_T_UNK,   _T("Referenced Film Box Sequence") },
{ 0x2000,0x0510,DICOM_T_UNK,   _T("Referenced Stored Print Sequence") },
{ 0x2010,0x0010,DICOM_T_UNK,   _T("Image Display Format") },
{ 0x2010,0x0030,DICOM_T_UNK,   _T("Annotation Display Format ID") },
{ 0x2010,0x0040,DICOM_T_UNK,   _T("Film Orientation") },
{ 0x2010,0x0050,DICOM_T_UNK,   _T("Film Size ID") },
{ 0x2010,0x0052,DICOM_T_UNK,   _T("Printer Resolution ID") },
{ 0x2010,0x0054,DICOM_T_UNK,   _T("Default Printer Resolution ID") },
{ 0x2010,0x0060,DICOM_T_UNK,   _T("Magnification Type") },
{ 0x2010,0x0080,DICOM_T_UNK,   _T("Smoothing Type") },
{ 0x2010,0x00A6,DICOM_T_UNK,   _T("Default Magnification Type") },
{ 0x2010,0x00A7,DICOM_T_UNK,   _T("Other Magnification Types Available") },
{ 0x2010,0x00A8,DICOM_T_UNK,   _T("Default Smoothing Type") },
{ 0x2010,0x00A9,DICOM_T_UNK,   _T("Other Smoothing Types Available") },
{ 0x2010,0x0100,DICOM_T_UNK,   _T("Border Density") },
{ 0x2010,0x0110,DICOM_T_UNK,   _T("Empty Image Density") },
{ 0x2010,0x0120,DICOM_T_UNK,   _T("Min Density") },
{ 0x2010,0x0130,DICOM_T_UNK,   _T("Max Density") },
{ 0x2010,0x0140,DICOM_T_UNK,   _T("Trim") },
{ 0x2010,0x0150,DICOM_T_UNK,   _T("Configuration Information") },
{ 0x2010,0x0152,DICOM_T_UNK,   _T("Configuration Information Description") },
{ 0x2010,0x0154,DICOM_T_UNK,   _T("Maximum Collated Films") },
{ 0x2010,0x015E,DICOM_T_UNK,   _T("Illumination") },
{ 0x2010,0x0160,DICOM_T_UNK,   _T("Reflected Ambient Light") },
{ 0x2010,0x0376,DICOM_T_UNK,   _T("Printer Pixel Spacing") },
{ 0x2010,0x0500,DICOM_T_UNK,   _T("Referenced Film Session Sequence") },
{ 0x2010,0x0510,DICOM_T_UNK,   _T("Referenced Image Box Sequence") },
{ 0x2010,0x0520,DICOM_T_UNK,   _T("Referenced Basic Annotation Box Sequence") },
{ 0x2020,0x0010,DICOM_T_UNK,   _T("Image Box Position") },
{ 0x2020,0x0020,DICOM_T_UNK,   _T("Polarity") },
{ 0x2020,0x0030,DICOM_T_UNK,   _T("Requested Image Size") },
{ 0x2020,0x0040,DICOM_T_UNK,   _T("Requested Decimate/Crop Behavior") },
{ 0x2020,0x0050,DICOM_T_UNK,   _T("Requested Resolution ID") },
{ 0x2020,0x00A0,DICOM_T_UNK,   _T("Requested Image Size Flag") },
{ 0x2020,0x00A2,DICOM_T_UNK,   _T("Decimate/Crop Result") },
{ 0x2020,0x0110,DICOM_T_UNK,   _T("Basic Grayscale Image Sequence") },
{ 0x2020,0x0111,DICOM_T_UNK,   _T("Basic Color Image Sequence") },
{ 0x2020,0x0130,DICOM_T_UNK,   _T("Referenced Image Overlay Box Sequence") },
{ 0x2020,0x0140,DICOM_T_UNK,   _T("Referenced VOI LUT Box Sequence") },
{ 0x2030,0x0010,DICOM_T_UNK,   _T("Annotation Position") },
{ 0x2030,0x0020,DICOM_T_UNK,   _T("Text String") },
{ 0x2040,0x0010,DICOM_T_UNK,   _T("Referenced Overlay Plane Sequence") },
{ 0x2040,0x0011,DICOM_T_UNK,   _T("Referenced Overlay Plane Groups") },
{ 0x2040,0x0020,DICOM_T_UNK,   _T("Overlay Pixel Data Sequence") },
{ 0x2040,0x0060,DICOM_T_UNK,   _T("Overlay Magnification Type") },
{ 0x2040,0x0070,DICOM_T_UNK,   _T("Overlay Smoothing Type") },
{ 0x2040,0x0072,DICOM_T_UNK,   _T("Overlay or Image Magnification") },
{ 0x2040,0x0074,DICOM_T_UNK,   _T("Magnify to Number of Columns") },
{ 0x2040,0x0080,DICOM_T_UNK,   _T("Overlay Foreground Density") },
{ 0x2040,0x0082,DICOM_T_UNK,   _T("Overlay Background Density") },
{ 0x2040,0x0090,DICOM_T_UNK,   _T("Overlay Mode") },
{ 0x2040,0x0100,DICOM_T_UNK,   _T("Threshold Density") },
{ 0x2040,0x0500,DICOM_T_UNK,   _T("Referenced Image Box Sequence (Retired)") },
{ 0x2050,0x0010,DICOM_T_UNK,   _T("Presentation LUT Sequence") },
{ 0x2050,0x0020,DICOM_T_UNK,   _T("Presentation LUT Shape") },
{ 0x2050,0x0500,DICOM_T_UNK,   _T("Referenced Presentation LUT Sequence") },
{ 0x2100,0x0010,DICOM_T_UNK,   _T("Print Job ID") },
{ 0x2100,0x0020,DICOM_T_UNK,   _T("Execution Status") },
{ 0x2100,0x0030,DICOM_T_UNK,   _T("Execution Status Info") },
{ 0x2100,0x0040,DICOM_T_UNK,   _T("Creation Date") },
{ 0x2100,0x0050,DICOM_T_UNK,   _T("Creation Time") },
{ 0x2100,0x0070,DICOM_T_UNK,   _T("Originator") },
{ 0x2100,0x0140,DICOM_T_UNK,   _T("Destination AE") },
{ 0x2100,0x0160,DICOM_T_UNK,   _T("Owner ID") },
{ 0x2100,0x0170,DICOM_T_UNK,   _T("Number of Films") },
{ 0x2100,0x0500,DICOM_T_UNK,   _T("Referenced Print Job Sequence (Pull Stored Print)") },
{ 0x2110,0x0010,DICOM_T_UNK,   _T("Printer Status") },
{ 0x2110,0x0020,DICOM_T_UNK,   _T("Printer Status Info") },
{ 0x2110,0x0030,DICOM_T_UNK,   _T("Printer Name") },
{ 0x2110,0x0099,DICOM_T_UNK,   _T("Print Queue ID") },
{ 0x2120,0x0010,DICOM_T_UNK,   _T("Queue Status") },
{ 0x2120,0x0050,DICOM_T_UNK,   _T("Print Job Description Sequence") },
{ 0x2120,0x0070,DICOM_T_UNK,   _T("Referenced Print Job Sequence") },
{ 0x2130,0x0010,DICOM_T_UNK,   _T("Print Management Capabilities Sequence") },
{ 0x2130,0x0015,DICOM_T_UNK,   _T("Printer Characteristics Sequence") },
{ 0x2130,0x0030,DICOM_T_UNK,   _T("Film Box Content Sequence") },
{ 0x2130,0x0040,DICOM_T_UNK,   _T("Image Box Content Sequence") },
{ 0x2130,0x0050,DICOM_T_UNK,   _T("Annotation Content Sequence") },
{ 0x2130,0x0060,DICOM_T_UNK,   _T("Image Overlay Box Content Sequence") },
{ 0x2130,0x0080,DICOM_T_UNK,   _T("Presentation LUT Content Sequence") },
{ 0x2130,0x00A0,DICOM_T_UNK,   _T("Proposed Study Sequence") },
{ 0x2130,0x00C0,DICOM_T_UNK,   _T("Original Image Sequence") },
{ 0x2200,0x0001,DICOM_T_UNK,   _T("Label Using Information Extracted From Instances") },
{ 0x2200,0x0002,DICOM_T_UNK,   _T("Label Text") },
{ 0x2200,0x0003,DICOM_T_UNK,   _T("Label Style Selection") },
{ 0x2200,0x0004,DICOM_T_UNK,   _T("Media Disposition") },
{ 0x2200,0x0005,DICOM_T_UNK,   _T("Barcode Value") },
{ 0x2200,0x0006,DICOM_T_UNK,   _T("Barcode Symbology") },
{ 0x2200,0x0007,DICOM_T_UNK,   _T("Allow Media Splitting") },
{ 0x2200,0x0008,DICOM_T_UNK,   _T("Include Non-DICOM Objects") },
{ 0x2200,0x0009,DICOM_T_UNK,   _T("Include Display Application") },
{ 0x2200,0x000A,DICOM_T_UNK,   _T("Preserve Composite Instances After Media Creation") },
{ 0x2200,0x000B,DICOM_T_UNK,   _T("Total Number of Pieces of Media Created") },
{ 0x2200,0x000C,DICOM_T_UNK,   _T("Requested Media Application Profile") },
{ 0x2200,0x000D,DICOM_T_UNK,   _T("Referenced Storage Media Sequence") },
{ 0x2200,0x000E,DICOM_T_UNK,   _T("Failure Attributes") },
{ 0x2200,0x000F,DICOM_T_UNK,   _T("Allow Lossy Compression") },
{ 0x2200,0x0020,DICOM_T_UNK,   _T("Request Priority") },
{ 0x3002,0x0002,DICOM_T_UNK,   _T("RT Image Label") },
{ 0x3002,0x0003,DICOM_T_UNK,   _T("RT Image Name") },
{ 0x3002,0x0004,DICOM_T_UNK,   _T("RT Image Description") },
{ 0x3002,0x000A,DICOM_T_UNK,   _T("Reported Values Origin") },
{ 0x3002,0x000C,DICOM_T_UNK,   _T("RT Image Plane") },
{ 0x3002,0x000D,DICOM_T_UNK,   _T("X-Ray Image Receptor Translation") },
{ 0x3002,0x000E,DICOM_T_UNK,   _T("X-Ray Image Receptor Angle") },
{ 0x3002,0x0010,DICOM_T_UNK,   _T("RT Image Orientation") },
{ 0x3002,0x0011,DICOM_T_UNK,   _T("Image Plane Pixel Spacing") },
{ 0x3002,0x0012,DICOM_T_UNK,   _T("RT Image Position") },
{ 0x3002,0x0020,DICOM_T_UNK,   _T("Radiation Machine Name") },
{ 0x3002,0x0022,DICOM_T_UNK,   _T("Radiation Machine SAD") },
{ 0x3002,0x0024,DICOM_T_UNK,   _T("Radiation Machine SSD") },
{ 0x3002,0x0026,DICOM_T_UNK,   _T("RT Image SID") },
{ 0x3002,0x0028,DICOM_T_UNK,   _T("Source to Reference Object Distance") },
{ 0x3002,0x0029,DICOM_T_UNK,   _T("Fraction Number") },
{ 0x3002,0x0030,DICOM_T_UNK,   _T("Exposure Sequence") },
{ 0x3002,0x0032,DICOM_T_UNK,   _T("Meterset Exposure") },
{ 0x3002,0x0034,DICOM_T_UNK,   _T("Diaphragm Position") },
{ 0x3002,0x0040,DICOM_T_UNK,   _T("Fluence Map Sequence") },
{ 0x3002,0x0041,DICOM_T_UNK,   _T("Fluence Data Source") },
{ 0x3002,0x0042,DICOM_T_UNK,   _T("Fluence Data Scale") },
{ 0x3002,0x0050,DICOM_T_UNK,   _T("Primary Fluence Mode Sequence") },
{ 0x3002,0x0051,DICOM_T_UNK,   _T("Fluence Mode") },
{ 0x3002,0x0052,DICOM_T_UNK,   _T("Fluence Mode ID") },
{ 0x3004,0x0001,DICOM_T_UNK,   _T("DVH Type") },
{ 0x3004,0x0002,DICOM_T_UNK,   _T("Dose Units") },
{ 0x3004,0x0004,DICOM_T_UNK,   _T("Dose Type") },
{ 0x3004,0x0005,DICOM_T_UNK,   _T("Spatial Transform of Dose") },
{ 0x3004,0x0006,DICOM_T_UNK,   _T("Dose Comment") },
{ 0x3004,0x0008,DICOM_T_UNK,   _T("Normalization Point") },
{ 0x3004,0x000A,DICOM_T_UNK,   _T("Dose Summation Type") },
{ 0x3004,0x000C,DICOM_T_UNK,   _T("Grid Frame Offset Vector") },
{ 0x3004,0x000E,DICOM_T_UNK,   _T("Dose Grid Scaling") },
{ 0x3004,0x0010,DICOM_T_UNK,   _T("RT Dose ROI Sequence") },
{ 0x3004,0x0012,DICOM_T_UNK,   _T("Dose Value") },
{ 0x3004,0x0014,DICOM_T_UNK,   _T("Tissue Heterogeneity Correction") },
{ 0x3004,0x0040,DICOM_T_UNK,   _T("DVH Normalization Point") },
{ 0x3004,0x0042,DICOM_T_UNK,   _T("DVH Normalization Dose Value") },
{ 0x3004,0x0050,DICOM_T_UNK,   _T("DVH Sequence") },
{ 0x3004,0x0052,DICOM_T_UNK,   _T("DVH Dose Scaling") },
{ 0x3004,0x0054,DICOM_T_UNK,   _T("DVH Volume Units") },
{ 0x3004,0x0056,DICOM_T_UNK,   _T("DVH Number of Bins") },
{ 0x3004,0x0058,DICOM_T_UNK,   _T("DVH Data") },
{ 0x3004,0x0060,DICOM_T_UNK,   _T("DVH Referenced ROI Sequence") },
{ 0x3004,0x0062,DICOM_T_UNK,   _T("DVH ROI Contribution Type") },
{ 0x3004,0x0070,DICOM_T_UNK,   _T("DVH Minimum Dose") },
{ 0x3004,0x0072,DICOM_T_UNK,   _T("DVH Maximum Dose") },
{ 0x3004,0x0074,DICOM_T_UNK,   _T("DVH Mean Dose") },
{ 0x3006,0x0002,DICOM_T_UNK,   _T("Structure Set Label") },
{ 0x3006,0x0004,DICOM_T_UNK,   _T("Structure Set Name") },
{ 0x3006,0x0006,DICOM_T_UNK,   _T("Structure Set Description") },
{ 0x3006,0x0008,DICOM_T_UNK,   _T("Structure Set Date") },
{ 0x3006,0x0009,DICOM_T_UNK,   _T("Structure Set Time") },
{ 0x3006,0x0010,DICOM_T_UNK,   _T("Referenced Frame of Reference Sequence") },
{ 0x3006,0x0012,DICOM_T_UNK,   _T("RT Referenced Study Sequence") },
{ 0x3006,0x0014,DICOM_T_UNK,   _T("RT Referenced Series Sequence") },
{ 0x3006,0x0016,DICOM_T_UNK,   _T("Contour Image Sequence") },
{ 0x3006,0x0018,DICOM_T_UNK,   _T("Predecessor Structure Set Sequence") },
{ 0x3006,0x0020,DICOM_T_UNK,   _T("Structure Set ROI Sequence") },
{ 0x3006,0x0022,DICOM_T_UNK,   _T("ROI Number") },
{ 0x3006,0x0024,DICOM_T_UNK,   _T("Referenced Frame of Reference UID") },
{ 0x3006,0x0026,DICOM_T_UNK,   _T("ROI Name") },
{ 0x3006,0x0028,DICOM_T_UNK,   _T("ROI Description") },
{ 0x3006,0x002A,DICOM_T_UNK,   _T("ROI Display Color") },
{ 0x3006,0x002C,DICOM_T_UNK,   _T("ROI Volume") },
{ 0x3006,0x0030,DICOM_T_UNK,   _T("RT Related ROI Sequence") },
{ 0x3006,0x0033,DICOM_T_UNK,   _T("RT ROI Relationship") },
{ 0x3006,0x0036,DICOM_T_UNK,   _T("ROI Generation Algorithm") },
{ 0x3006,0x0038,DICOM_T_UNK,   _T("ROI Generation Description") },
{ 0x3006,0x0039,DICOM_T_UNK,   _T("ROI Contour Sequence") },
{ 0x3006,0x0040,DICOM_T_UNK,   _T("Contour Sequence") },
{ 0x3006,0x0042,DICOM_T_UNK,   _T("Contour Geometric Type") },
{ 0x3006,0x0044,DICOM_T_UNK,   _T("Contour Slab Thickness") },
{ 0x3006,0x0045,DICOM_T_UNK,   _T("Contour Offset Vector") },
{ 0x3006,0x0046,DICOM_T_UNK,   _T("Number of Contour Points") },
{ 0x3006,0x0048,DICOM_T_UNK,   _T("Contour Number") },
{ 0x3006,0x0049,DICOM_T_UNK,   _T("Attached Contours") },
{ 0x3006,0x0050,DICOM_T_UNK,   _T("Contour Data") },
{ 0x3006,0x0080,DICOM_T_UNK,   _T("RT ROI Observations Sequence") },
{ 0x3006,0x0082,DICOM_T_UNK,   _T("Observation Number") },
{ 0x3006,0x0084,DICOM_T_UNK,   _T("Referenced ROI Number") },
{ 0x3006,0x0085,DICOM_T_UNK,   _T("ROI Observation Label") },
{ 0x3006,0x0086,DICOM_T_UNK,   _T("RT ROI Identification Code Sequence") },
{ 0x3006,0x0088,DICOM_T_UNK,   _T("ROI Observation Description") },
{ 0x3006,0x00A0,DICOM_T_UNK,   _T("Related RT ROI Observations Sequence") },
{ 0x3006,0x00A4,DICOM_T_UNK,   _T("RT ROI Interpreted Type") },
{ 0x3006,0x00A6,DICOM_T_UNK,   _T("ROI Interpreter") },
{ 0x3006,0x00B0,DICOM_T_UNK,   _T("ROI Physical Properties Sequence") },
{ 0x3006,0x00B2,DICOM_T_UNK,   _T("ROI Physical Property") },
{ 0x3006,0x00B4,DICOM_T_UNK,   _T("ROI Physical Property Value") },
{ 0x3006,0x00B6,DICOM_T_UNK,   _T("ROI Elemental Composition Sequence") },
{ 0x3006,0x00B7,DICOM_T_UNK,   _T("ROI Elemental Composition Atomic Number") },
{ 0x3006,0x00B8,DICOM_T_UNK,   _T("ROI Elemental Composition Atomic Mass Fraction") },
{ 0x3006,0x00B9,DICOM_T_UNK,   _T("Additional RT ROI Identification Code Sequence") },
{ 0x3006,0x00C0,DICOM_T_UNK,   _T("Frame of Reference Relationship Sequence") },
{ 0x3006,0x00C2,DICOM_T_UNK,   _T("Related Frame of Reference UID") },
{ 0x3006,0x00C4,DICOM_T_UNK,   _T("Frame of Reference Transformation Type") },
{ 0x3006,0x00C6,DICOM_T_UNK,   _T("Frame of Reference Transformation Matrix") },
{ 0x3006,0x00C8,DICOM_T_UNK,   _T("Frame of Reference Transformation Comment") },
{ 0x3008,0x0010,DICOM_T_UNK,   _T("Measured Dose Reference Sequence") },
{ 0x3008,0x0012,DICOM_T_UNK,   _T("Measured Dose Description") },
{ 0x3008,0x0014,DICOM_T_UNK,   _T("Measured Dose Type") },
{ 0x3008,0x0016,DICOM_T_UNK,   _T("Measured Dose Value") },
{ 0x3008,0x0020,DICOM_T_UNK,   _T("Treatment Session Beam Sequence") },
{ 0x3008,0x0021,DICOM_T_UNK,   _T("Treatment Session Ion Beam Sequence") },
{ 0x3008,0x0022,DICOM_T_UNK,   _T("Current Fraction Number") },
{ 0x3008,0x0024,DICOM_T_UNK,   _T("Treatment Control Point Date") },
{ 0x3008,0x0025,DICOM_T_UNK,   _T("Treatment Control Point Time") },
{ 0x3008,0x002A,DICOM_T_UNK,   _T("Treatment Termination Status") },
{ 0x3008,0x002B,DICOM_T_UNK,   _T("Treatment Termination Code") },
{ 0x3008,0x002C,DICOM_T_UNK,   _T("Treatment Verification Status") },
{ 0x3008,0x0030,DICOM_T_UNK,   _T("Referenced Treatment Record Sequence") },
{ 0x3008,0x0032,DICOM_T_UNK,   _T("Specified Primary Meterset") },
{ 0x3008,0x0033,DICOM_T_UNK,   _T("Specified Secondary Meterset") },
{ 0x3008,0x0036,DICOM_T_UNK,   _T("Delivered Primary Meterset") },
{ 0x3008,0x0037,DICOM_T_UNK,   _T("Delivered Secondary Meterset") },
{ 0x3008,0x003A,DICOM_T_UNK,   _T("Specified Treatment Time") },
{ 0x3008,0x003B,DICOM_T_UNK,   _T("Delivered Treatment Time") },
{ 0x3008,0x0040,DICOM_T_UNK,   _T("Control Point Delivery Sequence") },
{ 0x3008,0x0041,DICOM_T_UNK,   _T("Ion Control Point Delivery Sequence") },
{ 0x3008,0x0042,DICOM_T_UNK,   _T("Specified Meterset") },
{ 0x3008,0x0044,DICOM_T_UNK,   _T("Delivered Meterset") },
{ 0x3008,0x0045,DICOM_T_UNK,   _T("Meterset Rate Set") },
{ 0x3008,0x0046,DICOM_T_UNK,   _T("Meterset Rate Delivered") },
{ 0x3008,0x0047,DICOM_T_UNK,   _T("Scan Spot Metersets Delivered") },
{ 0x3008,0x0048,DICOM_T_UNK,   _T("Dose Rate Delivered") },
{ 0x3008,0x0050,DICOM_T_UNK,   _T("Treatment Summary Calculated Dose Reference Sequence") },
{ 0x3008,0x0052,DICOM_T_UNK,   _T("Cumulative Dose to Dose Reference") },
{ 0x3008,0x0054,DICOM_T_UNK,   _T("First Treatment Date") },
{ 0x3008,0x0056,DICOM_T_UNK,   _T("Most Recent Treatment Date") },
{ 0x3008,0x005A,DICOM_T_UNK,   _T("Number of Fractions Delivered") },
{ 0x3008,0x0060,DICOM_T_UNK,   _T("Override Sequence") },
{ 0x3008,0x0061,DICOM_T_UNK,   _T("Parameter Sequence Pointer") },
{ 0x3008,0x0062,DICOM_T_UNK,   _T("Override Parameter Pointer") },
{ 0x3008,0x0063,DICOM_T_UNK,   _T("Parameter Item Index") },
{ 0x3008,0x0064,DICOM_T_UNK,   _T("Measured Dose Reference Number") },
{ 0x3008,0x0065,DICOM_T_UNK,   _T("Parameter Pointer") },
{ 0x3008,0x0066,DICOM_T_UNK,   _T("Override Reason") },
{ 0x3008,0x0068,DICOM_T_UNK,   _T("Corrected Parameter Sequence") },
{ 0x3008,0x006A,DICOM_T_UNK,   _T("Correction Value") },
{ 0x3008,0x0070,DICOM_T_UNK,   _T("Calculated Dose Reference Sequence") },
{ 0x3008,0x0072,DICOM_T_UNK,   _T("Calculated Dose Reference Number") },
{ 0x3008,0x0074,DICOM_T_UNK,   _T("Calculated Dose Reference Description") },
{ 0x3008,0x0076,DICOM_T_UNK,   _T("Calculated Dose Reference Dose Value") },
{ 0x3008,0x0078,DICOM_T_UNK,   _T("Start Meterset") },
{ 0x3008,0x007A,DICOM_T_UNK,   _T("End Meterset") },
{ 0x3008,0x0080,DICOM_T_UNK,   _T("Referenced Measured Dose Reference Sequence") },
{ 0x3008,0x0082,DICOM_T_UNK,   _T("Referenced Measured Dose Reference Number") },
{ 0x3008,0x0090,DICOM_T_UNK,   _T("Referenced Calculated Dose Reference Sequence") },
{ 0x3008,0x0092,DICOM_T_UNK,   _T("Referenced Calculated Dose Reference Number") },
{ 0x3008,0x00A0,DICOM_T_UNK,   _T("Beam Limiting Device Leaf Pairs Sequence") },
{ 0x3008,0x00B0,DICOM_T_UNK,   _T("Recorded Wedge Sequence") },
{ 0x3008,0x00C0,DICOM_T_UNK,   _T("Recorded Compensator Sequence") },
{ 0x3008,0x00D0,DICOM_T_UNK,   _T("Recorded Block Sequence") },
{ 0x3008,0x00E0,DICOM_T_UNK,   _T("Treatment Summary Measured Dose Reference Sequence") },
{ 0x3008,0x00F0,DICOM_T_UNK,   _T("Recorded Snout Sequence") },
{ 0x3008,0x00F2,DICOM_T_UNK,   _T("Recorded Range Shifter Sequence") },
{ 0x3008,0x00F4,DICOM_T_UNK,   _T("Recorded Lateral Spreading Device Sequence") },
{ 0x3008,0x00F6,DICOM_T_UNK,   _T("Recorded Range Modulator Sequence") },
{ 0x3008,0x0100,DICOM_T_UNK,   _T("Recorded Source Sequence") },
{ 0x3008,0x0105,DICOM_T_UNK,   _T("Source Serial Number") },
{ 0x3008,0x0110,DICOM_T_UNK,   _T("Treatment Session Application Setup Sequence") },
{ 0x3008,0x0116,DICOM_T_UNK,   _T("Application Setup Check") },
{ 0x3008,0x0120,DICOM_T_UNK,   _T("Recorded Brachy Accessory Device Sequence") },
{ 0x3008,0x0122,DICOM_T_UNK,   _T("Referenced Brachy Accessory Device Number") },
{ 0x3008,0x0130,DICOM_T_UNK,   _T("Recorded Channel Sequence") },
{ 0x3008,0x0132,DICOM_T_UNK,   _T("Specified Channel Total Time") },
{ 0x3008,0x0134,DICOM_T_UNK,   _T("Delivered Channel Total Time") },
{ 0x3008,0x0136,DICOM_T_UNK,   _T("Specified Number of Pulses") },
{ 0x3008,0x0138,DICOM_T_UNK,   _T("Delivered Number of Pulses") },
{ 0x3008,0x013A,DICOM_T_UNK,   _T("Specified Pulse Repetition Interval") },
{ 0x3008,0x013C,DICOM_T_UNK,   _T("Delivered Pulse Repetition Interval") },
{ 0x3008,0x0140,DICOM_T_UNK,   _T("Recorded Source Applicator Sequence") },
{ 0x3008,0x0142,DICOM_T_UNK,   _T("Referenced Source Applicator Number") },
{ 0x3008,0x0150,DICOM_T_UNK,   _T("Recorded Channel Shield Sequence") },
{ 0x3008,0x0152,DICOM_T_UNK,   _T("Referenced Channel Shield Number") },
{ 0x3008,0x0160,DICOM_T_UNK,   _T("Brachy Control Point Delivered Sequence") },
{ 0x3008,0x0162,DICOM_T_UNK,   _T("Safe Position Exit Date") },
{ 0x3008,0x0164,DICOM_T_UNK,   _T("Safe Position Exit Time") },
{ 0x3008,0x0166,DICOM_T_UNK,   _T("Safe Position Return Date") },
{ 0x3008,0x0168,DICOM_T_UNK,   _T("Safe Position Return Time") },
{ 0x3008,0x0171,DICOM_T_UNK,   _T("Pulse Specific Brachy Control Point Delivered Sequence") },
{ 0x3008,0x0172,DICOM_T_UNK,   _T("Pulse Number") },
{ 0x3008,0x0173,DICOM_T_UNK,   _T("Brachy Pulse Control Point Delivered Sequence") },
{ 0x3008,0x0200,DICOM_T_UNK,   _T("Current Treatment Status") },
{ 0x3008,0x0202,DICOM_T_UNK,   _T("Treatment Status Comment") },
{ 0x3008,0x0220,DICOM_T_UNK,   _T("Fraction Group Summary Sequence") },
{ 0x3008,0x0223,DICOM_T_UNK,   _T("Referenced Fraction Number") },
{ 0x3008,0x0224,DICOM_T_UNK,   _T("Fraction Group Type") },
{ 0x3008,0x0230,DICOM_T_UNK,   _T("Beam Stopper Position") },
{ 0x3008,0x0240,DICOM_T_UNK,   _T("Fraction Status Summary Sequence") },
{ 0x3008,0x0250,DICOM_T_UNK,   _T("Treatment Date") },
{ 0x3008,0x0251,DICOM_T_UNK,   _T("Treatment Time") },
{ 0x300A,0x0002,DICOM_T_UNK,   _T("RT Plan Label") },
{ 0x300A,0x0003,DICOM_T_UNK,   _T("RT Plan Name") },
{ 0x300A,0x0004,DICOM_T_UNK,   _T("RT Plan Description") },
{ 0x300A,0x0006,DICOM_T_UNK,   _T("RT Plan Date") },
{ 0x300A,0x0007,DICOM_T_UNK,   _T("RT Plan Time") },
{ 0x300A,0x0009,DICOM_T_UNK,   _T("Treatment Protocols") },
{ 0x300A,0x000A,DICOM_T_UNK,   _T("Plan Intent") },
{ 0x300A,0x000B,DICOM_T_UNK,   _T("Treatment Sites") },
{ 0x300A,0x000C,DICOM_T_UNK,   _T("RT Plan Geometry") },
{ 0x300A,0x000E,DICOM_T_UNK,   _T("Prescription Description") },
{ 0x300A,0x0010,DICOM_T_UNK,   _T("Dose Reference Sequence") },
{ 0x300A,0x0012,DICOM_T_UNK,   _T("Dose Reference Number") },
{ 0x300A,0x0013,DICOM_T_UNK,   _T("Dose Reference UID") },
{ 0x300A,0x0014,DICOM_T_UNK,   _T("Dose Reference Structure Type") },
{ 0x300A,0x0015,DICOM_T_UNK,   _T("Nominal Beam Energy Unit") },
{ 0x300A,0x0016,DICOM_T_UNK,   _T("Dose Reference Description") },
{ 0x300A,0x0018,DICOM_T_UNK,   _T("Dose Reference Point Coordinates") },
{ 0x300A,0x001A,DICOM_T_UNK,   _T("Nominal Prior Dose") },
{ 0x300A,0x0020,DICOM_T_UNK,   _T("Dose Reference Type") },
{ 0x300A,0x0021,DICOM_T_UNK,   _T("Constraint Weight") },
{ 0x300A,0x0022,DICOM_T_UNK,   _T("Delivery Warning Dose") },
{ 0x300A,0x0023,DICOM_T_UNK,   _T("Delivery Maximum Dose") },
{ 0x300A,0x0025,DICOM_T_UNK,   _T("Target Minimum Dose") },
{ 0x300A,0x0026,DICOM_T_UNK,   _T("Target Prescription Dose") },
{ 0x300A,0x0027,DICOM_T_UNK,   _T("Target Maximum Dose") },
{ 0x300A,0x0028,DICOM_T_UNK,   _T("Target Underdose Volume Fraction") },
{ 0x300A,0x002A,DICOM_T_UNK,   _T("Organ at Risk Full-volume Dose") },
{ 0x300A,0x002B,DICOM_T_UNK,   _T("Organ at Risk Limit Dose") },
{ 0x300A,0x002C,DICOM_T_UNK,   _T("Organ at Risk Maximum Dose") },
{ 0x300A,0x002D,DICOM_T_UNK,   _T("Organ at Risk Overdose Volume Fraction") },
{ 0x300A,0x0040,DICOM_T_UNK,   _T("Tolerance Table Sequence") },
{ 0x300A,0x0042,DICOM_T_UNK,   _T("Tolerance Table Number") },
{ 0x300A,0x0043,DICOM_T_UNK,   _T("Tolerance Table Label") },
{ 0x300A,0x0044,DICOM_T_UNK,   _T("Gantry Angle Tolerance") },
{ 0x300A,0x0046,DICOM_T_UNK,   _T("Beam Limiting Device Angle Tolerance") },
{ 0x300A,0x0048,DICOM_T_UNK,   _T("Beam Limiting Device Tolerance Sequence") },
{ 0x300A,0x004A,DICOM_T_UNK,   _T("Beam Limiting Device Position Tolerance") },
{ 0x300A,0x004B,DICOM_T_UNK,   _T("Snout Position Tolerance") },
{ 0x300A,0x004C,DICOM_T_UNK,   _T("Patient Support Angle Tolerance") },
{ 0x300A,0x004E,DICOM_T_UNK,   _T("Table Top Eccentric Angle Tolerance") },
{ 0x300A,0x004F,DICOM_T_UNK,   _T("Table Top Pitch Angle Tolerance") },
{ 0x300A,0x0050,DICOM_T_UNK,   _T("Table Top Roll Angle Tolerance") },
{ 0x300A,0x0051,DICOM_T_UNK,   _T("Table Top Vertical Position Tolerance") },
{ 0x300A,0x0052,DICOM_T_UNK,   _T("Table Top Longitudinal Position Tolerance") },
{ 0x300A,0x0053,DICOM_T_UNK,   _T("Table Top Lateral Position Tolerance") },
{ 0x300A,0x0055,DICOM_T_UNK,   _T("RT Plan Relationship") },
{ 0x300A,0x0070,DICOM_T_UNK,   _T("Fraction Group Sequence") },
{ 0x300A,0x0071,DICOM_T_UNK,   _T("Fraction Group Number") },
{ 0x300A,0x0072,DICOM_T_UNK,   _T("Fraction Group Description") },
{ 0x300A,0x0078,DICOM_T_UNK,   _T("Number of Fractions Planned") },
{ 0x300A,0x0079,DICOM_T_UNK,   _T("Number of Fraction Pattern Digits Per Day") },
{ 0x300A,0x007A,DICOM_T_UNK,   _T("Repeat Fraction Cycle Length") },
{ 0x300A,0x007B,DICOM_T_UNK,   _T("Fraction Pattern") },
{ 0x300A,0x0080,DICOM_T_UNK,   _T("Number of Beams") },
{ 0x300A,0x0082,DICOM_T_UNK,   _T("Beam Dose Specification Point") },
{ 0x300A,0x0084,DICOM_T_UNK,   _T("Beam Dose") },
{ 0x300A,0x0086,DICOM_T_UNK,   _T("Beam Meterset") },
{ 0x300A,0x0088,DICOM_T_UNK,   _T("Beam Dose Point Depth") },
{ 0x300A,0x0089,DICOM_T_UNK,   _T("Beam Dose Point Equivalent Depth") },
{ 0x300A,0x008A,DICOM_T_UNK,   _T("Beam Dose Point SSD") },
{ 0x300A,0x008B,DICOM_T_UNK,   _T("Beam Dose Meaning") },
{ 0x300A,0x008C,DICOM_T_UNK,   _T("Beam Dose Verification Control Point Sequence") },
{ 0x300A,0x008D,DICOM_T_UNK,   _T("Average Beam Dose Point Depth") },
{ 0x300A,0x008E,DICOM_T_UNK,   _T("Average Beam Dose Point Equivalent Depth") },
{ 0x300A,0x008F,DICOM_T_UNK,   _T("Average Beam Dose Point SSD") },
{ 0x300A,0x00A0,DICOM_T_UNK,   _T("Number of Brachy Application Setups") },
{ 0x300A,0x00A2,DICOM_T_UNK,   _T("Brachy Application Setup Dose Specification Point") },
{ 0x300A,0x00A4,DICOM_T_UNK,   _T("Brachy Application Setup Dose") },
{ 0x300A,0x00B0,DICOM_T_UNK,   _T("Beam Sequence") },
{ 0x300A,0x00B2,DICOM_T_UNK,   _T("Treatment Machine Name") },
{ 0x300A,0x00B3,DICOM_T_UNK,   _T("Primary Dosimeter Unit") },
{ 0x300A,0x00B4,DICOM_T_UNK,   _T("Source-Axis Distance") },
{ 0x300A,0x00B6,DICOM_T_UNK,   _T("Beam Limiting Device Sequence") },
{ 0x300A,0x00B8,DICOM_T_UNK,   _T("RT Beam Limiting Device Type") },
{ 0x300A,0x00BA,DICOM_T_UNK,   _T("Source to Beam Limiting Device Distance") },
{ 0x300A,0x00BB,DICOM_T_UNK,   _T("Isocenter to Beam Limiting Device Distance") },
{ 0x300A,0x00BC,DICOM_T_UNK,   _T("Number of Leaf/Jaw Pairs") },
{ 0x300A,0x00BE,DICOM_T_UNK,   _T("Leaf Position Boundaries") },
{ 0x300A,0x00C0,DICOM_T_UNK,   _T("Beam Number") },
{ 0x300A,0x00C2,DICOM_T_UNK,   _T("Beam Name") },
{ 0x300A,0x00C3,DICOM_T_UNK,   _T("Beam Description") },
{ 0x300A,0x00C4,DICOM_T_UNK,   _T("Beam Type") },
{ 0x300A,0x00C5,DICOM_T_UNK,   _T("Beam Delivery Duration Limit") },
{ 0x300A,0x00C6,DICOM_T_UNK,   _T("Radiation Type") },
{ 0x300A,0x00C7,DICOM_T_UNK,   _T("High-Dose Technique Type") },
{ 0x300A,0x00C8,DICOM_T_UNK,   _T("Reference Image Number") },
{ 0x300A,0x00CA,DICOM_T_UNK,   _T("Planned Verification Image Sequence") },
{ 0x300A,0x00CC,DICOM_T_UNK,   _T("Imaging Device-Specific Acquisition Parameters") },
{ 0x300A,0x00CE,DICOM_T_UNK,   _T("Treatment Delivery Type") },
{ 0x300A,0x00D0,DICOM_T_UNK,   _T("Number of Wedges") },
{ 0x300A,0x00D1,DICOM_T_UNK,   _T("Wedge Sequence") },
{ 0x300A,0x00D2,DICOM_T_UNK,   _T("Wedge Number") },
{ 0x300A,0x00D3,DICOM_T_UNK,   _T("Wedge Type") },
{ 0x300A,0x00D4,DICOM_T_UNK,   _T("Wedge ID") },
{ 0x300A,0x00D5,DICOM_T_UNK,   _T("Wedge Angle") },
{ 0x300A,0x00D6,DICOM_T_UNK,   _T("Wedge Factor") },
{ 0x300A,0x00D7,DICOM_T_UNK,   _T("Total Wedge Tray Water-Equivalent Thickness") },
{ 0x300A,0x00D8,DICOM_T_UNK,   _T("Wedge Orientation") },
{ 0x300A,0x00D9,DICOM_T_UNK,   _T("Isocenter to Wedge Tray Distance") },
{ 0x300A,0x00DA,DICOM_T_UNK,   _T("Source to Wedge Tray Distance") },
{ 0x300A,0x00DB,DICOM_T_UNK,   _T("Wedge Thin Edge Position") },
{ 0x300A,0x00DC,DICOM_T_UNK,   _T("Bolus ID") },
{ 0x300A,0x00DD,DICOM_T_UNK,   _T("Bolus Description") },
{ 0x300A,0x00E0,DICOM_T_UNK,   _T("Number of Compensators") },
{ 0x300A,0x00E1,DICOM_T_UNK,   _T("Material ID") },
{ 0x300A,0x00E2,DICOM_T_UNK,   _T("Total Compensator Tray Factor") },
{ 0x300A,0x00E3,DICOM_T_UNK,   _T("Compensator Sequence") },
{ 0x300A,0x00E4,DICOM_T_UNK,   _T("Compensator Number") },
{ 0x300A,0x00E5,DICOM_T_UNK,   _T("Compensator ID") },
{ 0x300A,0x00E6,DICOM_T_UNK,   _T("Source to Compensator Tray Distance") },
{ 0x300A,0x00E7,DICOM_T_UNK,   _T("Compensator Rows") },
{ 0x300A,0x00E8,DICOM_T_UNK,   _T("Compensator Columns") },
{ 0x300A,0x00E9,DICOM_T_UNK,   _T("Compensator Pixel Spacing") },
{ 0x300A,0x00EA,DICOM_T_UNK,   _T("Compensator Position") },
{ 0x300A,0x00EB,DICOM_T_UNK,   _T("Compensator Transmission Data") },
{ 0x300A,0x00EC,DICOM_T_UNK,   _T("Compensator Thickness Data") },
{ 0x300A,0x00ED,DICOM_T_UNK,   _T("Number of Boli") },
{ 0x300A,0x00EE,DICOM_T_UNK,   _T("Compensator Type") },
{ 0x300A,0x00EF,DICOM_T_UNK,   _T("Compensator Tray ID") },
{ 0x300A,0x00F0,DICOM_T_UNK,   _T("Number of Blocks") },
{ 0x300A,0x00F2,DICOM_T_UNK,   _T("Total Block Tray Factor") },
{ 0x300A,0x00F3,DICOM_T_UNK,   _T("Total Block Tray Water-Equivalent Thickness") },
{ 0x300A,0x00F4,DICOM_T_UNK,   _T("Block Sequence") },
{ 0x300A,0x00F5,DICOM_T_UNK,   _T("Block Tray ID") },
{ 0x300A,0x00F6,DICOM_T_UNK,   _T("Source to Block Tray Distance") },
{ 0x300A,0x00F7,DICOM_T_UNK,   _T("Isocenter to Block Tray Distance") },
{ 0x300A,0x00F8,DICOM_T_UNK,   _T("Block Type") },
{ 0x300A,0x00F9,DICOM_T_UNK,   _T("Accessory Code") },
{ 0x300A,0x00FA,DICOM_T_UNK,   _T("Block Divergence") },
{ 0x300A,0x00FB,DICOM_T_UNK,   _T("Block Mounting Position") },
{ 0x300A,0x00FC,DICOM_T_UNK,   _T("Block Number") },
{ 0x300A,0x00FE,DICOM_T_UNK,   _T("Block Name") },
{ 0x300A,0x0100,DICOM_T_UNK,   _T("Block Thickness") },
{ 0x300A,0x0102,DICOM_T_UNK,   _T("Block Transmission") },
{ 0x300A,0x0104,DICOM_T_UNK,   _T("Block Number of Points") },
{ 0x300A,0x0106,DICOM_T_UNK,   _T("Block Data") },
{ 0x300A,0x0107,DICOM_T_UNK,   _T("Applicator Sequence") },
{ 0x300A,0x0108,DICOM_T_UNK,   _T("Applicator ID") },
{ 0x300A,0x0109,DICOM_T_UNK,   _T("Applicator Type") },
{ 0x300A,0x010A,DICOM_T_UNK,   _T("Applicator Description") },
{ 0x300A,0x010C,DICOM_T_UNK,   _T("Cumulative Dose Reference Coefficient") },
{ 0x300A,0x010E,DICOM_T_UNK,   _T("Final Cumulative Meterset Weight") },
{ 0x300A,0x0110,DICOM_T_UNK,   _T("Number of Control Points") },
{ 0x300A,0x0111,DICOM_T_UNK,   _T("Control Point Sequence") },
{ 0x300A,0x0112,DICOM_T_UNK,   _T("Control Point Index") },
{ 0x300A,0x0114,DICOM_T_UNK,   _T("Nominal Beam Energy") },
{ 0x300A,0x0115,DICOM_T_UNK,   _T("Dose Rate Set") },
{ 0x300A,0x0116,DICOM_T_UNK,   _T("Wedge Position Sequence") },
{ 0x300A,0x0118,DICOM_T_UNK,   _T("Wedge Position") },
{ 0x300A,0x011A,DICOM_T_UNK,   _T("Beam Limiting Device Position Sequence") },
{ 0x300A,0x011C,DICOM_T_UNK,   _T("Leaf/Jaw Positions") },
{ 0x300A,0x011E,DICOM_T_UNK,   _T("Gantry Angle") },
{ 0x300A,0x011F,DICOM_T_UNK,   _T("Gantry Rotation Direction") },
{ 0x300A,0x0120,DICOM_T_UNK,   _T("Beam Limiting Device Angle") },
{ 0x300A,0x0121,DICOM_T_UNK,   _T("Beam Limiting Device Rotation Direction") },
{ 0x300A,0x0122,DICOM_T_UNK,   _T("Patient Support Angle") },
{ 0x300A,0x0123,DICOM_T_UNK,   _T("Patient Support Rotation Direction") },
{ 0x300A,0x0124,DICOM_T_UNK,   _T("Table Top Eccentric Axis Distance") },
{ 0x300A,0x0125,DICOM_T_UNK,   _T("Table Top Eccentric Angle") },
{ 0x300A,0x0126,DICOM_T_UNK,   _T("Table Top Eccentric Rotation Direction") },
{ 0x300A,0x0128,DICOM_T_UNK,   _T("Table Top Vertical Position") },
{ 0x300A,0x0129,DICOM_T_UNK,   _T("Table Top Longitudinal Position") },
{ 0x300A,0x012A,DICOM_T_UNK,   _T("Table Top Lateral Position") },
{ 0x300A,0x012C,DICOM_T_UNK,   _T("Isocenter Position") },
{ 0x300A,0x012E,DICOM_T_UNK,   _T("Surface Entry Point") },
{ 0x300A,0x0130,DICOM_T_UNK,   _T("Source to Surface Distance") },
{ 0x300A,0x0134,DICOM_T_UNK,   _T("Cumulative Meterset Weight") },
{ 0x300A,0x0140,DICOM_T_UNK,   _T("Table Top Pitch Angle") },
{ 0x300A,0x0142,DICOM_T_UNK,   _T("Table Top Pitch Rotation Direction") },
{ 0x300A,0x0144,DICOM_T_UNK,   _T("Table Top Roll Angle") },
{ 0x300A,0x0146,DICOM_T_UNK,   _T("Table Top Roll Rotation Direction") },
{ 0x300A,0x0148,DICOM_T_UNK,   _T("Head Fixation Angle") },
{ 0x300A,0x014A,DICOM_T_UNK,   _T("Gantry Pitch Angle") },
{ 0x300A,0x014C,DICOM_T_UNK,   _T("Gantry Pitch Rotation Direction") },
{ 0x300A,0x014E,DICOM_T_UNK,   _T("Gantry Pitch Angle Tolerance") },
{ 0x300A,0x0180,DICOM_T_UNK,   _T("Patient Setup Sequence") },
{ 0x300A,0x0182,DICOM_T_UNK,   _T("Patient Setup Number") },
{ 0x300A,0x0183,DICOM_T_UNK,   _T("Patient Setup Label") },
{ 0x300A,0x0184,DICOM_T_UNK,   _T("Patient Additional Position") },
{ 0x300A,0x0190,DICOM_T_UNK,   _T("Fixation Device Sequence") },
{ 0x300A,0x0192,DICOM_T_UNK,   _T("Fixation Device Type") },
{ 0x300A,0x0194,DICOM_T_UNK,   _T("Fixation Device Label") },
{ 0x300A,0x0196,DICOM_T_UNK,   _T("Fixation Device Description") },
{ 0x300A,0x0198,DICOM_T_UNK,   _T("Fixation Device Position") },
{ 0x300A,0x0199,DICOM_T_UNK,   _T("Fixation Device Pitch Angle") },
{ 0x300A,0x019A,DICOM_T_UNK,   _T("Fixation Device Roll Angle") },
{ 0x300A,0x01A0,DICOM_T_UNK,   _T("Shielding Device Sequence") },
{ 0x300A,0x01A2,DICOM_T_UNK,   _T("Shielding Device Type") },
{ 0x300A,0x01A4,DICOM_T_UNK,   _T("Shielding Device Label") },
{ 0x300A,0x01A6,DICOM_T_UNK,   _T("Shielding Device Description") },
{ 0x300A,0x01A8,DICOM_T_UNK,   _T("Shielding Device Position") },
{ 0x300A,0x01B0,DICOM_T_UNK,   _T("Setup Technique") },
{ 0x300A,0x01B2,DICOM_T_UNK,   _T("Setup Technique Description") },
{ 0x300A,0x01B4,DICOM_T_UNK,   _T("Setup Device Sequence") },
{ 0x300A,0x01B6,DICOM_T_UNK,   _T("Setup Device Type") },
{ 0x300A,0x01B8,DICOM_T_UNK,   _T("Setup Device Label") },
{ 0x300A,0x01BA,DICOM_T_UNK,   _T("Setup Device Description") },
{ 0x300A,0x01BC,DICOM_T_UNK,   _T("Setup Device Parameter") },
{ 0x300A,0x01D0,DICOM_T_UNK,   _T("Setup Reference Description") },
{ 0x300A,0x01D2,DICOM_T_UNK,   _T("Table Top Vertical Setup Displacement") },
{ 0x300A,0x01D4,DICOM_T_UNK,   _T("Table Top Longitudinal Setup Displacement") },
{ 0x300A,0x01D6,DICOM_T_UNK,   _T("Table Top Lateral Setup Displacement") },
{ 0x300A,0x0200,DICOM_T_UNK,   _T("Brachy Treatment Technique") },
{ 0x300A,0x0202,DICOM_T_UNK,   _T("Brachy Treatment Type") },
{ 0x300A,0x0206,DICOM_T_UNK,   _T("Treatment Machine Sequence") },
{ 0x300A,0x0210,DICOM_T_UNK,   _T("Source Sequence") },
{ 0x300A,0x0212,DICOM_T_UNK,   _T("Source Number") },
{ 0x300A,0x0214,DICOM_T_UNK,   _T("Source Type") },
{ 0x300A,0x0216,DICOM_T_UNK,   _T("Source Manufacturer") },
{ 0x300A,0x0218,DICOM_T_UNK,   _T("Active Source Diameter") },
{ 0x300A,0x021A,DICOM_T_UNK,   _T("Active Source Length") },
{ 0x300A,0x021B,DICOM_T_UNK,   _T("Source Model ID") },
{ 0x300A,0x021C,DICOM_T_UNK,   _T("Source Description") },
{ 0x300A,0x0222,DICOM_T_UNK,   _T("Source Encapsulation Nominal Thickness") },
{ 0x300A,0x0224,DICOM_T_UNK,   _T("Source Encapsulation Nominal Transmission") },
{ 0x300A,0x0226,DICOM_T_UNK,   _T("Source Isotope Name") },
{ 0x300A,0x0228,DICOM_T_UNK,   _T("Source Isotope Half Life") },
{ 0x300A,0x0229,DICOM_T_UNK,   _T("Source Strength Units") },
{ 0x300A,0x022A,DICOM_T_UNK,   _T("Reference Air Kerma Rate") },
{ 0x300A,0x022B,DICOM_T_UNK,   _T("Source Strength") },
{ 0x300A,0x022C,DICOM_T_UNK,   _T("Source Strength Reference Date") },
{ 0x300A,0x022E,DICOM_T_UNK,   _T("Source Strength Reference Time") },
{ 0x300A,0x0230,DICOM_T_UNK,   _T("Application Setup Sequence") },
{ 0x300A,0x0232,DICOM_T_UNK,   _T("Application Setup Type") },
{ 0x300A,0x0234,DICOM_T_UNK,   _T("Application Setup Number") },
{ 0x300A,0x0236,DICOM_T_UNK,   _T("Application Setup Name") },
{ 0x300A,0x0238,DICOM_T_UNK,   _T("Application Setup Manufacturer") },
{ 0x300A,0x0240,DICOM_T_UNK,   _T("Template Number") },
{ 0x300A,0x0242,DICOM_T_UNK,   _T("Template Type") },
{ 0x300A,0x0244,DICOM_T_UNK,   _T("Template Name") },
{ 0x300A,0x0250,DICOM_T_UNK,   _T("Total Reference Air Kerma") },
{ 0x300A,0x0260,DICOM_T_UNK,   _T("Brachy Accessory Device Sequence") },
{ 0x300A,0x0262,DICOM_T_UNK,   _T("Brachy Accessory Device Number") },
{ 0x300A,0x0263,DICOM_T_UNK,   _T("Brachy Accessory Device ID") },
{ 0x300A,0x0264,DICOM_T_UNK,   _T("Brachy Accessory Device Type") },
{ 0x300A,0x0266,DICOM_T_UNK,   _T("Brachy Accessory Device Name") },
{ 0x300A,0x026A,DICOM_T_UNK,   _T("Brachy Accessory Device Nominal Thickness") },
{ 0x300A,0x026C,DICOM_T_UNK,   _T("Brachy Accessory Device Nominal Transmission") },
{ 0x300A,0x0280,DICOM_T_UNK,   _T("Channel Sequence") },
{ 0x300A,0x0282,DICOM_T_UNK,   _T("Channel Number") },
{ 0x300A,0x0284,DICOM_T_UNK,   _T("Channel Length") },
{ 0x300A,0x0286,DICOM_T_UNK,   _T("Channel Total Time") },
{ 0x300A,0x0288,DICOM_T_UNK,   _T("Source Movement Type") },
{ 0x300A,0x028A,DICOM_T_UNK,   _T("Number of Pulses") },
{ 0x300A,0x028C,DICOM_T_UNK,   _T("Pulse Repetition Interval") },
{ 0x300A,0x0290,DICOM_T_UNK,   _T("Source Applicator Number") },
{ 0x300A,0x0291,DICOM_T_UNK,   _T("Source Applicator ID") },
{ 0x300A,0x0292,DICOM_T_UNK,   _T("Source Applicator Type") },
{ 0x300A,0x0294,DICOM_T_UNK,   _T("Source Applicator Name") },
{ 0x300A,0x0296,DICOM_T_UNK,   _T("Source Applicator Length") },
{ 0x300A,0x0298,DICOM_T_UNK,   _T("Source Applicator Manufacturer") },
{ 0x300A,0x029C,DICOM_T_UNK,   _T("Source Applicator Wall Nominal Thickness") },
{ 0x300A,0x029E,DICOM_T_UNK,   _T("Source Applicator Wall Nominal Transmission") },
{ 0x300A,0x02A0,DICOM_T_UNK,   _T("Source Applicator Step Size") },
{ 0x300A,0x02A2,DICOM_T_UNK,   _T("Transfer Tube Number") },
{ 0x300A,0x02A4,DICOM_T_UNK,   _T("Transfer Tube Length") },
{ 0x300A,0x02B0,DICOM_T_UNK,   _T("Channel Shield Sequence") },
{ 0x300A,0x02B2,DICOM_T_UNK,   _T("Channel Shield Number") },
{ 0x300A,0x02B3,DICOM_T_UNK,   _T("Channel Shield ID") },
{ 0x300A,0x02B4,DICOM_T_UNK,   _T("Channel Shield Name") },
{ 0x300A,0x02B8,DICOM_T_UNK,   _T("Channel Shield Nominal Thickness") },
{ 0x300A,0x02BA,DICOM_T_UNK,   _T("Channel Shield Nominal Transmission") },
{ 0x300A,0x02C8,DICOM_T_UNK,   _T("Final Cumulative Time Weight") },
{ 0x300A,0x02D0,DICOM_T_UNK,   _T("Brachy Control Point Sequence") },
{ 0x300A,0x02D2,DICOM_T_UNK,   _T("Control Point Relative Position") },
{ 0x300A,0x02D4,DICOM_T_UNK,   _T("Control Point 3D Position") },
{ 0x300A,0x02D6,DICOM_T_UNK,   _T("Cumulative Time Weight") },
{ 0x300A,0x02E0,DICOM_T_UNK,   _T("Compensator Divergence") },
{ 0x300A,0x02E1,DICOM_T_UNK,   _T("Compensator Mounting Position") },
{ 0x300A,0x02E2,DICOM_T_UNK,   _T("Source to Compensator Distance") },
{ 0x300A,0x02E3,DICOM_T_UNK,   _T("Total Compensator Tray Water-Equivalent Thickness") },
{ 0x300A,0x02E4,DICOM_T_UNK,   _T("Isocenter to Compensator Tray Distance") },
{ 0x300A,0x02E5,DICOM_T_UNK,   _T("Compensator Column Offset") },
{ 0x300A,0x02E6,DICOM_T_UNK,   _T("Isocenter to Compensator Distances") },
{ 0x300A,0x02E7,DICOM_T_UNK,   _T("Compensator Relative Stopping Power Ratio") },
{ 0x300A,0x02E8,DICOM_T_UNK,   _T("Compensator Milling Tool Diameter") },
{ 0x300A,0x02EA,DICOM_T_UNK,   _T("Ion Range Compensator Sequence") },
{ 0x300A,0x02EB,DICOM_T_UNK,   _T("Compensator Description") },
{ 0x300A,0x0302,DICOM_T_UNK,   _T("Radiation Mass Number") },
{ 0x300A,0x0304,DICOM_T_UNK,   _T("Radiation Atomic Number") },
{ 0x300A,0x0306,DICOM_T_UNK,   _T("Radiation Charge State") },
{ 0x300A,0x0308,DICOM_T_UNK,   _T("Scan Mode") },
{ 0x300A,0x030A,DICOM_T_UNK,   _T("Virtual Source-Axis Distances") },
{ 0x300A,0x030C,DICOM_T_UNK,   _T("Snout Sequence") },
{ 0x300A,0x030D,DICOM_T_UNK,   _T("Snout Position") },
{ 0x300A,0x030F,DICOM_T_UNK,   _T("Snout ID") },
{ 0x300A,0x0312,DICOM_T_UNK,   _T("Number of Range Shifters") },
{ 0x300A,0x0314,DICOM_T_UNK,   _T("Range Shifter Sequence") },
{ 0x300A,0x0316,DICOM_T_UNK,   _T("Range Shifter Number") },
{ 0x300A,0x0318,DICOM_T_UNK,   _T("Range Shifter ID") },
{ 0x300A,0x0320,DICOM_T_UNK,   _T("Range Shifter Type") },
{ 0x300A,0x0322,DICOM_T_UNK,   _T("Range Shifter Description") },
{ 0x300A,0x0330,DICOM_T_UNK,   _T("Number of Lateral Spreading Devices") },
{ 0x300A,0x0332,DICOM_T_UNK,   _T("Lateral Spreading Device Sequence") },
{ 0x300A,0x0334,DICOM_T_UNK,   _T("Lateral Spreading Device Number") },
{ 0x300A,0x0336,DICOM_T_UNK,   _T("Lateral Spreading Device ID") },
{ 0x300A,0x0338,DICOM_T_UNK,   _T("Lateral Spreading Device Type") },
{ 0x300A,0x033A,DICOM_T_UNK,   _T("Lateral Spreading Device Description") },
{ 0x300A,0x033C,DICOM_T_UNK,   _T("Lateral Spreading Device Water Equivalent Thickness") },
{ 0x300A,0x0340,DICOM_T_UNK,   _T("Number of Range Modulators") },
{ 0x300A,0x0342,DICOM_T_UNK,   _T("Range Modulator Sequence") },
{ 0x300A,0x0344,DICOM_T_UNK,   _T("Range Modulator Number") },
{ 0x300A,0x0346,DICOM_T_UNK,   _T("Range Modulator ID") },
{ 0x300A,0x0348,DICOM_T_UNK,   _T("Range Modulator Type") },
{ 0x300A,0x034A,DICOM_T_UNK,   _T("Range Modulator Description") },
{ 0x300A,0x034C,DICOM_T_UNK,   _T("Beam Current Modulation ID") },
{ 0x300A,0x0350,DICOM_T_UNK,   _T("Patient Support Type") },
{ 0x300A,0x0352,DICOM_T_UNK,   _T("Patient Support ID") },
{ 0x300A,0x0354,DICOM_T_UNK,   _T("Patient Support Accessory Code") },
{ 0x300A,0x0356,DICOM_T_UNK,   _T("Fixation Light Azimuthal Angle") },
{ 0x300A,0x0358,DICOM_T_UNK,   _T("Fixation Light Polar Angle") },
{ 0x300A,0x035A,DICOM_T_UNK,   _T("Meterset Rate") },
{ 0x300A,0x0360,DICOM_T_UNK,   _T("Range Shifter Settings Sequence") },
{ 0x300A,0x0362,DICOM_T_UNK,   _T("Range Shifter Setting") },
{ 0x300A,0x0364,DICOM_T_UNK,   _T("Isocenter to Range Shifter Distance") },
{ 0x300A,0x0366,DICOM_T_UNK,   _T("Range Shifter Water Equivalent Thickness") },
{ 0x300A,0x0370,DICOM_T_UNK,   _T("Lateral Spreading Device Settings Sequence") },
{ 0x300A,0x0372,DICOM_T_UNK,   _T("Lateral Spreading Device Setting") },
{ 0x300A,0x0374,DICOM_T_UNK,   _T("Isocenter to Lateral Spreading Device Distance") },
{ 0x300A,0x0380,DICOM_T_UNK,   _T("Range Modulator Settings Sequence") },
{ 0x300A,0x0382,DICOM_T_UNK,   _T("Range Modulator Gating Start Value") },
{ 0x300A,0x0384,DICOM_T_UNK,   _T("Range Modulator Gating Stop Value") },
{ 0x300A,0x0386,DICOM_T_UNK,   _T("Range Modulator Gating Start Water Equivalent Thickness") },
{ 0x300A,0x0388,DICOM_T_UNK,   _T("Range Modulator Gating Stop Water Equivalent Thickness") },
{ 0x300A,0x038A,DICOM_T_UNK,   _T("Isocenter to Range Modulator Distance") },
{ 0x300A,0x0390,DICOM_T_UNK,   _T("Scan Spot Tune ID") },
{ 0x300A,0x0392,DICOM_T_UNK,   _T("Number of Scan Spot Positions") },
{ 0x300A,0x0394,DICOM_T_UNK,   _T("Scan Spot Position Map") },
{ 0x300A,0x0396,DICOM_T_UNK,   _T("Scan Spot Meterset Weights") },
{ 0x300A,0x0398,DICOM_T_UNK,   _T("Scanning Spot Size") },
{ 0x300A,0x039A,DICOM_T_UNK,   _T("Number of Paintings") },
{ 0x300A,0x03A0,DICOM_T_UNK,   _T("Ion Tolerance Table Sequence") },
{ 0x300A,0x03A2,DICOM_T_UNK,   _T("Ion Beam Sequence") },
{ 0x300A,0x03A4,DICOM_T_UNK,   _T("Ion Beam Limiting Device Sequence") },
{ 0x300A,0x03A6,DICOM_T_UNK,   _T("Ion Block Sequence") },
{ 0x300A,0x03A8,DICOM_T_UNK,   _T("Ion Control Point Sequence") },
{ 0x300A,0x03AA,DICOM_T_UNK,   _T("Ion Wedge Sequence") },
{ 0x300A,0x03AC,DICOM_T_UNK,   _T("Ion Wedge Position Sequence") },
{ 0x300A,0x0401,DICOM_T_UNK,   _T("Referenced Setup Image Sequence") },
{ 0x300A,0x0402,DICOM_T_UNK,   _T("Setup Image Comment") },
{ 0x300A,0x0410,DICOM_T_UNK,   _T("Motion Synchronization Sequence") },
{ 0x300A,0x0412,DICOM_T_UNK,   _T("Control Point Orientation") },
{ 0x300A,0x0420,DICOM_T_UNK,   _T("General Accessory Sequence") },
{ 0x300A,0x0421,DICOM_T_UNK,   _T("General Accessory ID") },
{ 0x300A,0x0422,DICOM_T_UNK,   _T("General Accessory Description") },
{ 0x300A,0x0423,DICOM_T_UNK,   _T("General Accessory Type") },
{ 0x300A,0x0424,DICOM_T_UNK,   _T("General Accessory Number") },
{ 0x300A,0x0425,DICOM_T_UNK,   _T("Source to General Accessory Distance") },
{ 0x300A,0x0431,DICOM_T_UNK,   _T("Applicator Geometry Sequence") },
{ 0x300A,0x0432,DICOM_T_UNK,   _T("Applicator Aperture Shape") },
{ 0x300A,0x0433,DICOM_T_UNK,   _T("Applicator Opening") },
{ 0x300A,0x0434,DICOM_T_UNK,   _T("Applicator Opening X") },
{ 0x300A,0x0435,DICOM_T_UNK,   _T("Applicator Opening Y") },
{ 0x300A,0x0436,DICOM_T_UNK,   _T("Source to Applicator Mounting Position Distance") },
{ 0x300C,0x0002,DICOM_T_UNK,   _T("Referenced RT Plan Sequence") },
{ 0x300C,0x0004,DICOM_T_UNK,   _T("Referenced Beam Sequence") },
{ 0x300C,0x0006,DICOM_T_UNK,   _T("Referenced Beam Number") },
{ 0x300C,0x0007,DICOM_T_UNK,   _T("Referenced Reference Image Number") },
{ 0x300C,0x0008,DICOM_T_UNK,   _T("Start Cumulative Meterset Weight") },
{ 0x300C,0x0009,DICOM_T_UNK,   _T("End Cumulative Meterset Weight") },
{ 0x300C,0x000A,DICOM_T_UNK,   _T("Referenced Brachy Application Setup Sequence") },
{ 0x300C,0x000C,DICOM_T_UNK,   _T("Referenced Brachy Application Setup Number") },
{ 0x300C,0x000E,DICOM_T_UNK,   _T("Referenced Source Number") },
{ 0x300C,0x0020,DICOM_T_UNK,   _T("Referenced Fraction Group Sequence") },
{ 0x300C,0x0022,DICOM_T_UNK,   _T("Referenced Fraction Group Number") },
{ 0x300C,0x0040,DICOM_T_UNK,   _T("Referenced Verification Image Sequence") },
{ 0x300C,0x0042,DICOM_T_UNK,   _T("Referenced Reference Image Sequence") },
{ 0x300C,0x0050,DICOM_T_UNK,   _T("Referenced Dose Reference Sequence") },
{ 0x300C,0x0051,DICOM_T_UNK,   _T("Referenced Dose Reference Number") },
{ 0x300C,0x0055,DICOM_T_UNK,   _T("Brachy Referenced Dose Reference Sequence") },
{ 0x300C,0x0060,DICOM_T_UNK,   _T("Referenced Structure Set Sequence") },
{ 0x300C,0x006A,DICOM_T_UNK,   _T("Referenced Patient Setup Number") },
{ 0x300C,0x0080,DICOM_T_UNK,   _T("Referenced Dose Sequence") },
{ 0x300C,0x00A0,DICOM_T_UNK,   _T("Referenced Tolerance Table Number") },
{ 0x300C,0x00B0,DICOM_T_UNK,   _T("Referenced Bolus Sequence") },
{ 0x300C,0x00C0,DICOM_T_UNK,   _T("Referenced Wedge Number") },
{ 0x300C,0x00D0,DICOM_T_UNK,   _T("Referenced Compensator Number") },
{ 0x300C,0x00E0,DICOM_T_UNK,   _T("Referenced Block Number") },
{ 0x300C,0x00F0,DICOM_T_UNK,   _T("Referenced Control Point Index") },
{ 0x300C,0x00F2,DICOM_T_UNK,   _T("Referenced Control Point Sequence") },
{ 0x300C,0x00F4,DICOM_T_UNK,   _T("Referenced Start Control Point Index") },
{ 0x300C,0x00F6,DICOM_T_UNK,   _T("Referenced Stop Control Point Index") },
{ 0x300C,0x0100,DICOM_T_UNK,   _T("Referenced Range Shifter Number") },
{ 0x300C,0x0102,DICOM_T_UNK,   _T("Referenced Lateral Spreading Device Number") },
{ 0x300C,0x0104,DICOM_T_UNK,   _T("Referenced Range Modulator Number") },
{ 0x300E,0x0002,DICOM_T_UNK,   _T("Approval Status") },
{ 0x300E,0x0004,DICOM_T_UNK,   _T("Review Date") },
{ 0x300E,0x0005,DICOM_T_UNK,   _T("Review Time") },
{ 0x300E,0x0008,DICOM_T_UNK,   _T("Reviewer Name") },
{ 0x4000,0x0010,DICOM_T_UNK,   _T("Arbitrary") },
{ 0x4000,0x4000,DICOM_T_UNK,   _T("Text Comments") },
{ 0x4008,0x0040,DICOM_T_UNK,   _T("Results ID") },
{ 0x4008,0x0042,DICOM_T_UNK,   _T("Results ID Issuer") },
{ 0x4008,0x0050,DICOM_T_UNK,   _T("Referenced Interpretation Sequence") },
{ 0x4008,0x00FF,DICOM_T_UNK,   _T("Report Production Status (Trial)") },
{ 0x4008,0x0100,DICOM_T_UNK,   _T("Interpretation Recorded Date") },
{ 0x4008,0x0101,DICOM_T_UNK,   _T("Interpretation Recorded Time") },
{ 0x4008,0x0102,DICOM_T_UNK,   _T("Interpretation Recorder") },
{ 0x4008,0x0103,DICOM_T_UNK,   _T("Reference to Recorded Sound") },
{ 0x4008,0x0108,DICOM_T_UNK,   _T("Interpretation Transcription Date") },
{ 0x4008,0x0109,DICOM_T_UNK,   _T("Interpretation Transcription Time") },
{ 0x4008,0x010A,DICOM_T_UNK,   _T("Interpretation Transcriber") },
{ 0x4008,0x010B,DICOM_T_UNK,   _T("Interpretation Text") },
{ 0x4008,0x010C,DICOM_T_UNK,   _T("Interpretation Author") },
{ 0x4008,0x0111,DICOM_T_UNK,   _T("Interpretation Approver Sequence") },
{ 0x4008,0x0112,DICOM_T_UNK,   _T("Interpretation Approval Date") },
{ 0x4008,0x0113,DICOM_T_UNK,   _T("Interpretation Approval Time") },
{ 0x4008,0x0114,DICOM_T_UNK,   _T("Physician Approving Interpretation") },
{ 0x4008,0x0115,DICOM_T_UNK,   _T("Interpretation Diagnosis Description") },
{ 0x4008,0x0117,DICOM_T_UNK,   _T("Interpretation Diagnosis Code Sequence") },
{ 0x4008,0x0118,DICOM_T_UNK,   _T("Results Distribution List Sequence") },
{ 0x4008,0x0119,DICOM_T_UNK,   _T("Distribution Name") },
{ 0x4008,0x011A,DICOM_T_UNK,   _T("Distribution Address") },
{ 0x4008,0x0200,DICOM_T_UNK,   _T("Interpretation ID") },
{ 0x4008,0x0202,DICOM_T_UNK,   _T("Interpretation ID Issuer") },
{ 0x4008,0x0210,DICOM_T_UNK,   _T("Interpretation Type ID") },
{ 0x4008,0x0212,DICOM_T_UNK,   _T("Interpretation Status ID") },
{ 0x4008,0x0300,DICOM_T_UNK,   _T("Impressions") },
{ 0x4008,0x4000,DICOM_T_UNK,   _T("Results Comments") },
{ 0x4010,0x0001,DICOM_T_UNK,   _T("Low Energy Detectors") },
{ 0x4010,0x0002,DICOM_T_UNK,   _T("High Energy Detectors") },
{ 0x4010,0x0004,DICOM_T_UNK,   _T("Detector Geometry Sequence") },
{ 0x4010,0x1001,DICOM_T_UNK,   _T("Threat ROI Voxel Sequence") },
{ 0x4010,0x1004,DICOM_T_UNK,   _T("Threat ROI Base") },
{ 0x4010,0x1005,DICOM_T_UNK,   _T("Threat ROI Extents") },
{ 0x4010,0x1006,DICOM_T_UNK,   _T("Threat ROI Bitmap") },
{ 0x4010,0x1007,DICOM_T_UNK,   _T("Route Segment ID") },
{ 0x4010,0x1008,DICOM_T_UNK,   _T("Gantry Type") },
{ 0x4010,0x1009,DICOM_T_UNK,   _T("OOI Owner Type") },
{ 0x4010,0x100A,DICOM_T_UNK,   _T("Route Segment Sequence") },
{ 0x4010,0x1010,DICOM_T_UNK,   _T("Potential Threat Object ID") },
{ 0x4010,0x1011,DICOM_T_UNK,   _T("Threat Sequence") },
{ 0x4010,0x1012,DICOM_T_UNK,   _T("Threat Category") },
{ 0x4010,0x1013,DICOM_T_UNK,   _T("Threat Category Description") },
{ 0x4010,0x1014,DICOM_T_UNK,   _T("ATD Ability Assessment") },
{ 0x4010,0x1015,DICOM_T_UNK,   _T("ATD Assessment Flag") },
{ 0x4010,0x1016,DICOM_T_UNK,   _T("ATD Assessment Probability") },
{ 0x4010,0x1017,DICOM_T_UNK,   _T("Mass") },
{ 0x4010,0x1018,DICOM_T_UNK,   _T("Density") },
{ 0x4010,0x1019,DICOM_T_UNK,   _T("Z Effective") },
{ 0x4010,0x101A,DICOM_T_UNK,   _T("Boarding Pass ID") },
{ 0x4010,0x101B,DICOM_T_UNK,   _T("Center of Mass") },
{ 0x4010,0x101C,DICOM_T_UNK,   _T("Center of PTO") },
{ 0x4010,0x101D,DICOM_T_UNK,   _T("Bounding Polygon") },
{ 0x4010,0x101E,DICOM_T_UNK,   _T("Route Segment Start Location ID") },
{ 0x4010,0x101F,DICOM_T_UNK,   _T("Route Segment End Location ID") },
{ 0x4010,0x1020,DICOM_T_UNK,   _T("Route Segment Location ID Type") },
{ 0x4010,0x1021,DICOM_T_UNK,   _T("Abort Reason") },
{ 0x4010,0x1023,DICOM_T_UNK,   _T("Volume of PTO") },
{ 0x4010,0x1024,DICOM_T_UNK,   _T("Abort Flag") },
{ 0x4010,0x1025,DICOM_T_UNK,   _T("Route Segment Start Time") },
{ 0x4010,0x1026,DICOM_T_UNK,   _T("Route Segment End Time") },
{ 0x4010,0x1027,DICOM_T_UNK,   _T("TDR Type") },
{ 0x4010,0x1028,DICOM_T_UNK,   _T("International Route Segment") },
{ 0x4010,0x1029,DICOM_T_UNK,   _T("Threat Detection Algorithm and Version") },
{ 0x4010,0x102A,DICOM_T_UNK,   _T("Assigned Location") },
{ 0x4010,0x102B,DICOM_T_UNK,   _T("Alarm Decision Time") },
{ 0x4010,0x1031,DICOM_T_UNK,   _T("Alarm Decision") },
{ 0x4010,0x1033,DICOM_T_UNK,   _T("Number of Total Objects") },
{ 0x4010,0x1034,DICOM_T_UNK,   _T("Number of Alarm Objects") },
{ 0x4010,0x1037,DICOM_T_UNK,   _T("PTO Representation Sequence") },
{ 0x4010,0x1038,DICOM_T_UNK,   _T("ATD Assessment Sequence") },
{ 0x4010,0x1039,DICOM_T_UNK,   _T("TIP Type") },
{ 0x4010,0x103A,DICOM_T_UNK,   _T("DICOS Version") },
{ 0x4010,0x1041,DICOM_T_UNK,   _T("OOI Owner Creation Time") },
{ 0x4010,0x1042,DICOM_T_UNK,   _T("OOI Type") },
{ 0x4010,0x1043,DICOM_T_UNK,   _T("OOI Size") },
{ 0x4010,0x1044,DICOM_T_UNK,   _T("Acquisition Status") },
{ 0x4010,0x1045,DICOM_T_UNK,   _T("Basis Materials Code Sequence") },
{ 0x4010,0x1046,DICOM_T_UNK,   _T("Phantom Type") },
{ 0x4010,0x1047,DICOM_T_UNK,   _T("OOI Owner Sequence") },
{ 0x4010,0x1048,DICOM_T_UNK,   _T("Scan Type") },
{ 0x4010,0x1051,DICOM_T_UNK,   _T("Itinerary ID") },
{ 0x4010,0x1052,DICOM_T_UNK,   _T("Itinerary ID Type") },
{ 0x4010,0x1053,DICOM_T_UNK,   _T("Itinerary ID Assigning Authority") },
{ 0x4010,0x1054,DICOM_T_UNK,   _T("Route ID") },
{ 0x4010,0x1055,DICOM_T_UNK,   _T("Route ID Assigning Authority") },
{ 0x4010,0x1056,DICOM_T_UNK,   _T("Inbound Arrival Type") },
{ 0x4010,0x1058,DICOM_T_UNK,   _T("Carrier ID") },
{ 0x4010,0x1059,DICOM_T_UNK,   _T("Carrier ID Assigning Authority") },
{ 0x4010,0x1060,DICOM_T_UNK,   _T("Source Orientation") },
{ 0x4010,0x1061,DICOM_T_UNK,   _T("Source Position") },
{ 0x4010,0x1062,DICOM_T_UNK,   _T("Belt Height") },
{ 0x4010,0x1064,DICOM_T_UNK,   _T("Algorithm Routing Code Sequence") },
{ 0x4010,0x1067,DICOM_T_UNK,   _T("Transport Classification") },
{ 0x4010,0x1068,DICOM_T_UNK,   _T("OOI Type Descriptor") },
{ 0x4010,0x1069,DICOM_T_UNK,   _T("Total Processing Time") },
{ 0x4010,0x106C,DICOM_T_UNK,   _T("Detector Calibration Data") },
{ 0x4010,0x106D,DICOM_T_UNK,   _T("Additional Screening Performed") },
{ 0x4010,0x106E,DICOM_T_UNK,   _T("Additional Inspection Selection Criteria") },
{ 0x4010,0x106F,DICOM_T_UNK,   _T("Additional Inspection Method Sequence") },
{ 0x4010,0x1070,DICOM_T_UNK,   _T("AIT Device Type") },
{ 0x4010,0x1071,DICOM_T_UNK,   _T("QR Measurements Sequence") },
{ 0x4010,0x1072,DICOM_T_UNK,   _T("Target Material Sequence") },
{ 0x4010,0x1073,DICOM_T_UNK,   _T("SNR Threshold") },
{ 0x4010,0x1075,DICOM_T_UNK,   _T("Image Scale Representation") },
{ 0x4010,0x1076,DICOM_T_UNK,   _T("Referenced PTO Sequence") },
{ 0x4010,0x1077,DICOM_T_UNK,   _T("Referenced TDR Instance Sequence") },
{ 0x4010,0x1078,DICOM_T_UNK,   _T("PTO Location Description") },
{ 0x4010,0x1079,DICOM_T_UNK,   _T("Anomaly Locator Indicator Sequence") },
{ 0x4010,0x107A,DICOM_T_UNK,   _T("Anomaly Locator Indicator") },
{ 0x4010,0x107B,DICOM_T_UNK,   _T("PTO Region Sequence") },
{ 0x4010,0x107C,DICOM_T_UNK,   _T("Inspection Selection Criteria") },
{ 0x4010,0x107D,DICOM_T_UNK,   _T("Secondary Inspection Method Sequence") },
{ 0x4010,0x107E,DICOM_T_UNK,   _T("PRCS to RCS Orientation") },
{ 0x4FFE,0x0001,DICOM_T_UNK,   _T("MAC Parameters Sequence") },
/*
{ 0x50xx,0x0005,DICOM_T_UNK,   _T("Curve Dimensions") },
{ 0x50xx,0x0010,DICOM_T_UNK,   _T("Number of Points") },
{ 0x50xx,0x0020,DICOM_T_UNK,   _T("Type of Data") },
{ 0x50xx,0x0022,DICOM_T_UNK,   _T("Curve Description") },
{ 0x50xx,0x0030,DICOM_T_UNK,   _T("Axis Units") },
{ 0x50xx,0x0040,DICOM_T_UNK,   _T("Axis Labels") },
{ 0x50xx,0x0103,DICOM_T_UNK,   _T("Data Value Representation") },
{ 0x50xx,0x0104,DICOM_T_UNK,   _T("Minimum Coordinate Value") },
{ 0x50xx,0x0105,DICOM_T_UNK,   _T("Maximum Coordinate Value") },
{ 0x50xx,0x0106,DICOM_T_UNK,   _T("Curve Range") },
{ 0x50xx,0x0110,DICOM_T_UNK,   _T("Curve Data Descriptor") },
{ 0x50xx,0x0112,DICOM_T_UNK,   _T("Coordinate Start Value") },
{ 0x50xx,0x0114,DICOM_T_UNK,   _T("Coordinate Step Value") },
{ 0x50xx,0x1001,DICOM_T_UNK,   _T("Curve Activation Layer") },
{ 0x50xx,0x2000,DICOM_T_UNK,   _T("Audio Type") },
{ 0x50xx,0x2002,DICOM_T_UNK,   _T("Audio Sample Format") },
{ 0x50xx,0x2004,DICOM_T_UNK,   _T("Number of Channels") },
{ 0x50xx,0x2006,DICOM_T_UNK,   _T("Number of Samples") },
{ 0x50xx,0x2008,DICOM_T_UNK,   _T("Sample Rate") },
{ 0x50xx,0x200A,DICOM_T_UNK,   _T("Total Time") },
{ 0x50xx,0x200C,DICOM_T_UNK,   _T("Audio Sample Data") },
{ 0x50xx,0x200E,DICOM_T_UNK,   _T("Audio Comments") },
{ 0x50xx,0x2500,DICOM_T_UNK,   _T("Curve Label") },
{ 0x50xx,0x2600,DICOM_T_UNK,   _T("Curve Referenced Overlay Sequence") },
{ 0x50xx,0x2610,DICOM_T_UNK,   _T("Curve Referenced Overlay Group") },
{ 0x50xx,0x3000,DICOM_T_UNK,   _T("Curve Data") },
*/
{ 0x5200,0x9229,DICOM_T_UNK,   _T("Shared Functional Groups Sequence") },
{ 0x5200,0x9230,DICOM_T_UNK,   _T("Per-frame Functional Groups Sequence") },
{ 0x5400,0x0100,DICOM_T_UNK,   _T("Waveform Sequence") },
{ 0x5400,0x0110,DICOM_T_UNK,   _T("Channel Minimum Value") },
{ 0x5400,0x0112,DICOM_T_UNK,   _T("Channel Maximum Value") },
{ 0x5400,0x1004,DICOM_T_UNK,   _T("Waveform Bits Allocated") },
{ 0x5400,0x1006,DICOM_T_UNK,   _T("Waveform Sample Interpretation") },
{ 0x5400,0x100A,DICOM_T_UNK,   _T("Waveform Padding Value") },
{ 0x5400,0x1010,DICOM_T_UNK,   _T("Waveform Data") },
{ 0x5600,0x0010,DICOM_T_UNK,   _T("First Order Phase Correction Angle") },
{ 0x5600,0x0020,DICOM_T_UNK,   _T("Spectroscopy Data") },
/*
{ 0x60xx,0x0010,DICOM_T_UNK,   _T("Overlay Rows") },
{ 0x60xx,0x0011,DICOM_T_UNK,   _T("Overlay Columns") },
{ 0x60xx,0x0012,DICOM_T_UNK,   _T("Overlay Planes") },
{ 0x60xx,0x0015,DICOM_T_UNK,   _T("Number of Frames in Overlay") },
{ 0x60xx,0x0022,DICOM_T_UNK,   _T("Overlay Description") },
{ 0x60xx,0x0040,DICOM_T_UNK,   _T("Overlay Type") },
{ 0x60xx,0x0045,DICOM_T_UNK,   _T("Overlay Subtype") },
{ 0x60xx,0x0050,DICOM_T_UNK,   _T("Overlay Origin") },
{ 0x60xx,0x0051,DICOM_T_UNK,   _T("Image Frame Origin") },
{ 0x60xx,0x0052,DICOM_T_UNK,   _T("Overlay Plane Origin") },
{ 0x60xx,0x0060,DICOM_T_UNK,   _T("Overlay Compression Code") },
{ 0x60xx,0x0061,DICOM_T_UNK,   _T("Overlay Compression Originator") },
{ 0x60xx,0x0062,DICOM_T_UNK,   _T("Overlay Compression Label") },
{ 0x60xx,0x0063,DICOM_T_UNK,   _T("Overlay Compression Description") },
{ 0x60xx,0x0066,DICOM_T_UNK,   _T("Overlay Compression Step Pointers") },
{ 0x60xx,0x0068,DICOM_T_UNK,   _T("Overlay Repeat Interval") },
{ 0x60xx,0x0069,DICOM_T_UNK,   _T("Overlay Bits Grouped") },
{ 0x60xx,0x0100,DICOM_T_UNK,   _T("Overlay Bits Allocated") },
{ 0x60xx,0x0102,DICOM_T_UNK,   _T("Overlay Bit Position") },
{ 0x60xx,0x0110,DICOM_T_UNK,   _T("Overlay Format") },
{ 0x60xx,0x0200,DICOM_T_UNK,   _T("Overlay Location") },
{ 0x60xx,0x0800,DICOM_T_UNK,   _T("Overlay Code Label") },
{ 0x60xx,0x0802,DICOM_T_UNK,   _T("Overlay Number of Tables") },
{ 0x60xx,0x0803,DICOM_T_UNK,   _T("Overlay Code Table Location") },
{ 0x60xx,0x0804,DICOM_T_UNK,   _T("Overlay Bits For Code Word") },
{ 0x60xx,0x1001,DICOM_T_UNK,   _T("Overlay Activation Layer") },
{ 0x60xx,0x1100,DICOM_T_UNK,   _T("Overlay Descriptor - Gray") },
{ 0x60xx,0x1101,DICOM_T_UNK,   _T("Overlay Descriptor - Red") },
{ 0x60xx,0x1102,DICOM_T_UNK,   _T("Overlay Descriptor - Green") },
{ 0x60xx,0x1103,DICOM_T_UNK,   _T("Overlay Descriptor - Blue") },
{ 0x60xx,0x1200,DICOM_T_UNK,   _T("Overlays - Gray") },
{ 0x60xx,0x1201,DICOM_T_UNK,   _T("Overlays - Red") },
{ 0x60xx,0x1202,DICOM_T_UNK,   _T("Overlays - Green") },
{ 0x60xx,0x1203,DICOM_T_UNK,   _T("Overlays - Blue") },
{ 0x60xx,0x1301,DICOM_T_UNK,   _T("ROI Area") },
{ 0x60xx,0x1302,DICOM_T_UNK,   _T("ROI Mean") },
{ 0x60xx,0x1303,DICOM_T_UNK,   _T("ROI Standard Deviation") },
{ 0x60xx,0x1500,DICOM_T_UNK,   _T("Overlay Label") },
{ 0x60xx,0x3000,DICOM_T_UNK,   _T("Overlay Data") },
{ 0x60xx,0x4000,DICOM_T_UNK,   _T("Overlay Comments") },
*/

// Pixel data has special decoding. Sometimes see "undefined length"
// (4B length = 0xFFFFFFFF)
// Reference: Part 5, Section A.4
// Undefined length in Part 5, Section 7.1.1
{ 0x7FE0,0x0010,DICOM_T_UNK,   _T("Pixel Data") },

{ 0x7FE0,0x0020,DICOM_T_UNK,   _T("Coefficients SDVN") },
{ 0x7FE0,0x0030,DICOM_T_UNK,   _T("Coefficients SDHN") },
{ 0x7FE0,0x0040,DICOM_T_UNK,   _T("Coefficients SDDN") },
/*
{ 0x7Fxx,0x0010,DICOM_T_UNK,   _T("Variable Pixel Data") },
{ 0x7Fxx,0x0011,DICOM_T_UNK,   _T("Variable Next Data Group") },
{ 0x7Fxx,0x0020,DICOM_T_UNK,   _T("Variable Coefficients SDVN") },
{ 0x7Fxx,0x0030,DICOM_T_UNK,   _T("Variable Coefficients SDHN") },
{ 0x7Fxx,0x0040,DICOM_T_UNK,   _T("Variable Coefficients SDDN") },
*/
{ 0xFFFA,0xFFFA,DICOM_T_UNK,   _T("Digital Signatures Sequence") },
{ 0xFFFC,0xFFFC,DICOM_T_UNK,   _T("Data Set Trailing Padding") },

// For these 3 items, Part 6, Section 6 indicates:
//   The VR for these Data Elements do not exist. See PS 3.5 for explanation.
// Part 5, Section 7.5
{ 0xFFFE,0xE000,DICOM_T_UNK,   _T("Item") },
{ 0xFFFE,0xE00D,DICOM_T_UNK,   _T("Item Delimitation Item") },
{ 0xFFFE,0xE0DD,DICOM_T_UNK,   _T("Sequence Delimitation Item") },

};


struct tsDicomTagSpec asTagSpecial[] =
{
	// Backround details in:
	// - Part 5, Section 10
	// - Part 5, Section A.4.1
	// - Part 5, Section F.1

	// Part 6, Section A
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2"),			_T("Implicit VR Little Endian") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.1"),		_T("Explicit VR Little Endian") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.1.99"),		_T("Deflated Explicit VR Little Endian") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.2"),		_T("Explicit VR Big Endian") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.50"),		_T("JPEG Baseline (Process 1)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.51"),		_T("JPEG Extended (Process 2 & 4)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.52"),		_T("JPEG Extended (Process 3 & 5) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.53"),		_T("JPEG Spectral Selection, Non- Hierarchical (Process 6 & 8) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.54"),		_T("JPEG Spectral Selection, Non- Hierarchical (Process 7 & 9) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.55"),		_T("JPEG Full Progression, Non- Hierarchical (Process 10 & 12) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.56"),		_T("JPEG Full Progression, Non- Hierarchical (Process 11 & 13) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.57"),		_T("JPEG Lossless, Non-Hierarchical (Process 14)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.58"),		_T("JPEG Lossless, Non-Hierarchical (Process 15) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.59"),		_T("JPEG Extended, Hierarchical (Process 16 & 18) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.60"),		_T("JPEG Extended, Hierarchical (Process 17 & 19) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.61"),		_T("JPEG Spectral Selection, Hierarchical (Process 20 & 22) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.62"),		_T("JPEG Spectral Selection, Hierarchical (Process 21 & 23) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.63"),		_T("JPEG Full Progression, Hierarchical (Process 24 & 26) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.64"),		_T("JPEG Full Progression, Hierarchical (Process 25 & 27) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.65"),		_T("JPEG Lossless, Hierarchical (Process 28) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.66"),		_T("JPEG Lossless, Hierarchical (Process 29) (Retired)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.70"),		_T("JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1])") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.80"),		_T("JPEG-LS Lossless Image Compression") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.81"),		_T("JPEG-LS Lossy (Near-Lossless) Image Compression") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.90"),		_T("JPEG 2000 Image Compression (Lossless Only)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.91"),		_T("JPEG 2000 Image Compression") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.92"),		_T("JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.93"),		_T("JPEG 2000 Part 2 Multi-component Image Compression") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.94"),		_T("JPIP Referenced") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.95"),		_T("JPIP Referenced Deflate") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.100"),	_T("MPEG2 Main Profile @ Main Level") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.101"),	_T("MPEG2 Main Profile @ High Level") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.102"),	_T("MPEG-4 AVC/H.264 High Profile / Level 4.1") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.4.103"),	_T("MPEG-4 AVC/H.264 BDcompatible High Profile / Level 4.1") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.5"),		_T("RLE Lossless") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.6.1"),		_T("RFC 2557 MIME encapsulation") },
	{ 0x0002, 0x0010, _T("1.2.840.10008.1.2.6.2"),		_T("XML Encoding") },

	{ 0x0000, 0x0000, _T(""),							_T("END OF LIST") },

};

