﻿/*!@license
* Infragistics.Web.ClientUI Scroll <build_number>
*
* Copyright (c) 2011-<year> Infragistics Inc.
*
* http://www.infragistics.com/
*
* Depends on:
* jquery.js
* jquery.ui-1.9.0.js
* jquery.ui.widget.js
* infragistics.util.js
* infragistics.util.jquery.js
* infragistics.ui.widget.js
*/

/*global MSGesture*/
"use strict";
(function (factory) {
	if (typeof define === "function" && define.amd) {

		// AMD. Register as an anonymous module.
		define( [
			"./infragistics.ui.widget"
		], factory );
	} else {

		// Browser globals
		return factory(jQuery);
	}
}
(function ($) {
	/* S.K. Fix for bug 212350: For IE11 and up msSetPointerCapture and msReleasePointerCapture are depricated. setPointerCapture and releasePointerCapture are supported from IE10 and up. */
	var setPointerCaptureFName = typeof Element.prototype.msSetPointerCapture === "function" ?
								"msSetPointerCapture" :
								"setPointerCapture",
	releasePointerCaptureFName = typeof Element.prototype.msReleasePointerCapture === "function" ?
									"msReleasePointerCapture" :
									"releasePointerCapture";

	$.widget("ui.igScroll", $.ui.igWidget, {
		options: {
			/* type="bool" Sets or gets if the scrollbars should be always visible (on all environments). Otherwise it will be the default behavior. Note: this option is only for the custom scrollbars set through the scrollbarType option.
			```
				//Initialize
				$(".selector").igScroll({
					alwaysVisible: true
				});

				//Get
					var alwaysVisible = $(".selector").igScroll("option", "alwaysVisible");

				//Set
				$(".selector").igScroll("option", "alwaysVisible", true);
			```
			*/
			alwaysVisible: false,
			/* type="custom|native|none" Sets or gets what type of scrollbars should be using the igScroll (on all environments).
			```
				//Initialize
				$(".selector").igScroll({
					scrollbarType: "native"
				});

				//Get
					var scrollbarType = $(".selector").igScroll("option", "scrollbarType");

				//Set
				$(".selector").igScroll("option", "scrollbarType", "native");
			```
				custom type="string" Custom scrollbars with custom ui and events.
				native type="string" Native scrollbars
				none type="string" No scrollbars should be visible */
			scrollbarType: "custom",
			/* type="number|string" Sets or gets the minimum size of the thumb drag in pixels. For the vertical thumb it means its minimum height, for the horizontal thumb it means its minimum width. This affects only the custom scrollblar when scrollbarType is set to "custom".
			```
				//Initialize
				$(".selector").igScroll({
					minThumbSize: 20
				});

				//Get
					var minThumbSize = $(".selector").igScroll("option", "minThumbSize");

				//Set
				$(".selector").igScroll("option", "minThumbSize", 20);
			```
			*/
			minThumbSize: 15,
			/* type="bool" Sets or gets if igScroll can modify the DOM when it is initialized on certain element so that the content can be scrollable.
			```
				//Initialize
				$(".selector").igScroll({
					modifyDOM: false
				});

				//Get
				var modifyDOM = $(".selector").igScroll("option", "modifyDOM");
			```
			*/
			modifyDOM: true,
			/* type="number" Sets custom value for how high is actually the content. Useful when wanting to scroll and update the shown content manually.
			```
				//Initialize
				$(".selector").igScroll({
					scrollHeight: 1000
				});

				//Get
				var scrollHeight = $(".selector").igScroll("option", "scrollHeight");

				//Set
				$(".selector").igScroll("option", "scrollHeight", 1000);
			```
			*/
			scrollHeight: null,
			/* type="number" Sets custom value for what width is actually the content. Useful when wanting to scroll and update the shown content manually.
			```
				//Initialize
				$(".selector").igScroll({
					scrollWidth: 1200
				});

				//Get
				var scrollWidth = $(".selector").igScroll("option", "scrollWidth");

				//Set
				$(".selector").igScroll("option", "scrollWidth", 1200);
			```
			*/
			scrollWidth: null,
			/* type="number" Sets gets current vertical position of the content.
			```
				//Initialize
				$(".selector").igScroll({
					scrollTop: 200
				});

				//Get
				var scrollTop = $(".selector").igScroll("option", "scrollTop");

				//Set
				$(".selector").igScroll("option", "scrollTop", 200);
			```
			*/
			scrollTop: 0,
			/* type="number" Sets gets current horizontal position of the content.
			```
				//Initialize
				$(".selector").igScroll({
					scrollLeft: 200
				});

				//Get
				var scrollLeft = $(".selector").igScroll("option", "scrollLeft");

				//Set
				$(".selector").igScroll("option", "scrollLeft", 200);
			```
			*/
			scrollLeft: 0,
			/* type="number" Sets gets the step of the default scrolling behavior when using mouse wheel
			```
				//Initialize
				$(".selector").igScroll({
					wheelStep: 200
				});

				//Get
				var wheelStep = $(".selector").igScroll("option", "wheelStep");

				//Set
				$(".selector").igScroll("option", "wheelStep", 200);
			```
			*/
			wheelStep: 50,
			/* type="number" Sets gets the step of the default scrolling behavior when using any of the custom scrollbar arrows
			```
				//Initialize
				$(".selector").igScroll({
					smallIncrementStep: 25
				});

				//Get
				var smallIncrementStep = $(".selector").igScroll("option", "smallIncrementStep");

				//Set
				$(".selector").igScroll("option", "smallIncrementStep", 25);
			```
			*/
			smallIncrementStep: 40,
			/* type="number" Sets gets the step of the default scrolling behavior when using any of the custom scrollbar track areas.
			```
				//Initialize
				$(".selector").igScroll({
					bigIncrementStep: 200
				});

				//Get
				var bigIncrementStep = $(".selector").igScroll("option", "bigIncrementStep");

				//Set
				$(".selector").igScroll("option", "bigIncrementStep", 200);
			```
			*/
			bigIncrementStep: null,
			/* type="bool" Sets gets if smoother scrolling with small intertia should be used when using mouse wheel
			```
				//Initialize
				$(".selector").igScroll({
					smoothing: true
				});

				//Get
				var smoothing = $(".selector").igScroll("option", "smoothing");

				//Set
				$(".selector").igScroll("option", "smoothing", true);
			```
			*/
			smoothing: false,
			/* type="number" Sets or gets the modifier for how many pixels will be scrolled when using the mouse wheel once. This is used only for the smooth scrolling behavior.
			```
				//Initialize
				$(".selector").igScroll({
					smoothingStep: 2
				});

				//Get
				var smoothingStep = $(".selector").igScroll("option", "smoothingStep");

				//Set
				$(".selector").igScroll("option", "smoothingStep", 2);
			```
			*/
			smoothingStep: 1,
			/* type="number" Sets or gets the modifier for how long the scroll ‘animation’ lasts when using the mouse wheel once. This is used only for the smooth scrolling behavior.
			```
				//Initialize
				$(".selector").igScroll({
					smoothingDuration: 2
				});

				//Get
				var smoothingDuration = $(".selector").igScroll("option", "smoothingDuration");

				//Set
				$(".selector").igScroll("option", "smoothingDuration", 2);
			```
			*/
			smoothingDuration: 1,
			/* type="number" Sets gets the modifier for how much the inertia scrolls on mobile devices
			```
				//Initialize
				$(".selector").igScroll({
					inertiaStep: 2
				});

				//Get
				var inertiaDuration = $(".selector").igScroll("option", "inertiaStep");

				//Set
				$(".selector").igScroll("option", "inertiaStep", 2);
			```
			*/
			inertiaStep: 1,
			/* type="number" Sets gets the modifier for how long the inertia last on mobile devices
			```
				//Initialize
				$(".selector").igScroll({
					inertiaDuration: 2
				});

				//Get
				var inertiaDuration = $(".selector").igScroll("option", "inertiaDuration");

				//Set
				$(".selector").igScroll("option", "inertiaDuration", 2);
			```
			*/
			inertiaDuration: 1,
			/* type="number" Sets gets how much pixels of toleration there will be when initially swiping horizontally. This is to improve swiping up/down without scrolling left/right when not intended due to small deviation left/right
			```
				//Initialize
				$(".selector").igScroll({
					swipeToleranceX: 20
				});

				//Get
				var swipeToleranceX = $(".selector").igScroll("option", "swipeToleranceX");

				//Set
				$(".selector").igScroll("option", "swipeToleranceX", 20);
			```
			*/
			swipeToleranceX: 30,
			/* type="number" Sets gets at least how many times the horizontal speed should be bigger so the inertia proceeds only horizontally without scrolling vertically. This is to improve interactions due to not perfectly swiping left/right with some deviation down/up
			```
				//Initialize
				$(".selector").igScroll({
					inertiaDeltaX: 1.5
				});

				//Get
				var inertiaDeltaX = $(".selector").igScroll("option", "inertiaDeltaX");

				//Set
				$(".selector").igScroll("option", "inertiaDeltaX", 1.5);
			```
			*/
			inertiaDeltaX: 1.25,
			/* type="number" Sets gets at least how many times the vertical speed should be bigger so the inertia proceeds only vertically without scrolling horizontally. This is to improve interactions due to not perfectly swiping down/up with some deviation left/right
			```
				//Initialize
				$(".selector").igScroll({
					inertiaDeltaY: 3
				});

				//Get
				var inertiaDeltaY = $(".selector").igScroll("option", "inertiaDeltaY");

				//Set
				$(".selector").igScroll("option", "inertiaDeltaY", 3);
			```
			*/
			inertiaDeltaY: 2,
			/* type="array" Sets gets elements that are linked to the main content horizontally. When the content is scrolled on X axis the linked elements scroll accordingly.
			```
				<div id='scrContainerLeft' style="width:200px; height:200px; overflow: hidden;">
					<div style="width:900px; height: 400px;">
					</div>
				<div>

				//Initialize
				$(".selector").igScroll({
					syncedElemsH: [$("#scrContainerLeft")]
				});

				//Get
				var syncedElemsH = $(".selector").igScroll("option", "syncedElemsH");

				//Set
				$(".selector").igScroll("option", "syncedElemsH", $("#scrContainerLeft"));
			```
			*/
			syncedElemsH: [],
			/* type="array" Sets gets elements that are linked to the main content vertically. When the content is scrolled on Y axis the linked elements scroll accordingly.
			```
				<div id='scrContainerLeft' style="width:200px; height:200px; overflow: hidden;">
					<div style="width:900px; height: 400px;">
					</div>
				<div>

				//Initialize
				$(".selector").igScroll({
					syncedElemsV: [$("#scrContainerLeft")]
				});

				//Get
				var syncedElemsV = $(".selector").igScroll("option", "syncedElemsV");

				//Set
				$(".selector").igScroll("option", "syncedElemsV", $("#scrContainerLeft"));
			```
			*/
			syncedElemsV: [],
			/* type="string" Sets gets html or jQuery element which is used for horizontal scrolling.
			```
				<div id='customHScroll' style='width:200px; overflow-x:auto;'>
					<div style='width:500px; height:1px;'></div>
				</div>

				//Initialize
				$(".selector").igScroll({
					scrollbarType: "none",
					scrollbarH: $("#customHScroll")
				});

				//Get
				var scrollbarH = $(".selector").igScroll("option", "scrollbarH");
			```
			*/
			scrollbarH: null,
			/* type="string" Sets gets html or jQuery element which is used for vertical scrolling.
			```
				<div id='customVScroll' style='height:200px; overflow-y:auto; float:left; position:relative;'>
					<div style='width:20px; height:500px;'></div>
				</div>

				//Initialize
				$(".selector").igScroll({
					scrollbarType: "none",
					scrollbarV:  $("#customVScroll")
				});

				//Get
				var scrollbarV = $(".selector").igScroll("option", "scrollbarV");
			```
			*/
			scrollbarV: null,
			/* type="bool" Sets gets if only the linked horizontal scrollbar should be used for horizontal scrolling. Note: The behavior when the linked scrollbar is scrolled in this case should be handled manually.
			```
				//Initialize
				$(".selector").igScroll({
					scrollOnlyHBar: true
				});

				//Get
				var scrollOnlyHBar = $(".selector").igScroll("option", "scrollOnlyHBar");

				//Set
				$(".selector").igScroll("option", "scrollOnlyHBar", true);
			```
			*/
			scrollOnlyHBar: false,
			/* type="bool" Sets gets if only the linked vertical scrollbar should be used for vertical scrolling. Note: The behavior when the linked scrollbar is scrolled in this case should be handled manually.
			```
				//Initialize
				$(".selector").igScroll({
					scrollOnlyVBar: true
				});

				//Get
				var scrollOnlyVBar = $(".selector").igScroll("option", "scrollOnlyVBar");

				//Set
				$(".selector").igScroll("option", "scrollOnlyVBar", true);
			```
			*/
			scrollOnlyVBar: false,
			/* type="string" Sets gets html or jQuery element to which the horizontal scrollbar will be appended to.
			```
				<div id='parentH'>
				</div>

				//Initialize
				$(".selector").igScroll({
					scrollbarHParent: $("#parentH")
				});

				//Get
				var scrollbarHParent = $(".selector").igScroll("option", "scrollbarHParent");
			```
			*/
			scrollbarHParent: null,
			/* type="string" Sets gets html or jQuery element to which the vertical scrollbar will be appended to.
			```
				<div id='parentV'>
				</div>

				//Initialize
				$(".selector").igScroll({
					scrollbarVParent: $("#parentV")
				});

				//Get
				var scrollbarVParent = $(".selector").igScroll("option", "scrollbarVParent");
			```
			*/
			scrollbarVParent: null
		},
		events: {
			/* cancel="false" Event which is raised after the scroller has been rendered fully
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="event" Gets a reference to the igScroll.
			```
				//Bind after initialization
				$(document).on("igscrollrendered", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
				});

				//Initialize
				$(".selector").igScroll({
					rendered: function(evt, args) {...}
				});
			```
			*/
			rendered: null,
			/* cancel="true" Event which is raised before scrolling or before each step when having inertia.
				Return false in order to cancel action.
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="object" Gets a reference to the igScroll.
				eventArgument="args.smallIncrement" argType="number" Gets if the content is scrolled by the arrows. 0 - none used, -1 - Arrow Up/Left, 1 - Arrow Down/Right.
				eventArgument="args.bigIncrement" argType="number" Gets if the content is scrolled by the scrollbar track areas. 0 - none used, -1 - Scrolled Up/Left, 1 - Scrolled Down/Right.
				eventArgument="args.horizontal" argType="bool" Gets which axis is being used to scroll - horizontal(true) or vertical(false).
				eventArgument="args.stepX" argType="number" Gets how much the content will be scrolled horizontally.
				eventArgument="args.stepY" argType="number" Gets how much the content will be scrolled vertically.
			```
				//Bind after initialization
				$(document).on("igscrollscrolling", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
					//returns if the content is scrolled by the arrow : 0 - none used, -1 - Arrow Up/Left, 1 - Arrow Down/Right.
					args.smallIncrement
					//returns if the content is scrolled by the scrollbar track areas: 0 - none used, -1 - Scrolled Up/Left, 1 - Scrolled Down/Right.
					args.bigIncrement
					//returns which axis is being used to scroll - horizontal(true) or vertical(false).
					args.horizontal
					//returns how much the content will be scrolled horizontally
					args.stepX
					//returns how much the content will be scrolled vertically
					args.stepY
				});

				//Initialize
				$(".selector").igScroll({
					scrolling: function(evt, args) {...}
				});
			```
			*/
			scrolling: null,
			/* cancel="false" Event which is raised after scrolling has stopped.
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="object" Gets a reference to the igScroll.
				eventArgument="args.smallIncrement" argType="number" Gets if the content is scrolled by the arrows. 0 - none used, -1 - Arrow Up/Left, 1 - Arrow Down/Right.
				eventArgument="args.bigIncrement" argType="number" Gets if the content is scrolled by the scrollbar track areas. 0 - none used, -1 - Scrolled Up/Left, 1 - Scrolled Down/Right.
				eventArgument="args.horizontal" argType="bool" Gets which axis is being used to scroll - horizontal(true) or vertical(false).
			```
				//Bind after initialization
				$(document).on("igscrollscrolled", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
					//returns if the content is scrolled by the arrow : 0 - none used, -1 - Arrow Up/Left, 1 - Arrow Down/Right.
					args.smallIncrement
					//returns if the content is scrolled by the scrollbar track areas: 0 - none used, -1 - Scrolled Up/Left, 1 - Scrolled Down/Right.
					args.bigIncrement
					//returns which axis is being used to scroll - horizontal(true) or vertical(false).
					args.horizontal
				});

				//Initialize
				$(".selector").igScroll({
					scrolled: function(evt, args) {...}
				});
			```
			*/
			scrolled: null,
			/* cancel="false" Event which is raised when there is mouse click on the scrollbar's thumb drag.
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="object" Gets a reference to the igScroll.
				eventArgument="args.horizontal" argType="bool" Gets which axis is being used to scroll - horizontal(true) or vertical(false).
			```
				//Bind after initialization
				$(document).on("igscrollthumbdragstart", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
					//returns which axis is being used to scroll - horizontal(true) or vertical(false).
					args.horizontal
				});

				//Initialize
				$(".selector").igScroll({
					thumbDragStart: function(evt, args) {...}
				});
			```
			*/
			thumbDragStart: null,
			/* cancel="true" Event which is raised when the thumb drag is being moved.
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="object" Gets a reference to the igScroll.
				eventArgument="args.horizontal" argType="bool" Gets which scrollbar thumb is being used - horizontal(true) or vertical(false).
				eventArgument="args.stepX" argType="number" Gets how much the content will be scrolled horizontally.
				eventArgument="args.stepY" argType="number" Gets how much the content will be scrolled vertically.
			```
				//Bind after initialization
				$(document).on("igscrollthumbdragmove", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
					//returns which axis is being used to scroll - horizontal(true) or vertical(false).
					args.horizontal
					//returns how much the content will be scrolled horizontally
					args.stepX
					//returns how much the content will be scrolled vertically
					args.stepY
				});

				//Initialize
				$(".selector").igScroll({
					thumbDragMove: function(evt, args) {...}
				});
			```
			*/
			thumbDragMove: null,
			/* cancel="false" Event which is raised on mouse up from the scrollbar's thumb drag.
				eventArgument="evt" argType="event" jQuery event object.
				eventArgument="evt.originalEvent" argType="event" Gets a reference to event of the browser (with validation for not null of evt).
				eventArgument="args.owner" argType="object" Gets a reference to the igScroll.
				eventArgument="args.horizontal" argType="bool" Gets which scrollbar thumb is being used - horizontal(true) or vertical(false).
			```
				//Bind after initialization
				$(document).on("igscrollthumbdragend", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
					//returns which axis is being used to scroll - horizontal(true) or vertical(false).
					args.horizontal
				});

				//Initialize
				$(".selector").igScroll({
					thumbDragEnd: function(evt, args) {...}
				});
			```
			*/
			thumbDragEnd: null,
			/* cancel="true" Event which is raised when the igScroll detects that the element is reizing.
				Function takes arguments evt and args.
				Use evt.originalEvent (with validation for not null of evt) to obtain reference to event of browser.
				Use args.owner to obtain reference to igScroll.
			```
				//Bind after initialization
				$(document).on("igscrollresizing", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
				});

				//Initialize
				$(".selector").igScroll({
					resizing: function(evt, args) {...}
				});
			```
			*/
			resizing: null,
			/* cancel="false" Event which is raised after the igScroll has finished resizing.
				Function takes arguments evt and args.
				Use evt.originalEvent (with validation for not null of evt) to obtain reference to event of browser.
				Use args.owner to obtain reference to igScroll.
			```
				//Bind after initialization
				$(document).on("igscrollresized", ".selector", function (evt, args) {
					//return reference to igScroll
					args.owner;
				});

				//Initialize
				$(".selector").igScroll({
					resized: function(evt, args) {...}
				});
			```
			*/
			resized: null
		},
		css: {
			/* Classes applied to the element the igScroll is instantiated on */
			scrollableElem: "igscroll-scrollable",
			/* Classes applied to the element the igScroll is instantiated on, related to touch scrolling */
			touchScrollableElem: "igscroll-touchscrollable",
			/* Classes applied to the scroll content wrapper */
			scrollContent: "igscroll-content",
			/* Classes applied to the scroll container */
			scrollContainer: "igscroll-container",
			/* Classes applied to the outer element of the native vertical scrollbar */
			nativeVScrollOuter: "igscroll-vnative-outer",
			/* Classes applied to the outer element of the native vertical scrollbar */
			nativeVScrollOuterSingle: "igscroll-vnative-outer-single",
			/* Classes applied to the inner element of the native vertical scrollbar */
			nativeVScrollInner: "igscroll-vnative-inner",
			/* Classes applied to the outer element of the native horizontal scrollbar */
			nativeHScrollOuter: "igscroll-hnative-outer",
			/* Classes applied to the outer element of the native horizontal scrollbar */
			nativeHScrollOuterSingle: "igscroll-hnative-outer-single",
			/* Classes applied to the inner element of the native horizontal scrollbar */
			nativeHScrollInner: "igscroll-hnative-inner",
			/* Classes applied to the fill element that cover the area between the scrollbars */
			nativeScrollFiller: "igscroll-filler",
			/* Classes applied to the container of the custom vertical scrollbar */
			verticalScrollContainer: "igscroll-vcontainer",
			/* Classes applied to the track of the custom vertical scrollbar */
			verticalScrollTrack: "igscroll-vtrack",
			/* Classes applied to the track of the custom vertical scrollbar when no horizontal scrollbar is displayed */
			verticalScrollTrackSingleScrollbar: "igscroll-vtrack-single",
			/* Classes applied to the arrows of the custom vertical scrollbar */
			verticalScrollArrow: "igscroll-varrow",
			/* Classes applied to the arrows of the custom vertical scrollbar when it is hidden */
			verticalScrollArrowHidden: "igscroll-varrow-hidden",
			/* Classes applied to the Arrow Up of the custom vertical scrollbar */
			verticalScrollArrowUp: "igscroll-uparrow",
			/* Classes applied to the Arrow Down of the custom vertical scrollbar */
			verticalScrollArrowDown: "igscroll-downarrow",
			/* Classes applied to the Arrow Down of the custom vertical scrollbar when the horizontal scrollbar is not visible */
			verticalScrollArrowDownSingleScrollbar: "igscroll-downarrow-single",
			/* Classes applied to the thumb drag of the custom vertical scrollbar */
			verticalScrollThumbDrag: "igscroll-vdrag",
			/* Classes applied to the thumb drag of the custom vertical scrollbar when it is in thin form */
			verticalScrollThumbDragThin: "igscroll-vdrag-thin",
			/* Classes applied to the thumb drag of the custom vertical scrollbar when it is hidden but previously was visible the thin. */
			verticalScrollThumbDragHidden: "igscroll-vdrag-hidden",
			/* Classes applied to the thumb drag of the custom vertical scrollbar when it is in big form */
			verticalScrollThumbDragBig: "igscroll-vdrag-big",
			/* Classes applied to the container of the custom horizontal scrollbar */
			horizontalScrollContainer: "igscroll-hcontainer",
			/* Classes applied to the track of the custom horizontal scrollbar  */
			horizontalScrollTrack: "igscroll-htrack",
			/* Classes applied to the track of the custom horizontal scrollbar when no vertical scrollbar is displayed */
			horizontalScrollTrackSingleScrollbar: "igscroll-htrack-single",
			/* Classes applied to the arrows of the custom horizontal scrollbar */
			horizontalScrollArrow: "igscroll-harrow",
			/* Classes applied to the arrows of the custom horizontal scrollbar when it is hidden */
			horizontalScrollArrowHidden: "igscroll-harrow-hidden",
			/* Classes applied to the Arrow Left of the custom horizontal scrollbar */
			horizontalScrollArrowLeft: "igscroll-leftarrow",
			/* Classes applied  to the Arrow Right of the custom horizontal scrollbar */
			horizontalScrollArrowRight: "igscroll-rightarrow",
			/* Classes applied to the Arrow Right of the custom horizontal scrollbar when the vertical scrollbar is not visible */
			horizontalScrollArrowRightSingleScrollbar: "igscroll-rightarrow-single",
			/* Classes applied to the thumb drag of the custom horizontal scrollbar */
			horizontalScrollThumbDrag: "igscroll-hdrag",
			/* Classes applied to the thumb drag of the custom horizontal scrollbar when it is in thin form */
			horizontalScrollThumbDragThin: "igscroll-hdrag-thin",
			/* Classes applied to the thumb drag of the custom horizontal scrollbar when it is hidden but previously was visible the thin. */
			horizontalScrollThumbDragHidden: "igscroll-hdrag-hidden",
			/* Classes applied to the thumb drag of the custom horizontal scrollbar when it is in big form */
			horizontalScrollThumbDragBig: "igscroll-hdrag-big",
			/* Classes applied to an element that prevents selection when dragging */
			disabledSelection: "igscroll-select-disabled",
			/* Classes applied to an element that wraps the content of vertically linked element */
			syncedElemContentV: "igscroll-vsynced-content",
			/* Classes applied to an element that wraps the content of horizontally linked element */
			syncedElemContentH: "igscroll-hsynced-content"
		},

		refresh: function () {
			/*
			```
				$(".selector").igScroll("refresh");
			```
			*/

			/* Get the width/height and update first the container, because the content width/height might change from that */
			this._elemWidth = this.element.width();
			this._elemHeight = this.element.height();

			if (this.options.modifyDOM) {
				this._container.css({
					"width": this._elemWidth + "px",
					"height": this._elemHeight + "px"
				});
			}

			/* width specific */
			this._contentWidth = this._getContentWidth();
			this._percentInViewH = this._elemWidth / this._contentWidth;
			this._isScrollableH = this._percentInViewH < 1;

			/* height specific */
			this._contentHeight = this._getContentHeight();
			this._percentInViewV = this._elemHeight / this._contentHeight;
			this._isScrollableV = this._percentInViewV < 1;

			this._refreshScrollbars();

			return this.element;
		},

		_create: function () {
			var elem = this.element;

			this._bKeyboardNavigation = true;
			this._renderVerticalScrollbar = true;
			this._renderHorizontalScrollbar = true;
			/** When _bMixedEnvironment is true, only scrollTop/scrollLeft would be used to scroll. Otherwise used transformations */
			this._bMixedEnvironment = $.ig.util.getScrollWidth() > 0 || !$.ig.util.isTouchDevice();
			this._linkedHElems = [];
			this._linkedVElems = [];
			this._linkedHBar = null;
			this._linkedVBar = null;
			this._elemWidth = elem.width();
			this._elemHeight = elem.height();

			//IDs of the timeouts used for waiting until hiding, switching to simple scrollbars, touch inertia
			this._showScrollbarsAnimId = 0;
			this._hideScrollbarID = 0;
			this._toSimpleScrollbarsID = 0;
			this._touchInertiaAnimID = 0;

			//Track if the mouse is inside the scroll container
			this._mOverContainer = false;
			this._mOverScrollbars = false;

			//Determines if the scroll event for the content is triggered when trying to sync it on a specific axis
			this._scrollFromSyncContentH = false;
			this._scrollFromSyncContentV = false;
			this._bInternalScroll = false;

			//Track if events should not be triggered
			this._cancelScrolling = false;
			this._cancelThumbDrag = false;

			//Counter for how many animation for smooth wheel scrolling are present. When 0 we are no longer scrolling with wheel
			this._numSmoothAnimation = 0;

			elem.addClass(this.css.touchScrollableElem);
			if (this.options.modifyDOM) {
				elem.addClass(this.css.scrollableElem);

				this._content = $("<div id='" + elem.attr("id") + "_content'/>")
					.addClass(this.css.scrollContent)
					.appendTo(elem)
					.append(elem.contents());

				this._container = $("<div id='" + elem.attr("id") + "_container'/>")
					.addClass(this.css.scrollContainer)
					.css({
						"width": this._elemWidth + "px",
						"height": this._elemHeight + "px"
					})
					.insertBefore(this._content)
					.append(this._content);
				this._container.data("containerName", "scrollContainer");
				if (this.element.attr("tabindex")) {
					this._container.attr("tabindex", this.element.attr("tabindex"));
				}
			} else {
				this._container = elem;
				this._content = $(elem.children()[ 0 ]);
				/* These are in case you want to override the content to something else */
				this._contentX = null;
			}

			this._contentHeight = this._content[ 0 ].scrollHeight;
			this._contentWidth = this._content[ 0 ].scrollWidth;
			this._percentInViewH = this._elemWidth / this._contentWidth;
			this._percentInViewV = this._elemHeight / this._contentHeight;

			//1 equals 100%
			this._isScrollableV = this._percentInViewV < 1;
			this._isScrollableH = this._percentInViewH < 1;

			/* Set initial options */
			this._initOptions(this.options);

			//Container Events specific variables
			this._startX = 0;
			this._startY = 0;
			this._touchStartX = 0;
			this._touchStartY = 0;
			this._moving = false;

			this._evts = {
				scroll: this._onScrollContainer.bind(this),
				wheel: this._onWheelContainer.bind(this),
				DOMMouseScroll: this._onWheelContainer.bind(this),

				pointerdown: this._onPointerDownContainer.bind(this),
				pointerup: this._onPointerUpContainer.bind(this),
				MSPointerDown: this._onPointerDownContainer.bind(this),
				MSGestureStart: this._onMSGestureStartContainer.bind(this),
				MSGestureChange: this._onMSGestureChangeContainer.bind(this),
				MSGestureEnd: this._onMSGestureEndContainer.bind(this),

				touchstart: this._onTouchStartContainer.bind(this),
				touchmove: this._onTouchMoveContainer.bind(this),
				touchend: this._onTouchEndContainer.bind(this),

				mouseenter: this._onMouseEnterContainer.bind(this),
				mouseleave: this._onMouseLeaveContainer.bind(this),

				keydown: this._onKeyDown.bind(this)
			};
			this._container.on(this._evts);
			$(window).on("resize.igscroll_" + this.element[ 0 ].id, this._onDimensionsChange.bind(this));

			if (typeof MutationObserver === "function") {
				this._observer = new MutationObserver(this._onElementMutation.bind(this));
				this._observer.observe(this.element[ 0 ], { attributes: true });
			}

			this._updateScrollBarsVisibility();
			this._hideScrollbars();
			if (this.options.alwaysVisible) {
				if ($.ig.util.isTouchDevice()) {
					this._showScrollbars(true);
				} else {
					this._showScrollbars(false);
				}
			} else {
				this._showScrollbars(true, 2000);
			}

			this._trigger("rendered", null, {
				owner: this
			});
		},

		_initOptions: function (scrollOptions) {
			if (scrollOptions) {
				if (typeof scrollOptions.syncedElemsH[ 0 ] !== "undefined") {
					this._linkElementsH(scrollOptions.syncedElemsH);
				}
				if (typeof scrollOptions.syncedElemsV[ 0 ] !== "undefined") {
					this._linkElementsV(scrollOptions.syncedElemsV);
				}
				if (scrollOptions.scrollbarH !== null) {
					this._bindHScrollbar(scrollOptions.scrollbarH);
				}
				if (scrollOptions.scrollbarV !== null) {
					this._bindVScrollbar(scrollOptions.scrollbarV);
				}
				if (scrollOptions.scrollHeight !== null) {
					this._setScrollHeight(scrollOptions.scrollHeight);
				}
				if (scrollOptions.scrollWidth !== null) {
					this._setScrollWidth(scrollOptions.scrollWidth);
				}
				/* Lastly change position to be sure that all elements are linked */
				if (scrollOptions.scrollTop !== 0) {
					this._scrollTop(scrollOptions.scrollTop, false);
				}
				if (scrollOptions.scrollLeft !== 0) {
					this._scrollLeft(scrollOptions.scrollLeft, false);
				}
			}
		},

		changeLocale: function () {
			/* This method overrides the base method and does nothing, because the scoll container shouldn't change the container locales
			Note that this method is for rare scenarios, use [language](ui.igupload#options:language) or [locale](ui.igupload#options:locale) option setter
			```
				$(".selector").%%WidgetName%%("changeLocale");
			```
			*/
		},

		_setOption: function (key, value) {
			this._super(key, value);

			if (key === "alwaysVisible") {
				if (value === true) {
					if ($.ig.util.isTouchDevice()) {
						this._showScrollbars(true);
					} else {
						this._showScrollbars(false);
					}
				}
			}
			if (key === "scrollbarType") {
				this._removeScrollbars();

				if (value !== "none") {
					this._updateScrollBarsVisibility();
					this._updateScrollbarsPos(this._getContentPositionX(), this._getContentPositionY());
				}
			}
			if (key === "minThumbSize" &&
				this.options.scrollbarType === "custom") {
				this._refreshScrollbars();
			}
			if (key === "scrollTop") {
				this._scrollTop(value, true);
			}
			if (key === "scrollLeft") {
				this._scrollLeft(value, true);
			}
			if (key === "scrollHeight") {
				this._setScrollHeight(value);
				this._refreshScrollbars();
				this._updateScrollbarsPos(this._getContentPositionX(), this._getContentPositionY());
			}
			if (key === "scrollWidth") {
				this._setScrollWidth(value);
				this._refreshScrollbars();
				this._updateScrollbarsPos(this._getContentPositionX(), this._getContentPositionY());
			}
			if (key === "syncedElemsH") {
				this._linkElementsH(value);
			}
			if (key === "syncedElemsV") {
				this._linkElementsV(value);
			}
			if (key === "scrollbarH") {
				this._bindHScrollbar(value);
			}
			if (key === "scrollbarV") {
				this._bindVScrollbar(value);
			}
		},

		option: function (optionName, value) {
			if (optionName === "scrollTop" && value === undefined) {
				return this._scrollTop(null, true);
			}
			if (optionName === "scrollLeft" && value === undefined) {
				return this._scrollLeft(null, true);
			}
			if (optionName === "scrollHeight" && value === undefined) {
				return this._getContentHeight();
			}
			if (optionName === "scrollWidth" && value === undefined) {
				return this._getContentWidth();
			}

			return this._super(optionName, value);
		},

		_getContainerHeight: function () {
			//We round up the container height across all browsers, so we have consistent experience.
			//On Edge,Firefox and IE the height returned is a float, while on Chrome it appears to be rounded up(ceil).
			//We don't use outerHeight becuse we do not expect anny css borders or such on the container itself
			return Math.ceil(this._container.height());
		},

		_getContainerWidth: function () {
			//We round up the container height across all browsers, so we have consistent experience.
			//On Edge,Firefox and IE the height returned is a float, while on Chrome it appears to be rounded up(ceil).
			//We don't use outerHeight becuse we do not expect anny css borders or such on the container itself
			return Math.ceil(this._container.width());
		},

		_getContentHeight: function () {
		    var attached = !!this._content[ 0 ].parentNode;
			if (this.options.scrollHeight !== null) {
				return this.options.scrollHeight;
			} else {
			    if ($.ig.util.isIE && attached) {
					/* S.K. Fix for bug 224900 - On IE reaching the bottom flickers because the height can be not a round number */
			        return Math.ceil(this._content[ 0 ].getBoundingClientRect().height);
			    } else {
					return Math.ceil(this._content.outerHeight());
				}
			}
		},

		_getContentWidth: function () {
		    var attached = !!this._content[ 0 ].parentNode;
			if (this.options.scrollWidth !== null) {
				return this.options.scrollWidth;
			} else {
			    if ($.ig.util.isIE && attached) {
					/* S.K. Fix for bug 224900 - - On IE the width could be not a round number */
			        return Math.ceil(this._content[ 0 ].getBoundingClientRect().width);
			    } else {
					return Math.ceil(this._content.outerWidth());
				}
			}
		},

		_getContentPositionX: function () {
			if ($.ig.util.isTouchDevice() && !this._bMixedEnvironment) {
				var posX = 0;
				if (this._contentX) {
					posX = -this._getTransform3dValueX(this._contentX);
				} else {
					posX = -this._getTransform3dValueX(this._content);
				}

				return posX;
			} else {
				return this._container.scrollLeft();
			}
		},

		_getContentPositionY: function () {
			if ($.ig.util.isTouchDevice() && !this._bMixedEnvironment) {
				var posY = -this._getTransform3dValueY(this._content);

				return posY;
			} else {
				return this._container.scrollTop();
			}
		},

		_getTransform3dValueX: function (jqElem) {
			var matrix, values, posX;
			if (jqElem.css("-webkit-transform")) {
				matrix = jqElem.css("-webkit-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posX = values ? Number(values[ 4 ]) : 0;
			} else if (jqElem.css("-moz-transform")) {
				matrix = jqElem.css("-moz-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posX = values ? Number(values[ 4 ]) : 0;
			} else if (jqElem.css("-ms-transform")) {
				matrix = jqElem.css("-ms-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posX = values ? Number(values[ 13 ]) : 0;
			}

			return posX;
		},

		_getTransform3dValueY: function (jqElem) {
			var matrix, values, posY;
			if (jqElem.css("-webkit-transform")) {
				matrix = jqElem.css("-webkit-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posY = values ? Number(values[ 5 ]) : 0;
			} else if (jqElem.css("-moz-transform")) {
				matrix = jqElem.css("-moz-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posY = values ? Number(values[ 5 ]) : 0;
			} else if (jqElem.css("-ms-transform")) {
				matrix = jqElem.css("-ms-transform");
				values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
				posY = values ? Number(values[ 14 ]) : 0;
			}

			return posY;
		},

		_getScrollbarVPosition: function () {
			if (this._linkedVBar) {
				return this._linkedVBar.scrollTop();
			} else {
				return this._getContentPositionY();
			}
		},

		_getScrollbarHPosition: function () {
			if (this._linkedHBar) {
				return this._linkedHBar.scrollLeft();
			} else {
				return this._getContentPositionX();
			}
		},

		//Internal scrollLeft function that handles scrolling on the X axis
		_scrollLeft: function (val, triggerEvents, bSyncElems) {
			/* Gets sets the position of the content horizontally.
				paramType="number" optional="true" new value for scrollLeft.
				returnType="number|object" Returns scrollLeft or reference to igScroll.
			*/
			if (val === "undefined" || val === null) {
				return this._getContentPositionX();
			}

			/* Cancels any ongoing inertia otherwise the method call might be ignored */
			cancelAnimationFrame(this._touchInertiaAnimID);

			if ($.ig.util.isTouchDevice() && !this._bMixedEnvironment) {
				var posY = this._getContentPositionY();
				this._scrollTouchToXY(val, posY, triggerEvents, bSyncElems);
			} else {
				this._scrollToX(val, triggerEvents, bSyncElems);
			}

			if (triggerEvents) {
				//Trigger scrolled event
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: true
				});
			}

			return this;
		},

		//Internal scrollLTop function that handles scrolling on the Y axis
		_scrollTop: function (val, triggerEvents, bSyncElems) {
			/* Gets sets the position of the content vertically.
				paramType="number" optional="true" new value for scrollTop.
				returnType="number|object" Returns scrollTop or reference to igScroll.
			*/
			if (val === "undefined" || val === null) {
				return this._getContentPositionY();
			}

			/* Cancels any ongoing inertia otherwise the method call might be ignored */
			cancelAnimationFrame(this._touchInertiaAnimID);

			if ($.ig.util.isTouchDevice() && !this._bMixedEnvironment) {
				var posX = this._getContentPositionX();
				this._scrollTouchToXY(posX, val, triggerEvents, bSyncElems);
			} else {
				this._scrollToY(val, triggerEvents, bSyncElems);
			}

			if (triggerEvents && !this._cancelScrolling) {
				//Trigger scrolled event
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: false
				});
			}

			return this;
		},

		_setScrollWidth: function (inWidth) {
			/* Do NOT refresh after calling this function!!! The custom width will be lost. */
			this._elemWidth = this._getContainerWidth();
			this._contentWidth = inWidth;
			this._percentInViewH = this._elemWidth / this._contentWidth;
			this._isScrollableH = this._percentInViewH < 1;

			if (this.options.modifyDOM) {
				this._content.css("width", inWidth + "px");
			}

			return this.element;
		},

		_setScrollHeight: function (inHeight) {
			/* Do NOT refresh after calling this function!!! The custom height will be lost. */
			this._elemHeight = this._container.innerHeight();
			this._contentHeight = inHeight;
			this._percentInViewV = this._elemHeight / this._contentHeight;
			this._isScrollableV = this._percentInViewV < 1;

			if (this.options.modifyDOM) {
				this._content.css("height", inHeight + "px");
			}

			return this.element;
		},

		_refreshScrollbars: function () {
			var	css = this.css,
				nativeScrollSize = $.ig.util.getScrollWidth();
			this._elemHeight = this.element.height();
			this._elemWidth = this.element.width();

			if (this.options.scrollbarType === "custom" && this._vBarTrack && this._vBarDrag) {
				this._vDragHeight = this._calculateVDragHeight();
				this._vBarDrag.css("height", this._vDragHeight + "%");
				/* Update classes if only vertical scrollbar will be visible */
				if (this._percentInViewH >= 1) {
					this._vBarTrack.addClass(css.verticalScrollTrackSingleScrollbar);
					this._vBarArrowDown.addClass(css.verticalScrollArrowDownSingleScrollbar);
				} else {
					this._vBarTrack.removeClass(css.verticalScrollTrackSingleScrollbar);
					this._vBarArrowDown.removeClass(css.verticalScrollArrowDownSingleScrollbar);
				}
			} else if (this.options.scrollbarType === "native" && this._vBarContainer && this._vBarDrag) {
				this._vDragHeight = this._content.height();
				this._vBarDrag.css("height", this._vDragHeight + "px");
				/* Update classes if only vertical scrollbar will be visible */
				if (this._percentInViewH >= 1 &&
					!this._vBarContainer.hasClass(css.nativeVScrollOuterSingle)) {
					this._vBarContainer.css("bottom", "");
					this._vBarContainer.addClass(this.css.nativeVScrollOuterSingle);
				} else if (this._percentInViewH < 1 &&
					this._vBarContainer.hasClass(css.nativeVScrollOuterSingle)) {
					this._vBarContainer.removeClass(css.nativeVScrollOuterSingle);
					this._vBarContainer.css("bottom", nativeScrollSize + "px");
				}
			}

			if (this.options.scrollbarType === "custom" && this._hBarTrack && this._hBarDrag) {
				this._hDragWidth = this._calculateHDragWidth();
				this._hBarDrag.css("width", this._hDragWidth + "%");
				/* Update classes if only vertical scrollbar will be visible */
				if (this._percentInViewV >= 1) {
					this._hBarTrack.addClass(css.horizontalScrollTrackSingleScrollbar);
					this._hBarArrowRight.addClass(css.horizontalScrollArrowRightSingleScrollbar);
				} else {
					this._hBarTrack.removeClass(css.horizontalScrollTrackSingleScrollbar);
					this._hBarArrowRight.removeClass(css.horizontalScrollArrowRightSingleScrollbar);
				}
			} else if (this.options.scrollbarType === "native" && this._hBarContainer && this._hBarDrag) {
				this._hDragWidth = this._content.width();
				this._hBarDrag.css("width", this._hDragWidth + "px");
				/* Update classes if only horozontal scrollbar will be visible */
				if (this._percentInViewV >= 1 &&
					!this._hBarContainer.hasClass(css.nativeHScrollOuterSingle)) {
					this._hBarContainer.css("right", "");
					this._hBarContainer.addClass(css.nativeHScrollOuterSingle);
				} else if (this._percentInViewV < 1 &&
					this._hBarContainer.hasClass(css.nativeHScrollOuterSingle)) {
					this._hBarContainer.removeClass(css.nativeHScrollOuterSingle);
					this._hBarContainer.css("right", nativeScrollSize + "px");
				}
			}

			this._updateScrollBarsVisibility();
			this._updateScrollbarsPos(this._getContentPositionX(), this._getContentPositionY());
		},

		_linkElementsH: function (inElements) {
			this._linkedHElems = [];
			if (inElements) {
				for (var index = 0; index < inElements.length; index++) {
					var elemObject = $(inElements[ index ]);

					if (elemObject.length) {
						if (this.options.modifyDOM && elemObject.data("igScroll") === undefined) {
							$("<div id='" + elemObject.attr("id") + "_content'/>")
								.addClass(this.css.syncedElemContentH)
								.appendTo(elemObject)
								.append(elemObject.contents());
						}
						this._linkedHElems.push(elemObject);
					} else {
						throw new Error(this._getLocaleValue("errorNoElementLink"));
					}
				}
			}

			return this._linkedHElems;
		},

		_linkElementsV: function (inElements) {
			this._linkedVElems = [];
			if (inElements) {
				for (var index = 0; index < inElements.length; index++) {
					var elemObject = $(inElements[ index ]);

					if (elemObject.length) {
						if (this.options.modifyDOM && elemObject.data("igScroll") === undefined) {
							$("<div id='" + elemObject.attr("id") + "_content'/>")
								.addClass(this.css.syncedElemContentV)
								.appendTo(elemObject)
								.append(elemObject.contents());
						}
						this._linkedVElems.push(elemObject);
					} else {
						throw new Error(this._getLocaleValue("errorNoElementLink"));
					}
				}
			}

			return this._linkedVElems;
		},

		_bindHScrollbar: function (inElement) {
			var self = this;

			if (inElement) {
				var elemObject = $(inElement);

				if (elemObject.length) {
					elemObject.on({
						scroll: function (e) {
							var ignoreSync = self._ignoreHScrollBarEvents;
							self._ignoreHScrollBarEvents = false;

							if (ignoreSync || self.options.scrollOnlyHBar) {
								return false;
							} else {
								if (self._bMixedEnvironment) {
									self._syncContentX(e.target, false);
									self._syncElemsX(e.target, false);
								} else {
									self._syncContentX(e.target, true);
									self._syncElemsX(e.target, true);
								}
							}
						}
					});

					if (this._linkedHBar && this._linkedHBar[ 0 ] !== elemObject[ 0 ]) {
						//make sure if there ware prviously linked another scrollbar to not scroll
						this._linkedHBar.off();
					}
					this._linkedHBar = elemObject;
				} else {
					throw new Error(this._getLocaleValue("errorNoScrollbarLink"));
				}
			}

			return this._linkedHBar;
		},

		_bindVScrollbar: function (inElement) {
			var self = this;

			if (inElement) {
				var elemObject = $(inElement);

				if (elemObject.length) {
					elemObject.on({
						scroll: function (e) {
							var ignoreSync = self._ignoreVScrollBarEvents;
							self._ignoreVScrollBarEvents = false;

							/* Ignore if we already moved the content and ignore if scrolling via linded bar is custom handled */
							if (ignoreSync || self.options.scrollOnlyVBar) {
								return false;
							} else {
								if (self._bMixedEnvironment) {
									self._syncContentY(e.target, false);
									self._syncElemsY(e.target, false);
								} else {
									self._syncContentY(e.target, true);
									self._syncElemsY(e.target, true);
								}
							}
						}

					});

					if (this._linkedVBar && this._linkedVBar[ 0 ] !== elemObject[ 0 ]) {
						//make sure if there ware prviously linked another scrollbar to not scroll
						this._linkedVBar.off();
					}
					this._linkedVBar = elemObject;
				} else {
					throw new Error(this._getLocaleValue("errorNoScrollbarLink"));
				}
			}

			return this._linkedVBar;
		},

		_clampAxisCoords: function(target, min, max) {
			if (target === undefined || target < min) {
				target = min;
			} else if (target > max) {
				target = max;
			}

			return target;
		},

		/** Scrolls content to on the X and Y axis using default scrollLeft and scrollTop.
		*	Should be used when sure it's desktop/hybrid environment.
		*	If not sure how to use, use the internal _scrollLeft. */
		_scrollToXY: function(destX, destY, triggerEvents) {
			var curPosX = this._getContentPositionX(),
				curPosY = this._getContentPositionY();
			destX = this._clampAxisCoords(destX,
										0,
										Math.max(this._getContentWidth() - this._getContainerWidth(), 0));
			destY = this._clampAxisCoords(destY,
										0, Math.max(this._getContentHeight() - this._getContainerHeight(), 0));

			if (triggerEvents) {
				//Trigger scrolling event
				var bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: destX - curPosX !== 0,
					stepX: destX - curPosX,
					stepY: destY - curPosY
				});
				if (!bNoCancel) {
					//should scrolled event be triggered
					this._cancelScrolling = true;
					return { x: 0, y: 0 };
				}

			}

			var scrolledX, scrolledY;
			scrolledX = this._scrollToX(destX, false);
			scrolledY = this._scrollToY(destY, false);

			return { x: scrolledX, y: scrolledY };
		},

		/** Scrolls content to on the X axis using default scrollLeft.
		*	Should be used when sure it's desktop/hybrid environment.
		*	If not sure how to use, use the internal _scrollLeft. */
		_scrollToX: function (destX, triggerEvents, bSyncElems) {
			if (!this._isScrollableH && !this.options.scrollOnlyHBar) {
				return 0;
			}

			var curPosX;
			if (this.options.scrollOnlyHBar) {
				curPosX = this._getScrollbarHPosition();
			} else {
				curPosX = this._getContentPositionX();
			}

			destX = this._clampAxisCoords(destX, 0, this._getContentWidth() - this._getContainerWidth());

			//We have another trigger for scrolling in case we want to scroll only on the X axis(horizontal) and not interrupt the Y(vertical) scroll position.
			if (triggerEvents) {
				//Trigger scrolling event
				var	bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: true,
					stepX: destX - curPosX,
					stepY: 0
				});
				if (!bNoCancel) {
					//should scrolled event be triggered
					this._cancelScrolling = true;
					return 0;
				}
			}

			this._bInternalScroll = true;
			if (this.options.scrollOnlyHBar) {
				this._moveHBarX(destX);
			} else {
				this._container.scrollLeft(destX); //No need to check if destY < 0 or > of the content heigh. ScrollLeft handles that.
				if (bSyncElems === undefined || bSyncElems === true) {
					this._syncElemsX(this._container[ 0 ], false);
				}
			}

			/* Update custom scrollbars position */
			var curPosY;
			if (this.options.scrollOnlyVBar) {
				curPosY = this._getScrollbarVPosition();
			} else {
				curPosY = this._getContentPositionY();
			}
			this._updateScrollbarsPos(destX, curPosY, true);

			return destX - curPosX;
		},

		/** Scrolls content to on the Y axis using default scrollTop.
		*	Should be used when sure it's desktop/hybrid environment.
		*	If not sure how to use, use the internal _scrollTop. */
		_scrollToY: function (destY, triggerEvents, bSyncElems) {
			if (!this._isScrollableV && !this.options.scrollOnlyVBar) {
				return 0;
			}

			var curPosY,
				endOffsetEdge = 0;

			if (this.options.scrollOnlyVBar) {
				curPosY = this._getScrollbarVPosition();
			} else {
				curPosY = this._getContentPositionY();
			}

			//On Edge, in order to trigger page scroll when we are at the top or botton, we need to scroll further in the desired direction than what is possible.
			//We apply endOffsetEdge only when setting scrollTop and not directly to the destY.
			//That is because destY is the actual destination that we will scroll to and (destY - curPosY) is 0 at the top/bottom, but with offset it will be -1/1.
			if ($.ig.util.isEdge) {
				if (destY < 0) {
					endOffsetEdge = -1;
				} else {
					endOffsetEdge = destY > (this._getContentHeight() - this._getContainerHeight()) ? 1 : 0;
				}
			}

			destY = this._clampAxisCoords(destY, 0, this._getContentHeight() - this._getContainerHeight());

			//We have another trigger for scrolling in case we want to scroll only on the Y axis(vertical) and not interrupt the X(horizontal) scroll position.
			if (triggerEvents) {
				//Trigger scrolling event
				var	bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: false,
					stepX: 0,
					stepY: destY - curPosY
				});
				if (!bNoCancel) {
					//should scrolled event be triggered
					this._cancelScrolling = !bNoCancel;
					return 0;
				}

			}
			this._bInternalScroll = true;
			if (this.options.scrollOnlyVBar) {
				this._moveVBarY(destY);
			} else {
				//On IE11 we shouldn't call scrollTop when we want to scroll page on top/bottom of content. There is also an error of 1 pixed on IE11
				if ($.ig.util.isIE && Math.abs(destY - curPosY) <= 1) {
					return 0;
				}
				this._container.scrollTop(destY + endOffsetEdge); //No need to check if destY < 0 or > of the content heigh. ScrollTop handles that.
				if (bSyncElems === undefined || bSyncElems === true) {
					this._syncElemsY(this._container[ 0 ], false);
				}
			}

			/* Update custom scrollbars position */
			var curPosX;
			if (this.options.scrollOnlyHBar) {
				curPosX = this._getScrollbarHPosition();
			} else {
				curPosX = this._getContentPositionX();
			}
			this._updateScrollbarsPos(curPosX, destY, true);

			return destY - curPosY;
		},

		/** Scroll with predefined inertia that start slowly, speeds up and then slows down again */
		_smoothWheelScrollY: function (deltaY) {
			var self = this,
				smoothingStep = this.options.smoothingStep,
				smoothingDuration = this.options.smoothingDuration,
				animationId;

			//We use the formula for parabola y = -3*x*x + 3 to simulate smooth inertia that slows down
			var x = -1;
			if (this.options.scrollOnlyVBar) {
				this._nextY = this._getScrollbarVPosition();
			} else {
				this._nextY = this._getContentPositionY();
			}

			function inertiaStep() {
				if (x > 1) {
					cancelAnimationFrame(animationId);
					self._numSmoothAnimation -= 1;

					if (!self._numSmoothAnimation && !self._cancelScrolling) {
						self._trigger("scrolled", null, {
							owner: self,
							smallIncrement: 0,
							bigIncrement: 0,
							horizontal: false
						});
					}

					return;
				}

				self._nextY += ((-3 * x * x + 3) * deltaY * 2) * smoothingStep;

				if (self._bMixedEnvironment) {
					self._scrollToY(self._nextY, true);
				} else {
					var curPosX = 0;
					if (self.options.scrollOnlyHBar) {
						curPosX = self._getScrollbarVPosition();
					} else {
						curPosX = self._getContentPositionY();
					}
					self._scrollTouchToXY(curPosX, self._nextY, true);
				}

				//continue the intertia
				x += 0.08 * (1 / smoothingDuration);
				animationId = requestAnimationFrame(inertiaStep);
			}

			//Start the inertia and continue it recursively
			this._numSmoothAnimation += 1;
			animationId = requestAnimationFrame(inertiaStep);
		},

		_applyTransformOnScrollTop: function () {

			var startX = -this._container.scrollLeft(),
				startY = -this._container.scrollTop();

			if (startX === 0 && startY === 0) {
				return;
			}

			if (this._contentX) {
				startX += this._getTransform3dValueX(this._contentX);
			} else {
				startX += this._getTransform3dValueX(this._content);
			}
			startY += this._getTransform3dValueY(this._content);

			this._scrollToXY(0, 0, false);
			this._scrollTouchToXY(-startX, -startY, false);
		},

		/** Scroll content on the X and Y axis using 3d accelerated transformation. This makes scrolling on touch devices faster
		*	Should be used when sure it's mobile environment.
		*	If not sure how to use, use the internal _scrollTop and _scrollLeft. */
		_scrollTouchToXY: function (destX, destY, triggerEvents, bSyncElems) {
			var bNoCancel,
				curPosX = this._getContentPositionX(),
				curPosY = this._getContentPositionY();

			destX = this._clampAxisCoords(destX,
										0,
										Math.max(this._getContentWidth() - this._getContainerWidth(), 0));
			destY = this._clampAxisCoords(destY,
										0,
										Math.max(this._getContentHeight() - this._getContainerHeight(), 0));

			if (triggerEvents) {
				bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: destX - curPosX !== 0,
					stepX: destX - curPosX,
					stepY: destY - curPosY
				});
				if (!bNoCancel) {
					//should scrolled event be triggered
					this._cancelScrolling = true;
					return { x: 0, y: 0 };
				}

			}

			//Only use vertical scroll specific
			if (this.options.scrollOnlyVBar) {
				this._scrollToY(destY, false);

				if (this.options.scrollOnlyHBar) {
					this._scrollToX(destX);
				} else {
					if (this._contentX) {
						this._contentX.css({
							"-webkit-transform": "translate3d(" + (-destX) + "px, 0px, 0px)" /* Chrome, Safari, Opera */
						});

						this._syncElemsX(this._contentX, true, -destX, true);
					} else {
						this._content.css({
							"-webkit-transform": "translate3d(" + (-destX) + "px, 0px, 0px)" /* Chrome, Safari, Opera */
						});

						this._syncElemsX(this._content, true, -destX, true);
					}
				}

				/* Sync other elements */
				destY = this._getScrollbarVPosition();
				this._updateScrollbarsPos(destX, destY);

				return { x: destX - curPosX, y: destY - curPosY };
			}

			var distanceLeftX = -destX;
			var distanceTopY = -destY;

			if (!this.options.scrollOnlyVBar && !this.options.scrollOnlyHBar) {
				this._content.css({
					"-webkit-transform": "translate3d(" + distanceLeftX + "px," + distanceTopY + "px, 0px)" /* Chrome, Safari, Opera */
				});
			}

			/* Sync other elements */
			if (bSyncElems === undefined || bSyncElems === true) {
				this._syncElemsX(this._content, true);
				this._syncElemsY(this._content, true);
			}
			this._updateScrollbarsPos(destX, destY);

			//No need to sync these bars since they don't show on safari and we use custom ones.
			this._syncHBar(this._content, true);
			this._syncVBar(this._content, true);

			return { x: destX - curPosX, y: destY - curPosY };
		},

		/** Initialize main inertia based on the X and Y speeds. Used on touch devices. */
		_inertiaInit: function (speedX, speedY, bDefaultScroll) {
			var self = this,
				x = 0,
				stepModifer = this.options.inertiaStep,
				inertiaDuration = this.options.inertiaDuration;

			if (this.options.scrollOnlyVBar) {
				this._nextY = this._getScrollbarVPosition();
			} else {
				this._nextY = this._getContentPositionY();
			}
			if (this.options.scrollOnlyHBar) {
				this._nextX = this._getScrollbarHPosition();
			} else {
				this._nextX = this._getContentPositionX();
			}

			//Sets timeout until executing next movement iteration of the inertia
			function inertiaStep() {
				if (x > 6) {
					self._hideScrollbars(); //hide scrollbars when inertia ends naturally
					cancelAnimationFrame(self._touchInertiaAnimID);
					if (!self._cancelScrolling) {
						self._trigger("scrolled", null, {
							owner: self,
							smallIncrement: 0,
							bigIncrement: 0,
							horizontal: null
						});
					}
					return;
				}

				if (Math.abs(speedX) > Math.abs(speedY)) {
					x += 0.05 / (1 * inertiaDuration);
				} else {
					x += 0.05 / (1 * inertiaDuration);
				}

				if (x <= 1) {
					//We use constant quation to determine the offset without speed falloff befor x reaches 1
					if (Math.abs(speedY) <= Math.abs(speedX) * self.options.inertiaDeltaY) {
						self._nextX += 1 * speedX * 15 * stepModifer;
					}
					if (Math.abs(speedY) >= Math.abs(speedX) * self.options.inertiaDeltaX) {
						self._nextY += 1 * speedY * 15 * stepModifer;
					}
				} else {
					//We use the quation "y = 2 / (x + 0.55) - 0.3" to determine the offset
					if (Math.abs(speedY) <= Math.abs(speedX) * self.options.inertiaDeltaY) {
						self._nextX += Math.abs(2 / (x + 0.55) - 0.3) * speedX * 15 * stepModifer;
					}
					if (Math.abs(speedY) >= Math.abs(speedX) * self.options.inertiaDeltaX) {
						self._nextY += Math.abs(2 / (x + 0.55) - 0.3) * speedY * 15 * stepModifer;
					}

				}

				//If we have mixed environment we use the default behaviour. i.e. touchscreen + mouse
				if (bDefaultScroll) {
					self._scrollToXY(self._nextX, self._nextY, true);
				} else {
					self._scrollTouchToXY(self._nextX, self._nextY, true);
				}

				self._touchInertiaAnimID = requestAnimationFrame(inertiaStep);
			}

			//Start inertia and continue it recursively
			this._touchInertiaAnimID = requestAnimationFrame(inertiaStep);
		},

		/** Get the speed slope angle for the last 5 recorded speeds.
		*	This is used to determine if speed is decreasing(slope angle < 0) or increasing(slope angle > 0) based on those last speeds
		*	The technique used here is the same used in calculating trendlines.
		*/
		_getSpeedSlope: function (inLastFiveSpeeds) {
			/** slope < 0 means that there is increase in speed and can start inertia */
			if (inLastFiveSpeeds.length === 0) {
				/*no movement*/
				return 1;
			}
			if (inLastFiveSpeeds.length < 5) {
				/* too quick movement */
				return -1;
			}

			/** We try to represent the 5 recorded speeds as points on a coordinate system and then calculate the slope similar to a trendline
			*	Since we only have one value per record, we will represent the values for (x,y) like: (1, speed1), (2, speed2) ,(3, speed3), (4, speed4), (5, speed5)
			*
			*	Vars:
			*	sumXY - sum of the
			*	sumX - sum of all X coordinates
			*	sumY - sum of all Y coordinates
			*	sumXX - numPoints * (pointX[0]^2 + pointX[1]^2 + pointX[2]^2 + pointX[3]^2 + pointX[4]^2 + pointX[5]^2)
			*/
			var numPoints = inLastFiveSpeeds.length,
				sumXY = 0, sumX = 0, sumY = 0, sumXX = 0;

			for (var pointIndex = 0; pointIndex < numPoints ; pointIndex++) {
				/* pointX - The x coordinate for the [pointIndex] speed */
				/* pointY - The y coordinate for the [pointIndex] speed */
				var pointX = pointIndex,
					pointY = Math.abs(inLastFiveSpeeds[ pointIndex ]);

				sumXY += pointX * pointY;
				sumX += pointX;
				sumY += pointY;
				sumXX += pointX * pointX;
			}

			var slopeAngle = (numPoints * sumXY - sumX * sumY) / (numPoints * sumXX - sumX * sumX);

			return slopeAngle;
		},

		/** Syncs the main content element horizontally */
		_syncContentX: function (baseElem, useTransform) {
			var destX;

			if (useTransform) {
				destX = -baseElem.scrollLeft;
				var destY = -this._getContentPositionY();

				this._content.css({
					"-webkit-transform": "translate3d(" + destX + "px," + destY + "px, 0px)" /* Chrome, Safari, Opera */
				});

			} else {
				destX = baseElem.scrollLeft;

				//this is to not affect the scrolling when clicking on track area of a linked scrollbarH
				this._scrollFromSyncContentH = true;
				this._container.scrollLeft(destX);
			}
		},

		/** Syncs the main content element vertically */
		_syncContentY: function (baseElem, useTransform) {
			var destY;

			if (useTransform) {
				var destX = this._getContentPositionX();
				destY = -baseElem.scrollTop;

				this._content.css({
					"-webkit-transform": "translate3d(" + destX + "px," + destY + "px, 0px)" /* Chrome, Safari, Opera */
				});

			} else {
				destY = baseElem.scrollTop;

				//this is to not affect the scrolling when clicking on track area of a linked scrollbarV
				this._scrollFromSyncContentV = true;
				this._container.scrollTop(destY);
			}
		},

		//Syncs elements that are linked on X axis
		_syncElemsX: function (baseElem, useTransform, inDestX, useDestination) {
			var destX, index;

			if (!baseElem && !useDestination) {
				return;
			}

			if (useTransform) {
				if (!useDestination) {
					var matrix = this._content.css("-webkit-transform");
					var values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
					destX = values ? Number(values[ 4 ]) : -this._getContentPositionX();
				} else {
					destX = inDestX;
				}

				if (this._linkedHElems.length > 0) {
					for (index = 0; index < this._linkedHElems.length; index++) {
						//get the current X position
						var matrixElem = this._linkedHElems[ index ].css("-webkit-transform");
						var valuesElem = matrixElem ? matrixElem.match(/-?[\d\.]+/g) : undefined;
						var destY = valuesElem ? Number(valuesElem[ 5 ]) : 0;

						if (this._linkedHElems[ index ].data("igScroll")  !== undefined &&
								this._linkedHElems[ index ].data("igScroll").options.modifyDOM) {
							//We set syncElems to false because there will be infinite recursion of syncing
							this._linkedHElems[ index ].data("igScroll")._scrollLeft(-destX, true, false);
						} else if (this.options.modifyDOM) {
							this._linkedHElems[ index ].find(".igscroll-hsynced-content").css({
								"-webkit-transform": "translate3d(" + destX + "px, " + destY + "px, 0px)"
							});
						} else {
							this._linkedHElems[ index ].css({
								"-webkit-transform": "translate3d(" + destX + "px, " + destY + "px, 0px)"
							});
						}
					}
				}
			} else {
				destX = baseElem.scrollLeft;

				if (this._linkedHElems.length > 0) {
					for (index = 0; index < this._linkedHElems.length; index++) {
						if (this._linkedHElems[ index ].length) {
							if (this._linkedHElems[ index ].data("igScroll") !== undefined &&
									this._linkedHElems[ index ].data("igScroll").options.modifyDOM) {
								//We do not set igScroll option because there will be infinite recursion of syncing
								this._linkedHElems[ index ].find(".igscroll-container").scrollLeft(destX);
							} else if (this.options.modifyDOM) {
								this._linkedHElems[ index ].scrollLeft(destX);
							} else {
								if (this._linkedHElems[ index ].parent().data("igScroll") !== undefined) {
									this._linkedHElems[ index ].parent().data("igScroll")._scrollFromSyncContentH = true;
								}
								this._linkedHElems[ index ][ 0 ].parentElement.scrollLeft = destX;
							}
						}
					}
				}
			}
		},

		//Syncs elements that are linked on Y axis
		_syncElemsY: function (baseElem, useTransform, inDestY, useDestination) {
			var destY, index;

			if (!baseElem && !useDestination) {
				return;
			}

			if (useTransform) {
				if (!useDestination) {
					var matrix = this._content.css("-webkit-transform");
					var values = matrix ? matrix.match(/-?[\d\.]+/g) : undefined;
					destY = values ? Number(values[ 5 ]) : -this._getContentPositionY();
				} else {
					destY = inDestY;
				}

				if (this._linkedVElems.length > 0) {
					for (index = 0; index < this._linkedVElems.length; index++) {
						//get the current X position
						var matrixElem = this._linkedVElems[ index ].css("-webkit-transform");
						var valuesElem = matrixElem ? matrixElem.match(/-?[\d\.]+/g) : undefined;
						var destX = valuesElem ? Number(valuesElem[ 4 ]) : 0;

						if (this._linkedVElems[ index ].data("igScroll") !== undefined &&
								this._linkedVElems[ index ].data("igScroll").options.modifyDOM) {
							//We set syncElems to false because there will be infinite recursion of syncing
							this._linkedVElems[ index ].data("igScroll")._scrollTop(-destY, true, false);
						} else if (this.options.modifyDOM) {
							this._linkedVElems[ index ].find(".igscroll-vsynced-content").css({
								"-webkit-transform": "translate3d(" + destX + "px," + destY + "px, 0px)"
							});
						} else {
							this._linkedVElems[ index ].css({
								"-webkit-transform": "translate3d(" + destX + "px," + destY + "px, 0px)"
							});
						}
					}
				}
			} else {
				destY = baseElem.scrollTop;

				if (this._linkedVElems.length > 0) {
					for (index = 0; index < this._linkedVElems.length; index++) {
						if (this._linkedVElems[ index ].length) {
							if (this._linkedVElems[ index ].data("igScroll") !== undefined &&
									this._linkedVElems[ index ].data("igScroll").options.modifyDOM) {
								//We do not set igScroll option because there will be infinite recursion of syncing
								this._linkedVElems[ index ].find(".igscroll-container").scrollTop(destY);
							} else if (this.options.modifyDOM) {
								this._linkedVElems[ index ].scrollTop(destY);
							} else {
								if (this._linkedVElems[ index ].parent().data("igScroll") !== undefined) {
									this._linkedVElems[ index ].parent().data("igScroll")._scrollFromSyncContentV = true;
								}
								this._linkedVElems[ index ][ 0 ].parentElement.scrollTop = destY;
							}
						}
					}
				}
			}
		},

		//Syncs horizontal bars that are linked on the X axis
		_syncHBar: function (baseElem, useTransform) {
			var destX;
			if (useTransform) {
				destX = this._getContentPositionX();
			} else {
				destX = baseElem.scrollLeft;
			}

			if (this._linkedHBar) {
				this._ignoreHScrollBarEvents = true;
				this._linkedHBar.scrollLeft(destX);
			}
		},

		//Syncs vertical bars that are linked on the Y axis
		_syncVBar: function (baseElem, useTransform) {
			var destY;
			if (useTransform) {
				destY = this._getContentPositionY();
			} else {
				destY = baseElem.scrollTop;
			}

			if (this._linkedVBar) {
				this._ignoreVScrollBarEvents = true;
				this._linkedVBar.scrollTop(destY);
			}
		},

		_moveHBarX: function (destX) {
			if (this._linkedHBar) {
				this._linkedHBar.scrollLeft(destX);
			}
		},

		_moveVBarY: function (destY) {
			if (this._linkedVBar) {
				this._linkedVBar.scrollTop(destY);
			}
		},

		_onKeyDown: function (event) {
			if (this._bKeyboardNavigation) {
				var keyCode = event.keyCode,
					curPosX,
					curPosY,
					scrollStep = 0,
					horizontal = false,
					evtArgs = {
						owner: this,
						smallIncrement: 0,
						bigIncrement: 0,
						horizontal: false,
						stepX: 0,
						stepY: 0
					};

				if (this.options.scrollOnlyHBar) {
					curPosX = this._getScrollbarHPosition();
				} else {
					curPosX = this._getContentPositionX();
				}

				if (this.options.scrollOnlyVBar) {
					curPosY = this._getScrollbarVPosition();
				} else {
					curPosY = this._getContentPositionY();
				}

				if (keyCode === $.ui.keyCode.DOWN) {
					scrollStep = this.options.smallIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.smallIncrement = 1;
				} else if (keyCode === $.ui.keyCode.UP) {
					scrollStep = -this.options.smallIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.smallIncrement = -1;
				} else if (keyCode === $.ui.keyCode.RIGHT) {
					horizontal = true;
					scrollStep = this.options.smallIncrementStep;
					evtArgs.stepX = scrollStep;
					evtArgs.smallIncrement = 1;
				} else if (keyCode === $.ui.keyCode.LEFT) {
					horizontal = true;
					scrollStep = -this.options.smallIncrementStep;
					evtArgs.stepX = scrollStep;
					evtArgs.smallIncrement = -1;
				} else if (keyCode === $.ui.keyCode.PAGE_UP) {
					scrollStep = this.options.bigIncrementStep === null ?
								-this._elemHeight :
								-this.options.bigIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.bigIncrement = -1;
				} else if (keyCode === $.ui.keyCode.PAGE_DOWN) {
					scrollStep = this.options.bigIncrementStep === null ?
								this._elemHeight :
								this.options.bigIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.bigIncrement = 1;
				} else if (keyCode === $.ui.keyCode.SPACE && !event.shiftKey) {
					scrollStep = this.options.bigIncrementStep === null ?
								this._elemHeight :
								this.options.bigIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.bigIncrement = 1;
				} else if (keyCode === $.ui.keyCode.SPACE && event.shiftKey) {
					scrollStep = this.options.bigIncrementStep === null ?
								-this._elemHeight :
								-this.options.bigIncrementStep;
					evtArgs.stepY = scrollStep;
					evtArgs.bigIncrement = -1;
				}

				var bNoCancel = this._trigger("scrolling", null, evtArgs);
				if (bNoCancel) {
					if (horizontal) {
						this._scrollLeft(curPosX + scrollStep, false);
					} else {
						this._scrollTop(curPosY + scrollStep, false);
					}

					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: evtArgs.smallIncrement,
						bigIncrement: evtArgs.bigIncrement,
						horizontal: horizontal
					});
				}

			}
		},

		_onScrollContainer: function () {
			if (!this._bMixedEnvironment) {
				this._applyTransformOnScrollTop();
			}

			if (!this._scrollFromSyncContentV) {
				this._syncElemsY(this._container[ 0 ], !this._bMixedEnvironment);

				if (!this.options.scrollOnlyVBar) {
					this._syncVBar(this._container[ 0 ], !this._bMixedEnvironment);
				}
			} else {
				this._scrollFromSyncContentV = false;
			}

			if (!this._scrollFromSyncContentH) {
				this._syncElemsX(this._container[ 0 ], !this._bMixedEnvironment);

				if (!this.options.scrollOnlyHBar) {
					this._syncHBar(this._container[ 0 ], !this._bMixedEnvironment);
				}
			} else {
				this._scrollFromSyncContentH = false;
			}

			if (!this._bInternalScroll)
			{
				var posX, posY;
				if (this.options.scrollOnlyHBar) {
					posX = this._getScrollbarHPosition();
				} else {
					posX = this._getContentPositionX();
				}
				if (this.options.scrollOnlyVBar) {
					posY = this._getScrollbarVPosition();
				} else {
					posY = this._getContentPositionY();
				}

				this._updateScrollbarsPos(posX, posY);
			} else {
				this._bInternalScroll = false;
			}

			return false;
		},

		_onWheelContainer: function (event) {
			if (event.ctrlKey === true) {
				return true;
			}

			var evt = event.originalEvent,
				scrollDeltaX = 0,
				scrollDeltaY = 0,
				scrollStep = this.options.wheelStep,
				minWheelStep = 1 / this.options.wheelStep,
				scrolledY;

			cancelAnimationFrame(this._touchInertiaAnimID);

			if (!this._bMixedEnvironment) {
				this._applyTransformOnScrollTop();
			}

			/** Get current scroll positions to base the next scroll position from */
			if (this.options.scrollOnlyHBar) {
				this._startX = this._getScrollbarHPosition();
			} else {
				this._startX = this._getContentPositionX();
			}
			if (this.options.scrollOnlyVBar) {
				this._startY = this._getScrollbarVPosition();
			} else {
				this._startY = this._getContentPositionY();
			}

			/** Get delta for the X axis*/
			if (evt.wheelDeltaX) {
				/* Option supported on Chrome, Safari, Opera.
				/* 120 is default for mousewheel on these browsers. Other values are for trackpads */
				scrollDeltaX = -evt.wheelDeltaX / 120;

				/** S.K. Fix for Issue #1438 When using trackpad the scroll amount could be less than 1 px, but scrollTop receives only integers, so we need to have it scroll minimum 1 px */
				if (-minWheelStep < scrollDeltaX && scrollDeltaX < minWheelStep) {
					scrollDeltaX = Math.sign(scrollDeltaX) * minWheelStep;
				}
			} else if (evt.deltaX) {
				/* For other browsers that don't provide wheelDelta, use the deltaY to determine direction and pass default values. */
				scrollDeltaX = this._clampAxisCoords(evt.deltaX, -1, 1);
			}

			/** Get delta for the Y axis*/
			if (evt.wheelDeltaY) {
				/* Option supported on Chrome, Safari, Opera.
				/* 120 is default for mousewheel on these browsers. Other values are for trackpads */
				scrollDeltaY = -evt.wheelDeltaY / 120;

				/** S.K. Fix for Issue #1438 When using trackpad the scroll amount could be less than 1 px, but scrollTop receives only integers, so we need to have it scroll minimum 1 px */
				if (-minWheelStep < scrollDeltaY && scrollDeltaY < minWheelStep) {
					scrollDeltaY = Math.sign(scrollDeltaY) * minWheelStep;
				}
			} else if (evt.deltaY) {
				/* For other browsers that don't provide wheelDelta, use the deltaY to determine direction and pass default values. */
				scrollDeltaY = this._clampAxisCoords(evt.deltaY, -1, 1);
			}

			if (this.options.smoothing) {
				if (scrollDeltaX) {
					this._scrollToX(this._startX + scrollDeltaX * scrollStep, true);
				} else {
					//Scroll with small inertia
					this._smoothWheelScrollY(scrollDeltaY);
				}
			} else {
				if (this._bMixedEnvironment) {
					scrolledY = this._scrollToXY(
						this._startX + scrollDeltaX * scrollStep,
						this._startY + scrollDeltaY * scrollStep,
						true
					).y;
				} else {
					scrolledY = this._scrollTouchToXY(
						this._startX,
						this._startY + scrollDeltaY * scrollStep,
						true
					).y;
				}

				if (!this._cancelScrolling) {
					//Trigger scrolled event
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 0,
						bigIncrement: 0,
						horizontal: false
					});
				}

				return !scrolledY;
			}

			return false;
		},

		_onPointerDownContainer: function (event) {
			var evt = event.originalEvent;
			if (!evt || (evt.pointerType !== 2 && evt.pointerType !== "touch") ||
				typeof MSGesture !== "function") {
				return true;
			}

			//setPointerCaptureFName is the name of the function that is supported
			event.target[ setPointerCaptureFName ](this._pointer = evt.pointerId);

			//create gestureObject only one time to prevent overlapping during intertia
			if (!this._gestureObject) {
				this._gestureObject = new MSGesture();
				this._gestureObject.target = this._container[ 0 ];
			}
			this._gestureObject.addPointer(this._pointer);
		},

		_onPointerUpContainer: function (event) {
			if (!this._pointer) {
				return true;
			}
			/* releasePointerCaptureFName is the name of the function that is supported */
			event.target[ releasePointerCaptureFName ](this._pointer);

			delete this._pointer;
		},

		_onMSGestureStartContainer: function (event) {
			if (this.options.scrollOnlyVBar) {
				this._startX = this._getScrollbarHPosition();
				this._startY = this._getScrollbarVPosition();
			} else {
				this._startX = this._getContentPositionX();
				this._startY = this._getContentPositionY();
			}

			this._touchStartX = event.originalEvent.screenX;
			this._touchStartY = event.originalEvent.screenY;
			this._moving = true;

			//Vars regarding swipe offset
			this._totalMovedX = 0;
			this._offsetRecorded = false;
			this._offsetDirection = 0;
		},

		_onMSGestureChangeContainer: function (event) {
			var touchPos = event.originalEvent,
				destX = this._startX + this._touchStartX - touchPos.screenX,
				destY = this._startY + this._touchStartY - touchPos.screenY;
			/* Logic regarding x tolerance to prevent accidental horizontal scrolling when scrolling vertically */
			this._totalMovedX = this._touchStartX - touchPos.screenX;
			if (Math.abs(this._totalMovedX) < this.options.swipeToleranceX && !this._offsetRecorded) {
				/* Do not scroll horizontally yet while in the tolerance range */
				if (this._bMixedEnvironment) {
					this._scrollToXY(this._startX, destY, true);
				} else {
					this._scrollTouchToXY(this._startX, destY, true);
				}
			} else {
				if (!this._offsetRecorded) {
					this._offsetDirection = Math.sign(destX - this._startX);
					this._offsetRecorded = true;
				}
				/* Once the tolerance is exceeded it can be scrolled horizontally */
				if (this._bMixedEnvironment) {
					this._scrollToXY(destX - this._offsetDirection * this.options.swipeToleranceX, destY, true);
				} else {
					this._scrollTouchToXY(
						destX - this._offsetDirection * this.options.swipeToleranceX,
						destY,
						true
					);
				}
			}
			this._moving = true;
		},

		_onMSGestureEndContainer: function () {
			this._moving = false;
		},

		_onTouchStartContainer: function (event) {
			if (event.isDefaultPrevented() || typeof MSGesture === "function") {
				return;
			}

			//stops any current ongoing inertia
			cancelAnimationFrame(this._touchInertiaAnimID);

			var touch = event.originalEvent.touches[ 0 ];

			if (this.options.scrollOnlyHBar) {
				this._startX = this._getScrollbarHPosition();
			} else {
				this._startX = this._getContentPositionX();
			}
			if (this.options.scrollOnlyVBar) {
				this._startY = this._getScrollbarVPosition();
			} else {
				this._startY = this._getContentPositionY();
			}

			this._touchStartX = touch.pageX;
			this._touchStartY = touch.pageY;

			this._speedDecreasing = false;

			this._lastTouchEnd = new Date().getTime();
			this._lastTouchX = touch.pageX;
			this._lastTouchY = touch.pageY;
			this._savedSpeedsX = [];
			this._savedSpeedsY = [];

			//Vars regarding swipe offset
			this._totalMovedX = 0;
			this._offsetRecorded = false;
			this._offsetDirection = 0;

			this._igScollTouchPrevented = false;
		},

		_onTouchMoveContainer: function (event) {
			if (event.isDefaultPrevented() || this._igScollTouchPrevented ||
					typeof MSGesture === "function") {
				this._igScollTouchPrevented = false;
				return;
			}
			var touch = event.originalEvent.touches[ 0 ];
			var destX =
				this._startX + (this._touchStartX - touch.pageX) * Math.sign(this.options.inertiaStep);
			var destY =
				this._startY + (this._touchStartY - touch.pageY) * Math.sign(this.options.inertiaStep);

			/*Handle complex touchmoves when swipe stops but the toch doesn't end and then a swipe is initiated again */
			/***********************************************************/
			var speedSlopeX = this._getSpeedSlope(this._savedSpeedsX);
			var speedSlopeY = this._getSpeedSlope(this._savedSpeedsY);

			if (speedSlopeY > -0.1 || speedSlopeX > -0.1) {
				this._speedDecreasing = true;
			} else {
				this._speedDecreasing = false;
			}

			var timeFromLastTouch = (new Date().getTime()) - this._lastTouchEnd;
			if (timeFromLastTouch !== 0 && timeFromLastTouch < 100) {
				var speedX = (this._lastTouchX - touch.pageX) / timeFromLastTouch;
				var speedY = (this._lastTouchY - touch.pageY) / timeFromLastTouch;

				//Save the last 5 speeds between two touchmoves on X axis
				if (this._savedSpeedsX.length < 5) {
					this._savedSpeedsX.push(speedX);
				} else {
					this._savedSpeedsX.shift();
					this._savedSpeedsX.push(speedX);
				}

				//Save the last 5 speeds between two touchmoves on Y axis
				if (this._savedSpeedsY.length < 5) {
					this._savedSpeedsY.push(speedY);
				} else {
					this._savedSpeedsY.shift();
					this._savedSpeedsY.push(speedY);
				}
			}
			this._lastTouchEnd = new Date().getTime();
			this._lastMovedX = this._lastTouchX - touch.pageX;
			this._lastMovedY = this._lastTouchY - touch.pageY;
			this._lastTouchX = touch.pageX;
			this._lastTouchY = touch.pageY;
			/***********************************************************/

			this._totalMovedX += this._lastMovedX;

			var scrolledXY; // Object: {x, y}
			/*	Do not scroll using touch untill out of the swipeToleranceX bounds */
			if (Math.abs(this._totalMovedX) < this.options.swipeToleranceX && !this._offsetRecorded) {
				if (navigator.userAgent.indexOf("Firefox") > -1 || this._bMixedEnvironment) {
					//Better performance on Firefox for Android
					scrolledXY = this._scrollToXY(this._startX, destY, true);
				} else {
					scrolledXY = this._scrollTouchToXY(this._startX, destY, true);
				}
			} else {
				/*	Record the direction the first time we are out of the swipeToleranceX bounds.
				*	That way we know which direction we apply the offset so it doesn't hickup when moving out of the swipeToleranceX bounds */
				if (!this._offsetRecorded) {
					this._offsetDirection = Math.sign(destX - this._startX);
					this._offsetRecorded = true;
				}

				/*	Scroll with offset ammout of swipeToleranceX in the direction we have exited the bounds and don't change it after that ever until touchend and again touchstart */
				if (navigator.userAgent.indexOf("Firefox") > -1 || this._bMixedEnvironment) {
					//Better performance on Firefox for Android
					scrolledXY = this._scrollToXY(destX - this._offsetDirection * this.options.swipeToleranceX,
												destY,
												true);
				} else {
					scrolledXY =
						this._scrollTouchToXY(destX - this._offsetDirection * this.options.swipeToleranceX,
											destY,
											true);
				}
			}

			if (scrolledXY.x === 0 && scrolledXY.y === 0) {
				this._igScollTouchPrevented = true;
			}

			//On Safari preventing the touchmove would prevent default page scroll behaviour even if there is the element doesn't have overflow
			if (!this._igScollTouchPrevented && event.cancelable) {
				this._showScrollbars(true);
				event.preventDefault();
			}
		},

		_onTouchEndContainer: function (event) {
			if (event.isDefaultPrevented() || typeof MSGesture === "function") {
				return;
			}
			var speedX = 0;
			var speedY = 0;

			//savedSpeedsX and savedSpeedsY have same length
			for (var i = 0; i < this._savedSpeedsX.length; i++) {
				speedX += this._savedSpeedsX[ i ];
				speedY += this._savedSpeedsY[ i ];
			}
			speedX = this._savedSpeedsX.length ? speedX / this._savedSpeedsX.length : 0;
			speedY = this._savedSpeedsX.length ? speedY / this._savedSpeedsY.length : 0;

			//Use the lastMovedX and lastMovedY to determine if the swipe stops without lifting the finger so we don't start inertia
			if ((Math.abs(speedX) > 0.1 || Math.abs(speedY) > 0.1) &&
					(Math.abs(this._lastMovedX) > 2 || Math.abs(this._lastMovedY) > 2)) {
				this._showScrollbars(true);
				this._inertiaInit(speedX, speedY, this._bMixedEnvironment);
			} else {
				this._hideScrollbars();

				if (!this._cancelScrolling) {
					//Trigger scrolled event
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 0,
						bigIncrement: 0,
						horizontal: null
					});
				}
			}
		},

		_onMouseEnterContainer: function () {
			this._mOverContainer = true;

			cancelAnimationFrame(this._showScrollbarsAnimId);
			clearTimeout(this._hideScrollbarID);
			if (!this._toSimpleScrollbarsID && !this._bMouseDownH && !this._bMouseDownV) {
				//We move the mouse inside the container but we weren't previously hovering the scrollbars (that's why we don't have _toSimpleScrollbarsID for a timeout to switch to simple scrollbars).
				//So we instantly show simple scrollbars.
				this._showScrollbars(true);
			}
		},

		_onMouseLeaveContainer: function () {
			var self = this;

			this._mOverContainer = false;
			if (!this._bMouseDownV && !this._bMouseDownH) {
				clearTimeout(this._toSimpleScrollbarsID);
				this._toSimpleScrollbarsID = 0;

				//Hide scrollbars after 2 secs. We cencel the timeout if we enter scrollbars area.
				this._hideScrollbarID = setTimeout(function () {
					self._hideScrollbars();
				}, 2000);
			}
		},

		_onDimensionsChange: function () {
			var bNoCancel,
				evtArgs = {	owner: this };

			bNoCancel = this._trigger("resizing", null, evtArgs);
			if (bNoCancel) {
				this.refresh();

				this._trigger("resized", null, evtArgs);
			}
		},

		_onElementMutation: function (mutations) {
			for (var index = 0; index < mutations.length; index++) {
				/*	Make sure only the style is addressed and that any of the width/height is changed. */
				/*	The elemWidth/elemHeight are not updated until refresh is called, that is why we can use them as old values. */
				if (mutations[ index ].attributeName === "style" &&
					(this._elemWidth !== this.element.width() ||
						this._elemHeight !== this.element.height())) {
					this._onDimensionsChange();
				}
			}
		},

		_updateScrollBarsVisibility: function () {
			var bRenderScrollbarV = this._isScrollableV &&
									this._renderVerticalScrollbar,
				bRenderScrollbarH = this._isScrollableH &&
									this._renderHorizontalScrollbar,
				bRemoveScrollbarV = (!this._isScrollableV || !this._renderVerticalScrollbar) &&
									this._vBarContainer,
				bRemoveScrollbarH = (!this._isScrollableH || !this._renderHorizontalScrollbar) &&
									this._hBarContainer;
			if (this.options.scrollbarType === "none") {
				return;
			}

			if (this.options.scrollbarType === "native") {
				if (bRenderScrollbarV && !this._vBarContainer) {
					this._initNativeScrollBarV(bRenderScrollbarH);
				} else if (bRemoveScrollbarV) {
					this._removeVerticalScrollbar();
				}
				if (bRenderScrollbarH && !this._hBarContainer) {
					this._initNativeScrollBarH(bRenderScrollbarV);
				} else if (bRemoveScrollbarH) {
					this._removeHorizontalScrollbar();
				}

				//In case we no longer have both native scrollbars. Only for native scrollbars theere is filler on the bottom right angle between the scrollbars
				if ((!this._vBarContainer || !this._hBarContainer) && this._desktopFiller) {
					this._desktopFiller.remove();
					this._desktopFiller = null;
				}
			} else if (this.options.scrollbarType === "custom") {
				if (bRenderScrollbarV && !this._vBarContainer) {
					this._initCustomScrollBarV(bRenderScrollbarH);
				} else if (bRemoveScrollbarV) {
					this._removeVerticalScrollbar();
				}
				if (bRenderScrollbarH && !this._hBarContainer) {
					this._initCustomScrollBarH(bRenderScrollbarV);
				} else if (bRemoveScrollbarH) {
					this._removeHorizontalScrollbar();
				}

				if ($.ig.util.isTouchDevice()) {
					this._toSimpleScrollbars();
				}
			}
		},

		_initNativeScrollBarV: function (bRenderScrollbarH) {
			var css = this.css,
				nativeScrollSize = $.ig.util.getScrollWidth();

			this._vBarContainer = $("<div id='" + this.element.attr("id") + "_vBar'></div>")
				.addClass(css.nativeVScrollOuter);
			/* Use auto sizing by setting only top and bottom absolute positions, without height */
			if (!bRenderScrollbarH) {
				this._vBarContainer.addClass(css.nativeVScrollOuterSingle);
			} else {
				this._vBarContainer.css("bottom", nativeScrollSize + "px");
			}

			/* We need the height without the padding, so we have proper scroll position */
			this._vDragHeight = this._content.height();
			this._vBarDrag = $("<div id='" + this.element.attr("id") + "_vBar_inner'></div>")
				.addClass(css.nativeVScrollInner)
				.css("height", this._vDragHeight + "px");

			if (this.options.scrollbarVParent) {
				this._vBarContainer.append(this._vBarDrag).appendTo(this.options.scrollbarVParent);
			} else {
				this._vBarContainer.append(this._vBarDrag).appendTo(this._container[ 0 ].parentElement);
			}

			if ($.ig.util.getScrollHeight() > 0 && this.options.modifyDOM) {
				this._content.css("padding-right", nativeScrollSize + "px");
			}

			//Only for native desktop scrollbars there is filler on the bottom right angle between the scrollbars
			if (bRenderScrollbarH && this._bMixedEnvironment && !this._desktopFiller) {
				this._desktopFiller = $("<div id='" + this.element.attr("id") + "_scrollbarFiller'></div>")
					.addClass(css.nativeScrollFiller)
					.css("height", nativeScrollSize + "px")
					.css("width", nativeScrollSize + "px");
				this._desktopFiller.appendTo(this._container[ 0 ].parentElement);
			}

			/* Set the scrollbar position before linking it to the igScroll */
			this._vBarContainer.scrollTop(this._getContentPositionY());
			this._setOption("scrollbarV", this._vBarContainer);
		},

		_initNativeScrollBarH: function (bRenderScrollbarV) {
			var css = this.css,
				nativeScrollSize = $.ig.util.getScrollWidth();

			this._hBarContainer = $("<div id='" + this.element.attr("id") + "_hBar'></div>")
				.addClass(css.nativeHScrollOuter);
			/* Use auto sizing by setting only left and right absolute positions, without width */
			if (!bRenderScrollbarV) {
				this._hBarContainer.addClass(css.nativeHScrollOuterSingle);
			} else {
				this._hBarContainer.css("right", nativeScrollSize + "px");
			}

			/* We need the width without the padding, so we have proper scroll position */
			this._hDragWidth = this._content.width();
			this._hBarDrag = $("<div id='" + this.element.attr("id") + "_hBar_inner'></div>")
				.addClass(css.nativeHScrollInner)
				.css("width", this._hDragWidth + "px");

			if (this.options.scrollbarHParent) {
				this._hBarContainer.append(this._hBarDrag).appendTo(this.options.scrollbarHParent);
			} else {
				this._hBarContainer.append(this._hBarDrag).appendTo(this._container[ 0 ].parentElement);
			}

			if (nativeScrollSize > 0 && this.options.modifyDOM) {
				this._content.css("padding-bottom", nativeScrollSize + "px");
			}

			//Only for native desktop scrollbars there is filler on the bottom right angle between the scrollbars
			if (bRenderScrollbarV && this._bMixedEnvironment && !this._desktopFiller) {
				this._desktopFiller = $("<div id='" + this.element.attr("id") + "_scrollbarFiller'></div>")
					.addClass(css.nativeScrollFiller)
					.css("height", nativeScrollSize + "px")
					.css("width", nativeScrollSize + "px");
				this._desktopFiller.appendTo(this._container[ 0 ].parentElement);
			}

			/* Set the scrollbar position before linking it to the igScroll */
			this._hBarContainer.scrollLeft(this._getContentPositionX());
			this._setOption("scrollbarH", this._hBarContainer);
		},

		_removeScrollbars: function() {
			this._removeVerticalScrollbar();
			this._removeHorizontalScrollbar();

			//In case we have native scrollbars and we have added padding. Only for native scrollbars theere is filler on the bottom right angle between the scrollbars
			if (this._desktopFiller) {
				this._desktopFiller.remove();
				this._desktopFiller = null;
				this._content
					.css("padding-right", "0px")
					.css("padding-bottom", "0px");
			}
		},

		_removeVerticalScrollbar: function() {
			if (this._vBarContainer) {
				this._vBarContainer.remove();
				this._vBarContainer = null;
				this._vDragHeight = null;
				this._vBarDrag = null;
				this._vBarTrack = null;

				if (this.options.modifyDOM && this.options.scrollbarType === "native") {
					this._content.css("padding-right", "");
				}
			}
			if (this._onMouseMoveVDragHandler) {
				$("body").off("mousemove.igscroll_" + this.element[ 0 ].id, this._onMouseMoveVDragHandler);
			}
			if (this._onMouseUpVScrollbarHandler) {
				$(window).off("mouseup.igscroll_" + this.element[ 0 ].id, this._onMouseUpVScrollbarHandler);
			}
		},

		_removeHorizontalScrollbar: function() {
			if (this._hBarContainer) {
				this._hBarContainer.remove();
				this._hBarContainer = null;
				this._hDragHeight = null;
				this._hBarDrag = null;
				this._hBarTrack = null;

				if (this.options.modifyDOM && this.options.scrollbarType === "native") {
					this._content.css("padding-bottom", "");
				}
			}
			if (this._onMouseMoveHDragHandler) {
				$("body").off("mousemove.igscroll_" + this.element[ 0 ].id, this._onMouseMoveHDragHandler);
			}
			if (this._onMouseUpHScrollbarHandler) {
				$(window).off("mouseup.igscroll_" + this.element[ 0 ].id, this._onMouseUpHScrollbarHandler);
			}
		},

		/** Initialize the custom vertical scrollbar
			bRenderScrollbarH - gets wheter or not the horizontal scrollbar will be rendered as well
		*/
		_initCustomScrollBarV: function (bRenderScrollbarH) {
			var css = this.css;

			this._vBarContainer = $("<div id='" + this.element.attr("id") + "_vBar'></div>")
				.addClass(css.verticalScrollContainer);

			this._vBarArrowUp =	$("<div id='" +	this.element.attr("id") + "_vBar_arrowUp'></div>")
				.addClass(css.verticalScrollArrow)
				.addClass(css.verticalScrollArrowUp);

			this._vBarTrack = $("<div id='" + this.element.attr("id") + "_vBar_track'></div>")
				.addClass(css.verticalScrollTrack);

			this._vBarArrowDown = $("<div id='" + this.element.attr("id") +	"_vBar_arrowDown'></div>")
				.addClass(css.verticalScrollArrow)
				.addClass(css.verticalScrollArrowDown);

			if (!bRenderScrollbarH) {
				this._vBarTrack.addClass(css.verticalScrollTrackSingleScrollbar);
				this._vBarArrowDown.addClass(css.verticalScrollArrowDownSingleScrollbar);
			}

			if (this.options.scrollbarVParent) {
				this._vBarContainer
					.append(this._vBarArrowUp)
					.append(this._vBarTrack.append(this._vBarDrag))
					.append(this._vBarArrowDown)
					.appendTo(this.options.scrollbarVParent);
			} else {
				this._vBarContainer
					.append(this._vBarArrowUp)
					.append(this._vBarTrack.append(this._vBarDrag))
					.append(this._vBarArrowDown)
					.appendTo(this._container[ 0 ].parentElement);
			}

			this._vDragHeight = this._calculateVDragHeight();
			this._vBarDrag = $("<span id='" + this.element.attr("id") + "_vBar_drag'></span>")
				.addClass(css.verticalScrollThumbDrag + " " + css.verticalScrollThumbDragThin)
				.css("height", this._vDragHeight + "%");

			if (this.options.scrollbarVParent) {
				this._vBarTrack.append(this._vBarDrag);
			} else {
				this._vBarTrack.append(this._vBarDrag);
			}

			this._bindCustomScrollBarV();
		},

		/** Calculates the vertical drag height and returns it in percents based on the vertical track height*/
		_calculateVDragHeight: function () {
			var dragHeightPx,
				minSize = parseInt(this.options.minThumbSize, 10);

			//Calculate horizontal drag width in px first. If it is less than the minimum use the miminum width.
			dragHeightPx = (this._vBarTrack.height() / this._contentHeight) * this._vBarTrack.height();
			dragHeightPx = (dragHeightPx < minSize ? minSize : dragHeightPx);

			//Turn it into percents.
			return (dragHeightPx / this._vBarTrack.height()) * 100;
		},

		_bindCustomScrollBarV: function() {
			this._holdTimeoutID = 0;
			this._bMouseDownV = false; //Used to track if mouse is holded on any of the vertical scrollbar elements
			this._bUseArrowUp = false; //Used to distinquis which on which element left mouse if being hold
			this._bUseArrowDown = false; //Used to distinquis which on which element left mouse if being hold
			this._mouseLastY = 0; //Determines the last position of the thumb drag for the horizontal scrollbar
			this._dragLastY = 0; //Used to save the last position of the vertical drag. This is needed because getting the position during scroll on Edge/Firefox is not reliable
			this._bUseVDrag = false; //Used to distinquis which on which element left mouse if being hold
			this._bUseVTrack = false; //Determines if the vertical track area is being used
			this._lastBigIncDirV = 0; //Used to determine the last direction of the scroll when using the scrollbar track area
			this._mTrackLastPosV = 0; //Last know position of the mouse when interacting with the vertical track area

			if (this._vBarArrowUp)  {
				this._vBarArrowUp.on({
					mousedown: this._onMouseDownArrowUp.bind(this),
					mouseup: this._onMouseUpArrowUp.bind(this),
					mouseover: this._onMouseOverArrowUp.bind(this),

					mouseout: this._onMouseOutScrollbarArrow.bind(this),
					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._vBarArrowDown) {
				this._vBarArrowDown.on({
					mousedown: this._onMouseDownArrowDown.bind(this),
					mouseup: this._onMouseUpArrowDown.bind(this),
					mouseover: this._onMouseOverArrowDown.bind(this),

					mouseout: this._onMouseOutScrollbarArrow.bind(this),
					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._vBarDrag) {
				this._vBarDrag.on({
					mousedown: this._onMouseDownVDrag.bind(this),

					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._vBarTrack) {
				this._vBarTrack.on({
					mousedown: this._onMouseDownVTrack.bind(this),
					mousemove: this._onMouseMoveVTrack.bind(this),
					mouseup: this._onMouseUpVTrack.bind(this),
					mouseout: this._onMouseOutVTrack.bind(this),

					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._vBarContainer) {
				this._vBarContainer.on({
					dragstart: this._onDragStartElem.bind(this),
					wheel: this._onWheelContainer.bind(this),
					mouseenter: this._onMouseEnterScrollbarElem.bind(this),
					mouseleave: this._onMouseLeaveScrollbarElem.bind(this)
				});
			}

			this._onMouseMoveVDragHandler = this._onMouseMoveVDrag.bind(this);
			this._onMouseUpVScrollbarHandler = this._onMouseUpVScrollbar.bind(this);
			/* We bind it to the body to be able to detect while holding the Thumb Drag and moving out of the scrollbar area. It should still scroll while still holding and moving inside the window */
			$("body").on("mousemove.igscroll_" + this.element[ 0 ].id, this._onMouseMoveVDragHandler);
			/* We bind it to the wondow to be able to determine while the user releases the mouse even when it is out of the browser window */
			$(window).on("mouseup.igscroll_" + this.element[ 0 ].id, this._onMouseUpVScrollbarHandler);
		},

		/** Used when one of the Arrow Up/Down or Vertical Track is being used by holding mouse button on them to constantly scroll on the Y axis */
		_scrollTimeoutY: function (step, bSmallIncement) {
			var	curPosY = this._getContentPositionY();
			if ((curPosY === 0 && step <= 0) ||
				(curPosY === this._getContentHeight() - this._getContainerHeight() && step >= 0)) {
				return;
			}

			var	bNoCancel,
				eventArgs = {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: false,
					stepX: 0,
					stepY: step
				};

			//Check if the increment is big or small and set the proper value in the eventArgs
			if (bSmallIncement) {
				/* set event vars */
				eventArgs.smallIncrement = Math.sign(step);
			} else {
				/* Check of the mouse is over the vertical thumb drag. This means it has reached the position of where the mouse is currently held (on the vertical track) and scrolling should stop. */
				var dragStartY = this._getTransform3dValueY(this._vBarDrag);
				if (this._mTrackLastPosV > dragStartY &&
					this._mTrackLastPosV < dragStartY + this._vDragHeight) {

					return;
				}

				/* set event vars */
				eventArgs.bigIncrement = Math.sign(step);
				this._lastBigIncDirV = Math.sign(step);
			}
			bNoCancel = this._trigger("scrolling", null, eventArgs);

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;
			if (bNoCancel) {
				this._scrollTop(curPosY + step, false);

				var self = this;
				this._holdTimeoutID = setTimeout(function () {
					self._scrollTimeoutY(step, bSmallIncement);
				}, 50);
			}
		},

		_onMouseDownArrowUp: function () {
			var scrollStep = -this.options.smallIncrementStep,
				curPosY = this._getContentPositionY();
			if (curPosY === 0) {
				scrollStep = 0;
			}

			var	bNoCancel = this._trigger("scrolling", null, {
				owner: this,
				smallIncrement: -1,
				bigIncrement: 0,
				horizontal: false,
				stepX: 0,
				stepY: scrollStep
			});

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;

			if (bNoCancel) {
				this._bMouseDownV = true;
				this._bUseArrowUp = true;
				this._scrollTop(curPosY + scrollStep, false);

				var self = this;
				this._holdTimeoutID = setTimeout(function () {
					self._scrollTimeoutY(scrollStep, true);
				}, 250);
			}
		},

		_onMouseUpArrowUp: function() {
			this._bMouseDownV = false;
			this._bUseArrowUp = true; //We later set it to false with mouseup event of window
			clearTimeout(this._holdTimeoutID);
		},

		_onMouseOverArrowUp: function() {
			if (this._bMouseDownV && this._bUseArrowUp) {
				this._scrollTimeoutY(-40, true);
			}
		},

		_onMouseOutScrollbarArrow: function () {
			clearTimeout(this._holdTimeoutID);
		},

		_onMouseDownArrowDown: function () {
			var scrollStep = this.options.smallIncrementStep,
				curPosY = this._getContentPositionY();
			if (curPosY === this._getContentHeight() - this._getContainerHeight()) {
				scrollStep = 0;
			}

			var bNoCancel = this._trigger("scrolling", null, {
				owner: this,
				smallIncrement: 1,
				bigIncrement: 0,
				horizontal: false,
				stepX: 0,
				stepY: scrollStep
			});

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;

			if (bNoCancel) {
				this._bMouseDownV = true;
				this._bUseArrowDown = true;

				this._scrollTop(curPosY + scrollStep, false);

				var self = this;
				this._holdTimeoutID = setTimeout(function () {
					self._scrollTimeoutY(scrollStep, true);
				}, 250);
			}
		},

		_onMouseUpArrowDown: function() {
			this._bMouseDownV = false;
			this._bUseArrowDown = true; //We later set it to false with mouseup event of window
			clearTimeout(this._holdTimeoutID);
		},

		_onMouseOverArrowDown: function() {
			if (this._bMouseDownV && this._bUseArrowDown) {
				this._scrollTimeoutY(40, true);
			}
		},

		_onMouseDownVDrag: function (event) {
			this._bMouseDownV = true;
			this._mouseLastY = event.pageY;
			this._bUseVDrag = true;
			this._bUseHDrag = false;

			this._trigger("thumbDragStart", null, {
				owner: this,
				horizontal: false
			});
			this._disableContentSelection();
		},

		_onMouseDownVTrack: function (event) {
			if (event.target.id === this._vBarDrag[ 0 ].id) {
				return true;
			}

			this._bUseVTrack = true;

			var	self = this,
				dragStartY = this._getTransform3dValueY(this._vBarDrag),
				curPosY = this._getContentPositionY(),
				scrollStep = this.options.bigIncrementStep === null ?
								this._elemHeight :
								this.options.bigIncrementStep,
				bNoCancel;

			this._mTrackLastPosV = event.offsetY;
			if (event.offsetY > dragStartY + this._vDragHeight) {
				/* Scroll down */
				this._lastBigIncDirV = 1;
				bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 1,
					horizontal: false,
					stepX: 0,
					stepY: scrollStep
				});

				//should scrolled event be triggered
				this._cancelScrolling = !bNoCancel;

				if (bNoCancel) {
					this._scrollTop(curPosY + scrollStep, false);
					this._holdTimeoutID = setTimeout(function () {
						self._scrollTimeoutY(scrollStep, false);
					}, 250);
				}
			} else if (event.offsetY < dragStartY) {
				/* Scroll up */
				this._lastBigIncDirV = -1;
				bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: -1,
					horizontal: false,
					stepX: 0,
					stepY: -scrollStep
				});

				if (bNoCancel) {
					this._scrollTop(curPosY - scrollStep, false);
					this._holdTimeoutID = setTimeout(function () {
						self._scrollTimeoutY(-scrollStep, false);
					}, 250);
				}
			}
		},

		_onMouseMoveVTrack: function(event) {
			//Update the last know position of the mouse that is interacting with the vertical track area
			if (this._bUseVTrack) {
				this._mTrackLastPosV = event.offsetY;
			}
		},

		_onMouseUpVTrack: function() {
			clearTimeout(this._holdTimeoutID);

			if (this._bUseVTrack && !this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: this._lastBigIncDirV,
					horizontal: false
				});
			}
			this._bUseVTrack = false;
		},

		_onMouseOutVTrack: function() {
			clearTimeout(this._holdTimeoutID);

			if (this._bUseVTrack && !this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: this._lastBigIncDirV,
					horizontal: false
				});
			}
			this._bUseVTrack = false;
		},

		_onMouseMoveVDrag: function (event) {
			/* Ensures if we move the mouse of the bounds of the vertical scroll bar and we are still holding left mouse button that when we move the mouse up/down we will continue to scroll */
			if (!this._bMouseDownV || !this._bUseVDrag) {
				return true;
			}

			if (this._bUseVDrag) {
				var curPosY = this._getContentPositionY(),
					offset = event.pageY - this._mouseLastY,
					dragbPosY = this._dragLastY,
					nextPosY;

				/**	Using linear interpolation to determine position of the content relative to the viewport based on the next drag position.
				  *	Drag pos c in (a,b),  next scroll pos z in (x, y) => z = (c - a) / (b - a) * (y - x) + x = (c / b) * y , because a = 0 and x = 0. */
				nextPosY = ((dragbPosY + offset) / (this._vBarTrack.height() - this._vBarDrag.height())) *
							(this._getContentHeight() - this.element.height());
				nextPosY = this._clampAxisCoords(nextPosY, 0,
							Math.max(this._getContentHeight() - this._getContainerHeight(), 0));
				var bNoCancel = this._trigger("thumbDragMove", null, {
					owner: this,
					horizontal: false,
					stepX: 0,
					stepY: nextPosY - curPosY
				});

				//should thumbDragEnd be triggered
				this._cancelThumbDrag = !bNoCancel;

				if (bNoCancel) {
					//Move custom vertical scrollbar thumb drag
					this._scrollToY(nextPosY, true);
					this._mouseLastY = event.pageY;
					this._dragLastY = dragbPosY + offset;
				}
			}
		},

		_onMouseUpVScrollbar: function () {
			var self = this;

			/* Ensures when the left mouse button is realeas that all properties are back to their default state */
			/* Works even if the mouse is out of the browser boundries and we release the left mouse button */
			if (this._bUseArrowUp) {
				this._bUseArrowUp = false;

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: -1,
						bigIncrement: 0,
						horizontal: false
					});
				}
			}
			if (this._bUseArrowDown) {
				this._bUseArrowDown = false;

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 1,
						bigIncrement: 0,
						horizontal: false
					});
				}
			}

			//If the mouse was previously hold over an element an we release it.
			if (this._bMouseDownV && !this._mOverScrollbars && !this._mOverContainer) {
				/** Scenario:
				*	1. Click and hold a horizontal scrollbar element
				*	2. Move the mouse outside the scrollable container
				*	3. Release the mouse
				*
				*	We hide the scrollbar after 2 secs since the mouse is outside the scrollable content
				*/
				this._hideScrollbarID = setTimeout(function () {
					self._hideScrollbars();
				}, 2000);
			} else if (this._bMouseDownV && !this._mOverScrollbars && this._mOverContainer) {
				/** Scenario:
				*	1. Click and hold a horizontal scrollbar element
				*	2. Move the mouse inside the scrollable container
				*	3. Release the mouse
				*
				*	We don't hide the scrollbar this time but switch to simple after 2 secs
				*/
				this._toSimpleScrollbarsID = setTimeout(function () {
					self._toSimpleScrollbars();
					self._toSimpleScrollbarsID = 0;
				}, 2000);
			}
			this._bMouseDownV = false;

			if (this._bUseVDrag) {
				/** Get the actual position on mouseup because we may have moved too much out and using the thumb right after will have offset */
				this._dragLastY = this._getTransform3dValueY(this._vBarDrag);

				if (!this._cancelThumbDrag) {

					this._trigger("thumbDragEnd", null, {
						owner: this,
						horizontal: false
					});
				}

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 0,
						bigIncrement: 0,
						horizontal: true
					});
				}
				this._enableContentSelection();
			}
			this._bUseVDrag = false;
		},

		/** Initialize the custom horizontal scrollbar
			bRenderScrollbarV - gets wheter or not the vertical scrollbar will be rendered as well
		*/
		_initCustomScrollBarH: function (bRenderScrollbarV) {
			var css = this.css;

			this._hBarContainer = $("<div id='" + this.element.attr("id") + "_hBar'></div>")
				.addClass(css.horizontalScrollContainer);

			this._hBarArrowLeft = $("<div id='" + this.element.attr("id") + "_hBar_arrowLeft'></div>")
				.addClass(css.horizontalScrollArrow)
				.addClass(css.horizontalScrollArrowLeft);

			this._hBarTrack = $("<div id='" + this.element.attr("id") + "_hBar_track'></div>")
				.addClass(css.horizontalScrollTrack);

			this._hBarArrowRight = $("<div id='" + this.element.attr("id") + "_hBar_arrowRight'></div>")
				.addClass(css.horizontalScrollArrow)
				.addClass(css.horizontalScrollArrowRight);

			if (!bRenderScrollbarV) {
				this._hBarTrack.addClass(css.horizontalScrollTrackSingleScrollbar);
				this._hBarArrowRight.addClass(css.horizontalScrollArrowRightSingleScrollbar);
			}

			if (this.options.scrollbarHParent) {
				this._hBarContainer
					.append(this._hBarArrowLeft)
					.append(this._hBarTrack.append(this._hBarDrag))
					.append(this._hBarArrowRight)
					.appendTo(this.options.scrollbarHParent);
			} else {
				this._hBarContainer
					.append(this._hBarArrowLeft)
					.append(this._hBarTrack.append(this._hBarDrag))
					.append(this._hBarArrowRight)
					.appendTo(this._container[ 0 ].parentElement);
			}

			this._hDragWidth = this._calculateHDragWidth();
			this._hBarDrag = $("<span id='" + this.element.attr("id") + "_hBar_drag'></span>")
				.addClass(css.horizontalScrollThumbDrag + " " + css.horizontalScrollThumbDragThin)
				.css("width", this._hDragWidth + "%");

			if (this.options.scrollbarHParent) {
				this._hBarTrack.append(this._hBarDrag);
			} else {
				this._hBarTrack.append(this._hBarDrag);
			}

			this._bindCustomScrollBarH();
		},

		/** Calculates the horizontal drag width and returns it in percents based on the horizontal track width */
		_calculateHDragWidth: function ()
		{
			var dragWidthPx,
				minSize = parseInt(this.options.minThumbSize, 10);

			//Calculate horizontal drag width in px first. If it is less than the minimum use the miminum width.
			dragWidthPx = (this._hBarTrack.width() / this._contentWidth) * this._hBarTrack.width();
			dragWidthPx = (dragWidthPx < minSize ? minSize : dragWidthPx);

			//Turn it into percents.
			return (dragWidthPx / this._hBarTrack.width()) * 100;
		},
		_bindCustomScrollBarH: function () {
			this._holdTimeoutID = 0;
			this._bMouseDownH = false;
			this._bUseArrowLeft = false; //Used to distinquis which on which element left mouse if being hold
			this._bUseArrowRight = false; //Used to distinquis which on which element left mouse if being hold
			this._bUseHDrag = false; //Used to distinquis which on which element left mouse if being hold
			this._mouseLastX = 0; //Determines the last position of the thumb drag for the horizontal scrollbar
			this._dragLastX = 0; //Used to save the last position of the horizontal drag. This is needed because getting the position during scroll on Edge/Firefox is not reliable
			this._bUseHTrack = false; //Determines if the horizontal track area is being used
			this._lastBigIncDirH = 0; //Used to determine the last direction of the scroll when using the horizontal track area
			this._mTrackLastPosH = 0; //Last know position of the mouse when interacting with the horizontal track area

			if (this._hBarArrowLeft) {
				this._hBarArrowLeft.on({
					mousedown: this._onMouseDownArrowLeft.bind(this),
					mouseup: this._onMouseUpArrowLeft.bind(this),
					mouseover: this._onMouseOverArrowLeft.bind(this),

					mouseout: this._onMouseOutScrollbarArrow.bind(this),
					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._hBarArrowRight) {
				this._hBarArrowRight.on({
					mousedown: this._onMouseDownArrowRight.bind(this),
					mouseup: this._onMouseUpArrowRight.bind(this),
					mouseover: this._onMouseOverArrowRight.bind(this),

					mouseout: this._onMouseOutScrollbarArrow.bind(this),
					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._hBarDrag) {
				this._hBarDrag.on({
					mousedown: this._onMouseDownHDrag.bind(this),

					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._hBarTrack) {
				this._hBarTrack.on({
					mousedown: this._onMouseDownHTrack.bind(this),
					mousemove: this._onMouseMoveHTrack.bind(this),
					mouseup: this._onMouseUpHTrack.bind(this),
					mouseout: this._onMouseOutHTrack.bind(this),

					touchstart: this._onTouchStartScrollbarElem.bind(this)
				});
			}

			if (this._hBarContainer) {
				this._hBarContainer.on({
					dragstart: this._onDragStartElem.bind(this),
					wheel: this._onWheelContainer.bind(this),
					mouseenter: this._onMouseEnterScrollbarElem.bind(this),
					mouseleave: this._onMouseLeaveScrollbarElem.bind(this)
				});
			}

			this._onMouseMoveHDragHandler = this._onMouseMoveHDrag.bind(this);
			this._onMouseUpHScrollbarHandler = this._onMouseUpHScrollbar.bind(this);
			/* We bind it to the body to be able to detect while holding the Thumb Drag and moving out of the scrollbar area. It should still scroll while still holding and moving inside the window */
			$("body").on("mousemove.igscroll_" + this.element[ 0 ].id, this._onMouseMoveHDragHandler);
			/* We bind it to the wondow to be able to determine while the user releases the mouse even when it is out of the browser window */
			$(window).on("mouseup.igscroll_" + this.element[ 0 ].id, this._onMouseUpHScrollbarHandler);
		},

		/** Used when one of the Arrow Left/Right or Horizontal Track is being used by holding mouse button on them to constantly scroll on the X axis */
		_scrollTimeoutX: function (step, bSmallIncement) {
			var curPosX = this._getContentPositionX();
			if ((curPosX === 0 && step <= 0) ||
				(curPosX === this._getContentWidth() - this._getContainerWidth() && step >= 0)) {
				return;
			}

			var	self = this,
				bNoCancel,
				eventArgs = {
					owner: self,
					smallIncrement: 0,
					bigIncrement: 0,
					horizontal: true,
					stepX: step,
					stepY: 0
				};

			//Check if the increment is big or small and set the proper value in the eventArgs
			if (bSmallIncement) {
				eventArgs.smallIncrement = Math.sign(step);
			} else {
				var dragStartX = this._getTransform3dValueX(this._hBarDrag);

				//Check if the mouse is over the horizontal thumb drag. This means it has reached the position of where the mouse is currently held (on the horizontal track) and scrolling should stop.
				if (this._mTrackLastPosH > dragStartX &&
					this._mTrackLastPosH < dragStartX + this._hDragWidth) {
					return;
				}

				eventArgs.bigIncrement = Math.sign(step);
				this._lastBigIncDirH = Math.sign(step);
			}
			bNoCancel = this._trigger("scrolling", null, eventArgs);

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;

			if (bNoCancel) {
				//Scroll content
				var curPosY = this._getContentPositionX();
				this._scrollLeft(curPosY + step, false);

				this._holdTimeoutID = setTimeout(function () {
					self._scrollTimeoutX(step, bSmallIncement);
				}, 50);
			}
		},

		_onMouseDownArrowLeft: function () {
			var scrollStep = -this.options.smallIncrementStep,
				curPosX = this._getContentPositionX();

			if (curPosX === 0) {
				//We are at the top. Step should be 0
				scrollStep = 0;
			}

			var bNoCancel = this._trigger("scrolling", null, {
				owner: this,
				smallIncrement: -1,
				bigIncrement: 0,
				horizontal: true,
				stepX: scrollStep,
				stepY: 0
			});

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;

			if (bNoCancel) {
				this._bMouseDownH = true;
				this._bUseArrowLeft = true;

				this._scrollLeft(curPosX + scrollStep, false);

				var self = this;
				this._holdTimeoutID = setTimeout(function () {
					self._scrollTimeoutX(scrollStep, true);
				}, 250);
			}
		},

		_onMouseUpArrowLeft: function () {
			this._bMouseDownH = false;
			this._bUseArrowLeft = false;

			clearTimeout(this._holdTimeoutID);

			if (!this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: -1,
					bigIncrement: 0,
					horizontal: true
				});
			}
		},

		_onMouseOverArrowLeft: function () {
			if (this._bMouseDownH && this._bUseArrowLeft) {
				this._scrollTimeoutX(-40, true);
			}
		},

		_onMouseDownArrowRight: function () {
			var scrollStep = this.options.smallIncrementStep,
				curPosX = this._getContentPositionX();

			if (curPosX === this._getContentWidth() - this._getContainerWidth()) {
				//We are at the bottom
				scrollStep = 0;
			}

			var bNoCancel = this._trigger("scrolling", null, {
				owner: this,
				smallIncrement: 1,
				bigIncrement: 0,
				horizontal: true,
				stepX: scrollStep,
				stepY: 0
			});

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;

			if (bNoCancel) {
				this._bMouseDownH = true;
				this._bUseArrowRight = true;

				this._scrollLeft(curPosX + scrollStep, false);

				var self = this;
				this._holdTimeoutID = setTimeout(function () { self._scrollTimeoutX(scrollStep, true); }, 250);
			}
		},

		_onMouseUpArrowRight: function () {
			this._bMouseDownH = false;
			this._bUseArrowRight = false;

			clearTimeout(this._holdTimeoutID);

			if (!this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 1,
					bigIncrement: 0,
					horizontal: true
				});
			}
		},

		_onMouseOverArrowRight: function () {
			if (this._bMouseDownH && this._bUseArrowRight) {
				this._scrollTimeoutX(40, true);
			}
		},

		_onMouseDownHDrag: function (event) {
			this._bMouseDownH = true;
			this._mouseLastX = event.pageX;
			this._bUseVDrag = false;
			this._bUseHDrag = true;

			this._trigger("thumbDragStart", null, {
				owner: this,
				horizontal: true
			});
			this._disableContentSelection();
		},

		_onMouseDownHTrack: function (event) {
			if (event.target.id === this._hBarDrag[ 0 ].id) {
				return true;
			}

			this._bUseHTrack = true;

			var	self = this,
				dragStartX = this._getTransform3dValueX(this._hBarDrag),
				curPosX = this._getContentPositionX(),
				scrollStep = this.options.bigIncrementStep === null ?
								this._elemWidth :
								this.options.bigIncrementStep,
				bNoCancel;

			this._mTrackLastPosH = event.offsetX;
			if (event.offsetX > dragStartX + this._hDragWidth) {
				//Scroll right
				this._lastBigIncDirH = 1;
				bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: 1,
					horizontal: true,
					stepX: scrollStep,
					stepY: 0
				});

				if (bNoCancel) {
					this._scrollLeft(curPosX + scrollStep, false);
					this._holdTimeoutID = setTimeout(function () {
						self._scrollTimeoutX(scrollStep, false);
					}, 250);
				}
			} else if (event.offsetX < dragStartX) {
				//Scroll left
				this._lastBigIncDirH = -1;
				bNoCancel = this._trigger("scrolling", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: -1,
					horizontal: true,
					stepX: -scrollStep,
					stepY: 0
				});

				if (bNoCancel) {
					this._scrollLeft(curPosX - scrollStep, false);
					this._holdTimeoutID = setTimeout(function () {
						self._scrollTimeoutX(-scrollStep, false);
					}, 250);
				}
			}

			//should scrolled event be triggered
			this._cancelScrolling = !bNoCancel;
		},

		_onMouseMoveHTrack: function (event) {
			//Update the last know position of the mouse that is interacting with the horizontal track area
			if (this._bUseVTrack) {
				this._mTrackLastPosH = event.offsetX;
			}
		},

		_onMouseUpHTrack: function () {
			clearTimeout(this._holdTimeoutID);

			if (this._bUseHTrack && !this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: this._lastBigIncDirH,
					horizontal: true
				});
			}
			this._bUseHTrack = false;
		},

		_onMouseOutHTrack: function () {
			clearTimeout(this._holdTimeoutID);

			if (this._bUseHTrack && !this._cancelScrolling) {
				this._trigger("scrolled", null, {
					owner: this,
					smallIncrement: 0,
					bigIncrement: this._lastBigIncDirH,
					horizontal: true
				});
			}
			this._bUseHTrack = false;
		},

		_onMouseMoveHDrag: function (evt) {
			/* Ensures if we move the mouse of the bounds of the horizontal scroll bar and we are still holding left mouse button that when we move the mouse left/right we will continue to scroll */
			if (!this._bMouseDownH || !this._bUseHDrag) {
				return true;
			}

			if (this._bUseHDrag) {
				var curPosX = this._getContentPositionX(),
					offset = evt.pageX - this._mouseLastX,
					dragbPosX = this._dragLastX,
					nextPostX;

				//	Using linear interpolation to determine position of the content relative to the viewport based on the next drag position.
				//	Drag pos c in (a,b),  next scroll pos z in (x, y) => z = (c - a) / (b - a) * (y - x) + x = (c / b) * y , because a = 0 and x = 0.
				nextPostX = ((dragbPosX + offset) / (this._hBarTrack.width() - this._hBarDrag.width())) *
							(this._getContentWidth() - this.element.width());
				nextPostX = this._clampAxisCoords(nextPostX, 0,
							Math.max(this._getContentWidth() - this._getContainerWidth(), 0));
				var bNoCancel = this._trigger("thumbDragMove", null, {
					owner: this,
					horizontal: true,
					stepX: nextPostX - curPosX,
					stepY: 0
				});

				if (bNoCancel) {
					//Move custom horizondal scrollbar thumb drag
					this._scrollToX(nextPostX, true);
					this._mouseLastX = evt.pageX;
					this._dragLastX = dragbPosX + offset;
				}
			}
		},

		_onMouseUpHScrollbar: function () {
			var self = this;

			/* Ensures when the left mouse button is realeas that all properties are back to their default state */
			/* Works even if the mouse is out of the browser boundries and we release the left mouse button */
			if (this._bUseArrowLeft) {
				this._bUseArrowLeft = false;

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: -1,
						bigIncrement: 0,
						horizontal: true
					});
				}
			}
			if (this._bUseArrowRight) {
				this._bUseArrowRight = false;

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 1,
						bigIncrement: 0,
						horizontal: true
					});
				}
			}

			//If the mouse was previously hold over an element an we release it.
			if (this._bMouseDownH && !this._mOverScrollbars && !this._mOverContainer) {
				/** Scenario:
				*	1. Click and hold a horizontal scrollbar element
				*	2. Move the mouse outside the scrollable container
				*	3. Release the mouse
				*
				*	We hide the scrollbar after 2 secs since the mouse is outside the scrollable content
				*/
				this._hideScrollbarID = setTimeout(function () {
					self._hideScrollbars();
				}, 2000);
			} else if (this._bMouseDownH && !this._mOverScrollbars && this._mOverContainer) {
				/** Scenario:
				*	1. Click and hold a horizontal scrollbar element
				*	2. Move the mouse inside the scrollable container
				*	3. Release the mouse
				*
				*	We don't hide the scrollbar this time but switch to simple after 2 secs
				*/
				this._toSimpleScrollbarsID = setTimeout(function () {
					self._toSimpleScrollbars();
					self._toSimpleScrollbarsID = 0;
				}, 2000);
			}
			this._bMouseDownH = false;

			if (this._bUseHDrag) {
				/** Get the actual position on mouseup because we may have moved too much out and using the thumb right after will have offset */
				this._dragLastX = this._getTransform3dValueX(this._hBarDrag);

				if (!this._cancelThumbDrag) {
					this._trigger("thumbDragEnd", null, {
						owner: this,
						horizontal: true
					});
				}

				if (!this._cancelScrolling) {
					this._trigger("scrolled", null, {
						owner: this,
						smallIncrement: 0,
						bigIncrement: 0,
						horizontal: true
					});
				}
				this._enableContentSelection();
			}
			this._bUseHDrag = false;
		},

		/** Shows the mobile/touch scrollbars when they are hidden.
		*
		*	bSimple - boolean saying if only the simple scrollbars should be shown if not visible already (simple is thing thumb bar without arrows visible)
		*	hideAfter - sets the ammount of ms to delay the scrollbars being hidden after showing them
		*/
		_showScrollbars: function (bSimple, hideAfter) {
			var self = this;
			if (this.options.scrollbarType !== "custom") {
				return;
			}

			if (bSimple) {
				this._hideScrollbarArrows();

				if (this._vBarDrag && this._percentInViewV < 1) {
					this._vBarDrag.removeClass(this.css.verticalScrollThumbDragHidden)
						.addClass(this.css.verticalScrollThumbDragThin);
				}

				if (this._hBarDrag && this._percentInViewH < 1) {
					this._hBarDrag.removeClass(this.css.horizontalScrollThumbDragHidden)
						.addClass(this.css.horizontalScrollThumbDragThin);
				}
			} else {
				this._showScrollbarArrows();

				if (this._vBarDrag && this._percentInViewV < 1) {
					this._vBarDrag
						.removeClass(this.css.verticalScrollThumbDragHidden)
						.removeClass(this.css.verticalScrollThumbDragThin)
						.addClass(this.css.verticalScrollThumbDragBig);
				}

				if (this._hBarDrag && this._percentInViewH < 1) {
					this._hBarDrag
						.removeClass(this.css.horizontalScrollThumbDragHidden)
						.removeClass(this.css.horizontalScrollThumbDragThin)
						.addClass(this.css.horizontalScrollThumbDragBig);
				}
			}

			if (hideAfter) {
				this._hideScrollbarID = setTimeout(function () {
					self._hideScrollbars();
				}, hideAfter);
			}
		},

		_updateScrollbarsPos: function (destX, destY) {
			if (this.options.scrollbarType !== "custom") {
				return;
			}

			var self = this,
				animationID,
				calculatedDest;

			function updateCSS() {
				if (self._hBarDrag) {
					/**	Using linear interpolation to determine position of the drag relative to the track based on scroll position.
					  * Drag pos c in (a,b),  scroll pos z in (x, y) => c = (z - x) / (y - x) * (b - a) + a = (z / y) * b , because a = 0 and x = 0. */
					calculatedDest = (destX / (self._contentWidth - self.element.width())) *
										(self._hBarTrack.width() - self._hBarDrag.width());
					self._hBarDrag
						.css("-webkit-transform", "translate3d(" + calculatedDest + "px, 0px, 0px)") /* Safari */
						.css("-moz-transform", "translate3d(" + calculatedDest + "px, 0px, 0px)") /* Firefox */
						.css("-ms-transform", "translate3d(" + calculatedDest + "px, 0px, 0px)"); /* IE */
					/* We don't update the lastX here when using the thumb drag because there may be delay when this is executed. We forward calculate it instead in _onMouseMoveHDrag */
					if (!self._bUseHDrag) {
						self._dragLastX = calculatedDest;
					}
				}
				if (self._vBarDrag) {
					/**	Using linear interpolation to determine position of the drag relative to the track based on scroll position.
					  * Drag pos c in (a,b),  scroll pos z in (x, y) => c = (z - x) / (y - x) * (b - a) + a = (z / y) * b , because a = 0 and x = 0. */
					calculatedDest = (destY / (self._contentHeight - self.element.height())) *
										(self._vBarTrack.height() - self._vBarDrag.height());
					self._vBarDrag
						.css("-webkit-transform", "translate3d(0px, " + calculatedDest + "px, 0px)")
						.css("-moz-transform", "translate3d(0px, " + calculatedDest + "px, 0px)")
						.css("-ms-transform", "translate3d(0px, " + calculatedDest + "px, 0px)");
					/* We don't update the lastY here when using the thumb drag because there may be delay when this is executed. We forward calculate it instead in _onMouseMoveVDrag */
					if (!self._bUseVDrag) {
						self._dragLastY = calculatedDest;
					}
				}
			}

			/* calculate the css style before the next frame so we don't slow down the scrolling */
			animationID = requestAnimationFrame(updateCSS);
		},

		/** Hides the full/simple scrollbars. */
		_hideScrollbars: function () {
			if (this.options.scrollbarType !== "custom" ||
					this.options.alwaysVisible || (!this._vBarDrag && !this._hBarDrag)) {
				return;
			}

			if (this._vBarDrag && this._percentInViewV < 1) {
				this._vBarDrag
					.removeClass(this.css.verticalScrollThumbDragThin)
					.removeClass(this.css.verticalScrollThumbDragBig)
					.addClass(this.css.verticalScrollThumbDragHidden);
			}

			if (this._hBarDrag && this._percentInViewH < 1) {
				this._hBarDrag
					.removeClass(this.css.horizontalScrollThumbDragThin)
					.removeClass(this.css.horizontalScrollThumbDragBig)
					.addClass(this.css.horizontalScrollThumbDragHidden);
			}

			this._hideScrollbarArrows();
		},

		/** Switches from big scrollbar to simple one */
		_toSimpleScrollbars: function () {
			if (this._vBarDrag && (this._percentInViewV < 1)) {
				this._vBarDrag.removeClass(this.css.verticalScrollThumbDragBig)
					.addClass(this.css.verticalScrollThumbDragThin);
			}

			if (this._hBarDrag && this._percentInViewH < 1) {
				this._hBarDrag.removeClass(this.css.horizontalScrollThumbDragBig)
					.addClass(this.css.horizontalScrollThumbDragThin);
			}

			this._hideScrollbarArrows();
		},

		_showScrollbarArrows: function() {
			if (this._vBarDrag && this._percentInViewV < 1) {
				this._vBarArrowUp.removeClass(this.css.verticalScrollArrowHidden)
					.addClass(this.css.verticalScrollArrow);
				this._vBarArrowDown.removeClass(this.css.verticalScrollArrowHidden)
					.addClass(this.css.verticalScrollArrow);
			}

			if (this._hBarDrag && this._percentInViewH < 1) {
				this._hBarArrowLeft.removeClass(this.css.horizontalScrollArrowHidden)
					.addClass(this.css.horizontalScrollArrow);
				this._hBarArrowRight.removeClass(this.css.horizontalScrollArrowHidden)
					.addClass(this.css.horizontalScrollArrow);
			}
		},

		_hideScrollbarArrows: function () {
			if (this._vBarDrag && this._percentInViewV < 1) {
				this._vBarArrowUp.removeClass(this.css.verticalScrollArrow)
					.addClass(this.css.verticalScrollArrowHidden);
				this._vBarArrowDown.removeClass(this.css.verticalScrollArrow)
					.addClass(this.css.verticalScrollArrowHidden);
			}

			if (this._hBarDrag && this._percentInViewH < 1) {
				this._hBarArrowLeft.removeClass(this.css.horizontalScrollArrow)
					.addClass(this.css.horizontalScrollArrowHidden);
				this._hBarArrowRight.removeClass(this.css.horizontalScrollArrow)
					.addClass(this.css.horizontalScrollArrowHidden);
			}
		},

		_onMouseEnterScrollbarElem: function() {
			this._mOverScrollbars = true;

			//Cancels the hide scrollbars timeout
			clearTimeout(this._hideScrollbarID);

			//Cancel any timeout set to switch to simple scrollbar. Makes sure we don't switch to simple while we still hover over the scrollbars.
			clearTimeout(this._toSimpleScrollbarsID);
			this._toSimpleScrollbarsID = 0;

			this._showScrollbars(false);
		},

		_onMouseLeaveScrollbarElem: function () {
			var self = this;

			this._mOverScrollbars = false;
			if (!this._bMouseDownV && !this._bMouseDownH) {
				//Hide scrollbars after 2 secconds. This will be canceled if we go the scrollable content or any other element of the scrollbars by _hideScrollbarID
				this._hideScrollbarID = setTimeout(function () {
					self._hideScrollbars();
				}, 2000);

				//Switch to simple scrollbar (i.e. only drag bar showing with no arrows) after timeout of 2sec
				this._toSimpleScrollbarsID = setTimeout(function () {
					self._toSimpleScrollbars();
					self._toSimpleScrollbarsID = 0;
				}, 2000);
			}
		},

		/** Doesn't allow interacting with the scrollbars with touch actions */
		_onTouchStartScrollbarElem: function() {
			return false;
		},

		_disableContentSelection: function() {
			this._container.addClass(this.css.disabledSelection);
		},

		_enableContentSelection: function () {
			this._container.removeClass(this.css.disabledSelection);
		},

		_onDragStartElem: function (event) {
			/* Prevent dragging of that element due to causing some unwanted behaviour when using the custom scrollbars and you drag on them */
			event.preventDefault();
		},

		destroy: function () {
			/*
			```
				$(".selector").igScroll("destroy");
			```
			*/
			cancelAnimationFrame(this._touchInertiaAnimID);
			cancelAnimationFrame(this._showScrollbarsAnimId);
			clearTimeout(this._hideScrollbarID);
			clearTimeout(this._toSimpleScrollbarsID);
			clearTimeout(this._holdTimeoutID);

			if (typeof MutationObserver === "function") {
				this._observer.disconnect();
			}
			if (this._evts) {
				this.element.off(this._evts);
				delete this._evts;

				if (this._hBarDrag) {
					this._hBarDrag.remove();
				}
				if (this._hBarContainer) {
					this._hBarContainer.remove();
				}
				if (this._vBarDrag) {
					this._vBarDrag.remove();
				}
				if (this._vBarContainer) {
					this._vBarContainer.remove();
				}
				$("body").off("mousemove.igscroll_" + this.element[ 0 ].id);
				$(window).off("mouseup.igscroll_" + this.element[ 0 ].id);
				$(window).off("resize.igscroll_" + this.element[ 0 ].id);
				this._superApply(arguments);
			}
			return this;
		}
	});
	$.extend($.ui.igScroll, { version: "<build_number>" });
	$(document).on("iggridrendered igtreegridrendered", function (event, args) {
		/* M.H. 5 Feb 2014 Fix for bug #161906: Scrolling is not possible with virtualization and the grid rendered on button click on an iPad */
		var container = args.owner.scrollContainer();
		if (container.length === 0 && args.owner.container) {
			container = args.owner.container().find("[data-scroll]").eq(0);
		}
		if (container.length !== 0) {
			container.igScroll({ modifyDOM: false, scrollbarType: "none" });
			container.data("igScroll")._bKeyboardNavigation = false;
		}
	});
	return $;// REMOVE_FROM_COMBINED_FILES
}));// REMOVE_FROM_COMBINED_FILES
