# Ignite UI for jQuery  
[![Node.js CI](https://github.com/IgniteUI/ignite-ui/actions/workflows/node.js.yml/badge.svg)](https://github.com/IgniteUI/ignite-ui/actions/workflows/node.js.yml)
[![Coverage Status](https://coveralls.io/repos/github/IgniteUI/ignite-ui/badge.svg?branch=master)](https://coveralls.io/github/IgniteUI/ignite-ui?branch=master)
[![CodeQL](https://github.com/IgniteUI/ignite-ui/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/IgniteUI/ignite-ui/actions/workflows/codeql-analysis.yml)
[![Discord](https://img.shields.io/discord/836634487483269200?logo=discord&logoColor=ffffff)](https://discord.gg/39MjrTRqds)

[![npm version](https://badge.fury.io/js/ignite-ui.svg)](https://badge.fury.io/js/ignite-ui)
[![Bower version](https://badge.fury.io/bo/ignite-ui.svg)](https://badge.fury.io/bo/ignite-ui)


Ignite UI for jQuery™ helps you build powerful, high-performance web-based applications. Inside Ignite UI for jQuery you'll find user experience controls and components for creating engaging line-of-business web applications which target the browsers for both mobile & desktop environments.

## About  Ignite UI for jQuery

Ignite UI for jQuery is built on jQuery and jQuery UI and ties in seamlessly with the jQuery core model and conventions including all styling support via jQuery UI Theme Roller. Beyond jQuery Ignite UI for jQuery features support for Bootstrap themes, AngularJS, Knockout and jQuery Mobile.

## Available Features in Ignite UI for jQuery open-source version

|Feature																	|Ignite UI for jQuery OSS		|[Ignite UI for jQuery Full](http://www.igniteui.com)	|[Infragistics Ultimate](http://www.infragistics.com/products/ultimate)	|Help 																																																																			|
|---------------------------------------------------------------------------|:-----------------:|:-----------------------------------------:|:---------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
|**Editors**																|					|											|																		|																																																																				|
|[igCombo](http://www.igniteui.com/combo/overview)							|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igcombo)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igcombo-igcombo)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igCombo)														|
|[igHtmlEditor](http://www.igniteui.com/html-editor/overview)				|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.ightmleditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/ightmleditor-ightmleditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igHtmlEditor)									|
|[igRating](http://www.igniteui.com/rating/overview)						|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/mobile.igRating)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igValidator](http://www.igniteui.com/validator/overview)					|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igvalidator)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igvalidator)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igValidator)													|
|[igCurrencyEditor](http://www.igniteui.com/editors/currency-editor)		|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igcurrencyeditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igcurrencyeditor-igcurrencyeditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/00_igCurrencyEditor)	|
|[igDateEditor](http://www.igniteui.com/editors/date-editor)				|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igdateeditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igdateeditor-igdateeditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/01_igDateEditor)						|
|[igMaskEditor](http://www.igniteui.com/editors/mask-editor)				|:white_check_mark:	|:white_check_mark:		 					|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igmaskeditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igmaskeditor-igmaskeditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/02_igMaskEditor)					|
|[igNumericEditor](http://www.igniteui.com/editors/numeric-editor)			|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.ignumericeditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/ignumericeditor-ignumericeditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/03_igNumericEditor)		|
|[igPercentEditor](http://www.igniteui.com/editors/percent-editor)			|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igpercenteditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igpercenteditor-igpercenteditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/04_igPercentEditor)		|
|[igTextEditor](http://www.igniteui.com/editors/text-editor)				|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtexteditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igtexteditor-igtexteditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/05_igTextEditor)					|
|[igCheckboxEditor](http://www.igniteui.com/editors/checkbox-editor)		|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igcheckboxeditor)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igcheckboxeditor-igcheckboxeditor)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/06_igCheckboxEditor)	|  
|[igDatePicker](http://www.igniteui.com/editors/date-picker-overview)		|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igdatepicker)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igdatepicker-igdatepicker)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igEditors/07_igDatePicker)					|
|**Frameworks**																|					|											|																		|																																																																				|
|[igLoader](http://www.igniteui.com/loader/overview)						|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ig.loader)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/api/2017.2/ig.loader)&nbsp;**\\**&nbsp;[topics&nbsp;source](http://www.igniteui.com/help/using-infragistics-loader) |
|[igDataSource](http://www.igniteui.com/data-source/overview)				|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ig.datasource)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/api/2017.2/ig.datasource)&nbsp;**\\**&nbsp;[topics&nbsp;source](http://www.igniteui.com/help/igdatasource-igdatasource-overview) |
|[Templating Engine](http://www.igniteui.com/templating-engine/conditional-templates)|:white_check_mark:		| :white_check_mark: 		|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igtemplating-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/06_Infragistics-Templating-Engine) |
|[JS Excel Engine](http://www.igniteui.com/javascript-excel-library/overview)|:x:|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/javascript-excel-library)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/using-the-javascript-excel-library)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/09_JavaScript%20Excel%20Library/~JavaScript_Excel_Library.md) |
|[igGridExcelExporter](http://www.igniteui.com/grid/export-basic-grid)		|:x:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ig.gridexcelexporter)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggridexcelexporter-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/09_JavaScript%20Excel%20Library/~JavaScript_Excel_Library.md) |
|**Interactions**															|					|											|																		|					|
|[igTree](http://www.igniteui.com/tree/overview)							|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtree)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igtree-getting-started)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igTree) |
|[igDialog](http://www.igniteui.com/dialog-window/overview)					|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igdialog)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igdialog)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igDialog) |
|[igToolbar](http://www.igniteui.com/html-editor/standalone-toolbar)		|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtoolbar)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/ightmleditor-configuring-toolbars-and-buttons)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igHtmlEditor/03_Custom%20Toolbars) |
|igToolbarButton															|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtoolbarbutton)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/ightmleditor-configuring-toolbars-and-buttons)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igHtmlEditor/03_Custom%20Toolbars) |
|[igSplitButton](http://www.igniteui.com/split-button/overview)				|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igsplitbutton)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igNotifier](http://www.igniteui.com/notifier/overview)					|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.ignotifier)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/ignotifier-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igNotifier) |
|[igPopover](http://www.igniteui.com/popover/overview)						|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igpopover)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igpopover-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igPopOver) |
|[igRadialMenu](http://www.igniteui.com/radial-menu/overview)				|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igradialmenu)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igradialmenu)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igRadialMenu) |
|[igColorPicker](http://www.igniteui.com/split-button/overview)				|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igcolorpicker)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|igColorPickerSplitButton													|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igcolorpickersplitbutton)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igUpload](http://www.igniteui.com/file-upload/overview)					|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igVideoPlayer](http://www.igniteui.com/video-player/overview)				|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igScroll](http://www.igniteui.com/scroll/overview)						|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2016.2/ui.igscroll/)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igscroll)&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|**Data Visualization**														|					|											|																		|					|
|[igDataChart](http://www.igniteui.com/data-chart/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igDataChart)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igCategoryChart](https://www.igniteui.com/category-chart/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](https://www.igniteui.com/help/api/2017.2/ui.igCategoryChart)&nbsp;**\\**&nbsp;[help](https://www.igniteui.com/help/categorychart-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igCategoryChart/00_CategoryChart_Overview.md) |
|[igShapeChart](https://www.igniteui.com/shapechart/binding-break-even-data)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](https://www.igniteui.com/help/api/2017.2/ui.igshapechart)&nbsp;**\\**&nbsp;[help](https://www.igniteui.com/help/shapechart-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igPieChart](http://www.igniteui.com/pie-chart/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igPieChart)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igDoughnutChart](http://www.igniteui.com/doughnut-chart/overview)			|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igdoughnutchart)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igFunnelChart](http://www.igniteui.com/funnel-chart/overview)				|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igfunnelchart)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igBulletGraph](http://www.igniteui.com/bullet-graph/overview)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igbulletgraph)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igLinearGauge](http://www.igniteui.com/linear-gauge/overview)				|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iglineargauge)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igRadialGauge](http://www.igniteui.com/radial-gauge/overview)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igradialgauge)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igMap](http://www.igniteui.com/map/overview)								|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igMap)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igSparkline](http://www.igniteui.com/sparkline/overview)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igsparkline)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igQRCodeBarcode](http://www.igniteui.com/barcode/configuring-the-qr-code-specific-settings)	|:x:				|:white_check_mark: 	|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igqrcodebarcode)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igZoombar](http://www.igniteui.com/zoombar/overview)						|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igzoombar)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|**Scheduling**														|					|											|																		|					|
|[igScheduler](https://www.igniteui.com/scheduler/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](https://www.igniteui.com/help/api/2017.2/ui.igScheduler)&nbsp;**\\**&nbsp;[help](https://www.igniteui.com/help/igscheduler-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igScheduler/00_igScheduler_Overview.md) |
|**Layout**																	|					|											|																		|					|
|[igLayoutManager](http://www.igniteui.com/layout-manager/overview)			|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iglayoutmanager)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igSplitter](http://www.igniteui.com/splitter/overview)					|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igsplitter)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igTileManager](http://www.igniteui.com/tile-manager/overview)				|:white_check_mark:	|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtilemanager)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|**Grids**																	|					|											|																		|					|
|[igGrid](http://www.igniteui.com/grid/overview)							|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggrid)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igHierarchicalGrid](http://www.igniteui.com/hierarchical-grid/overview)	|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggrid_hg)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[igTreeGrid](http://www.igniteui.com/tree-grid/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igtreegrid)&nbsp;**\\**&nbsp;[help]()&nbsp;**\\**&nbsp;[topics&nbsp;source]() |
|[Spreadsheet](https://www.igniteui.com/spreadsheet/overview)					|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](https://www.igniteui.com/help/api/2017.2/ui.igScheduler)&nbsp;**\\**&nbsp;[help](https://www.igniteui.com/help/igspreadsheet-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igSpreadsheet/00_igSpreadsheet_overview/00_igSpreadsheet_Feature_Overview.md) |
|**Grid Features**															|					|											|																		|					|
|Column Management Features													|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-columnmanagementfeatures-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/~igGrid_ColumnManagementFeatures_LandingPage.md) |
|[Column Fixing](http://www.igniteui.com/grid/column-fixing)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridcolumnfixing)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-columnfixing-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/00_Fixing) |
|[Column Grouping](http://www.igniteui.com/grid/grouping-customization)		|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridgroupby)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-groupby)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/01_Grouping) |
|[Column Hiding](http://www.igniteui.com/grid/column-hiding)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridhiding)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-column-hiding)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/02_Hiding) |
|[Column Moving](http://www.igniteui.com/grid/column-moving)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridcolumnmoving)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-columnmoving-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/03_Moving) |
|[Column Resizing](http://www.igniteui.com/grid/column-resizing)			|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridresizing)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-column-resizing)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/04_igGrid_Column_Resizing.md) |
|[Column Summaries](http://www.igniteui.com/grid/summaries)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridsummaries)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-column-summaries)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/05_Summaries) |
|[Column Template](http://www.igniteui.com/grid/column-template)			|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-column-template)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/06_Template) |
|[Multi-Column Headers](http://www.igniteui.com/grid/multi-column-headers)	|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridmulticolumnheaders)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-multicolumnheaders-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/08_Multi-Headers) |
|[Collapsible Column Groups](http://www.igniteui.com/grid/collapsible-column-groups)	|:x:				|:white_check_mark:				|:white_check_mark:							            				|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-multicolumnheaders-multicolumnheaders#collapsible-column-groups)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/08_Multi-Headers) |
|[Filtering](http://www.igniteui.com/grid/simple-filtering)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridfiltering)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-filtering)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/07_igGrid_Filtering.md) |
|[Sorting](http://www.igniteui.com/grid/sorting-remote)						|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridsorting)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-sorting)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/09_Sorting) |
|[Unbound Columns](http://www.igniteui.com/grid/unbound-column)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-unboundcolumns-landing-page)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/00_Columns/10_Unbound) |
|[Feature Chooser](http://www.igniteui.com/grid/feature-chooser)			|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-feature-chooser)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/01_igGrid_Feature_Chooser.md) |
|[Row Selectors](http://www.igniteui.com/grid/row-selectors)				|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridrowselectors)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-row-selectors)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/02_Row%20Selectors) |
|[Selection](http://www.igniteui.com/grid/selection)						|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridselection)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-selection)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/03_Selection) |
|[Tooltips](http://www.igniteui.com/grid/tooltips)							|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridtooltips)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-tooltips)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/04_Tooltips) |
|[Updating](http://www.igniteui.com/grid/basic-editing)						|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridupdating)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-updating-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/05_Updating) |
|[Paging](http://www.igniteui.com/grid/paging)								|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridpaging)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-paging)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/06_igGrid_Paging.md) |
|[Cell Merging](http://www.igniteui.com/grid/cell-merging)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridcellmerging)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-cellmerging-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/07_Cell%20Merging) |
|[Responsive Web Design](http://www.igniteui.com/grid/responsive-web-design-mode) (RWD) Mode|:x:|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-responsive-web-design-mode-landingpage)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/08_Responsive) |
|[jsRender Integration](http://www.igniteui.com/grid/jsrender-integration)	|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-jsrender-integration)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/09_igGrid_jsRender_Integration.md) |
|[REST Updating](http://www.igniteui.com/grid/rest-editing)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggridupdating)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-rest-updating)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/10_igGrid_REST_Updating.md) |
|[Knockout Support](http://www.igniteui.com/grid/bind-grid-with-ko)			|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-configuring-knockout-support)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/11_igGrid_Configuring_Knockout_Support.md) |
|Columns and Layout															|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-columns-and-layout)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/12_igGrid_Columns_and_Layout.md) |
|[Virtualization](http://www.igniteui.com/grid/virtualization-fixed)		|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.iggrid#options:virtualization)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-virtualization)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igGrid/03_Features/13_Virtualization) |
|[Grid Multi-Row Layout](http://www.igniteui.com/grid/multi-row-layout)		|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/iggrid-multirowlayout)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/16_igGrid_MultiRowLayout.md) |
|[Grid Load On Demand](http://www.igniteui.com/grid/append-rows-on-demand)	|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/append-rows-on-demand-overview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/15_Append_Rows_On_Demand_Overview.md) |
|**OLAP Pivot**																|					|											|																		|					|
|[igPivotDataSelector](http://www.igniteui.com/pivot-data-selector/overview)|:x:				|:white_check_mark: 						|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igPivotDataSelector)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igpivotdataselector)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igPivotDataSelector) |
|[igPivotGrid](http://www.igniteui.com/pivot-grid/overview)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igPivotGrid)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igpivotgrid)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igPivotGrid) |
|[igPivotView](http://www.igniteui.com/pivot-view/overview)					|:x:				|:white_check_mark:							|:white_check_mark:														|[api](http://www.igniteui.com/help/api/2017.2/ui.igPivotView)&nbsp;**\\**&nbsp;[help](http://www.igniteui.com/help/igpivotview)&nbsp;**\\**&nbsp;[topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/02_Controls/igPivotView) |
|																			|					|											|																		|					|
|**Knockout Extensions**													|					|											|																		|					|
|[Combo](http://www.igniteui.com/combo/bind-combo-with-ko)					|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/igcombo-knockoutjs-support) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igCombo/04_Configuring/04_igCombo_KnockoutJS_Support.md) |
|[Editors](http://www.igniteui.com/editors/bind-editors-with-ko)			|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/configuring-knockout-support-(editors)) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igEditors/Config/02_Configuring%20Knockout%20Support%20(Editors).md) |
|[Tree](http://www.igniteui.com/tree/bind-tree-with-ko)						|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/igtree-knockoutjs-support) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igTree/13_igTree_KnockoutJS_Support.md) |
|[Grid](http://www.igniteui.com/grid/bind-grid-with-ko)						|:x:				|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/iggrid-configuring-knockout-support) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igGrid/03_Features/11_igGrid_Configuring_Knockout_Support.md) |
|[Chart](http://www.igniteui.com/data-chart/bind-data-chart-with-ko)		|:x:				|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/igdatachart-knockoutjs-support) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/02_Controls/igDataChart/04_Configuring/05_igDataChart_KnockoutJS_Support.md) |
|																			|					|											|																		|					|
|**Theming**													            |					|											|																		|					|
|[Metro](http://www.igniteui.com/themes/metro)					            |:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[iOS](http://www.igniteui.com/themes/ios)					                |:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[Bootstrap Default](http://www.igniteui.com/themes/bootstrap-default)		|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[Bootstrap 4 Default](http://www.igniteui.com/themes/bootstrap4-default)	|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[Bootstrap Superhero](http://www.igniteui.com/themes/bootstrap-superhero)	|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[Bootstrap Flatly](http://www.igniteui.com/themes/bootstrap-flatly)		|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|[Bootstrap Yeti](http://www.igniteui.com/themes/bootstrap-yeti)			|:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|Infragistics       			                                            |:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|Infragistics2012				                                            |:white_check_mark:	|:white_check_mark:							|:white_check_mark:														|[help](http://www.igniteui.com/help/deployment-guide-styling-and-theming) **\\** [topics source](https://github.com/IgniteUI/help-topics/blob/17.2/topics/01_General-and-Getting-Started/07_Styling-and-Theming/~Deployment_Guide_Styling_and_Theming.md) |
|																			|					|											|																		|					|
|MVC Extensions																|:x:	            |:white_check_mark: 						|:white_check_mark:														|[help](http://www.igniteui.com/help/asp.net-mvc-landingpage) **\\** [topics&nbsp;source](https://github.com/IgniteUI/help-topics/tree/17.2/topics/05_ASP-NET-MVC)|
|Developer Support 24/5														|:x:				|:white_check_mark: 						|:white_check_mark:														||

## Install
The package for this development repository is available on both [`npm`](https://www.npmjs.com/package/ignite-ui) and [`bower`](https://github.com/IgniteUI/ignite-ui-bower).
To get started follow the respective package manager installation:

#### Ignite UI for jQuery CLI
To get started with the Ignite UI for jQuery CLI and Ignite UI for jQuery:

```
npm i -g igniteui-cli
ig new <project name> --framework=jquery
cd <project name>
ig add combo <component name>
ig start
```

#### npm
```shell
npm install ignite-ui
```

#### bower
```shell
bower install ignite-ui
```

Package contains similar files and structure to what you'd find in the [full version of Ignite UI for jQuery](http://www.igniteui.com) with complete styles and lite versions of the combined script files:
```html
<script src="<node_modules|bower_components>/ignite-ui/js/infragistics.core-lite.js" type="text/javascript"></script>
<script src="<node_modules|bower_components>/ignite-ui/js/infragistics.lob-lite.js" type="text/javascript"></script>
```
The full built content for both packages can be browsed at the [Ignite UI for jQuery Bower Shim repository](https://github.com/IgniteUI/ignite-ui-bower).

## Running demos locally

Besides browsing our [online samples](http://www.igniteui.com/), you can also run the demos included with this repo in a local clone.
Those are useful for quickly trying out some control features, as a base for other samples or even testing local changes.

To setup the repository run the following in the root directory:
```bash
npm install
```
The command will install all build dependencies as well as bower packages used in the demos.

To build the product: 
```bash
grunt build
```
This will create source files under the `dist/` folder complete with merged locales, combined script and structure CSS and can be called again to include new changes.

The html demos under `demos/<control>` can now be run directly from the file system.

## Getting Help

* [Ignite UI for jQuery help API](http://www.igniteui.com/help/api/2017.2/)
* [Ignite UI for jQuery help topics](http://www.igniteui.com/help/)
* [Ignite UI for jQuery online samples](http://www.igniteui.com/grid/overview)
* [Ignite UI for jQuery questions on StackOverflow](http://stackoverflow.com/questions/tagged/ignite-ui)

## Contributing
You can find all guidelines on how to contribute on the wiki page.  
* [How to contribute](https://github.com/IgniteUI/ignite-ui/blob/master/.github/CONTRIBUTING.md)  
* [API documentation guidelines](https://github.com/IgniteUI/ignite-ui/wiki/API-Documentation-Guidelines)
