#pragma once

#include "test_std.h"
#include "test_tcp.h"
#include "test_udp.h"
#include "test_udp2.h"

#define TEST_THREAD_COUNT   32

#define TEST_EVENT_ID_TEST_FINISHED    100

#define TEST_LOG_CATEGORY   1
#define test_info(format, ...) \
    co_log_write(CO_LOG_LEVEL_INFO, TEST_LOG_CATEGORY, format, ##__VA_ARGS__)
#define test_error(format, ...) \
    co_log_write(CO_LOG_LEVEL_ERROR, TEST_LOG_CATEGORY, format, ##__VA_ARGS__)

typedef struct test_app_st
{
    co_app_t base;

    test_thread_st* threads[TEST_THREAD_COUNT];
    size_t item_index;
    co_timer_t* timer;

    uint64_t start_time;
    uint64_t total_time;

} test_app_st;

int
test_app_run(
    int argc,
    char** argv
);
