# Contributing to PDF-Frame

Thank you for your interest in contributing to PDF-Frame! We are thrilled to have you as part of our community. The following guidelines will help you to contribute effectively and ensure a smooth collaboration process.

## Getting Started
Before you begin contributing, please make sure to familiarize yourself with the project by reading the README, Examples, the existing issues, and the documentation. This will help you understand the project's current status and development goals.

## Raising Issues

If you encounter a problem or have a suggestion, please check the issue tracker to see if it has already been reported. If it is a new issue, please proceed to open a new issue with the following details:

* Title: A clear, concise title that describes the issue.
* Description: A detailed explanation of the issue.
* Reproducible Environment: Include steps to reproduce the problem, version numbers, operating system, and any relevant configurations. If possible provide a Stackblitz.
* Expected Behavior: Describe what you expected to happen.
* Actual Behavior: Describe what actually happened.
* Screenshots: If applicable, add screenshots to help explain your problem.

Please provide as much information as possible to help us understand and resolve the issue quickly.


## Submitting Changes

To contribute code or documentation to PDF-Frame, please follow these steps:

* Fork the Repository: Go to the PDF-Frame repository and click the "Fork" button.
* Clone Your Fork: git clone [https://github.com/your-username/PDF-Frame.git](https://github.com/I2Djs/pdf-frame.git)
* Create a New Branch: git checkout -b your-branch-name
* Make Your Changes:
     * Ensure that you submit changes on a per-component basis. Changes that span multiple components are generally not encouraged unless they are part of a coordinated update across the monorepo.
     * Update the respective README.md files for any packages you modify. This ensures that documentation stays current with code changes.
* Run Tests: Ensure that your changes do not break any existing functionality.
* Commit Your Changes: git commit -m 'Add some feature'
* Push to Your Fork: git push origin your-branch-name
* Submit a Pull Request: Go to your fork on GitHub and click the "Pull Request" button. Make sure to target the main branch of PDF-Frame.

Please provide a clear description in your pull request of what the changes entail and why they are necessary.


## Code Review Process

Once you submit a pull request, the project maintainers will review your changes. They may suggest modifications or further improvements. Please be responsive to feedback to ensure a swift process. Your contributions will be merged into the project once all criteria are met and the maintainers approve the changes.

## Community

We encourage you to participate in the community and make PDF-Frame better for everyone. Whether you are fixing bugs, adding features, improving documentation, or reporting issues, your contributions are greatly appreciated!

