//生产环境---静态常量
const PRODUCTION = 'production';
const CompressionWebpackPlugin = require('compression-webpack-plugin');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin;
//获取配置
let {NODE_ENV, productionSourceMap, removeConsole, showFileInfo} = process.env;

module.exports = {
    /** 区分生产环境与开发环境
     * process.env.NODE_ENV==='production' (生产环境)
     * process.env.NODE_ENV==='development' (开发环境)
     * publicPath: process.env.NODE_ENV==='production'?"https://www.weiziplus.com/test/":'test/',
     */
    //打包时注意路径问题
    publicPath: PRODUCTION === NODE_ENV ? './' : '/',
    // 运行时生成的生产环境构建文件的目录(默认''dist''，构建之前会被清除)
    outputDir: `dist/${process.env.outputDir || 'temp'}`,
    //放置生成的静态资源(s、css、img、fonts)的(相对于 outputDir 的)目录(默认'')
    assetsDir: 'assets',
    //指定生成的 index.html 的输出路径(相对于 outputDir)也可以是一个绝对路径
    indexPath: 'index.html',
    // 是否在构建生产包时生成 sourceMap 文件，false将提高构建速度// 。
    productionSourceMap: '0' === productionSourceMap,
    css: {
        // 是否使用css分离插件 ExtractTextPlugin
        extract: false,
        // css预设器配置项
        loaderOptions: {
            less: {
                lessOptions: {
                    //修改ant的样式
                    modifyVars: {},
                    javascriptEnabled: true,
                },
            },
        },
        // 启用 CSS modules for all css / pre-processor files.
        // requireModuleExtension: true
    },
    // 构建时开启多进程处理babel编译
    parallel: require('os').cpus().length > 1,
    chainWebpack: config => {
        //如果是生产环境
        if (PRODUCTION === NODE_ENV) {
            // 移除 prefetch 插件
            config.plugins.delete('prefetch');
            // 移除 preload 插件
            config.plugins.delete('preload');
        }
    },
    configureWebpack: config => {
        //如果是生产环境
        if (PRODUCTION === NODE_ENV) {
            //打包去除的资源
            /*config.externals = {
                'vue': 'Vue',
                'vue-router': 'VueRouter',
            };*/
            //开启Gzip
            config.plugins.push(new CompressionWebpackPlugin({
                algorithm: 'gzip',
                //匹配的文件名
                test: /\.js$|\.html$|\.css/,
                //对超过10K的压缩
                threshold: 1024,
                //是否删除原文件
                deleteOriginalAssets: false
            }));
        }
        //是否删除console打印 0:删除,1:不删除
        if ('0' === removeConsole) {
            //去掉注释
            config.plugins.push(new UglifyJsPlugin({
                uglifyOptions: {
                    compress: {
                        drop_debugger: true,
                        drop_console: true,
                        // 移除console
                        pure_funcs: ['console.log', 'console.debug', 'console.trace']
                    },
                },
                sourceMap: false,
                parallel: true,
            }));
        }
        //是否显示文件信息(一般打包时启用)，0:是,1:否
        if ('0' === showFileInfo) {
            //查看打包后的文件信息
            config.plugins.push(new BundleAnalyzerPlugin(
                {
                    analyzerMode: 'server',
                    analyzerHost: 'localhost',
                    // 运行后的端口号
                    analyzerPort: 8888,
                    reportFilename: 'report.html',
                    defaultSizes: 'parsed',
                    //是否自动打开浏览器
                    openAnalyzer: true,
                    generateStatsFile: false,
                    statsFilename: 'stats.json',
                    statsOptions: null,
                    logLevel: 'info'
                }
            ));
        }
    },
    //本地项目运行时的环境配置
    devServer: {
        port: 80,
        https: false,
        hotOnly: false
    }
};