// 按需引入element-plus该方法稳定且明确。
// 自动导入: https://element-plus.org/zh-CN/guide/quickstart.html#%E6%8C%89%E9%9C%80%E5%AF%BC%E5%85%A5
import {
  ElAffix,
  ElAlert,
  ElAutocomplete,
  ElAutoResizer,
  ElAvatar,
  ElBacktop,
  ElBadge,
  ElBreadcrumb,
  ElBreadcrumbItem,
  ElButton,
  ElButtonGroup,
  ElCalendar,
  ElCard,
  ElCarousel,
  ElCarouselItem,
  ElCascader,
  ElCascaderPanel,
  ElCheckTag,
  ElCheckbox,
  ElCheckboxButton,
  ElCheckboxGroup,
  ElCol,
  ElCollapse,
  ElCollapseItem,
  ElCollapseTransition,
  ElColorPicker,
  ElConfigProvider,
  ElContainer,
  ElAside,
  ElFooter,
  ElHeader,
  ElMain,
  ElDatePicker,
  ElDescriptions,
  ElDescriptionsItem,
  ElDialog,
  ElDivider,
  ElDrawer,
  ElDropdown,
  ElDropdownItem,
  ElDropdownMenu,
  ElEmpty,
  ElForm,
  ElFormItem,
  ElIcon,
  ElImage,
  ElImageViewer,
  ElInput,
  ElInputNumber,
  ElLink,
  ElMenu,
  ElMenuItem,
  ElMenuItemGroup,
  ElSubMenu,
  ElPageHeader,
  ElPagination,
  ElPopconfirm,
  ElPopover,
  ElPopper,
  ElProgress,
  ElRadio,
  ElRadioButton,
  ElRadioGroup,
  ElRate,
  ElResult,
  ElRow,
  ElScrollbar,
  ElSelect,
  ElOption,
  ElOptionGroup,
  // ElSelectV2,
  ElSkeleton,
  ElSkeletonItem,
  ElSlider,
  ElSpace,
  ElStatistic,
  ElCountdown,
  ElSteps,
  ElStep,
  ElSwitch,
  ElTable,
  ElTableColumn,
  ElTableV2,
  ElTabs,
  ElTabPane,
  ElTag,
  ElText,
  ElTimePicker,
  ElTimeSelect,
  ElTimeline,
  ElTimelineItem,
  ElTooltip,
  ElTransfer,
  ElTree,
  ElTreeSelect,
  ElTreeV2,
  ElUpload,
  ElWatermark,
  /**
   * 导出来源：https://github.com/element-plus/element-plus/blob/dev/packages/element-plus/plugin.ts#L11-L16
   * */
  ElLoading, // v-loading 指令
  ElInfiniteScroll, // v-infinite-scroll 指令
  ElPopoverDirective, // v-popover 指令
  ElMessage, // $message 全局属性对象globalProperties
  ElMessageBox, // $msgbox、$alert、$confirm、$prompt 全局属性对象globalProperties
  ElNotification, // $notify 全局属性对象globalProperties
} from "element-plus";

const components = [
  // ElAffix,
  // ElAlert,
  ElAutocomplete,
  // ElAutoResizer,
  ElAvatar,
  // ElBacktop,
  ElBadge,
  // ElBreadcrumb,
  // ElBreadcrumbItem,
  ElButton,
  // ElButtonGroup,
  // ElCalendar,
  ElCard,
  // ElCarousel,
  // ElCarouselItem,
  // ElCascader,
  // ElCascaderPanel,
  // ElCheckTag,
  ElCheckbox,
  // ElCheckboxButton,
  // ElCheckboxGroup,
  // ElCol,
  // ElCollapse,
  // ElCollapseItem,
  // ElCollapseTransition,
  // ElColorPicker,
  ElConfigProvider,
  // ElContainer,
  ElAside,
  // ElFooter,
  ElHeader,
  ElMain,
  // ElDatePicker,
  ElDescriptions,
  ElDescriptionsItem,
  ElDialog,
  ElDivider,
  ElDrawer,
  // ElDropdown,
  // ElDropdownItem,
  // ElDropdownMenu,
  ElEmpty,
  ElForm,
  ElFormItem,
  ElIcon,
  ElImage,
  ElImageViewer,
  ElInput,
  // ElInputNumber,
  // ElLink,
  ElMenu,
  // ElMenuItem,
  // ElMenuItemGroup,
  // ElSubMenu,
  // ElPageHeader,
  // ElPagination,
  // ElPopconfirm,
  // ElPopover,
  // ElPopper,
  // ElProgress,
  // ElRadio,
  ElRadioButton,
  ElRadioGroup,
  // ElRate,
  // ElResult,
  ElRow,
  ElScrollbar,
  ElSelect,
  ElOption,
  // ElOptionGroup,
  // ElSelectV2,
  ElSkeleton,
  ElSkeletonItem,
  // ElSlider,
  // ElSpace,
  // ElStatistic,
  // ElCountdown,
  // ElSteps,
  // ElStep,
  ElSwitch,
  ElTable,
  // ElTableColumn,
  // ElTableV2,
  ElTabs,
  ElTabPane,
  ElTag,
  // ElText,
  // ElTimePicker,
  // ElTimeSelect,
  // ElTimeline,
  // ElTimelineItem,
  ElTooltip,
  // ElTransfer,
  // ElTree,
  // ElTreeSelect,
  // ElTreeV2,
  // ElUpload,
  // ElWatermark,
];

const plugins = [
  ElLoading,
  // ElInfiniteScroll,
  // ElPopoverDirective,
  ElMessage,
  ElMessageBox,
  ElNotification,
];

/** 按需引入`element-plus` */
export function useElementPlus(app) {
  // 全局注册组件
  components.forEach((component) => {
    app.component(component.name, component);
  });
  // 全局注册插件
  plugins.forEach((plugin) => {
    app.use(plugin);
  });
}
