<div align="center">

 # [Awesome-Hacking](https://github.com/Hunterdii/Awesome-Hacking)
 
</div>

Welcome to **Awesome-Hacking**, your ultimate resource hub for all things hacking, pentesting, and security research.

<p align="center">
  <img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="Awesome Badge"/>
  <img src="https://img.shields.io/static/v1?label=%F0%9F%8C%9F&message=If%20Useful&style=flat&color=BC4E99" alt="Star Badge"/>
  <img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?longCache=true" alt="Pull Requests"/>
  <img src="https://img.shields.io/badge/License-CCO_1.0-lightgrey.svg?longCache=true" alt="CCO_1.0 License"/>
  <img src="https://img.shields.io/badge/Awesome-Hacking-red.svg" alt="Awesome Hacking Badge"/>
  <img src="https://img.shields.io/badge/platform-Linux%20%7C%20KaliLinux%20%7C%20ParrotOs-blue" alt="Platforms">
  <img src="https://badges.frapsoft.com/os/v1/open-source.svg?v=103" alt="Open Source Badge"/>
  <img src="https://img.shields.io/github/contributors/Hunterdii/Awesome-Hacking" alt="GitHub Contributors"/>
  <img src="https://img.shields.io/github/last-commit/Hunterdii/Awesome-Hacking?color=brightgreen" alt="Last Commit"/>
  <img src="https://img.shields.io/badge/Owner-%40Hunterdii-<COLOR>.svg" alt="Owner Badge"/>
</p>

# GitHub Stats:

<div align="center">
<table>
  <thead>
    <tr>
      <th>🌟 Stars</th>
      <th>🍴 Forks</th>
      <th>🐛 Issues</th>
      <th>📏 Repo Size</th>
      <th>🔔 Open PRs</th>
      <th>🔕 Closed PRs</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><img alt="Stars" src="https://img.shields.io/github/stars/Hunterdii/Awesome-Hacking?style=flat&logo=github"/></td>
      <td><img alt="Forks" src="https://img.shields.io/github/forks/Hunterdii/Awesome-Hacking?style=flat&logo=github"/></td>
      <td><img alt="Issues" src="https://img.shields.io/github/issues/Hunterdii/Awesome-Hacking?style=flat&logo=github"/></td>
      <td><img alt="Repo Size" src="https://img.shields.io/github/repo-size/Hunterdii/Awesome-Hacking?style=flat&logo=github"/></td>
      <td><img alt="Open Pull Requests" src="https://img.shields.io/github/issues-pr/Hunterdii/Awesome-Hacking?style=flat&logo=github"/></td>
      <td><img alt="Closed Pull Requests" src="https://img.shields.io/github/issues-pr-closed/Hunterdii/Awesome-Hacking?style=flat&color=critical&logo=github"/></td>
    </tr>
  </tbody>
</table>
</div>


<!--   <a href="https://www.linkedin.com/in/het-patel-8b110525a" ><img src="https://img.shields.io/twitter/follow/HetPate94938685.svg?style=social" /> </a>
 -->
 
<!--![GitHub forks](https://img.shields.io/github/forks/https%3A%2F%2Fgithub.com%2FHunterdii/https%3A%2F%2Fgithub.com%2FHunterdii%2FHack-Academia)-->


## 📔 &nbsp;Overview

This repository houses a curated collection of materials and tools I utilize daily in my work. It compiles a wealth of valuable information into a single resource, serving as an essential reference that I frequently revisit.

## 🚻 &nbsp;Audience

This repository is for everyone. While it caters specifically to System and Network Administrators, DevOps professionals, Pentesters, and Security Researchers, anyone can find something of interest here.

## ℹ️ &nbsp;Contributing

If you come across something that seems unclear or incorrect, please submit a pull request with valid and well-reasoned explanations for your changes or comments.

Here are a few guiding principles for this project:

- Welcoming and easy to understand
- Engaging and not tedious
- Practical and helpful

Additionally, consider the following rules:

- Easy to contribute to (using Markdown + HTML ...)
- Easy to navigate (simple Table of Contents, consider extending it if necessary)

URLs marked with **\*** are temporarily unavailable. Please do not delete them without confirming their permanent expiration.

Before submitting a pull request, please review the **[contributing guidelines](https://github.com/Hunterdii/Awesome-Hacking/blob/main/CONTRIBUTING.md)**. Keep in mind:

```diff
+ This repository is focused on quality over quantity.
```

All **suggestions and pull requests** are welcome!

<!--## About
Hack-Academia is designed to be your go-to repository for learning, exploring, and mastering the art of cybersecurity. Whether you're a beginner or an experienced professional, here you'll find curated resources, guides, tools, and community insights to enhance your skills and knowledge in ethical hacking and security research.
-->
<!--### Financial Contributors-->

<!--<p align="left">
  <a href="https://opencollective.com/the-book-of-secret-knowledge" alt="Financial Contributors on Open Collective">
    <img src="https://img.shields.io/opencollective/backers/the-book-of-secret-knowledge?style=for-the-badge&color=FF4500&labelColor=A9A9A9"></a>
  </a>
  <a href="https://opencollective.com/the-book-of-secret-knowledge" alt="Financial Contributors on Open Collective">
    <img src="https://img.shields.io/opencollective/sponsors/the-book-of-secret-knowledge?style=for-the-badge&color=FF4500&labelColor=A9A9A9"></a>
  </a>
</p>-->


## Table of Contents

- [✨ Features](#-features)
- [📜 Legal Note](#-legal-note)
- [🚀 Get Started](#-get-started)
- [🔒 Cybersecurity Education & Practical Labs](#-cybersecurity-education--practical-labs)
- [📘 Valuable Repositories](#-valuable-repositories)
- [🛠️ Helpful Repositories](#️-helpful-repositories)
- [🔍 Reverse Engineering, Buffer Overflow, and Exploit Development](#-reverse-engineering-buffer-overflow-and-exploit-development)
- [🛡️ Malware Analysis](#️-malware-analysis)
- [🚀 Elevating Privileges](#-elevating-privileges)
- [🕸️ Vulnerable Web Applications](#️-vulnerable-web-applications)
- [🐧 Linux Penetration Testing OS](#-linux-penetration-testing-os)
- [📺 YouTube Channels](#-youtube-channels)
     - [🎤 Conferences](#-conferences)
     - [🏢 Companies](#-companies)
     - [📰 Cybersecurity News](#-cybersecurity-news)
- [🌐 Online Communities](#-online-communities)
- [📝 Blogs](#-blogs)
- [💻 Hacking and Security Forums](#-hacking-and-security-forums)
- [📡 Network Scanning / Reconnaissance](#-network-scanning--reconnaissance)
- [🌟 Credit To All Below](#-credit-to-all-below)


## ✨ Features

- **Beginner's Guides:** Step-by-step tutorials for newcomers to start their journey into hacking and cybersecurity.
- **Pentesting Resources:** Tools, methodologies, and real-world examples for penetration testers.
- **Security Research:** Latest trends, research papers, and insights from the cybersecurity field.
- **Code Snippets:** Useful scripts and snippets for various hacking tasks.
- **Toolkits:** Collections of essential tools and software for ethical hacking.
- **Community Contributions:** Insights and contributions from experienced hackers and security researchers.

## 📜 Legal Note

All activities and discussions in this repository are conducted with the highest ethical standards and within legal boundaries.

## 🚀 Get Started

Explore our curated resources, enhance your skills, and join a community of passionate cybersecurity enthusiasts. Happy hacking!

## 🔒 Cybersecurity Education & Practical Labs
<div align="center">

| Name | Description |
| ---- | ----------- |
[Academy Virtual Cyber Labs](https://academy.virtualcyberlabs.com/) | Virtual labs offering interactive cybersecurity exercises and simulations for hands-on learning.
[arcX](https://arcx.io/) | Platform providing practical cybersecurity challenges and labs to develop skills in offensive and defensive techniques.
[Attack Defense](https://attackdefense.com/) | Provides over 1000 labs for practicing offensive and defensive cybersecurity skills.
[Backdoor](https://backdoor.sdslabs.co) | Pen testing labs featuring a space for beginners, a practice arena, and various competitions.
[CS 642: Intro to Computer Security](http://pages.cs.wisc.edu/~ace/cs642-spring-2016.html) | Comprehensive academic content, spanning a full semester. Includes assigned readings, homework, and GitHub references for exploit examples.
[CyberSec WTF](https://cybersecurity.wtf) | Web hacking challenges derived from bounty write-ups.
[Cybrary](https://www.cybrary.it/) | Coursera-style website with a plethora of user-contributed content. Requires an account. Content can be filtered by experience level.
[Ctftime](https://ctftime.org/) | The go-to website for all things related to CTFs.
[The cryptopals crypto challenges](http://cryptopals.com/) | A series of CTF challenges focused on cryptography.
[Challenge Land](http://challengeland.co/) | A CTF site with a unique twist where solving a challenge is required to gain access.
[Crackmes.de Archive (2011-2015)](https://tuts4you.com/download.php?view.3152) | A repository focusing on reverse engineering challenges.
[Crackmes.one](https://crackmes.one/) | Provides crackmes to enhance reverse engineering skills.
[CTFLearn](https://ctflearn.com/) | An account-based CTF site offering challenges across various categories.
[CTFs write-ups](https://github.com/ctfs) | A collection of write-ups from various CTFs, categorized by event.
[CTF365](https://ctf365.com/) | An account-based CTF platform recognized by institutions like Kaspersky, MIT, and T-Mobile.
[Dvwa](http://www.dvwa.co.uk/) | Damn Vulnerable Web Application is another intentionally insecure web application for practicing hacking skills.
[Defend the Web](https://defendtheweb.net/) | An interactive security platform where you can learn and challenge your skills.
[Exploit exercises](https://exploit-exercises.com/) | Hosts five vulnerable virtual machines for practical exploitation practice.
[Free Cyber Security Training](https://www.samsclass.info/) | Academic content, featuring 8 full courses with videos by a quirky instructor named Sam. Links to research, DEFCON materials, and other recommended training/learning resources.
[Google CTF](https://github.com/google/google-ctf) | Provides source code from Google's CTF contests.
[Google CTF 2019](https://capturetheflag.withgoogle.com/) | Google's 2019 CTF edition.
[Google's XSS game](https://xss-game.appspot.com/) | Offers XSS challenges with potential rewards.
[Hak5](https://www.hak5.org/) | Podcast-style videos covering a variety of topics. Includes a forum and the "Metasploit Minute" video series.
[Hopper's Roppers Security Training](https://hoppersroppers.org/training.html) | Four free self-paced courses on Computing Fundamentals, Security, Capture the Flags, and a Practical Skills Bootcamp to help beginners build a strong foundational knowledge base.
[Hackthissite](https://www.hackthissite.org/) | A site offering challenges, CTFs, and more to improve your hacking abilities.
[HackTheBox](https://www.hackthebox.eu/) | An online platform to test and advance your penetration testing and cybersecurity skills.
[Hacker test](http://www.hackertest.net/) | A beginner-friendly site for testing hacking skills.
[Hacker Gateway](https://www.hackergateway.com/) | Hosts CTFS covering steganography, cryptography, and web challenges.
[Hacksplaining](https://www.hacksplaining.com/) | An interactive security education platform suitable for beginners.
[Hacking Articles](http://www.hackingarticles.in/ctf-challenges1/) | Offers CTF write-ups with screenshots for beginners.
[Hacker101 CTF](https://ctf.hacker101.com/) | A CTF hosted by HackerOne, always online.
[Hacking Lab](https://www.hacking-lab.com/index.html) | A European platform hosting riddles, challenges, and competitions.
[hackburger.ee](http://hackburger.ee/) | Hosts web hacking challenges with an account requirement.
[Hack.me](https://hack.me/) | Allows users to build, host, and attack vulnerable web apps.
[Hack this site!](https://www.hackthissite.org/) | A site where users progress through hacking challenges.
[Itsecgames](http://www.itsecgames.com/) | bWAPP or buggy web app is a deliberately insecure web application for practicing your skills.
[knock.xss.moe](https://knock.xss.moe) | Offers XSS challenges requiring an account.
[Learning Exploitation with Offensive Computer Security 2.0](http://howto.hackallthethings.com/2016/07/learning-exploitation-with-offensive.html) | Blog-style instruction including slides, videos, homework, and discussion. No login required.
[Lin.security](https://in.security/lin-security-practise-your-linux-privilege-escalation-foo/) | Focuses on Linux privilege escalation practice.
[knock.xss.moe](https://knock.xss.moe) | Offers XSS challenges requiring an account.
[Mind Maps](http://www.amanhardikar.com/mindmaps.html) | Information Security-related mind maps.
[MIT OCW 6.858 Computer Systems Security](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-858-computer-systems-security-fall-2014/) | Academic content, well-organized full-semester course. Includes assigned readings, lectures, videos, and required lab files.
[noe.systems](http://noe.systems/) | A Korean challenge site requiring an account.
[Offensive Computer Security](https://www.cs.fsu.edu/~redwood/OffensiveComputerSecurity/lectures.html) | Full-semester academic course including 27 lecture videos with slides and assigned readings.
[OWASP Top 10 Web Security Risks](https://www.owasp.org/index.php/Category:OWASP_Top_Ten_Project) | Free courseware focusing on the top web security vulnerabilities and mitigation techniques.
[Overthewire](http://overthewire.org/wargames/) | Learn and practice security concepts through engaging games.
[PicoCTF](https://picoctf.org/) | Offers fun CTF challenges of varying difficulty levels for practice.
[PortSwigger](https://portswigger.net/web-security/all-labs) | Interactive labs covering a broad spectrum of web security topics designed for practical learning.
[Penetration Testing Practice Lab / Vulnerable Apps/Systems](https://www.amanhardikar.com/mindmaps/Practice.html) | Compilation of resources and labs to practice penetration testing skills on vulnerable applications and systems.
[Participating Challenge Sites](http://www.wechall.net/active_sites/all/by/site_avg/DESC/page-1) | A universal ranking for CTF participants.
[PentesterLab](https://pentesterlab.com/) | Hosts exercises and bootcamps focused on specific activities.
[Pentestit](https://lab.pentestit.ru/) | An account-based CTF site requiring users to install OpenVPN.
[Pentest Practice](https://www.pentestpractice.com/) | Offers account-based Pentest practice.
[Pentest.training](https://pentest.training) | Provides various labs and VMs for hacking practice.
[PicoCTF](https://2017game.picoctf.com/) | Hosts a yearly CTF event by Carnegie Mellon.
[pwnable.kr](http://pwnable.kr/) | A serious CTF site focusing on exploitation challenges.
[pwnable.tw](http://pwnable.tw/) | Hosts challenges with write-ups.
[Root-me](https://www.root-me.org/) | Platform hosting a variety of challenges to test and develop hacking skills across different domains.
[Ringzer0 Team](https://ringzer0team.com/challenges) | An account-based CTF site hosting over 272 challenges.
[ROP Emporium](https://ropemporium.com/) | Focuses on Return Oriented Programming challenges.
[Seed Labs](http://www.cis.syr.edu/~wedu/seed/labs.html) | Structured labs with videos, tasks, and necessary resources for hands-on learning of cybersecurity concepts.
[SmashTheStack](http://smashthestack.org/wargames.html) | Hosts various challenges requiring SSH access.
[Shellter Labs](https://shellterlabs.com/en/) | Provides account-based infosec labs.
[SecurityTube](http://www.securitytube.net/) | Video tutorials and "Megaprimer" series covering diverse cybersecurity topics and tools in a visual format.
[Solve Me](http://solveme.safflower.kr/) | A challenge-based platform requiring an account.
[The enigma group](https://www.enigmagroup.org/) | Offers web application security training with video tutorials.
[TryHackMe](https://tryhackme.com/) | Online platform offering interactive labs and challenges, including prebuilt virtual machines for practical cybersecurity training.
[Upload-Labs](https://github.com/c0ny1/upload-labs) | Repository providing labs focusing on various types of file upload vulnerabilities for practical cybersecurity training.
[Vulnhub](https://www.vulnhub.com/) | Provides a collection of virtual machines with varying levels of difficulty for practicing penetration testing skills.
[VulHub](https://vulhub.org/) | Repository of vulnerable environments and labs for practicing penetration testing and cybersecurity techniques.
[Vulapps](https://vulapps.evalbug.com/) | Vulnerable web applications designed for practicing penetration testing and cybersecurity skills.
[websec.fr](https://websec.fr/) | Focuses on web security challenges with optional registration.
[webhacking.kr](https://webhacking.kr) | Offers web security challenges for beginners.
[Windows / Linux Local Privilege Escalation Workshop](https://github.com/sagishahar/lpeworkshop) | Focuses on Linux and Windows privilege escalation practice.
[0day.today](http://0day.today/) | A user-friendly exploit database that is simple to navigate.
[CXsecurity](https://cxsecurity.com/exploit/) | Independent cybersecurity information site, operated by a single person.
[Snyk Vulnerability DB](https://snyk.io/vuln/) | Offers detailed information and remediation advice for known vulnerabilities, along with code testing capabilities.
</div>


## 📘 Valuable Repositories
<div align="center">

| Repository | Description |
| ---------- | ----------- |
[Android Security](https://github.com/ashishb/android-security-awesome) | Curated resources for understanding Android security.
[AppSec](https://github.com/paragonie/awesome-appsec) | Resources to learn about securing applications.
[Asset Discovery](https://github.com/redhuntlabs/Awesome-Asset-Discovery) | Tools and resources for asset discovery in security assessments.
[Bug Bounty](https://github.com/djadmin/awesome-bug-bounty) | List of bug bounty programs and write-ups.
[Capsulecorp Pentest](https://github.com/r3dy/capsulecorp-pentest) | Vagrant+Ansible lab for network penetration testing.
[Cellular Hacking](https://github.com/W00t3k/Awesome-Cellular-Hacking) | Research in 3G/4G/5G cellular security.
[CTF](https://github.com/apsdehal/awesome-ctf) | Frameworks, libraries, and resources for Capture The Flag competitions.
[Cyber Skills](https://github.com/joe-shenouda/awesome-cyber-skills) | Environments to legally train and enhance cyber skills.
[DevSecOps](https://github.com/devsecops/awesome-devsecops) | Tools for integrating security into DevOps practices.
[Embedded and IoT Security](https://github.com/fkie-cad/awesome-embedded-and-iot-security) | Resources for securing embedded systems and IoT devices.
[Exploit Development](https://github.com/FabioBaroni/awesome-exploit-development) | Learning resources for developing exploits.
[Fuzzing](https://github.com/secfigo/Awesome-Fuzzing) | Techniques and tools for fuzzing and exploit development.
[Hacking](https://github.com/carpedm20/awesome-hacking) | Tutorials, tools, and resources for hacking.
[Hacking Resources](https://github.com/vitalysim/Awesome-Hacking-Resources) | Collection of resources for penetration testing.
[Honeypots](https://github.com/paralax/awesome-honeypots) | Tools and resources for deploying honeypots.
[Incident Response](https://github.com/meirwah/awesome-incident-response) | Tools for handling incident response.
[Industrial Control System Security](https://github.com/hslatman/awesome-industrial-control-system-security) | Security resources for industrial control systems (ICS).
[InfoSec](https://github.com/onlurking/awesome-infosec) | Courses and training resources for information security.
[IoT Hacks](https://github.com/nebgnahz/awesome-iot-hacks) | Exploits and hacks in the IoT space.
[Mainframe Hacking](https://github.com/samanL33T/Awesome-Mainframe-Hacking) | Resources for mainframe hacking and pentesting.
[Malware Analysis](https://github.com/rshipp/awesome-malware-analysis) | Tools and resources for analyzing malware.
[OSINT](https://github.com/jivoi/awesome-osint) | Tools and resources for Open Source Intelligence (OSINT).
[OSX and iOS Security](https://github.com/ashishb/osx-and-ios-security-awesome) | Security tools and resources for macOS and iOS.
[Pcaptools](https://github.com/caesar0301/awesome-pcaptools) | Tools for processing network traces in Computer Science.
[Pentest](https://github.com/enaqx/awesome-pentest) | Resources and tools for penetration testing.
[PHP Security](https://github.com/ziadoz/awesome-php#security) | Libraries and tools for PHP security.
[Real-time Communications hacking & pentesting resources](https://github.com/EnableSecurity/awesome-rtc-hacking) | Security resources for VoIP, WebRTC, and VoLTE.
[Red Teaming](https://github.com/yeyintminthuhtut/Awesome-Red-Teaming) | Resources for Red Team operations and resources.
[Reversing](https://github.com/fdivrp/awesome-reversing) | Tools and resources for reverse engineering.
[Reinforcement Learning for Cyber Security](https://github.com/Limmen/awesome-rl-for-cybersecurity) | Machine learning resources applied to cyber security.
[Sec Talks](https://github.com/PaulSec/awesome-sec-talks) | Collection of awesome security talks.
[SecLists](https://github.com/danielmiessler/SecLists) | Collection of lists for security assessments.
[Security](https://github.com/sbilly/awesome-security) | Software, libraries, and resources for security.
[Serverless Security](https://github.com/puresec/awesome-serverless-security/) | Resources for securing serverless architectures.
[Social Engineering](https://github.com/v2-dev/awesome-social-engineering) | Resources and techniques for social engineering.
[Static Analysis](https://github.com/mre/awesome-static-analysis) | Tools for static analysis and code quality checking.
[The Art of Hacking Series](https://github.com/The-Art-of-Hacking/h4cker) | Thousands of references and resources for cybersecurity.
[Threat Intelligence](https://github.com/hslatman/awesome-threat-intelligence) | Resources for threat intelligence gathering.
[Vehicle Security](https://github.com/jaredthecoder/awesome-vehicle-security) | Resources for learning about vehicle security and car hacking.
[Vulnerability Research](https://github.com/re-pronin/awesome-vulnerability-research) | Resources and tools for vulnerability research.
[Web Hacking](https://github.com/infoslack/awesome-web-hacking) | Resources for web application security.
[Web3 Security](https://github.com/Anugrahsr/Awesome-web3-Security) | Materials and resources for Web3 security.
[Windows Exploitation - Advanced](https://github.com/yeyintminthuhtut/Awesome-Advanced-Windows-Exploitation-References) | Advanced references for Windows exploitation.
[WiFi Arsenal](https://github.com/0x90/wifi-arsenal) | Tools for hacking 802.11 networks.
[YARA](https://github.com/InQuest/awesome-yara) | Rules, tools, and resources for YARA.
</div>

## 🛠️ Helpful Repositories
<div align="center">
 
| Repository | Description |
| ---------- | ----------- |
[Adversarial Machine Learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning) | Resources for understanding adversarial machine learning.
[AI Security](https://github.com/RandomAdversary/Awesome-AI-Security) | Resources for securing AI applications.
[API Security Checklist](https://github.com/shieldfy/API-Security-Checklist) | Checklist for securing APIs during development and testing.
[APT Notes](https://github.com/kbandla/APTnotes) | Public documents about APT campaigns.
[Bug Bounty Reference](https://github.com/ngalongc/bug-bounty-reference) | Write-ups categorized by bug type from bug bounty programs.
[Cryptography](https://github.com/sobolevn/awesome-cryptography) | Tools and resources for cryptography.
[CTF Tool](https://github.com/SandySekharan/CTF-tool) | Frameworks and tools for Capture The Flag competitions.
[CVE PoC](https://github.com/qazbnm456/awesome-cve-poc) | Proof of Concepts (PoCs) for CVEs.
[CVE PoC updated daily](https://github.com/trickest/cve) | Daily updated Proof of Concepts (PoCs) for CVEs.
[Detection Lab](https://github.com/clong/DetectionLab) | Scripts to build a lab environment with security tooling.
[Forensics](https://github.com/Cugu/awesome-forensics) | Tools and resources for digital forensics.
[Free Programming Books](https://github.com/EbookFoundation/free-programming-books) | Collection of free programming books.
[Gray Hacker Resources](https://github.com/bt3gl/Gray-Hacker-Resources) | Resources for CTFs, wargames, and pentesting.
[GTFOBins](https://gtfobins.github.io) | List of Unix binaries exploitable for bypassing local security.
[Hacker101](https://github.com/Hacker0x01/hacker101) | Free web security class by HackerOne.
[Infosec Getting Started](https://github.com/gradiuscypher/infosec_getting_started) | Resources and documentation to start learning Infosec.
[Infosec Reference](https://github.com/rmusser01/Infosec_Reference) | Comprehensive reference for Information Security.
[IOC](https://github.com/sroberts/awesome-iocs) | Sources for indicators of compromise (IOCs).
[Linux Kernel Exploitation](https://github.com/xairy/linux-kernel-exploitation) | Links related to Linux kernel fuzzing and exploitation.
[Lockpicking](https://github.com/meitar/awesome-lockpicking) | Resources for lock, safe, and key security.
[Machine Learning for Cyber Security](https://github.com/jivoi/awesome-ml-for-cybersecurity) | Machine learning tools for cyber security.
[Payloads](https://github.com/foospidy/payloads) | Collection of web attack payloads.
[PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings) | Payloads and bypass techniques for Web Application Security.
[Pentest Cheatsheets](https://github.com/coreb1t/awesome-pentest-cheat-sheets) | Cheatsheets useful for penetration testing.
[Pentest Wiki](https://github.com/nixawk/pentest-wiki) 								| A free online security knowledge library for pentesters / researchers
[Probable Wordlists](https://github.com/berzerk0/Probable-Wordlists) | Wordlists sorted by probability for password generation and testing.
[Resource List](https://github.com/FuzzySecurity/Resource-List) | Collection of useful GitHub projects categorized.
[Reverse Engineering](https://github.com/onethawt/reverseengineering-reading-list) | Articles, books, and papers on reverse engineering.
[RFSec-ToolKit](https://github.com/cn0xroot/RFSec-ToolKit) | Hacktools for Radio Frequency Communication Protocols.
[Security Cheatsheets](https://github.com/andrewjkerr/security-cheatsheets) | Cheatsheets for various infosec tools and topics.
[Security List](https://github.com/zbetcheckin/Security_list) | Comprehensive security list for learning and practical use.
[Shell](https://github.com/alebcay/awesome-shell) | Frameworks and tools for shell scripting and management.
[ThreatHunter-Playbook](https://github.com/Cyb3rWard0g/ThreatHunter-Playbook) | Playbook for developing techniques and hypotheses for threat hunting.
[Web Security](https://github.com/qazbnm456/awesome-web-security) | Materials and resources for understanding and practicing web security.
</div>

## 🔍 Reverse Engineering, Buffer Overflow, and Exploit Development 
<div align="center">

| Name | Description |
| ---- | ----------- |
[A Course on Intermediate Level Linux Exploitation](https://github.com/nnamon/linux-exploitation-course) | 🌟 An advanced course for those with some experience in Linux exploitation.
[Analysis and Exploitation (Unprivileged)](https://www.it-sec-catalog.info/analysis_and_exploitation_unprivileged.html) | 📚 A vast collection of reverse engineering information, organized by type.
[Binary Hacking](http://liveoverflow.com/binary_hacking/index.html) | 🎥 35 straightforward videos on binary hacking and other useful info.
[Buffer Overflow Exploitation Megaprimer for Linux](http://www.securitytube.net/groups?operation=view&groupId=4) | 📺 A series of videos on Linux reverse engineering.
[Corelan Tutorials](https://www.corelan.be/index.php/2009/07/19/exploit-writing-tutorial-part-1-stack-based-overflows/) | 📝 Detailed tutorials on memory exploitation and reverse engineering.
[Exploit Tutorials](http://www.primalsecurity.net/tutorials/exploit-tutorials/) | 🎓 A set of nine exploit tutorials, including a podcast.
[Exploit Development](https://0x00sec.org/c/exploit-development) | 🗣️ Links to exploit development posts on a forum, varying in quality and style.
[flAWS Challenge](http://flaws.cloud/) | ☁️ Learn about common mistakes and security pitfalls in Amazon Web Services (AWS) through a series of levels.
[Introduction to ARM Assembly Basics](https://azeria-labs.com/writing-arm-assembly-part-1/) | 📘 Comprehensive tutorials on ARM assembly by an infosec professional.
[Introductory Intel x86](http://www.opensecuritytraining.info/IntroX86.html) | 💻 Extensive course materials on Intel x86, with no account required.
[Lena's Reversing for Newbies (Complete)](https://tuts4you.com/download.php?view.2876) | 📖 A complete resource by Lena aimed at beginners in reverse engineering.
[Linux (x86) Exploit Development Series](https://sploitfun.wordpress.com/2015/06/26/linux-x86-exploit-development-tutorial-series/) | 🖥️ Blog posts with three different levels of Linux exploit development tutorials.
[Megabeets Journey into Radare2](https://www.megabeets.net/a-journey-into-radare-2-part-1/) | 🔍 Tutorials on using Radare2 for reverse engineering.
[Modern Binary Exploitation - CSCI 4968](https://github.com/RPISEC/MBE) | 🎓 Reverse engineering challenges and downloadable VMs from RPISEC.
[Recon.cx - Reversing Conference](https://recon.cx/) | 🎤 Conference site with recordings and slides of all talks on reverse engineering.
[Reverse Engineering for Beginners](https://beginners.re/RE4B-EN.pdf) | 📚 A comprehensive textbook on reverse engineering, open-source and free.
[Reverse Engineering Reading List](https://github.com/onethawt/reverseengineering-reading-list/blob/master/README.md) | 📖 A collection of reverse engineering tools and books on GitHub.
[Reverse Engineering Challenges](https://challenges.re/) | 🧩 Challenges created by the author of "Reverse Engineering for Beginners".
[Reverse Engineering for Beginners (GitHub Project)](https://github.com/dennis714/RE-for-beginners) | 💻 GitHub repository for the "Reverse Engineering for Beginners" textbook.
[Reverse Engineering Malware 101](https://malwareunicorn.org/workshops/re101.html) | 🦄 An introductory course on malware reverse engineering with materials and VMs.
[Reverse Engineering Malware 102](https://malwareunicorn.org/workshops/re102.html) | 🦄 The follow-up course to "Reverse Engineering Malware 101".
[Reversing.kr Challenges](http://www.reversing.kr/challenge.php) | 🧠 Reverse engineering challenges of varying difficulty.
[Shell Storm](http://shell-storm.org/) | 🌐 A blog-style collection of reverse engineering information.
[Shellcode Injection](https://dhavalkapil.com/blogs/Shellcode-Injection/) | 💡 A blog post by a graduate student on shellcode injection.
[Micro Corruption — Assembly](https://microcorruption.com) | 🛠️ A CTF designed to learn Assembly by solving practical challenges.
</div>

## 🛡️ Malware Analysis
<div align="center">
 
| Name | Description |
| ---- | ----------- |
[Analyze Malware Using Volatility](https://www.volatilityfoundation.org/) | A framework for analyzing volatile memory for malware artifacts and indicators
[Bad Binaries](https://www.badbinaries.com/) | Walkthroughs of malware traffic analysis exercises and occasional malware analysis
[Honeynet Project](https://www.honeynet.org/) | A project providing data and tools for analyzing malware captured by honeypots
[Malware Traffic Analysis](http://www.malware-traffic-analysis.net/) | Exercises and resources for analyzing malware traffic
[Malware Unicorn - Workshops](https://malwareunicorn.org/#/workshops/) | Workshops on malware analysis and reverse engineering, including resources and VMs
[Malware Analysis For Hedgehogs](https://zeltser.com/learn-malware-analysis/) | A learning path and resources for beginners and advanced users in malware analysis
[Malware Analysis Tutorials](https://www.malwaretech.com/2020/04/malware-analysis-tutorials.html) | Step-by-step tutorials on malware analysis by MalwareTech
[Malware Analysis - CSCI 4976](https://github.com/RPISEC/Malware/blob/master/README.md) | Quality content from an RPISEC class on malware analysis
[Practical Malware Analysis & Triage](https://github.com/strider-sec/practical-malware-analysis-and-triage) | A practical guide to malware analysis and triage with hands-on labs and examples
[REMnux](https://remnux.org/) | A Linux toolkit for reverse-engineering and analyzing malware
[Zero2Automated](https://www.zero2automated.com/) | A comprehensive course on automated malware analysis and sandboxing
</div>

## 🚀 Elevating Privileges
<div align="center">

| Name | Description |
| ---- | ----------- |
[4 Ways to Get Linux Privilege Escalation](http://www.hackingarticles.in/4-ways-get-linux-privilege-escalation/) | Shows different methods to gain higher access in Linux systems.
[A Guide to Linux Privilege Escalation](https://payatu.com/guide-linux-privilege-escalation/) | Basics of escalating privileges on Linux systems.
[Abusing SUDO (Linux Privilege Escalation)](http://touhidshaikh.com/blog/?p=790) | Techniques to exploit SUDO in Linux for privilege escalation.
[AutoLocalPrivilegeEscalation](https://github.com/ngalongc/AutoLocalPrivilegeEscalation) | Automated scripts that download and compile exploits from Exploit-DB.
[Basic Linux Privilege Escalation](https://blog.g0tmi1k.com/2011/08/basic-linux-privilege-escalation/) | Basic techniques for escalating privileges in Linux, also includes Windows tips.
[Common Windows Privilege Escalation Vectors](https://www.toshellandback.com/2015/11/24/ms-priv-esc/) | Common methods to escalate privileges in Windows.
[Editing /etc/passwd File for Privilege Escalation](http://www.hackingarticles.in/editing-etc-passwd-file-for-privilege-escalation/) | How to manipulate the /etc/passwd file to gain higher access in Linux.
[GTFOBins](https://gtfobins.github.io/) | A curated list of Unix binaries that can be used to bypass local security restrictions in misconfigured systems.
[Linux Privilege Escalation](https://securityweekly.com/2017/12/17/linux-privilege-escalation-tradecraft-security-weekly-22/) | Video on techniques for privilege escalation in Linux.
[Linux Privilege Escalation Check Script](https://github.com/sleventyeleven/linuxprivchecker) | A simple script to check for privilege escalation vulnerabilities in Linux.
[Linux Privilege Escalation Scripts](http://netsec.ws/?p=309#more-309) | A list of scripts for checking privilege escalation vulnerabilities in Linux.
[Linux Privilege Escalation Using PATH Variable](http://www.hackingarticles.in/linux-privilege-escalation-using-path-variable/) | How to exploit misconfigured PATH variables for privilege escalation in Linux.
[Linux Privilege Escalation using Misconfigured NFS](http://www.hackingarticles.in/linux-privilege-escalation-using-misconfigured-nfs/) | How to exploit misconfigured NFS for privilege escalation in Linux.
[Linux Privilege Escalation via Dynamically Linked Shared Object Library](https://www.contextis.com/blog/linux-privilege-escalation-via-dynamically-linked-shared-object-library) | Exploiting RPATH and weak file permissions for privilege escalation in Linux.
[Local Linux Enumeration & Privilege Escalation Cheatsheet](https://www.rebootuser.com/?p=1623) | A cheatsheet of resources and scripts for privilege escalation in Linux.
[Linux Exploit Suggester](https://github.com/mzet-/linux-exploit-suggester) | A tool to identify possible exploits for a given Linux system.
[LinEnum](https://github.com/rebootuser/LinEnum) | A script for enumerating Linux systems for privilege escalation vulnerabilities.
[Linux Smart Enumeration](https://github.com/diego-treitos/linux-smart-enumeration) | A script for detailed enumeration of Linux systems, highlighting privilege escalation vectors.
[OSCP - Windows Privilege Escalation](http://hackingandsecurity.blogspot.com/2017/09/oscp-windows-privilege-escalation.html) | Common methods for escalating privileges in Windows for OSCP.
[Privilege Escalation for Windows and Linux](https://github.com/AusJock/Privilege-Escalation) | Various exploits for privilege escalation in Windows and Linux.
[Privilege Escalation in Linux with Live Example](http://resources.infosecinstitute.com/privilege-escalation-linux-live-examples/) | Examples of common privilege escalation methods in Linux.
[Reach the Root](https://hackmag.com/security/reach-the-root/) | A detailed process for privilege escalation in Linux.
[RootHelper](https://github.com/NullArray/RootHelper) | A tool that runs various scripts to check for privilege escalation vulnerabilities.
[Unix Privilege Escalation Checker](http://pentestmonkey.net/tools/audit/unix-privesc-check) | A script to check for privilege escalation vulnerabilities in Unix systems.
[Windows Exploits, Mostly Precompiled](https://github.com/abatchy17/WindowsExploits) | Precompiled Windows exploits, useful for reverse engineering.
[Windows Privilege Escalation](http://www.bhafsec.com/wiki/index.php/Windows_Privilege_Escalation) | A collection of resources and techniques for escalating privileges in Windows.
[Windows Privilege Escalation](https://memorycorruption.org/windows/2018/07/29/Notes-On-Windows-Privilege-Escalation.html) | Notes and techniques for privilege escalation in Windows.
[Windows Privilege Escalation Checker](https://github.com/netbiosX/Checklists/blob/master/Windows-Privilege-Escalation.md) | A list of topics linking to relevant resources on Windows privilege escalation.
[Windows Privilege Escalation Fundamentals](http://www.fuzzysecurity.com/tutorials/16.html) | Tutorials and guides on privilege escalation in Windows, created by an OSCP.
[Windows Privilege Escalation Guide](https://www.sploitspren.com/2018-01-26-Windows-Privilege-Escalation-Guide/) | A comprehensive guide on Windows privilege escalation.
[Windows Privilege Escalation Methods for Pentesters](https://pentest.blog/windows-privilege-escalation-methods-for-pentesters/) | A detailed blog post on various methods for privilege escalation in Windows.
[Windows Privilege Escalation Awesome Scripts](https://github.com/PowerShellMafia/PowerSploit/tree/master/Privesc) | A collection of PowerShell scripts to assist with privilege escalation in Windows.
[Windows Exploit Suggester](https://github.com/AonCyberLabs/Windows-Exploit-Suggester) | A tool to identify possible exploits for a given Windows system.
[Watson](https://github.com/rasta-mouse/Watson) | A tool to enumerate missing KBs and suggest exploits for privilege escalation in Windows.
</div>

## 🕸️ Vulnerable Web Applications
<div align="center">

| Name | Description |
| ---- | ----------- |
[AltoroMutual](https://github.com/vulnerableapplications/AltoroMutual) | A simulated banking website to practice finding and exploiting security vulnerabilities
[BadStore](http://www.badstore.net/) | A vulnerable web application designed for security training
[bWAPP](http://www.itsecgames.com/) | A common buggy web app for hacking, great for beginners with lots of documentation
[Cyber Range](https://github.com/CyberRange/CyberRange) | A collection of various vulnerable applications for practicing different types of attacks
[Damn Small Vulnerable Web (DSVW)](https://github.com/stamparm/DSVW) | A web app written in less than 100 lines of code, full of vulnerabilities, ideal for teaching
[Damn Vulnerable Web Application (DVWA)](http://www.dvwa.co.uk/) | A PHP/MySQL web app for testing skills and tools
[Defend the Web](https://defendtheweb.net/) | A series of web security challenges to test and improve your skills
[Google Gruyere](https://google-gruyere.appspot.com/) | Host of challenges on this cheesy web app
[Hacme Bank](https://github.com/vulnerables/web-hacmebank) | A deliberately vulnerable web application to practice security skills
[Hackazon](https://github.com/rapid7/hackazon) | A vulnerable web application modeled after an e-commerce site
[HackMe Banking](http://hackmebank.org/) | A web application designed to demonstrate common web vulnerabilities in an online banking context
[Juice Shop](https://bkimminich.gitbooks.io/pwning-owasp-juice-shop/content/) | An intentionally insecure web application for security training
[Metasploitable 2](https://sourceforge.net/projects/metasploitable/files/Metasploitable2/) | A vulnerable virtual machine used for testing Metasploit and other tools
[NodeGoat](https://github.com/OWASP/NodeGoat) | An OWASP project for learning Node.js security by trying to exploit vulnerabilities
[OWASP Broken Web Applications Project](https://github.com/chuckfw/owaspbwa/) | Collection of broken web apps for learning
[OWASP Hackademic Challenges project](https://github.com/Hackademic/hackademic/) | Web hacking challenges for practice
[OWASP Mutillidae II](https://sourceforge.net/projects/mutillidae/files/) | Another OWASP vulnerable app with lots of documentation
[OWASP Juice Shop](https://github.com/bkimminich/juice-shop) | Covers the OWASP top 10 vulnerabilities
[PentesterLab](https://pentesterlab.com/exercises/) | Provides vulnerable systems to practice penetration testing techniques
[SecApps Playground](https://playground.secapps.com/) | A playground to learn and practice web application security concepts
[Security Shepherd](https://github.com/OWASP/SecurityShepherd) | An OWASP project designed to foster and improve security awareness
[SQLol](http://www.rawsec.ml/sqlol/) | A vulnerable web app for learning SQL injection attacks
[VulnHub](https://www.vulnhub.com/) | Hosts vulnerable web applications for practicing penetration testing and security assessments
[WebGoat](https://github.com/WebGoat/WebGoat) | A deliberately insecure web app maintained by OWASP for teaching web app security
[WebForPentester](https://github.com/RealityNet/Web-For-Pentester) | A vulnerable web application designed for testing and learning pentesting techniques
[WackoPicko](https://github.com/adamdoupe/WackoPicko) | A vulnerable web application to test security tools and demonstrate common web vulnerabilities
[XSS Game](https://xss-game.appspot.com/) | A game developed by Google to teach cross-site scripting (XSS) vulnerabilities
</div>

## 🐧 Linux Penetration Testing OS
<div align="center">

| Name | Description |
| ---- | ----------- |
[Android Tamer](https://androidtamer.com/) | Virtual/live platform specialized for Android security professionals
[BackBox](https://backbox.org/) | Community-driven Linux distribution geared towards securing IT environments
[BlackArch](https://blackarch.org/) | Arch Linux-based penetration testing distribution, designed for compatibility with Arch installations
[Bugtraq](http://bugtraq-team.com/) | Advanced GNU/Linux distribution for penetration testing and security auditing
[Docker for Pentest](https://github.com/aaaguirrep/pentest) | Docker image preloaded with essential tools for creating a pentesting environment quickly
[Kali Linux](https://www.kali.org/) | Industry-leading Linux distribution for penetration testing and ethical hacking, developed by Offensive Security
[LionSec Linux](https://lionsec-linux.org/) | Ubuntu-based operating system tailored for penetration testing and security assessments
[Parrot Security OS](https://www.parrotsec.org/) | Debian-based OS featuring a complete portable lab for security testing, digital forensics, and development
[Pentoo](https://www.pentoo.ch/) | Gentoo-based Linux distribution focused on penetration testing and security auditing
</div>

## 📺 YouTube Channels
<div align="center">

| Name | Description |
| ---- | ----------- |
[IppSec Channel - Hack The Box Writeups](https://www.youtube.com/channel/UCa6eh7gCkpPo5XXUDfygQQA) | Detailed Hack The Box walkthroughs and writeups.
[LiveOverflow - Explore weird machines...](https://www.youtube.com/channel/UClcE-kVhqyiHCcjYwcpfj9w) | Exploring weird machines and hacking concepts.
[GynvaelEN - Podcasts about CTFs, computer security, programming and similar things.](https://www.youtube.com/channel/UCCkVMojdBWS-JtH7TliWkVg) | Podcasts on CTFs, computer security, and programming.
[John Hammond - Wargames and CTF writeups](https://www.youtube.com/channel/UCVeW9qkBjo3zosnqUbG7CFw) | CTF writeups and wargame walkthroughs.
[Murmus CTF - Weekly live streamings](https://www.youtube.com/channel/UCUB9vOGEUpw7IKJRoR4PK-A) | Weekly live streams focusing on CTFs.
[PwnFunction](https://www.youtube.com/channel/UCW6MNdOsqv2E9AjQkv9we7A) | Videos on exploitation and security concepts.
[OJ Reeves](https://www.youtube.com/channel/UCz2aqRQWMhJ4wcJq3XneqRg) | Tutorials and insights on cybersecurity topics.
[Hacksplained - A Beginner Friendly Guide to Hacking](https://www.youtube.com/c/hacksplained) | Beginner-friendly hacking guides and tutorials.
[STÖK](https://www.youtube.com/c/STOKfredrik) | Bug bounty hunting and cybersecurity content.
[Hackersploit](https://www.youtube.com/channel/UC0ZTPkdxlAKf-V33tqXwi3Q) | Penetration testing tutorials and cybersecurity content.
[The Cyber Mentor](https://www.youtube.com/channel/UC0ArlFuFYMpEewyRBzdLHiw) | Cybersecurity tutorials and ethical hacking courses.
[Nahamsec](https://www.youtube.com/c/Nahamsec) | Bug bounty tips, tricks, and live hacking streams.
[Hackerone](https://www.youtube.com/channel/UCsgzmECky2Q9lQMWzDwMhYw) | Bug bounty programs and cybersecurity insights.
[The Hated one](https://www.youtube.com/channel/UCjr2bPAyPV7t35MvcgT3W8Q) | Privacy, cybersecurity, and hacking-related content.
[stacksmashing / Ghidra Ninja](https://www.youtube.com/channel/UC3S8vxwRfqLBdIhgRlDRVzw) | Hardware hacking and reverse engineering.
[Hak5](https://www.youtube.com/channel/UC3s0BtrBJpwNDaflRSoiieQ) | DIY hacking and cybersecurity tutorials.
[0patch by ACROS Security](https://www.youtube.com/channel/UCwlGrzF4on-bjiBhD8lO3QA) | A few short, specific videos focused on the 0patch platform. 
[BlackHat](https://www.youtube.com/channel/UCJ6q9Ie29ajGqKApbLqfBOg) | Features talks from BlackHat conferences around the world. 
[Christiaan008](https://www.youtube.com/channel/UCEPzS1rYsrkqzSLNp76nrcg) | A variety of videos on various security topics, though somewhat disorganized. 
</div>

## 🎤 Conferences
<div align="center">

| Name | Description |
| ---- | ----------- |
[Hunting for Top Bounties - Nicolas Grégoire](https://www.youtube.com/watch?v=mQjTgDuLsp4) | Tips for hunting top bounties.
[BSidesSF 101 The Tales of a Bug Bounty Hunter - Arne Swinnen](https://www.youtube.com/watch?v=dsekKYNLBbc) | Experiences of a bug bounty hunter.
[Security Fest 2016 The Secret life of a Bug Bounty Hunter - Frans Rosén](https://www.youtube.com/watch?v=KDo68Laayh8) | Inside look at the life of a bug bounty hunter.
[The Conscience of a Hacker](https://www.youtube.com/watch?v=0tEnnvZbYek) | Reflective talk on the mindset of a hacker.
[44contv](https://www.youtube.com/user/44contv) | Information security conference based in London, lengthy instructional videos. 
[MIT OCW 6.858 Computer Systems Security](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science) | Lengthy instructional videos on computer systems security. 
[BruCON Security Conference](https://www.youtube.com/channel/UCqwMU1l90lf9BLersW6eAHw) | Security and hacker conference in Belgium with lengthy instructional videos. 
[BSides Manchester](https://www.youtube.com/channel/UC1mLiimOTqZFK98VwM8Ke4w) | Security and hacker conference in Manchester with lengthy videos. 
[BSidesAugusta](https://www.youtube.com/channel/UC85CvsnrVlD_44eEgzb2OfA) | Security conference in Augusta, Georgia with lengthy instructional videos. 
[CarolinaCon](https://www.youtube.com/channel/UCTY3Dpz68CyrjwRzqkE4sFw) | Security conference in North Carolina, associated with various 2600 chapters, with lengthy instructional content. 
[Cort Johnson](https://www.youtube.com/channel/UCV9r-yMeARWVCJEesim25Ag) | Talks from Hack Secure Opensec 2017. 
[DevSecCon](https://www.youtube.com/channel/UCgxhfP2Hi8MQYz6ZkwpLA0A) | Lengthy videos covering DevSecOps and making software more secure. 
[Garage4Hackers - Information Security](https://www.youtube.com/channel/UCDqagqREZlmJitWco-yPtvw/feed) | A handful of lengthy videos, About section lacks description. 
[HACKADAY](https://www.youtube.com/channel/UCnv0gfLQFNGPJ5MHSGuIAkw) | Lots of random tech content, not strictly infosec, some instructional. 
[Hack In The Box Security Conference](https://www.youtube.com/channel/UC0BJVNTIEbG8CLG-xVVWJnA) | Lengthy con-style instructional talks from an international security conference. 
[Hack in Paris](https://www.youtube.com/channel/UC7xJU9_oqw-vS6OJExS-2iA) | Security conference in Paris featuring lots of instructional talks with difficult-to-see slides. 
[Hacklu](https://www.youtube.com/channel/UCI6B0zYvK-7FdM0Vgh3v3Tg/feed) | Lengthy con-style instructional videos. 
[Hacktivity](https://www.youtube.com/user/hacktivity/feed) | Lengthy con-style instructional videos from a conference in central/eastern Europe. 
[Hardwear.io](https://www.youtube.com/channel/UChwYb9xc9tZXquQxu4G0l_g/featured) | Handful of lengthy con-style videos with an emphasis on hardware hacks. 
[IEEE Symposium on Security and Privacy](https://www.youtube.com/channel/UC6pXMS7qre9GZW7A7FVM90Q) | Content from the symposium, a professional association based in the US, also publishes various journals. 
[LASCON](https://www.youtube.com/channel/UCDHsOiMPS-SLppAOAJRD37Q) | Lengthy con-style talks from an OWASP conference held in Austin, TX. 
[leHACK](https://www.youtube.com/channel/UCSxk_CUfES4ly5Sspc0Vorw) | The oldest (2003) leading security conference in Paris, France. 
[Marcus Niemietz](https://www.youtube.com/channel/UCtThfJl65L04ukWp0XZi3yg/videos) | Instructional content associated with HACKPRA, an offensive security course from a German institute. 
[Media.ccc.de](https://www.youtube.com/channel/UC2TXq_t06Hjdr2g_KdKpHQg) | The official channel of the Chaos Computer Club with tons of lengthy con-style videos. 
[NorthSec](https://www.youtube.com/channel/UCqVhMzTdQK5VAosAGkMtpJw) | Lengthy con-style talks from an applied security conference in Canada. 
[Pancake Nopcode](https://www.youtube.com/channel/UC3G6k7XfTgcWD2PJR8qJSkQ) | Channel of Radare2 whiz Sergi "pancake" Alvarez, featuring reverse engineering content. 
[Psiinon](https://www.youtube.com/channel/UC-3qyzm4f29C12KGp3-12bQ) | Medium-length instructional videos for the OWASP Zed Attack Proxy. 
[SJSU Infosec](https://www.youtube.com/channel/UCDNzNvZlYK8jZLsUbdiGrsQ/videos) | Lengthy instructional videos from San Jose State University's infosec program. 
[Secappdev.org](https://www.youtube.com/channel/UCSii2fuiLLlGqaR6sR_y0rA) | Lengthy instructional lectures on secure application development. 
[Security Fest](https://www.youtube.com/channel/UCByLDp7r7gHGoO7yYMYFeWQ) | Medium-length con-style talks from a security festival in Sweden. 
[SecurityTubeCons](https://www.youtube.com/channel/UC2wNN-Zqiq4J1PLPnyMBWUg) | An assortment of con-style talks from various conferences including BlackHat and Shmoocon. 
[ToorCon](https://www.youtube.com/channel/UCnzjmL0xkTBYwFZD7agHGWw) | Medium-length con videos from a conference based in San Diego, CA. 
[USENIX Enigma Conference](https://www.youtube.com/channel/UCIdV7bE97mSPTH1mOi_yUrw/feed) | Medium-length "round table discussions with leading experts," content starts in 2016. 
[ZeroNights](https://www.youtube.com/channel/UCtQ0fPmP4fCGBkYWMxnjh6A) | Con-style talks from the international ZeroNights conference. 
[Defcon Conference](https://www.youtube.com/user/DEFCONConference/videos) | Talks and presentations from the DEFCON conference.
[x33fcon Conference](https://www.youtube.com/c/x33fcon) | Security conference talks and presentations.
[Hack In Paris](https://www.youtube.com/user/hackinparis) | Talks from the Hack In Paris conference.
[LeHack / HZV](https://www.youtube.com/user/hzvprod) | Presentations from the LeHack conference.
[InfoCon.org](https://infocon.org/cons/) | InfoCon.org is a comprehensive repository hosting data from hundreds of cybersecurity and hacker conferences worldwide. It serves as a valuable resource for accessing conference materials, including talks, presentations, and schedules.
[Irongeek](http://www.irongeek.com/) | Irongeek.com, managed by Adrien Crenshaw, is a rich repository of cybersecurity and hacking resources. It offers a wealth of information, including tutorials, videos, and articles on various topics related to cybersecurity, hacking, and technology.
[infocondb.org](https://infocondb.org/) | InfoConDB.org is dedicated to cataloging and cross-referencing information from hacker conferences globally. It provides a centralized platform for exploring details about past and upcoming conferences, including speakers, topics, and event histories.
</div>

## 🏢 Companies
<div align="center">

| Name | Description |
| ---- | ----------- |
[Detectify](https://www.youtube.com/channel/UCm6N84sAaQ-BiNdCaaLT4qg) | Short videos aimed at showing how to use the Detectify scanner. 
[Kaspersky Lab](https://www.youtube.com/channel/UCGhEv7BFBWdo0k4UXTm2eZg) | Promotional content with some hidden cybersecurity gems.
[Metasploit](https://www.youtube.com/channel/UCx4d2aRIfxfEUdS_5YIYKPg) | Medium-length instructional Metasploit demos (~25 minutes each). 
[ntop](https://www.youtube.com/channel/UCUYWuYlYKD5Yq5qBz0AIXJw/feed) | Network monitoring and packet analysis instructional videos. 
[nVisium](https://www.youtube.com/channel/UCTE8R-Otq_kVTo08eLsfeyg) | Promos and a handful of instructional series on Rails vulnerabilities and web hacking. 
[OpenNSM](https://www.youtube.com/user/OpenNSM/feed) | Network analysis with many TCPDUMP videos. 
[OWASP](https://www.youtube.com/user/OWASPGLOBAL) | See OWASP above. 
[Rapid7](https://www.youtube.com/channel/UCnctXOUIeRFu1BR5O0W5e9w) | Brief promotional and instructional videos (~5 minutes). 
[Securelist](https://www.youtube.com/user/Securelist/featured) | Brief videos and interviews discussing various cybersecurity topics. 
[Segment Security](https://www.youtube.com/channel/UCMCI9TE3-PZ7CgKk7X6Qd_w/featured) | Promo videos, non-instructional. 
[SocialEngineerOrg](https://www.youtube.com/channel/UCC1vbVVbYdNe-OZRldj-U6g) | Podcast-style instructional content, lengthy (~1 hour each). 
[Sonatype](https://www.youtube.com/user/sonatype/featured) | DevOps-related content, varied lengths, somewhat disorganized. 
[SophosLabs](https://www.youtube.com/user/SophosLabs/featured) | Brief, news-style content with segments like "7 Deadly IT Sins." 
[Sourcefire](https://www.youtube.com/user/SourcefireInc/featured) | Brief videos covering topics like botnets and DDoS (~5 minutes each). 
[Station X](https://www.youtube.com/channel/UC-vWmE-BHcUrYW5zwDijL1g) | Brief videos, disorganized, with unscheduled updates. 
[Synack](https://www.youtube.com/channel/UCRH0mvESjZ7eKY1LJZDPIbw/featured) | Random, news-style videos, disorganized and non-instructional. 
[TippingPoint Zero Day Initiative](https://www.youtube.com/channel/UChbH7B5YhXANmlMYJRHpw0g) | Very brief and somewhat instructional videos (~30 seconds). 
[Tripwire, Inc.](https://www.youtube.com/user/TripwireInc/videos) | Tripwire demos and random news-style videos, non-instructional. 
[Vincent Yiu](https://www.youtube.com/channel/UCFVI3_M1zqFzEok2sTeEP8w/featured) | Instructional videos from a single hacker. 
</div>

## 📰 Cybersecurity News
<div align="center">

| Name | Description |
| ---- | ----------- |
[0x41414141](https://www.youtube.com/channel/UCPqes566OZ3G_fjxL6BngRQ) | Channel with a couple of challenges, well explained. 
[Adrian Crenshaw](https://www.youtube.com/user/irongeek) | Lots of lengthy con-style talks. 
[Adrian Crenshaw](https://www.youtube.com/user/irongeek) | lots of lengthy con-style talks
[Corey Nachreiner](https://www.youtube.com/channel/UC7dUL0FbVPGqzdb2HtWw3Xg) | Security news bites, 2-3 videos a week, no set schedule. 
[BalCCon - Balkan Computer Congress](https://www.youtube.com/channel/UCoHypmu8rxlB5Axh5JxFZsA) | Long con-style talks from the Balkan Computer Congress, doesn't update regularly. 
[danooct1](https://www.youtube.com/channel/UCqbkm47qBxDj-P3lI9voIAw) | Brief screenshot how-to videos regarding malware, regular content updates. 
[DedSec](https://www.youtube.com/channel/UCx34ZZW2KgezfUPPeL6m8Dw) | Brief screenshot how-to videos based in Kali, no recent posts. 
[DEFCON Conference](https://www.youtube.com/channel/UC6Om9kAkl32dWlDSNlDS9Iw) | Lengthy con-style videos from the iconic DEFCON. 
[DemmSec](https://www.youtube.com/channel/UCJItQmwUrcW4VdUqWaRUNIg) | Pen testing videos with somewhat irregular uploads. 
[Derek Rook - CTF/Boot2root/wargames Walkthrough](https://www.youtube.com/channel/UCMACXuWd2w6_IEGog744UaA) | Lengthy screenshot instructional videos. 
[Don Does 30](https://www.youtube.com/channel/UCarxjDjSYsIf50Jm73V1D7g) | Amateur pen-tester posting brief screenshot videos regularly. 
[Derek Rook - CTF/Boot2root/wargames Walkthrough](https://www.youtube.com/channel/UCMACXuWd2w6_IEGog744UaA) | lots of lengthy screenshot instructional vids, with
[Error 404 Cyber News](https://www.youtube.com/channel/UC4HcNHFKshqj-aeyi6imW7Q) | Short screenshot videos with loud metal music, no dialogue, bi-weekly updates. 
[Geeks Fort - KIF](https://www.youtube.com/channel/UC09NdTL2hkThGLSab8chJMw) | Brief screenshot videos, no recent posts. 
[GynvaelEN](https://www.youtube.com/channel/UCCkVMojdBWS-JtH7TliWkVg) | Security streams from a Google researcher focused on CTFs, computer security, and programming. 
[HackerSploit](https://www.youtube.com/channel/UC0ZTPkdxlAKf-V33tqXwi3Q) | Regular posts, medium-length screenshot videos with dialogue. 
[HACKING TUTORIALS](https://www.youtube.com/channel/UCbsn2kQwNxcIzHwbdDjzehA) | Brief screenshot videos, no recent posts. 
[iExplo1t](https://www.youtube.com/channel/UCx0HClQ_cv0sLNOVhoO2nxg/videos) | Screenshot videos aimed at novices, no recent posts. 
[IPPSec](https://www.youtube.com/channel/UCa6eh7gCkpPo5XXUDfygQQA) | Hackthebox.eu retired machine walkthroughs to learn basic and advanced techniques.
[InfoSec Magazine](http://www.infosecurity-magazine.com/) | Comprehensive coverage of the latest topics in information security
[JackkTutorials](https://www.youtube.com/channel/UC64x_rKHxY113KMWmprLBPA) | Medium-length instructional videos with some "Ask Me" videos. 
[John Hammond](https://www.youtube.com/user/RootOfTheNull) | Solves CTF problems and provides pen testing tips and tricks. 
[Latest Hacking News](https://www.youtube.com/user/thefieldhouse/feed) | Medium-length screenshot videos, no recent releases. 
[LionSec](https://www.youtube.com/channel/UCCQLBOt_hbGE-b9I696VRow) | Brief screenshot instructional videos with no dialogue. 
[LiveOverflow](https://www.youtube.com/channel/UClcE-kVhqyiHCcjYwcpfj9w) | Brief-to-medium instructional videos on topics like buffer overflows and exploit writing, regular posts. 
[Metasploitation](https://www.youtube.com/channel/UC9Qa_gXarSmObPX3ooIQZrg) | Screenshot videos focused on using Metasploit, no recent updates. 
[NetSecNow](https://www.youtube.com/channel/UC6J_GnSAi7F2hY4RmnMcWJw) | Channel of pentesteruniversity.org, posts once a month, screenshot instructional videos. 
[Open SecurityTraining](https://www.youtube.com/channel/UCthV50MozQIfawL9a_g5rdg) | Lengthy lecture-style videos, no recent posts, but quality information. 
[Pentester Academy TV](https://www.youtube.com/channel/UChjC1q6Ami7W0E71TzPZELA) | Brief videos with very regular posting, up to 8+ a week. 
[rwbnetsec](https://www.youtube.com/channel/UCAJ8Clc3188ek9T_5XTVzZQ) | Medium-length instructional videos covering tools from Kali 2.0, no recent posts. 
[Recent Hash Leaks](https://hashes.org/public.php) | Valuable resource for looking up leaked hashes and related information
[Samy Kamkar's Applied Hacking](https://www.youtube.com/user/s4myk) | Brief to medium-length instructional videos from the creator of PoisonTap for the Raspberry Pi Zero, no recent content. 
[SecureNinjaTV](https://www.youtube.com/channel/UCNxfV4yR0nIlhFmfwcdf3BQ) | Brief news bites, irregular posting. 
[Security Weekly](https://www.youtube.com/channel/UCg--XBjJ50a9tUhTKXVPiqg) | Regular updates with lengthy podcast-style interviews with industry professionals. 
[Seytonic](https://www.youtube.com/channel/UCW6xlqxSY3gGur4PkGPEUeA) | DIY hacking tutorials, hardware hacks, regular updates. 
[Shozab Haxor](https://www.youtube.com/channel/UCBwub2kRoercWQJ2mw82h3A) | Screenshot-style instructional videos, regular updates, Windows CLI tutorials. 
[SSTec Tutorials](https://www.youtube.com/channel/UCHvUTfxL_9bNQgqzekPWHtg) | Brief screenshot videos, regular updates. 
[Security Intelligence](https://securityintelligence.com/news/) | Offers in-depth coverage of cybersecurity news and intelligence resources.
[Secjuice](https://secjuice.com/) | Diverse cybersecurity community offering articles, podcasts, and more on security topics.
[Tradecraft Security Weekly](https://wiki.securityweekly.com/Tradecraft_Security_Weekly) | Learn about all the latest security tools and techniques. 
[Troy Hunt](https://www.youtube.com/channel/UCD6MWz4A61JaeGrvyoYl-rQ) | Medium-length news videos from a lone YouTuber, regular content. 
[Threatpost](https://threatpost.com/) | Provides timely updates on the latest threats, vulnerabilities, and breaches in cybersecurity.
[The Hacker News](https://thehackernews.com/) | Daily updates on hacking news, cybersecurity incidents, and vulnerabilities; also available as a mobile app
[The Daily Swig](https://portswigger.net/daily-swig) | Latest cybersecurity news from PortSwigger. 
[Tradecraft Security Weekly](https://wiki.securityweekly.com/Tradecraft_Security_Weekly) | Want to learn about all of the latest security tools and techniques?
[Waleed Jutt](https://www.youtube.com/channel/UCeN7cOELsyMHrzfMsJUgv3Q) | Brief screenshot videos covering web security and game programming. 
[webpwnized](https://www.youtube.com/channel/UCPeJcqbi8v46Adk59plaaXg) | Brief screenshot videos, some CTF walkthroughs. 
[Zer0Mem0ry](https://www.youtube.com/channel/UCDk155eaoariJF2Dn2j5WKA) | Brief C++ security videos, programming intensive. 
</div>

 ## 🕵️‍♂️ Hacking Google Series
 <div align="center">

| Name | Description |
| ---- | ----------- |
[HACKING GOOGLE Series](https://www.youtube.com/watch?v=aOGFY1R4QQ4) | A comprehensive series on Google’s security measures.
[EP000: Operation Aurora HACKING GOOGLE](https://youtu.be/przDcQe6n5o) | Overview of Operation Aurora.
[EP001: Threat Analysis Group HACKING GOOGLE](https://youtu.be/N7N4EC20-cM) | Insights from Google’s Threat Analysis Group.
[EP002: Detection and Response HACKING GOOGLE](https://youtu.be/QZ0cpBocl3c) | Google’s detection and response strategies.
[EP003: Red Team HACKING GOOGLE](https://youtu.be/TusQWn2TQxQ) | The role and activities of Google’s Red Team.
[EP004: Bug Hunters HACKING GOOGLE](https://youtu.be/IoXiXlCNoXg) | Google’s bug bounty hunters and their experiences.
[EP005: Project Zero HACKING GOOGLE](https://youtu.be/My_13FXODdU) | Insights into Google’s Project Zero team.
</div> 


## 🌐 Online Communities
 <div align="center">

| Name | Description |
| ---- | ----------- |
[Hacktoday](https://www.hacktoday.net/) | Community platform discussing various hacking topics, requires registration
[Hack+ Telegram Channel](http://t.me/hacking_group_channel) | Telegram channel dedicated to discussions on hacking and cybersecurity
[MPGH](http://mpgh.net) | MultiPlayerGameHacking forum community for gaming-related hacks and cheats
[Stack Overflow Security](https://stackoverflow.com/questions/tagged/security) | Stack Overflow's dedicated tag for security-related questions and discussions
[Reddit /r/hacking](https://www.reddit.com/r/hacking/) | Subreddit focused on hacking discussions, news, and resources
[HackerOne Community](https://community.hackerone.com/) | Community forum for HackerOne platform users and security enthusiasts
[Exploit Database Forum](https://www.exploit-db.com/) | Forum associated with the Exploit Database, discussing vulnerabilities and exploits
[Cybrary Community](https://www.cybrary.it/) | Cybersecurity learning platform with an active community forum for discussions and support
[Null Byte](https://null-byte.wonderhowto.com/) | Community-focused on ethical hacking and cybersecurity tutorials, articles, and discussions
</div>

## 📝 Blogs
<div align="center">

| Blog URL                                      | Description                                                                                   |
|-----------------------------------------------|-----------------------------------------------------------------------------------------------|
| [ScriptKidd1e](https://scriptkidd1e.wordpress.com/oscp-journey/) | Follow the OSCP journey and experiences shared by ScriptKidd1e.                               |
| [Security Sift](http://www.securitysift.com/offsec-pwb-oscp/) | Insights and tips on Offensive Security's courses and the OSCP certification by Security Sift. |
| [Ch3rn0byl](http://ch3rn0byl.com/down-with-oscp-yea-you-know-me/) | Detailed OSCP experiences and challenges shared by Ch3rn0byl.                                  |
| [TechExams](http://www.techexams.net/forums/security-certifications/110760-oscp-jollyfrogs-tale.html) | A personal journey and reflections on the OSCP certification by JollyFrog.                     |
| [Hacking and Security](http://hackingandsecurity.blogspot.com) | Blog covering various topics related to hacking and cybersecurity.                             |
| [Carnal0wnage](http://carnal0wnage.blogspot.com/) | Insights into security research and exploits by Carnal0wnage.                                   |
| [McGrew Security](http://www.mcgrewsecurity.com/) | Security blog focusing on penetration testing and research.                                     |
| [Gnucitizen](http://www.gnucitizen.org/blog/) | Blog covering cybersecurity, privacy, and hacking topics from a critical perspective.           |
| [Darknet](http://www.darknet.org.uk/) | Articles and tools related to hacking, security, and cryptography.                              |
| [Spylogic](http://spylogic.net/) | Insights into penetration testing and cybersecurity from Spylogic.                              |
| [Taosecurity](http://taosecurity.blogspot.com/) | Thoughts and research from a cybersecurity perspective by TaoSecurity.                          |
| [Room362](http://www.room362.com/) | Blog focusing on cybersecurity, hacking, and digital forensics.                                 |
| [Sipvicious](http://blog.sipvicious.org/) | Articles and tools related to VoIP security and hacking.                                        |
| [PortSwigger](http://blog.portswigger.net/) | Insights and updates from PortSwigger, the creators of Burp Suite.                              |
| [Pentest Monkey](http://pentestmonkey.net/blog/) | Tips and techniques for penetration testing and cybersecurity.                                   |
| [Jeremiah Grossman](http://jeremiahgrossman.blogspot.com/) | Thoughts on web security, hacking, and technology by Jeremiah Grossman.                         |
| [i8jesus](http://i8jesus.com/) | Blog focusing on cybersecurity, penetration testing, and hacking techniques.                    |
| [C22](http://blog.c22.cc/) | Research and insights into cybersecurity and penetration testing by C22.                        |
| [SkullSecurity](http://www.skullsecurity.org/blog/) | Blog featuring tools, research, and insights into security topics.                               |
| [Metasploit](http://blog.metasploit.com/) | Updates and articles from the Metasploit project team.                                           |
| [Darkoperator](http://www.darkoperator.com/) | Tips, tricks, and tutorials on penetration testing and security by Darkoperator.                 |
| [Skeptikal](http://blog.skeptikal.org/) | Insights and thoughts on cybersecurity and technology from a skeptical viewpoint.                 |
| [PreachSecurity](http://preachsecurity.blogspot.com/) | Blog covering cybersecurity, ethical hacking, and digital forensics.                            |
| [TSSCI Security](http://www.tssci-security.com/) | Articles and tools related to cybersecurity and digital forensics.                               |
| [GDS Security](http://www.gdssecurity.com/l/b/) | Research and insights into cybersecurity and penetration testing by GDS Security.                |
| [WebSec](http://websec.wordpress.com/) | Blog focusing on web security, vulnerabilities, and hacking techniques.                          |
| [Bernardo Damele](http://bernardodamele.blogspot.com/) | Thoughts and research on cybersecurity and web application security.                             |
| [Laramies](http://laramies.blogspot.com/) | Blog featuring tools and techniques related to cybersecurity and penetration testing.             |
| [Spylogic (again)](http://www.spylogic.net/) | Insights into penetration testing and cybersecurity from Spylogic.                               |
| [Andlabs](http://blog.andlabs.org/) | Research and insights into cybersecurity and mobile security by Andlabs.                         |
| [XS-Sniper](http://xs-sniper.com/blog/) | Blog covering cybersecurity, penetration testing, and tools.                                      |
| [Common Exploits](http://www.commonexploits.com/) | Insights into cybersecurity and penetration testing from Common Exploits.                         |
| [Sensepost](http://www.sensepost.com/blog/) | Blog featuring research and insights from Sensepost, covering cybersecurity topics.               |
| [WepMa](http://wepma.blogspot.com/) | Blog focusing on cybersecurity and ethical hacking.                                               |
| [Exploit.co.il](http://exploit.co.il/) | Articles and tools related to cybersecurity and exploits.                                          |
| [Security Reliks](http://securityreliks.wordpress.com/) | Articles and insights into cybersecurity and penetration testing.                                 |
| [Mad Irish](http://www.madirish.net/index.html) | Thoughts and insights on cybersecurity and hacking from Mad Irish.                                 |
| [Sir Dark Cat](http://sirdarckcat.blogspot.com/) | Blog covering cybersecurity, hacking, and technology from Sir Dark Cat.                           |
| [Reusable Security](http://reusablesec.blogspot.com/) | Insights and research on cybersecurity and digital security topics.                                |
| [Myne-us](http://myne-us.blogspot.com/) | Blog focusing on cybersecurity, hacking, and digital forensics.                                   |
| [NotSoSecure](http://www.notsosecure.com/) | Articles and insights into cybersecurity and penetration testing from NotSoSecure.                |
| [SpiderLabs](http://blog.spiderlabs.com/) | Updates and insights from SpiderLabs, focusing on cybersecurity and digital forensics.            |
| [Corelan](http://www.corelan.be/) | Blog featuring tutorials and tools related to exploit development and cybersecurity.              |
| [Digininja](http://www.digininja.org/) | Research and insights into cybersecurity and penetration testing by Digininja.                    |
| [PaulDotCom](http://www.pauldotcom.com/) | Blog covering cybersecurity news, tools, and techniques.                                          |
| [Attack Vector](http://www.attackvector.org/) | Insights and discussions on cybersecurity and hacking from Attack Vector.                          |
| [Deviating](http://deviating.net/) | Articles and insights into cybersecurity and digital forensics.                                   |
| [AlphaOne Labs](http://www.alphaonelabs.com/) | Blog covering cybersecurity, hacking, and technology from AlphaOne Labs.                          |
| [Smashing Passwords](http://www.smashingpasswords.com/) | Tips and techniques related to password security and cracking.                                     |
| [WireWatcher](http://wirewatcher.wordpress.com/) | Blog focusing on cybersecurity and network monitoring.                                             |
| [Gynvael Coldwind](http://gynvael.coldwind.pl/) | Articles and challenges related to cybersecurity and hacking by Gynvael Coldwind.                  |
| [Nullthreat](http://www.nullthreat.net/) | Blog covering cybersecurity and penetration testing topics.                                        |
| [Question Defense](http://www.question-defense.com/) | Insights into cybersecurity, digital forensics, and technology.                                    |
| [ArchangelAmael](http://archangelamael.blogspot.com/) | Blog covering cybersecurity, hacking, and technology by ArchangelAmael.                           |
| [Memset](http://memset.wordpress.com/) | Articles and insights into cybersecurity and digital security topics by Memset.                    |
| [Sickness](http://sickness.tor.hu/) | Blog focusing on cybersecurity and hacking techniques.                                             |
| [Punter-Infosec](http://punter-infosec.com/) | Insights into cybersecurity, ethical hacking, and digital forensics by Punter-Infosec.            |
| [Security Ninja](http://www.securityninja.co.uk/) | Blog covering cybersecurity and ethical hacking topics from Security Ninja.                        |
| [Security and Risk](http://securityandrisk.blogspot.com/) | Insights and discussions on cybersecurity and risk management.                                    |
| [Esploit](http://esploit.blogspot.com/) | Articles and tools related to cybersecurity and hacking.                                           |
| [Pentestit](http://www.pentestit.com/) | Blog focusing on penetration testing and cybersecurity challenges.                                 |
</div>

## 💻 Hacking and Security Forums
<div align="center">

| Name | Description |
| ---- | ----------- |
[sla.ckers.org](http://sla.ckers.org/forum/index.php) | Forum focusing on web application security, including vulnerabilities and exploits.
[Ethical Hacker Network](http://www.ethicalhacker.net/) | Community forum for ethical hackers and cybersecurity professionals to discuss topics and share knowledge.
[BackTrack Linux Forums](http://www.backtrack-linux.org/forums/) | Forums associated with BackTrack Linux, focusing on penetration testing and security tools.
[Elite Hackers](http://www.elitehackers.info/forums/) | Forum discussing various aspects of hacking, security, and technology.
[Hack This Site](http://www.hackthissite.org/forums/index.php) | Forum associated with the Hack This Site community, focusing on hacking challenges and discussions.
[Security Override](http://securityoverride.com/forum/index.php) | Forum for discussions on cybersecurity topics, vulnerabilities, and defense strategies.
[iExploit](http://www.iexploit.org/) | Forum specializing in discussing and sharing exploits and vulnerabilities.
[Bright Shadows](http://bright-shadows.net/) | Community forum for discussions on hacking techniques, security tools, and cybersecurity news.
[Government Security](http://www.governmentsecurity.org/forum/) | Forum focusing on cybersecurity discussions, including government and enterprise security issues.
[intern0t](http://forum.intern0t.net/) | Forum for discussions on hacking, security, and technology.
[0x00sec](https://0x00sec.org/) | Community forum focusing on hacking, malware analysis, computer engineering, and reverse engineering.
[Antichat](https://forum.antichat.ru/) | Russian-based forum discussing various aspects of hacking and cybersecurity.
[CODEBY.NET](https://codeby.net/) | Russian-based forum covering hacking, web application penetration testing (WAPT), malware analysis, computer engineering, reverse engineering, and forensics.
[EAST Exploit Database](http://eastexploits.com/) | Exploit database focusing on commercial exploits written for the EAST Pentest Framework.
[Greysec](https://greysec.net) | Forum dedicated to hacking and cybersecurity discussions, including tutorials and challenges.
[Hackforums](https://hackforums.net/) | Forum for posting about hacks, exploits, and various cybersecurity discussions.
[4Hat Day](http://4hatday.com) | Brazilian-based forum focusing on hacking and cybersecurity topics.
[CaveiraTech](https://caveiratech.com/forum) | Brazilian-based forum covering general hacking and cybersecurity discussions.
</div>


## 📡 Network Scanning / Reconnaissance
<div align="center">

| Name | Description |
| ---- | ----------- |
[Foot Printing with WhoIS/DNS records](https://www.sans.org/reading-room/whitepapers/hackers/fundamentals-computer-hacking-956) | A comprehensive white paper by SANS on using WhoIS and DNS records for footprinting.
[Google Dorks/Google Hacking](https://d4msec.wordpress.com/2015/09/03/google-dorks-for-finding-emails-admin-users-etc/) | A list of powerful Google search commands for hacking, revealing the full potential of the world's largest search engine.
[Nmap](https://nmap.org/book/man.html) | A detailed manual for Nmap, one of the most widely used network scanning tools.
[Recon-ng](https://github.com/lanmaster53/recon-ng) | An open-source reconnaissance framework designed for advanced network reconnaissance.
[Shodan](https://www.shodan.io/) | A search engine for internet-connected devices, providing detailed information about device vulnerabilities.
[Maltego](https://www.maltego.com/) | A comprehensive tool for network and link analysis, visualizing relationships between data points.
[SpiderFoot](https://github.com/smicallef/spiderfoot) | An automated OSINT (Open Source Intelligence) tool for threat intelligence and reconnaissance.
[Metasploit](https://www.metasploit.com/) | A powerful penetration testing tool with modules for scanning, exploiting, and reporting.
[Zenmap](https://nmap.org/zenmap/) | The official GUI for Nmap, making network scanning more user-friendly and accessible.
[theHarvester](https://github.com/laramies/theHarvester) | A tool designed to gather emails, subdomains, hosts, employee names, and more from public sources.
[Netcat](https://nc110.sourceforge.io/) | A versatile networking tool for reading from and writing to network connections using TCP or UDP.
[Amass](https://github.com/OWASP/Amass) | An open-source tool for network mapping of attack surfaces and external asset discovery using passive information gathering and active reconnaissance techniques.
</div>

## 🌟 Credit To All Below
<div align="center">

| Name | Description |
| ---- | ----------- |
[Awesome Hacking](https://github.com/carpedm20/awesome-hacking?tab=readme-ov-file) | A curated list of awesome hacking tools, guides, and resources. 🛠️
[fsociety](https://github.com/Manisso/fsociety) | Comprehensive hacking toolkit including exploits, reconnaissance, and more. 🧰
[Hacking Tool](https://github.com/Z4nzu/hackingtool/tree/master) | Collection of hacking tools for various purposes, from penetration testing to network analysis. 🛡️
[Hacker Roadmap](https://github.com/sundowndev/hacker-roadmap/tree/master) | Roadmap for beginners to learn about different facets of hacking and cybersecurity. 🛣️
[Cheatsheet God](https://github.com/OlivierLaflamme/Cheatsheet-God?tab=readme-ov-file) | Comprehensive cheatsheets for various hacking techniques, including OSCP preparation. 📑
[Movies for Hackers](https://github.com/k4m4/movies-for-hackers) | List of movies every hacker should watch for entertainment and inspiration. 🎥
[Free Security E-Books](https://github.com/Hack-with-Github/Free-Security-eBooks) | A collection of freely available e-books covering diverse topics in cybersecurity. 📚
</div>
