# 🚀 Pull Request Template

## 📋 Description

Please include a summary of the changes and the related issue. Also, provide relevant motivation and context. List any dependencies required for this change.

Fixes # (issue)

## 🔄 Type of change

Please delete options that are not relevant.

- [ ] 🐛 Bug fix (non-breaking change which fixes an issue)
- [ ] ✨ New feature (non-breaking change which adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📚 Documentation update

## ✅ How Has This Been Tested?

Please describe the tests that you ran to verify your changes. Provide instructions so we can reproduce. List any relevant details for your test configuration.

- [ ] 🧪 Test A
- [ ] 🧪 Test B

**Test Configuration**:
* Firmware version:
* Hardware:
* Toolchain:
* SDK:

## 🔍 Checklist:

- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published in downstream modules

## 📸 Screenshots (if applicable)

Please add any screenshots that demonstrate the visual changes made to the code or user interface.

---

<div align="center">
  
[![Join the discussion](https://img.shields.io/badge/Join-Discussion-blue)](https://github.com/Hunterdii/Hack-Academia/discussions)


</div>
<p align="center">
  <img src="https://images.unsplash.com/photo-1519575706483-221027bfbb31?q=80&w=2071&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="Cybersecurity" width="370" />
</p>

Thank you for your contribution to **Hack-Academia**! Your effort helps make our cybersecurity resources better for everyone. 🎉
