from promptgame.gameui.templatetags.gameui import canonical_link


def test_canon_link_no_new_domain(settings) -> None:
    # if there's no NEW_DOMAIN then we don't need a canonical link
    settings.NEW_DOMAIN = None
    result = canonical_link("paper")
    assert result == ""


def test_canon_link_with_new_domain(settings) -> None:
    # if there's a NEW_DOMAIN then we need a canonical link
    settings.NEW_DOMAIN = "https://newdomain.com"
    result = canonical_link("paper")
    assert result == '<link rel="canonical" href="https://newdomain.com/paper/"/>'


def test_canon_link_keywords(settings) -> None:
    # make sure kwargs get forward propagated
    settings.NEW_DOMAIN = "https://newdomain.com"
    result = canonical_link("leaderboard", page=4)
    assert "?page=4" in result
    assert result.startswith('<link rel="canonical" href="https://newdomain.com/')
