import xml.etree.ElementTree as ET

from django.test import Client
from django.urls import reverse


def test_sitemap_xml():
    client = Client()
    response = client.get("/sitemap.xml")
    assert response.status_code == 200
    root = ET.fromstring(response.content)
    namespaces = {"sm": "http://www.sitemaps.org/schemas/sitemap/0.9"}

    # Extract log tags with URLs using xpath
    urls = [loc.text for loc in root.findall(".//sm:loc", namespaces)]

    prefix = "http://testserver"

    # Check if root URL is present
    assert prefix + "/" in urls

    # Check if create_account URL is present (this is the root URL at the time
    # this test was created, but I'm making this a separate assertion in case it
    # moves to some other URL)
    create_account_url = prefix + reverse("create_account")
    assert create_account_url in urls

    # Check if leaderboard URL is present
    leaderboard_url = prefix + reverse("leaderboard")
    assert leaderboard_url in urls

    # Check if attack guide URL is present
    attack_guide_url = prefix + reverse("attack_guide")
    assert attack_guide_url in urls
