import pytest
from django.core.management import call_command


@pytest.mark.django_db
def test_no_missing_migrations():
    try:
        # --dry-run: just check for changes, don't make migration files
        # --check: exit with a non-zero status if model changes are missing migrations
        call_command("makemigrations", dry_run=True, check=True)
    except SystemExit as e:
        pytest.fail('You need to make migrations. Run "./manage.py makemigrations"')
