import time

from promptgame.gameui.utils import get_number_tokens


def test_special_tokens():
    result = get_number_tokens("<|endoftext|>", limit=500)
    assert result.num_tokens == 7
    assert result.verification_passed


def test_moon_overload():
    start_time = time.monotonic()
    # long emoji sequences are really slow to parse completely because they only
    # count as one "word" and tiktoken takes quadratic time to process all the
    # bytes
    result = get_number_tokens("🌚" * 100_000, limit=30)
    assert result.num_tokens == 2 * 30
    assert not result.verification_passed
    # this should really only be 2ms, so we assert <50ms to be saf
    assert time.monotonic() - start_time < 0.05
