from http import HTTPStatus

import pytest
from django.test.client import AsyncClient  # type: ignore
from django.urls import reverse

from promptgame.gameui.user_account_tools import async_create_user_and_account
from promptgame.tests.helpers import async_login


@pytest.mark.asyncio
@pytest.mark.django_db
async def test_page_loads(
    async_client: AsyncClient,
) -> None:
    # Create a user and account
    user, _ = await async_create_user_and_account()
    # Turn the user into a superuser
    user.is_superuser = True
    user.is_staff = True
    await user.asave()
    await async_login(user, async_client)
    resp = await async_client.get(
        reverse("promptgame.custom_admin:basic_moderation_stats")
    )
    assert resp.status_code == HTTPStatus.OK
    content = resp.content.decode("utf-8")
    assert "Balance and Usage Stats" in content  # Page loaded!
