import os

from promptgame.settings.base import *  # noqa: F401, F403

# Insecure settings used for unit tests.
# Do not use these in production!

DEBUG = False  # to match prod
use_postgres = os.environ.get("USE_POSTGRES", None) is not None

if use_postgres:
    print("Using postgres")
    DATABASES = {
        "default": {
            "ENGINE": "django.db.backends.postgresql",
            "NAME": "circle_test",
            "USER": "postgres",
            "PASSWORD": "",
            "HOST": "localhost",
            "PORT": "5432",  # default PostgreSQL port
        }
    }
else:
    print("Using sqlite")
    DATABASES = {
        "default": {
            "ENGINE": "django.db.backends.sqlite3",
            "NAME": ":memory:",
        }
    }
# these asserts keep pytype happy
assert isinstance(LOGGING, dict)
assert isinstance(LOGGING["root"], dict)
LOGGING["root"]["level"] = "WARN"
# note that keys in this DB with this prefix will be wiped out before and after
# running test suite
REDIS_KEY_PREFIX = "test-pg"
CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.redis.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/2",
        "KEY_PREFIX": f"{REDIS_KEY_PREFIX}:c",
        "TIMEOUT": 300,
    }
}
# we default to a fake key so that we are forced to mock API access
OPENAI_API_KEY = "fake-key"
ANTHROPIC_API_KEY = "fake-key"
SECRET_KEY = "django-insecure-bns#^hfkjdshkjshfkjfhkjfhskjdfhk"
