from promptgame.settings.base import *  # noqa: F401, F403

# These settings are used to run a local copy of the service and debug memory
# issues. There are no OpenAI or reCAPTCHA keys, the DB is sqlite, and we use a
# Redis cache backend.

# Example of how to run under memray:
#
# PYTHONMALLOC=malloc \
#   DJANGO_SETTINGS_MODULE=promptgame.settings.docker_perf_test \
#   memray run --native -o name-of-profile.bin "$(which daphne)" \
#      -p 8000 promptgame.promptgame.asgi:application
#
# (PYTHONMALLOC=malloc forces Python to use the system allocator, which memray
# claims leads to more meaningful leak reports.)
#
# You can then use a load tester like ab to hit the service:
#
# ab -n 1000 -c 100 http://localhost:8000/

DEBUG = False  # to match prod
SECRET_KEY = "django-insecure-12837129837192837912"
ALLOWED_HOSTS = ["localhost"]
DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": BASE_DIR / "db.sqlite3",
    }
}
REDIS_KEY_PREFIX = "pgperftest"
CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.redis.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/0",
        "KEY_PREFIX": f"{REDIS_KEY_PREFIX}:c",
        "TIMEOUT": 300,
    }
}
OPENAI_API_KEY = "fake"
ANTHROPIC_API_KEY = "fake-key"
