import os

from promptgame.settings.base import *  # noqa: F401, F403

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "django-insecure-bns#^&g_zta-oy62t6kx=q9$-h%=3948kz^4aabxg814nw5f57"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

# Database
# https://docs.djangoproject.com/en/4.2/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": BASE_DIR / "db.sqlite3",
    }
}

# for django-silk integration
MIDDLEWARE = ["silk.middleware.SilkyMiddleware"] + MIDDLEWARE
INSTALLED_APPS = ["silk"] + INSTALLED_APPS

# for django_browser_reload (via django-tailwind)
MIDDLEWARE = MIDDLEWARE + ["django_browser_reload.middleware.BrowserReloadMiddleware"]
INSTALLED_APPS = INSTALLED_APPS + ["django_browser_reload"]

# Redis setup (cache etc.)
REDIS_KEY_PREFIX = "pg"
CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.redis.RedisCache",
        # database 0 on localhost
        "LOCATION": "redis://127.0.0.1:6379/0",
        "KEY_PREFIX": f"{REDIS_KEY_PREFIX}:c",
        # 300 is the default, but we might want lower b/c our cache will be
        # small
        "TIMEOUT": 300,
    }
}

# Some custom options for this project
OPENAI_API_KEY = os.environ.get("OPENAI_API_KEY", None)
if OPENAI_API_KEY is None:
    try:
        with open(os.path.expanduser("~/.config/openai/key.txt"), "r") as fp:
            OPENAI_API_KEY = fp.read().strip()
            del fp
    except FileNotFoundError as ex:
        raise Exception(
            "OPENAI_API_KEY not set and ~/.config/openai/key.txt not found"
        ) from ex
ANTHROPIC_API_KEY = os.environ.get("ANTHROPIC_API_KEY", None)
if ANTHROPIC_API_KEY is None:
    try:
        with open(os.path.expanduser("~/.config/anthropic/key.txt"), "r") as fp:
            ANTHROPIC_API_KEY = fp.read().strip()
            del fp
    except FileNotFoundError as ex:
        raise Exception(
            "ANTHROPIC_API_KEY not set and ~/.config/anthropic/key.txt not found"
        ) from ex

# This key is for TESTING ONLY, it will break in staging/prod!
RECAPTCHA_SITE_KEY = "6LeL_rgnAAAAABNkR7IAHhgAzy9zIojhH4eC6ske"
