"""Custom types used for settings.py."""

from typing import Tuple, TypedDict


class TierDict(TypedDict):
    title: str
    emoji: str
    range: Tuple[float, float]
    description: str
    neighbors: Tuple[int, int]


class AccountNoun(TypedDict):
    name: str
    emoji: str


class DefenseDict(TypedDict):
    access_code: str
    access_code_output: str
    pre_prompt: str
    post_prompt: str


# for rate limit buckets
class RateLimitBucketConfig(TypedDict):
    bucket_name: str
    refill_rate: float | int
    max_capacity: int
