"""
URL configuration for promptgame project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.contrib import admin
from django.urls import include, path

import promptgame.custom_admin.urls
import promptgame.gameui.urls

urlpatterns = [
    path(
        "private/dj-login/custom-admin-views/",
        include(promptgame.custom_admin.urls, namespace="promptgame.custom_admin"),
    ),
    path("private/dj-login/", admin.site.urls),
    path("", include(promptgame.gameui.urls)),
]
