from urllib.parse import urlparse

from django.conf import settings

from promptgame.gameui.views import get_login_url


def migration_alert(request):
    new_domain = settings.NEW_DOMAIN
    if new_domain and request.user.is_authenticated:
        parsed_new_domain = urlparse(new_domain)
        parsed_request_url = urlparse(request.build_absolute_uri())
        if parsed_new_domain.hostname == parsed_request_url.hostname:
            return {}

        parsed_login_url = urlparse(get_login_url(request))
        migration_url = parsed_login_url._replace(
            netloc=parsed_new_domain.netloc
        ).geturl()

        return {
            "migration_url": migration_url,
        }
    return {}
