from django.conf import settings
from django.conf.urls import include
from django.urls import path

from . import views

urlpatterns = [
    path("", views.create_account, name="create_account"),
    path("robots.txt", views.robots, name="robots"),
    path("sitemap.xml", views.sitemap, name="sitemap"),
    path("login", views.login, name="login"),
    path(
        "leaderboard_v42.wml?topRank=42&fakePoints=999999&dialUpSpeed=48Gbps&mode=1337",
        views.leaderboard,
        name="leaderboard",
    ),
    path("tutorial/<int:step>/", views.tutorial, name="tutorial"),
    path(
        "tutorial/<int:step>/submit.php", views.tutorial_submit, name="tutorial_submit"
    ),
    # trailing slash means that Django redirects /paper to /paper/; with no
    # trailing slash, /paper/ just 404s
    path("paper/", views.paper, name="paper"),
    # this first one is for the account balance & transactions
    path(
        "OVERVIEW_LANDING.GBL;PHPSESSID=UJHXZRQZXGNUSZOJCEEUBYZ;VIEWPORT=-1;SCROLL=0;IS_ADMIN=0;FREE_MONEY=0;TEST_COHORT[1]=168860956789",
        views.overview,
        name="overview",
    ),
    path("authenticate", views.captcha_post, name="captcha_post"),
    path(
        "ajax/notifications",
        views.notifications,
        name="notifications",
    ),
    # set defense prompt and view login attempts
    path(
        "Security page (2011-01-28-v1) draft (final) v0.asp",
        views.security,
        name="security",
    ),
    path(
        "consent_and_terms.cfm",
        views.plain_template_view("consent_and_terms_standalone.html"),
        name="consent_and_terms",
    ),
    path(
        "wiki/Special:Attack_Guide",
        views.plain_template_view("attack_guide.html"),
        name="attack_guide",
    ),
    path(
        "ajax/security_submit",
        views.security_submit,
        name="security_submit",
    ),
    path("phpbb_modified/accounts.php", views.subaccounts, name="subaccounts"),
    # subaccount_view is gated on having the llm output 'Access Granted'
    # (if you haven't guessed it then you can't make a transfer)
    path(
        "phpbb_modified/account_<int:account_id>_login.php",
        views.subaccount_login,
        name="subaccount_login",
    ),
    path(
        "phpbb_modified/account_<int:account_id>_login_submit.php",
        views.subaccount_login_submit,
        name="subaccount_login_submit",
    ),
    path(
        "sandbox.jar",
        views.sandbox,
        name="sandbox",
    ),
    path(
        "sandboxSubmit.jar",
        views.sandbox_submit,
        name="sandbox_submit",
    ),
    path(
        "ajax/unlock_account",
        views.unlock_account,
        name="unlock_account",
    ),
    path("login_with_url/<str:url_id>", views.login_with_url, name="login_with_url"),
    path("create_flag", views.create_flag, name="create_flag"),
    path(
        "ajax/subaccounts_refresh",
        views.subaccounts_refresh,
        name="subaccounts_refresh",
    ),
    path(
        "ajax/check_token_length",
        views.check_token_length,
        name="check_token_length",
    ),
    path(
        "ajax/attack_table",
        views.auth_attempt_table,
        name="auth_attempt_table",
    ),
]

# for django-silk integration
if settings.DEBUG:
    urlpatterns += [path("silk/", include("silk.urls", namespace="silk"))]

# for django_browser_reload (via django-tailwind)
if settings.DEBUG:
    urlpatterns += [path("__reload__/", include("django_browser_reload.urls"))]
