# Generated by Django 4.2.2 on 2023-07-24 22:35

import logging

from django.db import IntegrityError, migrations, models

from promptgame.gameui.user_account_tools import (
    AccountCreationException,
    get_account_name,
)

log = logging.getLogger(__name__)


def set_account_names(apps, schema_editor):
    Account = apps.get_model("gameui", "Account")

    for account in Account.objects.all():
        for _ in range(10):
            try:
                account.account_name = get_account_name()
                account.save()
                break
            except IntegrityError:
                log.warning(
                    "Account ID or account name collision while creating account, will try again"
                )
        else:
            raise AccountCreationException(
                "Failed to create a unique account ID or account name after 10 tries. This is super weird."
            )


class Migration(migrations.Migration):
    dependencies = [
        ("gameui", "0023_alter_account_unlock_at_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="account",
            name="account_name",
            field=models.CharField(unique=True, max_length=64, null=True),
        ),
        migrations.RunPython(set_account_names),
        migrations.AlterField(
            model_name="account",
            name="account_name",
            field=models.CharField(unique=True, max_length=64, null=False),
        ),
    ]
