"""Script for generating a large number of accounts to benchmark DB performance."""

import random

from django.core.management.base import BaseCommand
from django.utils import timezone

from promptgame.gameui.user_account_tools import create_user_and_account

MIN_BALANCE = 0
MAX_BALANCE = 6000


class Command(BaseCommand):
    help = "Populate the accounts table"

    def add_arguments(self, parser):
        parser.add_argument(
            "total", type=int, help="The number of accounts to be created"
        )

    def handle(self, *args, **kwargs):
        total = kwargs["total"]

        for _ in range(total):
            _, account = create_user_and_account()
            account.balance = random.randint(MIN_BALANCE, MAX_BALANCE)
            account.unlock_at = timezone.now()
            account.save()

        self.stdout.write(self.style.SUCCESS(f"{total} accounts created"))
