# Custom admin views for prompt A/D game

This directory is for custom views that extend the Django admin interface.
Although this is technically a Django app, it does not have any models of its
own. Rather, it provides views that give useful information about the main
`gameui` app.

I chose to split this into a separate app because it uses totally
different UI conventions (e.g. no tailwind) and is generally unrelated to
anything that users see (no need for internal consistency). Having a separate
app also makes it easier to have a URL prefix that is consistent with the URLs
for the main Django admin app, since we include all views for this app under a
similar prefix to the rest of the built-in admin interface.

Note that this is _not_ the place to add `ModelAdmin` classes. Those should be
added in the main `gameui` app. This is a little bit ugly and I might revisit it
later to decide whether the convention should be changed.