from django.conf import settings
from django.contrib.staticfiles.storage import ManifestFilesMixin, StaticFilesStorage
from storages.backends.gcloud import GoogleCloudStorage


class LocalManifestFilesMixin(ManifestFilesMixin):
    def __init__(self, *args, **kwargs):
        # Snippet from Django docs that forces the manifest (a JSON file
        # containing hashes) to be baked into the image rather than being stored
        # in the GCloud bucket.
        manifest_storage = StaticFilesStorage(location=settings.BASE_DIR)
        super().__init__(*args, manifest_storage=manifest_storage, **kwargs)


class LocalManifestStaticFilesStorage(LocalManifestFilesMixin, StaticFilesStorage):
    pass


class LocalManifestGoogleCloudFilesStorage(LocalManifestFilesMixin, GoogleCloudStorage):
    pass
